;;; EMAIL-ENCRYPT
;;; -------------

(defun encrypt-headers (headers key )
  (if (endp headers)
      nil
    (let* ((header  (car headers))
	   (field   (car header))
	   (content (cdr header)))
      (cond ((equal 'subject field)
	     (cons (cons field (wrap-list content (list 'encrypted key)))
		   (encrypt-headers (cdr headers) key )))
	     (t (cons header
		      (encrypt-headers (cdr headers) key )))))))

(defun encrypt-body (body key)
  (wrap-list body (list 'encrypted key)))

(defun encrypt-message (msg key nonce)
  (declare (ignore nonce))
  (make-message
     :sender (message-sender msg)
     :recips (message-recips msg)
     :headers (encrypt-headers (message-headers msg) key)
     :body    (encrypt-body    (message-body    msg) key)))

; email-encrypt-init env -> env
; initializes encryption variables
(defun email-encrypt-init  (env)
   (set-var 'e-corrs '() 
   (set-var 'nonce-counter 0 env)))

(defun email-encrypt-command (cmd args env)
  (begin 
   (cw "  [email-encrypt-command:  ~x0]~%" (lookup 'user))
   (cond ((equal 'SET_CORRESPONDENT_KEY cmd)
	  (let ((corr (car args))
		(key  (cadr args)))
	    (if (member-equal corr (lookup 'e-corrs))
		(if (equal '() key)
		    (set-var 'e-corrs
			     (remove-equal corr (lookup 'e-corrs))
			     env)
		  (set-hash-var corr key 'correspondent-key env))
	      (set-var 'e-corrs (cons corr (lookup 'e-corrs)) 
		       (set-hash-var corr key 'correspondent-key env)))))
	 (t env))))

(defun email-encrypt-outgoing (msg env)
  (let ((?recip (recipient msg)))
    (begin 
     (cw "  [email-encrypt-outgoing: ~x0]~%" (lookup 'user))
     (if (member-equal ?recip (lookup 'e-corrs))
	 (let ((key   (lookup  'correspondent-key ?recip))
	       (nonce (lookup 'nonce-counter)))
	   (act mail
		(encrypt-message msg key nonce)
		(set-var  'nonce-counter (1+ nonce) env)))
       (act mail msg env)))))

(defun email-encrypt-incoming (msg env)
  (begin 
   (cw "  [email-encrypt-incoming: ~x0]~%" (lookup 'user))
   (act comment "[Incoming events not handled]")))

(defun body-encrypted? (body)
  (and 
   (listp body)
   (listp (car body))
   (equal (caar body)
          'encrypted)))

(defun encrypted? (msg)
  (and
   (message-p msg)
   (let ((body (message-body msg)))
     (body-encrypted? body))))
