;;; EMAIL-VERIFY
;;; ----------------------

(defun is-signed (body)
  (begin
   (cw "body: ~x0~%" body (and (consp body) (equal (car body) 'signature)))
  (and (consp body)
       (equal (car body) 'signature))))

;;(signature-verified message string) -> boolean
;; verify a signature
(defun signature-verified (msg key)
  (begin
   (cw "    [signature-verified]: ")
   (let ((ret     (get-msg-wrapper msg)))
     (begin
      (if (is-signed ret)
	  (begin
	   (cw "key: ~x0 ~x1~%" key (cadr ret))
	  (if (equal key (cadr ret))
	      (begin (cw "Verified~%") t)
	    (begin (cw "Invalid~%") nil)))
	(begin (cw "Not signed~%" nil)))))))


;;(email-verify-init env) -> env
;; initialize environment
(defun email-verify-init (env)
  (begin
   (cw "  [email-verify-init]~%")
  (set-var 'user '() 
  (set-var 'e-corrs '() env))))

;;(email-verify-command cmd args env) -> env
;;
(defun email-verify-command (cmd args env)
  (begin 
   (cw "  [email-verify-command: ~x0]~%" (lookup 'user))
  (cond ((equal 'SET_USER cmd)
         (let ((?user (caar args)))
            (set-var 'user ?user env)))                ; return
        ((equal 'SET_CORRESPONDENT_KEY cmd)
         (let ((corr (caar args))
               (key  (cadar args)))
           (begin
            (cw "KEY: ~x0 -> ~x1~%" (stringify corr) (stringify key))
           (if (equal '() key)
               (set-var 'e-corrs (remove-equal corr (lookup 'e-corrs)) env)
             (let ((env (set-hash-var corr key 'correspondent-key env)))
	       (begin
		(cw "CORR-KEY: ~x0%~%" (stringify (lookup 'correspondent-key)))
               (set-hash-var corr key 'correspondent-key
                             (set-var 'e-corrs
                                      (los-adjoin corr (lookup 'e-corrs)) env))))))))
        (t env))))

;;(email-verify-outgoing message env) -> action
;;
(defun email-verify-outgoing (msg env)
  (declare ;(xargs :guard (messagep msg))
           (ignore msg))
  (begin
   (cw "  [email-verify-outgoing: ~x0]~%" (lookup 'user))
   (mv nil env)))

;;(email-verify-incoming message env) -> action
;;
(defun email-verify-incoming (msg env)
  (begin
   (cw "  [email-verify-incoming: ~x0]~%" (lookup 'user))
  (let ((?user (lookup 'name))
	(?corr (sender msg)))
    (if (equal ?user '())
	(mv nil (comment "    [User not set yet --> no action]" env))
      (begin
       (cw "corr-->~x0~%" (member-equal ?corr (lookup 'e-corrs)))
       (cw "ecorr-->~x0~%" (lookup 'e-corrs))
       (cw "env-->~x0~%" env)
      (if (member-equal ?corr (lookup 'e-corrs))
	  (let ((?key (get-hash-var ?corr 'correspondent-key env)))
	    (if (signature-verified msg ?key)
		(make-action 'deliver
		     (make-message
		      ?corr
		      (get-var 'recipients  msg)
		      (set-var 'X-Verification-Status 'succeeded
			       (get-var 'headers msg))
		      (get-var 'body-lines msg))
		     (set-var 'deliver-to ?user env))
	      (begin
	       (cw "failed-env-->~x0~%" env)
	       (cw "failed-key-->~x0~%" (get-hash-var ?corr 'correspondent-key env))
	      (make-action 'deliver
		   (make-message
		    ?corr
		    (get-var 'recipients msg)
		    (set-var 'X-Verification-Status 'failed
			     (get-var 'headers msg))
		    (get-var 'body-lines msg))
		   (set-var 'deliver-to ?user env)))))
	(make-action 'deliver
	     (make-message
	      ?corr
	      (get-var 'recipients msg)
	      (set-var 'X-Verification-Status 'unknown
		       (get-var 'headers msg))
	     (get-var 'body-lines msg))
	     (set-var 'deliver-to ?user env))))))))


