// ---------------------------------------------------------------------------
// - Primes.hxx                                                              -
// - standard object library - private prime number definitions              -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful,  but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct,  indirect,  incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2023 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef AFNIX_PRIMES_HXX
#define AFNIX_PRIMES_HXX

namespace afnix {

  // the table of prime number
  static const long CPY_PLONG_BASE[] = {
    37L,        73L,         157L,        307L,       601L,      1201L,
    2417L,      4801L,       9001L,       19001L,     37003L,    70001L,
    130003L,    270001L,     570001L,     1000003L,   2000003L,  4000037L,
    8000017L,   20000003L,   40000003L,   81000001L,  160000003L,330000001L, 
    600000001L, 1000000007L, 2000000011L, 402500003L, 429454979L
  };

  // the number of long prime numbers
  static const long CPY_PLONG_SIZE = sizeof(CPY_PLONG_BASE) / sizeof(long);

  // the first 2048 prime numbers
  static const long CPY_PRIME_BASE[] = {
    2L,     3L,     5L,     7L,     11L,    13L,    17L,    19L, 
    23L,    29L,    31L,    37L,    41L,    43L,    47L,    53L, 
    59L,    61L,    67L,    71L,    73L,    79L,    83L,    89L, 
    97L,    101L,   103L,   107L,   109L,   113L,   127L,   131L, 
    137L,   139L,   149L,   151L,   157L,   163L,   167L,   173L, 
    179L,   181L,   191L,   193L,   197L,   199L,   211L,   223L, 
    227L,   229L,   233L,   239L,   241L,   251L,   257L,   263L, 
    269L,   271L,   277L,   281L,   283L,   293L,   307L,   311L, 
    313L,   317L,   331L,   337L,   347L,   349L,   353L,   359L, 
    367L,   373L,   379L,   383L,   389L,   397L,   401L,   409L, 
    419L,   421L,   431L,   433L,   439L,   443L,   449L,   457L, 
    461L,   463L,   467L,   479L,   487L,   491L,   499L,   503L, 
    509L,   521L,   523L,   541L,   547L,   557L,   563L,   569L, 
    571L,   577L,   587L,   593L,   599L,   601L,   607L,   613L, 
    617L,   619L,   631L,   641L,   643L,   647L,   653L,   659L, 
    661L,   673L,   677L,   683L,   691L,   701L,   709L,   719L, 
    727L,   733L,   739L,   743L,   751L,   757L,   761L,   769L, 
    773L,   787L,   797L,   809L,   811L,   821L,   823L,   827L, 
    829L,   839L,   853L,   857L,   859L,   863L,   877L,   881L, 
    883L,   887L,   907L,   911L,   919L,   929L,   937L,   941L, 
    947L,   953L,   967L,   971L,   977L,   983L,   991L,   997L, 
    1009L,  1013L,  1019L,  1021L,  1031L,  1033L,  1039L,  1049L, 
    1051L,  1061L,  1063L,  1069L,  1087L,  1091L,  1093L,  1097L, 
    1103L,  1109L,  1117L,  1123L,  1129L,  1151L,  1153L,  1163L, 
    1171L,  1181L,  1187L,  1193L,  1201L,  1213L,  1217L,  1223L, 
    1229L,  1231L,  1237L,  1249L,  1259L,  1277L,  1279L,  1283L, 
    1289L,  1291L,  1297L,  1301L,  1303L,  1307L,  1319L,  1321L, 
    1327L,  1361L,  1367L,  1373L,  1381L,  1399L,  1409L,  1423L, 
    1427L,  1429L,  1433L,  1439L,  1447L,  1451L,  1453L,  1459L, 
    1471L,  1481L,  1483L,  1487L,  1489L,  1493L,  1499L,  1511L, 
    1523L,  1531L,  1543L,  1549L,  1553L,  1559L,  1567L,  1571L, 
    1579L,  1583L,  1597L,  1601L,  1607L,  1609L,  1613L,  1619L, 
    1621L,  1627L,  1637L,  1657L,  1663L,  1667L,  1669L,  1693L, 
    1697L,  1699L,  1709L,  1721L,  1723L,  1733L,  1741L,  1747L, 
    1753L,  1759L,  1777L,  1783L,  1787L,  1789L,  1801L,  1811L, 
    1823L,  1831L,  1847L,  1861L,  1867L,  1871L,  1873L,  1877L, 
    1879L,  1889L,  1901L,  1907L,  1913L,  1931L,  1933L,  1949L, 
    1951L,  1973L,  1979L,  1987L,  1993L,  1997L,  1999L,  2003L, 
    2011L,  2017L,  2027L,  2029L,  2039L,  2053L,  2063L,  2069L, 
    2081L,  2083L,  2087L,  2089L,  2099L,  2111L,  2113L,  2129L, 
    2131L,  2137L,  2141L,  2143L,  2153L,  2161L,  2179L,  2203L, 
    2207L,  2213L,  2221L,  2237L,  2239L,  2243L,  2251L,  2267L, 
    2269L,  2273L,  2281L,  2287L,  2293L,  2297L,  2309L,  2311L, 
    2333L,  2339L,  2341L,  2347L,  2351L,  2357L,  2371L,  2377L, 
    2381L,  2383L,  2389L,  2393L,  2399L,  2411L,  2417L,  2423L, 
    2437L,  2441L,  2447L,  2459L,  2467L,  2473L,  2477L,  2503L, 
    2521L,  2531L,  2539L,  2543L,  2549L,  2551L,  2557L,  2579L, 
    2591L,  2593L,  2609L,  2617L,  2621L,  2633L,  2647L,  2657L, 
    2659L,  2663L,  2671L,  2677L,  2683L,  2687L,  2689L,  2693L, 
    2699L,  2707L,  2711L,  2713L,  2719L,  2729L,  2731L,  2741L, 
    2749L,  2753L,  2767L,  2777L,  2789L,  2791L,  2797L,  2801L, 
    2803L,  2819L,  2833L,  2837L,  2843L,  2851L,  2857L,  2861L, 
    2879L,  2887L,  2897L,  2903L,  2909L,  2917L,  2927L,  2939L, 
    2953L,  2957L,  2963L,  2969L,  2971L,  2999L,  3001L,  3011L, 
    3019L,  3023L,  3037L,  3041L,  3049L,  3061L,  3067L,  3079L, 
    3083L,  3089L,  3109L,  3119L,  3121L,  3137L,  3163L,  3167L, 
    3169L,  3181L,  3187L,  3191L,  3203L,  3209L,  3217L,  3221L, 
    3229L,  3251L,  3253L,  3257L,  3259L,  3271L,  3299L,  3301L, 
    3307L,  3313L,  3319L,  3323L,  3329L,  3331L,  3343L,  3347L, 
    3359L,  3361L,  3371L,  3373L,  3389L,  3391L,  3407L,  3413L, 
    3433L,  3449L,  3457L,  3461L,  3463L,  3467L,  3469L,  3491L, 
    3499L,  3511L,  3517L,  3527L,  3529L,  3533L,  3539L,  3541L, 
    3547L,  3557L,  3559L,  3571L,  3581L,  3583L,  3593L,  3607L, 
    3613L,  3617L,  3623L,  3631L,  3637L,  3643L,  3659L,  3671L, 
    3673L,  3677L,  3691L,  3697L,  3701L,  3709L,  3719L,  3727L, 
    3733L,  3739L,  3761L,  3767L,  3769L,  3779L,  3793L,  3797L, 
    3803L,  3821L,  3823L,  3833L,  3847L,  3851L,  3853L,  3863L, 
    3877L,  3881L,  3889L,  3907L,  3911L,  3917L,  3919L,  3923L, 
    3929L,  3931L,  3943L,  3947L,  3967L,  3989L,  4001L,  4003L, 
    4007L,  4013L,  4019L,  4021L,  4027L,  4049L,  4051L,  4057L, 
    4073L,  4079L,  4091L,  4093L,  4099L,  4111L,  4127L,  4129L, 
    4133L,  4139L,  4153L,  4157L,  4159L,  4177L,  4201L,  4211L, 
    4217L,  4219L,  4229L,  4231L,  4241L,  4243L,  4253L,  4259L, 
    4261L,  4271L,  4273L,  4283L,  4289L,  4297L,  4327L,  4337L, 
    4339L,  4349L,  4357L,  4363L,  4373L,  4391L,  4397L,  4409L, 
    4421L,  4423L,  4441L,  4447L,  4451L,  4457L,  4463L,  4481L, 
    4483L,  4493L,  4507L,  4513L,  4517L,  4519L,  4523L,  4547L, 
    4549L,  4561L,  4567L,  4583L,  4591L,  4597L,  4603L,  4621L, 
    4637L,  4639L,  4643L,  4649L,  4651L,  4657L,  4663L,  4673L, 
    4679L,  4691L,  4703L,  4721L,  4723L,  4729L,  4733L,  4751L, 
    4759L,  4783L,  4787L,  4789L,  4793L,  4799L,  4801L,  4813L, 
    4817L,  4831L,  4861L,  4871L,  4877L,  4889L,  4903L,  4909L, 
    4919L,  4931L,  4933L,  4937L,  4943L,  4951L,  4957L,  4967L, 
    4969L,  4973L,  4987L,  4993L,  4999L,  5003L,  5009L,  5011L, 
    5021L,  5023L,  5039L,  5051L,  5059L,  5077L,  5081L,  5087L, 
    5099L,  5101L,  5107L,  5113L,  5119L,  5147L,  5153L,  5167L, 
    5171L,  5179L,  5189L,  5197L,  5209L,  5227L,  5231L,  5233L, 
    5237L,  5261L,  5273L,  5279L,  5281L,  5297L,  5303L,  5309L, 
    5323L,  5333L,  5347L,  5351L,  5381L,  5387L,  5393L,  5399L, 
    5407L,  5413L,  5417L,  5419L,  5431L,  5437L,  5441L,  5443L, 
    5449L,  5471L,  5477L,  5479L,  5483L,  5501L,  5503L,  5507L, 
    5519L,  5521L,  5527L,  5531L,  5557L,  5563L,  5569L,  5573L, 
    5581L,  5591L,  5623L,  5639L,  5641L,  5647L,  5651L,  5653L, 
    5657L,  5659L,  5669L,  5683L,  5689L,  5693L,  5701L,  5711L, 
    5717L,  5737L,  5741L,  5743L,  5749L,  5779L,  5783L,  5791L, 
    5801L,  5807L,  5813L,  5821L,  5827L,  5839L,  5843L,  5849L, 
    5851L,  5857L,  5861L,  5867L,  5869L,  5879L,  5881L,  5897L, 
    5903L,  5923L,  5927L,  5939L,  5953L,  5981L,  5987L,  6007L, 
    6011L,  6029L,  6037L,  6043L,  6047L,  6053L,  6067L,  6073L, 
    6079L,  6089L,  6091L,  6101L,  6113L,  6121L,  6131L,  6133L, 
    6143L,  6151L,  6163L,  6173L,  6197L,  6199L,  6203L,  6211L, 
    6217L,  6221L,  6229L,  6247L,  6257L,  6263L,  6269L,  6271L, 
    6277L,  6287L,  6299L,  6301L,  6311L,  6317L,  6323L,  6329L, 
    6337L,  6343L,  6353L,  6359L,  6361L,  6367L,  6373L,  6379L, 
    6389L,  6397L,  6421L,  6427L,  6449L,  6451L,  6469L,  6473L, 
    6481L,  6491L,  6521L,  6529L,  6547L,  6551L,  6553L,  6563L, 
    6569L,  6571L,  6577L,  6581L,  6599L,  6607L,  6619L,  6637L, 
    6653L,  6659L,  6661L,  6673L,  6679L,  6689L,  6691L,  6701L, 
    6703L,  6709L,  6719L,  6733L,  6737L,  6761L,  6763L,  6779L, 
    6781L,  6791L,  6793L,  6803L,  6823L,  6827L,  6829L,  6833L, 
    6841L,  6857L,  6863L,  6869L,  6871L,  6883L,  6899L,  6907L, 
    6911L,  6917L,  6947L,  6949L,  6959L,  6961L,  6967L,  6971L, 
    6977L,  6983L,  6991L,  6997L,  7001L,  7013L,  7019L,  7027L, 
    7039L,  7043L,  7057L,  7069L,  7079L,  7103L,  7109L,  7121L, 
    7127L,  7129L,  7151L,  7159L,  7177L,  7187L,  7193L,  7207L, 
    7211L,  7213L,  7219L,  7229L,  7237L,  7243L,  7247L,  7253L, 
    7283L,  7297L,  7307L,  7309L,  7321L,  7331L,  7333L,  7349L, 
    7351L,  7369L,  7393L,  7411L,  7417L,  7433L,  7451L,  7457L, 
    7459L,  7477L,  7481L,  7487L,  7489L,  7499L,  7507L,  7517L, 
    7523L,  7529L,  7537L,  7541L,  7547L,  7549L,  7559L,  7561L, 
    7573L,  7577L,  7583L,  7589L,  7591L,  7603L,  7607L,  7621L, 
    7639L,  7643L,  7649L,  7669L,  7673L,  7681L,  7687L,  7691L, 
    7699L,  7703L,  7717L,  7723L,  7727L,  7741L,  7753L,  7757L, 
    7759L,  7789L,  7793L,  7817L,  7823L,  7829L,  7841L,  7853L, 
    7867L,  7873L,  7877L,  7879L,  7883L,  7901L,  7907L,  7919L, 
    7927L,  7933L,  7937L,  7949L,  7951L,  7963L,  7993L,  8009L, 
    8011L,  8017L,  8039L,  8053L,  8059L,  8069L,  8081L,  8087L, 
    8089L,  8093L,  8101L,  8111L,  8117L,  8123L,  8147L,  8161L, 
    8167L,  8171L,  8179L,  8191L,  8209L,  8219L,  8221L,  8231L, 
    8233L,  8237L,  8243L,  8263L,  8269L,  8273L,  8287L,  8291L, 
    8293L,  8297L,  8311L,  8317L,  8329L,  8353L,  8363L,  8369L, 
    8377L,  8387L,  8389L,  8419L,  8423L,  8429L,  8431L,  8443L, 
    8447L,  8461L,  8467L,  8501L,  8513L,  8521L,  8527L,  8537L, 
    8539L,  8543L,  8563L,  8573L,  8581L,  8597L,  8599L,  8609L, 
    8623L,  8627L,  8629L,  8641L,  8647L,  8663L,  8669L,  8677L, 
    8681L,  8689L,  8693L,  8699L,  8707L,  8713L,  8719L,  8731L, 
    8737L,  8741L,  8747L,  8753L,  8761L,  8779L,  8783L,  8803L, 
    8807L,  8819L,  8821L,  8831L,  8837L,  8839L,  8849L,  8861L, 
    8863L,  8867L,  8887L,  8893L,  8923L,  8929L,  8933L,  8941L, 
    8951L,  8963L,  8969L,  8971L,  8999L,  9001L,  9007L,  9011L, 
    9013L,  9029L,  9041L,  9043L,  9049L,  9059L,  9067L,  9091L, 
    9103L,  9109L,  9127L,  9133L,  9137L,  9151L,  9157L,  9161L, 
    9173L,  9181L,  9187L,  9199L,  9203L,  9209L,  9221L,  9227L, 
    9239L,  9241L,  9257L,  9277L,  9281L,  9283L,  9293L,  9311L, 
    9319L,  9323L,  9337L,  9341L,  9343L,  9349L,  9371L,  9377L, 
    9391L,  9397L,  9403L,  9413L,  9419L,  9421L,  9431L,  9433L, 
    9437L,  9439L,  9461L,  9463L,  9467L,  9473L,  9479L,  9491L, 
    9497L,  9511L,  9521L,  9533L,  9539L,  9547L,  9551L,  9587L, 
    9601L,  9613L,  9619L,  9623L,  9629L,  9631L,  9643L,  9649L, 
    9661L,  9677L,  9679L,  9689L,  9697L,  9719L,  9721L,  9733L, 
    9739L,  9743L,  9749L,  9767L,  9769L,  9781L,  9787L,  9791L, 
    9803L,  9811L,  9817L,  9829L,  9833L,  9839L,  9851L,  9857L, 
    9859L,  9871L,  9883L,  9887L,  9901L,  9907L,  9923L,  9929L, 
    9931L,  9941L,  9949L,  9967L,  9973L,  10007L, 10009L, 10037L, 
    10039L, 10061L, 10067L, 10069L, 10079L, 10091L, 10093L, 10099L, 
    10103L, 10111L, 10133L, 10139L, 10141L, 10151L, 10159L, 10163L, 
    10169L, 10177L, 10181L, 10193L, 10211L, 10223L, 10243L, 10247L, 
    10253L, 10259L, 10267L, 10271L, 10273L, 10289L, 10301L, 10303L, 
    10313L, 10321L, 10331L, 10333L, 10337L, 10343L, 10357L, 10369L, 
    10391L, 10399L, 10427L, 10429L, 10433L, 10453L, 10457L, 10459L, 
    10463L, 10477L, 10487L, 10499L, 10501L, 10513L, 10529L, 10531L, 
    10559L, 10567L, 10589L, 10597L, 10601L, 10607L, 10613L, 10627L, 
    10631L, 10639L, 10651L, 10657L, 10663L, 10667L, 10687L, 10691L, 
    10709L, 10711L, 10723L, 10729L, 10733L, 10739L, 10753L, 10771L, 
    10781L, 10789L, 10799L, 10831L, 10837L, 10847L, 10853L, 10859L, 
    10861L, 10867L, 10883L, 10889L, 10891L, 10903L, 10909L, 10937L, 
    10939L, 10949L, 10957L, 10973L, 10979L, 10987L, 10993L, 11003L, 
    11027L, 11047L, 11057L, 11059L, 11069L, 11071L, 11083L, 11087L, 
    11093L, 11113L, 11117L, 11119L, 11131L, 11149L, 11159L, 11161L, 
    11171L, 11173L, 11177L, 11197L, 11213L, 11239L, 11243L, 11251L, 
    11257L, 11261L, 11273L, 11279L, 11287L, 11299L, 11311L, 11317L, 
    11321L, 11329L, 11351L, 11353L, 11369L, 11383L, 11393L, 11399L, 
    11411L, 11423L, 11437L, 11443L, 11447L, 11467L, 11471L, 11483L, 
    11489L, 11491L, 11497L, 11503L, 11519L, 11527L, 11549L, 11551L, 
    11579L, 11587L, 11593L, 11597L, 11617L, 11621L, 11633L, 11657L, 
    11677L, 11681L, 11689L, 11699L, 11701L, 11717L, 11719L, 11731L, 
    11743L, 11777L, 11779L, 11783L, 11789L, 11801L, 11807L, 11813L, 
    11821L, 11827L, 11831L, 11833L, 11839L, 11863L, 11867L, 11887L, 
    11897L, 11903L, 11909L, 11923L, 11927L, 11933L, 11939L, 11941L, 
    11953L, 11959L, 11969L, 11971L, 11981L, 11987L, 12007L, 12011L, 
    12037L, 12041L, 12043L, 12049L, 12071L, 12073L, 12097L, 12101L, 
    12107L, 12109L, 12113L, 12119L, 12143L, 12149L, 12157L, 12161L, 
    12163L, 12197L, 12203L, 12211L, 12227L, 12239L, 12241L, 12251L, 
    12253L, 12263L, 12269L, 12277L, 12281L, 12289L, 12301L, 12323L, 
    12329L, 12343L, 12347L, 12373L, 12377L, 12379L, 12391L, 12401L, 
    12409L, 12413L, 12421L, 12433L, 12437L, 12451L, 12457L, 12473L, 
    12479L, 12487L, 12491L, 12497L, 12503L, 12511L, 12517L, 12527L, 
    12539L, 12541L, 12547L, 12553L, 12569L, 12577L, 12583L, 12589L, 
    12601L, 12611L, 12613L, 12619L, 12637L, 12641L, 12647L, 12653L, 
    12659L, 12671L, 12689L, 12697L, 12703L, 12713L, 12721L, 12739L, 
    12743L, 12757L, 12763L, 12781L, 12791L, 12799L, 12809L, 12821L, 
    12823L, 12829L, 12841L, 12853L, 12889L, 12893L, 12899L, 12907L, 
    12911L, 12917L, 12919L, 12923L, 12941L, 12953L, 12959L, 12967L, 
    12973L, 12979L, 12983L, 13001L, 13003L, 13007L, 13009L, 13033L, 
    13037L, 13043L, 13049L, 13063L, 13093L, 13099L, 13103L, 13109L, 
    13121L, 13127L, 13147L, 13151L, 13159L, 13163L, 13171L, 13177L, 
    13183L, 13187L, 13217L, 13219L, 13229L, 13241L, 13249L, 13259L, 
    13267L, 13291L, 13297L, 13309L, 13313L, 13327L, 13331L, 13337L, 
    13339L, 13367L, 13381L, 13397L, 13399L, 13411L, 13417L, 13421L, 
    13441L, 13451L, 13457L, 13463L, 13469L, 13477L, 13487L, 13499L, 
    13513L, 13523L, 13537L, 13553L, 13567L, 13577L, 13591L, 13597L, 
    13613L, 13619L, 13627L, 13633L, 13649L, 13669L, 13679L, 13681L, 
    13687L, 13691L, 13693L, 13697L, 13709L, 13711L, 13721L, 13723L, 
    13729L, 13751L, 13757L, 13759L, 13763L, 13781L, 13789L, 13799L, 
    13807L, 13829L, 13831L, 13841L, 13859L, 13873L, 13877L, 13879L, 
    13883L, 13901L, 13903L, 13907L, 13913L, 13921L, 13931L, 13933L, 
    13963L, 13967L, 13997L, 13999L, 14009L, 14011L, 14029L, 14033L, 
    14051L, 14057L, 14071L, 14081L, 14083L, 14087L, 14107L, 14143L, 
    14149L, 14153L, 14159L, 14173L, 14177L, 14197L, 14207L, 14221L, 
    14243L, 14249L, 14251L, 14281L, 14293L, 14303L, 14321L, 14323L, 
    14327L, 14341L, 14347L, 14369L, 14387L, 14389L, 14401L, 14407L, 
    14411L, 14419L, 14423L, 14431L, 14437L, 14447L, 14449L, 14461L, 
    14479L, 14489L, 14503L, 14519L, 14533L, 14537L, 14543L, 14549L, 
    14551L, 14557L, 14561L, 14563L, 14591L, 14593L, 14621L, 14627L, 
    14629L, 14633L, 14639L, 14653L, 14657L, 14669L, 14683L, 14699L, 
    14713L, 14717L, 14723L, 14731L, 14737L, 14741L, 14747L, 14753L, 
    14759L, 14767L, 14771L, 14779L, 14783L, 14797L, 14813L, 14821L, 
    14827L, 14831L, 14843L, 14851L, 14867L, 14869L, 14879L, 14887L, 
    14891L, 14897L, 14923L, 14929L, 14939L, 14947L, 14951L, 14957L, 
    14969L, 14983L, 15013L, 15017L, 15031L, 15053L, 15061L, 15073L, 
    15077L, 15083L, 15091L, 15101L, 15107L, 15121L, 15131L, 15137L, 
    15139L, 15149L, 15161L, 15173L, 15187L, 15193L, 15199L, 15217L, 
    15227L, 15233L, 15241L, 15259L, 15263L, 15269L, 15271L, 15277L, 
    15287L, 15289L, 15299L, 15307L, 15313L, 15319L, 15329L, 15331L, 
    15349L, 15359L, 15361L, 15373L, 15377L, 15383L, 15391L, 15401L, 
    15413L, 15427L, 15439L, 15443L, 15451L, 15461L, 15467L, 15473L, 
    15493L, 15497L, 15511L, 15527L, 15541L, 15551L, 15559L, 15569L, 
    15581L, 15583L, 15601L, 15607L, 15619L, 15629L, 15641L, 15643L, 
    15647L, 15649L, 15661L, 15667L, 15671L, 15679L, 15683L, 15727L, 
    15731L, 15733L, 15737L, 15739L, 15749L, 15761L, 15767L, 15773L, 
    15787L, 15791L, 15797L, 15803L, 15809L, 15817L, 15823L, 15859L, 
    15877L, 15881L, 15887L, 15889L, 15901L, 15907L, 15913L, 15919L, 
    15923L, 15937L, 15959L, 15971L, 15973L, 15991L, 16001L, 16007L, 
    16033L, 16057L, 16061L, 16063L, 16067L, 16069L, 16073L, 16087L, 
    16091L, 16097L, 16103L, 16111L, 16127L, 16139L, 16141L, 16183L, 
    16187L, 16189L, 16193L, 16217L, 16223L, 16229L, 16231L, 16249L, 
    16253L, 16267L, 16273L, 16301L, 16319L, 16333L, 16339L, 16349L, 
    16361L, 16363L, 16369L, 16381L, 16411L, 16417L, 16421L, 16427L, 
    16433L, 16447L, 16451L, 16453L, 16477L, 16481L, 16487L, 16493L, 
    16519L, 16529L, 16547L, 16553L, 16561L, 16567L, 16573L, 16603L, 
    16607L, 16619L, 16631L, 16633L, 16649L, 16651L, 16657L, 16661L, 
    16673L, 16691L, 16693L, 16699L, 16703L, 16729L, 16741L, 16747L, 
    16759L, 16763L, 16787L, 16811L, 16823L, 16829L, 16831L, 16843L, 
    16871L, 16879L, 16883L, 16889L, 16901L, 16903L, 16921L, 16927L, 
    16931L, 16937L, 16943L, 16963L, 16979L, 16981L, 16987L, 16993L, 
    17011L, 17021L, 17027L, 17029L, 17033L, 17041L, 17047L, 17053L, 
    17077L, 17093L, 17099L, 17107L, 17117L, 17123L, 17137L, 17159L, 
    17167L, 17183L, 17189L, 17191L, 17203L, 17207L, 17209L, 17231L, 
    17239L, 17257L, 17291L, 17293L, 17299L, 17317L, 17321L, 17327L, 
    17333L, 17341L, 17351L, 17359L, 17377L, 17383L, 17387L, 17389L, 
    17393L, 17401L, 17417L, 17419L, 17431L, 17443L, 17449L, 17467L, 
    17471L, 17477L, 17483L, 17489L, 17491L, 17497L, 17509L, 17519L, 
    17539L, 17551L, 17569L, 17573L, 17579L, 17581L, 17597L, 17599L, 
    17609L, 17623L, 17627L, 17657L, 17659L, 17669L, 17681L, 17683L, 
    17707L, 17713L, 17729L, 17737L, 17747L, 17749L, 17761L, 17783L, 
    17789L, 17791L, 17807L, 17827L, 17837L, 17839L, 17851L, 17863L
  };

  // the number of prime numbers
  static const long CPY_PRIME_SIZE = sizeof(CPY_PRIME_BASE) / sizeof(long);
}

#endif
