#include "demo.h"

/* our graphics, samples, etc. */
DATAFILE *data;

char const *names[] = {
    "ASTA01",
    "ASTA02",
    "ASTA03",
    "ASTA04",
    "ASTA05",
    "ASTA06",
    "ASTA07",
    "ASTA08",
    "ASTA09",
    "ASTA10",
    "ASTA11",
    "ASTA12",
    "ASTA13",
    "ASTA14",
    "ASTA15",
    "ASTB01",
    "ASTB02",
    "ASTB03",
    "ASTB04",
    "ASTB05",
    "ASTB06",
    "ASTB07",
    "ASTB08",
    "ASTB09",
    "ASTB10",
    "ASTB11",
    "ASTB12",
    "ASTB13",
    "ASTB14",
    "ASTB15",
    "ASTC01",
    "ASTC02",
    "ASTC03",
    "ASTC04",
    "ASTC05",
    "ASTC06",
    "ASTC07",
    "ASTC08",
    "ASTC09",
    "ASTC10",
    "ASTC11",
    "ASTC12",
    "ASTC13",
    "ASTC14",
    "ASTC15",
    "BOOM_SPL",
    "DEATH_SPL",
    "END_FONT",
    "ENGINE1",
    "ENGINE2",
    "ENGINE3",
    "ENGINE4",
    "ENGINE5",
    "ENGINE6",
    "ENGINE7",
    "ENGINE_SPL",
    "GAME_MUSIC",
    "GAME_PAL",
    "GO_BMP",
    "INTRO_ANIM",
    "INTRO_BMP_1",
    "INTRO_BMP_2",
    "INTRO_BMP_3",
    "INTRO_BMP_4",
    "INTRO_MUSIC",
    "INTRO_SPL",
    "ROCKET",
    "SHIP1",
    "SHIP2",
    "SHIP3",
    "SHIP4",
    "SHIP5",
    "SHOOT_SPL",
    "TITLE_BMP",
    "TITLE_FONT",
    "TITLE_MUSIC",
    "TITLE_PAL",
    "WELCOME_SPL",
};

int title_pal[];
int game_pal[];
ALLEGRO_BITMAP *ast;

static PALETTE *_make_pal(int *pal) {
    PALETTE *p = al_calloc(1, sizeof *p);
    for (int i = 0; i < 256; i++) {
        p->rgb[i] = al_map_rgb(pal[i * 3 + 0], pal[i * 3 + 1], pal[i * 3 + 2]);
    }
    return p;
}

void data_load(void) {
    data = al_calloc(DATA_COUNT, sizeof *data);
    ast = al_load_bitmap("data/AST.png");
    for (int i = 0; i < DATA_COUNT; i++) {
        char name[1000];
        if (i == END_FONT) {
            data[END_FONT].dat = al_load_font("data/DejaVuSans.ttf", 48, 0);;
        }
        if (i == TITLE_FONT) {
            data[TITLE_FONT].dat = al_load_font("data/DejaVuSans.ttf", 24, 0);
        }
        if (i == GAME_MUSIC || i == TITLE_MUSIC || i == INTRO_MUSIC) {
            sprintf(name, "data/%s.ogg", names[i]);
            data[i].dat = strdup(name);
        }
        if (i == TITLE_PAL) {
            data[i].dat = _make_pal(title_pal);
        }
        if (i == GAME_PAL) {
            data[i].dat = _make_pal(game_pal);
        }
        if (i >= ASTA01 && i <= ASTC15) {
            int j = i - ASTA01;
            int x = j % 8;
            int y = j / 8;
            data[i].dat = al_create_sub_bitmap(ast, x * 60, y * 60, 60, 60);
        }
        if (!data[i].dat) {
            sprintf(name, "data/%s.png", names[i]);
            data[i].dat = al_load_bitmap(name);
        }
        if (!data[i].dat) {
            sprintf(name, "data/%s.wav", names[i]);
            data[i].dat = al_load_sample(name);
        }
        if (!data[i].dat) {
            printf("Could not load %s.\n", name);
        }
    }
}



int title_pal[] = {
   0, 0, 0,
   48, 48, 81,
   28, 28, 101,
   60, 60, 109,
   101, 101, 162,
   142, 142, 203,
   190, 190, 243,
   255, 255, 255,
   0, 0, 0,
   4, 0, 0,
   4, 0, 0,
   8, 0, 0,
   8, 0, 0,
   12, 0, 0,
   12, 0, 0,
   16, 0, 0,
   16, 0, 0,
   20, 0, 0,
   20, 0, 0,
   24, 0, 0,
   24, 0, 0,
   28, 0, 0,
   28, 0, 0,
   32, 0, 0,
   32, 0, 0,
   36, 0, 0,
   40, 0, 0,
   40, 0, 0,
   44, 0, 0,
   44, 0, 0,
   48, 0, 0,
   48, 0, 0,
   52, 0, 0,
   52, 0, 0,
   56, 0, 0,
   56, 0, 0,
   60, 0, 0,
   60, 0, 0,
   65, 0, 0,
   65, 0, 0,
   69, 0, 0,
   69, 0, 0,
   73, 0, 0,
   77, 0, 0,
   77, 0, 0,
   81, 0, 0,
   81, 0, 0,
   85, 0, 0,
   85, 0, 0,
   89, 0, 0,
   89, 0, 0,
   93, 0, 0,
   93, 0, 0,
   97, 0, 0,
   97, 0, 0,
   101, 0, 0,
   101, 0, 0,
   105, 0, 0,
   105, 0, 0,
   109, 0, 0,
   113, 0, 0,
   113, 0, 0,
   117, 0, 0,
   117, 0, 0,
   121, 0, 0,
   121, 0, 0,
   125, 0, 0,
   125, 0, 0,
   130, 0, 0,
   130, 0, 0,
   134, 0, 0,
   134, 0, 0,
   138, 0, 0,
   138, 0, 0,
   142, 0, 0,
   142, 0, 0,
   146, 0, 0,
   150, 0, 0,
   150, 0, 0,
   154, 0, 0,
   154, 0, 0,
   158, 0, 0,
   158, 0, 0,
   162, 0, 0,
   162, 0, 0,
   166, 0, 0,
   166, 0, 0,
   170, 0, 0,
   170, 0, 0,
   174, 0, 0,
   174, 0, 0,
   178, 0, 0,
   178, 0, 0,
   182, 0, 0,
   186, 0, 0,
   186, 0, 0,
   190, 0, 0,
   190, 0, 0,
   195, 0, 0,
   195, 0, 0,
   199, 0, 0,
   199, 0, 0,
   203, 0, 0,
   203, 0, 0,
   207, 0, 0,
   207, 0, 0,
   211, 0, 0,
   211, 0, 0,
   215, 0, 0,
   215, 0, 0,
   219, 0, 0,
   223, 0, 0,
   223, 0, 0,
   227, 0, 0,
   227, 0, 0,
   231, 0, 0,
   231, 0, 0,
   235, 0, 0,
   235, 0, 0,
   239, 0, 0,
   239, 0, 0,
   243, 0, 0,
   243, 0, 0,
   247, 0, 0,
   247, 0, 0,
   251, 0, 0,
   251, 0, 0,
   255, 0, 0,
   0, 0, 0,
   0, 0, 0,
   4, 4, 4,
   4, 4, 4,
   8, 8, 8,
   8, 8, 8,
   12, 12, 12,
   12, 12, 12,
   16, 16, 16,
   16, 16, 16,
   20, 20, 20,
   20, 20, 20,
   24, 24, 24,
   24, 24, 24,
   28, 28, 28,
   28, 28, 28,
   32, 32, 32,
   32, 32, 32,
   36, 36, 36,
   36, 36, 36,
   40, 40, 40,
   40, 40, 40,
   44, 44, 44,
   44, 44, 44,
   48, 48, 48,
   48, 48, 48,
   52, 52, 52,
   52, 52, 52,
   56, 56, 56,
   56, 56, 56,
   60, 60, 60,
   60, 60, 60,
   65, 65, 65,
   65, 65, 65,
   69, 69, 69,
   69, 69, 69,
   73, 73, 73,
   73, 73, 73,
   77, 77, 77,
   77, 77, 77,
   81, 81, 81,
   81, 81, 81,
   85, 85, 85,
   85, 85, 85,
   89, 89, 89,
   89, 89, 89,
   93, 93, 93,
   93, 93, 93,
   97, 97, 97,
   97, 97, 97,
   101, 101, 101,
   101, 101, 101,
   105, 105, 105,
   105, 105, 105,
   109, 109, 109,
   109, 109, 109,
   113, 113, 113,
   113, 113, 113,
   117, 117, 117,
   117, 117, 117,
   121, 121, 121,
   121, 121, 121,
   125, 125, 125,
   125, 125, 125,
   130, 130, 130,
   130, 130, 130,
   134, 134, 134,
   134, 134, 134,
   138, 138, 138,
   138, 138, 138,
   142, 142, 142,
   142, 142, 142,
   146, 146, 146,
   146, 146, 146,
   150, 150, 150,
   150, 150, 150,
   154, 154, 154,
   154, 154, 154,
   158, 158, 158,
   158, 158, 158,
   162, 162, 162,
   162, 162, 162,
   166, 166, 166,
   166, 166, 166,
   170, 170, 170,
   170, 170, 170,
   174, 174, 174,
   174, 174, 174,
   178, 178, 178,
   178, 178, 178,
   182, 182, 182,
   182, 182, 182,
   186, 186, 186,
   186, 186, 186,
   190, 190, 190,
   190, 190, 190,
   195, 195, 195,
   195, 195, 195,
   199, 199, 199,
   199, 199, 199,
   203, 203, 203,
   203, 203, 203,
   207, 207, 207,
   207, 207, 207,
   211, 211, 211,
   211, 211, 211,
   215, 215, 215,
   215, 215, 215,
   219, 219, 219,
   219, 219, 219,
   223, 223, 223,
   223, 223, 223,
   227, 227, 227,
   227, 227, 227,
   231, 231, 231,
   231, 231, 231,
   235, 235, 235,
   235, 235, 235,
   239, 239, 239,
   239, 239, 239,
   243, 243, 243,
   243, 243, 243,
   247, 247, 247,
   247, 247, 247,
   251, 251, 251,
   251, 251, 251,
   255, 255, 255,
   255, 255, 255,
};

int game_pal[] = {
   0, 0, 0,
   255, 255, 255,
   0, 162, 255,
   0, 255, 0,
   255, 255, 0,
   255, 0, 0,
   0, 0, 0,
   162, 162, 162,
   0, 0, 117,
   0, 0, 162,
   0, 125, 211,
   130, 56, 255,
   0, 199, 255,
   130, 154, 195,
   223, 255, 186,
   255, 255, 255,
   0, 0, 0,
   16, 0, 0,
   44, 0, 0,
   73, 0, 0,
   101, 0, 0,
   130, 0, 0,
   162, 0, 0,
   195, 0, 0,
   227, 0, 0,
   255, 0, 0,
   255, 101, 0,
   255, 150, 0,
   255, 199, 0,
   255, 255, 0,
   255, 255, 125,
   255, 255, 255,
   93, 56, 12,
   101, 65, 16,
   73, 56, 36,
   109, 105, 77,
   125, 81, 24,
   97, 56, 12,
   255, 255, 65,
   52, 32, 8,
   93, 52, 16,
   117, 73, 20,
   130, 85, 24,
   73, 69, 48,
   48, 36, 24,
   44, 40, 28,
   255, 243, 56,
   69, 56, 36,
   73, 60, 40,
   85, 81, 60,
   142, 97, 28,
   121, 117, 85,
   150, 105, 28,
   101, 97, 69,
   60, 48, 28,
   101, 97, 73,
   65, 60, 44,
   146, 142, 105,
   77, 73, 52,
   32, 20, 4,
   40, 36, 24,
   121, 117, 89,
   138, 134, 97,
   142, 138, 101,
   121, 77, 20,
   8, 8, 4,
   81, 65, 40,
   8, 4, 4,
   81, 60, 40,
   85, 81, 56,
   89, 73, 48,
   77, 73, 56,
   48, 44, 32,
   52, 48, 36,
   255, 255, 73,
   113, 109, 81,
   255, 219, 52,
   56, 44, 24,
   40, 32, 20,
   125, 81, 20,
   186, 178, 134,
   56, 52, 40,
   150, 146, 105,
   89, 44, 8,
   182, 174, 130,
   162, 109, 32,
   125, 121, 89,
   138, 85, 24,
   89, 85, 65,
   255, 154, 16,
   255, 211, 48,
   130, 125, 93,
   109, 105, 81,
   65, 32, 4,
   117, 73, 24,
   255, 207, 48,
   134, 130, 93,
   154, 146, 109,
   56, 40, 20,
   36, 32, 24,
   60, 48, 32,
   97, 52, 16,
   162, 154, 113,
   166, 158, 121,
   0, 0, 0,
   60, 32, 4,
   158, 150, 113,
   97, 52, 12,
   65, 60, 48,
   130, 125, 89,
   93, 56, 16,
   113, 109, 77,
   81, 69, 48,
   12, 12, 8,
   146, 97, 28,
   77, 65, 44,
   146, 138, 101,
   73, 52, 32,
   16, 12, 8,
   28, 16, 4,
   125, 121, 85,
   130, 81, 20,
   12, 8, 0,
   101, 56, 16,
   130, 77, 20,
   255, 255, 60,
   20, 16, 8,
   65, 44, 24,
   52, 48, 32,
   81, 16, 0,
   52, 40, 20,
   158, 154, 113,
   134, 130, 97,
   85, 73, 44,
   65, 48, 24,
   16, 8, 0,
   121, 69, 16,
   36, 32, 20,
   89, 77, 56,
   142, 97, 24,
   109, 73, 20,
   255, 227, 56,
   32, 28, 16,
   52, 40, 24,
   134, 125, 97,
   255, 235, 52,
   65, 65, 44,
   255, 69, 8,
   81, 65, 36,
   44, 40, 32,
   113, 69, 24,
   130, 77, 24,
   255, 235, 56,
   255, 162, 16,
   52, 44, 32,
   109, 73, 16,
   97, 56, 16,
   166, 162, 117,
   138, 85, 20,
   52, 40, 28,
   65, 48, 28,
   142, 138, 105,
   109, 69, 24,
   77, 65, 36,
   255, 199, 48,
   73, 69, 52,
   255, 146, 16,
   60, 56, 36,
   134, 89, 20,
   24, 12, 0,
   69, 56, 40,
   255, 227, 52,
   138, 134, 93,
   255, 251, 60,
   255, 89, 16,
   85, 73, 48,
   158, 154, 109,
   150, 97, 32,
   255, 239, 56,
   73, 60, 48,
   150, 146, 109,
   73, 52, 24,
   121, 73, 20,
   65, 56, 40,
   255, 150, 16,
   255, 97, 8,
   255, 44, 4,
   16, 16, 12,
   56, 56, 36,
   255, 231, 56,
   56, 44, 28,
   255, 142, 16,
   255, 178, 16,
   255, 138, 16,
   16, 0, 0,
   255, 121, 16,
   255, 158, 16,
   255, 134, 16,
   255, 170, 16,
   16, 4, 0,
   255, 65, 8,
   20, 8, 0,
   48, 8, 0,
   255, 52, 8,
   255, 105, 12,
   56, 12, 0,
   255, 113, 16,
   24, 4, 0,
   255, 130, 16,
   40, 8, 0,
   255, 97, 16,
   28, 8, 0,
   65, 16, 0,
   32, 8, 0,
   255, 60, 8,
   255, 48, 4,
   255, 117, 16,
   255, 146, 12,
   73, 16, 0,
   24, 8, 0,
   255, 130, 12,
   255, 125, 16,
   255, 56, 8,
   255, 154, 12,
   36, 8, 0,
   32, 4, 0,
   255, 162, 12,
   255, 56, 4,
   255, 109, 16,
   65, 12, 0,
   255, 138, 12,
   44, 8, 0,
   40, 4, 0,
   255, 142, 12,
   255, 105, 16,
   255, 65, 4,
   81, 48, 174,
   174, 174, 81,
   0, 0, 0,
   0, 0, 0,
   0, 0, 0,
   0, 0, 0,
   65, 182, 65,
   52, 81, 81,
   109, 81, 182,
   81, 101, 247,
   113, 109, 97,
   215, 109, 113,
   0, 0, 0,
   0, 0, 0,
   0, 0, 0,
   0, 0, 0,
   203, 65, 203,
   154, 81, 81,
   215, 251, 166,
   0, 0, 0,
};
