/* Generated By:JavaCC: Do not edit this line. AlnParser.java */
package es.uvigo.ei.sing.alter.parser;

import es.uvigo.ei.sing.alter.types.Aln;
import es.uvigo.ei.sing.alter.types.AlnSequence;
import java.io.StringReader;
import java.util.Vector;

/**
* ALN format parser.
* @author Daniel Gomez Blanco
* @version 1.2
*/

public class AlnParser implements AlnParserConstants {
  /**
  * Static method that parses an input string and returns a MSA in ALN format.
  * @param in Input string.
  * @return MSA in ALN format.
  */
  public static Aln parseMSA (String in) throws ParseException
    {
        //Parse string and return MSA
        AlnParser parser = new AlnParser(new StringReader(in));
        return parser.Aln();
    }

/**
* Grammar's root production. Structure:<br>
* &nbsp;&nbsp;1. Any combination of spaces, tabs and new lines
* until the word "CLUSTAL", "MUSCLE" or "PROBCONS".<br>
* &nbsp;&nbsp;2. Any character after the word "CLUSTAL", "MUSCLE" or "PROBCONS"
* until the end of that line.<br>
* &nbsp;&nbsp;3. Any combination of spaces, tabs and new lines
* until first sequence identifier.<br>
* &nbsp;&nbsp;4. Sequence blocks with the following structure:<br>
* &nbsp;&nbsp;&nbsp;&nbsp;4a. Sequence line:<br>
* &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4a1. Identifier.<br>
* &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4a2. Data line.<br>
* &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4a3. Number of residues (optional).<br>
* &nbsp;&nbsp;&nbsp;&nbsp;4b. Consensus line made up of spaces, tabs, "*", ":" or ".".
* @return MSA in ALN format.
*/
  final public Aln Aln() throws ParseException {
    Vector<AlnSequence> seqs = new Vector<AlnSequence>();
    String id, data;
    int cont = 0;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        jj_consume_token(EOL);
        break;
      case BLANK:
        jj_consume_token(BLANK);
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 10:
      jj_consume_token(10);
      break;
    case 11:
      jj_consume_token(11);
      break;
    case 12:
      jj_consume_token(12);
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        jj_consume_token(BLANK);
        break;
      case UPPER_CASE:
        jj_consume_token(UPPER_CASE);
        break;
      case LOWER_CASE:
        jj_consume_token(LOWER_CASE);
        break;
      case NUMBER:
        jj_consume_token(NUMBER);
        break;
      case ANY:
        jj_consume_token(ANY);
        break;
      case 13:
        jj_consume_token(13);
        break;
      case 14:
        jj_consume_token(14);
        break;
      case 15:
        jj_consume_token(15);
        break;
      case 16:
        jj_consume_token(16);
        break;
      case 17:
        jj_consume_token(17);
        break;
      case 10:
        jj_consume_token(10);
        break;
      case 11:
        jj_consume_token(11);
        break;
      case 12:
        jj_consume_token(12);
        break;
      case 18:
        jj_consume_token(18);
        break;
      case 19:
        jj_consume_token(19);
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(EOL);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        jj_consume_token(EOL);
        break;
      case BLANK:
        jj_consume_token(BLANK);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_4:
    while (true) {
      id = Id();
      jj_consume_token(BLANK);
      data = DataLine();
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMBER:
          ;
          break;
        default:
          jj_la1[7] = jj_gen;
          break label_5;
        }
        jj_consume_token(NUMBER);
        label_6:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BLANK:
            ;
            break;
          default:
            jj_la1[8] = jj_gen;
            break label_6;
          }
          jj_consume_token(BLANK);
        }
      }
      jj_consume_token(EOL);
            seqs.add(new AlnSequence(id,data));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 10:
      case 11:
      case 12:
      case 16:
      case 17:
      case 18:
      case 19:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_4;
      }
    }
    label_7:
    while (true) {
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
        case 13:
        case 14:
        case 15:
          ;
          break;
        default:
          jj_la1[10] = jj_gen;
          break label_8;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          jj_consume_token(BLANK);
          break;
        case 13:
          jj_consume_token(13);
          break;
        case 14:
          jj_consume_token(14);
          break;
        case 15:
          jj_consume_token(15);
          break;
        default:
          jj_la1[11] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(EOL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
      case 13:
      case 14:
      case 15:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_7;
      }
    }
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 10:
      case 11:
      case 12:
      case 16:
      case 17:
      case 18:
      case 19:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_9;
      }
      label_10:
      while (true) {
        IdSeq(seqs.elementAt(cont).getId());
        jj_consume_token(BLANK);
        data = DataLine();
        label_11:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NUMBER:
            ;
            break;
          default:
            jj_la1[14] = jj_gen;
            break label_11;
          }
          jj_consume_token(NUMBER);
          label_12:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              ;
              break;
            default:
              jj_la1[15] = jj_gen;
              break label_12;
            }
            jj_consume_token(BLANK);
          }
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EOL:
          jj_consume_token(EOL);
          break;
        case 0:
          jj_consume_token(0);
          break;
        default:
          jj_la1[16] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                seqs.elementAt(cont).concat(data);
                cont++;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 10:
        case 11:
        case 12:
        case 16:
        case 17:
        case 18:
        case 19:
          ;
          break;
        default:
          jj_la1[17] = jj_gen;
          break label_10;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
      case 13:
      case 14:
      case 15:
        label_13:
        while (true) {
          label_14:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
            case 13:
            case 14:
            case 15:
              ;
              break;
            default:
              jj_la1[18] = jj_gen;
              break label_14;
            }
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              jj_consume_token(BLANK);
              break;
            case 13:
              jj_consume_token(13);
              break;
            case 14:
              jj_consume_token(14);
              break;
            case 15:
              jj_consume_token(15);
              break;
            default:
              jj_la1[19] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          jj_consume_token(EOL);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
          case BLANK:
          case 13:
          case 14:
          case 15:
            ;
            break;
          default:
            jj_la1[20] = jj_gen;
            break label_13;
          }
        }
        break;
      case 0:
        jj_consume_token(0);
        break;
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            cont = 0;
    }
    jj_consume_token(0);
        {if (true) return new Aln(seqs);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a sequence identifier. The identifier cannot contain spaces
* and it cannot start with the characters "*",":","." to avoid
* confusion with consensus lines.
* @return String with the sequence identifier.
*/
  final public String Id() throws ParseException {
    StringBuffer s =  new StringBuffer();
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 18:
    case 19:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 18:
        jj_consume_token(18);
        break;
      case 19:
        jj_consume_token(19);
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          t = jj_consume_token(BLANK);
          break;
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          t = jj_consume_token(NUMBER);
          break;
        case ANY:
          t = jj_consume_token(ANY);
          break;
        case 13:
          t = jj_consume_token(13);
          break;
        case 14:
          t = jj_consume_token(14);
          break;
        case 15:
          t = jj_consume_token(15);
          break;
        case 16:
          t = jj_consume_token(16);
          break;
        case 17:
          t = jj_consume_token(17);
          break;
        case 10:
          t = jj_consume_token(10);
          break;
        case 11:
          t = jj_consume_token(11);
          break;
        case 12:
          t = jj_consume_token(12);
          break;
        default:
          jj_la1[23] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                s.append(t.image);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 10:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:
        case 16:
        case 17:
          ;
          break;
        default:
          jj_la1[24] = jj_gen;
          break label_15;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 18:
        jj_consume_token(18);
        break;
      case 19:
        jj_consume_token(19);
        break;
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case UPPER_CASE:
    case LOWER_CASE:
    case NUMBER:
    case ANY:
    case 10:
    case 11:
    case 12:
    case 16:
    case 17:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
        t = jj_consume_token(UPPER_CASE);
        break;
      case LOWER_CASE:
        t = jj_consume_token(LOWER_CASE);
        break;
      case NUMBER:
        t = jj_consume_token(NUMBER);
        break;
      case ANY:
        t = jj_consume_token(ANY);
        break;
      case 16:
        t = jj_consume_token(16);
        break;
      case 17:
        t = jj_consume_token(17);
        break;
      case 10:
        t = jj_consume_token(10);
        break;
      case 11:
        t = jj_consume_token(11);
        break;
      case 12:
        t = jj_consume_token(12);
        break;
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            s.append(t.image);
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 10:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:
        case 16:
        case 17:
        case 18:
        case 19:
          ;
          break;
        default:
          jj_la1[27] = jj_gen;
          break label_16;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          t = jj_consume_token(NUMBER);
          break;
        case ANY:
          t = jj_consume_token(ANY);
          break;
        case 13:
          t = jj_consume_token(13);
          break;
        case 14:
          t = jj_consume_token(14);
          break;
        case 15:
          t = jj_consume_token(15);
          break;
        case 16:
          t = jj_consume_token(16);
          break;
        case 17:
          t = jj_consume_token(17);
          break;
        case 18:
          t = jj_consume_token(18);
          break;
        case 19:
          t = jj_consume_token(19);
          break;
        case 10:
          t = jj_consume_token(10);
          break;
        case 11:
          t = jj_consume_token(11);
          break;
        case 12:
          t = jj_consume_token(12);
          break;
        default:
          jj_la1[28] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                s.append(t.image);
      }
      break;
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return s.toString();}
    throw new Error("Missing return statement in function");
  }

/**
* Same behaviour as Id(), but in this case equality between the already read
* identifier and the current one is checked.
* @param id Identifier to parse.
*/
  final public void IdSeq(String id) throws ParseException {
    StringBuffer s = new StringBuffer();
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 18:
    case 19:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 18:
        jj_consume_token(18);
        break;
      case 19:
        jj_consume_token(19);
        break;
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          t = jj_consume_token(BLANK);
          break;
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          t = jj_consume_token(NUMBER);
          break;
        case ANY:
          t = jj_consume_token(ANY);
          break;
        case 13:
          t = jj_consume_token(13);
          break;
        case 14:
          t = jj_consume_token(14);
          break;
        case 15:
          t = jj_consume_token(15);
          break;
        case 16:
          t = jj_consume_token(16);
          break;
        case 17:
          t = jj_consume_token(17);
          break;
        case 10:
          t = jj_consume_token(10);
          break;
        case 11:
          t = jj_consume_token(11);
          break;
        case 12:
          t = jj_consume_token(12);
          break;
        default:
          jj_la1[31] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                s.append(t.image);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 10:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:
        case 16:
        case 17:
          ;
          break;
        default:
          jj_la1[32] = jj_gen;
          break label_17;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 18:
        jj_consume_token(18);
        break;
      case 19:
        jj_consume_token(19);
        break;
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case UPPER_CASE:
    case LOWER_CASE:
    case NUMBER:
    case ANY:
    case 10:
    case 11:
    case 12:
    case 16:
    case 17:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
        t = jj_consume_token(UPPER_CASE);
        break;
      case LOWER_CASE:
        t = jj_consume_token(LOWER_CASE);
        break;
      case NUMBER:
        t = jj_consume_token(NUMBER);
        break;
      case ANY:
        t = jj_consume_token(ANY);
        break;
      case 16:
        t = jj_consume_token(16);
        break;
      case 17:
        t = jj_consume_token(17);
        break;
      case 10:
        t = jj_consume_token(10);
        break;
      case 11:
        t = jj_consume_token(11);
        break;
      case 12:
        t = jj_consume_token(12);
        break;
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            s.append(t.image);
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 10:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:
        case 16:
        case 17:
        case 18:
        case 19:
          ;
          break;
        default:
          jj_la1[35] = jj_gen;
          break label_18;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          t = jj_consume_token(NUMBER);
          break;
        case ANY:
          t = jj_consume_token(ANY);
          break;
        case 13:
          t = jj_consume_token(13);
          break;
        case 14:
          t = jj_consume_token(14);
          break;
        case 15:
          t = jj_consume_token(15);
          break;
        case 16:
          t = jj_consume_token(16);
          break;
        case 17:
          t = jj_consume_token(17);
          break;
        case 18:
          t = jj_consume_token(18);
          break;
        case 19:
          t = jj_consume_token(19);
          break;
        case 10:
          t = jj_consume_token(10);
          break;
        case 11:
          t = jj_consume_token(11);
          break;
        case 12:
          t = jj_consume_token(12);
          break;
        default:
          jj_la1[36] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                s.append(t.image);
      }
      break;
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (!id.equals(s.toString()))
        {if (true) throw new ParseException("ID for sequence \u005c"" + id
                            + "\u005c"does not match with ID in line " + t.beginLine);}
  }

/**
* Parses a data line. A data line can be made up of characters from "A" to "Z"
* (lowercase and uppercase), "-", "." or "?". Spaces and tabs are omitted.
* @return String with the data line (always uppercase).
*/
  final public String DataLine() throws ParseException {
    StringBuffer s = new StringBuffer();
    Token t;
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        t = jj_consume_token(BLANK);
        break;
      case UPPER_CASE:
      case LOWER_CASE:
      case 10:
      case 11:
      case 12:
      case 15:
      case 16:
      case 17:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case 16:
          t = jj_consume_token(16);
          break;
        case 15:
          t = jj_consume_token(15);
          break;
        case 17:
          t = jj_consume_token(17);
          break;
        case 10:
          t = jj_consume_token(10);
          break;
        case 11:
          t = jj_consume_token(11);
          break;
        case 12:
          t = jj_consume_token(12);
          break;
        default:
          jj_la1[38] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                s.append(t.image);
        break;
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
      case UPPER_CASE:
      case LOWER_CASE:
      case 10:
      case 11:
      case 12:
      case 15:
      case 16:
      case 17:
        ;
        break;
      default:
        jj_la1[40] = jj_gen;
        break label_19;
      }
    }
        {if (true) return s.toString().toUpperCase();}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public AlnParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[41];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x6,0x6,0x1c00,0xffc7c,0xffc7c,0x6,0x6,0x20,0x4,0xf1c78,0xe004,0xe004,0xe006,0xf1c78,0x20,0x4,0x3,0xf1c78,0xe004,0xe004,0xe006,0xe007,0xc0000,0x3fc7c,0x3fc7c,0xc0000,0x31c78,0xffc78,0xffc78,0xf1c78,0xc0000,0x3fc7c,0x3fc7c,0xc0000,0x31c78,0xffc78,0xffc78,0xf1c78,0x39c18,0x39c1c,0x39c1c,};
   }

  /** Constructor with InputStream. */
  public AlnParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public AlnParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new AlnParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public AlnParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new AlnParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public AlnParser(AlnParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(AlnParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[20];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 41; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 20; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
