/****************************************************************************************
 * Copyright (c) 2013 Konrad Zemek <konrad.zemek@gmail.com>                             *
 *                                                                                      *
 * This program is free software; you can redistribute it and/or modify it under        *
 * the terms of the GNU General Public License as published by the Free Software        *
 * Foundation; either version 2 of the License, or (at your option) any later           *
 * version.                                                                             *
 *                                                                                      *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY      *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A      *
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.             *
 *                                                                                      *
 * You should have received a copy of the GNU General Public License along with         *
 * this program.  If not, see <http://www.gnu.org/licenses/>.                           *
 ****************************************************************************************/

#include "ITunesConfigWidget.h"

#include <KLocalizedString>
#include <KUrlRequester>

using namespace StatSyncing;

ITunesConfigWidget::ITunesConfigWidget( const QVariantMap &config, QWidget *parent,
                                        Qt::WindowFlags f )
    : SimpleImporterConfigWidget( QStringLiteral("iTunes"), config, parent, f )
{
    KUrlRequester *dbField = new KUrlRequester;
    dbField->setNameFilter( QStringLiteral("iTunes Music Library.xml") );
    addField( QStringLiteral("dbPath"), i18n( "Database location" ), dbField, QStringLiteral("text") );
}

ITunesConfigWidget::~ITunesConfigWidget()
{
}
