//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// Name:         wxCasPix Class
///
/// Purpose:      wxCas main frame
///
/// Author:       ThePolish <thepolish@vipmail.ru>
///
/// Copyright (c) 2004-2011 ThePolish ( thepolish@vipmail.ru )
///
/// Derived from CAS by Pedro de Oliveira <falso@rdk.homeip.net>
///
/// Pixmaps from aMule http://www.amule.org
///
/// This program is free software; you can redistribute it and/or modify
///  it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// This program is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with this program; if not, write to the
/// Free Software Foundation, Inc.,
/// 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


#include "wxcaspix.h"

wxBitmap WxCasPix::getPixmap( const wxString& name )
{
	if ( name == wxT( "about" ) ) {
		wxBitmap bitmap( m_about_xpm );
		return bitmap;
	} else if ( name == wxT( "prefs" ) ) {
		wxBitmap bitmap( m_prefs_xpm );
		return bitmap;
	} else if ( name == wxT( "print" ) ) {
		wxBitmap bitmap( m_print_xpm );
		return bitmap;
	} else if ( name == wxT( "refresh" ) ) {
		wxBitmap bitmap( m_refresh_xpm );
		return bitmap;
	} else if ( name == wxT( "save" ) ) {
		wxBitmap bitmap( m_save_xpm );
		return bitmap;
	} else if ( name == wxT( "stat" ) ) {
		wxBitmap bitmap( m_stat_xpm );
		return bitmap;
	} else if ( name == wxT( "stop" ) ) {
		wxBitmap bitmap( m_stop_xpm );
		return bitmap;
#ifndef __WINDOWS__
	} else if ( name == wxT( "wxcas" ) ) {
		wxBitmap bitmap( m_wxcas_xpm );
		return bitmap;
#endif
	} else {
		return wxNullBitmap;
	}

}

const char *
WxCasPix::m_about_xpm[] =
    { /* XPM */
        /* columns rows colors chars-per-pixel */
        "32 32 179 2",
        "   c None",
        ".  c #0c0b0a",
        "X  c #32373e",
        "o  c #3f3330",
        "O  c #002e66",
        "+  c #00306a",
        "@  c #003573",
        "#  c #003778",
        "$  c #00397c",
        "%  c #5a2d12",
        "&  c #45312a",
        "*  c #642909",
        "=  c #682b09",
        "-  c #6f310d",
        ";  c #74360f",
        ":  c #7a3b12",
        ">  c #7c4d2d",
        ",  c #48494c",
        "<  c #7e5e50",
        "1  c #675b63",
        "2  c #696c6f",
        "3  c #003c84",
        "4  c #003f89",
        "5  c #00408b",
        "6  c #0a4083",
        "7  c #014499",
        "8  c #114d9c",
        "9  c #18529c",
        "0  c #054eb0",
        "q  c #0d51a5",
        "w  c #1558a7",
        "e  c #1857b1",
        "r  c #1b65ae",
        "t  c #23558d",
        "y  c #245f9f",
        "u  c #34659b",
        "i  c #276bb8",
        "p  c #3f6ea2",
        "a  c #0657c6",
        "s  c #1462d2",
        "d  c #256cd0",
        "f  c #2774c4",
        "g  c #2d70cd",
        "h  c #2f76d7",
        "j  c #2171e8",
        "k  c #357fe6",
        "l  c #3b95db",
        "z  c #2f82f0",
        "x  c #3a80e6",
        "c  c #3a85e8",
        "v  c #3e89ed",
        "b  c #3684f1",
        "n  c #5185bf",
        "m  c #4182c7",
        "M  c #4997d8",
        "N  c #4289ec",
        "B  c #4389f2",
        "V  c #4490f2",
        "C  c #4e94f2",
        "Z  c #5a9df3",
        "A  c #54afed",
        "S  c #5ba4e1",
        "D  c #71a6da",
        "F  c #63a3f6",
        "G  c #67a9f8",
        "H  c #6ca9f7",
        "J  c #6daaf8",
        "K  c #79aee9",
        "L  c #75b8ee",
        "P  c #76b1f7",
        "I  c #77b2f9",
        "U  c #75bcf3",
        "Y  c #7bb4f9",
        "T  c #7fbdf9",
        "R  c #74c2fa",
        "E  c #7dc6fa",
        "W  c #833f14",
        "Q  c #bf2b4a",
        "!  c #8f4b1b",
        "~  c #954f1d",
        "^  c #97511e",
        "/  c #9c5622",
        "(  c #a45b24",
        ")  c #a25d29",
        "_  c #a7602a",
        "`  c #ad6227",
        "'  c #ad6228",
        "]  c #b6692b",
        "[  c #b86b2c",
        "{  c #b67038",
        "}  c #bd7031",
        "|  c #867069",
        " . c #ac4c6f",
        ".. c #b14062",
        "X. c #b14a6c",
        "o. c #c73351",
        "O. c #ca3f5c",
        "+. c #c0712f",
        "@. c #c67530",
        "#. c #c37a31",
        "$. c #c07a3c",
        "%. c #ca7b38",
        "&. c #cc5773",
        "*. c #c7627f",
        "=. c #a35d82",
        "-. c #b67698",
        ";. c #ce6d87",
        ":. c #b68b67",
        ">. c #cd8838",
        ",. c #e49c3f",
        "<. c #ce8240",
        "1. c #cf874a",
        "2. c #d38c4d",
        "3. c #d89c47",
        "4. c #d69658",
        "5. c #d99b62",
        "6. c #dca25c",
        "7. c #daa16c",
        "8. c #e0ae7d",
        "9. c #838186",
        "0. c #9a9794",
        "q. c #8192af",
        "w. c #ac98bb",
        "e. c #b58fb1",
        "r. c #a0a09f",
        "t. c #b4b4b0",
        "y. c #92b2d8",
        "u. c #83baf9",
        "i. c #8abffb",
        "p. c #abb3db",
        "a. c #b5afd1",
        "s. c #b4b7da",
        "d. c #83c9fb",
        "f. c #8bc3fc",
        "g. c #9bc4e8",
        "h. c #93c4fb",
        "j. c #95ccfb",
        "k. c #9dccfc",
        "l. c #9cd1fb",
        "z. c #a0cefd",
        "x. c #a4d1fe",
        "c. c #afd5f3",
        "v. c #abd5fd",
        "b. c #b7cdee",
        "n. c #b7d4f5",
        "m. c #b4d9f7",
        "M. c #b4dbfe",
        "N. c #b9defe",
        "B. c #bde1fe",
        "V. c #d487a0",
        "C. c #d49db4",
        "Z. c #d1b28b",
        "A. c #d1a7be",
        "S. c #e4b785",
        "D. c #d0b4cb",
        "F. c #d1bad0",
        "G. c #e2bdcd",
        "H. c #edcfa7",
        "J. c #cac8c2",
        "K. c #d4cdc2",
        "L. c #dfdbd6",
        "P. c #cad3ea",
        "I. c #c4e4ff",
        "U. c #c9e7ff",
        "Y. c #cae8ff",
        "T. c #d3ecfe",
        "R. c #dbf0ff",
        "E. c #e2c9d9",
        "W. c #e2d4e2",
        "Q. c #f6e7da",
        "!. c #e7e7e5",
        "~. c #e2e1ef",
        "^. c #e3f3ff",
        "/. c #eaf6ff",
        "(. c #eef8ff",
        "). c #f1f1ef",
        "_. c #f2f9ff",
        "`. c #fdfdfe",
        "'. c None",
        /* pixels */
        "'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.",
        "'.'.'.'.'.'.'.'.'.'.'.4 3 3 $ $ $ $ $ $ $ '.'.'.'.'.'.'.'.'.'.'.",
        "'.'.'.'.'.'.'.'.3 3 3 w l A R d.d.d.U D y # @ @ '.'.'.'.'.'.'.'.",
        "'.'.'.'.'.'.4 4 r M U j.l.B.N.B.B.N.B.m.c.g.D u @ @ '.'.'.'.'.'.",
        "'.'.'.'.4 4 f M d.N.T./.`.`.`.`.`.`.`.`.`.(.T.B.y.p @ + '.'.'.'.",
        "'.'.'.4 w l R M.T.`.`.`.`.`.`.`.`.`.`.`.`.`.`._.R.I.y.t + '.'.'.",
        "'.'.4 i l R M.`.`.`._.^.^.W.W.W.W.W.^.^.^._._.`.`.T.B.g.p + '.'.",
        "'.4 r l E B.`.(.^.^.^.^.^.E.G.G.G.E.^.^.^.^.^.^._.`.R.M.D t + '.",
        "'.5 m R N.`.^.T.T.T.T.T.T.A.C.C.C.F.R.R.R.R.R.^.^.^.`.T.z.n + '.",
        "5 i S M./._.T.T.T.T.T.T.T.A.V.V.V.D.T.R.T.T.T.T.R.^././.M.K 9 + ",
        "4 m d.N._.T.T.T.Y.Y.Y.Y.Y.A.;.;.;.D.Y.Y.Y.Y.Y.Y.T.Y.^._.M.i.i O ",
        "4 S j.N._.U.I.U.Y.Y.Y.Y.Y.F.&.&.&.P.Y.Y.Y.Y.Y.Y.Y.T.Y._.v.u.m + ",
        "4 L k.M.(.I.I.I.Y.Y.Y.Y.U.P.O.O.O.Y.U.U.U.U.U.I.I.I.I./.v.P c O ",
        "4 S x.v.Y.B.B.I.I.I.I.I.I.I.*.o.*.Y.I.U.I.I.I.I.I.I.N.Y.i.F k O ",
        "4 n k.x.B.M.M.N.B.B.B.B.B.B.-.Q -.B.B.B.B.B.I.I.N.I.I.B.Y C d O ",
        "4 y D x.M.N.N.N.M.< * * * B.a.e.a.B.B.B.B.N.N.B.N.N.N.x.H N 8 + ",
        "'.3 l * * * B.< ; { 6.: | N.n.e.b.N.M.B.N.N.N.B.B.N.N.i.Z h O '.",
        "'.# * 2.* k.* [ S.5.) ; y.a..... .s.M.M.N.N.N.N.B.v.h.Z v 8 O '.",
        "'.* @.] * ; H.S.7.>.; | v.e. . . .a.M.B.N.N.N.M.v.h.Z B g O '.'.",
        "'.* ] ; <.8.4.2.) % =.z.z.a.=.=.-.s.x.v.N.N.N.v.j.C k g 9 + '.'.",
        "* * ! <.2.>.' * 1 D K h.f.f.p.w.p.f.h.x.M.v.M.T F N i 8 O '.'.'.",
        "'.* ~ [ ` ` : / * i c F G H H H H H I f.x.v.u.C N e 3 + '.'.'.'.",
        "* * ( [ @.% 8.H.{ * @ 8 s j b b b B F I f.i.C k w O + '.'.'.'.'.",
        "'.* [ } @.7._.L.. ! = & X X @ + @ 7 a F u.F j w + '.'.'.'.'.'.'.",
        "* - @.<.@.2.Q.0.X ) Z.L.).t.X '.'.+ 7 s Z b w + '.'.'.'.'.'.'.'.",
        "* ~ 2.6.4.%.1.4.%.%.Z.2 . `.t.X '.'.+ a b a O '.'.'.'.'.'.'.'.'.",
        "* ` 2.H.8.2.%.] ) $.t.t.r.).!.X '.'.+ a s + '.'.'.'.'.'.'.'.'.'.",
        "* ~ <.5.7.2.%.[ ` { K.!.`.).).X '.'.+ 0 + '.'.'.'.'.'.'.'.'.'.'.",
        "* - ] <.>.3.@.[ ( :.J.L.!.).!.X '.'.O + '.'.'.'.'.'.'.'.'.'.'.'.",
        "* : * ) ( ( ( / > r.J.2 J.L.9.X '.'.+ '.'.'.'.'.'.'.'.'.'.'.'.'.",
        "- ! / W = * % & X 2 0.t., X X '.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.",
        "- ! #.,.<.' * '.'.X X X X '.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'.'."
    };

const char *
WxCasPix::m_prefs_xpm[] =
    { /* XPM */
        /* columns rows colors chars-per-pixel */
        "32 32 100 2",
        "  	c None",
        ". 	c #9A5600",
        "+ 	c #945300",
        "@ 	c #904F00",
        "# 	c #8B4C00",
        "$ 	c #DC9124",
        "% 	c #FFC463",
        "& 	c #FBB648",
        "* 	c #B66A01",
        "= 	c #E3900B",
        "- 	c #C17101",
        "; 	c #8F5000",
        "> 	c #C47A14",
        ", 	c #F4B54F",
        "' 	c #FFCA72",
        ") 	c #FEBB4B",
        "! 	c #FFB63C",
        "~ 	c #EFAE45",
        "{ 	c #EC950C",
        "] 	c #F59D0B",
        "^ 	c #FBA10D",
        "/ 	c #BF7204",
        "( 	c #824800",
        "_ 	c #9D5800",
        ": 	c #F1AF49",
        "< 	c #FFC15C",
        "[ 	c #FFC055",
        "} 	c #F1AB3A",
        "| 	c #FFB233",
        "1 	c #FCA512",
        "2 	c #F39C1C",
        "3 	c #E39321",
        "4 	c #FFB02B",
        "5 	c #FFAF28",
        "6 	c #FFAC22",
        "7 	c #FEAA1B",
        "8 	c #DF8C0B",
        "9 	c #7A4400",
        "0 	c #FFB027",
        "a 	c #FEA816",
        "b 	c #CE8009",
        "c 	c #6E3D00",
        "d 	c #E49929",
        "e 	c #FFB843",
        "f 	c #D48006",
        "g 	c #FFC86E",
        "h 	c #D9871D",
        "i 	c #B96400",
        "j 	c #F4AD43",
        "k 	c #DE9B30",
        "l 	c #E79107",
        "m 	c #FFE5BC",
        "n 	c #FFD897",
        "o 	c #FFD082",
        "p 	c #FFBE53",
        "q 	c #C98B31",
        "r 	c #B1751B",
        "s 	c #E38D09",
        "t 	c #D19036",
        "u 	c #FFD899",
        "v 	c #FABD5B",
        "w 	c #AB7326",
        "x 	c #D97E00",
        "y 	c #D47900",
        "z 	c #CB7300",
        "A 	c #AC6300",
        "B 	c #BA7C1F",
        "C 	c #FFE0AC",
        "D 	c #FEC669",
        "E 	c #B36400",
        "F 	c #DD8000",
        "G 	c #EC8F0A",
        "H 	c #754100",
        "I 	c #FEC770",
        "J 	c #FFCD7A",
        "K 	c #C36B00",
        "L 	c #A45B00",
        "M 	c #B67B29",
        "N 	c #A85D00",
        "O 	c #FFD38B",
        "P 	c #DAA14A",
        "Q 	c #B26D0C",
        "R 	c #B98131",
        "S 	c #703F00",
        "T 	c #C38322",
        "U 	c #FFF3DF",
        "V 	c #FFFFFF",
        "W 	c #DEA751",
        "X 	c #A7650D",
        "Y 	c #FFDBA1",
        "Z 	c #E18E1D",
        "` 	c #EA9A24",
        " .	c #F2A52D",
        "..	c #E1901D",
        "+.	c #D07B0B",
        "@.	c #E3952B",
        "#.	c #D98414",
        "$.	c #FFE3B3",
        "%.	c #E88903",
        "&.	c #9B600D",
        "                                                                ",
        "                    . + + +       @ @ #                         ",
        "              . . . $ % & +     + * = - # ;                     ",
        "            . > , ' % ) ! ~ +   ; { ] ^ { / # (                 ",
        "            _ : < % [ ! } | ~ ; = 1 1 ] ] 2 = #                 ",
        "            . 3 [ [ ) ! ! 4 5 / 6 7 1 ] ^ ] 8 9                 ",
        "            . . [ [ ! ! | | 4 0 6 6 a 1 ^ ^ b c   ( 9           ",
        "      . _ . ; 9 d [ e ! ! | | 4 5 6 6 a a 1 / c ( * f 9         ",
        "    _ } g } h i j ) ) e ! } k k k } 6 7 a 1 { * l ^ ^ 8 9       ",
        "    _ m n o o % p p ) ) q ; ; ; # # r k 7 7 a ^ ^ ^ ] ] s 9     ",
        "  . t m u o % v < [ p w ; * x y z A ; ; B 7 a 1 1 ^ ^ ^ ] f 9   ",
        "  . u C o o D % v < q # E z x F x y z E + B 7 a 1 ^ ^ ^ ] G H   ",
        "  . I u o o D D % < _ * z x x F F x z z i ( B 7 a 1 ^ ^ ] z 9   ",
        ". F F 2 & J g D % % _ ; # # # ( 9 _ E K i _ ( } a a ^ { E # H   ",
        ". F F y K 2 J J D % _             9 9 _ E L 9 k 7 7 = E # ( H   ",
        ". + K y K L G J g D M _               H _ L 9 k 6 7 1 ^ { f E H ",
        "    + + K N 2 O J D P .                 c _ c k 6 6 7 1 ] ] ] H ",
        "        + Q m u o J ' R _               c # c } 0 6 6 a a ] ] S ",
        "      + T o U u n J J g R ( 9           c c B | | | 5 7 a a ^ H ",
        "    + x 2 O V m u O J J ' W w 9 9 H 9 c c X ! | | | | | | 6 a S ",
        "  + x F F 2 Y U u u o J g D D } k k k k } [ [ [ ! Z 3 `  . .^ S ",
        "  + F F F F 2 Y C ) ..J o g D % % v [ [ [ ) [ [ p Z _ E K y c   ",
        "  + * x F F F 2 ..i +  .u o J D % < < [ [ [ [ [ % j K + _ i S   ",
        "    @ F F F F z i 9 + 3 C u o J ' % D D % % % % % O 3 K c c     ",
        "      # F F z # #   ( +.m u u O J ' I [  .I o O O o e @.c       ",
        "        # E #       9 +.O m m u u O ' +.x { [ m Y v #.E c       ",
        "          #         ( y l ) o m m $.O i F F %. .Z z i i H       ",
        "                  ( . x F F x G 2 B 9 9 z F F i i i i L c       ",
        "                  ( A F F F F F F &.9   H x F K i i + c         ",
        "                  ( - F F F F F F 9       H F z N c c           ",
        "                    9 9 9 A / z y H         c H c               ",
        "                          9 9 9 H                               "
    };

const char *
WxCasPix::m_print_xpm[] =
    { /* XPM */
        /* columns rows colors chars-per-pixel */
        "32 32 152 2",
        "   c None",
        ".  c #0c0b0a",
        "X  c #32373e",
        "o  c #303941",
        "O  c #1f4d2a",
        "+  c #2c6c3b",
        "@  c #36414a",
        "#  c #39434d",
        "$  c #3c4752",
        "%  c #346246",
        "&  c #5d2d0e",
        "*  c #642909",
        "=  c #6e310c",
        "-  c #7f3e13",
        ";  c #723c44",
        ":  c #414041",
        ">  c #414d58",
        ",  c #43505b",
        "<  c #475460",
        "1  c #485663",
        "2  c #4b5865",
        "3  c #4e5c6a",
        "4  c #505a65",
        "5  c #555f6a",
        "6  c #52606e",
        "7  c #5b646d",
        "8  c #566675",
        "9  c #576877",
        "0  c #586876",
        "q  c #5b6b7b",
        "w  c #6b6c6f",
        "e  c #606f7d",
        "r  c #62717d",
        "t  c #727476",
        "y  c #5e6f80",
        "u  c #5e7080",
        "i  c #637382",
        "p  c #647788",
        "a  c #657889",
        "s  c #687784",
        "d  c #6a7986",
        "f  c #6d7c8b",
        "g  c #6b7e91",
        "h  c #747b82",
        "j  c #727f8a",
        "k  c #21a72c",
        "l  c #378346",
        "z  c #15c61d",
        "x  c green",
        "c  c #33e23a",
        "v  c #429c55",
        "b  c #47a55d",
        "n  c #41ff41",
        "m  c #6d8295",
        "M  c #74828f",
        "N  c #758491",
        "B  c #708498",
        "V  c #7b8792",
        "C  c #7e8c99",
        "Z  c #7fb79a",
        "A  c #76c493",
        "S  c #79c697",
        "D  c #813f12",
        "F  c #a1282d",
        "G  c #804017",
        "H  c #86451b",
        "J  c #8e4a1a",
        "K  c #954f1d",
        "L  c #9a531e",
        "P  c #a65d24",
        "I  c #ab6228",
        "U  c #b4682c",
        "Y  c #bc6e2d",
        "T  c #bf7732",
        "R  c #a4734c",
        "E  c red",
        "W  c #c1742d",
        "Q  c #c77835",
        "!  c #ca4f55",
        "~  c #ce8240",
        "^  c #c18c57",
        "/  c #cc914e",
        "(  c #d28a4a",
        ")  c #d69556",
        "_  c #d99a5c",
        "`  c #dfaa6e",
        "'  c #deaa7d",
        "]  c #878f98",
        "[  c #86929e",
        "{  c #8b939c",
        "}  c #90979f",
        "|  c #8694a1",
        " . c #8a96a1",
        ".. c #8d98a4",
        "X. c #939ba2",
        "o. c #939ea9",
        "O. c #86ae9e",
        "+. c #88bda3",
        "@. c #96a2ae",
        "#. c #9aa3ad",
        "$. c #97a4b0",
        "%. c #9aa6b2",
        "&. c #9ca9b4",
        "*. c #97b3af",
        "=. c #a0a09f",
        "-. c #a0a7ae",
        ";. c #a7a8a4",
        ":. c #a2abb4",
        ">. c #a3aeb8",
        ",. c #a8aeb4",
        "<. c #a6b1bc",
        "1. c #aab1b7",
        "2. c #abb3bb",
        "3. c #b2b8bd",
        "4. c #aab5c1",
        "5. c #acb8c4",
        "6. c #b3bbc3",
        "7. c #b1bdc8",
        "8. c #8dcea7",
        "9. c #8ecfa9",
        "0. c #a2c3b9",
        "q. c #b7c0ca",
        "w. c #bac3cc",
        "e. c #bdc7d1",
        "r. c #bec8d2",
        "t. c #c3aa90",
        "y. c #dfae85",
        "u. c #e9c38f",
        "i. c #e6d2ba",
        "p. c #f2dcaf",
        "a. c #c5c5c1",
        "s. c #c1c7cd",
        "d. c #c2cad3",
        "f. c #c9ced3",
        "g. c #ccd1d6",
        "h. c #cdd4da",
        "j. c #d2d7dc",
        "k. c #d2d9df",
        "l. c #d8dbdf",
        "z. c #d4dbe1",
        "x. c #dadee3",
        "c. c #d8e0e7",
        "v. c #dfe4e8",
        "b. c #e5e5e2",
        "n. c #e3e6ea",
        "m. c #e7eaee",
        "M. c #ececea",
        "N. c #eceff2",
        "B. c #edf0f3",
        "V. c #f0f2f5",
        "C. c white",
        "Z. c None",
        /* pixels */
        "Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.",
        "Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.3 3 3 2 2 2 Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.",
        "Z.Z.Z.Z.Z.Z.Z.Z.8 8 0 0 e r r 0 8 , , , > > Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.",
        "Z.Z.Z.Z.Z.8 8 8 r s s s s r r r r r r r 0 3 , $ , # # Z.Z.Z.Z.Z.",
        "Z.Z.8 8 8 r s s s s s s s s s s s s r r r r e e r r # Z.Z.Z.Z.Z.",
        "8 8 i d f f f f f f f d s s s s s s s s s s s s q i # Z.Z.Z.Z.Z.",
        "8 5.%.| C j f f f f j f f f f f d s s s s s e 9 a m # Z.Z.Z.Z.Z.",
        "8 r.c.c.z.w.>. .M f f f f f f f f f f s e 9 9 u m m # Z.Z.Z.Z.Z.",
        "8 r.N.C.V.m.x.k.d.q.%.| N i f d d d q 8 8 8 y m m m o Z.Z.Z.Z.Z.",
        "8 r.C.C.C.m.l.k.h.r.w.7.5.q f r C | 8 8 8 9 g B m m o Z.Z.Z.Z.Z.",
        "8 w.N.C.N.m.l.k.k.d.w.7.5.6 f 6 7.&.6 8 8 a m m m m o Z.Z.Z.Z.Z.",
        "8 7.n.C.m.m.z.k.k.r.w.7.5.3 M 3 z.&.3 8 y g g g B p o Z.Z.Z.Z.Z.",
        "8 4.x.N.v.v.k.z.h.r.w.5.5.2 M 2 k.%.2 9 a g g g f 8 o Z.Z.Z.Z.Z.",
        "8 4.x.j <.v.z.z.h.r.w.5.4.1 j 1 h.%.< y a a a g q 9 o Z.Z.Z.Z.Z.",
        "8 4.x.N.s.r X.k.<.d.q.5.<.1 N 1 r.%.< y p u a y 8 u o Z.Z.Z.Z.Z.",
        "8 <.x.5 X.n.2.4 [ r.7.4.<., N > 7.$.> y u u u * q m o Z.Z.Z.Z.Z.",
        "8 >.x.V.3.5 X.j.<.w.7.4.<., j , 4.@.> q q r * * a m X Z.Z.Z.Z.Z.",
        "8 >.x.$ o.x.2.4 { s.5.<.&., j , 4.@., 0 0 * * G g * * * * * * * ",
        "8 :.v.M.3.> X.j.,.w.5.,.*.% b + 0.o., 0 0 * Y - * p.u.` ~ I * Z.",
        "8 &.l.> } x.2.$ { q.5.<.+.+ v + 9.o.> 8 * G P * p.` ) Y * * Z.Z.",
        "8 &.x.N.3.$ X.g.:.w.2.,.S + c k 9.o., 8 * J ~ ` ) K * * Z.Z.Z.Z.",
        "8 $.x.$ X.x.2.$ ] 6.<.:.A + n z 9...> 8 * Q Y P H * o Z.Z.Z.Z.Z.",
        "0 @.x.m.3.$ } g.:.6.2.:.A + x z 9..., * * Y Y & ' R G * Z.Z.Z.Z.",
        "5 o.x.$ X.l.3.# ] 7.2.&.Z + l O 8. ., 8 * Q Y y.C.. R I X X X Z.",
        "6 o.l.n.2.> } f.-.6.,.&.O.% b + 0. ., * * ( _ _ M.: T / i.C.a.X ",
        "3 ..l.$ X.l.1.# ] 6.<.#.@.> ! ; 2. ., 8 * ` p.` _ U T ^ w . C.X ",
        "3 ] 7.l.l.> } f.-.6.<.#.o.> E F 2. ., * = _ ` ` ( U P t.a.=.M.X ",
        "3 s o.7.f.f.j.> ] 6.,.#.o.> E F <. .> * = P ( ( Q I P t.b.b.b.X ",
        "Z.3 8 r h 1.s.f.s.6.>.#.o., 7 o <.{ , * D * * * * * t =.;.;.X Z.",
        "Z.Z.Z.1 1 < i C :.,.-.#.#., r , 2..., * J I P - * Z.X X X X Z.Z.",
        "Z.Z.Z.Z.Z.Z.> > $ $ , 7 h , r > V M # * J W W L * Z.Z.Z.Z.Z.Z.Z.",
        "Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.# @ @ X o o X o o Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z."
    };

const char *
WxCasPix::m_refresh_xpm[] =
    { /* XPM */
        /* columns rows colors chars-per-pixel */
        "32 32 117 2",
        "   c None",
        ".  c #1c203a",
        "X  c #1e2252",
        "o  c #1e3249",
        "O  c #143959",
        "+  c #0c3c62",
        "@  c #242840",
        "#  c #213d5c",
        "$  c #353541",
        "%  c #34394c",
        "&  c #383e4f",
        "*  c #3d3e78",
        "=  c #0d4758",
        "-  c #04406c",
        ";  c #044777",
        ":  c #01556d",
        ">  c #09566b",
        ",  c #056078",
        "<  c #444451",
        "1  c #4a4a5d",
        "2  c #4c4c61",
        "3  c #515161",
        "4  c #5c5c6d",
        "5  c #53537e",
        "6  c #5f5f70",
        "7  c #636365",
        "8  c gray42",
        "9  c #636377",
        "0  c #727272",
        "q  c #3e3e8f",
        "w  c #014f85",
        "e  c #01528a",
        "r  c #025691",
        "t  c #0a5fae",
        "y  c #016495",
        "u  c #01649b",
        "i  c #01708d",
        "p  c #0168af",
        "a  c #016bb4",
        "s  c #0175a2",
        "d  c #017ca4",
        "f  c #0173ba",
        "g  c #127bb3",
        "h  c #017bc0",
        "j  c #6c7698",
        "k  c #018bb9",
        "l  c #0192bc",
        "z  c #0589ca",
        "x  c #019ac5",
        "c  c #0192d2",
        "v  c #0299d7",
        "b  c #019bd9",
        "n  c #0e94d2",
        "m  c #089bd8",
        "M  c #1b91cd",
        "N  c #1898d2",
        "B  c #01a3cf",
        "V  c #00a5d5",
        "C  c #02a1dd",
        "Z  c #1aa4db",
        "A  c #01a5e0",
        "S  c #01aae4",
        "D  c #01aee8",
        "F  c #0daee5",
        "G  c #01b1e2",
        "H  c #01b3eb",
        "J  c #02b8ef",
        "K  c #0cb0e7",
        "L  c #09b4eb",
        "P  c #01bcf2",
        "I  c #10aae1",
        "U  c #1eabe0",
        "Y  c #12b3e9",
        "T  c #19b3e7",
        "R  c #2597c5",
        "E  c #2398d1",
        "W  c #27abdf",
        "Q  c #36a8db",
        "!  c #21b3e7",
        "~  c #23b7e9",
        "^  c #2fb2e3",
        "/  c #2dbaea",
        "(  c #38afe0",
        ")  c #39bbe8",
        "_  c #01c1f5",
        "`  c #01c3f8",
        "'  c #45aedb",
        "]  c #48bae5",
        "[  c #77bed4",
        "{  c #4bc5ed",
        "}  c #4bd0f5",
        "|  c #59c6ec",
        " . c #5fd6f7",
        ".. c #78c0d4",
        "X. c #65c9ec",
        "o. c #6dcef0",
        "O. c #6bd4f4",
        "+. c #75cfef",
        "@. c #77d5f4",
        "#. c #8dcdec",
        "$. c #85daf6",
        "%. c #96d8e9",
        "&. c #93d3f3",
        "*. c #97ddf1",
        "=. c #84e2fb",
        "-. c #8be3fb",
        ";. c #8de8fe",
        ":. c #92e4fb",
        ">. c #92e8fd",
        ",. c #9ceafe",
        "<. c #a0e7fc",
        "1. c #a6ecfe",
        "2. c #a8e3f8",
        "3. c #abebfd",
        "4. c #b7edfc",
        "5. c #b9f0fe",
        "6. c None",
        /* pixels */
        "6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.5.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.",
        "6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.5.6.6.6.6.6.6.6.6.6.6.6.6.0   1 6.",
        "6.6.6.6.6.6.6.6.6.6.6.6.6.6.X.5.} % # @ X X + O o =       .   6.",
        "6.6.6.6.6.6.6.6.6.: : . . o ' 5.O.t i s a d d a d a p a a . O 6.",
        "6.6.6.6.. O + = : : i i s h o.5.O.d a a d d d a a p p a a . O 6.",
        "6.6.6.3 * d a a d a a a d f $.5.@.a d E 5.h d p p p p p a . $ 6.",
        "6.6.6.3 * d a a d a a d a z <.5.&.d d O.5.z a p p p p a a . $ 6.",
        "6.6.6.3 * a a a d d d a d n 3.5.&.a a &.5.m a p p p p a a . % 6.",
        "6.6.6.3 - d d a a a a a d Q 1.5.-.h a *.5.W a p p p a a a . < 6.",
        "6.6.6.3 - d d a a n z a a ^ 5.| 5.h f :.5.' f a a a f f f . < 6.",
        "6.6.6.3 - d d a f 5.| a a | 5.| 5.f l 5.2.X.f h h f f h f . 1 6.",
        "6.6.6.3 - d a a l 5.1.f a O.5.{ 5.l n 5.*.$.l h f f h h f . 2 6.",
        "6.6.6.3 * d d a m 5.5.m f =.5.' 5.l Z 5. .5.m h h f h z l . 3 6.",
        "6.6.6.4 * d d f ] 4.5.( l 5.5.) 5.z ( 5./ 5.! z M m Z ! ^ ` O.@.",
        "6.6.6.3 - d a f +.5.;. .m 5.^ ^ 5.m ) 5.T 5./ | *.<.5.5.5.1.6.6.",
        "6.6.6.4 ; f h N 5.[ | %.~ 5.W ( 5.L ..5.L 5.| 5.X./ ) R S > 5 6.",
        "6.6.6.` R ' | @.5.W ) 1.[ 5.Z ( 5.R X.@.v 5.5.5.W c b b c o 3 6.",
        "6.6.1.1.5.5.$.O.{ z Z 2.=.5.N ! 5.~ 5.| b  .5.3.L x c b c o 3 6.",
        "o.o.J _ g N M c l l v ,.1.%.b ! 5.) 5.} x } 5.,.S c c C B o 3 6.",
        "6.6.6.3 w z z z z z b =.5. .c U 5.} 5./ c / 5.O.S B D A A o 3 6.",
        "6.6.6.4 q z b b c c c [ 5.[ c E 5.[ 5.~ C E 5.} S S S S S o 3 6.",
        "6.6.6.3 : c b c x x c / 5.) C R 5. .5.Y A H 5.Y S A A K H O 3 6.",
        "6.6.6.3 e v b c c c c R 5.L A R 5.&.5.L F F H H H H H K H O 3 6.",
        "6.6.6.3 t c C B B B D D 5.S F I 5.>.5.H H H H K G P P U P O 3 6.",
        "6.6.6.7 i B A D A S S S S S A I 5.:.5.J H P U P P P P _ J O 3 6.",
        "6.6.6.5 r S S F F D K H H K H P 5.3.&.P U P P _ _ ` ` ` O.O 3 6.",
        "6.6.6.3 u A A H H H H H K P P _ 5.5. ._ _ _ ` J O.J O.J J . 3 6.",
        "6.6.6.6 u H H H G P P P G G Z V @.5.{ r , ; o X . .   % & 1 9 6.",
        "6.6.6.6 y P H x k a r : ; o . ; ..5.O.8 6.6.6.6.6.6.6.6.6.6.6.6.",
        "6.6.6.6.. . X < 7 0 6.6.6.6.6.6.#.5.6.j 6.6.6.6.6.6.6.6.6.6.6.6.",
        "6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.5.6.6.6.6.6.6.6.6.6.6.6.6.6.6.",
        "6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.5.6.6.6.6.6.6.6.6.6.6.6.6.6.6."
    };

const char *
WxCasPix::m_save_xpm[] =
    { /* XPM */
        /* columns rows colors chars-per-pixel */
        "32 32 134 2",
        "   c None",
        ".  c #093d5c",
        "X  c #2d440a",
        "o  c #344f0c",
        "O  c #36520c",
        "+  c #3c5b0d",
        "@  c #0b446b",
        "#  c #0b4771",
        "$  c #0c4c79",
        "%  c #6d0000",
        "&  c #770303",
        "*  c #7c0405",
        "=  c #41630e",
        "-  c #45690f",
        ";  c #476b10",
        ":  c #486d10",
        ">  c #4b7310",
        ",  c #527c12",
        "<  c #094e84",
        "1  c #0e568d",
        "2  c #075090",
        "3  c #0b5fa0",
        "4  c #135fa1",
        "5  c #12619e",
        "6  c #126aae",
        "7  c #1370b8",
        "8  c #317abd",
        "9  c #1479c6",
        "0  c #568313",
        "q  c #598714",
        "w  c #5c8c14",
        "e  c #5f9115",
        "r  c #629516",
        "t  c #679c17",
        "y  c #689e17",
        "u  c #6ba217",
        "i  c #6ba318",
        "p  c #71ab19",
        "a  c #76b41a",
        "s  c #78b61a",
        "d  c #7cbd1b",
        "f  c #7fc11c",
        "g  c #248ad6",
        "h  c #3191d9",
        "j  c #3b95d4",
        "k  c #2b9bea",
        "l  c #369ce6",
        "z  c #44a9f3",
        "x  c #57b4f9",
        "c  c #5bb6f8",
        "v  c #6baaec",
        "b  c #65b9f8",
        "n  c #6fbef9",
        "m  c #79afe9",
        "M  c #75b8f3",
        "N  c #77c0f6",
        "B  c #73c1fd",
        "V  c #880506",
        "C  c #8a0609",
        "Z  c #920609",
        "A  c #92080a",
        "S  c #990405",
        "D  c #9b0a0d",
        "F  c #a20a0d",
        "G  c #a40d10",
        "H  c #b50f13",
        "J  c #bc1318",
        "K  c #cb161c",
        "L  c #d31820",
        "P  c #c62d31",
        "I  c #cd3035",
        "U  c #d53f3a",
        "Y  c #e21d26",
        "T  c #ea212a",
        "R  c #f2232d",
        "E  c #f44b53",
        "W  c #f5585f",
        "Q  c #f5656c",
        "!  c #f56d61",
        "~  c #f66b71",
        "^  c #f57076",
        "/  c #81c41c",
        "(  c #85cb1d",
        ")  c #88cf1e",
        "_  c #8cd41f",
        "`  c #8fd91f",
        "'  c #95e025",
        "]  c #98e12b",
        "[  c #9be231",
        "{  c #9fe33a",
        "}  c #a2e43f",
        "|  c #a3e441",
        " . c #a7e54b",
        ".. c #ace754",
        "X. c #aee759",
        "o. c #b0e85b",
        "O. c #b5e967",
        "+. c #b6ea69",
        "@. c #b8ea6c",
        "#. c #bbeb73",
        "$. c #beec7a",
        "%. c #8dc7fa",
        "&. c #99cef9",
        "*. c #afd9fd",
        "=. c #b5daf9",
        "-. c #f7878c",
        ";. c #f88d91",
        ":. c #f89296",
        ">. c #f8a3a6",
        ",. c #c5ee87",
        "<. c #c6ee8a",
        "1. c #c8ef8e",
        "2. c #ccf095",
        "3. c #cff19d",
        "4. c #d3f2a4",
        "5. c #d6f3ab",
        "6. c #d8f4af",
        "7. c #daf4b4",
        "8. c #dff6bd",
        "9. c #c5e3fb",
        "0. c #d4eafd",
        "q. c #fbced0",
        "w. c #fbd4d5",
        "e. c #e3f7c6",
        "r. c #e6f8cb",
        "t. c #e9f9d2",
        "y. c #edfad9",
        "u. c #fde9ea",
        "i. c #f1fbe3",
        "p. c #f5fcea",
        "a. c #f3faff",
        "s. c #f8fdf1",
        "d. c white",
        "f. c None",
        /* pixels */
        "f.f.f.f.f.f.f.2 . f.f.f.f.f.f.f.* V Z Z F F H H f.f.f.f.f.f.f.f.",
        "f.f.f.f.f.f.2 M 4 . f.f.f.f.f.& A D G J L L Y K H H f.f.f.f.f.f.",
        "f.f.f.f.f.2 m *.B 4 . f.f.f.% % % % * C G Y Y Y T K H f.f.f.f.f.",
        "f.f.f.f.2 m 0.9.N x 4 . f.f.f.f.f.f.f.* Z H Y R R R H f.f.f.f.f.",
        "f.f.f.2 m a.a.0.n l h 4 . f.f.f.f.f.f.% V D R E ^ -.U H f.f.f.f.",
        "f.f.2 2 2 2 %.0.b g . . . . = + + + + % V S R W -.>.! H f.f.f.f.",
        "f.f.f.f.f.2 v =.c 9 . > p p p p p p p % V F R W -.w.! H - X X f.",
        "f.f.f.f.f.2 8 &.z 9 . e i p p p p p p % & F R W -.w.! H 0 e > X ",
        "f.f.f.f.f.= 2 j k 7 . w t y u u i % % % & F R Q -.d.! H 0 u w X ",
        "f.f.f.f.f.+ 2 3 6 5 1 . . . . w y % V P I I R ~ ;.d.! H H H H O ",
        "f.f.f.f.f.+ e 2 < $ # @ . . q r r r % V R W Q ~ :.u.d.d.! H > X ",
        "f.f.f.f.f.+ > > > > > > 0 r e e e e e % V R Q -.:.q.u.! H > e X ",
        "f.X X X X X X X X X X + = = > > > > > > % V R :.:.w.! H : w w X ",
        "+ r ] X.o.o.{ [ _ r = X X X X X X X X + > % V R >.! H - 0 0 0 X ",
        "+ ] 4.r.p.s.s.s.i.r.5.2.#.X.{ { ' s = X - > % V ! H = 0 0 0 0 X ",
        "+ f 5.r.r.r.r.t.t.y.p.s.s.s.i.r.7.1.) X O = > % V = > , , , , X ",
        "f.+ o.4.4.4.4.5.6.8.e.e.e.e.e.e.e.7.,.t X O = - = - - : > > > X ",
        "f.+ s 1.1.1.1.1.1.1.1.1.1.1.1.1.1.1.3.$.a X X X X X = - : > > X ",
        "f.f.+ } #.#.#.#.#.#.#.#.#.#.#.#.#.#.1.3.,.#.#...' w X = - > > X ",
        "f.f.+ u o.o.o.o.o.o.o.o.o.o.o.o.o.o.@.1.3.r.y.y.6.<.r X = : > X ",
        "f.f.f.+ ` } } } } | | | | | | | | |  ...+.O.+.O.+.+.' X = - : X ",
        "f.f.f.+ r ] ] ] ] ] ] ] ] ] ] ] ] ] ] ] ] ] ] ] ] ] ] X + = - X ",
        "f.f.f.f.O d ' ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ` ' e X = - X ",
        "f.f.f.f.O w _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ f X = = X ",
        "f.f.f.f.f.O a _ ) ) ) ) ) ) ( ) ( ( ( ( ( ( ( ( ( ( ( _ X O = X ",
        "f.f.f.f.f.O 0 ( _ ) ) ) ) ) ( ( ( ( ( ( ( ( ( ( ( ( ( ) > X = X ",
        "f.f.f.f.f.f.O p ) _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ d X = X ",
        "f.f.f.f.f.f.O > a _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ X O X ",
        "f.f.f.f.f.f.f.O , i d ( _ _ _ ` _ _ _ _ _ _ _ _ _ _ _ _ _ 0 X X ",
        "f.f.f.f.f.f.f.f.o o o o o o o > t p d ( ( ) _ _ _ _ _ _ _ i X X ",
        "f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.: : o O o X X X : e p d / ( w X f.",
        "f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.= X X X X X X f.f."
    };

const char *
WxCasPix::m_stat_xpm[] =
    { /* XPM */
        /* columns rows colors chars-per-pixel */
        "630 120 256 2",
        "   c #000000",
        ".  c #090A0A",
        "X  c #151618",
        "o  c #0A1513",
        "O  c #151729",
        "+  c #0D2E1A",
        "@  c #183836",
        "#  c #142F2A",
        "$  c #271434",
        "%  c #3A3B3B",
        "&  c #262C2F",
        "*  c #2E2013",
        "=  c #16354A",
        "-  c #32184D",
        ";  c #263946",
        ":  c #303152",
        ">  c #33356A",
        ",  c #232566",
        "<  c #184638",
        "1  c #164C2D",
        "2  c #1A6935",
        "3  c #325C2C",
        "4  c #36513A",
        "5  c #2E4E37",
        "6  c #3D641D",
        "7  c #346629",
        "8  c #2A6F33",
        "9  c #1E4B19",
        "0  c #194846",
        "q  c #155649",
        "w  c #135953",
        "e  c #0F4E56",
        "r  c #104770",
        "t  c #176746",
        "y  c #186754",
        "u  c #1A7657",
        "i  c #0E7549",
        "p  c #1B6667",
        "a  c #264647",
        "s  c #265857",
        "d  c #374648",
        "f  c #384655",
        "g  c #2C5150",
        "h  c #394877",
        "j  c #385976",
        "k  c #30536B",
        "l  c #266859",
        "z  c #24775A",
        "x  c #296E4A",
        "c  c #296765",
        "v  c #287765",
        "b  c #396768",
        "n  c #3A6575",
        "m  c #397369",
        "M  c #306F75",
        "N  c #533533",
        "B  c #733112",
        "V  c #72352A",
        "C  c #59221A",
        "Z  c #4D1972",
        "A  c #5A3958",
        "S  c #4D344F",
        "D  c #4E3470",
        "F  c #66355A",
        "G  c #762A49",
        "H  c #772954",
        "J  c #6E324F",
        "K  c #6D366D",
        "L  c #52195A",
        "P  c #4E4337",
        "I  c #75493A",
        "U  c #6E4934",
        "Y  c #615719",
        "T  c #454444",
        "R  c #575559",
        "E  c #514853",
        "W  c #484678",
        "Q  c #44577A",
        "!  c #574766",
        "~  c #584775",
        "^  c #54546B",
        "/  c #565473",
        "(  c #484C68",
        ")  c #4B6B71",
        "_  c #6A4A4B",
        "`  c #634878",
        "'  c #6C4870",
        "]  c #717274",
        "[  c #586D50",
        "{  c #3A3787",
        "}  c #3D1797",
        "|  c #394A84",
        " . c #385384",
        ".. c #334B93",
        "X. c #3650A2",
        "o. c #34708B",
        "O. c #22699F",
        "+. c #1B76C4",
        "@. c #4D178A",
        "#. c #4D328D",
        "$. c #5A37A3",
        "%. c #721990",
        "&. c #7C14A7",
        "*. c #71318E",
        "=. c #6C31AC",
        "-. c #773ACB",
        ";. c #484688",
        ":. c #474995",
        ">. c #495497",
        ",. c #574987",
        "<. c #594895",
        "1. c #545687",
        "2. c #4C558A",
        "3. c #564CA8",
        "4. c #486D88",
        "5. c #4A6FB0",
        "6. c #654887",
        "7. c #674B97",
        "8. c #675289",
        "9. c #695795",
        "0. c #794687",
        "q. c #775194",
        "w. c #6C4CAB",
        "e. c #736D8F",
        "r. c #6C67B1",
        "t. c #536FCE",
        "y. c #6D4AC8",
        "u. c #6C6CCE",
        "i. c #707AE2",
        "p. c #5769D1",
        "a. c #248339",
        "s. c #239C32",
        "d. c #078146",
        "f. c #278451",
        "g. c #2D826D",
        "h. c #2EA45F",
        "j. c #63A433",
        "k. c #708676",
        "l. c #5DA25A",
        "z. c #43FC3F",
        "x. c #77C236",
        "c. c #50C41F",
        "v. c #55D455",
        "b. c #368789",
        "n. c #388FB2",
        "m. c #14A0A6",
        "M. c #39A6D2",
        "N. c #2B97CC",
        "B. c #0ACFEF",
        "V. c #788788",
        "C. c #558CA8",
        "Z. c #4B93CC",
        "A. c #44A1D1",
        "S. c #47A4E5",
        "D. c #7091E6",
        "F. c #73ABE4",
        "G. c #6B99D4",
        "H. c #4CD8B2",
        "J. c #96173B",
        "K. c #8A3B17",
        "L. c #923330",
        "P. c #A61C3A",
        "I. c #B9273C",
        "U. c #AC3038",
        "Y. c #A6251A",
        "T. c #971949",
        "R. c #86244B",
        "E. c #89385A",
        "W. c #983A5A",
        "Q. c #8F2D50",
        "!. c #973A65",
        "~. c #893872",
        "^. c #A11547",
        "/. c #AE2E49",
        "(. c #A93A67",
        "). c #B03970",
        "_. c #954715",
        "`. c #914510",
        "'. c #904930",
        "]. c #976431",
        "[. c #AB4E12",
        "{. c #A94A2A",
        "}. c #B74B2A",
        "|. c #B5512C",
        " X c #AD6E36",
        ".X c #A37209",
        "XX c #91474B",
        "oX c #86467C",
        "OX c #924470",
        "+X c #AC4C54",
        "@X c #B84875",
        "#X c #B0456C",
        "$X c #B37846",
        "%X c #916F59",
        "&X c #CA3230",
        "*X c #E03027",
        "=X c #C8334D",
        "-X c #C93C77",
        ";X c #C85332",
        ":X c #DA6F2C",
        ">X c #C94F47",
        ",X c #C44477",
        "<X c #CC4371",
        "1X c #C47C46",
        "2X c #891B9B",
        "3X c #8F19AB",
        "4X c #8F3191",
        "5X c #8F2AAD",
        "6X c #A41AB6",
        "7X c #A13188",
        "8X c #A223AA",
        "9X c #980FCD",
        "0X c #9429CB",
        "qX c #A916D1",
        "wX c #A822D9",
        "eX c #854686",
        "rX c #885187",
        "tX c #894D92",
        "yX c #8445A2",
        "uX c #A84684",
        "iX c #8D7398",
        "pX c #8954D9",
        "aX c #8E6DDC",
        "sX c #906BE2",
        "dX c #B24DE9",
        "fX c #A55CDC",
        "gX c #CC3884",
        "hX c #C54581",
        "jX c #AE9325",
        "kX c #A6905F",
        "lX c #86C63B",
        "zX c #8CCA4A",
        "xX c #F1B90B",
        "cX c #DEA023",
        "vX c #D08C4D",
        "bX c #D8A265",
        "nX c #F1D107",
        "mX c #F1D52D",
        "MX c #EFD648",
        "NX c #8B8E8F",
        "BX c #9496A6",
        "VX c #ACACAC",
        "CX c #9FA19E",
        "ZX c #8AB7E8",
        "AX c #93ACD8",
        "SX c #9BE898",
        "DX c #99C4ED",
        "FX c #AFD2F4",
        "GX c #B4D3EC",
        "HX c #CAB39B",
        "JX c #E7D9AC",
        "KX c #CECECD",
        "LX c #CDE9FC",
        "PX c #FCFCFA",
        "IX c #E8F1F5",
        "UX c #DEE1DD",
        /* pixels */
        "H G H H T.~.T.2X).7XOX#X).).~.).).).).).).^.2X~.!.Q.!.Q.R.T.R.~.~.!.(.(.(.!.^.(.!.(.T.~.!.!.!.(.!.!.~.(.!.~.~.K K OX~.4XoXoXeXeXeXoXoXeXtX4XoXeX~.uX4X' ~.4XoX~.K eX~.' ~.K ' ~.eXoXeXeXeXeXeX0.K K K ' K 0.' K ' ' 0.0.K K K eXoX' ' oX' rXoXoXoXrXrXoXiXOXrXrXrXrXOXrXrXoXoX%XrXoXoXoXoXoX%Xq.rXrXoXrXrXrXrXrXrXrXoXOXOXOX4XOXoX~.~.K ~.H K K K H K H K K F H K ~.~.oX' K eXK eX' ~.0.eX~.' ' eXoXoXK *.D K D D D D D *.*.7.*.*.0.*.*.6.D *.~ #.` *.~ ~ 6.K *.#.K 0.K 0.*.*.K D D K K K D K K D ~ K ,.D D ,.D D ~ #.,.D W D #.~ #.~ W ,.W D ;.W D D ;.W D ;.W W ( h W k Q h h j h j  .j | r > | ..................r r { ....{ r p O.p p p p ..r p ............r ......r | > r > r > r .. .| 2.| | ;.| | | Q h Q 2.h | #.{ #.{ { { { { > #.{ > #.} #.#.<.<.:.$.:.#.$.$.#.#.#.#.$.} $.} } } } } } } } @.} } @.} @.} #.#.} @.} @.@.} } { > @.Z Z Z } Z } Z } @.@.} } &.@.} @.@.@.} &.} &.@.@.%.@.@.@.Z Z Z @.Z Z Z Z @.@.Z Z Z @.Z Z Z Z Z Z Z Z Z Z Z Z Z Z L - L Z L - Z Z L Z - L Z Z #.Z *.#.D *.#.K @.Z #.K @.K #.*.@.Z @.Z @.Z @.Z Z @.%.Z Z %.@.=.$.@.=.$.$.$.=.} -.&.=.} -.-.&.} =.$.=.=.=.=.$.$.$.$.=.=.=.=.y.3.-.p.w.y.r.w.y.y.y.w.y.y.w.y.y.-.y.-.y.-.-.-.-.-.-.=.-.-.$.=.-.-.-.-.y.y.-.y.pX-.y.y.y.y.y.y.sXpXpXpXpXpXpXpXpXwXpXpXpXpXpXr.sXsXfXsXpXfXfXsXsXsXdXpXwXpXdXdXdXwXwXdXdXdXdXwXdXdXdXwX",
        "H H ~.^.~.T.T.(.).#X).7X).).).).~.).).~.).~.(.Q.Q.!.Q.~.~.Q.!.4XeX~.(.(.).^.(.!.(.!.!.~.(.~.!.~.(.!.(.!.(.K ~.~.~.~.oXK 4X' ~.0.~.*.eXK K eXeXoXoX4X~.eXeXK 4X' ~.oX' 4X~.eX4X' eXeXK oXoXrX' ' K ' K ' eX0.' 0.' eXtXq.0.' K ' ' oX' ~.0.%XoXrXrXoXoXrXOXrXrXuXrXOXrXOXoXoXoXoXrXrXoXoXoXoXq.tXrXrXrXrXoXrXrXrXrXrXrXoX~.' ~.oX~.K ~.~.K ~.H K K K H ~.K H K Z K ' 4XoX0.eXK K ' 4XeXK K oX4XoXeX~.oX*.*.K K *.*.K K *.6.*.*.0.6.*.*.6.D *.~ *.` *.~ *.*.~ 6.D K *.*.K ` *.*.K K K 6.<.6.6.,.1.,.6.D ~ *.~ ~ *.~ *.~ D ~ #.W W W W D W D ;.;.D W ;.W ;.W W W W W W Q k k h j h h h h h h h | h | ........{ ..{ ........r ..r ....p r p O.p p o.M ..O.......O...O...r  . .| h r > ..> h > h | | | |  .M Q W h 2. .W Q 2.#.{ { #.#.{ { #.} { { #.#.{ #.<.<.$.<.#.$.:.#.<.:.#.$.{ { $.$.{ } } } } } } } @.@.} } @.} @.} @.} #.#.} } #.@.@.} @.} } Z } @.@.} Z } &.&.} } &.} &.@.@.@.} @.@.@.@.@.@.%.@.@.Z @.Z Z @.@.Z Z Z Z @.Z @.Z @.Z @.Z @.Z @.Z Z Z Z Z L L Z , Z Z Z Z - > Z Z Z Z D D D D Z D Z Z *.D *.*.@.*.D @.Z Z *.K @.Z %.Z %.%.Z Z %.@.@.$.$.$.$.=.$.$.$.$.=.} =.&.-.=.} &.-.=.$.=.$.=.=.=.$.=.=.3.p.y.=.=.y.r.y.p.y.y.p.3.y.y.3.y.w.w.-.-.y.-.=.-.y.y.-.=.-.-.-.-.-.-.-.-.=.-.-.-.y.0Xy.y.y.-.u.y.pX-.pXpXpXpXpXpXpXpXpXpX-.pXpXyXpXpXsXsXsXsXsXfXsXsXfXdXsXpXdXpXpXdXdXfXdXdXdXdXwXdXdXgXdXdXdX",
        ").7X~.2X7X^.!.7X).7X).7X~.~.).).).~.).T.).).).!.~.Q.Q.Q.W.~.~.eXeXuX~.).).(.!.(.(.!.(.!.(.!.(.!.~.!.).!.(.K K ~.~.eX' ~.' ~.0.~.oX4X~.eXoX~.oXeXeX7X' ~.~.oXK oX~.*.*.' 0.oX~.0.oXeXeXeXeX0.' 0.' K ' ' 4X' eX' ' q.tXq.0.q.' ' oX' oXoXoXoXoXoXoXoXrXrXoXrXoX%XrXoXrX%X%XrXoXoXoXoXoX%XoXrXq.rXrXtXrXrXrXrXrXrXrXrXtXrXoXeX~.oXoX4XeXK K K ~.K K H K K K K H K ~.4X~.eXtX0.*.oX' oX' 4XK eXK eXeX0.oXK *.*.*.6.K D K *.*.*.0.*.*.0.0.*.*.~ D *.*.K ,.,.~ *.6.*.*.K K *.K ' *.K D K ` 6.8.~ ` ,.,.,.~ *.D ,.D ,.,.D ,.D W W D #.#.W ,.;.W W ;.D D ;.W D W W D ;.W k k h ( k Q k j h h h h  .| h | .............. .k r ....{ ..{ .. .p p p o.c n c o............... . ...O. .r r > h r h h k h ;.;.j m m m h Q h | Q Q ;.X.$...X.#.{ { { > #.{ { > <.<.,.<.<.<.#.{ $.#.:.$.$.{ $.$.{ } #.$.} } } $.} @.@.@.} } $.@.@.@.} } @.@.#.@.{ } { , @.{ Z } @.> } @.@.@.} } &.&.} } &.@.@.@.@.@.&.&.@.@.@.@.@.Z Z @.Z @.@.Z @.@.Z @.Z @.Z @.Z Z Z Z Z @.Z Z Z Z Z Z Z Z Z Z L Z - L > Z Z Z Z Z Z #.#.D @.@.Z #.Z Z #.#.Z D %.*.@.@.@.@.Z Z @.%.Z Z %.Z %.@.$.%.#.#.$.$.$.$.$.$.$.-.-.&.} =.-.$.=.$.=.$.=.$.=.$.$.$.} p.p.p.$.3.y.p.r.p.y.p.y.y.u.r.y.w.y.y.w.-.-.y.=.y.-.-.y.-.-.-.y.y.-.-.-.-.=.y.-.-.-.y.y.pX-.y.y.y.u.-.sXpXpXpX-.pXpXpXpXpXsXpXpXpXpXpXsXsXfXsXpXsXfXdXsXfXsXfXpXdXdXpXdXdXdXwXdXdXdXwXfXdXdXdXdX",
        "(.T.).^.!.~.).).#X7X).).).).).~.).).).7X7XT.).~.R.~.!.!.~.eX~.eXeXOXrXOX(.(.^.).T.(.!.!.~.(.~.~.(.!.~.!.!.~.~.~.~.' 4XK ~.eXoXeX0.0.0.eXoXoX4XeXeX' *.oXK oX*.~.oX~.oX~.*.oXoX~.K eXeXeX0.*.' K 0.` *.eX' 0.0.eXq.tXtXq.q.rXrX0.' oX' oXoXoXoXoXrXoXrXOXoXrXrXtXrXrXrXoXrXrXoXrXoXrXrXrXoXtXrXq.q.rXq.rXoXrXq.rXq.tXtXeXeXtXtX4XoXeXK ~.~.K K K ~.K K K K K H K ' eXeXoX0.0.' eX~.*.' oXoXeXeX~.oX~.oXeXK 6.*.*.0.#.*.7.7.*.*.7.7.*.*.6.0.*.6.~ ~ 6.*.~ 6.` ,.~ ` *.*.K *.*.K K K K ~ ` ` 6.` 6.6.,.1.~ 6.D ,.D D ,.D 6.D ,.;.~ W ,.D W ~ #.W ;.;.D W W D W W W W h ( h h j j j j h | j h h h | h ............r r | k ..| ..r ....r p O.p M c c c ................r O. .r  .o. .r r > h k j n  .M m M ) m b 2.;.Q Q  .j #.{ { #...#.> { { { D #.<.<.:.$.#.#.<.$.$.#.$.$.#.#.#.} { } $.#.} @.$.} } } @.} } } } @.@.@.$.} $.@.@.} @.} @.@.@.@.@.} #.@.@.@.} @.@.@.} &.} } &.} @.@.@.@.@.@.@.@.%.@.@.Z %.@.Z @.@.Z @.@.Z Z Z { @.Z Z Z @.@.@.Z Z Z Z @.Z Z Z Z - Z Z Z Z Z Z Z > L L - Z Z K Z #.D *.D K #.*.*.D *.#.*.Z K @.K %.Z %.Z %.@.%.Z @.Z @.#.#.$.$.$.$.$.$.$.$.$.&.} =.=.} } -.$.=.$.y.=.y.$.=.=.y.y.p.p.p.p.p.p.y.y.y.r.w.y.r.y.y.y.y.w.w.-.y.-.-.-.-.y.$.-.y.y.=.y.y.$.y.=.-.-.-.-.-.-.-.-.-.-.y.u.u.pX-.pXi.pXpXpXpXpXpXpXpXpXpXpXpXy.aXfXsXsXsXsXfXsXsXpXsXsXfXdXdXdXdXdXdXdXdXdXdXdXdXdXdXwXdXdX",
        ").2X~.).).).7X7X).).7X~.).).).!.~.).).^.7X).~.T.!.W.!.oXeXeXuXoXoX4XOXeX~.(.(.(.).~.!.~.(.!.(.(.).!.!.~.(.~.eXeXeX~.' eX*.0.tX*.eX' eXeXK eX*.oXeX' 0.' eX4XoX~.~.' 4XoXeX~.eX~.eXeXeX0.' ' ' 0.' 0.0.oXeX0.0.tXq.tXtXtXiXtXtXrXeXeXeXoXoXoXrXrXoXoXrXoXrXrXrXrXoXrXrXrXiXoXoXoXrXoXoXoXrXrXrXtXtXq.q.tXrXrXrXe.q.tXq.rX4XtXq.tXeXeXK ~.K ~.K *.K K K K H K K 4XeXeXeXeXeX0.eX' eX0.' 4X0.oXeXeXoXeXoX4X0.*.6.*.*.*.7.*.0.*.0.*.*.*.0.*.q.*.*.6.~ ~ ~ *.6.6.6.~ Q #.*.*.*.6.D K *.K K ,.6.~ ` 6.1.~ ,.,.D 6.D ,.,.D ,.D D W ;.W W ~ D ;.W W W D D ;.W W ;.W Q W h h h k j n c j j | h | h h ..h r ..........r r r j  .k r | ....p p p o.k M c j e O.............r ..k r O. .p O. .h k  .j M n m m n m m m ) b Q Q j Q Q ..{ #...#.#.> #.{ { > <.<.:.<.#.<.<.$.#.{ $.#.#.$.{ #.#.} #.#.} $.} @.} } } @.} @.@.@.} @.} @.#.} #.@.@.@.@.@.@.@.} @.@.@.@.@.@.Z { @.@.} @.&.&.} &.&.@.@.@.{ Z @.@.@.%.@.@.Z @.@.@.Z @.Z @.Z Z @.{ @.> @.Z @.Z @.Z @.Z Z Z } Z Z , Z Z Z Z Z Z D Z Z > > - L Z D Z *.D @.K Z *.D D *.#.#.K @.@.@.Z @.Z Z @.@.%.Z Z Z %.#.#.#.$.$.$.X.$.:.$.$.$.} =.=.=.-.=.=.$.=.$.$.=.$.$.-.$.$.p.p.p.p.y.p.r.p.w.p.y.p.y.p.y.w.y.y.y.w.-.w.y.y.-.-.-.y.-.y.-.y.X.y.y.$.y.-.$.-.-.-.-.-.-.-.-.i.i.i.p.-.pXpXpXi.pXpXpXpX-.pXsXi.pXpXdXsXsXsXpXsXfXpXsXsXfXsXdXfXsXdXfXdXwXdXdXdXdXdXdXdXdXdXdXdXdX",
        ").^.).).T.7X).).(.L.V ).).~.(.(.^.).(.(.(.).).).~.eXeXuXeXrXoX4XuXeXoXoX7X(.(.!.~.).(.!.(.!.~.(.~.(.OX).!.eXeX~.4X' K eXeXeX0.eX0.4X0.0.4XtXeXeX*.6.*.6.0.K K 0.~.oX' 4X' 4X' 0.0.eX0.' ' 0.0.' 0.0.' 0.0.rXtXq.yXq.tXiXtXrXrXtXrXrX' oXoXoXOXrXoXiXoXrXrXOX@XrXrXOX@XrXoXoXrXoXoXoXrX' rXtXq.tXq.tXtXtXtXq.rXtXiXtXtXrXtXtXyXtXtXyXtX*.*.K K 4XK K 4XK K K 4X' ~.eX*.eXq.0.0.rX' eXoX0.' eXeXK ' oXoX' 0.*.7.6.6.0.0.6.8.7.q.8.q.0.*.0.q.*.` *.*.*.6.` D 6.*.|  .W ~ 6.K K *.K K D ` 6.` 6.` 6.6.,.,.,.,.D ,.D D ~ D ,.,.,.D ,.W #.,.;.W ,.;.D | D W W W h Q h j j k n M j j n j j | | k j p  .p ......r r h j ..k r  .| p r j p r p j k b n c p ..........O...O.....O.r  . . .j  . .j  .n n m M m M m ) g.m Q j Q Q W :.$.{ #.#...{ #.> ;.<.<.<.,.<.<.$.#.:.$.$.$.$.{ } $.} #.#.} #.X.} #.$.} $.@.} @.} $.@.@.@.@.@.@.@.@.@.} #.@.{ } { Z { @.@.@.{ > } Z Z } &.} } } } @.} @.@.@.{ > @.@.} %.@.@.@.@.@.@.@.@.} Z } } Z Z } } @.#.Z @.Z @.Z @.Z } Z Z Z Z Z Z Z Z > L - - - - D ~ D Z Z D Z #.#.D #.D @.*.*.Z %.D D @.Z %.Z %.Z %.Z %.Z %.@.;.#.{ $.:.:.$.#.{ #.$.#.$.=.=.$.=.=.=.$.y.y.=.=.$.=.-.$.$.p.p.p.p.p.r.u.u.u.p.u.w.y.r.y.w.r.y.w.y.y.w.y.-.-.y.-.3.-.-.$.-.y.y.y.y.y.y.y.-.=.-.-.-.-.-.y.i.i.D.i.i.pXi.pXpXpXpXpXpXpXsXpXi.sXi.i.sXsXdXsXsXfXsXsXdXfXfXfXsXsXsXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXfX",
        ").).).~.).7X7X).V B V (.7X!.!.(.7X).).(.).7X^.).uXeXoXeXoXeXrXoXeXOX~.eXeXOX).).(.(.~.~.~.(.~.!.(.OX(.!.!.uXeXeX0.eX0.4X0.eXeX0.eX0.0.4X0.' eXeX0.' 0.*.0.0.eX~.*.oXeXK 4X' eXeX0.eX' 4X*.eX0.0.0.0.0.q.q.tXtXe.tXiXtXtXtXtXtXtXrXtXrXrXrXrXoXrXrXrXoXoXrXoXiXoXOXiXrXoXoXoXq.rXrXoXiXrXtXtXtXrXrXtXtXq.tXyXtXtXtXtXrXeXyXq.yXtX0.yXtXyXtXyXtXq.4X0.K 0.K oX' 4X4X' ' 0.0.' eX0.eXeX0.oXeXeXeXeX4XoXoXoXeX0.0.0.0.7.6.q.7.0.0.8.8.' / ' 6.` ` ` ~ ~ ~ 6.*.,.W j  .;.Q ;.,.*.K *.*.K ,.6.6.` 6.~ ` 6.,.1.,.~ D 6.#.~ #.W W W W / / ;.W D ;.#.W W W W | W j h | W j k n j k j M k p M k p  .k M k k ......M  .k  .r  .k k c c c p  .M j n n n c n c ......O...r .... ... . . .O.k M M  .j M M m M m m M m m m m ) Q Q Q  .2.{ :.:.:.:.;.;.>.<.<.<.<.,.:.$.$.$.#.$.$.{ :.$.#.#.} { { { #.} } #.#.#.@.@.@.} } @.@.$.@.@.@.@.#.@.@.#.} > @.D @.D @.@.@.#.#.} > } { @.@.} } @.&.} } @.@.> { { > { @.@.@.%.@.@.@.@.Z @.} @.@.} } Z @.@.Z @.Z @.#.@.Z Z } Z Z Z Z Z Z Z Z > Z - - Z K 9.AXAX9.L D Z D D D Z Z #.#.K D *.Z *.*.Z Z %.@.Z Z @.Z Z %.%.@.#.:.:.3.:.>.#.#.{ ' %X#.$.=.=.=.$.$.=.-.$.$.=.$.$.$.-.y.3.p.X.p.p.p.u.u.p.u.r.r.p.p.y.y.u.y.r.y.w.y.y.y.y.y.-.y.-.-.-.-.y.p.y.y.$.y.-.-.-.-.-.-.-.-.i.i.S.i.i.i.i.i.-.-.pXpXpXpXpXpXpXi.sXD.i.AXsXsXsXsXsXfXsXsXsXpXsXsXdXdXsXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXfX",
        "^.2X).OX).).(.C C B L.W.B C B B C C C C ~.).7X4XuXeXeXuXeXuXeXoXoXoXuXeXOXoX~.#X~.).(.(.).!.(.!.!.(.!.(.!.~.eXeXeXeX0.' eX0.0.0.0.0.0.0.0.eX4X' *.0.0.K 6.` 0.*.~.' 4X~.eXeXK eXeX' 0.' 0.' ' 0.' 0.rXe.q.tXtXtXtXyXiXtXtXiXtXtXrXrXrXrXrXrXrXoXiXOXiX@XrXrXoXrXrXoXrXrXoXiXrXrXrXoXe.rXq.e.tXq.q.tXq.iXq.iXw.e.e.q.tXyXyXtXyXq.yXyXq.yXyXyXyXtXeX*.4X0.eX*.eX' ' 0.4X0.0.0.] 0.0.eXrX0.eX0.0.eXoXeXeXoXoX0.*.7.7.8.0.7.0.8.6.q.8./ / / ^ ^ ^ ^ / / ^ ^ ^ / / / W / W / Q ~ ,.K ` K K ,.` 6.` 6.6.` ~ ,.,.~ #.~ W W ~ ~ W ;.W Q W W ~ ;.W ~ W W h W W j W W Q h j n c M p v c M M c M k p  .k  . .p  . .r r j r | k p c c l l c M k b c c b n c p ..............r O. ...p O. .M  . .M M M M n m M n m m ) m m m n Q Q Q j :.:...X.:...:.<.<.<.<.;.<.<.:.#.:.#.#.#.$.} #.} :.$.{ #.} } #.{ } } { $.@.} @.$.@.@.@.{ D D #.> #.D #.#.#.#.@.D } { @.@.} } #.@.@.{ @.@.%.} &.} @.@.@.> > > > { > > @.@.@.@.@.@.@.@.@.Z @.@.@.> } > } } Z @.Z @.Z @.@.Z @.Z Z , Z Z , Z Z - - D e.AXFXGXZ.Q , > #.#.Z D *.*.D Z @.D Z #.K Z #.Z Z Z Z %.Z %.Z Z Z #.:.<.:.:.#.:.{ D ,.%X%X:.$.} $.$.=.$.$.$.$.$.$.$.-.3.$.$.p.p.p.p.y.p.r.u.p.y.p.p.p.p.r.p.w.p.y.y.p.p.y.y.-.y.y.y.-.$.-.y.p.y.y.y.p.y.$.y.$.-.+.-.-.-.i.t.i.i.t.i.D.i.i.sXpXpXpXpXsXpXpXi.i.i.sXi.i.sXi.sXsXsXpXsXsXsXsXsXsXsXdXfXdXdXdXfXdXdXdXdXdXdXdXdXdXfXfX",
        "gX).7X).).OX(.B ]._.B I JXJXbXbX1X|.B Q.).).7X~.eXeXOXrXeXeXeXOX~.eXOXoXOXOX~.!.!.(.!.(.!.).(.!.!.!.(.OX#X' eXeX0.0.yX0.0.eX*.eX0.0.0.0.0.0.0.*.0.' 0.0.K *.6.` ' ~.0.' 4X0.' eX' eX0.0.eX' eX' 0.q.q.e.tXtXtXtXq.yXtXtXtXiXuXtXrXrXrXrXrXrXoXiXOXrXrXrX@XrXoXiXrXrXrXrXrXrXtXrXrXq.iXq.tXtXq.q.iXtXq.iXyXr.iXe.yXq.yXyXyXyXtXtXyXtXq.yXyXyXeXyXyXeX4X0.0.4X0.0.eX0.0.0.0.' 0.0.rX0.0.eX0.eX0.0.0.eXoXoXeXeX0.0.8.7.0.8.8.0.8.8.0./ ] ^ ^ / ' ^ / ^ ^ ^ ' / ^ ^ ^ ' ^ ^ ^ ] / ~ #.K ` 6.6.6.` 6.` ` ` ,.,.W W W #.W W W W W Q W W Q ,.W W W W W h j Q W j h Q h j p v M v p M c p c p M k  . .p r k  . . .p  .r n c p c l s b ( b j n b j c b k j .................. . . . . . .M  .M n n n M m m M ) m m ) m m ) Q j Q j 2. .2.| :.;.<.<.<.:.<.<.<.:.<.#.<.#.$.$.} #.#.} $.} #.#.} } #.@.{ } { } { #.#.> W D > W #.D > D #.D { @.#.@.{ { Z #.Z #.#.} #.{ #.Z { @.@.@.@.@.@.@.Z > > > > > > > { Z @.@.@.@.@.@.@.@.@.@.@.} Z @.Z @.@.@.@.@.Z Z @.@.@.Z Z Z Z Z Z , L - D BXFXZXZ.+.5.h L Z D D D Z #.Z D #.D K K #.#.Z Z Z @.Z %.Z %.Z %.Z #.:.:.#.:.#.:.{ > W %X$XXXW ;.$.$.=.$.$.$.$.3.$.$.$.3.3.$.p.p.p.p.y.p.y.p.p.p.u.p.r.y.y.p.r.p.3.p.u.y.y.u.u.y.y.-.y.-.y.y.y.y.y.p.y.y.y.y.$.y.y.t.t.p.i.i.i.p.i.t.D.i.S.i.i.i.pXpXi.y.y.sXi.i.D.sXi.i.D.sXaXaXi.pXsXsXsXsXpXsXaXfXfXfXsXdXdXdXdXdXdXdXdXdXdXdXfXiX",
        "7X).7X).#XE.B B _.K. XJXbXvXvX_.B C (.~.4XoXuXeXeXuXoX4XuXoXeXuXoXeXuX4XrXoXuXOX!.~.!.!.!.!.!.(.!.(.!.(.!.4XeX0.eXeX0.eX0.0.tX0.0.4X0.q.0.0.0.0.*.0.0.` 0.6.0.0.6.0.eX0.oX0.eX0.eX' 0.eX0.0.0.q.8.tXrXq.r.tXiXtXtXiXyXiXyXiXyXiXrXiXuXrXrXoXrXuXrXrXoXoXrXrXOXoXtXtXrXq.rXrXrXrXrXtXq.tXq.q.tXiXq.q.q.q.e.yXq.tXr.iXq.yXyXyXyXyXyXyXyXyXyXq.4XyX4XeX0.eX*.' ' *.*.0.*.0.0.0.0.' 0.0.0.q.0.eX0.4XeXoXoX0.0.0.7.*.7.0.7.0.0.9.q.8.8.^ ^ ^ / ^ ^ ^ ^ ^ ^ ^ ^ ^ / / ^ ^ ^ ^ ^ ^ ` ~ ` ,.` ~ ` ' 6.` ` 8.6.~ ,.;.,.W / W 2./ W / ,.W / W W W ,.;.W j j j k Q W j j Q j v v v v M v M M M n j M p j  .c c M r r  .p k c c c c c l b b ( b b b b n b b M c n j p j p O.M  .p O.p O.n k  .n n b M b b M n m n m b m m m m n ;.Q Q h  . . .n  .o.2.<.,.<.<.;.,.<.<.#.#.#.{ $.$...{ } #.} { #.X.{ { { { > #.> D > D D #.D D D D #.{ D #.Z > D #.Z @.#.@.#.#.} D } @.} } @., Z } @.Z @., , Z , > > > > { > , @.@.@.@.@.@.@.@.@.} @.@.@.@.} } Z @.Z @.@.} @.} Z Z , , Z Z , Z - D BXDXZ.+.+.N.5.: - > > Z D D D *.Z Z K @.Z Z K @.Z Z Z Z Z Z Z Z Z Z ;.:.;.:.:.;.{ > D ' ].kX].W D $.#.$.$.=.$.$.<.3.w.3.3.3.y.p.X.X.p.X.p.p.3.p.w.3.p.r.p.5.3.p.y.p.y.r.p.r.y.y.y.p.r.y.y.y.y.3.y.y.y.y.$.y.y.-.-.y.t.t.p.p.i.i.i.i.i.i.i.i.p.i.p.u.pX-.sXi.D.aXsXsXi.sXsXsXi.D.aXaXAXsXsXsXsXsXsXaXaXaXsXsXdXsXdXdXdXdXdXdXdXdXdXaXfX",
        ").).).).7XE.B `.:XvXbXvX`.B B V !.(.).uXeXrXuXeXeXeXuXuXOXrXeXuXOXuXeXOXOX~.eXeXuX~.!.!.~.#XOX!.!.!.!.!.!.eX0.0.q.0.0.tX0.0.tX*.7.0.*.0.0.0.6.0.0.0.K *.K 6.6.6.6.0.0.' ' ' 4XeX0.' 0.' 0.0.0.' q.q.tXe.yXe.yXiXyXtXiXyXuXyXyXiXtXrXOXrXuXiXoXrX@XrXoXrXrXrXiXrXrXe.rXe.q.rXe.rXtXq.tXq.tXiXq.tXq.tXyXe.iXq.e.yXq.iXtXyXyXq.yXyXyXq.yXyXyXq.4Xw.w.yX*.*.*.0.0.4X0.0.0.0.0.' 0.0.0.0.0.0.0.0.' eXeX*.7.*.*.7.0.7.0.0.0.7.0.8.8.e.8./ ' ^ ' ^ / ^ ' / ^ ^ ] / ^ / ^ / / / ^ ^ / ~ ~ 6.*.~ ` 6.` 6.6.` ` ` ,./ ;.W Q W W W W 2./ W ;.Q Q W W j j j j j b k j Q Q h j c v v v p M p M c M p p  .j k k p r  .p j c c k p k p c b b ( b b f b b b b b j b c c b m c b b M c m c b b m m c m b M m m b m m m m ) m m ) b ) j Q j 2. . .4.n M m m 2.<.1.,.,.:.;.<.:.:.$.$.#.$.{ $.#.{ ..} X.{ { { ..| #.{ #.> W ( h > D D ;.W D #.D Z D #.@.Z #.#.@.#.@.{ @.#.#.{ @.> Z } , , Z , - , , , , , > , { > > r { > @.Z > } @.Z } Z @.@.@.@.} Z @.@.@.@.Z } Z Z Z , Z Z Z - Z - L r.ZX+.+.t.Z.D.G.L > D Z D Z D D D Z D @.Z D D Z D Z Z Z Z Z Z Z Z Z #.#.:.:.;.h | | > / %X$XvX%Xh ;.@.$.*.$.$.$.3.$.3.3.3.3.$.3.p.3.p.3.3.p.3.5.3.r.r.5.3.3.3.3.3.5.3.r.p.3.p.p.p.p.p.5.p.y.y.y.y.3.3.y.y.y.$.y.-.y.-.p.t.S.t.t.t.i.p.i.t.i.i.p.i.p.u.y.u.y.pXi.i.i.i.sXAXi.D.i.sXi.aXaXi.aXpXsXaXaXsXsXsXaXAXdXsXdXdXdXdXdXdXdXdXdXfXfX",
        "7X7X).7X).XXB :X X X].B B OX7X#X).uXeXuXuXOXeXuXuX~.oXoXuXOXoX4XeXuX~.oXOXuXOXOXOXOX~.!.!.~.!.!.!.(.!.(.(.eX0.0.0.*.q.0.tX0.0.q.7.0.q.q.*.q.0.0.6.0.6.0.0.0.8.0.6.0.tXq.eXeX0.' 0.4XrX' 0.0.0.8.q.iXq.q.e.yXe.tXiXyXiXtXiXyXiXuXuXiXiXrXoXoXoXiXiXrXuXrXrXtXrXrXtXrXtXrXrXrXtXrXtXtXtXq.q.q.tXq.tXw.iXtX9.9.yXe.r.r.yXyXyXtXyXyXyXyXyXyXyXyXq.4XyXyXeXeXeX*.0.0.*.0.0.0.6.0.0.q.0.q.0.0.q.0.7.w.7.7.0.7.q.*.7.0.7.7.8.0.0.9.6.' 8.' / / / ^ ^ / ^ ^ ^ ' ^ ^ / ^ / ^ / ^ / ^ ~ 6.~ ` ` 6.~ ` 6.` ` ` 8.` ` W Q 2./ ;./ W W / ;.Q W Q W Q Q j Q j j j j b b j b h M M v v v v v M M c n p M k k p c c p  . .p k k c c c s b ( b b ( b b b k b b b c b n b b M c b m c m c b m m ) m m m m m ) m [ m m m ) m m m m m n n Q 4.Q  . .n M m m M n 2.2.2.<.1.2.#.#.#.#.{ $.{ $.{ } } $.{ #.{ #.{ { | { D > W h h W h D D > D D D > #.#.#.D #.#.Z #.@.{ } #.{ } @.{ } > Z , - O o O . . . O = , > , > > > > > Z } Z > Z , @.@.@.@.@.@.@.@.@.} Z @.@.Z } @.Z Z Z - , Z - - ~ G.+.Z.Z.S.F.ZXe.- - > D D D D Z D D Z D D Z Z K Z Z Z Z Z Z Z Z Z Z W ;.;.h ;.#.D > ( _ ].vX X' > > #.$.#.$.$.<.<.3.3.3.3.3.3.p.X.p.p.X.3.3.3.3.3.>.3.>.>.<.>.>.>.3.X.3.3.5.3.t.5.p.p.t.t.t.p.p.p.p.p.y.p.y.y.y.y.y.y.t.i.t.S.i.p.S.D.i.i.i.i.i.p.p.p.u.pXu.i.i.i.D.sXD.aXi.i.sXi.aXi.u.aXi.i.AXaXaXaXaXaXaXsXsXdXAXdXKXdXdXdXdXdXdXaXfX",
        ").).).7XC B B .X:XY {.bX$XL.B G tXuXuXeXeXuXeXoXuXrXoX4XeXuXeXeXuXeXeXeXeXOXoXeXeXoX!.~.OX~.OXOXOX).(.!.(.eXtX0.0.tX0.0.q.0.0.q.0.7.0.q.*.q.7.*.0.0.*.6.6.0.8.0.q.rXrXrX0.' 4X' 0.eX0.0.0.0.e.0.q.e.yXe.q.iXe.tXtXtXiXyXfXuXiXtXtXiXuXtXrXrXuXuXrXrXrXe.e.tXe.tXtXrXrXq.tXrXrXtXq.iXq.q.yXtXq.iXr.tXtX9.8.1.9.q.yXtXyXyXyXyXyXyXyXyXyXtXyX4Xq.yXq.5Xq.0.tX*.tX*.*.tX0.0.0.6.0.q.0.q.7.q.7.q.w.7.7.*.q.7.7.*.*.q.8.7.6.9.8.0.8.q.8./ / ` ^ / ' ! / ! ^ / ^ ^ / / / ^ / ^ ^ / ~ ,.6.,.~ 6.` ` ,.6.~ ` ` / 8./ Q / ;.Q Q / W ;.W W ( Q ) b j j Q k b k b n j b k j c M v v v v v v c c M p n k p k k p c k k p c c c l s c l b ) b b b R b b b k b b b b n b c m M b m c m b m [ b m ) m m m m b b m ) m m m ) m b n ) n Q Q j 2.n M M m M M m M 2.2.2.2.2.>.#.$.#.$.{ #.#.#.#.} { } X.{ { { ..{ { { D h W h ( ( h j h D D D #.D { D D #.@.@.#.Z #.#.} #.@.{ } > Z , $ . .   .     . . . O , : , > > > > | > { { > > { { Z } @.@.@.@.Z } Z } Z @.Z Z Z Z Z Z - Z - L 5.N.N.S.G.ZXDXGX! - S Z D Z Z Z D D Z D Z Z D D Z Z Z - Z Z Z Z Z Z Z #.h ;.#.h W h > ! ].$XvX XR f > #.$.$.#.$.>.3.>.3.3.>.3.p.X.p.X.p.$.3.X.X.3.;.,.;.2.q.] e.iX` 8.2.:.>.3.3.5.p.5.p.5.p.p.t.t.t.t.t.t.+.p.+.p.p.p.t.i.t.p.i.p.p.i.t.S.p.p.t.t.5.t.r.2.y.u.i.i.aXi.aXD.aXi.aXu.u.pXu.aXaXu.aXaXaXaXD.sXsXsXsXAXsXsXsXdXsXfXdXdXfXfXfXfX",
        ").7X).7XOXXXB  X:XvXJXIXuX%X].U % & ; K uXuXuXeXeXOXoXeXrXeXuXeXeXeXrXuXtXtXrXtXtXtXtXeX~.oXtX4XeXq.0.tXeXeXeX0.0.0.q.tX*.q.q.7.7.0.q.0.q.7.7.q.6.6.6.0.8.7.0.8.0.rXrX' 9.q.' 0.' eX0.0.0.9.0.e.e.tXe.q.q.w.tXr.yXiXyXiXtXiXtXtXiXtXtXuXOXrXrXrXrXtXtXtXtXtXtXtXe.tXtXrXrXrXq.tXtXq.q.tXq.iXtXq.q.iXq.<.8.8.<.9.r.yXyXyXq.yXyXyXyXyXq.yXyXyX4Xq.yXq.4X4X*.tX*.tXeX0.q.*.0.0.q.7.9.9.7.7.7.w.7.9.7.7.*.0.0.q.8.7.6.0.0.8.6.8.8.8.8.' / / ` / ^ ~ ! ! ! ( ^ / / ^ / ^ ^ / ^ ^ ~ ~ 6.K 6.` ` 6.` / / 8.` / / ` ,./ ;./ W ;.W / ( k Q n ) n ) j j b n n b n b b b b v M v p p v v M M v c M c c M c c c c l s p w c c s l l c l k b b b b b b b b s b b b m b n b b m b ) m m m m m m m ) x m m m m b m ) m m m ) b b b b n Q Q j M M m m m m m g.) Q 2.Q 2.2.#.:.#.#.{ $.{ ..#.{ { { #.#.{ { { { { { h h D ( > h k h k k W D D D #.{ @.D #.#.@.#.{ { #.{ { @.> Z , - . .           . & &   . , : , > > > { { , , > > , , , > , , { Z } Z @.Z @.Z @.Z , Z - , Z - - ( +.Z.G.F.ZXDXGXNX- - , : D > D D Z > L D D D L D L A A L L - Z Z L Z D W #.W | D > > : _ ].vXvX].R > h j o. .>.>.>.3.>.>.5.>.5.X.p.3.3.3.X.3.X.:...8.rX%XkXbXbXcX:X:X:X>X%X1.2.X.3.3.p.3.p.5.p.t.t.t.t.5.t.5.t.p.p.p.p.t.t.t.S.S.t.S.t.i.p.t.p.t.t.r.^ P ^ u.u.u.u.i.i.u.D.i.aXi.aXu.u.u.r.aXu.u.aXi.aXsXsXsXsXsXsXsXsXAXsXsXfXKXdXaXfXaXG.",
        "7X7X).).B C B vXvXbXHXKXS  XvXbXUXPXKX] uX~.uXOXuXoXoXuXuXeXeXuXuXeXrXeXuXtXtXeXeXeXeXeX4XoXeX4X4XtX*.0.eXeXq.0.0.tX0.*.q.q.7.q.7.7.7.q.7.q.7.7.6.6.6.~ 6.q.8.q.0.0.q.' 0.8.q.0.' 0.0.0.q.q.q.q.yXe.r.q.iXq.r.q.iXtXtXuXiXiXyXfXrXe.rXuXrXrXrXrXtXiXq.yXtXtXe.tXtXtXrXtXe.q.0.q.q.tXtXtXtXq.tXq.yX9.8.8.8.8.9.8.q.yXyXyXyXyXyXyXyXyXyXyXtX*.*.yXyX4XyXyXq.4XyXyX*.yXq.0.8.9.7.q.q.w.w.7.q.7.7.w.7.7.*.7.7.6.8.6.8.0.6.6.8.8.8.8.0./ ' / / ~ ^ ` ^ ~ ^ / / / ^ ^ ~ ^ ^ / / / ~ W ~ *.` ~ 6.` ` 8.` 8.` 8.8.` 1.W W W / W Q Q ( ) ) b j b b n j n c b b b b b b c v p M v v v v p M p c M c c l c c l p s c l s s y l c l l l c ) b ( b b R b b b b k b b b b b b m b m m m m m m m l m m m ) [ m m m m b b b b b j ) j ) n Q n m m m M M M g.m m m 4.4.2.2.$.#.$.#.$.| u c k k | { { { { { { ..{ D h D h h h ( D W k f j k D #.D D Z @.#.@.#.#.{ #.} #.} @.{ , , . . .   .       . E ^ *   O = , > > > > > > { > , > > { , , > > , , , Z } Z Z } , Z , Z Z - , - >.Z.F.F.ZXDXGXAXE - L : L Z Z D D L > D Z Z D D Z L E U _ A - - - L D > W h ;.> > > > E '. XbX$X%Xf r j .. .>.5.>.X.5.>.X.>.X.5.y.y.X.p.X.X.3.#.#.%XkXvXMXcXbXcXcX:X:X:X*X:X;XOX1.>.>.5.3.5.5.p.t.5.t.5.5.5.p.t.+.p.p.p.p.t.t.t.p.t.S.i.t.t.t.p.X.e._ N ^ 5.5.p.u.u.u.u.u.u.u.u.u.aXr.iX' 9.r.r.u.aXaXi.aXaXsXsXi.sXsXAXsXsXsXfXdXdXfXD.S.S.",
        ").).).uXOXXXB bXJXHXbXcX X XvX%XR * UX] uXeXuXuXeXuXeXuXeXuXeXrXeXtXuXrXeXeX0.eXq.0.tXq.eXeXeX0.q.eXtX4X0.eXeXeX0.0.0.q.w.q.7.w.7.7.0.w.7.q.7.q.6.6.6.6.6.9.8.8.8.9.0.9.9.8.9.9.rX0.0.e.q.9.e.e.e.yXtXiXq.e.tXe.w.iXiXyXtXtXuXiXe.rXrXiXuXrXiXq.tXtXiXyXe.e.tXtXq.iXtXrX0.0.q.q.q.q.iXq.yXe.tXq.9.9.8.<.<.8.,.9.q.yXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXw.w.4XyX0.tXyXtXyXq.7.9.7.7.w.7.9.7.q.w.9.7.7.w.7.7.8.6.7.7.0.7.6.6.8.8.8.` 8.9./ ^ / ` ! / ^ ~ ^ / Q / ( / / / ^ / ^ / ^ / ~ ~ ~ ` 6.` 8./ / / / / / / Q Q Q 1.Q 2./ Q j b n b b ) b ) m n n c b c b b b c v u g.v v v v v v v v v c v v p v c c s c s c c l s c l v c l l l b b b ( b k b ) s b b M c b b M b b m ) x b m m m [ b m b m m b ) m ) m ) m m b b b b n n Q j m M M M ) m M g.m g.M Q ;.;.:.#.{ #.#.h u p y u y p p p  .r { r ..h D h W D h h h ( h k ( j k h D #.#.#.Z Z #.#.{ #.#.{ @.{ @., - .       .       . & & .     $ , , > > > > > r > > , , > > r > , r , , Z - Z - Z - - Z - , - Z - C.F.ZXZXZXGXGX/ - - - , > : : Z > Z D Z D D L > D L > U U U _ L - L > > > > D h > h > _ ].1XbX].I f r r r o.>.4.>.>.>.>.>.>.3.3.X.X.3.X.3.3.X.{ / 1XvXcXcXMXcXcXcX:X:X:X:X;X;X;X+X:.>.X.3.3.5.3.5.5.5.5.5.+.X.+.p.p.p.p.t.t.i.t.i.t.p.p.t.t.+.5.' XXL.S 2.>.5.r.5.y.r.u.u.r.u.u.r.r.u.e._ S e.r.r.aXu.aXaXD.i.D.D.D.sXsXsXAXfXsXfXAXAXF.F.G.",
        ").uXOX#XB B B vXbXbXbXcX X|.kXHXHXCXUX] OXuXuXeXuXeXeXuXuXeXuXeXrXeXeXeXeXeXeXq.eX0.rXq.q.eX4XtXtX0.0.tX4XeXeXtXeX0.0.q.w.q.q.w.7.w.q.7.7.7.6.7.7.,.6.,.6.6.8.7.,.9.q.9.9.q.9.9.9.q.q.rX9.9.9.9.9.9.q.e.q.e.iXq.q.r.tXtXtXiXq.r.q.rXe.rXtXq.e.tXiXq.yXiXq.iXtXq.tXtXtXq.q.0.q.rXq.rXq.tXtXq.e.7.7.1.8.,.9.8.8.<.q.5XyXyXyXyXyXyXyXyX4Xw.yX4XyXq.4Xw.yX4XyXyXyXyXyXyXq.7.q.q.9.w.q.w.9.9.9.w.9.7.7.1.1.9.8.6.6.8.8.7.6.8.8.8.` 8.8./ ^ / ^ / / ~ / ^ ^ Q / ^ / ^ ( / ^ / ^ ~ ~ ~ ~ / ~ ~ ` / 8./ 8./ / W W ;.W 2./ W Q 2.Q n n b b b ) b m m n b b m c b b c m z z g.v v v v v p v v M c v p l c c l l l l c c l l l z l l c l c b b ( b ( b b ( b b b b b b b b b b m b m m l m ) b b x ) m m m m m ) b ) m b b b b ) b n ) Q M m M m m m M g.v g.g.m ;.Q ;.$.} { $.k u u i p y p y i y p y p w k k f h h D W ( h W k h h k k k h D @.#.@.{ #.#.{ #.} { #.> , $   .       .     . .       . O - = > > > > > r > > > > , > > , > , > , : - - - - - - , - - - - - 4.G.AXAXGXGX/ $ $ - , - : - L : L Z S D D Z Z L Z : - U V '.U U L : : > > s > r h , ( ]. XvXvX]._ s r r  .X.>.>.>.>.>.X.>.3.3.X.5.3.3.X.3.:.:.;.#XcXcXcXcXbXcXcX:X:X:X:X*X:X*X*X{.W W ;.;...>.>.5.5.5.O.5.o.5.5.X.5.5.t.p.p.t.t.t.i.Z.t.p.5.5.oX/.L.N ( h 2. .3.>.>.5.w.5.r.r.u.r.3.>.r.OXC S e.r.u.aXi.i.D.D.i.D.AXi.sXZXi.dXdXD.F.F.F.D.F.",
        "7X@XuXrXC B B ].1XvX1X X.X|.kXKXUXIXUX] uXuXuXuX@X7XuXrXoXuXuXeXtXeXeXeXeXeXeXq.0.rX0.eXeXtXeXeX*.0.4X*.q.eX0.eXyX0.q.w.7.7.7.7.7.7.7.7.7.7.7.6.6.6.,.6.6.7.8.8.6.9.7.9.9.9.9.9.9.9.e.q.9.9.>.9.9.9.r.9.r.q.q.r.e.q.iXiXyXq.w.q.q.e.e.tXiXq.tXr.q.tXtXe.tXq.tXtXe.tXq.q.q.0.q.' 0.q.q.iXtXq.q.9.8.,.9.8.,.,.9.8.7.q.yXyXyXyXyXyXyXyXyXyXyXyXyX5XtXyXyXyXq.yXyXyXyX0.w.7.7.7.9.q.9.w.w.q.q.7.9.8.1.9.1.1.7.8.7.e.7.8.8.8.] 8.8.8.8./ ^ ^ ^ ^ ~ ( / ^ ^ ^ ( / ( Q / ^ / ^ ^ ^ ~ ~ ,.` 6./ / / / ` / ~ Q ;.Q Q Q / 2.Q Q n n Q m m n m b b m ) m b c m m c b v v v z f.f.v v v v v p v c v v v v v z v v v c l l c l c l c l l z l l b b ) b b b b b b k b b b b c b b b m ) x m ) m m m [ l m b m b b m ) c b n b ) n j b j b Q m m M M v g.g.g.g.g.g.M M  .Q #.#.#.{ p u i p i p y p p y i p p w s s c k k s k k f k ( ( k j ( k k f > #.#.#.#.#.{ #.#.#.} Z , O   . .             . .     . . = : > , > > > > > > r > > > r , , , , = - - - : ( f S : - - - - - > VXGXGXKX' - & ; E : E D : : - : - > Z S : D Z D L : : U Y U U _ _ : : > > > > , s _ ]. XbX1X].R = r 2. .4. .>.>.>.>.>.X.>.X.3.3.X.3.3.:.:.| > %XvXvXbXMXMXcXvXcX:X:X*X:X*X[.*XE.f ] l.) Q | | :...X.o.o.X.o.X.o.5.5.5.5.t.t.t.S.t.t.t.5.5.] }.&XL.C S W 1./ A S S ( / 2.9.>.3.>.>.3.9.] V * ! 9.t.u.G.D.i.D.D.i.aXAXi.sXD.D.ZXD.D.D.D.F.S.",
        "#XuXOX@XC B B B B B B C B _ NXCXCXCXS ' uXuXuXuXuXuXuXuXuXeX*.' 0.eX0.eXeXeXq.eX0.eXeXq.0.q.rX*.0.4X*.tX*.tXeXq.eX0.9.7.7.q.7.q.q.7.7.7.7.6.7.6.6.,.6.,.6.7.8.7.8.8.9.9.9.8.9.9.9.9.9.e.9.9.9.9.9.9.9.9.9.e.9.e.q.e.r.q.r.q.r.q.q.r.q.iXr.iXr.q.r.iXq.tXiXtXq.iXrXtXrXq.' rX0.0.0.0.q.tXtX9.8.<.8.,.,.9.9.8.8.9.9.8.7.9.q.yXyXyXyXyXyXyXyX4Xq.yXyXyXyX5X5Xq.yXw.yXq.w.q.w.q.7.w.w.9.9.9.9.1.1.1.<.8.8.8.1.8.8.1.1.8.8.8.8.8.8.8.8./ ) ^ ^ ^ / ^ Q / ( ~ / / / / / / ^ / / / ~ / / / / ` / 8./ / W Q W Q Q W Q W W Q n  .n 4.n b m b m m b m ) M b c v b v v v v g.g.z g.g.p v v v c c v v v v v p v l c l l p l l c l l c l l l l l s ) b b b b b b b b b b b l b x b b b b x x m b b m b [ m m m b ) l l ) ) n j n b Q b Q n n m m g.g.m g.g.g.g.M v M n Q #.#.$.} u i u i p i u i i p p p p p p s b s s s g k k b k k ( h h k k h > { } > { { #.@.#.} { @., O   . X O .     X & & & .     . $ : , : r > r > > , f > , , = : , , , = : S ( ( D ~ D W ( D - - $ $ NXGXe.( T ( / ;.#.{ > h W ! : - - D - Z : L > L - : : U V U U ].I R d : = : , > = _ ].vXbX$X].( r j ;. . .o.>.:.>.>.>.:.3.X.3.X.:.:.>.:.:.;.W 1XvXcXcXmXcXcXcX:X:X:X:X:X;X*X[.F > [ j.j.[ / W k h k j j Q j  .4.k.l.e.X.p.t.t.p.p.t.t.5.>.+X*XU.V C - E V L.L.B N * * & : Q <.2.2.>.;.' Q.* & 1.r.u.G.i.D.i.D.sXD.i.i.D.D.F.D.D.D.F.D.G.S.",
        "uXOX#XOXB B _..X[.`.B V uXS ; % % : oXuXuXOXuX@XuXoXeX~.K ' *.eXeXeXeXeXeX0.eXeXrX0.eXtXeXq.eX0.0.0.tX0.4X0.eXeXeXw.7.w.7.7.7.7.7.7.q.7.7.7.7.7.7.7.6.6.6.6.,.8.7.8.9.q.9.q.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.9.q.r.9.e.tXr.q.q.r.q.9.q.yXe.tXiXiXq.q.tXq.q.tXq.q.q.q.q.q.' q.0.8.rXq.q.q.9.,.8.,.9.8.7.1.7.7.9.9.7.9.9.7.9.9.w.q.yX5Xq.yXyXyXyXyXyXyXyXyXyXyX4X4Xw.4Xw.9.9.9.q.q.9.<.1.2.1.1.1.) 1.1.1./ 1.1.8.e./ 7.8.8.1.8.8.q.1.^ ^ Q ^ ^ ( Q ( / Q / / ( / ( / / / ^ ^ / ,.8.8.` / ` / / j Q j j Q j Q Q Q Q n n 2.n j n ) ) n ) b ) ) m ) m c b m v z m z z f.z f.g.g.v u z c v y y l y p l u u v l u z l l l l c l l l l c l l b R b b ( b ( b b b b l b b l l b b m ) m m b m m m m b m b [ b b l b b n ) n n j ) n n n M g.g.v g.g.g.m g.g.p p M j | #.{ { u u u p y i y i y i y y w p y s g l s k b k k s k ( k h j ( k f > > { #.{ Z > { #.#.} , Z . . NXCX5   . X NXVXKXS . .   . = = : > > , > r > r > > r > > , , = = : W | >.G.AXAXAXG.5.{ > ( : : S ! ^ 1.2.5.t.G.AXAXF.t.5.{ | ~ : - - > L > L > D ; - % P V Y U ].$X_ f : = : = = [  XvXbX XXXf k h  .X.2.:. .:.>...>.X.3.:.>.3.:.3.:.:.{ > ~ :XcXvXcXmXbXcX:X:X:X*X:X*X*X*X;XA S j.6 j.j.j.l.l.) ) ) ] k.l.l.x.c.j.1.5.p.p.t.t.p.t.t.3.6.}.*XY.C V V B U.B B C * N C * * O - W W W ~ _ L.C X f 3.r.i.i.D.D.aXD.D.sXD.D.F.D.D.D.F.D.F.D.D.",
        "OX@XuXuXC B _. X X].K.B ).7X7XuXuXuXuXtX7XuXuXuXOX4X4X~.*.' K 0.0.eXeX~.OX0.eX0.q.eXeXq.tX0.q.tX0.eXeX*.4Xq.*.eXq.7.w.7.7.7.7.w.7.7.7.7.7.6.7.7.8.,.6.6.6.8.6.7.8.8.9.9.q.9.9.9.9.9.9.9.9.9.9.9.e.9.9.9.9.9.9.e.9.9.9.e.9.9.r.r.q.q.r.q.q.iXiXw.e.yXr.iXq.q.q.0.e.rX0.0.q.' 0.rXrXq.rX0.8.1.9.1.8.8.<.8.9.,.9.1.9.8.9.7.w.9.9.q.*.6.*.0.q.4XyXyXyXyXyXyXyXyX4XyXyXyXq.w.8.1.] 1./ 2.Q ) / 1.) 1.1./ 1.1.] 1.1.8.1.Q 1.9.8.8.8.8.8./ ^ ^ Q ^ ^ Q Q ( Q / ( ( / / / ^ / ( / / / ` ` ` ` ` / Q j Q j Q ) j j Q Q Q n o.j Q n n n m b ) m m m ) m m m m b l v v v v f.g.g.u d.v g.u z p z c l u z l z l u l l l z l l l l c c l c m l l z c ) b ( b b b b b b b s b g b b b ) x b b l m ) g.m [ b ) m m l b s ) b b j j ) b n n j c g.g.g.g.g.g.g.g.g.p p v c M h #.{ ..i u y u i i i y y p i y i y y l s s g b k f g f k h h k h k k f > > > { { { { > } > > > Z o N KXVXVX. . ] IXNXVXKX.       O , , : , > > r > , : r : , , = = ; / h G.GXLXIXIXIXIXLXIXGXG.{ > W W  .5.G.GXLXLXLXFXFXFXDXDXF.n.X.:.: - - D Z D L D : : ; N N C Y '.].kX] & = ; = = P  XbXbX+XI a r h | .. . . . .2.>.:.:.>.:.:.:.:.3.X.;.#.h %X:XvXcXMXMXcXcXcX:X:X:X:X;X*X*X{.: [ j.j.j.j.j.x.x.x.x.lXlXzXx.x.x.v.l.;.X.5.t.t.t.t.t.t.>.' ;X&XK.L.U.U.I.&XY.&XU.C C C C C X X % ! R V {.L.* . ; 1.u.u.D.i.D.D.sXD.D.S.D.F.S.F.AXD.D.F.F.D.",
        "uXuXuXOXuXOX@XuX@XuX~.~.~.7XuX4X7XuXuXtXuXuXuX4XuXeXK eX~.4X*.0.0.0.OXW.W.OXeXeX0.eX0.eX0.eXeX0.eX*.eXyXeXtXeXq.9.w.w.9.7.w.7.9.7.w.q.7.7.7.8.7.7.<.,.,.,.6.,.6.1.9.8.8.9.8.9.8.9.9.1.9.1.9.e.r.9.9.9.r.9.9.r.4.9.e.r.9.9.<.9.q.q.r.q.r.q.r.q.iXiXe.tXq.q.q.q.0.0.q.q.rXq.0.0.q.q.0.8.8.,.8.8.,.,.9.,.9.8.7.9.7.7.9.9.9.9.9.9.7.,.*.7.6.*.7.0.w.4XyXyXyXyXyXyXyXyX) ) ) ) ] ) 4.1.Q 2.1.1.1.1.1.1.1.1.] 1.8.8.) n n n 8.8.7.8.8.8.1.Q ^ ) ( ( Q j h Q ^ / / W / / / ~ ^ / / / 8.` ` / Q j n n Q j Q Q ( Q Q ) n n ) ) n ) n n n m m m m m m m ) ) b l y g.f.v v u u f.f.v g.g.u v u z u p z p u p z u v u l p z v z l l l l l l l b l b l ( b b ( b ( b b b l b b l x b b b m m v x x m m m b m ) b b s c b b Q b n j Q M v v g.f.v f.m f.m m g.g.g.g.p p u p { }  .i u i i i i i i i i i y i i u s l s s b g b b k k ( W j k f k h k > h #.{ { { { > r e e , o ] % R VX* X NXCXX [ KX&       O = : > , , > : > > > : , = - = : h <.DXLXIXIXIXIXIXIXIXIXIXIXLXZXG.G.AXLXIXLXLXLXLXLXLXFXFXFXDXDXZ.O.9.: : L : L L - : - - : N N C U '.$XHX_ = T E a U  XbXvX X[ = r r 2.2. . .2. .;...:.:.3.:.:.:.:.:.#.;.> D $XvXcXvXMXcXvXvX:X:X:X*X*X*X[.;XI ; [ Y j.j.j.j.c.x.x.lXlXlXlXx.x.x.c.[ h X.X.5.t.t.t.t.+.5.' =X&XY./.$X$XI.&X{.U.I.L.C C C C C C V {.I.&X&XV * X % 1.5.D.i.D.sXi.D.D.D.D.S.D.D.S.D.D.D.ZXD.G.",
        "OXuXuXuXuXuXuX7X7XK Q.~.~.~.uX7XuX4XtXuXuXuXeXuXuX4XK 4X~.4XeX~.eX4XW.W.W.W.OXeXeX0.eXeXeX0.eX0.4X' eX*.tX*.q.9.9.w.9.w.7.9.7.7.q.7.7.7.7.7.7.7.7.8.<.6.7.8.8.,.8.7.9.9.e.9.8.9.9.9.9.1.9.9.9.9.9.9.e.9.9.e.e.r.e.9.9.<.<.<.,.<.w.9.r.q.w.q.e.r.w.q.e.' 8.q.q.0.0.q.q.q.rXq.' rXrXq.` 8.8.8.,.8.8.,.8.9.,.9.9.9.9.7.9.7.w.9.9.,.6.6.6.*.7.*.*.q.*.w.yX4XyXyXyXw.q./ / ] ] ) ] Q 2.4.1.1.1.1.1./ ] 1.1.1./ 1.) o. .n n 2.8.8.8.` 8./ / ^ ( ) ( h Q k j ^ Q / / ^ / ( ^ ~ ^ / ~ ` ` / j j j n k j Q Q n Q Q b n ) n ) M n n M n m m m m [ m m m m m m t l y f.z f.g.f.u g.g.d.p u z p z p z u u p p l l p p z p z z z l l l l l l l m l l l b ) b b b b b b b b b b b b l l b b v z z m m m m b [ b b g b s b n b b n l l f.g.g.f.v g.g.g.g.v g.g.g.p p u f.u u | { p i i i d.d.d.i i i i i y y i t l l g b g s b g k k ( ( h k k h f h k g { { { > h w y w e 0 o ) % X [ Y C l.%X. . KXP       O = = = > k , k = r , = , , = : Q :.GXIXIXIXIXIXIXIXIXIXIXIXIXIXIXIXIXIXLXLXLXIXLXLXFXFXFXFXFXDXDXF.+.5.( L : > L Z > : : - ; ; N N Y V ].bXHX% E _ 4 U  XbXvX].R = r r k  . . . . . .:.#.:...#.:.:.:.:.| #.h ' vX:XcXcXMXMXcXcXcX:X:X*X:X*X*X&XN a j.j.Y j.j.x.x.x.x.lXlXzXx.x.x.j.j.) r X.5.5.t.t.5.t.X.X.) {.Y.}.HXUXkX'.vXJXbXL.&XK.B J.B C B &X*X&X&XL.C X X ; 5.t.Z.D.i.D.D.D.D.D.F.D.D.S.D.F.D.D.D.F.S.",
        "uXuX@XuXuXuXuX(.~., r , r r r 4X= O uX7X7XuXuXuXuX~.~.4XK eX~.4XK W.+XW.W.W.!.OXeX0.0.q.q.eXeX~.oXeXeXeX*.eXw.w.3.7.w.7.7.9.w.7.w.7.q.7.7.8.7.<.7.7.6.,.6.,.6.,.6.8.1.9.8.8.9.9.e.9.9.9.9.9.9.9.9.e.9.9.9.9.9.9.9.<.,.<.9.<.7.<.<.9.7.7.q.e.q.q.q.e.q.8.8.` 8.e.q.0.rX0.rX0.q.0.' 8.8.1.8.,.8.,.,.8.8.,.9.9.<.7.9.9.9.9.9.9.7.*.*.6.6.! *.0.7.*.q.*.w.w.q.5X4XyXq.8.] ) 1.] ) / Q 2.Q 1.) 1.1.1.1.1.1./ 1.Q 2.Q n  .n n ) 8.8.8.8.` Q Q Q ( j j k Q h Q ( / ( / / / ( ^ ^ / / ~ Q c k j k n n b b n b Q j b n n M M n n ) M n n m m m m m m m ) m x s y y y u f.g.u f.v u g.p u z z u u v l v u z u l z l u z l y p l l l l m l l l l l l l l ) b ( b R b b g b b l b c b x z v m z z z b m b b l q x x l x t q t y f.g.g.p f.g.g.f.v f.g.g.m g.p g.d.g.d.u u k { y i d.d.d.d.d.i i i i i i i i t l g b g g b f l s k g g k ( j f h f f s > { > f w p y w e e + R kX* jXxXxXjXjX* U KXO .   . O = = > = = > , > : s , = = ; Q { GXLXIXIXIXIXIXIXIXIXIXIXIXIXIXIXIXLXIXIXLXLXLXLXLXFXFXFXFXDXDXDXG.Z.e.- - : - : L - : : ; - ; S % C Y U %XbX_ N N V U U %XvX]._ a = r r  . . .;.|  .| :.:.:.:.:.:.;.:.#.| h OX:XcXvXMXcXcXcX:X:X:X:X:X;X;X;XU.: P Y j.j.j.j.x.c.x.x.x.lXzXzXx.x.x.j.b  .X.5.5.5.5.5.5.5...2.L.J.bXJXJX}.vXJXJXJX%XU.&XK.B J.Y.C Y.&XY.B C O X * ( 5.u.t.D.D.D.D.D.D.S.D.S.F.F.S.S.D.D.S.S.S.",
        "OX@XuXuXrX7X!.r = O.N.H.h.N.O.= q e O tX7XuX7XuXuX4X~.~.4X*.~.4XW.W.W.(.W.W.W.E.OX0.eXeXoXoX~.eXoXK ' 4XeXeX7.w.9.w.w.9.w.7.7.w.7.7.w.9.7.7.7.7.8.7.6.<.<.6.6.8.<.,.8.9.9.8.9.8.9.9.8.9.>.e.9.e.r.e.9.r.e.9.9.1.1.7.<.9.<.<.<.9.8.<.<.<.7.q.9.q.q.9.' q.8.q.8.8.q.0.0.q.' rX0.0.` 8.7.1.8.,.8.,.8.1.8.8.8.8.7.9.9.q.w.9.9.w.6.,.,.` ! ' ! *.0.q.*.*.7.q.q.=.yXtXq.8.) ] ] ) 1.] / 2.2./ 1.Q 1.1.1.1.1.) 2.Q o.Q Q n n n j 1.8.8.9./ Q ( ^ j Q k Q h Q j ( ^ ^ Q Q ^ ^ Q ^ / Q j k k k k k b n n b n n b b b k n n ) M M n M n m b m m m m ) m ) z l y s y x y z d.z z u u u u g.u p g.u u u p p z u l u p u y l y c l l l c l c c l l l l l l b b b ) b b ) b s b k l b l i y v m z z v x b m ) g g x l s t y l i d.g.g.d.g.d.g.v u g.f.g.v g.v u g.d.g.u u p c c d.d.d.d.d.d.d.d.d.2 d.i i i y u l b g g b g b b g f g b g g ( ( k k f k g s s p p p y w w e o . kXcXxXxXnXmXmXmXcXjX.   . . o O = a > > : > e : = = = = W #.G.LXIXIXIXIXIXIXIXIXIXIXLXLXLXIXLXLXLXLXLXLXFXLXFXFXFXDXFXDXDXDXF.G.AX] $ : : = : a : > : : : : & P & C Y `.U N V U ].].$XkX].$X_ ; r r k r h | j h  .| | :.;.:.:.;.:.{ h r k %XcXvXcXMXmXcXcX:X:X*X*X:X*X;X*XV & [ 6 j.j.j.jXc.x.x.lXlXlXlXx.x.l.c.l.h  . .5.5.5.+.5.5.O.X.Q V +XJXJXJX{.HXJXJXJXCXP.*XY.B C J.C C B C * * O X % Q 5.Z.i.D.D.D.D.D.D.S.F.D.F.S.G.F.S.F.S.S.S.",
        "OXOX@XuX#X~.r v H.m.B.M.m...r f.= z.s.O uXuXuX7XuXeXK 4X~.~.~.W.W.W.W.W.W.!.W.W.W.!.oXK K *.eX~.4XeXeXeX0.eX4X0.w.3.9.3.3.9.9.7.7.7.7.7.9.7.7.7.7.6.,.8.8.6.<.6.8.6.8.9.8.e.9.e.9.9.e.1.e.9.9.9.9.9.9.e.9.9.9.<.<.<.7.<.9.,.<.7.<.<.8.<.8.e.q.q.q.e.q.8.] 6.' 8.8.8.0.0.0.q.0.` 8.,.8.8.,.8.,.8.8.6.,.8.,.8.8.9.9.9.9.9.9.9.0.` ~ ! ! ! ' ' 7.*.7.0.*.*.*.q.yX=.=.q.e./ 1.] / ) ) 2.2.2.1.1.1.) 1.Q 2.Q n Q Q Q Q o.4.j  .n ,.8.8./ ( j j ( k Q k j j ( j ( ^ ^ ^ ^ ^ ^ ^ j c k c c k p c k k j b Q j n b b b b m n n ) M ) M ) m ) ) b m m m l x t l t l t l y u z f.g.g.u v u u u u u u u v u z p u z u l p z y c l l l l l z l x m l l l z l R b b ( b g b b b b b l y y i u x z m l z m m c t x l x t t i u g.u g.i d.g.g.g.g.g.g.v g.g.g.f.f.d.g.d.u i y c p d.d.d.d.d.d.d.d.a.d.d.f.i t i i y s s b g g g l g f b g s x g g g x s g s s y p y y p w w 0 + C jXxXxXxXmXmXnXnXnXxX*       o = : , = = r > = 0 = r = : ,.X.FXLXIXIXIXIXIXIXLXIXLXIXLXLXLXLXLXLXLXLXLXLXFXFXFXFXFXDXZXDXDXZXF.GXVX^ = ; : ; > : : a a g 0 < @ 5 % & N N U Y ].].]. X$XbX%X].R = = = r r r | | |  .h | ;.| #.{ | { ..| > h 1X:XcXMXcXbXcX:X:X:X:X:X*X:X*X&XP % j.[ j.j.j.c.x.x.x.lXlXlXzXx.x.x.j.[ j  .o.X.X.X.X.5.5.X. .j XXkXHXJXbX$XJXJXJXJXHXL.&XY.Y.Y.C C C * * X X X & 2.5.5.C.G.Z.A.S.D.A.S.G.G.S.S.G.F.D.D.S.S.F.S.",
        "OXOX#X7X~.r n IXm.B.B.v.+.r z.e z.z.z.O 8XuX7X4X~.~.*.~.~.~.~.W.W.!.W.W.W.OXW.OX!.!.!.oX4XoXoXoXoXeXeX0.4X' 0.eX4Xq.9.w.9.7.w.7.7.7.7.7.7.7.7.7.7.6.7.8.<.8.,.8.6.,.6.8.8.q.9.8.9.9.9.9.9.9.e.9.9.9.e.9.<.<.<.<.<.9.7.<.<.9.,.<.,.7.7.8.9.q.e.9.q.9.8.8.8.8.8.8.q.8.8.' ' 0.` ,.,.8.,.8.8.~ 6.6.1.,.8.8.8.8.8.8.8.9.q.r.9.8.` ` ! ! ! ' ' ! *.7.*.7.q.*.6.*.*.w.w.q.) 8.) / ) / ) / Q 1.2./ 1.1./ Q Q Q Q j ) o.Q n n j n n Q 8.8.8.Q ( ( b b k ( k Q k k j Q ^ ^ ( ^ ( k k c k j k k k k s k j n b b b b b b b b n n n ) M ) n m m m m m ) b l l y y t x y y x l t u u g.u v u g.p v u g.u u u u y v p u l u y c y l s s s l l l z l l l l l y u b ) b b ( b b b c p i t y i y z z z z z z b t s l z l i u u f.g.i u g.v u g.g.f.v g.g.g.M g.d.g.d.d.p u t t t 2 d.d.d.d.d.d.d.d.d.d.i d.u i u u l s g s b b g g s g f b g l b l g s x l l y p y y c y i < < + C jXxXnXxXmXnXnXcXcXcX* . .   . O = = , r = e 0 0 = = = Q > G.FXLXIXIXIXIXIXLXLXLXLXLXLXLXLXLXLXFXLXFXLXFXFXFXFXFXDXDXDXDXZXZXDXGX] ; & ; : a a a a a a a a < < @ % * N U Y ].].]. X X X X X X_ = r = r r r k j h h j h #.h | | | ..| h h ] :XvXcXcXMXcXbXcX:X:X:X*X:X*X;XU.4 P Y j.6 j.j.x.c.x.lXlXlXzXlXx.x.x.j.) k ..o.5.5.o.5.5.O.o. .k XXCXR kX+X%XkXJXJXJXHXY.*X&XB C C * * X X X X & Q 5.5.t.Z.G.Z.D.Z.A.A.A.Z.A.A.Z.Z.A.S.A.G.G.S.S.",
        "+XOXOX!.~.r SXh.B.B.B.m.+.r z.s.z.z.a.O 4X' ~.K K ~.~.K ~.!.W.W.W.W.W.!.!.E.!.!.OXE.!.E.~.eX*.oXoXK 4XeXeXeXeXeX0.0.q.w.w.7.9.3.w.7.7.7.7.7.7.7.<.<.7.,.8.6.7.6.6.6.8.' 9.8.e.9.9.9.e.9.9.9.9.9.e.9.>.7.9.9.<.9.7.7.,.7.7.<.,.8.,.9.8.9.8.9.q.9.9.9.q.8.q.8.0.8.' 6.8.8.' 8.` 8.7.1.8.,.8.8.8./ 6.6./ 8.<.,.8.8.8.8.9.9.8.` ' / ' ' ! ! ! ! 6.0.7.0.*.7.6.*.0.K *.*.] ) ^ ] / ) / ) 2.Q 1.1./ 4.Q 4.Q 4.2.4.Q Q  .n 2.j n  .n 4.8.` b ( n ( ( b ) k k j ( j j ( ^ ^ k b b k k c k p c k c k c j b n b b m b b j n m ) m M ) m m ) ) m ) ) ) t t t l t l y y u y y u y u u u f.v d.u u g.p u u g.z u y u u u p u y y y l l l y s l l l l l l y y y u k b ( b b b c u i w y y y y y z z x z z l l q x u y u u f.u d.g.u d.u g.i u v f.g.v g.g.u g.d.g.d.i t 5 x t 2 d.d.d.d.2 a.d.f.d.i d.i d.u i i u s b b f s k b s f b f g g g g x s s s y y l t y w y w e e + . `.jXxXxXjXxXjXcXjXkXX . E &   O = = = a = 0 0 0 = @ = 1.{ ZXLXIXIXIXIXLXIXLXLXLXLXLXLXLXLXFXLXLXFXFXFXFXFXDXFXDXDXDXDXZXF.DXKXV.< @ ; ; ; a ; a a a a 0 a a < @ d 4 V '.]. X$X XvXvX X XvX X%Xa = = r e r r : h h h h h ;.h h h h r h k @X:XcXvXvX1X%X+X%X$X$X:X:X:X*X&XL.& [ j.[ j.j.j.j.lXx.lXlXlXlXlXx.c.v.l.k k o.X.o.X.X.X.O.X.X.j ^ '.P * %XC %X4 kXJXJXCXV *XY.Y.J.C X . X X * : Q 4.5.Z.t.Z.Z.S.Z.A.Z.A.Z.A.Z.A.A.A.A.A.A.S.S.A.G.",
        "!.~.~.~.r O.h.B.B.H.B.B.N.{ z.z.z.z.O # H H K H H K H ~.~.W.W.W.W.!.W.W.W.OXE.!.!.~.E.OX~.OXK eX4X0.oXoXeX~.eXeXeX0.eXeX7.w.7.7.9.7.7.7.7.7.7.9.7.,.<.8.8.,.6.6.6.6.6.' 8.9.e.9.9.e.e.9.1.9.e.9.9.6.6.6.<.7.9.7.8.7.<.,.,.6.6.,.7.<.,.9.0.9.8.q.q.8.8.8.' 8.8.' ' 8.6.` ` ` 8.,.8.,.8.8.6.,.8.,.8.~ ~ 6.6.8.8.8.e.8.` / / ` ! K ! ! ! ! ' ! ! *.0.*.7.*.6.*.6.6.` ` / ) / ) ) / ) / 1.2.Q 1.2.Q Q Q n ) Q 4.n Q 4.j j 4.Q j  .M 1./ j Q ( b ( ( ( b b ( b j k ( ( b j k k c k M c p k c c k p c c b b b b b b b n ) b n m ) ) m m ) m ) m x l y l t l y x y y x u x x y u z v f.g.u u g.u u u p p u u u u u y l y p l l l l l q l x l z l u y u y y c b b b R l i i p i i w y i y y z z u l u q y u y p i u d.v d.p g.u u d.u u v g.g.g.f.v d.d.g.d.t t g t t t d.d.d.d.d.d.d.d.i d.i f.i i f.i i u x s g ( l g s g ( f g g g g s g t s x 2 x 2 2 y w i w q 1 + o CX.XjXcXcXjXcXjXHXKXP   T ] . . = = = = 0 0 0 = = @ a ;.X.DXLXLXIXLXLXLXLXLXLXLXLXLXLXFXLXFXFXFXFXFXFXDXDXFXZXZXDXDXF.F.F.DXNX; @ @ ; f a ; a a a g a a g a < < @ T U ].]. X X:XvXvXvXvX1X1X XE = = e , e r 0 k h h h h h k h k > k k > %X1X%X_ % @ & # @ & & 3 I  X;X&X_ ; [ j.6 j.j.j.x.x.x.lXlXlXlXlXx.j.j.[ f p ..o.X.o.X. .O.O.| h _ C X . N * & * U JXJXbXL.&X&XY.C C X X o X ( 4.4.5.Z.Z.G.t.G.A.G.A.A.Z.Z.A.Z.A.A.A.A.A.Z.A.G.F.S.",
        "!.7XT.Q., O.m.m.B.M.B.IXH.O.z.z.s.s.O O H L H Z K H K ~.Q.!.W.W.W.W.!.W.W.E.!.OX!.!.!.!.!.!.OX4XoX~.oXoXeXeXeXeXeXeX0.4X4Xq.7.w.9.w.9.7.7.7.7.<.7.7.7.6.7.6.6.` 6.6.6.0.' q.q.9.9.9.9.9.9.e.9.6.0.6.0.6.6.` 6.7.<.7.,.~ ~ 6.1.6.7.9.9.q.q.9.0.e.8.8.q.8.9.8.8.q.8.8.' 8.` ,.6.8.,.8.8.,.6.8.~ 8.,.8.8.8.8.8.6.8.8.` ` ` ' ` ~ ' ! ' ! ' ! _ ! ` 6.6.0.*.*.6.*.` ~ ! ! ^ ^ / ^ ^ / ) ) 1.1.Q Q Q 4. .2.Q Q Q Q Q Q Q Q n n o.n  .) 1.b ( b ( j b b ( k b ( b j b k b b k k k p k j k j c k c j c c b ) m n ) m b m b m ) n m m m ) m ) ) l y t s y l t y l u y u y u u i u u u u g.u u u d.u u u u u u p u p y y y y y l y l s l s g l l l y y y y y u c b b c y p y w w w y y w y i y z x u u y y p i i y i u d.i g.d.g.g.g.u g.u u z g.g.g.u f.u y t t x t t x d.d.d.d.d.d.d.d.d.i d.d.d.u u i u u z l l g g b b g g g f s g g x x x x t x t 4 2 w i q q 1 < o X VXVX X.X.X.XkXVXUXIXVX. . X     O # = 0 0 0 = 0 @ @ k | 5.FXLXLXLXLXLXLXLXFXLXFXLXFXFXFXFXFXFXFXDXFXDXFXDXDXDXDXZXF.G.F.ZXGXR & & @ @ = ; ; a ; ; 0 a 0 0 5 < < @ P ].].$XvX$XvXvXvXvXJXPXUXkXT = = r e r r , = k h > | k h k k k > > ; f : ; ; ( e.4.5.e.4.b d & % _ ].S ; [ [ j.j.j.c.x.x.x.lXlXlXlXx.x.x.j.[ r k ..o.o.X.o.....k h ' |.Y.C * V C . . [ JXJX#XU.*X*XY.B C X X o % Q >.5.C.t.Z.G.Z.Z.A.A.A.n.A.A.A.A.n.Z.Z.n.A.Z.S.S.S.A.",
        "T.7X~.!.r O.{ ....r # v.c.r z.z.z.z.t O L T.R.Z ~.H ~.Q.W.W.W.W.W.!.W.!.!.W.!.!.!.!.~.!.~.OXOX~.~.oXeX4X~.eXeX4X4XoXoX4XeXeX0.q.3.7.7.3.w.7.7.7.7.8.6.7.6.6.6.6.6.6.6.` ' 0.9.9.9.9.e.e.9./ K 6.0.6.0.0.0.' K ' 7.~ D D 8.6.,.8.8.6.9.q.q.8.9.8.8.0.8.0.' 8.8.' 8.` ` ` ` 6.8.1.8.8.1.6.,./ 8.~ ` 8.6.` 8.8.8./ 8.8.` 6.` / ! ! ' ' ! ! ' ' ! _ *.*.6.6.6.` ! ( ^ ! ^ ( ^ ^ ^ ) / / / Q Q Q 4.Q Q Q 2.Q Q Q n j Q n j j n j j n n j b k ( k b R f b b ( b ( b ( k ( b k b c c k j p c k k c j c j c m b b n ) n n ) m m ) m m ) m ) m l l t l y x l y u y y u x u y u y u u z z g.g.d.g.p g.u u u u u u u z y y y p y y s l y l s l q g l u y y u y y u c y y y y w y w w i i w t y y u y z u x u y i y i u i d.d.u d.p u u u u z v g.u v u d.y w t t t q t t t d.d.d.s.d.d.d.d.d.d.i i i i i i u x l l m g g b s ( k g x g x x x t t t x t 2 t t 2 w q q < #   T UXKXVXCXbXHXKXUXPXPXPXE     .   o @ @ < = 0 < 0 @ @ Q { t.FXLXLXLXLXLXLXLXFXLXFXFXFXFXFXFXFXFXDXFXDXDXZXDXDXZXZXF.F.F.S.F.BX@ # @ @ @ ; ; ; a ; 0 a 0 < 5 q 1 1 @ T ].bXPXUXbXvXvXvXbXPXPXPXJXR = = ; = r s = = a k h > h > k > r k = : b / C.AXGXDXZXAXG.G.u.5.) f d ; @ R j.j.6 j.j.x.c.lXx.lXlXlXlXx.x.j.j.Q s k p o.o. ... .j h k |.*X&XY.Y.Y.C . o kXJXJX'.&X*XU.Y.C C X X . & ;.5.t.t.G.G.Z.A.A.Z.A.A.A.C.A.A.n.A.A.Z.A.A.S.S.S.A.S.",
        "~.~.~.~.r s.SXz.z.z.O m.d.r O O O O O O H H ~.T.~.K W.W.W.W.W.W.W.W.!.W.!.!.E.~.!.~.OXE.!.!.W.E.OX~.~.eXeXoXoXoXoXoXeXeXeX4XtX0.q.7.w.9.<.9.7.7.8.7.7.6.6.0.` 0.6.6.6.` oX' 8.e.e.9.9.9.~ K K ` 0.0.0.0.*.' E.E.F ~ ~ ~ / 8.8.8.6.6.] ' ] ' 0.' ' e.8.8.9.8.8.8.` 8.` ` ~ ` ~ 8.,.,.6.,.6.,.~ 6.~ ~ ~ ` ~ ` ` ~ / ` ` ] ` ' ! ! ! ! ' ! ! ! ! ! ` 0.*.6.` ! ! ~ ! ! ^ ! ! ! E ^ ^ ) ) / 1.Q 2.Q Q Q Q j n Q j j n  .n n j n n j n n b ( b k k k ( b g ( b k b b b s b k b k c k c k c c c c c c c c c b ) m ) b b ) m ) m ) ) ) ) z z y l t t l y t y x x u y u x u u u y u u u i u g.u g.d.g.u v u u v u y p y y y y t s t x s y y x t w y y u y y y y y y y y y w w y w e w y w y y y u y u y u u y i y y u u i g.d.d.u d.g.u g.u u g.z i x t t t t t 2 t t t d.d.d.d.d.d.2 d.i d.f.i u f.u u i u x s x l l g g g x t t 8 t t 2 8 t t 2 q x 2 t 5 i q < # o o VXIXUXKXVXKXKXUXPXPXPXPXKXX       . o # @ @ 0 < 1 # 1 Q { Z.FXLXLXLXLXFXFXFXFXFXFXFXFXFXDXDXDXDXDXDXDXDXDXZXZXZXD.F.D.G.F.F.) # & @ = @ @ ; ; f d ; 0 5 0 < < < < # R kXPXPXPXUXbXbXvXJXPXPXPXPX%X= = r = e r r 0 ; = h k h h h f h f > 4.r.AXDXGXKXDXAXAXG.G.Z.5.r.4.1.f = d j.j.j.j.j.x.x.lXlXlXlXlXlXx.x.v.[ k k j  . . . .) Q r f ' ;X*XY.&X*X&XY.* * JXJX%XV ;X&XY.Y.B * * X o % 4.5.t.Z.Z.Z.Z.A.A.C.A.A.A.A.A.A.A.A.A.S.S.A.A.A.S.A.A.",
        "T.).T.2X, ..z.z.z.z.O N.N.m.O.O.} ..r O L H H ~.H !.!.Q.W.W.W.W.W.!.W.!.!.!.~.~.!.!.!.!.!.E.!.!.OX~.OXoX~.eX~.oX*.oX4XeX0.eXeX4XtX0.7.7.9.7.7.7.7.8.8.7.' 0.` 0.6.6.6.6.oXK ` 9.e.9.0.' K D K ! K 0.oX' ~.XXK E._ F ~ ` 8.8.8.8.8.' ] ' ' ' ' ` ' 8.8.` 8.8.6.` ` 8.` ` ` ~ ` ~ 6.,.6.~ ,./ 6.6.~ ~ ~ ~ ` K ~ ~ ~ ` ` ` ! ! ! ` ! ' K ! ! ! ! ! E 6.6.! ( ! ! ( ! ! ^ ! ! ! ( A ! ( ^ Q Q Q 2.n Q Q j Q j Q j b j Q Q n j n j n j j o.k k k ( b g g b k b b k b s b s b b k s c k c c c c c c c c c b b ) m b m ) b m ) ) m ) m z l l s l t t l l y x y u x u y u u u u u u u u f.p u g.g.u g.u u u u u u y y w y w y w y y l s t l t s w q w y y y y y y y y w w y w w w i y y w p w i i y p u i y w i i w i i t q i i u i u u u v u v i t t 2 q t t t t t i 2 d.d.d.d.d.d.d.2 i f.d.i i u i u u y x l t y t i t t t t t 2 t t g 2 2 t x t t 5 2 < 2 0 @ o   ^ PXPXPXUXKXUXPXPXPXPXPXPXPXP .       . O # < < < < 1 < j ..t.DXFXFXLXFXFXFXFXFXFXFXFXDXDXDXDXDXDXDXZXZXZXZXF.F.ZXF.F.F.S.G.G.f # @ ; @ & ; @ ; a a < < g 1 a < < 1 # R kXPXPXPXPXJXvXbXUXKXUXPXPXCXN = = = r r e ; ; = g > h k > > f : a 5.G.AXAXGXAXGXAXG.G.G.C.5.5.>...( @ 0 R [ j.j.j.x.x.lXlXlXzXlXlXx.j.j.) k c j M j k b k.kX[ g _ *X*XY.*X*X&XP.C V |.U.Y.Y.Y.Y.Y.C C $ X . X S 5.5.Z.Z.Z.Z.A.Z.A.n.A.A.n.A.A.M.S.S.S.M.S.Z.M.Z.N.S.Z.",
        "~.~.Q.!.= r z.z.s.z.# DXUXh.O.+.+.X., = ~.R.R.R.Q.!.Q.(.W.W.W.!.!.Q.!.!.!.!.E.!.E.W.+X!.!.!.OX!.!.~.~.oX~.~.eX~.oXeXeXeX4XtXyXeXeXeX~.' w.7.7.7.7.7.7.` 0.*.' 6.0.6.` 6.' ' ' 0.q.' 0.0.' K A K K 0.' ' H K XXJ OXH F 6.8.` ' 8.8.' ' ' ] ' ' ' ' / ` ' ` ' ' 8.` ` ` ` ` ` ~ ~ ! 6.,.6.6.~ ~ ~ ` 6.~ ~ ! ` ! ` K ! ~ ! K ! A ! ! ! ! ' ' ' F ! _ ! ! ^ ! R ( ! ~ ! ( ^ ! ( ( ! ! ( ^ ^ Q 2.j 2.4.j Q j j Q j Q j n n  .n j j n M j j M b k k k k b s b s b b s l b l s l c b c k c k c j c j c l m l c b ) ) m m ) ) m ) m l l l l t t l y l t y y u u y y u u y x u u u u v u u u u d.d.v d.v u u u u y y y y y t y y y w q y q t q y w w e q y y y w w t w w y w w w w w w y y w y w w p y i i i i i w i t e q q t i i i i u i i u u w t t q 2 t t t t t t d.d.d.d.d.d.d.d.d.d.d.i d.d.d.i u u u u 2 t 2 t 2 t 2 2 t 2 t 2 t 2 t t 2 g 2 2 q 5 2 1 < +   o KXPXPXPXPXPXPXPXPXPXPXPXPXPXe..     . . . # # < < @ # @ Q X.Z.DXFXFXFXFXFXFXDXDXFXDXDXDXDXDXDXDXDXZXZXZXD.F.ZXF.F.F.F.G.G.Z.C.f # @ @ ; @ ; @ @ ; 0 < 5 < < 5 < < < # R kXPXPXJXCXPXbXbXHX$ ] PXPXVX( # = = = e r = ; a = k h > k e > : k Z.G.AXAXGXGXAXAXG.G.G.t.5.3.:.#.: ; [ E T _ l.j.j.j.lXlXlXlXlXj.k.[ f f r r k k k s s m zXbXR _ ;X*X&XY.Y.U.B C P.Y.U.*X*X*X&XY.B C * X . * Q 5.5.5.Z.Z.A.A.n.A.A.A.A.A.A.S.S.S.S.S.S.M.S.S.M.A.N.S.",
        "~.~.~.~.r a.z.z.2 z.+ zXz.s.c.h.+.X.= R.H H R.~.W.W.W.W.W.!.!.W.Q.!.Q.!.~.E.E.!.!.!.W.!.!.OXE.E.~.OXOX~.~.~.eXeX*.eXuXeXeXeXeXeXtX~.OXOX~.8.7.7.7.7.0.0.' 0.0.6.` 6.6.6.~.0.' oX0.' ' *.K F K F K ' K OXE.K K H XXF XX' ` ' 8.9.] oX' ] ' ' ' ` ' ' ~ ` K F J K ` ` ` ` ~ ` K K ~ ! ` ~ ~ 6.~ 6.~ ~ ` ~ ! ! ` ` ' ` ` ! ! ! F ! ! ! ' ! ! _ ! _ ! ! ( ! E ( ( ! ( ! ( ! E ( ( ( ( A ( ( ) 2.2.Q Q Q j Q j j j Q Q n n n  .M j n  .n j M j b k b k s b s b k l b c c b l b s l c c c c c b c c c c l l s l ) b ) ) b b ) b g l s l t t l t l y z x u y x u x x u u u u u u u u u u g.u u u u u d.g.u u u w y w y w y t w q q w s s t t w w e w w w w w w w w w w w y w w w y w w w y y w w i y i w i i t q < q q q 5 q i u u i u i i t t t t q i t t t t t t x d.d.d.d.d.d.d.d.d.d.i d.i i f.i i i y 2 t q i i 2 t t 2 t 2 i t t t 8 t 2 2 t 2 2 2 1 1 + .   N UXPXPXPXPXPXPXPXPXPXPXPXPXIXVX.           o # 1 1 1 # # Q { Z.ZXFXFXFXFXFXFXZXDXDXDXDXDXZXZXF.F.ZXZXZXF.ZXZXZXZXF.F.F.S.G.Z.Z.E # & ; @ @ @ ; @ < 5 < 5 < 2 5 1 < 1 # R kXPXPXR * KXvX$XbXCXJXPXPXHXkX; = = = e = 0 0 0 0 0 k k , > f = n C.G.AXGXGXAXAXF.AXG.G.C.5.3.:.W ; [ jX$X[ T 5 4 U [ [ l.R R R g f [ g s k k k r r ] [ s l.kXkX[ +XU.Y.J.Y.Y.L.U.*X*X*X*X*XY.I.Y.C C X X X 5 Q o.n.Z.n.A.A.A.A.A.A.A.A.S.S.S.S.S.S.S.S.S.S.N.Z.S.Z.A.",
        "T.).~.T.O.1 z.w o s.O s.s.s.s.u +...O ~.R.~.~.T.(.W.W.W.W.W.Q.W.!.!.E.Q.E.E.E.E.!.!.!.!.!.E.!.!.E.!.~.~.oX~.~.eXOXuXrX4XtX4XtXyX4X~.E.OX~.OX' 7.7.6.' *.' 0.' *.' 6.6.6.' oXoXeXeXK ' 0.' K F K F K E.H K E.E._ J E.K J ' 8.8.' ` ' ' oX' ' ' ' ! ' ' ! F F F F K A ` ` ' ! ! ~ ! K ! ~ 6.~ 6.~ ~ ` ~ K K ~ ! K ! ` ! K ~ ! ! ' F ' ! ! ' ! R F ! E E E ( ! ! ! ! ( ! ( A ( A ! ! ( ! ^ Q Q 4.Q 2.Q Q j Q n 2.n j Q Q j j n j j M n j j n k s s g b s b b s c s s l b s l s b c v c c c c c c c l b l b s ) ) m ) ) b x t s g l t l l q l t t s y y u y u u u z u u u u u u u u u u g.u u u u g.u d.u p w w w w y w y q e 0 0 q q q g w w e w e w w w w w w e i w y w w y w w y y w y y w w i i i w e q q q q q 0 q q y i i i i t t t t t t 2 i t t t t t 2 i d.d.d.d.d.d.d.d.d.i d.d.d.2 i d.i i i t 2 2 t 2 q 2 q t 2 t t 2 t 2 t 2 t 2 < 5 2 < 1 #       R KXUXPXPXIXUXPXPXPXPXUXKXKXKXKX&       . .   o # # < # # b ..Z.ZXZXDXFXDXFXDXZXZXF.ZXF.F.ZXF.ZXZXF.ZXF.ZXZXF.ZXF.ZXZXF.F.G.Z.Z.) # @ @ @ @ @ @ @ 5 < < < < 0 < < 1 1 < T %XUXPXKXVXJXHXVXKXUXUXPXPXUXKX] @ = = r = a 0 0 s 0 0 > k = : : 5.G.G.AXGXGXDXAXAXG.C.C.5.5.>.:.~ ; jXjXvXvXjX%XT 5 # @ @ d P x jXjXcX%Xg r s k p c kXbXl.T g kXk.( XXV K.U.*X*X&X*X*X*XY.Y.B Y.V C * o . & Q O.5.n.n.H.A.A.A.A.A.A.n.A.A.S.S.S.S.S.S.S.M.Z.S.N.N.Z.N.",
        "7X~.~.T...0 2 # ..O O M s.s.p O.r O K ~.W.W.W.W.W.W.W.W.W.(.W.W.!.Q.Q.E.E.E.E.!.W.OX!.!.!.!.!.E.E.E.E.~.OXoXOXOXrXOXuX4XtXeX0.eXoX~.OXOXOXK OX' 6.' 4X' 0.0.' ' *.6.6.6.` oXOX' oX' K K F K F F H ' H K XXH _ E.H _ E.E.E.' ' ' ' ] ' ] ' ' ' ! ` ` K K F F F F F A ~ ~ ! D D ! K A A ! ` ~ ~ ~ ~ ` ! ~ ~ ! ` ! ~ ` ! ! ! ` ! ! ! ! F ! _ ! R ! _ E ! ! ! ( E ( ! ( ! ! ! A ( ( A ( ( ( Q ^ Q Q j 2.Q n Q 2.n Q Q n Q j n n j n n j n j j n k s b s s b s l l c b l s b l c b l b v c c c c c c l c l g l l m ) m x 5 g x s s t l y t l x y t t t l u z x u u u u u u u u u u u d.u u g.u u u d.i y i w i q q q q w i e e q q 0 q q w e e w w w e w w w w w w w w w w p w p y w w y i w y y w q q q q 2 q t q q q < q t i i i t t t t t t t t t t 2 t t t x u d.d.d.d.d.d.d.a.d.d.d.d.f.i d.i 2 2 t 2 t 2 q 2 i 2 q 2 q t t t 2 q 2 t 2 t 5 2 2 1 1 o     . ] UXPXPXPXPXIXPXPXPXPXPXUXKXKXKXVX. * X .       + # # # # k ..n.ZXZXDXZXZXF.F.F.ZXZXF.F.ZXF.ZXF.ZXZXZXZXZXZXZXZXZXZXZXF.F.F.S.N.V.& & @ @ @ a @ 5 5 5 < q 5 5 1 1 @ @ # T CXJXPXPXUXUXKXKXKXKXKXKXKXKXUXVX( @ = = e e a 0 0 s 0 a f > ; a C.G.AXAXGXGXAXAXG.G.G.Z.5.3.>.#.f 5 jXjXjXcXcXnXjXmXlXcXMXvXMXnXnXnXnX[ s g k k a a ( kXcXjX[ kXkX< g E J B P.&X&X&X*XY.C * C B C * X o O f O.n.n.n.N.A.A.n.A.A.A.n.A.A.A.S.S.S.S.S.M.S.S.N.S.Z.M.Z.S.",
        "~.T.(.~.K O = e O , +.+.O.O.r = , R.!.T.W.W.W.W.W.W.W.W.W.Q.W.W.Q.E.E.E.E.!.E.(.(.W.(.!.OXW.!.E.!.E.W.XXOXuXOXOXrXuXtXeXeXtXtX~.!.~.~.E.OX!.' OXoX' ' oXeXK 0.6.6.' 6.6.6.!.XX!.OXE.F F F ' F K XXK XXE.K E.E.K K XXE.K J H K ' H K _ OXoX' ` ' ' ` A F F F F F F K K A ' A ! K D ! A ! D K ` ~ ` D ~ K ! D ! K K ! A ` F A ! F ! ! ! _ A ! ! E E ! ! E ( ( ! ! ( E E ! ! ( ( A ( A ^ ( ^ ( Q Q Q Q 2.n Q n 2.j j Q j j j j M j n j j M n j n c s b b c c c b s b s l b b s l c l c z b c c c v l l g x d 4 g b d 4 g 5 s s l t q l s t q l s y t t y t y z u u u u z u f.u u f.u u u i i p y y w i w q e q e i w w w e e 0 e e q 0 e e e e e w w w e w w w w w w w w w w w w y w w w w w w i 1 q q q q q < < q q q q < w i t t t t q i q i t t t t t t t z d.d.s.2 d.d.d.d.2 d.d.2 d.i i i i i i 2 i 2 2 2 t 2 t 2 t 2 2 2 2 t 2 2 2 5 2 2 1 1 1 # . o o & KXPXPXPXPXPXPXPXPXPXPXPXPXPXIXKXUX]   X X     . o # @ + # s X.+.F.F.F.D.F.F.ZXF.ZXF.ZXZXF.DXZXZXZXZXZXZXZXZXZXZXZXZXZXF.F.F.G.A.Z.E # < & @ < < 1 < < 1 1 1 1 @ 1 1 1 + R VXUXIXUXKXVXKXUXUXUXIXIXKXVX[ VXNX= = = = = 0 0 0 0 0 0 ; = @ j r.G.AXGXGXGXDXAXG.G.Z.r.r.>.>.#.@ R jXcXcXxXxXnXnXnXnXmXMXMXmXnXnXnXcXP s s r b ( g 0 1 [ zXMXmX[ @ @ ; ( E V B L.K.C C C Y.J.J.N * X & k  .o.5.n.n.Z.M.A.A.H.A.A.A.A.A.n.S.S.S.S.S.S.S.S.M.S.S.S.S.S.",
        ").T.7X~.!.T.O O L = O = = = = L T.~.Q.W.W.W.W.W.W.W./.W./.W.W.W.!.Q.E.E.E.E.!.!.W.!.!.!.!.!.OXW.W.+XXX+X+XOXOXuXrXtXuXtXtXtX~.).!.OXOX!.OX' ' OX' oXoXK ' ' oX' ' OXOXXXE.XXOXE.OXXXJ F J K E.' K H ' E.K E.J _ K J J E.XXH K F ' ' J ' _ ' ' ' ! K F F F F K A F A A A A K F ! A K ! D ! A ~ ` ! D ` ! K ' K ! ~ ! A ! ! ! ! ! ! ! E E E R F R ! R F E ! E ( A ! A ( ( ( A ( A E ( ( ( ( ^ ( 2.2.j Q Q 2.Q n Q Q n 4.j j j j j c j M k M  .n n b s b b b b l l l b s s l s c b v v g x g 4 4 4 4 4 g 8 4 4 4 5 5 5 g a x s y s l t s t l t l s t t q t t y u u u f.u f.u u u u u i u i y i i y y y e q e i q q q i e 0 0 e q q e 0 e e e e e e e w w w w w w w w w w p w w w w p w w w w q q q 1 q q q < q q q < q q 0 q i t t t t t t t 2 q 2 t t t t i f.d.d.s.d.d.d.d.d.d.2 a.d.2 d.f.a.2 f.2 2 i t t 2 t t t 2 t 2 2 2 2 2 2 t t < 2 1 1 1 1 +   * . CXPXPXPXPXPXPXPXPXPXPXPXPXPXPXPXPXUXKXX . X o   .   + 1 1 9 2 O.O.D.S.G.F.F.ZXF.ZXZXF.ZXZXDXDXZXZXDXZXZXZXZXZXZXZXZXZXZXZXZXF.F.A.A.V.& # @ < 5 5 < 5 1 5 1 5 5 < < @ # + [ KXKXKXVXVXVXKXKXKXKXKXKXHXBXT kXKX) @ @ 0 0 0 0 a 0 0 a @ @ @ 1.Z.AXAXDXGXAXAXAXG.G.C.5.5.>.{ > # Y cXjXcXjXxXnXnXnXnXmXMXMXmXnXnXnXjXd = s s kXMXkXq a g kXmXmXkX_ +X+X_ f S S C B J.J.J.J.C G N $ X ( M O.o.n.n.n.A.n.A.A.A.A.n.A.H.A.A.N.S.S.S.S.S.S.S.S.S.S.S.S.S.",
        "~.!.~.T.!.~.~.R.R.H R.H L R.H R.!.Q.(.(.Q.(.W.W.W.W.!.W.(.W.(.W.W.(.(.E.~.E.(.W.!.+X!.+X!.+XW.XX+XW.+X+X+X+XOXeXuXeXtX4X4X!.!.~.).~.~.OX!.OXE.~.!.OXOX!.!.!.!.!.W.OXE.E.XXE.OXE.XXOXH E.J H J J H ' H K XXE.K E.E.E._ K E._ XXH E.J ' H ' J F ! F F F F F F K F A K F K A ! ! D ! A D A A A A D ! ' D ! ! ! D ! K A ! ! K ! A ` ! E F ! F ! E E F E ! E A ( E ( ( ( ( A ! ( A ( ! R ( ^ ( R ( ( Q 2.2.Q j Q 2.n j 2.j j j n c k n k j j j M j n k c s s s s s b c s c c s b s s 4 5 3 5 3 5 3 g 4 g 5 4 4 g g 5 g g 4 x g t l t q l l t t s t t w s q q q t q y u u u u u u u u u u y p y u y y i w i q q q q q q q q e q 0 e < 0 w e e e e e e e e e e e w w w w w w w w w w w e w w w q i q t i q q q t q q < q q < q < i t i i t t t t t i t t t 2 i x x d.d.2 d.d.d.d.d.d.d.d.f.d.2 d.2 d.8 i 2 2 8 2 2 2 2 2 t 2 2 q 2 5 t 2 5 2 2 2 5 1 1 1 o . X % IXPXPXPXPXPXPXPXPXPXPXPXPXPXPXPXPXPXPXE & & O .     + + 1 + 1 4.+.N.t.S.G.F.F.ZXF.DXZXDXZXZXZXZXDXZXZXZXZXZXZXDXZXZXZXZXZXZXZXF.F.F.A.[ # # < 1 < < 1 g 1 < < < 1 1 1 @ # k.KXCXVXCXVXVXVXCXVXCXVXVXVXk.E e.KXVXd @ < 0 0 a < 0 < a @ 5 @ 5.C.G.AXGXGXDXAXG.G.G.t.5.5.>.;.f & jXjXcXjXnXnXnXnXnXmXmXMXMXnXnXnXnX[ a a e w y kXcXzXkXcXmXjXjXMX|.;X}.V E = : A C B C C C V V C * * h p o.O.n.n.A.n.A.n.n.A.A.A.A.n.n.A.N.S.S.S.S.S.S.M.S.S.S.S.S.S.",
        "T.~.~.T.~.!.!.!.~.H E.H G H H H !.!.(.W.W.W.W.W.W.W.W.(.W.W.W.W.W.(.W.!.W.W.+X!.W.!.W.W.XX!.W.+X+X+XW.W.+X+X+XOXrX4XtXtXOX!.!.OX~.OX!.!.OXW.#XW.+X!.!.!.OXW.W.E.W.W.!.~.XXXXE.~.E.~.E.E.E.K E.K XXE.K H K K XX_ E.OX_ H H XXK E.E._ K _ ' F F K F F F F F K F F A K A K D ! D A S A A A ! D A A F K ! D K ! D D ! ! ! A ! A ! ! F F F E E E ! _ A E ! ! E ! ! E E ( A ( ! A ( ( ( ( R ( ( R ( ( 2.j 2.Q Q Q Q Q Q j j j k b j b j b j j j j n n n j c s s s s s s c c 4 5 4 5 5 5 5 P 3 5 3 5 4 4 x 5 5 4 x 4 x g d 5 g s t l q l t t l t l t q q t g t q s q t t q w i u u u u u i y u y y y y w w q w i e q q q q e q e q 0 e e e e e e e e e e e e e e w w e w w w w w e w w w e e < q i 2 q q q 2 e 1 q q 2 q q < q < i i q 2 q q i t q i t t t 2 u z x d.d.d.d.d.d.a.d.d.d.2 d.d.2 f.d.2 d.d.2 8 8 8 8 2 8 8 2 2 < 2 < 2 t 2 < 2 2 1 < 1 1 # . * . CXPXPXPXPXPXPXPXPXPXPXPXPXPXPXPXPXPXPXPXNX. . X . .   . + 9 1 1 X.O.+.N.G.F.F.ZXZXZXZXZXDXDXZXDXDXZXDXDXDXDXDXDXZXDXDXDXDXDXDXZXZXF.F.S.C.T # 9 1 1 < 1 < 1 @ 1 1 < 1 # # 4 VXCX_ NXVXVXCXVXCXVXVXVXVXCX] E CXKXKX] @ @ 0 @ < 0 0 < < @ & g 5.G.AXZXGXDXAXAXG.G.t.C.5.3.3.{ & 4 jXvXcXcXxXxXnXnXnXmXmXMXmXnXnXnXnX[ a a e g e k [ kXbXlXj.g [ kX{.&XL.C R = @ S L.U.Y.I.&XY.&XY.C * f k o.n.+.n.n.Z.n.A.H.A.n.A.A.A.n.A.A.M.S.S.S.S.S.S.S.S.S.S.S.M.",
        "~.(.~.!.(.~.T.!.R.R.P 5 N H H R.T.!.T.!.(.W./.W.(.W.W.W./.W.(.W./.Q.(.W.W.(.W.W.+XW.#XW.!.XX+XW.W.XX+X+XXX+X+X+XOXtXuXOX#X(.(.(.(.).(.(.!.OXW.OXW.OXW.!.OXE.OX!.OXE.XXE.E.~.E.OXXXE.E.E.E.E.J E.K E.OXXXXXH F H K H E._ K XX_ E.E.H E.K J F ' F F F K F F F F D K A F A F F A A A D A A A A A L A A A ` ! ! ' A F A A A D ! A A ! E ! ! ! F A E ! ! _ E ! A ( E ( A ( ! A ( ( A R ( ( E ( ( ( ( Q 2.Q Q 2.Q Q Q Q Q ( Q ( k j k j b b k b n j n j f T f f f f f b b c 5 4 5 4 5 4 3 5 5 5 5 5 4 4 g g g 5 a d t 5 t g g g s t l t s s t s t l q q s q q q q q y t < < < i u u u u u u u u i i y w w w q w q q q i e e 0 0 q e q 0 e e r e e r e e e e p e e e w w e e e e w e e e e e e q q q t q q w 1 q q q q q 0 < q q q i 2 t i i 2 t 2 2 t t t x z z z i f.2 a.d.d.2 d.d.d.d.i a.i d.8 a.i 8 a.2 8 2 2 8 8 8 3 2 2 2 2 2 2 2 < < 2 1 2 1 1 + o X O UXPXPXPXPXPXPXIXPXPXPXPXPXPXPXPXPXPXPXPXKX    . X     . 9 + + + b +.+.Z.Z.F.ZXZXZXZXZXDXDXDXDXDXDXDXDXDXDXDXDXZXDXDXDXDXDXDXDXDXDXDXZXF.Z.5.R @ # 1 1 @ 5 5 @ 1 1 1 # 1 # [ KXCXE ] CXVXVXCXVXVXVXCXCXVXE ] KXKXKXNX5 # @ < < 0 < < = @ @ Q Z.G.AXFXGXDXAXAXG.G.G.Z.r.>.:.h # [ jXcXjXcXnXnXnXnXnXmXMXMXmXnXnXnXjXx 0 g s s f e s g b g ; @ < XXU.Y.G C T T E _ I.*X*X*X*X&X*X}.V * f k O.o.5.5.n.n.n.N.n.n.A.A.n.A.H.A.A.Z.S.S.S.S.S.S.S.S.S.M.S.S.",
        ").~.7X~.T.~.!.Q.~.E k.] [ P R.R.Q.!.!.(.W.W.W.W.W./.W./.(.W./.+X(.W.(.W.#XW.W.(.!.W.!.!.W.W.W.XXW.+XW.+X+X+X+X+X+XuX#X+X#X!.!.!.(.(.(.OX!.W.XX!.OXW.W.OXW.W.W.W.XXOXOXE.OXE.E.XXOXE.E.OXE.E.K E.XXH H ' J OX' H H K K E.E.J E.' E.H E._ ' J F F F F F F F A F F K A K A ! F K A A A A D A A A F F A A F D K F A S A D A A A A F F F E A E A ! A E E E ! E ! E ! ! ( A ( ( ! A ( ( E ( E R ( E ( ( Q 2.Q Q Q Q ( ( ( ( f ( ( ( b j k j b j j j k d S d f d f d d f g f 4 5 5 4 4 5 4 5 3 3 5 5 d 5 g g x g 5 g 4 g g g 5 g q x t l x q g g s s q q q 2 g q q s q w 0 < e < e w u u u u u u u y y q e w e w q i q q q 0 e q e e < q e e e e e e e e e e e e p e w e e e e p e e e e e e e q 2 t q 2 q q t q q q q < < q q q < t t t q i t t t i q t 2 x z z z z z d.x f.f.x 8 8 i d.a.2 f.2 d.8 8 8 8 8 8 8 2 2 7 8 2 1 2 2 1 1 2 2 2 < 2 1 1 1 # o X . R PXPXPXPXPXPXIXPXPXPXPXPXPXPXPXPXPXPXPXPXUX.   . X       + + 1 + g 5.+.Z.G.F.ZXZXZXDXFXDXDXDXDXDXDXDXDXDXDXZXDXDXDXDXFXDXDXFXDXFXDXDXDXDXZXN.O.4.a @ 1 < 5 1 1 1 1 # 1 + + NXKXVX[ E NXCXVXVXCXVXVXCXVXBXR VXVXKXKXCX& # @ < @ < @ < 0 # % 4.G.AXDXKXFXAXAXAXAXC.C.r.5.>.#.f & ].jXcXcXxXjXnXnXnXmXmXMXMXmXnXnXnXkXa 0 0 g r s e s e g a g = d {.*X;XL.$ % & N V Y.&X*X*X*X*X&XP.V * & b k O.n.n.n.Z.Z.n.n.A.A.A.A.A.n.A.N.n.A.S.S.S.S.S.S.S.S.S.N.N.",
        "T.!.T.(.~.!.!.W.T l.SXSXl.x 5 ).(.W.(.!.(.Q.W.(.W.W.W.(.W.W.(.W.Q.(.W.W.+XW.+X(.W.W.XXW.+XW.W.+X+XW.+X+X+X+X+X+X+X+X#X+X+X(.(.(.OX).(.#X+X+X!.!.W.!.+X!.!.OXOXW.E.E.E.XXE.!.E.E.E.E.E.H E.E.E.E.K E.E.E.E.OXH E.XXE._ H K XXJ H E._ E.K _ F F F K F F F F K F F A A A A A A ! A A D F D A A A J L F A A A A K D A A A A A A A A ! A E A F ! E ! ! E ! E ! E ! ( ( E ( A A E ! ( R ( R F E S ( S E Q Q Q Q ( D ( E ! ( E ( ! ( k b ( j j j j E d d S S d d : d d : ; % 4 5 4 5 5 4 5 4 5 4 4 5 4 x g 4 4 g x g g g g g g 4 g g g t g s x t x s t q 0 q q q t q t q < 0 < @ < 0 q t u u u u y i q e q e q q q e q q q 0 q e q q e e e e e r e e e e e e e e e e e e e e e e e e e e e e q 0 e q q q q t q 2 q q q t q q < q < q i 2 i t t t t i 2 2 t z z x f.x z i x x x f.f.x x x a.x x 8 8 8 8 7 8 8 8 2 8 8 2 3 1 1 2 2 2 2 q 5 2 2 1 5 1 9 o   X . CXPXPXPXPXPXPXIXPXPXPXPXPXPXPXPXPXPXPXPXPXIXX . . X .   . + + + + 9 C.+.+.S.F.F.ZXDXDXZXFXFXDXFXFXFXDXFXDXFXFXFXFXFXFXFXFXFXFXFXFXFXDXDXDXZXZX+.O.) 1 # 1 1 1 # 1 1 1 # # & CXKXKXCXR ] CXCXCXCXCXCXCXCXiXNXVXKXHXKXCX@ # # # 1 @ @ @ < # E 5.G.G.AXAXAXAXBXG.G.G.t.5.>.:.| : % jXjXjXjXcXxXnXnXnXmXmXMXmXnXnXnXnX[ = a 0 e k s c s s s w s s g XX&X&XB N S $ C U.&X*XY.Y.U.U.L.V N X X E k o.O.5.n.5.n.n.n.Z.n.A.n.A.A.A.A.Z.A.S.S.S.S.S.S.S.S.S.S.S.",
        "7X!.T.~.E.!.E.x l.SXSXv.l.j.a.3 !.(.(.(.(.(.W./.W.W./.(.W.(.W.W.(./.W.W.W.(.+XW.W.W.XXW.W.W.XX+X+XW.+XXXXX+X+X+X#X+X+X#X+X#X#XOXOX+XXXXXXXOXXXOXW.OXW.W.OXW.W.OXE.E.XXE.OXXXE.E.E.E.E.OXE.E.K ~.E.E.E.E.OXH J _ ' J _ E.K E.H XXE.H XXJ K F F F K F F F F K F F A D F F A A A A A A D A D A F L J L J S F F A F K A A A A A S A ! A E A E ! E ! ! E ! ! E ! E ! ( A ( E ( ( R ( E ! E V V J A : S ( k S S : ! E A ( S ( E ( ( h b j j ( k E T ; S T S : ; ; ; S d ; d 4 5 4 5 5 5 4 4 5 5 4 5 g g 4 x g g g g g g g 4 4 4 P 4 4 4 g g x g x w s q g q q t q q q 0 @ < < 0 < e < < 0 t u i u t q q e e q q w q q q q e q 0 e e q e e r e e e e e e e r e e e e e e e e e e e e e e e e < 0 0 q q q q q q q 2 q 1 q q q < q q q 2 2 i i q t t 2 t 2 z z x z f.u x x f.f.x x x f.x x x 8 8 7 8 8 7 8 7 8 8 2 2 8 2 2 2 1 1 < 2 5 2 2 1 5 1 9 1 + .   &   KXPXPXPXPXPXPXUXPXPXPXPXPXPXPXPXPXPXPXPXPXIXX . . o       o + + + + g.Z.N.S.F.ZXZXDXDXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXDXFXFXFXDXZ.O.j # 1 + # 9 # 9 # + + + & VXKXKXKXNXR NXCXCXCXBXCXCXCXkXCXVXVXVXVXCX5 @ # + & + # 1 # # b C.G.e.4.^ : f f : NXNXe.] ] NXk.e.V.%Xk.%XV.k.JXnXnXnXmXmXMXmXnXnXnXcX[ = 0 s r g s s s s p s w w a ( I V B N & & C }.*X*X*X}.J.B C V N X X f j  .O.n.5.n.n.5.n.n.A.n.A.n.A.A.A.A.A.A.S.S.S.S.S.S.M.S.S.S.",
        "~.!.~.).!.OX[ l.SXSXzXh.h.v.l.[ 5 E.).#X#X#X(.W.(.W.W.W.W.(./.(.W.W.W.W.W.+XW.W.W.XX/.W.W.W.+XW.XX#X#X+X+X+X+X+X+X+X+X+X+X#XXX+XXXXX+X%XXX+X!.XXOXW.XX!.W.W.OXE.OXE.!.XXE.E.E.!.E.E.E.E.E.E.E.E.E.E.E.K E.' J E.J E.E.F E.J ' XX' E.XXK H F H F F F H F F F F F A K A A A ! K D A A A A A A L J S J S F F F F A A K K A A A A A A A F A A A A E E ! ! E ( ! ( ( E ( ! D A ( ! E ! E G G J J J S ( D f S d S S E S S ( E ( f ( ( ( ( ( k E S S S : N : N S : % ; % ; % % 4 5 4 4 4 g 5 5 g 4 4 4 g g g g g x 4 g 3 4 4 4 4 4 4 4 4 4 t g 8 g g t q q q q q q q q < 0 0 q < q q < q 5 a < q u g 0 q e q e q q q e w q q q 0 q q q e e r = r e e r r e e e e r e e e r = e e = e e < 2 5 < < q 0 5 q q q 2 q q q t q q 0 q q < < 2 t 2 2 t 2 t q 2 t x z z z x z z u x x x x 8 8 8 7 8 7 7 7 7 7 7 7 7 7 7 8 8 3 3 3 1 1 5 t 2 2 2 2 2 2 1 1 1 +   . 4 . UXPXPXPXPXPXPXUXPXPXPXPXPXPXPXPXPXPXPXPXPXPX*   X .   .   + + + 9 + g AXZ.S.F.F.DXDXFXDXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXFXn.5.< # + 1 # < a < 1 < 5 # P CXKXVXVXVXCX] NXNXNXBXiXNXNXNXCXVXVXVXVX%X%XI [ ] [ R R d < # ) 2.( ; & # @ O @ @ ) &                         kXnXxXnXmXMXMXmXnXnXnXjX% @ 0 0 s s k w s p s s s s w a ^ _ Q.J.* * B *X*X;X*X*XP.V C V * * o d M O.o.O.+.n.n.n.n.A.A.n.Z.n.A.n.n.A.n.A.S.S.S.S.S.S.S.B.S.S.",
        "~.).(.!._ [ l.CXSXl.3 5 x [ l.V.] 5 E.#X).#X(.#X/.W.(.W./.W.(.W.W.W.W.Q.W.W.W.XXW.W.W.W.+XW.W.+XW.+X+X+X+X+X+X+X+X+X+X+XXX].XXXX+XXXXX+XXXXX!.OX!.!.W.OXW.W.!.E.E.E.E.E.OXE.E.E.E.OXE.E.E.E.E.E.E.E.E.E.E.E.J K _ XXH XX_ E.J H K XXH F H F F H H F F F F L F F A A A A K ! A F A A K A A F J L L L J F F H F H F K F F F F A A A A A ! E S A A E ( ( E ! E E ( ! ( ! E ! ( R R E J G G G J G G S ( S ( S S S S ( S S ( f E ( f ( k f S S d d S S : T S S & % ; % ; ; % 5 4 g 5 5 4 4 4 5 4 5 5 x g 4 g 3 4 4 P P 4 4 P P 4 4 [ 4 4 4 x g g s x g q g q g a a 0 a 0 0 < 0 0 0 < < 0 0 5 < a < q q e e q q w q i q w q e e q q e e e e e r e e e e e e e e e e e e e e = e e e e 0 3 7 3 7 5 < 0 q q q q q t 1 q < q < 2 2 t 5 q 2 2 2 2 q 2 2 2 t 2 2 i x u f.x x x x x 7 8 7 7 7 7 7 7 7 8 8 7 7 7 7 8 7 2 2 3 3 2 8 8 8 2 1 q 1 1 1 9 # 1 +     * . IXPXPXPXPXPXPXIXPXPXPXPXPXPXPXPXPXPXPXPXPXIXX . X         o 9 9 1 + 1 BXS.S.F.ZXDXDXFXFXFXFXFXFXFXFXFXFXFXFXFXFXLXLXFXFXFXFXFXFXFXFXFXFXFXFXZX+.C.< 1 + 1 1 d k.%X%X%X%X X].HXVXVXVXVXVXNXNXNXNXNXNXNXiXNXNXVXVXVXCX X XvXvXvXNXNXNX] a @ ; @ # # # # @ # @ @ g.*                         bXjXjXxXmXMXMXnXnXnXxX[ a = 0 s s e c s s s k w s s s 0 0 f g E N V I.*X*X;X&XY.L.N C N * X X a p o.n.o.n.n.n.n.A.n.n.A.A.H.A.n.A.A.Z.N.S.S.B.S.S.S.S.S.M.S.",
        ").!.).S [ [ 8 7 5 % NXVX] 5 4 g 5 P 5 (.#X(.#X#X#X(.(.W.W.(.W./.(.#X!.XXXXW.G L.W.W.W.W.W.XXW.W.W.+X+X+X+X+X+X+X+X+XXX+X+XXX+X+XXX+X+XXX+X+XXX+X+X!.XXW.W.OXW.XXW.E.E.E.E.W.E.E.E.E.E.OXE.E.E.E.E.K E.E.E.~._ E.E.K ' H E.K XXK J E.H F F H F F H H H F H F F F F F A A A A A A K A K A A G L J J J F H L J F F F F F L F A F A F A E A F A A A A E ! ! ! ( ! ! ( A ! ( E E R ! J V J G J V J G J S S S S : S S E D E D E ( ( ( k ( E E S S S S N S N N N S & ; % % ; @ 5 4 5 4 4 g g 5 d 5 d 4 4 4 4 P 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 2 g s g q 5 a 0 a a a < a q 5 0 q < < 0 0 < q < q 0 q q e q < q q q q q q q e < e e < e e e r e e r e r e e r e e r e e e e e r e e e 3 8 3 3 3 3 7 3 1 q 5 0 < q q q t q q q 0 < 5 2 2 i i 2 2 2 2 2 2 2 2 2 2 2 u x 8 8 8 7 7 7 7 8 7 8 7 8 7 7 7 7 8 8 7 7 7 2 3 2 7 8 x 2 5 5 2 2 2 1 1 1 1 # o * Y * * UXPXPXPXPXPXPXUXPXPXPXPXPXPXPXPXPXPXPXPXPXKX. X . X X + . + + 1 9 9 1 ) DXS.F.F.DXDXFXFXFXFXFXFXFXLXFXFXLXFXFXFXFXFXFXFXLXFXLXFXLXFXFXFXFXFXF.t.BX# 1 1 # # [ CXCXBXkXbXvXvXvXHXVXVXVXCXCXiXkX%XNX] NXV.%XNXVXVXkX X X:X1XvXvX1XCXCXNXT # @ @ # # @ @ @ @ 0 < V.#                         zXjXjXlXcXMXmXnXnXnXxX[ @ 0 0 k s w s s e p s e s w s s s 0 = = S V U.Y.*X&XL.V C N $ * O X o f k o.o.n.O.b.n.n.n.n.n.n.n.n.A.A.A.n.Z.N.S.S.S.S.S.S.S.M.S.S.",
        ").).!.(.(.).~.(.P CXIXUXVX] N (.#X).).#X(.#X(.(.(.(.(.+X(.(.W.(.OX+X#X+X!.XXQ.V V G E.XXXX+XW.+XXX+X+X+X+X+X+X%X%X+XXXXX+X].XX%X%XXX+XXXXX+XOXOXXXOXW.W.OXXX!.W.OXE.E.E.E.W.E.E.OXE.E.E.E.E.K E.E.E.E.E.~.E.E._ _ K ' J F XXK XXE.H J F F H J H F H H F H F H F H L F F S F F F A K A A L H L H H F H F F H F J F L F F F A F A E A F A A S J S F S ! ( E ( E ! A ( A ! R R R J J G J G G J J N J S S S S N S S S A A ( S E E E S E E S S T S N - N S - N N N & & ; % % 5 5 % 5 4 4 4 4 4 4 4 4 4 4 P 4 4 4 P 4 4 4 4 T 7 T 4 4 P 4 4 4 4 4 s g g 5 g a 0 g a < < a 5 0 < a a < 0 0 < q 0 0 0 < ; 0 0 0 0 0 0 a q 0 0 0 0 q 0 0 e q 0 q 0 e e e r e e e r r e e r e = e e e e e 3 3 3 3 3 3 3 7 3 3 7 5 < 0 < q q 2 t q q 5 5 2 < 2 2 2 2 2 2 2 2 2 2 2 2 8 7 7 7 8 7 7 7 7 3 8 7 7 8 7 8 7 7 8 7 8 7 7 8 8 8 4 8 8 8 8 5 2 < 2 1 1 1 1 9 + 9 cXxXxXC [ IXPXPXPXPXPXUXPXPXPXPXPXPXPXPXPXPXPXJXbXbX*   .     % X o + 9 9 1 1 < BXF.F.F.DXDXFXFXFXFXFXFXFXLXFXFXFXFXFXFXFXLXFXFXFXFXFXFXFXFXFXLXFXFXN.DX) + 1 + 1 @ ] CXVXkX XvXvXvX:XkXVXVXCXVXCXiXk.%XV.NXkXe.V.V.CXkX].]. X:XvXvXvX$XVXCX%Xg # @ # @ @ @ # @ < < q V.*                         kX.XjXjXjXmXmXnXnXnXjXd < 0 0 w s s s e s e s s s s s e s : e = ; N C L.L.V R.C N $ * * X X X R p o.o.n.b.n.n.n.n.n.H.n.n.n.A.n.n.A.A.n.A.S.S.S.S.S.S.S.S.S.",
        "(.#X#X(.(.(.(.).P k.CXVXV.^ 4 #X#X#X#X#X#X(.(.#X(.).(./.(./.W.(.#X(.OXOXOXW.W.E.'.J E.Q.W.W.W.+XXXW.XX#X+X#X#X+X+X+XXX+XXX+XXX+X+XXXXX+XXX+XXX+XXXW.OX!.W.W.E.#X#X!.XXE.E.E.W.E.E.E.E.W.~.E.E.E.E.K ~.E.E.~.E.H E.XXH XXE.J E.H E.F F H F H H F H K J F H J H H H H F F L F D F F A F D T.H G L F J L H L F F L F J F F F F A F F F J G A L A A A A A E ( ! ! ! ! ( ( ! ( R _ G V G V J V L G J J G J S S S S S S S S A S ( A S A S S T S S S S N N N % N S - N N ; % : % 5 5 5 g d 4 4 4 P 4 P 4 P 4 4 d 4 4 4 4 T 4 4 P x 4 4 g 4 4 d d 4 4 l s a a q a < a a 0 a 0 0 q < < a 5 0 0 0 0 < a 0 0 0 0 0 0 0 0 @ 0 0 0 ; 0 = 0 0 = < 0 = 0 0 = 0 e e e e e e r e e e r e e e e 0 5 2 3 3 3 3 5 3 3 3 7 7 7 3 3 5 < q q < 2 t < q < i i 2 2 2 2 2 2 2 8 7 3 7 7 7 7 7 7 8 3 8 7 8 8 7 8 7 7 7 8 7 7 7 8 7 3 8 8 8 8 2 3 2 3 2 2 2 2 1 1 9 + 9 Y xXxXxXxX* R UXPXPXPXPXIXIXPXPXPXPXPXPXPXPXPXPXMXnXnX*       . o .Xj.+ 9 1 1 + 1 k.AXF.F.F.DXFXFXFXFXLXFXLXFXLXFXLXLXFXLXFXLXFXLXFXLXFXFXLXFXFXFXLXF.F.AX1 1 # 1 # # ^ %XVXCXvXvXvXvX X X XkXCXVXCXNX%Xk.iXiXk.%XkX%X$X X]. X1XcXvXvX1XHXVXVX] d @ 0 @ @ @ @ < = < e < k.#                         kXY Y jXjXjXnXjXjXjX[ < 0 g a e s s s s s w s s s w s w p e r ; f V C N N C C C N & + * + o & b r o.o.b.b.O.b.n.n.n.n.n.n.Z.A.A.A.Z.n.A.A.A.S.S.S.S.S.S.S.S.",
        "#X@X).] 8 3 x 7 3 g [ l.[ 7 9 1 5 d % ).(.#X)./.>X(.#X/.(.W./.(.#X#X#X#XOXXXXXE.J Q.XXQ.W.W.XXXX+XXX+X+X+X#X+X+X+X@X+X+XXX+XXXXX+XXXXX+X+XXXXX+X!.OXW.W.!.XXOX@X@X%XOXXXE.E.E.E.XXE.E.E.E.E.E.E.E.E.E.E.K E._ E.E.J E.K K Q.E.G F H H F H F H H H H J H F H H H G L T.L J F F F K A A K H G L H F J H L H F F F F F F A A A F A G L G L G G J S A A A A ! ( E ( A ! ! ^ R E G G J V J G G N N G N S N L S S S S S S S S S S A A S A S S N S N N N N L N - S N N : % % % 5 & % 5 4 g 4 P 4 P 4 4 4 P 4 4 4 d x P 4 4 g 4 g d 7 4 4 d x P d 4 P ; 5 a a a a 0 a < a < < a a 0 < < < 0 < a 0 0 a 0 0 0 0 ; 0 ; 0 0 0 ; 0 0 = 0 0 0 0 0 0 0 ; 0 a < q q 0 e e e e e r e r e r r e q 3 5 3 3 3 3 3 3 3 3 3 3 3 3 8 3 3 3 q q q < 1 5 < 2 2 2 2 2 2 2 7 7 7 7 3 8 8 7 7 8 7 7 8 8 7 7 8 3 7 7 7 8 [ 8 8 7 8 7 3 8 3 8 8 8 2 8 2 8 2 2 1 1 Y Y Y .XcXxXxXxXxXcX. & KXPXPXPXPXPXPXPXPXPXPXPXPXPXPXPXbXxXcXX         C nXxX+ + 1 1 + 1 1 V.DXF.ZXDXDXFXFXFXFXFXFXFXLXLXFXFXLXFXFXFXFXLXFXFXLXFXFXFXFXLXDXA.GXV.# # 1 # 1 # [ VXVXHX$XvXvXvXjX X X].]. X%X%X%XkXkXkX$X$X$X X X X X]. XvXvXvXbXCXVXVXNX@ @ # @ < 0 0 0 q < q 1 k.#                         V.6 Y Y ].j.[ [ g < @ 0 0 e g s a g 0 s s 0 s w k 0 p c c p s = E /.Y.V C * * $ X * C * * & X ( k o.b.O.n.n.b.n.n.n.n.n.n.H.n.A.n.H.A.A.n.M.A.S.S.S.S.S.S.M.",
        ").).).).OX[ k.SXl.l.7 2 8 8 j.l.[ d _ ).(.).#X#X).(.(.).(.(.+X#XOX#X#X#X@X#XXXQ.XXXXQ.W.XX+X+X+X+X+X+X%X+X%X+X+X%X#X+X@X+X%X+X+X#XXX+XXXXX+XXXXX#XW.XX!.OXOX@X@X@X@X#XOXXXE.W.E.E.W.E.E.E.E.E.XXE.E.E.K XXJ H E.E.' _ G E.E.E.K K F H F K H F F F H H H H H H J G G G G R.R.H F A A A H T.T.G G J L F H L H H F F F F F L J L H H G H V G L G G F A A D A A ( A ( E R R E G G G G G G J G J J J J J G N S N S S S S S J A A S S S S J N S S $ N L N N N N N L N N N & ; % 5 % % & d 4 4 4 4 4 4 4 4 4 4 d 4 4 4 d 8 P d 4 4 d d 4 4 4 4 % 4 4 ; % = 0 a a a a a a < a a 5 0 a 0 a a < 0 0 0 0 < 0 = 0 0 0 0 0 0 0 0 0 0 0 a ; 0 0 ; 0 0 0 0 0 0 q 0 0 < 0 0 e e e e e e e e = q 5 2 3 5 2 3 3 3 3 3 3 3 3 3 3 3 3 7 3 7 3 3 5 2 < 1 2 2 2 7 9 2 3 8 7 8 7 7 7 7 7 7 8 3 7 7 8 7 7 8 7 8 8 7 8 7 7 8 3 8 7 7 8 8 2 8 a.8 2 2 5 1 1 Y cXxXxXxXxXxXxXxXxXnX.X  X VXPXPXPXPXPXPXPXPXPXPXPXPXPXUXbXnXxXY . . . C jXxXjX+ + 9 9 1 9 x VXLXFXFXGXLXFXGXFXLXLXLXLXFXLXLXLXFXLXLXLXFXFXLXLXFXLXLXLXLXLXFXGXUX) + + 1 1 + + T VXCXCXBXkXvXvXvX X XU ].]. X X X]. X X$X$XvXvX X$X X X:XvXvXvXNXNXCXCXNX& # # < # # @ < 0 1 < q m BXV.V.V.V.V.CX&           k.o X * # # # + # < = < a 0 0 s w e s 0 s s a s w s s p w w k ; E >X*X;XJ.C * * C N ].lXY * X d p p p o.O.b.n.O.b.n.n.n.n.n.n.n.A.n.A.n.A.A.S.S.S.S.B.S.S.S.",
        "-X@X).).#XXX[ l.SXSXzXh.l.v.l.[ 4 XX).>X<X+X(.).(.(.(.#X(./.#XOX#XOX#X#X#XOXW.Q.E.Q.XXW.+XXX+X+X%X+X#X%X+X+X+X#X$X#X#X$X#X#X@X@X@X#XXXXX+XXXXX+XXX!.!.XXW.#X#X@X@X@X@XhX!.XXE.E.E.E.E.E.W.E.Q.H E.E.E.H J J XXE.G H E.E.E.E.H H H J F H K H H H H H H H H H H H G G H G H T.H H H H D R.T.R.G L F J F H H F F F L F F A H L H H H G H G L G L G G F A A A ! ! E E ( R E G G V G J G G N G J G G V L S G N S S S S S N N N J J S J N S S N C N L L C S L J N N E N S % % 5 & 3 % 9 N 5 4 5 P 4 4 4 4 4 4 7 T x P 4 4 P 4 4 P % 4 % 4 ; P 4 ; 4 % ; a ; a a a a < a < 0 @ < 0 0 a 0 0 0 0 0 0 = 0 0 0 0 a = 0 0 0 0 0 0 0 0 0 ; 0 ; 0 0 0 0 0 0 0 0 q q q 0 0 < q q a 0 e e e e 5 2 5 3 3 5 3 3 5 3 5 7 3 3 3 3 3 3 3 3 3 3 3 7 3 2 5 9 3 3 3 3 3 4 7 7 8 7 7 7 8 8 7 7 8 7 7 8 7 8 7 7 8 7 8 8 7 8 8 8 8 8 7 2 8 a.8 2 2 8 2 2 2 9 Y xXxXxXxXxXxXnXxXxXxXxX*   . NXPXPXPXPXPXPXPXPXPXPXPXIXKXvXxXxX.X.X.XjXjXxXxXxX9 + 9 1 + 2 V.o .   .     KXDXGXGXGXUXLXFXLXLXGXLXLXFXLXFXLXLXLXFXLXLX.     .   . V.+ 1 + 1 1 + T NX] %Xe.kXvXvX:X X].'.]. X X:XvXvXvXvXvXvXvX1X X1X X X%X$XvX%X] ] %XV.] & < # < @ @ @ q < e < < < 0 @ @ + # o [ &           e.o o O + # # = 0 0 0 e a e 0 s s 0 e 0 g 0 e a s w s p p s e = f L.*X*X*X&XU.V C N C Y jXcX3 & f c M o.O.b.n.o.b.n.n.n.n.n.n.A.A.n.A.A.A.M.M.S.S.S.S.M.S.M.",
        ").).<X).).-X#X8 v.SXSXSXv.l.a.9 W.(.).).(.(.#X/.#X=X(./.(.(.#X@X@X#X#XOX#XE.XXXXXXW.XXXXXX+XXX%X+X+X+X+X+XOX+X%X@X+X+X@X@X@X@X@X).(.+XXXXX+XXX+X+X+X!.OX#X#XOX@X@X@X%XuX@XXXQ.XXQ.E.E.Q.Q.E.E.E.E.E.E.E.Q._ J _ E.Q.Q.G H E.R.R.E.H H H H H H E.H K H H H H H H H G T.H H G T.T.R.R.T.R.R.R.G G G L F L L F L F F F J L L L H H G H H G G G G H J J L A D E A D ( R ! G G J G J V J J G G J N S J G N N J N J S S L N L N S S S S L N C N - N N N N N N N N S P T T N S % % & % % 5 4 4 4 4 % 4 P 4 d d d 4 4 4 4 g d 4 % ; 5 % 4 % 5 P 4 P % % % ; ; @ < a ; a < 0 @ 0 ; 0 0 = a < a < 5 0 0 0 0 < 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 < < < 0 q < < q < 1 < 0 q q 5 3 5 2 3 3 3 3 4 7 5 3 3 3 3 3 3 3 3 3 3 3 3 3 3 7 5 3 9 3 3 3 8 7 7 7 8 7 7 7 7 7 7 7 7 7 7 7 7 x 8 7 7 8 7 8 7 7 7 7 3 8 8 8 2 8 a.8 2 2 1 1 9 Y cXxXxXxXxXxXxXxXxXxXnX.X    . VXPXPXPXPXPXPXPXPXPXPXPXKXjXcXxXcXcXcXxXxXxXxXxXxX* + + 1 9 V.            GXAXAXGXGXGXLXLXLXFXLXGXFXLXLXLXLXLXLXLXLXLX            V.+ # + + + + 5 R ] ] [ ^ %X].XX[ U ].]. X XvX:XvXvXvXvXbXvXvXvXvX X X_ T P R R [ R ^ E # # @ # < < 0 < @ 1 q < 0 < @ 1 # + o ) &           ] o o + # # @ 0 0 0 = < 0 0 a 0 a s s 0 g s a c k e p s w s k e 0 _ I.*X*X*XY.L.C C N & 6 Y * X : c M o.b.o.o.m.n.n.m.n.n.n.A.n.n.M.A.n.n.M.M.S.S.S.M.M.M.M.",
        ").-X).-X-X).).).P l.SXSXl.8 % W.(.#X(.(.(.(.).(.(.(.#X/.(.(.#X@X@XOX#X#XOXW.XXW.+XW.XXXXXX+XXX+X+X+X+X+X%X+X@X+X$X,X@X@X@X@X,X@X#X).OXXX+XXX+XXXXX+XXXOX@XuX@X@XuX@X@X@X@X@X%XOXE.Q.XXE.XXE.E.E.E.E.E.E.E.J J Q.Q.E.E.G E.R.R.R.R.R.H K F H H K H K H H H H H R.H H H T.T.H T.G R.R.R.R.T.R.H L G H H L L F L F L F F F H T.G H H H H R.H G L G J L L G J A ! E ! F J G V J G G J J J G N G J G L J N G G N S N G N N L N L S J J N N L - N N L L N L G S N T T T T P T N 4 3 % % & % 5 4 P P 4 4 4 P 4 4 % 5 d g P P T d 5 % 5 ; 5 ; ; % P 5 4 ; ; ; ; ; @ a < 0 a a a a a a s g 0 0 0 0 0 0 0 0 0 = < 0 0 0 0 0 0 0 0 0 0 0 a < 0 0 0 0 0 0 0 q q < q q < < 0 < < < < < < 5 3 5 3 5 5 5 5 3 3 3 3 7 5 4 3 3 3 3 5 3 3 3 3 3 3 7 3 3 9 3 3 3 3 3 7 7 7 8 3 8 7 7 7 7 8 8 7 8 7 7 7 7 8 7 8 8 7 8 7 7 8 7 8 8 8 8 a.8 8 8 2 2 1 1 6 cXxXxXnXnXxXxXxXnXxXxXxXY     ] PXPXPXPXPXPXPXPXPXPXPXKXjXcXxXxXxXxXxXxXxXxXxXxXjX9 9 1 1 k.            AXG.SXAXGXGXDXZXDXDXGXAXDXDXDXZXDXGXFXGXFXGX            V.+ + + + # + @ E E R T T 5 5 # T U ].]. X XvXvXvXvXvXbXbXvXvXvXvXvXvX].5 X X & 5 N T & + # # # # # @ < @ < < < < < @ @ 1 # # ) &           k.o o + # # @ 0 = 0 0 q 0 a 0 s = s a 0 0 a e s w w p w w s w 0 = d _ Y.Y.L.L.V C & * * X X X X O g p M o.o.b.b.b.n.n.n.n.M.n.M.n.M.M.M.A.M.M.M.S.M.M.M.M.B.",
        ").-X-XgX).-X-X-X-X3 a.l.7 4 (.W.(.).#X).#X).#X/.(.(.(.(.#X/.#X@XuX@X#X#X+X(.OXXXW.XXOXOXXX+X+XOX+X+X+X+X@X+X+X,X<X@X@X+X@X<X,X1X@X@X).+X+XXXXX#XOXXXOX@X#X%X@X@X%X@X@XOX@X@X@X@XW.E.E.E.H E.E.E.E.E.E.Q.Q.Q.E.E.G G Q.E.E.R.R.R.R.E.!.R.H K H H H E.H H E.R.H G T.G G H G T.H T.R.T.R.T.T.T.T.H G H H H H H F F F F L H G H T.H H H G L H G G H J J G G H H H A F F V G G G J V G G J N G S G S J N L N G N L G G N L N N N N L L N G N N G N N N N N N N S P S N _ S T T P P N 5 N & % 4 5 % 4 4 5 ; 5 % % 4 d P d g d T ; % 5 N 4 P 5 5 ; ; d @ d a d f f g f f f g f f g s f g a 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 q q t q t q q q q q q < 0 < < 5 5 2 5 2 3 3 2 3 5 5 5 3 7 2 3 3 3 3 8 3 3 7 3 3 7 3 3 3 3 9 Y 3 7 3 3 7 8 7 8 8 7 8 7 7 7 7 7 7 7 7 8 8 [ 8 [ 8 8 8 8 8 7 2 7 7 2 a.2 a.8 2 2 2 1 + 9 cXxXxXxXxXxXxXxXxXxXxXxXjX* T KXPXPXPXPXPXPXPXPXPXPXUXE Y cXxXxXxXxXxXxXxXxXxXnXnXxXY + 2 k.            VXj o.o.C.C.DXGXGXFXGXAXAXDXGXDXDXG.M.Z.C.GX            V.+ + + 5 P T E [ U [ _ P P P P P '.].]. XvX1XvXvXbXbXbXbXbXvXvXvXvX X].P 9 & & & 4 4 % @ 5 < 0 1 @ < < < @ < < < < @ < # # # ) *           e.o o O # # # e 0 0 0 = 0 e s 0 w a s = s 0 s e e s a s w w w = = ; T & C C * * & O X X X X * X O & f p p p o.o.b.b.b.n.m.n.m.M.M.M.M.M.M.M.M.M.M.M.M.M.M.M.",
        "-XgXgX8XgX-X-X-X).-X_ T _ (.(.(.#X).#X(.(.(.(.(.(.#X(.(.(./.@X@X@X@X%XuX(.#X+XW.XXXX+XW.+XXX+X+XOX+X+X#X@X@X@X@X@X@X,X@X,X,X@X@X,X@X).+XXX#XXX#X+X(.@XOX@X@X@XrX@X@X%X@X@X@X@X@X@XE.E.OXE.E.E.E.E.E.E.Q.W.Q.W.R.R.E.R.R.Q.Q.R.~.T.~.T.~.T.K H H H E.K R.~.R.~.H H H T.H H T.T.G H T.R.R.T.^.^.2XT.H H T.H H T.H 2XH H T.H H T.H T.H G G H G L G G G G H G L T.G G G G V G G J J G J N J J J J L J L N G L N N G S L G N L N N N N N L V N N L G N N N L S N T T T N E P N P T T N 4 N ; 4 4 4 5 N % ; 4 % d 4 T d T d d d 4 T 4 4 4 4 d 4 4 d d d f f g f f d f f g f g a g s a g a 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 e 0 0 0 0 q 0 q q t w q q q q q 1 q q q < < 5 2 5 5 5 2 8 3 5 5 3 3 3 3 3 3 3 5 9 3 3 3 3 3 3 3 3 7 9 3 6 9 3 6 3 7 7 8 8 8 8 7 7 7 7 7 7 7 7 8 7 7 8 7 7 [ 7 a.7 7 8 7 8 2 7 2 s.a.2 8 8 2 2 1 9 6 cXxXxXxXxXxXxXxXxXxXxXxXxXjXUXPXPXPXPXPXPXPXPXPXPXKXP . `.cXxXxXxXxXxXxXxXxXxXxXnXxXjX+ 9 V.            VX) e.V.VXAXAXGXAXVXBXBXBXVXDXGXDXGXGXGXLXUX            V.o + X R ] NXNXkX X X].].].].Y U U ]. X X X1XvXvXbXbXbXbXbXbXvXvXvX:X XU U I ].]. X$X%X%X%X] ] E @ < # < < < @ < < # 0 @ @ < [ &           k.o o # # # = 0 < 0 @ @ e 0 0 = 0 0 a 0 g 0 0 w 0 0 w g 0 e 0 0 = = g 8 a.1 + 9 2 9 + 9 9 & & & X $ & T b n M o.o.b.m.O.b.n.m.n.N.M.M.M.M.M.M.S.M.M.M.M.M.M.",
        "gXgXgXgXgX-X).-X-X).@X@X).(.(.(.(.#X).#X<X(./.#X#X/.)./.(./.@X@X@X@X@X@X+X#X(.+X#X#X+X+XXX+X+X+X+X+X@X@X@X@X,X,X,X,X,X,XhXhX,X@X@X@X#X#X+XXX#XXXOX#X@XOX@X@X@X@X<XiX,X@X@X@X@X@X@X@X+XE.!.E.!.E.E.E.W.Q.Q.(.Q.!.E.R.E.Q.Q.Q.R.R.~.T.!.R.!.T.~.H H H R.H R.H R.R.T.H H T.T.H H T.T.H T.T.^.^.^.^.^.^.T.T.T.~.~.T.T.T.^.T.T.T.H H G G T.L H H G H G G T.G G T.H G G G G J G J J V J G G J L J V J V G G G V L G G G N G G V L G G G N V L S G N N L N N N N T T _ T E S E _ T T P T T T P d N N 4 4 5 % % 4 d d d 4 d d d d d R g d d d 4 d g d d d f d f f g f g f g f f f g f g a 0 a 0 0 0 0 0 @ 0 0 0 0 0 0 q q 0 w 0 e 0 0 0 0 0 0 e q 0 0 e w w w w w w w w w w w 1 q 1 2 < 2 2 5 5 5 5 3 2 3 3 3 5 5 3 3 2 3 3 3 7 7 3 3 6 6 7 7 7 7 3 7 3 7 3 7 8 7 8 7 a.a.7 8 8 7 8 7 7 8 8 7 7 8 a.7 7 8 8 8 8 6 2 8 a.7 2 s.2 2 9 1 9 @ Y cXxXnXxXxXxXnXxXxXxXxXnXxXxXHXPXPXPXPXPXPXPXPXIXCX* . . .XxXxXxXxXxXxXxXxXxXxXxXxXcX6 + 1 k.          . CX^ ) 4.C.BXVXBX) R 5 1 g d R k.VXGXKXGXDXLX            k.o o # ^ kXNX%X$X1X:X X|.].'.'.`.U ]. X XvXvXvXvXvXbXbXbXbXvXvXvXvX X XU ]. X X:XvXvXvXNXCXBXCXR 5 # 1 # 0 0 < < < # @ 1 @ < ) &           k.o o O # = @ < @ e @ e @ < 0 0 0 0 0 0 w = 0 0 = 0 0 = < < < @ @ @ 4 f.h.a.9 f.a.f.2 a.3 P % T 4 & & & 4 R Q M o.o.o.o.n.b.n.O.n.m.N.M.M.M.M.M.M.M.M.M.M.M.",
        "gXdXgX8XgX7X-X-X-X)._ 4 _ ).(.(.#X(.#X).#X(.).#X(.(.(.(.(.(.@X@X@X#X@X#X+X#X(.+X+X#X).#X+X+X+X<X@X@X@X@X,X,X,X,XhX@X,X,X,X@X,X,X@X@X#X).OX+X+X#X+X#X#X@X@XuX@X@X@X@X@X@X@X%XuX@X@X@X@X#X!.E.E.E.E.E.E.W.W.(.(.W.Q.Q.Q.Q.~.Q.Q.T.T.!.T.!.T.!.T.~.E.H ~.E.R.H R.~.T.H T.H H H T.H H T.T.R.^.^.^.^.^.^.^.^.^.T.T.T.T.~.T.T.T.T.H T.T.G G T.G H G T.T.T.G G T.G T.G J V G G G E.G G G G G G G V J V G G G J J G L G V L L G N G G V V L G L G N L N N L G L J P T T N _ P T S P T T P P N d P 4 d P P % 4 % 4 d d d d T d T T f T g d d d d d d d d d d d g f d g f a f d f a g g g g a 0 a 0 = 0 0 a 0 0 0 q 0 0 0 0 0 0 q a 0 w e 0 w q 0 0 0 0 q w w w w w w w w w w w q < q 1 5 5 2 2 5 5 2 5 3 5 5 3 3 3 5 5 3 3 3 3 7 3 3 3 3 3 3 7 3 7 3 3 6 7 9 8 7 7 a.7 8 7 8 8 7 8 7 8 7 8 7 [ a.7 a.7 8 8 7 7 8 8 7 8 8 a.8 7 2 2 2 2 1 9 .XxXxXxXxXxXxXxXxXnXxXxXxXxXcX.X] KXIXPXPXIXKXBXd .     . .XcXxXxXxXxXxXxXxXxXxXcX.XY + 1 2 V.            VXNXBXCXVXVXCX[ + + + + + + 4 V.CXVXKXUXUXUX            k.. o & R V.NX%X X1X X X X].].U `.U ].]. X$X XvXvXvXvXbXbXvXvXvXvXvXvX].].]. X XvXvXvXvX XCXCXVX] @ @ 1 < < < < < < 1 @ < @ < ) &           ] o o + # # @ 0 0 < 0 0 e e 0 e a s 0 0 a 0 0 0 < a a a a b g [ R l.l.l.f.a.9 s.f.s.2 8 [ R & b g f T 5 & & % T R ) M g.o.o.o.o.n.O.b.n.N.A.M.M.S.M.M.M.A.M.",
        "hXgXgXgXgXgX-X-X-X[ k.k.[ N )./.(.<X(.#X(.#X(././.(.#X=X(.).@X@X@X@X@X#X<X).#X<X<X#X<X#X#X@X@X7X@X,X,X@X,X,XuX,X,X,X,XgX,X,X,X@X@X+X(.(.#XW.!.+X#X#X#X#X@XOX@X@X@X@X@X@X@X@XuX@X@X@X@X@X@X!.!.E.~.E.!.(.T.W./.(.).Q.Q.Q.T.Q.Q.~.~.R.~.T.~.T.T.~.Q.H H R.~.~.R.R.~.R.R.T.T.T.H T.H T.T.T.^.^.^.^.^.^.^.^.^.^.T.T.^.^.~.T.H H T.H G T.T.G J.T.J.G G G G T.H G G G G G G V G V G G G G R.G H H G G G G N G G G V V G G G N J G L L J G G N L G V N N N G N T P E P T T P A P A P P T S P T d P % 4 4 4 P d d d P d d d d d d T g T d T d 4 d d 4 d d g f d d d g d d f g f f a a a g a 0 0 0 0 0 0 0 0 a 0 0 0 0 0 0 0 e 0 w 0 0 0 0 0 0 0 e q e q w w w w w e i w w w w < < 2 5 2 1 g 5 2 5 5 8 3 2 3 5 3 3 3 3 3 3 3 3 7 7 7 3 7 6 7 7 3 3 6 6 3 6 3 8 7 7 7 8 7 8 7 8 8 7 a.8 a.7 a.7 7 a.7 a.8 a.8 8 8 8 8 8 8 2 a.8 2 2 2 2 9 Y .XcXxXxXxXxXxXxXxXxXxXxXxXxXcX.X* . * & & X .       .   . .XcXxXxXxXxXxXxXxXxX.X6 + + 9 1 9 V.            o . . X X . o k.+ + + + 9 + k.o o . . . o .             k.o o X P ] NXkX].1XvX X X].].].U U ].]. X$XvX1XvXvXvXvXbXvXvXvX XvX X].'.]. XjXvXvXvXvX XiXVXNX] 5 + # @ @ @ < @ < # < < < q k.&           V.o o + # # 0 < @ 0 @ e @ @ 0 0 0 0 = < 0 = 0 ^ NXVXJXHXkXP [ [ 6 7 7 2 a.a.a.9 9 2 a.8 3 % * f s s k ) b f d @ & & & d g ( ) 4.o.b.O.5.n.n.Z.n.M.M.M.S.M.M.",
        "gXgXgXdXgXgX-XgX3 l.SXSXl.[ 3 -X/.@X#X#X).).).).#X).).=X).).@X@X@X@X<X#X#X<X#X#X<X#X,X@X,X@X,X@XhX@X@X,X@X,X,X,X,X,X,XhX,XhX@X,X@X#X+X#X(.+X!.#X#XOX#X@X@X@X@XuX@X@X@X@X@X@X@X,X@X@X@X@XuX@X%XE.!.E.!.^.(./.(.(.).^.W.Q.!.T.!.T.T.T.~.T.Q.~.T.T.T.~.~.R.H ~.R.R.~.T.H ~.R.R.T.H T.T.H ^.^.^.^.^.^.^.^.^.^.^.^.^.^.^.^.^.T.T.T.T.G G J.T.J.T.G T.G G T.G G G G G G G G R.V G G G G G G G R.G G G G G G G G L J L L V G J L V V J L V G N G J L G L V J J P T _ S E S S T E N P T T N P N d 4 P % % % d P d d d 4 T d d d d T f d f f d d d d d d d a d d a d f d d a f g d g g a a a 0 0 0 0 = a 0 0 0 0 0 0 0 0 0 0 e e 0 w w 0 w 0 q 0 q e 0 q w w e i w w w w w q w < < 1 1 5 5 2 5 5 2 4 3 5 5 3 3 3 3 3 5 3 3 9 7 3 3 3 3 7 3 3 6 7 3 6 7 7 7 7 7 a.[ a.7 7 8 7 8 8 7 8 8 8 8 8 8 8 a.7 a.[ 7 8 8 8 a.7 8 8 8 a.2 6 s.9 9 s.7 Y jXjXjXcXxXcXxXxXxXxXxXxXxXcX.X*                   .   * .XjXxXxXxXxXxXcXjXY + + + + 9 1 9 k.                          k.+ + + 9 9 1 V.      .                   k.o . X [ NXCXCX].$X:X X X.XU Y '.U '.].]. X XvX1XvXvXvXvXcXvX1X1X X].].].]. X1XvXvXvX1XkXKXHXBXR @ # # 0 q @ @ < 1 + @ < < < k.#           e.o o + # # = < 0 0 @ @ = 0 0 = 0 0 = = 0 R CXJXJXJXUXJXHXOXkXHXJXJXJX%XP 8 d.d.d.a.8 6 4 % % 5 s s p j p o.M ) ) R f @ S N N N S ( o.5.5.Z.Z.Z.M.M.M.M.M.M.",
        "gXgXgXgXgXgX-Xx l.SXSXv.v.l.a.7 (.@X,X7X@X).).).=X).).).).@X@X@X@X@X#X@X<X#X<X@X#X-X).@X,X).@X,X@X,X,XhX,X,X-XuXuX,XhX).hX-X,X#X#X#X#X(.#XW.#XOX#X#X#XOX%XuX#X@X@X@X@X@X@X@X@XuXrX@X@X@X@X@X@XOXE.E.!.(.(.(.(././.(.(.T.T.!.R.!.Q.~.T.~.T.~.T.~.~.T.T.~.R.R.R.R.R.R.T.R.T.R.T.R.T.T.T.^.^.^.^.T.T.^.^.^.^.^.^.^.^.^.^.^.^.^.T.^.J.G G J.J.J.J.J.T.T.G G G G G G G V G _ G G G R.G G G R.G R.R.G V L G V G V G G L G N G V L L V V L L V G N N G J J J E S T P T T P _ N E T T P T T T T ; N % 4 4 T N 4 T 4 T T T d T g T g T g d T g E 5 d d d d d d f f a g a f d d a d d a g f a ; e e 0 0 0 a 0 0 e 0 0 0 0 0 e 0 0 e 0 0 0 0 e 0 w 0 q q e w w w w w w w q w w w 1 < < 5 2 1 5 < 2 < 3 8 4 3 3 5 5 5 3 3 3 3 3 7 3 7 6 3 3 7 7 3 7 7 7 3 7 7 6 a.[ 8 7 7 8 7 8 7 7 7 8 8 2 8 8 8 a.8 8 7 a.8 a.7 a.8 8 8 8 8 8 8 a.s.2 2 s.2 7 9 6 Y `..X.X.XcXjXxXxXxXcX.X`.* . . o . . . . . . .   X `..XcXxXxXxXcX`.9 + + + 1 + + 1 2 V.                          NX+ + + + + 1 NX      .                   k.. o + ^ %XNXBXNX$XvX X X X].]._.U Y _.]. X$X X1XvXvXvXvX:X1X1X X X].U ].]. X:XvXvXvXkXHXVXVXVX] @ @ @ @ < < < < e 0 q 0 0 e ) &           V.o o O # # < e < < 0 0 < @ 0 0 s 0 a 0 a ] JXJXJXJXHXVX%XHXPXJXJXUXUXVX] 3 f.a.8 6 7 & & ; : f k p p p o.M M p p p c c n c k E P C N 4.n.5.Z.Z.n.n.Z.n.A.M.",
        "gXgXgXgXgXuX[ l.SXSXv.v.s.l.l.f.5 OX@X@X@XuX@X@X).#X).).).#X@X@X@X@X#X#X#X<X#X#X).-X@X,X,X@X).@X,X,X@X@X@X,X,X,X-X,X,XhX,XhXgX#X(.#X(.(.(.#X#X#X%X#X#X#X@XuX@X@X@X@X@X@X@X@X@X%X@X@X%XuXuX@X@X@X!.~.!././.(.)./.=X(.(.^.!.T.T.Q.R.R.Q.Q.!.T.~.T.T.~.~.T.~.H H ~.~.T.T.~.~.T.T.T.T.G T.T.^.T.^.T.T.T.^.^.^.^.).^.^.^.^.^.^.^.^.^.^.^.J.J.J.J.J.G T.T.J.G G V G G G G G G G G G G G G G R.R.H H G G G L L L L G G V L V L J G J L J J L L L G G G L J S P P _ P T N T E T S N T S P P P N N % N N N % P : d T d d d T d T f d d E d g d T f d d 4 d d d a a f d d f a a d d a d a a g a @ 0 0 @ 0 0 0 e ; 0 = e 0 0 a q 0 0 0 q e w 0 w 0 e q e w w q w q w w w q w w w < 1 1 5 < 2 5 5 1 1 5 5 3 3 3 3 3 3 4 5 9 3 3 7 3 6 3 3 6 6 7 6 7 7 7 7 7 7 7 7 7 7 8 7 a.7 8 8 7 8 8 8 8 8 8 8 a.8 a.8 8 a.8 8 8 8 8 8 8 2 s.2 2 2 2 a.9 8 2 9 2 9 9 9 9 B Y .X.X.XjX.X.XB + + + + + + + + + + + + o Y .X.XjX.X.XY + + + 9 1 + 1 9 1 + V.                        . k.o + + + + 9 NX.                         k.. o X E ] ] %Xk.%XvX:X X].].'.Y U N P Y U ]. X XjX$X$X1X$X X].].Y Y '.].].1X:XvXcXvXNXBXBXCXVX[ # @ # # @ @ < @ @ < < < < < k.&           k.o o + # # # @ < = < < @ @ < 0 0 0 0 0 < b NXHXJXUXKX%XCXHXJXJXJXJXJXBXR % 3 3 9 & @ 5 T f R ) p p o.o.o.o.p O.M p c n ) s p k ) _ C E 5.n.Z.N.N.n.Z.N.Z.n.",
        "gXwXhXgX7X[ l.SXCXl.8 3 x [ k.NX) P ' @X).,X@X7X@X7X,X@X-X@X).,X@X@X@X@X-X#X<X-X<X,X-X,X@X,X,X,X@X,X,X,XhX@X@X,X,XhXhX,XhX-X,X).(.(.(.!.W.#XOXOX#XOXOX#X#XOX@X@X@X@X@X@X@X@X@X@X@X@X@XuXOX@X@X@X@X#X(./.).).=X).)./.(.).Q.!.~.R.Q.T.~.Q.R.Q.T.!.T.^.^.T.T.T.H T.R.R.R.T.R.R.^.G T.T.T.T.^.^.^.^.T.T.T.T.^.^.T.^.^.^.^.T.^.^.^.^.^.^.^.^.T.J.J.J.J.J.J.G G G G G G G G G G G G G G G R.H G R.R.R.G G V G V G G G H G J G G L N G L V V J V L S N G J N S T T S T _ S N E P _ S T T S N d S 4 4 d d d d 4 P d T d T g T d T f T g f E f f E T ; : 5 a ; d d d d a a d d f a d a a d a a ; @ < = ; a a a a s a 0 0 0 a 0 w 0 w 0 e 0 e q q q q q q w w w w q w q w y q w < 1 < < < < < 5 < 5 2 < 5 8 4 3 5 3 3 3 4 5 3 7 6 7 3 6 3 7 3 6 7 6 7 6 7 6 8 a.6 a.7 7 7 8 7 7 7 7 2 8 8 x m 8 8 a.[ a.a.8 a.a.7 a.7 a.8 s.9 2 2 2 a.2 a.2 2 2 9 9 9 1 9 9 + + Y B B B * + + + + 9 + + 9 9 + + + 9 + * Y `.`.`.Y * + 9 + + + 9 + 1 + 9 V.                          k.o o + + 1 9 V..                         k.o . o 5 R [ ] ] ]  X].U P Y 9 & & # + & & % P P P P P _ N 5 % & P P P U '.].1X1XvXkX%Xk.%XV.NXR @ + # + # < < < 0 < 0 < < 0 ) &           ] o o o + @ @ < < < = = @ @ = = 0 0 0 0 0 a g R ] kX] [ iXJXJXJXJXHXkX] E f : f d ( ( ( ^ ) b c M M o.M o.p b.p p j Q _ _ k k k ^ T * T C.5.t.5.n.Z.n.Z.N.Z.",
        "gXgXgXb g [ 4 8 3 d NXVX] ; 4 4 5 [ 8 hX,XhX,X,X@X,XuX,X@X@X,X@X@X#X@X-X@X,X,X,XhX,X,X,X@X@X,X@X,X@X,X,X,X,X@XhX,X,X,X-X,X-X,X).(.!.(.!.(.OX#X#XOX#X#X#X#X#X@XuX@X,X,X@X@X@X@X<X@X@X@X+X@X@X@X@X@X@XhX@X#X=X)./.).^.).)./.(.Q.R.R.R.Q.Q.Q.Q.T.W.^./././.T.R.R.R.R.Q.Q.T.T.T.T.H T.H ^.^.^.T.^.^.T.T.^.T.T.^.^.^.^.^.^.T.^.^.^.^.^.^.^.^.J.J.J.G J.J.J.G G G G G G G G G Q.G G G R.H R.G H R.H H G J V L L G G L G V J G C G G G G G N J V L N J S J _ T P S _ T P S S E T P E N T d 4 N N % d N 4 S % S d T T d f d d f T f f T T f f f E d T d ; d d d 4 ; d a d a d d d a a 5 : d ; @ @ @ ; a : s a a e a a e a a e 0 e w 0 0 w 0 e q q q q w w i e q w q w y w w e 1 1 1 < < 5 < 2 1 4 2 1 5 2 8 x 5 3 4 3 4 4 7 3 7 Y 3 7 6 6 7 6 6 3 6 6 7 7 7 7 8 a.6 7 8 7 a.8 7 8 8 2 8 ) m m z a.8 7 a.8 a.a.8 a.2 a.2 9 a.2 9 2 7 s.2 s.9 2 9 9 2 2 9 1 1 9 1 + 9 9 + + 9 + 1 1 + 1 9 9 + + 9 + + + + + + + + + + + + + + + + 1 9 9 CX                          k.o o + + + + V..                         ] o o + + % E P d 5 % * # + # # + 1 # + # # # & & 1 + + < # + + @ + # # @ % 5 P Y ]._ ] [ ] ] R P @ + # # # < 0 < < 0 0 < < < g.& .         ] o o + + # @ @ = = @ < @ + @ a e 0 g 0 = = a = @ = @ @ < [ k.HXHXVXHXe.( ( ( ^ ( ) ^ ) b l c o.M g.M b.M o.M c ) R L.L.L.R R E % * & 4.n.t.t.5.Z.Z.Z.n.Z.N.",
        "gXgXgXgXhXgXgXgXS CXUXUXVX] N ).@XuXhX,X,X@X,X,X).7X,X,X@X,X@X,X@X-X@X@X).-X,XhXhX,X,XhX@X,X,X,X@X,X@X@X@X@X,X@X,X@XhXhXuX@XgX-X#X#XW.(.#X(.(.XXOX(.#XOXOX#X#X,X,X,X@X,X@X<X@X@X@X@X@X@X+X@X@X@X%X@X%X@X#X(.(.(./.(.(./.).^.!.R.Q.Q.Q.Q.!.T.^./././.I.^.T.R.R.R.R.R.R.~.T.R.T.R.T.T.T.^.^.T.^.^.T.T.T.^.^.T.^.^.^.^.).^.^.^.^.^.^.^.^.^.J.J.J.J.J.J.J.J.J.G G G G G V R.G G G G V R.R.R.R.R.R.R.G G G G V G G G G L G G G L G L G L G G G J G J J J P T T P S P S _ P P E J T T S N S P ; S 4 4 % % 4 4 d T d T T T T T d T d f f d T d g f f f 5 d 4 : d d d ; d d d d d d ; d d d ; % ; ; ; a e g a s = s a e f e 0 e 0 q 0 w 0 w q q e q e q w w q w w w w p y p w 1 < < < 1 < 0 5 g 5 g 5 5 5 5 g x g 4 g 3 4 7 6 3 7 7 7 6 7 7 7 7 6 7 3 6 7 7 a.7 7 8 7 7 [ 7 7 7 7 8 8 c M m M g.m f.a.a.a.a.8 8 9 7 2 9 2 2 2 2 s.s.2 2 2 2 a.s.a.2 9 9 9 9 1 1 k.k.k.k.l.k.k.k.k.k.k.k.l.k.k.k.l.k.] k.k.k.k.] l.k.k.k.x 1 1 1 + + 1 V.            CXe.%Xk.k.k.] NX] [ [ k.k.k.CXk.k.k.V.k.k.VX            k.. . o + + 1 T k.k.] k.k.k.[ < # 1 < 1 1 @ # 9 @ @ < # 1 + 1 # 1 # < x ] k.] ] ] k.[ 5 N T T 4 # # # # @ # @ 5 < < 0 @ 0 < < ) &           k.o o O # = @ < g ; = 0 e # 0 0 a 0 s = a = s = 0 0 = 0 g e.V.BXNXBXNXNXV.V.BXCXNXBXV.V.V.BXC.V.C.C.o.o.o.M o.] Q.L.U.U.K.C & & % R ) 5.5.5.C.n.5.5.N.Z.Z.Z.",
        "gX8XgXgXgXgXgXgXP k.CXVXNXR P #XuX,XhX<X,X,XhX,XhX,X,XuXgXuX<XgX-X).-X,X<X-X,X-X<XhX,X,X,X,X,X@X,X@X@X,X,X@X,X,X@XhXhX@X-X-XuX,X<X#X#X(.(.OXOX#X+X#X(.).OX#X@XuX,X@X,X@X@X@X@X@X@X@X@X@X@X@X@X@XhX@X@X@X).)./.=X(./.^.).(.).Q.Q.Q.Q.~.T.T./.I.I.I.^./.I./.T.T.R.R.T.R.Q.T.R.T.T.T.T.T.^.T.^.T.^.^.T.T.T.T.T.T.^.^.T.^.^.^.^.^.^.^.^.^.^.G J.J.J.J.T.J.G J.J.V G G R.G G R.R.G G G G G R.E.R.H R.R.G N G H H H G L G G L G L G G L V G G H G L J J S S P T _ P A P E _ S S P N E P S P S T N 4 S N d S % S d T f d T T f d f d d d f d f E f E f f d d : d d d d d d d ; T d ; 5 d ; ; @ ; = a g = g a a k s a f e a w s 0 0 0 e q q q e q e q q w w w w w i w w w w w 1 < < < 2 5 2 5 t t 5 x x x g x x x g 4 g 3 7 6 6 6 3 6 3 6 6 7 7 3 7 6 7 j.7 6 6 7 7 8 7 6 8 7 6 8 2 x b M g.m m m g.f.a.a.8 a.a.8 2 7 2 2 2 2 s.8 a.2 s.s.9 2 9 2 2 9 2 2 2 1 3 k.X X X O X X X o + X X o O X O X X X X X * X # O X * O V.1 1 + 9 1 1 NX            k.. o . . . o NXX X * O X X k.1 9 1 + o X NX            ] o o o + + # k.& X X X X X NX1 1 # 1 5 < < 5 5 < < d @ @ @ a @ < @ < k.& X # X O X V.@ @ @ @ & # @ @ 1 < @ @ 0 a < q < 0 0 0 k.&           e.o o + # @ @ = a a ; a 0 a s s s 0 g e s e s 0 0 s a k ) R O X X * X X # * X X + X X # X X X X # CXM M M ) ' '.V L.V V C * ( n  .o.O.n.5.5.5.t.t.Z.Z.N.N.Z.",
        "gXhXgX[ [ 4 [ 7 3 8 x k.[ 3 9 3 5 4 7 hX,X,X<XhX,XgXhXgXhX-XhXhXgX-X-XhX-XhX-XhXhX<X,X,X,X@X@X,X,X,X,X@X,X,X@X,X,X,X,X-X,XhXgX,X#X#X#X!.!.+X(.(.!.!.OX#X#X#X@X,X,X,X,X<X<X#X<X#X@X@X@X@X@X@X@X@XhX@X@X@X/./.=X/.=X^.-X=X(.^.Q.T.Q.Q.Q.T.I.I./.^./.I.I././.W.T.T.T.Q.T.T.R.T.R.T.T.T.^.T.^.T.^.^.^.T.T.^.T.^.T.^.^.^.^.^.^.^.^.^.P.P.^.J.J.J.J.J.J.J.J.J.J.J.J.G G V R.R.G G G R.R.G R.R.R.R.R.R.R.H G L G G G G G G J G G G G G G H H H G L J J J P P E T P E P E N T J T A T S S E S E A A F F P ; 4 % S 4 d T T d d T d d T d T f E g g f f f E f d 5 5 : d 5 a d d d ; d d a 5 ; d ; @ ; g g s g k h h a e a a g 0 0 e e 0 0 0 e w q q q q w w w y w w w w w y p p w < < < 0 1 q 5 5 g x l l l x s x x x 4 5 3 7 6 3 6 7 6 6 7 6 6 6 6 6 7 7 7 6 6 a.7 7 7 7 7 7 7 a.2 2 m M ) g.M g.m v z m 8 a.2 8 s.2 2 2 2 2 2 2 a.a.a.2 2 d.2 s.9 2 s.9 2 9 2 8 [                                                       V.9 9 1 + 1 1 NX            kX. o . . o . k.            V.9 + + + + o ]             k.o o + X + # k..       .   V.1 @ 1 @ # 5 < @ < 5 < 5 @ ; @ & @ ; @ @ V.X           V.# # # # @ # < # @ # # # 0 < < 0 @ < < < ] &           k.X X X O # = @ = = ; = = e 0 0 a = k ; ; 0 k e = k = g 4.N       .                               V.M p 4.] ) ) ) M n ) ) 4. .o.o.O.5.5.5.Z.Z.5.t.n.5.t.Z.Z.",
        "gXgXgXgX#Xl.k.SXl.l.[ 2 3 8 l.l.[ T XXhXhX<XhX<X,X,XhXhXgXgXhXgXhXhXhXgX<X-XhX-X,XhX<XhX,X,X1X,X,X,X@X,X,X,X,X@X,XhX,X-X,XgX@X,X(.<X#X(.W.(.#X(.(.!.OX).).).uX,X,X,X,X#X<X#X,X#X@X@X<X#X@X@X,X@X,X@X7X=X/.).I.I.I.I.I.^.(././.^.R.T./.I.I.I.^.=X/.P.I.^.^.^.^././.Q.T.Q.T.R.R.J.J.T.^.T.^.T.^.T.^.T.^.T.T.T.^.T.T.^.^.^.P.^.^.^.^.^.P.J.J.J.J.J.J.J.T.J.J.J.^.G G G G H G G G G R.G R.R.Q.R.R.R.R.G G G G L G H H G G L G G G L G L G H H J J J J P T T N E S S _ J T E S N _ E _ E J E A F _ A T P d T T d T T f f : d T d d f f f f f f f f f f f f d : 5 d d d d d ; d 5 d d d a f ; a f k h > h k h h s s a f e 0 e s 0 e 0 e w w q q q e q e w w w w i w w y w y p t q < < q < x s x l b x b x l m x x 5 x 3 3 6 6 6 3 6 6 6 6 7 6 6 6 6 6 7 7 a.6 6 7 3 7 7 7 7 8 8 c m M g.4.m M M m v z f.z 8 8 2 2 2 2 9 2 8 s.8 a.a.a.s.2 2 2 9 a.2 2 2 2 9 2 R                                                       NX+ # 9 9 < # NX            k.. . o . o o k.            V.+ # + + X X V.            k.. o o + + 9 V..           k.1 + 1 5 # 5 a < d 5 < a < 5 @ @ @ ; @ < V.X           V.& # # & @ @ < < @ @ 5 # < < a < < 0 < < k.&           e.o o + O @ & @ = = g f = g ; e k e = e : e e f s s : k ] 5                                       V.c c k p M M M M o.o.o.o.o.o.o.5.t.5.t.Z.t.Z.Z.5.Z.Z.Z.Z.",
        "gXgXgXgXgX@Xf.l.SXSXv.l.v.l.l.a.4 OX,XhXhX<X<XhX,XhXhXhX-XgXhXhXhXgXgXhXhXgXgX,XhX<X<XhX@X,XhXhX@X@X,X,X@X,X,X,X@X).).,X-XhXgX,X#X<X<X#X(.#X(.#X#X#X).OXOX@X#X,X,X,X@X<X@X<X@X<X@X>X@X#X@X@X#X@X#X).-X-X=X/.I.I.I.I.I.I.^.).Q.^././.=XI.I./././././././././.^.T.T.^.T.^.J.J.T.Q.J.T.T.P.T.^.T.^.T.^.^.^.^.^.^.^.^.T.^.^.^.J.P.J.^.P.J.P.J.J.J.J.J.J.G J.J.J.G T.W.L.L.G Q.R.Q.R.R.R.R.Q.R.R.R.R.R.H G G H H G H H J G G L G H G H G H G H H J H T S P _ E P P _ S T E J _ S A A S J A J F F F F S d T T f T S : S E S E : d f d d d f E f E f f f f ( f T d d d d d d d d : : f f f h > h k k h k h r h h > s a g a s e s w s e q q q w e q q q i w w i w w w w w y p u l < < q 0 y l c b l l l x b x l x b x g 6 6 6 6 6 6 6 6 6 6 6 6 7 6 7 7 6 6 6 7 a.6 j.7 6 7 7 8 x M 4.M M M M M m v m m z z f.i a.2 2 8 s.2 a.a.s.2 2 a.9 a.2 2 2 2 9 2 2 9 2 2 ]                                                       k.9 + + # & 9 NX            k.o o o o X + k.            k.+ + + + + O V.            k.o o + # + 1 V..           k.& # # @ @ @ @ < < @ < < 5 < a ; @ a % a V.X           V.# # # @ # @ < < < @ @ @ a @ a a a 0 < 0 ) &           k.. O O # & @ ; g = = = ; : = g s ; s s a k k : f r g s ) %                                       V.0 s p k p o.o.b.b.b.b.o.O.n.5.5.t.Z.Z.t.Z.t.t.Z.Z.t.n.Z.",
        "gXgXgXgXgXgX).3 v.SXSXv.v.l.8 5 @XhX,XhX<XhXhX<X<XhXhXgX-XgXgXgXgX-XhXgXgXhXhX<XgX-XhXgX@X,XhXhXhXhX@X,X,X@X,X,X,X,X,X,X,X-X-XhX<X#X<X+X#X(.#X).#X).).@X@XOX@X,X,X,X#X-X-X#X#X@X@X@X#X#X+X@X@X@X@X).=X^.=XI.I.I.I.I.I.I.I.I.^.=X=XI.I./.I.I./.I.P./.P./.P././.T.^.Q.T.J.P.T.T.J.T.T.T.T.^.^.T.T.^.^.^.T.^.^.^.^.^.^.^.P.P.P.P.^.P.P.J.J.J.J.J.J.J.J.J.J.J.T.T.G Q.XXQ.Q.Q.V V Q.R.R.R.R.Q.R.R.R.R.R.G H H G G H H G H H G H G H H G H G H G H J P E T E T E N E S _ N E J E _ N _ A _ A _ F _ F T T S : f S > S S D S f D d f d f T f d T f f f f E f f f d d ; ; d d f f f f f f h h f k k > k k h > k h r a k k s = s s s s s e q q q q q w i w w w w w y p p p y y p p w q l c l c c c c c c l c x l l m x c g 7 7 7 6 6 6 6 6 6 6 6 6 6 6 6 6 7 6 7 6 6 7 6 7 7 7 f.m 4.M g.M m M m v v m v v x z x x 8 a.2 2 2 a.a.a.a.a.a.2 2 s.9 s.2 9 2 9 2 9 2 R                                                       V.+ + + + 9 1 NX            k.. o + + + + NX            NX+ + + X # O V.            k.o o o + 1 # k..           NX+ O # & & 1 @ 5 5 5 < 5 < g 5 a a ; ; ; V.X .         kX+ O + # @ @ < @ 0 @ 5 @ < a @ a < ; a 0 ] #           %XO X # & @ ; ; ; a : = a s a e = = k : k k g e > s r f e.5                                       NX= 0 s p M o.b.o.b.m.b.n.o.5.5.n.Z.t.t.Z.Z.t.t.Z.5.Z.Z.t.",
        "gXgXgXgXgXgXgXgX[ l.SXSXl.f.P <X<X<X,X<XgX<XgXhXhXgX-X-XgXgX-XgXhXhXgXhXhXgXgXgXhXhXgX<X@X,X,X1X,X1X,X@X,X,X,X,X).,X<X7X-X,XhX<X,X<X#X<X).#X).#X).OXOX#X).).@X-X<X,X<X<X@X<X<X#X,X@X@X#X#X#X,X@X).=X-X=X^.I.I.I.I.*XI.I.I.I.I.I././.I.I.I.I.^./.^.I./.P././.^./.Q.T.T./.P./.T.T.T.J.T.^.T.T.^.T.^.(.^.T.^.T.^.T.^.^.^.P.J.P.P.^.P.^.P.J.J.Y.J.J.J.J.J.J.J.T.G T.Q.XXQ.Q.G Q.Q.R.R.Q.Q.R.Q.R.R.Q.R.G G H H H H H G H H G H G H G H H H H H J H J T T T N P J E P T T J A E A A A S A A F F F K F S S T S S S S S f f S D ( > S f f f f f f f T f f f T ( f d d g f f f f f f h f > h k h > h r h h k h h h h k s k g s e s e e s w q q w w q e w w w y w y w e p p p y p v v c l c l c v c c v c v v m v z l x m b l g x t 4 8 7 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 7 7 6 7 f.o.g.M 4.M m M v M m v v m m f.f.f.i f.a.a.s.a.a.a.a.2 8 s.2 s.9 9 2 s.2 2 9 2 a.]                                                       k.o X + # 1 1 NX            iX. o o + + + NX            k.o X + # O # NX            k.. + + + + 1 V..           ] X + O # @ 5 5 a < g a a 5 a < 5 ; @ @ ; k.X           e.+ o # # # < a < < @ @ 5 @ a < ; 0 a < 0 V.&           e.o o O O & & ; ; = s s = : f e k : f e > 0 s > e k s s 4.%                                       e.@ = a s M M b.b.b.n.n.5.5.5.5.t.Z.Z.Z.Z.t.Z.Z.Z.t.Z.Z.5.",
        "gXgXgXgXgXgXhXgXgXP l.l.8 4 <X-X<X,X<XhXgX-XgXgXgX-XgXgXgXgXgX-XgXgX-XgXhXgXhXgXgXgX-X-X).,X<X@X,X@X,X,X@X@X,X@X,X).,XhX-X,X<XhXhX>X<X#X#X(.).#X#X).#X(.OX#XuX-X,X,X<X@X<X#X#X<X#X<X#X<X).).).-X=X=X)./.I.I.I.I.I.I.I.I.=XI.I.I.I.I.I./.I./.^././.I.P.U.^.U.^.U.T.^./.P.T.U.^.P.T.T.T.T.T.T.T.J.T.T.^.^.!.^.^.^.T.^.^.^.J.P.^.P.P.P.Y.P.J.J.J.J.J.J.J.J.G J.G J.Q.Q.L.Q.Q.Q.Q.R.Q.R.R.T.R.R.R.R.R.G G H R.H H H H H H H H H H H G H H H H H H S P T T P T _ P A _ S _ S _ E J A A J E _ A F K J S S S S S S S S D E S ( D D D f S f f f f f f f f f f f f : f f f k f f f f h f f k f h h h j h h | h h | h k g k c k w s s w e w q q w w w w w w w i e w p w y w p p p p v c v p c c c v b l l c v v M z m v z c b l x s l y l z x 3 6 6 6 6 6 6 6 6 6 6 6 6 7 6 7 a.k.b.M M M g.M g.m m v v M v m g.z f.z f.u a.a.a.a.a.a.s.2 9 s.2 2 2 l.l.k.l.k.l.k.CXV.k.V.k.V.k.] k.k.iXk.k.k.k.] %XV.k.] ] CX            k.o o + + # < NX            k.o o + # # + NX.           k.o + o # & = NX            k.o o + + 1 1 V..           V.o o O # @ & < 5 @ < 5 a 5 a 5 5 = & @ ; V.X           V.o o + # @ < 5 0 g < @ 0 < @ d a < g a @ V.&           k.o o O # ; & ; a a = = : ; = : f = e > s b V.e.e.V.V.V.C.BXNXV.e.NXV.e.k.kXV.e.V.] e.V.k.V.V.e.V.NX] ] V.C.V.C.G.C.n.b.n.5.5.5.Z.t.Z.Z.Z.t.t.Z.t.Z.t.Z.Z.t.",
        "gXgXgXgXgXgXgXgXgXgX_ d J -X-X<X<X,X<XgX-XgXgX<XgX-XgX-XgX-XgX-XhXgXgXgXgXgX-XgX-XgXgXgXhX,X@X<X@X,X,X@X,X,X@X,X).-X,X-X-X,X7X,X-X#X<X<X<X#X#X(.(.#X(.#X#X).@X,X<X-X-X-X<X-X<X<X<X#X-X#X<X).).=X-X/.-X=XI.=X=XI.*XI.I.I.^.I.=XI.I.I.I.=XI.=XI.I./.P.P././.T.^././.^.P./.^././.P.J.U.P.P.U.P.^./.^.^.T.^.^.^.^.^.T.).^.^.P.P.P.P.P.P.J.J.Y.J.J.J.J.J.J.J.G G G G XXQ.W.Q./.Q.R.R.R.R.R.~.R.T.~.T.R.R.H E.H H H R.H H H H H H G G H H H H H H L G A E T J T S S _ J T S A S A S _ E J J A F F F F S f f S S > S D S S > S ( : D f f D > ( f f E : ( d T f f f f f f f f f f f f f > h h > h h h h | j | |  .;.c k c k s c p s c p y w w i w w i w w q w w w p p p p p p p c p c p c v c v c v v v v v v v v v v z c b s l s x l l l t q g t t 8 8 6 6 6 6 6 6 6 6 6 6 z o.4.g.m M 4.m o.b.4.g.M v v g.v f.f.f.f.f.f.s.a.a.s.2 2 a.2 2 s.9 8 k.* # & & & NX1 1 1 + + X o o o o o o o o o o o o o . o k.            e.o + o + # 1 NX            k.o X X # # @ NX            k.o o O O O @ NX            ] o o + + + # V..           k.o X # & & a @ @ g a 5 < < g @ ; @ ; ; a e.X           ] o O + # @ < < 0 5 5 < < a a a g ; a ; d ] &           ] o o + & @ ; ; : 0 k ; = s : : = : f s a 4.R & & & & & BXa k 0 = # O # O O + O # O O + # O # + # E ^ & & X & & E V.o.X.4.5.5.o.t.Z.Z.t.Z.Z.Z.Z.t.Z.Z.t.t.5.",
        "gXgXgXgX7XgXgXgXgX-X-X-X-XgX<X<X,X,X,XhXgXgXgXgXgXgXgXgXgX-XgXgXgXgX-XgXgXgXgXgXgXgX-XgXhX,X,X@X,X,X1XhX,X<X,X,X,X,X).,X,X-X,X,X,X,X).<X#X).#X#X#X(.(.(.#X).).-X<X,X<X<X#X<X#X(.#X=X#X<X<X#X=X^.^.=X/.I.I.I.I.I.I.I.I.=XI.=XI.I.I.=XI.I.I.I.I.^.^.T.U.T.P.^.U.^.^.U./.I.U./.I./.U.P.U.^.P.T.J.T.^.^.T.^.^.T.^.T.^.^.^.J.P.P.P.P.P.P.P.J.J.J.J.J.G J.J.C J.C G J.Q.W.Q./.Q.Q.Q./.Q.Q.Q.T.Q.R.R.R.R.R.H H R.H H R.R.H H H H T.G L G H H H H H G H J H J A _ T S T T E J A E A A J A A F A F F F F A S S D S D D S E > S > D > S D S > E > ( S f f ( f > h f f f f f f f f f f > k f h k k h h h h | h | Q  .;.k c k b c s k p y p w w w w i e w y y w i e p p p e p p p p p v c v p c v v v c c v v v v v v v v g.v c c s p l l l l s g q g x f.h.f.f.f.8 7 6 6 6 7 7 M M m M M m o.g.4.b.b.o.M M M M v M g.f.f.z x a.a.a.a.a.a.a.2 2 a.s.8 ]           iX1 1 + 1 + + + + o o o o o o o X o o o o o k.            kXo o + + @ & NX            V.o o X # & # CX            NXo o O # & @ NX            k.o o o X # # NX.           %XO o X # & @ a 5 a 5 g a a g @ ; = ; ; a e.X           V.o o O # @ a < < q a a a a @ d a a a ; ; ] &           V.O o O # & ; ; s : = f : : a k k : k a k 1.%           NXr = ; = # # O # # O O # O # O # # # # @ k T           & V. .o.o.5.5.5.Z.i.S.t.t.Z.Z.t.Z.Z.Z.G.Z.5.",
        "gXgXgXgXgXgXgXgX-XgX_ 5 _ <XhXgX,X<X,XhX-XgX<XgXgX-XgX-XgXgXgXgXgXgXgXgX-XgXgXgXgXgXgXgXhX,X,X@X@X,XhXhX#X#X@X@X).-X,X-X-XhXgX,XgX,X>X<X#X<X-X).#X#X#X<X#X#X,X-X-X<X-X<X-X<X-X<X,X,X<X#X,X=X-X=X/./.=X=XI.=XI.=X=XI.I.I.I.I.I.=XI.I.I.I.I.I.I.P.P.U.P.U./.U././.I.I.P.I.I.I.I.P.U.T.T.U.^.P./.P./.T.T./.^.T.T.^.T.T.P.P.P.P.P.P.P.J.J.Y.J.J.P.J.J.J.G G G J.G G L.Q.XXQ.Q.Q.Q.Q.T.R.R.Q.T.Q.R.T.Q.Q.H R.H E.H H H R.H H G L H H H G H H H H H H H H H H H J _ S _ S T _ J A A _ F ! F F F F _ K S S D S D S D f D S D S S D D f f E > E : ( > S f > S > > , k h > k f f > f f f h k > h k h h j h h | | h | j k c k s k w O.O.p w q w i w w y w w y w w e p p p p p p M M v p p v c v M c v v v M v v v v v v z z v c p c c l u z g q q s f.f.d.f.f.f.f.f.f.z 8 7 ) g.4.o.4.b.o.b.4.b.o.g.4.b.b.g.M v m m g.f.f.f.f.i a.a.2 a.2 s.2 2 9 x R           k.1 1 # + + + + o + + + + X + + X + O + + o NX            k.. o X * @ 9 NX            e.o o + & @ 1 NX            %XO o O O # # NX            k.o o + O # # V..           V.o o X # # & @ @ a < a 5 5 @ ; ; ; @ ; @ V.X           ] o o X # # < a < g < < 5 < @ 0 a @ d a ; V.&           %XO o O O # ; ; ; ; > ; f r : g f = > a f 4.%           iX0 a = = = # @ = # = @ @ @ = = = = = = 0 ( T           & C. . . .o.O.5.t.Z.t.Z.Z.i.t.S.Z.t.t.Z.5.Z.",
        "hXgX).-XgX-XgX).-XR k.] [ _ -XhXgX-X-XgXgX-XgXgX-XgXgXgX<XgXgXgXgXgXgX-XgXgXgXgXgXgX-XgX,X<X@X<X,X@X,X<X#X(.<X-X-X#X,X,XhX<XgXhX,X<X<X<X<X#X#X>X+X-X).@X#X#X-X<X-X<X<X-X<X<X<X<X#X<X(.<X-X=X=X=X=X/.=XI.I.I.I.I.I.I.=XI.^.=XI.I.I.I.I.I.I.I.I.I.I.I.U.P.U./.P./.U.I.P.P.P.I.I.P./.^.^.U.P.T.T.^.T.T.T.^.T.^.^.(.T.^.I.P.P.P.P.T.P.P.L.P.L.J.P.P.J.G R.G J.G J.T.L.W.Q.Q.Q.Q.W.T.!.Q.Q.T.T.Q.R.~.Q.Q.R.E.R.R.H ~.H H H H H H H H H H H H H H H H H H H H H H F J F E A _ E _ A F E F F _ F F F F D S : D S D S D S ( S S S > > D D > S f D f > f > > > > > > k h h h j h k k k f r  .h  .| | |  . ...| | | h  .j k j p k p O.O.p i w i e w i w y y y w p p p p p p p p v p M p v c v v v v c v v v v v v u v v v v v c p p c k c p s k k k c j j f.f.f.d.f.z f.u v b.o.b.4.b.o.b.4.b.b.o.m 4.b.M M v g.4.b.b.g.f.f.a.f.f.a.a.a.a.a.a.a.2 a.[           ] # 1 1 + # + 1 # + + # + # # + # # # O & + NX            k.o o + # @ < NX            e.o X X & @ @ NX            iXo X X # @ & NX            e.o X X X & & V..           e.o X X O @ @ @ ; < < 5 0 ; a ; ; ; ; ; ; V.X           k.X X + # @ a a < g g < a a a a a ; f d a V.&           e.o o O & ; = : : g : = , g = : , e > : k 4.%           k.@ = ; = ; = = = = = 0 = e 0 0 0 e e : = / T           & e.> k  .o.X.Z.Z.t.Z.Z.i.Z.S.t.i.Z.Z.t.Z.t.",
        "hXgXgX-X).gXgXgX[ l.SXSXl.8 P -X<X-X-X-XgXgXgXgXgXgXgXgXgXgXgXgXgXgXgXgXgXgXgXgXgXgXgXgX-X<X#X<X@X<X@X).#X<X).#X<X#X-X<X-X<X<X<X,X7X<X<X<X<X=X#X-X+X<X>X).#X-X-X<X-X-X<X-X<X).#X<X-X-X>X-X=X=X=X=X=XI.I.I.=XI.I.=XI.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.U./.P.U.P.I.I.U./.I.I.I./././.P./.^./.T.P.T.T.^./.T.^.Q.T.T.^./.P.^.U.P.P.P.P.P.P.J.P.P.J.P.J.J.J.L.G J.J.G Q.Q.Q.Q.Q.W.T.Q.T.Q.T.Q.Q.R.Q.T.Q.Q.Q.G H H H H R.H R.H H H H H H H E.H E.H H H H H H K K H F ' K K F F F A A A F F F F _ K F K A E S ( D f S > D S > D D D S S E : > f h f ( f > : > S > h > j h k j h h h h h  .| | | | | |  . .| | | | |  .j n c c c p O.p O.y w w w w w y w p w e p p p p p p y p v M p v v p v M v v v v v v v v v g.v g.z z v v  . . .| j j h |  . .j j  .f.f.f.g.f.u v g.b.4.o.b.o.o.b.5.4.o.4.b.b.b.b.4.m M v g.g.g.m g.f.f.f.8 a.2 a.a.2 2 a.8 x ]           ] + + + # 1 # 1 1 1 # < 1 < # & 1 & @ @ @ & NX            e.o o + + # @ NX            kXo X + & & @ BX            k.X O & & & ; NX            e.o X X O & 5 NX.           k.o o # & @ % @ % ; < g a @ a ; ; a ; a ; V.X           e.o o O & & < a g q x 0 g a a a d a a d ; e.&           k.X X O & = ; ; f a > : : : > f f : f k f 4.%           V.@ = @ = 0 0 g k s k k s k k k k k > s k / T           & 4.= k h  .o.5.5.Z.Z.i.Z.Z.t.Z.Z.Z.t.Z.Z.t.",
        "-X-X<XgX).,X).8 v.SXSXv.v.h.a.3 -X-X-X-XgX-X-XgXgXgXgXgXgXgXgXgX-XgXgXgXgXgXgX-XgXgXgXgX-X<X).).+X<X<X).>X(.=X@X<X-X<X,X<X<X<XhX,X<X>X#X-X=X).)./.#X#X#X).>X<X-X<X<X-X-X<X).-X<X>X<X=X=X=X=X-X=X=XI.=XI.I.I.=XI.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.I.U.P.P./.P.U.P.I.I.P.I./.I./.I.^.P./.^././.J./.T./.^.^.^.^./.(.^.I.U.P.P.U.P.P.P.J.P.P.J.P.P.L.T.J.G R.R.R.J.Q./.Q.W./.Q.Q.Q.!.T.!.T.!.T.!.T.L.XXL.J R.R.G G H G H H R.H H R.H H H H H H H H E.H H H E.H F K F K ' J K F F _ F E F F K F F F S S f D S D ( D > S S > > S ( > D > ( S > ( > : : > : > f h > h h j h h  .h  .|  .| ..j  .| ..|  ... .| |  .| p j p k p p O.p O.w w w w y w i p w p p p r p p p y z p p v M v p v v c v v v v v v v v v v v f.v f.v p  . .h |  . . .h  . .j h  .v g.f.f.f.g.v b.o.b.o.o.b.o.4.b.b.o.b.M M b.) g.b.M g.b.b.g.g.g.g.f.a.f.d.a.a.2 a.2 8 2 8 ]           k.+ + + # 1 1 1 < < < < < < < @ < < & @ % @ NX            kXo X + & & 5 NX            e.o + O # @ @ NX          . kXo X O & - ; NX            %Xo o X O # & V..           e.o X X # & @ ; a < < a a d @ ; ; ; ; a ; V.X           k.o o O # @ ; 0 5 g g 0 g 5 a 5 g ; d ; ; e.&           kXo o O & ; ; : f : f > k : > : k : > : f e.%           e.# # @ @ a g s p k M c c j n M p k r k h 4.T           % ) - = k  .X.5.5.n.5.Z.t.S.Z.i.Z.t.t.D.Z.Z.",
        "<XgXgXhXhX#X[ l.UXSXv.s.j.l.l.[ 5 <X<X-XgXgXgXgXgX-XgXgXgXgXgXgXgXgXgXgXgXgXgXgX-XgXgXgX-X-X>X#X#X@X).-X).<X).<X).,X-X-X<X<X<X<X-X<X<X;X>X>X;X>X=X>X<X/.<X<X=X<X<X<X=X-X-X>X<X=X-X<X=X=X=X=X=X=X=X=XI.I.I.=XI.=XI.I.=XI.=XI.I.I.I.I.I.^.I.I.P.I.I.P.P.P.U.U.P.P.I.P.I.I.I./.I./.I.I./.T.U.T.T./.T.T.T.T.Q././.^.^./.P.P.P.P.P.P.U.P.J.Y.J.P.J.Q.P.L.R.L.J.L.J.R.Q.W.Q.T.Q.Q.T.!.T.T.!.T.T.R.T.T.Q.G Q.E.G H G R.G G G H L H H H R.H R.H ~.H R.K K H H H H K F K ' F K K F K F K J F ' F F K F K A ( S D ( ( ( : D f D S D > S > > f > f ( : : D : : : : > > > k j h h j h  .h  .|  . . .|  ... .|  ...h | | ..j M  .p k O.p O.p w i w i w p p w y p w p p p p p p p p v p v p v z v v v v v v m v v v f.v v v v  . . . . . . .h h  . .| j j j  .v f.d.g.u f.g.4.b.4.5.b.4.b.b.o.b.4.4.b.4.b.o.M g.M b.b.b.b.g.b.g.f.d.f.a.8 a.8 2 s.a.8 x R           ] o + + + @ 1 < q < 5 q 5 g < 5 d a a 0 a a NX            k.o X + & 1 < NX          . kXo X + & & @ V.V.NXiXNXk.e./ o X O # & ; NX            V.o X o O # & V..           k.o X + & & @ 5 g a a a ; ; a @ a ; ; ; a V.X           e.o o # # O = ; < w q 5 a a g a : ; f : ; ] &           e.O O O O & ; ; ; a > a > > : f > : > , : 8.%           NX^ ) / ) C.e.C.V.C.C.V.C.C.C.C.e.e.C.e.C.BXT           & ] = = e j X.4.5.5.5.t.5.5.Z.t.t.S.Z.Z.i.Z.",
        "hX-X-XgX+X[ l.zXV.l.3 5 x [ l.V.[ d XX,XgXgXgXgXgXgXgXgXgXgXgXgXgX-XgXgXhXhXgXhXhXhX,X<X,X#X-X(.#X-X<X#X=X@X#X-X<X<X<X<X<X<X<X<X,X-X<X>X>X>X>X*X=X;X=X=X=X=X<X-X<X<X<X=X<X<X>X<X<X=X=X<X=X=X=X=X/.=X=X=X}.I.=X/.I.=XI.I.&X/.I.I.I.I.^.I.I.P.I.I.I.P.P.P.U.P.U.P.I.P.I.I.I./.I./.I.I./.^./.T.^.T./.T.T.^.^././././.^.P.U.P.P.U.P.P.P.L.P.J.J.P.L.L.L.T.R.L.J.Q.J.Q.W.Q.Q.Q.Q.Q.Q.W.Q.^.T.Q.T.Q.Q.Q.Q.Q.V G Q.V G G G G J N G L G J G H H E.H H E.H H E.H H ' F ' F F ' H _ K K K K F H ' F F F ' F ( D D E > f ( D D E > > > D D S > h S f : : > : - , - > r > h h j h h  .| h  .| |  . .|  .| .. .| ..h | | | j k k p o.p O.p O.w w w w w w y w p p p w p p O.p p p p p v v v v z v v z v v v v v v v v p v M p .. .k  . . . .j  .h  .| | j j h n f.f.g.f.g.o.b.o.b.4.b.o.b.o.b.4.o.o.b.b.4.o.M ) g.b.b.h.b.b.g.g.b.f.f.f.a.a.a.2 a.8 x ) [           ] o + + 1 1 < g 5 5 q x 1 g g g f g a g d 5 NX            kXo o + 9 & & NX            V.o X # # @ ; d ; & & $ O O X X & O & : : NX            NX. X O O & & V..           NXo X O & @ & 0 d a a ; a ; a @ a ; a ; ; V.X           ] X X O O # ; @ ; f s q a d % : f ; f ; : V.&           %XO O + @ = ; f f f , s > > : f f > > : > ] %           & & % % & % & % & % & % % & % % & % & % & % .           & ^ & ; > h o.o.5.5.5.n.5.5.5.5.5.5.t.Z.Z.D.",
        "gXhX<XR [ [ x [ 3 g NXVX] % d 4 5 R d ,XgXgXgXgXgXgXgXgXhXhXgXhXgXgXgXgX,X<XhXhXhXhX<X<X#X/.#X=X/.-X).<X<X<X<X(.(.<X<X<X<X<X<X<X,X,X<X>X*X>X>X:X;X;X;X;X=X<X-X<X<X<X<X<X=X<X<X=X<X=X=X=X=X=X=X=X=X&XI.}.}.}.&X&XI.I.I.I./.&XI.I.I.I.I.I.I.I.P.I.Y.J.L.U.P.U.P.U.P.I.I.I.I.I././.^././.P.T././.T.T.T./././.I.^.I././.U.P.P./.P.P.P.U.P.P.P.P.L.L.J.L.U.L.Q.L.L.Q.Q.'.W.'.Q././.Q.L.Q.W.Q.W.Q.T.R.XXQ.Q.E.E.G G E.Q.G J J L N N S F S F J H H H R.H H E.H H ' K F K K ' K K K K E.K K K F K H K J A D S ( S ( D ( f ( ( ( S D f > > ( > > > > > : : : : = , > > k h h h | r | ..|  ..... ... . . ... .2.| | | | j p  .p p O.p O.p i i w i i w p w w w p p p p p p p p u v p p v p z v v m v z v v m v v b j o. . . .M O. .k .. . . .h  .j j |  .;.j v f.f.g.M b.o.5.o.b.o.b.b.4.4.b.b.4.4.4.o.) 4.o.b.b.b.b.b.b.g.b.g.m f.a.a.a.a.a.a.i z ) R         . ] o + # # 1 < w 2 g t a g g g g f d a f a g NX            e.o o # # @ 5 NX            ] X X O & & ; ; ; ; ; & O O O X O & & % % CX            ] o X + O & # NX.           ] o X + # & @ @ a @ : ; a a g ; = a : g s V.X           e.o o O @ $ = ; = ; : = d : : : f : : d f e.&           e.o O O & $ ; f ; > f : : > > > > f D > > e.%                                                                   & ^ O = e h ..5.5.5.5.5.5.Z.n.5.5.5.5.O.5.5.",
        "<XgXgX<X<XgXgX<XT CXIXUXVX] P @X,X<X<X<XgXgXgX<XhX,X-X-XhX@XhXuXhXhXgXgXhXCXhXhXhX@X<X<X(.#X(.<X-X).(.<X).#X-X<X,X<X<X>X<X<X<X<X<X>X>X>X>X>X;X;X;X=X;X;X&X=X<X<X<X<X<X<X<X<X=X<X=X=X=X=X=X<X=X=XI.&X}.}.;X}.&XI.I.I.I.=XI.I.&XP.I.I.P.P.I.Y.P.P.J.L.P.P.L.U.U.I.I.I.=XI./.I.&XI.I.I.&X/.U.^.P.^.T./././././././.^.U./.P.P.U.P.U.P.P.P.J.P.L.P.L.L./.L.U.L.Q.XXL.W.W.Q.Q.Q.W.XXQ.Q.Q.Q.E.Q.Q.Q.E.E.G Q.XXQ.G G R.G G J V G L G S S J F F K K F H R.R.H H J K H ' K F F K K F K K K F H K ' H H K F D ( : D D f D ( D D ( ( ( ( > ( > > : > : : > : , : : : k > > > r h r  .h | | | .. .|  .r  ... .| | |  .| |  .| M  .O.p o.p O.O.p u p p p p p p p p p p p p p o.p p v v v v v v v g.z v v v v v c 2.>.>. . . .p p  . . . . . . . .j  .| h  .| ..p p M v b.b.5.b.o.b.o.o.o.b.o.4.g.b.4.4.M M M b.g.g.b.b.b.b.b.g.4.g.g.f.a.a.a.8 z l c m [ .         ] + O + 9 < < g 2 g g g g f f g g g f g a a BX* & & & * & V.o X # & & a NX& * & & & * NXo X + & @ % % ; % & & O & & O & & & : @ NX& * & & & * e.o X O # & & NX& & & * & * NXo X O O @ @ ; a ; f a a ; a ; a f ; a = V.: $ * & & * V.o o O O = = - = : = - : - : - : ; : : ; e.P * & & & * NX. . O # # = ; : f > > > k k > > : > : > 4.R O & & & * & X O & & O & * & * & * & O O & & O & * X & & * & * * & E ^ = = e h  .5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.",
        "gXgX<XgXgX<X<XgXT k.VXCXNX[ T ,X,X<X<X,X<X<X<X<X,X,X).-X@XhXhXhXhXhXhX<XhXhXhXiXhX<X+X(.=X/.#X=X>X).<X).<X<X<X<X<X<X<X=X<X>X>X*X;X>X>X*X;X*X;X>X;X>X&X=X;X=X>X=X=X=X=X=X>X*X<X*X=X=X=X=X*X=X=X*XI.;X}.;X|.}.}.;XI.&X&XI.I.I.I.U.I.Y.P.I.P.P.U.Y.L.J.L.P.P.P.U.P.I.I.I.I.I.I./.&X&XI.&XI.P.U.U.U.U.U.I./.U.U./././.U.U.U.U.P.P.U.U.J.U.P.U.U.T.L.T.L.U.L./.Q.Q.XXL.XXXX/.XX'.Q.XXXXQ.XX'.Q.Q.Q.'.Q.'.Q.R.G Q.I G G J _ _ N N G J J S A K K F K ' K K K H ' K ' F ' _ ' K K ~._ K H ' K K H K K K A ( D D f ( W ( f ( ( f k D ( ( ( ( D > D : , : : : : : , > h > h > h | | r | | r h r |  ...|  ... .| | | | | ;.2. .M p O.o.O.o.o.O.O.o.o.O.O.p O.O.O.o.O.O.o.o.o.o.v u g.p v u z v v v v f.v v  .>.2.:.>...p j .. . . . . ...k  . .| j ;. .j | | j M  .o.o.o.b.o.b.o.b.4.b.o.4.b.4.4.b.4.o.) o.b.b.b.b.g.b.b.b.b.g.g.b.M d.a.a.f.m v v ) [           ] o o # # < 5 s q x l g f g g g f g g g f d BX; % % % % ; k.X X O # @ < CX% % % % % % V.X O # & & ; : ; ; : % & & & & % & ; d : CX% % % % N ; NXo X X O & = NXS 5 N ; % % e.o o # # & @ = @ @ @ ; = a a ; a a ; g f V.E 4 % d N ; e.O o O O $ ; = : : : ; : : > : f : f f f e.[ d % 5 N ; iX. o o O - - : k f : k > : : > > > ( > f e.] % % 5 N ; % 4 N % % N % 4 4 : % % % 5 N % N % % 4 P % P : d N ; % R / # - > h o.o.5.n.5.n.5.5.Z.5.5.5.o.5.5.5.",
        "gX<XgXkX[ 3 8 7 3 3 [ k.[ 3 9 9 5 % % ,X,X,XhX1X@X,X@X@X1X1X>X>X@XhXuXhXhXhXhXhX,X=X-X/.(.).(.=X=X-X#X-X).>X<X<X>X>X>X>X>X>X>X>X>X=X>X;X;X>X*X>X&X;X;X*X*X;X}.;X;X=X>X=X=X<X=X*X&X=X&XI.&X&X&X}.}.}.}.}.;X}.|.}.&XI.&XI.&XI.U.U.P.Y.U.Y.P.P.Y.J.J.K.J.L.J.P.L.I.I.I.I.I./.I.I.I./.&XI.&X/.I.U.U.U.U.&X/.U.I.}.U.U.U.U.U.U.U.U.U.P.U.U.U./.U.L.U.U.Q.L.Q./.XXU.W.Q.XXQ.'.Q.Q.'.W.Q.XXQ.Q.XXQ.Q.Q.Q.'.E.Q.Q.U I _ I _ I I _ _ U J S A J _ ' K _ K K K K ' F K K K R R R ' K _ K K K H F K K K K H A D W ( D ( ( D ( D D f ( ( D k ( h ( > > : : : : : : : , k > > > h > | | r h | h r h | | | .. ...| | ..|  .|  .,.2.2.o.o.O.O.p o.M o.v p o.o.O.o.o.O.o.O.o.o.O.O.o.o.v v v v v v z z v v v n >.>.>.2.>.>.:. .o. . .p  . . . . . . .h  . .h | j  .j n o.o.o.o.o.o.b.o.o.b.o.4.b.4.4.o.4.4.M n g.b.g.b.b.h.b.b.b.b.b.b.g.M g.f.f.M g.v v g.]           ] X X # @ < q x g g k l g g f f b f k f g g BXP d P S T T iXo O O @ @ a NXT T T T T T e.X X O & ; % d : d T ; & ; : % : % d d ; BXT T T T T S NX. X # & ; ; BXT T T T T T NXo + O # # # & ; = ; g g a a ; 0 ; ; : ; V.R T d T d S V.o o O & $ = = = : , - : : : : : f f : d V.R S S P d N NX. o O $ ; : : > : > g > > f h > f W > > e.] N S P T T T T S 4 T T P S S P T d S P d T T T d T T d P T d N P d ] ) O = > j X.5.5.5.5.C.n.Z.5.5.5.5.4.5.5.5.",
        "gX<X<XgXXXl.l.SXl.l.2 2 2 8 l.l.l.d E.<X,X,X@X@X$X@XhX@X>X>X;X;X:XvX>X>X@X@XhXuX<X<X=X(.(.>X(.-X).-X<X>X<X<X<X>X>X+X;X;X=X>X:X<X*X>X;X;X;X;X;X;X;X;X;X;X}.;X;X;X;X;X;X=X>X*X>X=X&X=X&X/.I.&XU.;X;X}.&X}.}.}.}.|.&X=X&XI.U.U.U.I.P.U.L.P.P.U.J.L.J.J.L.Y.L.Y.P.I./.I.I.=X&XI.I.&XI.I.&XI.I.I.I.+X/.I./.}./.&X/.U.U.U.U.U.U.U./.L.P.P.P.U./.U.U.Q.L./.L.U.L.L.W.'.XXQ.XXQ.'.W.'.Q.W.'.'.Q.Q.Q.'.Q.Q._ V Q._ I I I I '.[ [ U _ U _ _ _ S F F K K K K K F ' K ' ' R R R R R _ K E.K K K F F _ K K ' K ( ( D ( k D ( ( ( ( ( ( ( ( h h ( D : : > > : : , : , f > > r h > h h | | | |  ...| h  .| .. . . . . .| | ;.;.;.1.1.Q o.M o.o.p O.b.O.O.p o.o.o.o.o.o.o.o.o.o.o.o.o.v v v g.g.v g.f.v M 4.>.>.>.2.>.:.>.2. . .o.p .. . . . . . . . . . .2.| | |  .n o.o.4.b.4.b.4.b.5.o.b.b.4.o.b.b.4.o.4.M b.b.b.b.b.b.b.l.b.b.b.g.4.b.m g.M g.v v m ) R         . ] X + O # < 5 g g b g ( g b g g g g g f g g CX% % % % 4 d e.X O $ - & : NX% % % % % % NXX X & & ; ; f d ; : ; : d ; ; S ; : d : CX% % % d 4 ; NXo X X O & & NXT d % % % % kXo o X # & ; & ; = f ; a f g a f ; a a : V.E 4 % % % % NXo . O O = $ : = : : : > : : S : : f : : e.R 4 % % 4 ; iXo X O & ; : > D ( > D D > h D > h h > k e.^ % % % % % % % % % % % % ; % % % % % ; % % % % % S % % % : N ; % : [ ^ O : r h  .o.5.5.t.5.5.5.5.5.n.5.5.5.5.O.",
        "<X<XgX<X-X@X[ l.SXSXzXl.l.v.l.a.4 #X<X<X<X+X,X+X@X1XhX@X>X;X:X1X;X;X>X1X1X>X>X>X>X=X=X-X=X)./.>X#X>X+X>X+X>X;X X;X X;X X>X*X<X*X>X:X>X;X*X;X;X;X;X;X;X*X;X;X;X;X;X;X;X;X>X;X*X=X/.&X&X&X}.;X}.&X;XU.|.}.}.}.;X}.}.&X&XI.;XI.I.U.U.L.U.P.Y.P.L.L.K.L.L.J.L.U.I.I.I.=X&X/./.&X&X/.&X&XI.I.&XI.I.&XU././.&XU./.+XU.U./.U.I.U.U.U././.L.U././.L.L.L.'.L.'.L.'.Q.W.Q.U.W./.XX'.XXW.Q.Q.Q.L.Q.Q.V Q._ '.L._ Q.'.I _ I I I I [ U [ [ U U [ _ ' ' ' K ' K ' K K ' K ' R R R R ' R _ ' ' K F F F ' K H ' F k D ( ( D ( h h h ( h > ( h ( Q h > > > : > > h : : : > > > h > h h > h h | | | .. .....j  .|  ... .| | ;.| | ;.2.2.2.;.o.o.o.O.v o.p o.o.o.o.O.o.O.M o.O.O.o.o.o.o.o.f.v v f.g.M n o.>.>.>.9.>.>.2.2. . .>.2.r  . . . . . .r  . . .;.| j ;. .j  .n o.b.o.o.o.b.4.o.4.o.4.o.4.b.o.4.4.o.4.b.b.b.h.b.b.b.b.b.b.k.o.g.b.b.) 4.4.n ) Q ) 4.]           ] X O # & a g g f f f b g k f s s g k g g f BXT S d T T T kXo O & & : : BXT T T T d N k.X O O & ; ; : f : : T : E T : d f f f d BXT T d T d N NX. O O # ; ; NXT T T T T P V.o O O O & = ; ; @ a f a a k ) ) ] ) ) ) BXR T T 4 T P iXo O O # $ = : : : : : > : : : > f f : f e.R E T d S P NXX o O $ : S D > ( h D h D D D > #.W D > e.] 4 d T T d NXNXNXNXNXNXiXNXNXNXNXNXNXBXNXNXNXNXNXNXNXNXNXNXNXBXNXBXBX( = = > k O.5.O.n.5.5.5.t.n.5.5.5.5.X.4.5.",
        "gXgX<XgXgX<X@X3 SXSXSXv.v.l.8 3 1X<X<X<X<X+X+X@X@X@XhX@X1X;X;X;X;X1X;X>X1X>X>X>X|.>X>X>X>X+X>X+X+X>X>X>X+X;X+X>X|.;X;X|.>X>X:X>X;X>X;X;X>X;X;X=X;X;X;X;X;X;X*X;X;X;X;X;X&X;X;X*X&X&X&XI.;XI.U.;X}.;X}.;X;X}.}.|.|.}.U.U.U.I.}.I.Y.U.Y.U.P.L.Y.J.J.L.L.J.L.U.U./.I././.&X/.I.I.I./.I.&X/.I.I./.U.>X&X/./.I.U.&XI.U.U./.{./.{./.{.{./.U.XXU.U.L./.XXL.XXXX'.'.L.XXXXL.XXQ.W.Q.W.'.XXQ._ E.XXXX'.XXXX_ XXI I I '.I I I I I U _ U R _ [ U _ H ' ' K ' K ' K H ' _ R [ _ R R ' R R R ' K J ' F H ' H K ( k h W ( D ( ( D ( W ( ( ( ( ( f > > > h ( h h > : > h > r > r > > r r | | | |  . ...| .. ...| .. . .;. .;.| 2.2.2.2.2.2.o.o.o.o.o.o.O.p o.o.M o.o.o.o.o.M o.O.o.o.o.v g.v v o.O. .>.>.>.>.>.2.:.>.>.2.>.>. . .M j  . . . . . . . .j  .;.j | | ;.n o.4.o.5.b.o.o.b.4.4.b.4.4.4.4.4.M ) 4.4.b.b.b.b.b.b.b.b.b.b.b.4.b.4.4.b.) 4.) ) Q ) ] X X X X X NXO + # @ a g g b g b f k b g BXBXCXCXCXCXBXVX4 4 T T T d e.O O O = - : BXP ; T d T 4 iXX O O & ; : E f : E f T f ( f f E S f f BXT T N T P 4 iXX X O & & ; NXT T d T d d V.o O O & @ = ; ; ; = f a k V.%X] ] ] ] ] ] T T T S S 4 kXo o O $ & = : : : : : D : S : : : f : a e.R 4 S P T d NXo O O $ : : > > D D h D D D W D D ;.D ;.e.] S N d d P NXo O O O O O O $ O $ $ $ O O O $ O O O $ O $ = # O O O O & - = > k  .5.5.5.n.5.5.n.5.5.5.5.5.5.5.5.",
        "<XgXgXhXgX<X<XgX4 l.SXSXh.8 4 -X<X<X<X<X1X>X1X+X$X@X@X@X;X;X;X;X;X>X>X;X>X1X+X;X>X;X>X>X>X>X+X;X+X>X>X>X$X>X>X X;X|.$X;X>X=X>X>X;X;X;X&X*X>X;X;X;X>X*X;X;X*X;X}.;X;X;X&X*X;X;X&X&X&XU.;XU.;X}.}.U.;X}.}.}.;X}.}.|.}.}.U.&X}./.&XU.U.L.P.Y.J.V J.K.L.L.L.U./.U.U./.U.I.I.&XI.&XI.I.I./.&X&XI.I.U.I./.U.=XU./.U./.U.}./././.{./.U./.U.{./.U.L././.'.XX'.L.XX'.Q./.W.XXQ.'.Q.XX'.Q.XXQ.XXG XXI XX_ I XXI XX'.I I I I I I I I [ I [ P [ _ _ ' ' K ' ' K K K ' ' R R R R R ! R ! _ ! _ _ F K ' K ' H ! ( h h k ( h W W h h W k W ( W h h > h h h h W ;.W : = h > > r r > > r h h |  .| :.:. . ... . ... .| ;. .| ;. .;.2.2.2.2.2.2. .M o.o.M o.O.M o.o.o.o.o.o.o.o.o.o.o.o.o.o.v o.O.O.4.>.3.>.>.>.>.>.>. .2.2.>.>. ... .j  .| | ;. .2.h  . .h ;. .j |  . .o.2.4.2.4.5.o.4.b.4.o.4.4.4.4.4.2.2.2.2.2.4.b.b.b.b.b.b.b.b.b.b.4.4.) 4.b.) 4.) 4.4.NXT T T S T CX+ O # ; g g g b g b b g ) f CXE T T T E T E T T E T T T e.o O $ $ : : BXE T T T T T V.o O O & : S f ( E f : ( E E f f E f d f CXT E T T T T iXo X O & & ; NXE T T E T E NXo X O O & @ ; : a ; a g g V.^ T T E T E T T T E T T T iXo o O = $ : : , > : S S > f > : : : f ( V.[ E T T T T NXo O O = - > D ( ( > D D > ;.;.D D ;.D W e.] T T T T T iXX X O O O O $ $ O $ $ O $ $ $ O = O = = O O - @ $ $ = = = : = k  .o.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.",
        "hXhX<X<XgXgX<X<X<XP j.l.3 P <X<X<X<X<X<X@X>X@X+X>X#X1X>X;X:X;X1X1X;X1X>X>X>X;X>X;X+X;X+X>X>X>X/.>X;X>X|.;X+X|.;X;X|.;X;X;X;X;X;X;X>X>X;X;X>X;X>X&X;X;X;X;X;X;X;X&X}.;X;X;X;X;X&X}.}.}.U.}.;X&X}.}.;XU.}.&X}.}.}.{.|.{.U.U.&X}.&XU.L.Y.U.L.K.J.Y.B J.L.U.U././.U.U./.U.+XU.I.U./.I.I.&XI./.&XI./.&XU.I./.I.}.U.U.U.U./.}././.{./.XXU.'./.U.U.L.'.XX'.'.XX'.'.'.Q.L.W.Q.W.XXQ.Q.XXQ.'._ '.I XXV XX_ I I I _ _ I I I I I I I U U I _ _ _ _ ' ' ' K E.' ' ' ' _ R R R R _ R _ R R R ! R R ' F F F K K ( ( W ( W ( W ( ( ( ( ( ( h ( ( > h h D k > h > h > > > r > k > > h h h h  .| |  .| .... .:... .| :.;.;.2.;.;.2.2.2.>.2.2.4.4.o.M M o.o.M M o.M o.o.M o.o.o.o.M o.o.X.o.O.O.o.>.>.>.>.>.>.1.>.2.>.>.:. . .>.2.>.1.2.;.;.2.2.;.2. . .2.2. .;.| j ;.n ) 4.) 4.) 4.4.o.4.o.4.4.4.4.>.>.4.4.1.2.2.1.1.4.b.b.b.b.g.b.k.b.V.b.b.b.) 4.4.4.) ) NX% P 4 % 4 NXX X # & d g f f b ( g k b g CX; ; N % 4 5 N ; N % 4 N d V.O O O = : S BX% % % T N 4 iXX O $ ; : : : f f ( f ( f f f ( f f ( d BXN ; d 5 : 5 NXX o # & ; ; NXd 4 % % N ; e.o X X O & ; : g : h a a f V.E % % 4 % % % N : 5 N % % V.o O O O = : = a f : > ( : : : > S f > : e.R % P : 4 N NXO O O $ : : ( > D W ( W D ;.D D ;.W ;.~ r.] % T % d N NXO O O $ $ $ - , $ - , - - , - - - - : , : , , , , : , : , > > |  .X.5.5.5.5.5.5.5.5.n.5.5.5.5.5.5.",
        "<X<X<XgX<XgX<XgX<X<X%XR XX<X<X<X<X<X,X>X$X+X1X>X+X>X1X>X1X;X>X;X;X>X1X>X>X>X;X>X;X;X>X;X=X>X>X>X>X+X;X>X>X;X|.|.|.>X|.|.;X;X|.;X;X>X;X;X&X;X;X&X;X;X*X;X*X;X;X;X;X*X;X[.;X}.}.}.}.}.[.U.U.}.;X}.U.}.;X;X}.{.|.{.{.|.|.|.}.U.;XU.U.U.Y.L.L.L.L.L.L.L.U.U.U./.U.U./.{.{./.U.{./.U.U.I.U.&X&XI.&X/.+XU.I.U.+XI.=XU.+XI./.}.}.+XU./.U.+X/.U.U.XX/.L.'.Q.XXL.'.Q.'.Q.XXL.'.W.Q.XXXXQ.'.XXXX'.Q.I E.'.'.I I I I I XXI I I [ I I I I _ [ _ _ _ K ! _ F _ F A F _ R R R R R R R R ! R E _ R ' _ _ ' ' H K k ( h h ( h h h ( ( h W h ( W > h D h h h h h h h k : h > k > h k h > > ..| ;.| |  . . ... . ...2.,.1.1.1.1.1.2.2.2.2.2.Q 2.n o.4.o.o.o.M o.M o.o.o.M v o.o.M o.o.X.o.o.O.X.>.3.>.>.>.>.>.>.>.>. .2.2.>.2.,.<.,.<.2.2.;.;.Q ;.|  .Q  .h  .| j ;. .W Q ) 2.1.4.4.4.4.4.4.4.4.4.1.4.4.>.1.>.9.2.1.1.>.1.9.8.9.b.b.g.b.b.o.V.4.b.) 4.4.4.q.NXT T S P T CXO # # @ a g b g b b s b b b CXT T T T T T T T T T T T T NXX O & - : > BXT T T T T T NXX O O - ; : > : : f f T f f R ( f f E f BXT T T T T S V.o X O & ; ; BXE T P T d d NXo O O @ = = ; : : f a s f V.^ T T T T T T T T T T T T NX. O O $ $ : ; f ( ( : D : D : f : ( S f V.[ T T T T d iX. O O & : f D W D D h D h W ;.D W #.W ;.e.] d T T ; T NX$ O $ $ - - - - , , , , Z > D Z Z Z Z , > > > > > > > > > h |  .X. .>.5.5.5.5.Z.5.5.5.n.5.5.5.5.5.",
        "<X<X<XgXgX<XgX<XhX<XgX<XgXgX<X<X<XhX>X+X>X@X+X>X1X@X+X;X:X;X:X;X1X;X>X>X>X1X;X>X>X>X>X=X;X>X>X|.;X>X+X;X+X;X X;X;X X|.|.;X;X;X;X;X;X>X*X;X;X>X;X;X*X;X;X;X&X;X;X}.;X[.}.;X[.}.}.}.}.{.}.}.}.}.}.}.;X}.}.|.}.{.|.}.|.{.|.}.&X&XU.}.U.L.L.Y.L.L.L.L.P.P.U./.L./.U.U.U././.{./.{./.{.{.U.+X&XU.&X/.U.=X+X&X&X/./.}.U.U./././.U.U.{.{./.{.XXU.XXU.U.{.'.'.XXXX'.I '.W.XXQ.XX'.Q.XX'.J I XX_ _ '.I _ _ I _ '.I I I I I U ].U I I I I U _ P [ _ _ E _ F E _ E R R R R _ R R _ E R E R ! R _ ! ! ' _ K F h h h ( h h ( h h h W h ( k h h h h h h h h h h h h > > r > h h > h r h | |  . .| | >.X. ...X.2.,.2.1.1.;.,.2.1.;.>.2.>.2.2.4. .Q n o.o.o.M o.M b.M o.o.b.o.O.O.O.o.O.O.4.>.>.>.>.9.>.>.1.>.>.>.>.:.2.<.<.<.1.<.2.:.,.;.;.;.| ;.| 2.h j ;.;. .| h W k Q 1.1.) / 1.Q 1.4.4.4.>.>.4.1.1.>.1.4.9.1.>.2.9.1.9.7.b.b.b.b.b.g.g.C.4.b.4.4.) OXNXN ; % % d NXX O & ; g g b g b ( R k ( s CX4 4 N ; % ; N ; 5 % % ; N e.o O $ ; ; : BX% ; N 4 % % e.X O $ $ : : f D h ( ( ( ^ ( ( R ( ( ( ( CXP % % % N 4 NXo O # & ; a NXP d ; N 4 N NXo X O # - ; ; g > f k f f V.E % % P ; % ; N 4 N ; % : NXo O O = = , f f ( ( ( W : ( : : > : : : e.R S % % % % NXX O O $ : > > > ;.> D W W #.D | #.W W ,.e.^ N % % % N NX$ O $ - - , > Z > @.Z D #.@.#.@.@.*.@.#.#.> | #.| | { ;...:.:.3.>.>.X.4.5.5.5.5.5.5.5.5.5.5.5.5.5.",
        "<X<X@X>X-XgX<XgXhX<XhX,X;X<X<X<X<X<X+X>X>X+X$X>X+X+X>X;X;X:X X;X;X>X>X1X>X;X;X;X>X;X>X>X>X=X;X>X;X+X;X+X>X|.|.:X|.|.|. X|.;X;X;X;X;X;X=X;X;X;X>X;X;X;X;X}.}.[. X[.}.|.}.[.|.}.}.}.}.}.}.}.}.}.;X}.|.|.{.{.{.|.{.|.|.{.{.}.}.;XU.&XI.Y.{.U.L.L.L.L.L.U.U.U./.'.U./.U.XX{.XXU.U.+X/.{./.'.{.XXU././././.=XU.}././.I.}././.{././././.XX{.XX/.'.+XU.W.'.L.XX'._ I XX'.Q.L.XXXXI XX_ XXI V XX_ XX_ '.'.'.I I I I I I I U I I U ].U I I [ U _ _ T _ ! _ A _ R R R R R ^ R E E R E E R R R R R R R E k h h h ( ( k W h ( h ( h h h ( > h h h h h h | h h h h > > > r > h | h > h | | | |  . .:.o.X.X.2.,.<.2.,.<.2.2.1.2.2.:.2.>.>.4.2. .2.Q 4.M o.M o.o.M b.o.o. .X.O.o.X.o.O.>.>.>.3.>.>.>.>.>.2.>.2.<.<.<.<.7.1.<.<.<.<.<.:.2.;.;.2.2.h 2.2.;.Q | h W | W W ( Q Q 1./ 1.1.1.>.1.4.2.4.2.2.4.1.2.9.4.<.1.>.9.<.9.<.1.1.b.b.b.b.g.C.) 4.4.) 0.7XNXd N d % % NXO O & @ a s b b b b b s b c BX5 : N % 4 % 5 % N % d % P iXX O & : : S BXN d 4 P ; N iXo O $ & : > > : D f ( E ( f ( f f ( d > CXS 4 T % N 4 NXo X O & ; ; NXT T % % % % iX. O O O @ ; : : : D f f f V.E % % 4 N % % % % d 4 N ; NX. o O $ = : f f k ( : D > ( ( > S : > > e.R % % 4 4 N NXO X O $ : > D D h ;.W ;.D D ;.W ;.#.~ ;.e.] ; 4 S % % NX$ O - - > > { { #.#.#.#.$.#.=.*.*.=.=.*.=.=.<.3.3.X.3.:.3.3.3.=.3.>.>.5.>.5.>.>.5.5.5.5.5.5.5.5.t.",
        ">X<X@X,X<X-XgX<XgX .+.N.n.N.p @X<X+X>X+X@X>X+X+X>X$X>X:X;X;X;X;X;X;X;X>X>X;X1X;X;X;X;X;X;X>X>X;X>X|.;X>X X|.|.|.|.|.|.;X|.|.;X;X;X>X;X;X&X;X;X;X;X;X{.[.[.[.|.|.[.|.|.[.}.}.}.}.}.}.}.}.}.}.}.}.|.{.{.{.{.|.{.|.{.|.|.}.|.}.&X}.U.;XU.L.L.L._.L.L.L.L./.U.U.U./.{.U.U.U.U.U.{.'.{.XX/.{./.{.{.{.'.'.{././.I.U.=XI.+X/.}././.{.{.{././.XX/.+X'././.'.'.XX'.'.'.XXXX'.XX_ L._ '._ '._ XX_ V I '._ I _ I I I I _ I I I _ I I [ I I I I _ _ _ _ E _ E E E R R R _ [ R R R E E E R R R R ( R E R R ( ( ( ( k h h h h h h h h ( h h h > > h h W h h h h | ;.h r h h h | r | | h  . .| |  . . ... .2.1.1.,.2.1.2.,.2.;.2.2.>.2.>. .2.n 4.4.n o.o.M o.M M M M o.O.O.O.O.5.O.>.>.3.1.>.>.>.>.>.>.>.>.>.7.7.7.<.<.<.,.,.<.<.<.1.<.<.2.;.;. .;.;.| h | W  .| h h h Q h W 1.1.Q 1.) 2.1.1.1.2.2.1.>.>.1.>.1.1.1.2.9.8.<.1.1.8.8.4.b.b.C.b.b.b.4.e.~.uXCX] ] ] ] ] VXX X & ; : f b b n b b b b c CXk.] ] ] ] ] ] T E T E T E k.X O & ; : > BXE T T T T E e.O O & - : : > D h ( ( b ( f E R ( T ( f CXE T T T T P iXo + & & ; a V.CXBXCXCXCXBXNX4 T T ( ^ ^ ^ / ) 8./ 2.1.BXCXCXBXBXNXCXVXR E T E E E iXX O O $ = f f f ^ S D ( : ! 8.8.e.e./ / BX] E E T E T CX: : T ! / 8.1.> D > W W ;.;.h D ;.;.~ #.r.VXCXBXCXBXCXCXS ( ! ` ,.7.3.r.w.w.r.r.r.yXyXyXfXyXyXpXyX-.=.3.3.3.3.3.3.=.-.-.-.>.5.5.5.3.5.5.3.3.5.5.5.5.5.5.t.",
        "<X+X+X<X+X>X<X<X' H.B.N.m.SXh.M +X+X+X>X>X+X+X>X+X>X$X;X;X:X;X;X;X;X;X>X;X X;X;X;X1X:X X;X;X;X=X;X}.;X|.}.|.|.|.|.|.|.|.|.;X}.;X;X;X;X;X;X;X&X[.[.{.[.|.|.[.|.[.|.|.|.|.[.[.}.}.}.}.}.U.}.}.}.|.{.+X{.|.{.{.|.{.}.|.{.|.{.|.}.I.;XU.}.L.L.L.L.'.'.L.L.L.U./.L././.U.'.U.{./.{./.U.XX'.XX{.XXXX{.+X'.].{./.;X>XU./.U.U.U./.+X+XU././.'.'.'.XXU.L.'.'.'.'._ Q.I '.I XXI XXXX_ '.'._ Q.'.'.XXI '.I I I _ I I I I I I [ ].U I I I I I I I U _ E R _ E _ R R [ E _ R E R R E E R R R R R g R R E ( k k ( k W ( h h ( h W h ( W h h h h ( h W h W h h h h h h h h h h r h | h  .|  .| h |  .......2.1.1.1.,.1.1.2.2.:.,.>.2.>.>.2.>.o.n 4.n 4.o.) M M M o.o.X.O.X.X.O.O.>.9.>.>.>.9.>.>.>.>.>.>.:.>.<.7.$.7.<.<.<.<.7.1.<.,.2.:.<.;.2.;.W ;.W ;.h | W h h j D ( W W / 1.1.1.1.2./ Q 1.8.1.2.4.1.1.>.9.2.1.<.1.1.<.1.8.1.1.1.1.1.b.b.4.4.b.eX7X~.iXuXiX%XoX' ] CXBXNXCXCXBXCXCXCXCXVXCXCXCXBXV.V.] / ] ^ VX: N T T P d V.O O & ; : W BXd % T S d P V.O O = - : : f > > ( ( ( ( ( f ) E f ( ( BXP d d d d T iXo X # & a a f g a & $ $ O ] NXe.] ] k.e.%Xk.iX] k.k.] BX, : - $ O O ] E 4 d d 4 N NXX O $ @ = f f f D W > W D BXNX] ] ] ] ] ] E d S 5 S T ] ] ] ] ] ] ] VXD D h W ;.W ;.;.;.;.#.#.~ ,.D D D - - $ ! CXk.] %XV.] kXkX] %XV.] e.] ] NXe.e.k.e.KX=.=.-.3.y.3.y.-.-.-.-.-.3.>.>.5.5.3.5.3.3.5.p.3.5.5.5.t.",
        "#X@X@X>X<X#X>X/.C.H.B.B.B.v.h.g.k B ].+X>X+X$X+X>X$X>X;X;X1X;X:X;X;X1X;X:X;X|.;X;X|.|.;X|.|.|.|.;X|.|.}.|.|.|. X|.|.|.;X|.;X|.;X&X}.;X&X>X;X>X;X{.[.].[.[. X[.|.[._.[.{.|.|.}.}.}.}.}.}.}.;X}.Y.{.{.{.|.{.|.{.|.{.{.|.{.|.|.[.;XU.&X;XU.L.L.K.L.L.L.V L.L.L./.{.'.U.U.U.+X'./.'.{.{./.{.XX{.{.XX{.'.XX'.I./.I./.I.>XU.+XU.U./.{.+X'.+X/.XXXX'.XXQ.I XXI '.'.I U U I _ '._ '._ Q.'._ I _ _ I _ I V I I I _ U I I I ].[ I U _ U I _ U I U U _ _ _ _ _ R R R R R R R E R E E [ R b R R R R R R ( ( ( h ( k ( h k h h h h h h h f > h h h h | h | W h h | | h h h | | | h  .h |  .| | :.>... .,.1.1.,.2.2.:.2.,.2.2.>.2.2.>.2.>.>.>.Q n Q o.4.o.M o.o.O...O.X.O.O.O.X.>.>.>.3.>.>.>.>.>.:.2.>. .>.<.7.7.<.<.<.<.<.,.<.7.<.1.<.2.,.;.;.;.h ;.h ;.W | ;.| h W D ~ W 2./ 1./ 4.1.1.~ ,.,.<.1.1.9.>.1.>.1.9.>.9.9.<.9.1.1.4.1.e.1.1.e.4.b.e.7X7X).7XK K F L $ N NXS T ; T T % S T T ; d T T BXg f : - $ $ NXP 4 S 4 d T ] X O - : : > BXP d % T T d NXX O $ : : D D D ( R ( R ^ ^ ^ ( ( ( ( E BXd N N d S d NXX O $ & ; a d f d - : & O ] T d P P d T ; 4 P S T T T BX: = - = O O ] R d N N d d iX. $ - - - E h D ( D ( ~ > iXR P T T T P T 4 N 4 N d % N % T T T T T BXh > > #.D | #.W ;.;.,.,.,.#.#.~ > > : & ! ] T S d d : T ; : T d P T T % d P N ; N VX=.=.=.-.w.y.-.-.-.y.pX-.-.9.5.3.3.5.>.5.3.3.3.3.3.3.5.5.",
        "<X+X#X<X+X<X}.E b.B.B.B.H.H.h.h.O.N ].'.+X+X>X+X;X}.;X:X;X|.|.:X;X;X;X;X X;X;X;X|.;X|.;X;X|.|.|.|.|.|.}.|.|.|.|. X|.;X|.|.;X;X|.|.}.U.;X&X;X;X}.[.{.[.{.[. X[.|._.L.K.'.{.}.}.}.}.}.}.}.U.>X}.{.{.{.+X|.{.{.|.{.{.|.{.{.|.|.|.}.I.;X&XU.L.K.L.L.{.L.L.L.K.L.L.XX{./.'.U.{./.'.+XU.'./.'.{.XX{.XX{.XX'.XXXXU.I./././.=X/./.+X/./././.XX/.U.XXXX'._ '._ I _ '.[ U [ U _ XX'._ XXI '._ XXV '._ V _ _ I _ I I I I _ [ I I I I I U I _ I U I I [ %X_ _ R _ R R R R R R E R R R R R b R R R R R f ( ( ( h ( k ( ( h h h h k h h h h h h > h h W h h h W  .h | h h  .| h | | | |  . .:...:. ...:.,.1.1.,.1.2.,.2.2.;.2.2.>.>.>.>.>. .X.4.o.Q o.n o.o.X.o.O. .O.X.+.X.X.X.X.>.>.>.>.>.>.3.>.5.1.;.:.>.>.<.7.<.,.<.7.<.<.7.<.,.<.,.2.:.:.2.1.;.W | W | h ;.j | W D D ( W ,.1.2.1.1.W / ;.,.,.,.1.8.1.1.1.>.7.1.<.<.9.1.1.1.1.4.1.4.8.1.,.1.rX7X).~.~.~.K H L - S NX% N d N % % % % % % N ; P BXg : : S & $ NX; N % % d % ] O O & : : D BXN : 5 N % % NXO O $ : > > D D ( R ( ^ ^ ( ^ ( ^ ( ^ ( BXN : 5 N % % kXo O O & : f d f : : - & & e.T % % : N 5 % % % % % % % BX- = $ = = O e.E 4 % % N % iXX $ $ - L Z K D ! D W ~ D NXR T N % % % d N ; % 4 N ; % % % % N ; % CX: > > D W ;.;.:.;.;.,.#.#.;.#.~ D > : : ' ] % % % % N 4 % % N 5 % ; N % N 5 : N 5 BX$.*.=.=.-.-.-.-.-.-.-.-.-.-.p.5.3.5.3.3.5.3.3.3.3.3.3.3.",
        "#X<X,X=X>X}.{.k B.B.B.H.SXm.N.v = I jX`.|.;X}.}.}.}.;X;X;X:X;X;X X:X;X;X;X;X[.:X;X|.;X|.;X[.|.;X[.;X}.|.}.|. X|.|.;X}.;X;X|.}.|.}.}.;X;X}.}.;X}.].[.].[.{.[.{.{.K.K.K.K.K.K.[.;X}.}.}.}.}.}.}.|.{.{.{.{.{.|.{.{.|.{.|.|.{.|.{.|.|.}.U.'.L.K.'.L.'.L.L.L.L.L.'.L.U.XX/.'.XX'./.'.'.{.XX{.{.XXXX'.'.{.XX'.'.W./.}.}./.U.}.U.U.}.U.{.{.XX'.XXXX'.XX'._ '.'.'._ '.U I U I '.XXI I I _ '._ I _ '._ '.V I V U I I I I I I I I [ I ].[ I I U I I I I _ R R R [ R R R R E R T R R [ R R R R R b R E j k ( k h h h h h h h h h h h h h h W h h W h | | W W h  .h | h | | | |  .h h ..:.>.:. ...2.1.,.1.,.2.<.2.2.,.;.:.,.,.;.2.:.:.2.>.>. .Q 4.n  .....O.X.X.O.X.X.X.X.X.X.X.>.>.3.>.>.>.>.>.>.>.;.;.:.| $.7.$.7.<.<.<.<.$.,.<.2.<.2.,.,.;.;.;.;.h 2.;.W h ;.;.h ( D D W W / Q / 1./ / W ,.,.,.8.1.<.<.1.2.9.9.<.1.7.9.1.e.1.1.1.1.,.~ ,.' 7X7X7X7XeX4X~.K F L F NXN T d T T d T T T T T T E NX: S - $ : - BXT T T T T T NXO & & : > W BXd T T T T P e.X O $ ; : : > W ( ^ ( ) ( ( ) ( ( ( / ( VXT T T T d P iXX O O $ : : a > S S : - $ NXE T T T T T T T T T T T T BX& - & $ $ $ e.R T T T P d iXO $ $ - Z Z Z %.@.*.D D ( r.[ T d T d T T T T T T d N T T T T d N 4 BX- : > > > D ;.,.,.,.,.$.,.,.,.#.D D > > 8.] T P T T d T T S T T T T T T T T T T S BX#.#.#.=.=.-.-.-.-.y.-.y.-.-.p.3.3.5.5.5.3.p.p.3.p.3.3.p.",
        "<X#X>X+X}.[.].@ z N.B.N.h.N.O.r %XvXkX_.U.}.&X[.}.;X;X:X:X;X;X X;X;X;X|.;X:X|.|.:X[.[.;X|.;X|.}.;X|.|.;X|.|.|.|.|.|.;X|.|.|.;X|.}.;X}.}.}.;X}.{.[.[.[.].[.].{._.K.L.`.K.K.K.'.K.U.}.}.}.;XU.&X}.{.{.{.{.+X{.|.}.{.+X|.|.|.|.{.|.{.{.'.L.L.{.L.'.L.L.'.L.L.'.L.'.U.L.W.{.U./.'.U.{.U.{.W.{.'.{.'.XX+X'.XXXXXX/.+XI.U.U./.}.+X&X+XW.XX/.XX{.XX'._ _ '.'._ I _ ]._ U I I _ _ I I XXI XX'._ V _ V _ _ I I I U '.I _ '.I I '.I I I I I I [ I I I I I _ [ R ' R R R E E E R [ ( R R R R R R R R ( ( k h h h Q k h k h h h h h h h h h W h ( h h W h W | | | W h  .|  .| r > r > >.>.| :...:.1.,.2.,.2.<.2.;.;.,.2.;.,.:.;.,.;.;.;.2...X.o.o.X.X.o.X.X.X.X.X.X.X.X.X.X.o.X.5.>.>.>.>.>.>.>.>.>.:.;.;.| | 7.7.<.<.<.<.<.<.<.,.<.<.:.:.,./ ;.;.Q ;.W ;.h ;.| Q ;.~ W ~ W W D W W W ~ ~ ~ ,.,.,.<.<.,.<.8.<.1.7.1.1.9.<.1.1.1.1.Q / W ,.1.7X#X7X~.eX4X4X~.K K F K NXT T T T T T T T T T T T E iXS - S S : S BXN T T T T T e.X $ $ : > f BXT T T T T T iXo $ & : S ( ( ( / Q ^ ^ ^ ^ ) ^ ( ! ( / BXT T T T T T NXX O $ & S S L S D D : L : NXE T T T T T T T S 4 T T T NX$ $ - - - - e.R T T T d T NXX $ - - Z Z Z %.Z @.*.Z *.iXR T T T N T T N d T T S 4 T T T T T T P BX: - : > D ;.;.;.:.#.,.7.<.<.<.;.;.#.W D q.] T T T T T T T T T T 4 S T T T T T T T BXZ Z #.#.$.=.-.y.-.y.y.-.-.-.-.5.5.3.3.3.3.p.3.3.p.3.3.r.",
        "+X<X}.}.[. X].T [ g.) o.g.g.k [ bXbX{.}.}.&X[.}.[.;X;X;X;X;X;X:X|.:X;X:X;X|.|.;X|.;X|.;X|.;X|.;X|.|.}.}.|.;X[.|.|.|.|.|.;X|.|.|.}.}.}.;X}.}.}.{.[.].[.].[.[.[.K.K.U L._.L._.K.{.L.[.[.U.;X;X;X}.}.{.{.{.{.|.{.{.|.{.|.|.{.|.{.|.{.{.L.{.L.L.'.L.L.K.L.'.'.L.L.'.'.'.L.L.'.{.XX{.XX'.'.'.XX'.XXXX'.'.XXXXXXXX'.U.>XU.=XU./././.U.{.U.'.W.'.XX_ ].XXI _ '._ '.I I I U I I _ I _ '.I I _ I I XX_ '.XXU V _ U [ I I [ I I [ I I I I I I I I I I I I _ _ [ R R R R _ R R R R [ R b R b R ( R R ^ R b ( ( ( k h h h h h h h h k h h h h W h h h | Q | h Q W | | | | h { ..{ { ....:.;.:.2.,.,.1.,.1.2.2.,.2.,.;.,.:.2.,.;.:.,.;.;.;.>.;.:.....X.X.X.O.X.O.X...X.+.X.X.X.X.X.X.>.>.5.>.>.>.3.>.>.:.;.#.;.$.7.6.7.<.<.3.<.<.:.<.,.<.1.;.;.;.2.;.;.W ;.;.;.W W ~ ~ D ! W ~ ~ D ( W W W ,.~ ,.1.6.,.1.8.1.,.7.1.7.<.<.9.1.4.1.~ D ~ ( ~ K 7X7X7X7XuX7XeXeX4X~.K ~.] X . o X . X . X o X . o X NX$ % - : : S BXo o . X o X NXO $ % : S ( BXX o . X o o NXO $ & : : > D Q ^ R ) ) ^ / ^ ( ^ ^ ~ ( CXo o . X o o iXX O $ % - : S D A S : D : NXX X o . X X . X X . X X . iX$ $ $ $ - : iX& . . X o X rXO $ $ L L Z @.@.*.@.*.%.*.aX% X o o X X o X X . X X o . o X o o X . e.O & : > > ;.;.;.,.7.#.7.<.<.<.<.<.<.;.#.iXT o o o X o X o o X . . X X o . X . X X NX- - Z @.$.-.-.-.y.-.y.y.y.-.0X3.3.5.p.X.y.X.r.3.3.r.p.w.",
        ">X}.[.[.[.vXbXbXvXbXkXbXvXvX].].bX].`.}.}.U.}.}.;X;X;X:X;X;X:X;X;X;X;X;X;X;X:X|.;X|.;X;X|.|.|.|.}.|.|.}.|.|.|.|.;X|.|.;X|.}.|.}.}.}.|.}.}.;X{.{.{.].[._.[.{._.K.K.K.K.K.K.'.K._.[.{._.L.}.}.;X}.}.{.{.{.{.{.}.|.|.{.{.{.|.{.{.|.|.{.{.'.L.L.L.K.'.L.'.L.L.'.Q.'.'.L.'.'.{.L.'.U.'.XX'.'.XX'.'.'.'.'.XXXXI XXXXI /.+XU.>X/.}.+X/.W.{.XXXXXX'._ I _ I _ '.'._ '.I [ I U _ _ '._ _ I _ I I I I I _ _ I I I I I I [ [ ].U U [ I I I I I I [ '.I I I I _ R R R R R _ R R [ R R [ ) R R E R R ( R R ( ( R ( R E ( ( h k h h h h W h W W h h h W h | h | Q ;.| h | { { ..r { | | :.>.| | 1.1.1.,.2.1.,.1.;.2.;.,.;.,.;.,.<.;.;.;.;.;.:.:...:.:.X.{ } X.X.X.+...X.X.X.X.>.X.X.X.>.>.>.>.>.>.3.>.>.3.:.| h ,.7.7.<.7.<.<.<.<.<.:.<.<.;.,.;.;.;.,.,.,.~ ,.,.~ ,.~ W ~ ,.W ~ ~ D D D ~ W ,.6.,.6.6.,.,.<.<.<.8.9.<.<.9.<.1.1.8.0.D D D ( 7X7X7X7XuXeX4XeX4X4X7X~.eX%X$ & & & * & & & X * * O & e.& $ : S D D BX& # & & X & NXO $ $ : > W BX* & O & O O NXO O $ : : ( D ( ^ ^ ) ^ ^ ) ^ ^ ^ ( ! ~ BXO * # O O * iXX $ & N - L Z D D D D D : iX% O & * # & * * & $ * O * iXO $ - - $ , iX% O & * & * V.O $ $ - Z K @.K *.%.#.@.*.iXS & O * $ * O * & & * O * & & * & & X & NXO $ , : > #.2.;.<.6.7.#.<.$.<.<.<.<.<.<.r.R * & & & * * * # * # * & & & X & O # O NX- , > } $.=.-.y.-.y.-.y.p.-.-.-.3.y.$.y.$.y.$.p.3.3.3.y.",
        "[.[.*X}. XHXHXbXbXbXbXvXvX X].Y $XY `.U.;X}.}.}.}. X;X;X X;X;X;X;X:X X;X|.;X[.;X;X|.|.|.|.|.|.|.|.|.{.|.}.;X|.|.|.|.;X|.}.|.{.}.|.}.}.}.}.;X{.{._.[.].[._.]._.U K.K.'.K.K.K.K.L.L.[.{.{.Y.{.Y.{.U.|.{.{.{.{.{.{.{.{.{.{.{.{.{.{.{.|.{.{.L._.L.'.L.'.L.'.'.L.L.'.L.XX'./.XX'.XX'.'.'.XX'.'.'.+X'.XX'.XX'.XXI I XX'./.I.U./.I.U./.XXQ.XX'.I I I XXI ].'._ _ I I XX].I I I I I I I _ I V _ I I _ V V V _ I _ I I I I I U I ].I I [ I [ I I _ I _ I _ ] R R _ R _ ] _ R ^ R R R R R R R R ( R ( ( R R ^ R ( ( ( ( E ^ ^ ( ( W ( ( h ( h W h h h W Q h h h > | h | h { | { ....2.:.:.,.1.<.,.2.,.:.2.,.2.1.;.,.2.:.,.;.;.;.;.#.;.;.:.| :...| ..X.X.X.X...} X.X.O.X.X.X.5.X.X.X.X.3.>.3.>.>.>.>.>.>.;.#.<.3.$.<.<.<.<.<.<.<.<.<.:.<.,.,.7.<.6.,.,.,.6.,.,.D W D ~ ~ ~ ,.D W W W ~ D 6.,.,.#.,.6.6.*.,.8.<.1.1.9.1.7.4.8.0.*.0.: A K 7X7XOX7X~.7XeX7XeXoXeX4XtXBXiXiXiXrX%X' ] ' ] ] ' ' ] S $ $ S L D ` q.iXiXiX] ] ] T $ $ : : f W e.BXe.e.] ] ] S O - ; : > D W / ^ Q ^ ) ^ / / / ~ / ~ ! e.NXiXiX] ] ] S X $ $ - L L Z K Z D D S D 6.iXiXe.] ] R ' ^ ' ^ _ ' ] S $ $ - L L : ~ e.iXq.e.e./ S $ $ - L Z Z Z *.@.*.%.%.$.=.iXiXiXiXe.8.] / ' ' ' ^ ] ' R ] ^ ' ! ] E $ = : , > W ;.;.<.$.7.7.7.<.w.<.7.<.<.<.9.fXfXiXtXtXq.8.` 8.] 8.] ` / 8.' ] ] 8.' W - - Z D $.$.y.-.y.-.p.-.-.-.=.-.-.3.$.y.y.y.y.-.y.y.-.y.",
        "[.&X}.[.[.`.].].].].].'.].]. X_.B ].`.}.U.[.}.[.}.:X|.;X;X;X;X X X;X:X;X:X[.;X|.|.;X:X|.|.;X|.|.|.|.|.|.|.|.|. X|.|.|.;X}.|.|.{.}.}.}.;X}.|.{._.{._.[._._._._.K.K.'.K.K.'.K.K.K.L.{.{.{.{.{.Y.{.}.}.}.{.{.{.{.{.XX{.{.{.{.{.{.{.{.{.|.{.'.'.{.L.'.L.'.L.L.'.'.'.L.'.'.'.'.Q.'.XXXXXX'.'.XXXX'.'.'.XXXX_ XX'.XXXX'.XX}.I.&X/./.{.'.XX_ I ]._ _ I I I _ XXI I '._ I I [ I I _ I _ I I XXI I J I I _ V _ U U ].U I [ I [ I U _ U I I I I I I U I _ [ R R _ [ R R R ' R R R R b R R R R R E R R R R ^ R ^ R ( R ^ ( ! ( ! ^ ^ ~ ( ~ ! ( D W W h h | W > h | | h | { ..{ | ..:.2.:.:.:.,.1.1.,.2.,.,.2.2.;.;.;.;.,.;.;.:.;.;.;.#.| ..;.......{ X.X.X...X.....} X.X.X.X.X.>.X.4.X.>.>.X.>.3.>.3.>.>.:.:.3.<.7.<.<.<.$.3.<.<.<.<.<.$.<.6.<.6.6.6.,.,.,.,.D ,.~ ~ W #.~ ~ ~ ~ D ~ #.` ~ ~ ,.,.,.,.6.*.6.<.8.9.<.7.<.<.6.eX*.0.0.K D ).7X7X7XuX7XtX7XtX7XeX7XeX~.4XK ~.H L $ $ * $ * $ $ * & $ $ - - D D K ,.K D S : - $ $ $ - : S ( W W W D D ; & $ $ $ & - S > W ~ / / / / / / Q ~ / / / ~ ~ ! ! D S - $ $ $ $ $ - L L H %.Z K K Z K D D S - - - $ $ $ X O $ $ X $ $ $ $ - L Z Z D D Z D - - $ $ $ - - L Z @.*.#.%.#.%.%.*.%.*.@.Z - - $ $ $ $ $ $ O X $ X X X O $ O O O $ - : h ;.;.>.7.$.7.$.7.7.7.7.w.$.w.7.=.&.&.%.@.Z - - - $ - $ - $ $ $ - $ $ $ - - - - Z #.$.$.p.-.-.p.-.-.y.-.0X0Xy.-.y.$.-.$.-.y.y.-.-.y.",
        "[.[.}.[.}._.$X$XjX].'.].$XjX X].]._.K.[.[.}.}.Y.}.;X:X|.:X;X:X;X;X;X|.;X;X;X|.;X;X[.|.[.|..X|.|.|.|.{.|.|.|.[.[. X|.|.|.[.[.{.|.{.}.}.}.}.{._.{._._.].[.{._.K.K.K.K.K.K.K.K.K.K.'._.Y.[.{.{.{.}.L.L.B {.+X'.{.{.{.{.{.{.{.{.{.|.{.|.{.{.{.L.L.'.L.'.L.I L.L.'.L.'.'.I '.'.'.'.'.'.'.'.XX'.{.XX].'.XXXX'._ _ XXI _ XXQ./.&X+XI.XX_ _ _ I [ I I I I _ I I XXI _ XX].I I I I _ '.I I J I _ XX_ V J I _ U U U [ I [ I I I _ U I _ I I I [ XXI _ [ [ R R R ^ _ _ ' R R _ R _ R R R R R g R R E ( R ( R ( ( R ! ( ^ ^ ( ( E ~ ( ! ~ ! ! W W W h D h > h { { | > { | > { > { { ;.;.;.,.;.;.1.,.2.,.,.2.,.;.,.;.;.;.,.:.;.;.#.:.| ;.;.:...:.....$.X.X.X.X.} ......X.X.X.X.X.X.5.X.>.X.>.3.>.>.>.>.>.:.:.<.3.3.w.<.$.3.7.<.$.3.$.$.3.<.<.<.6.7.6.6.6.6.~ ,.6.~ ,.~ ~ *.6.,.,.~ ,.6.~ #.,.6.,.6.6.6.6.<.,.6.<.,.7.1.8.7.*.*.*.*.*.eX4X7X7X~.7X~.7X7XtX7XtXuXeX4XeX4X~.*.H G L L L - $ $ $ $ $ - N S S A D ~ *.,.D D S : - - $ ; : f W ~ ;.W ! D : : - & & - : : D W D K ,.` / ) / 8.K ~ K ~ ~ ~ ~ ! D D S S $ N $ $ - : L Z Z ~.Z %.K %.Z D D > L - $ $ $ $ $ $ $ $ $ $ $ $ L L Z K Z Z Z L - - - - $ - - Z D D *.%.*.$.*.#.*.*.%.%.Z Z L - - $ $ $ $ $ $ $ $ $ $ O $ - & = = : > > 2.:.<.*.q.=.5Xw.5Xw.5Xw.5X5X=.0X0X5X%.%.Z Z L L - - - - - , - - - , - - - Z , > #.$.w.} -.-.-.y.y.y.y.=.-.-.-.y.-.y.-.-.-.y.-.y.-.",
        "}.[.}.[.[._.vXkXvXB ]. X$X$X X].].`.K.}.[.U.U.[.;X;X:X|.;X;X;X:X:X|.;X;X;X;X:X}.:X|.|.|.|.|.|.|.|.|.[.|.|.{.].].[..X|.{._.[.].[.{.}.|.}.}.[._._.B B {.]._.`.`.K.K.'.K.K.'.K.K.U K.'.U.{.Y._.K.V B B V _.{.{.].{.{.{.{.XX{.+X{.{.{.{.{.}.{.L.'.'._.L.L.'.L.L.'.I '.'.I '.'.I '.V I L.V I U U U U U U U N V P N I U _ L.XX/./.{._ XX_ _ I _ I I [ _ ]._ _ I _ _ V _ I I I U I I _ U U J I U _ _ U N N U U [ ].U U I I I I I I I '.I [ _ I _ _ R R R R _ R R R ' R R _ R R ' _ [ R R E R E R ( R R R ! E ( ^ ( ^ ( ^ E ( ! ! ! ~ ^ ~ ! ~ W ;.> W > > | ;.{ | { h { ..{ { { | 2.:.,.#.;.;.,.2.,.2.,.~ #.~ ;.W ;.;.;.,.#.#.;.;.;...| | :...X.X.X.X.} ..X.} ..{ ..X.X.3.X.X.X.>.X.>.>.:.>.3.:.<.$.<.<.7.3.3.7.7.$.7.$.w.<.7.$.3.3.3.$.3.6.6.6.,.6.*.6.6.~ ~ ,.~ ~ *.~ ,.6.~ #.` ,.6.~ ,.6.6.,.6.,.6.6.#.7.<.7.7.*.7.*.*.*.4X*.4X).4X7X7X~.~.4XtX4XtXuX4XtXuX4XeX~.K K H L L L L N L L - L - S L D K D *.6.6.#.D D S : L S - D D W W / / W ( > : - : & : : D D ! D ` K K 6.6./ ` K *.~ K D D D ~ D S : - - : S S L L Z Z K Z %.K %.K K D D D L L - - - $ $ - - - - - L L L L Z Z K %.Z Z > Z - - - - L Z Z *.#.*.*.$.$.*.*.%.%.%.Z Z Z L - - L - - - - - - $ - - - - - , : D D D $.=.2X5XyX5X5Xw.yX5Xw.5X=.yX0X0X3X5X&.=.%.Z Z Z Z L L Z , Z , Z > , { > > > @.#.$.$.$.y.-.y.y.y.y.y.y.-.-.-.-.-.-.-.-.-.y.-.-.-.-.",
        "[.*X[.}.|.{.bXbXkX].`.].$X1X X]._.`.K.}.[.[.[.{.;X:X;X:X:X|.;X|.|.:X;X X;X|.[.;X|.|.|.|.|.|.|.|.[.|.{.|.|.{.[.{.{.|.]._.[.]._._._._.{.[.}._._._.B B _.[._.`.K.`.`.K._.V K.K.K.K.K._._.{._.'.B B B C U '.{.{.{.{.{.{.{.{.{.'.{.{.{.{.{.'.{.'.L.L.L.'.L.'.V U I U I V U V U U U I U I I U V U V V N N U N N N N U P U J '.'./.XX_ XX_ I _ I XX'.I '._ _ '._ '.'._ _ I XX_ _ I I I _ U U U U U U I U N P U I [ U [ U [ I [ [ U I [ I I I I I _ R R _ R [ ' _ R R _ R _ ' _ ' R R _ ( R ( R E E R ^ R R ( E ( ^ ^ ^ ! ~ ( ~ ~ ^ ! ~ ! ~ ! D ;.W > > ;.> > | > | > | > { | { ,.;.#.,.;.;.:.;.;.,.;./ 1.;.;.;.#.W W #.;.;.:.;.{ :...;.{ ....:.X.} X.X.........X.X.3.X.X.X.>.>.X.>.X.X.:.3.<.<.<.3.<.$.$.3.<.3.3.7.3.<.$.$.7.3.$.$.<.3.$.3.6.6.6.6.,.6.6.6.,.,.6.*.,.6.*.6.6.,.6.~ ` #.,.,.,.6.6.6.6.7.0.*.*.*.7.*.7.*.*.*.4X' 4X).7X~.7X7X7XuX7XuX4X4XtX7XeX4XeX4X~.4XK K K L F L H Z A L K D K D 6.*.6.6.6.6.6.D D S L L L L K D ~ ,.1.~ ~ D S > : S D D D ~ ~ ` ` *.6.*.K *.6.*.*.D ,.*.K *.D K K Z S L S L L Z L K K %.%.K *.Z %.Z K Z D Z L L - L - L L L L L L L L Z Z %.%.%.K %.Z Z D L Z L D Z D *.*.*.$.*.*.%.*.=.%.=.=.*.%.Z Z Z Z L L Z Z L L L L - : L Z Z Z Z Z Z %.%.=.5X5X5X5X5Xw.5Xw.5X5XyXw.0X9X0X0X&.&.&.%.%.Z #.#.#.@.#.#.#.#.#.} } #.@.#.$.$.$.$.y.y.y.y.y.y.y.y.y.-.-.-.-.-.-.-.-.-.-.y.-.-.-.",
        "[.}.}.}.}.[.bXbXbX$X X].vXkX X]._.`.{.[.K.K.Y.|.|.;X|.|.[.;X:X X|.|.;X[.|.;X;X|.|.|.|._.[.|.[.|.|.[.[.|.[.|.{._.[.].[.[.[.[.`.`._.`._._._._._._.`.V _._._.`.K.K.K.K.`.`.K.K.K.K.K.V K.'._.B '.'.'._._._._.{.{.{.{.].{.{.{.{.{.{.{.{.{._.L.'.'.L.L.L.V V V I V '.U '.V '.V '.V V U V V U U V U P N Y N U Y N N U U P I _ '._ _ _ _ _ _ XXI _ _ I I _ '._ _ _ I I I _ '.V U _ U _ U _ U U _ _ U P U U P _ U I ].[ ]._ I U _ _ _ _ I I XX_ [ _ _ R R R ' R R R R ' R ' R _ _ _ R ' R R R ( ^ R R E E R E ^ ( ~ ( ^ ~ ~ ~ ~ ( ~ ~ ! ~ ^ ~ ( W > ;.| | { | { { { | { > ..{ { ,.;.,.;.<.;.;.#.:.;.,.;.;.,.;.W W W D ;.#.W { | #.;.;.....X.X.X.X.} X.{ } X...{ } ..X.$.>.3.:.X.:.<.$.*.$.,.<.<.<.<.<.<.<.<.3.3.=.w.$.$.<.w.$.3.7.$.3.$.3.$.3.$.6.,.6.,.6.,.6.6.6.6.*.,.*.~ *.6.*.~ ,.,.6.,.6.,.*.,.*.*.4X=.=.0.*.7.7.*.K *.*.4X7X7X7X7XuX7X~.7XtX7X7XeX4X4XuXtXeXeX4X~.K 4XK K K ~.K K *.K *.K *.` 7.7.7.0.*.0.*.~ D K Z K K #.K %.*.*.*.6.~ W ! D D D D D D ~ 6.K 6.` K *.*.K *.*.*.K ~ K #.K K D K K Z K L L Z K Z %.Z %.%.K %.%.K @.Z K Z D D Z Z L L L Z L Z L L Z Z Z Z K Z %.Z %.%.K Z D D Z D Z K #.*.$.=.*.q.*.*.%.=.%.%.%.%.%.%.%.Z @.*.Z Z Z Z D D Z Z @.K #.%.Z *.Z %.*.2X5XyX5X5X5X5X5XyX5X5XpX5X0X9X0X0X5X5X5X5X&.&.=.$.$.$.$.$.$.$.$.} $.$.$.$.$.$.$.y.y.y.y.y.y.y.y.y.y.0X-.-.-.-.-.-.-.-.-.-.-.-.-.",
        ";X[.[.*X[.{.JXbXbX X].$XkXvXjX'.B `.[.Y.[.}.[.[.:X[.|.|.|.{.;X;X:X|.;X:X:X[.|.;X|.;X X[.{.|.{.|.[.{.{.[.{.{.[.[._.[._._._.[._..X_.[._._._._._._._._._..X`._.`.U `._.K._.`.K.'.K.K._.K.K.'.K._._._._.'._._.'.{.{.{.{.{.{.{.{.{.{.{.L.L.'.{.L.L.K.V '.I V U V I U U '.U U I U U U I U U U V U V U V N N N N P N N N N _ '.XX'._ _ _ I _ I _ U _ _ U S _ I XXI I _ _ I _ _ _ U _ U _ U _ U U U U _ U I [ I U [ U I R R _ [ _ _ _ _ _ [ _ R ^ ' ! R R R [ R R R _ R _ ] _ ' [ ' ' _ _ R R E ! ( R ! ^ ! ! ^ / ~ ! ~ ~ W ! ~ ~ ~ ! ~ ~ ~ ! ~ W W > h > ;.> | h h { | { | { | ,.,.;.:.;.;.;.;.;.#.| ;.W ;.;.;.W D h #.h #.;.#.| { ;.{ } X.X.X.X.X.X.X.......{ ....{ X.X.:.<.*.$.$.6.$.$.$.<.<.<.$.<.3.<.$.<.<.7.<.<.w.3.$.7.$.3.3.w.$.$.3.$.3.<.7.<.6.,.6.6.*.*.~ *.6.6.6.,.6.6.,.,.6.~ ,.,.6.*.=.=.*.*.*.*.=.=.q.*.*.*.4X*.7X7X7X).7X7X~.4X7X7XtXtX7XuXeXtX4X4XeX4X4X~.4X4X4X2X4X2X4X4X2X*.*.0.*.*.q.*.*.7.6.7.*.*.*.K %.K *.*.*.*.*.*.*.*.*.#.W D D ~ #.6.,.6.6.6.*.*.0.` *.K K *.*.*.K *.K *.K *.D K Z K D Z K K K *.K *.%.K *.*.K Z *.%.K Z D L Z Z Z Z 2X2XZ 2XZ K %.%.%.2X%.2X%.%.%.%.%.D *.*.#.%.*.=.*.*.*.=.=.=.=.&.=.=.%.=.*.%.%.*.%.%.%.%.*.Z #.*.%.%.&.&.%.%.%.%.%.=.5X=.5X5X5X5XfX5XpX5XpX5X5X0X0X0X0X0X0X0X5X5X5X5X5X=.=.=.3.$.y.$.$.y.$.$.w.y.$.y.y.y.y.-.p.y.-.p.-.y.y.-.-.-.-.-.-.-.-.-.-.-.-.-.wX",
        "[.*X[.}.}.[.kX X].].].].].].`._._.`.[.[.[.[.[.[.|.:X|.;X:X{.|.;X:X[.;X X;X}.;X;X|.|.|.[.[.}.}.|.{.[.[.[.[.[.[._.[._..X`.[.`.`.`.`..X`.[._._._._._._.`._._.K.`.`._._.`.`.`._.'.K.`.K.'.'._._._.'._.'._._.'._.{.{.{.{.{.'.{.{.'.{.'.{.'.U.L.L.L.L.L.K.'.V V U V '.I U '.I I V U V V V U I U V U N N P U N N Y P U _ P P N _ V _ U _ _ J U _ U R U _ N _ _ _ I '._ V _ I XX_ _ I _ U U _ I U _ _ P _ U I I [ I [ I _ R ' _ _ R R _ _ _ R ' ! ' R ^ ' R R R ' ' R _ ' R R R ' _ _ ' ' E ( ! ! R ! R R ! ( ~ ! ^ ! ~ ~ ~ ( ~ ~ ~ ~ ! ! ~ ! ( ~ > h h > | > | | | { | r { ..W ,.;.,.;.;.;.;.;.;.#.W #.,.W ;.W D W { h #.| | #.{ | { ..X.X.X.} X.X...X...........{ X.X.{ $.*.$.<.$.6.7.*.7.<.<.$.3.$.7.3.$.3.3.7.$.$.7.<.3.$.3.w.3.$.3.3.$.3.3.7.,.6.,.,.6.~ *.,.*.6.6.*.~ 6.*.6.*.6.,.6.6.*.=.=.2X*.4X=.4X4X*.7.=.*.*.*.4X4X7X7X).7X7X7XuX4X~.7XeX7XtXyX4XtX4XuX7X4XeX7X4X4X5X4X4XyX5X4X4X4Xq.tX*.q.tXyX0.*.0.4Xw.*.*.4X*.*.K %.*.*.*.*.*.*.*.*.K D #.~ *.6.6.0.*.q.*.0.4X*.*.4X*.4X*.*.*.*.*.%.*.*.K *.%.%.K 2X*.2XK %.K *.%.*.*.*.*.*.*.K %.%.Z %.%.%.Z %.%.2XZ 2XZ *.%.%.%.%.%.%.&.&.%.%.%.*.*.#.*.$.*.*.=.q.=.=.*.5X&.&.=.5X=.&.=.=.4X=.&.*.=.%.=.*.=.%.=.&.=.&.=.&.=.&.=.3X3X5X5X5XyX0X5XyX5XyX5XyXpX0XwX0X0X0X0X0X5X0X8XpX8Xw.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.p.-.-.-.pXwX-.-.-.-.-.wX-.-.-.-.-.-.-.",
        ";X[.*X[.[.}.&X}.|.|.Y.;XU.[.}.U.}.[.[.K.[.[.[.}.|.;X:X|.{.|.{.:X X|.;X|.|.[.;X;X;X[.|._.`.K._.[._.[.K.K.K.[._.[.`.`.B `.`.`.`.B `.`.`.`.K.K.B _._.`._.B V `.`._.B B B V K.B `.K._.V K._.V V _._.'.`.].B B '.].{.{.{.{.{.{.{.U.{.{.L.L.L.'.L.'.U I U V U U '.U U I V U V I I U I U U U V V U N U N N N N N N N N _ N _ N J _ _ _ _ _ _ _ _ _ P _ P _ _ I _ _ J I _ I _ _ U J J U J _ U _ _ I I U U _ [ U [ U I I _ ' _ R ' _ _ _ _ ' R ^ R ' ! ' ! ! ' R [ R ' R _ R ' _ R R ' _ ! A ! ! ! E R ^ R ! ~ ^ ! ~ W / ~ ( ~ ~ ~ ! ~ W ! ~ ~ ~ ~ W h #.| { | { > { { { { { { | ,.,.;.;.<.3.>.<.<.;.;.;.#.;.;.D W #.;.#.;.#.{ ;.#.> #...} X.X.X.X.} X.X.} ....} { X.X.#.X.X.<.#.*.7.$.#.<.#.$.$.<.<.$.<.<.<.$.7.3.3.w.$.$.w.<.$.$.3.3.$.$.3.w.$.0.7.6.6.6.6.6.6.6.` ~ *.6.6.*.6.*.0.*.*.*.3X5X2X2X*.5X=.*.=.=.*.=.0.7.2X*.*.4X7X7X7X7X~.7X4X7X7X4XtXtX7X7XuX7XuX4XtX4X7XyX7X8XuX5X7X8XuX5X5X4X5XyXyX4X=.q.4XyXyXq.4X4X4X4X2X2X*.*.4X4X%.4X4X=.4X4X4XK Z Z *.*.*.0.0.*.*.*.*.*.4X4X*.%.4X*.*.*.*.4X4X2X*.4X*.K *.K %.*.*.%.2X4X%.2XK *.*.%.*.%.%.%.K %.K *.%.*.*.%.2X2X2X%.*.*.%.%.*.&.*.%.&.&.2X%.=.=.*.*.=.*.=.0.=.=.=.5X=.=.5X&.5X=.5X&.=.5X=.&.5X5X&.&.&.=.3X=.0X&.&.=.&.&.&.&.=.5X5X0XyX8X0X0XpX8XfX0X5X0X0X9X0X8XwX0X0X0X8X0X6Xy.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.-.0XwXwXwXwXwXwXwX-.wX-.-.wX-.-.-.-.wX-.-.-.",
        "[.}.[.;X;X[.;X}.|.L.}.}.}.Y.[.[.[.[.[.Y.[.[.[.`.[.|.:X;X X{.|.:X:X|.;X;X|.[.}.[.[.K._.`.[.Y.[.K.[.K.[.`._.`.[.`.B `.`.`.`.`.`.`.`.B `.B `.`.`.K._.B B `.`.B `.B _.Y `.B `.B B `.`.B K._._.B B _.`.B B '.'.U _.{.+X{.{.{.{.{.{.{.'.L.L.L.L.V V _.V '.U V '.V U K.U '.'.V U U V U V U V U V U V N U N Y N N Y N U U N U U U _ _ _ J U _ _ _ _ _ _ _ _ I I '._ I _ XX_ _ _ I J _ _ V _ _ N U _ U _ _ N _ _ I [ I [ R _ ' _ _ _ _ _ _ ! ' R ! ! R ! ! R ' ! ' R R _ _ ' _ ! _ ' _ ! ! D ! ! ! ! R ! ! ! ~ ~ ~ ~ ~ ~ ~ / ~ ~ ~ ~ ~ ! ~ ! ~ ! ~ W > W | > { h h { r | { | { ,.,.,.;.,.3.>.>.3.>.3.<.>.>.<.:.:.;.;.;.:.;.| #.{ :.{ ..:.X.X...X.#.X.X.} X.{ X...X.#.X.} X.X...#.$.#.*.$.$.#.$.6.7.$.<.w.3.$.$.<.<.$.w.3.$.w.w.$.3.$.w.3.$.3.$.0.q.*.q.0.*.*.0.6.6.6.,.6.6.6.6.*.6.*.2X5X3X2X2X5X*.5X5X*.4X=.*.=.*.*.w.4X2X7X7X7X4X7X7X7X7X7X7X~.4XuX7XtXuXyX7XyXyX7XuX5X7X8XuX5XuX8XyX8XuX8XyX5XyX*.yXyX5Xq.4XyX5X4X4X2X4X4X~.K 4X*.4X*.*.2X2X*.=.4X*.K K %.*.2X4X7.7.*.4X*.4X%.*.2X4X*.*.*.*.*.%.2X4X&.%.%.*.2X2X2X*.%.4X*.2X%.%.*.4X*.4X*.%.2X4X%.%.%.%.%.%.2X2X%.2X%.*.%.%.*.5X%.2X&.*.&.%.2X%.4X=.w.7.7.*.q.w.7.=.&.=.=.5X=.=.=.0X=.5X5X3X&.-.&.5X=.&.-.3X-.5X0X3X0X0X3X&.&.0X5X5XyX5X8X5X0X8XfXyX0X5X0X0X0X0XwX0X0XwX0X0XwX0X8XpXy.y.y.y.y.y.y.-.-.y.p.y.-.0X-.9X9XwXwXwXwXwXwXwXwXwX-.-.-.-.-.pX-.-.-.-.-.-.-.",
        "}.}.;X[.[.;X[.;X{.}.[.}.[.[.[.[.[.K.[.[.[.[.[.[.[.[.[.[.[._.[.|.|.|.:X[.[._.[.[.[.K.[.`.`.[.[.K._.K.K.K.K.K._.[.`.`.`.`.`.`.`.`.`.B `.B `.B `.B `.B `.`.`.B K.K.`._._.B `.B V `._.B K.K.'.K.K.K.`.U '.`._.Y '.'.{.{.{.{.{.'.'.L.L.L.K.V V '.V V U V V U V U I I I I U I I K.U I U U V U U U N Y N P N N N N N P N _ J P P _ _ J _ _ _ J _ _ P _ _ N _ J _ _ J _ I _ V _ _ _ _ N _ _ J U J J _ U U _ U _ I _ I _ _ ! _ R R _ R ' ^ R ! ' ! R ' ' R ' R ' ^ ^ _ ' R R ' _ R ' ' ~ D ! D ! ' ! ! ! ! ! ! ~ ~ ~ ~ / ~ ! ~ ~ ~ / ~ ^ ! ~ ~ ~ ~ W ;.{ | ;.h | { | { { h #.h ,.,.;.,.<.1.>.<.>.>.<.>.:.:.:.,.:.:.;.:.;.;.#.| #.:.>.>.:.X.X.} X.X.} X.:.#.X.X.} } X...X...{ X.<.6.$.,.,.$.7.$.<.$.<.3.$.$.w.<.$.3.3.$.3.<.$.3.3.$.3.$.$.3.3.*.0.*.q.*.4X0.4X*.4X4X*.0.*.*.6.*.6.*.3X3X2X5X5X2X=.5X5X*.2X=.4Xw.4X*.w.*.2X2X7X7X7X7X7X7X7X7X7X7X7X7X7XtX7XtX7X4XuX7X7XyX7XyX7X5XuX8X5X8X8X5X8XyX8X5X4X4X4XyX5Xw.5Xw.4X2X4X4X%.2X%.%.2X2X4X4X*.*.4X4X4X2X@.Z *.*.5X2X4X4X2X4X4X*.4X2X4X%.4X*.*.2X4X%.4X%.4X2X4X2X*.2X*.2X4X%.2X2X4X2X2X2X%.%.%.%.%.%.%.*.*.%.%.*.2X=.%.2X%.=.2X*.2X=.2X*.&.2X2X&.5X&.&.&.&.=.=.w.=.=.4X5X5X5X3X&.5X5X5X&.5X5X&.-.3X3X0X5X3X3X-.5X&.0X&.-.9X9X&.&.9X3X5X0X5X5X8XfX8XyX5X0XyX0X0X0XwX0X0X6X0X6X0X6X0X0X0X0Xy.y.y.y.y.y.-.-.-.9X-.wX9XwXwXwXwXwXwXwXwXwXwXwXwXwXwXpX-.-.wX-.-.-.-.-.-.-.-.",
        "[.;X[.;X[.:X[.[.[.[.[.[.[.[.[.[.[.[.[.K.[.[..X[.[.`.[.[.[.`.[.{.|.|.|.[.[.`.[.[.`.`.[.K.[.[.[.K.`.K.`.`.[.`.[.`.`.`.`.[.`.B B .X`.B `.B `.`.K.`.`.B `.`.`.Y `.`.`.`.`.B _.B `.`.B B `.'.`.B K.U '.B U _._.U Y '.'.{.{.{.{.'.V L.L.K.V V V '.V V '.V U V Y U U U U V U U V U U U V I U V V U N P N P N N V P P N I N _ N N _ _ _ _ _ _ J _ _ S E _ N S _ I _ _ _ _ _ _ _ _ J _ J _ J _ N _ J J J J _ _ U U _ _ _ ' _ R _ R _ _ ' ' ' ! _ R ! ! ! ! R R ' ! ! _ ' ' R ' R ! _ ! D ` K ~ ~ ~ D ' ! ! ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ! ~ ~ ~ ~ ~ ~ ~ ~ ~ W h ;.h | | { h W D ;.W #.~ ;.~ ;.;.>.3.>.<.>.>.>.<.:.<.:.;.{ :.:.;.:.#.| ;.:.>.>.:.{ X.X...{ X.X.#.X.:.{ X.$...X...} X.:.#.7.#.7.$.<.$.#.#.7.7.<.3.<.$.3.$.<.3.w.$.$.3.w.$.3.$.$.3.$.q.q.*.q.0.4X*.K 4XeX4X0.4X4X*.eX4X*.0.*.4X3X3X3X2X5X5X2X=.4X=.*.=.=.*.*.4X2X2X2X7X2X7X4X7X7X7X7X7X7X7X7XtXuX7XuX4XyX7X8X7X8XtX8X8XuXtX8X8X7X5X8X8X5X8X8X4X5X5X5XyX5Xw.4X2X2X2X2X2X2X2X2X7X2X7X2X4X4X2X4X4X=.*.Z *.5X5X3X8X2X2X2X7X2X4X2X2X*.2X4X4X*.5X2X4X2X2X2X=.4X2X4X2X4X2X2X4X2X2X2X2X2X2XK %.2XZ %.%.Z 2X2X%.%.&.*.&.4X*.4X%.&.&.*.&.=.2X2X&.5X&.&.&.&.&.&.=.w.w.=.=.5X3X5X-.=.0X5X-.5X0X0X5X0X5X&.0X-.9X&.-.-.9X0X-.9X9X9X9X&.9X9X9X5X5X5XyX0X8XfX5X5X8X0X0X0X9X0X0X0X0X0X0XdX8X0X6X5Xy.-.-.&.0X0X0XwX0XwX0XwX9XwXwXqXwXqXwXqXqXwXwXwXwXwXwXwX0X-.-.-.0X-.-.-.-.-.-.",
        "[.[.*X[.[.[.*X[.Y.[.Y.Y.[.[.Y.`.Y.[.[.[.[.[.[.[.[.[.`.[.[._.`._..X|. X[.[.`.K.K.[.Y.[.K.K.K.K.[.K.[.Y.K.K.`.[.`.B `.`.`.`.`.B B `.`.`.`.`.B B `.`.B `.`.`.B `.`.B B B B `._.V B K.B K.B B V V `.Y U `.].].B '._.U {.{.{.L.L.K.L.V L.L.V B U V I U V B N V U U V U U U '.'.U I V U V U U U U N N V N N Y P N N U U _ N _ _ _ _ _ _ _ _ _ _ _ _ U _ _ U A A U U J N _ J _ _ P N _ J U J _ N _ U J U N J _ _ _ _ _ R R _ ' ' _ ^ R R R ' ! ! ' ' _ R ' ' R R ' ' _ _ F _ ' ! ' ~ ! D ! D ! ! ~ ` ! ` ~ ! ~ ~ / ~ ~ ~ / ~ ~ ~ ~ ~ ~ ~ ~ ~ ^ ~ ( D | > h D ;.;.~ ,.W #.~ D W W #.#.;.>.<.<.>.>.<.:.<.:.;.:.:.:.#.{ :.:.#.:.{ :.>.:.X.{ { X.} X.} X.X.#.X.X.{ } X.{ X.X.#.*.$.*.<.6.#.$.7.7.$.#.$.$.<.3.<.3.$.3.$.$.3.3.$.$.3.$.3.3.3.w.*.0.0.*.4X4X0.4X*.4X*.4X*.*.4X4X4X4X4X4X4X3X5X8X3X3X2X3X4X2X=.4X4X4X2X2X2X2X2X7X7X7X7X7X7X7X7X7X7X7X8X4X7X4XtX7XyX4XuXuXyX8X7XuXyX5X8X5XuX5X8X8XuX7X8X8X7X4X*.yX4XyX4X*.2X~.2X4X2X~.~.2X2X2X2X5X2X4X5X5X4X5X4XK 2X3X5X8X3X2X8X2X2X2X2X2X4X4X2X4X=.4X2X2X5X4X=.2X4X5X4X5X%.2X8X2X2X2X2X8X2X2X5X3X2X2X2X2X%.2X2X2X2X5X%.5X&.2X=.%.&.*.5X&.5X&.2X2X3X2X2X3X&.3X3X3X3X3X=.5X3X-.=.&.3X3X&.3X3X&.&.&.=.&.&.&.&.&.9X3X3X&.&.&.9X9X9X9X-.9X&.9X0X0X6X8X0X8XfX5X0X5XfX0X0XwX0X0XqX0X0X8X0X6X0X0X0XwX0X-.9X0XwXwX0X0XwX0XwX0XwX0XwXwXqXwXqXqXqXqXwXwXwXqXdXpX-.0X-.-.-.wX-.pX-.pX-.",
        "[.[.[.:X[.[.[.[.[.[.[.[.[.[.[.Y.[.[.[.[.[.[.[.[.[.[.[.[.]._._._.].[.[.[.K.[.Y.K.K.Y.K.[.K.[.[.`.[.[.[.K.K.`.`.`.`.`.`.`.`.`.B `.Y `.`.`.`.`.`.`.`.`.`.`.`._.`.`._.K.Y B B K.K.B B K.B _.K.K.`.V _._.Y _.`.U '.U Y {._.'.'.U K.L.V L.V V V B V V V U U V V Y U V U V N Y B U V I V U V U U V N V P N P N N N U N N _ U N _ _ _ _ _ _ _ _ _ _ _ _ A _ _ _ _ _ _ _ _ _ _ A _ J U _ U _ U J J J J N J J J U _ _ _ _ _ ! ! _ _ ! _ ! _ ! R ! _ ! _ ! ! _ ! ' R ' ' _ F ' ! ' ' ! ~ D ! K ~ ` ~ K ~ K ` D ~ ! ~ ~ ~ ~ ~ ( ^ ~ ~ ~ ~ ( ~ ~ ~ ~ ~ ~ W W W W ~ W ~ ~ W W W ~ ;.W W #.W #.<.>.<.:.<.:.<.;.:.;.:.;...#.:.{ ;.| :.#.:.X.>.:.X.{ X.X.X.{ { X.X.#.} X.X...} X.X.*.<.,.6.#.$.6.,.#.,.*.$.$.#.$.$.3.$.3.3.3.<.w.w.3.3.$.3.y.$.*.0.*.tX*.*.yX*.4X*.4X*.4XK *.4X4X*.4X4X4X4X4X2X5X3X2X3X5X2X2X4X4X2X2X2X2X2X2X2X7X7X7X7X7X2X7X7X7X7X8X7X7X4XtX7XtXuX4X7X4X7X7XtX8X7X8XuXyX8XuX8X7X4X8X8X8X8X8X8X2XK %.2X4X2X~.2X~.2X4X2X2X~.2X2X8X2X8X5X4X4X8X8X8X&.5X8X6X8X3X8X3X2X8X2X2X2X2X4X4X4X5X=.4X2X4X2X2X4X5X2X2X2X2X2X2X3X2X2X3X2X3X3X2X3X2X2X2X2X2X3X2X2X&.2X&.&.3X&.*.2X2X2X2X2X2X3X&.3X3X3X3X&.3X3X&.3X&.&.5X5X3X3X9X5X0X-.3X&.&.=.&.&.%.%.&.%.&.&.&.&.&.%.&.&.&.9X9X9X9X-.9X9X9X3X0X5X5X5X8X8X5X8X0X0X9X0X0X0X9X9X0XwX0X0X0X0X8X0X0X0X3X3X0XwXwXwX0XwXwXwX0X9XwXqXqXqXqXqXqXqXqXqXqXwX-.-.0X-.-.-.-.-.-.-.-.-.0X",
        "[.:X[.*X[.:X[.:X*X[.*X[.[.[.[.[.[.:X[.[.[..X[.[..X[..X[.[.[._._._._._.[.[.`.`.[.[.[.`.[.[.`.Y.`.[.`.[.`.[.[.[.`.`.`.`.`..XB `.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`.`._._._.B Y `.K.`._.K.'._._.K._._.`.U '._.U `.Y U Y '.U '.U `.I K.L.K.V '.V V V V V B B U U V U P P V U V P U N Y U I V U U N P P N Y N N N Y N N P J U N T _ E _ _ _ _ _ _ _ J _ _ N J _ A N _ _ _ J U _ J _ _ J J J N _ _ V _ A N _ J J N J _ _ _ _ R _ ' R ' R ~ R ' ! ! ! ! ' ! ' ! ! ! R ' ' ' ' K ! K D K ~ D ` ! D ~ K ~ ! ~ ' ~ ~ ! ! ~ ~ ~ ~ ~ ~ ~ ~ / ~ ~ ^ ~ ~ ~ ~ ~ W W ( W W W #.W ,.W W ~ #.;.D ;.W 2.:.>.2.>.:.:.:.;.#.;.#.#.;...#.#...#...:.:.:.X.{ X.{ X.X.X.X.} { X.X.{ ..X.X.{ $.#.<.$.$.<.*.#.*.#.#.#.#.<.7.$.$.<.<.$.$.$.3.$.$.3.$.3.$.3.$.7.*.tX*.tXyX4X*.0.K K 4XK 4X4X4X0.4X4X*.4X4X4X4X3X5X2X3X2X5X3X3X2X&.2X2X2X4X2X2X7X8X7X7X8X7X7X8X7X7X7X7X7X7XuX4X7X4XtXuX4XyXtX8XuXtX8X8X8XyX8X8X5X5X7X8X5X8X7X8X8X2XK K 2X%.2X2X~.~.2X7X2X2X2X8X2X8X8X2X8X5X7X8X8X6X6X6X8X6X6X8X2X8X2X8X2X8X4X2X4X4X4X2X5X5X5X5X5X5X2X2X2X5X5X3X5X8X5X8X2X3X8X8X3X8X3X3X2X2X3X3X2X3X&.2X3X2X2X3X2X2X2X2X3X2X3X3X3X3X3X3X3X3X3X3X3X&.3X&.9X5X&.&.&.0X&.3X0X&.0X&.&.&.&.&.&.&.&.&.&.%.@.%.&.9X9X9X9X9X9X9X9X0X0X0X9XwX8XfX5XyX8XfX5X0X0X0XqX0X0X0X0X0X8X8XwX0X0X0X0X0X0X5X9XwXwX0XwXwX0X9XwXqXqXwXwXqXqXqXqXqXqXqXqX0X9X0X9X0X9X0X5X-.0X0X-.wX-.",
        "[.*X[.:X[.[.:X[..X[.[.[.[.[.[.[.[.[.:X[.[.[.[..X[..X[.[.[.[._._._.]._._.`.`.[.`.`.[.`.[.`.Y.`.[.`.K.[.[.`.[.K.[.[.[.`.`.`.`.`.`.`.`.`.`.`.`.`.`._._.`.`.`.`._.`.B B B `.`.B K.K.`.K.K.`.K.'.'.K.`.`.'.Y U ].Y `.'._.U ].U _.U U U U V V V V V Y U V V Y U Y N U V P U N N Y N Y N P N V U N P N N U N N V P N N U N _ V _ _ _ _ _ E _ J _ _ _ P _ _ U A N S _ _ _ _ _ _ _ J J U _ N J V _ J J U J J V J S _ U _ ! ' R R ' _ R ! ' ! ' ! _ ! ! ! ! R ! ! F ! F F F ' ' K ,.K #.K ~ D D ~ K ~ ' ` ' ! ~ ~ D ` ! ! ~ ~ ~ / ~ ^ ~ ~ ~ ~ / ~ ! ~ ~ W W W W W W W ;.W ,.~ W #.#.W D ;.:.:.,.<.:.<.:.<.:.;.;.#.;.#.| { #...#.#.:.:.:.X.} X.{ X.{ X.$...X.{ X.X.X.{ ;.#.#.,.,.#.#.*.#.,.#.#.*.#.#.$.$.$.$.:.$.3.$.3.3.$.$.3.$.3.3.=.q.=.q.*.*.0.4X4X0.*.~.%.K 4X4X*.K 4X4X4X4X4X4X2X4X2X5X3X3X3X3X2X3X3X4X2X2X5X2X2X2X2X2X2X7X7X7X7X7X7X7X7X7X7X7X4X7XtX7XtX7XyX7X4X8X5XuX8XyX8X4X8X4X8X8X7X8X8X8X4X8X8X8X~.2X2X2X4X2X2X2X2X7X2X2X7X8X8X8X8X8X2X8X8X8X6X6X6X6X6X6X8X3X8X2X8X2X8X3X2X2X8X5X5X4X5X3X8X5X8X3X5X8X2X3X8X3X3X2X3X3X8X8X3X8X3X3X3X6X2X6X3X3X3X3X&.2X3X5X2X3X2X2X2X3X2X3X3X3X3X3X3X3X3X6X3X3X3X3X3X9X&.9X&.&.&.&.&.9X&.&.9X&.&.&.&.&.&.&.&.&.@.&.&.-.9X9X9X9X9X9X9X9X9X9X9X9XwX0X6X5X5X0XyX5X0XwX9X0X0X9X0X5X5X0X0X5X0X0X5X0X5X3X3X5X3XwXqX0X9XqX0XwX9X9XqXwXqXqXqXqXqXqXqXqXqXqX9X9X6X9X6X3X0X9X9X0X0X0X-.",
        "[.[.[.[.*X[.[.[.[.:X[.[.[.[.[.[.[..X[..X[..X[.[.[.[.[..X.X[._.[.[._.[._.Y.[.K.Y.[.`.[.`.[.[.[.`.[.[.[.`.[.`.[.K.`.`.`.[.[.`.`.`.`.[.[.`..X`..X`.`.`.`..X`.`._._.`.B `.`.`.`.`.`.K._.`.K._.K.K._.'.Y `.'._.'.'.U U U '.Y '.Y '.Y V Y Y V U V V V B V N V U V U V Y V N Y N P V N C Y N Y P N V N N N Y N P N N Y N _ _ _ _ _ E _ _ _ E _ U E _ _ J A _ _ _ _ P J _ P J U _ _ _ A _ J _ P U J J U J _ _ J _ _ _ _ _ _ _ ' ! R ' ! ! ! ! ! ' ! ! _ ' ' ! ' E ! S A ! K ! K D D ~ ~ D ` ~ ~ K ! D ' D ' ~ K ! ~ ~ ` ~ ~ / ~ ~ ~ ~ ~ / ~ ~ ! ~ / ~ ~ W / ( W / W ~ ,.W W W ;.W #.#.;.,.:.:.:.;.:.;.:.:.;.{ ;.{ ;.#.{ ..{ { X.:.X.:.{ X.{ X.{ X.{ } X.X.} X.{ ..:.#.#.*.*.#.,.,.#.#.#.,.*.,.#.#.#.:.<.$.$.$.$.3.$.3.$.3.$.3.$.7.7.*.7.=.0.yX4X*.eXq.4XK *.4X*.4X4X4X4X4X*.4X%.4X*.4X4X3X3X3X5X8X5X2X2X2X2X2X2X2X8X2X8X2X8X3X7X8X7X2X7X7X7X8X7X7X7XtX4X4X4XuX7X4XuXyXuX8XyX8X7X8X4X8X7X8X5X4X8X8X8X8X8X8X2X2X2X2X4X2X4X2X2X2X8X2X2X3X8X8X8X8X8X2X8X6X6X6X6X6X6X6X3X6X3X6X2X8X2X3X3X~.2X2X5X5X8X8X3X8X5X8X2X8X3X3X8X8X8X8X8X6X3X3X6X3X8X8X6X2X6X6X3X6X3X3X3X5X3X3X3X3X3X3X2X3X3X3X3X3X3X3X3X3X3X3X9X9X3X3X3X3X9X3X&.&.&.&.&.&.0X9X&.&.&.&.&.&.&.&.&.&.&.&.9X9X9X9X9X9X9X9X9X9X9X9X9X9X9X9X9XwX0X8X0X8XfX0X0X0X0X0X0X0X6X5X5X5X3X3X5X3X&.&.3X3X2XqXwXwX9X0XwX9X9XwX9XqXqXqXqXqXqXqXqXqXqXqXqX9X6X6X9X&.0X0X-.0X-.0X0X",
        ":X[.[.:X[.:X[.[.[.[.[.*X[.[.[.[.[.:X[.[.[.[.[.[.[.[._.[.[.{.[.{.[._.[.[.[.`.`.[.Y.`.[.Y.K.`.[.Y.[.Y.[.`.[.[.[.`.Y `.`.[.`.`.`.`.`.`.`.`.`.`.`.`.`._.`.`.`._.`.`.`.`.`._.`.`.`.K.`.K._.`.K.K._._.`.'.U `.`.Y '.Y '.Y U U U '.Y U Y B Y V U V V C V Y V U U V U N U P N N V Y C P N Y N N V N Y N N P N N N P N P N _ N _ _ _ _ _ _ _ E _ _ _ _ J P _ _ N P J _ J _ J _ J N _ J U V _ J J A J J J V J J J J U _ _ R _ ! _ _ ' _ ! _ ' ! R ! _ ! ! _ ! ! _ ! A S A K ! D K *.~ ~ D *.~ K *.,.` ~ ~ ~ ~ ! ~ K ! ~ ! ' ~ W ~ ~ ~ ~ ' ~ ~ ~ ~ ~ ~ ! / ~ W W ( W W / W W ;.#.W W #.;.W ,.:.<.:.:.;.:.;.#.:.#.> #.| ;.{ ..#.{ #.X.:.:.X.{ X.{ X.X.X.X.........X.{ #.#.K ;.#.*.#.,.#.6.#.#.#.,.#.*.,.<.$.<.$.$.3.3.$.$.3.$.3.$.w.*.w.7.*.0.*.tX*.0.4X4X*.K *.K *.*.4X4X*.K 4X4X4X4X4X*.4X2X3X3X2X2X3X2X3X2X2X2X2X2X2X8X2X2X8X3X8X2X7X7X7X8X7X7X7X7X4XuXuXuX4XyX7XtX4X7X8X7X8X8X7X7X8X8X2X4X8X4X8X7X4X8X8X8X8X2X2X2X2X2X2X2X8X8X2X7X6X8X6X8X8X8X8X8X8X6X6X6X6X6X6X6X6X8X2X2X6X2X8X2X2X2XZ Z 2X3X8X8X6X5X8X8X3X8X3X3X8X3X8X8X6X8X6X3X8X6X6X6X8X3X6X6X3X6X3X5X3X3X3X3X3X3X3X3X3X3X3X3X6X6X3X3X3X6X6X9X6X3X6X3X9X3X9X&.&.&.&.&.&.&.&.&.&.9X-.&.&.9X&.9X&.&.&.&.9X9X9X9X9X9X9X9X9X9X9X9X9X9X9X9X9X9X9X8X5X0X8X8XfX0X9X0X0X0X5X0X5X5X&.&.5X5X5X3X5X&.&.3XqX9X3XqX6X9X3XqX3XqXqXqXqXqXqXqXqXqXqX6X6X6X9X6X9X3X6X=.0X-.9X0XpX",
        "[.[.[.[.[.[.:X:X[.:X[..X[.[..X.X.X[..X[..X[..X[._..X[.[..X[..X_._.[._.[.K.[.[.`.`.[.`.[.[.[.`.[.`.[.`.[.`.[.[.`.`.`.B B `.[.`..X.X`.`.`.`.`.[.`.`._.`._._.`.`.`.`.`.`.B `.`._.Y `.`.'.K._._._.K._._.Y '.'._.Y '.U '.U `.`.U U U U U N Y B Y N Y B N V Y U U V Y N Y V Y P N N Y P N C P P N N N P V P N N U N N U N N _ E _ _ _ _ _ _ _ _ E _ E _ _ _ A _ _ T _ _ J E _ _ J _ _ _ J U J J U P J J _ J N _ E _ _ _ ' R ! ! ! K ! ' ! ' F ! ' ! ' ' ! ! ! A E J ! ! K ~ D ~ D *.D ~ D #.~ D ` K ~ ! K ! ` ` ! ` ' D ! ! ~ ~ ~ ~ _ ~ ~ ~ / ~ ~ ~ ~ W W / ~ W W W W W #.W ;.;.W #.;.:.;.;.;.;.<.,.:.;.;.:.:.> #.| #.#.{ X...:.X.:...X.:.X.X.{ } ..X.X.{ X.:.#.#.#.#.6.$.6.#.#.#.,.*.,.*.#.*.#.#.*.#.$.3.$.3.$.$.3.$.3.$.3.0.=.7.7.*.*.w.*.yX*.yX*.4X*.K 4XK ~.*.4X4X4X4X~.2X4X*.4X4X4X8X3X3X3X5X3X2X5X2X2X3X2X2X2X2X2X2X8X2X8X3X8X8X7X8X7X8X8XeXtX4X7XtX7X4X7X4X4XuX5XuX5X5X8X4X8X7X4X8X8X4X8X8X8X8X8X8X6X7X4X8X2X7X2X2X2X7X8X8X8X6X8X8X6X6X8X6XqX6X6X6X6X6X6X6X2X6X8X2X8X2X8X2X2XZ %.K Z 2X6X8X6X6X6X6X8X8X8X6X6X6X6X8X6X6X6X6X6X0X6X3X3X6X6X6X6X3X3X5X6X3X3X3X3X3X3X6X3X3X6X3X3X3X9XqX6X9X9X9X9X9X9X3X9X&.3X&.&.&.&.&.&.&.&.&.&.&.9X&.&.9X&.9X9X9X9X9X9X9X9X9X9X9X9X9X9X9X9X9X9XqX9XqX9XqXwXwXwX0X5X5X5X8X0X0X&.0X5X&.0X5X5X5X&.&.&.&.%.&.2XqXqX6X9X6X6X3X9X3X9XqXqXqX6X6XqX6XqXqX6X6X6X6X6XqX6X6X3X9X0X0X0X0X"
    };

const char *
WxCasPix::m_stop_xpm[] =
    { /* XPM */
        /* columns rows colors chars-per-pixel */
        "32 32 79 1",
        "  c None",
        ". c #6c0000",
        "X c #770000",
        "o c #6e5900",
        "O c #755f00",
        "+ c #7c6400",
        "@ c #83130b",
        "# c #981513",
        "$ c #a71c19",
        "% c #b52521",
        "& c #846b00",
        "* c #897000",
        "= c #907400",
        "- c #977a00",
        "; c #9c7e00",
        ": c #927c12",
        "> c #cd312c",
        ", c #d03e39",
        "< c #d44b47",
        "1 c #d75854",
        "2 c #da6561",
        "3 c #dc6f6b",
        "4 c #a48400",
        "5 c #b18e00",
        "6 c #b59200",
        "7 c #b49b00",
        "8 c #bd9700",
        "9 c #bb9a00",
        "0 c #bb9e12",
        "q c #cc9c00",
        "w c #c3a000",
        "e c #c6ac00",
        "r c #c6ae0c",
        "t c #c9a000",
        "y c #c9a800",
        "u c #d1a400",
        "i c #d3ab00",
        "p c #d8ad00",
        "a c #ddaf1a",
        "s c #d3b100",
        "d c #d3b800",
        "f c #d9b400",
        "g c #ddb800",
        "h c #e1bb00",
        "j c #e5bb18",
        "k c #e5bc20",
        "l c #dbc31a",
        "z c #e8c600",
        "x c #ecc800",
        "c c #e8ce18",
        "v c #efd30d",
        "b c #f5d400",
        "n c #f7d804",
        "m c #fadc00",
        "M c #f4db38",
        "N c #fce220",
        "B c #fce430",
        "V c #fde748",
        "C c #fde852",
        "Z c #f7e465",
        "A c #fce960",
        "S c #fdeb6a",
        "D c #fded71",
        "F c #fdee78",
        "G c #e59492",
        "H c #fdee81",
        "J c #fdef8b",
        "K c #fdf08f",
        "L c #fdf193",
        "P c #fdf198",
        "I c #fef3a3",
        "U c #fdf3ae",
        "Y c #fef5b3",
        "T c #fef6be",
        "R c #fdf6c3",
        "E c #fffbe2",
        "W c #fffef4",
        "Q c white",
        "! c None",
        /* pixels */
        "!!!!!!!!!!!!!!!!!!!*&&&&!!!!!!!!",
        "!!!!!!!!!!!!!!;4;-=qqqq;+!!!!!!!",
        "!!!!!!!!!444448tuuyuuuqq;O!!!!!!",
        "!!!!!!!!4qiiiiuuuuuuuuuqu;o!!!!!",
        "!!!!!!!!4giippiuuiuuuuuuqq;o!!!!",
        "!!!!!!!!4gfiuiiiuuuuphxnmm9o!!!!",
        "!!!!!!!4qghfpuifhMHUUPPCm7O!!!!!",
        "!!!!!!!4ihhhxZTEERYUJHZm7O!!!!!!",
        "!!!!!!!4ggzgnWWRYPHHHSm7o!!!!!!!",
        "!!!!!!4wggzgSWYIHHHHCm7o!!!!!!!!",
        "!!!!!!4igggxTYPHHHFSBro!!!!!!!!!",
        "!!!!!!4fgggnTPHHHDCVdo!!!!!!!!!!",
        "!!!!!4wdfggAYHHHDACco=o!!!!!!!!!",
        "!!!!!4ifggxPLHFSAAMo*46o!!!!!!!!",
        "!!!!49idfgbYLFCAAA:oOooo!!!!!!!!",
        "!!!!4wiiidNKDCSAVVVBl7o!!!!!!!!!",
        "!!!!!4wiizAFSCVVVVVv7o=o!!!!!!!!",
        "!!!!!!4wibACVVVVVVmro=46o!!!!!!!",
        "!!!!!!!4wnVVVVVVVBl*oooooo!!!!!!",
        "!!!!!!!!4444440HBBBBBBmb7o!!!!!!",
        "!!!!!!!!!!4g94CEFBBBmmb7o!!!!!!!",
        "!!!!!!!!!!494SQFBBmk@@@@!!!!!!!!",
        "!!!!!!!!!!!-mTFBmma@$>>$@!!!!!!!",
        "!!!!!!!!!!*mFCmmmj@1GG31>X!!!!!!",
        "!!!!!!!!!!*****9m@$GQG3Q<$X!!!!!",
        "!!!!!!!!!!!!*8*bb@>GGQQ2<>.!!!!!",
        "!!!!!!!!!!!!*5*bb@>33QQ1<>.!!!!!",
        "!!!!!!!!!!!!!*ybx@$1Q21Q,#.!!!!!",
        "!!!!!!!!!!!!!*ix&!@><<<,%.!!!!!!",
        "!!!!!!!!!!!!!*d*!!!X$>>#.!!!!!!!",
        "!!!!!!!!!!!!!**!!!!!X...!!!!!!!!",
        "!!!!!!!!!!!!!*!!!!!!!!!!!!!!!!!!"
    };

#ifndef __WINDOWS__
const char *
WxCasPix::m_wxcas_xpm[] =
    { /* XPM */
        /* columns rows colors chars-per-pixel */
        "32 32 190 2",
        "   c None",
        ".  c #182139",
        "X  c #182152",
        "o  c #18314a",
        "O  c #10395a",
        "+  c #083963",
        "@  c #212942",
        "#  c #21395a",
        "$  c #313142",
        "%  c #31394a",
        "&  c #39394a",
        "*  c #39397b",
        "=  c #08425a",
        "-  c #00426b",
        ";  c #004273",
        ":  c #00526b",
        ">  c #08526b",
        ",  c #00637b",
        "<  c #7b4200",
        "1  c #424252",
        "2  c #4a4a5a",
        "3  c #4a4a63",
        "4  c #525263",
        "5  c #5a5a6b",
        "6  c #52527b",
        "7  c gray42",
        "8  c #636373",
        "9  c gray45",
        "0  c #005294",
        "q  c #085aad",
        "w  c #00738c",
        "e  c #006bad",
        "r  c #006bb5",
        "t  c #0073a5",
        "y  c #007ba5",
        "u  c #0073bd",
        "i  c #007bc6",
        "p  c #6b739c",
        "a  c #0094bd",
        "s  c #008cce",
        "d  c #009cc6",
        "f  c #0094d6",
        "g  c #009cd6",
        "h  c #0894d6",
        "j  c #089cde",
        "k  c #1894ce",
        "l  c #00a5ce",
        "z  c #00a5d6",
        "x  c #00a5de",
        "c  c #18a5de",
        "v  c #00ade7",
        "b  c #00b5e7",
        "n  c #00b5ef",
        "m  c #00bdef",
        "M  c #08b5e7",
        "N  c #00bdf7",
        "B  c #10ade7",
        "V  c #18b5e7",
        "C  c #2194c6",
        "Z  c #219cd6",
        "A  c #21adde",
        "S  c #31adde",
        "D  c #21b5e7",
        "F  c #29b5e7",
        "G  c #39ade7",
        "H  c #39bdef",
        "J  c #00c6f7",
        "K  c #42adde",
        "L  c #4abde7",
        "P  c #73bdd6",
        "I  c #4ac6ef",
        "U  c #4ad6f7",
        "Y  c #5ac6ef",
        "T  c #5ad6f7",
        "R  c #63ceef",
        "E  c #6bd6f7",
        "W  c #73ceef",
        "Q  c #73d6f7",
        "!  c #8c4a00",
        "~  c #9c5200",
        "^  c #9c7339",
        "/  c #a55a00",
        "(  c #ad5a00",
        ")  c #a56300",
        "_  c #ad6300",
        "`  c #ad6308",
        "'  c #ad6b08",
        "]  c #a56b18",
        "[  c #ad6b18",
        "{  c #ad7318",
        "}  c #b56300",
        "|  c #b56b00",
        " . c #bd6b00",
        ".. c #b56b10",
        "X. c #b57300",
        "o. c #bd7300",
        "O. c #bd7310",
        "+. c #ad7b39",
        "@. c #b57b29",
        "#. c #bd7b31",
        "$. c #c66b00",
        "%. c #c67300",
        "&. c #ce7300",
        "*. c #c67b18",
        "=. c #ce7b10",
        "-. c #d67b00",
        ";. c #bd8429",
        ":. c #b58442",
        ">. c #bd8c42",
        ",. c #ad946b",
        "<. c #b58c63",
        "1. c #b59c7b",
        "2. c #bd9c73",
        "3. c #bd9c7b",
        "4. c #bda57b",
        "5. c #c68418",
        "6. c #d68400",
        "7. c #de8400",
        "8. c #de8c08",
        "9. c #d68c18",
        "0. c #de8c18",
        "q. c #de9418",
        "w. c #c68421",
        "e. c #de8c21",
        "r. c #de9429",
        "t. c #d69431",
        "y. c #d69439",
        "u. c #de9c39",
        "i. c #e78c08",
        "p. c #e78c18",
        "a. c #e79418",
        "s. c #f79c08",
        "d. c #e79c21",
        "f. c #e79c29",
        "g. c #f7a518",
        "h. c #ffa510",
        "j. c #ffad18",
        "k. c #e7a539",
        "l. c #f7a521",
        "z. c #ffad21",
        "x. c #f7a531",
        "c. c #f7ad31",
        "v. c #ffb531",
        "b. c #ffb539",
        "n. c #c6944a",
        "m. c #ce944a",
        "M. c #de9c42",
        "N. c #c6a57b",
        "B. c #cead73",
        "V. c #cead7b",
        "C. c #e7ad4a",
        "Z. c #f7b542",
        "A. c #ffb542",
        "S. c #ffbd4a",
        "D. c #f7bd52",
        "F. c #ffbd52",
        "G. c #ffbd5a",
        "H. c #e7b573",
        "J. c #efbd73",
        "K. c #f7bd63",
        "L. c #ffc65a",
        "P. c #f7c66b",
        "I. c #ffc663",
        "U. c #ffc66b",
        "Y. c #ffc673",
        "T. c #ffce7b",
        "R. c #8cceef",
        "E. c #84def7",
        "W. c #94deef",
        "Q. c #94d6f7",
        "!. c #8ce7ff",
        "~. c #94e7ff",
        "^. c #9cefff",
        "/. c #a5e7ff",
        "(. c #a5efff",
        "). c #ade7ff",
        "_. c #b5efff",
        "`. c #d6bda5",
        "'. c #d6c6ad",
        "]. c #d6c6b5",
        "[. c #deceb5",
        "{. c #ffce84",
        "}. c #ffd68c",
        "|. c #ffd694",
        " X c #e7d6bd",
        ".X c #ffdea5",
        "XX c #e7dece",
        "oX c #efe7de",
        "OX c #ffe7c6",
        "+X c None",
        /* pixels */
        "+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X_.+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X",
        "+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X_.+X+X+X+X+X+X+X+X+X+X+X+X9   2 +X",
        "+X+X+X+X+X+X+X+X+X+X+X+X+X+XR _.U % # @ X X + O o =       .   +X",
        "+X+X+X+X+X+X+X+X+X: : . . o K _.E q w t r y y r y r e r r . O +X",
        "+X+X+X+X. O + = : : w w t i W _.E y r r y y y r r e e r r . O +X",
        "+X+X+X4 * y r r y r r r y u E._.Q r y Z _.i y e e e e e r . $ +X",
        "+X+X+X4 * y r r y r r y r s /._.Q.y y E _.s r e e e e r r . $ +X",
        "+X+X+X4 * r r r y y y r y h )._.Q.r r Q._.j r e e e e r r . % +X",
        "+X+X+X4 - y y r r r r r y S (._.!.i r W._.A r e e e r r r . 1 +X",
        "+X+X+X4 - y y r r h s r r S _.Y _.i u ~._.K u r r r u u u . 1 +X",
        "+X+X+X4 - y y r u _.Y r r Y _.Y _.u a _./.R u i i u u i u . 2 +X",
        "+X+X+X4 - y r r a _.(.u r E _.I _.a h _.W.E.a i u u i i u . 3 +X",
        "+X+X+X4 * y y r j _._.j u E._.K _.a c _.T _.j i i u i s a . 4 +X",
        "+X+X+X5 * y y u L _._.G a _._.H _.s G _.F _.D s k j c D S J E Q ",
        "+X+X+X4 - y r u W _.!.T j _.S S _.j H _.V _.F Y W./._._._.(.+X+X",
        "+X+X+X5 ; u i k _.P Y W.D _.A G _.M P _.M _.Y _.R F H C v > 6 +X",
        "+X+X+XJ C K Y Q _.A H (.P _.c G _.C R Q g _._._.A f g g f o 4 +X",
        "+X+X XV.w.[ E.:.| N.c /.E._.k D _.D _.Y g T _.).M d f g f o 4 +X",
        "W W O.I.F.b.n.8.s.i./ ^.(.W.g D _.H _.U d U _.^.v f f x l o 4 +X",
        "+X+X) F.A.v.l.z.h.h.) `.'.T f A _.U _.F f F _.E v l v x x o 4 +X",
        "m.y...Z.A.c.r.f.l.h.o.6.6.`.f Z _.P _.D x Z _.U v v v v v o 4 +X",
        "H.}.I.G.u.`  ._ ' q.h.h.s.6.'.C _.T _.B x b _.B v x x B b O 4 +X",
        "Y.T.U.I.)  .&.&.$./ q.h.s.6.3.C _.Q._.M B B b b b b b B b O 4 +X",
        "-.e.U.I.:.[.[.2.] ( { j.i./ <.B _.~._.b b b b B v m m A m O 4 +X",
        ">._ K.Y.;.oX+X+XoX! ] z.g.s._ B _.~._.n b m A m m m m N n O 4 +X",
        "B.M.OX{.P.>.4.].].< r.v.z.g.X.m _.).Q.m A m m N N J J J E O 4 +X",
        "-.a..X}.P.P.C.t.t.k.S.x.9.a.@.N _._.T N N N J n E n E n n . 4 +X",
        "%.7.p.*.5.|.Y.I.L.G.L.G.| ~ '.z Q _.I 0 , ; o X . .   % & 2 8 +X",
        "`.%.#.`.` .X|.T.D.x.{.{.e.,.. ; P _.E 7 +X+X+X+X+X+X+X+X+X+X+X+X",
        "+X'.+XXX_ d.K.J.@.-.0.=.} 1.+X+XR._.+Xp +X+X+X+X+X+X+X+X+X+X+X+X",
        "+X+X+X4.%.7.7.| '.+.&./ ^ +X+X+X+X_.+X+X+X+X+X+X+X+X+X+X+X+X+X+X",
        "+X+X+X+X3.+./ +.+X+X1.].+X+X+X+X+X_.+X+X+X+X+X+X+X+X+X+X+X+X+X+X"
    };
#endif /* !__WINDOWS__ */
// File_checked_for_headers
