/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.permission;

import android.annotation.CurrentTimeMillisLong;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcelable;

import com.android.internal.util.DataClass;

/**
 * Represents the usage of a permission group by an app. Supports package name, user, permission
 * group, whether or not the access is running or recent, whether the access is tied to a phone
 * call, and an optional special attribution tag, label and proxy label.
 *
 * @hide
 */
@SystemApi
@DataClass(
        genHiddenConstructor = true,
        genEqualsHashCode = true,
        genToString = true
)
public final class PermissionGroupUsage implements Parcelable {

    private final @NonNull String mPackageName;
    private final int mUid;
    private final long mLastAccessTimeMillis;
    private final @NonNull String mPermissionGroupName;
    private final boolean mActive;
    private final boolean mPhoneCall;
    private final @Nullable CharSequence mAttributionTag;
    private final @Nullable CharSequence mAttributionLabel;
    private final @Nullable CharSequence mProxyLabel;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/permission/PermissionGroupUsage.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    /**
     * Creates a new PermissionGroupUsage.
     *
     * @hide
     */
    @DataClass.Generated.Member
    public PermissionGroupUsage(
            @NonNull String packageName,
            int uid,
            long lastAccessTimeMillis,
            @NonNull String permissionGroupName,
            boolean active,
            boolean phoneCall,
            @Nullable CharSequence attributionTag,
            @Nullable CharSequence attributionLabel,
            @Nullable CharSequence proxyLabel) {
        this.mPackageName = packageName;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mPackageName);
        this.mUid = uid;
        this.mLastAccessTimeMillis = lastAccessTimeMillis;
        this.mPermissionGroupName = permissionGroupName;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mPermissionGroupName);
        this.mActive = active;
        this.mPhoneCall = phoneCall;
        this.mAttributionTag = attributionTag;
        this.mAttributionLabel = attributionLabel;
        this.mProxyLabel = proxyLabel;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * @return Package name for the usage
     */
    @DataClass.Generated.Member
    public @NonNull String getPackageName() {
        return mPackageName;
    }

    /**
     * @return UID for the usage
     */
    @DataClass.Generated.Member
    public int getUid() {
        return mUid;
    }

    /**
     * @return Last access time in millis for the usage
     */
    @CurrentTimeMillisLong
    @DataClass.Generated.Member
    public long getLastAccessTimeMillis() {
        return mLastAccessTimeMillis;
    }

    /**
     * @return Permission group name for the usage
     */
    @DataClass.Generated.Member
    public @NonNull String getPermissionGroupName() {
        return mPermissionGroupName;
    }

    /**
     * @return If usage is active
     */
    @DataClass.Generated.Member
    public boolean isActive() {
        return mActive;
    }

    /**
     * @return If usage is a phone call
     */
    @DataClass.Generated.Member
    public boolean isPhoneCall() {
        return mPhoneCall;
    }

    /**
     * @return Attribution tag associated with the usage
     */
    @DataClass.Generated.Member
    public @Nullable CharSequence getAttributionTag() {
        return mAttributionTag;
    }

    /**
     * @return Attribution label associated with the usage
     */
    @DataClass.Generated.Member
    public @Nullable CharSequence getAttributionLabel() {
        return mAttributionLabel;
    }

    /**
     * @return Proxy label associated with the usage
     */
    @DataClass.Generated.Member
    public @Nullable CharSequence getProxyLabel() {
        return mProxyLabel;
    }

    @Override
    @DataClass.Generated.Member
    public String toString() {
        // You can override field toString logic by defining methods like:
        // String fieldNameToString() { ... }

        return "PermissionGroupUsage { " +
                "packageName = " + mPackageName + ", " +
                "uid = " + mUid + ", " +
                "lastAccessTimeMillis = " + mLastAccessTimeMillis + ", " +
                "permissionGroupName = " + mPermissionGroupName + ", " +
                "active = " + mActive + ", " +
                "phoneCall = " + mPhoneCall + ", " +
                "attributionTag = " + mAttributionTag + ", " +
                "attributionLabel = " + mAttributionLabel + ", " +
                "proxyLabel = " + mProxyLabel +
        " }";
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(PermissionGroupUsage other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        PermissionGroupUsage that = (PermissionGroupUsage) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mPackageName, that.mPackageName)
                && mUid == that.mUid
                && mLastAccessTimeMillis == that.mLastAccessTimeMillis
                && java.util.Objects.equals(mPermissionGroupName, that.mPermissionGroupName)
                && mActive == that.mActive
                && mPhoneCall == that.mPhoneCall
                && java.util.Objects.equals(mAttributionTag, that.mAttributionTag)
                && java.util.Objects.equals(mAttributionLabel, that.mAttributionLabel)
                && java.util.Objects.equals(mProxyLabel, that.mProxyLabel);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mPackageName);
        _hash = 31 * _hash + mUid;
        _hash = 31 * _hash + Long.hashCode(mLastAccessTimeMillis);
        _hash = 31 * _hash + java.util.Objects.hashCode(mPermissionGroupName);
        _hash = 31 * _hash + Boolean.hashCode(mActive);
        _hash = 31 * _hash + Boolean.hashCode(mPhoneCall);
        _hash = 31 * _hash + java.util.Objects.hashCode(mAttributionTag);
        _hash = 31 * _hash + java.util.Objects.hashCode(mAttributionLabel);
        _hash = 31 * _hash + java.util.Objects.hashCode(mProxyLabel);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        int flg = 0;
        if (mActive) flg |= 0x10;
        if (mPhoneCall) flg |= 0x20;
        if (mAttributionTag != null) flg |= 0x40;
        if (mAttributionLabel != null) flg |= 0x80;
        if (mProxyLabel != null) flg |= 0x100;
        dest.writeInt(flg);
        dest.writeString(mPackageName);
        dest.writeInt(mUid);
        dest.writeLong(mLastAccessTimeMillis);
        dest.writeString(mPermissionGroupName);
        if (mAttributionTag != null) dest.writeCharSequence(mAttributionTag);
        if (mAttributionLabel != null) dest.writeCharSequence(mAttributionLabel);
        if (mProxyLabel != null) dest.writeCharSequence(mProxyLabel);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ PermissionGroupUsage(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        int flg = in.readInt();
        boolean active = (flg & 0x10) != 0;
        boolean phoneCall = (flg & 0x20) != 0;
        String packageName = in.readString();
        int uid = in.readInt();
        long lastAccessTimeMillis = in.readLong();
        String permissionGroupName = in.readString();
        CharSequence attributionTag = (flg & 0x40) == 0 ? null : (CharSequence) in.readCharSequence();
        CharSequence attributionLabel = (flg & 0x80) == 0 ? null : (CharSequence) in.readCharSequence();
        CharSequence proxyLabel = (flg & 0x100) == 0 ? null : (CharSequence) in.readCharSequence();

        this.mPackageName = packageName;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mPackageName);
        this.mUid = uid;
        this.mLastAccessTimeMillis = lastAccessTimeMillis;
        this.mPermissionGroupName = permissionGroupName;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mPermissionGroupName);
        this.mActive = active;
        this.mPhoneCall = phoneCall;
        this.mAttributionTag = attributionTag;
        this.mAttributionLabel = attributionLabel;
        this.mProxyLabel = proxyLabel;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<PermissionGroupUsage> CREATOR
            = new Parcelable.Creator<PermissionGroupUsage>() {
        @Override
        public PermissionGroupUsage[] newArray(int size) {
            return new PermissionGroupUsage[size];
        }

        @Override
        public PermissionGroupUsage createFromParcel(@NonNull android.os.Parcel in) {
            return new PermissionGroupUsage(in);
        }
    };

    @DataClass.Generated(
            time = 1645067417023L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/permission/PermissionGroupUsage.java",
            inputSignatures = "private final @android.annotation.NonNull java.lang.String mPackageName\nprivate final  int mUid\nprivate final  long mLastAccessTimeMillis\nprivate final @android.annotation.NonNull java.lang.String mPermissionGroupName\nprivate final  boolean mActive\nprivate final  boolean mPhoneCall\nprivate final @android.annotation.Nullable java.lang.CharSequence mAttributionTag\nprivate final @android.annotation.Nullable java.lang.CharSequence mAttributionLabel\nprivate final @android.annotation.Nullable java.lang.CharSequence mProxyLabel\nclass PermissionGroupUsage extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass(genHiddenConstructor=true, genEqualsHashCode=true, genToString=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
