/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package android.service.autofill.augmented;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Bundle;
import android.service.autofill.Dataset;

import com.android.internal.util.DataClass;

import java.util.ArrayList;
import java.util.List;

/**
 * Response to a {@link FillRequest}.
 *
 * @hide
 */
@SystemApi
@DataClass(
        genBuilder = true,
        genHiddenGetters = true)
public final class FillResponse {

    /**
     * The {@link FillWindow} used to display the Autofill UI.
     */
    private @Nullable FillWindow mFillWindow;

    /**
     * The {@link Dataset}s representing the inline suggestions data. Defaults to null if no
     * inline suggestions are available from the service.
     */
    @DataClass.PluralOf("inlineSuggestion")
    private @Nullable List<Dataset> mInlineSuggestions;

    /**
     * The client state that {@link AugmentedAutofillService} implementation can put anything in to
     * identify the request and the response when calling
     * {@link AugmentedAutofillService#getFillEventHistory()}.
     */
    private @Nullable Bundle mClientState;

    private static FillWindow defaultFillWindow() {
        return null;
    }

    private static List<Dataset> defaultInlineSuggestions() {
        return null;
    }

    private static Bundle defaultClientState() {
        return null;
    }


    /** @hide */
    abstract static class BaseBuilder {
        abstract FillResponse.Builder addInlineSuggestion(@NonNull Dataset value);
    }



    // Code below generated by codegen v1.0.15.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/service/autofill/augmented/FillResponse.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ FillResponse(
            @Nullable FillWindow fillWindow,
            @Nullable List<Dataset> inlineSuggestions,
            @Nullable Bundle clientState) {
        this.mFillWindow = fillWindow;
        this.mInlineSuggestions = inlineSuggestions;
        this.mClientState = clientState;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The {@link FillWindow} used to display the Autofill UI.
     *
     * @hide
     */
    @DataClass.Generated.Member
    public @Nullable FillWindow getFillWindow() {
        return mFillWindow;
    }

    /**
     * The {@link Dataset}s representing the inline suggestions data. Defaults to null if no
     * inline suggestions are available from the service.
     *
     * @hide
     */
    @DataClass.Generated.Member
    public @Nullable List<Dataset> getInlineSuggestions() {
        return mInlineSuggestions;
    }

    /**
     * The client state that {@link AugmentedAutofillService} implementation can put anything in to
     * identify the request and the response when calling
     * {@link AugmentedAutofillService#getFillEventHistory()}.
     *
     * @hide
     */
    @DataClass.Generated.Member
    public @Nullable Bundle getClientState() {
        return mClientState;
    }

    /**
     * A builder for {@link FillResponse}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder extends BaseBuilder {

        private @Nullable FillWindow mFillWindow;
        private @Nullable List<Dataset> mInlineSuggestions;
        private @Nullable Bundle mClientState;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * The {@link FillWindow} used to display the Autofill UI.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setFillWindow(@NonNull FillWindow value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mFillWindow = value;
            return this;
        }

        /**
         * The {@link Dataset}s representing the inline suggestions data. Defaults to null if no
         * inline suggestions are available from the service.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setInlineSuggestions(@NonNull List<Dataset> value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mInlineSuggestions = value;
            return this;
        }

        /** @see #setInlineSuggestions */
        @DataClass.Generated.Member
        @Override
        @NonNull FillResponse.Builder addInlineSuggestion(@NonNull Dataset value) {
            if (mInlineSuggestions == null) setInlineSuggestions(new ArrayList<>());
            mInlineSuggestions.add(value);
            return this;
        }

        /**
         * The client state that {@link AugmentedAutofillService} implementation can put anything in to
         * identify the request and the response when calling
         * {@link AugmentedAutofillService#getFillEventHistory()}.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setClientState(@NonNull Bundle value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mClientState = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull FillResponse build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mFillWindow = defaultFillWindow();
            }
            if ((mBuilderFieldsSet & 0x2) == 0) {
                mInlineSuggestions = defaultInlineSuggestions();
            }
            if ((mBuilderFieldsSet & 0x4) == 0) {
                mClientState = defaultClientState();
            }
            FillResponse o = new FillResponse(
                    mFillWindow,
                    mInlineSuggestions,
                    mClientState);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x8) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1584480900526L,
            codegenVersion = "1.0.15",
            sourceFile = "frameworks/base/core/java/android/service/autofill/augmented/FillResponse.java",
            inputSignatures = "private @android.annotation.Nullable android.service.autofill.augmented.FillWindow mFillWindow\nprivate @com.android.internal.util.DataClass.PluralOf(\"inlineSuggestion\") @android.annotation.Nullable java.util.List<android.service.autofill.Dataset> mInlineSuggestions\nprivate @android.annotation.Nullable android.os.Bundle mClientState\nprivate static  android.service.autofill.augmented.FillWindow defaultFillWindow()\nprivate static  java.util.List<android.service.autofill.Dataset> defaultInlineSuggestions()\nprivate static  android.os.Bundle defaultClientState()\nclass FillResponse extends java.lang.Object implements []\n@com.android.internal.util.DataClass(genBuilder=true, genHiddenGetters=true)\nabstract  android.service.autofill.augmented.FillResponse.Builder addInlineSuggestion(android.service.autofill.Dataset)\nclass BaseBuilder extends java.lang.Object implements []")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
