/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.codegentest;

import android.annotation.IntRange;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.PackageManager;

import com.android.internal.util.DataClass;

import java.util.List;
import java.util.Set;

/**
 * Test for some false positive pitfalls for
 * {@link android.processor.staledataclass.StaleDataclassProcessor}
 *
 * Relies on the detector being run, failing the build should any of things here falsely
 * register as stale.
 */
@DataClass(genConstructor = false, genBuilder = false)
public class StaleDataclassDetectorFalsePositivesTest {

    /** Interfaces should be ignored */
    public interface SomeListener {
        void onEvent();
    }

    /** Enums should be ignored */
    private enum SomeEnum { ONE, TWO }

    /** Annotations should be ignored */
    public @interface SomeAnnotation {}

    /* Static initializers should be ignored */
    static {}

    /* Initializers should be ignored */
    {}

    /* Wildcard type argument should work correctly */
    @Nullable
    private List<Set<?>> mUsesWildcards = null;

    /** Unrelated methods should be noted, without triggering staleness false positives */
    public @NonNull String someMethod(int param) { return null; }

    /** Inlined constants in annotation args should be fine */
    private @IntRange(from = PackageManager.PERMISSION_GRANTED) void annotatedWithConstArg() {}



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/tests/Codegen/src/com/android/codegentest/StaleDataclassDetectorFalsePositivesTest.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    public @Nullable List<Set<?>> getUsesWildcards() {
        return mUsesWildcards;
    }

    @DataClass.Generated.Member
    public @NonNull StaleDataclassDetectorFalsePositivesTest setUsesWildcards(@NonNull List<Set<?>> value) {
        mUsesWildcards = value;
        return this;
    }

    @DataClass.Generated(
            time = 1616541544639L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/tests/Codegen/src/com/android/codegentest/StaleDataclassDetectorFalsePositivesTest.java",
            inputSignatures = "private @android.annotation.Nullable java.util.List<java.util.Set<?>> mUsesWildcards\npublic @android.annotation.NonNull java.lang.String someMethod(int)\nprivate @android.annotation.IntRange void annotatedWithConstArg()\nclass StaleDataclassDetectorFalsePositivesTest extends java.lang.Object implements []\n@com.android.internal.util.DataClass(genConstructor=false, genBuilder=false)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
