# libcast

libcast is an open source implementation of the Cast protocol supporting Cast
applications and streaming to Cast-compatible devices.

## Using the standalone implementations

To run the standalone sender and receivers together, first you need to install
the following dependencies: FFMPEG, LibVPX, LibOpus, LibSDL2, LibAOM as well as
their headers (frequently in a separate -dev package). Currently, it is advised
that most Linux users compile LibAOM from source, using the instructions at
https://aomedia.googlesource.com/aom/. Older versions found in many package
management systems have blocking performance issues, causing AV1 encoding to be
completely unusable. From here, you just need a video to use with the
cast_sender, as the cast_receiver can generate a self-signed certificate and
private key for each session. You can also generate your own RSA private key and
either create or have the receiver automatically create a self signed
certificate with that key. If the receiver generates a root certificate, it will
print out the location of that certificate to stdout.

Note that we assume that the private key is a PEM-encoded RSA private key,
and the certificate is X509 PEM-encoded. The certificate must also have
the CA bit set in the basic constraints. The easiest way to test with a key
and certificate is to use ones generated by the cast_receiver standalone
application.

## Developer certificate generation and use

The easiest way to generate a private key and certificate is to just run
the cast_receiver with `-g`, and both should be written out to files:

```
  $ /path/to/out/Default/cast_receiver -g
    [INFO:../../cast/receiver/channel/static_credentials.cc(161):T0] Generated new private key for session: ./generated_root_cast_receiver.key
    [INFO:../../cast/receiver/channel/static_credentials.cc(169):T0] Generated new root certificate for session: ./generated_root_cast_receiver.crt
```

These generated credentials can be passed in to start a session, e.g.
```
./out/Default/cast_receiver -d generated_root_cast_receiver.crt -p generated_root_cast_receiver.key lo0
```

And then passed to the cast sender to connect and start a streaming session:
```
  $ ./out/Default/cast_sender -d generated_root_cast_receiver.crt lo0 ~/video-1080-mp4.mp4
```

When running on Mac OS X, also pass the `-x` flag to the cast receiver to
disable DNS-SD/mDNS, since Open Screen does not currently integrate with
Bonjour.

When connecting to a receiver that's not running on the loopback interface
(typically `lo` or `lo0`), pass the `-r <receiver IP endpoint>` flag to the
`cast_sender` binary.
