/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.closurerunner;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.rhino.Node;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

class MinerrPass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    final AbstractCompiler compiler;
    final Pattern minerrInstanceRegex = Pattern.compile("^(\\S+)MinErr$");
    private Map<String, Map<String, String>> namespaces;
    private Map<String, String> globalNamespace;
    private List<Node> minerrInstances;
    private PrintStream errorConfigOutput;
    private Node minerrDefNode;
    private String minerrDefSource;
    static final DiagnosticType THROW_IS_NOT_MINERR_ERROR_WARNING = DiagnosticType.warning((String)"JSC_THROW_IS_NOT_MINERR_ERROR_WARNING", (String)"Throw expression is not a minErr instance.");
    static final DiagnosticType UNSUPPORTED_STRING_EXPRESSION_ERROR = DiagnosticType.error((String)"JSC_UNSUPPORTED_STRING_EXPRESSION_ERROR", (String)"Can't extract a static string value where one was expected.");
    static final DiagnosticType MULTIPLE_MINERR_DEFINITION_WARNING = DiagnosticType.warning((String)"JSC_MULTIPLE_MINERR_DEFINITION_WARNING", (String)"Found definitions for the function 'minErr' in multiple locations.");

    public MinerrPass(AbstractCompiler compiler, PrintStream errorConfigOutput, String minerrDef) {
        this.compiler = compiler;
        this.namespaces = new HashMap<String, Map<String, String>>();
        this.globalNamespace = new HashMap<String, String>();
        this.minerrInstances = new ArrayList<Node>();
        this.errorConfigOutput = errorConfigOutput;
        this.minerrDefSource = minerrDef;
    }

    public MinerrPass(AbstractCompiler compiler, PrintStream errorConfigOutput) {
        this(compiler, errorConfigOutput, null);
    }

    static String substituteInCode(String code, String url, String separator) {
        return code.replace("MINERR_URL", url).replace("MINERR_SEPARATOR", separator);
    }

    private Node createSubstituteMinerrDefinition() {
        SourceFile source = SourceFile.fromCode((String)"MINERR_ASSET", (String)this.minerrDefSource);
        JsAst ast = new JsAst(source);
        return ast.getAstRoot(this.compiler).getFirstChild().detachFromParent();
    }

    private boolean isMinerrCall(Node ast) {
        Node nameNode;
        if (ast.isCall() && (nameNode = ast.getFirstChild()).isName()) {
            String name = nameNode.getString();
            return name.equals("minErr");
        }
        return false;
    }

    private boolean isMinerrInstance(Node ast) {
        if (ast.isCall()) {
            Node child = ast.getFirstChild();
            if (child.isName()) {
                String name = child.getString();
                return this.minerrInstanceRegex.matcher(name).matches();
            }
            return this.isMinerrCall(child);
        }
        return false;
    }

    private boolean isMinerrDefinition(Node ast) {
        Node child;
        if (ast.isFunction() && (child = ast.getFirstChild()).isName()) {
            String name = child.getString();
            return name.equals("minErr");
        }
        return false;
    }

    private <T> List<T> listFromIterable(Iterable<T> iterable) {
        ArrayList<T> ts = new ArrayList<T>();
        for (T elt : iterable) {
            ts.add(elt);
        }
        return ts;
    }

    private String getNamespace(Node ast) {
        Node child = ast.getFirstChild();
        if (this.isMinerrCall(child)) {
            List grandchildren = this.listFromIterable(child.children());
            if (grandchildren.size() >= 2) {
                return this.getExprString((Node)grandchildren.get(1));
            }
            return null;
        }
        if (this.isMinerrInstance(ast)) {
            String name = child.getString();
            Matcher match = this.minerrInstanceRegex.matcher(name);
            match.find();
            return match.group(1);
        }
        throw new IllegalArgumentException("Node must be a minErr instance");
    }

    private void addMessageToNamespace(String namespace, String code, String message) {
        if (!this.namespaces.containsKey(namespace)) {
            this.namespaces.put(namespace, new HashMap());
        }
        Map<String, String> namespacedMessages = this.namespaces.get(namespace);
        namespacedMessages.put(code, message);
    }

    private void addMessageToGlobalNamespace(String code, String message) {
        this.globalNamespace.put(code, message);
    }

    private void unmarkInstancesBelow(Node ast) {
        this.minerrInstances.remove(ast);
        for (Node child : ast.children()) {
            this.unmarkInstancesBelow(child);
        }
    }

    private String getExprStringR(Node ast) {
        if (ast.isString()) {
            return ast.getString();
        }
        if (ast.isAdd()) {
            return this.getExprStringR(ast.getFirstChild()) + this.getExprStringR(ast.getChildAtIndex(1));
        }
        throw new IllegalArgumentException("Wrong node type");
    }

    private String getExprString(Node ast) {
        try {
            return this.getExprStringR(ast);
        }
        catch (IllegalArgumentException e) {
            this.compiler.report(JSError.make((Node)ast, (DiagnosticType)UNSUPPORTED_STRING_EXPRESSION_ERROR, (String[])new String[0]));
            return null;
        }
    }

    public void process(Node externs, Node root) {
        NodeTraversal.traverse((AbstractCompiler)this.compiler, (Node)root, (NodeTraversal.Callback)this);
        boolean codeChanged = false;
        for (Node instance : this.minerrInstances) {
            Node templateNode = instance.getChildAtIndex(2);
            Node errCodeNode = instance.getChildAtIndex(1);
            String namespace = this.getNamespace(instance);
            if (namespace != null) {
                this.addMessageToNamespace(namespace, this.getExprString(errCodeNode), this.getExprString(templateNode));
            } else {
                this.addMessageToGlobalNamespace(this.getExprString(errCodeNode), this.getExprString(templateNode));
            }
            instance.removeChild(templateNode);
            codeChanged = true;
        }
        if (this.minerrDefNode != null && this.minerrDefSource != null) {
            Node newMinErrDef = this.createSubstituteMinerrDefinition();
            newMinErrDef.useSourceInfoFromForTree(this.minerrDefNode);
            this.minerrDefNode.getParent().replaceChild(this.minerrDefNode, newMinErrDef);
            codeChanged = true;
        }
        HashMap<String, Map<String, String>> jsonBuilder = new HashMap<String, Map<String, String>>(this.namespaces);
        jsonBuilder.putAll(this.globalNamespace);
        JSONObject json = new JSONObject(jsonBuilder);
        this.errorConfigOutput.print(json.toString());
        if (codeChanged) {
            this.compiler.reportCodeChange();
        }
    }

    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isThrow() && !this.isMinerrInstance(n.getFirstChild())) {
            this.compiler.report(t.makeError(n, THROW_IS_NOT_MINERR_ERROR_WARNING, new String[0]));
            this.unmarkInstancesBelow(n);
        }
        if (this.isMinerrInstance(n)) {
            this.minerrInstances.add(n);
        }
        if (this.isMinerrDefinition(n)) {
            if (this.minerrDefNode == null) {
                this.minerrDefNode = n;
            } else {
                this.compiler.report(t.makeError(n, MULTIPLE_MINERR_DEFINITION_WARNING, new String[0]));
            }
        }
    }
}

