/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger-register.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
* SECTION:ianjuta-debugger-register
* @title: IAnjutaDebuggerRegister
* @short_description: Register interface for debuggers
* @see_also:
* @stability: Unstable
* @include: libanjuta/interfaces/ianjuta-debugger-register.h
*
 	* This interface is used to examine and change values of CPU registers.
*/

#include "ianjuta-debugger-register.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_debugger_register_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-debugger-register-quark");
	}
	
	return quark;
}

/**
* ianjuta_debugger_register_list_register:
* @obj: Self
* @callback: Callback to call with the #IAnjutaDebuggerRegisterData list
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
*
* List all registers of the target. This function can be called without
* a program loaded, the value field of register structure is not filled.
*
* Returns: TRUE if the request succeed and the callback is
* called. If FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_register_list_register (IAnjutaDebuggerRegister *obj, IAnjutaDebuggerGListCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_REGISTER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_REGISTER_GET_IFACE (obj)->list_register (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_register_list_register_default (IAnjutaDebuggerRegister *obj, IAnjutaDebuggerGListCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_register_update_register:
* @obj: Self
* @callback: Callback call with the list of all modified #IAnjutaDebuggerRegisterData
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
*
* Return all modified registers since the last call. Only the num and
* value field are used.
*
* Returns: TRUE if the request succeed and the callback is
* called. If FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_register_update_register (IAnjutaDebuggerRegister *obj, IAnjutaDebuggerGListCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_REGISTER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_REGISTER_GET_IFACE (obj)->update_register (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_register_update_register_default (IAnjutaDebuggerRegister *obj, IAnjutaDebuggerGListCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_register_write_register:
* @obj: Self
* @value: Modified register with a new value
* @err: Error propagation and reporting.
*
* Change the value of one register. Only the num and value field are used.
*
* Returns: TRUE if the request succeed.
*/
gboolean
ianjuta_debugger_register_write_register (IAnjutaDebuggerRegister *obj, IAnjutaDebuggerRegisterData *value, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_REGISTER(obj), FALSE);
	return IANJUTA_DEBUGGER_REGISTER_GET_IFACE (obj)->write_register (obj, value, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_register_write_register_default (IAnjutaDebuggerRegister *obj, IAnjutaDebuggerRegisterData *value, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_debugger_register_base_init (IAnjutaDebuggerRegisterIface* klass)
{
	static gboolean initialized = FALSE;

	klass->list_register = ianjuta_debugger_register_list_register_default;
	klass->update_register = ianjuta_debugger_register_update_register_default;
	klass->write_register = ianjuta_debugger_register_write_register_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_debugger_register_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaDebuggerRegisterIface),
			(GBaseInitFunc) ianjuta_debugger_register_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaDebuggerRegister", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_DEBUGGER);
	}
	return type;			
}
