#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2021 Dell Inc. or its subsidiaries. All Rights Reserved
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for sonic_system
"""

from __future__ import absolute_import, division, print_function
__metaclass__ = type

DOCUMENTATION = """
---
module: sonic_system
version_added: 1.0.0
notes:
- Tested against Enterprise SONiC Distribution by Dell Technologies.
- Supports C(check_mode).
author: Abirami N (@abirami-n)
short_description: Configure system parameters
description:
  - This module is used for configuration management of global system parameters on devices running Enterprise SONiC.
options:
  config:
    description:
      - Specifies the system related configurations
    type: dict
    suboptions:
      hostname:
        description:
          - Specifies the hostname of the SONiC device
        type: str
      interface_naming:
        description:
          - Specifies the type of interface-naming in device
        type: str
        choices:
          - standard
          - native
      anycast_address:
        description:
          - Specifies different types of anycast address that can be configured on the device
        type: dict
        suboptions:
          ipv4:
            description:
              - Enable or disable ipv4 anycast-address
            type: bool
          ipv6:
            description:
              - Enable or disable ipv6 anycast-address
            type: bool
          mac_address:
            description:
              - Specifies the mac anycast-address
            type: str
  state:
    description:
      - Specifies the operation to be performed on the system parameters configured on the device.
      - In case of merged, the input configuration will be merged with the existing system configuration on the device.
      - In case of deleted the existing system configuration will be removed from the device.
    default: merged
    choices: ['merged', 'deleted']
    type: str
"""
EXAMPLES = """
# Using deleted
#
# Before state:
# -------------
#!
#SONIC(config)#do show running-configuration
#!
#ip anycast-mac-address aa:bb:cc:dd:ee:ff
#ip anycast-address enable
#ipv6 anycast-address enable
#interface-naming standard

- name: Merge provided configuration with device configuration
  dellemc.enterprise_sonic.sonic_system:
    config:
      hostname: SONIC
      interface_naming: standard
      anycast_address:
        ipv6: true
    state: deleted

# After state:
# ------------
#!
#sonic(config)#do show running-configuration
#!
#ip anycast-mac-address aa:bb:cc:dd:ee:ff
#ip anycast-address enable


# Using deleted
#
# Before state:
# -------------
#!
#SONIC(config)#do show running-configuration
#!
#ip anycast-mac-address aa:bb:cc:dd:ee:ff
#ip anycast-address enable
#ipv6 anycast-address enable
#interface-naming standard

- name: Delete all system related configs in device configuration
  dellemc.enterprise_sonic.sonic_system:
    config:
    state: deleted

# After state:
# ------------
#!
#sonic(config)#do show running-configuration
#!


# Using merged
#
# Before state:
# -------------
#!
#sonic(config)#do show running-configuration
#!

- name: Merge provided configuration with device configuration
  dellemc.enterprise_sonic.sonic_system:
    config:
      hostname: SONIC
      interface_naming: standard
      anycast_address:
        ipv6: true
        ipv4: true
        mac_address: aa:bb:cc:dd:ee:ff
    state: merged

# After state:
# ------------
#!
#SONIC(config)#do show running-configuration
#!
#ip anycast-mac-address aa:bb:cc:dd:ee:ff
#ip anycast-address enable
#ipv6 anycast-address enable
#interface-naming standard


"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  type: list
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
after:
  description: The resulting configuration model invocation.
  returned: when changed
  type: list
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['command 1', 'command 2', 'command 3']
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.dellemc.enterprise_sonic.plugins.module_utils.network.sonic.argspec.system.system import SystemArgs
from ansible_collections.dellemc.enterprise_sonic.plugins.module_utils.network.sonic.config.system.system import System


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    module = AnsibleModule(argument_spec=SystemArgs.argument_spec,
                           supports_check_mode=True)

    result = System(module).execute_module()
    module.exit_json(**result)


if __name__ == '__main__':
    main()
