#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for junos_bgp_global
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type

ANSIBLE_METADATA = {
    "metadata_version": "1.1",
    "status": ["preview"],
    "supported_by": "network",
}

DOCUMENTATION = """
---
module: junos_bgp_global
version_added: "1.3.0"
short_description: Manages BGP Global configuration on devices running Juniper JUNOS.
description:
  - This module manages global bgp configuration on devices running Juniper JUNOS.
author: Rohit Thakur (@rohitthakur2590)
requirements:
  - ncclient (>=v0.6.4)
  - xmltodict (>=0.12.0)
notes:
  - This module requires the netconf system service be enabled on the device being managed.
  - This module works with connection C(netconf). See L(the Junos OS Platform Options,../network/user_guide/platform_junos.html).
  - Tested against JunOS v18.4R1
options:
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the Junos device
      by executing the command B(show protocols bgp).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result
    type: str
  config:
    description: A list of BGP process configuration.
    type: dict
    suboptions:
      as_number:
        description: Specify Autonomous system number.
        type: str
      loops:
        description: Specify maximum number of times this AS can be in an AS path.
        type: int
      asdot_notation:
        description: Enable AS-Dot notation to display true 4 byte AS numbers.
        type: bool
      accept_remote_nexthop: &accept_remote_nexthop
        description: Allow import policy to specify a non-directly connected next-hop.
        type: bool
      add_path_display_ipv4_address: &add_path_display_ipv4_address
        description: Display add-path path-id in IPv4 address format.
        type: bool
      advertise_bgp_static: &advertise_bgp_static
        description: Advertise bgp-static routes.
        type: dict
        suboptions:
          set:
            description: Set Advertise bgp-static routes.
            type: bool
          policy:
            description: Specify static route advertisement policy.
            type: str
      advertise_external: &advertise_external
        description: Advertise best external routes.
        type: dict
        suboptions:
          set:
            description: Set Advertise best external routes.
            type: bool
          conditional:
            description: Route matches active route upto med-comparison rule.
            type: bool
      advertise_from_main_vpn_tables:
        description: Advertise VPN routes from bgp.Xvpn.0 tables in master instance.
        type: bool
      advertise_inactive: &advertise_inactive
        description: Advertise inactive routes.
        type: bool
      advertise_peer_as: &advertise_peer_as
        description: Advertise routes received from the same autonomous system.
        type: bool
      authentication_algorithm: &authentication_algorithm
        description: Specify authentication algorithm name.
        type: str
        choices: ["aes-128-cmac-96", "hmac-sha-1-96", "md5"]
      authentication_key: &authentication_key
        description: Specify MD5 authentication key.
        type: str
      authentication_key_chain: &authentication_key_chain
        description: Specify authentication key chain name.
        type: str
      bfd_liveness_detection: &bfd_liveness_detection
        description: Bidirectional Forwarding Detection (BFD) options.
        type: dict
        suboptions:
          authentication:
            description: Authentication options.
            type: dict
            suboptions:
              algorithm:
                description: Specify algorithm name.
                type: str
                choices: ["keyed-md5", "keyed-sha-1", "meticulous-keyed-md5", "meticulous-keyed-sha-1", "simple-password"]
              key_chain:
                description: Specify Key chain name.
                type: str
              loose_check:
                description: Verify authentication only if authentication is negotiated.
                type: bool
          detection_time:
            description: Specify Detection-time optionss.
            type: dict
            suboptions:
              threshold:
                description: Specify high detection-time triggering a trap (milliseconds).
                type: int
          holddown_interval:
            description: Specify time to hold the session-UP notification to the client.
            type: int
          minimum_interval:
            description: Specify minimum transmit and receive interval.
            type: int
          minimum_receive_interval:
            description: Specify minimum receive interval.
            type: int
          multiplier:
            description: Specify detection time multiplier.
            type: int
          no_adaptation:
            description: Disable adaptation.
            type: bool
          session_mode:
            description: BFD single-hop or multihop session-mode.
            type: str
            choices: ["automatic", "multihop", "single-hop"]
          transmit_interval:
            description: Transmit-interval options.
            type: dict
            suboptions:
              minimum_interval:
                description: Specify Minimum transmit interval.
                type: int
              threshold:
                description: Specify high transmit interval triggering a trap.
                type: int
          version:
            description: Specify BFD protocol version number.
            type: str
            choices: ["0", "1", "automatic"]
      bgp_error_tolerance: &bgp_error_tolerance
        description: Handle BGP malformed updates softly.
        type: dict
        suboptions:
          set:
            description: Set BGP malformed updates softly.
            type: bool
          malformed_route_limit:
            description: Maximum number of malformed routes from a peer.
            type: int
          malformed_update_log_interval:
            description: Time used when logging malformed update.
            type: int
          no_malformed_route_limit:
            description: Specify no malformed route limit.
            type: bool
      bmp: &bmp
        description: Specific settings to override the routing-options settings.
        type: dict
        suboptions:
          monitor:
            description: Enable/Disable monitoring.
            type: bool
          route_monitoring:
            description: Control route monitoring settings.
            type: dict
            suboptions:
              none:
                description: Do not send route montoring messages.
                type: bool
              post_policy:
                description: Send post policy route montoring messages.
                type: bool
              post_policy_exclude_non_eligible:
                description: Send post policy route montoring messages and exclude unresolved routes, etc.
                type: bool
              pre_policy:
                description: Send pre policy route montoring messages.
                type: bool
              post_policy_exclude_non_feasible:
                description: Send pre policy route montoring messages and exclude looped routes, etc.
                type: bool
      cluster_id: &cluster_id
        description: Specify cluster identifier.
        type: str
      damping: &damping
        description: Enable route flap damping.
        type: bool
      description: &description
        description: Specify text description.
        type: str
      disable:
        description: Disable BGP.
        type: bool
      egress_te: &egress_te
        description: Use Egress Peering traffic engineering.
        type: dict
        suboptions:
          set:
            description: Set the attribute.
            type: bool
          backup_path:
            description: The 'egress-te-backup-paths template' to use for this peer.
            type: str
      egress_te_backup_paths:
        description: Backup-path for Egress-TE peer interface failure.
        type: dict
        suboptions:
          templates:
            description: Specify Backup-path template.
            type: list
            elements: dict
            suboptions:
              path_name:
                description: Name of Egress-TE backup path.
                type: str
                required: true
              ip_forward:
                description: Use IP-forward backup path for Egress TE.
                type: dict
                suboptions:
                  set:
                    description: Set use IP-forward backup path for Egress TE.
                    type: bool
                  rti_name:
                    description: Routing-instance to use as IP forward backup-path.
                    type: str
              peers:
                description: Specify address of BGP peer to use as backup next-hop.
                type: list
                elements: str
              remote_nexthop:
                description: Specify address of remote-nexthop to use as backup path.
                type: str
      egress_te_set_segment:
        description: Configure BGP-Peer-Set segment.
        type: list
        elements: dict
        suboptions:
          name:
            description: The BGP-Peer-Set segment name.
            type: str
            required: true
          label:
            description: Backup segment label value from static label pool.
            type: int
          egress_te_backup_segment_label:
            description: BGP-Peer-Set SID label value from static label pool.
            type: int
      egress_te_sid_stats:
        description: Create BGP-Peer-SID sensor.
        type: bool
      enforce_first_as: &enforce_first_as
        description: Enforce neighbor AS is the first AS in AS-PATH attribute (EBGP).
        type: bool
      export: &export
        description: Specify export policy.
        type: str
      forwarding_context: &forwarding_context
        description: Specify routing-instance used for data-forwarding and transport-session.
        type: str
      graceful_restart: &graceful_restart
        description: BGP graceful restart options.
        type: dict
        suboptions:
          set:
            description: Set BGP graceful restart options.
            type: bool
          disable:
            description: Disable graceful restart.
            type: bool
          dont_help_shared_fate_bfd_down:
            description: Honor BFD-Down(C=0) if GR-restart not in progress.
            type: bool
          forwarding_state_bit:
            description: Control forwarding-state flag negotiation.
            type: dict
            suboptions:
              as_rr_client:
                description: As for a route reflector client.
                type: bool
              from_fib:
                description: Always use state of associated FIB(s).
                type: bool
          long_lived:
            description: Long-lived graceful restart options.
            type: dict
            suboptions:
              advertise_to_non_llgr_neighbor:
                description: Advertise stale routes to non-LLGR neighbors.
                type: dict
                suboptions:
                  set:
                    description: Set Advertise stale routes to non-LLGR neighbors.
                    type: bool
                  omit_no_export:
                    description: Set Advertise stale routes to non-LLGR neighbors.
                    type: bool
              receiver_disable:
                description: Disable receiver (helper) functionality.
                type: bool
          restart_time:
            description: Restart time used when negotiating with a peer.
            type: int
          stale_routes_time:
            description: Maximum time for which stale routes are kept.
            type: int
      hold_time: &hold_time
        description: Specify hold time used when negotiating with a peer.
        type: int
      holddown_all_stale_labels:
        description: Hold all BGP stale-labels, facilating make-before-break for new label advertisements.
        type: bool
      idle_after_switch_over: &idle_after_switch_over
        description: Stop peer session from coming up after nonstop-routing switch-over.
        type: dict
        suboptions:
          timeout:
            description: Specify timeout value, in seconds, for starting peer after switch over.
            type: int
          forever:
            description: Idle the peer until the user intervenes.
            type: bool
      import: &import
        description: Specify import policy.
        type: list
        elements: str
      include_mp_next_hop: &include_mp_next_hop
        description: Include NEXT-HOP attribute in multiprotocol updates.
        type: bool
      ipsec_sa: &ipsec_sa
        description: Specify IPSec SA name.
        type: str
      keep: &keep
        description: Specify how to retain routes in the routing table.
        type: str
        choices: ["all", "none"]
      local_address: &local_address
        description: Specify Address of local end of BGP session.
        type: str
      local_as: &local_as
        description: Local autonomous system number.
        type: dict
        suboptions:
          as_num:
            description: Autonomous system number in plain number or (asdot notation) format.
            type: str
            required: true
          alias:
            description: Treat this AS as an alias to the system AS.
            type: bool
          loops:
            description: Maximum number of times this AS can be in an AS path.
            type: int
          no_prepend_global_as:
            description: Maximum number of times this AS can be in an AS path.
            type: bool
          private:
            description: Hide this local AS in paths learned from this peering.
            type: bool
      local_interface: &local_interface
        description: Specify Local interface for IPv6 link local EBGP peering.
        type: str
      local_preference: &local_preference
        description: Specify value of LOCAL_PREF path attribute.
        type: str
      log_updown: &log_updown
        description: Enable log a message for peer state transitions.
        type: bool
      metric_out: &metric_out
        description: Specify route metric sent in MED.
        type: dict
        suboptions:
          metric_value:
            description: Specify metric value.
            type: int
          igp:
            description: Track the IGP metric.
            type: dict
            suboptions:
              set:
                description: Set track the IGP metric.
                type: bool
              metric_offset:
                description: Specify metric offset for MED.
                type: int
              delay_med_update:
                description: Delay updating MED when IGP metric increases.
                type: bool
          minimum_igp:
            description: Track the minimum IGP metric.
            type: dict
            suboptions:
              set:
                description: Set track the minimum IGP metric.
                type: bool
              metric_offset:
                description: Specify metric offset for MED.
                type: int
      mtu_discovery: &mtu_discovery
        description: Enable TCP path MTU discovery.
        type: bool
      multihop: &multihop
        description: Configure an EBGP multihop session.
        type: dict
        suboptions:
          set:
            description: Set an EBGP multihop session.
            type: bool
          no_nexthop_change:
            description: Do not change next hop to self in advertisements.
            type: bool
          ttl:
            description: TTL value for the session.
            type: int
      multipath: &multipath
        description: Allow load sharing among multiple BGP paths.
        type: dict
        suboptions:
          set:
            description: Set allow load sharing among multiple BGP paths.
            type: bool
          disable:
            description: Disable Multipath.
            type: bool
          multiple_as:
            description: Use paths received from different ASs.
            type: bool
          multiple_as_disable:
            description: Disable multipath.
            type: bool
      multipath_build_priority:
        description: Configure the multipath build priority.
        type: str
        choices: ["low", "medium"]
      no_advertise_peer_as: &no_advertise_peer_as
        description: Allows to not advertise routes received from the same autonomous system.
        type: bool
      no_aggregator_id: &no_aggregator_id
        description: Set router ID in aggregator path attribute to 0.
        type: bool
      no_client_reflect: &no_client_reflect
        description: Disable intracluster route redistribution.
        type: bool
      no_precision_timers: &no_precision_timers
        description: Specify not to use precision timers for scheduling keepalives.
        type: bool
      out_delay: &out_delay
        description: Specify how long before exporting routes from routing table.
        type: int
      outbound_route_filter: &outbound_route_filter
        description: Dynamically negotiated cooperative route filtering.
        type: dict
        suboptions:
          bgp_orf_cisco_mode:
            description: Using BGP ORF capability code 130 and Prefix ORF type 128.
            type: bool
          prefix_based:
            description: Prefix-based outbound route filtering.
            type: dict
            suboptions:
              set:
                description: Set prefix-based outbound route filtering.
                type: bool
              accept:
                description: Honor Prefix-based ORFs from remote peers.
                type: dict
                suboptions:
                  set:
                    description: Set honor Prefix-based ORFs from remote peers.
                    type: bool
                  inet:
                    description: Honor IPv4 prefix filters.
                    type: bool
                  inet6:
                    description: Honor IPv6 prefix filters.
                    type: bool
      output_queue_priority:
        description: BGP output queue priority scheduler for updates.
        type: dict
        suboptions:
          defaults:
            description: Map policy's priority class and BGP output-queue.
            type: dict
            suboptions:
              high:
                description: Assign the 'high' priority class to this output-queue.
                type: dict
                suboptions:
                  expedited:
                    description: Expedited queue; highest priority.
                    type: bool
                  priority:
                    description: Specify output queue priorit.
                    type: int
              low:
                description: Assign the 'low' priority class to this output-queue.
                type: dict
                suboptions:
                  expedited:
                    description: Expedited queue; highest priority.
                    type: bool
                  priority:
                    description: Specify output queue priorit.
                    type: int
              medium:
                description: Assign the 'medium' priority class to this output-queue.
                type: dict
                suboptions:
                  expedited:
                    description: Expedited queue; highest priority.
                    type: bool
                  priority:
                    description: Specify output queue priorit.
                    type: int
          expedited_update_tokens:
            description: Expedited queue; highest priority for number of tokens.
            type: int
          priority_update_tokens:
            description: Output queue priority; higher is better.
            type: list
            elements: dict
            suboptions:
              priority:
                description: Specify the priority.
                type: int
                required: true
              update_tokens:
                description: Specify update_tokens.
                type: int
                required: true
      passive: &passive
        description: Specify to not send open messages to a peer.
        type: bool
      path_selection:
        description: Configure path selection strategy.
        type: dict
        suboptions:
          always_compare_med:
            description: Compare MED on paths from different AS.
            type: bool
          as_path_ignore:
            description: Ignore AS path comparison during path selection.
            type: bool
          cisco_non_deterministic:
            description: Use Cisco IOS nondeterministic path selection algorithm.
            type: bool
          external_router_id:
            description: Compare router ID on BGP externals.
            type: bool
          l2vpn_use_bgp_rules:
            description:  Use standard BGP rules during L2VPN path selection.
            type: bool
          med_plus_igp:
            description: Add IGP cost to next-hop to MED before comparing MED values.
            type: dict
            suboptions:
              set:
                description: Set med-plus-igp attribute.
                type: bool
              igp_multiplier:
                description: Specify multiplier for IGP cost to next-hop.
                type: int
              med_multiplier:
                description: Specify Multiplier for MED.
                type: int
      peer_as: &peer_as
        description: Specify Autonomous system number in plain number or 'higher 16bits'.'Lower 16 bits' format.
        type: str
      precision_timers:
        description: Use precision timers for scheduling keepalives.
        type: bool
      preference: &preference
        description: Specify preference value.
        type: str
      remove_private: &remove_private
        description: Remove well-known private AS numbers.
        type: dict
        suboptions:
          set:
            description: Remove well-known private AS numbers.
            type: bool
          all:
            description: Remove all private AS numbers and do not stop at the first public AS number.
            type: bool
          all_replace:
            description: Specify private AS replacement.
            type: bool
          all_replace_nearest:
            description: Use closest public AS number to replace a private AS number.
            type: bool
          no_peer_loop_check:
            description: Remove peer loop-check.
            type: bool
      rfc6514_compliant_safi129: &rfc6514_compliant_safi129
        description: Specify Compliance with RFC6514 SAFI129 format.
        type: bool
      route_server_client: &route_server_client
        description: Enable route server client behavior.
        type: bool
      send_addpath_optimization:
        description: Enable BGP addpath advertisement optimization.
        type: bool
      snmp_options:
        description: Customize SNMP behaviors specifically for BGP MIBs.
        type: dict
        suboptions:
          backward_traps_only_from_established:
            description: Limit traps for backward transitions to only those moving from Established state.
            type: bool
          emit_inet_address_length_in_oid:
            description: Emit Length in OID for InetAddress MIB type.
            type: bool
      sr_preference_override:
        description: Replace received segment routing traffic engineering preference value with override value.
        type: str
      stale_labels_holddown_period:
        description: Specify duration (sec) MPLS labels allocated by BGP are kept after they go stale.
        type: int
      tcp_aggressive_transmission: &tcp_aggressive_transmission
        description: Enable aggressive transmission of pure TCP ACKs and retransmissions.
        type: bool
      tcp_mss: &tcp_mss
        description: Specify maximum TCP segment size.
        type: int
      traceoptions: &traceoptions
        description: Configure trace options for BGP.
        type: dict
        suboptions:
          file:
            description: Specify trace file options.
            type: dict
            suboptions:
              filename:
                description: Specify name of file in which to write trace information.
                type: str
                required: true
              files:
                description: Specify maximum number of trace files.
                type: int
              no_world_readable:
                description: Don't allow any user to read the log file.
                type: bool
              world_readable:
                description: Allow any user to read the log file.
                type: bool
              size:
                description: Specify maximum trace file size.
                type: int
          flag:
            description: Specify tracing parameters.
            type: list
            elements: dict
            suboptions:
              name:
                description: specify event name
                type: str
                choices:
                  - 4byte-as
                  - add-path
                  - all
                  - bfd
                  - damping
                  - egress-te
                  - general
                  - graceful-restart
                  - keepalive
                  - normal
                  - nsr-synchronization
                  - open
                  - packets
                  - policy
                  - refresh
                  - route
                  - state
                  - task
                  - thread-io
                  - thread-update-io
                  - timer
                  - update
                required: true
              detail:
                description: Trace detailed information.
                type: bool
              disable:
                description: Disable this trace flag.
                type: bool
              receive:
                description: Trace received packets.
                type: bool
              send:
                description: Trace transmitted packets.
                type: bool
              filter:
                description: Filter to apply to this flag.
                type: dict
                suboptions:
                  set:
                    description: Set filter to apply to this flag.
                    type: bool
                  match_on_prefix:
                    description: Specify filter based on prefix.
                    type: bool
                  policy:
                    description: Specify filter policy.
                    type: str
      traffic_statistics_labeled_path:
        description: Collect periodic ingress labeled statistics for BGP label-switched paths.
        type: dict
        suboptions:
          file:
            description: Specify statistics file options.
            type: dict
            suboptions:
              filename:
                description: Specify name of file in which to write trace information.
                type: str
              files:
                description: Specify maximum number of trace files.
                type: int
              no_world_readable:
                description: Don't allow any user to read the log file.
                type: bool
              world_readable:
                description: Allow any user to read the log file.
                type: bool
              size:
                description: Specify maximum trace file size.
                type: int
          interval:
            description: Specify time interval to collect statistics.
            type: int
      ttl: &ttl
        description: Specify TTL value for the single-hop peer.
        type: int
      unconfigured_peer_graceful_restart:
        description: Specify BGP unconfigured peer graceful restart options.
        type: bool
      vpn_apply_export:
        description: Apply BGP export policy when exporting VPN routes.
        type: bool
      groups:
        description: Specify name of the group.
        type: list
        elements: dict
        suboptions:
          name:
            description: Specify the name of the group
            type: str
          accept_remote_nexthop: *accept_remote_nexthop
          add_path_display_ipv4_address: *add_path_display_ipv4_address
          advertise_bgp_static: *advertise_bgp_static
          advertise_external: *advertise_external
          advertise_inactive: *advertise_inactive
          advertise_peer_as: *advertise_peer_as
          allow:
            description: Configure peer connections for specific networks.
            type: list
            elements: str
          as_override: &as_override
            description: Replace neighbor AS number with our AS number
            type: bool
          authentication_algorithm: *authentication_algorithm
          authentication_key: *authentication_key
          authentication_key_chain: *authentication_key_chain
          bfd_liveness_detection: *bfd_liveness_detection
          bgp_error_tolerance: *bgp_error_tolerance
          bmp: *bmp
          cluster_id: *cluster_id
          damping: *damping
          description: *description
          egress_te: *egress_te
          enforce_first_as: *enforce_first_as
          export: *export
          forwarding_context: *forwarding_context
          graceful_restart: *graceful_restart
          hold_time: *hold_time
          idle_after_switch_over: *idle_after_switch_over
          import: *import
          include_mp_next_hop: *include_mp_next_hop
          ipsec_sa: *ipsec_sa
          keep: *keep
          local_address: *local_address
          local_as: *local_as
          local_interface: *local_interface
          local_preference: *local_preference
          log_updown: *log_updown
          metric_out: *metric_out
          mtu_discovery: *mtu_discovery
          multihop: *multihop
          multipath: *multipath
          no_advertise_peer_as: *no_advertise_peer_as
          no_aggregator_id: *no_aggregator_id
          no_client_reflect: *no_client_reflect
          optimal_route_reflection:
            description:  Enable optimal route reflection for this client group.
            type: dict
            suboptions:
              igp_backup:
                description: Backup node identifier for this client group.
                type: str
              igp_primary:
                description: Primary node identifier for this client group.
                type: str
          out_delay: *out_delay
          outbound_route_filter: *outbound_route_filter
          passive: *passive
          peer_as: *peer_as
          preference: *preference
          remove_private: *remove_private
          rfc6514_compliant_safi129: *rfc6514_compliant_safi129
          route_server_client: *route_server_client
          tcp_aggressive_transmission: *tcp_aggressive_transmission
          tcp_mss: *tcp_mss
          traceoptions: *traceoptions
          ttl: *ttl
          type:
            description: Specify BGP group type.
            type: str
            choices: ['external', 'internal']
          unconfigured_peer_graceful_restart: &unconfigured_peer_graceful_restart
            description: Specify BGP unconfigured peer graceful restart options.
            type: bool
          vpn_apply_export: &vpn_apply_export
            description: Apply BGP export policy when exporting VPN routes.
            type: bool
          neighbors:
            description: Specify list of neighbors.
            type: list
            elements: dict
            suboptions:
              neighbor_address:
                description: Specify neighbor address.
                type: str
              accept_remote_nexthop: *accept_remote_nexthop
              add_path_display_ipv4_address: *add_path_display_ipv4_address
              advertise_bgp_static: *advertise_bgp_static
              advertise_external: *advertise_external
              advertise_inactive: *advertise_inactive
              advertise_peer_as: *advertise_peer_as
              as_override: *as_override
              authentication_algorithm: *authentication_algorithm
              authentication_key: *authentication_key
              authentication_key_chain: *authentication_key_chain
              bfd_liveness_detection: *bfd_liveness_detection
              bgp_error_tolerance: *bgp_error_tolerance
              bmp: *bmp
              cluster_id: *cluster_id
              damping: *damping
              description:
                description: Specify neighbor description.
                type: str
              egress_te: *egress_te
              enforce_first_as: *enforce_first_as
              export: *export
              forwarding_context: *forwarding_context
              graceful_restart: *graceful_restart
              hold_time: *hold_time
              idle_after_switch_over: *idle_after_switch_over
              import: *import
              include_mp_next_hop: *include_mp_next_hop
              ipsec_sa: *ipsec_sa
              keep: *keep
              local_address: *local_address
              local_as: *local_as
              local_interface: *local_interface
              local_preference: *local_preference
              log_updown: *log_updown
              metric_out: *metric_out
              mtu_discovery: *mtu_discovery
              multihop: *multihop
              multipath: *multipath
              no_advertise_peer_as: *no_advertise_peer_as
              no_aggregator_id: *no_aggregator_id
              no_client_reflect: *no_client_reflect
              out_delay: *out_delay
              outbound_route_filter: *outbound_route_filter
              passive: *passive
              peer_as: *peer_as
              preference: *preference
              remove_private: *remove_private
              rfc6514_compliant_safi129: *rfc6514_compliant_safi129
              route_server_client: *route_server_client
              tcp_aggressive_transmission: *tcp_aggressive_transmission
              tcp_mss: *tcp_mss
              traceoptions: *traceoptions
              ttl: *ttl
              unconfigured_peer_graceful_restart: *unconfigured_peer_graceful_restart
              vpn_apply_export: *vpn_apply_export

  state:
    description:
    - The state the configuration should be left in.
    - State I(purged) removes all (routing-options autonomous-system, bgp global, bgp groups, bgp neighbors, bgp family
      and bgp group and neighbor family) the BGP configurations from the
      target device. Use caution with this state.
    - State I(deleted) only removes BGP attributes that this modules
      manages and does not negate the BGP process completely. Thereby, preserving
      address-family related configurations under BGP context.
    - Running states I(deleted) and I(replaced) will result in an error if there
      are address-family configuration lines present under a neighbor.Please use the
      M(junipernetworks.junos.junos_bgp_address_family)
      modules for prior cleanup.
    - Refer to examples for more details.
    type: str
    choices:
      - purged
      - merged
      - replaced
      - deleted
      - gathered
      - parsed
      - rendered
    default: merged
"""
EXAMPLES = """
# Using merged
#
# Before state
# ------------
#
# admin# show protocols bgp
# [edit]

# admin# show routing-options autonomous-system
# [edit]

- name: Merge Junos BGP config
  junipernetworks.junos.junos_bgp_global:
    config:
      as_number: "65534"
      loops: 3
      asdot_notation: true
      accept_remote_nexthop: true
      add_path_display_ipv4_address: true
      advertise_bgp_static:
        policy: "static-to-bgp"
      advertise_from_main_vpn_tables: true
      advertise_inactive: true
      authentication_algorithm: "md5"
      bgp_error_tolerance:
        malformed_route_limit: 20000000
      bmp:
        monitor: true
      damping: true
      description: "This is configured with Junos_bgp resource module"
      egress_te_sid_stats: true
      hold_time: 5
      holddown_all_stale_labels: true
      include_mp_next_hop: true
      log_updown: true
      no_advertise_peer_as: true
      no_aggregator_id: true
      no_client_reflect: true
      out_delay: 10
      precision_timers: true
      preference: 2
    state: merged

# After state
# -----------
#
# admin# show routing-options autonomous-system
# 65534 loops 3 asdot-notation;

# admin# show protocols bgp
# precision-timers;
# advertise-from-main-vpn-tables;
# holddown-all-stale-labels;
# description "This is configured with Junos_bgp resource module";
# accept-remote-nexthop;
# preference 2;
# hold-time 5;
# advertise-inactive;
# no-advertise-peer-as;
# no-aggregator-id;
# out-delay 10;
# log-updown;
# damping;
# bgp-error-tolerance {
#     malformed-route-limit 20000000;
# }
# authentication-algorithm md5;
# no-client-reflect;
# include-mp-next-hop;
# bmp {
#     monitor enable;
# }
# advertise-bgp-static {
#     policy static-to-bgp;
# }
# add-path-display-ipv4-address;
# egress-te-sid-stats;


# Using merged
#
# Before state
# ------------
#
# admin# show routing-options autonomous-system
# 65534 loops 3 asdot-notation;

# admin# show protocols bgp
# precision-timers;
# advertise-from-main-vpn-tables;
# holddown-all-stale-labels;
# description "This is configured with Junos_bgp resource module";
# accept-remote-nexthop;
# preference 2;
# hold-time 5;
# advertise-inactive;
# no-advertise-peer-as;
# no-aggregator-id;
# out-delay 10;
# log-updown;
# damping;
# bgp-error-tolerance {
#     malformed-route-limit 20000000;
# }
# authentication-algorithm md5;
# no-client-reflect;
# include-mp-next-hop;
# bmp {
#     monitor enable;
# }
# advertise-bgp-static {
#     policy static-to-bgp;
# }
# add-path-display-ipv4-address;
# egress-te-sid-stats;

- name: Update running Junos BGP config
  junipernetworks.junos.junos_bgp_global:
    config:
      egress_te_backup_paths:
        templates:
          - path_name: customer1
            peers:
              - '11.11.11.11'
              - '11.11.11.12'
              - '11.11.11.13'
            remote_nexthop: '2.2.2.2'
      groups:
        - name: 'internal'
          type: 'internal'
          vpn_apply_export: true
          out_delay: 30
          accept_remote_nexthop: true
          add_path_display_ipv4_address: true
          peer_as: '65534'
          allow:
            - 'all'
            - '1.1.1.0/24'
          neighbors:
            - neighbor_address: '11.11.11.11'
              peer_as: '65534'
              out_delay: 11
            - neighbor_address: '11.11.11.12'
              peer_as: '65534'
              out_delay: 12

        - name: 'external'
          out_delay: 20
          peer_as: '65534'
          accept_remote_nexthop: true
          add_path_display_ipv4_address: true
          neighbors:
            - neighbor_address: '12.12.12.12'
              peer_as: '65534'
              out_delay: 21
              accept_remote_nexthop: true
              add_path_display_ipv4_address: true
            - neighbor_address: '11.11.11.13'
              peer_as: '65534'
              out_delay: 31
              accept_remote_nexthop: true
              add_path_display_ipv4_address: true
    state: merged

# After state
# -----------
#
# admin# show routing-options autonomous-system
# 65534 loops 3 asdot-notation;

# admin# show protocols bgp
# precision-timers;
# advertise-from-main-vpn-tables;
# holddown-all-stale-labels;
# egress-te-backup-paths {
#     template customer1 {
#         peer 11.11.11.11;
#         peer 11.11.11.12;
#         peer 11.11.11.13;
#         remote-nexthop {
#             2.2.2.2;
#         }
#     }
# }
# description "This is configured with Junos_bgp resource module";
# accept-remote-nexthop;
# preference 2;
# hold-time 5;
# advertise-inactive;
# no-advertise-peer-as;
# no-aggregator-id;
# out-delay 10;
# log-updown;
# damping;
# bgp-error-tolerance {
#     malformed-route-limit 20000000;
# }
# authentication-algorithm md5;
# no-client-reflect;
# include-mp-next-hop;
# bmp {
#     monitor enable;
# }
# add-path-display-ipv4-address;
# egress-te-sid-stats;
# group internal {
#     type internal;
#     accept-remote-nexthop;
#     out-delay 30;
#     vpn-apply-export;
#     peer-as 65534;
#     add-path-display-ipv4-address;
#     allow [ 0.0.0.0/0 1.1.1.0/24 ];
#     neighbor 11.11.11.11 {
#         out-delay 11;
#         peer-as 65534;
#     }
#     neighbor 11.11.11.12 {
#         out-delay 12;
#         peer-as 65534;
#     }
# }
# group external {
#     accept-remote-nexthop;
#     out-delay 20;
#     peer-as 65534;
#     add-path-display-ipv4-address;
#     neighbor 12.12.12.12 {
#         accept-remote-nexthop;
#         out-delay 21;
#         peer-as 65534;
#         add-path-display-ipv4-address;
#     }
#     neighbor 11.11.11.13 {
#         accept-remote-nexthop;
#         out-delay 31;
#         peer-as 65534;
#         add-path-display-ipv4-address;
#     }
# }


# Using replaced
#
# Before state
# ------------
#
# admin# show routing-options autonomous-system
# [edit]
# admin# show protocols bgp
# precision-timers;
# advertise-from-main-vpn-tables;
# holddown-all-stale-labels;
# description "This is configured with Junos_bgp resource module";
# accept-remote-nexthop;
# preference 2;
# hold-time 5;
# advertise-inactive;
# no-advertise-peer-as;
# no-aggregator-id;
# out-delay 10;
# log-updown;
# damping;
# bgp-error-tolerance {
#     malformed-route-limit 20000000;
# }
# authentication-algorithm md5;
# no-client-reflect;
# include-mp-next-hop;
# bmp {
#     monitor enable;
# }
# advertise-bgp-static {
#     policy static-to-bgp;
# }
# add-path-display-ipv4-address;
# egress-te-sid-stats;

- name: Replace Junos BGP global config
  junipernetworks.junos.junos_bgp_global:
   config:
     advertise_bgp_static:
       policy: "static-to-bgp"
     advertise_inactive: true
     authentication_algorithm: "md5"
     bfd_liveness_detection:
       minimum_receive_interval: 8
       multiplier: 30
       no_adaptation: true
       transmit_interval:
         minimum_interval: 4
       version: "automatic"
     bgp_error_tolerance:
       malformed_route_limit: 40000000
     description: "This is configured with Junos_bgp resource module replace"
     egress_te_sid_stats: true
     hold_time: 5
     out_delay: 10
     preference: "2"
   state: replaced

# After state
# -----------
#
# admin# show protocols bgp
# description "This is configured with Junos_bgp resource module replace";
# preference 2;
# hold-time 5;
# advertise-inactive;
# out-delay 10;
# bgp-error-tolerance {
#     malformed-route-limit 40000000;
# }
# authentication-algorithm md5;
# advertise-bgp-static {
#     policy static-to-bgp;
# }
# bfd-liveness-detection {
#     version automatic;
#     minimum-receive-interval 8;
#     multiplier 30;
#     no-adaptation;
#     transmit-interval {
#         minimum-interval 4;
#     }
# }
# egress-te-sid-stats;

# admin# show routing-options autonomous-system
# [edit]

#
# Using deleted
#
# Before state
# ------------
#
# admin# show protocols bgp
# precision-timers;
# advertise-from-main-vpn-tables;
# holddown-all-stale-labels;
# description "This is configured with Junos_bgp resource module";
# accept-remote-nexthop;
# preference 2;
# hold-time 5;
# advertise-inactive;
# no-advertise-peer-as;
# no-aggregator-id;
# out-delay 10;
# log-updown;
# damping;
# bgp-error-tolerance {
#     malformed-route-limit 20000000;
# }
# authentication-algorithm md5;
# no-client-reflect;
# include-mp-next-hop;
# bmp {
#     monitor enable;
# }
# add-path-display-ipv4-address;
# egress-te-sid-stats;
# group internal {
#     out-delay 12;
# }
# admin# show routing-options autonomous-system
# 65534 loops 3 asdot-notation;

- name: Delete Junos BGP global config
  junipernetworks.junos.junos_bgp_global:
    config:
    state: deleted

# After state
# -----------
# admin# show protocols bgp
# group internal {
#     out-delay 12;
# }



# admin# show protocols bgp
# [edit]

# admin# show routing-options autonomous-system
# [edit]
# Using gathered
#
# Before state
# ------------
#
# admin# show protocols bgp
# description "This is configured with Junos_bgp resource module replace";
# preference 2;
# hold-time 5;
# advertise-inactive;
# out-delay 10;
# bgp-error-tolerance {
#     malformed-route-limit 40000000;
# }
# authentication-algorithm md5;
# advertise-bgp-static {
#     policy static-to-bgp;
# }
# bfd-liveness-detection {
#     version automatic;
#     minimum-receive-interval 8;
#     multiplier 30;
#     no-adaptation;
#     transmit-interval {
#         minimum-interval 4;
#     }
# }
# egress-te-sid-stats;

- name: Gather Junos BGP global config
  junipernetworks.junos.junos_bgp_global:
    config:
    state: gathered
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#    "gathered": {
#         "advertise_bgp_static": {
#             "policy": "static-to-bgp"
#         },
#         "advertise_inactive": true,
#         "authentication_algorithm": "md5",
#         "bfd_liveness_detection": {
#             "minimum_receive_interval": 8,
#             "multiplier": 30,
#             "no_adaptation": true,
#             "transmit_interval": {
#                 "minimum_interval": 4
#             },
#             "version": "automatic"
#         },
#         "bgp_error_tolerance": {
#             "malformed_route_limit": 40000000
#         },
#         "description": "This is configured with Junos_bgp resource module replace",
#         "egress_te_sid_stats": true,
#         "hold_time": 5,
#         "out_delay": 10,
#         "preference": "2"
#     }
#
#
# Using purged
#
# Before state
# ------------
#
# admin# show protocols bgp
# precision-timers;
# advertise-from-main-vpn-tables;
# holddown-all-stale-labels;
# description "This is configured with Junos_bgp resource module";
# accept-remote-nexthop;
# preference 2;
# hold-time 5;
# advertise-inactive;
# no-advertise-peer-as;
# no-aggregator-id;
# out-delay 10;
# log-updown;
# damping;
# bgp-error-tolerance {
#     malformed-route-limit 20000000;
# }
# authentication-algorithm md5;
# no-client-reflect;
# include-mp-next-hop;
# bmp {
#     monitor enable;
# }
# add-path-display-ipv4-address;
# egress-te-sid-stats;
# group internal {
#     out-delay 12;
# }
# admin# show routing-options autonomous-system
# 65534 loops 3 asdot-notation;

- name: Purge Junos BGP global config
  junipernetworks.junos.junos_bgp_global:
    config:
    state: purged

# After state
# ----------
# admin# show protocols bgp
#
# [edit]
# admin# show routing-options autonomous-system
#
#[edit]


# Using rendered
#
#
- name: Render the commands for provided  configuration
  junipernetworks.junos.junos_bgp_global:
    config:
      authentication_algorithm: "md5"
      bfd_liveness_detection:
        minimum_receive_interval: 4
        multiplier: 10
        no_adaptation: true
        transmit_interval:
          minimum_interval: 2
        version: "automatic"
      bgp_error_tolerance:
        malformed_route_limit: 20000000
      bmp:
        monitor: true
      damping: true
      description: "This is configured with Junos_bgp resource module"
      egress_te_sid_stats: true
      hold_time: 5
    state: rendered

#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "rendered": "
# <nc:protocols
#     xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">
#     <nc:bgp>
#         <nc:damping/>
#         <nc:egress-te-sid-stats/>
#         <nc:authentication-algorithm>md5</nc:authentication-algorithm>
#         <nc:description>This is configured with Junos_bgp resource module</nc:description>
#         <nc:hold-time>5</nc:hold-time>
#         <nc:bfd-liveness-detection>
#             <nc:transmit-interval>
#                 <nc:minimum-interval>2</nc:minimum-interval>
#             </nc:transmit-interval>
#             <nc:minimum-receive-interval>4</nc:minimum-receive-interval>
#             <nc:multiplier>10</nc:multiplier>
#             <nc:no-adaptation/>
#             <nc:version>automatic</nc:version>
#         </nc:bfd-liveness-detection>
#         <nc:bgp-error-tolerance>
#             <nc:malformed-route-limit>20000000</nc:malformed-route-limit>
#         </nc:bgp-error-tolerance>
#         <nc:bmp>
#             <nc:monitor>enable</nc:monitor>
#         </nc:bmp>
#     </nc:bgp>
# </nc:protocols>"
#
# Using parsed
# parsed.cfg
# ------------
# <?xml version="1.0" encoding="UTF-8"?>
# <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
#    <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
#       <version>18.4R1-S2.4</version>
#       <protocols>
#          <bgp>
#             <precision-timers />
#             <advertise-from-main-vpn-tables />
#             <holddown-all-stale-labels />
#             <description>This is configured with Junos_bgp resource module</description>
#             <accept-remote-nexthop />
#             <preference>2</preference>
#             <hold-time>5</hold-time>
#             <advertise-inactive />
#             <no-advertise-peer-as />
#             <no-aggregator-id />
#             <out-delay>10</out-delay>
#             <log-updown />
#             <damping />
#             <bgp-error-tolerance>
#                <malformed-route-limit>20000000</malformed-route-limit>
#             </bgp-error-tolerance>
#             <authentication-algorithm>md5</authentication-algorithm>
#             <remove-private />
#             <no-client-reflect />
#             <include-mp-next-hop />
#             <bmp>
#                <monitor>disable</monitor>
#                <route-monitoring>
#                   <none />
#                </route-monitoring>
#             </bmp>
#             <advertise-bgp-static>
#                <policy>static-to-bgp</policy>
#             </advertise-bgp-static>
#             <add-path-display-ipv4-address />
#             <bfd-liveness-detection>
#                <version>automatic</version>
#                <minimum-receive-interval>4</minimum-receive-interval>
#                <multiplier>10</multiplier>
#                <no-adaptation />
#                <transmit-interval>
#                   <minimum-interval>2</minimum-interval>
#                </transmit-interval>
#                <detection-time>
#                   <threshold>300000</threshold>
#                </detection-time>
#             </bfd-liveness-detection>
#             <egress-te-sid-stats />
#             <group>
#                <name>internal</name>
#                <out-delay>8</out-delay>
#             </group>
#             <group>
#                <name>external</name>
#                <out-delay>9</out-delay>
#             </group>
#             <group>
#                <name>inboun</name>
#                <type>internal</type>
#             </group>
#             <group>
#                <name>ibgp</name>
#                <type>internal</type>
#                <local-address>10.2.2.2</local-address>
#                <export>static-to-bgp</export>
#                <neighbor>
#                   <name>10.1.1.1</name>
#                </neighbor>
#             </group>
#          </bgp>
#          <ospf3>
#             <area>
#                <name>0.0.0.100</name>
#                <stub>
#                   <default-metric>200</default-metric>
#                </stub>
#                <interface>
#                   <name>so-0/0/0.0</name>
#                   <metric>5</metric>
#                   <priority>3</priority>
#                </interface>
#             </area>
#          </ospf3>
#       </protocols>
#       <routing-options>
#          <static>
#             <route>
#                <name>172.16.17.0/24</name>
#                <discard />
#             </route>
#          </static>
#          <router-id>10.200.16.75</router-id>
#          <autonomous-system>
#             <as-number>65432</as-number>
#          </autonomous-system>
#       </routing-options>
#    </configuration>
# </rpc-reply>


- name: Parsed the device configuration to get output commands
  junipernetworks.junos.junos_bgp_global:
    running_config: "{{ lookup('file', './parsed.cfg') }}"
    state: parsed
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "parsed":  {
#         "accept_remote_nexthop": true,
#         "add_path_display_ipv4_address": true,
#         "advertise_bgp_static": {
#             "policy": "static-to-bgp"
#         },
#         "advertise_from_main_vpn_tables": true,
#         "advertise_inactive": true,
#         "as_number": "65432",
#         "authentication_algorithm": "md5",
#         "bfd_liveness_detection": {
#             "detection_time": {
#                 "threshold": 300000
#             },
#             "minimum_receive_interval": 4,
#             "multiplier": 10,
#             "no_adaptation": true,
#             "transmit_interval": {
#                 "minimum_interval": 2
#             },
#             "version": "automatic"
#         },
#         "bgp_error_tolerance": {
#             "malformed_route_limit": 20000000
#         },
#         "bmp": {
#             "monitor": false,
#             "route_monitoring": {
#                 "none": true
#             }
#         },
#         "damping": true,
#         "description": "This is configured with Junos_bgp resource module",
#         "egress_te_sid_stats": true,
#         "hold_time": 5,
#         "holddown_all_stale_labels": true,
#         "include_mp_next_hop": true,
#         "log_updown": true,
#         "no_advertise_peer_as": true,
#         "no_aggregator_id": true,
#         "no_client_reflect": true,
#         "out_delay": 10,
#         "precision_timers": true,
#         "preference": "2"
#     }
#

"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  type: dict
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
after:
  description: The resulting configuration model invocation.
  returned: when changed
  type: dict
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['
  <nc:protocols
    xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">
    <nc:bgp>
        <nc:damping/>
        <nc:egress-te-sid-stats/>
        <nc:authentication-algorithm>md5</nc:authentication-algorithm>
        <nc:description>This is configured with Junos_bgp resource module</nc:description>
        <nc:hold-time>5</nc:hold-time>
        <nc:bfd-liveness-detection>
            <nc:transmit-interval>
                <nc:minimum-interval>2</nc:minimum-interval>
            </nc:transmit-interval>
            <nc:minimum-receive-interval>4</nc:minimum-receive-interval>
            <nc:multiplier>10</nc:multiplier>
            <nc:no-adaptation/>
            <nc:version>automatic</nc:version>
        </nc:bfd-liveness-detection>
        <nc:bgp-error-tolerance>
            <nc:malformed-route-limit>20000000</nc:malformed-route-limit>
        </nc:bgp-error-tolerance>
        <nc:bmp>
            <nc:monitor>enable</nc:monitor>
        </nc:bmp>
    </nc:bgp>
  </nc:protocols>', 'xml 2', 'xml 3']
"""


from ansible.module_utils.basic import AnsibleModule

from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.argspec.bgp_global.bgp_global import (
    Bgp_globalArgs,
)
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.bgp_global.bgp_global import (
    Bgp_global,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]

    module = AnsibleModule(
        argument_spec=Bgp_globalArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
    )

    result = Bgp_global(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
