use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestUtil;
use Apache::TestRequest;

my $vars = Apache::Test::vars();

plan tests => 2, need $vars->{ssl_module_name}, need_lwp,
    qw(LWP::Protocol::https);

Apache::TestRequest::user_agent_keepalive(0);
Apache::TestRequest::scheme('https');
Apache::TestRequest::module('ssl_optional_cc');

my $r;

$r = GET "/require/none/";

ok t_cmp($r->code, 200, "access permitted without ccert");

$r = GET "/require/any/";

ok !t_cmp($r->code, 200, "access *not* permitted without ccert");
