/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgView;
import java.text.MessageFormat;
import java.util.ArrayList;

public class CreateViewParser {
    public static void parse(PgDatabase pgDatabase, String string) {
        Parser parser = new Parser(string);
        parser.expect("CREATE");
        parser.expectOptional("OR", "REPLACE");
        boolean bl = parser.expectOptional("MATERIALIZED");
        boolean bl2 = parser.expectOptional("TEMPORARY");
        boolean bl3 = parser.expectOptional("RECURSIVE");
        parser.expect("VIEW");
        String string2 = parser.parseIdentifier();
        StringBuilder stringBuilder = new StringBuilder();
        if (parser.expectOptional("WITH")) {
            parser.expect("(");
            while (!parser.expectOptional(")")) {
                stringBuilder.append(parser.getExpression());
            }
        }
        boolean bl4 = parser.expectOptional("(");
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (bl4) {
            while (!parser.expectOptional(")")) {
                arrayList.add(ParserUtils.getObjectName(parser.parseIdentifier()));
                parser.expectOptional(",");
            }
        }
        parser.expect("AS");
        String string3 = parser.getRest();
        PgView pgView = new PgView(ParserUtils.getObjectName(string2));
        pgView.setMaterialized(bl);
        pgView.setTemporary(bl2);
        pgView.setRecursive(bl3);
        pgView.setWith(stringBuilder.toString());
        pgView.setDeclaredColumnNames(arrayList);
        pgView.setQuery(string3);
        String string4 = ParserUtils.getSchemaName(string2, pgDatabase);
        PgSchema pgSchema = pgDatabase.getSchema(string4);
        if (pgSchema == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), string4, string));
        }
        pgSchema.addRelation(pgView);
    }

    private CreateViewParser() {
    }
}

