//
// Copyright © 2020 Arm Ltd and Contributors. All rights reserved.
// SPDX-License-Identifier: MIT
//

#include <catch.hpp>
#include <limits>

#include "Wav2LetterMFCC.hpp"

const std::vector<float> testWav = std::vector<float>
{
    -3.0f, 0.0f, 1.0f, -1.0f, 2.0f, 3.0f, -2.0f, 2.0f,
            1.0f, -2.0f, 0.0f, 3.0f, -1.0f, 8.0f, 3.0f, 2.0f,
            -1.0f, -1.0f, 2.0f, 7.0f, 3.0f, 5.0f, 6.0f, 6.0f,
            6.0f, 12.0f, 5.0f, 6.0f, 3.0f, 3.0f, 5.0f, 4.0f,
            4.0f, 6.0f, 7.0f, 7.0f, 7.0f, 3.0f, 7.0f, 2.0f,
            8.0f, 4.0f, 4.0f, 2.0f, -4.0f, -1.0f, -1.0f, -4.0f,
            2.0f, 1.0f, -1.0f, -4.0f, 0.0f, -7.0f, -6.0f, -2.0f,
            -5.0f, 1.0f, -5.0f, -1.0f, -7.0f, -3.0f, -3.0f, -7.0f,
            0.0f, -3.0f, 3.0f, -5.0f, 0.0f, 1.0f, -2.0f, -2.0f,
            -3.0f, -3.0f, -7.0f, -3.0f, -2.0f, -6.0f, -5.0f, -8.0f,
            -2.0f, -8.0f, 4.0f, -9.0f, -4.0f, -9.0f, -5.0f, -5.0f,
            -3.0f, -9.0f, -3.0f, -9.0f, -1.0f, -7.0f, -4.0f, 1.0f,
            -3.0f, 2.0f, -8.0f, -4.0f, -4.0f, -5.0f, 1.0f, -3.0f,
            -1.0f, 0.0f, -1.0f, -2.0f, -3.0f, -2.0f, -4.0f, -1.0f,
            1.0f, -1.0f, 3.0f, 0.0f, 3.0f, 2.0f, 0.0f, 0.0f,
            0.0f, -3.0f, 1.0f, 1.0f, 0.0f, 8.0f, 3.0f, 4.0f,
            1.0f, 5.0f, 6.0f, 4.0f, 7.0f, 3.0f, 3.0f, 0.0f,
            3.0f, 6.0f, 7.0f, 6.0f, 4.0f, 5.0f, 9.0f, 9.0f,
            5.0f, 5.0f, 8.0f, 1.0f, 6.0f, 9.0f, 6.0f, 6.0f,
            7.0f, 1.0f, 8.0f, 1.0f, 5.0f, 0.0f, 5.0f, 5.0f,
            0.0f, 3.0f, 2.0f, 7.0f, 2.0f, -3.0f, 3.0f, 0.0f,
            3.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, -1.0f, -1.0f,
            -2.0f, -3.0f, -8.0f, 0.0f, 1.0f, 0.0f, -3.0f, -3.0f,
            -3.0f, -2.0f, -3.0f, -3.0f, -4.0f, -6.0f, -2.0f, -8.0f,
            -9.0f, -4.0f, -1.0f, -5.0f, -3.0f, -3.0f, -4.0f, -3.0f,
            -6.0f, 3.0f, 0.0f, -1.0f, -2.0f, -9.0f, -4.0f, -2.0f,
            2.0f, -1.0f, 3.0f, -5.0f, -5.0f, -2.0f, 0.0f, -2.0f,
            0.0f, -1.0f, -3.0f, 1.0f, -2.0f, 9.0f, 4.0f, 5.0f,
            2.0f, 2.0f, 1.0f, 0.0f, -6.0f, -2.0f, 0.0f, 0.0f,
            0.0f, -1.0f, 4.0f, -4.0f, 3.0f, -7.0f, -1.0f, 5.0f,
            -6.0f, -1.0f, -5.0f, 4.0f, 3.0f, 9.0f, -2.0f, 1.0f,
            3.0f, 0.0f, 0.0f, -2.0f, 1.0f, 2.0f, 1.0f, 1.0f,
            0.0f, 3.0f, 2.0f, -1.0f, 3.0f, -3.0f, 7.0f, 0.0f,
            0.0f, 3.0f, 2.0f, 2.0f, -2.0f, 3.0f, -2.0f, 2.0f,
            -3.0f, 4.0f, -1.0f, -1.0f, -5.0f, -1.0f, -3.0f, -2.0f,
            1.0f, -1.0f, 3.0f, 2.0f, 4.0f, 1.0f, 2.0f, -2.0f,
            0.0f, 2.0f, 7.0f, 0.0f, 8.0f, -3.0f, 6.0f, -3.0f,
            6.0f, 1.0f, 2.0f, -3.0f, -1.0f, -1.0f, -1.0f, 1.0f,
            -2.0f, 2.0f, 1.0f, 2.0f, 0.0f, -2.0f, 3.0f, -2.0f,
            3.0f, -2.0f, 1.0f, 0.0f, -3.0f, -1.0f, -2.0f, -4.0f,
            -6.0f, -5.0f, -8.0f, -1.0f, -4.0f, 0.0f, -3.0f, -1.0f,
            -1.0f, -1.0f, 0.0f, -2.0f, -3.0f, -7.0f, -1.0f, 0.0f,
            1.0f, 5.0f, 0.0f, 5.0f, 1.0f, 1.0f, -3.0f, 0.0f,
            -6.0f, 3.0f, -8.0f, 4.0f, -8.0f, 6.0f, -6.0f, 1.0f,
            -6.0f, -2.0f, -5.0f, -6.0f, 0.0f, -5.0f, 4.0f, -1.0f,
            4.0f, -2.0f, 1.0f, 2.0f, 1.0f, 0.0f, -2.0f, 0.0f,
            0.0f, 2.0f, -2.0f, 2.0f, -5.0f, 2.0f, 0.0f, -2.0f,
            1.0f, -2.0f, 0.0f, 5.0f, 1.0f, 0.0f, 1.0f, 5.0f,
            0.0f, 8.0f, 3.0f, 2.0f, 2.0f, 0.0f, 5.0f, -2.0f,
            3.0f, 1.0f, 0.0f, 1.0f, 0.0f, -2.0f, -1.0f, -3.0f,
            1.0f, -1.0f, 3.0f, 0.0f, 3.0f, 0.0f, -2.0f, -1.0f,
            -4.0f, -4.0f, -4.0f, -1.0f, -4.0f, -4.0f, -3.0f, -6.0f,
            -3.0f, -7.0f, -3.0f, -1.0f, -2.0f, 0.0f, -5.0f, -4.0f,
            -7.0f, -3.0f, -2.0f, -2.0f, 1.0f, 2.0f, 2.0f, 8.0f,
            5.0f, 4.0f, 2.0f, 4.0f, 3.0f, 5.0f, 0.0f, 3.0f,
            3.0f, 6.0f, 4.0f, 2.0f, 2.0f, -2.0f, 4.0f, -2.0f,
            3.0f, 3.0f, 2.0f, 1.0f, 1.0f, 4.0f, -5.0f, 2.0f,
            -3.0f, 0.0f, -1.0f, 1.0f, -2.0f, 2.0f, 5.0f, 1.0f,
            4.0f, 2.0f, 3.0f, 1.0f, -1.0f, 1.0f, 0.0f, 6.0f,
            0.0f, -2.0f, -1.0f, 1.0f, -1.0f, 2.0f, -5.0f, -1.0f,
            -5.0f, -1.0f, -6.0f, -3.0f, -3.0f, 2.0f, 4.0f, 0.0f,
            -1.0f, -5.0f, 3.0f, -4.0f, -1.0f, -3.0f, -4.0f, 1.0f,
            -4.0f, 1.0f, -1.0f, -1.0f, 0.0f, -5.0f, -4.0f, -2.0f,
            -1.0f, -1.0f, -3.0f, -7.0f, -3.0f, -3.0f, 4.0f, 4.0f
};

TEST_CASE("Test MFCC")
{
    int sampFreq = 16000;
    int frameLenMs = 32;
    int frameLenSamples = sampFreq * frameLenMs * 0.001;
    int numMfccFeats = 13;

    std::vector<float> fullAudioData;

    for (auto f : testWav)
    {
        fullAudioData.emplace_back( f / (1<<15));
    }

    MfccParams mfccParams(sampFreq, 128, 0, 8000, numMfccFeats,
                          frameLenSamples, false, 1);

    Wav2LetterMFCC mfccInst = Wav2LetterMFCC(mfccParams);
    mfccInst.Init();
    auto mfccOutput = mfccInst.MfccCompute(fullAudioData);

    std::vector<float> expected = { -834.96564f, 21.02699f, 18.62856f, 7.3412f, 18.90791f, -5.36034f, 6.52351f,
                                    -11.27064f, 8.37522f, 12.0672f, 8.30833f, -13.50008f, -18.1761f};

    REQUIRE_THAT(mfccOutput, Catch::Approx(expected).epsilon(1.e-5) );
}