//
// Copyright © 2021 Arm Ltd and Contributors. All rights reserved.
// SPDX-License-Identifier: MIT
//

#include <vector>
#include <IMemoryOptimizerStrategy.hpp>

struct TestBlock
{
    std::string m_Name;
    std::vector<armnn::MemBlock>& m_Blocks;
};

// Generated from fsrcnn_720p.tflite
std::vector<armnn::MemBlock> fsrcnn
{
    { 0, 1, 691200, 0, 0 },
    { 1, 3, 7372800, 0, 1 },
    { 2, 5, 7372800, 0, 2 },
    { 3, 7, 1843200, 0, 3 },
    { 4, 9, 1843200, 0, 4 },
    { 5, 11, 1843200, 0, 5 },
    { 6, 13, 1843200, 0, 6 },
    { 7, 15, 1843200, 0, 7 },
    { 8, 17, 1843200, 0, 8 },
    { 9, 19, 7372800, 0, 9 },
    { 10, 21, 7372800, 0, 10 },
    { 11, 23, 2764800, 0, 11 },
    { 12, 25, 2764800, 0, 12 },
    { 13, 27, 2764800, 0, 13 }
};


// Generated from inception_v4_299_quant.tflite
std::vector<armnn::MemBlock> inceptionv4
{
    { 0, 1, 268203, 0, 0 },
    { 1, 5, 710432, 0, 1 },
    { 4, 9, 691488, 0, 4 },
    { 5, 12, 1382976, 0, 5 },
    { 6, 14, 341056, 0, 6 },
    { 7, 15, 511584, 0, 7 },
    { 8, 18, 852640, 0, 8 },
    { 9, 20, 341056, 0, 9 },
    { 10, 22, 341056, 0, 10 },
    { 12, 25, 341056, 0, 12 },
    { 13, 27, 341056, 0, 13 },
    { 11, 26, 483936, 0, 11 },
    { 14, 29, 483936, 0, 14 },
    { 15, 32, 967872, 0, 15 },
    { 17, 35, 235200, 0, 17 },
    { 16, 34, 235200, 0, 16 },
    { 18, 40, 470400, 0, 18 },
    { 21, 44, 78400, 0, 21 },
    { 22, 46, 78400, 0, 22 },
    { 19, 44, 470400, 0, 19 },
    { 24, 50, 117600, 0, 24 },
    { 20, 47, 117600, 0, 20 },
    { 23, 50, 117600, 0, 23 },
    { 26, 53, 117600, 0, 26 },
    { 25, 52, 117600, 0, 25 },
    { 27, 58, 470400, 0, 27 },
    { 30, 62, 78400, 0, 30 },
    { 31, 64, 78400, 0, 31 },
    { 28, 62, 470400, 0, 28 },
    { 33, 68, 117600, 0, 33 },
    { 29, 65, 117600, 0, 29 },
    { 32, 68, 117600, 0, 32 },
    { 35, 71, 117600, 0, 35 },
    { 34, 70, 117600, 0, 34 },
    { 36, 76, 470400, 0, 36 },
    { 39, 80, 78400, 0, 39 },
    { 40, 82, 78400, 0, 40 },
    { 37, 80, 470400, 0, 37 },
    { 42, 86, 117600, 0, 42 },
    { 38, 83, 117600, 0, 38 },
    { 41, 86, 117600, 0, 41 },
    { 44, 89, 117600, 0, 44 },
    { 43, 88, 117600, 0, 43 },
    { 45, 94, 470400, 0, 45 },
    { 48, 98, 78400, 0, 48 },
    { 49, 100, 78400, 0, 49 },
    { 46, 98, 470400, 0, 46 },
    { 51, 104, 117600, 0, 51 },
    { 47, 101, 117600, 0, 47 },
    { 50, 104, 117600, 0, 50 },
    { 53, 107, 117600, 0, 53 },
    { 52, 106, 117600, 0, 52 },
    { 54, 111, 470400, 0, 54 },
    { 57, 115, 235200, 0, 57 },
    { 58, 117, 274400, 0, 58 },
    { 56, 116, 110976, 0, 56 },
    { 59, 119, 73984, 0, 59 },
    { 55, 115, 110976, 0, 55 },
    { 60, 124, 295936, 0, 60 },
    { 63, 128, 55488, 0, 63 },
    { 64, 130, 55488, 0, 64 },
    { 61, 128, 295936, 0, 61 },
    { 65, 133, 64736, 0, 65 },
    { 66, 135, 55488, 0, 66 },
    { 69, 139, 64736, 0, 69 },
    { 70, 141, 64736, 0, 70 },
    { 62, 134, 110976, 0, 62 },
    { 68, 140, 73984, 0, 68 },
    { 71, 143, 73984, 0, 71 },
    { 67, 139, 36992, 0, 67 },
    { 72, 148, 295936, 0, 72 },
    { 75, 152, 55488, 0, 75 },
    { 76, 154, 55488, 0, 76 },
    { 73, 152, 295936, 0, 73 },
    { 77, 157, 64736, 0, 77 },
    { 78, 159, 55488, 0, 78 },
    { 81, 163, 64736, 0, 81 },
    { 82, 165, 64736, 0, 82 },
    { 74, 158, 110976, 0, 74 },
    { 80, 164, 73984, 0, 80 },
    { 83, 167, 73984, 0, 83 },
    { 79, 163, 36992, 0, 79 },
    { 84, 172, 295936, 0, 84 },
    { 87, 176, 55488, 0, 87 },
    { 88, 178, 55488, 0, 88 },
    { 85, 176, 295936, 0, 85 },
    { 89, 181, 64736, 0, 89 },
    { 90, 183, 55488, 0, 90 },
    { 93, 187, 64736, 0, 93 },
    { 94, 189, 64736, 0, 94 },
    { 86, 182, 110976, 0, 86 },
    { 92, 188, 73984, 0, 92 },
    { 95, 191, 73984, 0, 95 },
    { 91, 187, 36992, 0, 91 },
    { 96, 196, 295936, 0, 96 },
    { 99, 200, 55488, 0, 99 },
    { 100, 202, 55488, 0, 100 },
    { 97, 200, 295936, 0, 97 },
    { 101, 205, 64736, 0, 101 },
    { 102, 207, 55488, 0, 102 },
    { 105, 211, 64736, 0, 105 },
    { 106, 213, 64736, 0, 106 },
    { 98, 206, 110976, 0, 98 },
    { 104, 212, 73984, 0, 104 },
    { 107, 215, 73984, 0, 107 },
    { 103, 211, 36992, 0, 103 },
    { 108, 220, 295936, 0, 108 },
    { 111, 224, 55488, 0, 111 },
    { 112, 226, 55488, 0, 112 },
    { 109, 224, 295936, 0, 109 },
    { 113, 229, 64736, 0, 113 },
    { 114, 231, 55488, 0, 114 },
    { 117, 235, 64736, 0, 117 },
    { 118, 237, 64736, 0, 118 },
    { 110, 230, 110976, 0, 110 },
    { 116, 236, 73984, 0, 116 },
    { 119, 239, 73984, 0, 119 },
    { 115, 235, 36992, 0, 115 },
    { 120, 244, 295936, 0, 120 },
    { 123, 248, 55488, 0, 123 },
    { 124, 250, 55488, 0, 124 },
    { 121, 248, 295936, 0, 121 },
    { 125, 253, 64736, 0, 125 },
    { 126, 255, 55488, 0, 126 },
    { 129, 259, 64736, 0, 129 },
    { 130, 261, 64736, 0, 130 },
    { 122, 254, 110976, 0, 122 },
    { 128, 260, 73984, 0, 128 },
    { 131, 263, 73984, 0, 131 },
    { 127, 259, 36992, 0, 127 },
    { 132, 268, 295936, 0, 132 },
    { 135, 272, 55488, 0, 135 },
    { 136, 274, 55488, 0, 136 },
    { 133, 272, 295936, 0, 133 },
    { 137, 277, 64736, 0, 137 },
    { 138, 279, 55488, 0, 138 },
    { 141, 283, 64736, 0, 141 },
    { 142, 285, 64736, 0, 142 },
    { 134, 278, 110976, 0, 134 },
    { 140, 284, 73984, 0, 140 },
    { 143, 287, 73984, 0, 143 },
    { 139, 283, 36992, 0, 139 },
    { 144, 291, 295936, 0, 144 },
    { 146, 294, 55488, 0, 146 },
    { 147, 296, 73984, 0, 147 },
    { 149, 299, 73984, 0, 149 },
    { 150, 301, 92480, 0, 150 },
    { 148, 300, 12288, 0, 148 },
    { 151, 303, 20480, 0, 151 },
    { 145, 297, 65536, 0, 145 },
    { 152, 308, 98304, 0, 152 },
    { 155, 313, 24576, 0, 155 },
    { 156, 315, 24576, 0, 156 },
    { 153, 313, 98304, 0, 153 },
    { 157, 318, 16384, 0, 157 },
    { 158, 319, 16384, 0, 158 },
    { 159, 321, 28672, 0, 159 },
    { 162, 326, 32768, 0, 162 },
    { 163, 328, 16384, 0, 163 },
    { 164, 329, 16384, 0, 164 },
    { 154, 320, 16384, 0, 154 },
    { 161, 327, 32768, 0, 161 },
    { 165, 331, 32768, 0, 165 },
    { 160, 326, 16384, 0, 160 },
    { 166, 336, 98304, 0, 166 },
    { 169, 341, 24576, 0, 169 },
    { 170, 343, 24576, 0, 170 },
    { 167, 341, 98304, 0, 167 },
    { 171, 346, 16384, 0, 171 },
    { 172, 347, 16384, 0, 172 },
    { 173, 349, 28672, 0, 173 },
    { 176, 354, 32768, 0, 176 },
    { 177, 356, 16384, 0, 177 },
    { 178, 357, 16384, 0, 178 },
    { 168, 348, 16384, 0, 168 },
    { 175, 355, 32768, 0, 175 },
    { 179, 359, 32768, 0, 179 },
    { 174, 354, 16384, 0, 174 },
    { 180, 364, 98304, 0, 180 },
    { 183, 369, 24576, 0, 183 },
    { 184, 371, 24576, 0, 184 },
    { 181, 369, 98304, 0, 181 },
    { 185, 374, 16384, 0, 185 },
    { 186, 375, 16384, 0, 186 },
    { 187, 377, 28672, 0, 187 },
    { 190, 382, 32768, 0, 190 },
    { 191, 384, 16384, 0, 191 },
    { 192, 385, 16384, 0, 192 },
    { 182, 376, 16384, 0, 182 },
    { 189, 383, 32768, 0, 189 },
    { 193, 387, 32768, 0, 193 },
    { 188, 382, 16384, 0, 188 },
    { 194, 389, 98304, 0, 194 },
    { 195, 391, 1536, 0, 195 },
    { 196, 393, 1536, 0, 196 },
    { 197, 395, 1001, 0, 197 },
    { 198, 397, 1001, 0, 198 }
};

// Generated from deepspeechv1_float32.tflite
std::vector<armnn::MemBlock> deepspeechv1
{
    { 0, 3, 31616, 0, 0 },
    { 3, 39, 31616, 0, 3 },
    { 36, 73, 131072, 0, 36 },
    { 37, 75, 131072, 0, 37 },
    { 38, 77, 131072, 0, 38 },
    { 39, 79, 131072, 0, 39 },
    { 40, 81, 131072, 0, 40 },
    { 41, 83, 131072, 0, 41 },
    { 42, 85, 131072, 0, 42 },
    { 43, 87, 131072, 0, 43 },
    { 44, 89, 131072, 0, 44 },
    { 45, 91, 131072, 0, 45 },
    { 46, 93, 8192, 0, 46 },
    { 46, 94, 8192, 0, 47 },
    { 46, 95, 8192, 0, 48 },
    { 46, 96, 8192, 0, 49 },
    { 46, 97, 8192, 0, 50 },
    { 46, 98, 8192, 0, 51 },
    { 46, 99, 8192, 0, 52 },
    { 46, 100, 8192, 0, 53 },
    { 46, 101, 8192, 0, 54 },
    { 46, 102, 8192, 0, 55 },
    { 46, 103, 8192, 0, 56 },
    { 46, 104, 8192, 0, 57 },
    { 46, 105, 8192, 0, 58 },
    { 46, 106, 8192, 0, 59 },
    { 46, 107, 8192, 0, 60 },
    { 46, 108, 8192, 0, 61 },
    { 47, 110, 8192, 0, 62 },
    { 1, 64, 8192, 0, 1 },
    { 63, 127, 16384, 0, 78 },
    { 64, 129, 32768, 0, 79 },
    { 65, 131, 8192, 0, 82 },
    { 65, 132, 8192, 0, 80 },
    { 65, 133, 8192, 0, 81 },
    { 65, 134, 8192, 0, 83 },
    { 66, 136, 8192, 0, 84 },
    { 67, 138, 8192, 0, 85 },
    { 68, 139, 8192, 0, 86 },
    { 70, 142, 8192, 0, 88 },
    { 2, 74, 8192, 0, 2 },
    { 72, 145, 8192, 0, 90 },
    { 71, 144, 8192, 0, 89 },
    { 69, 144, 8192, 0, 87 },
    { 74, 149, 8192, 0, 92 },
    { 48, 124, 8192, 0, 63 },
    { 76, 153, 16384, 0, 94 },
    { 77, 155, 32768, 0, 95 },
    { 78, 157, 8192, 0, 98 },
    { 78, 158, 8192, 0, 96 },
    { 78, 159, 8192, 0, 97 },
    { 78, 160, 8192, 0, 99 },
    { 79, 162, 8192, 0, 100 },
    { 80, 164, 8192, 0, 101 },
    { 81, 165, 8192, 0, 102 },
    { 83, 168, 8192, 0, 104 },
    { 73, 158, 8192, 0, 91 },
    { 85, 171, 8192, 0, 106 },
    { 84, 170, 8192, 0, 105 },
    { 82, 170, 8192, 0, 103 },
    { 87, 175, 8192, 0, 108 },
    { 49, 138, 8192, 0, 64 },
    { 89, 179, 16384, 0, 110 },
    { 90, 181, 32768, 0, 111 },
    { 91, 183, 8192, 0, 114 },
    { 91, 184, 8192, 0, 112 },
    { 91, 185, 8192, 0, 113 },
    { 91, 186, 8192, 0, 115 },
    { 92, 188, 8192, 0, 116 },
    { 93, 190, 8192, 0, 117 },
    { 94, 191, 8192, 0, 118 },
    { 96, 194, 8192, 0, 120 },
    { 86, 184, 8192, 0, 107 },
    { 98, 197, 8192, 0, 122 },
    { 97, 196, 8192, 0, 121 },
    { 95, 196, 8192, 0, 119 },
    { 100, 201, 8192, 0, 124 },
    { 50, 152, 8192, 0, 65 },
    { 102, 205, 16384, 0, 126 },
    { 103, 207, 32768, 0, 127 },
    { 104, 209, 8192, 0, 130 },
    { 104, 210, 8192, 0, 128 },
    { 104, 211, 8192, 0, 129 },
    { 104, 212, 8192, 0, 131 },
    { 105, 214, 8192, 0, 132 },
    { 106, 216, 8192, 0, 133 },
    { 107, 217, 8192, 0, 134 },
    { 109, 220, 8192, 0, 136 },
    { 99, 210, 8192, 0, 123 },
    { 111, 223, 8192, 0, 138 },
    { 110, 222, 8192, 0, 137 },
    { 108, 222, 8192, 0, 135 },
    { 113, 227, 8192, 0, 140 },
    { 51, 166, 8192, 0, 66 },
    { 115, 231, 16384, 0, 142 },
    { 116, 233, 32768, 0, 143 },
    { 117, 235, 8192, 0, 146 },
    { 117, 236, 8192, 0, 144 },
    { 117, 237, 8192, 0, 145 },
    { 117, 238, 8192, 0, 147 },
    { 118, 240, 8192, 0, 148 },
    { 119, 242, 8192, 0, 149 },
    { 120, 243, 8192, 0, 150 },
    { 122, 246, 8192, 0, 152 },
    { 112, 236, 8192, 0, 139 },
    { 124, 249, 8192, 0, 154 },
    { 123, 248, 8192, 0, 153 },
    { 121, 248, 8192, 0, 151 },
    { 126, 253, 8192, 0, 156 },
    { 52, 180, 8192, 0, 67 },
    { 128, 257, 16384, 0, 158 },
    { 129, 259, 32768, 0, 159 },
    { 130, 261, 8192, 0, 162 },
    { 130, 262, 8192, 0, 160 },
    { 130, 263, 8192, 0, 161 },
    { 130, 264, 8192, 0, 163 },
    { 131, 266, 8192, 0, 164 },
    { 132, 268, 8192, 0, 165 },
    { 133, 269, 8192, 0, 166 },
    { 135, 272, 8192, 0, 168 },
    { 125, 262, 8192, 0, 155 },
    { 137, 275, 8192, 0, 170 },
    { 136, 274, 8192, 0, 169 },
    { 134, 274, 8192, 0, 167 },
    { 139, 279, 8192, 0, 172 },
    { 53, 194, 8192, 0, 68 },
    { 141, 283, 16384, 0, 174 },
    { 142, 285, 32768, 0, 175 },
    { 143, 287, 8192, 0, 178 },
    { 143, 288, 8192, 0, 176 },
    { 143, 289, 8192, 0, 177 },
    { 143, 290, 8192, 0, 179 },
    { 144, 292, 8192, 0, 180 },
    { 145, 294, 8192, 0, 181 },
    { 146, 295, 8192, 0, 182 },
    { 148, 298, 8192, 0, 184 },
    { 138, 288, 8192, 0, 171 },
    { 150, 301, 8192, 0, 186 },
    { 149, 300, 8192, 0, 185 },
    { 147, 300, 8192, 0, 183 },
    { 152, 305, 8192, 0, 188 },
    { 54, 208, 8192, 0, 69 },
    { 154, 309, 16384, 0, 190 },
    { 155, 311, 32768, 0, 191 },
    { 156, 313, 8192, 0, 194 },
    { 156, 314, 8192, 0, 192 },
    { 156, 315, 8192, 0, 193 },
    { 156, 316, 8192, 0, 195 },
    { 157, 318, 8192, 0, 196 },
    { 158, 320, 8192, 0, 197 },
    { 159, 321, 8192, 0, 198 },
    { 161, 324, 8192, 0, 200 },
    { 151, 314, 8192, 0, 187 },
    { 163, 327, 8192, 0, 202 },
    { 162, 326, 8192, 0, 201 },
    { 160, 326, 8192, 0, 199 },
    { 165, 331, 8192, 0, 204 },
    { 55, 222, 8192, 0, 70 },
    { 167, 335, 16384, 0, 206 },
    { 168, 337, 32768, 0, 207 },
    { 169, 339, 8192, 0, 210 },
    { 169, 340, 8192, 0, 208 },
    { 169, 341, 8192, 0, 209 },
    { 169, 342, 8192, 0, 211 },
    { 170, 344, 8192, 0, 212 },
    { 171, 346, 8192, 0, 213 },
    { 172, 347, 8192, 0, 214 },
    { 174, 350, 8192, 0, 216 },
    { 164, 340, 8192, 0, 203 },
    { 176, 353, 8192, 0, 218 },
    { 175, 352, 8192, 0, 217 },
    { 173, 352, 8192, 0, 215 },
    { 178, 357, 8192, 0, 220 },
    { 56, 236, 8192, 0, 71 },
    { 180, 361, 16384, 0, 222 },
    { 181, 363, 32768, 0, 223 },
    { 182, 365, 8192, 0, 226 },
    { 182, 366, 8192, 0, 224 },
    { 182, 367, 8192, 0, 225 },
    { 182, 368, 8192, 0, 227 },
    { 183, 370, 8192, 0, 228 },
    { 184, 372, 8192, 0, 229 },
    { 185, 373, 8192, 0, 230 },
    { 187, 376, 8192, 0, 232 },
    { 177, 366, 8192, 0, 219 },
    { 189, 379, 8192, 0, 234 },
    { 188, 378, 8192, 0, 233 },
    { 186, 378, 8192, 0, 231 },
    { 191, 383, 8192, 0, 236 },
    { 57, 250, 8192, 0, 72 },
    { 193, 387, 16384, 0, 238 },
    { 194, 389, 32768, 0, 239 },
    { 195, 391, 8192, 0, 242 },
    { 195, 392, 8192, 0, 240 },
    { 195, 393, 8192, 0, 241 },
    { 195, 394, 8192, 0, 243 },
    { 196, 396, 8192, 0, 244 },
    { 197, 398, 8192, 0, 245 },
    { 198, 399, 8192, 0, 246 },
    { 200, 402, 8192, 0, 248 },
    { 190, 392, 8192, 0, 235 },
    { 202, 405, 8192, 0, 250 },
    { 201, 404, 8192, 0, 249 },
    { 199, 404, 8192, 0, 247 },
    { 204, 409, 8192, 0, 252 },
    { 58, 264, 8192, 0, 73 },
    { 206, 413, 16384, 0, 254 },
    { 207, 415, 32768, 0, 255 },
    { 208, 417, 8192, 0, 258 },
    { 208, 418, 8192, 0, 256 },
    { 208, 419, 8192, 0, 257 },
    { 208, 420, 8192, 0, 259 },
    { 209, 422, 8192, 0, 260 },
    { 210, 424, 8192, 0, 261 },
    { 211, 425, 8192, 0, 262 },
    { 213, 428, 8192, 0, 264 },
    { 203, 418, 8192, 0, 251 },
    { 215, 431, 8192, 0, 266 },
    { 214, 430, 8192, 0, 265 },
    { 212, 430, 8192, 0, 263 },
    { 217, 435, 8192, 0, 268 },
    { 59, 278, 8192, 0, 74 },
    { 219, 439, 16384, 0, 270 },
    { 220, 441, 32768, 0, 271 },
    { 221, 443, 8192, 0, 274 },
    { 221, 444, 8192, 0, 272 },
    { 221, 445, 8192, 0, 273 },
    { 221, 446, 8192, 0, 275 },
    { 222, 448, 8192, 0, 276 },
    { 223, 450, 8192, 0, 277 },
    { 224, 451, 8192, 0, 278 },
    { 226, 454, 8192, 0, 280 },
    { 216, 444, 8192, 0, 267 },
    { 228, 457, 8192, 0, 282 },
    { 227, 456, 8192, 0, 281 },
    { 225, 456, 8192, 0, 279 },
    { 230, 461, 8192, 0, 284 },
    { 60, 292, 8192, 0, 75 },
    { 232, 465, 16384, 0, 286 },
    { 233, 467, 32768, 0, 287 },
    { 234, 469, 8192, 0, 290 },
    { 234, 470, 8192, 0, 288 },
    { 234, 471, 8192, 0, 289 },
    { 234, 472, 8192, 0, 291 },
    { 235, 474, 8192, 0, 292 },
    { 236, 476, 8192, 0, 293 },
    { 237, 477, 8192, 0, 294 },
    { 239, 480, 8192, 0, 296 },
    { 229, 470, 8192, 0, 283 },
    { 241, 483, 8192, 0, 298 },
    { 240, 482, 8192, 0, 297 },
    { 238, 482, 8192, 0, 295 },
    { 243, 487, 8192, 0, 300 },
    { 61, 306, 8192, 0, 76 },
    { 245, 491, 16384, 0, 302 },
    { 246, 493, 32768, 0, 303 },
    { 247, 495, 8192, 0, 306 },
    { 247, 496, 8192, 0, 304 },
    { 247, 497, 8192, 0, 305 },
    { 247, 498, 8192, 0, 307 },
    { 248, 500, 8192, 0, 308 },
    { 249, 502, 8192, 0, 309 },
    { 250, 503, 8192, 0, 310 },
    { 252, 506, 8192, 0, 312 },
    { 242, 496, 8192, 0, 299 },
    { 254, 509, 8192, 0, 314 },
    { 253, 508, 8192, 0, 313 },
    { 251, 508, 8192, 0, 311 },
    { 256, 513, 8192, 0, 316 },
    { 62, 320, 8192, 0, 77 },
    { 258, 517, 16384, 0, 318 },
    { 259, 519, 32768, 0, 319 },
    { 260, 521, 8192, 0, 322 },
    { 260, 522, 8192, 0, 320 },
    { 260, 523, 8192, 0, 321 },
    { 260, 524, 8192, 0, 323 },
    { 261, 526, 8192, 0, 324 },
    { 262, 528, 8192, 0, 325 },
    { 263, 529, 8192, 0, 326 },
    { 265, 532, 8192, 0, 328 },
    { 255, 522, 8192, 0, 315 },
    { 267, 535, 8192, 0, 330 },
    { 266, 534, 8192, 0, 329 },
    { 264, 534, 8192, 0, 327 },
    { 269, 539, 8192, 0, 332 },
    { 75, 346, 8192, 0, 93 },
    { 88, 359, 8192, 0, 109 },
    { 101, 372, 8192, 0, 125 },
    { 114, 385, 8192, 0, 141 },
    { 127, 398, 8192, 0, 157 },
    { 140, 411, 8192, 0, 173 },
    { 153, 424, 8192, 0, 189 },
    { 166, 437, 8192, 0, 205 },
    { 179, 450, 8192, 0, 221 },
    { 192, 463, 8192, 0, 237 },
    { 205, 476, 8192, 0, 253 },
    { 218, 489, 8192, 0, 269 },
    { 231, 502, 8192, 0, 285 },
    { 244, 515, 8192, 0, 301 },
    { 257, 528, 8192, 0, 317 },
    { 271, 543, 131072, 0, 334 },
    { 272, 545, 131072, 0, 335 },
    { 273, 547, 131072, 0, 336 },
    { 274, 549, 131072, 0, 337 },
    { 275, 551, 1856, 0, 338 },
    { 276, 553, 1856, 0, 339 },
    { 270, 548, 8192, 0, 333 },
    { 268, 547, 8192, 0, 331 }
};

// Generated from resnet_v2_50_default_minmax.tflite
std::vector<armnn::MemBlock> resnetv2
{
    { 0, 1, 150528, 0, 0 },
    { 1, 37, 802816, 0, 1 },
    { 36, 73, 200704, 0, 36 },
    { 37, 75, 200704, 0, 37 },
    { 38, 77, 200704, 0, 38 },
    { 39, 80, 200704, 0, 39 },
    { 41, 83, 200704, 0, 41 },
    { 42, 85, 200704, 0, 42 },
    { 43, 87, 200704, 0, 43 },
    { 44, 89, 200704, 0, 44 },
    { 40, 86, 802816, 0, 40 },
    { 45, 91, 802816, 0, 45 },
    { 47, 95, 802816, 0, 47 },
    { 48, 97, 802816, 0, 48 },
    { 49, 99, 802816, 0, 49 },
    { 50, 101, 200704, 0, 50 },
    { 51, 103, 200704, 0, 51 },
    { 52, 105, 200704, 0, 52 },
    { 53, 107, 200704, 0, 53 },
    { 46, 101, 802816, 0, 46 },
    { 54, 109, 802816, 0, 54 },
    { 55, 112, 802816, 0, 55 },
    { 56, 114, 802816, 0, 56 },
    { 58, 117, 802816, 0, 58 },
    { 59, 119, 802816, 0, 59 },
    { 60, 121, 200704, 0, 60 },
    { 61, 123, 200704, 0, 61 },
    { 62, 125, 50176, 0, 62 },
    { 63, 127, 50176, 0, 63 },
    { 57, 122, 200704, 0, 57 },
    { 64, 129, 200704, 0, 64 },
    { 65, 131, 200704, 0, 65 },
    { 66, 133, 200704, 0, 66 },
    { 67, 135, 200704, 0, 67 },
    { 68, 138, 200704, 0, 68 },
    { 70, 141, 100352, 0, 70 },
    { 71, 143, 100352, 0, 71 },
    { 72, 145, 100352, 0, 72 },
    { 73, 147, 100352, 0, 73 },
    { 69, 144, 401408, 0, 69 },
    { 74, 149, 401408, 0, 74 },
    { 76, 153, 401408, 0, 76 },
    { 77, 155, 401408, 0, 77 },
    { 78, 157, 401408, 0, 78 },
    { 79, 159, 100352, 0, 79 },
    { 80, 161, 100352, 0, 80 },
    { 81, 163, 100352, 0, 81 },
    { 82, 165, 100352, 0, 82 },
    { 75, 159, 401408, 0, 75 },
    { 83, 167, 401408, 0, 83 },
    { 85, 171, 401408, 0, 85 },
    { 86, 173, 401408, 0, 86 },
    { 87, 175, 401408, 0, 87 },
    { 88, 177, 100352, 0, 88 },
    { 89, 179, 100352, 0, 89 },
    { 90, 181, 100352, 0, 90 },
    { 91, 183, 100352, 0, 91 },
    { 84, 177, 401408, 0, 84 },
    { 92, 185, 401408, 0, 92 },
    { 93, 188, 401408, 0, 93 },
    { 94, 190, 401408, 0, 94 },
    { 96, 193, 401408, 0, 96 },
    { 97, 195, 401408, 0, 97 },
    { 98, 197, 100352, 0, 98 },
    { 99, 199, 100352, 0, 99 },
    { 100, 201, 25088, 0, 100 },
    { 101, 203, 25088, 0, 101 },
    { 95, 198, 100352, 0, 95 },
    { 102, 205, 100352, 0, 102 },
    { 103, 207, 100352, 0, 103 },
    { 104, 209, 100352, 0, 104 },
    { 105, 211, 100352, 0, 105 },
    { 106, 214, 100352, 0, 106 },
    { 108, 217, 50176, 0, 108 },
    { 109, 219, 50176, 0, 109 },
    { 110, 221, 50176, 0, 110 },
    { 111, 223, 50176, 0, 111 },
    { 107, 220, 200704, 0, 107 },
    { 112, 225, 200704, 0, 112 },
    { 114, 229, 200704, 0, 114 },
    { 115, 231, 200704, 0, 115 },
    { 116, 233, 200704, 0, 116 },
    { 117, 235, 50176, 0, 117 },
    { 118, 237, 50176, 0, 118 },
    { 119, 239, 50176, 0, 119 },
    { 120, 241, 50176, 0, 120 },
    { 113, 235, 200704, 0, 113 },
    { 121, 243, 200704, 0, 121 },
    { 123, 247, 200704, 0, 123 },
    { 124, 249, 200704, 0, 124 },
    { 125, 251, 200704, 0, 125 },
    { 126, 253, 50176, 0, 126 },
    { 127, 255, 50176, 0, 127 },
    { 128, 257, 50176, 0, 128 },
    { 129, 259, 50176, 0, 129 },
    { 122, 253, 200704, 0, 122 },
    { 130, 261, 200704, 0, 130 },
    { 132, 265, 200704, 0, 132 },
    { 133, 267, 200704, 0, 133 },
    { 134, 269, 200704, 0, 134 },
    { 135, 271, 50176, 0, 135 },
    { 136, 273, 50176, 0, 136 },
    { 137, 275, 50176, 0, 137 },
    { 138, 277, 50176, 0, 138 },
    { 131, 271, 200704, 0, 131 },
    { 139, 279, 200704, 0, 139 },
    { 141, 283, 200704, 0, 141 },
    { 142, 285, 200704, 0, 142 },
    { 143, 287, 200704, 0, 143 },
    { 144, 289, 50176, 0, 144 },
    { 145, 291, 50176, 0, 145 },
    { 146, 293, 50176, 0, 146 },
    { 147, 295, 50176, 0, 147 },
    { 140, 289, 200704, 0, 140 },
    { 148, 297, 200704, 0, 148 },
    { 149, 300, 200704, 0, 149 },
    { 150, 302, 200704, 0, 150 },
    { 152, 305, 200704, 0, 152 },
    { 153, 307, 200704, 0, 153 },
    { 154, 309, 50176, 0, 154 },
    { 155, 311, 50176, 0, 155 },
    { 156, 313, 12544, 0, 156 },
    { 157, 315, 12544, 0, 157 },
    { 151, 310, 50176, 0, 151 },
    { 158, 317, 50176, 0, 158 },
    { 159, 319, 50176, 0, 159 },
    { 160, 321, 50176, 0, 160 },
    { 161, 323, 50176, 0, 161 },
    { 162, 326, 50176, 0, 162 },
    { 164, 329, 25088, 0, 164 },
    { 165, 331, 25088, 0, 165 },
    { 166, 333, 25088, 0, 166 },
    { 167, 335, 25088, 0, 167 },
    { 163, 332, 100352, 0, 163 },
    { 168, 337, 100352, 0, 168 },
    { 170, 341, 100352, 0, 170 },
    { 171, 343, 100352, 0, 171 },
    { 172, 345, 100352, 0, 172 },
    { 173, 347, 25088, 0, 173 },
    { 174, 349, 25088, 0, 174 },
    { 175, 351, 25088, 0, 175 },
    { 176, 353, 25088, 0, 176 },
    { 169, 347, 100352, 0, 169 },
    { 177, 355, 100352, 0, 177 },
    { 179, 359, 100352, 0, 179 },
    { 180, 361, 100352, 0, 180 },
    { 181, 363, 100352, 0, 181 },
    { 182, 365, 25088, 0, 182 },
    { 183, 367, 25088, 0, 183 },
    { 184, 369, 25088, 0, 184 },
    { 185, 371, 25088, 0, 185 },
    { 178, 365, 100352, 0, 178 },
    { 186, 373, 100352, 0, 186 },
    { 187, 375, 100352, 0, 187 },
    { 188, 377, 100352, 0, 188 },
    { 189, 379, 100352, 0, 189 },
    { 190, 381, 100352, 0, 190 },
    { 191, 383, 2048, 0, 191 },
    { 192, 385, 1001, 0, 192 },
    { 193, 387, 1001, 0, 193 },
    { 194, 389, 1001, 0, 194 }

};

// Generated from yolov3_1080_1920_backbone_int8.tflite
std::vector<armnn::MemBlock> yolov3
{
    { 0, 1, 24883200, 0, 0 },
    { 1, 75, 6220800, 0, 1 },
    { 74, 150, 66355200, 0, 74 },
    { 75, 152, 66355200, 0, 75 },
    { 76, 154, 66355200, 0, 76 },
    { 77, 155, 66355200, 0, 77 },
    { 78, 157, 66355200, 0, 78 },
    { 79, 160, 33177600, 0, 79 },
    { 80, 162, 33177600, 0, 80 },
    { 81, 164, 33177600, 0, 81 },
    { 82, 165, 33177600, 0, 82 },
    { 84, 170, 16588800, 0, 84 },
    { 85, 172, 16588800, 0, 85 },
    { 86, 174, 16588800, 0, 86 },
    { 87, 175, 16588800, 0, 87 },
    { 88, 177, 16588800, 0, 88 },
    { 89, 180, 33177600, 0, 89 },
    { 90, 182, 33177600, 0, 90 },
    { 91, 184, 33177600, 0, 91 },
    { 92, 185, 33177600, 0, 92 },
    { 93, 187, 33177600, 0, 93 },
    { 83, 177, 33177600, 0, 83 },
    { 94, 189, 33177600, 0, 94 },
    { 95, 192, 16588800, 0, 95 },
    { 96, 194, 16588800, 0, 96 },
    { 97, 196, 16588800, 0, 97 },
    { 98, 197, 16588800, 0, 98 },
    { 100, 202, 8294400, 0, 100 },
    { 101, 204, 8294400, 0, 101 },
    { 102, 206, 8294400, 0, 102 },
    { 103, 207, 8294400, 0, 103 },
    { 104, 209, 8294400, 0, 104 },
    { 105, 212, 16588800, 0, 105 },
    { 106, 214, 16588800, 0, 106 },
    { 107, 216, 16588800, 0, 107 },
    { 108, 217, 16588800, 0, 108 },
    { 109, 219, 16588800, 0, 109 },
    { 99, 209, 16588800, 0, 99 },
    { 111, 224, 8294400, 0, 111 },
    { 112, 226, 8294400, 0, 112 },
    { 113, 228, 8294400, 0, 113 },
    { 114, 229, 8294400, 0, 114 },
    { 115, 231, 8294400, 0, 115 },
    { 116, 234, 16588800, 0, 116 },
    { 117, 236, 16588800, 0, 117 },
    { 118, 238, 16588800, 0, 118 },
    { 119, 239, 16588800, 0, 119 },
    { 120, 241, 16588800, 0, 120 },
    { 110, 231, 16588800, 0, 110 },
    { 121, 243, 16588800, 0, 121 },
    { 122, 246, 8294400, 0, 122 },
    { 123, 248, 8294400, 0, 123 },
    { 124, 250, 8294400, 0, 124 },
    { 125, 251, 8294400, 0, 125 },
    { 127, 256, 4147200, 0, 127 },
    { 128, 258, 4147200, 0, 128 },
    { 129, 260, 4147200, 0, 129 },
    { 130, 261, 4147200, 0, 130 },
    { 131, 263, 4147200, 0, 131 },
    { 132, 266, 8294400, 0, 132 },
    { 133, 268, 8294400, 0, 133 },
    { 134, 270, 8294400, 0, 134 },
    { 135, 271, 8294400, 0, 135 },
    { 136, 273, 8294400, 0, 136 },
    { 126, 263, 8294400, 0, 126 },
    { 138, 278, 4147200, 0, 138 },
    { 139, 280, 4147200, 0, 139 },
    { 140, 282, 4147200, 0, 140 },
    { 141, 283, 4147200, 0, 141 },
    { 142, 285, 4147200, 0, 142 },
    { 143, 288, 8294400, 0, 143 },
    { 144, 290, 8294400, 0, 144 },
    { 145, 292, 8294400, 0, 145 },
    { 146, 293, 8294400, 0, 146 },
    { 147, 295, 8294400, 0, 147 },
    { 137, 285, 8294400, 0, 137 },
    { 149, 300, 4147200, 0, 149 },
    { 150, 302, 4147200, 0, 150 },
    { 151, 304, 4147200, 0, 151 },
    { 152, 305, 4147200, 0, 152 },
    { 153, 307, 4147200, 0, 153 },
    { 154, 310, 8294400, 0, 154 },
    { 155, 312, 8294400, 0, 155 },
    { 156, 314, 8294400, 0, 156 },
    { 157, 315, 8294400, 0, 157 },
    { 158, 317, 8294400, 0, 158 },
    { 148, 307, 8294400, 0, 148 },
    { 160, 322, 4147200, 0, 160 },
    { 161, 324, 4147200, 0, 161 },
    { 162, 326, 4147200, 0, 162 },
    { 163, 327, 4147200, 0, 163 },
    { 164, 329, 4147200, 0, 164 },
    { 165, 332, 8294400, 0, 165 },
    { 166, 334, 8294400, 0, 166 },
    { 167, 336, 8294400, 0, 167 },
    { 168, 337, 8294400, 0, 168 },
    { 169, 339, 8294400, 0, 169 },
    { 159, 329, 8294400, 0, 159 },
    { 171, 344, 4147200, 0, 171 },
    { 172, 346, 4147200, 0, 172 },
    { 173, 348, 4147200, 0, 173 },
    { 174, 349, 4147200, 0, 174 },
    { 175, 351, 4147200, 0, 175 },
    { 176, 354, 8294400, 0, 176 },
    { 177, 356, 8294400, 0, 177 },
    { 178, 358, 8294400, 0, 178 },
    { 179, 359, 8294400, 0, 179 },
    { 180, 361, 8294400, 0, 180 },
    { 170, 351, 8294400, 0, 170 },
    { 182, 366, 4147200, 0, 182 },
    { 183, 368, 4147200, 0, 183 },
    { 184, 370, 4147200, 0, 184 },
    { 185, 371, 4147200, 0, 185 },
    { 186, 373, 4147200, 0, 186 },
    { 187, 376, 8294400, 0, 187 },
    { 188, 378, 8294400, 0, 188 },
    { 189, 380, 8294400, 0, 189 },
    { 190, 381, 8294400, 0, 190 },
    { 191, 383, 8294400, 0, 191 },
    { 181, 373, 8294400, 0, 181 },
    { 193, 388, 4147200, 0, 193 },
    { 194, 390, 4147200, 0, 194 },
    { 195, 392, 4147200, 0, 195 },
    { 196, 393, 4147200, 0, 196 },
    { 197, 395, 4147200, 0, 197 },
    { 198, 398, 8294400, 0, 198 },
    { 199, 400, 8294400, 0, 199 },
    { 200, 402, 8294400, 0, 200 },
    { 201, 403, 8294400, 0, 201 },
    { 202, 405, 8294400, 0, 202 },
    { 192, 395, 8294400, 0, 192 },
    { 204, 410, 4147200, 0, 204 },
    { 205, 412, 4147200, 0, 205 },
    { 206, 414, 4147200, 0, 206 },
    { 207, 415, 4147200, 0, 207 },
    { 208, 417, 4147200, 0, 208 },
    { 209, 420, 8294400, 0, 209 },
    { 210, 422, 8294400, 0, 210 },
    { 211, 424, 8294400, 0, 211 },
    { 212, 425, 8294400, 0, 212 },
    { 213, 427, 8294400, 0, 213 },
    { 203, 417, 8294400, 0, 203 },
    { 214, 430, 8294400, 0, 214 },
    { 215, 433, 4177920, 0, 215 },
    { 217, 436, 4177920, 0, 217 },
    { 218, 438, 4177920, 0, 218 },
    { 219, 439, 4177920, 0, 219 },
    { 221, 444, 2088960, 0, 221 },
    { 222, 446, 2088960, 0, 222 },
    { 223, 448, 2088960, 0, 223 },
    { 224, 449, 2088960, 0, 224 },
    { 225, 451, 2088960, 0, 225 },
    { 226, 454, 4177920, 0, 226 },
    { 227, 456, 4177920, 0, 227 },
    { 228, 458, 4177920, 0, 228 },
    { 229, 459, 4177920, 0, 229 },
    { 230, 461, 4177920, 0, 230 },
    { 220, 451, 4177920, 0, 220 },
    { 232, 466, 2088960, 0, 232 },
    { 233, 468, 2088960, 0, 233 },
    { 234, 470, 2088960, 0, 234 },
    { 235, 471, 2088960, 0, 235 },
    { 236, 473, 2088960, 0, 236 },
    { 237, 476, 4177920, 0, 237 },
    { 238, 478, 4177920, 0, 238 },
    { 239, 480, 4177920, 0, 239 },
    { 240, 481, 4177920, 0, 240 },
    { 241, 483, 4177920, 0, 241 },
    { 231, 473, 4177920, 0, 231 },
    { 243, 488, 2088960, 0, 243 },
    { 244, 490, 2088960, 0, 244 },
    { 245, 492, 2088960, 0, 245 },
    { 246, 493, 2088960, 0, 246 },
    { 247, 495, 2088960, 0, 247 },
    { 248, 498, 4177920, 0, 248 },
    { 249, 500, 4177920, 0, 249 },
    { 250, 502, 4177920, 0, 250 },
    { 251, 503, 4177920, 0, 251 },
    { 252, 505, 4177920, 0, 252 },
    { 242, 495, 4177920, 0, 242 },
    { 254, 510, 2088960, 0, 254 },
    { 255, 512, 2088960, 0, 255 },
    { 256, 514, 2088960, 0, 256 },
    { 257, 515, 2088960, 0, 257 },
    { 258, 517, 2088960, 0, 258 },
    { 259, 520, 4177920, 0, 259 },
    { 260, 522, 4177920, 0, 260 },
    { 261, 524, 4177920, 0, 261 },
    { 262, 525, 4177920, 0, 262 },
    { 263, 527, 4177920, 0, 263 },
    { 253, 517, 4177920, 0, 253 },
    { 265, 532, 2088960, 0, 265 },
    { 266, 534, 2088960, 0, 266 },
    { 267, 536, 2088960, 0, 267 },
    { 268, 537, 2088960, 0, 268 },
    { 269, 539, 2088960, 0, 269 },
    { 270, 542, 4177920, 0, 270 },
    { 271, 544, 4177920, 0, 271 },
    { 272, 546, 4177920, 0, 272 },
    { 273, 547, 4177920, 0, 273 },
    { 274, 549, 4177920, 0, 274 },
    { 264, 539, 4177920, 0, 264 },
    { 276, 554, 2088960, 0, 276 },
    { 277, 556, 2088960, 0, 277 },
    { 278, 558, 2088960, 0, 278 },
    { 279, 559, 2088960, 0, 279 },
    { 280, 561, 2088960, 0, 280 },
    { 281, 564, 4177920, 0, 281 },
    { 282, 566, 4177920, 0, 282 },
    { 283, 568, 4177920, 0, 283 },
    { 284, 569, 4177920, 0, 284 },
    { 285, 571, 4177920, 0, 285 },
    { 275, 561, 4177920, 0, 275 },
    { 287, 576, 2088960, 0, 287 },
    { 288, 578, 2088960, 0, 288 },
    { 289, 580, 2088960, 0, 289 },
    { 290, 581, 2088960, 0, 290 },
    { 291, 583, 2088960, 0, 291 },
    { 292, 586, 4177920, 0, 292 },
    { 293, 588, 4177920, 0, 293 },
    { 294, 590, 4177920, 0, 294 },
    { 295, 591, 4177920, 0, 295 },
    { 296, 593, 4177920, 0, 296 },
    { 286, 583, 4177920, 0, 286 },
    { 298, 598, 2088960, 0, 298 },
    { 299, 600, 2088960, 0, 299 },
    { 300, 602, 2088960, 0, 300 },
    { 301, 603, 2088960, 0, 301 },
    { 302, 605, 2088960, 0, 302 },
    { 303, 608, 4177920, 0, 303 },
    { 304, 610, 4177920, 0, 304 },
    { 305, 612, 4177920, 0, 305 },
    { 306, 613, 4177920, 0, 306 },
    { 307, 615, 4177920, 0, 307 },
    { 297, 605, 4177920, 0, 297 },
    { 309, 620, 2088960, 0, 309 },
    { 310, 622, 2088960, 0, 310 },
    { 311, 624, 2088960, 0, 311 },
    { 312, 625, 2088960, 0, 312 },
    { 314, 630, 1044480, 0, 314 },
    { 315, 632, 1044480, 0, 315 },
    { 316, 634, 1044480, 0, 316 },
    { 317, 635, 1044480, 0, 317 },
    { 318, 637, 1044480, 0, 318 },
    { 319, 640, 2088960, 0, 319 },
    { 320, 642, 2088960, 0, 320 },
    { 321, 644, 2088960, 0, 321 },
    { 322, 645, 2088960, 0, 322 },
    { 323, 647, 2088960, 0, 323 },
    { 313, 637, 2088960, 0, 313 },
    { 325, 652, 1044480, 0, 325 },
    { 326, 654, 1044480, 0, 326 },
    { 327, 656, 1044480, 0, 327 },
    { 328, 657, 1044480, 0, 328 },
    { 329, 659, 1044480, 0, 329 },
    { 330, 662, 2088960, 0, 330 },
    { 331, 664, 2088960, 0, 331 },
    { 332, 666, 2088960, 0, 332 },
    { 333, 667, 2088960, 0, 333 },
    { 334, 669, 2088960, 0, 334 },
    { 324, 659, 2088960, 0, 324 },
    { 336, 674, 1044480, 0, 336 },
    { 337, 676, 1044480, 0, 337 },
    { 338, 678, 1044480, 0, 338 },
    { 339, 679, 1044480, 0, 339 },
    { 340, 681, 1044480, 0, 340 },
    { 341, 684, 2088960, 0, 341 },
    { 342, 686, 2088960, 0, 342 },
    { 343, 688, 2088960, 0, 343 },
    { 344, 689, 2088960, 0, 344 },
    { 345, 691, 2088960, 0, 345 },
    { 335, 681, 2088960, 0, 335 },
    { 347, 696, 1044480, 0, 347 },
    { 348, 698, 1044480, 0, 348 },
    { 349, 700, 1044480, 0, 349 },
    { 350, 701, 1044480, 0, 350 },
    { 351, 703, 1044480, 0, 351 },
    { 352, 706, 2088960, 0, 352 },
    { 353, 708, 2088960, 0, 353 },
    { 354, 710, 2088960, 0, 354 },
    { 355, 711, 2088960, 0, 355 },
    { 356, 713, 2088960, 0, 356 },
    { 346, 703, 2088960, 0, 346 },
    { 357, 715, 2088960, 0, 357 },
    { 358, 718, 1044480, 0, 358 },
    { 359, 720, 1044480, 0, 359 },
    { 360, 722, 1044480, 0, 360 },
    { 361, 723, 1044480, 0, 361 },
    { 362, 725, 1044480, 0, 362 },
    { 363, 728, 2088960, 0, 363 },
    { 364, 730, 2088960, 0, 364 },
    { 365, 732, 2088960, 0, 365 },
    { 366, 733, 2088960, 0, 366 },
    { 367, 735, 2088960, 0, 367 },
    { 368, 738, 1044480, 0, 368 },
    { 369, 740, 1044480, 0, 369 },
    { 370, 742, 1044480, 0, 370 },
    { 371, 743, 1044480, 0, 371 },
    { 372, 745, 1044480, 0, 372 },
    { 373, 748, 2088960, 0, 373 },
    { 374, 750, 2088960, 0, 374 },
    { 375, 752, 2088960, 0, 375 },
    { 376, 753, 2088960, 0, 376 },
    { 377, 755, 2088960, 0, 377 },
    { 378, 758, 1044480, 0, 378 },
    { 379, 760, 1044480, 0, 379 },
    { 380, 762, 1044480, 0, 380 },
    { 381, 763, 1044480, 0, 381 },
    { 382, 766, 1044480, 0, 382 },
    { 383, 770, 2088960, 0, 383 },
    { 384, 772, 522240, 0, 384 },
    { 385, 774, 2088960, 0, 385 },
    { 386, 776, 522240, 0, 386 },
    { 387, 778, 2088960, 0, 387 },
    { 389, 780, 2088960, 0, 389 },
    { 388, 780, 522240, 0, 388 },
    { 390, 782, 522240, 0, 390 },
    { 391, 784, 2088960, 0, 391 },
    { 392, 786, 522240, 0, 392 },
    { 394, 789, 2088960, 0, 394 },
    { 393, 789, 520200, 0, 393 },
    { 395, 792, 2088960, 0, 395 },
    { 308, 705, 4177920, 0, 308 },
    { 397, 795, 6266880, 0, 397 },
    { 398, 798, 2088960, 0, 398 },
    { 399, 800, 2088960, 0, 399 },
    { 400, 802, 2088960, 0, 400 },
    { 401, 803, 2088960, 0, 401 },
    { 402, 805, 2088960, 0, 402 },
    { 403, 808, 4177920, 0, 403 },
    { 404, 810, 4177920, 0, 404 },
    { 405, 812, 4177920, 0, 405 },
    { 406, 813, 4177920, 0, 406 },
    { 407, 815, 4177920, 0, 407 },
    { 408, 818, 2088960, 0, 408 },
    { 409, 820, 2088960, 0, 409 },
    { 410, 822, 2088960, 0, 410 },
    { 411, 823, 2088960, 0, 411 },
    { 412, 825, 2088960, 0, 412 },
    { 413, 828, 4177920, 0, 413 },
    { 414, 830, 4177920, 0, 414 },
    { 415, 832, 4177920, 0, 415 },
    { 416, 833, 4177920, 0, 416 },
    { 417, 835, 4177920, 0, 417 },
    { 418, 838, 2088960, 0, 418 },
    { 419, 840, 2088960, 0, 419 },
    { 420, 842, 2088960, 0, 420 },
    { 421, 843, 2088960, 0, 421 },
    { 422, 846, 2088960, 0, 422 },
    { 423, 850, 4177920, 0, 423 },
    { 424, 852, 1044480, 0, 424 },
    { 425, 854, 4177920, 0, 425 },
    { 426, 856, 1044480, 0, 426 },
    { 427, 858, 4177920, 0, 427 },
    { 429, 860, 4177920, 0, 429 },
    { 428, 860, 1044480, 0, 428 },
    { 430, 862, 1044480, 0, 430 },
    { 431, 864, 4177920, 0, 431 },
    { 432, 866, 1044480, 0, 432 },
    { 434, 869, 4147200, 0, 434 },
    { 433, 869, 2080800, 0, 433 },
    { 435, 872, 4147200, 0, 435 },
    { 216, 653, 8294400, 0, 216 },
    { 437, 875, 12441600, 0, 437 },
    { 438, 878, 4147200, 0, 438 },
    { 439, 880, 4147200, 0, 439 },
    { 440, 882, 4147200, 0, 440 },
    { 441, 883, 4147200, 0, 441 },
    { 442, 885, 4147200, 0, 442 },
    { 443, 888, 8294400, 0, 443 },
    { 444, 890, 8294400, 0, 444 },
    { 445, 892, 8294400, 0, 445 },
    { 446, 893, 8294400, 0, 446 },
    { 447, 895, 8294400, 0, 447 },
    { 448, 898, 4147200, 0, 448 },
    { 449, 900, 4147200, 0, 449 },
    { 450, 902, 4147200, 0, 450 },
    { 451, 903, 4147200, 0, 451 },
    { 452, 905, 4147200, 0, 452 },
    { 453, 908, 8294400, 0, 453 },
    { 454, 910, 8294400, 0, 454 },
    { 455, 912, 8294400, 0, 455 },
    { 456, 913, 8294400, 0, 456 },
    { 457, 915, 8294400, 0, 457 },
    { 458, 918, 4147200, 0, 458 },
    { 459, 920, 4147200, 0, 459 },
    { 460, 922, 4147200, 0, 460 },
    { 461, 923, 4147200, 0, 461 },
    { 462, 925, 4147200, 0, 462 },
    { 463, 928, 8294400, 0, 463 },
    { 464, 930, 8294400, 0, 464 },
    { 465, 932, 8294400, 0, 465 },
    { 466, 933, 8294400, 0, 466 },
    { 467, 935, 8294400, 0, 467 },
    { 468, 937, 8262000, 0, 468 },
    { 396, 866, 2080800, 0, 396 },
    { 436, 907, 8323200, 0, 436 },
    { 469, 941, 33048000, 0, 469 }
};

// Generated from deeplabv3_257_mv_gpu.tflite
std::vector<armnn::MemBlock> deeplabv3
{
    { 0, 3, 31616, 0, 0 },
    { 3, 39, 31616, 0, 3 },
    { 36, 73, 131072, 0, 36 },
    { 37, 75, 131072, 0, 37 },
    { 38, 77, 131072, 0, 38 },
    { 39, 79, 131072, 0, 39 },
    { 40, 81, 131072, 0, 40 },
    { 41, 83, 131072, 0, 41 },
    { 42, 85, 131072, 0, 42 },
    { 43, 87, 131072, 0, 43 },
    { 44, 89, 131072, 0, 44 },
    { 45, 91, 131072, 0, 45 },
    { 46, 93, 8192, 0, 46 },
    { 46, 94, 8192, 0, 47 },
    { 46, 95, 8192, 0, 48 },
    { 46, 96, 8192, 0, 49 },
    { 46, 97, 8192, 0, 50 },
    { 46, 98, 8192, 0, 51 },
    { 46, 99, 8192, 0, 52 },
    { 46, 100, 8192, 0, 53 },
    { 46, 101, 8192, 0, 54 },
    { 46, 102, 8192, 0, 55 },
    { 46, 103, 8192, 0, 56 },
    { 46, 104, 8192, 0, 57 },
    { 46, 105, 8192, 0, 58 },
    { 46, 106, 8192, 0, 59 },
    { 46, 107, 8192, 0, 60 },
    { 46, 108, 8192, 0, 61 },
    { 47, 110, 8192, 0, 62 },
    { 1, 64, 8192, 0, 1 },
    { 63, 127, 16384, 0, 78 },
    { 64, 129, 32768, 0, 79 },
    { 65, 131, 8192, 0, 82 },
    { 65, 132, 8192, 0, 80 },
    { 65, 133, 8192, 0, 81 },
    { 65, 134, 8192, 0, 83 },
    { 66, 136, 8192, 0, 84 },
    { 67, 138, 8192, 0, 85 },
    { 68, 139, 8192, 0, 86 },
    { 70, 142, 8192, 0, 88 },
    { 2, 74, 8192, 0, 2 },
    { 72, 145, 8192, 0, 90 },
    { 71, 144, 8192, 0, 89 },
    { 69, 144, 8192, 0, 87 },
    { 74, 149, 8192, 0, 92 },
    { 48, 124, 8192, 0, 63 },
    { 76, 153, 16384, 0, 94 },
    { 77, 155, 32768, 0, 95 },
    { 78, 157, 8192, 0, 98 },
    { 78, 158, 8192, 0, 96 },
    { 78, 159, 8192, 0, 97 },
    { 78, 160, 8192, 0, 99 },
    { 79, 162, 8192, 0, 100 },
    { 80, 164, 8192, 0, 101 },
    { 81, 165, 8192, 0, 102 },
    { 83, 168, 8192, 0, 104 },
    { 73, 158, 8192, 0, 91 },
    { 85, 171, 8192, 0, 106 },
    { 84, 170, 8192, 0, 105 },
    { 82, 170, 8192, 0, 103 },
    { 87, 175, 8192, 0, 108 },
    { 49, 138, 8192, 0, 64 },
    { 89, 179, 16384, 0, 110 },
    { 90, 181, 32768, 0, 111 },
    { 91, 183, 8192, 0, 114 },
    { 91, 184, 8192, 0, 112 },
    { 91, 185, 8192, 0, 113 },
    { 91, 186, 8192, 0, 115 },
    { 92, 188, 8192, 0, 116 },
    { 93, 190, 8192, 0, 117 },
    { 94, 191, 8192, 0, 118 },
    { 96, 194, 8192, 0, 120 },
    { 86, 184, 8192, 0, 107 },
    { 98, 197, 8192, 0, 122 },
    { 97, 196, 8192, 0, 121 },
    { 95, 196, 8192, 0, 119 },
    { 100, 201, 8192, 0, 124 },
    { 50, 152, 8192, 0, 65 },
    { 102, 205, 16384, 0, 126 },
    { 103, 207, 32768, 0, 127 },
    { 104, 209, 8192, 0, 130 },
    { 104, 210, 8192, 0, 128 },
    { 104, 211, 8192, 0, 129 },
    { 104, 212, 8192, 0, 131 },
    { 105, 214, 8192, 0, 132 },
    { 106, 216, 8192, 0, 133 },
    { 107, 217, 8192, 0, 134 },
    { 109, 220, 8192, 0, 136 },
    { 99, 210, 8192, 0, 123 },
    { 111, 223, 8192, 0, 138 },
    { 110, 222, 8192, 0, 137 },
    { 108, 222, 8192, 0, 135 },
    { 113, 227, 8192, 0, 140 },
    { 51, 166, 8192, 0, 66 },
    { 115, 231, 16384, 0, 142 },
    { 116, 233, 32768, 0, 143 },
    { 117, 235, 8192, 0, 146 },
    { 117, 236, 8192, 0, 144 },
    { 117, 237, 8192, 0, 145 },
    { 117, 238, 8192, 0, 147 },
    { 118, 240, 8192, 0, 148 },
    { 119, 242, 8192, 0, 149 },
    { 120, 243, 8192, 0, 150 },
    { 122, 246, 8192, 0, 152 },
    { 112, 236, 8192, 0, 139 },
    { 124, 249, 8192, 0, 154 },
    { 123, 248, 8192, 0, 153 },
    { 121, 248, 8192, 0, 151 },
    { 126, 253, 8192, 0, 156 },
    { 52, 180, 8192, 0, 67 },
    { 128, 257, 16384, 0, 158 },
    { 129, 259, 32768, 0, 159 },
    { 130, 261, 8192, 0, 162 },
    { 130, 262, 8192, 0, 160 },
    { 130, 263, 8192, 0, 161 },
    { 130, 264, 8192, 0, 163 },
    { 131, 266, 8192, 0, 164 },
    { 132, 268, 8192, 0, 165 },
    { 133, 269, 8192, 0, 166 },
    { 135, 272, 8192, 0, 168 },
    { 125, 262, 8192, 0, 155 },
    { 137, 275, 8192, 0, 170 },
    { 136, 274, 8192, 0, 169 },
    { 134, 274, 8192, 0, 167 },
    { 139, 279, 8192, 0, 172 },
    { 53, 194, 8192, 0, 68 },
    { 141, 283, 16384, 0, 174 },
    { 142, 285, 32768, 0, 175 },
    { 143, 287, 8192, 0, 178 },
    { 143, 288, 8192, 0, 176 },
    { 143, 289, 8192, 0, 177 },
    { 143, 290, 8192, 0, 179 },
    { 144, 292, 8192, 0, 180 },
    { 145, 294, 8192, 0, 181 },
    { 146, 295, 8192, 0, 182 },
    { 148, 298, 8192, 0, 184 },
    { 138, 288, 8192, 0, 171 },
    { 150, 301, 8192, 0, 186 },
    { 149, 300, 8192, 0, 185 },
    { 147, 300, 8192, 0, 183 },
    { 152, 305, 8192, 0, 188 },
    { 54, 208, 8192, 0, 69 },
    { 154, 309, 16384, 0, 190 },
    { 155, 311, 32768, 0, 191 },
    { 156, 313, 8192, 0, 194 },
    { 156, 314, 8192, 0, 192 },
    { 156, 315, 8192, 0, 193 },
    { 156, 316, 8192, 0, 195 },
    { 157, 318, 8192, 0, 196 },
    { 158, 320, 8192, 0, 197 },
    { 159, 321, 8192, 0, 198 },
    { 161, 324, 8192, 0, 200 },
    { 151, 314, 8192, 0, 187 },
    { 163, 327, 8192, 0, 202 },
    { 162, 326, 8192, 0, 201 },
    { 160, 326, 8192, 0, 199 },
    { 165, 331, 8192, 0, 204 },
    { 55, 222, 8192, 0, 70 },
    { 167, 335, 16384, 0, 206 },
    { 168, 337, 32768, 0, 207 },
    { 169, 339, 8192, 0, 210 },
    { 169, 340, 8192, 0, 208 },
    { 169, 341, 8192, 0, 209 },
    { 169, 342, 8192, 0, 211 },
    { 170, 344, 8192, 0, 212 },
    { 171, 346, 8192, 0, 213 },
    { 172, 347, 8192, 0, 214 },
    { 174, 350, 8192, 0, 216 },
    { 164, 340, 8192, 0, 203 },
    { 176, 353, 8192, 0, 218 },
    { 175, 352, 8192, 0, 217 },
    { 173, 352, 8192, 0, 215 },
    { 178, 357, 8192, 0, 220 },
    { 56, 236, 8192, 0, 71 },
    { 180, 361, 16384, 0, 222 },
    { 181, 363, 32768, 0, 223 },
    { 182, 365, 8192, 0, 226 },
    { 182, 366, 8192, 0, 224 },
    { 182, 367, 8192, 0, 225 },
    { 182, 368, 8192, 0, 227 },
    { 183, 370, 8192, 0, 228 },
    { 184, 372, 8192, 0, 229 },
    { 185, 373, 8192, 0, 230 },
    { 187, 376, 8192, 0, 232 },
    { 177, 366, 8192, 0, 219 },
    { 189, 379, 8192, 0, 234 },
    { 188, 378, 8192, 0, 233 },
    { 186, 378, 8192, 0, 231 },
    { 191, 383, 8192, 0, 236 },
    { 57, 250, 8192, 0, 72 },
    { 193, 387, 16384, 0, 238 },
    { 194, 389, 32768, 0, 239 },
    { 195, 391, 8192, 0, 242 },
    { 195, 392, 8192, 0, 240 },
    { 195, 393, 8192, 0, 241 },
    { 195, 394, 8192, 0, 243 },
    { 196, 396, 8192, 0, 244 },
    { 197, 398, 8192, 0, 245 },
    { 198, 399, 8192, 0, 246 },
    { 200, 402, 8192, 0, 248 },
    { 190, 392, 8192, 0, 235 },
    { 202, 405, 8192, 0, 250 },
    { 201, 404, 8192, 0, 249 },
    { 199, 404, 8192, 0, 247 },
    { 204, 409, 8192, 0, 252 },
    { 58, 264, 8192, 0, 73 },
    { 206, 413, 16384, 0, 254 },
    { 207, 415, 32768, 0, 255 },
    { 208, 417, 8192, 0, 258 },
    { 208, 418, 8192, 0, 256 },
    { 208, 419, 8192, 0, 257 },
    { 208, 420, 8192, 0, 259 },
    { 209, 422, 8192, 0, 260 },
    { 210, 424, 8192, 0, 261 },
    { 211, 425, 8192, 0, 262 },
    { 213, 428, 8192, 0, 264 },
    { 203, 418, 8192, 0, 251 },
    { 215, 431, 8192, 0, 266 },
    { 214, 430, 8192, 0, 265 },
    { 212, 430, 8192, 0, 263 },
    { 217, 435, 8192, 0, 268 },
    { 59, 278, 8192, 0, 74 },
    { 219, 439, 16384, 0, 270 },
    { 220, 441, 32768, 0, 271 },
    { 221, 443, 8192, 0, 274 },
    { 221, 444, 8192, 0, 272 },
    { 221, 445, 8192, 0, 273 },
    { 221, 446, 8192, 0, 275 },
    { 222, 448, 8192, 0, 276 },
    { 223, 450, 8192, 0, 277 },
    { 224, 451, 8192, 0, 278 },
    { 226, 454, 8192, 0, 280 },
    { 216, 444, 8192, 0, 267 },
    { 228, 457, 8192, 0, 282 },
    { 227, 456, 8192, 0, 281 },
    { 225, 456, 8192, 0, 279 },
    { 230, 461, 8192, 0, 284 },
    { 60, 292, 8192, 0, 75 },
    { 232, 465, 16384, 0, 286 },
    { 233, 467, 32768, 0, 287 },
    { 234, 469, 8192, 0, 290 },
    { 234, 470, 8192, 0, 288 },
    { 234, 471, 8192, 0, 289 },
    { 234, 472, 8192, 0, 291 },
    { 235, 474, 8192, 0, 292 },
    { 236, 476, 8192, 0, 293 },
    { 237, 477, 8192, 0, 294 },
    { 239, 480, 8192, 0, 296 },
    { 229, 470, 8192, 0, 283 },
    { 241, 483, 8192, 0, 298 },
    { 240, 482, 8192, 0, 297 },
    { 238, 482, 8192, 0, 295 },
    { 243, 487, 8192, 0, 300 },
    { 61, 306, 8192, 0, 76 },
    { 245, 491, 16384, 0, 302 },
    { 246, 493, 32768, 0, 303 },
    { 247, 495, 8192, 0, 306 },
    { 247, 496, 8192, 0, 304 },
    { 247, 497, 8192, 0, 305 },
    { 247, 498, 8192, 0, 307 },
    { 248, 500, 8192, 0, 308 },
    { 249, 502, 8192, 0, 309 },
    { 250, 503, 8192, 0, 310 },
    { 252, 506, 8192, 0, 312 },
    { 242, 496, 8192, 0, 299 },
    { 254, 509, 8192, 0, 314 },
    { 253, 508, 8192, 0, 313 },
    { 251, 508, 8192, 0, 311 },
    { 256, 513, 8192, 0, 316 },
    { 62, 320, 8192, 0, 77 },
    { 258, 517, 16384, 0, 318 },
    { 259, 519, 32768, 0, 319 },
    { 260, 521, 8192, 0, 322 },
    { 260, 522, 8192, 0, 320 },
    { 260, 523, 8192, 0, 321 },
    { 260, 524, 8192, 0, 323 },
    { 261, 526, 8192, 0, 324 },
    { 262, 528, 8192, 0, 325 },
    { 263, 529, 8192, 0, 326 },
    { 265, 532, 8192, 0, 328 },
    { 255, 522, 8192, 0, 315 },
    { 267, 535, 8192, 0, 330 },
    { 266, 534, 8192, 0, 329 },
    { 264, 534, 8192, 0, 327 },
    { 269, 539, 8192, 0, 332 },
    { 75, 346, 8192, 0, 93 },
    { 88, 359, 8192, 0, 109 },
    { 101, 372, 8192, 0, 125 },
    { 114, 385, 8192, 0, 141 },
    { 127, 398, 8192, 0, 157 },
    { 140, 411, 8192, 0, 173 },
    { 153, 424, 8192, 0, 189 },
    { 166, 437, 8192, 0, 205 },
    { 179, 450, 8192, 0, 221 },
    { 192, 463, 8192, 0, 237 },
    { 205, 476, 8192, 0, 253 },
    { 218, 489, 8192, 0, 269 },
    { 231, 502, 8192, 0, 285 },
    { 244, 515, 8192, 0, 301 },
    { 257, 528, 8192, 0, 317 },
    { 271, 543, 131072, 0, 334 },
    { 272, 545, 131072, 0, 335 },
    { 273, 547, 131072, 0, 336 },
    { 274, 549, 131072, 0, 337 },
    { 275, 551, 1856, 0, 338 },
    { 276, 553, 1856, 0, 339 },
    { 270, 548, 8192, 0, 333 },
    { 268, 547, 8192, 0, 331 }
};

// Generated from mobilebert_float_20191023.tflite
std::vector<armnn::MemBlock> mobilebert
{
    { 1, 4, 1536, 0, 1 },
    { 0, 4, 1536, 0, 0 },
    { 2, 7, 1536, 0, 2 },
    { 3, 9, 1536, 0, 3 },
    { 4, 11, 1536, 0, 4 },
    { 6, 14, 1536, 0, 6 },
    { 5, 14, 786432, 0, 5 },
    { 7, 17, 196608, 0, 7 },
    { 8, 42, 589824, 0, 8 },
    { 11, 48, 589824, 0, 11 },
    { 12, 50, 589824, 0, 12 },
    { 13, 52, 589824, 0, 13 },
    { 14, 54, 589824, 0, 14 },
    { 15, 56, 589824, 0, 15 },
    { 16, 58, 589824, 0, 16 },
    { 17, 60, 589824, 0, 17 },
    { 18, 62, 589824, 0, 18 },
    { 19, 64, 589824, 0, 19 },
    { 20, 66, 589824, 0, 20 },
    { 21, 68, 589824, 0, 21 },
    { 22, 70, 589824, 0, 22 },
    { 23, 72, 589824, 0, 23 },
    { 24, 74, 589824, 0, 24 },
    { 25, 76, 589824, 0, 25 },
    { 26, 78, 589824, 0, 26 },
    { 27, 80, 589824, 0, 27 },
    { 28, 82, 589824, 0, 28 },
    { 29, 84, 589824, 0, 29 },
    { 30, 86, 589824, 0, 30 },
    { 31, 88, 589824, 0, 31 },
    { 32, 90, 589824, 0, 32 },
    { 33, 92, 589824, 0, 33 },
    { 34, 94, 589824, 0, 34 },
    { 35, 96, 196096, 0, 35 },
    { 36, 98, 196096, 0, 36 },
    { 37, 100, 589824, 0, 37 },
    { 38, 102, 589824, 0, 38 },
    { 39, 104, 589824, 0, 39 },
    { 40, 106, 589824, 0, 40 },
    { 41, 108, 589824, 0, 41 },
    { 42, 110, 589824, 0, 42 },
    { 43, 112, 589824, 0, 43 },
    { 44, 114, 589824, 0, 44 },
    { 45, 116, 589824, 0, 45 },
    { 46, 118, 589824, 0, 46 },
    { 47, 120, 589824, 0, 47 },
    { 48, 122, 589824, 0, 48 },
    { 49, 124, 589824, 0, 49 },
    { 50, 126, 589824, 0, 50 },
    { 51, 128, 589824, 0, 51 },
    { 52, 130, 589824, 0, 52 },
    { 53, 132, 589824, 0, 53 },
    { 54, 134, 589824, 0, 54 },
    { 55, 136, 589824, 0, 55 },
    { 56, 138, 589824, 0, 56 },
    { 57, 140, 589824, 0, 57 },
    { 58, 142, 589824, 0, 58 },
    { 59, 144, 589824, 0, 59 },
    { 60, 146, 589824, 0, 60 },
    { 61, 148, 196608, 0, 61 },
    { 10, 97, 196608, 0, 10 },
    { 62, 149, 196608, 0, 62 },
    { 87, 175, 589824, 0, 87 },
    { 88, 177, 589824, 0, 88 },
    { 89, 179, 786432, 0, 89 },
    { 90, 181, 786432, 0, 90 },
    { 9, 100, 786432, 0, 9 },
    { 91, 183, 786432, 0, 91 },
    { 92, 185, 786432, 0, 92 },
    { 94, 191, 786432, 0, 94 },
    { 95, 193, 196608, 0, 95 },
    { 96, 196, 196608, 0, 96 },
    { 97, 198, 196608, 0, 97 },
    { 99, 201, 196608, 0, 99 },
    { 100, 203, 196608, 0, 100 },
    { 101, 205, 196608, 0, 101 },
    { 102, 207, 196608, 0, 102 },
    { 103, 209, 196608, 0, 103 },
    { 104, 211, 196608, 0, 104 },
    { 106, 214, 196608, 0, 106 },
    { 105, 214, 196608, 0, 105 },
    { 107, 217, 196608, 0, 107 },
    { 109, 223, 196608, 0, 109 },
    { 108, 223, 196608, 0, 108 },
    { 110, 229, 196608, 0, 110 },
    { 115, 238, 196608, 0, 115 },
    { 111, 235, 49152, 0, 111 },
    { 112, 237, 49152, 0, 112 },
    { 113, 239, 49152, 0, 113 },
    { 114, 241, 49152, 0, 114 },
    { 116, 244, 49152, 0, 116 },
    { 117, 246, 49152, 0, 117 },
    { 118, 248, 49152, 0, 118 },
    { 119, 250, 49152, 0, 119 },
    { 120, 252, 49152, 0, 120 },
    { 121, 254, 49152, 0, 121 },
    { 122, 256, 49152, 0, 122 },
    { 123, 258, 49152, 0, 123 },
    { 128, 264, 49152, 0, 128 },
    { 129, 266, 49152, 0, 129 },
    { 130, 268, 49152, 0, 130 },
    { 131, 270, 49152, 0, 131 },
    { 132, 272, 49152, 0, 132 },
    { 133, 274, 49152, 0, 133 },
    { 134, 276, 49152, 0, 134 },
    { 135, 278, 49152, 0, 135 },
    { 124, 268, 49152, 0, 124 },
    { 140, 284, 49152, 0, 140 },
    { 125, 270, 49152, 0, 125 },
    { 141, 286, 49152, 0, 141 },
    { 126, 272, 49152, 0, 126 },
    { 142, 288, 49152, 0, 142 },
    { 127, 274, 49152, 0, 127 },
    { 143, 290, 49152, 0, 143 },
    { 144, 292, 589824, 0, 144 },
    { 145, 293, 589824, 0, 145 },
    { 146, 294, 589824, 0, 146 },
    { 147, 295, 589824, 0, 147 },
    { 148, 297, 2359296, 0, 148 },
    { 149, 299, 2359296, 0, 149 },
    { 150, 301, 2359296, 0, 150 },
    { 63, 214, 589824, 0, 63 },
    { 151, 303, 2359296, 0, 151 },
    { 152, 305, 2359296, 0, 152 },
    { 153, 310, 2359296, 0, 153 },
    { 154, 312, 589824, 0, 154 },
    { 155, 314, 589824, 0, 155 },
    { 156, 316, 589824, 0, 156 },
    { 157, 318, 589824, 0, 157 },
    { 158, 320, 589824, 0, 158 },
    { 136, 298, 49152, 0, 136 },
    { 159, 322, 589824, 0, 159 },
    { 137, 300, 49152, 0, 137 },
    { 160, 324, 589824, 0, 160 },
    { 138, 302, 49152, 0, 138 },
    { 161, 326, 589824, 0, 161 },
    { 139, 304, 49152, 0, 139 },
    { 162, 328, 49152, 0, 162 },
    { 163, 329, 49152, 0, 163 },
    { 164, 330, 49152, 0, 164 },
    { 165, 331, 49152, 0, 165 },
    { 166, 333, 196608, 0, 166 },
    { 167, 335, 196608, 0, 167 },
    { 168, 337, 196608, 0, 168 },
    { 169, 339, 196608, 0, 169 },
    { 170, 341, 196608, 0, 170 },
    { 98, 269, 196608, 0, 98 },
    { 171, 343, 196608, 0, 171 },
    { 172, 345, 196608, 0, 172 },
    { 174, 349, 196608, 0, 174 },
    { 175, 351, 786432, 0, 175 },
    { 176, 353, 786432, 0, 176 },
    { 177, 355, 196608, 0, 177 },
    { 178, 357, 196608, 0, 178 },
    { 173, 352, 196608, 0, 173 },
    { 179, 359, 196608, 0, 179 },
    { 180, 361, 196608, 0, 180 },
    { 182, 365, 196608, 0, 182 },
    { 183, 367, 786432, 0, 183 },
    { 184, 369, 786432, 0, 184 },
    { 185, 371, 196608, 0, 185 },
    { 186, 373, 196608, 0, 186 },
    { 181, 368, 196608, 0, 181 },
    { 187, 375, 196608, 0, 187 },
    { 188, 377, 196608, 0, 188 },
    { 190, 381, 196608, 0, 190 },
    { 191, 383, 786432, 0, 191 },
    { 192, 385, 786432, 0, 192 },
    { 193, 387, 196608, 0, 193 },
    { 194, 389, 196608, 0, 194 },
    { 189, 384, 196608, 0, 189 },
    { 195, 391, 196608, 0, 195 },
    { 196, 393, 196608, 0, 196 },
    { 198, 397, 196608, 0, 198 },
    { 199, 399, 786432, 0, 199 },
    { 200, 401, 786432, 0, 200 },
    { 201, 403, 196608, 0, 201 },
    { 202, 405, 196608, 0, 202 },
    { 197, 400, 196608, 0, 197 },
    { 203, 407, 196608, 0, 203 },
    { 204, 409, 196608, 0, 204 },
    { 205, 411, 196608, 0, 205 },
    { 206, 413, 196608, 0, 206 },
    { 207, 415, 786432, 0, 207 },
    { 208, 417, 786432, 0, 208 },
    { 93, 302, 786432, 0, 93 },
    { 209, 419, 786432, 0, 209 },
    { 210, 421, 786432, 0, 210 },
    { 212, 427, 786432, 0, 212 },
    { 213, 429, 196608, 0, 213 },
    { 214, 432, 196608, 0, 214 },
    { 215, 434, 196608, 0, 215 },
    { 217, 437, 196608, 0, 217 },
    { 218, 439, 196608, 0, 218 },
    { 219, 441, 196608, 0, 219 },
    { 220, 443, 196608, 0, 220 },
    { 221, 445, 196608, 0, 221 },
    { 222, 447, 196608, 0, 222 },
    { 224, 450, 196608, 0, 224 },
    { 223, 450, 196608, 0, 223 },
    { 225, 453, 196608, 0, 225 },
    { 227, 459, 196608, 0, 227 },
    { 226, 459, 196608, 0, 226 },
    { 228, 465, 196608, 0, 228 },
    { 233, 474, 196608, 0, 233 },
    { 229, 471, 49152, 0, 229 },
    { 230, 473, 49152, 0, 230 },
    { 231, 475, 49152, 0, 231 },
    { 232, 477, 49152, 0, 232 },
    { 234, 480, 49152, 0, 234 },
    { 235, 482, 49152, 0, 235 },
    { 236, 484, 49152, 0, 236 },
    { 237, 486, 49152, 0, 237 },
    { 238, 488, 49152, 0, 238 },
    { 239, 490, 49152, 0, 239 },
    { 240, 492, 49152, 0, 240 },
    { 241, 494, 49152, 0, 241 },
    { 246, 500, 49152, 0, 246 },
    { 247, 502, 49152, 0, 247 },
    { 248, 504, 49152, 0, 248 },
    { 249, 506, 49152, 0, 249 },
    { 250, 508, 49152, 0, 250 },
    { 251, 510, 49152, 0, 251 },
    { 252, 512, 49152, 0, 252 },
    { 253, 514, 49152, 0, 253 },
    { 242, 504, 49152, 0, 242 },
    { 258, 520, 49152, 0, 258 },
    { 243, 506, 49152, 0, 243 },
    { 259, 522, 49152, 0, 259 },
    { 244, 508, 49152, 0, 244 },
    { 260, 524, 49152, 0, 260 },
    { 245, 510, 49152, 0, 245 },
    { 261, 526, 49152, 0, 261 },
    { 262, 528, 589824, 0, 262 },
    { 263, 529, 589824, 0, 263 },
    { 264, 530, 589824, 0, 264 },
    { 265, 531, 589824, 0, 265 },
    { 266, 533, 2359296, 0, 266 },
    { 267, 535, 2359296, 0, 267 },
    { 268, 537, 2359296, 0, 268 },
    { 64, 333, 589824, 0, 64 },
    { 269, 539, 2359296, 0, 269 },
    { 270, 541, 2359296, 0, 270 },
    { 271, 546, 2359296, 0, 271 },
    { 272, 548, 589824, 0, 272 },
    { 273, 550, 589824, 0, 273 },
    { 274, 552, 589824, 0, 274 },
    { 275, 554, 589824, 0, 275 },
    { 276, 556, 589824, 0, 276 },
    { 254, 534, 49152, 0, 254 },
    { 277, 558, 589824, 0, 277 },
    { 255, 536, 49152, 0, 255 },
    { 278, 560, 589824, 0, 278 },
    { 256, 538, 49152, 0, 256 },
    { 279, 562, 589824, 0, 279 },
    { 257, 540, 49152, 0, 257 },
    { 280, 564, 49152, 0, 280 },
    { 281, 565, 49152, 0, 281 },
    { 282, 566, 49152, 0, 282 },
    { 283, 567, 49152, 0, 283 },
    { 284, 569, 196608, 0, 284 },
    { 285, 571, 196608, 0, 285 },
    { 286, 573, 196608, 0, 286 },
    { 287, 575, 196608, 0, 287 },
    { 288, 577, 196608, 0, 288 },
    { 216, 505, 196608, 0, 216 },
    { 289, 579, 196608, 0, 289 },
    { 290, 581, 196608, 0, 290 },
    { 292, 585, 196608, 0, 292 },
    { 293, 587, 786432, 0, 293 },
    { 294, 589, 786432, 0, 294 },
    { 295, 591, 196608, 0, 295 },
    { 296, 593, 196608, 0, 296 },
    { 291, 588, 196608, 0, 291 },
    { 297, 595, 196608, 0, 297 },
    { 298, 597, 196608, 0, 298 },
    { 300, 601, 196608, 0, 300 },
    { 301, 603, 786432, 0, 301 },
    { 302, 605, 786432, 0, 302 },
    { 303, 607, 196608, 0, 303 },
    { 304, 609, 196608, 0, 304 },
    { 299, 604, 196608, 0, 299 },
    { 305, 611, 196608, 0, 305 },
    { 306, 613, 196608, 0, 306 },
    { 308, 617, 196608, 0, 308 },
    { 309, 619, 786432, 0, 309 },
    { 310, 621, 786432, 0, 310 },
    { 311, 623, 196608, 0, 311 },
    { 312, 625, 196608, 0, 312 },
    { 307, 620, 196608, 0, 307 },
    { 313, 627, 196608, 0, 313 },
    { 314, 629, 196608, 0, 314 },
    { 316, 633, 196608, 0, 316 },
    { 317, 635, 786432, 0, 317 },
    { 318, 637, 786432, 0, 318 },
    { 319, 639, 196608, 0, 319 },
    { 320, 641, 196608, 0, 320 },
    { 315, 636, 196608, 0, 315 },
    { 321, 643, 196608, 0, 321 },
    { 322, 645, 196608, 0, 322 },
    { 323, 647, 196608, 0, 323 },
    { 324, 649, 196608, 0, 324 },
    { 325, 651, 786432, 0, 325 },
    { 326, 653, 786432, 0, 326 },
    { 211, 538, 786432, 0, 211 },
    { 327, 655, 786432, 0, 327 },
    { 328, 657, 786432, 0, 328 },
    { 330, 663, 786432, 0, 330 },
    { 331, 665, 196608, 0, 331 },
    { 332, 668, 196608, 0, 332 },
    { 333, 670, 196608, 0, 333 },
    { 335, 673, 196608, 0, 335 },
    { 336, 675, 196608, 0, 336 },
    { 337, 677, 196608, 0, 337 },
    { 338, 679, 196608, 0, 338 },
    { 339, 681, 196608, 0, 339 },
    { 340, 683, 196608, 0, 340 },
    { 342, 686, 196608, 0, 342 },
    { 341, 686, 196608, 0, 341 },
    { 343, 689, 196608, 0, 343 },
    { 345, 695, 196608, 0, 345 },
    { 344, 695, 196608, 0, 344 },
    { 346, 701, 196608, 0, 346 },
    { 351, 710, 196608, 0, 351 },
    { 347, 707, 49152, 0, 347 },
    { 348, 709, 49152, 0, 348 },
    { 349, 711, 49152, 0, 349 },
    { 350, 713, 49152, 0, 350 },
    { 352, 716, 49152, 0, 352 },
    { 353, 718, 49152, 0, 353 },
    { 354, 720, 49152, 0, 354 },
    { 355, 722, 49152, 0, 355 },
    { 356, 724, 49152, 0, 356 },
    { 357, 726, 49152, 0, 357 },
    { 358, 728, 49152, 0, 358 },
    { 359, 730, 49152, 0, 359 },
    { 364, 736, 49152, 0, 364 },
    { 365, 738, 49152, 0, 365 },
    { 366, 740, 49152, 0, 366 },
    { 367, 742, 49152, 0, 367 },
    { 368, 744, 49152, 0, 368 },
    { 369, 746, 49152, 0, 369 },
    { 370, 748, 49152, 0, 370 },
    { 371, 750, 49152, 0, 371 },
    { 360, 740, 49152, 0, 360 },
    { 376, 756, 49152, 0, 376 },
    { 361, 742, 49152, 0, 361 },
    { 377, 758, 49152, 0, 377 },
    { 362, 744, 49152, 0, 362 },
    { 378, 760, 49152, 0, 378 },
    { 363, 746, 49152, 0, 363 },
    { 379, 762, 49152, 0, 379 },
    { 380, 764, 589824, 0, 380 },
    { 381, 765, 589824, 0, 381 },
    { 382, 766, 589824, 0, 382 },
    { 383, 767, 589824, 0, 383 },
    { 384, 769, 2359296, 0, 384 },
    { 385, 771, 2359296, 0, 385 },
    { 386, 773, 2359296, 0, 386 },
    { 65, 452, 589824, 0, 65 },
    { 387, 775, 2359296, 0, 387 },
    { 388, 777, 2359296, 0, 388 },
    { 389, 782, 2359296, 0, 389 },
    { 390, 784, 589824, 0, 390 },
    { 391, 786, 589824, 0, 391 },
    { 392, 788, 589824, 0, 392 },
    { 393, 790, 589824, 0, 393 },
    { 394, 792, 589824, 0, 394 },
    { 372, 770, 49152, 0, 372 },
    { 395, 794, 589824, 0, 395 },
    { 373, 772, 49152, 0, 373 },
    { 396, 796, 589824, 0, 396 },
    { 374, 774, 49152, 0, 374 },
    { 397, 798, 589824, 0, 397 },
    { 375, 776, 49152, 0, 375 },
    { 398, 800, 49152, 0, 398 },
    { 399, 801, 49152, 0, 399 },
    { 400, 802, 49152, 0, 400 },
    { 401, 803, 49152, 0, 401 },
    { 402, 805, 196608, 0, 402 },
    { 403, 807, 196608, 0, 403 },
    { 404, 809, 196608, 0, 404 },
    { 405, 811, 196608, 0, 405 },
    { 406, 813, 196608, 0, 406 },
    { 334, 741, 196608, 0, 334 },
    { 407, 815, 196608, 0, 407 },
    { 408, 817, 196608, 0, 408 },
    { 410, 821, 196608, 0, 410 },
    { 411, 823, 786432, 0, 411 },
    { 412, 825, 786432, 0, 412 },
    { 413, 827, 196608, 0, 413 },
    { 414, 829, 196608, 0, 414 },
    { 409, 824, 196608, 0, 409 },
    { 415, 831, 196608, 0, 415 },
    { 416, 833, 196608, 0, 416 },
    { 418, 837, 196608, 0, 418 },
    { 419, 839, 786432, 0, 419 },
    { 420, 841, 786432, 0, 420 },
    { 421, 843, 196608, 0, 421 },
    { 422, 845, 196608, 0, 422 },
    { 417, 840, 196608, 0, 417 },
    { 423, 847, 196608, 0, 423 },
    { 424, 849, 196608, 0, 424 },
    { 426, 853, 196608, 0, 426 },
    { 427, 855, 786432, 0, 427 },
    { 428, 857, 786432, 0, 428 },
    { 429, 859, 196608, 0, 429 },
    { 430, 861, 196608, 0, 430 },
    { 425, 856, 196608, 0, 425 },
    { 431, 863, 196608, 0, 431 },
    { 432, 865, 196608, 0, 432 },
    { 434, 869, 196608, 0, 434 },
    { 435, 871, 786432, 0, 435 },
    { 436, 873, 786432, 0, 436 },
    { 437, 875, 196608, 0, 437 },
    { 438, 877, 196608, 0, 438 },
    { 433, 872, 196608, 0, 433 },
    { 439, 879, 196608, 0, 439 },
    { 440, 881, 196608, 0, 440 },
    { 441, 883, 196608, 0, 441 },
    { 442, 885, 196608, 0, 442 },
    { 443, 887, 786432, 0, 443 },
    { 444, 889, 786432, 0, 444 },
    { 329, 774, 786432, 0, 329 },
    { 445, 891, 786432, 0, 445 },
    { 446, 893, 786432, 0, 446 },
    { 448, 899, 786432, 0, 448 },
    { 449, 901, 196608, 0, 449 },
    { 450, 904, 196608, 0, 450 },
    { 451, 906, 196608, 0, 451 },
    { 453, 909, 196608, 0, 453 },
    { 454, 911, 196608, 0, 454 },
    { 455, 913, 196608, 0, 455 },
    { 456, 915, 196608, 0, 456 },
    { 457, 917, 196608, 0, 457 },
    { 458, 919, 196608, 0, 458 },
    { 460, 922, 196608, 0, 460 },
    { 459, 922, 196608, 0, 459 },
    { 461, 925, 196608, 0, 461 },
    { 463, 931, 196608, 0, 463 },
    { 462, 931, 196608, 0, 462 },
    { 464, 937, 196608, 0, 464 },
    { 469, 946, 196608, 0, 469 },
    { 465, 943, 49152, 0, 465 },
    { 466, 945, 49152, 0, 466 },
    { 467, 947, 49152, 0, 467 },
    { 468, 949, 49152, 0, 468 },
    { 470, 952, 49152, 0, 470 },
    { 471, 954, 49152, 0, 471 },
    { 472, 956, 49152, 0, 472 },
    { 473, 958, 49152, 0, 473 },
    { 474, 960, 49152, 0, 474 },
    { 475, 962, 49152, 0, 475 },
    { 476, 964, 49152, 0, 476 },
    { 477, 966, 49152, 0, 477 },
    { 482, 972, 49152, 0, 482 },
    { 483, 974, 49152, 0, 483 },
    { 484, 976, 49152, 0, 484 },
    { 485, 978, 49152, 0, 485 },
    { 486, 980, 49152, 0, 486 },
    { 487, 982, 49152, 0, 487 },
    { 488, 984, 49152, 0, 488 },
    { 489, 986, 49152, 0, 489 },
    { 478, 976, 49152, 0, 478 },
    { 494, 992, 49152, 0, 494 },
    { 479, 978, 49152, 0, 479 },
    { 495, 994, 49152, 0, 495 },
    { 480, 980, 49152, 0, 480 },
    { 496, 996, 49152, 0, 496 },
    { 481, 982, 49152, 0, 481 },
    { 497, 998, 49152, 0, 497 },
    { 498, 1000, 589824, 0, 498 },
    { 499, 1001, 589824, 0, 499 },
    { 500, 1002, 589824, 0, 500 },
    { 501, 1003, 589824, 0, 501 },
    { 502, 1005, 2359296, 0, 502 },
    { 503, 1007, 2359296, 0, 503 },
    { 504, 1009, 2359296, 0, 504 },
    { 66, 571, 589824, 0, 66 },
    { 505, 1011, 2359296, 0, 505 },
    { 506, 1013, 2359296, 0, 506 },
    { 507, 1018, 2359296, 0, 507 },
    { 508, 1020, 589824, 0, 508 },
    { 509, 1022, 589824, 0, 509 },
    { 510, 1024, 589824, 0, 510 },
    { 511, 1026, 589824, 0, 511 },
    { 512, 1028, 589824, 0, 512 },
    { 490, 1006, 49152, 0, 490 },
    { 513, 1030, 589824, 0, 513 },
    { 491, 1008, 49152, 0, 491 },
    { 514, 1032, 589824, 0, 514 },
    { 492, 1010, 49152, 0, 492 },
    { 515, 1034, 589824, 0, 515 },
    { 493, 1012, 49152, 0, 493 },
    { 516, 1036, 49152, 0, 516 },
    { 517, 1037, 49152, 0, 517 },
    { 518, 1038, 49152, 0, 518 },
    { 519, 1039, 49152, 0, 519 },
    { 520, 1041, 196608, 0, 520 },
    { 521, 1043, 196608, 0, 521 },
    { 522, 1045, 196608, 0, 522 },
    { 523, 1047, 196608, 0, 523 },
    { 524, 1049, 196608, 0, 524 },
    { 452, 977, 196608, 0, 452 },
    { 525, 1051, 196608, 0, 525 },
    { 526, 1053, 196608, 0, 526 },
    { 528, 1057, 196608, 0, 528 },
    { 529, 1059, 786432, 0, 529 },
    { 530, 1061, 786432, 0, 530 },
    { 531, 1063, 196608, 0, 531 },
    { 532, 1065, 196608, 0, 532 },
    { 527, 1060, 196608, 0, 527 },
    { 533, 1067, 196608, 0, 533 },
    { 534, 1069, 196608, 0, 534 },
    { 536, 1073, 196608, 0, 536 },
    { 537, 1075, 786432, 0, 537 },
    { 538, 1077, 786432, 0, 538 },
    { 539, 1079, 196608, 0, 539 },
    { 540, 1081, 196608, 0, 540 },
    { 535, 1076, 196608, 0, 535 },
    { 541, 1083, 196608, 0, 541 },
    { 542, 1085, 196608, 0, 542 },
    { 544, 1089, 196608, 0, 544 },
    { 545, 1091, 786432, 0, 545 },
    { 546, 1093, 786432, 0, 546 },
    { 547, 1095, 196608, 0, 547 },
    { 548, 1097, 196608, 0, 548 },
    { 543, 1092, 196608, 0, 543 },
    { 549, 1099, 196608, 0, 549 },
    { 550, 1101, 196608, 0, 550 },
    { 552, 1105, 196608, 0, 552 },
    { 553, 1107, 786432, 0, 553 },
    { 554, 1109, 786432, 0, 554 },
    { 555, 1111, 196608, 0, 555 },
    { 556, 1113, 196608, 0, 556 },
    { 551, 1108, 196608, 0, 551 },
    { 557, 1115, 196608, 0, 557 },
    { 558, 1117, 196608, 0, 558 },
    { 559, 1119, 196608, 0, 559 },
    { 560, 1121, 196608, 0, 560 },
    { 561, 1123, 786432, 0, 561 },
    { 562, 1125, 786432, 0, 562 },
    { 447, 1010, 786432, 0, 447 },
    { 563, 1127, 786432, 0, 563 },
    { 564, 1129, 786432, 0, 564 },
    { 566, 1135, 786432, 0, 566 },
    { 567, 1137, 196608, 0, 567 },
    { 568, 1140, 196608, 0, 568 },
    { 569, 1142, 196608, 0, 569 },
    { 571, 1145, 196608, 0, 571 },
    { 572, 1147, 196608, 0, 572 },
    { 573, 1149, 196608, 0, 573 },
    { 574, 1151, 196608, 0, 574 },
    { 575, 1153, 196608, 0, 575 },
    { 576, 1155, 196608, 0, 576 },
    { 578, 1158, 196608, 0, 578 },
    { 577, 1158, 196608, 0, 577 },
    { 579, 1161, 196608, 0, 579 },
    { 581, 1167, 196608, 0, 581 },
    { 580, 1167, 196608, 0, 580 },
    { 582, 1173, 196608, 0, 582 },
    { 587, 1182, 196608, 0, 587 },
    { 583, 1179, 49152, 0, 583 },
    { 584, 1181, 49152, 0, 584 },
    { 585, 1183, 49152, 0, 585 },
    { 586, 1185, 49152, 0, 586 },
    { 588, 1188, 49152, 0, 588 },
    { 589, 1190, 49152, 0, 589 },
    { 590, 1192, 49152, 0, 590 },
    { 591, 1194, 49152, 0, 591 },
    { 592, 1196, 49152, 0, 592 },
    { 593, 1198, 49152, 0, 593 },
    { 594, 1200, 49152, 0, 594 },
    { 595, 1202, 49152, 0, 595 },
    { 600, 1208, 49152, 0, 600 },
    { 601, 1210, 49152, 0, 601 },
    { 602, 1212, 49152, 0, 602 },
    { 603, 1214, 49152, 0, 603 },
    { 604, 1216, 49152, 0, 604 },
    { 605, 1218, 49152, 0, 605 },
    { 606, 1220, 49152, 0, 606 },
    { 607, 1222, 49152, 0, 607 },
    { 596, 1212, 49152, 0, 596 },
    { 612, 1228, 49152, 0, 612 },
    { 597, 1214, 49152, 0, 597 },
    { 613, 1230, 49152, 0, 613 },
    { 598, 1216, 49152, 0, 598 },
    { 614, 1232, 49152, 0, 614 },
    { 599, 1218, 49152, 0, 599 },
    { 615, 1234, 49152, 0, 615 },
    { 616, 1236, 589824, 0, 616 },
    { 617, 1237, 589824, 0, 617 },
    { 618, 1238, 589824, 0, 618 },
    { 619, 1239, 589824, 0, 619 },
    { 620, 1241, 2359296, 0, 620 },
    { 621, 1243, 2359296, 0, 621 },
    { 622, 1245, 2359296, 0, 622 },
    { 67, 690, 589824, 0, 67 },
    { 623, 1247, 2359296, 0, 623 },
    { 624, 1249, 2359296, 0, 624 },
    { 625, 1254, 2359296, 0, 625 },
    { 626, 1256, 589824, 0, 626 },
    { 627, 1258, 589824, 0, 627 },
    { 628, 1260, 589824, 0, 628 },
    { 629, 1262, 589824, 0, 629 },
    { 630, 1264, 589824, 0, 630 },
    { 608, 1242, 49152, 0, 608 },
    { 631, 1266, 589824, 0, 631 },
    { 609, 1244, 49152, 0, 609 },
    { 632, 1268, 589824, 0, 632 },
    { 610, 1246, 49152, 0, 610 },
    { 633, 1270, 589824, 0, 633 },
    { 611, 1248, 49152, 0, 611 },
    { 634, 1272, 49152, 0, 634 },
    { 635, 1273, 49152, 0, 635 },
    { 636, 1274, 49152, 0, 636 },
    { 637, 1275, 49152, 0, 637 },
    { 638, 1277, 196608, 0, 638 },
    { 639, 1279, 196608, 0, 639 },
    { 640, 1281, 196608, 0, 640 },
    { 641, 1283, 196608, 0, 641 },
    { 642, 1285, 196608, 0, 642 },
    { 570, 1213, 196608, 0, 570 },
    { 643, 1287, 196608, 0, 643 },
    { 644, 1289, 196608, 0, 644 },
    { 646, 1293, 196608, 0, 646 },
    { 647, 1295, 786432, 0, 647 },
    { 648, 1297, 786432, 0, 648 },
    { 649, 1299, 196608, 0, 649 },
    { 650, 1301, 196608, 0, 650 },
    { 645, 1296, 196608, 0, 645 },
    { 651, 1303, 196608, 0, 651 },
    { 652, 1305, 196608, 0, 652 },
    { 654, 1309, 196608, 0, 654 },
    { 655, 1311, 786432, 0, 655 },
    { 656, 1313, 786432, 0, 656 },
    { 657, 1315, 196608, 0, 657 },
    { 658, 1317, 196608, 0, 658 },
    { 653, 1312, 196608, 0, 653 },
    { 659, 1319, 196608, 0, 659 },
    { 660, 1321, 196608, 0, 660 },
    { 662, 1325, 196608, 0, 662 },
    { 663, 1327, 786432, 0, 663 },
    { 664, 1329, 786432, 0, 664 },
    { 665, 1331, 196608, 0, 665 },
    { 666, 1333, 196608, 0, 666 },
    { 661, 1328, 196608, 0, 661 },
    { 667, 1335, 196608, 0, 667 },
    { 668, 1337, 196608, 0, 668 },
    { 670, 1341, 196608, 0, 670 },
    { 671, 1343, 786432, 0, 671 },
    { 672, 1345, 786432, 0, 672 },
    { 673, 1347, 196608, 0, 673 },
    { 674, 1349, 196608, 0, 674 },
    { 669, 1344, 196608, 0, 669 },
    { 675, 1351, 196608, 0, 675 },
    { 676, 1353, 196608, 0, 676 },
    { 677, 1355, 196608, 0, 677 },
    { 678, 1357, 196608, 0, 678 },
    { 679, 1359, 786432, 0, 679 },
    { 680, 1361, 786432, 0, 680 },
    { 565, 1246, 786432, 0, 565 },
    { 681, 1363, 786432, 0, 681 },
    { 682, 1365, 786432, 0, 682 },
    { 684, 1371, 786432, 0, 684 },
    { 685, 1373, 196608, 0, 685 },
    { 686, 1376, 196608, 0, 686 },
    { 687, 1378, 196608, 0, 687 },
    { 689, 1381, 196608, 0, 689 },
    { 690, 1383, 196608, 0, 690 },
    { 691, 1385, 196608, 0, 691 },
    { 692, 1387, 196608, 0, 692 },
    { 693, 1389, 196608, 0, 693 },
    { 694, 1391, 196608, 0, 694 },
    { 696, 1394, 196608, 0, 696 },
    { 695, 1394, 196608, 0, 695 },
    { 697, 1397, 196608, 0, 697 },
    { 699, 1403, 196608, 0, 699 },
    { 698, 1403, 196608, 0, 698 },
    { 700, 1409, 196608, 0, 700 },
    { 705, 1418, 196608, 0, 705 },
    { 701, 1415, 49152, 0, 701 },
    { 702, 1417, 49152, 0, 702 },
    { 703, 1419, 49152, 0, 703 },
    { 704, 1421, 49152, 0, 704 },
    { 706, 1424, 49152, 0, 706 },
    { 707, 1426, 49152, 0, 707 },
    { 708, 1428, 49152, 0, 708 },
    { 709, 1430, 49152, 0, 709 },
    { 710, 1432, 49152, 0, 710 },
    { 711, 1434, 49152, 0, 711 },
    { 712, 1436, 49152, 0, 712 },
    { 713, 1438, 49152, 0, 713 },
    { 718, 1444, 49152, 0, 718 },
    { 719, 1446, 49152, 0, 719 },
    { 720, 1448, 49152, 0, 720 },
    { 721, 1450, 49152, 0, 721 },
    { 722, 1452, 49152, 0, 722 },
    { 723, 1454, 49152, 0, 723 },
    { 724, 1456, 49152, 0, 724 },
    { 725, 1458, 49152, 0, 725 },
    { 714, 1448, 49152, 0, 714 },
    { 730, 1464, 49152, 0, 730 },
    { 715, 1450, 49152, 0, 715 },
    { 731, 1466, 49152, 0, 731 },
    { 716, 1452, 49152, 0, 716 },
    { 732, 1468, 49152, 0, 732 },
    { 717, 1454, 49152, 0, 717 },
    { 733, 1470, 49152, 0, 733 },
    { 734, 1472, 589824, 0, 734 },
    { 735, 1473, 589824, 0, 735 },
    { 736, 1474, 589824, 0, 736 },
    { 737, 1475, 589824, 0, 737 },
    { 738, 1477, 2359296, 0, 738 },
    { 739, 1479, 2359296, 0, 739 },
    { 740, 1481, 2359296, 0, 740 },
    { 68, 809, 589824, 0, 68 },
    { 741, 1483, 2359296, 0, 741 },
    { 742, 1485, 2359296, 0, 742 },
    { 743, 1490, 2359296, 0, 743 },
    { 744, 1492, 589824, 0, 744 },
    { 745, 1494, 589824, 0, 745 },
    { 746, 1496, 589824, 0, 746 },
    { 747, 1498, 589824, 0, 747 },
    { 748, 1500, 589824, 0, 748 },
    { 726, 1478, 49152, 0, 726 },
    { 749, 1502, 589824, 0, 749 },
    { 727, 1480, 49152, 0, 727 },
    { 750, 1504, 589824, 0, 750 },
    { 728, 1482, 49152, 0, 728 },
    { 751, 1506, 589824, 0, 751 },
    { 729, 1484, 49152, 0, 729 },
    { 752, 1508, 49152, 0, 752 },
    { 753, 1509, 49152, 0, 753 },
    { 754, 1510, 49152, 0, 754 },
    { 755, 1511, 49152, 0, 755 },
    { 756, 1513, 196608, 0, 756 },
    { 757, 1515, 196608, 0, 757 },
    { 758, 1517, 196608, 0, 758 },
    { 759, 1519, 196608, 0, 759 },
    { 760, 1521, 196608, 0, 760 },
    { 688, 1449, 196608, 0, 688 },
    { 761, 1523, 196608, 0, 761 },
    { 762, 1525, 196608, 0, 762 },
    { 764, 1529, 196608, 0, 764 },
    { 765, 1531, 786432, 0, 765 },
    { 766, 1533, 786432, 0, 766 },
    { 767, 1535, 196608, 0, 767 },
    { 768, 1537, 196608, 0, 768 },
    { 763, 1532, 196608, 0, 763 },
    { 769, 1539, 196608, 0, 769 },
    { 770, 1541, 196608, 0, 770 },
    { 772, 1545, 196608, 0, 772 },
    { 773, 1547, 786432, 0, 773 },
    { 774, 1549, 786432, 0, 774 },
    { 775, 1551, 196608, 0, 775 },
    { 776, 1553, 196608, 0, 776 },
    { 771, 1548, 196608, 0, 771 },
    { 777, 1555, 196608, 0, 777 },
    { 778, 1557, 196608, 0, 778 },
    { 780, 1561, 196608, 0, 780 },
    { 781, 1563, 786432, 0, 781 },
    { 782, 1565, 786432, 0, 782 },
    { 783, 1567, 196608, 0, 783 },
    { 784, 1569, 196608, 0, 784 },
    { 779, 1564, 196608, 0, 779 },
    { 785, 1571, 196608, 0, 785 },
    { 786, 1573, 196608, 0, 786 },
    { 788, 1577, 196608, 0, 788 },
    { 789, 1579, 786432, 0, 789 },
    { 790, 1581, 786432, 0, 790 },
    { 791, 1583, 196608, 0, 791 },
    { 792, 1585, 196608, 0, 792 },
    { 787, 1580, 196608, 0, 787 },
    { 793, 1587, 196608, 0, 793 },
    { 794, 1589, 196608, 0, 794 },
    { 795, 1591, 196608, 0, 795 },
    { 796, 1593, 196608, 0, 796 },
    { 797, 1595, 786432, 0, 797 },
    { 798, 1597, 786432, 0, 798 },
    { 683, 1482, 786432, 0, 683 },
    { 799, 1599, 786432, 0, 799 },
    { 800, 1601, 786432, 0, 800 },
    { 802, 1607, 786432, 0, 802 },
    { 803, 1609, 196608, 0, 803 },
    { 804, 1612, 196608, 0, 804 },
    { 805, 1614, 196608, 0, 805 },
    { 807, 1617, 196608, 0, 807 },
    { 808, 1619, 196608, 0, 808 },
    { 809, 1621, 196608, 0, 809 },
    { 810, 1623, 196608, 0, 810 },
    { 811, 1625, 196608, 0, 811 },
    { 812, 1627, 196608, 0, 812 },
    { 814, 1630, 196608, 0, 814 },
    { 813, 1630, 196608, 0, 813 },
    { 815, 1633, 196608, 0, 815 },
    { 817, 1639, 196608, 0, 817 },
    { 816, 1639, 196608, 0, 816 },
    { 818, 1645, 196608, 0, 818 },
    { 823, 1654, 196608, 0, 823 },
    { 819, 1651, 49152, 0, 819 },
    { 820, 1653, 49152, 0, 820 },
    { 821, 1655, 49152, 0, 821 },
    { 822, 1657, 49152, 0, 822 },
    { 824, 1660, 49152, 0, 824 },
    { 825, 1662, 49152, 0, 825 },
    { 826, 1664, 49152, 0, 826 },
    { 827, 1666, 49152, 0, 827 },
    { 828, 1668, 49152, 0, 828 },
    { 829, 1670, 49152, 0, 829 },
    { 830, 1672, 49152, 0, 830 },
    { 831, 1674, 49152, 0, 831 },
    { 836, 1680, 49152, 0, 836 },
    { 837, 1682, 49152, 0, 837 },
    { 838, 1684, 49152, 0, 838 },
    { 839, 1686, 49152, 0, 839 },
    { 840, 1688, 49152, 0, 840 },
    { 841, 1690, 49152, 0, 841 },
    { 842, 1692, 49152, 0, 842 },
    { 843, 1694, 49152, 0, 843 },
    { 832, 1684, 49152, 0, 832 },
    { 848, 1700, 49152, 0, 848 },
    { 833, 1686, 49152, 0, 833 },
    { 849, 1702, 49152, 0, 849 },
    { 834, 1688, 49152, 0, 834 },
    { 850, 1704, 49152, 0, 850 },
    { 835, 1690, 49152, 0, 835 },
    { 851, 1706, 49152, 0, 851 },
    { 852, 1708, 589824, 0, 852 },
    { 853, 1709, 589824, 0, 853 },
    { 854, 1710, 589824, 0, 854 },
    { 855, 1711, 589824, 0, 855 },
    { 856, 1713, 2359296, 0, 856 },
    { 857, 1715, 2359296, 0, 857 },
    { 858, 1717, 2359296, 0, 858 },
    { 69, 928, 589824, 0, 69 },
    { 859, 1719, 2359296, 0, 859 },
    { 860, 1721, 2359296, 0, 860 },
    { 861, 1726, 2359296, 0, 861 },
    { 862, 1728, 589824, 0, 862 },
    { 863, 1730, 589824, 0, 863 },
    { 864, 1732, 589824, 0, 864 },
    { 865, 1734, 589824, 0, 865 },
    { 866, 1736, 589824, 0, 866 },
    { 844, 1714, 49152, 0, 844 },
    { 867, 1738, 589824, 0, 867 },
    { 845, 1716, 49152, 0, 845 },
    { 868, 1740, 589824, 0, 868 },
    { 846, 1718, 49152, 0, 846 },
    { 869, 1742, 589824, 0, 869 },
    { 847, 1720, 49152, 0, 847 },
    { 870, 1744, 49152, 0, 870 },
    { 871, 1745, 49152, 0, 871 },
    { 872, 1746, 49152, 0, 872 },
    { 873, 1747, 49152, 0, 873 },
    { 874, 1749, 196608, 0, 874 },
    { 875, 1751, 196608, 0, 875 },
    { 876, 1753, 196608, 0, 876 },
    { 877, 1755, 196608, 0, 877 },
    { 878, 1757, 196608, 0, 878 },
    { 806, 1685, 196608, 0, 806 },
    { 879, 1759, 196608, 0, 879 },
    { 880, 1761, 196608, 0, 880 },
    { 882, 1765, 196608, 0, 882 },
    { 883, 1767, 786432, 0, 883 },
    { 884, 1769, 786432, 0, 884 },
    { 885, 1771, 196608, 0, 885 },
    { 886, 1773, 196608, 0, 886 },
    { 881, 1768, 196608, 0, 881 },
    { 887, 1775, 196608, 0, 887 },
    { 888, 1777, 196608, 0, 888 },
    { 890, 1781, 196608, 0, 890 },
    { 891, 1783, 786432, 0, 891 },
    { 892, 1785, 786432, 0, 892 },
    { 893, 1787, 196608, 0, 893 },
    { 894, 1789, 196608, 0, 894 },
    { 889, 1784, 196608, 0, 889 },
    { 895, 1791, 196608, 0, 895 },
    { 896, 1793, 196608, 0, 896 },
    { 898, 1797, 196608, 0, 898 },
    { 899, 1799, 786432, 0, 899 },
    { 900, 1801, 786432, 0, 900 },
    { 901, 1803, 196608, 0, 901 },
    { 902, 1805, 196608, 0, 902 },
    { 897, 1800, 196608, 0, 897 },
    { 903, 1807, 196608, 0, 903 },
    { 904, 1809, 196608, 0, 904 },
    { 906, 1813, 196608, 0, 906 },
    { 907, 1815, 786432, 0, 907 },
    { 908, 1817, 786432, 0, 908 },
    { 909, 1819, 196608, 0, 909 },
    { 910, 1821, 196608, 0, 910 },
    { 905, 1816, 196608, 0, 905 },
    { 911, 1823, 196608, 0, 911 },
    { 912, 1825, 196608, 0, 912 },
    { 913, 1827, 196608, 0, 913 },
    { 914, 1829, 196608, 0, 914 },
    { 915, 1831, 786432, 0, 915 },
    { 916, 1833, 786432, 0, 916 },
    { 801, 1718, 786432, 0, 801 },
    { 917, 1835, 786432, 0, 917 },
    { 918, 1837, 786432, 0, 918 },
    { 920, 1843, 786432, 0, 920 },
    { 921, 1845, 196608, 0, 921 },
    { 922, 1848, 196608, 0, 922 },
    { 923, 1850, 196608, 0, 923 },
    { 925, 1853, 196608, 0, 925 },
    { 926, 1855, 196608, 0, 926 },
    { 927, 1857, 196608, 0, 927 },
    { 928, 1859, 196608, 0, 928 },
    { 929, 1861, 196608, 0, 929 },
    { 930, 1863, 196608, 0, 930 },
    { 932, 1866, 196608, 0, 932 },
    { 931, 1866, 196608, 0, 931 },
    { 933, 1869, 196608, 0, 933 },
    { 935, 1875, 196608, 0, 935 },
    { 934, 1875, 196608, 0, 934 },
    { 936, 1881, 196608, 0, 936 },
    { 941, 1890, 196608, 0, 941 },
    { 937, 1887, 49152, 0, 937 },
    { 938, 1889, 49152, 0, 938 },
    { 939, 1891, 49152, 0, 939 },
    { 940, 1893, 49152, 0, 940 },
    { 942, 1896, 49152, 0, 942 },
    { 943, 1898, 49152, 0, 943 },
    { 944, 1900, 49152, 0, 944 },
    { 945, 1902, 49152, 0, 945 },
    { 946, 1904, 49152, 0, 946 },
    { 947, 1906, 49152, 0, 947 },
    { 948, 1908, 49152, 0, 948 },
    { 949, 1910, 49152, 0, 949 },
    { 954, 1916, 49152, 0, 954 },
    { 955, 1918, 49152, 0, 955 },
    { 956, 1920, 49152, 0, 956 },
    { 957, 1922, 49152, 0, 957 },
    { 958, 1924, 49152, 0, 958 },
    { 959, 1926, 49152, 0, 959 },
    { 960, 1928, 49152, 0, 960 },
    { 961, 1930, 49152, 0, 961 },
    { 950, 1920, 49152, 0, 950 },
    { 966, 1936, 49152, 0, 966 },
    { 951, 1922, 49152, 0, 951 },
    { 967, 1938, 49152, 0, 967 },
    { 952, 1924, 49152, 0, 952 },
    { 968, 1940, 49152, 0, 968 },
    { 953, 1926, 49152, 0, 953 },
    { 969, 1942, 49152, 0, 969 },
    { 970, 1944, 589824, 0, 970 },
    { 971, 1945, 589824, 0, 971 },
    { 972, 1946, 589824, 0, 972 },
    { 973, 1947, 589824, 0, 973 },
    { 974, 1949, 2359296, 0, 974 },
    { 975, 1951, 2359296, 0, 975 },
    { 976, 1953, 2359296, 0, 976 },
    { 70, 1047, 589824, 0, 70 },
    { 977, 1955, 2359296, 0, 977 },
    { 978, 1957, 2359296, 0, 978 },
    { 979, 1962, 2359296, 0, 979 },
    { 980, 1964, 589824, 0, 980 },
    { 981, 1966, 589824, 0, 981 },
    { 982, 1968, 589824, 0, 982 },
    { 983, 1970, 589824, 0, 983 },
    { 984, 1972, 589824, 0, 984 },
    { 962, 1950, 49152, 0, 962 },
    { 985, 1974, 589824, 0, 985 },
    { 963, 1952, 49152, 0, 963 },
    { 986, 1976, 589824, 0, 986 },
    { 964, 1954, 49152, 0, 964 },
    { 987, 1978, 589824, 0, 987 },
    { 965, 1956, 49152, 0, 965 },
    { 988, 1980, 49152, 0, 988 },
    { 989, 1981, 49152, 0, 989 },
    { 990, 1982, 49152, 0, 990 },
    { 991, 1983, 49152, 0, 991 },
    { 992, 1985, 196608, 0, 992 },
    { 993, 1987, 196608, 0, 993 },
    { 994, 1989, 196608, 0, 994 },
    { 995, 1991, 196608, 0, 995 },
    { 996, 1993, 196608, 0, 996 },
    { 924, 1921, 196608, 0, 924 },
    { 997, 1995, 196608, 0, 997 },
    { 998, 1997, 196608, 0, 998 },
    { 1000, 2001, 196608, 0, 1000 },
    { 1001, 2003, 786432, 0, 1001 },
    { 1002, 2005, 786432, 0, 1002 },
    { 1003, 2007, 196608, 0, 1003 },
    { 1004, 2009, 196608, 0, 1004 },
    { 999, 2004, 196608, 0, 999 },
    { 1005, 2011, 196608, 0, 1005 },
    { 1006, 2013, 196608, 0, 1006 },
    { 1008, 2017, 196608, 0, 1008 },
    { 1009, 2019, 786432, 0, 1009 },
    { 1010, 2021, 786432, 0, 1010 },
    { 1011, 2023, 196608, 0, 1011 },
    { 1012, 2025, 196608, 0, 1012 },
    { 1007, 2020, 196608, 0, 1007 },
    { 1013, 2027, 196608, 0, 1013 },
    { 1014, 2029, 196608, 0, 1014 },
    { 1016, 2033, 196608, 0, 1016 },
    { 1017, 2035, 786432, 0, 1017 },
    { 1018, 2037, 786432, 0, 1018 },
    { 1019, 2039, 196608, 0, 1019 },
    { 1020, 2041, 196608, 0, 1020 },
    { 1015, 2036, 196608, 0, 1015 },
    { 1021, 2043, 196608, 0, 1021 },
    { 1022, 2045, 196608, 0, 1022 },
    { 1024, 2049, 196608, 0, 1024 },
    { 1025, 2051, 786432, 0, 1025 },
    { 1026, 2053, 786432, 0, 1026 },
    { 1027, 2055, 196608, 0, 1027 },
    { 1028, 2057, 196608, 0, 1028 },
    { 1023, 2052, 196608, 0, 1023 },
    { 1029, 2059, 196608, 0, 1029 },
    { 1030, 2061, 196608, 0, 1030 },
    { 1031, 2063, 196608, 0, 1031 },
    { 1032, 2065, 196608, 0, 1032 },
    { 1033, 2067, 786432, 0, 1033 },
    { 1034, 2069, 786432, 0, 1034 },
    { 919, 1954, 786432, 0, 919 },
    { 1035, 2071, 786432, 0, 1035 },
    { 1036, 2073, 786432, 0, 1036 },
    { 1038, 2079, 786432, 0, 1038 },
    { 1039, 2081, 196608, 0, 1039 },
    { 1040, 2084, 196608, 0, 1040 },
    { 1041, 2086, 196608, 0, 1041 },
    { 1043, 2089, 196608, 0, 1043 },
    { 1044, 2091, 196608, 0, 1044 },
    { 1045, 2093, 196608, 0, 1045 },
    { 1046, 2095, 196608, 0, 1046 },
    { 1047, 2097, 196608, 0, 1047 },
    { 1048, 2099, 196608, 0, 1048 },
    { 1050, 2102, 196608, 0, 1050 },
    { 1049, 2102, 196608, 0, 1049 },
    { 1051, 2105, 196608, 0, 1051 },
    { 1053, 2111, 196608, 0, 1053 },
    { 1052, 2111, 196608, 0, 1052 },
    { 1054, 2117, 196608, 0, 1054 },
    { 1059, 2126, 196608, 0, 1059 },
    { 1055, 2123, 49152, 0, 1055 },
    { 1056, 2125, 49152, 0, 1056 },
    { 1057, 2127, 49152, 0, 1057 },
    { 1058, 2129, 49152, 0, 1058 },
    { 1060, 2132, 49152, 0, 1060 },
    { 1061, 2134, 49152, 0, 1061 },
    { 1062, 2136, 49152, 0, 1062 },
    { 1063, 2138, 49152, 0, 1063 },
    { 1064, 2140, 49152, 0, 1064 },
    { 1065, 2142, 49152, 0, 1065 },
    { 1066, 2144, 49152, 0, 1066 },
    { 1067, 2146, 49152, 0, 1067 },
    { 1072, 2152, 49152, 0, 1072 },
    { 1073, 2154, 49152, 0, 1073 },
    { 1074, 2156, 49152, 0, 1074 },
    { 1075, 2158, 49152, 0, 1075 },
    { 1076, 2160, 49152, 0, 1076 },
    { 1077, 2162, 49152, 0, 1077 },
    { 1078, 2164, 49152, 0, 1078 },
    { 1079, 2166, 49152, 0, 1079 },
    { 1068, 2156, 49152, 0, 1068 },
    { 1084, 2172, 49152, 0, 1084 },
    { 1069, 2158, 49152, 0, 1069 },
    { 1085, 2174, 49152, 0, 1085 },
    { 1070, 2160, 49152, 0, 1070 },
    { 1086, 2176, 49152, 0, 1086 },
    { 1071, 2162, 49152, 0, 1071 },
    { 1087, 2178, 49152, 0, 1087 },
    { 1088, 2180, 589824, 0, 1088 },
    { 1089, 2181, 589824, 0, 1089 },
    { 1090, 2182, 589824, 0, 1090 },
    { 1091, 2183, 589824, 0, 1091 },
    { 1092, 2185, 2359296, 0, 1092 },
    { 1093, 2187, 2359296, 0, 1093 },
    { 1094, 2189, 2359296, 0, 1094 },
    { 71, 1166, 589824, 0, 71 },
    { 1095, 2191, 2359296, 0, 1095 },
    { 1096, 2193, 2359296, 0, 1096 },
    { 1097, 2198, 2359296, 0, 1097 },
    { 1098, 2200, 589824, 0, 1098 },
    { 1099, 2202, 589824, 0, 1099 },
    { 1100, 2204, 589824, 0, 1100 },
    { 1101, 2206, 589824, 0, 1101 },
    { 1102, 2208, 589824, 0, 1102 },
    { 1080, 2186, 49152, 0, 1080 },
    { 1103, 2210, 589824, 0, 1103 },
    { 1081, 2188, 49152, 0, 1081 },
    { 1104, 2212, 589824, 0, 1104 },
    { 1082, 2190, 49152, 0, 1082 },
    { 1105, 2214, 589824, 0, 1105 },
    { 1083, 2192, 49152, 0, 1083 },
    { 1106, 2216, 49152, 0, 1106 },
    { 1107, 2217, 49152, 0, 1107 },
    { 1108, 2218, 49152, 0, 1108 },
    { 1109, 2219, 49152, 0, 1109 },
    { 1110, 2221, 196608, 0, 1110 },
    { 1111, 2223, 196608, 0, 1111 },
    { 1112, 2225, 196608, 0, 1112 },
    { 1113, 2227, 196608, 0, 1113 },
    { 1114, 2229, 196608, 0, 1114 },
    { 1042, 2157, 196608, 0, 1042 },
    { 1115, 2231, 196608, 0, 1115 },
    { 1116, 2233, 196608, 0, 1116 },
    { 1118, 2237, 196608, 0, 1118 },
    { 1119, 2239, 786432, 0, 1119 },
    { 1120, 2241, 786432, 0, 1120 },
    { 1121, 2243, 196608, 0, 1121 },
    { 1122, 2245, 196608, 0, 1122 },
    { 1117, 2240, 196608, 0, 1117 },
    { 1123, 2247, 196608, 0, 1123 },
    { 1124, 2249, 196608, 0, 1124 },
    { 1126, 2253, 196608, 0, 1126 },
    { 1127, 2255, 786432, 0, 1127 },
    { 1128, 2257, 786432, 0, 1128 },
    { 1129, 2259, 196608, 0, 1129 },
    { 1130, 2261, 196608, 0, 1130 },
    { 1125, 2256, 196608, 0, 1125 },
    { 1131, 2263, 196608, 0, 1131 },
    { 1132, 2265, 196608, 0, 1132 },
    { 1134, 2269, 196608, 0, 1134 },
    { 1135, 2271, 786432, 0, 1135 },
    { 1136, 2273, 786432, 0, 1136 },
    { 1137, 2275, 196608, 0, 1137 },
    { 1138, 2277, 196608, 0, 1138 },
    { 1133, 2272, 196608, 0, 1133 },
    { 1139, 2279, 196608, 0, 1139 },
    { 1140, 2281, 196608, 0, 1140 },
    { 1142, 2285, 196608, 0, 1142 },
    { 1143, 2287, 786432, 0, 1143 },
    { 1144, 2289, 786432, 0, 1144 },
    { 1145, 2291, 196608, 0, 1145 },
    { 1146, 2293, 196608, 0, 1146 },
    { 1141, 2288, 196608, 0, 1141 },
    { 1147, 2295, 196608, 0, 1147 },
    { 1148, 2297, 196608, 0, 1148 },
    { 1149, 2299, 196608, 0, 1149 },
    { 1150, 2301, 196608, 0, 1150 },
    { 1151, 2303, 786432, 0, 1151 },
    { 1152, 2305, 786432, 0, 1152 },
    { 1037, 2190, 786432, 0, 1037 },
    { 1153, 2307, 786432, 0, 1153 },
    { 1154, 2309, 786432, 0, 1154 },
    { 1156, 2315, 786432, 0, 1156 },
    { 1157, 2317, 196608, 0, 1157 },
    { 1158, 2320, 196608, 0, 1158 },
    { 1159, 2322, 196608, 0, 1159 },
    { 1161, 2325, 196608, 0, 1161 },
    { 1162, 2327, 196608, 0, 1162 },
    { 1163, 2329, 196608, 0, 1163 },
    { 1164, 2331, 196608, 0, 1164 },
    { 1165, 2333, 196608, 0, 1165 },
    { 1166, 2335, 196608, 0, 1166 },
    { 1168, 2338, 196608, 0, 1168 },
    { 1167, 2338, 196608, 0, 1167 },
    { 1169, 2341, 196608, 0, 1169 },
    { 1171, 2347, 196608, 0, 1171 },
    { 1170, 2347, 196608, 0, 1170 },
    { 1172, 2353, 196608, 0, 1172 },
    { 1177, 2362, 196608, 0, 1177 },
    { 1173, 2359, 49152, 0, 1173 },
    { 1174, 2361, 49152, 0, 1174 },
    { 1175, 2363, 49152, 0, 1175 },
    { 1176, 2365, 49152, 0, 1176 },
    { 1178, 2368, 49152, 0, 1178 },
    { 1179, 2370, 49152, 0, 1179 },
    { 1180, 2372, 49152, 0, 1180 },
    { 1181, 2374, 49152, 0, 1181 },
    { 1182, 2376, 49152, 0, 1182 },
    { 1183, 2378, 49152, 0, 1183 },
    { 1184, 2380, 49152, 0, 1184 },
    { 1185, 2382, 49152, 0, 1185 },
    { 1190, 2388, 49152, 0, 1190 },
    { 1191, 2390, 49152, 0, 1191 },
    { 1192, 2392, 49152, 0, 1192 },
    { 1193, 2394, 49152, 0, 1193 },
    { 1194, 2396, 49152, 0, 1194 },
    { 1195, 2398, 49152, 0, 1195 },
    { 1196, 2400, 49152, 0, 1196 },
    { 1197, 2402, 49152, 0, 1197 },
    { 1186, 2392, 49152, 0, 1186 },
    { 1202, 2408, 49152, 0, 1202 },
    { 1187, 2394, 49152, 0, 1187 },
    { 1203, 2410, 49152, 0, 1203 },
    { 1188, 2396, 49152, 0, 1188 },
    { 1204, 2412, 49152, 0, 1204 },
    { 1189, 2398, 49152, 0, 1189 },
    { 1205, 2414, 49152, 0, 1205 },
    { 1206, 2416, 589824, 0, 1206 },
    { 1207, 2417, 589824, 0, 1207 },
    { 1208, 2418, 589824, 0, 1208 },
    { 1209, 2419, 589824, 0, 1209 },
    { 1210, 2421, 2359296, 0, 1210 },
    { 1211, 2423, 2359296, 0, 1211 },
    { 1212, 2425, 2359296, 0, 1212 },
    { 72, 1285, 589824, 0, 72 },
    { 1213, 2427, 2359296, 0, 1213 },
    { 1214, 2429, 2359296, 0, 1214 },
    { 1215, 2434, 2359296, 0, 1215 },
    { 1216, 2436, 589824, 0, 1216 },
    { 1217, 2438, 589824, 0, 1217 },
    { 1218, 2440, 589824, 0, 1218 },
    { 1219, 2442, 589824, 0, 1219 },
    { 1220, 2444, 589824, 0, 1220 },
    { 1198, 2422, 49152, 0, 1198 },
    { 1221, 2446, 589824, 0, 1221 },
    { 1199, 2424, 49152, 0, 1199 },
    { 1222, 2448, 589824, 0, 1222 },
    { 1200, 2426, 49152, 0, 1200 },
    { 1223, 2450, 589824, 0, 1223 },
    { 1201, 2428, 49152, 0, 1201 },
    { 1224, 2452, 49152, 0, 1224 },
    { 1225, 2453, 49152, 0, 1225 },
    { 1226, 2454, 49152, 0, 1226 },
    { 1227, 2455, 49152, 0, 1227 },
    { 1228, 2457, 196608, 0, 1228 },
    { 1229, 2459, 196608, 0, 1229 },
    { 1230, 2461, 196608, 0, 1230 },
    { 1231, 2463, 196608, 0, 1231 },
    { 1232, 2465, 196608, 0, 1232 },
    { 1160, 2393, 196608, 0, 1160 },
    { 1233, 2467, 196608, 0, 1233 },
    { 1234, 2469, 196608, 0, 1234 },
    { 1236, 2473, 196608, 0, 1236 },
    { 1237, 2475, 786432, 0, 1237 },
    { 1238, 2477, 786432, 0, 1238 },
    { 1239, 2479, 196608, 0, 1239 },
    { 1240, 2481, 196608, 0, 1240 },
    { 1235, 2476, 196608, 0, 1235 },
    { 1241, 2483, 196608, 0, 1241 },
    { 1242, 2485, 196608, 0, 1242 },
    { 1244, 2489, 196608, 0, 1244 },
    { 1245, 2491, 786432, 0, 1245 },
    { 1246, 2493, 786432, 0, 1246 },
    { 1247, 2495, 196608, 0, 1247 },
    { 1248, 2497, 196608, 0, 1248 },
    { 1243, 2492, 196608, 0, 1243 },
    { 1249, 2499, 196608, 0, 1249 },
    { 1250, 2501, 196608, 0, 1250 },
    { 1252, 2505, 196608, 0, 1252 },
    { 1253, 2507, 786432, 0, 1253 },
    { 1254, 2509, 786432, 0, 1254 },
    { 1255, 2511, 196608, 0, 1255 },
    { 1256, 2513, 196608, 0, 1256 },
    { 1251, 2508, 196608, 0, 1251 },
    { 1257, 2515, 196608, 0, 1257 },
    { 1258, 2517, 196608, 0, 1258 },
    { 1260, 2521, 196608, 0, 1260 },
    { 1261, 2523, 786432, 0, 1261 },
    { 1262, 2525, 786432, 0, 1262 },
    { 1263, 2527, 196608, 0, 1263 },
    { 1264, 2529, 196608, 0, 1264 },
    { 1259, 2524, 196608, 0, 1259 },
    { 1265, 2531, 196608, 0, 1265 },
    { 1266, 2533, 196608, 0, 1266 },
    { 1267, 2535, 196608, 0, 1267 },
    { 1268, 2537, 196608, 0, 1268 },
    { 1269, 2539, 786432, 0, 1269 },
    { 1270, 2541, 786432, 0, 1270 },
    { 1155, 2426, 786432, 0, 1155 },
    { 1271, 2543, 786432, 0, 1271 },
    { 1272, 2545, 786432, 0, 1272 },
    { 1274, 2551, 786432, 0, 1274 },
    { 1275, 2553, 196608, 0, 1275 },
    { 1276, 2556, 196608, 0, 1276 },
    { 1277, 2558, 196608, 0, 1277 },
    { 1279, 2561, 196608, 0, 1279 },
    { 1280, 2563, 196608, 0, 1280 },
    { 1281, 2565, 196608, 0, 1281 },
    { 1282, 2567, 196608, 0, 1282 },
    { 1283, 2569, 196608, 0, 1283 },
    { 1284, 2571, 196608, 0, 1284 },
    { 1286, 2574, 196608, 0, 1286 },
    { 1285, 2574, 196608, 0, 1285 },
    { 1287, 2577, 196608, 0, 1287 },
    { 1289, 2583, 196608, 0, 1289 },
    { 1288, 2583, 196608, 0, 1288 },
    { 1290, 2589, 196608, 0, 1290 },
    { 1295, 2598, 196608, 0, 1295 },
    { 1291, 2595, 49152, 0, 1291 },
    { 1292, 2597, 49152, 0, 1292 },
    { 1293, 2599, 49152, 0, 1293 },
    { 1294, 2601, 49152, 0, 1294 },
    { 1296, 2604, 49152, 0, 1296 },
    { 1297, 2606, 49152, 0, 1297 },
    { 1298, 2608, 49152, 0, 1298 },
    { 1299, 2610, 49152, 0, 1299 },
    { 1300, 2612, 49152, 0, 1300 },
    { 1301, 2614, 49152, 0, 1301 },
    { 1302, 2616, 49152, 0, 1302 },
    { 1303, 2618, 49152, 0, 1303 },
    { 1308, 2624, 49152, 0, 1308 },
    { 1309, 2626, 49152, 0, 1309 },
    { 1310, 2628, 49152, 0, 1310 },
    { 1311, 2630, 49152, 0, 1311 },
    { 1312, 2632, 49152, 0, 1312 },
    { 1313, 2634, 49152, 0, 1313 },
    { 1314, 2636, 49152, 0, 1314 },
    { 1315, 2638, 49152, 0, 1315 },
    { 1304, 2628, 49152, 0, 1304 },
    { 1320, 2644, 49152, 0, 1320 },
    { 1305, 2630, 49152, 0, 1305 },
    { 1321, 2646, 49152, 0, 1321 },
    { 1306, 2632, 49152, 0, 1306 },
    { 1322, 2648, 49152, 0, 1322 },
    { 1307, 2634, 49152, 0, 1307 },
    { 1323, 2650, 49152, 0, 1323 },
    { 1324, 2652, 589824, 0, 1324 },
    { 1325, 2653, 589824, 0, 1325 },
    { 1326, 2654, 589824, 0, 1326 },
    { 1327, 2655, 589824, 0, 1327 },
    { 1328, 2657, 2359296, 0, 1328 },
    { 1329, 2659, 2359296, 0, 1329 },
    { 1330, 2661, 2359296, 0, 1330 },
    { 73, 1404, 589824, 0, 73 },
    { 1331, 2663, 2359296, 0, 1331 },
    { 1332, 2665, 2359296, 0, 1332 },
    { 1333, 2670, 2359296, 0, 1333 },
    { 1334, 2672, 589824, 0, 1334 },
    { 1335, 2674, 589824, 0, 1335 },
    { 1336, 2676, 589824, 0, 1336 },
    { 1337, 2678, 589824, 0, 1337 },
    { 1338, 2680, 589824, 0, 1338 },
    { 1316, 2658, 49152, 0, 1316 },
    { 1339, 2682, 589824, 0, 1339 },
    { 1317, 2660, 49152, 0, 1317 },
    { 1340, 2684, 589824, 0, 1340 },
    { 1318, 2662, 49152, 0, 1318 },
    { 1341, 2686, 589824, 0, 1341 },
    { 1319, 2664, 49152, 0, 1319 },
    { 1342, 2688, 49152, 0, 1342 },
    { 1343, 2689, 49152, 0, 1343 },
    { 1344, 2690, 49152, 0, 1344 },
    { 1345, 2691, 49152, 0, 1345 },
    { 1346, 2693, 196608, 0, 1346 },
    { 1347, 2695, 196608, 0, 1347 },
    { 1348, 2697, 196608, 0, 1348 },
    { 1349, 2699, 196608, 0, 1349 },
    { 1350, 2701, 196608, 0, 1350 },
    { 1278, 2629, 196608, 0, 1278 },
    { 1351, 2703, 196608, 0, 1351 },
    { 1352, 2705, 196608, 0, 1352 },
    { 1354, 2709, 196608, 0, 1354 },
    { 1355, 2711, 786432, 0, 1355 },
    { 1356, 2713, 786432, 0, 1356 },
    { 1357, 2715, 196608, 0, 1357 },
    { 1358, 2717, 196608, 0, 1358 },
    { 1353, 2712, 196608, 0, 1353 },
    { 1359, 2719, 196608, 0, 1359 },
    { 1360, 2721, 196608, 0, 1360 },
    { 1362, 2725, 196608, 0, 1362 },
    { 1363, 2727, 786432, 0, 1363 },
    { 1364, 2729, 786432, 0, 1364 },
    { 1365, 2731, 196608, 0, 1365 },
    { 1366, 2733, 196608, 0, 1366 },
    { 1361, 2728, 196608, 0, 1361 },
    { 1367, 2735, 196608, 0, 1367 },
    { 1368, 2737, 196608, 0, 1368 },
    { 1370, 2741, 196608, 0, 1370 },
    { 1371, 2743, 786432, 0, 1371 },
    { 1372, 2745, 786432, 0, 1372 },
    { 1373, 2747, 196608, 0, 1373 },
    { 1374, 2749, 196608, 0, 1374 },
    { 1369, 2744, 196608, 0, 1369 },
    { 1375, 2751, 196608, 0, 1375 },
    { 1376, 2753, 196608, 0, 1376 },
    { 1378, 2757, 196608, 0, 1378 },
    { 1379, 2759, 786432, 0, 1379 },
    { 1380, 2761, 786432, 0, 1380 },
    { 1381, 2763, 196608, 0, 1381 },
    { 1382, 2765, 196608, 0, 1382 },
    { 1377, 2760, 196608, 0, 1377 },
    { 1383, 2767, 196608, 0, 1383 },
    { 1384, 2769, 196608, 0, 1384 },
    { 1385, 2771, 196608, 0, 1385 },
    { 1386, 2773, 196608, 0, 1386 },
    { 1387, 2775, 786432, 0, 1387 },
    { 1388, 2777, 786432, 0, 1388 },
    { 1273, 2662, 786432, 0, 1273 },
    { 1389, 2779, 786432, 0, 1389 },
    { 1390, 2781, 786432, 0, 1390 },
    { 1392, 2787, 786432, 0, 1392 },
    { 1393, 2789, 196608, 0, 1393 },
    { 1394, 2792, 196608, 0, 1394 },
    { 1395, 2794, 196608, 0, 1395 },
    { 1397, 2797, 196608, 0, 1397 },
    { 1398, 2799, 196608, 0, 1398 },
    { 1399, 2801, 196608, 0, 1399 },
    { 1400, 2803, 196608, 0, 1400 },
    { 1401, 2805, 196608, 0, 1401 },
    { 1402, 2807, 196608, 0, 1402 },
    { 1404, 2810, 196608, 0, 1404 },
    { 1403, 2810, 196608, 0, 1403 },
    { 1405, 2813, 196608, 0, 1405 },
    { 1407, 2819, 196608, 0, 1407 },
    { 1406, 2819, 196608, 0, 1406 },
    { 1408, 2825, 196608, 0, 1408 },
    { 1413, 2834, 196608, 0, 1413 },
    { 1409, 2831, 49152, 0, 1409 },
    { 1410, 2833, 49152, 0, 1410 },
    { 1411, 2835, 49152, 0, 1411 },
    { 1412, 2837, 49152, 0, 1412 },
    { 1414, 2840, 49152, 0, 1414 },
    { 1415, 2842, 49152, 0, 1415 },
    { 1416, 2844, 49152, 0, 1416 },
    { 1417, 2846, 49152, 0, 1417 },
    { 1418, 2848, 49152, 0, 1418 },
    { 1419, 2850, 49152, 0, 1419 },
    { 1420, 2852, 49152, 0, 1420 },
    { 1421, 2854, 49152, 0, 1421 },
    { 1426, 2860, 49152, 0, 1426 },
    { 1427, 2862, 49152, 0, 1427 },
    { 1428, 2864, 49152, 0, 1428 },
    { 1429, 2866, 49152, 0, 1429 },
    { 1430, 2868, 49152, 0, 1430 },
    { 1431, 2870, 49152, 0, 1431 },
    { 1432, 2872, 49152, 0, 1432 },
    { 1433, 2874, 49152, 0, 1433 },
    { 1422, 2864, 49152, 0, 1422 },
    { 1438, 2880, 49152, 0, 1438 },
    { 1423, 2866, 49152, 0, 1423 },
    { 1439, 2882, 49152, 0, 1439 },
    { 1424, 2868, 49152, 0, 1424 },
    { 1440, 2884, 49152, 0, 1440 },
    { 1425, 2870, 49152, 0, 1425 },
    { 1441, 2886, 49152, 0, 1441 },
    { 1442, 2888, 589824, 0, 1442 },
    { 1443, 2889, 589824, 0, 1443 },
    { 1444, 2890, 589824, 0, 1444 },
    { 1445, 2891, 589824, 0, 1445 },
    { 1446, 2893, 2359296, 0, 1446 },
    { 1447, 2895, 2359296, 0, 1447 },
    { 1448, 2897, 2359296, 0, 1448 },
    { 74, 1523, 589824, 0, 74 },
    { 1449, 2899, 2359296, 0, 1449 },
    { 1450, 2901, 2359296, 0, 1450 },
    { 1451, 2906, 2359296, 0, 1451 },
    { 1452, 2908, 589824, 0, 1452 },
    { 1453, 2910, 589824, 0, 1453 },
    { 1454, 2912, 589824, 0, 1454 },
    { 1455, 2914, 589824, 0, 1455 },
    { 1456, 2916, 589824, 0, 1456 },
    { 1434, 2894, 49152, 0, 1434 },
    { 1457, 2918, 589824, 0, 1457 },
    { 1435, 2896, 49152, 0, 1435 },
    { 1458, 2920, 589824, 0, 1458 },
    { 1436, 2898, 49152, 0, 1436 },
    { 1459, 2922, 589824, 0, 1459 },
    { 1437, 2900, 49152, 0, 1437 },
    { 1460, 2924, 49152, 0, 1460 },
    { 1461, 2925, 49152, 0, 1461 },
    { 1462, 2926, 49152, 0, 1462 },
    { 1463, 2927, 49152, 0, 1463 },
    { 1464, 2929, 196608, 0, 1464 },
    { 1465, 2931, 196608, 0, 1465 },
    { 1466, 2933, 196608, 0, 1466 },
    { 1467, 2935, 196608, 0, 1467 },
    { 1468, 2937, 196608, 0, 1468 },
    { 1396, 2865, 196608, 0, 1396 },
    { 1469, 2939, 196608, 0, 1469 },
    { 1470, 2941, 196608, 0, 1470 },
    { 1472, 2945, 196608, 0, 1472 },
    { 1473, 2947, 786432, 0, 1473 },
    { 1474, 2949, 786432, 0, 1474 },
    { 1475, 2951, 196608, 0, 1475 },
    { 1476, 2953, 196608, 0, 1476 },
    { 1471, 2948, 196608, 0, 1471 },
    { 1477, 2955, 196608, 0, 1477 },
    { 1478, 2957, 196608, 0, 1478 },
    { 1480, 2961, 196608, 0, 1480 },
    { 1481, 2963, 786432, 0, 1481 },
    { 1482, 2965, 786432, 0, 1482 },
    { 1483, 2967, 196608, 0, 1483 },
    { 1484, 2969, 196608, 0, 1484 },
    { 1479, 2964, 196608, 0, 1479 },
    { 1485, 2971, 196608, 0, 1485 },
    { 1486, 2973, 196608, 0, 1486 },
    { 1488, 2977, 196608, 0, 1488 },
    { 1489, 2979, 786432, 0, 1489 },
    { 1490, 2981, 786432, 0, 1490 },
    { 1491, 2983, 196608, 0, 1491 },
    { 1492, 2985, 196608, 0, 1492 },
    { 1487, 2980, 196608, 0, 1487 },
    { 1493, 2987, 196608, 0, 1493 },
    { 1494, 2989, 196608, 0, 1494 },
    { 1496, 2993, 196608, 0, 1496 },
    { 1497, 2995, 786432, 0, 1497 },
    { 1498, 2997, 786432, 0, 1498 },
    { 1499, 2999, 196608, 0, 1499 },
    { 1500, 3001, 196608, 0, 1500 },
    { 1495, 2996, 196608, 0, 1495 },
    { 1501, 3003, 196608, 0, 1501 },
    { 1502, 3005, 196608, 0, 1502 },
    { 1503, 3007, 196608, 0, 1503 },
    { 1504, 3009, 196608, 0, 1504 },
    { 1505, 3011, 786432, 0, 1505 },
    { 1506, 3013, 786432, 0, 1506 },
    { 1391, 2898, 786432, 0, 1391 },
    { 1507, 3015, 786432, 0, 1507 },
    { 1508, 3017, 786432, 0, 1508 },
    { 1510, 3023, 786432, 0, 1510 },
    { 1511, 3025, 196608, 0, 1511 },
    { 1512, 3028, 196608, 0, 1512 },
    { 1513, 3030, 196608, 0, 1513 },
    { 1515, 3033, 196608, 0, 1515 },
    { 1516, 3035, 196608, 0, 1516 },
    { 1517, 3037, 196608, 0, 1517 },
    { 1518, 3039, 196608, 0, 1518 },
    { 1519, 3041, 196608, 0, 1519 },
    { 1520, 3043, 196608, 0, 1520 },
    { 1522, 3046, 196608, 0, 1522 },
    { 1521, 3046, 196608, 0, 1521 },
    { 1523, 3049, 196608, 0, 1523 },
    { 1525, 3055, 196608, 0, 1525 },
    { 1524, 3055, 196608, 0, 1524 },
    { 1526, 3061, 196608, 0, 1526 },
    { 1531, 3070, 196608, 0, 1531 },
    { 1527, 3067, 49152, 0, 1527 },
    { 1528, 3069, 49152, 0, 1528 },
    { 1529, 3071, 49152, 0, 1529 },
    { 1530, 3073, 49152, 0, 1530 },
    { 1532, 3076, 49152, 0, 1532 },
    { 1533, 3078, 49152, 0, 1533 },
    { 1534, 3080, 49152, 0, 1534 },
    { 1535, 3082, 49152, 0, 1535 },
    { 1536, 3084, 49152, 0, 1536 },
    { 1537, 3086, 49152, 0, 1537 },
    { 1538, 3088, 49152, 0, 1538 },
    { 1539, 3090, 49152, 0, 1539 },
    { 1544, 3096, 49152, 0, 1544 },
    { 1545, 3098, 49152, 0, 1545 },
    { 1546, 3100, 49152, 0, 1546 },
    { 1547, 3102, 49152, 0, 1547 },
    { 1548, 3104, 49152, 0, 1548 },
    { 1549, 3106, 49152, 0, 1549 },
    { 1550, 3108, 49152, 0, 1550 },
    { 1551, 3110, 49152, 0, 1551 },
    { 1540, 3100, 49152, 0, 1540 },
    { 1556, 3116, 49152, 0, 1556 },
    { 1541, 3102, 49152, 0, 1541 },
    { 1557, 3118, 49152, 0, 1557 },
    { 1542, 3104, 49152, 0, 1542 },
    { 1558, 3120, 49152, 0, 1558 },
    { 1543, 3106, 49152, 0, 1543 },
    { 1559, 3122, 49152, 0, 1559 },
    { 1560, 3124, 589824, 0, 1560 },
    { 1561, 3125, 589824, 0, 1561 },
    { 1562, 3126, 589824, 0, 1562 },
    { 1563, 3127, 589824, 0, 1563 },
    { 1564, 3129, 2359296, 0, 1564 },
    { 1565, 3131, 2359296, 0, 1565 },
    { 1566, 3133, 2359296, 0, 1566 },
    { 75, 1642, 589824, 0, 75 },
    { 1567, 3135, 2359296, 0, 1567 },
    { 1568, 3137, 2359296, 0, 1568 },
    { 1569, 3142, 2359296, 0, 1569 },
    { 1570, 3144, 589824, 0, 1570 },
    { 1571, 3146, 589824, 0, 1571 },
    { 1572, 3148, 589824, 0, 1572 },
    { 1573, 3150, 589824, 0, 1573 },
    { 1574, 3152, 589824, 0, 1574 },
    { 1552, 3130, 49152, 0, 1552 },
    { 1575, 3154, 589824, 0, 1575 },
    { 1553, 3132, 49152, 0, 1553 },
    { 1576, 3156, 589824, 0, 1576 },
    { 1554, 3134, 49152, 0, 1554 },
    { 1577, 3158, 589824, 0, 1577 },
    { 1555, 3136, 49152, 0, 1555 },
    { 1578, 3160, 49152, 0, 1578 },
    { 1579, 3161, 49152, 0, 1579 },
    { 1580, 3162, 49152, 0, 1580 },
    { 1581, 3163, 49152, 0, 1581 },
    { 1582, 3165, 196608, 0, 1582 },
    { 1583, 3167, 196608, 0, 1583 },
    { 1584, 3169, 196608, 0, 1584 },
    { 1585, 3171, 196608, 0, 1585 },
    { 1586, 3173, 196608, 0, 1586 },
    { 1514, 3101, 196608, 0, 1514 },
    { 1587, 3175, 196608, 0, 1587 },
    { 1588, 3177, 196608, 0, 1588 },
    { 1590, 3181, 196608, 0, 1590 },
    { 1591, 3183, 786432, 0, 1591 },
    { 1592, 3185, 786432, 0, 1592 },
    { 1593, 3187, 196608, 0, 1593 },
    { 1594, 3189, 196608, 0, 1594 },
    { 1589, 3184, 196608, 0, 1589 },
    { 1595, 3191, 196608, 0, 1595 },
    { 1596, 3193, 196608, 0, 1596 },
    { 1598, 3197, 196608, 0, 1598 },
    { 1599, 3199, 786432, 0, 1599 },
    { 1600, 3201, 786432, 0, 1600 },
    { 1601, 3203, 196608, 0, 1601 },
    { 1602, 3205, 196608, 0, 1602 },
    { 1597, 3200, 196608, 0, 1597 },
    { 1603, 3207, 196608, 0, 1603 },
    { 1604, 3209, 196608, 0, 1604 },
    { 1606, 3213, 196608, 0, 1606 },
    { 1607, 3215, 786432, 0, 1607 },
    { 1608, 3217, 786432, 0, 1608 },
    { 1609, 3219, 196608, 0, 1609 },
    { 1610, 3221, 196608, 0, 1610 },
    { 1605, 3216, 196608, 0, 1605 },
    { 1611, 3223, 196608, 0, 1611 },
    { 1612, 3225, 196608, 0, 1612 },
    { 1614, 3229, 196608, 0, 1614 },
    { 1615, 3231, 786432, 0, 1615 },
    { 1616, 3233, 786432, 0, 1616 },
    { 1617, 3235, 196608, 0, 1617 },
    { 1618, 3237, 196608, 0, 1618 },
    { 1613, 3232, 196608, 0, 1613 },
    { 1619, 3239, 196608, 0, 1619 },
    { 1620, 3241, 196608, 0, 1620 },
    { 1621, 3243, 196608, 0, 1621 },
    { 1622, 3245, 196608, 0, 1622 },
    { 1623, 3247, 786432, 0, 1623 },
    { 1624, 3249, 786432, 0, 1624 },
    { 1509, 3134, 786432, 0, 1509 },
    { 1625, 3251, 786432, 0, 1625 },
    { 1626, 3253, 786432, 0, 1626 },
    { 1628, 3259, 786432, 0, 1628 },
    { 1629, 3261, 196608, 0, 1629 },
    { 1630, 3264, 196608, 0, 1630 },
    { 1631, 3266, 196608, 0, 1631 },
    { 1633, 3269, 196608, 0, 1633 },
    { 1634, 3271, 196608, 0, 1634 },
    { 1635, 3273, 196608, 0, 1635 },
    { 1636, 3275, 196608, 0, 1636 },
    { 1637, 3277, 196608, 0, 1637 },
    { 1638, 3279, 196608, 0, 1638 },
    { 1640, 3282, 196608, 0, 1640 },
    { 1639, 3282, 196608, 0, 1639 },
    { 1641, 3285, 196608, 0, 1641 },
    { 1643, 3291, 196608, 0, 1643 },
    { 1642, 3291, 196608, 0, 1642 },
    { 1644, 3297, 196608, 0, 1644 },
    { 1649, 3306, 196608, 0, 1649 },
    { 1645, 3303, 49152, 0, 1645 },
    { 1646, 3305, 49152, 0, 1646 },
    { 1647, 3307, 49152, 0, 1647 },
    { 1648, 3309, 49152, 0, 1648 },
    { 1650, 3312, 49152, 0, 1650 },
    { 1651, 3314, 49152, 0, 1651 },
    { 1652, 3316, 49152, 0, 1652 },
    { 1653, 3318, 49152, 0, 1653 },
    { 1654, 3320, 49152, 0, 1654 },
    { 1655, 3322, 49152, 0, 1655 },
    { 1656, 3324, 49152, 0, 1656 },
    { 1657, 3326, 49152, 0, 1657 },
    { 1662, 3332, 49152, 0, 1662 },
    { 1663, 3334, 49152, 0, 1663 },
    { 1664, 3336, 49152, 0, 1664 },
    { 1665, 3338, 49152, 0, 1665 },
    { 1666, 3340, 49152, 0, 1666 },
    { 1667, 3342, 49152, 0, 1667 },
    { 1668, 3344, 49152, 0, 1668 },
    { 1669, 3346, 49152, 0, 1669 },
    { 1658, 3336, 49152, 0, 1658 },
    { 1674, 3352, 49152, 0, 1674 },
    { 1659, 3338, 49152, 0, 1659 },
    { 1675, 3354, 49152, 0, 1675 },
    { 1660, 3340, 49152, 0, 1660 },
    { 1676, 3356, 49152, 0, 1676 },
    { 1661, 3342, 49152, 0, 1661 },
    { 1677, 3358, 49152, 0, 1677 },
    { 1678, 3360, 589824, 0, 1678 },
    { 1679, 3361, 589824, 0, 1679 },
    { 1680, 3362, 589824, 0, 1680 },
    { 1681, 3363, 589824, 0, 1681 },
    { 1682, 3365, 2359296, 0, 1682 },
    { 1683, 3367, 2359296, 0, 1683 },
    { 1684, 3369, 2359296, 0, 1684 },
    { 76, 1761, 589824, 0, 76 },
    { 1685, 3371, 2359296, 0, 1685 },
    { 1686, 3373, 2359296, 0, 1686 },
    { 1687, 3378, 2359296, 0, 1687 },
    { 1688, 3380, 589824, 0, 1688 },
    { 1689, 3382, 589824, 0, 1689 },
    { 1690, 3384, 589824, 0, 1690 },
    { 1691, 3386, 589824, 0, 1691 },
    { 1692, 3388, 589824, 0, 1692 },
    { 1670, 3366, 49152, 0, 1670 },
    { 1693, 3390, 589824, 0, 1693 },
    { 1671, 3368, 49152, 0, 1671 },
    { 1694, 3392, 589824, 0, 1694 },
    { 1672, 3370, 49152, 0, 1672 },
    { 1695, 3394, 589824, 0, 1695 },
    { 1673, 3372, 49152, 0, 1673 },
    { 1696, 3396, 49152, 0, 1696 },
    { 1697, 3397, 49152, 0, 1697 },
    { 1698, 3398, 49152, 0, 1698 },
    { 1699, 3399, 49152, 0, 1699 },
    { 1700, 3401, 196608, 0, 1700 },
    { 1701, 3403, 196608, 0, 1701 },
    { 1702, 3405, 196608, 0, 1702 },
    { 1703, 3407, 196608, 0, 1703 },
    { 1704, 3409, 196608, 0, 1704 },
    { 1632, 3337, 196608, 0, 1632 },
    { 1705, 3411, 196608, 0, 1705 },
    { 1706, 3413, 196608, 0, 1706 },
    { 1708, 3417, 196608, 0, 1708 },
    { 1709, 3419, 786432, 0, 1709 },
    { 1710, 3421, 786432, 0, 1710 },
    { 1711, 3423, 196608, 0, 1711 },
    { 1712, 3425, 196608, 0, 1712 },
    { 1707, 3420, 196608, 0, 1707 },
    { 1713, 3427, 196608, 0, 1713 },
    { 1714, 3429, 196608, 0, 1714 },
    { 1716, 3433, 196608, 0, 1716 },
    { 1717, 3435, 786432, 0, 1717 },
    { 1718, 3437, 786432, 0, 1718 },
    { 1719, 3439, 196608, 0, 1719 },
    { 1720, 3441, 196608, 0, 1720 },
    { 1715, 3436, 196608, 0, 1715 },
    { 1721, 3443, 196608, 0, 1721 },
    { 1722, 3445, 196608, 0, 1722 },
    { 1724, 3449, 196608, 0, 1724 },
    { 1725, 3451, 786432, 0, 1725 },
    { 1726, 3453, 786432, 0, 1726 },
    { 1727, 3455, 196608, 0, 1727 },
    { 1728, 3457, 196608, 0, 1728 },
    { 1723, 3452, 196608, 0, 1723 },
    { 1729, 3459, 196608, 0, 1729 },
    { 1730, 3461, 196608, 0, 1730 },
    { 1732, 3465, 196608, 0, 1732 },
    { 1733, 3467, 786432, 0, 1733 },
    { 1734, 3469, 786432, 0, 1734 },
    { 1735, 3471, 196608, 0, 1735 },
    { 1736, 3473, 196608, 0, 1736 },
    { 1731, 3468, 196608, 0, 1731 },
    { 1737, 3475, 196608, 0, 1737 },
    { 1738, 3477, 196608, 0, 1738 },
    { 1739, 3479, 196608, 0, 1739 },
    { 1740, 3481, 196608, 0, 1740 },
    { 1741, 3483, 786432, 0, 1741 },
    { 1742, 3485, 786432, 0, 1742 },
    { 1627, 3370, 786432, 0, 1627 },
    { 1743, 3487, 786432, 0, 1743 },
    { 1744, 3489, 786432, 0, 1744 },
    { 1746, 3495, 786432, 0, 1746 },
    { 1747, 3497, 196608, 0, 1747 },
    { 1748, 3500, 196608, 0, 1748 },
    { 1749, 3502, 196608, 0, 1749 },
    { 1751, 3505, 196608, 0, 1751 },
    { 1752, 3507, 196608, 0, 1752 },
    { 1753, 3509, 196608, 0, 1753 },
    { 1754, 3511, 196608, 0, 1754 },
    { 1755, 3513, 196608, 0, 1755 },
    { 1756, 3515, 196608, 0, 1756 },
    { 1758, 3518, 196608, 0, 1758 },
    { 1757, 3518, 196608, 0, 1757 },
    { 1759, 3521, 196608, 0, 1759 },
    { 1761, 3527, 196608, 0, 1761 },
    { 1760, 3527, 196608, 0, 1760 },
    { 1762, 3533, 196608, 0, 1762 },
    { 1767, 3542, 196608, 0, 1767 },
    { 1763, 3539, 49152, 0, 1763 },
    { 1764, 3541, 49152, 0, 1764 },
    { 1765, 3543, 49152, 0, 1765 },
    { 1766, 3545, 49152, 0, 1766 },
    { 1768, 3548, 49152, 0, 1768 },
    { 1769, 3550, 49152, 0, 1769 },
    { 1770, 3552, 49152, 0, 1770 },
    { 1771, 3554, 49152, 0, 1771 },
    { 1772, 3556, 49152, 0, 1772 },
    { 1773, 3558, 49152, 0, 1773 },
    { 1774, 3560, 49152, 0, 1774 },
    { 1775, 3562, 49152, 0, 1775 },
    { 1780, 3568, 49152, 0, 1780 },
    { 1781, 3570, 49152, 0, 1781 },
    { 1782, 3572, 49152, 0, 1782 },
    { 1783, 3574, 49152, 0, 1783 },
    { 1784, 3576, 49152, 0, 1784 },
    { 1785, 3578, 49152, 0, 1785 },
    { 1786, 3580, 49152, 0, 1786 },
    { 1787, 3582, 49152, 0, 1787 },
    { 1776, 3572, 49152, 0, 1776 },
    { 1792, 3588, 49152, 0, 1792 },
    { 1777, 3574, 49152, 0, 1777 },
    { 1793, 3590, 49152, 0, 1793 },
    { 1778, 3576, 49152, 0, 1778 },
    { 1794, 3592, 49152, 0, 1794 },
    { 1779, 3578, 49152, 0, 1779 },
    { 1795, 3594, 49152, 0, 1795 },
    { 1796, 3596, 589824, 0, 1796 },
    { 1797, 3597, 589824, 0, 1797 },
    { 1798, 3598, 589824, 0, 1798 },
    { 1799, 3599, 589824, 0, 1799 },
    { 1800, 3601, 2359296, 0, 1800 },
    { 1801, 3603, 2359296, 0, 1801 },
    { 1802, 3605, 2359296, 0, 1802 },
    { 77, 1880, 589824, 0, 77 },
    { 1803, 3607, 2359296, 0, 1803 },
    { 1804, 3609, 2359296, 0, 1804 },
    { 1805, 3614, 2359296, 0, 1805 },
    { 1806, 3616, 589824, 0, 1806 },
    { 1807, 3618, 589824, 0, 1807 },
    { 1808, 3620, 589824, 0, 1808 },
    { 1809, 3622, 589824, 0, 1809 },
    { 1810, 3624, 589824, 0, 1810 },
    { 1788, 3602, 49152, 0, 1788 },
    { 1811, 3626, 589824, 0, 1811 },
    { 1789, 3604, 49152, 0, 1789 },
    { 1812, 3628, 589824, 0, 1812 },
    { 1790, 3606, 49152, 0, 1790 },
    { 1813, 3630, 589824, 0, 1813 },
    { 1791, 3608, 49152, 0, 1791 },
    { 1814, 3632, 49152, 0, 1814 },
    { 1815, 3633, 49152, 0, 1815 },
    { 1816, 3634, 49152, 0, 1816 },
    { 1817, 3635, 49152, 0, 1817 },
    { 1818, 3637, 196608, 0, 1818 },
    { 1819, 3639, 196608, 0, 1819 },
    { 1820, 3641, 196608, 0, 1820 },
    { 1821, 3643, 196608, 0, 1821 },
    { 1822, 3645, 196608, 0, 1822 },
    { 1750, 3573, 196608, 0, 1750 },
    { 1823, 3647, 196608, 0, 1823 },
    { 1824, 3649, 196608, 0, 1824 },
    { 1826, 3653, 196608, 0, 1826 },
    { 1827, 3655, 786432, 0, 1827 },
    { 1828, 3657, 786432, 0, 1828 },
    { 1829, 3659, 196608, 0, 1829 },
    { 1830, 3661, 196608, 0, 1830 },
    { 1825, 3656, 196608, 0, 1825 },
    { 1831, 3663, 196608, 0, 1831 },
    { 1832, 3665, 196608, 0, 1832 },
    { 1834, 3669, 196608, 0, 1834 },
    { 1835, 3671, 786432, 0, 1835 },
    { 1836, 3673, 786432, 0, 1836 },
    { 1837, 3675, 196608, 0, 1837 },
    { 1838, 3677, 196608, 0, 1838 },
    { 1833, 3672, 196608, 0, 1833 },
    { 1839, 3679, 196608, 0, 1839 },
    { 1840, 3681, 196608, 0, 1840 },
    { 1842, 3685, 196608, 0, 1842 },
    { 1843, 3687, 786432, 0, 1843 },
    { 1844, 3689, 786432, 0, 1844 },
    { 1845, 3691, 196608, 0, 1845 },
    { 1846, 3693, 196608, 0, 1846 },
    { 1841, 3688, 196608, 0, 1841 },
    { 1847, 3695, 196608, 0, 1847 },
    { 1848, 3697, 196608, 0, 1848 },
    { 1850, 3701, 196608, 0, 1850 },
    { 1851, 3703, 786432, 0, 1851 },
    { 1852, 3705, 786432, 0, 1852 },
    { 1853, 3707, 196608, 0, 1853 },
    { 1854, 3709, 196608, 0, 1854 },
    { 1849, 3704, 196608, 0, 1849 },
    { 1855, 3711, 196608, 0, 1855 },
    { 1856, 3713, 196608, 0, 1856 },
    { 1857, 3715, 196608, 0, 1857 },
    { 1858, 3717, 196608, 0, 1858 },
    { 1859, 3719, 786432, 0, 1859 },
    { 1860, 3721, 786432, 0, 1860 },
    { 1745, 3606, 786432, 0, 1745 },
    { 1861, 3723, 786432, 0, 1861 },
    { 1862, 3725, 786432, 0, 1862 },
    { 1864, 3731, 786432, 0, 1864 },
    { 1865, 3733, 196608, 0, 1865 },
    { 1866, 3736, 196608, 0, 1866 },
    { 1867, 3738, 196608, 0, 1867 },
    { 1869, 3741, 196608, 0, 1869 },
    { 1870, 3743, 196608, 0, 1870 },
    { 1871, 3745, 196608, 0, 1871 },
    { 1872, 3747, 196608, 0, 1872 },
    { 1873, 3749, 196608, 0, 1873 },
    { 1874, 3751, 196608, 0, 1874 },
    { 1876, 3754, 196608, 0, 1876 },
    { 1875, 3754, 196608, 0, 1875 },
    { 1877, 3757, 196608, 0, 1877 },
    { 1879, 3763, 196608, 0, 1879 },
    { 1878, 3763, 196608, 0, 1878 },
    { 1880, 3769, 196608, 0, 1880 },
    { 1885, 3778, 196608, 0, 1885 },
    { 1881, 3775, 49152, 0, 1881 },
    { 1882, 3777, 49152, 0, 1882 },
    { 1883, 3779, 49152, 0, 1883 },
    { 1884, 3781, 49152, 0, 1884 },
    { 1886, 3784, 49152, 0, 1886 },
    { 1887, 3786, 49152, 0, 1887 },
    { 1888, 3788, 49152, 0, 1888 },
    { 1889, 3790, 49152, 0, 1889 },
    { 1890, 3792, 49152, 0, 1890 },
    { 1891, 3794, 49152, 0, 1891 },
    { 1892, 3796, 49152, 0, 1892 },
    { 1893, 3798, 49152, 0, 1893 },
    { 1898, 3804, 49152, 0, 1898 },
    { 1899, 3806, 49152, 0, 1899 },
    { 1900, 3808, 49152, 0, 1900 },
    { 1901, 3810, 49152, 0, 1901 },
    { 1902, 3812, 49152, 0, 1902 },
    { 1903, 3814, 49152, 0, 1903 },
    { 1904, 3816, 49152, 0, 1904 },
    { 1905, 3818, 49152, 0, 1905 },
    { 1894, 3808, 49152, 0, 1894 },
    { 1910, 3824, 49152, 0, 1910 },
    { 1895, 3810, 49152, 0, 1895 },
    { 1911, 3826, 49152, 0, 1911 },
    { 1896, 3812, 49152, 0, 1896 },
    { 1912, 3828, 49152, 0, 1912 },
    { 1897, 3814, 49152, 0, 1897 },
    { 1913, 3830, 49152, 0, 1913 },
    { 1914, 3832, 589824, 0, 1914 },
    { 1915, 3833, 589824, 0, 1915 },
    { 1916, 3834, 589824, 0, 1916 },
    { 1917, 3835, 589824, 0, 1917 },
    { 1918, 3837, 2359296, 0, 1918 },
    { 1919, 3839, 2359296, 0, 1919 },
    { 1920, 3841, 2359296, 0, 1920 },
    { 78, 1999, 589824, 0, 78 },
    { 1921, 3843, 2359296, 0, 1921 },
    { 1922, 3845, 2359296, 0, 1922 },
    { 1923, 3850, 2359296, 0, 1923 },
    { 1924, 3852, 589824, 0, 1924 },
    { 1925, 3854, 589824, 0, 1925 },
    { 1926, 3856, 589824, 0, 1926 },
    { 1927, 3858, 589824, 0, 1927 },
    { 1928, 3860, 589824, 0, 1928 },
    { 1906, 3838, 49152, 0, 1906 },
    { 1929, 3862, 589824, 0, 1929 },
    { 1907, 3840, 49152, 0, 1907 },
    { 1930, 3864, 589824, 0, 1930 },
    { 1908, 3842, 49152, 0, 1908 },
    { 1931, 3866, 589824, 0, 1931 },
    { 1909, 3844, 49152, 0, 1909 },
    { 1932, 3868, 49152, 0, 1932 },
    { 1933, 3869, 49152, 0, 1933 },
    { 1934, 3870, 49152, 0, 1934 },
    { 1935, 3871, 49152, 0, 1935 },
    { 1936, 3873, 196608, 0, 1936 },
    { 1937, 3875, 196608, 0, 1937 },
    { 1938, 3877, 196608, 0, 1938 },
    { 1939, 3879, 196608, 0, 1939 },
    { 1940, 3881, 196608, 0, 1940 },
    { 1868, 3809, 196608, 0, 1868 },
    { 1941, 3883, 196608, 0, 1941 },
    { 1942, 3885, 196608, 0, 1942 },
    { 1944, 3889, 196608, 0, 1944 },
    { 1945, 3891, 786432, 0, 1945 },
    { 1946, 3893, 786432, 0, 1946 },
    { 1947, 3895, 196608, 0, 1947 },
    { 1948, 3897, 196608, 0, 1948 },
    { 1943, 3892, 196608, 0, 1943 },
    { 1949, 3899, 196608, 0, 1949 },
    { 1950, 3901, 196608, 0, 1950 },
    { 1952, 3905, 196608, 0, 1952 },
    { 1953, 3907, 786432, 0, 1953 },
    { 1954, 3909, 786432, 0, 1954 },
    { 1955, 3911, 196608, 0, 1955 },
    { 1956, 3913, 196608, 0, 1956 },
    { 1951, 3908, 196608, 0, 1951 },
    { 1957, 3915, 196608, 0, 1957 },
    { 1958, 3917, 196608, 0, 1958 },
    { 1960, 3921, 196608, 0, 1960 },
    { 1961, 3923, 786432, 0, 1961 },
    { 1962, 3925, 786432, 0, 1962 },
    { 1963, 3927, 196608, 0, 1963 },
    { 1964, 3929, 196608, 0, 1964 },
    { 1959, 3924, 196608, 0, 1959 },
    { 1965, 3931, 196608, 0, 1965 },
    { 1966, 3933, 196608, 0, 1966 },
    { 1968, 3937, 196608, 0, 1968 },
    { 1969, 3939, 786432, 0, 1969 },
    { 1970, 3941, 786432, 0, 1970 },
    { 1971, 3943, 196608, 0, 1971 },
    { 1972, 3945, 196608, 0, 1972 },
    { 1967, 3940, 196608, 0, 1967 },
    { 1973, 3947, 196608, 0, 1973 },
    { 1974, 3949, 196608, 0, 1974 },
    { 1975, 3951, 196608, 0, 1975 },
    { 1976, 3953, 196608, 0, 1976 },
    { 1977, 3955, 786432, 0, 1977 },
    { 1978, 3957, 786432, 0, 1978 },
    { 1863, 3842, 786432, 0, 1863 },
    { 1979, 3959, 786432, 0, 1979 },
    { 1980, 3961, 786432, 0, 1980 },
    { 1982, 3967, 786432, 0, 1982 },
    { 1983, 3969, 196608, 0, 1983 },
    { 1984, 3972, 196608, 0, 1984 },
    { 1985, 3974, 196608, 0, 1985 },
    { 1987, 3977, 196608, 0, 1987 },
    { 1988, 3979, 196608, 0, 1988 },
    { 1989, 3981, 196608, 0, 1989 },
    { 1990, 3983, 196608, 0, 1990 },
    { 1991, 3985, 196608, 0, 1991 },
    { 1992, 3987, 196608, 0, 1992 },
    { 1994, 3990, 196608, 0, 1994 },
    { 1993, 3990, 196608, 0, 1993 },
    { 1995, 3993, 196608, 0, 1995 },
    { 1997, 3999, 196608, 0, 1997 },
    { 1996, 3999, 196608, 0, 1996 },
    { 1998, 4005, 196608, 0, 1998 },
    { 2003, 4014, 196608, 0, 2003 },
    { 1999, 4011, 49152, 0, 1999 },
    { 2000, 4013, 49152, 0, 2000 },
    { 2001, 4015, 49152, 0, 2001 },
    { 2002, 4017, 49152, 0, 2002 },
    { 2004, 4020, 49152, 0, 2004 },
    { 2005, 4022, 49152, 0, 2005 },
    { 2006, 4024, 49152, 0, 2006 },
    { 2007, 4026, 49152, 0, 2007 },
    { 2008, 4028, 49152, 0, 2008 },
    { 2009, 4030, 49152, 0, 2009 },
    { 2010, 4032, 49152, 0, 2010 },
    { 2011, 4034, 49152, 0, 2011 },
    { 2016, 4040, 49152, 0, 2016 },
    { 2017, 4042, 49152, 0, 2017 },
    { 2018, 4044, 49152, 0, 2018 },
    { 2019, 4046, 49152, 0, 2019 },
    { 2020, 4048, 49152, 0, 2020 },
    { 2021, 4050, 49152, 0, 2021 },
    { 2022, 4052, 49152, 0, 2022 },
    { 2023, 4054, 49152, 0, 2023 },
    { 2012, 4044, 49152, 0, 2012 },
    { 2028, 4060, 49152, 0, 2028 },
    { 2013, 4046, 49152, 0, 2013 },
    { 2029, 4062, 49152, 0, 2029 },
    { 2014, 4048, 49152, 0, 2014 },
    { 2030, 4064, 49152, 0, 2030 },
    { 2015, 4050, 49152, 0, 2015 },
    { 2031, 4066, 49152, 0, 2031 },
    { 2032, 4068, 589824, 0, 2032 },
    { 2033, 4069, 589824, 0, 2033 },
    { 2034, 4070, 589824, 0, 2034 },
    { 2035, 4071, 589824, 0, 2035 },
    { 2036, 4073, 2359296, 0, 2036 },
    { 2037, 4075, 2359296, 0, 2037 },
    { 2038, 4077, 2359296, 0, 2038 },
    { 79, 2118, 589824, 0, 79 },
    { 2039, 4079, 2359296, 0, 2039 },
    { 2040, 4081, 2359296, 0, 2040 },
    { 2041, 4086, 2359296, 0, 2041 },
    { 2042, 4088, 589824, 0, 2042 },
    { 2043, 4090, 589824, 0, 2043 },
    { 2044, 4092, 589824, 0, 2044 },
    { 2045, 4094, 589824, 0, 2045 },
    { 2046, 4096, 589824, 0, 2046 },
    { 2024, 4074, 49152, 0, 2024 },
    { 2047, 4098, 589824, 0, 2047 },
    { 2025, 4076, 49152, 0, 2025 },
    { 2048, 4100, 589824, 0, 2048 },
    { 2026, 4078, 49152, 0, 2026 },
    { 2049, 4102, 589824, 0, 2049 },
    { 2027, 4080, 49152, 0, 2027 },
    { 2050, 4104, 49152, 0, 2050 },
    { 2051, 4105, 49152, 0, 2051 },
    { 2052, 4106, 49152, 0, 2052 },
    { 2053, 4107, 49152, 0, 2053 },
    { 2054, 4109, 196608, 0, 2054 },
    { 2055, 4111, 196608, 0, 2055 },
    { 2056, 4113, 196608, 0, 2056 },
    { 2057, 4115, 196608, 0, 2057 },
    { 2058, 4117, 196608, 0, 2058 },
    { 1986, 4045, 196608, 0, 1986 },
    { 2059, 4119, 196608, 0, 2059 },
    { 2060, 4121, 196608, 0, 2060 },
    { 2062, 4125, 196608, 0, 2062 },
    { 2063, 4127, 786432, 0, 2063 },
    { 2064, 4129, 786432, 0, 2064 },
    { 2065, 4131, 196608, 0, 2065 },
    { 2066, 4133, 196608, 0, 2066 },
    { 2061, 4128, 196608, 0, 2061 },
    { 2067, 4135, 196608, 0, 2067 },
    { 2068, 4137, 196608, 0, 2068 },
    { 2070, 4141, 196608, 0, 2070 },
    { 2071, 4143, 786432, 0, 2071 },
    { 2072, 4145, 786432, 0, 2072 },
    { 2073, 4147, 196608, 0, 2073 },
    { 2074, 4149, 196608, 0, 2074 },
    { 2069, 4144, 196608, 0, 2069 },
    { 2075, 4151, 196608, 0, 2075 },
    { 2076, 4153, 196608, 0, 2076 },
    { 2078, 4157, 196608, 0, 2078 },
    { 2079, 4159, 786432, 0, 2079 },
    { 2080, 4161, 786432, 0, 2080 },
    { 2081, 4163, 196608, 0, 2081 },
    { 2082, 4165, 196608, 0, 2082 },
    { 2077, 4160, 196608, 0, 2077 },
    { 2083, 4167, 196608, 0, 2083 },
    { 2084, 4169, 196608, 0, 2084 },
    { 2086, 4173, 196608, 0, 2086 },
    { 2087, 4175, 786432, 0, 2087 },
    { 2088, 4177, 786432, 0, 2088 },
    { 2089, 4179, 196608, 0, 2089 },
    { 2090, 4181, 196608, 0, 2090 },
    { 2085, 4176, 196608, 0, 2085 },
    { 2091, 4183, 196608, 0, 2091 },
    { 2092, 4185, 196608, 0, 2092 },
    { 2093, 4187, 196608, 0, 2093 },
    { 2094, 4189, 196608, 0, 2094 },
    { 2095, 4191, 786432, 0, 2095 },
    { 2096, 4193, 786432, 0, 2096 },
    { 1981, 4078, 786432, 0, 1981 },
    { 2097, 4195, 786432, 0, 2097 },
    { 2098, 4197, 786432, 0, 2098 },
    { 2100, 4203, 786432, 0, 2100 },
    { 2101, 4205, 196608, 0, 2101 },
    { 2102, 4208, 196608, 0, 2102 },
    { 2103, 4210, 196608, 0, 2103 },
    { 2105, 4213, 196608, 0, 2105 },
    { 2106, 4215, 196608, 0, 2106 },
    { 2107, 4217, 196608, 0, 2107 },
    { 2108, 4219, 196608, 0, 2108 },
    { 2109, 4221, 196608, 0, 2109 },
    { 2110, 4223, 196608, 0, 2110 },
    { 2112, 4226, 196608, 0, 2112 },
    { 2111, 4226, 196608, 0, 2111 },
    { 2113, 4229, 196608, 0, 2113 },
    { 2115, 4235, 196608, 0, 2115 },
    { 2114, 4235, 196608, 0, 2114 },
    { 2116, 4241, 196608, 0, 2116 },
    { 2121, 4250, 196608, 0, 2121 },
    { 2117, 4247, 49152, 0, 2117 },
    { 2118, 4249, 49152, 0, 2118 },
    { 2119, 4251, 49152, 0, 2119 },
    { 2120, 4253, 49152, 0, 2120 },
    { 2122, 4256, 49152, 0, 2122 },
    { 2123, 4258, 49152, 0, 2123 },
    { 2124, 4260, 49152, 0, 2124 },
    { 2125, 4262, 49152, 0, 2125 },
    { 2126, 4264, 49152, 0, 2126 },
    { 2127, 4266, 49152, 0, 2127 },
    { 2128, 4268, 49152, 0, 2128 },
    { 2129, 4270, 49152, 0, 2129 },
    { 2134, 4276, 49152, 0, 2134 },
    { 2135, 4278, 49152, 0, 2135 },
    { 2136, 4280, 49152, 0, 2136 },
    { 2137, 4282, 49152, 0, 2137 },
    { 2138, 4284, 49152, 0, 2138 },
    { 2139, 4286, 49152, 0, 2139 },
    { 2140, 4288, 49152, 0, 2140 },
    { 2141, 4290, 49152, 0, 2141 },
    { 2130, 4280, 49152, 0, 2130 },
    { 2146, 4296, 49152, 0, 2146 },
    { 2131, 4282, 49152, 0, 2131 },
    { 2147, 4298, 49152, 0, 2147 },
    { 2132, 4284, 49152, 0, 2132 },
    { 2148, 4300, 49152, 0, 2148 },
    { 2133, 4286, 49152, 0, 2133 },
    { 2149, 4302, 49152, 0, 2149 },
    { 2150, 4304, 589824, 0, 2150 },
    { 2151, 4305, 589824, 0, 2151 },
    { 2152, 4306, 589824, 0, 2152 },
    { 2153, 4307, 589824, 0, 2153 },
    { 2154, 4309, 2359296, 0, 2154 },
    { 2155, 4311, 2359296, 0, 2155 },
    { 2156, 4313, 2359296, 0, 2156 },
    { 80, 2237, 589824, 0, 80 },
    { 2157, 4315, 2359296, 0, 2157 },
    { 2158, 4317, 2359296, 0, 2158 },
    { 2159, 4322, 2359296, 0, 2159 },
    { 2160, 4324, 589824, 0, 2160 },
    { 2161, 4326, 589824, 0, 2161 },
    { 2162, 4328, 589824, 0, 2162 },
    { 2163, 4330, 589824, 0, 2163 },
    { 2164, 4332, 589824, 0, 2164 },
    { 2142, 4310, 49152, 0, 2142 },
    { 2165, 4334, 589824, 0, 2165 },
    { 2143, 4312, 49152, 0, 2143 },
    { 2166, 4336, 589824, 0, 2166 },
    { 2144, 4314, 49152, 0, 2144 },
    { 2167, 4338, 589824, 0, 2167 },
    { 2145, 4316, 49152, 0, 2145 },
    { 2168, 4340, 49152, 0, 2168 },
    { 2169, 4341, 49152, 0, 2169 },
    { 2170, 4342, 49152, 0, 2170 },
    { 2171, 4343, 49152, 0, 2171 },
    { 2172, 4345, 196608, 0, 2172 },
    { 2173, 4347, 196608, 0, 2173 },
    { 2174, 4349, 196608, 0, 2174 },
    { 2175, 4351, 196608, 0, 2175 },
    { 2176, 4353, 196608, 0, 2176 },
    { 2104, 4281, 196608, 0, 2104 },
    { 2177, 4355, 196608, 0, 2177 },
    { 2178, 4357, 196608, 0, 2178 },
    { 2180, 4361, 196608, 0, 2180 },
    { 2181, 4363, 786432, 0, 2181 },
    { 2182, 4365, 786432, 0, 2182 },
    { 2183, 4367, 196608, 0, 2183 },
    { 2184, 4369, 196608, 0, 2184 },
    { 2179, 4364, 196608, 0, 2179 },
    { 2185, 4371, 196608, 0, 2185 },
    { 2186, 4373, 196608, 0, 2186 },
    { 2188, 4377, 196608, 0, 2188 },
    { 2189, 4379, 786432, 0, 2189 },
    { 2190, 4381, 786432, 0, 2190 },
    { 2191, 4383, 196608, 0, 2191 },
    { 2192, 4385, 196608, 0, 2192 },
    { 2187, 4380, 196608, 0, 2187 },
    { 2193, 4387, 196608, 0, 2193 },
    { 2194, 4389, 196608, 0, 2194 },
    { 2196, 4393, 196608, 0, 2196 },
    { 2197, 4395, 786432, 0, 2197 },
    { 2198, 4397, 786432, 0, 2198 },
    { 2199, 4399, 196608, 0, 2199 },
    { 2200, 4401, 196608, 0, 2200 },
    { 2195, 4396, 196608, 0, 2195 },
    { 2201, 4403, 196608, 0, 2201 },
    { 2202, 4405, 196608, 0, 2202 },
    { 2204, 4409, 196608, 0, 2204 },
    { 2205, 4411, 786432, 0, 2205 },
    { 2206, 4413, 786432, 0, 2206 },
    { 2207, 4415, 196608, 0, 2207 },
    { 2208, 4417, 196608, 0, 2208 },
    { 2203, 4412, 196608, 0, 2203 },
    { 2209, 4419, 196608, 0, 2209 },
    { 2210, 4421, 196608, 0, 2210 },
    { 2211, 4423, 196608, 0, 2211 },
    { 2212, 4425, 196608, 0, 2212 },
    { 2213, 4427, 786432, 0, 2213 },
    { 2214, 4429, 786432, 0, 2214 },
    { 2099, 4314, 786432, 0, 2099 },
    { 2215, 4431, 786432, 0, 2215 },
    { 2216, 4433, 786432, 0, 2216 },
    { 2218, 4439, 786432, 0, 2218 },
    { 2219, 4441, 196608, 0, 2219 },
    { 2220, 4444, 196608, 0, 2220 },
    { 2221, 4446, 196608, 0, 2221 },
    { 2223, 4449, 196608, 0, 2223 },
    { 2224, 4451, 196608, 0, 2224 },
    { 2225, 4453, 196608, 0, 2225 },
    { 2226, 4455, 196608, 0, 2226 },
    { 2227, 4457, 196608, 0, 2227 },
    { 2228, 4459, 196608, 0, 2228 },
    { 2230, 4462, 196608, 0, 2230 },
    { 2229, 4462, 196608, 0, 2229 },
    { 2231, 4465, 196608, 0, 2231 },
    { 2233, 4471, 196608, 0, 2233 },
    { 2232, 4471, 196608, 0, 2232 },
    { 2234, 4477, 196608, 0, 2234 },
    { 2239, 4486, 196608, 0, 2239 },
    { 2235, 4483, 49152, 0, 2235 },
    { 2236, 4485, 49152, 0, 2236 },
    { 2237, 4487, 49152, 0, 2237 },
    { 2238, 4489, 49152, 0, 2238 },
    { 2240, 4492, 49152, 0, 2240 },
    { 2241, 4494, 49152, 0, 2241 },
    { 2242, 4496, 49152, 0, 2242 },
    { 2243, 4498, 49152, 0, 2243 },
    { 2244, 4500, 49152, 0, 2244 },
    { 2245, 4502, 49152, 0, 2245 },
    { 2246, 4504, 49152, 0, 2246 },
    { 2247, 4506, 49152, 0, 2247 },
    { 2252, 4512, 49152, 0, 2252 },
    { 2253, 4514, 49152, 0, 2253 },
    { 2254, 4516, 49152, 0, 2254 },
    { 2255, 4518, 49152, 0, 2255 },
    { 2256, 4520, 49152, 0, 2256 },
    { 2257, 4522, 49152, 0, 2257 },
    { 2258, 4524, 49152, 0, 2258 },
    { 2259, 4526, 49152, 0, 2259 },
    { 2248, 4516, 49152, 0, 2248 },
    { 2264, 4532, 49152, 0, 2264 },
    { 2249, 4518, 49152, 0, 2249 },
    { 2265, 4534, 49152, 0, 2265 },
    { 2250, 4520, 49152, 0, 2250 },
    { 2266, 4536, 49152, 0, 2266 },
    { 2251, 4522, 49152, 0, 2251 },
    { 2267, 4538, 49152, 0, 2267 },
    { 2268, 4540, 589824, 0, 2268 },
    { 2269, 4541, 589824, 0, 2269 },
    { 2270, 4542, 589824, 0, 2270 },
    { 2271, 4543, 589824, 0, 2271 },
    { 2272, 4545, 2359296, 0, 2272 },
    { 2273, 4547, 2359296, 0, 2273 },
    { 2274, 4549, 2359296, 0, 2274 },
    { 81, 2356, 589824, 0, 81 },
    { 2275, 4551, 2359296, 0, 2275 },
    { 2276, 4553, 2359296, 0, 2276 },
    { 2277, 4558, 2359296, 0, 2277 },
    { 2278, 4560, 589824, 0, 2278 },
    { 2279, 4562, 589824, 0, 2279 },
    { 2280, 4564, 589824, 0, 2280 },
    { 2281, 4566, 589824, 0, 2281 },
    { 2282, 4568, 589824, 0, 2282 },
    { 2260, 4546, 49152, 0, 2260 },
    { 2283, 4570, 589824, 0, 2283 },
    { 2261, 4548, 49152, 0, 2261 },
    { 2284, 4572, 589824, 0, 2284 },
    { 2262, 4550, 49152, 0, 2262 },
    { 2285, 4574, 589824, 0, 2285 },
    { 2263, 4552, 49152, 0, 2263 },
    { 2286, 4576, 49152, 0, 2286 },
    { 2287, 4577, 49152, 0, 2287 },
    { 2288, 4578, 49152, 0, 2288 },
    { 2289, 4579, 49152, 0, 2289 },
    { 2290, 4581, 196608, 0, 2290 },
    { 2291, 4583, 196608, 0, 2291 },
    { 2292, 4585, 196608, 0, 2292 },
    { 2293, 4587, 196608, 0, 2293 },
    { 2294, 4589, 196608, 0, 2294 },
    { 2222, 4517, 196608, 0, 2222 },
    { 2295, 4591, 196608, 0, 2295 },
    { 2296, 4593, 196608, 0, 2296 },
    { 2298, 4597, 196608, 0, 2298 },
    { 2299, 4599, 786432, 0, 2299 },
    { 2300, 4601, 786432, 0, 2300 },
    { 2301, 4603, 196608, 0, 2301 },
    { 2302, 4605, 196608, 0, 2302 },
    { 2297, 4600, 196608, 0, 2297 },
    { 2303, 4607, 196608, 0, 2303 },
    { 2304, 4609, 196608, 0, 2304 },
    { 2306, 4613, 196608, 0, 2306 },
    { 2307, 4615, 786432, 0, 2307 },
    { 2308, 4617, 786432, 0, 2308 },
    { 2309, 4619, 196608, 0, 2309 },
    { 2310, 4621, 196608, 0, 2310 },
    { 2305, 4616, 196608, 0, 2305 },
    { 2311, 4623, 196608, 0, 2311 },
    { 2312, 4625, 196608, 0, 2312 },
    { 2314, 4629, 196608, 0, 2314 },
    { 2315, 4631, 786432, 0, 2315 },
    { 2316, 4633, 786432, 0, 2316 },
    { 2317, 4635, 196608, 0, 2317 },
    { 2318, 4637, 196608, 0, 2318 },
    { 2313, 4632, 196608, 0, 2313 },
    { 2319, 4639, 196608, 0, 2319 },
    { 2320, 4641, 196608, 0, 2320 },
    { 2322, 4645, 196608, 0, 2322 },
    { 2323, 4647, 786432, 0, 2323 },
    { 2324, 4649, 786432, 0, 2324 },
    { 2325, 4651, 196608, 0, 2325 },
    { 2326, 4653, 196608, 0, 2326 },
    { 2321, 4648, 196608, 0, 2321 },
    { 2327, 4655, 196608, 0, 2327 },
    { 2328, 4657, 196608, 0, 2328 },
    { 2329, 4659, 196608, 0, 2329 },
    { 2330, 4661, 196608, 0, 2330 },
    { 2331, 4663, 786432, 0, 2331 },
    { 2332, 4665, 786432, 0, 2332 },
    { 2217, 4550, 786432, 0, 2217 },
    { 2333, 4667, 786432, 0, 2333 },
    { 2334, 4669, 786432, 0, 2334 },
    { 2336, 4675, 786432, 0, 2336 },
    { 2337, 4677, 196608, 0, 2337 },
    { 2338, 4680, 196608, 0, 2338 },
    { 2339, 4682, 196608, 0, 2339 },
    { 2341, 4685, 196608, 0, 2341 },
    { 2342, 4687, 196608, 0, 2342 },
    { 2343, 4689, 196608, 0, 2343 },
    { 2344, 4691, 196608, 0, 2344 },
    { 2345, 4693, 196608, 0, 2345 },
    { 2346, 4695, 196608, 0, 2346 },
    { 2348, 4698, 196608, 0, 2348 },
    { 2347, 4698, 196608, 0, 2347 },
    { 2349, 4701, 196608, 0, 2349 },
    { 2351, 4707, 196608, 0, 2351 },
    { 2350, 4707, 196608, 0, 2350 },
    { 2352, 4713, 196608, 0, 2352 },
    { 2357, 4722, 196608, 0, 2357 },
    { 2353, 4719, 49152, 0, 2353 },
    { 2354, 4721, 49152, 0, 2354 },
    { 2355, 4723, 49152, 0, 2355 },
    { 2356, 4725, 49152, 0, 2356 },
    { 2358, 4728, 49152, 0, 2358 },
    { 2359, 4730, 49152, 0, 2359 },
    { 2360, 4732, 49152, 0, 2360 },
    { 2361, 4734, 49152, 0, 2361 },
    { 2362, 4736, 49152, 0, 2362 },
    { 2363, 4738, 49152, 0, 2363 },
    { 2364, 4740, 49152, 0, 2364 },
    { 2365, 4742, 49152, 0, 2365 },
    { 2370, 4748, 49152, 0, 2370 },
    { 2371, 4750, 49152, 0, 2371 },
    { 2372, 4752, 49152, 0, 2372 },
    { 2373, 4754, 49152, 0, 2373 },
    { 2374, 4756, 49152, 0, 2374 },
    { 2375, 4758, 49152, 0, 2375 },
    { 2376, 4760, 49152, 0, 2376 },
    { 2377, 4762, 49152, 0, 2377 },
    { 2366, 4752, 49152, 0, 2366 },
    { 2382, 4768, 49152, 0, 2382 },
    { 2367, 4754, 49152, 0, 2367 },
    { 2383, 4770, 49152, 0, 2383 },
    { 2368, 4756, 49152, 0, 2368 },
    { 2384, 4772, 49152, 0, 2384 },
    { 2369, 4758, 49152, 0, 2369 },
    { 2385, 4774, 49152, 0, 2385 },
    { 2386, 4776, 589824, 0, 2386 },
    { 2387, 4777, 589824, 0, 2387 },
    { 2388, 4778, 589824, 0, 2388 },
    { 2389, 4779, 589824, 0, 2389 },
    { 2390, 4781, 2359296, 0, 2390 },
    { 2391, 4783, 2359296, 0, 2391 },
    { 2392, 4785, 2359296, 0, 2392 },
    { 82, 2475, 589824, 0, 82 },
    { 2393, 4787, 2359296, 0, 2393 },
    { 2394, 4789, 2359296, 0, 2394 },
    { 2395, 4794, 2359296, 0, 2395 },
    { 2396, 4796, 589824, 0, 2396 },
    { 2397, 4798, 589824, 0, 2397 },
    { 2398, 4800, 589824, 0, 2398 },
    { 2399, 4802, 589824, 0, 2399 },
    { 2400, 4804, 589824, 0, 2400 },
    { 2378, 4782, 49152, 0, 2378 },
    { 2401, 4806, 589824, 0, 2401 },
    { 2379, 4784, 49152, 0, 2379 },
    { 2402, 4808, 589824, 0, 2402 },
    { 2380, 4786, 49152, 0, 2380 },
    { 2403, 4810, 589824, 0, 2403 },
    { 2381, 4788, 49152, 0, 2381 },
    { 2404, 4812, 49152, 0, 2404 },
    { 2405, 4813, 49152, 0, 2405 },
    { 2406, 4814, 49152, 0, 2406 },
    { 2407, 4815, 49152, 0, 2407 },
    { 2408, 4817, 196608, 0, 2408 },
    { 2409, 4819, 196608, 0, 2409 },
    { 2410, 4821, 196608, 0, 2410 },
    { 2411, 4823, 196608, 0, 2411 },
    { 2412, 4825, 196608, 0, 2412 },
    { 2340, 4753, 196608, 0, 2340 },
    { 2413, 4827, 196608, 0, 2413 },
    { 2414, 4829, 196608, 0, 2414 },
    { 2416, 4833, 196608, 0, 2416 },
    { 2417, 4835, 786432, 0, 2417 },
    { 2418, 4837, 786432, 0, 2418 },
    { 2419, 4839, 196608, 0, 2419 },
    { 2420, 4841, 196608, 0, 2420 },
    { 2415, 4836, 196608, 0, 2415 },
    { 2421, 4843, 196608, 0, 2421 },
    { 2422, 4845, 196608, 0, 2422 },
    { 2424, 4849, 196608, 0, 2424 },
    { 2425, 4851, 786432, 0, 2425 },
    { 2426, 4853, 786432, 0, 2426 },
    { 2427, 4855, 196608, 0, 2427 },
    { 2428, 4857, 196608, 0, 2428 },
    { 2423, 4852, 196608, 0, 2423 },
    { 2429, 4859, 196608, 0, 2429 },
    { 2430, 4861, 196608, 0, 2430 },
    { 2432, 4865, 196608, 0, 2432 },
    { 2433, 4867, 786432, 0, 2433 },
    { 2434, 4869, 786432, 0, 2434 },
    { 2435, 4871, 196608, 0, 2435 },
    { 2436, 4873, 196608, 0, 2436 },
    { 2431, 4868, 196608, 0, 2431 },
    { 2437, 4875, 196608, 0, 2437 },
    { 2438, 4877, 196608, 0, 2438 },
    { 2440, 4881, 196608, 0, 2440 },
    { 2441, 4883, 786432, 0, 2441 },
    { 2442, 4885, 786432, 0, 2442 },
    { 2443, 4887, 196608, 0, 2443 },
    { 2444, 4889, 196608, 0, 2444 },
    { 2439, 4884, 196608, 0, 2439 },
    { 2445, 4891, 196608, 0, 2445 },
    { 2446, 4893, 196608, 0, 2446 },
    { 2447, 4895, 196608, 0, 2447 },
    { 2448, 4897, 196608, 0, 2448 },
    { 2449, 4899, 786432, 0, 2449 },
    { 2450, 4901, 786432, 0, 2450 },
    { 2335, 4786, 786432, 0, 2335 },
    { 2451, 4903, 786432, 0, 2451 },
    { 2452, 4905, 786432, 0, 2452 },
    { 2454, 4911, 786432, 0, 2454 },
    { 2455, 4913, 196608, 0, 2455 },
    { 2456, 4916, 196608, 0, 2456 },
    { 2457, 4918, 196608, 0, 2457 },
    { 2459, 4921, 196608, 0, 2459 },
    { 2460, 4923, 196608, 0, 2460 },
    { 2461, 4925, 196608, 0, 2461 },
    { 2462, 4927, 196608, 0, 2462 },
    { 2463, 4929, 196608, 0, 2463 },
    { 2464, 4931, 196608, 0, 2464 },
    { 2466, 4934, 196608, 0, 2466 },
    { 2465, 4934, 196608, 0, 2465 },
    { 2467, 4937, 196608, 0, 2467 },
    { 2469, 4943, 196608, 0, 2469 },
    { 2468, 4943, 196608, 0, 2468 },
    { 2470, 4949, 196608, 0, 2470 },
    { 2475, 4958, 196608, 0, 2475 },
    { 2471, 4955, 49152, 0, 2471 },
    { 2472, 4957, 49152, 0, 2472 },
    { 2473, 4959, 49152, 0, 2473 },
    { 2474, 4961, 49152, 0, 2474 },
    { 2476, 4964, 49152, 0, 2476 },
    { 2477, 4966, 49152, 0, 2477 },
    { 2478, 4968, 49152, 0, 2478 },
    { 2479, 4970, 49152, 0, 2479 },
    { 2480, 4972, 49152, 0, 2480 },
    { 2481, 4974, 49152, 0, 2481 },
    { 2482, 4976, 49152, 0, 2482 },
    { 2483, 4978, 49152, 0, 2483 },
    { 2488, 4984, 49152, 0, 2488 },
    { 2489, 4986, 49152, 0, 2489 },
    { 2490, 4988, 49152, 0, 2490 },
    { 2491, 4990, 49152, 0, 2491 },
    { 2492, 4992, 49152, 0, 2492 },
    { 2493, 4994, 49152, 0, 2493 },
    { 2494, 4996, 49152, 0, 2494 },
    { 2495, 4998, 49152, 0, 2495 },
    { 2484, 4988, 49152, 0, 2484 },
    { 2500, 5004, 49152, 0, 2500 },
    { 2485, 4990, 49152, 0, 2485 },
    { 2501, 5006, 49152, 0, 2501 },
    { 2486, 4992, 49152, 0, 2486 },
    { 2502, 5008, 49152, 0, 2502 },
    { 2487, 4994, 49152, 0, 2487 },
    { 2503, 5010, 49152, 0, 2503 },
    { 2504, 5012, 589824, 0, 2504 },
    { 2505, 5013, 589824, 0, 2505 },
    { 2506, 5014, 589824, 0, 2506 },
    { 2507, 5015, 589824, 0, 2507 },
    { 2508, 5017, 2359296, 0, 2508 },
    { 2509, 5019, 2359296, 0, 2509 },
    { 2510, 5021, 2359296, 0, 2510 },
    { 83, 2594, 589824, 0, 83 },
    { 2511, 5023, 2359296, 0, 2511 },
    { 2512, 5025, 2359296, 0, 2512 },
    { 2513, 5030, 2359296, 0, 2513 },
    { 2514, 5032, 589824, 0, 2514 },
    { 2515, 5034, 589824, 0, 2515 },
    { 2516, 5036, 589824, 0, 2516 },
    { 2517, 5038, 589824, 0, 2517 },
    { 2518, 5040, 589824, 0, 2518 },
    { 2496, 5018, 49152, 0, 2496 },
    { 2519, 5042, 589824, 0, 2519 },
    { 2497, 5020, 49152, 0, 2497 },
    { 2520, 5044, 589824, 0, 2520 },
    { 2498, 5022, 49152, 0, 2498 },
    { 2521, 5046, 589824, 0, 2521 },
    { 2499, 5024, 49152, 0, 2499 },
    { 2522, 5048, 49152, 0, 2522 },
    { 2523, 5049, 49152, 0, 2523 },
    { 2524, 5050, 49152, 0, 2524 },
    { 2525, 5051, 49152, 0, 2525 },
    { 2526, 5053, 196608, 0, 2526 },
    { 2527, 5055, 196608, 0, 2527 },
    { 2528, 5057, 196608, 0, 2528 },
    { 2529, 5059, 196608, 0, 2529 },
    { 2530, 5061, 196608, 0, 2530 },
    { 2458, 4989, 196608, 0, 2458 },
    { 2531, 5063, 196608, 0, 2531 },
    { 2532, 5065, 196608, 0, 2532 },
    { 2534, 5069, 196608, 0, 2534 },
    { 2535, 5071, 786432, 0, 2535 },
    { 2536, 5073, 786432, 0, 2536 },
    { 2537, 5075, 196608, 0, 2537 },
    { 2538, 5077, 196608, 0, 2538 },
    { 2533, 5072, 196608, 0, 2533 },
    { 2539, 5079, 196608, 0, 2539 },
    { 2540, 5081, 196608, 0, 2540 },
    { 2542, 5085, 196608, 0, 2542 },
    { 2543, 5087, 786432, 0, 2543 },
    { 2544, 5089, 786432, 0, 2544 },
    { 2545, 5091, 196608, 0, 2545 },
    { 2546, 5093, 196608, 0, 2546 },
    { 2541, 5088, 196608, 0, 2541 },
    { 2547, 5095, 196608, 0, 2547 },
    { 2548, 5097, 196608, 0, 2548 },
    { 2550, 5101, 196608, 0, 2550 },
    { 2551, 5103, 786432, 0, 2551 },
    { 2552, 5105, 786432, 0, 2552 },
    { 2553, 5107, 196608, 0, 2553 },
    { 2554, 5109, 196608, 0, 2554 },
    { 2549, 5104, 196608, 0, 2549 },
    { 2555, 5111, 196608, 0, 2555 },
    { 2556, 5113, 196608, 0, 2556 },
    { 2558, 5117, 196608, 0, 2558 },
    { 2559, 5119, 786432, 0, 2559 },
    { 2560, 5121, 786432, 0, 2560 },
    { 2561, 5123, 196608, 0, 2561 },
    { 2562, 5125, 196608, 0, 2562 },
    { 2557, 5120, 196608, 0, 2557 },
    { 2563, 5127, 196608, 0, 2563 },
    { 2564, 5129, 196608, 0, 2564 },
    { 2565, 5131, 196608, 0, 2565 },
    { 2566, 5133, 196608, 0, 2566 },
    { 2567, 5135, 786432, 0, 2567 },
    { 2568, 5137, 786432, 0, 2568 },
    { 2453, 5022, 786432, 0, 2453 },
    { 2569, 5139, 786432, 0, 2569 },
    { 2570, 5141, 786432, 0, 2570 },
    { 2572, 5147, 786432, 0, 2572 },
    { 2573, 5149, 196608, 0, 2573 },
    { 2574, 5152, 196608, 0, 2574 },
    { 2575, 5154, 196608, 0, 2575 },
    { 2577, 5157, 196608, 0, 2577 },
    { 2578, 5159, 196608, 0, 2578 },
    { 2579, 5161, 196608, 0, 2579 },
    { 2580, 5163, 196608, 0, 2580 },
    { 2581, 5165, 196608, 0, 2581 },
    { 2582, 5167, 196608, 0, 2582 },
    { 2584, 5170, 196608, 0, 2584 },
    { 2583, 5170, 196608, 0, 2583 },
    { 2585, 5173, 196608, 0, 2585 },
    { 2587, 5179, 196608, 0, 2587 },
    { 2586, 5179, 196608, 0, 2586 },
    { 2588, 5185, 196608, 0, 2588 },
    { 2593, 5194, 196608, 0, 2593 },
    { 2589, 5191, 49152, 0, 2589 },
    { 2590, 5193, 49152, 0, 2590 },
    { 2591, 5195, 49152, 0, 2591 },
    { 2592, 5197, 49152, 0, 2592 },
    { 2594, 5200, 49152, 0, 2594 },
    { 2595, 5202, 49152, 0, 2595 },
    { 2596, 5204, 49152, 0, 2596 },
    { 2597, 5206, 49152, 0, 2597 },
    { 2598, 5208, 49152, 0, 2598 },
    { 2599, 5210, 49152, 0, 2599 },
    { 2600, 5212, 49152, 0, 2600 },
    { 2601, 5214, 49152, 0, 2601 },
    { 2606, 5220, 49152, 0, 2606 },
    { 2607, 5222, 49152, 0, 2607 },
    { 2608, 5224, 49152, 0, 2608 },
    { 2609, 5226, 49152, 0, 2609 },
    { 2610, 5228, 49152, 0, 2610 },
    { 2611, 5230, 49152, 0, 2611 },
    { 2612, 5232, 49152, 0, 2612 },
    { 2613, 5234, 49152, 0, 2613 },
    { 2602, 5224, 49152, 0, 2602 },
    { 2618, 5240, 49152, 0, 2618 },
    { 2603, 5226, 49152, 0, 2603 },
    { 2619, 5242, 49152, 0, 2619 },
    { 2604, 5228, 49152, 0, 2604 },
    { 2620, 5244, 49152, 0, 2620 },
    { 2605, 5230, 49152, 0, 2605 },
    { 2621, 5246, 49152, 0, 2621 },
    { 2622, 5248, 589824, 0, 2622 },
    { 2623, 5249, 589824, 0, 2623 },
    { 2624, 5250, 589824, 0, 2624 },
    { 2625, 5251, 589824, 0, 2625 },
    { 2626, 5253, 2359296, 0, 2626 },
    { 2627, 5255, 2359296, 0, 2627 },
    { 2628, 5257, 2359296, 0, 2628 },
    { 84, 2713, 589824, 0, 84 },
    { 2629, 5259, 2359296, 0, 2629 },
    { 2630, 5261, 2359296, 0, 2630 },
    { 2631, 5266, 2359296, 0, 2631 },
    { 2632, 5268, 589824, 0, 2632 },
    { 2633, 5270, 589824, 0, 2633 },
    { 2634, 5272, 589824, 0, 2634 },
    { 2635, 5274, 589824, 0, 2635 },
    { 2636, 5276, 589824, 0, 2636 },
    { 2614, 5254, 49152, 0, 2614 },
    { 2637, 5278, 589824, 0, 2637 },
    { 2615, 5256, 49152, 0, 2615 },
    { 2638, 5280, 589824, 0, 2638 },
    { 2616, 5258, 49152, 0, 2616 },
    { 2639, 5282, 589824, 0, 2639 },
    { 2617, 5260, 49152, 0, 2617 },
    { 2640, 5284, 49152, 0, 2640 },
    { 2641, 5285, 49152, 0, 2641 },
    { 2642, 5286, 49152, 0, 2642 },
    { 2643, 5287, 49152, 0, 2643 },
    { 2644, 5289, 196608, 0, 2644 },
    { 2645, 5291, 196608, 0, 2645 },
    { 2646, 5293, 196608, 0, 2646 },
    { 2647, 5295, 196608, 0, 2647 },
    { 2648, 5297, 196608, 0, 2648 },
    { 2576, 5225, 196608, 0, 2576 },
    { 2649, 5299, 196608, 0, 2649 },
    { 2650, 5301, 196608, 0, 2650 },
    { 2652, 5305, 196608, 0, 2652 },
    { 2653, 5307, 786432, 0, 2653 },
    { 2654, 5309, 786432, 0, 2654 },
    { 2655, 5311, 196608, 0, 2655 },
    { 2656, 5313, 196608, 0, 2656 },
    { 2651, 5308, 196608, 0, 2651 },
    { 2657, 5315, 196608, 0, 2657 },
    { 2658, 5317, 196608, 0, 2658 },
    { 2660, 5321, 196608, 0, 2660 },
    { 2661, 5323, 786432, 0, 2661 },
    { 2662, 5325, 786432, 0, 2662 },
    { 2663, 5327, 196608, 0, 2663 },
    { 2664, 5329, 196608, 0, 2664 },
    { 2659, 5324, 196608, 0, 2659 },
    { 2665, 5331, 196608, 0, 2665 },
    { 2666, 5333, 196608, 0, 2666 },
    { 2668, 5337, 196608, 0, 2668 },
    { 2669, 5339, 786432, 0, 2669 },
    { 2670, 5341, 786432, 0, 2670 },
    { 2671, 5343, 196608, 0, 2671 },
    { 2672, 5345, 196608, 0, 2672 },
    { 2667, 5340, 196608, 0, 2667 },
    { 2673, 5347, 196608, 0, 2673 },
    { 2674, 5349, 196608, 0, 2674 },
    { 2676, 5353, 196608, 0, 2676 },
    { 2677, 5355, 786432, 0, 2677 },
    { 2678, 5357, 786432, 0, 2678 },
    { 2679, 5359, 196608, 0, 2679 },
    { 2680, 5361, 196608, 0, 2680 },
    { 2675, 5356, 196608, 0, 2675 },
    { 2681, 5363, 196608, 0, 2681 },
    { 2682, 5365, 196608, 0, 2682 },
    { 2683, 5367, 196608, 0, 2683 },
    { 2684, 5369, 196608, 0, 2684 },
    { 2685, 5371, 786432, 0, 2685 },
    { 2686, 5373, 786432, 0, 2686 },
    { 2571, 5258, 786432, 0, 2571 },
    { 2687, 5375, 786432, 0, 2687 },
    { 2688, 5377, 786432, 0, 2688 },
    { 2690, 5383, 786432, 0, 2690 },
    { 2691, 5385, 196608, 0, 2691 },
    { 2692, 5388, 196608, 0, 2692 },
    { 2693, 5390, 196608, 0, 2693 },
    { 2695, 5393, 196608, 0, 2695 },
    { 2696, 5395, 196608, 0, 2696 },
    { 2697, 5397, 196608, 0, 2697 },
    { 2698, 5399, 196608, 0, 2698 },
    { 2699, 5401, 196608, 0, 2699 },
    { 2700, 5403, 196608, 0, 2700 },
    { 2702, 5406, 196608, 0, 2702 },
    { 2701, 5406, 196608, 0, 2701 },
    { 2703, 5409, 196608, 0, 2703 },
    { 2705, 5415, 196608, 0, 2705 },
    { 2704, 5415, 196608, 0, 2704 },
    { 2706, 5421, 196608, 0, 2706 },
    { 2711, 5430, 196608, 0, 2711 },
    { 2707, 5427, 49152, 0, 2707 },
    { 2708, 5429, 49152, 0, 2708 },
    { 2709, 5431, 49152, 0, 2709 },
    { 2710, 5433, 49152, 0, 2710 },
    { 2712, 5436, 49152, 0, 2712 },
    { 2713, 5438, 49152, 0, 2713 },
    { 2714, 5440, 49152, 0, 2714 },
    { 2715, 5442, 49152, 0, 2715 },
    { 2716, 5444, 49152, 0, 2716 },
    { 2717, 5446, 49152, 0, 2717 },
    { 2718, 5448, 49152, 0, 2718 },
    { 2719, 5450, 49152, 0, 2719 },
    { 2724, 5456, 49152, 0, 2724 },
    { 2725, 5458, 49152, 0, 2725 },
    { 2726, 5460, 49152, 0, 2726 },
    { 2727, 5462, 49152, 0, 2727 },
    { 2728, 5464, 49152, 0, 2728 },
    { 2729, 5466, 49152, 0, 2729 },
    { 2730, 5468, 49152, 0, 2730 },
    { 2731, 5470, 49152, 0, 2731 },
    { 2720, 5460, 49152, 0, 2720 },
    { 2736, 5476, 49152, 0, 2736 },
    { 2721, 5462, 49152, 0, 2721 },
    { 2737, 5478, 49152, 0, 2737 },
    { 2722, 5464, 49152, 0, 2722 },
    { 2738, 5480, 49152, 0, 2738 },
    { 2723, 5466, 49152, 0, 2723 },
    { 2739, 5482, 49152, 0, 2739 },
    { 2740, 5484, 589824, 0, 2740 },
    { 2741, 5485, 589824, 0, 2741 },
    { 2742, 5486, 589824, 0, 2742 },
    { 2743, 5487, 589824, 0, 2743 },
    { 2744, 5489, 2359296, 0, 2744 },
    { 2745, 5491, 2359296, 0, 2745 },
    { 2746, 5493, 2359296, 0, 2746 },
    { 85, 2832, 589824, 0, 85 },
    { 2747, 5495, 2359296, 0, 2747 },
    { 2748, 5497, 2359296, 0, 2748 },
    { 2749, 5502, 2359296, 0, 2749 },
    { 2750, 5504, 589824, 0, 2750 },
    { 2751, 5506, 589824, 0, 2751 },
    { 2752, 5508, 589824, 0, 2752 },
    { 2753, 5510, 589824, 0, 2753 },
    { 2754, 5512, 589824, 0, 2754 },
    { 2732, 5490, 49152, 0, 2732 },
    { 2755, 5514, 589824, 0, 2755 },
    { 2733, 5492, 49152, 0, 2733 },
    { 2756, 5516, 589824, 0, 2756 },
    { 2734, 5494, 49152, 0, 2734 },
    { 2757, 5518, 589824, 0, 2757 },
    { 2735, 5496, 49152, 0, 2735 },
    { 2758, 5520, 49152, 0, 2758 },
    { 2759, 5521, 49152, 0, 2759 },
    { 2760, 5522, 49152, 0, 2760 },
    { 2761, 5523, 49152, 0, 2761 },
    { 2762, 5525, 196608, 0, 2762 },
    { 2763, 5527, 196608, 0, 2763 },
    { 2764, 5529, 196608, 0, 2764 },
    { 2765, 5531, 196608, 0, 2765 },
    { 2766, 5533, 196608, 0, 2766 },
    { 2694, 5461, 196608, 0, 2694 },
    { 2767, 5535, 196608, 0, 2767 },
    { 2768, 5537, 196608, 0, 2768 },
    { 2770, 5541, 196608, 0, 2770 },
    { 2771, 5543, 786432, 0, 2771 },
    { 2772, 5545, 786432, 0, 2772 },
    { 2773, 5547, 196608, 0, 2773 },
    { 2774, 5549, 196608, 0, 2774 },
    { 2769, 5544, 196608, 0, 2769 },
    { 2775, 5551, 196608, 0, 2775 },
    { 2776, 5553, 196608, 0, 2776 },
    { 2778, 5557, 196608, 0, 2778 },
    { 2779, 5559, 786432, 0, 2779 },
    { 2780, 5561, 786432, 0, 2780 },
    { 2781, 5563, 196608, 0, 2781 },
    { 2782, 5565, 196608, 0, 2782 },
    { 2777, 5560, 196608, 0, 2777 },
    { 2783, 5567, 196608, 0, 2783 },
    { 2784, 5569, 196608, 0, 2784 },
    { 2786, 5573, 196608, 0, 2786 },
    { 2787, 5575, 786432, 0, 2787 },
    { 2788, 5577, 786432, 0, 2788 },
    { 2789, 5579, 196608, 0, 2789 },
    { 2790, 5581, 196608, 0, 2790 },
    { 2785, 5576, 196608, 0, 2785 },
    { 2791, 5583, 196608, 0, 2791 },
    { 2792, 5585, 196608, 0, 2792 },
    { 2794, 5589, 196608, 0, 2794 },
    { 2795, 5591, 786432, 0, 2795 },
    { 2796, 5593, 786432, 0, 2796 },
    { 2797, 5595, 196608, 0, 2797 },
    { 2798, 5597, 196608, 0, 2798 },
    { 2793, 5592, 196608, 0, 2793 },
    { 2799, 5599, 196608, 0, 2799 },
    { 2800, 5601, 196608, 0, 2800 },
    { 2801, 5603, 196608, 0, 2801 },
    { 2802, 5605, 196608, 0, 2802 },
    { 2803, 5607, 786432, 0, 2803 },
    { 2804, 5609, 786432, 0, 2804 },
    { 2689, 5494, 786432, 0, 2689 },
    { 2805, 5611, 786432, 0, 2805 },
    { 2806, 5613, 786432, 0, 2806 },
    { 2808, 5619, 786432, 0, 2808 },
    { 2809, 5621, 196608, 0, 2809 },
    { 2810, 5624, 196608, 0, 2810 },
    { 2811, 5626, 196608, 0, 2811 },
    { 2813, 5629, 196608, 0, 2813 },
    { 2814, 5631, 196608, 0, 2814 },
    { 2815, 5633, 196608, 0, 2815 },
    { 2816, 5635, 196608, 0, 2816 },
    { 2817, 5637, 196608, 0, 2817 },
    { 2818, 5639, 196608, 0, 2818 },
    { 2820, 5642, 196608, 0, 2820 },
    { 2819, 5642, 196608, 0, 2819 },
    { 2821, 5645, 196608, 0, 2821 },
    { 2823, 5651, 196608, 0, 2823 },
    { 2822, 5651, 196608, 0, 2822 },
    { 2824, 5657, 196608, 0, 2824 },
    { 2829, 5666, 196608, 0, 2829 },
    { 2825, 5663, 49152, 0, 2825 },
    { 2826, 5665, 49152, 0, 2826 },
    { 2827, 5667, 49152, 0, 2827 },
    { 2828, 5669, 49152, 0, 2828 },
    { 2830, 5672, 49152, 0, 2830 },
    { 2831, 5674, 49152, 0, 2831 },
    { 2832, 5676, 49152, 0, 2832 },
    { 2833, 5678, 49152, 0, 2833 },
    { 2834, 5680, 49152, 0, 2834 },
    { 2835, 5682, 49152, 0, 2835 },
    { 2836, 5684, 49152, 0, 2836 },
    { 2837, 5686, 49152, 0, 2837 },
    { 2842, 5692, 49152, 0, 2842 },
    { 2843, 5694, 49152, 0, 2843 },
    { 2844, 5696, 49152, 0, 2844 },
    { 2845, 5698, 49152, 0, 2845 },
    { 2846, 5700, 49152, 0, 2846 },
    { 2847, 5702, 49152, 0, 2847 },
    { 2848, 5704, 49152, 0, 2848 },
    { 2849, 5706, 49152, 0, 2849 },
    { 2838, 5696, 49152, 0, 2838 },
    { 2854, 5712, 49152, 0, 2854 },
    { 2839, 5698, 49152, 0, 2839 },
    { 2855, 5714, 49152, 0, 2855 },
    { 2840, 5700, 49152, 0, 2840 },
    { 2856, 5716, 49152, 0, 2856 },
    { 2841, 5702, 49152, 0, 2841 },
    { 2857, 5718, 49152, 0, 2857 },
    { 2858, 5720, 589824, 0, 2858 },
    { 2859, 5721, 589824, 0, 2859 },
    { 2860, 5722, 589824, 0, 2860 },
    { 2861, 5723, 589824, 0, 2861 },
    { 2862, 5725, 2359296, 0, 2862 },
    { 2863, 5727, 2359296, 0, 2863 },
    { 2864, 5729, 2359296, 0, 2864 },
    { 86, 2951, 589824, 0, 86 },
    { 2865, 5731, 2359296, 0, 2865 },
    { 2866, 5733, 2359296, 0, 2866 },
    { 2867, 5738, 2359296, 0, 2867 },
    { 2868, 5740, 589824, 0, 2868 },
    { 2869, 5742, 589824, 0, 2869 },
    { 2870, 5744, 589824, 0, 2870 },
    { 2871, 5746, 589824, 0, 2871 },
    { 2872, 5748, 589824, 0, 2872 },
    { 2850, 5726, 49152, 0, 2850 },
    { 2873, 5750, 589824, 0, 2873 },
    { 2851, 5728, 49152, 0, 2851 },
    { 2874, 5752, 589824, 0, 2874 },
    { 2852, 5730, 49152, 0, 2852 },
    { 2875, 5754, 589824, 0, 2875 },
    { 2853, 5732, 49152, 0, 2853 },
    { 2876, 5756, 49152, 0, 2876 },
    { 2877, 5757, 49152, 0, 2877 },
    { 2878, 5758, 49152, 0, 2878 },
    { 2879, 5759, 49152, 0, 2879 },
    { 2880, 5761, 196608, 0, 2880 },
    { 2881, 5763, 196608, 0, 2881 },
    { 2882, 5765, 196608, 0, 2882 },
    { 2883, 5767, 196608, 0, 2883 },
    { 2884, 5769, 196608, 0, 2884 },
    { 2812, 5697, 196608, 0, 2812 },
    { 2885, 5771, 196608, 0, 2885 },
    { 2886, 5773, 196608, 0, 2886 },
    { 2888, 5777, 196608, 0, 2888 },
    { 2889, 5779, 786432, 0, 2889 },
    { 2890, 5781, 786432, 0, 2890 },
    { 2891, 5783, 196608, 0, 2891 },
    { 2892, 5785, 196608, 0, 2892 },
    { 2887, 5780, 196608, 0, 2887 },
    { 2893, 5787, 196608, 0, 2893 },
    { 2894, 5789, 196608, 0, 2894 },
    { 2896, 5793, 196608, 0, 2896 },
    { 2897, 5795, 786432, 0, 2897 },
    { 2898, 5797, 786432, 0, 2898 },
    { 2899, 5799, 196608, 0, 2899 },
    { 2900, 5801, 196608, 0, 2900 },
    { 2895, 5796, 196608, 0, 2895 },
    { 2901, 5803, 196608, 0, 2901 },
    { 2902, 5805, 196608, 0, 2902 },
    { 2904, 5809, 196608, 0, 2904 },
    { 2905, 5811, 786432, 0, 2905 },
    { 2906, 5813, 786432, 0, 2906 },
    { 2907, 5815, 196608, 0, 2907 },
    { 2908, 5817, 196608, 0, 2908 },
    { 2903, 5812, 196608, 0, 2903 },
    { 2909, 5819, 196608, 0, 2909 },
    { 2910, 5821, 196608, 0, 2910 },
    { 2912, 5825, 196608, 0, 2912 },
    { 2913, 5827, 786432, 0, 2913 },
    { 2914, 5829, 786432, 0, 2914 },
    { 2915, 5831, 196608, 0, 2915 },
    { 2916, 5833, 196608, 0, 2916 },
    { 2911, 5828, 196608, 0, 2911 },
    { 2917, 5835, 196608, 0, 2917 },
    { 2918, 5837, 196608, 0, 2918 },
    { 2919, 5839, 196608, 0, 2919 },
    { 2920, 5841, 196608, 0, 2920 },
    { 2921, 5843, 786432, 0, 2921 },
    { 2922, 5845, 786432, 0, 2922 },
    { 2807, 5730, 786432, 0, 2807 },
    { 2923, 5847, 786432, 0, 2923 },
    { 2924, 5849, 786432, 0, 2924 },
    { 2925, 5851, 786432, 0, 2925 },
    { 2926, 5853, 786432, 0, 2926 },
    { 2927, 5855, 3072, 0, 2927 },
    { 2928, 5857, 3072, 0, 2928 },
    { 2929, 5859, 3072, 0, 2929 },
    { 2930, 5861, 1536, 0, 2930 },
    { 2930, 5862, 1536, 0, 2931 },
    { 2932, 5865, 1536, 0, 2933 },
    { 2931, 5865, 1536, 0, 2932 }
};

// Generated from ssd_mobilenet_v2_int8.tflite
std::vector<armnn::MemBlock> ssd_mobilenetv2
{
    { 0, 1, 1080000, 0, 0 },
    { 1, 3, 270000, 0, 1 },
    { 2, 5, 720000, 0, 2 },
    { 3, 7, 720000, 0, 3 },
    { 4, 9, 720000, 0, 4 },
    { 5, 11, 720000, 0, 5 },
    { 6, 13, 360000, 0, 6 },
    { 7, 15, 2160000, 0, 7 },
    { 8, 17, 2160000, 0, 8 },
    { 9, 19, 540000, 0, 9 },
    { 10, 21, 540000, 0, 10 },
    { 12, 25, 810000, 0, 12 },
    { 13, 27, 810000, 0, 13 },
    { 14, 29, 810000, 0, 14 },
    { 15, 31, 810000, 0, 15 },
    { 11, 28, 135000, 0, 11 },
    { 16, 33, 135000, 0, 16 },
    { 17, 35, 135000, 0, 17 },
    { 18, 37, 810000, 0, 18 },
    { 19, 39, 810000, 0, 19 },
    { 20, 41, 207936, 0, 20 },
    { 21, 43, 207936, 0, 21 },
    { 23, 47, 277248, 0, 23 },
    { 24, 49, 277248, 0, 24 },
    { 25, 51, 277248, 0, 25 },
    { 26, 53, 277248, 0, 26 },
    { 22, 50, 46208, 0, 22 },
    { 27, 55, 46208, 0, 27 },
    { 29, 59, 277248, 0, 29 },
    { 30, 61, 277248, 0, 30 },
    { 31, 63, 277248, 0, 31 },
    { 32, 65, 277248, 0, 32 },
    { 28, 62, 46208, 0, 28 },
    { 33, 67, 46208, 0, 33 },
    { 34, 69, 46208, 0, 34 },
    { 35, 71, 277248, 0, 35 },
    { 36, 73, 277248, 0, 36 },
    { 37, 75, 69312, 0, 37 },
    { 38, 77, 69312, 0, 38 },
    { 40, 81, 138624, 0, 40 },
    { 41, 83, 138624, 0, 41 },
    { 42, 85, 138624, 0, 42 },
    { 43, 87, 138624, 0, 43 },
    { 39, 84, 23104, 0, 39 },
    { 44, 89, 23104, 0, 44 },
    { 46, 93, 138624, 0, 46 },
    { 47, 95, 138624, 0, 47 },
    { 48, 97, 138624, 0, 48 },
    { 49, 99, 138624, 0, 49 },
    { 45, 96, 23104, 0, 45 },
    { 50, 101, 23104, 0, 50 },
    { 52, 105, 138624, 0, 52 },
    { 53, 107, 138624, 0, 53 },
    { 54, 109, 138624, 0, 54 },
    { 55, 111, 138624, 0, 55 },
    { 51, 108, 23104, 0, 51 },
    { 56, 113, 23104, 0, 56 },
    { 57, 115, 23104, 0, 57 },
    { 58, 117, 138624, 0, 58 },
    { 59, 119, 138624, 0, 59 },
    { 60, 121, 138624, 0, 60 },
    { 61, 123, 138624, 0, 61 },
    { 63, 127, 207936, 0, 63 },
    { 64, 129, 207936, 0, 64 },
    { 65, 131, 207936, 0, 65 },
    { 66, 133, 207936, 0, 66 },
    { 62, 130, 34656, 0, 62 },
    { 67, 135, 34656, 0, 67 },
    { 69, 139, 207936, 0, 69 },
    { 70, 141, 207936, 0, 70 },
    { 71, 143, 207936, 0, 71 },
    { 72, 145, 207936, 0, 72 },
    { 68, 142, 34656, 0, 68 },
    { 73, 147, 34656, 0, 73 },
    { 74, 149, 34656, 0, 74 },
    { 75, 151, 207936, 0, 75 },
    { 76, 155, 207936, 0, 76 },
    { 77, 157, 4332, 0, 77 },
    { 78, 159, 98553, 0, 78 },
    { 79, 161, 57600, 0, 79 },
    { 82, 165, 57600, 0, 82 },
    { 84, 169, 96000, 0, 84 },
    { 85, 171, 96000, 0, 85 },
    { 86, 173, 96000, 0, 86 },
    { 87, 175, 96000, 0, 87 },
    { 83, 172, 16000, 0, 83 },
    { 88, 177, 16000, 0, 88 },
    { 90, 181, 96000, 0, 90 },
    { 91, 183, 96000, 0, 91 },
    { 92, 185, 96000, 0, 92 },
    { 93, 187, 96000, 0, 93 },
    { 89, 184, 16000, 0, 89 },
    { 94, 189, 16000, 0, 94 },
    { 95, 191, 16000, 0, 95 },
    { 96, 193, 96000, 0, 96 },
    { 97, 195, 96000, 0, 97 },
    { 98, 197, 96000, 0, 98 },
    { 99, 199, 96000, 0, 99 },
    { 100, 201, 32000, 0, 100 },
    { 101, 203, 128000, 0, 101 },
    { 102, 207, 128000, 0, 102 },
    { 103, 209, 2400, 0, 103 },
    { 104, 211, 54600, 0, 104 },
    { 105, 213, 25600, 0, 105 },
    { 108, 217, 25600, 0, 108 },
    { 106, 216, 2400, 0, 106 },
    { 107, 218, 54600, 0, 107 },
    { 109, 221, 12800, 0, 109 },
    { 112, 227, 12800, 0, 112 },
    { 113, 229, 600, 0, 113 },
    { 114, 231, 13650, 0, 114 },
    { 115, 233, 3200, 0, 115 },
    { 118, 237, 3200, 0, 118 },
    { 116, 236, 600, 0, 116 },
    { 117, 238, 13650, 0, 117 },
    { 119, 241, 2304, 0, 119 },
    { 122, 247, 2304, 0, 122 },
    { 123, 249, 216, 0, 123 },
    { 124, 251, 4914, 0, 124 },
    { 125, 253, 1152, 0, 125 },
    { 128, 257, 1152, 0, 128 },
    { 126, 256, 216, 0, 126 },
    { 127, 258, 4914, 0, 127 },
    { 129, 261, 1024, 0, 129 },
    { 132, 267, 1024, 0, 132 },
    { 133, 269, 96, 0, 133 },
    { 134, 271, 2184, 0, 134 },
    { 135, 273, 256, 0, 135 },
    { 138, 277, 256, 0, 138 },
    { 136, 276, 96, 0, 136 },
    { 137, 278, 2184, 0, 137 },
    { 139, 281, 128, 0, 139 },
    { 142, 286, 128, 0, 142 },
    { 143, 288, 24, 0, 143 },
    { 144, 290, 546, 0, 144 },
    { 145, 292, 24, 0, 145 },
    { 146, 294, 546, 0, 146 },
    { 80, 229, 4332, 0, 80 },
    { 110, 259, 2400, 0, 110 },
    { 120, 269, 600, 0, 120 },
    { 130, 279, 216, 0, 130 },
    { 140, 289, 96, 0, 140 },
    { 147, 296, 24, 0, 147 },
    { 81, 231, 98553, 0, 81 },
    { 111, 261, 54600, 0, 111 },
    { 121, 271, 13650, 0, 121 },
    { 131, 281, 4914, 0, 131 },
    { 141, 291, 2184, 0, 141 },
    { 148, 298, 546, 0, 148 },
    { 149, 300, 7668, 0, 149 },
    { 150, 302, 174447, 0, 150 },
    { 151, 304, 7668, 0, 151 },
    { 152, 306, 174447, 0, 152 },
    { 153, 308, 30672, 0, 153 },
    { 154, 309, 697788, 0, 154 },
    { 155, 311, 160, 0, 155 },
    { 155, 312, 40, 0, 156 },
    { 155, 313, 40, 0, 157 },
    { 155, 314, 4, 0, 158 }
};