/*
 * >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
 * ART -- Artificial Read Transcription, ART_454
 * Authors: Weichun Huang 2008-2016
 * License: GPL v3 
 * ############################################################################
 * #    This program is free software: you can redistribute it and/or modify  #
 * #    it under the terms of the GNU General Public License as published by  #
 * #    the Free Software Foundation, either version 3 of the License, or     #
 * #    (at your option) any later version.                                   #
 * #                                                                          #
 * #    This program is distributed in the hope that it will be useful,       #
 * #    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
 * #    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
 * #    GNU General Public License for more details.                          #
 * #                                                                          #
 * #    You should have received a copy of the GNU General Public License     #
 * #    along with this program.  If not, see <http://www.gnu.org/licenses/>. #
 * ############################################################################
 * <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
*/

#pragma once
#include <iostream>
#include <vector>
#include <sstream>
#include <fstream>
#include <string>
#include <map>
#include <cstdlib>
#include <climits>

#define IS_CUM_DIST false
#define HIGHEST_QUAL 80
//QUAL_DIST_ONE len
//QUAL_DIST_TWO len pos pre_qual

#define QUAL_DIST_1BASE "1	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n1	11689246	1276516	3703034	7516682	10871020	6539842	102210424	73949791	108823539	60805916	104723650	114396380	107935410	251902802	214547676	186373847	297009042	315627399	196048526	217274586	476950371	257276609	453292291	402734594	269577304	596908406	332062327	1074973725	352219073	978107263	1235403596	509661119	1738987281	230222943	254146179	1573060404\n2	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	58970	774030	1829749	3387711	5147083	3152979	47377966	39671920	61988782	19584477	45144268	56802658	55818747	59944316	69475791	60677891	95078132	74797090	76000598	53346905	121661797	79530611	116653706	103893075	86121412	131877523	94817980	272466803	101597801	247313469	311431484	131928954	428355491	68870544	65677841	389745636\n3	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	7474	456631	968983	1769357	3024407	1963485	36076087	15425293	40373983	18579178	32438423	32900434	24761575	26239564	26902344	22024645	41611806	21913939	28611170	16603900	32240867	37018857	25287293	34276171	20865687	45030897	25556612	45687884	28047527	59979865	64996744	32989302	99359770	17875895	67382710	15127566\n4	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1842	289930	498128	888138	1629892	964786	17244834	7666840	23847150	11128064	11669623	12144899	10920197	10214114	10878995	10392312	14625308	7995250	5195219	8492224	8045919	12403815	5874901	12267157	6479429	11658169	9361680	12325072	8201758	21447095	16488231	7970134	18344792	3651055	617994	3403963\n5	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	667	189768	254552	446512	784173	485615	9354853	7446605	8596740	9457241	3789508	5395076	3215842	3902886	2456817	5534805	2751597	3827199	2634035	1263993	3951887	5207839	1334867	4233325	1739037	2004038	2107832	698620	1282280	651930	4219983	2515930	4746309	521828	184704	987702\n6	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n6	316	125295	125679	208060	356452	244174	4593915	3107288	3314695	3931216	1732215	1158121	1412784	831417	1774032	1081135	1697761	1377186	527781	547875	631423	697603	411161	272376	272630	311908	762727	303218	227389	43565	359117	81742	33363	229140	9	212335\n7	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n7	185	77986	57345	99305	158759	121567	1819705	1054939	1363161	1420863	812473	862311	544731	440656	190810	306357	593995	166206	160617	179562	149020	72907	56836	243751	173991	62898	53704	33973	28296	17501	10	2	44925	2	14425\n8	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n8	132	47506	28427	50998	75413	63841	782574	398236	559088	770505	532078	191830	32758	165402	76313	185077	77931	49209	7441	64347	49875	15976	28780	15268	23346	5085	57	7447	7	11158	12	4	4514	2	10\n9	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n9	90	29481	16899	30620	43522	39201	411082	412510	297697	264057	221069	313342	19740	19816	322	27394	53235	176	22175	16	189	113	28	97	10	31	100	12	2	4	5	4	2336	2	11\n10	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n10	62	18350	11172	19600	28106	24166	261592	244810	183321	195954	130420	150704	10981	251	652	30736	1661	167	130	54	174	54	25	34	6	44	24	13	2	3	8	4	1284	2	11\n11	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37\n11	42	11625	7778	13510	19325	15372	178205	159307	122503	125802	86634	91689	6431	307	579	17451	1047	176	81	55	157	13	18	11	10	16	4	8	3	2	724\n12	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	35	37	40\n12	38	7693	5762	9387	14098	10226	132034	114236	90564	92493	64376	65414	4508	401	209	11227	715	52	153	16	50	12	24	12	5	18	5	12	3	502	1\n13	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37	39\n13	43	5120	4183	6842	10312	6901	99629	85379	70046	68235	51202	48863	3249	431	104	7306	603	39	179	21	22	19	22	7	7	7	17	5	1	1	351	2\n14	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n14	31	3304	3149	5109	8132	4776	74801	63312	54238	50117	40770	35533	1784	230	125	4688	470	14	74	19	22	8	13	14	2	3	9	3	2	225\n15	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32	34	37	40\n15	16	2298	2368	3710	6195	3378	55453	46290	41901	34778	31958	24909	956	191	97	2819	386	14	18	5	15	8	8	4	1	3	4	1	124	1\n16	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	31	33	34	37	40\n16	14	1576	1786	2892	5033	2542	40905	34084	31824	23656	24508	16873	501	111	68	1769	260	10	11	5	20	2	1	6	4	2	1	1	86	1\n17	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	27	31	32	34	36	37	40\n17	7	1111	1383	2167	3898	1963	30307	25129	24311	15944	18882	11268	291	93	27	1064	165	2	17	9	1	1	2	2	1	1	53	1\n18	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	31	37	40\n18	8	821	1082	1621	3072	1361	21631	17624	17513	10494	14127	7301	174	25	22	584	58	4	11	1	3	1	1	1	23	1\n19	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	27	28	30	37\n19	14	580	791	1339	2474	1033	15208	12120	12484	6798	10115	4643	110	19	5	345	25	1	14	1	1	1	1	2	17\n20	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24	25	27	30	31	37	40\n20	7	429	561	954	1770	743	10469	8110	8712	4233	7145	2744	43	18	6	222	13	10	3	5	1	1	1	11	1\n21	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	25	28	37\n21	5	298	394	704	1314	474	6824	5169	5968	2571	4930	1597	40	11	9	148	23	4	2	1	5\n22	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	29	30	37\n22	4	229	322	510	897	316	4327	3201	4111	1598	3161	971	12	10	2	75	13	1	1	1	1	1	4\n23	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	25	29	37\n23	4	152	223	314	534	217	2719	2006	2664	979	2122	527	8	5	2	43	10	1	1	1	2\n24	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	25	28	37\n24	4	126	165	242	396	144	1764	1273	1779	611	1415	332	10	4	1	28	9	2	1	1	1\n25	0	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21	23	37\n25	1	88	98	156	232	82	1044	795	1206	353	923	206	6	4	29	4	1	3\n26	0	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21	37\n26	6	53	65	98	188	68	657	497	831	250	644	132	3	4	16	6	1\n27	0	6	7	8	9	10	11	12	13	14	15	16	18	19	20	21	37\n27	7	45	44	56	102	33	414	328	545	172	445	80	1	1	9	1	1\n28	0	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21	37\n28	2	32	36	39	80	26	274	207	401	111	310	67	2	1	4	2	1\n29	0	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21	23\n29	1	17	20	28	59	17	211	134	278	67	226	44	2	1	2	1	1\n30	0	6	7	8	9	10	11	12	13	14	15	16	19	20	21\n30	1	15	20	15	39	12	117	108	199	54	159	25	1	2	1\n31	6	7	8	9	10	11	12	13	14	15	16	17	20	21	37\n31	14	7	12	21	11	66	589	154	66	709	135	5	134	20	31\n32	6	7	8	9	10	11	12	13	14	15	16	20	37\n32	4	6	6	13	2	36	36	71	23	67	15	3	1\n33	6	7	8	9	10	11	12	13	14	15	16	20\n33	3	4	7	14	2	32	26	73	12	52	8	1\n34	6	7	8	9	10	11	12	13	14	15	16	17	20	21\n34	5	5	9	6	1	29	22	60	13	49	11	1	1	1\n35	6	7	8	9	11	12	13	14	15	16	18\n35	4	4	2	10	14	9	41	10	34	6	1\n36	6	7	8	9	11	12	13	14	15	16\n36	2	2	3	8	19	6	31	13	22	5\n37	6	7	8	9	10	11	12	13	14	15	16\n37	3	1	2	7	2	11	8	22	3	20	4\n38	6	8	9	10	11	12	13	14	15\n38	1	2	4	2	4	8	22	3	11\n39	8	9	11	12	13	14	15\n39	3	2	10	4	15	3	7\n40	7	8	9	10	11	12	13	14	15	16\n40	1	2	1	1	8	2	10	2	9	2\n41	6	7	8	9	10	11	12	13	14	15	16\n41	1	2	1	3	1	2	5	6	2	3	1\n42	6	9	10	12	13	15\n42	3	3	1	1	5	4\n43	6	8	9	11	13	14	15\n43	2	1	3	5	6	2	5\n44	6	9	13	15	16\n44	1	1	1	3	1\n45	9	10	12	13	14	15\n45	1	1	1	6	1	3\n46	9	12	13	14\n46	1	2	1	1\n47	13\n47	5\n48	11	12	13	15\n48	1	1	1	2\n49	13	14\n49	1	1\n50	13\n50	1\n"
#define QUAL_DIST_MC "2	1	0	0\n2	1	0	58970\n2	1	6	6	9	11	12	13	15	16	17	18	20	22	24	26	30\n2	1	6	724672	49323	2	1	3	7	2	1	9	2	4	2	1	1\n2	1	7	7	8	9	10	11	12	13	15	18	20	21	22	23	24	25	26	28\n2	1	7	1661828	91071	68096	6760	19	1648	209	93	11	2	4	2	1	1	2	1	1\n2	1	8	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	25\n2	1	8	64706	3010648	68231	18128	125016	60947	32464	11	7500	9	2	33	9	3	2	1	1\n2	1	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29	32	34	39	40\n2	1	9	17482	21622	40963	4408264	136935	246072	160260	66949	21518	14957	5522	4824	1078	107	419	57	4	4	1	1	1	2	2	1	1	8	29\n2	1	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	39	40\n2	1	10	5512	12556	108663	2653378	59897	115790	57508	93973	14610	13918	7269	8949	86	193	504	10	30	2	1	1	1	1	4	36	87\n2	1	11	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	35	38\n2	1	11	47	81922	112043	47739	43198449	370021	1161201	150152	1021280	753607	135839	248444	31876	50980	8251	1873	2368	633	999	120	81	23	3	1	7	7\n2	1	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	32	33	35	36	37\n2	1	12	758	34884	70230	64313	504569	35773143	595236	429866	270041	790769	278614	172068	418575	99762	105076	41254	11467	3930	6268	440	282	46	6	38	2	108	64	46	65\n2	1	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n2	1	13	99	32871	50683	42282	1327680	934626	54470041	706969	869303	1103556	495374	632193	564444	196651	263554	112764	97972	38331	26785	14948	3680	2778	402	458	12	15	34	2	15	103	104	15	38\n2	1	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	14	11	6787	45490	110014	380452	916958	16165070	239526	427639	374265	339585	225790	57700	148556	54063	14646	48085	4556	7144	7749	6129	1045	1147	243	767	328	5	560	130	29	6	1	1\n2	1	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	15	684	15359	6901	3816	1177201	262824	1391490	379034	37242396	591996	1016167	1030238	752294	369880	404090	150849	121888	81025	58908	35315	18321	15986	4604	2645	5001	751	397	15	4105	15	59	6	3	5\n2	1	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	16	11	2159	9041	804015	971858	1232967	438292	877052	46345147	1096246	2024614	407537	1100601	531997	369692	105889	163135	197131	30593	44255	22705	7600	6825	1264	2357	2321	125	122	605	6338	25	125	14\n2	1	17	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	17	1	388	1663	4645	181285	325146	524969	321418	1349665	1544601	44663679	848377	1860242	748522	1303069	448976	573033	445650	149058	278749	128689	54000	23288	12002	12496	5917	1907	664	5033	647	364	27	116	461\n2	1	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	18	2	422	2627	331430	168018	723760	232690	1308019	2304702	1158000	47458135	829697	1417087	2053652	877362	388132	202463	131039	63793	129468	71482	34262	22130	13412	13840	3047	3065	1153	1066	162	94	71	34\n2	1	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	19	13	63	153	39017	457321	690003	219612	802372	491059	2390465	1181302	54861497	1732606	1562718	1220144	1636596	584315	407626	235682	449337	174745	154390	36750	51951	52124	29710	3435	7884	2006	638	130	75	52\n2	1	20	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	20	328	290	71831	136781	207251	39467	384484	1260672	877438	1718286	2277964	45832726	2676221	925501	634871	623524	2037678	284909	224690	156991	82120	44349	20869	68291	40805	7582	28092	3315	9708	467	172	218\n2	1	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	21	24	197	10824	121630	362716	169455	551144	531869	1294024	2393272	1854901	3274302	72091099	3157284	2228778	1664021	2143133	1388357	960468	442271	131002	140183	29666	54433	27346	8387	32370	8321	4109	1885	291	370\n2	1	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	22	1	22	1741	58496	161459	43188	152407	463872	481726	1034777	1278983	1098688	3631359	60155402	923524	1258118	1763585	675403	369429	690330	161827	193319	90828	40061	12481	18268	23487	7635	2996	2202	316	1160\n2	1	23	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	23	36	3453	16060	124424	19366	153967	123873	640346	439800	1805148	811294	2844836	1194567	57573532	1080270	2468323	978416	2657667	1053641	886772	363279	266621	279554	81042	41216	47703	15102	25344	2474	1610	862\n2	1	24	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	24	1	1368	7323	59998	59864	90932	217949	556939	245078	606559	766235	1968075	1555647	1526925	37617773	1274888	2166951	1971623	961840	563591	257297	224546	350124	131196	83670	46113	18789	6737	3760	2254	2860\n2	1	25	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	25	3	1104	8883	36192	4474	86964	224021	180073	167880	457756	2182061	2421462	2090670	2947304	1739966	96265034	2902298	3799826	2793298	736104	986598	332300	648903	297313	106770	190578	21223	19884	4727	3424	4704\n2	1	26	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	26	258	1036	22882	6928	50903	46186	332980	87149	253327	348294	1617974	911664	1124406	2577673	3351157	59816386	2699516	2160958	1522160	983464	444762	500813	199931	162505	105539	104389	56776	25076	5571	9948\n2	1	27	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	27	1	2	116	276	5707	11426	25117	53521	147458	140989	510933	231164	1124550	556671	2847224	2418155	4373568	3321812	86885080	4626394	4012450	1903977	1172817	1161635	378074	277568	261337	76145	77241	28201	9673	14424\n2	1	28	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	28	1	28	46	4618	7317	22305	33036	71366	70513	221125	148607	552300	905760	1233968	1071181	3218724	2483893	5656347	74567260	4535411	4467810	1215635	1886175	883352	165209	280022	62462	60052	27893	14687	25972\n2	1	29	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	29	2	3	16	937	1882	6884	13385	31348	41478	192749	95609	170899	332314	1006869	634272	889437	1736498	4700595	5414197	59415391	3328844	2070486	4057116	934473	445416	319074	101407	97929	29747	14136	38019\n2	1	30	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	30	3	12	481	646	4123	8399	14507	23973	41550	47546	142277	247509	429656	305469	1172895	1187578	2347015	5600424	4052577	102693597	4409303	5379143	1108530	1169361	758281	282093	282184	48194	34362	85835\n2	1	31	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	31	2	117	510	2383	2771	16794	15920	69521	26984	38245	171221	326522	236768	561832	539164	1391498	1418135	2458208	5388170	72241447	3950268	2901505	1363670	846877	412898	193281	131102	52138	60029\n2	1	32	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	32	4	117	791	1068	3680	8616	16980	68987	83028	58695	49697	334199	371167	746123	586466	1365981	2079926	4994881	6471303	4987704	235529210	5537871	4276518	2830761	782568	581861	177433	106540	414628\n2	1	33	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	33	36	61	148	336	1213	2212	3710	22598	47161	30939	16400	100561	113282	394297	247056	533649	1143789	1152061	1447333	3708366	6289293	74535276	2357173	6493864	1496523	680364	422107	138780	219213\n2	1	34	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	34	3	6	29	402	709	5090	4876	11139	10202	14761	52484	107237	175476	381384	508106	249888	661333	1335642	1513489	4880453	2616386	228863990	2691929	929601	1277332	297826	201512	522184\n2	1	35	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	35	1	15	14	202	833	212	1108	1154	4711	20018	24752	17982	31534	36484	214519	105474	290398	314119	415374	1003359	1092945	3111931	7998905	3441633	282644890	2545969	5550262	1563919	323315	675452\n2	1	36	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	36	1	46	81	69	7	261	246	331	1697	3490	8515	9329	9847	16225	28495	124057	88393	103787	134543	430176	780964	923894	1803126	1247572	3150960	115418727	3118178	2359032	735234	1431671\n2	1	37	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	37	1	9	14	39	11	543	192	254	511	1389	5349	2591	9655	6036	18702	67320	67103	65825	100251	348631	293577	785902	937908	1437234	7101041	3846720	406395933	3451166	1587816	1823768\n2	1	38	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	38	16	5	1	11	4	32	22	136	134	527	2715	3148	3278	3737	5570	32988	34212	40006	41544	76527	259436	265976	532037	422186	2005271	2826513	3414523	53345197	1460222	4094570\n2	1	39	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	39	12	43	1	1	11	2	17	18	199	56	255	282	463	520	1848	2406	4004	7749	12464	18051	16221	38229	58025	147800	135307	246441	411038	830035	3087778	1859534	53753017	5046014\n2	1	40	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	40	46	150	3	6	39	1	21	24	847	65	98	387	586	1185	1261	2818	4927	10778	15020	30548	33605	105622	64376	697297	241082	689727	863773	1621733	2472532	5112220	6652101	371122758\n3	1	0	0\n3	1	0	7474\n3	1	6	6	9	11	12	13	15	18	21	24	25	28\n3	1	6	434415	22201	1	1	3	1	4	1	1	2	1\n3	1	7	7	8	9	10	11	12	13	15	16	17	18	21	22	23	24\n3	1	7	923341	17883	23896	2885	15	790	135	22	1	4	4	3	2	1	1\n3	1	8	7	8	9	10	11	12	13	14	15	16	18	19	20	21	24\n3	1	8	24543	1655521	11584	5893	24732	29859	15271	6	1918	6	11	8	1	2	2\n3	1	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	40\n3	1	9	11229	13323	20428	2805113	44184	52307	38111	26386	5405	3879	1439	1909	499	24	82	39	5	5	7	5	2	2	4	20\n3	1	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	28	29	30	39	40\n3	1	10	2404	5832	59841	1782034	13393	40757	18490	24720	3257	6502	2079	3855	28	51	128	5	18	3	1	2	1	1	3	13	67\n3	1	11	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	31	38\n3	1	11	24	39226	43980	24156	34043884	210906	1164204	252980	152797	105685	14606	11555	5489	3056	2088	201	775	175	268	3	26	1	1	1\n3	1	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	33	35	36	37\n3	1	12	2676	22123	39977	26978	358560	14098937	50983	216286	157410	213197	140531	48787	28243	6681	10442	243	760	309	1452	506	113	1	1	30	26	10	20	11\n3	1	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37	39	40\n3	1	13	45	18934	34897	19600	1764202	155306	35825173	681923	758084	562904	123498	202902	84600	50720	60977	15628	4750	4953	2558	755	484	364	3	184	415	3	41	3	36	21	2	18\n3	1	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n3	1	14	53	11004	19563	615378	275907	990967	15268108	182270	375915	293309	180310	121799	75228	109989	20951	10043	9234	11573	1262	3351	1122	475	341	525	188	144	1	118	38	10	1	1\n3	1	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n3	1	15	687	4637	11038	2465	347015	183931	1195814	328167	28368334	600848	673431	189431	195516	95899	102159	25621	43851	22892	18261	10706	8100	2646	2130	1250	1208	935	487	20	909	1	27	2	5\n3	1	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	16	19	2432	11627	595254	290321	788579	448130	887985	27714165	502399	854322	197119	161312	296009	35429	19691	18033	45390	7114	10471	2921	2301	1922	3278	609	995	37	73	97	2391	6	2	1\n3	1	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	17	172	1645	4882	180010	436821	435724	397934	972771	740140	19151318	564240	821374	192572	525996	81277	87240	52339	69619	16789	14212	1524	4847	1942	2387	1350	614	174	1102	128	116	1	46	269\n3	1	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	18	3	2761	5951	80508	111124	448042	209200	267734	1254426	788064	20855371	528233	511667	747771	214961	95077	41495	24855	12575	13230	9165	5393	5191	2175	2233	533	1306	160	245	76	12	8	19\n3	1	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	19	95	216	401	35716	157208	382243	236370	333120	356789	1125536	803395	21253434	639493	443284	345465	339910	67385	223485	94081	25983	14378	3506	7135	3545	1906	5331	885	1479	209	303	10	21	27\n3	1	20	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	20	408	610	23199	24249	183176	111671	162601	329714	248208	713752	901749	17208270	884248	281502	171243	90205	462883	78789	61799	45807	8282	10658	2728	1568	6503	1490	5136	283	3779	84	48	3\n3	1	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	21	186	462	44116	75599	583720	231398	315154	514692	1129128	1125936	631377	1180098	32392408	777531	1123405	388713	520653	277033	148490	54837	28821	37683	8371	8543	4968	1488	5454	474	901	55	79	33\n3	1	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	22	20	400	2565	4817	171390	149371	61701	125541	192772	497557	486934	346606	1060415	17276738	363431	238600	311478	273042	110870	120524	37582	43872	19089	7523	4424	1676	4035	716	118	25	74	33\n3	1	23	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	23	12	179	3791	4063	92458	74230	311499	69698	211496	237444	941580	254810	1471580	500560	21456718	558570	482101	1247411	346214	143696	50701	73846	21391	15453	10991	11286	8571	1938	8383	100	365	35\n3	1	24	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	24	21	3242	2726	65647	53149	193207	57046	137464	109543	239629	135345	578946	345943	869862	12002819	398462	518720	356349	155093	130020	59120	54314	66722	25741	33624	7687	1076	1687	118	489	89\n3	1	25	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	25	1	54	1578	15466	22732	53368	172711	366084	151207	87781	367066	848604	879378	528994	627596	570207	24310288	1055810	765331	625775	203191	327094	106475	54585	37248	40406	13008	1623	4615	1109	1253	229\n3	1	26	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	26	182	4265	16241	18692	137861	132237	117765	55810	431590	275386	603192	501776	1767364	685824	1493228	27180275	812195	1409395	602835	369352	152251	108702	50967	47585	15764	8424	17155	433	2004	107\n3	1	27	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	27	3	18	256	1040	14867	32926	105455	96757	77623	93466	160671	155782	370048	230182	728067	565439	1050383	1198511	17846365	875909	627754	422155	219067	106088	109439	90720	53704	6190	44884	656	2187	681\n3	1	28	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	28	12	38	136	6418	16712	35955	72293	14199	80514	106732	280179	179761	334268	306016	255078	1122767	1842096	1098912	25394520	497835	1864930	302187	176635	127874	46519	39725	9771	55358	3123	5520	88\n3	1	29	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	29	6	59	309	7475	40779	23750	81994	66372	41079	61545	146867	181402	170156	296481	418442	919098	977119	650783	14973626	789249	339648	242449	198228	126023	80048	4216	15629	2854	9967	34\n3	1	30	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	30	9	4	472	989	1824	14021	24642	35230	65464	84879	94270	227501	208269	266183	164265	840450	652103	763037	2410778	1058526	33589999	1290163	1123361	356061	638964	82752	26337	946215	46762	14767	2600\n3	1	31	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	31	4	12	29	8	2363	6701	11431	52577	32884	41509	62303	45686	85328	190300	95555	104162	353966	348203	421529	588511	535042	1711679	18773225	671236	611891	457372	187362	70002	50693	11173	31539	2337\n3	1	32	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	32	338	2475	30741	19563	22425	34350	39095	27371	62714	49162	121200	144889	149303	333236	297681	481555	363421	2001648	883080	38932780	545304	821057	109985	52740	39125	15389	33754	73503\n3	1	33	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	33	1	5	233	1242	1978	11260	23681	13967	14565	34073	52146	51663	48416	75918	87589	125931	144140	249538	312035	392166	572280	844570	713609	21604744	739280	918906	686936	59403	71654	133789	61809\n3	1	34	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	34	112	202	1071	3840	5793	34309	26851	43480	45971	30288	66686	131698	177195	264802	354936	222012	254850	1071836	907778	1443158	956652	52286149	664238	299621	320043	135053	178988	52253\n3	1	35	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	35	9	192	90	400	2656	2900	4246	3974	18052	37987	38269	24354	34321	48228	44267	76590	134865	137715	283989	284717	486337	307287	1586656	1079627	58811408	609657	481576	190315	198822	67238\n3	1	36	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	36	6	10	54	45	51	1025	165	846	6406	9828	5361	20859	10936	15533	20535	59978	34149	98178	25698	115529	288347	181157	1099067	513204	1081634	27624081	879013	302630	543111	51866\n3	1	37	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	37	1	1	19	110	136	187	2357	743	3210	13260	19350	27130	4307	32109	16457	34065	65714	131857	132873	44294	1464468	235895	110308	226265	749494	1110992	1734139	91178254	1133576	568687	319512\n3	1	38	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	38	5	9	9	7	22	168	14	408	125	3218	836	1153	1150	8012	9337	11792	3110	14045	15882	108761	59942	40439	186874	291982	245457	427517	607358	14876877	493824	467562\n3	1	39	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	39	8	21	1	5	10	22	67	59	199	186	610	1365	4499	2708	3890	8257	11387	34429	16012	24876	69877	105116	100310	69008	356325	390455	366202	745704	1031022	1343723	62363566	332791\n3	1	40	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	40	36	136	12	7	35	4	20	34	633	73	1080	1024	295	221	397	871	2066	1931	1837	476	1344	13139	6983	164561	131072	97548	117061	69892	339609	831668	474715	12868786\n3	2	0	0\n3	2	0	7474\n3	2	6	6	9	11	13	15	16	17	20	21\n3	2	6	432214	13415	2	3	5	2	1	1	1\n3	2	7	7	8	9	10	11	12	13	15	17	22	25\n3	2	7	931855	19381	10764	2282	8	2191	74	484	2	1	1\n3	2	8	7	8	9	10	11	12	13	14	15	16	17	18	19	20	22\n3	2	8	17115	1680944	11143	5063	32584	20383	14306	40	3240	23	33	5	45	1	1\n3	2	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	39	40\n3	2	9	12518	13407	15024	2857300	43888	37834	36515	28436	9483	9896	2194	1616	2530	123	257	163	24	13	1	3	2	3	33\n3	2	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	30	31	39	40\n3	2	10	2619	5649	54427	1793002	11637	24336	17118	19326	2759	9878	4210	5687	370	544	459	252	128	15	20	2	13	3	19	4	12	78\n3	2	11	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31	32	35	37	38	39	40\n3	2	11	5	22290	33916	22278	34989617	229837	1392067	487689	263899	491971	126434	57392	26945	15644	22858	1814	2280	1804	968	59	194	16	13	1	10	1	1	1	4\n3	2	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	33	35	36	37	39	40\n3	2	12	460	24124	26980	32497	324690	14452878	49657	202911	157701	237140	355810	89151	114740	18038	53781	2997	3455	1727	9507	3254	789	73	40	423	252	195	25	53	5	1\n3	2	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	13	76	17830	28409	17131	1544727	157046	36759678	754587	795156	588331	349843	361986	295442	136464	420111	124934	61179	50924	12482	8859	12129	3055	102	331	2125	48	1050	79	65	38	96	1	1	9\n3	2	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	14	6	3050	16547	305842	261240	929030	15476727	203669	356435	332155	177636	192376	87311	177816	109211	53587	42980	43402	12691	22595	12741	4936	1157	5373	1488	1347	106	340	48	138	9	24	2\n3	2	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	15	205	4866	2734	1484	193319	179325	1170829	314471	28788784	632674	722224	195223	271805	131175	249638	52343	236231	147005	125622	92713	75465	27570	28295	10323	9592	22270	8882	706	1928	38	229	14	42	8\n3	2	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	16	9	878	6773	131920	265151	773771	442199	856722	28180813	554081	948569	257141	254916	396948	93250	56022	45502	263071	90465	67303	48062	19221	16813	42373	14001	17877	2272	1621	383	2370	118	45	15\n3	2	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	17	112	730	1853	22356	165904	162288	337427	923754	718230	19553999	555598	904262	209972	925705	156749	150259	101544	119765	85236	54097	10434	52814	22316	24155	16113	11215	3812	2939	117	594	9	127	354\n3	2	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	18	1	295	1938	14490	51283	267758	185091	248680	1159112	787296	21236016	553848	530145	894222	365536	190531	82474	61482	41726	70766	54125	47012	42757	28095	27596	10659	22380	2698	562	2826	207	109	39\n3	2	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	19	9	32	54	6258	40833	115872	137700	231728	291655	1062563	771321	21657660	656268	505679	389658	770080	182829	280993	319566	115952	71444	27406	56125	42305	27151	24188	17178	12712	4136	10606	65	379	603\n3	2	20	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	20	116	106	4544	8213	65412	96560	111325	204502	232455	666130	908133	17542567	888537	285541	196657	108546	675642	208712	121145	205845	44062	65038	31925	21088	40270	28773	29162	7574	16997	2045	835	655\n3	2	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	21	15	99	3751	12803	96287	137785	145389	379209	604034	938389	570776	1151870	32908425	809619	1115413	457387	715874	477987	277554	137727	99941	162268	60620	39433	34985	28189	26726	3677	15775	490	2600	201\n3	2	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	22	1	11	180	419	25820	26969	22335	44990	95134	294697	424527	326680	977558	17708497	383540	258373	430221	376790	148988	246990	107215	145778	116014	32039	32157	19857	16320	11253	2967	582	1677	142\n3	2	23	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	23	23	545	601	8101	11885	63097	22046	95484	109741	405678	224175	1499150	496279	21883869	711007	506076	1427682	574057	220572	136229	197151	70629	76725	54711	45068	23312	7057	20159	724	2241	250\n3	2	24	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	24	2	279	530	8338	10372	34449	23650	63641	45466	91665	107280	509721	334386	730507	12248015	416058	545802	458843	193981	231624	123857	81895	114024	65384	96041	31148	8972	11303	6108	4849	536\n3	2	25	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	25	1	2	296	2305	3940	15653	27097	63326	92641	33070	273847	557499	642537	411413	626726	570635	24926973	1202861	830653	928830	293402	630033	234161	101934	78710	118193	28266	9197	18874	6059	6373	1149\n3	2	26	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	26	3	458	1852	1256	16115	11885	21503	20007	122080	106146	356403	371441	1515508	664777	1291254	27590604	963510	1481102	734204	519441	260433	243311	104417	162174	52282	41369	45506	7311	20084	1060\n3	2	27	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	27	38	73	740	4447	12456	12715	15112	19566	35685	71803	190771	173800	432206	458724	950972	1000124	18206451	843729	784791	605719	327679	214636	185135	230435	103013	22241	92019	1666	10067	1356\n3	2	28	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	28	1	3	561	957	3709	6033	1131	9617	21831	57009	69734	192055	188085	186968	737515	1759470	1107931	25699838	512099	1922886	458087	364511	220602	148667	93350	55447	90144	7745	15302	232\n3	2	29	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	29	2	22	697	3408	3793	7069	7559	5440	14587	47019	88129	74807	151507	290587	732380	805569	623508	15111020	826267	394799	258886	301089	173971	201154	17108	30350	9287	43826	554\n3	2	30	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	30	1	11	95	228	1850	2388	2594	4798	9609	14916	45862	73355	93962	76378	414136	453920	560335	2329216	1019498	34153097	1448709	1536454	438654	858297	182155	69317	1114759	76820	65127	8588\n3	2	31	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	31	2	245	600	1171	4877	3514	3267	6598	4636	13791	51115	29076	56624	198860	198856	280016	410915	432508	1497769	19037137	722632	678592	732815	346977	155717	160232	18829	64492	3822\n3	2	32	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	32	23	263	1374	920	1979	3105	3069	2444	12090	13115	19615	74096	72563	146574	158357	238843	322022	1421381	797932	38932342	557173	1195440	229348	127703	75251	18547	48268	78559\n3	2	33	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	33	1	3	27	138	591	1011	649	754	3603	6816	6736	7471	13978	25236	61929	65367	140826	202021	254996	467900	752385	654487	22028335	825792	1261107	850465	157002	124229	251816	79794\n3	2	34	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	34	1	5	33	176	282	2262	1457	2811	3418	3560	17714	44482	61976	105830	163199	89282	167748	769192	528737	925613	825221	52369354	834688	393833	583937	221500	291341	60720\n3	2	35	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	35	10	5	62	328	145	374	192	1142	2604	3097	3487	5146	7200	17008	18360	64385	54862	110253	150116	273712	145282	1054110	864994	58916160	827048	866871	204365	267493	74172\n3	2	36	10	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	36	2	20	28	32	76	40	98	278	299	394	1730	691	1318	4740	14387	10210	24320	6895	61296	174748	74844	811800	401088	805710	27764542	1228559	341582	597129	55255\n3	2	37	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	37	5	9	24	6	445	96	139	258	734	1534	459	3315	2212	6134	24683	47914	76380	18486	1206601	83041	54128	78389	379557	560028	1140161	90774822	677891	645850	304474\n3	2	38	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	38	2	1	1	2	2	9	3	42	14	138	62	85	137	214	1740	1200	992	6200	5403	65793	46216	36775	115216	168072	225825	388584	862632	15443663	992011	606374\n3	2	39	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	39	8	27	2	6	2	7	6	93	17	105	184	177	335	743	902	2685	3778	3953	8977	16160	23305	42168	47257	175879	232512	260061	650899	882963	658631	61676561	369240\n3	2	40	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	40	36	79	2	2	32	7	11	455	40	42	16	117	40	126	251	352	260	909	138	284	4082	3331	141374	94480	86050	104777	60747	345472	591593	378422	12488488\n4	1	0	0\n4	1	0	1842\n4	1	6	6	9	11	12	13	14	17	21	25\n4	1	6	270857	19063	3	1	1	1	1	2	1\n4	1	7	7	8	9	10	11	12	13	14	15	17	18	21	22	24	27\n4	1	7	471349	9170	15338	1528	4	572	137	1	20	1	3	2	1	1	1\n4	1	8	7	8	9	10	11	12	13	14	15	16	17	18	19	21	24\n4	1	8	939	837351	6735	3364	11581	20979	6188	8	949	24	2	9	4	4	1\n4	1	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	39	40\n4	1	9	76	1696	3799	1537391	20528	26916	20676	10961	2967	2338	756	1272	420	21	2	41	2	7	5	2	1	1	2	1	3	8\n4	1	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	30	39	40\n4	1	10	539	1132	21149	878628	7171	22247	9536	14798	1815	3102	1264	3220	17	35	62	2	10	1	3	4	51\n4	1	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31	35\n4	1	11	195	3074	8336	16446293	146360	442856	108441	55920	20492	4899	3732	1650	1126	496	111	665	57	115	2	9	2	2	1\n4	1	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35	36	37\n4	1	12	329	2152	4350	109101	7026734	100757	187772	76675	68186	31978	37417	9023	8635	2160	201	565	57	590	41	44	3	1	27	1	1	1	10	15	14\n4	1	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	32	35	36	37	39	40\n4	1	13	1	4924	7898	3809	543132	71323	21890727	260725	372677	242788	280890	73761	21545	59201	6654	2357	2028	972	1055	225	143	108	1	149	2	3	22	12	3	15\n4	1	14	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n4	1	14	1	88	100986	104825	175235	9747862	92873	277766	269360	135638	107323	55731	14692	8434	9934	3456	21653	911	213	599	38	174	108	30	6	16	84	21	6	1\n4	1	15	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n4	1	15	631	18	44824	81266	494093	95438	10148652	296439	172283	53359	78332	110913	48793	19750	6433	3025	8845	3330	483	1473	115	107	17	41	485	22	435	1	20\n4	1	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n4	1	16	1788	10237	74812	321013	202937	331753	10385607	163702	353900	73191	76690	68614	31563	5750	2980	30758	1866	2670	1918	417	661	71	41	66	75	25	55	1733	2	4\n4	1	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	17	57	108	200	310	248932	155507	168801	198697	9022601	310692	431168	161526	95974	52580	20014	9186	32360	4651	3049	990	370	1142	362	11	45	44	439	101	111	1	23	145\n4	1	18	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n4	1	18	23	38560	52464	91638	36797	427951	248793	8389631	186976	335397	245072	71379	30881	15161	14243	7201	10390	4315	973	4600	448	230	81	673	59	143	26	7	2\n4	1	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n4	1	19	5	5084	1763	101177	51354	71439	474435	205051	8859267	386480	419120	213772	22388	23408	16186	12654	5015	4182	527	3072	513	623	131	459	672	83	130	5\n4	1	20	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n4	1	20	18	1	27294	47303	106618	45928	87025	244449	295958	8447936	427698	228226	113568	77471	163413	43886	11430	11056	2383	2014	676	326	1783	791	2702	50	2294	15\n4	1	21	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	21	5	30	173	109	41926	61206	76597	143681	424204	453054	12007746	469965	160616	353676	151969	170839	61972	21088	6254	12256	1407	1883	850	550	2721	265	240	22	2	2\n4	1	22	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	22	15	11	18	156	2759	20448	30814	76297	128983	181407	177658	6394145	260728	199685	166484	179239	59141	69410	7946	21097	9331	3543	883	991	3686	328	30	14	2	1\n4	1	23	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n4	1	23	1	1	12	17	3	473	205	1934	17822	12943	97059	133441	149027	4214689	109571	106304	105984	101820	47381	14503	38097	18194	4219	5498	7346	3561	1064	4007	37	6\n4	1	24	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	24	1	10	35	161	68	441	4352	19453	76375	384447	237516	130618	6430164	357959	440013	140526	149703	37436	23275	13314	11535	5598	22050	5293	506	1304	14	55	2\n4	1	25	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	25	9	3	11	14385	4103	12336	41204	6995	4387	31755	47098	111398	99852	155112	6466360	268336	212671	278803	83850	67881	50168	10769	19392	40686	14430	1562	2171	147	38	7\n4	1	26	11	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n4	1	26	1	15	102	17	506	4805	3749	16672	141984	167878	92021	430903	213921	10040465	113068	681244	166717	173245	66219	12803	17258	39329	13426	5849	1533	84	1\n4	1	27	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	27	5	5	17	10	401	1270	1207	3540	16507	44732	47333	119506	77244	132762	4658732	288037	117281	206069	59501	11412	24162	30819	22657	3331	8061	293	3	4\n4	1	28	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	28	2	8	1	5	15	17	95	103	4143	3861	19212	39539	104509	151112	473096	183099	9919383	211908	482497	352407	158380	45965	72989	18979	12097	11659	1857	165	54\n4	1	29	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	29	1	1	4	12	86	178	182	3261	9837	11141	12812	36676	110948	84834	189303	5488347	92425	176545	59842	69405	90804	38272	478	2304	1072	618	41\n4	1	30	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	30	1	1	2	2	2	8	25	192	121	3590	1932	10081	11687	118258	118159	292252	102802	9651945	431406	631269	71066	131617	44848	20951	13153	307	603	1889\n4	1	31	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	31	42	6	121	3	88	48	130	2862	4724	4956	20536	35816	36361	259851	87720	169708	7985795	243160	234351	187000	49654	28808	8013	1417	500	10\n4	1	32	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	32	1	2	1	20	52	88	144	1497	576	6586	7939	10888	4477	80862	56512	292981	186585	11055191	253504	204021	80699	16584	33586	336	3137	28803\n4	1	33	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	33	4	1	7	3	15	132	55	446	298	2223	8295	8720	9453	33909	42140	63142	165339	86899	6533612	747241	384023	77787	30968	5363	946	737\n4	1	34	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	34	11	2	7	7	4	6	61	105	2724	15905	12610	19602	17034	39176	8984	46590	29416	272740	20787825	141558	25989	6919	8707	3095	8018\n4	1	35	14	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	35	1	2	3	12	1	64	187	226	1143	2155	2028	737	9958	5275	30205	20936	47113	38233	142891	15942627	153780	56659	14580	5978	13437\n4	1	36	13	14	17	18	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	36	3	2	1	6	31	8	28	158	102	1400	8374	280	21035	30486	58847	29802	36088	106833	7300728	277937	82455	7909	7621\n4	1	37	12	14	18	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	37	1	1	5	1	8	48	2	23	25	360	133	863	10637	8674	55630	5003	23399	22102	97045	17905574	106060	29480	79718\n4	1	38	11	14	16	17	18	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	38	4	4	2	1	7	12	28	10	109	25	113	1366	337	1105	9458	6195	6960	8704	13970	76475	143010	3153157	68981	161022\n4	1	39	9	10	13	17	18	21	25	26	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	39	3	6	1	26	1	1	2	1	28	51	196	28	5213	17	2920	6109	4336	29044	28558	460007	81446\n4	1	40	9	10	13	17	21	22	23	24	25	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	40	13	44	13	211	1	1	15	1	1	1	1	3	41	7	49275	869	14880	20317	6968	69909	58061	42351	3140980\n4	2	0	0\n4	2	0	1842\n4	2	6	6	9	11	13	15	16	17	20	23	39	40\n4	2	6	258819	12098	2	4	3	1	2	1	1	1	1\n4	2	7	7	8	9	10	11	12	13	15	16	17	18	19	22	23	24	26\n4	2	7	456176	8771	6731	1115	15	1449	61	196	2	1	1	2	1	1	1	1\n4	2	8	7	8	9	10	11	12	13	14	15	16	17	18	19	24\n4	2	8	12120	805198	5454	2521	13088	12968	4778	30	1346	28	17	4	35	1\n4	2	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	39	40\n4	2	9	12176	9938	10277	1504745	19023	15945	17074	10784	4368	4632	1163	963	1601	106	4	92	12	5	1	1	15\n4	2	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	31	39	40\n4	2	10	1346	3039	26690	845257	5326	12155	7228	9794	1305	3910	2110	3379	187	235	225	130	73	7	10	1	6	3	13	4	9	46\n4	2	11	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31	34	35	38	39	40\n4	2	11	11	17324	21360	12264	16177429	178550	544781	183802	72682	44213	29700	5266	5423	5066	1534	412	243	141	246	5	52	1	12	1	2	4	2	5\n4	2	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	32	33	35	36	37	38	39	40\n4	2	12	2276	17926	21892	15759	271536	6688892	93098	210750	83342	84033	60467	32157	10936	12906	2267	989	1392	153	2247	128	220	1	17	283	2	5	80	17	30	1	3	3\n4	2	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n4	2	13	90	6883	14197	8936	722087	155687	21139689	268676	390756	271894	387347	133003	50726	150592	43521	11547	13793	3320	2493	2138	3594	739	29	229	5	15	173	2	18	20	21	3	10\n4	2	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n4	2	14	48	5823	11579	242888	282320	353742	9112930	84842	242815	237098	122332	126740	63996	35361	30262	36226	12793	17979	4994	912	870	415	1316	2575	114	8	130	104	30	41	1\n4	2	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n4	2	15	340	2102	6494	1576	98172	103245	545605	125464	9705829	284116	166880	43983	101425	122062	58710	42977	17370	10965	20884	15660	982	9225	1215	763	455	271	8329	458	1054	13	186	27	1\n4	2	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n4	2	16	35	1475	4981	64832	115880	397309	299057	396015	9924159	158255	336427	71852	77629	87964	47742	9516	9447	73585	12013	11033	20110	2793	1631	859	991	1176	1878	587	469	3730	59	14\n4	2	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	17	78	1239	2672	49308	85073	521736	292823	225499	232625	8373507	272460	402928	158964	91088	68511	21433	25657	34224	15088	9001	6271	2532	9114	985	193	1129	756	862	896	3614	61	19	459\n4	2	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	18	4	2708	5137	9012	46150	188072	151778	54913	465213	383126	7774093	177039	330614	242562	78988	36789	27635	18586	12355	20355	11431	5549	9802	4827	1174	735	5372	409	560	1670	44	6	40\n4	2	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n4	2	19	61	176	268	9136	17046	77615	163829	136607	109618	537498	269891	8166415	377821	416132	230654	21733	32523	21691	16952	12487	12966	1755	10737	6232	3327	458	4063	1422	663	58	39	8\n4	2	20	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n4	2	20	15	348	10265	21918	211706	87527	154086	105853	205875	436561	500274	7613854	441439	203936	109600	97728	169923	62179	14999	18125	5049	6014	5401	2148	6966	6583	9124	390	375	55	8\n4	2	21	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	21	1	201	317	2775	3426	67970	53303	82454	116876	115866	328183	561859	586015	10849322	471977	144131	325348	157665	199140	72208	36550	14674	19240	9449	3093	3690	7678	6899	2424	2199	943	24	53\n4	2	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	22	27	223	664	1972	19614	38063	61705	68331	95091	114302	316834	271312	595271	5595157	252274	233381	161538	175794	57239	86139	11695	37218	24611	5122	3106	6347	4137	1212	1611	609	120	21\n4	2	23	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	23	6	134	442	1924	19852	49821	27233	13593	32759	51354	34135	144516	199532	319889	3746674	111955	103465	110419	118425	57261	14256	64191	20914	8641	7954	11242	5043	365	700	30	3	12\n4	2	24	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	24	15	236	212	6193	15513	14983	14696	40663	41600	52359	137741	432160	296006	154064	5695294	354229	397390	143925	141526	38428	34054	15245	12510	6609	24159	8010	641	905	39	63	4\n4	2	25	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	25	1	27	531	4310	4704	28545	28658	112803	47335	27935	34989	231441	217948	223697	130306	448933	5490999	297182	194276	246667	85357	77338	61351	14469	19157	41944	11163	885	734	161	115	100\n4	2	26	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	26	1	2	165	3990	7137	25213	18686	24452	18417	27600	98514	279584	243584	139381	516311	389902	9115969	117532	649301	160114	165412	66465	18301	17988	54109	14157	8609	3023	917	60	27\n4	2	27	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	27	12	87	336	5505	1492	1636	18817	15118	30334	18732	21500	105860	84797	155662	184816	252721	165446	3992471	305049	108216	207916	62256	17546	20576	35827	20514	3523	2914	225	11	59\n4	2	28	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	28	4	5	9	1891	1515	12003	27923	9509	19405	19906	27632	58820	132411	85213	205508	325926	814340	392231	8807045	199798	494114	352565	200057	45817	89818	21227	13833	12159	1667	162	255\n4	2	29	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	29	5	1	32	63	860	2194	4294	3661	9160	3180	8613	28425	21406	21297	58061	125196	220325	147027	259379	4980473	105313	201835	63725	77951	81392	44960	1024	2474	1021	528	352\n4	2	30	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	30	18	407	426	1736	1368	3401	15932	17005	19563	9520	31884	61346	95743	50598	112978	239704	280520	617842	149862	8238128	445093	683677	78017	140663	51158	15484	11560	559	641	3937\n4	2	31	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	31	1	8	11	40	4127	827	1748	1790	8605	10303	9096	14895	48235	31857	24006	102790	108306	91575	481126	274985	535982	6976270	277371	268887	235452	71699	35221	17260	1646	325	144\n4	2	32	10	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	32	1	105	153	580	1798	438	2161	5830	3407	6021	8848	16124	18274	25233	32905	30004	287974	87566	913757	385979	9925023	241822	279016	102088	95101	41986	805	3142	27758\n4	2	33	10	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	33	2	268	35	10919	1831	1188	1252	909	10314	5869	5904	11462	10990	28220	28245	31907	70433	112900	108893	352642	294023	5229113	799501	367865	83741	54856	12737	580	1166\n4	2	34	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	34	1	1	1	244	729	3263	1118	10151	7886	11813	13293	11336	19307	39949	71163	96131	64892	127406	126640	201622	332964	378536	1028163	19695780	253930	27664	41136	17229	3573	8310\n4	2	35	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	35	5	105	36	149	1726	957	1198	773	2568	14183	10312	7486	9460	13718	18660	23013	32410	34457	75387	85534	111790	147711	498124	299804	15286274	166192	66191	13466	5213	13293\n4	2	36	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	36	2	13	27	36	15	735	1037	904	1236	821	3631	3120	637	1299	3053	14642	6430	26220	2150	26394	78539	113000	130597	43424	238298	6746485	299696	72898	10257	9826\n4	2	37	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	37	31	89	48	264	4411	4410	2617	104	479	2858	3161	886	1236	1169	5292	4709	18033	4646	21781	33228	79412	90580	44224	102178	469014	17283872	323428	27330	80937\n4	2	38	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	38	4	4	5	53	89	72	87	59	148	1042	1243	85	94	460	1720	497	3097	1931	1969	12109	6528	25962	29629	21132	103379	238965	2801176	55764	155269\n4	2	39	6	9	10	13	15	16	17	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	39	1	4	10	1	1	1	30	30	2	40	256	3	90	220	145	15	298	879	980	587	4697	1093	6595	8657	16008	35110	85711	371381	91059\n4	2	40	6	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	40	1	16	73	3	3	19	4	25	699	109	19	10	92	69	25	8	237	38	115	652	722	7765	872	54932	2266	17117	21675	14182	87449	240198	119634	2954994\n4	3	0	0\n4	3	0	1842\n4	3	6	6	21\n4	3	6	270996	1\n4	3	7	7	8	9	10	11	13\n4	3	7	481952	5	1	329	7	3\n4	3	8	7	8	9	10	11	12	13	15	16\n4	3	8	9240	857481	1	541	17	295	3653	518	1\n4	3	9	6	7	8	9	10	11	12	13	14	15	16	17	18	39	40\n4	3	9	11702	9591	8734	1579226	14183	460	1178	6157	1	4	1	107	1	1	7\n4	3	10	7	8	9	10	11	12	13	14	15	16	17	21	39	40\n4	3	10	1425	2962	26276	892766	1418	2817	3047	60	1	1496	1	1	4	15\n4	3	11	7	8	9	10	11	12	13	14	15	16	17	18	19	21	23	25	28	38\n4	3	11	6	10780	19756	12748	17071779	51866	410623	77127	31729	7224	139	19	4	1	2	2	1	2\n4	3	12	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22	36\n4	3	12	408	16551	16002	18575	222102	7235225	18989	72815	64014	55090	99	28060	3406	2	12	2\n4	3	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	36	40\n4	3	13	70	6350	11834	8906	602216	163563	22525803	114351	343488	211684	189288	31374	68	17876	111	7	3	2	1	1	8	2\n4	3	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	29	31	36\n4	3	14	2	2130	10748	132911	230651	330148	9870115	59102	159069	120843	75049	77787	34616	57	4	1	33	10332	1	1	1	9\n4	3	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	30\n4	3	15	96	2493	1635	992	68886	91413	525283	129667	10221393	225663	120119	29956	40338	87798	33307	2362	330	4	2877	2	3	1\n4	3	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	30	31	32	34	38	40\n4	3	16	23	586	2782	22320	91673	361577	314651	401230	10421754	120658	300411	41200	31481	49627	14427	184	26	9290	7	3	1	3	1	2	3	1\n4	3	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31	33	36	39	40\n4	3	17	56	560	1407	7923	35554	364648	308039	221610	230793	9097643	157318	352297	61973	60861	23758	1175	192	28438	482	249	2	111	4	2	19	98\n4	3	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	32	34	36	38	39\n4	3	18	1	332	1903	4482	46358	108915	137698	57350	466469	379895	8438982	118289	174544	104651	51262	12176	2370	5314	3500	1025	2	2	1	3	11	6	1\n4	3	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	32\n4	3	19	4	32	45	1954	11897	27888	128409	90645	99025	555592	267454	8918029	198850	309533	98489	7229	11451	2788	2018	781	11	9	28\n4	3	20	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\n4	3	20	4	62	2111	13755	91700	71203	128000	92805	175456	407780	470173	8438570	317291	127428	72698	54689	20421	10592	2560	3201	139	29	23	46	80	3\n4	3	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	38\n4	3	21	27	100	397	1703	10286	16280	61943	84886	106894	302079	546882	562051	11935352	122065	90252	291903	32961	98179	9744	3136	403	70	7	94	15	3	36	6\n4	3	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n4	3	22	1	10	92	323	5520	11123	21068	41995	66225	97001	259921	269885	507901	6451034	109357	168285	75964	122641	30091	9461	4056	2490	89	1197	141	38	180\n4	3	23	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38	40\n4	3	23	20	192	439	2680	11673	7854	5491	19731	38294	29597	138571	195276	317537	4211417	83547	76424	69794	35450	26138	7572	1345	3252	306	44	61	9	26	21	5\n4	3	24	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38\n4	3	24	1	24	28	1702	4451	3546	3764	12220	17556	36200	108380	460058	249745	144793	6487473	108381	326928	90968	76131	8646	6306	3715	4687	1154	2271	1099	1	12\n4	3	25	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n4	3	25	1	157	977	1300	29973	13753	42752	39579	16617	19493	201251	191747	211294	128886	383528	6442376	143076	54378	109882	22897	3888	8893	4471	4295	9928	1930	293	7	70	1\n4	3	26	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n4	3	26	10	527	1041	4530	3078	5507	12364	16482	66189	224960	236256	120433	555154	328734	9961256	81775	373263	80481	80582	22264	5258	5205	88	2115	85	18	5\n4	3	27	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n4	3	27	1	25	11	347	318	537	2796	4243	11745	5558	13637	83463	87040	128868	178593	250202	159745	4607303	131866	61485	88779	21833	1662	4225	6133	475	1021	38	100\n4	3	28	10	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n4	3	28	1	181	340	2026	3501	879	4571	4698	15355	29274	103509	60654	186668	332473	749374	341625	9853039	144109	216640	185872	60941	18153	7635	6937	6785	41	889	27\n4	3	29	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	29	1	2	95	156	801	641	1918	920	4279	14690	16171	19786	43577	109063	199047	147815	248676	5436766	63952	62664	44162	29166	23643	1476	174	119	251	21	1\n4	3	30	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	30	2	13	35	61	187	452	1610	3113	3225	2764	13591	39450	51305	34879	90117	223948	265765	553250	143737	9530043	143275	204562	41789	5883	14665	14091	5256	254	143	38\n4	3	31	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n4	3	31	1	4	6	160	135	200	554	690	1078	1829	2752	25113	22597	18675	83765	87595	77595	444021	206032	447279	7850836	125193	123740	31715	7996	2803	2878	876	1\n4	3	32	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	32	7	23	81	195	23	341	1364	679	1624	5702	5408	13266	15945	21762	19298	196420	80245	762013	304763	10665919	69999	20735	33979	46577	24773	24	3361	22083\n4	3	33	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	33	8	8	630	108	143	195	313	2292	1277	2405	7271	7708	30936	21771	28859	73486	89401	96898	302757	306284	6583890	205056	28685	21078	2746	1616	1	629\n4	3	34	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	34	16	48	129	104	975	661	1209	1352	2080	10386	24216	50836	60072	49780	101481	101950	145943	231846	272417	866764	19869579	113719	22133	22946	4125	1171	7026\n4	3	35	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	35	5	4	73	332	90	306	111	486	1661	1829	3068	3045	4692	14862	11883	23711	27590	48227	69840	78291	103777	416518	193031	15561612	73291	11528	9268	3436	12159\n4	3	36	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	36	1	13	22	24	1	92	76	75	113	58	263	782	290	518	1962	7624	4957	20221	1046	32756	59835	28898	94468	43282	204684	7195302	46544	57099	2436	4603\n4	3	37	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	37	4	7	4	1	443	107	25	18	543	176	117	704	1195	1180	2184	3729	18924	4354	24436	18254	57805	49738	12781	79166	386119	17273857	195858	19998	62798\n4	3	38	11	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	38	2	5	3	3	4	25	11	4	36	33	68	24	296	290	320	2505	1120	1712	12632	5434	16428	16059	20469	100706	81447	3248155	24565	43400\n4	3	39	6	9	10	11	13	14	17	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	39	1	3	10	1	2	1	31	4	2	2	2	7	46	87	1	20	199	631	1062	492	5499	874	4915	7907	11774	32862	79189	422759	30587\n4	3	40	9	10	11	12	13	14	15	16	17	18	19	21	22	23	24	25	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	40	32	56	1	1	27	1	1	5	247	6	9	5	1	16	3	16	76	135	215	3845	331	50930	1251	15820	21190	11690	84225	208451	108877	2840723\n5	1	0	0\n5	1	0	667\n5	1	6	6	9	11	17	18	22\n5	1	6	176937	12827	1	1	1	1\n5	1	7	7	8	9	10	11	12	13	15	18	27\n5	1	7	240939	4301	8064	910	1	264	66	4	2	1\n5	1	8	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22\n5	1	8	543	423737	3669	2109	4938	8548	2556	1	383	16	1	4	4	1	1	1\n5	1	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	39	40\n5	1	9	49	747	1778	745015	8247	12007	8904	4108	1164	964	302	687	160	10	2	14	1	1	2	2	1	1	2	1	4\n5	1	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	28	30	39	40\n5	1	10	234	504	7909	445623	3887	10385	4840	8617	906	773	485	1354	19	15	24	4	9	3	3	1	1	2	17\n5	1	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	31	38\n5	1	11	74	1424	4170	8995445	266330	41328	15617	20387	6372	1277	930	732	119	188	6	365	28	56	3	1	1\n5	1	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	33	35	36	37\n5	1	12	98	810	1675	358546	6652153	82207	262366	41625	26807	10770	4915	2428	923	858	16	152	30	190	1	8	1	2	3	15	6\n5	1	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	28	30	32	35	36	37	40\n5	1	13	2	1412	2417	1491	38722	54632	8142975	71019	72810	108837	69710	14420	12619	2190	1931	603	609	70	205	3	28	1	1	1	14	9	9\n5	1	14	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	35	36	37	38\n5	1	14	29	4229	310252	62744	8489414	135636	170070	61523	81796	45162	81047	4557	1211	863	1447	6955	66	96	25	5	34	60	16	2	2\n5	1	15	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	35	36	37	38	40\n5	1	15	252	21	14774	35789	69567	46812	3242462	94532	82010	55471	38457	57449	22713	18613	2562	564	6766	39	134	284	2	23	2	164	3	39	1	3\n5	1	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	35	36	37	38	40\n5	1	16	370	2904	30779	117636	220125	99258	4345389	162303	195477	97951	55884	31939	8622	5159	2686	16471	107	467	312	10	65	1	127	28	1003	2	1\n5	1	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	35	36	37	39	40\n5	1	17	23	71	98	66	70421	45481	82141	103465	2556726	121022	66430	107057	30962	13664	6434	3411	6430	78	637	709	22	18	135	163	49	43	7	79\n5	1	18	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37	38	40\n5	1	18	8	363	14481	59407	10734	206048	109532	3081294	96730	148560	77622	58206	11458	9282	12889	482	1909	2762	257	374	148	1	4	269	63	1	1	1\n5	1	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	40\n5	1	19	3	395	1015	39455	15450	19787	60115	52069	1991664	52066	67121	67933	35350	14786	21892	4098	5864	3863	260	1258	326	6	2	1	1873	162	2	1\n5	1	20	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39\n5	1	20	8	1	243	104945	47142	55273	89955	183628	63629	4365689	89193	259571	123493	19433	79128	39790	4308	4407	1946	414	398	16	10	5	532	59	1582	7\n5	1	21	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	21	1	10	53	122	11442	2482	4611	51019	24782	110028	2239865	70043	82338	20410	76162	10180	21270	15901	2254	1758	1133	21	23	45	5230	242	125	13	1	33\n5	1	22	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39\n5	1	22	7	6	8	63	23796	927	3883	14621	57667	245613	26661	2961204	132416	51442	109175	109043	21551	46530	1775	9109	7264	40	15	29	4128	200	24	2\n5	1	23	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n5	1	23	1	1	2	10	2	182	95	375	7263	9703	45961	48268	87105	2095544	23607	143950	46401	22527	55055	4925	1548	26333	12	74	34	5287	1747	7940	8	75\n5	1	24	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n5	1	24	1	2	16	201	3093	1575	2138	7785	17469	6490	66350	18991	977439	62885	55119	18204	8125	1960	2838	1103	115	76	16	6039	2687	3040	63	173\n5	1	25	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	25	3	5	4984	6858	11272	8761	9538	19259	13695	24757	42449	54815	40286	3167892	142016	82622	149757	33815	27551	91304	142	382	237	17396	1053	591	43	371	33\n5	1	26	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	26	2	4	10	6	50	4155	51057	8178	144781	33587	50785	129661	4086544	122520	269448	52019	59592	169881	2135	1509	1124	10799	4180	1231	9	1392	3180\n5	1	27	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	27	3	2	3	2	87	530	1233	766	2595	17929	9170	2983	38211	34394	1047711	72866	44526	24063	5966	6838	5328	995	9030	3159	3286	57	3129	5\n5	1	28	11	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	28	2	1	1	2	1930	770	605	4821	4201	14670	2800	37935	135858	45614	3301139	198526	310801	108047	17323	5060	8030	17720	4941	12043	208	253	24\n5	1	29	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	29	1	2	1	1	1	10	1422	744	946	399	580	15622	28570	30212	56002	1334988	141382	31578	13910	16427	22439	34187	3166	3461	199	2765	22\n5	1	30	13	14	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	30	1	1	3	17	83	1634	197	91	365	1968	8766	6552	52044	33547	1767139	59387	20544	1564	4833	11855	13944	17538	145	1752	68\n5	1	31	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	31	18	34	1	50	16	133	862	463	90	11277	8794	5085	37106	26380	32986	1821792	14746	25751	35607	41013	20398	15740	1261	2837	5392\n5	1	32	15	16	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	32	2	1	1	1	2	1	4	24	645	1515	8599	705	12045	2198	6485	596222	3455	4898	17648	7062	34503	231	2350	23\n5	1	33	14	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	33	1	1	1	5	19	13	4	60	42	1526	2162	9143	5428	16864	1946	17756	7150	1138594	26627	33261	9142	10559	1190	264	522\n5	1	34	23	24	25	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	34	1	2	38	1	3085	9012	3923	11350	5128	5009	549516	33364	18202	4606	4057	2666	1970\n5	1	35	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	35	4	33	1	1462	2284	3234	6517	1542	369	1506	3125	2171	5859	6978	2905	2471	4319	4066647	42987	29338	6640	19288	10303\n5	1	36	10	13	14	17	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	36	1	2	2	1	6	1	44	19	1231	2750	294	33	122	926	1181	1391	9554	3882	764	2443	12871	2286673	147132	13656	19035	11916\n5	1	37	13	17	21	23	24	25	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	37	1	2	4	27	116	1	40	217	1120	2633	1090	520	983	603	2843	18019	4663216	23770	7268	23836\n5	1	38	11	14	16	18	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	38	2	1	1	7	2	2	6	2	40	5	3	486	123	246	4526	15	670	6821	10275	21026	17890	389674	8461	61544\n5	1	39	9	10	13	17	21	25	26	27	28	29	30	31	33	34	35	36	37	38	39	40\n5	1	39	1	3	1	6	1	29	912	328	314	529	3	339	75	61	1737	873	9050	6154	149032	15256\n5	1	40	9	10	13	16	17	18	21	23	24	25	26	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	40	10	26	10	1	108	1	2	10	7	18	1163	6	23	11504	1	289	2750	14037	13074	22759	28708	4092	889103\n5	2	0	0\n5	2	0	667\n5	2	6	6	9	11	12	13	15	17	22	23	26	30	40\n5	2	6	162473	14492	2	2	5	3	2	2	1	2	1	1\n5	2	7	7	8	9	10	11	12	13	14	15	16	19	22	23	24	25	26\n5	2	7	230097	4316	5564	929	7	1374	80	1	85	4	1	2	2	1	1	1\n5	2	8	7	8	9	10	11	12	13	14	15	16	17	18	19\n5	2	8	481	407043	3159	1943	6132	10484	2178	29	629	50	9	5	37\n5	2	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	28	30	40\n5	2	9	76	690	1751	742224	7117	7798	9645	4692	1876	3156	807	782	1319	119	4	125	8	9	1	1	1	1	15\n5	2	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	28	29	39	40\n5	2	10	180	463	7508	429369	2787	7251	3936	6482	911	1414	605	3070	193	104	141	72	108	23	16	1	2	4	36\n5	2	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	31	35	38\n5	2	11	67	1372	3812	8898838	327986	71488	49608	35195	7297	27851	2639	3402	3502	1625	245	361	129	117	3	39	1	1	3	5	2\n5	2	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	33	35	36	37	38\n5	2	12	100	806	1564	330534	6431073	82866	310192	76094	36681	58815	14104	11884	18362	3116	882	366	98	1115	1	126	1	12	1	1	41	29	14	1\n5	2	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	35	36	37	40\n5	2	13	5	1249	2128	1379	34141	50410	7986517	67627	79286	155149	114547	27894	42358	16158	25854	4173	3669	315	873	13	95	331	15	3	7	14	38	25	13\n5	2	14	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	35	36	37	38\n5	2	14	25	3501	277552	56867	8233125	129919	177672	108801	101012	84247	136438	26144	8337	1657	8006	9388	299	969	251	489	4492	8	1	311	58	53	1\n5	2	15	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	35	36	37	40\n5	2	15	127	19	13181	31565	63267	42531	3067602	85663	100331	74939	72299	158456	50883	21227	14686	1426	8562	132	519	1064	143	88	68	300	47	3124	166\n5	2	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	35	36	37	38	40\n5	2	16	309	2513	24930	106970	195020	82332	3859751	168185	221004	187832	122841	109354	20157	12398	1982	32461	290	2177	3625	183	841	96	77	41	174	3	2\n5	2	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	35	36	37	39	40\n5	2	17	16	66	81	84	63596	37989	68153	88557	2353604	143692	82148	218016	85074	39099	25605	4080	9215	552	1334	2373	123	107	621	7	176	23	43	11	109\n5	2	18	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	34	35	36	37	38	39	40\n5	2	18	6	620	13507	54254	7360	172409	92318	2869654	137330	188013	124866	143106	29621	14077	16957	1762	3265	5134	1737	2307	991	32	6	263	32	6	6	10	1\n5	2	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37	38	39\n5	2	19	1	814	898	36802	13084	16221	55913	48687	1978091	48833	119752	82356	56293	19776	28707	5321	8246	7641	1187	9106	1940	29	5	1184	385	27	2	5\n5	2	20	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	20	14	232	93294	38937	42354	69916	148776	54809	4018794	104448	383188	197333	30694	97648	48106	6733	10443	2502	1475	1443	52	53	10	4252	883	1141	1	188	20\n5	2	21	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	21	2	35	141	244	8775	2000	4707	47771	22309	94851	2127994	62622	93492	27837	82110	14450	25279	56207	3233	4286	9888	52	32	64	3739	193	351	10	2	123\n5	2	22	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	22	9	8	5	50	21612	737	3224	11280	50469	193536	32846	2891583	142528	54345	132712	100248	46458	99965	2673	23176	15021	97	53	111	3099	331	579	2	60	10\n5	2	23	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	23	5	10	8	11	187	63	231	8260	8448	37994	52413	79143	1926539	26405	144981	64638	29042	139290	9210	3418	89393	38	134	39	4164	1197	8044	19	3	185\n5	2	24	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	24	2	1	3	10	161	2397	1279	1706	6304	15524	6611	56093	20965	936244	59429	67626	20279	8483	5573	9935	803	248	209	18	7706	2845	864	2	379	287\n5	2	25	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	25	1	2	3784	4420	8401	8445	7273	16439	23417	28187	33123	40030	39912	2926857	152987	91063	219392	53307	62681	207964	164	403	359	18740	920	222	52	1225	88\n5	2	26	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	26	8	3	8	2	3	51	3555	44421	7332	125795	27393	41722	106525	3366265	216587	281627	73563	103626	288446	2363	1846	494	10931	4803	4214	10	1768	3148\n5	2	27	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	27	1	6	13	9	43	465	1472	587	3073	31115	7717	3372	38170	32752	1109628	62085	68986	52024	5149	5663	5068	226	8492	3382	8081	15	9375	72\n5	2	28	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	28	1	4	4	1454	740	893	7267	4397	21901	3362	29176	112101	57302	2974903	196702	405380	197362	12509	3680	13653	16972	4461	25592	142	633	62\n5	2	29	13	15	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	29	1	2	1	6	1245	832	1098	443	503	14974	24930	40414	52392	1281479	206984	39802	13327	13306	36166	30016	2858	11238	156	8058	37\n5	2	30	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	30	1	2	15	141	1537	279	82	411	1516	8304	8116	62765	40841	2125771	63911	16618	928	6798	10100	9242	37882	50	3699	168\n5	2	31	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	31	18	1	43	2	49	8	204	1153	662	78	11119	5279	3257	49302	22255	31780	2124884	12244	18631	38611	26057	10242	27154	875	4402	6071\n5	2	32	15	16	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	32	1	2	1	1	2	1	1	19	584	1320	6933	636	12436	3398	5434	549866	2860	3970	18123	5721	75145	143	5043	33\n5	2	33	14	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	33	3	2	3	7	3	1	59	30	1506	2077	7525	4461	13398	1303	28861	5708	1049301	37105	27571	11030	16578	628	547	830\n5	2	34	15	24	25	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	34	1	3	33	3502	6423	2432	13864	4170	4396	580412	22290	12034	9649	3357	6434	2433\n5	2	35	17	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	35	4	29	1168	1633	3297	7004	1855	332	2205	4306	2636	7875	6974	1753	2166	3004	4207149	29505	33921	6430	24941	10372\n5	2	36	10	13	14	17	18	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	36	1	1	1	1	6	55	20	1074	2955	354	28	186	1180	1331	1528	10843	2750	749	1915	12138	2202203	172152	13724	35044	12945\n5	2	37	13	14	17	18	21	22	23	24	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	37	2	1	1	2	15	1	48	237	47	168	2252	4097	766	758	965	508	2528	17775	4913900	25455	10351	26882\n5	2	38	11	14	16	17	18	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	38	2	1	7	2	2	3	19	1	33	1	3	280	104	134	3952	6	361	6260	7912	18424	15432	344728	7746	70617\n5	2	39	9	10	13	17	25	26	27	28	29	30	31	33	34	35	36	37	38	39	40\n5	2	39	1	4	2	6	40	444	668	623	982	2	396	30	52	2151	644	11017	5600	185773	16603\n5	2	40	9	10	13	17	21	23	24	25	26	29	30	31	33	34	35	36	37	38	39	40\n5	2	40	10	23	11	94	1	8	1	9	468	4	30	12360	285	3178	13494	12250	24368	27731	5257	924011\n5	3	0	0\n5	3	0	667\n5	3	6	6	8	9	10	13	15\n5	3	6	162539	3	1	2	1	3\n5	3	7	7	8	10	11	13	15	18	19\n5	3	7	231317	6	120	6	1	1	1	1\n5	3	8	7	8	10	11	12	13	15	17	18\n5	3	8	6359	407638	130	17	93	815	78	1	1\n5	3	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	26	40\n5	3	9	15182	7838	5604	741960	4640	131	343	1563	1	2	1	55	2	3	1	4\n5	3	10	7	8	9	10	11	12	13	14	16	17	18	19	26	39	40\n5	3	10	1165	2450	10431	430002	425	861	883	23	237	1	1	1	2	1	16\n5	3	11	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	26	28	38\n5	3	11	2	8641	11030	6724	9009046	227901	24109	1133	9151	1702	82	13	9	2	2	1	1	2	1\n5	3	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	22	36\n5	3	12	2018	13336	12679	9309	454984	6422578	20903	197949	22735	16519	77	364	383	1	5	4\n5	3	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	28	29	36	40\n5	3	13	105	3145	6426	5170	95462	121165	8040441	22482	38553	70240	47083	6867	39	2	82	5	3	1	1	9	3\n5	3	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	25	26	27	29	36	38\n5	3	14	42	2598	7922	69547	413124	104201	8196989	26697	141084	26979	41705	27619	71946	145	5	11	2322	1	1	2	3	1\n5	3	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26\n5	3	15	202	1008	4369	1213	50051	104548	112736	160934	3034654	51608	46044	4931	9257	30997	6162	16406	122	20	2681	2\n5	3	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	29	31	38\n5	3	16	77	1138	1984	11127	54714	221711	239394	118714	3794511	56173	117521	5967	25720	1578	302	8	1611	5397	1	1	2	2\n5	3	17	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31	33	35	36	37	39	40\n5	3	17	1	44	1074	948	40101	72033	137554	129225	122856	208961	2301937	57775	36473	48899	3372	2024	99	919	5323	3	30	1	46	1	1	1	1	4	61\n5	3	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	36	38	40\n5	3	18	3	2083	4519	4037	20410	40498	126859	87068	287605	183849	2791567	29950	104376	34823	6049	4402	1030	4677	9	297	948	2	1	8	1	1\n5	3	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	32\n5	3	19	48	248	265	5749	16642	62004	110525	84883	227070	98767	167008	1889657	29645	14439	34710	4531	4242	10136	2485	1096	434	4	1\n5	3	20	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	33	35\n5	3	20	157	4817	25122	21831	168857	181540	157287	248262	222744	72674	3945901	63478	135639	27785	12082	16493	35235	484	561	1080	103	14	1\n5	3	21	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	38\n5	3	21	1	220	232	2612	4594	36672	35414	66876	131060	97559	139705	135450	130518	2050007	19475	34341	3436	18248	5087	1956	4798	611	1029	113	2	5	881	21	1\n5	3	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	35\n5	3	22	11	158	431	1244	6005	11504	27379	30351	55291	174875	103172	461425	83902	2800441	61068	40167	22372	89891	17404	1730	643	219	169	2	1056\n5	3	23	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	38	40\n5	3	23	11	170	484	572	6635	2506	22668	21190	36065	38646	72751	238228	120890	165197	1823045	14524	25596	18424	5476	11650	244	77	411	2	18	2230	641	13	3\n5	3	24	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	35	36	37\n5	3	24	1	23	212	136	670	10405	2018	2943	6434	20785	25266	37787	34444	70102	33869	911339	27813	29235	2353	1718	146	262	62	5	5019	2000	2\n5	3	25	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	25	1	18	220	2005	2099	14991	13926	51559	13836	27194	42574	135089	114440	171235	170053	78503	2782721	76770	24769	18191	9421	676	5063	27	106	29	1293	213	1	19	1	1\n5	3	26	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	38	39	40\n5	3	26	1	15	8	56	654	273	630	1046	3202	8221	61134	21111	140453	84464	90494	189130	3275551	24507	80546	18170	5684	3090	766	933	14	1	296	282\n5	3	27	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37	38	39\n5	3	27	3	93	174	165	1393	765	4054	2427	5660	10422	9634	37834	66485	38907	27520	118452	249229	1031021	39799	27256	4847	1768	4061	5269	881	109	22	1	244\n5	3	28	10	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n5	3	28	2	829	422	2417	6799	4661	8901	12586	18937	80786	131835	163270	14646	262554	369598	81237	2780141	39239	39211	28324	220	2177	1334	1957	3	156	3	188\n5	3	29	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n5	3	29	4	2	35	62	749	249	390	278	3122	1729	3866	5205	4843	13638	8166	73163	96185	84983	216455	1215469	31122	18934	9333	9715	4345	447	263	952	77\n5	3	30	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	30	3	2	3	6330	133	1168	182	3785	11696	2435	5966	29519	5835	12642	79785	142376	68375	532274	213247	1913691	28427	2533	644	1446	3021	451	2273	14	1	26\n5	3	31	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	31	1	6	11	13	28	169	327	1408	2570	4537	3342	17043	28688	113277	1662	245061	369977	7594	241879	47726	78030	1918588	2818	29191	8285	2107	314	91	595	367	5545\n5	3	32	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n5	3	32	1	4	8	87	103	187	231	126	595	808	4458	8773	18183	16217	21758	17607	528613	5288	2989	1025	1331	18	5\n5	3	33	10	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	33	1	1	4	2	4	13	57	17	135	65	167	303	558	2127	4144	7301	7213	18376	1776	25793	3641	1029088	2312	1633	1	533	210	22	5\n5	3	34	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	34	1	19	2	51	114	323	101	43	807	1099	516	22471	45501	8719	56107	6370	49276	533257	1622	723	335	3863	27	1612\n5	3	35	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	35	9	74	27	650	519	161	263	534	2015	7342	5716	5349	6907	10899	27035	18435	13642	27400	49570	18354	47405	30727	43596	39456	4073008	7869	2302	7895	3298	9538\n5	3	36	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	36	5	24	32	115	124	109	37	124	705	1585	360	1174	2104	3824	2163	8664	5408	10722	5642	13494	26041	11393	23699	20663	49583	2129536	5186	18316	557	10207\n5	3	37	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	37	21	28	92	3885	158	39	23	72	1678	736	1264	10773	1259	401	7639	11897	37603	13711	50817	39096	89673	30670	13153	48499	258107	4715454	25943	6661	31638\n5	3	38	11	12	14	15	16	17	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	38	3	1	3	3	5	1	11	2	10	12	32	6	90	23	26	769	391	320	4086	367	1629	5087	9497	19081	29145	330606	5914	22025\n5	3	39	9	10	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	39	1	1	2	14	45	16	425	53	203	1	667	2187	3010	11029	1518	10740	4914	7532	5346	761	8193	31638	40079	13197	6942	157420	5024\n5	3	40	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	40	19	48	5	2	12	251	9	162	1	7	42	171	34	216	306	216	6705	95	177	103	284	11119	126	1874	4213	15016	15944	28036	98687	23291	868169\n5	4	0	0\n5	4	0	667\n5	4	6	6	8	9\n5	4	6	177719	1	1\n5	4	7	7	8	10	12\n5	4	7	248880	4	122	1\n5	4	8	7	8	9	10	12	13	15	18\n5	4	8	4638	435947	1	118	78	1109	154	1\n5	4	9	6	7	8	9	10	11	12	13	14	17	40\n5	4	9	7967	5671	4842	768964	4458	147	305	1896	3	47	2\n5	4	10	7	8	9	10	11	12	13	14	16	18	40\n5	4	10	924	1788	10825	457443	589	784	1148	21	243	2	13\n5	4	11	7	8	9	10	11	12	13	14	15	16	17	18	19	20	25	38\n5	4	11	9	4729	10418	6771	9432993	251553	28933	1841	10302	1973	57	12	1	1	1	3\n5	4	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	22	36\n5	4	12	182	6414	7361	8634	379219	6792002	23356	222586	26785	21432	77	234	137	1	3	4\n5	4	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	36	40\n5	4	13	36	2359	4652	4757	54527	121187	8444799	27719	45144	79282	50938	7088	19	1	34	1	3	1	1	9	2\n5	4	14	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24	25	26	36\n5	4	14	853	6102	19165	352130	107269	8572220	31217	158005	33854	45235	29576	80537	73	2	14	3367	3	9\n5	4	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30\n5	4	15	53	1041	802	718	26524	54595	106047	156674	3311066	65030	58916	7578	11462	36667	8704	18157	129	23	4401	3	1	1	1\n5	4	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	31	32	38	40\n5	4	16	12	270	725	7331	41375	166215	226229	132113	4367003	66868	143027	8661	35468	1970	375	8	2240	7850	2	1	1	4	1\n5	4	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	28	31	36	39	40\n5	4	17	45	383	597	2324	12437	86040	76350	106082	197457	2558761	69189	41052	64278	3553	2798	230	1265	6015	75	4	22	6	9	54\n5	4	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	36	38	40\n5	4	18	4	133	817	593	3575	19616	87741	57266	257156	154329	3038677	31724	130156	36157	8250	3753	1380	6614	4	373	1423	1	21	2	2\n5	4	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	32\n5	4	19	2	11	29	841	3015	13574	55608	39148	120469	81759	107010	1959484	36367	17085	40251	5329	5435	13338	2995	997	612	1\n5	4	20	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33\n5	4	20	36	145	1253	3880	101519	64624	82035	129811	190754	77586	4368418	75977	176684	33210	13298	9886	39684	847	369	1151	58	1	19\n5	4	21	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	38	40\n5	4	21	2	3	44	126	523	2629	5556	27433	38490	30937	85320	71288	119240	2239273	16213	32354	3393	15621	6099	1828	3437	580	1199	76	1	4	1395	53	3	1\n5	4	22	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35\n5	4	22	10	28	35	1394	1713	23469	11547	16627	65839	89955	312740	94043	2959222	62141	48332	30480	100928	9609	1740	471	143	120	1	6	1583\n5	4	23	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	38	40\n5	4	23	1	14	116	154	892	737	4052	7917	7107	16527	37029	147472	108749	153121	2025274	12463	36195	22387	6869	8382	345	56	301	2	28	2242	834	8	6\n5	4	24	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37	40\n5	4	24	3	16	13	85	1380	673	3412	4090	11422	16869	22775	24146	68150	30068	981986	28397	36768	2018	1313	261	230	103	6	4	4914	2064	4	1\n5	4	25	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38	39	40\n5	4	25	1	72	381	462	10867	10266	24409	8889	17267	30196	96600	103417	137205	155450	79037	3087899	95969	25439	26151	10732	985	4964	32	159	27	696	122	36	10	18\n5	4	26	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	38	39	40\n5	4	26	1	2	15	157	137	260	201	828	6050	48965	14645	149137	59856	76543	181102	4116662	25769	98684	20621	5997	5448	910	1073	17	1	566	593\n5	4	27	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37	38	39\n5	4	27	1	2	4	112	206	667	1086	2312	4456	4016	30063	27907	24122	18574	98274	129554	999781	30004	20074	3456	3095	5620	6373	349	23	15	8	116\n5	4	28	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n5	4	28	68	50	488	609	1158	4057	3726	6067	18476	60581	54468	10647	156645	326758	94672	3216688	41367	33180	21576	261	2916	892	1541	10	171	7	105\n5	4	29	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n5	4	29	5	1	28	11	121	51	653	344	2591	3324	3362	5686	2761	42110	63510	52102	195254	1285094	25897	21189	9461	12875	6280	189	117	430	66	1\n5	4	30	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	30	1	2	32	56	137	112	555	2302	589	2886	13845	2633	3459	36429	71309	29955	321195	135784	1536216	29692	1335	1203	2544	1659	109	1309	25	4	11\n5	4	31	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	31	3	2	2	24	42	223	382	845	867	2356	14313	32787	1538	102850	189941	8130	115885	35648	62883	1637203	4083	14240	6502	2449	622	176	1066	251	4470\n5	4	32	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n5	4	32	1	2	11	26	27	93	29	247	939	3630	9708	19990	15924	22991	19376	588513	6731	3785	1792	2181	19	8	1\n5	4	33	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	38	39	40\n5	4	33	3	3	1	1	10	40	10	40	51	80	286	310	2146	3366	7688	8363	21618	2550	33661	4647	1143263	2734	1976	575	461	62	11\n5	4	34	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	34	6	4	13	73	182	77	34	649	1313	1377	13107	24105	7440	43570	7082	32816	503602	2261	1058	449	4334	40	1170\n5	4	35	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	35	5	3	85	216	87	222	304	1433	716	5436	4225	4867	6061	23889	14165	11723	23427	46710	15407	50450	27688	42854	42794	3897185	8867	2325	7955	2153	9177\n5	4	36	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	36	1	13	19	26	3	43	32	43	214	93	234	461	2131	3353	1694	6817	5014	9806	5544	15970	28446	13684	18034	20719	56849	2251047	6302	18334	770	11015\n5	4	37	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	37	2	2	1	50	284	71	3	2	563	168	60	13481	1693	325	2007	4478	11831	3940	15946	14173	32106	16642	6223	37114	201598	4375413	26665	5242	27621\n5	4	38	11	12	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	38	1	1	8	1	4	17	2	4	10	12	56	8	142	27	66	1283	530	514	4924	578	2327	6475	8983	17975	18639	401827	6822	21960\n5	4	39	9	10	11	13	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	39	1	5	1	5	2	17	3	1	13	14	15	3	119	564	2295	2894	492	3026	1529	3026	1898	398	2920	19419	17994	9209	8752	119846	3831\n5	4	40	9	10	11	12	13	15	16	17	18	19	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	40	26	42	3	1	20	4	7	148	7	2	95	269	284	127	6477	12	80	88	106	8316	152	1738	3754	14649	16722	24520	79663	23621	773227\n6	1	0	0\n6	1	0	316\n6	1	6	6	9	11	20\n6	1	6	115689	9604	1	1\n6	1	7	7	8	9	10	11	12	13	15	18	24\n6	1	7	118614	1900	4421	573	1	129	35	4	1	1\n6	1	8	7	8	9	10	11	12	13	15	16	19	24\n6	1	8	265	197021	2125	1482	2084	3598	1283	192	8	1	1\n6	1	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	25\n6	1	9	19	289	772	339470	3211	5334	4368	1701	515	337	3	356	61	5	1	8	1	1\n6	1	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23\n6	1	10	111	213	3090	224334	1996	8850	2090	1790	604	125	286	636	11	11	22	1	4\n6	1	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	28\n6	1	11	33	656	1951	4450798	114227	11533	5911	5847	1402	605	498	126	68	30	1	226	1	1	1\n6	1	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30\n6	1	12	25	308	683	151081	2749144	23939	117867	29190	7047	9014	9510	2965	5312	908	188	73	22	6	1	3	1	1\n6	1	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27\n6	1	13	410	699	612	11253	19262	3186133	19263	26996	19320	20505	4554	4012	559	789	105	188	32	2	1\n6	1	14	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n6	1	14	12	725	127977	18710	3545878	63762	38384	50105	30252	16387	28042	9594	738	497	69	38	30	12	1	2	1\n6	1	15	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	30	32\n6	1	15	109	1	4272	6449	16652	37365	1501874	12647	41517	29602	24532	20024	22458	13528	729	396	32	24	1	1	1	1\n6	1	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	37\n6	1	16	58	773	8568	31090	52035	15547	923108	29922	34236	25059	7554	11358	12015	1021	2369	2247	584	559	2	1	15\n6	1	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	35	37\n6	1	17	9	29	52	174	20119	46585	31499	17456	1141424	28090	32051	11579	50044	27364	2340	671	1324	1412	537	1	3	4	12	5\n6	1	18	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	32	33\n6	1	18	1	3	333	4305	17409	4641	26155	19127	640615	46036	13425	25646	14681	3633	9447	3115	1893	814	2	124	9	3\n6	1	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n6	1	19	1	149	304	17792	24371	8732	26340	23151	1484941	40726	59078	30172	22123	8057	23226	2651	1838	112	194	2	16	45	11\n6	1	20	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35	37\n6	1	20	2	50	28048	15466	4784	1785	9780	22464	882986	31936	22838	6890	3925	38728	8878	1338	115	527	1	3	552	1	2	36\n6	1	21	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\n6	1	21	5	19	52	9070	1125	49588	11675	28440	18295	1368532	83710	35194	39900	25506	19558	6040	207	546	51	3	184	14	1	5	41\n6	1	22	11	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n6	1	22	3	1	8787	143	3575	5352	18639	18874	47887	1062446	36418	45639	79758	33595	9915	783	3449	1650	56	204	5	6	1\n6	1	23	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n6	1	23	1	1	2	6	2	13	3	234	653	803	5536	24555	15943	365022	29947	20925	41106	14582	955	4138	2700	11	579	6	56	2\n6	1	24	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	1	24	1	1	2	5	5	60	145	1442	4784	4440	17739	10512	424347	6296	45152	26585	1373	3069	654	56	1073	5	80	30	1	15	3\n6	1	25	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	38	40\n6	1	25	1	3	1	1	7	1	40	1109	3056	2132	6049	11676	5237	505198	21865	18086	1769	26978	17069	4712	5600	20	489	205	106	5	8\n6	1	26	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	38\n6	1	26	2	8	1	63	11743	1254	15637	6574	9624	3286	578989	15083	17492	14844	5268	7728	8408	129	1419	26	10	15\n6	1	27	12	13	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	1	27	1	1	2	1	10	42	162	2366	2683	3764	8233	12130	329720	4603	15312	7833	8697	10854	1309	3282	60	14	9	73\n6	1	28	11	12	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	1	28	1	1	1	1	2	234	162	67	617	69	1849	2321	13768	6542	221563	5567	5858	6189	4937	1348	761	82	64	339	33\n6	1	29	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	1	29	1	1	2	450	234	570	403	2020	3285	5917	6911	2861	202881	7657	6927	20887	1953	4632	2434	177	827	1600\n6	1	30	14	16	17	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	1	30	2	2	1	16	22	30	199	152	5636	5909	7103	4809	240791	23645	6305	9085	3965	1713	1184	1256	82	1\n6	1	31	19	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	1	31	2	1	20	88	109	798	3111	2145	7076	8282	594963	12129	31614	2772	41739	15692	5562	29779	6845\n6	1	32	18	19	20	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	1	32	1	1	1	7	60	134	830	2056	4438	5749	1828	7780	234128	12660	3705	16488	1420	495	6955	4482\n6	1	33	19	21	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	1	33	3	1	3	3	63	770	912	1238	3286	3663	4119	180500	3513	12697	1584	3010	5508	6516\n6	1	34	22	24	25	26	27	28	29	31	32	33	34	35	36	37	38\n6	1	34	1	3	7	456	769	34	1191	560	2968	913	33833	942	488	78	1322\n6	1	35	17	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	1	35	2	30	33	1	300	1028	247	458	1290	3485	1227	248791	17279	9265	46921	28760\n6	1	36	26	28	29	30	31	32	34	35	36	37	38	40\n6	1	36	2	220	163	131	263	137	932	285	52368	2074	15226	9941\n6	1	37	17	25	26	27	28	29	31	32	33	34	35	36	37	38	39	40\n6	1	37	1	6	6	8	7	195	47	70	251	20	155	238	26790	2427	1	3141\n6	1	38	26	29	31	32	33	34	35	36	37	38	39	40\n6	1	38	1	4	842	1682	710	91	1102	2272	1496	193282	1	27657\n6	1	39	36	39\n6	1	39	1	8\n6	1	40	25	31	32	33	35	36	37	38	40\n6	1	40	2	591	2	939	48	11	231	6362	204149\n6	2	0	0\n6	2	0	316\n6	2	6	6	9	11	12	13	17	19	20	21\n6	2	6	106293	9407	1	1	2	1	1	1	1\n6	2	7	7	8	9	10	11	12	13	14	15	20	21\n6	2	7	113518	1795	2731	594	2	531	53	2	51	1	1\n6	2	8	7	8	9	10	11	12	13	14	15	16	17	18	19	21\n6	2	8	234	189179	1651	1188	2566	4383	929	11	298	34	1	5	11	2\n6	2	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	28	29\n6	2	9	45	315	828	343949	2598	3303	4384	1848	718	1274	66	376	567	55	3	62	3	6	1	1\n6	2	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	28	29	30\n6	2	10	84	210	2826	217017	1358	5899	1413	1159	715	261	276	1440	97	40	55	5	48	7	5	1	2	1\n6	2	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26\n6	2	11	30	543	1807	4416421	139924	17628	20303	9760	1632	12488	1957	888	4061	664	84	172	3	16\n6	2	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	30\n6	2	12	31	263	570	137076	2619638	22460	126728	34772	6856	30762	15248	12606	32134	2464	1033	130	171	207	27	56	5	2\n6	2	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30\n6	2	13	324	594	519	9275	17355	3131702	20290	49473	18347	34556	9910	11724	5965	6390	454	693	221	141	5	22	8	6\n6	2	14	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	33	37\n6	2	14	17	772	109231	17051	3410107	61466	38633	75354	36830	25828	64937	42966	2264	1313	513	1484	151	1244	3	337	2	2	13\n6	2	15	8	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	32	37\n6	2	15	66	3606	5730	14991	30127	1396390	10321	49015	39172	32689	60406	62468	27145	3527	1579	330	90	89	3	115	4	315	29\n6	2	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	33	34	37\n6	2	16	45	654	6431	27006	43722	11874	765982	30142	26656	54366	16760	21059	31145	1322	15736	4331	892	2294	2	12	2	2	1	23\n6	2	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	35	37\n6	2	17	14	35	30	153	18113	36409	25935	14918	1016834	31232	41347	38687	81076	74758	5181	1499	3556	2731	1892	7	18	17	7	1	7	4\n6	2	18	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37\n6	2	18	1	467	3779	15442	3375	19103	16534	582294	58518	19795	43543	20833	6816	29401	4248	2186	1843	12	637	5	3	2	15	2	1\n6	2	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n6	2	19	1	285	256	15658	18980	7175	23316	21207	1278714	32452	85840	41293	72805	24483	76465	4192	4429	198	1097	1	16	358	117\n6	2	20	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n6	2	20	4	41	25719	13811	3883	1433	8228	16100	829611	30164	21781	8352	5048	92589	9278	4994	206	1033	2	19	811	7	117\n6	2	21	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\n6	2	21	1	26	51	107	6970	655	35771	10624	23475	18014	1156933	157283	48359	86060	52751	43826	17764	331	1429	51	20	545	7	9	4	86\n6	2	22	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n6	2	22	1	4	2	8101	100	2947	3950	15397	15790	40762	954316	30343	56170	126769	39994	19467	1173	6511	4433	194	299	7	10	12\n6	2	23	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	40\n6	2	23	2	1	2	4	4	54	4	218	1056	799	5042	19480	13182	314069	29065	19421	58420	31388	1498	5463	6406	65	585	18	63	3\n6	2	24	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	2	24	2	7	1	2	4	57	156	1272	4956	3018	18660	9316	440639	7599	56466	35749	1923	4694	1110	67	1802	14	122	18	2	12	2\n6	2	25	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	25	3	3	10	2	64	948	2976	1704	4867	12828	4021	564758	16043	28805	2661	41785	30554	5850	5398	15	439	110	7	89	12	19\n6	2	26	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	2	26	3	1	5	39	10	75	10589	1242	14755	6543	11753	5123	642802	21405	18384	29506	4571	13441	12950	93	1983	49	6	32	19\n6	2	27	11	13	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	27	1	2	1	1	3	17	78	236	1773	2216	3650	7225	13304	355572	4403	17127	7451	14918	16048	1193	5871	21	12	34	33	1\n6	2	28	11	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	28	1	1	1	1	2	1	181	152	55	503	55	1551	2002	13225	6054	214347	4358	4799	8760	7154	904	1578	49	133	1073	56	4\n6	2	29	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	29	1	2	1	10	450	187	434	302	1705	2635	5827	7431	3237	221484	4461	7590	30531	1771	6582	1404	236	992	1809	7\n6	2	30	16	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	30	1	1	22	14	20	191	109	4538	5438	5473	4241	225850	27648	12238	5903	7150	582	1368	2363	164	1\n6	2	31	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	31	3	1	8	1	58	109	606	2539	2374	7223	6410	548374	10564	20657	3848	15714	10246	6080	26115	6280\n6	2	32	15	17	18	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	32	1	1	1	1	1	10	32	133	1201	2110	4248	4566	1874	6885	258100	8030	4042	12310	980	644	8305	2688\n6	2	33	19	21	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	33	1	1	1	7	86	590	797	1004	2664	4049	5538	187193	6256	14149	3027	4103	8589	6894\n6	2	34	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	2	34	1	5	17	584	1082	73	1898	1	1065	3437	1557	47156	1331	767	164	1647\n6	2	35	21	25	26	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	35	1	18	17	245	855	91	499	1445	3750	1736	209172	16652	10082	53792	28462\n6	2	36	26	28	29	30	31	32	34	35	36	37	38	40\n6	2	36	4	357	174	52	413	290	1204	202	53740	4263	22646	9448\n6	2	37	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n6	2	37	12	4	10	16	305	3	110	151	341	53	195	394	41869	4170	1	4039\n6	2	38	26	27	29	31	32	33	34	35	36	37	38	40\n6	2	38	1	1	8	1500	2674	1286	129	1672	2897	2390	268702	28333\n6	2	39	37	39\n6	2	39	3	7\n6	2	40	25	31	33	35	36	37	38	40\n6	2	40	2	829	1390	70	11	307	9247	279644\n6	3	0	0\n6	3	0	316\n6	3	6	6	11	12	13	15	16\n6	3	6	106332	1	1	1	2	1\n6	3	7	7	8	9	10	11	12	13	16	18	19\n6	3	7	114067	10	1	51	12	1	4	2	1	2\n6	3	8	7	8	9	10	11	12	13	15	16	19\n6	3	8	241	191919	5	29	13	30	183	54	1	2\n6	3	9	6	7	8	9	10	11	12	13	15	16	17	18	19	23\n6	3	9	73	273	796	358823	1412	82	95	372	16	12	26	8	10	1\n6	3	10	7	8	9	10	11	12	13	14	16	18	21	23	27\n6	3	10	105	195	2636	220628	183	226	316	4	57	1	2	2	2\n6	3	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n6	3	11	33	651	1827	4478961	84612	6107	20	2329	466	26	20	20	1	1	1\n6	3	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n6	3	12	39	234	631	129224	2698567	6272	70263	4138	4132	88	418	432	1	1	2\n6	3	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	27\n6	3	13	3	319	545	557	9146	16560	3186267	5049	7756	16413	12748	1843	24	5	102	2	5	1	1\n6	3	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	32\n6	3	14	2	2	13	746	104517	17438	3506567	22296	29267	24499	11231	11261	18489	162	4	7	3	3	2	1\n6	3	15	8	11	12	13	14	15	16	17	18	19	20	21	22	23	24\n6	3	15	64	3624	5544	14480	31275	1531717	4474	16545	2260	12880	9814	4649	5883	97	3\n6	3	16	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	31	37\n6	3	16	1	64	680	6311	25789	41603	10202	778200	7287	12096	3066	2294	251	41	9	5	72	12	1	1	9\n6	3	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	32	35	37\n6	3	17	16	36	5	49	151	17175	34769	24619	14204	1183807	9950	17736	1102	24571	1645	129	54	1	94	2	1	2	8\n6	3	18	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	31	33\n6	3	18	2	35	560	3477	14940	3687	18318	16918	701275	13189	5803	7679	2491	1983	123	122	4	3	1	1\n6	3	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31	32	33\n6	3	19	33	597	259	15781	19586	7102	26939	20563	1444408	11364	15941	10320	518	806	770	8	2	121	3	1	1\n6	3	20	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	32\n6	3	20	13	57	24197	12768	3854	1706	7858	20300	1043413	13431	13742	3718	6353	3124	7929	21	86	330	2\n6	3	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n6	3	21	3	1	20	63	139	255	6994	699	35411	11024	25044	20538	1440936	36368	16615	2884	1191	1765	207	33	180	27\n6	3	22	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31\n6	3	22	13	1	9	10	7874	116	3087	3804	15245	19759	52098	1241751	10363	17155	2843	10884	1052	207	310	7	5\n6	3	23	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31\n6	3	23	7	50	5	14	24	135	3	240	2915	864	4862	26517	15448	442837	8077	14078	6377	1692	30	228	24	1\n6	3	24	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n6	3	24	23	3	13	4	7	9	64	198	1234	8879	3911	25972	11887	641824	2776	11583	2939	1011	1091	107	13	12	1	1\n6	3	25	11	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37	40\n6	3	25	32	15	5	11	5	109	1004	4318	2011	4604	23498	3815	918371	4688	5809	1340	2143	40	72	39	9	37	63	8\n6	3	26	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\n6	3	26	7	1	13	9	6	8	63	27	76	10256	2746	16258	8701	17102	6930	822923	11612	10385	4072	3425	63	1421	78	322	7	5\n6	3	27	11	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n6	3	27	7	16	8	1	6	1	54	92	371	1849	2375	4935	8671	16856	494460	4617	8337	4547	1294	2242	529	986	14\n6	3	28	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36\n6	3	28	1	2	1	3	1	217	158	64	485	79	1497	1888	13583	6348	224864	3366	3931	1804	3231	455	2	1\n6	3	29	12	13	14	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n6	3	29	1	8	4	3	5	498	192	460	265	1776	2712	6037	11796	4599	310740	2173	6913	3398	967	2022	747	117	455\n6	3	30	13	14	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n6	3	30	1	10	1	2	1	4	15	11	32	162	120	4905	6892	5257	3400	270961	4596	1957	2398	1	54	38	1\n6	3	31	13	14	17	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38	39	40\n6	3	31	1	1	1	5	1	11	3	48	102	635	2490	3221	9632	6004	605006	7411	3925	2100	99	32	1100	1	497\n6	3	32	16	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	3	32	4	2	1	24	27	168	2301	2996	4380	5148	2681	6742	334857	4842	3046	858	263	204	2691\n6	3	33	14	19	24	25	26	27	28	29	30	31	32	33	34	35	37	38	40\n6	3	33	1	5	2	8	85	661	834	991	2858	4341	5764	207449	3907	3726	443	1534	1547\n6	3	34	16	22	24	25	26	27	28	29	31	32	33	34	35	36	37	38\n6	3	34	1	1	8	38	854	1663	141	3170	1672	3845	2623	71343	1393	1383	63	34\n6	3	35	17	25	26	28	29	30	31	32	33	34	35	36	37	38	40\n6	3	35	1	23	18	214	969	108	312	1194	5092	2124	243909	216	25	2771	85\n6	3	36	25	26	28	29	30	31	32	34	35	36	37	38	40\n6	3	36	1	4	580	178	85	429	353	2064	330	83211	367	2873	3\n6	3	37	25	26	27	28	29	31	32	33	34	35	36	37	38	40\n6	3	37	15	11	18	20	586	202	241	485	118	296	721	68979	2972	238\n6	3	38	27	28	29	31	32	33	34	35	36	37	38	40\n6	3	38	1	1	14	2116	4064	2182	204	2234	4662	3783	376988	9059\n6	3	39	22	23	30	35	37	39\n6	3	39	1	1	1	1	3	1\n6	3	40	25	31	33	35	36	37	38	40\n6	3	40	4	1102	2065	102	22	388	12903	349237\n6	4	0	0\n6	4	0	316\n6	4	6	6	8	9\n6	4	6	106399	2	4\n6	4	7	7	8	9	10	14\n6	4	7	114648	3	2	35	1\n6	4	8	7	8	9	10	12	13	15	18\n6	4	8	3180	189891	3	21	21	246	30	1\n6	4	9	6	7	8	9	10	11	12	13	14	17	18\n6	4	9	10881	4310	3043	342821	1279	41	100	433	2	28	1\n6	4	10	7	8	9	10	11	12	13	14	16\n6	4	10	786	1573	4482	217641	161	190	344	8	40\n6	4	11	7	8	9	10	11	12	13	14	15	16	17	18\n6	4	11	11	4052	5111	3235	4512061	89225	6387	29	2399	418	23	3\n6	4	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n6	4	12	985	5792	6617	8029	200787	2606887	6651	73473	4208	3958	87	215	155	1	1\n6	4	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	24	27\n6	4	13	74	1431	2828	2157	24874	35622	3166809	5250	7856	16703	12937	1836	14	2	32	1	1\n6	4	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	24	25\n6	4	14	14	1185	1797	29373	173219	35378	3387719	19612	30011	25315	11372	10889	18857	52	6	2\n6	4	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24\n6	4	15	127	484	1925	1168	13620	44668	73690	77585	1382719	5950	17439	2118	12026	10422	4497	5725	22	1\n6	4	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	28	37\n6	4	16	57	169	417	2531	10221	28666	53516	16875	739604	7394	12279	2991	2267	226	36	5	94	5	1	3\n6	4	17	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	35	37\n6	4	17	1	17	645	512	17892	38315	43632	92949	58742	38646	986212	9627	15192	1004	24112	1771	129	29	38	2	1	3	4\n6	4	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27\n6	4	18	3	1002	2467	2921	19154	14910	47087	46037	35605	39455	547780	12849	5787	7378	2438	553	90	84	1	2\n6	4	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	28\n6	4	19	37	104	154	1749	16399	18867	34567	47022	69950	54360	71084	1217368	8166	15382	9872	475	794	622	1	111\n6	4	20	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n6	4	20	1	14	111	5321	41438	8143	77446	66442	19744	38034	23851	47344	793105	11859	10716	3660	3655	2301	7997	19	81	371\n6	4	21	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	33\n6	4	21	1	108	142	1064	4197	10209	55384	77500	27687	95586	49453	100584	36861	1095171	26373	11601	1915	991	540	75	30	169	10	1\n6	4	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31\n6	4	22	8	17	121	1354	853	3452	34152	38964	90198	26664	51998	28729	175622	891861	8633	10820	2980	9496	948	205	255	12	5\n6	4	23	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n6	4	23	6	83	260	282	1378	2076	6943	2180	7439	9455	84532	10272	57286	39685	282935	5932	6697	3895	1530	25	249	12\n6	4	24	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\n6	4	24	1	19	3	260	344	893	2614	21156	2143	33811	25301	6662	106135	69861	34407	389202	2813	6907	1869	1087	982	162	9	19\n6	4	25	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37\n6	4	25	18	284	222	2138	714	5852	5947	6593	106405	110630	55327	157014	24755	9558	467202	2965	4764	1453	1923	26	56	33	8	73	71\n6	4	26	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\n6	4	26	2	34	48	22	371	225	1582	3778	3831	6044	12043	57310	61108	70655	72269	21645	574943	8384	9919	3635	2947	66	521	62	107	5	2\n6	4	27	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n6	4	27	9	60	39	1570	106	2905	2591	2963	6933	6774	23023	27947	37973	40913	32410	26222	323005	4313	4398	3288	1247	1135	397	443	4\n6	4	28	9	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n6	4	28	1	1	6	14	1	10	74	366	427	657	2882	2302	2706	3516	25994	5822	206870	1876	4129	1034	2935	316	2\n6	4	29	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n6	4	29	22	12	550	209	41	59	938	1582	1551	2049	11379	9951	6931	54568	33836	20670	6595	190999	3292	4186	3119	711	891	517	56	171\n6	4	30	10	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	40\n6	4	30	7	3	2	13	1	46	11	2	13	76	6943	8782	1654	37871	6455	10025	6696	6138	204558	4719	1130	1801	25	7	1\n6	4	31	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38	40\n6	4	31	1	1	4	9	6	25	73	82	546	271	323	10855	18993	20516	13545	10706	38757	508774	7677	3738	969	53	15	502	247\n6	4	32	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	4	32	388	1	14	497	1240	922	639	1246	3225	9561	18776	23308	10095	40319	14394	10382	226355	4195	2143	973	150	90	1121\n6	4	33	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	38	40\n6	4	33	2	4	2	33	4	16	23	26	50	44	41	234	1858	1924	2625	9494	34419	10554	165974	1820	2317	184	675	779\n6	4	34	15	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	4	34	1	2	3	2	16	63	219	329	1027	3662	9176	2580	9313	9968	4005	4614	5080	36871	778	487	25	16\n6	4	35	17	18	20	21	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	4	35	6	1	3	6	35	267	118	90	341	2778	1440	35140	21903	19175	1680	169087	76	10	1580	61\n6	4	36	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	4	36	1	1	11	2	9	32	130	80	1036	468	2813	20964	1571	4266	823	21903	35350	124	1080	2\n6	4	37	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	4	37	25	61	31	9	4	130	138	119	27	2	26	129	87	61	1462	1472	3354	10659	802	5665	228	14546	4465	29807	1352	150\n6	4	38	20	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	4	38	2	2	9	22	100	103	255	3791	594	56326	13749	12498	2346	86200	27747	4346	191610	4166\n6	4	39	31	39\n6	4	39	1	1\n6	4	40	23	24	25	26	28	29	30	31	32	33	35	36	37	38	40\n6	4	40	1	1	32	4	15	38	157	16427	6611	10765	57732	15923	4716	42787	205465\n6	5	0	0\n6	5	0	316\n6	5	6	6	9	11\n6	5	6	117278	1	1\n6	5	7	7	10	15\n6	5	7	124065	57	1\n6	5	8	7	8	10	11	12	13	15	18	21\n6	5	8	2085	203959	15	1	19	245	73	2	1\n6	5	9	6	7	8	9	10	11	12	13	17	18	20\n6	5	9	5562	3367	2498	353258	1650	67	102	507	23	1	1\n6	5	10	7	8	9	10	11	12	13	14	16	17	18	24\n6	5	10	520	1053	4707	232009	357	216	411	11	31	1	3	1\n6	5	11	7	8	9	10	11	12	13	14	15	16	17	18	21	24	25\n6	5	11	1	2073	4755	3230	4692325	99235	7869	13	2772	503	33	1	1	1	1\n6	5	12	7	8	9	10	11	12	13	14	15	16	17	18	19	21	23	27\n6	5	12	72	2580	3721	6187	164238	2799685	8565	85955	4736	5661	163	349	51	1	1	1\n6	5	13	7	8	9	10	11	12	13	14	15	16	17	18	19	21	23\n6	5	13	20	994	1905	1909	15692	38094	3307141	6571	9384	19803	13788	1923	6	7	2\n6	5	14	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25\n6	5	14	360	1624	8597	157672	33852	3575380	25514	34937	32670	12833	12643	19987	21	1	1	5	5\n6	5	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24\n6	5	15	22	461	333	545	7212	31881	44103	79457	1539331	7692	20880	3333	15947	10842	6556	6279	3	6\n6	5	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	30	37\n6	5	16	14	8	114	1728	10409	29856	51103	20520	914022	8956	17384	3548	2929	269	52	3	2	107	4	1	1	7\n6	5	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	29	35	37\n6	5	17	14	217	340	1152	9897	25737	64149	49909	33799	1136909	11399	17439	1257	34257	2385	197	26	11	1	2	8	3\n6	5	18	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27\n6	5	18	67	368	324	7245	5856	32146	32972	42308	32728	627895	13099	6696	8055	3623	387	97	153	1\n6	5	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	28	31\n6	5	19	1	3	11	218	2537	4436	21361	34929	30523	40661	47278	1476437	11934	18683	12031	445	865	726	154	1\n6	5	20	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n6	5	20	5	9	88	5999	810	32043	21021	8039	11218	14403	61869	855861	12161	12830	3990	3336	2527	8369	15	99	355	1\n6	5	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33\n6	5	21	6	28	45	686	958	10409	26469	13498	61157	24184	65942	35961	1345146	31811	15751	3199	1136	627	53	32	246	18	1	1\n6	5	22	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33\n6	5	22	1	214	314	812	14694	10814	27787	15776	38226	29506	84174	1067127	10504	10607	3816	10427	1388	306	406	7	16	1\n6	5	23	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n6	5	23	1	62	53	160	365	1212	702	1798	3558	21989	7303	41589	43411	356367	6762	6746	4109	2020	31	366	27\n6	5	24	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	35\n6	5	24	29	104	154	693	2941	772	8456	7861	4751	38585	53097	30921	387119	4042	5862	2321	1252	1296	167	25	28	1\n6	5	25	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37	40\n6	5	25	36	4	64	63	2038	1687	2467	25503	35278	20094	79543	25773	7619	443331	1822	5681	1560	2841	66	84	46	17	101	42	2\n6	5	26	11	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\n6	5	26	1	38	38	385	1328	1153	2529	10330	19966	41675	40317	43799	23939	530924	7071	9706	3588	3866	82	396	115	133	17	2\n6	5	27	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n6	5	27	11	1	867	882	741	2165	1851	5827	10732	14594	25900	20441	17078	314710	4448	4329	3654	1898	1303	629	246	2\n6	5	28	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33\n6	5	28	2	1	6	3	261	216	244	2232	860	1885	2387	22015	6333	220564	1633	5278	1019	3239	462\n6	5	29	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n6	5	29	1	10	11	2	44	381	513	705	453	4660	4674	3922	23655	15344	16567	7981	189450	3303	4444	3850	1297	493	601	58	86\n6	5	30	10	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36\n6	5	30	3	17	46	11	1	1	54	2484	3207	917	16358	7686	10063	7884	10770	229435	6927	1142	2333	55	13\n6	5	31	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38	40\n6	5	31	1	18	1	6	212	62	270	4329	7846	10195	6999	9025	24490	629795	9740	4301	541	79	20	320	169\n6	5	32	15	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	5	32	1	85	898	128	115	404	1115	4981	7133	10400	6406	18819	5198	12798	228399	2881	1746	569	52	27	573\n6	5	33	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	38	40\n6	5	33	8	1	45	3	28	24	22	59	34	27	220	1682	2087	2744	9802	32785	12389	169062	1019	1830	98	248	435\n6	5	34	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	5	34	4	16	114	148	547	1917	3607	911	5060	3875	2089	3209	1593	24406	474	324	14	13\n6	5	35	17	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	5	35	20	1	15	9	7	1	52	308	94	34	570	3255	2094	61539	21829	12121	1015	250199	104	30	873	42\n6	5	36	22	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	5	36	5	1	2	59	24	448	231	1385	13878	1879	1250	482	15574	48067	90	897	4\n6	5	37	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	5	37	16	10	1	50	118	35	4	2	18	71	28	29	610	806	1369	6816	821	2380	47	6903	1243	17479	589	114\n6	5	38	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	5	38	5	14	53	48	70	1762	166	32747	7750	5036	939	41336	10668	1917	135940	2272\n6	5	39	39\n6	5	39	1\n6	5	40	23	25	26	27	28	29	30	31	32	33	35	36	37	38	40\n6	5	40	1	18	4	1	5	34	48	9691	5052	5303	27359	7080	2415	22791	131069\n7	1	0	0\n7	1	0	185\n7	1	6	6	9	21\n7	1	6	71276	6709	1\n7	1	7	7	8	9	10	12	13	15	22\n7	1	7	53980	921	2065	322	42	13	1	1\n7	1	8	7	8	9	10	11	12	13	15	16	18\n7	1	8	147	93673	1432	992	870	1447	648	92	3	1\n7	1	9	6	7	8	9	10	11	12	13	14	15	16	17	19	22	23	24	27\n7	1	9	11	130	336	151333	1331	2451	1858	770	219	145	2	168	1	1	1	1	1\n7	1	10	7	8	9	10	11	12	13	14	15	16	17	18	19	21	23\n7	1	10	45	117	1261	111596	1084	4897	1018	1007	282	49	105	88	7	8	3\n7	1	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24	27\n7	1	11	12	284	854	1776565	33153	3954	1849	2100	481	175	120	9	21	9	117	1	1\n7	1	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26\n7	1	12	7	100	273	47204	932927	13819	36339	13042	1552	5088	265	1153	2649	471	6	42	1	1\n7	1	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25\n7	1	13	156	272	247	3602	11999	1296070	15098	18895	4119	8663	1560	107	321	1943	12	95	1	1\n7	1	14	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29\n7	1	14	9	321	34589	9900	1300004	22146	19904	11954	4957	2589	8855	5238	20	305	41	13	15	2	1\n7	1	15	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29\n7	1	15	56	1	1221	2709	12502	5243	716239	6306	23221	14482	2318	5480	16529	1468	4415	192	50	38	1	2\n7	1	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	37\n7	1	16	15	225	1631	8611	34224	11840	687963	40045	22224	1639	10699	37703	365	2277	1786	138	324	513	4	73	1	11\n7	1	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	37\n7	1	17	4	14	17	37	6016	1700	10903	11888	425220	32098	2080	7013	30861	26	16232	436	32	78	52	2	2	20\n7	1	18	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	32\n7	1	18	1	1	80	1263	5255	1517	8417	4811	341910	4243	12140	22031	824	26763	6492	1199	1089	2524	73	23\n7	1	19	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32\n7	1	19	3	53	3086	756	642	2870	6676	146724	12795	3799	711	2501	2517	3194	333	4080	1	55	7	7\n7	1	20	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	31	32	37\n7	1	20	1	17	9491	5343	217	290	1812	2060	246898	5329	4310	5210	5976	7792	1700	9274	242	2	389	4\n7	1	21	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32	37\n7	1	21	9	52	6924	6008	839	3514	1689	2361	495667	2154	19166	18977	11979	8604	6752	807	8181	9	287	16\n7	1	22	11	12	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32\n7	1	22	2	1	2770	892	4	1471	574	1730	5609	130362	831	5447	5168	2406	4782	447	2864	576	270\n7	1	23	11	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	1	23	1	3	2	11	9	75	14	1075	5471	364	141883	1521	2019	670	622	2812	2482	460	1105	8	10\n7	1	24	12	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	1	24	1	3	1	38	108	67	2752	5291	3650	1880	131424	9072	4918	2782	3648	12475	215	1003	148	58	28\n7	1	25	13	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	1	25	1	1	7	155	1936	1216	2098	1718	1816	108816	1869	6778	4839	15125	232	1221	922	32	238\n7	1	26	13	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	1	26	1	2	10	2	1	28	124	3005	145	1310	811	54287	300	2214	7124	767	661	322	1335	458\n7	1	27	13	14	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	1	27	1	5	5	18	43	138	73	745	478	556	51326	214	790	44	1935	131	1	333\n7	1	28	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\n7	1	28	7	34	389	537	4844	5592	3607	781	198457	11489	5547	2564	5330	353	526	1	3693\n7	1	29	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37	40\n7	1	29	26	46	50	227	453	552	1174	6113	134630	2626	4660	10938	2495	3135	6803	63\n7	1	30	22	24	25	26	27	28	29	30	31	32	33	34	37	40\n7	1	30	10	50	18	19	138	1735	466	41325	2409	4361	2329	462	5566	4010\n7	1	31	13	17	21	24	25	26	27	28	29	30	31	32	33	34	35	37	40\n7	1	31	1	1	1	4	18	4	260	332	1806	818	36411	1128	2823	2626	2	5444	2025\n7	1	32	25	26	27	28	29	30	31	32	33	34	37	40\n7	1	32	5	24	18	128	394	86	429	30774	169	236	970	740\n7	1	33	14	28	29	30	31	32	33	34	37	40\n7	1	33	1	23	671	229	13	466	16452	2507	4881	3053\n7	1	34	29	30	31	32	34	37\n7	1	34	106	131	86	628	16502	48\n7	1	35	21	26	35\n7	1	35	1	1	8\n7	1	36	36	37\n7	1	36	1	1\n7	1	37	25	26	27	28	29	30	31	32	33	34	35	37	39	40\n7	1	37	8	5	48	2	34	41	63	397	132	349	1	43759	1	85\n7	1	39	32	39\n7	1	39	1	1\n7	1	40	32	37	40\n7	1	40	34	338	14053\n7	2	0	0\n7	2	0	185\n7	2	6	6	9	11	13\n7	2	6	65805	5480	1	1\n7	2	7	7	8	9	10	11	12	13	15\n7	2	7	51674	858	1165	323	2	227	38	15\n7	2	8	7	8	9	10	11	12	13	14	15	16	17	18\n7	2	8	116	90047	897	720	1067	1858	395	6	139	31	5	1\n7	2	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22	23	24	25	30\n7	2	9	16	138	364	156573	960	1490	1874	724	609	496	24	152	16	26	3	1	1	1	1	1\n7	2	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	25\n7	2	10	28	118	1047	108468	594	3062	687	696	452	108	140	150	32	13	19	20	7\n7	2	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28\n7	2	11	8	253	789	1764042	44809	6802	6377	3725	598	4179	114	143	1366	217	38	91	1	2	10	1\n7	2	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27\n7	2	12	9	114	296	40983	878065	13833	38400	14530	1644	14083	886	4645	15564	2003	188	55	24	24	11	17\n7	2	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	30\n7	2	13	1	110	157	196	2830	10029	1258043	13886	28463	4140	18498	5112	851	2952	8803	108	424	39	16	1	10	1\n7	2	14	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n7	2	14	3	294	28716	8090	1261941	18690	23120	22689	5677	3856	22498	16330	82	726	175	13	58	472	1	147\n7	2	15	8	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	32\n7	2	15	24	1032	2300	10162	5266	666438	5419	30669	19109	3719	18147	34994	1765	12867	527	172	79	34	116	167\n7	2	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	37\n7	2	16	8	170	1277	6962	26283	9396	524455	36582	18542	1049	27989	78959	380	4721	8628	281	423	1824	2	504	12\n7	2	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	35	37\n7	2	17	5	4	14	37	5036	1394	7933	8869	358066	22507	1972	18731	56681	85	40570	1082	30	283	172	2	3	2	4	2	27\n7	2	18	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	32\n7	2	18	1	116	1055	4445	1429	6601	3955	274677	3322	11808	26173	981	68214	20153	1050	1040	5915	3	264	173\n7	2	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	31	32\n7	2	19	1	36	32	2574	710	488	2107	4955	122527	7884	6152	827	4739	3275	2044	410	6426	236	4	3\n7	2	20	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	2	20	2	15	7853	4491	248	258	1623	1649	244111	7951	2992	9723	8664	6179	1824	18226	2	428	1	10	525	3\n7	2	21	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32	33	37\n7	2	21	25	69	5726	4772	1220	3081	1894	3802	482735	2035	37448	21562	14352	25138	18735	1967	12678	27	134	1	4\n7	2	22	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	2	22	1	2293	715	13	1109	482	1494	4581	112561	2005	4317	4889	3335	5064	1241	4510	2	723	624	1\n7	2	23	10	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	2	23	1	4	1	43	1	21	232	16	904	5927	306	205207	1399	1548	1752	1354	1570	3046	474	430	2	6\n7	2	24	12	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	2	24	1	34	134	52	2561	4299	2862	2352	129388	7749	7267	3473	3041	19044	157	1242	111	11	31\n7	2	25	11	13	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	2	25	1	1	1	9	186	1971	901	1671	1405	1893	98577	3315	13220	4452	26001	627	470	1953	11	191\n7	2	26	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	2	26	1	15	46	11	9	84	126	2425	484	1252	772	65364	879	2367	4780	928	128	588	538	303\n7	2	27	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	2	27	2	1	1	2	1	29	68	102	173	1186	623	1307	83894	487	907	32	3151	70	173\n7	2	28	16	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	2	28	1	4	13	215	351	3635	4227	3265	1453	175249	13438	4909	1969	7791	18	146	5094\n7	2	29	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37	40\n7	2	29	1	6	15	15	42	202	393	810	1932	4903	164442	3038	3695	11553	1204	1886	4854	92\n7	2	30	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37	40\n7	2	30	2	1	6	2	31	10	26	126	1305	609	33906	1219	3644	397	380	7287	3573\n7	2	31	20	22	23	24	25	26	27	28	29	30	31	32	33	34	37	40\n7	2	31	1	2	1	4	10	4	430	129	1779	896	38354	1143	1400	2751	4611	1639\n7	2	32	14	18	23	25	26	27	28	29	30	31	32	33	34	37	40\n7	2	32	1	1	2	2	31	37	92	607	98	776	50742	111	484	2465	1115\n7	2	33	28	29	30	31	32	33	34	37	40\n7	2	33	5	643	362	19	348	13145	3014	5422	3221\n7	2	34	28	29	30	31	32	34	37\n7	2	34	3	203	184	136	1041	24657	119\n7	2	35	20	22	25	32	33	35	36\n7	2	35	1	1	1	1	1	6	1\n7	2	36	36\n7	2	36	1\n7	2	37	23	25	26	27	28	29	30	31	32	33	34	35	37	40\n7	2	37	1	18	19	91	4	61	98	127	722	223	501	1	70540	215\n7	2	39	39\n7	2	39	2\n7	2	40	30	32	37	40\n7	2	40	1	23	458	23547\n7	3	0	0\n7	3	0	185\n7	3	6	6	8	11\n7	3	6	65818	1	2\n7	3	7	7	8	9	10	11	12	13	14	16	17\n7	3	7	51925	8	1	12	5	2	1	1	1	1\n7	3	8	7	8	9	10	11	12	13	15	16	18	21\n7	3	8	138	91314	2	6	5	5	48	22	1	1	1\n7	3	9	6	7	8	9	10	11	12	13	15	16	17	21\n7	3	9	44	112	344	164516	480	40	38	98	4	4	8	2\n7	3	10	7	8	9	10	11	12	13	14	16	21	23\n7	3	10	27	125	1041	110294	76	74	111	7	6	1	2\n7	3	11	8	9	10	11	12	13	14	15	16	17	18	19	21	23\n7	3	11	18	245	864	1787479	21535	1674	8	585	94	17	2	1	1	1\n7	3	12	8	9	10	11	12	13	14	15	16	17	18	19	22\n7	3	12	6	97	259	38862	910697	4110	15860	1687	606	27	143	52	1\n7	3	13	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22	23\n7	3	13	2	91	156	211	2786	9882	1284481	2405	4540	3568	3287	449	2	41	2	2\n7	3	14	10	11	12	13	14	15	16	17	18	19	20	21	22	24\n7	3	14	2	319	27062	7688	1304410	4952	14821	929	2784	1704	5057	73	1	2\n7	3	15	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	26\n7	3	15	23	1	991	2271	9945	6300	727947	4032	4376	905	477	2904	3148	1579	71	1\n7	3	16	9	10	11	12	13	14	15	16	17	18	19	20	21	22	25	26	37\n7	3	16	1	6	189	1129	6615	24488	8506	528613	4497	3687	59	59	2988	374	2	34	2\n7	3	17	8	9	11	12	13	14	15	16	17	18	19	20	21	23	24	26	37\n7	3	17	9	12	21	42	4701	1339	7694	8345	465772	2183	1322	269	831	29	33	102	15\n7	3	18	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	28\n7	3	18	1	1	166	964	4163	1846	6330	4421	332862	2739	1313	1918	540	538	120	25	1\n7	3	19	11	12	13	14	15	16	17	18	19	20	21	22	24	25	26	27	31\n7	3	19	2	94	64	2393	771	451	2419	4480	132712	1262	1351	207	22	200	3	1	2\n7	3	20	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	35\n7	3	20	5	15	7215	4038	161	507	2223	2551	356478	2432	728	652	2845	1864	194	6	5	1\n7	3	21	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	34	35\n7	3	21	1	2	3	93	154	5785	4516	1849	3181	2183	4828	703105	2269	4836	3142	794	100	99	8	1	1	1\n7	3	22	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n7	3	22	1	2	1	2135	683	4	1048	416	1344	3974	115657	86	1629	910	1647	87	23	1\n7	3	23	10	11	12	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	37\n7	3	23	2	3	3	6	9	102	68	899	43	935	9675	290	375526	1924	846	804	230	218	40	1\n7	3	24	11	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32	34	36\n7	3	24	4	2	1	43	156	63	3995	5021	2706	3321	186483	1171	1156	1100	2191	20	2	1	1	1\n7	3	25	11	14	15	18	19	20	21	22	23	24	25	26	27	28	29	30	31	37\n7	3	25	1	1	1	29	344	2405	1431	1617	1187	1920	130299	577	462	2476	201	1	3	35\n7	3	26	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	3	26	1	1	3	1	30	79	19	5	318	194	2256	990	2017	1128	103984	1632	2269	760	46	2	3	34\n7	3	27	13	14	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	3	27	1	1	21	2	57	217	168	394	2190	839	2765	153497	1146	1951	30	419	1	85\n7	3	28	20	21	22	23	24	25	26	27	28	29	30	31	32	33\n7	3	28	4	26	192	437	3481	3832	3157	1904	178319	4329	955	99	89	2\n7	3	29	14	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37	40\n7	3	29	1	1	10	18	26	51	304	517	1032	3098	6164	240308	303	1383	549	459	170	51	1\n7	3	30	14	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	3	30	1	2	1	29	5	29	126	1521	847	42079	585	37	232	124	99\n7	3	31	19	22	24	25	26	27	28	29	30	31	32	33	34	36\n7	3	31	1	1	4	19	7	858	170	2081	924	47798	489	1	130	1\n7	3	32	23	25	26	27	28	29	30	31	32	33	34	37	40\n7	3	32	8	1	40	67	151	1061	118	1082	77434	171	665	547	13\n7	3	33	28	29	30	32	33	37\n7	3	33	1	730	366	237	15534	192\n7	3	34	29	30	31	32	34	37\n7	3	34	253	261	152	1347	31650	156\n7	3	35	19	33	35\n7	3	35	1	1	7\n7	3	36	36\n7	3	36	2\n7	3	37	16	17	25	26	27	28	29	30	31	32	33	34	35	37	40\n7	3	37	2	3	13	23	119	6	122	167	165	1166	304	666	3	98430	412\n7	3	39	39\n7	3	39	2\n7	3	40	30	32	37	40\n7	3	40	1	34	774	32593\n7	4	0	0\n7	4	0	185\n7	4	6	6	7	8	9	14\n7	4	6	65858	1	1	1	1\n7	4	7	7	8	9	10	14\n7	4	7	52184	8	2	9	1\n7	4	8	7	8	9	10	12	13	14	15	17\n7	4	8	157	91670	11	3	10	61	4	22	1\n7	4	9	6	7	8	9	10	11	12	13	14	17	18\n7	4	9	44	137	365	164900	421	22	42	118	11	11	2\n7	4	10	7	8	9	10	11	12	13	14	16	17	18\n7	4	10	48	115	1087	110635	72	52	112	6	6	3	2\n7	4	11	7	8	9	10	11	12	13	14	15	16	17	18	19	20\n7	4	11	16	35	394	872	1804047	22754	1793	65	602	180	17	12	1	5\n7	4	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n7	4	12	6	7	140	244	36307	912368	4282	16918	1897	622	37	112	62	1	1\n7	4	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n7	4	13	3	103	774	251	2569	9819	1291905	2669	5081	3772	3136	491	1	7	36	1\n7	4	14	7	9	10	11	12	13	14	15	16	17	18	19	20	21	24	25\n7	4	14	1	23	6	352	25319	7434	1304384	4883	15453	950	2895	1666	5317	76	2	1\n7	4	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23\n7	4	15	1	29	21	5	859	2132	9594	6042	733398	4576	4390	1024	529	3032	3444	1474	67\n7	4	16	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	37\n7	4	16	41	17	159	1097	6148	22597	8197	521515	4668	3997	75	67	3219	423	1	6	1	30	6\n7	4	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	37\n7	4	17	6	77	33	27	103	4349	1232	7053	8023	462489	2187	1373	295	879	1	25	39	104	1	11\n7	4	18	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28\n7	4	18	2	42	13	172	882	3865	1689	5833	4294	330706	2737	1376	2111	612	539	153	43	2	1\n7	4	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	25	28\n7	4	19	1	77	3	5	84	49	2383	735	467	2271	4140	131239	1331	1433	200	30	229	1\n7	4	20	7	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n7	4	20	1	1	149	3	9	17	6963	3700	164	483	2077	2521	356220	2538	796	656	2928	1811	193	6	2\n7	4	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n7	4	21	34	10	4	23	55	203	5864	4320	1840	3197	2040	4871	702418	2289	5008	3264	812	77	102	14	3\n7	4	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	33\n7	4	22	25	54	4	5	1	9	2012	630	11	963	395	1274	3938	114678	83	1743	975	1669	102	43	1	1\n7	4	23	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	32\n7	4	23	7	25	1	13	4	14	122	2	49	1007	33	899	9391	255	372071	1978	980	748	254	245	33	1\n7	4	24	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31\n7	4	24	17	40	11	1	20	1	3	55	172	63	4180	4586	2348	3207	185482	1190	1121	1189	2437	17	1	4\n7	4	25	10	13	14	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	4	25	4	1	1	36	270	2265	1266	1502	1136	1897	129959	585	548	2682	240	5	4	4	60\n7	4	26	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	4	26	2	9	1	2	3	7	5	25	95	54	4	342	190	2150	995	1794	1123	104015	1714	2289	774	28	2	4	28\n7	4	27	9	10	12	13	14	15	16	17	18	20	21	22	23	24	25	26	27	28	29	30	31	32	36	37\n7	4	27	1	49	9	8	6	2	1	11	62	47	167	129	338	2189	771	2654	153045	1249	1957	36	479	2	1	73\n7	4	28	10	12	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	4	28	6	2	1	2	4	4	27	1	1	15	197	419	3285	3515	3059	1774	176518	4578	1040	109	109	2	1\n7	4	29	13	16	17	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	4	29	2	1	1	26	22	38	41	305	502	1010	2876	5692	239143	328	1481	541	471	186	39\n7	4	30	10	13	15	16	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	37\n7	4	30	25	11	3	12	3	17	9	7	1	56	40	11	23	120	1396	772	41634	595	42	225	161	88\n7	4	31	10	13	14	15	17	18	19	21	24	25	26	27	28	29	30	31	32	34	37\n7	4	31	2	2	2	4	2	2	1	1	8	12	5	798	170	1958	918	47136	543	125	3\n7	4	32	14	16	19	22	23	25	26	27	28	29	30	31	32	33	34	37	40\n7	4	32	1	1	1	1	14	10	64	85	151	969	127	1059	77443	165	666	624	6\n7	4	33	17	28	29	30	31	32	33	37\n7	4	33	1	1	741	365	1	262	15163	170\n7	4	34	19	23	29	30	31	32	33	34	37\n7	4	34	1	1	248	235	167	1360	1	31216	178\n7	4	35	20	27	33	35\n7	4	35	1	1	1	9\n7	4	36	24	36	37\n7	4	36	1	2	1\n7	4	37	16	25	26	27	29	30	31	32	33	34	37	40\n7	4	37	1	15	17	126	119	186	210	1065	247	581	97455	399\n7	4	39	33	39\n7	4	39	1	1\n7	4	40	29	32	37	40\n7	4	40	1	38	694	32286\n7	5	0	0\n7	5	0	185\n7	5	6	6	8\n7	5	6	65900	2\n7	5	7	7	8	9	10\n7	5	7	52532	4	1	18\n7	5	8	7	8	9	11	12	13	15	21\n7	5	8	1573	90700	2	1	3	50	13	1\n7	5	9	6	7	8	9	10	11	12	13	17\n7	5	9	7161	2104	1719	156127	550	23	14	115	12\n7	5	10	7	8	9	10	11	12	13	14	16	21	23\n7	5	10	465	1143	2061	108786	114	45	114	4	5	1	1\n7	5	11	7	8	9	10	11	12	13	14	15	16	17	18	19	25\n7	5	11	9	1955	2517	1600	1812004	23716	1825	7	653	125	15	1	1	1\n7	5	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	23\n7	5	12	486	2620	3301	4490	68799	869764	4405	17664	1779	589	37	72	18	1	1\n7	5	13	7	8	9	10	11	12	13	14	15	16	17	18	19	21\n7	5	13	45	811	1339	1125	10581	22773	1274717	2723	5013	3966	3297	431	2	10\n7	5	14	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24	25\n7	5	14	1	9	1170	1311	9620	54173	21800	1248387	3393	16346	967	3013	1729	5453	31	1	1	1\n7	5	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23\n7	5	15	67	249	865	896	5920	19932	45818	23574	658993	5234	4510	689	503	3203	3181	1626	14\n7	5	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	25	26	28	37\n7	5	16	50	89	169	897	2642	6501	34443	9443	498689	4968	4073	100	217	2931	378	3	9	1	4\n7	5	17	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	37\n7	5	17	1	16	328	295	6660	18904	24470	27226	35975	44418	322431	2021	1237	122	651	1	9	32	21	4\n7	5	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	30\n7	5	18	1	59	325	230	1678	8296	8107	26118	24728	31555	245367	3097	920	1936	559	88	103	12	1	1	1\n7	5	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25\n7	5	19	1	44	62	249	5854	1141	4731	4863	1884	2818	4821	114265	758	1157	239	5	23	107\n7	5	20	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n7	5	20	4	3	22	1872	20929	3982	27152	20898	32471	18347	14633	11736	222387	2443	685	609	1919	1436	25	8	2	1\n7	5	21	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	33\n7	5	21	2	11	54	398	3185	13207	21606	47042	100780	60911	28998	7575	9950	433828	2452	2691	2453	467	74	34	12	1	1\n7	5	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30\n7	5	22	1	2	27	208	144	107	2130	579	139	1625	1269	4135	3627	108698	82	1724	982	1595	42	32	1\n7	5	23	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n7	5	23	1	7	61	164	146	936	1083	19579	7261	61674	79025	6529	10602	38492	2088	154412	1089	1022	204	65	140	22\n7	5	24	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32\n7	5	24	1	70	102	382	968	12117	1760	21260	4935	9963	27704	6425	2166	112777	985	691	476	2341	16	2	3\n7	5	25	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	5	25	1	13	48	50	50	375	516	72	2043	3394	8233	20106	7607	2314	10061	83276	510	446	2648	138	3	4	3	49\n7	5	26	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	5	26	21	24	13	166	220	866	328	1714	845	2504	30527	4572	2018	8456	3816	56002	505	2076	661	25	3	1	13\n7	5	27	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	37\n7	5	27	31	18	650	46	2624	274	9489	10870	23899	23266	7519	1882	4900	13631	974	60997	674	793	19	173	12\n7	5	28	14	15	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32\n7	5	28	1	1	3	2	11	3069	1695	2985	4776	5728	3088	518	167247	2999	677	74	17\n7	5	29	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	5	29	1	3	234	232	631	6	432	456	919	21758	7522	5580	27280	32197	8180	1253	18617	124478	209	959	257	257	85	7\n7	5	30	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	5	30	1	1	22	1072	394	1005	1745	83	8077	4792	26963	495	23	133	69	29\n7	5	31	14	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\n7	5	31	4	10	3	8	49	71	1679	1447	2822	976	474	4064	3858	5636	1643	28234	213	6	50\n7	5	32	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37	40\n7	5	32	172	3	223	19	923	329	1020	20	332	2885	934	265	13157	23256	5508	1825	29923	178	255	182	5\n7	5	33	24	25	26	28	29	30	31	32	33	35	37\n7	5	33	53	64	1314	62	2405	849	2445	87	8914	1	83\n7	5	34	24	25	28	29	30	31	32	33	34	37\n7	5	34	1	1	670	5792	633	5574	642	4416	15134	72\n7	5	35	26	33	35	37\n7	5	35	1	2	5	1\n7	5	36	35	36\n7	5	36	1	2\n7	5	37	16	17	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	40\n7	5	37	18	39	2	11	14	13	16	108	398	580	381	9483	11507	11661	9832	2605	8417	260	1	1	43969	115\n7	5	39	37\n7	5	39	1\n7	5	40	28	29	30	31	32	33	37	40\n7	5	40	1	520	7506	3027	1415	4543	244	15435\n7	6	0	0\n7	6	0	185\n7	6	6	6	7	9	26\n7	6	6	73054	4	2	1\n7	6	7	7	9	10	11	15\n7	6	7	57255	1	25	1	1\n7	6	8	7	8	9	10	12	13	15	18	21\n7	6	8	1093	98050	1	5	6	89	41	1	1\n7	6	9	6	7	8	9	10	11	12	13	15	17	21\n7	6	9	3632	1533	1328	160367	821	47	21	152	2	21	2\n7	6	10	7	8	9	10	11	12	13	14	16	18\n7	6	10	246	629	2032	116379	188	67	222	8	7	2\n7	6	11	7	8	9	10	11	12	13	14	15	16	17	27\n7	6	11	4	1011	2234	1500	1881239	27691	2849	9	840	168	34	1\n7	6	12	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22\n7	6	12	35	962	1750	3041	52450	955715	6224	21012	2052	746	65	82	4	1	1\n7	6	13	7	8	9	10	11	12	13	14	15	16	17	18	19	21	23	27\n7	6	13	28	498	927	948	5833	23221	1356313	4461	6439	4673	3880	482	1	1	1	1\n7	6	14	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24\n7	6	14	225	895	2594	47995	21058	1308040	3627	21102	1357	3322	2047	5987	40	1	11\n7	6	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22\n7	6	15	9	247	132	281	2632	14352	33639	24786	737972	6074	6445	1014	694	3630	4409	1590\n7	6	16	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	25	26	27	28	37\n7	6	16	1	4	8	45	509	2066	6567	30698	10787	686836	6906	5069	186	213	3494	452	1	3	1	1	3\n7	6	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24	25	26	28	37\n7	6	17	6	100	165	415	5558	10912	11924	24933	39482	415963	2500	1491	180	477	10	43	2	8	1	3\n7	6	18	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25\n7	6	18	2	12	67	76	394	2604	5689	18161	26054	39310	319539	4058	1130	2035	667	31	99	7\n7	6	19	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	25	28\n7	6	19	3	8	5	7	807	150	2697	2426	2265	3124	6670	147885	961	1096	239	62	184	1\n7	6	20	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31\n7	6	20	1	17	3055	463	9801	6295	8502	6207	13870	16518	232777	1617	832	653	2086	1542	11	12	1	1\n7	6	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n7	6	21	3	19	21	351	2042	5112	19240	34725	26941	19691	4320	5594	486651	2929	2634	3728	793	268	34	10	28\n7	6	22	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n7	6	22	1	7	55	40	2002	667	46	1408	1285	4304	4387	135071	157	2251	1180	1825	55	59\n7	6	23	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n7	6	23	31	9	89	118	3650	1762	15191	21123	2298	4030	15189	956	110672	843	1068	85	32	239	28\n7	6	24	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	33\n7	6	24	1	8	88	233	1900	511	5240	2338	5226	19374	8422	2221	128276	848	843	419	3307	42	6	1\n7	6	25	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	35	37\n7	6	25	12	3	25	79	152	40	1538	3765	7026	10799	7312	2487	9020	101804	725	469	3405	291	15	6	1	19\n7	6	26	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	6	26	11	49	211	51	446	266	1180	6850	2853	425	4675	2022	54358	201	2014	774	16	3	3	14\n7	6	27	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	37\n7	6	27	1	919	30	2298	3304	7198	5710	4438	520	2307	4467	291	36837	205	483	3	122	4\n7	6	28	16	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33\n7	6	28	1	1	8	739	717	3478	4844	6003	2747	163	204930	4438	781	205	36	8\n7	6	29	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	6	29	2	33	261	2	84	58	326	6602	3228	1621	9440	11008	7231	1185	12457	127852	100	1091	147	241	44	4\n7	6	30	20	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	6	30	1	33	420	290	295	696	90	6686	2706	43986	368	17	67	26	17\n7	6	31	17	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\n7	6	31	1	7	12	513	1499	936	1094	1093	1282	2959	7778	2685	32583	172	3	30\n7	6	32	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37	40\n7	6	32	1	22	2	394	80	476	7	83	635	324	86	4148	6746	2624	763	18387	192	141	74	4\n7	6	33	24	25	26	28	29	30	31	32	33	34	35	37\n7	6	33	40	38	1212	622	3954	2493	3119	236	15109	1	1	42\n7	6	34	25	28	29	30	31	32	33	34	37\n7	6	34	1	406	2126	192	1763	364	1714	9251	36\n7	6	35	35	37\n7	6	35	7	1\n7	6	36	33	36\n7	6	36	2	1\n7	6	37	16	17	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37	38	39	40\n7	6	37	11	18	1	15	28	6	14	75	125	372	179	3497	6602	3316	3979	573	3341	178	22274	1	1	64\n7	6	40	29	30	31	32	33	37	40\n7	6	40	390	2647	1124	392	1735	121	9146\n8	1	0	0\n8	1	0	132\n8	1	6	6	9	11\n8	1	6	43047	4458	1\n8	1	7	7	8	9	10	12	13	15\n8	1	7	26801	423	998	175	19	10	1\n8	1	8	7	8	9	10	11	12	13	15	16	34\n8	1	8	65	47881	901	660	474	656	288	68	4	1\n8	1	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21\n8	1	9	15	61	152	72167	517	1089	847	345	93	56	3	63	1	2	2\n8	1	10	7	8	9	10	11	12	13	14	15	16	17	18	19	21\n8	1	10	22	70	558	58500	708	2804	516	440	113	31	38	37	1	3\n8	1	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n8	1	11	5	131	418	766461	11747	1951	780	787	130	35	46	3	1	1	78\n8	1	12	9	10	11	12	13	14	15	16	17	18	19	20	21	23	28\n8	1	12	56	136	17312	351342	3375	18988	3007	783	859	101	2119	140	2	14	2\n8	1	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n8	1	13	32	81	140	2255	4308	536398	6736	6845	994	396	317	324	41	132	89\n8	1	14	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	28\n8	1	14	2	172	12554	6108	699391	21615	2394	2949	1317	20997	1955	658	177	204	6	5	1\n8	1	15	8	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26\n8	1	15	27	504	1014	7779	3943	488156	4711	2629	2731	9439	2210	7563	793	543	24	12\n8	1	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27\n8	1	16	3	81	399	1545	3458	8135	138887	5876	10193	770	2540	15888	155	3520	2	148	224	6\n8	1	17	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	33\n8	1	17	12	141	509	337	772	21764	2852	836	1382	938	779	2090	19	177	146	1	2	1\n8	1	18	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	32\n8	1	18	1	31	529	1953	1765	1576	890	137397	839	5906	5508	4	347	31	866	932	6732	14	81\n8	1	19	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	32\n8	1	19	2	23	1268	995	579	157	879	67177	1027	2250	115	138	10	16	376	1136	135	2	28\n8	1	20	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	32\n8	1	20	2	3106	4224	1372	110	1647	1663	149219	8082	1016	83	710	5483	1535	2114	4051	531	129\n8	1	21	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	32\n8	1	21	2	1	1	275	21	62	115	233	344	66633	72	275	909	279	1617	3632	3213	108	139\n8	1	22	11	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	32	37\n8	1	22	1	1	1	4	37	24	410	3104	334	38501	8	538	1338	575	2552	1101	565	2	113\n8	1	23	18	19	20	21	22	23	24	25	26	28	30	31	32\n8	1	23	2	4	77	151	4	7145	2	4	40	7	2	2	1\n8	1	24	14	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	37\n8	1	24	1	7	15	20	1944	396	1308	12	49382	3504	910	1667	1172	15	757	1	1704	1351	181\n8	1	25	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	37\n8	1	25	1	1	1	3	1465	443	211	15	389	39574	59	403	2745	7	1848	2	558	1367	783\n8	1	26	16	17	18	20	21	22	23	24	25	26	27	28	30	31	32	33	34	37\n8	1	26	1	1	5	12	16	10	34	641	160	11697	458	90	5	2	1367	1	1053	423\n8	1	27	18	20	21	22	23	24	25	26	27	28	29	30	32\n8	1	27	20	160	123	7	2	180	1192	236	26141	4	419	6	290\n8	1	28	21	22	23	24	25	26	27	28	29	30	31	33	34	37\n8	1	28	1	1	3	3	3	253	126	14794	2	26	1	1	50	4\n8	1	29	17	18	21	24	25	26	27	28	29	32	34	37\n8	1	29	1	2	2	93	173	2	1208	3	15632	2990	2458	782\n8	1	30	14	17	26	27	28	29	30	31	32	34	37\n8	1	30	1	1	37	7	159	3	4816	3	2	44	12\n8	1	31	13	25	26	27	28	31	32\n8	1	31	1	1	3	4	5	42	1\n8	1	32	14	25	26	27	28	29	30	32	33	34	37\n8	1	32	1	1	2	15	1	30	1	7271	3	119	3\n8	1	33	18	20	33\n8	1	33	1	1	5\n8	1	34	21	27	28	30	32	33	34	35	37\n8	1	34	1	34	141	203	460	1	10251	1	66\n8	1	35	33	35	37\n8	1	35	1	10	1\n8	1	36	35	36\n8	1	36	1	3\n8	1	37	23	28	30	32	34	35	37\n8	1	37	1	21	63	17	301	1	4110\n8	1	38	37	40\n8	1	38	1	1\n8	1	40	31	32	38	40\n8	1	40	1	1	1	7\n8	2	0	0\n8	2	0	132\n8	2	6	6	9\n8	2	6	40141	2921\n8	2	7	7	8	9	10	12	13	15	20\n8	2	7	25664	389	566	169	130	13	17	1\n8	2	8	7	8	9	10	11	12	13	14	15	16	17\n8	2	8	57	46075	488	371	501	805	200	1	76	15	1\n8	2	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19\n8	2	9	19	76	181	76194	414	672	932	363	197	203	16	62	10	11\n8	2	10	7	8	9	10	11	12	13	14	15	16	17	18	19	21	23\n8	2	10	11	72	478	57087	261	1590	364	333	145	54	40	81	20	5	10\n8	2	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	25	26\n8	2	11	9	138	407	762402	16568	2395	4078	2063	283	123	40	344	92	76	36	2	3\n8	2	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	26\n8	2	12	5	35	118	14994	326820	3820	19921	6776	1829	702	134	9574	963	22	16	8\n8	2	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	30\n8	2	13	33	50	80	1832	3900	525682	9612	12890	998	581	358	782	708	1344	1	151	1	6	2	1\n8	2	14	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26\n8	2	14	135	9722	4917	631920	24352	4318	3656	1256	53039	4687	2032	193	397	11	35\n8	2	15	8	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	32\n8	2	15	9	344	785	5881	4270	463809	3767	2054	3097	22696	4789	22871	808	994	95	74	38\n8	2	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29\n8	2	16	2	43	291	1237	2621	4819	94610	3754	6702	654	8946	23678	107	3758	2	722	293	23	1\n8	2	17	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	32\n8	2	17	12	105	408	250	556	19973	1861	2373	2731	2127	1067	3509	12	505	379	4	2	1\n8	2	18	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	32\n8	2	18	1	45	396	1512	1702	1295	839	106071	577	19166	7802	9	606	28	2726	1571	13191	18	1	147\n8	2	19	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	32\n8	2	19	11	19	1002	855	520	181	511	94030	975	1812	188	449	12	116	1348	2369	356	86\n8	2	20	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	32\n8	2	20	2	7	2406	3275	1304	105	1393	1215	135760	4694	986	277	706	7021	3335	3749	4528	541	224\n8	2	21	11	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	32	35\n8	2	21	1	2	391	12	127	113	304	315	87081	95	556	464	430	4358	7856	6623	123	275	1\n8	2	22	11	14	16	17	18	19	20	21	22	23	24	25	26	27	28	30	32	37\n8	2	22	1	1	7	33	19	413	2173	361	31040	6	491	508	1512	4604	1432	509	10	33\n8	2	23	10	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31\n8	2	23	2	3	1	2	1	1	8	20	146	310	8	13905	13	5	161	2	9	4\n8	2	24	17	18	19	20	21	22	23	24	25	26	27	28	29	30	32	34	37\n8	2	24	2	11	16	1483	333	990	13	38829	2701	1136	2572	1586	9	694	1747	721	72\n8	2	25	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	37\n8	2	25	1	8	1139	360	131	7	283	37529	76	370	5713	5	3672	8	1314	1540	787\n8	2	26	12	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	37\n8	2	26	1	8	17	5	1	40	35	14	202	383	114	13380	710	251	4	23	4	2162	958	349\n8	2	27	18	20	21	22	23	24	25	26	27	28	29	30	32\n8	2	27	28	303	269	15	2	116	917	568	43077	2	355	3	581\n8	2	28	21	22	23	24	25	26	27	28	30	31	34	35	37\n8	2	28	1	3	13	4	1	716	220	26511	76	1	102	1	12\n8	2	29	18	21	24	25	26	27	28	29	32	34	35	37\n8	2	29	1	3	34	83	6	763	1	9610	3186	1834	1	586\n8	2	30	24	26	27	28	30	31	32	34	37\n8	2	30	1	82	5	360	8366	2	2	89	26\n8	2	31	20	21	23	24	26	27	28	30	31\n8	2	31	1	1	1	2	1	2	7	1	38\n8	2	32	14	23	25	26	27	28	29	30	32	33	34	37\n8	2	32	1	1	2	10	47	1	76	9	14692	3	194	5\n8	2	33	31	32	33	35\n8	2	33	1	2	8	2\n8	2	34	25	27	28	29	30	32	33	34	37\n8	2	34	1	67	272	1	272	722	1	15510	149\n8	2	35	24	31	33	34	35	37\n8	2	35	1	1	1	2	7	1\n8	2	36	31	35	36\n8	2	36	1	1	1\n8	2	37	24	28	30	32	33	34	37\n8	2	37	1	29	48	15	1	360	6025\n8	2	38	35\n8	2	38	1\n8	2	40	39	40\n8	2	40	1	7\n8	3	0	0\n8	3	0	132\n8	3	6	6	15	19\n8	3	6	40158	1	1\n8	3	7	7	8	10	11	13	15	19\n8	3	7	25796	1	7	1	1	1	1\n8	3	8	7	8	11	12	13	15\n8	3	8	67	46676	1	3	16	10\n8	3	9	6	7	8	9	10	11	12	13	18\n8	3	9	30	54	188	80378	165	17	13	24	1\n8	3	10	7	8	9	10	11	12	13	14	16\n8	3	10	9	67	452	58029	28	32	30	1	2\n8	3	11	8	9	10	11	12	13	15	16	19\n8	3	11	5	122	414	773670	5955	821	167	34	1\n8	3	12	7	8	9	10	11	12	13	14	15	16	17	18	19	22	24\n8	3	12	1	4	52	130	13257	342046	1241	4254	396	149	8	54	21	1	1\n8	3	13	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22\n8	3	13	3	28	46	84	1759	3798	535072	1486	2469	493	33	127	1	1	1\n8	3	14	11	12	13	14	15	16	17	18	19	20	21	22	24\n8	3	14	153	8714	4458	659117	1864	1106	200	836	531	1300	1	3	1\n8	3	15	8	11	12	13	14	15	16	17	18	19	20	21\n8	3	15	13	314	766	5444	4310	505340	1918	107	1006	658	1701	48\n8	3	16	10	11	12	13	14	15	16	17	18	19	20	21	26	36\n8	3	16	1	42	248	1085	2311	3779	100573	201	617	162	547	16	10	1\n8	3	17	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	26\n8	3	17	1	1	12	95	342	230	532	30303	437	44	34	169	6	1	3	41\n8	3	18	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27\n8	3	18	2	82	335	1356	2152	1317	800	114699	265	547	82	10	3	8	7	35\n8	3	19	12	13	14	15	16	17	18	19	20	21	22	23	24	25\n8	3	19	42	13	808	1222	515	147	486	181766	564	221	258	11	6	18\n8	3	20	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n8	3	20	1	2	2167	2857	1174	68	1291	1142	172786	162	1004	114	705	650	62	232	1\n8	3	21	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29\n8	3	21	1	1	1	4	2	749	50	240	163	468	419	151992	152	183	173	163	101	354	1\n8	3	22	11	14	15	16	17	18	19	20	21	22	24	25	27\n8	3	22	1	2	1	5	35	34	561	1912	320	32338	403	41	2\n8	3	23	11	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n8	3	23	1	1	1	17	3	4	47	364	478	8	23524	28	5	423	3	2\n8	3	24	11	14	17	18	19	20	21	22	23	24	25	26	27	29\n8	3	24	1	2	6	8	18	1227	307	815	7	38654	121	186	30	12\n8	3	25	13	15	16	18	19	20	21	22	23	24	25	26	27	29	31	35\n8	3	25	1	1	2	7	20	1128	371	169	11	325	51044	26	372	5	1	1\n8	3	26	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30\n8	3	26	2	11	32	24	1	197	139	4	702	312	156	26049	679	713	33\n8	3	27	17	18	19	20	21	22	23	24	25	26	27	28	29\n8	3	27	1	59	2	692	657	9	5	109	984	1351	75376	2	384\n8	3	28	17	19	20	21	22	23	25	26	27	28	30	32	34	37\n8	3	28	2	3	4	3	20	16	15	1389	398	45470	182	3	178	18\n8	3	29	21	24	25	26	27	28	29	30	32	34\n8	3	29	3	30	81	2	663	2	9278	1	1	1\n8	3	30	18	22	25	26	27	28	30	31	33	34	37\n8	3	30	1	2	1	85	10	617	13438	1	1	143	39\n8	3	31	21	22	23	25	26	27	28	31	32\n8	3	31	1	3	15	15	6	2	2	15	1\n8	3	32	23	26	27	28	29	30	31	32	33	34	37\n8	3	32	2	17	89	1	108	8	1	24556	2	418	2\n8	3	33	24	30	32	33	35\n8	3	33	1	2	4	6	1\n8	3	34	27	28	30	32	34	37\n8	3	34	62	295	301	799	19646	207\n8	3	35	25	35\n8	3	35	1	13\n8	3	36	36\n8	3	36	1\n8	3	37	23	28	30	32	34	37\n8	3	37	1	38	78	10	457	7461\n8	3	39	39\n8	3	39	1\n8	3	40	32	39	40\n8	3	40	2	1	4\n8	4	0	0\n8	4	0	132\n8	4	6	6	7	8	9\n8	4	6	40177	5	1	5\n8	4	7	7	8	9	10	11	12	14\n8	4	7	25879	10	28	5	2	3	3\n8	4	8	7	8	9	10	11	12	13	14	15	18\n8	4	8	84	46805	41	2	1	12	19	9	8	1\n8	4	9	6	7	8	9	10	11	12	13	14	18\n8	4	9	30	87	177	80487	135	16	36	38	38	7\n8	4	10	7	8	9	10	11	12	13	14	17	18\n8	4	10	18	67	439	58219	21	18	38	6	6	2\n8	4	11	7	8	9	10	11	12	13	14	15	16	18	19\n8	4	11	15	10	229	438	780855	6369	1031	57	171	54	17	1\n8	4	12	7	9	10	11	12	13	14	15	16	17	18	19	21\n8	4	12	2	61	113	12430	342533	1393	4480	433	180	14	49	23	1\n8	4	13	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22\n8	4	13	2	33	395	84	1653	3908	537598	1667	2581	520	51	147	1	2	1\n8	4	14	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24\n8	4	14	2	29	3	158	8119	4281	657416	1977	1219	211	836	513	1390	1	2	1\n8	4	15	8	9	11	12	13	14	15	16	17	18	19	20	21	22	25\n8	4	15	10	16	261	682	5239	4187	505010	2098	134	1034	688	1844	30	7	2\n8	4	16	9	10	11	12	13	14	15	16	17	18	19	20	21	25	26	27	32\n8	4	16	22	1	59	267	964	2133	3577	99130	260	712	160	582	18	2	9	1	1\n8	4	17	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	32\n8	4	17	16	8	9	37	93	350	228	525	30182	457	40	29	167	10	1	9	24	1\n8	4	18	9	10	12	13	14	15	16	17	18	19	20	21	22	24	25	26	27\n8	4	18	23	9	67	275	1237	2116	1214	726	113177	230	611	87	16	18	11	2	35\n8	4	19	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27\n8	4	19	55	2	47	12	842	1324	488	133	421	181314	580	204	244	21	9	15	2\n8	4	20	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n8	4	20	79	3	8	5	1890	2693	1054	45	1148	1053	172336	177	1066	103	751	700	75	235	1\n8	4	21	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30\n8	4	21	22	10	5	3	15	691	12	214	163	377	394	151850	187	223	170	175	74	384	1	1\n8	4	22	9	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	27\n8	4	22	4	17	1	7	12	3	4	24	27	470	1736	259	31753	1	434	49	2\n8	4	23	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29	30	38\n8	4	23	3	12	7	1	6	9	1	3	20	37	287	441	7	23290	42	1	424	1	1	1	1\n8	4	24	9	10	12	14	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n8	4	24	6	17	4	3	7	14	15	1118	264	715	12	38182	142	196	49	2	12	1\n8	4	25	10	14	16	18	19	20	21	22	23	24	25	26	27	29\n8	4	25	1	1	1	11	24	1025	351	130	7	266	51026	48	406	5\n8	4	26	9	10	12	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	33\n8	4	26	1	2	5	2	8	55	22	3	200	146	8	736	290	146	26562	745	775	1	40	1\n8	4	27	9	10	12	13	14	15	17	18	20	21	22	23	24	25	26	27	28	29	30	32\n8	4	27	1	18	1	3	4	2	3	60	728	647	4	1	107	885	1230	74168	2	438	4	1\n8	4	28	12	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	30	34	37\n8	4	28	1	1	1	1	2	3	2	1	1	2	5	1	1	1300	364	45060	202	181	14\n8	4	29	10	16	21	22	24	25	26	27	29	32	37\n8	4	29	1	1	5	4	28	86	3	596	9062	1	1\n8	4	30	10	13	15	16	17	18	19	20	22	25	26	27	28	29	30	31	32	34	37	40\n8	4	30	7	5	2	5	2	1	3	3	15	3	74	3	559	1	13164	1	2	159	33	1\n8	4	31	10	18	22	25	26	28	31\n8	4	31	1	2	1	1	1	1	11\n8	4	32	16	19	20	22	23	26	27	28	29	30	31	32	33	34	37\n8	4	32	2	1	1	1	3	33	91	1	86	4	1	24725	3	423	1\n8	4	33	25	28	33	35\n8	4	33	1	1	6	1\n8	4	34	12	18	22	25	27	28	30	31	32	33	34	37\n8	4	34	2	1	1	1	60	266	273	1	741	1	19266	230\n8	4	35	23	30	33	35	37\n8	4	35	1	1	3	9	1\n8	4	36	36\n8	4	36	2\n8	4	37	24	28	30	32	33	34	37\n8	4	37	1	40	77	10	2	423	7174\n8	4	39	32	38\n8	4	39	1	1\n8	4	40	38	40\n8	4	40	1	3\n8	5	0	0\n8	5	0	132\n8	5	6	6	7	8	9	11\n8	5	6	40200	4	1	1	1\n8	5	7	7	8	10	11\n8	5	7	26077	10	6	1\n8	5	8	7	8	9	11	12	13	15\n8	5	8	72	47011	1	2	2	22	3\n8	5	9	6	7	8	9	10	11	12	13	15\n8	5	9	28	74	226	81398	183	19	3	30	1\n8	5	10	7	8	9	10	11	12	13	16\n8	5	10	19	78	439	58496	32	12	30	2\n8	5	11	7	8	9	10	11	12	13	14	15	16\n8	5	11	21	79	156	392	786669	6791	1085	22	161	90\n8	5	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n8	5	12	11	26	58	121	11421	343536	1535	4644	446	218	31	56	32	2	1\n8	5	13	7	8	9	10	11	12	13	14	15	16	17	18	19	21	30\n8	5	13	13	416	143	79	1572	3732	540112	1665	2561	517	65	118	3	2	1\n8	5	14	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	27\n8	5	14	2	16	10	1	181	7222	3862	656629	2064	1252	220	927	550	1413	1	3	5	1\n8	5	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	37\n8	5	15	1	27	10	1	244	645	4770	3823	505413	2023	147	1098	683	1890	48	2	1\n8	5	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	26	27\n8	5	16	159	19	2	78	212	839	1914	3328	98150	267	685	170	658	24	2	8	1\n8	5	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	24	26	29\n8	5	17	13	3	11	18	73	302	205	452	30145	477	58	21	216	20	8	49	1\n8	5	18	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	28	30\n8	5	18	3	3	12	52	263	1133	1987	1128	674	111917	290	654	138	14	1	25	6	30	1	1\n8	5	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25\n8	5	19	31	7	1	16	30	8	621	1229	476	126	363	180853	606	264	283	16	19	6\n8	5	20	8	9	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	32\n8	5	20	80	17	13	19	1786	2376	983	43	986	1049	172122	169	1199	141	849	699	69	264	1\n8	5	21	8	9	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27\n8	5	21	14	2	6	16	1	698	13	216	143	339	408	151511	188	217	242	184	69	384\n8	5	22	8	9	10	11	13	14	15	16	17	18	19	20	21	22	24	25	26	27	28	33\n8	5	22	19	6	4	4	9	8	1	5	15	24	446	1575	251	31271	462	65	4	1	3	1\n8	5	23	8	9	10	11	13	14	15	17	18	19	20	21	22	23	24	25	26\n8	5	23	21	8	1	15	37	2	3	2	12	28	245	427	1	23086	75	6	435\n8	5	24	10	14	17	18	19	20	21	22	23	24	25	26	27	29\n8	5	24	1	5	5	8	9	989	204	665	6	38009	138	214	41	15\n8	5	25	8	9	10	11	12	13	14	15	17	18	19	20	21	22	24	25	26	27	29	34\n8	5	25	3	2	6	5	2	13	1	1	15	10	20	1015	289	121	266	50988	33	452	4	1\n8	5	26	10	11	16	17	18	20	21	22	23	24	25	26	27	28	29	30\n8	5	26	1	1	11	29	25	204	124	3	674	246	153	27042	720	783	1	38\n8	5	27	18	20	21	23	24	25	26	27	28	29	31\n8	5	27	49	625	581	1	75	811	1098	73441	2	456	2\n8	5	28	9	11	13	17	24	26	27	28	30	34	37\n8	5	28	1	1	6	1	3	1191	398	44657	223	216	13\n8	5	29	21	24	25	26	27	28	29	33\n8	5	29	1	25	87	3	554	2	8933	1\n8	5	30	13	26	27	28	29	30	33	34	37\n8	5	30	1	59	2	534	1	12975	3	161	32\n8	5	31	13	17	30	31	33\n8	5	31	1	7	1	4	1\n8	5	32	23	25	26	27	29	30	32	34	37\n8	5	32	3	2	22	76	113	4	24827	435	1\n8	5	33	26	28	32	33	35\n8	5	33	1	1	2	11	1\n8	5	34	27	28	30	32	34	37\n8	5	34	66	230	253	649	19026	228\n8	5	35	17	32	35	37\n8	5	35	1	1	7	1\n8	5	36	36\n8	5	36	2\n8	5	37	28	30	32	34	35	37\n8	5	37	21	62	9	408	1	6953\n8	5	38	38	39\n8	5	38	2	1\n8	5	40	11	17	32	40\n8	5	40	1	1	1	1\n8	6	0	0\n8	6	0	132\n8	6	6	6	7\n8	6	6	40224	4\n8	6	7	7	10	11\n8	6	7	26287	6	1\n8	6	8	7	8	9	10	12	13	15\n8	6	8	921	47283	1	2	3	18	5\n8	6	9	6	7	8	9	10	11	12	13	16	21\n8	6	9	4748	1173	1116	74936	254	11	8	36	1	1\n8	6	10	7	8	9	10	11	12	13	14	16	18\n8	6	10	277	681	1018	57173	57	12	66	7	1	3\n8	6	11	7	8	9	10	11	12	13	14	15	16	24	28\n8	6	11	10	1228	1429	898	787879	7470	1181	6	170	30	3	1\n8	6	12	7	8	9	10	11	12	13	14	15	16	17	18	19\n8	6	12	293	1326	1815	2617	28285	320291	1902	5033	487	124	28	45	11\n8	6	13	7	8	9	10	11	12	13	14	15	16	17	18	20	27	28\n8	6	13	58	405	742	655	4438	7484	533457	2065	2673	560	79	112	1	1	1\n8	6	14	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24\n8	6	14	3	3	568	670	7374	29811	15477	611817	2081	1410	281	956	569	1524	1	4	1	6\n8	6	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22\n8	6	15	65	149	463	407	3483	10168	24759	31768	443058	2567	174	807	470	2057	80	2\n8	6	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	26\n8	6	16	32	45	126	486	2484	1867	6743	5931	85731	329	689	179	649	25	1	3\n8	6	17	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	26\n8	6	17	5	145	96	177	1121	867	4695	2603	5398	16121	564	53	52	77	13	7	16\n8	6	18	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	25	27	28\n8	6	18	2	33	178	107	298	775	2148	5300	9796	2470	94596	345	702	97	11	31	1	7	1\n8	6	19	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25\n8	6	19	10	1	24	42	441	13910	1150	66416	22507	1154	2437	929	74438	720	163	163	9	15	1\n8	6	20	7	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n8	6	20	1	160	1417	1140	6180	6503	13802	3655	19591	1778	125088	200	1241	45	896	670	7	52	1\n8	6	21	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27\n8	6	21	1	7	24	162	46	2651	2866	33194	31414	2597	9979	2872	7597	60014	200	85	296	138	13	95\n8	6	22	10	12	13	14	15	16	17	18	19	20	21	22	24	25\n8	6	22	2	1	7	377	1265	225	1259	22	265	1491	125	28155	544	34\n8	6	23	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	35\n8	6	23	19	82	48	231	687	1374	5736	3898	804	570	320	844	1	9384	61	85	1\n8	6	24	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	33	35\n8	6	24	3	23	11	26	81	30	1048	1057	858	3	36819	61	212	58	1	14	1	2	1\n8	6	25	10	13	15	16	17	18	19	20	21	22	23	24	25	26	27	29	32\n8	6	25	1	21	195	1388	933	2902	198	9717	1073	898	3	4518	30747	48	489	13	1\n8	6	26	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n8	6	26	2	9	17	8	102	189	625	640	2268	2095	5305	5125	1921	147	1678	52	9768	155	165	4	22\n8	6	27	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	32\n8	6	27	2	105	25	18429	3485	6119	8232	6794	1	4076	607	980	27075	1	499	1\n8	6	28	18	19	20	21	22	23	24	25	26	27	28	29	30	34	37\n8	6	28	24	699	8662	8297	2620	1	2998	6931	305	169	15405	2	52	57	12\n8	6	29	21	23	24	25	26	27	29	30	32\n8	6	29	7	1	73	34	2	507	8898	1	1\n8	6	30	19	20	21	22	24	25	26	28	30	31	32	34	35	37\n8	6	30	1	1115	241	1143	1608	4825	16	153	4372	1	1	58	1	23\n8	6	31	30	31	32\n8	6	31	1	4	1\n8	6	32	15	16	18	19	20	21	22	23	24	25	26	27	29	30	31	32	34	37\n8	6	32	70	1	218	191	463	481	28	1	3575	2132	3402	983	6349	2	2	7468	122	2\n8	6	33	26	30	32	33\n8	6	33	1	2	2	12\n8	6	34	22	24	25	26	27	28	29	30	32	34	35	37\n8	6	34	13	1975	2790	2166	26	84	4513	88	221	8269	1	101\n8	6	35	22	33	35\n8	6	35	1	1	7\n8	6	36	36\n8	6	36	2\n8	6	37	16	21	22	23	24	25	26	28	29	30	32	34	35	37\n8	6	37	3	4	110	1	223	1311	689	13	1160	30	5	165	3	3512\n8	6	38	37	39\n8	6	38	1	1\n8	6	39	39\n8	6	39	1\n8	6	40	40\n8	6	40	1\n8	7	0	0\n8	7	0	132\n8	7	6	6	29\n8	7	6	44971	1\n8	7	7	6	7	10	13	18	22	23	25\n8	7	7	1	29064	37	1	4	1	1	1\n8	7	8	7	8	9	10	12	13	15	27\n8	7	8	589	51544	3	4	5	41	37	1\n8	7	9	6	7	8	9	10	11	12	13	23	25	27	28\n8	7	9	2228	752	842	76729	526	53	20	70	2	1	2	1\n8	7	10	6	7	8	9	10	11	12	13	14	16	32\n8	7	10	1	124	388	960	61412	131	32	115	2	6	1\n8	7	11	6	8	9	10	11	12	13	14	15	16	17	19\n8	7	11	9	499	1074	792	819977	8874	1579	10	282	54	1	1\n8	7	12	6	7	8	9	10	11	12	13	14	15	16	17	18	19\n8	7	12	2	18	386	848	1588	21055	360154	2727	6803	706	225	31	45	1\n8	7	13	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22\n8	7	13	18	3	258	478	479	3134	6991	566642	3087	3417	820	154	132	1	1	1\n8	7	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24\n8	7	14	3	120	431	1393	24693	10807	695316	2276	1919	418	1108	667	1772	1	5	4\n8	7	15	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22\n8	7	15	13	8	133	64	125	1088	3718	14787	21181	477517	4449	319	912	649	2475	168	1\n8	7	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	27\n8	7	16	4	1	19	127	610	1317	3916	8623	143063	499	941	203	716	41	1	1\n8	7	17	6	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	26\n8	7	17	2	29	55	20	693	475	2933	2538	6427	21105	485	60	50	60	5	14	1\n8	7	18	6	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	27\n8	7	18	1	6	28	29	188	362	1677	3597	10922	2962	131461	712	876	132	26	34	6\n8	7	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24\n8	7	19	11	1942	175	15892	7516	1067	731	1161	58409	917	182	220	4	22\n8	7	20	8	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27\n8	7	20	1	159	94	2408	2891	2924	1533	4703	1848	151999	391	1676	21	1151	805	4	22\n8	7	21	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27\n8	7	21	9	2	13	207	605	8091	12019	824	5292	2494	8575	47128	200	39	481	129	1	35\n8	7	22	13	14	15	16	17	18	19	20	21	22	24	25	26\n8	7	22	3	142	596	180	500	25	203	1699	123	39875	797	32	1\n8	7	23	11	12	13	14	15	16	17	18	19	20	21	23	24	26	28\n8	7	23	21	4	40	77	330	2765	1261	164	66	80	173	4671	13	17	1\n8	7	24	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n8	7	24	15	1	75	82	26	1062	1327	952	1	55215	69	340	109	1	127\n8	7	25	15	16	17	18	19	20	21	22	24	25	26	27	28	29\n8	7	25	26	155	131	624	19	5679	332	1742	4353	36464	52	725	3	29\n8	7	26	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n8	7	26	3	14	148	92	512	349	1202	863	329	33	735	35	13265	63	54	3	13\n8	7	27	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n8	7	27	25	9	4790	824	1274	2179	1310	2	848	642	262	16655	4	793\n8	7	28	17	18	19	20	21	22	24	25	26	27	28	30	34	37\n8	7	28	1	4	149	2609	1985	617	605	1637	77	83	7983	21	53	2\n8	7	29	21	24	25	26	27	29\n8	7	29	17	81	38	1	638	20677\n8	7	30	20	21	22	24	25	26	27	28	30	31	34	37\n8	7	30	431	65	416	566	960	2	3	68	2026	1	25	7\n8	7	31	27	28	30	31\n8	7	31	1	1	2	4\n8	7	32	18	19	20	21	22	24	25	26	27	29	30	31	32	34\n8	7	32	93	20	158	53	10	890	466	619	173	1464	1	2	3682	70\n8	7	33	26	27	30	31	32	33\n8	7	33	2	1	1	1	4	6\n8	7	34	22	24	25	26	27	28	29	30	32	34	37\n8	7	34	6	819	748	614	11	46	1457	37	108	4777	48\n8	7	35	19	28	33	35\n8	7	35	1	1	4	8\n8	7	36	36\n8	7	36	2\n8	7	37	16	21	22	23	24	25	26	28	29	30	32	34	37\n8	7	37	3	1	60	1	162	444	321	7	652	17	4	88	1891\n8	7	39	37	39\n8	7	39	1	1\n8	7	40	40\n8	7	40	1\n9	1	0	0\n9	1	0	90\n9	1	6	6	9\n9	1	6	26677	2804\n9	1	7	7	8	9	10	12\n9	1	7	15854	255	656	118	16\n9	1	8	7	8	9	10	11	12	13	16\n9	1	8	48	28546	645	406	245	531	198	1\n9	1	9	6	7	8	9	10	11	12	13	14	15	16\n9	1	9	8	30	102	41580	286	657	496	260	48	50	5\n9	1	10	7	8	9	10	11	12	13	14	15	16	18\n9	1	10	16	40	361	36065	417	1750	192	270	77	12	1\n9	1	11	8	9	10	11	12	13	14	15	16	17	23\n9	1	11	5	80	253	403741	5450	812	371	245	71	1	53\n9	1	12	9	10	11	12	13	14	15	16	18	21	23	24\n9	1	12	23	67	9566	377429	1261	1068	576	21307	4	1194	14	1\n9	1	13	8	9	10	11	12	13	14	15	16	17	18	21	23	27\n9	1	13	26	55	34	624	1609	287356	1921	3616	376	13	57	1951	58	1\n9	1	14	10	11	12	13	14	15	16	17	18	20	21	23	27	28\n9	1	14	1	81	362	1788	258626	943	1921	3	68	30	10	221	2	1\n9	1	15	11	12	13	14	15	16	17	18	19	20	21	23	30\n9	1	15	216	495	5269	533	207810	3113	111	107	8	285	2865	256	1\n9	1	16	11	12	13	14	15	16	17	18	19	20	21	23	27	28	37\n9	1	16	41	182	654	4590	7355	261245	97	262	11	7752	17949	12889	1	1	313\n9	1	17	12	13	14	15	16	17	18	19	20	21	22	23	37\n9	1	17	1	89	16	476	317	15947	35	3	4	522	2	2206	122\n9	1	18	12	13	14	15	16	17	18	19	20	21	22	23	32	33	37\n9	1	18	1	468	355	328	456	71	16024	3	5	1594	5	350	2	1	153\n9	1	19	14	15	16	17	18	19	20	21	22	23	25	27	28	30\n9	1	19	4	6	4	10	11	231	6	21	3	16	6	2	1	1\n9	1	20	11	13	14	15	16	17	18	19	20	21	22	23	25	27\n9	1	20	1	3	2	764	341	18	22	23	25572	247	9	385	6	1\n9	1	21	14	15	16	17	18	19	20	21	22	23	25	27	28	31	37\n9	1	21	1	124	95	38	7	1	916	45834	10	5519	5	1	2	1	681\n9	1	22	13	18	19	20	21	22	23	24	25	26	27	28	30	31\n9	1	22	1	5	1	37	6	93	12	2	9	1	2	5	1	1\n9	1	23	14	15	16	17	18	19	20	21	22	23	25	27	28	31	32	37\n9	1	23	2	3	9	1	7	11	68	39	7	21964	9	2	22	1	1	29\n9	1	24	13	16	20	22	24	25	26\n9	1	24	2	1	1	1	9	1	1\n9	1	25	18	19	20	21	22	23	24	25	26	27	28	29	31\n9	1	25	1	2	1	3	4	27	1	114	2	1	22	1	10\n9	1	26	20	22	23	25	26	27	28	31	32\n9	1	26	1	11	7	16	56	2	8	11	1\n9	1	27	22	23	24	27	29	30	32\n9	1	27	8	1	2	11	1	3	2\n9	1	28	22	23	26	27	28	29	30	33	34	37\n9	1	28	3	18	8	2	57	1	5	1	1	1\n9	1	29	25	26	28	29\n9	1	29	1	2	1	6\n9	1	30	12	28	29	30	31	32	37\n9	1	30	1	1	1	24	1	2	1\n9	1	31	23	28	29	31\n9	1	31	3	12	1	84\n9	1	32	30	32\n9	1	32	1	11\n9	1	33	29	34\n9	1	33	1	1\n9	1	34	14	34\n9	1	34	1	3\n9	1	35	35\n9	1	35	5\n9	1	36	25	36	37\n9	1	36	1	2	1\n9	1	37	20	23	30	37\n9	1	37	1	295	1	2039\n9	1	39	39\n9	1	39	2\n9	1	40	26	31	40\n9	1	40	1	6	4\n9	2	0	0\n9	2	0	90\n9	2	6	6	9\n9	2	6	25126	1559\n9	2	7	7	8	9	10	12	22\n9	2	7	15204	287	284	101	71	1\n9	2	8	7	8	9	10	11	12	13	16	30\n9	2	8	54	27444	301	223	292	573	79	7	1\n9	2	9	6	7	8	9	10	11	12	13	14	15	16\n9	2	9	12	37	111	44455	210	367	489	227	136	141	19\n9	2	10	7	8	9	10	11	12	13	14	15	16	18	23\n9	2	10	8	40	295	35336	160	908	124	235	81	38	1	4\n9	2	11	9	10	11	12	13	14	15	16	17	19	20	21	22	23\n9	2	11	75	239	403610	8862	1115	997	360	230	1	2	38	32	1	27\n9	2	12	9	10	11	12	13	14	15	16	17	18	20	21	23\n9	2	12	22	64	7880	322215	1472	1992	846	51408	1	7	85	2315	16\n9	2	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n9	2	13	20	28	29	425	1349	282456	3434	6552	410	16	69	6	164	3312	83\n9	2	14	10	11	12	13	14	15	16	17	18	19	20	21	23\n9	2	14	2	58	304	1291	260629	1510	3044	5	61	5	365	191	343\n9	2	15	11	12	13	14	15	16	17	18	19	20	21	23	28\n9	2	15	129	324	3850	572	203240	2859	103	96	6	1013	9759	421	1\n9	2	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	37\n9	2	16	1	19	159	478	3289	4655	213634	108	180	19	23779	23491	1	19268	193\n9	2	17	13	14	15	16	17	18	19	20	21	23	24	28	37\n9	2	17	68	14	318	332	13244	25	3	4	251	1986	1	1	63\n9	2	18	13	14	15	16	17	18	19	20	21	22	23	37\n9	2	18	330	281	351	316	44	11855	4	8	2596	9	737	80\n9	2	19	13	14	15	16	17	18	19	20	21	22	23	25\n9	2	19	1	5	6	4	11	19	185	2	32	1	23	5\n9	2	20	11	13	14	15	16	17	18	19	20	21	22	23	25	26	28	29	30\n9	2	20	2	1	2	566	369	12	27	11	32793	232	15	634	10	2	1	1	1\n9	2	21	13	14	15	16	17	18	19	20	21	22	23	25	26	27	28	31	37\n9	2	21	1	2	178	82	30	2	3	625	63211	4	7508	8	1	1	12	1	566\n9	2	22	17	18	19	20	21	22	23	24	25	28	29	32\n9	2	22	1	8	1	18	7	99	7	2	5	5	2	1\n9	2	23	14	15	16	17	18	19	20	21	22	23	25	28	31	37\n9	2	23	5	9	13	2	4	10	117	53	9	43955	13	29	8	67\n9	2	24	14	21	22	24\n9	2	24	1	1	2	11\n9	2	25	21	22	23	24	25	26	28	29	30	31\n9	2	25	3	1	21	3	91	3	27	1	1	17\n9	2	26	21	22	23	24	25	26	27	28	30	31\n9	2	26	1	15	3	1	5	25	4	3	1	13\n9	2	27	22	23	25	27	28	29	30	32\n9	2	27	4	2	1	13	2	1	3	2\n9	2	28	22	23	25	26	27	28	29	30	31	35\n9	2	28	1	23	1	1	4	93	4	2	3	1\n9	2	29	25	27	29	30	32	33\n9	2	29	1	1	7	1	1	1\n9	2	30	28	29	30	32\n9	2	30	2	2	31	2\n9	2	31	23	24	25	26	28	30	31\n9	2	31	1	1	1	1	16	1	94\n9	2	32	28	30	32	33\n9	2	32	1	2	14	2\n9	2	33	35	37\n9	2	33	1	1\n9	2	34	31	34\n9	2	34	2	3\n9	2	35	35\n9	2	35	5\n9	2	36	36\n9	2	36	2\n9	2	37	23	29	30	37\n9	2	37	317	1	1	3021\n9	2	39	39\n9	2	39	2\n9	2	40	31	40\n9	2	40	1	3\n9	3	0	0\n9	3	0	90\n9	3	6	6	15\n9	3	6	25137	1\n9	3	7	7	10\n9	3	7	15300	3\n9	3	8	7	8	13\n9	3	8	39	27854	9\n9	3	9	6	7	8	9	10	11	12	13	19\n9	3	9	19	37	97	46754	82	11	5	13	1\n9	3	10	7	8	9	10	11	12	13	14	17\n9	3	10	10	43	267	35844	15	12	12	1	1\n9	3	11	8	9	10	11	12	13	14	15	16	18\n9	3	11	5	90	242	409904	2445	187	4	55	7	3\n9	3	12	8	9	10	11	12	13	14	15	16	19\n9	3	12	9	38	81	7005	327518	213	68	113	208	1\n9	3	13	8	9	10	11	12	13	14	15	16	17	18	19	20\n9	3	13	13	20	10	445	1286	288081	245	1169	147	6	66	4	1\n9	3	14	10	11	12	13	14	15	16	17	18	19	21	24	29\n9	3	14	2	81	340	1185	268583	94	1253	2	49	1	1	2	1\n9	3	15	11	12	13	14	15	16	17	18	19	20	22\n9	3	15	137	308	3117	673	212573	1571	134	96	4	199	1\n9	3	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23\n9	3	16	1	21	374	405	2681	4063	264784	121	185	1	82	41	2	4\n9	3	17	12	13	14	15	16	17	18	19	21	22	23	27	30\n9	3	17	1	60	15	268	332	12872	13	3	8	1	3	1	1\n9	3	18	9	10	12	13	14	15	16	17	18	20	21	23	24	26\n9	3	18	1	4	4	241	187	348	373	49	11141	2	1	1	1	1\n9	3	19	11	13	14	15	16	17	18	19	20	24\n9	3	19	2	5	7	20	55	9	8	147	1	1\n9	3	20	11	13	14	15	16	17	18	19	20	21	22\n9	3	20	1	1	10	419	379	8	14	10	57992	176	1\n9	3	21	11	13	14	15	16	17	18	19	20	21	22	24	28\n9	3	21	3	3	4	354	199	28	9	63	545	104275	2	1	1\n9	3	22	11	12	15	16	17	18	19	20	21	22	23	24	25	26	27\n9	3	22	1	1	1	5	4	31	5	35	4	68	3	1	2	1	1\n9	3	23	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	28	33	37\n9	3	23	1	2	1	9	19	36	3	8	43	331	49	20	74741	1	3	2	3	1	106\n9	3	24	11	22	23	24	25	27	28	29\n9	3	24	2	2	1	9	1	1	2	1\n9	3	25	11	19	20	21	22	23	24	25	26\n9	3	25	3	3	2	5	9	30	3	85	1\n9	3	26	11	16	19	21	22	23	25	26	30\n9	3	26	1	1	1	2	4	1	4	18	1\n9	3	27	14	20	21	22	23	24	25	26	27	28	30\n9	3	27	1	1	1	3	3	2	2	5	2	1	2\n9	3	28	19	20	21	22	23	25	26	27	28	29	30	31\n9	3	28	3	18	3	28	59	35	5	2	34	1	4	1\n9	3	29	17	19	21	22	25	26	27	28	29	30	32\n9	3	29	1	2	1	1	2	4	1	1	3	2	1\n9	3	30	18	21	22	24	25	26	27	28	29	30	32	36\n9	3	30	1	1	1	1	2	4	1	8	1	21	3	1\n9	3	31	22	23	25	26	28	31\n9	3	31	2	30	32	14	6	55\n9	3	32	21	28	32	33	35\n9	3	32	1	2	15	1	1\n9	3	33	30	32	33\n9	3	33	1	1	1\n9	3	34	31	34\n9	3	34	1	2\n9	3	35	21	25	26	34	35\n9	3	35	1	1	1	1	3\n9	3	36	36\n9	3	36	2\n9	3	37	20	23	28	29	37	39\n9	3	37	1	391	1	1	3596	1\n9	3	39	38	40\n9	3	39	1	1\n9	3	40	31	40\n9	3	40	1	2\n9	4	0	0\n9	4	0	90\n9	4	6	6	7	8	9	15\n9	4	6	25151	1	1	2	1\n9	4	7	7	8	9	10	12	14	15\n9	4	7	15363	6	9	2	4	1	1\n9	4	8	7	8	9	10	12	13	14\n9	4	8	54	27942	10	2	3	7	3\n9	4	9	6	7	8	9	10	11	12	13	14\n9	4	9	14	41	112	46907	69	6	7	9	5\n9	4	10	7	8	9	10	11	12	13	14\n9	4	10	8	39	242	35947	14	7	11	1\n9	4	11	8	9	10	11	12	13	14	15	16	18\n9	4	11	5	76	207	414281	2744	234	9	54	22	1\n9	4	12	8	9	10	11	12	13	14	15	16	17\n9	4	12	3	33	81	6195	325362	203	62	137	219	1\n9	4	13	8	9	10	11	12	13	14	15	16	17	18	19	20\n9	4	13	4	49	15	331	1291	290140	258	1211	155	6	71	1	1\n9	4	14	9	11	12	13	14	15	16	17	18	20	22\n9	4	14	1	76	362	1153	269414	144	1261	2	73	1	1\n9	4	15	9	11	12	13	14	15	16	17	18	19	20	21	24\n9	4	15	1	92	249	2854	613	213468	1775	134	85	1	223	1	1\n9	4	16	9	11	12	13	14	15	16	17	18	20	21\n9	4	16	2	14	434	290	2349	3721	262011	184	180	123	42\n9	4	17	9	12	13	14	15	16	17	18	21	27\n9	4	17	1	7	48	9	226	262	12655	16	13	1\n9	4	18	9	10	12	13	14	15	16	17	18	20	22\n9	4	18	2	1	2	182	142	319	351	55	10566	3	1\n9	4	19	9	12	13	14	15	16	17	18	19	23	27	28\n9	4	19	2	2	1	5	8	6	4	9	251	2	1	1\n9	4	20	9	12	13	14	15	16	17	18	19	20	21	22\n9	4	20	3	6	3	3	338	329	11	25	24	58241	225	2\n9	4	21	13	14	15	16	17	18	19	20	21	22\n9	4	21	1	10	369	165	22	4	13	506	103479	1\n9	4	22	9	12	13	16	17	18	19	20	21	22	23	24	27\n9	4	22	1	1	1	1	5	1	5	29	10	88	1	1	1\n9	4	23	10	12	14	15	16	17	18	19	20	21	22	23	25	26	27	37\n9	4	23	4	1	13	19	28	10	3	31	250	51	8	74710	1	1	1	136\n9	4	24	10	12	17	18	21	22	23	24	26	30	31	32\n9	4	24	1	1	1	2	1	2	1	8	1	2	1	1\n9	4	25	16	18	19	20	21	22	23	25	26	28	29	30	31\n9	4	25	1	1	20	15	3	2	25	96	2	1	1	1	1\n9	4	26	17	19	20	22	25	26	31\n9	4	26	2	1	1	9	8	31	2\n9	4	27	22	24	27	33\n9	4	27	4	1	4	2\n9	4	28	23	24	25	26	27	28	30	37\n9	4	28	8	1	2	1	4	40	2	1\n9	4	29	14	22	29	30	32\n9	4	29	1	1	4	1	1\n9	4	30	10	16	20	22	27	28	30	32	33\n9	4	30	1	1	1	2	2	3	20	1	1\n9	4	31	14	25	26	27	28	31\n9	4	31	1	1	2	1	4	49\n9	4	32	24	25	27	29	30	31	32	33\n9	4	32	1	1	1	1	2	1	12	1\n9	4	33	32	33\n9	4	33	1	2\n9	4	34	34\n9	4	34	3\n9	4	35	35\n9	4	35	4\n9	4	36	33	36\n9	4	36	1	2\n9	4	37	20	23	28	37\n9	4	37	1	275	1	3425\n9	4	38	37\n9	4	38	1\n9	4	39	39\n9	4	39	1\n9	4	40	31	40\n9	4	40	1	2\n9	5	0	0\n9	5	0	90\n9	5	6	6	7	8	9\n9	5	6	25137	10	15	3\n9	5	7	7	8	9	11\n9	5	7	15409	44	8	6\n9	5	8	7	8	9	10	11	13\n9	5	8	85	27988	13	2	20	4\n9	5	9	6	7	8	9	10	11	13\n9	5	9	20	46	259	46843	106	50	17\n9	5	10	7	8	9	10	11	12	13	15	16	21\n9	5	10	10	69	247	35967	25	4	5	1	1	1\n9	5	11	7	8	9	10	11	12	13	14	15	16	18\n9	5	11	23	162	120	216	417287	2762	262	71	54	51	1\n9	5	12	7	8	9	10	11	12	13	14	15	16	17	18\n9	5	12	5	48	30	78	5599	323999	239	88	127	230	12	28\n9	5	13	7	8	9	10	11	12	13	14	15	16	17	18\n9	5	13	22	857	263	18	697	1296	290245	241	1254	165	9	70\n9	5	14	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22\n9	5	14	1	37	29	1	181	322	1142	269535	134	1418	7	74	11	5	1	1\n9	5	15	7	8	9	11	12	13	14	15	16	17	18	19	20	21\n9	5	15	1	34	8	124	310	2539	664	213913	1878	187	121	2	231	4\n9	5	16	8	9	11	12	13	14	15	16	17	18	19	20	21	22\n9	5	16	347	30	94	451	311	1940	3307	259469	229	203	5	156	43	2\n9	5	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	27\n9	5	17	14	12	37	10	71	12	202	219	12464	22	2	9	12	5	1\n9	5	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	28\n9	5	18	14	11	1	20	7	211	114	302	309	20	9987	11	9	11	9	1\n9	5	19	8	9	10	11	13	14	15	17	18	19	20	21	22	23	29\n9	5	19	114	29	1	49	19	3	9	3	5	105	3	2	2	2	1\n9	5	20	8	9	11	13	14	15	16	17	18	19	20	21	22	26	30\n9	5	20	141	22	31	56	2	285	256	5	1	11	58342	234	7	1	1\n9	5	21	8	9	10	11	12	13	14	15	16	17	18	20	21	22	23	24	27	28\n9	5	21	9	8	1	19	1	40	3	346	176	30	4	439	102741	3	1	1	1	2\n9	5	22	8	9	10	11	13	14	16	17	18	19	20	21	22	26\n9	5	22	29	4	1	2	25	5	1	4	2	4	2	9	25	8\n9	5	23	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	26	27	37\n9	5	23	41	35	2	35	116	12	25	24	13	2	2	230	45	2	74310	3	1	124\n9	5	24	12	14	15	22	24	25	27\n9	5	24	1	1	1	4	3	1	2\n9	5	25	8	9	10	11	12	13	15	16	17	18	22	25	29\n9	5	25	4	12	9	12	3	32	2	1	23	1	1	8	1\n9	5	26	10	11	14	16	17	19	23	26	27	29	33	35	36\n9	5	26	6	1	2	1	15	1	1	6	1	1	1	1	1\n9	5	27	15	23	24	26	27	28	29	30\n9	5	27	1	1	2	1	7	1	1	2\n9	5	28	8	9	11	12	13	17	18	21	22	24	26	27	28	29	30	33	37\n9	5	28	2	1	1	1	15	8	1	1	1	2	2	1	7	2	3	1	1\n9	5	29	15	21	25	27	29	32\n9	5	29	1	1	1	1	1	1\n9	5	30	23	26	30	32	33\n9	5	30	1	1	22	3	1\n9	5	31	10	13	17	25	28	33\n9	5	31	5	7	40	1	1	1\n9	5	32	27	30	32	33\n9	5	32	1	1	13	1\n9	5	33	33	35	37\n9	5	33	4	2	1\n9	5	34	24	25	29\n9	5	34	1	1	1\n9	5	35	35\n9	5	35	4\n9	5	36	17	36\n9	5	36	1	1\n9	5	37	23	35	37\n9	5	37	246	2	3315\n9	5	39	39\n9	5	39	1\n9	5	40	40\n9	5	40	2\n9	6	0	0\n9	6	0	90\n9	6	6	6	7	9\n9	6	6	25151	5	1\n9	6	7	7	9	10	22\n9	6	7	15608	2	1	1\n9	6	8	7	8	9	10	12	13\n9	6	8	79	30133	4	2	6	4\n9	6	9	6	7	8	9	10	11	12	13	15	25\n9	6	9	24	65	115	47340	153	10	4	15	1	1\n9	6	10	7	8	9	10	11	12	13	14	16	18\n9	6	10	8	48	257	36053	29	8	7	1	2	1\n9	6	11	6	7	8	9	10	11	12	13	14	15	16	18	19	20\n9	6	11	1	76	1	85	268	420302	3034	378	30	71	39	3	1	1\n9	6	12	7	8	9	10	11	12	13	14	15	16	17	18	19	21	23\n9	6	12	37	1	33	84	5065	323151	227	126	159	271	7	2	2	1	1\n9	6	13	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21	28	30\n9	6	13	3	217	16	39	20	334	1246	291711	234	1302	166	12	52	1	1	1	1\n9	6	14	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	26\n9	6	14	49	1	23	4	85	300	1136	269223	151	1626	15	65	1	2	8	2	1	1\n9	6	15	7	9	10	11	12	13	14	15	16	17	18	20	21\n9	6	15	56	8	1	79	177	2321	691	213913	2119	202	117	278	2\n9	6	16	7	9	11	12	13	14	15	16	17	18	19	20	21\n9	6	16	6	5	12	529	232	1835	3000	257909	295	188	3	153	32\n9	6	17	7	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	26	28\n9	6	17	5	4	1	4	42	11	166	216	12563	25	1	1	24	3	1	1	1	1\n9	6	18	7	9	11	12	13	14	15	16	17	18	19	21	22	23	25\n9	6	18	6	6	8	1	133	97	276	278	28	9677	3	4	3	1	1\n9	6	19	7	9	10	11	13	14	15	17	18	19	21	24	35\n9	6	19	65	25	2	1	1	6	2	5	5	38	2	1	1\n9	6	20	7	9	10	13	15	16	17	18	19	20	21	23	29	30\n9	6	20	8	7	5	2	273	244	8	14	1	58614	246	1	1	2\n9	6	21	7	9	11	13	14	15	16	17	18	19	20	21	22	23	25	26	28\n9	6	21	2	3	1	1	4	362	141	17	1	1	409	102155	4	1	1	1	1\n9	6	22	10	14	15	18	19	20	22\n9	6	22	3	2	1	3	1	2	50\n9	6	23	10	11	13	14	15	16	17	20	21	22	23	37\n9	6	23	3	1	1	16	24	19	8	213	38	1	74117	121\n9	6	24	10	16	21	22	24	27\n9	6	24	1	1	1	1	4	1\n9	6	25	9	10	25	27\n9	6	25	5	2	4	1\n9	6	26	20	21	22	24	26\n9	6	26	2	4	7	2	7\n9	6	27	10	12	14	24	26	27	28	30\n9	6	27	1	1	1	2	3	5	2	1\n9	6	28	23	24	25	26	27	28\n9	6	28	1	1	1	1	3	5\n9	6	29	16	26	29	30\n9	6	29	1	2	4	1\n9	6	30	23	27	28	30\n9	6	30	1	2	2	24\n9	6	32	30	32	33\n9	6	32	4	12	1\n9	6	33	27	32	33	35\n9	6	33	1	1	6	1\n9	6	35	33	35\n9	6	35	2	7\n9	6	36	36\n9	6	36	2\n9	6	37	23	28	37\n9	6	37	238	1	3202\n9	6	39	39\n9	6	39	1\n9	6	40	17	40\n9	6	40	1	1\n9	7	0	0\n9	7	0	90\n9	7	6	6\n9	7	6	25179\n9	7	7	6	7	8	9	10	18	21	25\n9	7	7	1	16281	1	2	3	2	1	1\n9	7	8	6	7	8	9	11	13	15	27\n9	7	8	3	610	29686	4	2	8	1	1\n9	7	9	6	7	8	9	10	11	12	13	15	22	25	28\n9	7	9	2911	784	871	42955	198	110	2	12	1	1	1	1\n9	7	10	7	8	9	10	11	12	13	14	16	32\n9	7	10	193	469	628	35235	50	10	16	1	1	1\n9	7	11	6	8	9	10	11	12	13	14	15	16	19	25\n9	7	11	15	878	953	547	419792	3388	290	3	53	10	1	1\n9	7	12	6	7	8	9	10	11	12	13	14	15	16	17	18\n9	7	12	11	223	1039	1114	1742	17380	306218	350	147	167	64	1	1\n9	7	13	6	8	9	10	11	12	13	14	15	16	17	18	23	28\n9	7	13	45	317	637	315	2341	3540	287123	326	1280	210	25	50	1	1\n9	7	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n9	7	14	2	323	666	2554	3791	6515	256373	194	1773	11	65	2	2	6\n9	7	15	6	8	9	10	11	12	13	14	15	16	17	18	20	21	22\n9	7	15	21	2	310	237	860	2076	14547	3251	195347	2406	220	102	316	5	1\n9	7	16	6	8	9	10	11	12	13	14	15	16	17	18	20	21	22	23\n9	7	16	2	16	58	104	484	64455	782	5328	5323	185771	323	173	194	17	1	1\n9	7	17	6	9	10	11	12	13	14	15	16	17	18	21	23\n9	7	17	2	2	10	8	6	32	8	152	174	12694	21	51	1\n9	7	18	6	9	10	11	12	13	14	15	16	17	18	19	20	23\n9	7	18	3	5	2	2	11	151	115	229	323	38	9265	5	3	1\n9	7	19	13	14	15	17	18	19	20	21	23\n9	7	19	4	2	7	2	4	29	1	1	2\n9	7	20	11	12	13	14	15	16	17	18	19	20	21	22\n9	7	20	73	199	315	675	1637	30446	8	7	5	25973	334	4\n9	7	21	6	11	12	13	14	15	16	17	18	19	20	21	22\n9	7	21	4	88	3080	5676	337	16354	33084	452	3297	1	426	39716	3\n9	7	22	11	13	14	15	16	17	18	19	20	21	22	26\n9	7	22	2	1	1	3	4	5	2	8	5	9	31	1\n9	7	23	10	11	12	13	14	15	16	17	18	20	21	22	23	24	26	28	37\n9	7	23	27	59	49	149	577	751	33066	4437	1236	1290	11759	1	20913	1	1	1	46\n9	7	24	12	21	24	25	27	28\n9	7	24	1	4	2	1	1	2\n9	7	25	15	18	21	22	25	36\n9	7	25	1	2	1	1	2	1\n9	7	26	17	19	20	21	22	26	27\n9	7	26	1	1	1	2	4	6	1\n9	7	27	21	23	24	25	26	27\n9	7	27	1	1	2	1	2	6\n9	7	28	19	27	28	31\n9	7	28	1	2	9	1\n9	7	29	26	29\n9	7	29	2	3\n9	7	30	27	28	30	31	32\n9	7	30	1	5	22	3	2\n9	7	32	32	33\n9	7	32	9	4\n9	7	33	26	33	34	35	36	37\n9	7	33	1	4	1	1	1	1\n9	7	35	33	35	38\n9	7	35	1	7	1\n9	7	36	36\n9	7	36	2\n9	7	37	16	17	18	21	23	37\n9	7	37	485	169	158	1007	87	1417\n9	7	39	38\n9	7	39	1\n9	7	40	40\n9	7	40	1\n9	8	0	0\n9	8	0	90\n9	8	6	6	13	18	23\n9	8	6	28192	1	3	1\n9	8	7	7	9	10	17\n9	8	7	18045	15	30	1\n9	8	8	7	8	10	12	13\n9	8	8	447	32790	4	3	37\n9	8	9	6	7	8	9	10	11	12	13	17	21\n9	8	9	1440	425	678	44007	347	19	15	58	1	1\n9	8	10	7	8	9	10	11	12	13	16\n9	8	10	90	280	553	38043	70	15	33	2\n9	8	11	6	7	8	9	10	11	12	13	14	15	16	25\n9	8	11	3	1	427	854	465	436434	4890	578	7	120	25	1\n9	8	12	6	7	8	9	10	11	12	13	14	15	16\n9	8	12	3	12	371	492	1058	11488	372438	441	115	329	79\n9	8	13	6	8	9	10	11	12	13	14	15	16	17	18	31\n9	8	13	13	133	381	264	1512	3363	306969	779	2108	307	61	80	1\n9	8	14	6	9	10	11	12	13	14	15	16	17	18	21	22\n9	8	14	1	77	317	672	1808	3469	257835	257	2585	32	76	14	1\n9	8	15	6	9	10	11	12	13	14	15	16	17	18	20	21\n9	8	15	4	50	114	362	927	9819	1995	203159	4052	390	105	516	7\n9	8	16	9	10	11	12	13	14	15	16	17	18	20	21\n9	8	16	1	11	98	14084	543	3441	6148	262752	236	262	177	64\n9	8	17	9	10	11	12	13	14	15	16	17	18	19	21\n9	8	17	1	2	6	6	20	12	146	206	17845	26	3	113\n9	8	18	11	12	13	14	15	16	17	18	19\n9	8	18	4	11	170	98	291	423	42	13345	1\n9	8	19	10	11	12	13	14	15	16	17	18	19	22\n9	8	19	1	1	1	3	3	5	6	6	5	21	1\n9	8	20	12	13	14	15	16	17	18	19	20	21	23\n9	8	20	3	3	49	388	5241	9	3	2	21919	593	1\n9	8	21	11	12	13	14	15	16	17	18	19	20	21	22	23	25	28\n9	8	21	3	862	1443	27	3440	12605	505	1326	4	411	32283	1	2	1	1\n9	8	22	11	13	15	16	19	20	21	22	23\n9	8	22	2	1	2	3	5	8	8	17	1\n9	8	23	11	12	13	14	15	16	17	18	20	21	22	23	24	27	37\n9	8	23	10	4	30	75	101	6624	935	301	264	2437	1	10196	2	2	25\n9	8	24	15	17	18	24\n9	8	24	1	1	1	2\n9	8	25	20	23	25\n9	8	25	1	2	4\n9	8	26	21	24	26\n9	8	26	3	2	8\n9	8	27	23	24	25	27\n9	8	27	3	2	1	6\n9	8	28	20	24	25	27	28	30\n9	8	28	1	2	1	2	10	3\n9	8	29	29\n9	8	29	3\n9	8	30	27	28	30	31	32\n9	8	30	2	1	17	1	1\n9	8	31	30	31	33\n9	8	31	1	2	1\n9	8	32	23	30	32	33\n9	8	32	1	1	9	1\n9	8	33	31	32	33	35\n9	8	33	1	1	3	4\n9	8	34	34\n9	8	34	1\n9	8	35	17	33	35\n9	8	35	1	2	5\n9	8	36	23	36\n9	8	36	1	3\n9	8	37	16	17	18	20	21	23	37\n9	8	37	163	71	103	1	366	44	716\n9	8	38	38	39\n9	8	38	1	1\n9	8	40	40\n9	8	40	1\n10	1	0	0\n10	1	0	62\n10	1	6	6	9\n10	1	6	16484	1866\n10	1	7	7	8	9	10	12\n10	1	7	10500	182	390	90	10\n10	1	8	7	8	9	10	11	12	13\n10	1	8	28	18394	354	216	148	355	105\n10	1	9	6	7	8	9	10	11	12	13	14	15\n10	1	9	4	23	67	26837	193	415	331	171	36	29\n10	1	10	7	8	9	10	11	12	13	14	15	18\n10	1	10	7	23	201	22277	253	1000	164	173	67	1\n10	1	11	8	9	10	11	12	13	14	15	16\n10	1	11	5	41	160	257349	3124	535	230	125	23\n10	1	12	8	9	10	11	12	13	14	15	16	18	20	21\n10	1	12	1	17	35	4530	237894	700	587	316	74	5	1	650\n10	1	13	8	9	10	11	12	13	14	15	16	17	18	19	21\n10	1	13	17	24	12	352	1033	177473	1059	2186	172	5	4	4	980\n10	1	14	11	12	13	14	15	16	17	18	20	21	23\n10	1	14	49	196	1287	192789	511	1007	25	17	71	1	1\n10	1	15	11	12	13	14	15	16	17	18	19	20	21	23	25	26\n10	1	15	101	236	2725	320	125666	1279	10	16	6	54	4	1	1	1\n10	1	16	11	12	13	14	15	16	17	19	20	21	22	23	37\n10	1	16	14	59	238	2241	1380	132309	77	7	13932	3	1	1	442\n10	1	17	13	14	15	16	17	18	19	20	21	22	23	37\n10	1	17	41	182	27	133	9508	15	3	908	9	3	4	148\n10	1	18	13	14	15	16	17	18	19	20	21	22	23	32\n10	1	18	7	4	2	9	23	182	2	1	8	6	6	1\n10	1	19	14	15	16	17	18	19	20	21	22	23	25	27	30\n10	1	19	8	25	2	13	20	505	10	26	5	21	15	1	1\n10	1	20	14	15	16	17	18	19	20	21	22	23	25	30	37\n10	1	20	214	37	126	12	6	24	30066	9	7	3	9	1	222\n10	1	21	13	15	17	18	19	20	21	22	23	24	25	26	28\n10	1	21	1	2	19	4	2	5	1596	10	8	2	9	2	1\n10	1	22	14	19	20	21	22	23	24	25	28	31	32\n10	1	22	1	3	12	12	110	6	1	16	4	1	1\n10	1	23	18	19	20	21	22	23	25	28	30	31\n10	1	23	1	6	4	10	2	98	4	3	1	1\n10	1	24	19	20	21	22	23	24	26	27	28\n10	1	24	1	2	4	9	1	33	2	1	1\n10	1	25	19	21	22	23	24	25	28	31\n10	1	25	1	1	3	14	2	148	4	1\n10	1	26	20	21	22	23	24	25	26	27	28	29	30	31\n10	1	26	1	1	1	2	3	4	26	5	2	1	1	7\n10	1	27	22	26	27	28	30	31	32\n10	1	27	6	2	12	1	2	1	1\n10	1	28	23	25	28	29	30	31\n10	1	28	5	1	23	1	3	1\n10	1	29	22	27	28	29	30\n10	1	29	1	1	1	2	1\n10	1	30	26	27	28	29	30	31	32\n10	1	30	1	3	2	1	32	1	4\n10	1	31	25	28	31	32	34	35\n10	1	31	1	1	19	1	1	1\n10	1	32	30	32\n10	1	32	2	11\n10	1	33	33\n10	1	33	2\n10	1	34	30	34	37\n10	1	34	1	1	1\n10	1	35	35	37\n10	1	35	7	1\n10	1	36	36\n10	1	36	4\n10	1	37	12	20	32	35	37\n10	1	37	1	103	2	1	1177\n10	1	39	39	40\n10	1	39	1	1\n10	1	40	31	40\n10	1	40	2	9\n10	2	0	0\n10	2	0	62\n10	2	6	6	9\n10	2	6	15647	841\n10	2	7	7	8	9	10	12	15\n10	2	7	10089	149	212	67	40	1\n10	2	8	7	8	9	10	11	12	13\n10	2	8	22	17748	158	120	203	375	63\n10	2	9	6	7	8	9	10	11	12	13	14	15	20	23\n10	2	9	6	33	63	28709	124	234	299	136	68	56	1	1\n10	2	10	7	8	9	10	11	12	13	14	15\n10	2	10	4	17	202	21857	99	503	79	165	57\n10	2	11	9	10	11	12	13	14	15	16	17	18	19	20	21\n10	2	11	49	177	256768	4719	630	543	261	35	1	1	1	25	1\n10	2	12	9	10	11	12	13	14	15	16	18	19	20	21	28\n10	2	12	16	32	5151	235358	898	947	459	77	3	1	39	1257	1\n10	2	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n10	2	13	12	8	9	296	971	174723	1954	3901	144	8	4	4	62	1351\n10	2	14	11	12	13	14	15	16	17	18	19	20	21	22	27	28	35\n10	2	14	46	216	1018	193719	879	1610	43	18	9	277	5	1	1	1	1\n10	2	15	11	12	13	14	15	16	17	18	19	20	21	22	23\n10	2	15	76	210	2795	355	125414	1103	14	22	9	348	24	1	2\n10	2	16	11	12	13	14	15	16	17	18	19	20	21	25	29	37\n10	2	16	6	48	190	2208	1849	99676	57	4	4	30793	16	1	1	281\n10	2	17	13	14	15	16	17	18	19	20	21	22	23	25	37\n10	2	17	68	163	44	195	7985	12	3	1087	9	7	7	1	111\n10	2	18	11	12	13	14	15	16	17	18	19	20	21	22	23	25\n10	2	18	1	1	7	3	1	5	16	180	7	3	29	6	11	1\n10	2	19	12	14	15	16	17	18	19	20	21	22	23	24	25\n10	2	19	4	5	31	1	19	20	370	8	35	1	47	2	21\n10	2	20	11	14	15	16	17	18	19	20	21	22	23	25	26	30	31	37\n10	2	20	1	255	40	195	5	9	13	44440	11	2	6	32	1	1	1	158\n10	2	21	12	13	16	17	18	19	20	21	22	23	24	25	26	27	29\n10	2	21	1	3	1	15	8	3	14	3202	23	15	2	23	2	1	1\n10	2	22	15	18	19	20	21	22	23	24	25	26\n10	2	22	1	4	2	8	18	93	3	4	28	3\n10	2	23	15	18	19	21	22	23	24	25	26	28\n10	2	23	1	1	2	19	1	134	1	2	1	9\n10	2	24	15	20	21	22	24	29	30\n10	2	24	1	1	3	5	29	1	1\n10	2	25	19	21	22	23	25	26	27	28	31\n10	2	25	1	2	6	22	167	3	4	2	1\n10	2	26	20	23	24	25	26	27	28	30	31\n10	2	26	1	2	1	3	18	1	4	1	3\n10	2	27	20	21	22	23	24	26	27	28	32\n10	2	27	2	1	1	1	1	3	12	1	1\n10	2	28	20	22	23	25	26	27	28	29	30\n10	2	28	1	1	5	1	3	4	24	2	2\n10	2	29	27	28	29	30\n10	2	29	2	1	1	1\n10	2	30	24	26	27	28	29	30	37\n10	2	30	2	2	1	4	1	34	1\n10	2	31	22	25	28	31	32\n10	2	31	1	2	6	24	1\n10	2	32	26	29	30	32	33	34	35	37\n10	2	32	2	1	3	8	4	1	1	1\n10	2	33	32	33\n10	2	33	1	1\n10	2	34	29	31\n10	2	34	1	1\n10	2	35	35\n10	2	35	9\n10	2	36	36\n10	2	36	4\n10	2	37	20	37\n10	2	37	254	1737\n10	2	39	37\n10	2	39	1\n10	2	40	26	31	32	40\n10	2	40	1	3	1	5\n10	3	0	0\n10	3	0	62\n10	3	6	6	8\n10	3	6	15652	1\n10	3	7	7	10\n10	3	7	10144	4\n10	3	8	7	8	13	15\n10	3	8	26	17959	3	1\n10	3	9	6	7	8	9	10	11	12	13\n10	3	9	12	45	66	30030	34	5	1	2\n10	3	10	7	8	9	10	11	12	13	16	23\n10	3	10	3	22	186	22158	9	2	4	1	1\n10	3	11	8	9	10	11	12	13	15	16	17	19\n10	3	11	4	44	156	261382	1164	103	22	3	1	2\n10	3	12	8	9	10	11	12	13	14	15	16	17	19	21\n10	3	12	3	18	42	4332	238116	135	41	35	10	1	1	11\n10	3	13	8	9	10	11	12	13	14	15	16	17	18	21\n10	3	13	4	9	13	232	895	178682	150	571	44	3	1	6\n10	3	14	10	11	12	13	14	15	16	17	19	20	27\n10	3	14	5	65	221	949	198404	54	595	37	1	53	1\n10	3	15	11	12	13	14	15	16	17	18	19	20\n10	3	15	39	156	2039	393	129871	477	7	1	4	9\n10	3	16	11	12	13	14	15	16	17	20\n10	3	16	4	47	144	1593	1740	99383	78	53\n10	3	17	12	13	14	15	16	17	18	19	21	23	26\n10	3	17	1	39	121	32	217	7743	4	2	1	2	1\n10	3	18	8	9	10	12	13	14	15	16	17	18	19	22\n10	3	18	1	1	1	2	7	24	2	15	10	220	2	1\n10	3	19	12	13	14	15	16	17	18	19	20	22	23\n10	3	19	1	3	7	22	21	8	18	346	1	1	1\n10	3	20	13	14	15	16	17	18	19	20	21	22	23	25	27	37\n10	3	20	2	186	38	219	5	6	15	76845	1	2	2	1	1	41\n10	3	21	11	12	13	15	16	17	18	19	20	21	22	23	24	27\n10	3	21	1	2	8	9	31	6	7	23	19	5866	2	7	1	1\n10	3	22	14	15	16	18	19	20	21	22	23\n10	3	22	1	1	1	15	5	11	17	97	1\n10	3	23	11	16	18	19	20	21	22	23	25	26\n10	3	23	1	8	5	14	22	22	2	178	3	1\n10	3	24	11	18	20	22	23	24\n10	3	24	1	1	3	6	1	30\n10	3	25	13	21	22	23	24	25\n10	3	25	1	2	4	27	1	247\n10	3	26	21	22	23	24	25	26	27\n10	3	26	2	4	1	3	3	23	3\n10	3	27	20	22	23	24	25	26	27	31\n10	3	27	1	3	1	2	1	5	12	1\n10	3	28	17	20	22	23	25	26	27	28	29	30	32\n10	3	28	1	1	5	16	6	3	3	15	1	1	1\n10	3	29	26	27	29	30\n10	3	29	2	1	5	1\n10	3	30	21	25	26	27	28	29	30	31	32\n10	3	30	1	4	1	3	2	2	24	1	5\n10	3	31	13	23	25	26	28	31\n10	3	31	1	3	5	3	5	16\n10	3	32	30	32\n10	3	32	4	8\n10	3	33	31	33	34	35\n10	3	33	1	2	1	1\n10	3	34	34\n10	3	34	1\n10	3	35	26	30	35\n10	3	35	1	1	9\n10	3	36	36\n10	3	36	4\n10	3	37	20	27	28	31	35	37\n10	3	37	284	1	2	1	1	2001\n10	3	40	39	40\n10	3	40	1	4\n10	4	0	0\n10	4	0	62\n10	4	6	6	7\n10	4	6	15662	2\n10	4	7	7	10\n10	4	7	10217	1\n10	4	8	7	8	9	12	13	15\n10	4	8	30	18024	1	1	3	1\n10	4	9	6	7	8	9	10	11	12	13\n10	4	9	16	34	60	30127	34	5	5	7\n10	4	10	7	8	9	10	11	13	14\n10	4	10	9	22	182	22188	8	3	1\n10	4	11	8	9	10	11	12	13	14	15	16	18	20\n10	4	11	2	49	156	264520	1198	119	1	22	2	1	1\n10	4	12	8	9	10	11	12	13	14	15	16	18	21\n10	4	12	7	15	40	3608	236716	116	35	59	8	2	2\n10	4	13	8	9	10	11	12	13	14	15	16	17	18	21\n10	4	13	5	44	9	200	891	180109	174	644	31	8	2	5\n10	4	14	10	11	12	13	14	15	16	17	20\n10	4	14	3	55	227	847	198997	69	627	26	69\n10	4	15	9	11	12	13	14	15	16	17	19	20	21\n10	4	15	1	54	151	1560	427	129596	596	4	1	7	1\n10	4	16	9	10	11	12	13	14	15	16	17	18	19	20\n10	4	16	2	1	1	24	99	1233	1579	97909	121	1	1	54\n10	4	17	9	10	12	13	14	15	16	17	18	20	28\n10	4	17	2	4	7	25	110	25	207	7512	6	1	1\n10	4	18	9	10	12	13	14	15	16	17	18	19	20	21	22	24\n10	4	18	3	2	13	10	29	59	8	20	125	3	2	1	2	1\n10	4	19	9	12	13	14	15	16	17	18	19	20	21	22	23	27	28\n10	4	19	4	2	8	8	30	9	7	7	330	3	2	1	2	1	1\n10	4	20	9	12	13	14	15	16	17	18	19	20	21	22	37\n10	4	20	8	16	1	108	30	218	11	8	17	76824	2	1	58\n10	4	21	9	12	13	14	15	16	17	18	19	20	21	28\n10	4	21	6	13	14	32	69	7	25	17	31	12	5702	1\n10	4	22	9	10	15	16	17	18	19	20	21	22	24\n10	4	22	1	4	3	2	36	11	3	9	29	28	1\n10	4	23	10	14	15	17	18	19	20	21	22	23	25	27	28	35\n10	4	23	2	1	21	9	11	89	2	6	3	93	1	1	1	1\n10	4	24	9	10	15	17	18	19	21	22	23	24\n10	4	24	1	3	1	2	2	1	8	4	1	14\n10	4	25	16	17	18	19	20	21	22	23	25	26	29\n10	4	25	1	4	2	83	56	17	31	7	66	2	1\n10	4	26	10	11	17	18	21	22	23	24	25	26\n10	4	26	2	1	2	5	2	7	1	1	4	15\n10	4	27	10	12	16	21	22	23	25	26	27	28	33\n10	4	27	3	1	2	3	3	1	1	1	9	1	1\n10	4	28	10	12	18	23	26	28	30\n10	4	28	1	2	4	1	1	14	1\n10	4	29	27	29	35\n10	4	29	1	6	1\n10	4	30	10	15	16	18	21	22	25	27	28	30	32	37\n10	4	30	2	1	1	1	1	7	2	1	2	11	1	1\n10	4	31	10	28	30	31	33\n10	4	31	1	2	1	15	1\n10	4	32	25	27	31	32	33	38\n10	4	32	1	2	1	8	1	1\n10	4	33	33\n10	4	33	2\n10	4	34	29	34\n10	4	34	1	1\n10	4	35	21	35	37\n10	4	35	1	9	1\n10	4	36	36\n10	4	36	4\n10	4	37	20	37\n10	4	37	187	1855\n10	4	39	37\n10	4	39	1\n10	4	40	40\n10	4	40	4\n10	5	0	0\n10	5	0	62\n10	5	6	6	7	8	9	11\n10	5	6	15634	13	26	4	1\n10	5	7	7	8	9	11	13\n10	5	7	10210	59	11	9	3\n10	5	8	7	8	9	10	11	12	13	14\n10	5	8	49	18029	14	2	20	1	4	1\n10	5	9	6	7	8	9	10	11	12	13\n10	5	9	15	40	182	30084	79	35	2	9\n10	5	10	7	8	9	10	11	12	13\n10	5	10	4	46	187	22187	16	3	13\n10	5	11	7	8	9	10	11	12	13	14	15	16\n10	5	11	14	104	84	144	266583	1338	123	45	14	3\n10	5	12	7	8	9	10	11	12	13	14	15	16	18	21\n10	5	12	5	17	24	38	3135	235757	136	46	86	14	1	8\n10	5	13	7	8	9	10	11	12	13	14	15	16	17	21\n10	5	13	16	332	99	8	289	822	180470	149	686	41	2	7\n10	5	14	8	9	10	11	12	13	14	15	16	17	19	20	21\n10	5	14	23	16	2	119	231	848	199054	76	667	45	3	71	1\n10	5	15	8	9	11	12	13	14	15	16	17	18	19	20	22\n10	5	15	19	4	34	135	1323	393	129627	654	4	4	3	8	1\n10	5	16	8	9	10	11	12	13	14	15	16	17	18	20	21\n10	5	16	119	14	2	17	30	89	1031	1493	96585	156	5	85	2\n10	5	17	8	9	11	12	13	14	15	16	17	18	19	21	23\n10	5	17	5	2	15	5	38	85	31	163	7439	1	1	1	1\n10	5	18	8	9	11	12	13	14	15	16	17	18	19	20	23	28\n10	5	18	15	7	17	6	26	8	11	8	10	92	2	1	1	1\n10	5	19	8	9	11	12	13	14	15	16	17	18	19	20	22	23\n10	5	19	44	7	11	1	10	13	55	3	4	12	392	4	2	1\n10	5	20	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	37\n10	5	20	29	6	5	1	10	97	20	194	11	9	18	76760	3	2	1	61\n10	5	21	8	9	10	11	12	13	14	15	16	17	18	20	21	22	23\n10	5	21	2	3	1	3	12	23	1	4	9	18	8	5	5689	3	1\n10	5	22	8	10	11	12	13	14	16	17	18	20	21	22\n10	5	22	5	1	4	1	3	2	4	1	4	5	6	51\n10	5	23	8	9	11	13	14	15	16	17	18	19	20	21	22	23\n10	5	23	12	9	11	17	1	7	2	13	15	1	1	3	2	12\n10	5	24	17	19	20	22	24\n10	5	24	2	1	2	4	8\n10	5	25	8	9	10	11	13	17	22	23	24	25\n10	5	25	1	1	7	3	5	7	4	2	1	44\n10	5	26	11	12	17	20	21	22	24	26	32	35\n10	5	26	1	1	4	1	1	3	3	3	1	1\n10	5	27	19	20	21	22	25	27	28	30\n10	5	27	1	1	1	1	1	7	1	2\n10	5	28	10	13	15	17	18	20	24	27	28\n10	5	28	3	4	2	3	1	1	1	1	7\n10	5	29	19	21	24	26	29	32\n10	5	29	1	1	1	1	3	1\n10	5	30	19	27	30	32\n10	5	30	1	2	8	2\n10	5	31	8	10	13	17	24	30\n10	5	31	1	1	3	9	1	1\n10	5	32	30	32\n10	5	32	2	7\n10	5	33	33\n10	5	33	5\n10	5	34	34\n10	5	34	1\n10	5	35	12	16	24	33	35	37\n10	5	35	1	1	1	1	6	1\n10	5	36	24	35	36	37\n10	5	36	1	1	1	1\n10	5	37	17	20	21	35	37\n10	5	37	1	142	1	1	1771\n10	5	38	38\n10	5	38	1\n10	5	40	17	38	40\n10	5	40	1	1	2\n10	6	0	0\n10	6	0	62\n10	6	6	6	7\n10	6	6	15628	21\n10	6	7	6	7	9	10\n10	6	7	1	10348	1	1\n10	6	8	7	8	9	13\n10	6	8	102	18965	2	1\n10	6	9	6	7	8	9	10	11	12	13	24\n10	6	9	18	133	72	30247	91	1	4	9	1\n10	6	10	7	8	9	10	11	13	14\n10	6	10	29	31	176	22219	13	6	1\n10	6	11	6	7	8	9	10	11	12	13	14	15	16	18	24\n10	6	11	1	250	6	97	194	267887	1496	199	112	24	58	3	1\n10	6	12	7	8	9	10	11	12	13	14	15	16	17	18	21\n10	6	12	118	1	36	60	2858	234906	125	86	78	29	42	3	5\n10	6	13	6	7	8	9	10	11	12	13	14	15	16	17	18	21	22	23	28\n10	6	13	7	1002	6	123	12	166	776	180147	165	700	39	4	1	6	1	1	1\n10	6	14	7	8	9	10	11	12	13	14	15	16	17	18	20	21	22	25\n10	6	14	114	2	60	15	95	174	784	198709	90	686	80	14	99	1	2	1\n10	6	15	7	9	10	11	12	13	14	15	16	17	18	20	22\n10	6	15	372	50	2	46	107	1179	467	129098	743	27	2	18	1\n10	6	16	7	9	10	11	12	13	14	15	16	17	20	21	26\n10	6	16	11	26	3	1	23	75	855	1238	95828	184	100	3	1\n10	6	17	7	9	10	11	12	13	14	15	16	17	18	20	21	22	23\n10	6	17	24	21	1	5	4	43	53	22	131	7393	4	9	16	3	1\n10	6	18	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	31\n10	6	18	31	24	3	1	3	1	1	1	5	6	58	1	2	4	10	1\n10	6	19	7	9	10	11	12	14	15	19\n10	6	19	267	130	9	2	4	2	1	9\n10	6	20	7	9	10	13	14	15	16	17	18	20	21	22	28	37\n10	6	20	29	24	22	1	73	18	125	5	5	76717	1	1	1	65\n10	6	21	7	9	10	12	13	15	17	18	20	21	22	24\n10	6	21	8	21	8	24	30	13	11	1	1	5594	11	2\n10	6	22	7	9	10	13	14	18	20	21	22	24	25	28	30\n10	6	22	1	4	28	1	1	6	2	1	22	4	1	1	1\n10	6	23	7	9	10	21	22	23\n10	6	23	1	5	3	1	1	8\n10	6	24	12	21	24	25	27\n10	6	24	1	4	10	1	1\n10	6	25	7	9	10	17	21	25\n10	6	25	2	18	21	1	1	2\n10	6	26	14	17	21	26\n10	6	26	1	1	1	1\n10	6	27	12	13	22	27	28	36\n10	6	27	1	1	1	5	1	1\n10	6	28	23	27	28	30\n10	6	28	1	1	6	1\n10	6	29	26	29\n10	6	29	1	2\n10	6	30	17	30	32\n10	6	30	1	11	1\n10	6	32	30	32	33\n10	6	32	1	9	1\n10	6	33	33	35\n10	6	33	5	1\n10	6	34	34\n10	6	34	1\n10	6	35	32	35\n10	6	35	2	7\n10	6	36	36\n10	6	36	1\n10	6	37	20	37\n10	6	37	136	1698\n10	6	38	38\n10	6	38	2\n10	6	40	40\n10	6	40	2\n10	7	0	0\n10	7	0	62\n10	7	6	6\n10	7	6	15655\n10	7	7	6	7	8	9	10	13	18	21	27\n10	7	7	9	12839	3	7	1	1	1	1	1\n10	7	8	6	7	8	9	11	13\n10	7	8	6	35	19028	6	4	4\n10	7	9	6	7	8	9	10	11	12	13	15	16	18	19	24	28\n10	7	9	14	36	65	30644	103	158	5	10	8	1	6	12	2	1\n10	7	10	6	7	8	9	10	11	12	13	14	15	16	18	19	21	23	27\n10	7	10	3	11	29	166	22434	27	2	6	1	1	1	2	2	3	2	2\n10	7	11	6	8	9	10	11	12	13	14	15	16	17	18\n10	7	11	31	9	76	203	268899	1598	205	19	25	8	1	1\n10	7	12	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n10	7	12	12	8	13	49	2463	234596	160	108	87	11	3	1	4	1	6	1\n10	7	13	6	8	9	10	11	12	13	14	15	16	17	18	19	21	28\n10	7	13	115	7	20	11	181	818	180533	157	691	52	6	1	1	8	1\n10	7	14	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	27\n10	7	14	4	25	2	9	83	162	816	198426	78	727	79	22	3	83	2	1	2	1	1\n10	7	15	6	9	10	11	12	13	14	15	16	17	18	19	20	21\n10	7	15	40	13	2	24	83	1042	389	128794	823	24	9	9	29	2\n10	7	16	6	8	10	11	12	13	14	15	16	17	18	19	20	21	22	25\n10	7	16	3	3	3	4	23	56	782	1206	95252	194	1	10	94	7	5	1\n10	7	17	6	9	10	11	12	13	14	15	16	17	18	20	21	22	23	24	27\n10	7	17	14	4	1	3	1	11	51	10	115	7537	1	1	1	1	1	2	1\n10	7	18	6	8	9	11	13	14	15	16	18	19	20	21	22	23	27	28\n10	7	18	11	1	5	4	4	1	2	2	29	11	2	9	7	6	1	2\n10	7	19	8	19	21	29\n10	7	19	1	6	2	1\n10	7	20	10	13	14	15	16	17	19	20	22	37\n10	7	20	1	2	68	17	133	13	1	76768	3	78\n10	7	21	8	9	10	11	12	13	15	16	18	19	20	21	22	24	25	31	35\n10	7	21	1	2	5	2	15	16	2	1	1	1	9	5577	1	1	1	1	2\n10	7	22	18	19	20	21	22	25	27	28	29\n10	7	22	5	1	1	1	38	1	1	4	1\n10	7	23	9	19	21	23	27\n10	7	23	4	1	2	3	1\n10	7	24	22	24	25	26	27\n10	7	24	5	8	2	1	2\n10	7	25	24	25	27\n10	7	25	1	3	1\n10	7	26	26	27	28\n10	7	26	1	1	1\n10	7	27	22	23	24	27	28\n10	7	27	1	2	1	1	2\n10	7	28	24	26	27	28	29\n10	7	28	1	1	1	6	1\n10	7	29	29	30\n10	7	29	1	1\n10	7	30	28	30\n10	7	30	1	13\n10	7	31	30\n10	7	31	1\n10	7	32	21	30	32\n10	7	32	1	2	9\n10	7	33	33	35\n10	7	33	5	1\n10	7	34	32\n10	7	34	1\n10	7	35	33	35	37\n10	7	35	1	6	1\n10	7	36	36	37\n10	7	36	1	1\n10	7	37	20	35	37	39\n10	7	37	136	1	1625	1\n10	7	38	35	38\n10	7	38	1	1\n10	7	40	40\n10	7	40	2\n10	8	0	0\n10	8	0	62\n10	8	6	6	15	17	18	27\n10	8	6	15912	1	1	2	1\n10	8	7	7	9	10	13	15	17	20	23\n10	8	7	12783	128	3	3	1	1	1	1\n10	8	8	6	7	8	13	18	19\n10	8	8	3	499	18672	4	1	1\n10	8	9	6	7	8	9	10	11	12	13	27\n10	8	9	1973	770	547	27498	146	10	5	11	2\n10	8	10	7	8	9	10	11	12	13	15	20\n10	8	10	147	269	402	21955	36	4	7	1	1\n10	8	11	6	8	9	10	11	12	13	14	15	16	17\n10	8	11	7	627	633	403	267796	2146	200	5	28	6	1\n10	8	12	6	7	8	9	10	11	12	13	14	15	16	17	21	27\n10	8	12	3	174	754	755	1111	10969	223091	235	73	112	15	9	1	1\n10	8	13	6	8	9	10	11	12	13	14	15	16	17	18	20	21\n10	8	13	25	199	407	261	1688	2318	176776	234	867	69	17	2	2	1\n10	8	14	6	8	9	10	11	12	13	14	15	16	17	18	20	21\n10	8	14	1	4	229	505	1795	2333	4308	189543	103	976	97	5	102	1\n10	8	15	6	9	10	11	12	13	14	15	16	17	20\n10	8	15	13	216	156	604	1316	10799	2390	114259	1067	48	53\n10	8	16	9	10	11	12	13	14	15	16	17	18	20	22\n10	8	16	2	1	128	201	319	3544	2446	90191	171	10	112	1\n10	8	17	8	9	10	11	12	13	14	15	16	17	18	20	22\n10	8	17	1	3	2	21	2	11	54	19	105	7631	4	2	2\n10	8	18	10	11	12	13	14	15	16	17	18	22\n10	8	18	2	7	7	2	12	10	4	7	27	2\n10	8	19	11	12	13	14	15	16	17	18	19\n10	8	19	3	3	1	3	11	4	1	5	31\n10	8	20	11	12	13	14	15	16	17	18	20	22	23	37\n10	8	20	55	92	155	616	737	44932	2209	2	28302	4	1	19\n10	8	21	12	13	15	16	17	18	19	20	21	22	23	24	26	30\n10	8	21	1709	1984	3	4	4	5	5	4	1896	4	1	1	1	1\n10	8	22	11	13	14	15	16	17	18	19	20	21	22	24	27\n10	8	22	3	2	1	3	3	9	4	4	4	5	22	1	1\n10	8	23	18	19	21	23	24	26\n10	8	23	1	1	2	10	2	1\n10	8	24	19	21	22	24\n10	8	24	1	3	1	12\n10	8	25	24	25	27	28	33\n10	8	25	2	3	1	1	1\n10	8	26	12	21	26\n10	8	26	1	1	1\n10	8	27	17	22	24	27	28\n10	8	27	2	1	3	7	1\n10	8	28	14	20	22	23	24	27	28	30	31	32\n10	8	28	1	1	1	2	1	3	3	4	1	1\n10	8	29	26	27	29	30\n10	8	29	1	1	1	1\n10	8	30	27	28	30	32\n10	8	30	1	3	11	2\n10	8	31	32\n10	8	31	1\n10	8	32	27	30	32\n10	8	32	1	1	8\n10	8	33	32	33	35	37\n10	8	33	1	1	3	1\n10	8	35	35\n10	8	35	11\n10	8	36	36\n10	8	36	1\n10	8	37	16	17	20	35	37\n10	8	37	532	193	318	1	661\n10	8	38	39\n10	8	38	1\n10	8	39	37\n10	8	39	1\n10	8	40	40\n10	8	40	2\n10	9	0	0\n10	9	0	62\n10	9	6	6	9	11	13	21	23\n10	9	6	17926	7	1	1	1	1\n10	9	7	6	7	10\n10	9	7	1	14357	15\n10	9	8	6	7	8	9	10	12	13	28\n10	9	8	1	339	20718	1	1	2	10	1\n10	9	9	6	7	8	9	10	11	12	13\n10	9	9	896	458	447	28344	96	7	1	24\n10	9	10	7	8	9	10	11	12	13	14\n10	9	10	68	135	373	23910	30	6	22	1\n10	9	11	6	7	8	9	10	11	12	13	15	16\n10	9	11	2	1	313	568	369	279316	2266	220	44	16\n10	9	12	7	8	9	10	11	12	13	14	15	16	23	28\n10	9	12	9	215	343	673	7486	224088	210	24	135	43	1	1\n10	9	13	6	8	9	10	11	12	13	14	15	16	17\n10	9	13	2	103	257	203	1054	2213	189314	387	1137	131	16\n10	9	14	9	10	11	12	13	14	15	16	17	20\n10	9	14	44	251	430	1063	2368	190668	78	1315	109	150\n10	9	15	6	8	9	10	11	12	13	14	15	16	17	20	37\n10	9	15	1	1	38	69	270	565	6520	1423	108691	959	24	39	1\n10	9	16	9	10	11	12	13	14	15	16	17	20	22\n10	9	16	1	1	64	132	253	2145	2553	132604	83	71	1\n10	9	17	9	10	11	12	13	14	15	16	17	18	28\n10	9	17	1	1	16	1	10	45	20	102	10200	4	1\n10	9	18	10	11	12	13	14	15	16	17	18	20\n10	9	18	1	5	1	2	13	12	11	3	19	1\n10	9	19	11	14	15	16	18	19	21\n10	9	19	1	2	15	4	4	16	1\n10	9	20	11	12	13	14	15	16	17	19	20	22	23	25	26	37\n10	9	20	3	1	2	91	87	7695	383	1	20622	1	1	1	1	13\n10	9	21	12	13	15	16	17	18	19	20	21	35\n10	9	21	422	624	4	1	3	1	2	1	851	1\n10	9	22	13	15	16	17	18	19	20	21	22	23	24\n10	9	22	1	1	2	6	5	3	2	1	15	1	1\n10	9	23	14	17	19	21	23\n10	9	23	1	1	3	6	4\n10	9	24	18	19	21	22	23	24	27\n10	9	24	3	1	1	3	1	12	1\n10	9	25	14	25	27\n10	9	25	1	1	1\n10	9	26	26\n10	9	26	4\n10	9	27	17	21	22	23	24	25	27	28\n10	9	27	1	3	1	1	3	2	7	1\n10	9	28	27	28\n10	9	28	1	7\n10	9	29	29\n10	9	29	1\n10	9	30	18	24	28	30	31	32\n10	9	30	1	1	4	10	1	1\n10	9	31	29\n10	9	31	1\n10	9	32	29	30	31	32	33	35\n10	9	32	1	1	2	7	1	1\n10	9	33	25	33\n10	9	33	1	1\n10	9	35	27	33	35	37\n10	9	35	1	1	12	1\n10	9	36	24\n10	9	36	1\n10	9	37	16	17	20	35	36	37\n10	9	37	169	58	117	2	1	335\n10	9	39	39\n10	9	39	1\n10	9	40	17	36\n10	9	40	1	1\n11	1	0	0\n11	1	0	42\n11	1	6	6	9\n11	1	6	10503	1122\n11	1	7	7	8	9	10	12\n11	1	7	7330	144	250	45	9\n11	1	8	7	8	9	10	11	12	13\n11	1	8	34	12658	260	145	87	254	72\n11	1	9	6	7	8	9	10	11	12	13	14	15\n11	1	9	2	22	42	18503	117	274	191	133	30	11\n11	1	10	7	8	9	10	11	12	13	14	15	18\n11	1	10	12	14	122	14198	157	601	102	123	42	1\n11	1	11	8	9	10	11	12	13	14	15	16\n11	1	11	3	28	132	175850	1580	343	165	82	22\n11	1	12	9	10	11	12	13	14	15	16	18	19	21	22\n11	1	12	10	20	3623	154125	463	377	198	43	5	1	441	1\n11	1	13	8	9	10	11	12	13	14	15	16	17	19	21\n11	1	13	14	18	12	223	663	119171	576	1161	60	6	2	597\n11	1	14	10	11	12	13	14	15	16	17	18	19	20	21	27\n11	1	14	1	24	149	810	124005	353	423	3	15	4	10	3	2\n11	1	15	11	12	13	14	15	16	17	18	19	20	21	23\n11	1	15	61	202	2053	177	83393	650	9	45	8	16	13	7\n11	1	16	11	12	13	14	15	16	17	20	21	26	37\n11	1	16	8	33	175	1680	948	79877	52	8617	9	1	289\n11	1	17	11	13	14	15	16	17	18	19	20	21	22	23	28	37\n11	1	17	1	41	155	44	106	5438	13	2	482	21	3	9	1	115\n11	1	18	13	14	15	16	17	18	19	20	21	23	24	26\n11	1	18	9	5	4	5	16	224	5	2	22	13	1	1\n11	1	19	12	14	15	17	18	19	20	21	22	23	25	27\n11	1	19	1	7	26	7	17	448	13	21	5	19	14	1\n11	1	20	11	14	15	16	17	18	19	20	21	22	23	25	27	30	37\n11	1	20	1	189	17	83	10	7	23	16919	15	13	1	28	3	1	141\n11	1	21	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30\n11	1	21	2	1	7	2	3	9	976	11	14	2	15	2	1	1	1\n11	1	22	13	20	21	22	24	25	28\n11	1	22	1	13	14	100	5	41	2\n11	1	23	13	21	22	23	25	27	28\n11	1	23	1	6	1	70	1	1	1\n11	1	24	21	22	24	26\n11	1	24	1	7	45	2\n11	1	25	22	23	25	27	32	35\n11	1	25	1	7	143	4	1	1\n11	1	26	21	24	26	27	30	31\n11	1	26	1	1	7	2	1	1\n11	1	27	19	23	24	26	27\n11	1	27	1	1	1	1	14\n11	1	28	23	26	27	28	33\n11	1	28	1	1	1	7	1\n11	1	29	16	25	27	28	29\n11	1	29	1	1	1	1	6\n11	1	30	27	29	30\n11	1	30	3	1	12\n11	1	31	27	29	31\n11	1	31	1	1	2\n11	1	32	30	32	35\n11	1	32	2	5	1\n11	1	33	32	37	39\n11	1	33	1	1	1\n11	1	35	35\n11	1	35	2\n11	1	37	20	30	37\n11	1	37	44	1	679\n11	2	0	0\n11	2	0	42\n11	2	6	6	9\n11	2	6	9997	508\n11	2	7	7	8	9	10	12\n11	2	7	7074	118	138	38	30\n11	2	8	7	8	9	10	11	12	13\n11	2	8	13	12222	103	68	149	281	39\n11	2	9	6	7	8	9	10	11	12	13	14	15\n11	2	9	6	20	52	19615	79	148	196	91	51	55\n11	2	10	7	8	9	10	11	12	13	14	15	18\n11	2	10	5	13	118	13930	88	298	65	120	32	1\n11	2	11	8	9	10	11	12	13	14	15	16	20	21\n11	2	11	1	40	119	176488	2803	388	293	144	20	9	4\n11	2	12	9	10	11	12	13	14	15	16	17	18	19	20	21\n11	2	12	6	19	2726	152784	562	561	260	54	2	6	2	22	804\n11	2	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n11	2	13	4	3	7	169	648	118070	1185	2304	73	7	5	2	28	869\n11	2	14	11	12	13	14	15	16	17	18	19	20	21	26\n11	2	14	33	159	636	125086	516	888	17	19	5	125	4	1\n11	2	15	11	12	13	14	15	16	17	18	19	20	21	23\n11	2	15	26	127	1613	208	83390	677	19	38	5	128	42	8\n11	2	16	10	11	12	13	14	15	16	17	18	19	20	21	23	25	27	28	37\n11	2	16	1	4	23	79	993	977	59658	56	2	4	19212	26	1	1	1	1	232\n11	2	17	13	14	15	16	17	18	19	20	21	22	23	25	37	40\n11	2	17	40	93	40	96	4507	14	3	634	40	1	17	1	61	1\n11	2	18	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n11	2	18	3	4	5	3	20	210	9	2	39	1	25	1	2	1	3	1\n11	2	19	14	15	17	18	19	20	21	23	25	26	27\n11	2	19	10	31	11	18	345	5	18	33	24	1	1\n11	2	20	13	14	15	16	17	18	19	20	21	22	25	26	27	37\n11	2	20	1	90	15	86	8	9	11	25773	6	5	40	1	3	77\n11	2	21	13	16	17	18	19	20	21	22	23	24	25	26	27	29\n11	2	21	1	1	12	7	5	6	2020	12	47	1	23	3	1	1\n11	2	22	11	18	19	20	21	22	23	24	25	28\n11	2	22	1	1	2	9	11	75	4	4	34	1\n11	2	23	18	19	21	23	24	25	26	27	28	30\n11	2	23	3	1	8	124	1	1	1	1	1	1\n11	2	24	21	22	24\n11	2	24	2	11	42\n11	2	25	21	23	25	26	27	28	30\n11	2	25	1	24	211	1	1	1	4\n11	2	26	21	22	23	26	27	28	29\n11	2	26	1	2	1	8	1	1	1\n11	2	27	22	23	25	26	27	28\n11	2	27	1	2	2	1	26	2\n11	2	28	21	23	27	28	29\n11	2	28	1	2	1	8	1\n11	2	29	26	27	28	29\n11	2	29	1	1	2	4\n11	2	30	27	28	30	31\n11	2	30	2	1	14	1\n11	2	31	28	31\n11	2	31	1	2\n11	2	32	30	32\n11	2	32	1	6\n11	2	33	33\n11	2	33	1\n11	2	35	35	37	38\n11	2	35	1	2	1\n11	2	37	20	35	37\n11	2	37	119	1	1105\n11	2	39	39\n11	2	39	1\n11	3	0	0\n11	3	0	42\n11	3	6	6\n11	3	6	10003\n11	3	7	7	10\n11	3	7	7110	2\n11	3	8	7	8	13\n11	3	8	14	12394	2\n11	3	9	6	7	8	9	10	11	13\n11	3	9	10	18	59	20417	23	3	1\n11	3	10	7	8	9	10	11	12	13\n11	3	10	1	17	119	14112	9	1	2\n11	3	11	8	9	10	11	12	13	15\n11	3	11	1	43	104	179037	598	47	2\n11	3	12	9	10	11	12	13	14	15	16	21\n11	3	12	11	24	2995	154141	112	29	30	4	3\n11	3	13	8	9	10	11	12	13	14	15	16	17	21\n11	3	13	3	3	10	173	671	120295	88	330	9	5	1\n11	3	14	11	12	13	14	15	16	17	18	20	26\n11	3	14	39	170	685	127508	33	228	16	1	13	1\n11	3	15	11	12	13	14	15	16	17	19	20\n11	3	15	31	104	1706	248	85418	246	7	6	3\n11	3	16	10	11	12	13	14	15	16	17	18	19	20	22	25\n11	3	16	1	1	9	76	967	1304	59112	44	1	1	38	1	1\n11	3	17	13	14	15	16	17	21\n11	3	17	46	78	33	145	4356	1\n11	3	18	13	14	15	16	17	18	20	21\n11	3	18	4	6	7	2	8	304	1	1\n11	3	19	12	13	14	15	16	17	18	19	20	21\n11	3	19	1	1	5	27	1	12	24	320	2	1\n11	3	20	14	15	16	17	18	19	20	21	22	37\n11	3	20	98	30	138	5	5	22	45746	1	1	26\n11	3	21	11	12	14	15	16	17	18	19	20	21	23	24\n11	3	21	1	3	3	5	2	18	5	3	12	3837	6	1\n11	3	22	17	18	19	20	21	22	24	29\n11	3	22	1	1	3	8	15	76	3	1\n11	3	23	15	16	18	19	20	21	23	25	26	27\n11	3	23	1	1	3	3	4	29	242	3	1	1\n11	3	24	22	24\n11	3	24	8	41\n11	3	25	16	17	19	20	23	25\n11	3	25	1	1	1	1	30	305\n11	3	26	15	22	23	25	26	27\n11	3	26	1	1	1	1	14	1\n11	3	27	17	19	22	23	26	27\n11	3	27	1	1	1	2	1	36\n11	3	28	20	23	25	27	28	29	30	32\n11	3	28	1	3	1	1	11	1	1	1\n11	3	29	27	29\n11	3	29	1	6\n11	3	30	26	27	28	29	30	32\n11	3	30	1	4	2	1	11	1\n11	3	31	26	31\n11	3	31	1	2\n11	3	32	32\n11	3	32	6\n11	3	33	33\n11	3	33	1\n11	3	35	35\n11	3	35	2\n11	3	37	20	37	39\n11	3	37	199	1277	1\n11	3	38	38\n11	3	38	1\n11	3	39	39\n11	3	39	1\n11	3	40	40\n11	3	40	1\n11	4	0	0\n11	4	0	42\n11	4	6	6\n11	4	6	10013\n11	4	7	7	8\n11	4	7	7142	1\n11	4	8	7	8	9	12	13\n11	4	8	17	12454	1	1	1\n11	4	9	6	7	8	9	10	11	12	13	14	18\n11	4	9	15	28	48	20468	27	3	1	1	1	1\n11	4	10	7	8	9	10	11	12	13\n11	4	10	4	15	104	14140	6	1	6\n11	4	11	9	10	11	12	13	14	15	16\n11	4	11	49	106	181451	605	70	1	5	2\n11	4	12	8	9	10	11	12	13	14	15	16	18	21\n11	4	12	4	19	31	2441	153045	91	21	31	7	1	7\n11	4	13	8	9	10	11	12	13	14	15	16	17	18	21\n11	4	13	4	43	6	116	620	121702	129	331	12	7	5	2\n11	4	14	10	11	12	13	14	15	16	17	19	20\n11	4	14	3	38	165	610	127863	44	272	14	1	20\n11	4	15	11	12	13	14	15	16	17	19	20\n11	4	15	17	101	1164	239	85382	307	5	2	4\n11	4	16	9	11	12	13	14	15	16	17	20	21\n11	4	16	2	1	12	43	676	1188	57867	64	35	1\n11	4	17	9	12	13	14	15	16	17	18	19	26	28\n11	4	17	2	3	37	64	20	169	4173	3	1	1	1\n11	4	18	9	10	12	13	14	15	16	17	18	20	21	22\n11	4	18	2	1	21	7	60	76	3	10	161	1	1	1\n11	4	19	9	11	12	13	14	15	16	17	18	19	20	28\n11	4	19	2	1	11	8	14	31	1	4	8	278	1	1\n11	4	20	9	12	13	14	15	16	17	18	19	20	21	22	37\n11	4	20	6	17	1	50	18	158	3	3	15	45725	1	1	30\n11	4	21	9	12	13	14	15	16	17	18	19	20	21	22	23	24	25\n11	4	21	5	6	2	25	120	6	17	20	15	16	3652	1	2	1	1\n11	4	22	9	10	15	17	18	19	20	21	22	25\n11	4	22	2	1	1	22	6	2	7	20	26	1\n11	4	23	9	10	12	14	15	17	18	19	21	23	25\n11	4	23	1	1	1	2	21	8	13	73	12	151	1\n11	4	24	20	21	22	24	26	28	29\n11	4	24	1	15	6	20	1	1	1\n11	4	25	16	17	18	19	20	21	22	23	24	25\n11	4	25	1	3	2	82	66	34	41	4	1	77\n11	4	26	18	21	23	25	26\n11	4	26	3	3	1	1	11\n11	4	27	10	12	16	17	18	20	21	22	23	24	25	26	27	28	29\n11	4	27	3	1	2	1	2	2	1	3	3	1	1	3	19	1	1\n11	4	28	10	14	18	20	26	27	28	30	37\n11	4	28	1	1	1	1	1	1	5	1	1\n11	4	29	25	27	29	30	33\n11	4	29	1	1	5	1	1\n11	4	30	16	17	19	25	30\n11	4	30	1	1	1	5	4\n11	4	31	10	31\n11	4	31	1	1\n11	4	32	28	29	32	34\n11	4	32	1	1	5	1\n11	4	33	33\n11	4	33	1\n11	4	35	35\n11	4	35	2\n11	4	37	20	37\n11	4	37	168	1135\n11	4	38	38\n11	4	38	1\n11	4	39	39\n11	4	39	2\n11	4	40	32\n11	4	40	1\n11	5	0	0\n11	5	0	42\n11	5	6	6	7	8	9	13\n11	5	6	10015	1	9	2	1\n11	5	7	7	8	9	11\n11	5	7	7167	17	4	3\n11	5	8	7	8	9	11	13\n11	5	8	26	12488	8	3	1\n11	5	9	6	7	8	9	10	11	13	17\n11	5	9	8	26	76	20546	43	4	2	1\n11	5	10	7	8	9	10	11	12	13	17\n11	5	10	3	17	118	14174	3	1	3	2\n11	5	11	7	8	9	10	11	12	13	15	16\n11	5	11	2	14	47	116	183083	719	75	13	5\n11	5	12	8	9	10	11	12	13	14	15	16	17	21\n11	5	12	10	8	19	1985	152422	98	31	33	3	1	1\n11	5	13	8	9	10	11	12	13	14	15	16	17	21\n11	5	13	40	11	6	113	583	122497	86	390	11	5	1\n11	5	14	8	9	10	11	12	13	14	15	16	17	18	19	20\n11	5	14	4	4	4	46	190	577	127951	42	288	13	1	2	24\n11	5	15	8	9	11	12	13	14	15	16	17	18	19	20\n11	5	15	5	2	17	70	877	252	85654	373	6	1	4	7\n11	5	16	8	9	11	12	13	14	15	16	17	19	20	21\n11	5	16	11	2	2	12	30	535	983	57110	85	2	35	1\n11	5	17	11	12	13	14	15	16	17	20	21	22	29\n11	5	17	1	8	33	59	39	128	4060	1	1	1	1\n11	5	18	9	12	13	14	15	16	17	18	20	22\n11	5	18	1	1	13	7	40	2	13	150	1	1\n11	5	19	8	9	11	12	13	14	15	16	17	18	19	20\n11	5	19	7	3	2	2	1	4	46	1	4	12	382	6\n11	5	20	8	11	12	13	14	15	16	17	18	19	20	21	22	37\n11	5	20	6	1	9	1	43	17	131	6	6	24	45770	1	2	30\n11	5	21	11	12	13	14	15	16	17	18	20	21	22\n11	5	21	1	8	13	19	40	22	25	2	4	3614	1\n11	5	22	9	14	17	18	19	20	21	22	24\n11	5	22	1	2	1	1	1	9	9	54	1\n11	5	23	9	11	13	15	16	17	18	20	21	22	23\n11	5	23	1	4	4	34	5	36	38	1	18	1	19\n11	5	24	16	18	22	23	24	29\n11	5	24	1	2	5	2	12	1\n11	5	25	13	18	21	23	24	25	27	29\n11	5	25	2	1	2	9	1	71	1	1\n11	5	26	16	17	18	21	22	23	24	26	27	33\n11	5	26	1	2	1	3	1	1	1	5	1	1\n11	5	27	14	16	18	19	20	22	23	27	30\n11	5	27	2	2	4	2	3	1	1	5	1\n11	5	28	13	28	30\n11	5	28	2	7	1\n11	5	29	22	24	25	27	29\n11	5	29	1	1	1	1	4\n11	5	30	30\n11	5	30	6\n11	5	31	17\n11	5	31	1\n11	5	32	22	32\n11	5	32	1	5\n11	5	33	33\n11	5	33	2\n11	5	34	35\n11	5	34	1\n11	5	35	33	35\n11	5	35	1	1\n11	5	37	20	37\n11	5	37	94	1072\n11	5	38	38\n11	5	38	1\n11	5	39	37\n11	5	39	2\n11	6	0	0\n11	6	0	42\n11	6	6	6	7	9\n11	6	6	9948	69	6\n11	6	7	6	7	9\n11	6	7	1	7216	8\n11	6	8	6	7	8	9	10	13\n11	6	8	1	166	12523	10	1	3\n11	6	9	6	7	8	9	10	11	12	13	22\n11	6	9	9	263	48	20373	53	6	4	1	1\n11	6	10	6	7	8	9	10	11	12	13	14	15\n11	6	10	1	57	8	113	14165	6	1	2	8	1\n11	6	11	6	7	8	9	10	11	12	13	14	15	16	18	19\n11	6	11	6	287	1	81	128	183711	750	148	146	5	3	1	1\n11	6	12	7	8	9	10	11	12	13	14	15	16	18	20	21	28\n11	6	12	71	1	14	50	1911	151678	108	67	108	7	7	1	1	1\n11	6	13	6	7	8	9	10	11	12	13	14	15	16	17	21	24\n11	6	13	16	1289	4	180	8	105	585	121555	105	365	13	2	2	1\n11	6	14	7	9	10	11	12	13	14	15	16	17	18	20\n11	6	14	132	56	19	60	160	563	127560	89	304	11	7	30\n11	6	15	7	9	10	11	12	13	14	15	16	17	20	24\n11	6	15	513	52	3	35	62	765	256	85220	410	9	4	2\n11	6	16	7	9	10	11	12	13	14	15	16	17	20\n11	6	16	7	29	2	1	11	18	432	827	56608	98	50\n11	6	17	7	9	10	11	13	14	15	16	17	18	21\n11	6	17	31	52	6	6	41	19	63	94	3939	6	4\n11	6	18	7	9	10	11	12	13	14	15	16	17	18	19	21\n11	6	18	47	44	8	2	4	3	4	15	3	1	86	1	1\n11	6	19	7	9	10	12	14	15	17	18	19\n11	6	19	235	143	18	3	4	3	1	3	7\n11	6	20	7	9	10	12	13	14	15	16	17	18	20	21	37\n11	6	20	32	45	45	1	3	29	9	102	4	1	45647	2	35\n11	6	21	7	9	10	12	13	15	16	18	19	20	21	22	24	27	29	30\n11	6	21	18	31	11	8	5	35	7	9	1	1	3506	10	6	1	1	1\n11	6	22	9	10	13	15	17	21	22	24	25	27\n11	6	22	1	36	3	2	2	12	5	1	4	3\n11	6	23	7	9	12	16	17	20	21	23	24\n11	6	23	2	9	3	1	2	1	2	11	1\n11	6	24	21	23	24	25	27\n11	6	24	2	1	3	4	6\n11	6	25	7	9	10	17	23	24	25	40\n11	6	25	3	20	39	4	1	1	3	1\n11	6	26	12	18	19	26\n11	6	26	1	2	1	1\n11	6	27	9	12	17	18	24	27	30	36\n11	6	27	1	1	1	1	1	1	1	1\n11	6	28	10	20	26	28	30\n11	6	28	1	1	1	1	3\n11	6	29	17	18	21	27	29\n11	6	29	1	2	1	2	1\n11	6	30	30\n11	6	30	8\n11	6	32	32\n11	6	32	5\n11	6	33	32	33\n11	6	33	1	3\n11	6	35	35\n11	6	35	2\n11	6	37	20	35	37\n11	6	37	81	1	1022\n11	6	38	37\n11	6	38	1\n11	7	0	0\n11	7	0	42\n11	7	6	6\n11	7	6	9982\n11	7	7	6	7	10\n11	7	7	31	10406	1\n11	7	8	6	7	8	9	10	11	13\n11	7	8	49	24	12505	2	1	1	3\n11	7	9	6	7	8	9	10	11	13	15	16	19	24	27	30\n11	7	9	83	22	80	20960	59	43	7	5	3	1	2	1	2\n11	7	10	6	7	8	9	10	11	13	19	26\n11	7	10	11	8	20	116	14420	11	5	1	1\n11	7	11	6	7	8	9	10	11	12	13	14	15	16\n11	7	11	154	1	16	52	312	184151	942	96	68	15	36\n11	7	12	6	8	9	10	11	12	13	14	15	16	17	18	19	21	23	29\n11	7	12	77	10	12	112	1480	151283	124	68	52	12	32	4	1	3	1	1\n11	7	13	6	8	9	10	11	12	13	14	15	16	17	21	28	30\n11	7	13	493	8	48	19	96	585	121391	127	418	22	5	4	1	1\n11	7	14	6	8	9	10	11	12	13	14	15	16	17	18	19	20\n11	7	14	12	44	1	46	60	117	540	127369	43	321	46	2	1	28\n11	7	15	6	8	9	10	11	12	13	14	15	16	17	18	20	21\n11	7	15	193	2	41	11	12	54	681	241	85016	453	20	1	15	2\n11	7	16	6	8	9	10	11	12	13	14	15	16	17	18	20	21	25\n11	7	16	11	14	2	10	4	17	31	391	793	56079	101	2	81	15	1\n11	7	17	6	9	10	12	13	14	15	16	17	18	19	21\n11	7	17	58	28	1	1	2	15	5	80	3875	3	1	6\n11	7	18	6	8	9	11	12	13	15	16	17	18	21	22\n11	7	18	23	9	28	1	2	5	1	2	2	49	1	2\n11	7	19	8	9	13	16	18	19	28\n11	7	19	2	1	1	1	1	4	1\n11	7	20	8	11	13	14	15	16	17	18	20	37\n11	7	20	2	1	3	20	5	71	4	2	45676	32\n11	7	21	6	9	10	11	12	13	14	17	21	22	27	34\n11	7	21	1	20	8	1	8	14	2	2	3474	1	1	1\n11	7	22	8	12	15	17	22	26\n11	7	22	1	1	4	1	8	1\n11	7	23	9	18	22	23\n11	7	23	9	1	1	2\n11	7	24	13	18	21	24	25\n11	7	24	2	1	1	11	1\n11	7	25	13	18	24	25\n11	7	25	1	1	3	6\n11	7	26	18	21\n11	7	26	1	1\n11	7	27	13	22	24	26	27\n11	7	27	1	1	1	1	9\n11	7	28	28	29\n11	7	28	1	1\n11	7	29	29	32\n11	7	29	1	1\n11	7	30	25	28	30	32\n11	7	30	1	2	7	3\n11	7	32	25	32\n11	7	32	1	5\n11	7	33	33	35\n11	7	33	2	1\n11	7	35	35\n11	7	35	3\n11	7	36	36\n11	7	36	1\n11	7	37	20	37\n11	7	37	75	983\n11	7	40	40\n11	7	40	1\n11	8	0	0\n11	8	0	42\n11	8	6	6	9	21	24\n11	8	6	11168	7	1	2\n11	8	7	6	7	9	10	15	19\n11	8	7	3	10082	372	2	1	1\n11	8	8	6	7	8	9	10	11	13	15	17	18\n11	8	8	4	31	12653	3	2	8	6	3	1	2\n11	8	9	6	7	8	9	10	11	12	13	14	17	23\n11	8	9	14	19	61	21125	70	8	9	6	3	4	1\n11	8	10	6	7	8	9	10	11	12	13	14	15	16	18\n11	8	10	1	9	15	115	14819	27	3	4	3	1	1	2\n11	8	11	6	7	8	9	10	11	12	13	14	15	16	19\n11	8	11	22	1	2	50	134	184427	1084	105	8	16	9	3\n11	8	12	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22	23\n11	8	12	11	1	3	13	24	1311	151355	131	70	67	6	8	1	2	4	1	2\n11	8	13	6	8	9	10	11	12	13	14	15	16	17	19	21	22	23	24\n11	8	13	73	6	6	15	103	516	121452	152	547	21	10	1	2	1	1	1\n11	8	14	8	9	10	11	12	13	14	15	16	17	18	20	24	27\n11	8	14	6	4	9	48	108	479	127020	45	425	31	79	45	1	1\n11	8	15	6	9	10	11	12	13	14	15	16	17	18	20	21\n11	8	15	38	13	1	7	60	526	293	84685	611	18	54	12	39\n11	8	16	6	8	9	10	11	12	13	14	15	16	17	20	22\n11	8	16	5	1	1	2	2	6	18	331	689	55823	127	74	1\n11	8	17	8	13	14	15	16	17	19	21\n11	8	17	1	3	25	5	76	3972	1	5\n11	8	18	8	9	10	13	15	16	18	19	20	21	23	24\n11	8	18	2	3	2	2	2	1	32	1	3	18	1	1\n11	8	19	10	17	18	19\n11	8	19	1	1	1	6\n11	8	20	10	13	14	15	16	17	20	21	23	30	37\n11	8	20	1	2	26	6	60	3	45724	1	2	1	49\n11	8	21	9	12	13	17	18	19	21	22	23\n11	8	21	3	9	11	3	3	1	3471	4	2\n11	8	22	15	21	22	26\n11	8	22	1	2	9	1\n11	8	23	23	30\n11	8	23	2	1\n11	8	24	13	14	18	21	22	24	26	27	37\n11	8	24	1	1	1	2	1	7	1	2	1\n11	8	25	22	25	27	33\n11	8	25	1	5	3	1\n11	8	26	22	23	26\n11	8	26	1	1	1\n11	8	27	21	24	27\n11	8	27	2	2	7\n11	8	28	22	25	26	27	28\n11	8	28	1	1	1	1	1\n11	8	29	29	30\n11	8	29	2	1\n11	8	30	23	28	30\n11	8	30	1	2	7\n11	8	32	31	32\n11	8	32	2	7\n11	8	33	30	32\n11	8	33	1	1\n11	8	34	34\n11	8	34	1\n11	8	35	35	37\n11	8	35	3	1\n11	8	36	36\n11	8	36	1\n11	8	37	20	37\n11	8	37	64	951\n11	8	40	40\n11	8	40	1\n11	9	0	0\n11	9	0	42\n11	9	6	6	9	11	13	16	18	22	27\n11	9	6	11273	59	1	1	1	2	1	1\n11	9	7	6	7	8	10\n11	9	7	1	10139	1	2\n11	9	8	7	8	9	10	13	22\n11	9	8	371	12368	2	1	7	1\n11	9	9	6	7	8	9	10	11	12	13	15	21\n11	9	9	1387	821	344	19105	44	6	1	5	1	1\n11	9	10	7	8	9	10	11	12	13	14	21\n11	9	10	93	206	295	14459	14	2	8	3	2\n11	9	11	6	7	8	9	10	11	12	13	14	15	16	18	22\n11	9	11	6	1	444	400	269	183671	1076	58	1	8	5	1	1\n11	9	12	6	7	8	9	10	11	12	13	14	15	16	17	21\n11	9	12	2	143	554	608	793	7851	143022	107	8	56	4	1	1\n11	9	13	6	8	9	10	11	12	13	14	15	16	17\n11	9	13	14	178	302	204	1222	1703	118485	116	493	19	10\n11	9	14	6	9	10	11	12	13	14	15	16	17	18	20	23\n11	9	14	1	180	484	1250	1516	2855	120963	54	532	45	7	44	1\n11	9	15	6	9	10	11	12	13	14	15	16	17	19	20	21\n11	9	15	2	157	176	460	972	8127	1836	73710	594	16	2	15	1\n11	9	16	8	9	10	11	12	13	14	15	16	17	18	19	20\n11	9	16	1	2	10	90	148	226	2412	1694	52327	61	8	1	53\n11	9	17	9	10	11	12	13	14	15	16	17	18	21	23	28\n11	9	17	7	8	1	3	6	29	8	61	4046	6	1	1	1\n11	9	18	10	11	12	13	14	15	16	17	18	21	27\n11	9	18	1	20	3	2	64	30	1	1	49	3	1\n11	9	19	12	14	16	17	18	19	24\n11	9	19	1	1	2	3	1	7	1\n11	9	20	11	12	13	14	15	16	17	18	20	37\n11	9	20	32	41	83	316	381	29009	1305	1	14735	19\n11	9	21	10	11	12	13	14	15	17	18	21	23\n11	9	21	1	2	1125	1254	4	48	11	9	1092	1\n11	9	22	11	14	15	16	17	19	22\n11	9	22	1	1	3	1	1	1	12\n11	9	23	13	19	20	21	23	24	27\n11	9	23	3	2	1	1	4	1	1\n11	9	24	15	18	21	22	24	25	26\n11	9	24	1	1	3	3	4	1	1\n11	9	25	13	22	25	28\n11	9	25	1	1	3	1\n11	9	26	21	24	26\n11	9	26	1	2	1\n11	9	27	15	23	24	25	27\n11	9	27	1	1	5	1	6\n11	9	28	24	27	28\n11	9	28	1	1	1\n11	9	29	29\n11	9	29	2\n11	9	30	28	30	32\n11	9	30	1	8	2\n11	9	31	30	31\n11	9	31	1	1\n11	9	32	28	31	32\n11	9	32	1	1	6\n11	9	33	33\n11	9	33	1\n11	9	34	34\n11	9	34	1\n11	9	35	35\n11	9	35	3\n11	9	36	21\n11	9	36	1\n11	9	37	16	17	20	37	39\n11	9	37	369	123	175	334	1\n11	9	40	40\n11	9	40	1\n11	10	0	0\n11	10	0	42\n11	10	6	6	9	21\n11	10	6	12683	2	1\n11	10	7	7	10\n11	10	7	11556	12\n11	10	8	7	8	10	13\n11	10	8	266	13822	1	7\n11	10	9	6	7	8	9	10	11	12	13\n11	10	9	672	509	277	19598	43	3	1	14\n11	10	10	7	8	9	10	11	13	14\n11	10	10	55	126	319	15925	14	11	2\n11	10	11	6	8	9	10	11	12	13	15	16\n11	10	11	5	233	319	263	192184	1497	86	27	7\n11	10	12	7	8	9	10	11	12	13	14	15	16	18\n11	10	12	10	165	248	503	4838	143666	100	8	58	16	1\n11	10	13	6	8	9	10	11	12	13	14	15	16	17	21\n11	10	13	2	66	184	187	757	1505	127633	146	681	53	13	1\n11	10	14	8	9	10	11	12	13	14	15	16	17	20\n11	10	14	1	58	210	386	708	1682	121693	30	809	85	92\n11	10	15	6	9	10	11	12	13	14	15	16	17	18	19	20	28\n11	10	15	3	27	50	219	391	4589	1050	69686	435	13	1	1	22	1\n11	10	16	10	11	12	13	14	15	16	17	20\n11	10	16	15	46	72	137	1230	1619	79710	44	52\n11	10	17	10	11	12	13	14	15	16	17	18\n11	10	17	7	1	2	6	17	6	58	5525	1\n11	10	18	10	11	12	13	14	15	16	17	18	21\n11	10	18	4	7	1	2	33	18	4	5	10	1\n11	10	19	11	14	15	17	18	19\n11	10	19	2	1	4	1	1	4\n11	10	20	13	14	15	16	17	20	37\n11	10	20	4	26	36	4161	174	10617	5\n11	10	21	11	12	13	14	15	16	17	18	20	21	22	24	28\n11	10	21	1	247	343	1	17	1	6	2	2	484	1	1	1\n11	10	22	13	15	19	22	28\n11	10	22	1	3	5	9	1\n11	10	23	12	19	21	23\n11	10	23	1	1	2	4\n11	10	24	15	18	22	24	27\n11	10	24	1	2	1	9	1\n11	10	25	21	24	25\n11	10	25	2	2	1\n11	10	26	26\n11	10	26	2\n11	10	27	23	24	25	27	28\n11	10	27	2	3	2	2	1\n11	10	28	22	28	30\n11	10	28	1	3	1\n11	10	29	22	29\n11	10	29	1	1\n11	10	30	23	27	28	30\n11	10	30	1	1	3	4\n11	10	31	31\n11	10	31	2\n11	10	32	31	32\n11	10	32	1	7\n11	10	33	14\n11	10	33	1\n11	10	34	34\n11	10	34	1\n11	10	35	32	35\n11	10	35	2	1\n11	10	37	16	17	20	24	35	37\n11	10	37	79	29	50	1	1	193\n11	10	39	37\n11	10	39	1\n11	10	40	10\n11	10	40	1\n12	1	0	0\n12	1	0	38\n12	1	6	6	9\n12	1	6	6955	738\n12	1	7	7	8	9	10	12	27\n12	1	7	5434	101	197	23	6	1\n12	1	8	7	8	9	10	11	12	13	15\n12	1	8	16	8813	159	89	84	184	40	2\n12	1	9	6	7	8	9	10	11	12	13	14	15	21\n12	1	9	2	13	26	13496	66	214	132	110	27	11	1\n12	1	10	7	8	9	10	11	12	13	14	15	16\n12	1	10	4	12	96	9449	91	364	74	113	22	1\n12	1	11	8	9	10	11	12	13	14	15	16\n12	1	11	6	35	79	130513	1013	228	103	48	9\n12	1	12	8	9	10	11	12	13	14	15	16	18	21\n12	1	12	1	7	12	2681	110561	253	243	151	30	4	293\n12	1	13	8	9	10	11	12	13	14	15	16	17	18	21\n12	1	13	12	17	3	194	563	88094	391	871	61	7	1	350\n12	1	14	10	11	12	13	14	15	16	17	18	19	20	21\n12	1	14	1	25	110	575	91225	243	276	11	11	7	6	3\n12	1	15	11	12	13	14	15	16	17	18	19	20	21	23\n12	1	15	59	187	1615	145	61857	420	7	34	6	16	23	7\n12	1	16	11	12	13	14	15	16	17	18	20	21	23	27	37\n12	1	16	8	26	82	1196	719	56890	44	13	6211	34	3	1	187\n12	1	17	13	14	15	16	17	18	20	21	22	23	25	28	37\n12	1	17	18	91	40	68	3790	38	341	24	1	17	1	1	78\n12	1	18	13	14	15	16	17	18	19	20	21	23	25	27\n12	1	18	5	2	5	3	11	298	4	6	27	37	2	1\n12	1	19	14	15	17	18	19	20	21	22	23	24	25	26	27\n12	1	19	2	10	5	12	151	4	8	2	6	1	5	1	2\n12	1	20	13	14	15	16	17	18	19	20	21	23	25	37\n12	1	20	2	119	6	56	4	7	6	10904	2	1	9	111\n12	1	21	13	18	19	20	21	22	23	24	25	26	27	28\n12	1	21	2	1	3	2	676	1	23	1	3	1	1	1\n12	1	22	18	20	21	22	24	25	26	27\n12	1	22	1	4	4	31	2	6	3	1\n12	1	23	15	21	23	24	25	27	30\n12	1	23	1	4	142	1	3	1	1\n12	1	24	20	21	24	28\n12	1	24	1	1	13	1\n12	1	25	23	25	29	32\n12	1	25	4	44	1	1\n12	1	26	26	28	29\n12	1	26	10	1	1\n12	1	27	24	26	27	29	31\n12	1	27	1	1	20	1	1\n12	1	28	26	28\n12	1	28	2	10\n12	1	29	27	29	32\n12	1	29	1	3	1\n12	1	30	28	30	31\n12	1	30	2	15	1\n12	1	31	31	35\n12	1	31	4	1\n12	1	32	32	35\n12	1	32	11	1\n12	1	35	12	35\n12	1	35	1	2\n12	1	37	20	32	37	40\n12	1	37	17	1	483	1\n12	1	40	32\n12	1	40	1\n12	2	0	0\n12	2	0	38\n12	2	6	6	9\n12	2	6	6636	321\n12	2	7	7	8	9	10	12\n12	2	7	5232	83	111	20	21\n12	2	8	7	8	9	10	11	12	13	15\n12	2	8	13	8480	76	37	100	233	31	1\n12	2	9	7	8	9	10	11	12	13	14	15\n12	2	9	12	35	14185	79	138	152	74	42	28\n12	2	10	8	9	10	11	12	13	14	15	18	21\n12	2	10	12	90	9242	48	173	43	87	25	1	1\n12	2	11	8	9	10	11	12	13	14	15	16	17	20	25\n12	2	11	1	27	71	131229	1859	320	208	120	22	2	9	1\n12	2	12	9	10	11	12	13	14	15	16	17	18	19	20	21\n12	2	12	4	24	2315	109370	364	327	179	32	4	3	2	14	509\n12	2	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n12	2	13	4	4	9	107	521	87659	724	1442	57	5	3	1	15	547\n12	2	14	11	12	13	14	15	16	17	18	19	20	21	23\n12	2	14	28	109	485	92053	396	487	8	7	9	64	10	1\n12	2	15	11	12	13	14	15	16	17	18	19	20	21	23\n12	2	15	36	108	1343	155	61829	345	10	20	9	63	59	9\n12	2	16	10	11	12	13	14	15	16	17	18	19	20	21	23	27	29	30	37\n12	2	16	1	2	10	57	833	863	42014	31	5	1	13715	44	7	2	1	1	227\n12	2	17	13	14	15	16	17	18	19	20	21	22	23	24	37\n12	2	17	20	65	33	83	3082	27	2	433	35	1	41	1	56\n12	2	18	13	14	15	16	17	18	19	20	21	22	23	24	26	27\n12	2	18	3	3	6	6	10	258	1	10	38	3	77	2	1	2\n12	2	19	15	17	18	19	20	21	23	25	27\n12	2	19	4	3	6	134	3	5	12	8	2\n12	2	20	14	15	16	17	18	19	20	21	22	23	25	27	28	37\n12	2	20	83	15	56	4	3	4	17266	4	2	2	12	4	1	56\n12	2	21	14	15	17	19	20	21	22	23	24	25	26	27	28	29\n12	2	21	1	1	3	2	2	1379	2	46	1	1	6	1	2	3\n12	2	22	19	21	22	24	25	26	27	28\n12	2	22	1	6	16	2	5	2	1	2\n12	2	23	18	19	21	23	27	28\n12	2	23	1	1	18	218	1	1\n12	2	24	16	20	21	22	24	29\n12	2	24	1	2	1	1	13	1\n12	2	25	19	22	23	24	25	26	30\n12	2	25	1	1	3	2	64	1	1\n12	2	26	13	21	22	23	24	25	26	27\n12	2	26	1	1	1	1	1	1	11	1\n12	2	27	22	23	26	27	29	30\n12	2	27	1	2	1	23	1	1\n12	2	28	23	24	27	28	29	30\n12	2	28	2	2	1	8	1	2\n12	2	29	29	30	35\n12	2	29	4	1	1\n12	2	30	27	28	30	31	32\n12	2	30	1	2	10	1	2\n12	2	31	28	31\n12	2	31	1	5\n12	2	32	28	29	32\n12	2	32	1	2	12\n12	2	35	35	39\n12	2	35	3	1\n12	2	37	20	37\n12	2	37	49	810\n12	2	40	40\n12	2	40	1\n12	3	0	0\n12	3	0	38\n12	3	6	6\n12	3	6	6636\n12	3	7	7	10\n12	3	7	5256	1\n12	3	8	7	8	13\n12	3	8	17	8597	1\n12	3	9	6	7	8	9	10	11\n12	3	9	4	17	45	14734	14	4\n12	3	10	7	8	9	10	11	13	27\n12	3	10	4	11	97	9367	2	1	1\n12	3	11	8	9	10	11	12	13	15	16\n12	3	11	2	24	72	133595	280	26	3	1\n12	3	12	9	10	11	12	13	14	15	16	19	21\n12	3	12	7	19	1869	110569	59	16	13	2	1	1\n12	3	13	8	10	11	12	13	14	15	16	17	18\n12	3	13	3	6	100	508	89509	50	215	7	1	1\n12	3	14	11	12	13	14	15	16	17	18	20\n12	3	14	31	117	497	93806	13	112	2	1	2\n12	3	15	11	12	13	14	15	16	17	18	20\n12	3	15	13	85	1167	189	63267	213	5	1	2\n12	3	16	11	12	13	14	15	16	17	18	20	23\n12	3	16	2	6	39	583	780	41640	30	1	21	1\n12	3	17	13	14	15	16	17	21\n12	3	17	29	24	28	89	2991	1\n12	3	18	12	13	14	15	16	17	18	19	22\n12	3	18	1	5	2	3	2	9	310	1	1\n12	3	19	14	15	16	17	18	19	22	25\n12	3	19	3	5	1	1	8	148	1	1\n12	3	20	14	15	16	17	18	19	20	21	37\n12	3	20	39	12	71	2	1	3	31502	3	12\n12	3	21	12	13	14	15	16	17	18	19	20	21	22	23	27\n12	3	21	1	1	2	1	3	5	3	3	12	2618	2	5	1\n12	3	22	20	21	22	27\n12	3	22	1	5	21	1\n12	3	23	14	15	18	19	20	21	22	23\n12	3	23	1	2	3	3	1	25	2	384\n12	3	24	20	21	23	24	25	28\n12	3	24	1	1	1	18	2	1\n12	3	25	22	23	25	27\n12	3	25	2	12	77	1\n12	3	26	22	23	24	26\n12	3	26	2	1	1	18\n12	3	27	21	22	26	27	29	30\n12	3	27	1	2	2	32	1	1\n12	3	28	14	22	23	26	27	28\n12	3	28	1	1	4	2	2	8\n12	3	29	27	28	29	30\n12	3	29	2	2	8	1\n12	3	30	16	27	30	31	32	35\n12	3	30	1	3	8	1	2	1\n12	3	31	30	31\n12	3	31	1	5\n12	3	32	28	29	30	31	32\n12	3	32	1	3	1	1	8\n12	3	35	33	35\n12	3	35	1	3\n12	3	37	20	37\n12	3	37	123	1026\n12	3	39	31\n12	3	39	1\n12	3	40	40\n12	3	40	1\n12	4	0	0\n12	4	0	38\n12	4	6	6\n12	4	6	6640\n12	4	7	7	9	14\n12	4	7	5292	1	1\n12	4	8	7	8	9	14\n12	4	8	13	8643	1	1\n12	4	9	6	7	8	9	10	11	18\n12	4	9	10	22	46	14769	13	1	1\n12	4	10	7	8	9	10	11	12	14\n12	4	10	3	8	77	9387	2	1	1\n12	4	11	7	8	9	10	11	12	13	14	15	16	18\n12	4	11	2	2	49	85	135025	389	52	4	6	1	1\n12	4	12	8	9	10	11	12	13	14	15	17	18\n12	4	12	3	11	19	1890	109547	63	11	21	1	1\n12	4	13	8	9	10	11	12	13	14	15	16	17	18\n12	4	13	2	26	11	105	456	90441	66	215	8	2	2\n12	4	14	9	11	12	13	14	15	16	17	18	20\n12	4	14	3	22	145	462	93902	22	143	6	2	9\n12	4	15	8	9	11	12	13	14	15	16	17	18	19\n12	4	15	1	2	8	86	1065	173	62758	239	5	1	4\n12	4	16	9	10	11	12	13	14	15	16	17	18	20\n12	4	16	1	1	1	8	29	495	935	40624	33	1	14\n12	4	17	9	10	12	13	14	15	16	17	18	27\n12	4	17	3	3	4	19	24	40	117	2834	1	1\n12	4	18	10	11	12	13	14	15	16	17	18	21	22	26\n12	4	18	1	2	9	8	29	34	3	5	235	1	1	1\n12	4	19	9	12	14	15	16	17	18	19	20	21	25\n12	4	19	4	3	2	16	2	2	3	124	1	1	1\n12	4	20	9	12	13	14	15	16	17	18	19	20	21	22	37\n12	4	20	5	11	1	30	8	113	4	5	5	31469	1	1	12\n12	4	21	9	12	13	14	15	17	18	19	20	21	23\n12	4	21	5	4	1	7	52	8	13	4	11	2549	1\n12	4	22	9	10	12	13	17	18	20	21	22\n12	4	22	1	2	1	1	3	4	4	4	14\n12	4	23	9	10	12	15	16	17	18	19	21	22	23	27	28\n12	4	23	2	2	1	5	1	3	12	21	26	1	332	1	1\n12	4	24	9	10	18	19	20	21	22	24	28\n12	4	24	1	1	2	1	1	2	6	4	1\n12	4	25	17	19	20	21	22	25\n12	4	25	1	17	9	10	11	32\n12	4	26	10	14	18	20	21	23	26	27\n12	4	26	1	1	3	1	1	3	11	1\n12	4	27	10	12	15	17	18	20	21	22	26	27	30\n12	4	27	3	1	2	1	1	1	2	1	2	28	1\n12	4	28	22	26	28	30\n12	4	28	1	1	9	1\n12	4	29	10	22	27	29	32\n12	4	29	1	1	1	8	1\n12	4	30	10	16	17	20	24	25	30	32\n12	4	30	1	1	1	1	1	2	4	1\n12	4	31	10	17	18	27	29	30	31\n12	4	31	1	1	1	1	1	1	2\n12	4	32	26	32	33\n12	4	32	1	7	2\n12	4	33	33\n12	4	33	1\n12	4	35	31	35\n12	4	35	1	3\n12	4	37	20	37\n12	4	37	116	922\n12	4	40	40\n12	4	40	1\n12	5	0	0\n12	5	0	38\n12	5	6	6	7	8\n12	5	6	6646	2	2\n12	5	7	7\n12	5	7	5332\n12	5	8	7	8	9	11	13\n12	5	8	19	8682	2	1	1\n12	5	9	6	7	8	9	10	11\n12	5	9	10	18	29	14868	33	3\n12	5	10	7	8	9	10	11	13\n12	5	10	1	12	81	9434	3	1\n12	5	11	7	8	9	10	11	12	13	15	16\n12	5	11	1	3	42	72	136460	419	51	5	3\n12	5	12	8	9	10	11	12	13	14	15	16	21\n12	5	12	7	10	12	1461	109069	59	20	23	1	4\n12	5	13	7	8	9	10	11	12	13	14	15	16	17	21\n12	5	13	1	21	6	7	92	488	91247	69	206	2	1	2\n12	5	14	8	10	11	12	13	14	15	16	17	18	20\n12	5	14	1	3	26	164	420	93954	29	131	8	1	10\n12	5	15	8	10	11	12	13	14	15	16	17	19	20	28\n12	5	15	1	1	8	87	734	198	62844	230	6	1	3	1\n12	5	16	8	9	10	11	12	13	14	15	16	17	18	20\n12	5	16	14	3	1	3	2	21	333	756	40049	48	1	21\n12	5	17	10	11	12	13	14	15	16	17	19	21\n12	5	17	1	1	24	26	36	41	104	2674	2	1\n12	5	18	12	13	14	15	16	17	18	19	20\n12	5	18	3	16	2	79	10	24	151	3	1\n12	5	19	8	14	15	17	18	19	20\n12	5	19	4	3	14	5	3	146	1\n12	5	20	8	12	13	14	15	16	17	18	19	20	21	37\n12	5	20	3	22	1	24	14	84	13	2	9	31446	2	17\n12	5	21	8	12	13	14	15	16	17	18	20	21	22\n12	5	21	1	10	18	33	120	59	48	13	1	2293	1\n12	5	22	8	9	15	18	19	21	22\n12	5	22	1	1	1	3	1	1	29\n12	5	23	8	9	11	13	14	15	16	17	18	21	23	28\n12	5	23	1	2	2	1	1	63	22	81	98	36	28	1\n12	5	24	15	21	24\n12	5	24	1	1	3\n12	5	25	18	21	22	23	25\n12	5	25	1	1	2	1	30\n12	5	26	16	20	21	26\n12	5	26	1	1	4	10\n12	5	27	16	18	19	20	21	22	24	25	26	27	28	30\n12	5	27	3	3	1	6	2	1	1	1	1	12	1	1\n12	5	28	13	27	28\n12	5	28	1	2	8\n12	5	29	15	21	23	24	25	27	29\n12	5	29	1	2	2	1	1	1	1\n12	5	30	26	30\n12	5	30	1	6\n12	5	31	24	30	31\n12	5	31	1	1	1\n12	5	32	22	25	31	32\n12	5	32	2	3	1	3\n12	5	33	33	35\n12	5	33	2	1\n12	5	35	35\n12	5	35	3\n12	5	37	20	37\n12	5	37	110	824\n12	5	40	37\n12	5	40	1\n12	6	0	0\n12	6	0	38\n12	6	6	6	7	9\n12	6	6	6573	77	6\n12	6	7	7	9\n12	6	7	5368	6\n12	6	8	6	7	8	9	12	13\n12	6	8	1	73	8687	18	1	2\n12	6	9	6	7	8	9	10	11	15\n12	6	9	12	137	30	14798	35	2	1\n12	6	10	7	8	9	10	11	12	13\n12	6	10	12	9	80	9450	6	4	3\n12	6	11	6	7	9	10	11	12	13	14	15	16\n12	6	11	3	137	52	86	137174	524	81	1	1	1\n12	6	12	7	8	9	10	11	12	13	14	15	16\n12	6	12	15	1	13	19	1215	108874	84	39	27	1\n12	6	13	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21\n12	6	13	9	515	3	60	1	65	456	91159	76	237	11	2	1	1	1\n12	6	14	7	9	10	11	12	13	14	15	16	17	18	19	20\n12	6	14	41	30	14	46	174	435	93713	40	158	7	6	1	8\n12	6	15	7	9	10	11	12	13	14	15	16	17	18	20	24\n12	6	15	170	11	1	15	45	535	178	62953	270	10	4	4	1\n12	6	16	7	9	12	13	14	15	16	17	20\n12	6	16	2	7	11	13	277	655	39631	68	35\n12	6	17	7	9	10	12	13	14	15	16	17	18\n12	6	17	10	23	5	1	15	17	38	76	2720	3\n12	6	18	7	9	10	12	13	14	15	16	17	18	23\n12	6	18	19	19	4	1	3	6	5	2	6	210	1\n12	6	19	7	9	10	12	13	14	15	16	18	19	20\n12	6	19	64	45	5	10	1	21	4	1	1	10	1\n12	6	20	7	9	10	14	15	16	17	18	20	27	37\n12	6	20	7	12	7	10	8	81	3	4	31447	1	20\n12	6	21	7	9	10	12	13	15	16	18	20	21\n12	6	21	4	8	6	5	4	52	16	17	3	2234\n12	6	22	10	12	13	15	17	18	19	21	22\n12	6	22	15	1	2	2	2	1	1	2	9\n12	6	23	7	16	17	21	23\n12	6	23	2	1	1	1	26\n12	6	24	10	24\n12	6	24	1	5\n12	6	25	9	10	13	16	17	20	25	28	30\n12	6	25	7	15	1	1	3	2	4	1	1\n12	6	26	13	16	18	19	20	21	22	28	29\n12	6	26	1	1	1	1	4	1	1	1	1\n12	6	27	15	18	21	22	24	27	28\n12	6	27	1	3	4	2	1	2	2\n12	6	28	12	20	21	24	25	28	30\n12	6	28	1	3	1	1	1	3	1\n12	6	29	30\n12	6	29	1\n12	6	30	28	29	30\n12	6	30	1	1	6\n12	6	31	29	30\n12	6	31	1	1\n12	6	32	30	32\n12	6	32	1	2\n12	6	33	32	33\n12	6	33	1	1\n12	6	35	35	37\n12	6	35	3	1\n12	6	37	20	37\n12	6	37	80	762\n12	7	0	0\n12	7	0	38\n12	7	6	6	9\n12	7	6	6595	3\n12	7	7	6	7	9	10	22	27	28\n12	7	7	77	6570	2	1	1	1	1\n12	7	8	6	7	8	9	10\n12	7	8	88	14	8621	6	1\n12	7	9	6	7	8	9	10	11	13	19\n12	7	9	148	19	55	14909	52	8	3	1\n12	7	10	6	7	8	9	10	11	12	13	14	17	20\n12	7	10	42	3	14	86	9506	6	2	2	1	1	1\n12	7	11	6	7	8	9	10	11	12	13	14	15	16	18\n12	7	11	247	2	17	58	452	136946	537	73	185	4	1	1\n12	7	12	6	7	8	9	10	11	12	13	14	15	16	18	24\n12	7	12	148	1	31	22	217	1001	108442	66	117	57	2	3	1\n12	7	13	6	8	9	10	11	12	13	14	15	16	17\n12	7	13	1163	9	103	30	59	435	90201	79	253	5	2\n12	7	14	6	8	9	10	11	12	13	14	15	16	17	18	20	21\n12	7	14	40	80	6	65	35	76	463	93333	54	169	6	4	6	1\n12	7	15	6	8	9	10	11	12	13	14	15	16	17	18	20	23	27\n12	7	15	538	10	84	27	3	39	423	183	62390	308	7	4	5	2	1\n12	7	16	6	8	9	10	11	12	13	14	15	16	17	18	20	21	25\n12	7	16	32	28	18	8	1	13	37	231	622	39102	84	9	62	2	2\n12	7	17	6	8	9	10	12	13	14	15	16	17	18	21	25	27	28\n12	7	17	113	1	96	3	4	1	14	21	73	2477	12	1	4	1	1\n12	7	18	6	8	9	10	11	13	14	15	16	17	18	19	22\n12	7	18	76	14	85	1	1	4	1	2	2	2	61	1	1\n12	7	19	8	10	13	15	17	19\n12	7	19	1	1	3	1	1	6\n12	7	20	8	12	13	14	15	16	17	18	20	37\n12	7	20	1	1	6	5	8	57	2	1	31483	24\n12	7	21	6	8	9	10	12	13	14	15	16	17	18	21	23	25	27	40\n12	7	21	10	1	27	6	2	7	1	7	3	1	2	2168	1	2	5	1\n12	7	22	13	17	20	21	22\n12	7	22	1	1	1	1	8\n12	7	23	6	9	16	30\n12	7	23	2	23	1	1\n12	7	24	10	12	13	15	17	24\n12	7	24	2	1	1	1	1	2\n12	7	25	18	22	25\n12	7	25	1	1	3\n12	7	27	13	27	28\n12	7	27	1	1	1\n12	7	28	24	27	28	30\n12	7	28	1	1	5	1\n12	7	29	29\n12	7	29	3\n12	7	30	21	28	30	32\n12	7	30	1	1	7	2\n12	7	32	32\n12	7	32	3\n12	7	33	33\n12	7	33	1\n12	7	35	35\n12	7	35	3\n12	7	37	20	32	37\n12	7	37	72	1	710\n12	8	0	0\n12	8	0	38\n12	8	6	6	9	22	25\n12	8	6	9313	4	1	1\n12	8	7	6	7	8	9	10	11	13\n12	8	7	27	6428	1	149	2	1	1\n12	8	8	6	7	8	9	10	11	13	15	16	19\n12	8	8	20	9	8839	3	1	3	3	3	1	1\n12	8	9	6	7	8	9	10	11	12	13	14	17	18	28	32\n12	8	9	34	19	45	15343	40	8	14	3	13	3	4	1	1\n12	8	10	6	7	8	9	10	11	12	13	14	17	18\n12	8	10	9	3	11	92	10236	6	3	4	3	3	2\n12	8	11	6	7	8	9	10	11	12	13	14	15	16\n12	8	11	77	4	11	38	167	136994	650	66	38	6	9\n12	8	12	6	7	8	9	10	11	12	13	14	15	16	17	18	21	23\n12	8	12	39	2	9	17	42	903	108345	78	32	24	4	11	42	3	1\n12	8	13	6	8	9	10	11	12	13	14	15	16	17	18	21	23\n12	8	13	267	11	32	23	60	459	89990	102	332	6	2	4	2	2\n12	8	14	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n12	8	14	5	26	13	37	37	85	386	93322	16	184	18	4	1	10	4	2\n12	8	15	6	8	9	10	11	12	13	14	15	16	17	18	20	21	23	24\n12	8	15	137	3	50	9	2	34	359	194	62168	408	14	14	4	21	1	2\n12	8	16	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n12	8	16	6	4	12	1	1	1	11	193	478	38875	70	2	1	67	1\n12	8	17	8	9	10	12	13	14	15	16	17	18\n12	8	17	3	1	3	1	1	6	4	51	2514	1\n12	8	18	6	8	9	10	11	12	13	14	15	17	18	19	20	21	22	23	24	28\n12	8	18	8	12	4	1	1	3	1	1	1	2	53	1	1	3	1	3	1	1\n12	8	19	17	18	19	21	24\n12	8	19	1	1	2	2	2\n12	8	20	8	10	11	12	14	15	16	17	20	24	25	29	37\n12	8	20	1	5	3	1	13	2	43	1	31531	1	1	1	27\n12	8	21	6	9	12	13	14	21	23\n12	8	21	2	6	3	7	1	2153	2\n12	8	22	12	13	14	18	19	20	21	22	36\n12	8	22	1	1	2	1	1	1	1	2	1\n12	8	23	23	33\n12	8	23	2	1\n12	8	24	22	24	25\n12	8	24	1	2	1\n12	8	25	15	20	22	25\n12	8	25	2	1	1	7\n12	8	27	21	27	30\n12	8	27	1	8	1\n12	8	28	28\n12	8	28	9\n12	8	29	29	37\n12	8	29	1	2\n12	8	30	30	31	32\n12	8	30	7	1	1\n12	8	32	32\n12	8	32	6\n12	8	33	35\n12	8	33	1\n12	8	35	33	35	37\n12	8	35	1	1	1\n12	8	37	20	37\n12	8	37	56	678\n12	8	40	40\n12	8	40	1\n12	9	0	0\n12	9	0	38\n12	9	6	6	9	27\n12	9	6	9668	275	1\n12	9	7	6	7	8	10	11\n12	9	7	2	6458	2	2	1\n12	9	8	6	7	8	9	10	12	13	14	17\n12	9	8	3	17	8904	23	7	3	14	4	1\n12	9	9	6	7	8	9	10	11	12	13	18	27\n12	9	9	14	13	40	15659	27	3	1	5	1	1\n12	9	10	7	8	9	10	11	12	13	14	17	18\n12	9	10	1	11	82	10434	11	2	10	13	1	2\n12	9	11	6	7	9	10	11	12	13	14	15	16	18	19	23\n12	9	11	6	1	32	87	137214	610	45	1	7	10	1	2	3\n12	9	12	6	8	9	10	11	12	13	14	15	16	18	21\n12	9	12	12	2	3	22	813	108617	78	15	29	6	1	2\n12	9	13	6	8	9	10	11	12	13	14	15	16	17	18	20	22	23	27\n12	9	13	52	4	4	16	64	380	89948	72	357	7	2	1	1	1	1	1\n12	9	14	6	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23\n12	9	14	3	5	1	33	63	357	93033	36	280	18	76	2	9	1	1	2\n12	9	15	6	8	9	10	11	12	13	14	15	16	17	18	20	21	22	25	27\n12	9	15	15	3	6	2	3	27	330	191	61966	404	6	31	4	44	1	1	2\n12	9	16	8	9	10	11	12	13	14	15	16	17	20	23\n12	9	16	2	1	2	2	6	6	159	472	38840	59	31	1\n12	9	17	13	14	15	16	17	18	21\n12	9	17	1	3	4	53	2572	5	1\n12	9	18	6	11	18	19	21	23	27\n12	9	18	2	1	106	1	15	1	2\n12	9	19	15	19	21\n12	9	19	1	5	1\n12	9	20	14	15	16	20	37\n12	9	20	7	2	34	31567	61\n12	9	21	12	13	14	15	16	18	20	21\n12	9	21	3	2	1	1	1	2	1	2180\n12	9	22	18	22\n12	9	22	2	4\n12	9	23	23	24	37\n12	9	23	11	1	1\n12	9	24	21	23	24\n12	9	24	1	1	6\n12	9	25	15	21	25	27	32\n12	9	25	1	1	5	2	1\n12	9	27	21	27\n12	9	27	1	7\n12	9	28	27	28\n12	9	28	1	10\n12	9	29	29\n12	9	29	2\n12	9	30	28	30\n12	9	30	2	6\n12	9	31	31\n12	9	31	1\n12	9	32	30	32\n12	9	32	1	7\n12	9	33	33\n12	9	33	2\n12	9	35	35\n12	9	35	2\n12	9	36	36\n12	9	36	1\n12	9	37	20	37	38\n12	9	37	36	671	1\n12	9	40	9\n12	9	40	1\n12	10	0	0\n12	10	0	38\n12	10	6	6	9	15	17\n12	10	6	9732	42	1	2\n12	10	7	7\n12	10	7	6490\n12	10	8	7	8	9	10	13\n12	10	8	328	8637	1	4	3\n12	10	9	6	7	8	9	10	11	20\n12	10	9	1257	445	292	14074	15	3	1\n12	10	10	7	8	9	10	11	12	13	17	24\n12	10	10	67	128	272	10114	5	5	6	1	1\n12	10	11	6	8	9	10	11	12	13	14	15	16\n12	10	11	3	344	325	215	136459	756	37	1	4	1\n12	10	12	7	8	9	10	11	12	13	14	15	16\n12	10	12	115	410	495	581	6023	101999	46	8	30	5\n12	10	13	6	8	9	10	11	12	13	14	15	16	17\n12	10	13	7	120	272	196	1028	1296	87466	49	352	9	1\n12	10	14	6	9	10	11	12	13	14	15	16	17	18	20	23	36\n12	10	14	1	150	419	1089	1059	2205	88179	16	308	28	8	35	1	1\n12	10	15	6	9	10	11	12	13	14	15	16	17	20\n12	10	15	5	116	133	345	785	6458	1545	53093	382	5	9\n12	10	16	9	10	11	12	13	14	15	16	17	18	19	20\n12	10	16	4	3	79	124	188	1938	1275	35935	55	4	1	29\n12	10	17	9	10	12	13	14	15	16	17	21	22\n12	10	17	2	4	2	2	5	8	40	2594	1	1\n12	10	18	10	11	12	13	14	15	16	17	18	19\n12	10	18	19	7	34	5	77	19	1	4	61	1\n12	10	19	11	14	16	18	19\n12	10	19	1	1	2	1	5\n12	10	20	11	12	13	14	15	16	17	18	20	25	37\n12	10	20	24	29	53	232	228	21379	937	1	8754	1	11\n12	10	21	10	12	13	14	15	17	18	19	21	35\n12	10	21	1	762	807	19	34	2	13	1	607	1\n12	10	22	13	16	19	22	24\n12	10	22	1	1	1	3	1\n12	10	23	11	13	14	15	16	18	20	23\n12	10	23	2	2	2	1	1	3	5	4\n12	10	24	13	14	24\n12	10	24	1	1	5\n12	10	25	12	13	15	21	25\n12	10	25	1	1	2	1	1\n12	10	27	14	15	25	27\n12	10	27	1	3	2	11\n12	10	28	22	23	25	27	28\n12	10	28	1	1	1	2	7\n12	10	29	18	24\n12	10	29	1	1\n12	10	30	28	30\n12	10	30	1	6\n12	10	31	31\n12	10	31	1\n12	10	32	28	30	31	32\n12	10	32	1	2	1	4\n12	10	33	33\n12	10	33	2\n12	10	35	35\n12	10	35	2\n12	10	36	36\n12	10	36	1\n12	10	37	16	17	18	20	35	37\n12	10	37	322	98	1	123	1	188\n12	10	38	37\n12	10	38	1\n12	11	0	0\n12	11	0	38\n12	11	6	6	9	18\n12	11	6	11002	2	1\n12	11	7	7\n12	11	7	7445\n12	11	8	7	8	10	13\n12	11	8	205	9720	3	3\n12	11	9	6	7	8	9	10	11	12	13\n12	11	9	622	269	221	14608	19	1	1	12\n12	11	10	7	8	9	10	11	12	13\n12	11	10	35	103	267	11287	6	1	5\n12	11	11	8	9	10	11	12	13	14	15	16\n12	11	11	195	298	207	143413	859	67	2	14	10\n12	11	12	6	7	8	9	10	11	12	13	14	15	16\n12	11	12	1	8	130	184	352	3903	102180	54	1	32	7\n12	11	13	6	8	9	10	11	12	13	14	15	16	17\n12	11	13	4	66	154	140	645	1157	94662	73	351	28	1\n12	11	14	9	10	11	12	13	14	15	16	17	20	27\n12	11	14	50	244	225	560	1279	89180	20	410	32	57	1\n12	11	15	6	9	10	11	12	13	14	15	16	17	20	21\n12	11	15	1	20	51	161	342	3691	873	49613	295	6	12	1\n12	11	16	10	11	12	13	14	15	16	17	18	20\n12	11	16	2	30	89	139	931	1189	55956	29	1	20\n12	11	17	10	12	13	14	15	16	17\n12	11	17	2	3	3	9	8	50	3652\n12	11	18	9	10	11	12	13	14	15	16	17	18	25\n12	11	18	3	4	2	14	2	34	5	2	4	22	1\n12	11	19	11	12	14	15	16	19\n12	11	19	1	1	1	1	2	3\n12	11	20	14	15	16	17	18	20\n12	11	20	12	27	2548	91	1	6277\n12	11	21	12	13	14	15	16	17	18	21	23\n12	11	21	150	189	8	9	1	2	2	247	1\n12	11	22	13	17	18	22\n12	11	22	1	1	1	2\n12	11	23	14	21	23\n12	11	23	2	1	3\n12	11	24	15	21	24	32\n12	11	24	1	2	4	1\n12	11	25	16	23	25\n12	11	25	1	1	3\n12	11	27	15	21	23	25	27\n12	11	27	1	1	1	3	7\n12	11	28	21	23	25	26	27	28\n12	11	28	1	1	2	1	1	3\n12	11	30	27	28	30\n12	11	30	3	1	4\n12	11	31	27	31\n12	11	31	1	1\n12	11	32	32\n12	11	32	4\n12	11	33	33\n12	11	33	2\n12	11	35	29	35	37\n12	11	35	1	2	1\n12	11	36	13	36\n12	11	36	1	1\n12	11	37	16	17	20	37\n12	11	37	51	13	29	107\n13	1	0	0\n13	1	0	43\n13	1	6	6	9\n13	1	6	4637	483\n13	1	7	7	8	9	10	12\n13	1	7	3934	71	149	25	4\n13	1	8	7	8	9	10	11	12	13\n13	1	8	8	6442	121	58	67	123	23\n13	1	9	6	7	8	9	10	11	12	13	14	15\n13	1	9	2	8	39	9873	71	133	89	79	13	5\n13	1	10	7	8	9	10	11	12	13	14	15\n13	1	10	2	5	88	6367	71	225	52	73	18\n13	1	11	8	9	10	11	12	13	14	15	16	17\n13	1	11	1	23	69	98473	736	193	79	44	10	1\n13	1	12	9	10	11	12	13	14	15	16	17	21\n13	1	12	8	8	2918	81654	270	192	119	23	1	186\n13	1	13	8	9	10	11	12	13	14	15	16	17	18	20	21	22\n13	1	13	4	9	8	149	416	68197	393	611	44	7	1	1	205	1\n13	1	14	11	12	13	14	15	16	17	18	19	20	21\n13	1	14	16	111	367	67338	176	191	2	3	22	7	2\n13	1	15	11	12	13	14	15	16	17	18	19	20	21	23\n13	1	15	43	107	1487	111	48989	385	13	16	12	7	25	7\n13	1	16	11	12	13	14	15	16	17	18	19	20	21	23	37\n13	1	16	9	19	76	1182	673	42138	28	9	1	4500	56	3	169\n13	1	17	13	14	15	16	17	18	19	20	21	23	28	37\n13	1	17	22	78	48	67	2647	37	1	244	30	21	1	53\n13	1	18	13	14	15	16	17	18	19	20	21	23	27\n13	1	18	4	1	9	4	7	326	4	5	29	39	3\n13	1	19	14	15	16	17	18	19	20	21	23	26	27\n13	1	19	1	3	3	1	5	77	3	5	3	1	2\n13	1	20	14	15	16	17	18	19	20	21	22	23	24	25	28	37\n13	1	20	94	16	55	1	5	4	7062	4	2	1	1	1	2	58\n13	1	21	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n13	1	21	1	3	1	1	2	5	546	3	30	1	2	2	3	2	1\n13	1	22	18	20	21	22	26	27	28	29\n13	1	22	1	4	1	25	1	2	2	3\n13	1	23	18	19	21	23	25	27	28	31\n13	1	23	2	3	5	165	1	1	1	1\n13	1	24	20	21	22	24	26	27\n13	1	24	1	1	1	14	1	3\n13	1	25	12	23	25	28	31\n13	1	25	1	5	14	1	1\n13	1	26	22	25	26	29	31\n13	1	26	1	1	14	1	2\n13	1	27	22	27\n13	1	27	1	21\n13	1	28	15	21	28\n13	1	28	1	1	5\n13	1	29	27	29\n13	1	29	1	6\n13	1	30	12	28	30	31	35\n13	1	30	1	1	3	1	1\n13	1	31	28	31\n13	1	31	1	16\n13	1	32	32	38\n13	1	32	4	1\n13	1	33	33\n13	1	33	1\n13	1	35	35\n13	1	35	1\n13	1	37	37\n13	1	37	351\n13	1	39	37	39\n13	1	39	1	1\n13	2	0	0\n13	2	0	43\n13	2	6	6	9\n13	2	6	4426	213\n13	2	7	7	8	9	10	12\n13	2	7	3769	76	74	8	25\n13	2	8	7	8	9	10	11	12	13\n13	2	8	2	6170	57	30	101	179	23\n13	2	9	6	7	8	9	10	11	12	13	14	15	17\n13	2	9	1	15	28	10333	50	92	126	46	31	31	1\n13	2	10	8	9	10	11	12	13	14	15	17\n13	2	10	7	68	6193	44	145	24	92	32	1\n13	2	11	8	9	10	11	12	13	14	15	16	20\n13	2	11	2	26	74	100097	1223	216	137	78	22	4\n13	2	12	9	10	11	12	13	14	15	16	17	19	20	21\n13	2	12	4	13	1666	80773	248	259	120	32	1	4	2	364\n13	2	13	8	9	10	11	12	13	14	15	16	17	18	20	21	23\n13	2	13	3	2	4	79	464	68340	487	1013	30	3	5	6	333	1\n13	2	14	11	12	13	14	15	16	17	18	19	20	21\n13	2	14	12	61	388	68381	298	341	3	1	46	23	1\n13	2	15	11	12	13	14	15	16	17	18	19	20	21	23	29	30\n13	2	15	23	96	1175	112	48870	246	7	16	29	30	93	14	1	1\n13	2	16	11	12	13	14	15	16	17	18	19	20	21	23	37\n13	2	16	4	6	42	665	697	30862	26	5	1	10363	69	8	175\n13	2	17	13	14	15	16	17	18	19	20	21	23	37\n13	2	17	20	34	28	62	2137	13	1	303	26	43	42\n13	2	18	13	15	16	17	18	20	21	22	23	26	27\n13	2	18	6	7	4	6	269	3	39	2	53	1	16\n13	2	19	15	16	17	18	19	20	21	23\n13	2	19	1	1	3	2	109	1	7	2\n13	2	20	11	14	15	16	17	18	19	20	21	22	25	26	27	37\n13	2	20	1	51	10	45	5	1	1	11661	3	2	4	1	5	49\n13	2	21	18	20	21	22	23	24	25	26	27	28\n13	2	21	3	9	1016	1	52	1	2	5	5	2\n13	2	22	13	20	21	22	23	25	26	27	28\n13	2	22	1	4	3	18	3	2	1	1	1\n13	2	23	19	21	22	23	25\n13	2	23	1	13	1	258	1\n13	2	24	21	24	26	28	29	32\n13	2	24	1	8	2	3	1	1\n13	2	25	23	25	26	27	28\n13	2	25	2	9	2	1	5\n13	2	26	17	23	24	26	30	31\n13	2	26	1	1	2	11	1	3\n13	2	27	12	21	26	27	28	30\n13	2	27	1	1	1	30	2	1\n13	2	28	23	24	26	28\n13	2	28	1	1	1	13\n13	2	29	27	29\n13	2	29	1	10\n13	2	30	28	30\n13	2	30	1	2\n13	2	31	28	31\n13	2	31	2	19\n13	2	32	32\n13	2	32	4\n13	2	33	33\n13	2	33	1\n13	2	35	33	37\n13	2	35	1	1\n13	2	37	20	37\n13	2	37	19	613\n13	2	38	38\n13	2	38	1\n13	2	39	39\n13	2	39	1\n13	3	0	0\n13	3	0	43\n13	3	6	6\n13	3	6	4427\n13	3	7	7\n13	3	7	3786\n13	3	8	7	8\n13	3	8	14	6272\n13	3	9	6	7	8	9	10\n13	3	9	2	7	15	10748	5\n13	3	10	7	8	9	10	11\n13	3	10	1	5	59	6305	2\n13	3	11	9	10	11	12	13\n13	3	11	28	74	101905	97	15\n13	3	12	9	10	11	12	13	14	15	16\n13	3	12	4	9	1563	81485	23	10	4	1\n13	3	13	8	9	10	11	12	13	14	15	16	21\n13	3	13	1	2	4	82	452	69868	36	80	3	1\n13	3	14	10	11	12	13	14	15	16\n13	3	14	1	17	91	392	69714	7	27\n13	3	15	11	12	13	14	15	16	17	19\n13	3	15	13	63	1050	118	49852	84	4	1\n13	3	16	12	13	14	15	16	17	20\n13	3	16	5	12	478	732	30400	12	6\n13	3	17	13	14	15	16	17	18\n13	3	17	16	24	20	72	2061	1\n13	3	18	12	13	14	15	16	17	18	23\n13	3	18	1	10	4	2	2	3	292	1\n13	3	19	13	14	15	16	17	19	24\n13	3	19	1	2	1	4	4	179	1\n13	3	20	14	15	16	17	18	19	20	21	37\n13	3	20	19	5	56	1	1	2	22337	2	5\n13	3	21	13	14	15	16	18	19	20	21	23	27\n13	3	21	2	1	1	6	4	5	5	1941	3	1\n13	3	22	18	19	20	21	22\n13	3	22	1	2	3	2	16\n13	3	23	15	18	19	20	21	22	23\n13	3	23	1	2	4	4	22	3	402\n13	3	24	20	24\n13	3	24	2	10\n13	3	25	20	21	23	25\n13	3	25	1	1	1	15\n13	3	26	21	22	23	25	26\n13	3	26	3	1	1	2	18\n13	3	27	20	21	26	27	32\n13	3	27	1	2	1	54	1\n13	3	28	19	20	22	23	25	26	28	30\n13	3	28	1	1	1	5	2	1	16	2\n13	3	29	28	29	30\n13	3	29	1	10	1\n13	3	30	28	30\n13	3	30	1	4\n13	3	31	25	26	27	28	31	40\n13	3	31	4	4	1	2	10	1\n13	3	32	30	32\n13	3	32	1	4\n13	3	33	33\n13	3	33	2\n13	3	37	20	37\n13	3	37	62	818\n13	3	38	37\n13	3	38	1\n13	3	39	40\n13	3	39	1\n13	4	0	0\n13	4	0	43\n13	4	6	6\n13	4	6	4429\n13	4	7	7\n13	4	7	3808\n13	4	8	7	8	9\n13	4	8	9	6283	1\n13	4	9	6	7	8	9	10	18\n13	4	9	10	14	35	10770	11	1\n13	4	10	7	8	9	10	11\n13	4	10	2	3	62	6327	4\n13	4	11	7	9	10	11	12	13	14\n13	4	11	1	30	75	103253	193	29	1\n13	4	12	7	9	10	11	12	13	14	15	21\n13	4	12	1	15	9	1201	80898	43	11	15	1\n13	4	13	8	9	10	11	12	13	14	15	17	18	21\n13	4	13	2	19	2	48	417	70730	43	122	2	3	1\n13	4	14	9	10	11	12	13	14	15	16	17	20\n13	4	14	1	1	23	87	312	69908	14	55	3	2\n13	4	15	11	12	13	14	15	16	17\n13	4	15	3	53	751	117	49623	155	3\n13	4	16	9	11	12	13	14	15	16	17	18	20	21\n13	4	16	2	2	1	19	282	622	29674	35	1	16	1\n13	4	17	12	13	14	15	16	17	18	19\n13	4	17	3	22	10	32	68	1948	1	1\n13	4	18	9	10	12	13	14	15	16	17	18	20	22\n13	4	18	1	2	2	4	4	6	3	4	273	1	1\n13	4	19	12	13	14	15	16	17	18	19\n13	4	19	2	2	1	4	2	1	1	181\n13	4	20	9	11	14	15	16	17	18	19	20	21	37\n13	4	20	2	1	6	7	53	1	4	4	22333	1	10\n13	4	21	13	14	15	16	17	18	19	20	21	23\n13	4	21	2	2	8	1	2	4	3	14	1934	4\n13	4	22	9	10	12	18	20	22\n13	4	22	1	2	1	1	7	9\n13	4	23	15	18	19	21	23	27\n13	4	23	3	5	4	12	388	1\n13	4	24	9	10	24	28\n13	4	24	1	1	8	1\n13	4	25	19	20	21	22	23	25\n13	4	25	1	3	1	1	4	13\n13	4	26	10	18	20	25	26\n13	4	26	1	2	1	2	18\n13	4	27	10	17	18	27\n13	4	27	1	1	1	53\n13	4	28	10	23	26	27	28	30\n13	4	28	1	1	2	2	13	1\n13	4	29	29\n13	4	29	10\n13	4	30	10	30	33\n13	4	30	1	6	1\n13	4	31	28	31\n13	4	31	1	9\n13	4	32	22	25	32	35\n13	4	32	1	1	2	1\n13	4	33	33\n13	4	33	2\n13	4	37	20	32	35	37\n13	4	37	66	1	1	756\n13	4	40	40\n13	4	40	2\n13	5	0	0\n13	5	0	43\n13	5	6	6	8	11\n13	5	6	4436	2	1\n13	5	7	7\n13	5	7	3835\n13	5	8	7	8\n13	5	8	6	6317\n13	5	9	6	7	8	9	10	11	13\n13	5	9	13	10	32	10823	23	3	1\n13	5	10	7	8	9	10	11	13\n13	5	10	1	7	65	6357	2	2\n13	5	11	7	8	9	10	11	12	13	14	15	16\n13	5	11	4	9	38	71	104144	249	13	3	1	3\n13	5	12	7	8	9	10	11	12	13	14	15	16	18\n13	5	12	1	11	10	16	1164	80373	49	15	15	2	1\n13	5	13	8	9	10	11	12	13	14	15	17	21\n13	5	13	54	13	3	100	397	71134	46	162	4	1\n13	5	14	8	10	11	12	13	14	15	16	18	19	20\n13	5	14	2	4	25	140	318	69812	9	72	1	1	1\n13	5	15	8	11	12	13	14	15	16	17	18	20\n13	5	15	3	8	69	704	127	49354	179	8	2	2\n13	5	16	8	9	11	12	13	14	15	16	17	18	19	20	21\n13	5	16	24	3	8	2	14	243	657	29012	29	1	1	16	1\n13	5	17	8	9	11	12	13	14	15	16	17	19\n13	5	17	3	3	7	16	28	10	23	102	1807	1\n13	5	18	8	9	11	13	14	15	16	17	18	19	22\n13	5	18	3	1	2	28	4	72	6	27	151	1	2\n13	5	19	8	9	11	12	15	17	18	19\n13	5	19	13	1	4	7	7	1	3	158\n13	5	20	8	9	11	12	13	14	15	16	17	18	19	20	22	37\n13	5	20	16	2	2	16	7	9	10	57	2	4	4	22310	1	3\n13	5	21	8	11	12	13	14	15	16	17	18	20	21\n13	5	21	1	4	3	15	21	126	41	36	19	1	1684\n13	5	22	8	9	17	18	22\n13	5	22	2	1	1	2	6\n13	5	23	8	9	11	13	15	16	17	18	21	23	26	30\n13	5	23	2	3	7	9	64	15	66	117	47	65	1	1\n13	5	24	18	19	24	28\n13	5	24	1	1	5	1\n13	5	25	8	10	13	17	25\n13	5	25	3	1	4	3	5\n13	5	26	10	17	21	22	23	26	27\n13	5	26	2	2	4	1	1	9	1\n13	5	27	16	18	19	20	21	25	26	27	30\n13	5	27	3	4	5	1	8	2	2	30	1\n13	5	28	9	13	17	21	24	26	28	31\n13	5	28	1	4	1	1	1	1	5	1\n13	5	29	21	22	24	25	29\n13	5	29	3	2	2	1	2\n13	5	30	28	30	34\n13	5	30	1	5	1\n13	5	31	10	11	13	17	31\n13	5	31	1	2	1	4	1\n13	5	32	32\n13	5	32	3\n13	5	33	33	35\n13	5	33	1	2\n13	5	35	35\n13	5	35	2\n13	5	37	20	34	37\n13	5	37	101	1	664\n13	5	40	40\n13	5	40	2\n13	6	0	0\n13	6	0	43\n13	6	6	6	7	9\n13	6	6	4412	36	1\n13	6	7	7\n13	6	7	3857\n13	6	8	7	8	9\n13	6	8	26	6474	4\n13	6	9	6	7	8	9	10	11\n13	6	9	7	37	30	10855	33	2\n13	6	10	7	8	9	10	11	13	14\n13	6	10	5	6	71	6390	3	2	1\n13	6	11	7	9	10	11	12	13	14	15	16\n13	6	11	18	24	74	105014	293	55	2	2	1\n13	6	12	7	8	9	10	11	12	13	14	15	22\n13	6	12	2	3	15	12	862	80270	61	27	19	1\n13	6	13	6	7	9	10	11	12	13	14	15	16	17\n13	6	13	1	52	5	4	49	369	71630	64	154	2	1\n13	6	14	7	9	10	11	12	13	14	15	16	17	18	20	21	23\n13	6	14	7	6	6	28	148	312	69674	15	88	1	1	2	1	1\n13	6	15	7	9	11	12	13	14	15	16	17	18\n13	6	15	16	1	5	46	438	166	49649	168	7	4\n13	6	16	9	12	13	14	15	16	17	18	20\n13	6	16	1	1	5	158	492	28766	47	1	21\n13	6	17	7	9	10	11	12	13	14	15	16	17\n13	6	17	3	3	2	1	2	18	7	33	66	1856\n13	6	18	7	9	10	12	13	14	15	16	17	18	21\n13	6	18	2	1	2	1	6	7	5	5	3	272	2\n13	6	19	7	9	11	12	13	14	15	17	18	19	20\n13	6	19	6	7	1	19	1	76	22	3	3	33	1\n13	6	20	7	14	15	16	17	18	20	21	37\n13	6	20	3	6	4	65	2	5	22330	1	16\n13	6	21	7	13	15	16	18	19	20	21	22\n13	6	21	1	4	135	51	15	2	4	1536	1\n13	6	22	10	22\n13	6	22	1	11\n13	6	23	15	16	17	23\n13	6	23	1	2	2	61\n13	6	24	15	21	24	28\n13	6	24	1	2	4	1\n13	6	25	10	16	18	20	21	25\n13	6	25	1	1	1	2	1	2\n13	6	26	16	18	19	20	21	26\n13	6	26	2	5	1	3	1	1\n13	6	27	18	20	21	22	24	27\n13	6	27	19	3	1	2	1	5\n13	6	28	20	21	24	28	30\n13	6	28	1	1	1	3	1\n13	6	29	28	29\n13	6	29	1	1\n13	6	30	30	31	32\n13	6	30	5	1	1\n13	6	31	31	32\n13	6	31	1	1\n13	6	32	24	32\n13	6	32	1	2\n13	6	33	33\n13	6	33	1\n13	6	34	30	34\n13	6	34	1	1\n13	6	35	35	37\n13	6	35	3	1\n13	6	37	20	37\n13	6	37	67	600\n13	6	40	40\n13	6	40	2\n13	7	0	0\n13	7	0	43\n13	7	6	6	9\n13	7	6	4410	10\n13	7	7	6	7	8	9	18\n13	7	7	115	3950	1	4	1\n13	7	8	6	7	8	9	10\n13	7	8	118	6	6374	14	1\n13	7	9	6	7	8	9	10	11	13	15	18	19\n13	7	9	226	13	52	10641	38	14	3	3	2	2\n13	7	10	6	8	9	10	11	12	13	14	15	17	26\n13	7	10	52	8	85	6363	6	5	1	2	1	1	1\n13	7	11	6	8	9	10	11	12	13	14	15\n13	7	11	252	4	66	349	104786	427	78	2	1\n13	7	12	6	8	9	10	11	12	13	14	15	17	18	23\n13	7	12	86	13	19	158	682	80050	62	39	34	3	2	1\n13	7	13	6	8	9	10	11	12	13	14	15	16	17	18	20\n13	7	13	1312	5	157	35	48	346	70391	57	172	3	4	1	1\n13	7	14	6	8	9	10	11	12	13	14	15	16	20	21	35\n13	7	14	50	61	21	49	34	112	364	69372	28	92	3	1	1\n13	7	15	6	8	9	10	11	12	13	14	15	16	17	18\n13	7	15	541	5	104	22	2	22	342	153	49151	188	1	1\n13	7	16	6	8	9	10	12	13	14	15	16	17	18	20	21	24\n13	7	16	28	23	29	14	15	46	135	480	28375	40	7	21	3	1\n13	7	17	6	8	9	10	12	13	14	15	16	17	18	19	21	32\n13	7	17	111	1	131	3	1	11	2	5	41	1596	16	2	1	1\n13	7	18	6	8	9	10	12	13	14	15	16	17	18	21	23\n13	7	18	98	12	111	1	3	9	3	7	3	5	72	1	1\n13	7	19	8	9	10	13	18	19	22\n13	7	19	3	2	1	2	1	26	1\n13	7	20	12	13	14	15	16	18	19	20	21	37\n13	7	20	2	2	3	3	65	3	1	22343	1	11\n13	7	21	6	8	9	10	11	12	13	15	16	18	21	22	24	30\n13	7	21	6	4	50	5	3	1	13	31	11	6	1411	1	3	1\n13	7	22	10	12	18	20	21	22\n13	7	22	2	1	2	3	1	6\n13	7	23	6	9	16	21	23\n13	7	23	8	46	6	1	1\n13	7	24	13	16	21	24\n13	7	24	2	1	1	3\n13	7	25	13	20\n13	7	25	1	1\n13	7	26	21\n13	7	26	1\n13	7	27	13	26	27\n13	7	27	3	1	1\n13	7	28	21	25	28	30\n13	7	28	1	1	2	1\n13	7	29	23\n13	7	29	1\n13	7	30	30	32\n13	7	30	6	1\n13	7	31	23	31\n13	7	31	1	1\n13	7	32	32	33	37\n13	7	32	2	1	1\n13	7	33	33\n13	7	33	1\n13	7	34	33\n13	7	34	1\n13	7	35	33	35\n13	7	35	1	2\n13	7	37	20	37\n13	7	37	52	565\n13	7	40	40\n13	7	40	2\n13	8	0	0\n13	8	0	43\n13	8	6	6	9	13	24\n13	8	6	7409	2	1	1\n13	8	7	6	7	9\n13	8	7	43	3897	29\n13	8	8	6	7	8	9	10	13	15	19	30\n13	8	8	60	11	6486	2	3	1	1	1	1\n13	8	9	6	7	8	9	10	11	12	17	26	32\n13	8	9	72	15	48	11325	20	2	4	1	1	2\n13	8	10	6	8	9	10	11	12	13	14\n13	8	10	17	15	63	6928	6	3	7	2\n13	8	11	6	8	9	10	11	12	13	14	15	16\n13	8	11	170	24	35	354	104391	402	55	138	5	1\n13	8	12	6	7	8	9	10	11	12	13	14	15	18	21\n13	8	12	117	4	38	12	158	583	79927	64	45	35	1	1\n13	8	13	6	8	9	10	11	12	13	14	15\n13	8	13	668	14	38	28	41	335	69912	70	224\n13	8	14	6	8	9	10	11	12	13	14	15	16	17	18	19	20	25\n13	8	14	12	100	17	102	28	68	259	69003	53	108	2	11	1	3	1\n13	8	15	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	25\n13	8	15	344	15	123	23	3	27	237	132	48748	242	3	12	2	1	2	1	1\n13	8	16	6	8	9	10	11	12	13	14	15	16	17	19	20\n13	8	16	14	14	38	9	1	7	2	122	382	28101	57	1	37\n13	8	17	8	9	10	13	14	16	17	25	28\n13	8	17	1	1	3	2	2	50	1589	1	1\n13	8	18	6	8	9	10	11	12	13	14	16	18	20	21\n13	8	18	8	24	6	6	4	1	15	1	1	46	1	1\n13	8	19	8	10	12	13	14	15	18	19	24	25\n13	8	19	4	5	1	1	2	5	5	5	2	1\n13	8	20	10	11	12	13	14	16	17	20	37\n13	8	20	6	3	2	6	5	40	1	22343	18\n13	8	21	6	9	12	13	14	18	19	21	25\n13	8	21	4	18	1	5	1	1	2	1390	1\n13	8	22	12	14	17	18	21	22	25\n13	8	22	1	2	1	1	1	1	1\n13	8	23	19	23\n13	8	23	1	4\n13	8	24	14	17	20	21	24\n13	8	24	1	1	1	1	3\n13	8	25	25\n13	8	25	1\n13	8	26	26\n13	8	26	2\n13	8	27	23\n13	8	27	1\n13	8	28	27	28\n13	8	28	1	1\n13	8	30	28	30	32\n13	8	30	1	5	2\n13	8	31	31\n13	8	31	1\n13	8	32	30	32	33\n13	8	32	1	2	1\n13	8	33	26	33\n13	8	33	1	3\n13	8	35	33	35\n13	8	35	1	2\n13	8	37	20	37\n13	8	37	41	536\n13	8	40	40\n13	8	40	2\n13	9	0	0\n13	9	0	43\n13	9	6	6	9	22	23	26	27\n13	9	6	8600	333	1	1	1	2\n13	9	7	6	7	8	9	12	13	23\n13	9	7	6	3914	3	1	1	1	1\n13	9	8	6	7	8	9	10	11	12	13	14	15	17	18	19	21\n13	9	8	10	18	6606	65	8	1	17	11	33	3	2	7	1	1\n13	9	9	6	7	8	9	10	11	12	13	14	17	18\n13	9	9	23	15	41	11587	16	1	3	10	8	1	4\n13	9	10	6	7	8	9	10	11	12	13	14	16	18	32\n13	9	10	2	2	9	61	7538	4	8	13	3	1	3	1\n13	9	11	6	7	8	9	10	11	12	13	14	15	16	18	23\n13	9	11	42	3	11	61	88	104369	406	15	30	9	7	19	2\n13	9	12	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21\n13	9	12	24	1	8	6	24	567	79954	56	12	31	2	5	85	2	2\n13	9	13	6	8	9	10	11	12	13	14	15	16	17	18	21	23\n13	9	13	157	3	16	27	50	329	69623	64	262	3	3	25	4	1\n13	9	14	6	8	9	10	11	12	13	14	15	16	18	20	23\n13	9	14	6	17	2	8	27	62	286	68966	15	129	6	1	1\n13	9	15	6	8	9	10	11	12	13	14	15	16	17	18	20	21	23	24\n13	9	15	61	2	22	6	3	18	219	138	48646	271	1	29	3	30	1	3\n13	9	16	6	8	9	10	11	12	13	14	15	16	17	18	19	20	23\n13	9	16	2	17	10	2	8	6	4	94	379	27948	37	4	1	27	4\n13	9	17	12	14	15	16	17	18	21	22	25	32\n13	9	17	1	1	3	35	1602	6	1	3	2	1\n13	9	18	6	9	12	16	18	19	21	23	24\n13	9	18	2	2	1	1	45	3	13	2	8\n13	9	19	16	19	21	23\n13	9	19	1	10	1	1\n13	9	20	13	15	16	17	20	22	37\n13	9	20	2	1	24	2	22375	1	22\n13	9	21	6	9	11	12	13	19	20	21	23	24\n13	9	21	1	3	1	1	2	1	1	1384	1	1\n13	9	22	22\n13	9	22	1\n13	9	23	15	23\n13	9	23	1	5\n13	9	24	18	24\n13	9	24	1	5\n13	9	25	18	22	25\n13	9	25	1	1	5\n13	9	26	22	23	27	30\n13	9	26	1	1	1	1\n13	9	27	27\n13	9	27	1\n13	9	28	28	32\n13	9	28	2	1\n13	9	30	28	30	32\n13	9	30	1	4	2\n13	9	31	33\n13	9	31	1\n13	9	32	32\n13	9	32	6\n13	9	33	33\n13	9	33	5\n13	9	35	35\n13	9	35	2\n13	9	37	20	37\n13	9	37	28	526\n13	9	40	40\n13	9	40	2\n13	10	0	0\n13	10	0	43\n13	10	6	6	9	11	15	18\n13	10	6	8769	164	1	1	1\n13	10	7	6	7	9	10	14	18\n13	10	7	5	3936	8	2	1	1\n13	10	8	6	7	8	9	11	12	13\n13	10	8	2	11	6678	1	1	2	22\n13	10	9	6	7	8	9	10	11	13\n13	10	9	9	15	39	12096	5	1	4\n13	10	10	7	8	9	10	11	12	13	14	16	18	19\n13	10	10	1	9	48	7618	6	6	15	7	3	3	1\n13	10	11	6	8	9	10	11	12	13	14	15	16	17	18	19	23\n13	10	11	10	3	32	48	104476	417	18	5	7	2	1	2	4	6\n13	10	12	6	9	10	11	12	13	14	15	16	21	23\n13	10	12	3	4	9	439	80284	43	6	16	1	1	1\n13	10	13	6	10	11	12	13	14	15	16	21	23\n13	10	13	32	9	42	343	69539	36	225	5	3	8\n13	10	14	6	8	10	11	12	13	14	15	16	17	18	19	20	23	24	25\n13	10	14	2	3	1	27	46	304	68729	16	135	4	61	1	13	5	1	1\n13	10	15	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n13	10	15	8	1	3	1	3	16	169	156	48707	257	1	23	1	3	1\n13	10	16	8	11	12	13	14	15	16	17	18	20	23	37\n13	10	16	1	1	1	1	67	316	27966	40	1	25	1	2\n13	10	17	12	13	14	15	16	17	18\n13	10	17	1	1	1	2	20	1627	1\n13	10	18	11	12	16	18	24\n13	10	18	1	1	2	229	2\n13	10	19	11	15	18	19	21	22	23\n13	10	19	4	1	1	9	1	1	1\n13	10	20	15	16	17	20	37\n13	10	20	4	20	1	22388	22\n13	10	21	12	13	16	18	21	22	23	24\n13	10	21	2	3	2	2	1423	2	1	1\n13	10	22	18	19	22	24\n13	10	22	2	1	4	1\n13	10	23	18	23\n13	10	23	1	20\n13	10	24	18	21	24	27\n13	10	24	1	6	9	1\n13	10	25	22	25\n13	10	25	2	5\n13	10	26	28\n13	10	26	1\n13	10	27	23	27	30\n13	10	27	1	2	1\n13	10	28	28\n13	10	28	3\n13	10	30	30	32\n13	10	30	4	1\n13	10	32	25	27	30	32	33	34\n13	10	32	1	1	1	6	1	1\n13	10	33	31	32	33\n13	10	33	1	1	4\n13	10	35	35\n13	10	35	2\n13	10	37	20	37\n13	10	37	27	521\n13	10	40	40\n13	10	40	2\n13	11	0	0\n13	11	0	43\n13	11	6	6	9	15\n13	11	6	8826	13	1\n13	11	7	7\n13	11	7	3963\n13	11	8	7	8	9	13	18	21\n13	11	8	239	6491	1	1	1	1\n13	11	9	6	7	8	9	10	11	25\n13	11	9	1196	205	212	10738	2	2	1\n13	11	10	7	8	9	10	11	13	14	18\n13	11	10	40	86	170	7386	4	3	3	1\n13	11	11	6	7	8	9	10	11	12	13	15\n13	11	11	1	1	262	253	152	103925	397	10	1\n13	11	12	6	7	8	9	10	11	12	13	14	15	18	19\n13	11	12	2	101	313	390	411	4833	75013	29	7	18	1	1\n13	11	13	6	8	9	10	11	12	13	14	15	16\n13	11	13	4	124	234	148	839	1093	67454	25	194	4\n13	11	14	8	9	10	11	12	13	14	15	16	17	18	20\n13	11	14	1	128	347	873	833	1748	64881	8	156	9	15	9\n13	11	15	6	9	10	11	12	13	14	15	16	17	20\n13	11	15	4	104	139	267	689	5642	1380	40858	206	2	4\n13	11	16	9	11	12	13	14	15	16	17	20\n13	11	16	2	74	94	156	1679	1061	25301	22	24\n13	11	17	10	12	13	14	15	16	17	18\n13	11	17	3	1	1	5	1	36	1624	3\n13	11	18	9	10	11	12	13	14	15	16	17	18	19\n13	11	18	2	40	4	61	13	57	29	3	7	112	1\n13	11	19	14	15	16	18	19\n13	11	19	1	4	2	2	8\n13	11	20	11	12	13	14	15	16	17	20	37\n13	11	20	24	22	41	159	171	16303	662	5073	1\n13	11	21	12	13	15	18	21	28\n13	11	21	540	493	18	8	375	1\n13	11	22	10	16	18	19	20	21	22\n13	11	22	1	1	1	1	2	1	2\n13	11	23	11	13	14	15	16	17	18	19	21	23	28\n13	11	23	7	5	5	1	5	1	2	1	2	13	2\n13	11	24	13	15	18	21	23	24	27\n13	11	24	2	3	3	1	1	3	1\n13	11	25	12	14	16	25\n13	11	25	1	1	1	4\n13	11	27	25	26	27	28\n13	11	27	1	1	1	1\n13	11	28	28\n13	11	28	4\n13	11	30	27	28	30\n13	11	30	1	1	4\n13	11	31	32\n13	11	31	1\n13	11	32	25	30	32\n13	11	32	1	1	6\n13	11	33	32	33\n13	11	33	4	1\n13	11	34	34\n13	11	34	1\n13	11	35	33	35\n13	11	35	1	1\n13	11	37	16	17	20	35	37\n13	11	37	261	69	84	1	130\n13	11	40	40\n13	11	40	2\n13	12	0	0\n13	12	0	43\n13	12	6	6	9	15\n13	12	6	10030	2	1\n13	12	7	7	10\n13	12	7	4547	2\n13	12	8	7	8	13\n13	12	8	164	7320	5\n13	12	9	6	7	8	9	10	11	12	13\n13	12	9	702	112	163	11035	16	1	2	4\n13	12	10	7	8	9	10	11	12	13\n13	12	10	21	55	191	8349	6	3	4\n13	12	11	6	8	9	10	11	12	13	15	16\n13	12	11	1	158	217	163	108852	1399	46	14	2\n13	12	12	7	8	9	10	11	12	13	14	15	16\n13	12	12	10	114	154	322	3014	75009	44	3	55	19\n13	12	13	6	8	9	10	11	12	13	14	15	16	17\n13	12	13	1	65	109	148	545	979	73119	48	556	24	4\n13	12	14	9	10	11	12	13	14	15	16	17	20\n13	12	14	53	186	169	449	1173	65467	28	570	50	58\n13	12	15	9	10	11	12	13	14	15	16	17	20	24\n13	12	15	25	45	139	276	2973	731	37737	419	3	19	1\n13	12	16	10	11	12	13	14	15	16	17	18	20\n13	12	16	1	31	58	136	766	867	40336	52	1	31\n13	12	17	10	12	13	14	15	16	17\n13	12	17	2	4	7	4	2	17	2360\n13	12	18	9	10	12	13	14	15	16	17	18	19\n13	12	18	4	6	39	8	43	14	3	3	28	1\n13	12	19	14	17	18	19\n13	12	19	5	1	2	4\n13	12	20	11	14	15	16	17	20\n13	12	20	1	7	9	1432	48	3699\n13	12	21	12	13	15	16	18	19	21\n13	12	21	90	123	2	1	1	1	162\n13	12	22	15	22\n13	12	22	1	1\n13	12	23	11	13	14	18	19	21	23\n13	12	23	1	1	1	2	2	1	6\n13	12	24	24\n13	12	24	3\n13	12	25	20	21	22	25\n13	12	25	2	1	1	3\n13	12	26	26\n13	12	26	1\n13	12	27	23	27	30\n13	12	27	1	1	1\n13	12	28	25	27	28	30\n13	12	28	1	1	6	1\n13	12	30	28	30\n13	12	30	1	4\n13	12	32	30	32\n13	12	32	4	7\n13	12	33	33	35\n13	12	33	1	1\n13	12	34	34\n13	12	34	1\n13	12	35	35\n13	12	35	2\n13	12	37	16	17	20	37\n13	12	37	34	12	19	66\n13	12	40	40\n13	12	40	2\n14	1	0	0\n14	1	0	31\n14	1	6	6	9\n14	1	6	3007	297\n14	1	7	7	8	9	10	12\n14	1	7	2984	53	99	12	1\n14	1	8	7	8	9	10	11	12	13\n14	1	8	4	4848	71	30	48	82	26\n14	1	9	6	7	8	9	10	11	12	13	14	15\n14	1	9	1	9	17	7768	58	123	77	60	7	12\n14	1	10	7	8	9	10	11	12	13	14	15\n14	1	10	2	7	67	4414	39	136	41	56	14\n14	1	11	8	9	10	11	12	13	14	15	16\n14	1	11	3	17	49	73863	560	199	64	34	12\n14	1	12	9	10	11	12	13	14	15	16	17	19	21\n14	1	12	6	9	2214	60577	155	156	72	26	2	1	94\n14	1	13	8	9	10	11	12	13	14	15	16	17	18	21\n14	1	13	7	8	7	110	326	52836	305	480	30	1	1	127\n14	1	14	11	12	13	14	15	16	17	19	20\n14	1	14	13	76	243	49437	158	145	3	40	2\n14	1	15	8	11	12	13	14	15	16	17	18	19	20	21	23\n14	1	15	1	25	111	1157	108	38987	285	1	5	15	5	65	5\n14	1	16	11	12	13	14	15	16	17	18	19	20	21	23	25	27	37\n14	1	16	3	17	42	882	499	30638	14	5	1	3224	97	6	1	1	103\n14	1	17	11	13	14	15	16	17	18	20	21	23	32	37\n14	1	17	1	10	39	14	39	1492	8	139	9	7	1	25\n14	1	18	12	13	14	15	16	17	18	20	21	23	27\n14	1	18	1	8	1	12	3	7	171	1	12	11	3\n14	1	19	14	15	16	17	19	20	21	23	24	26	27\n14	1	19	1	1	1	2	110	1	4	1	1	2	1\n14	1	20	14	15	16	17	18	19	20	21	23	25	27	28	37\n14	1	20	50	6	22	1	1	2	4570	3	1	3	2	1	26\n14	1	21	15	17	18	19	20	21	22	23	25	26	27	28	29	37\n14	1	21	1	1	3	1	4	438	1	9	1	2	4	1	3	1\n14	1	22	19	20	22	25	27	28\n14	1	22	1	2	7	1	1	2\n14	1	23	21	23	30\n14	1	23	7	66	1\n14	1	24	20	21	24	26	27	28	35\n14	1	24	2	2	10	1	2	1	1\n14	1	25	22	23	25	26	27	28	29	31\n14	1	25	1	3	12	2	1	1	1	1\n14	1	26	23	26	28	37\n14	1	26	1	5	1	1\n14	1	27	20	21	22	26	27\n14	1	27	1	1	1	1	9\n14	1	28	23	24	28\n14	1	28	1	1	12\n14	1	29	29	30\n14	1	29	1	1\n14	1	30	24	30\n14	1	30	1	2\n14	1	31	28	30	31	37\n14	1	31	2	1	5	1\n14	1	32	32	35\n14	1	32	2	1\n14	1	33	16	32\n14	1	33	1	1\n14	1	37	20	37\n14	1	37	2	223\n14	2	0	0\n14	2	0	31\n14	2	6	6	9\n14	2	6	2858	150\n14	2	7	7	8	9	10	12\n14	2	7	2859	53	60	7	20\n14	2	8	7	8	9	10	11	12	13	15\n14	2	8	4	4621	38	14	97	141	20	1\n14	2	9	6	7	8	9	10	11	12	13	14	15\n14	2	9	3	5	25	8000	48	81	83	51	18	19\n14	2	10	7	8	9	10	11	12	13	14	15\n14	2	10	2	3	44	4298	25	98	30	62	17\n14	2	11	8	9	10	11	12	13	14	15	16	20	28\n14	2	11	1	16	60	75067	931	186	99	73	4	1	1\n14	2	12	9	10	11	12	13	14	15	16	20	21\n14	2	12	4	3	1847	59386	201	167	95	55	3	203\n14	2	13	9	10	11	12	13	14	15	16	17	19	20	21\n14	2	13	3	3	55	330	52920	440	788	43	3	2	1	189\n14	2	14	11	12	13	14	15	16	19	20	21\n14	2	14	16	62	218	50303	200	247	30	29	1\n14	2	15	11	12	13	14	15	16	17	18	19	20	21	23\n14	2	15	14	76	991	109	38716	182	1	6	26	34	129	6\n14	2	16	11	12	13	14	15	16	17	20	21	23	37\n14	2	16	2	5	19	595	548	22146	11	7663	79	12	122\n14	2	17	13	14	15	16	17	18	20	21	23	26	37\n14	2	17	8	41	7	37	1193	5	195	6	8	1	23\n14	2	18	13	14	15	16	17	18	20	21	23	27\n14	2	18	2	1	4	3	5	146	6	15	8	4\n14	2	19	14	15	16	17	18	19	20	21	23	25	27\n14	2	19	1	2	1	1	5	150	2	5	1	1	2\n14	2	20	14	15	16	17	18	19	20	21	25	26	37\n14	2	20	29	5	28	1	1	1	7851	1	3	3	30\n14	2	21	15	17	19	20	21	23	25	27	28	29	32\n14	2	21	2	1	1	6	828	15	1	1	1	1	2\n14	2	22	20	22	26	27\n14	2	22	1	6	1	2\n14	2	23	19	21	23	28\n14	2	23	1	10	99	1\n14	2	24	21	22	23	24	29\n14	2	24	1	1	1	9	1\n14	2	25	22	23	25	26	29\n14	2	25	2	1	13	1	1\n14	2	26	21	23	26\n14	2	26	1	1	11\n14	2	27	21	27\n14	2	27	2	22\n14	2	28	23	25	26	28	30\n14	2	28	3	1	4	12	1\n14	2	29	29\n14	2	29	5\n14	2	30	30	32\n14	2	30	4	1\n14	2	31	23	28	31	33\n14	2	31	1	1	3	1\n14	2	32	28	32\n14	2	32	1	3\n14	2	35	35	37\n14	2	35	1	1\n14	2	37	20	37\n14	2	37	6	374\n14	3	0	0\n14	3	0	31\n14	3	6	6\n14	3	6	2861\n14	3	7	7\n14	3	7	2870\n14	3	8	7	8\n14	3	8	7	4696\n14	3	9	6	7	8	9	10\n14	3	9	2	10	19	8278	6\n14	3	10	7	8	9	10	11\n14	3	10	3	2	44	4383	1\n14	3	11	8	9	10	11	12	13\n14	3	11	1	17	52	77074	53	7\n14	3	12	9	10	11	12	13	14	15	21\n14	3	12	9	5	1162	59921	23	9	2	1\n14	3	13	8	9	10	11	12	13	14	15	23\n14	3	13	2	2	3	56	368	54144	31	39	1\n14	3	14	11	12	13	14	15	16\n14	3	14	18	66	293	51463	4	21\n14	3	15	8	11	12	13	14	15	16	18\n14	3	15	1	8	65	797	88	39456	61	1\n14	3	16	12	13	14	15	16	17	20\n14	3	16	2	5	315	549	21860	12	3\n14	3	17	13	14	15	16	17	18	21\n14	3	17	8	7	9	40	1150	1	1\n14	3	18	12	13	14	15	16	17	18\n14	3	18	1	3	3	9	3	3	141\n14	3	19	15	16	19\n14	3	19	3	1	207\n14	3	20	14	15	16	17	18	19	20	37\n14	3	20	7	10	32	1	1	1	15742	4\n14	3	21	15	16	19	20	21	23\n14	3	21	4	3	3	2	1456	2\n14	3	22	19	22\n14	3	22	1	8\n14	3	23	18	19	20	21	23\n14	3	23	1	5	4	6	140\n14	3	24	20	21	24\n14	3	24	1	1	7\n14	3	25	23	25\n14	3	25	2	17\n14	3	26	20	25	26\n14	3	26	1	1	19\n14	3	27	26	27	32\n14	3	27	1	29	1\n14	3	28	22	23	25	28	29\n14	3	28	4	4	1	7	1\n14	3	29	29\n14	3	29	8\n14	3	30	30\n14	3	30	5\n14	3	31	25	31\n14	3	31	1	2\n14	3	32	32	35\n14	3	32	5	1\n14	3	33	33\n14	3	33	1\n14	3	35	35\n14	3	35	1\n14	3	37	20	37\n14	3	37	33	517\n14	4	0	0\n14	4	0	31\n14	4	6	6\n14	4	6	2863\n14	4	7	7	9\n14	4	7	2889	1\n14	4	8	7	8\n14	4	8	8	4713\n14	4	9	6	7	8	9	10\n14	4	9	4	12	18	8307	9\n14	4	10	8	9	10	11	12	15\n14	4	10	5	51	4390	1	1	1\n14	4	11	8	9	10	11	12	13	15\n14	4	11	1	26	61	78145	72	11	3\n14	4	12	8	9	10	11	12	13	14	15	21\n14	4	12	1	7	6	958	59470	21	7	5	1\n14	4	13	8	9	10	11	12	13	14	15	17\n14	4	13	3	6	1	45	323	54831	31	39	1\n14	4	14	11	12	13	14	15	16\n14	4	14	20	70	269	51548	3	13\n14	4	15	11	12	13	14	15	16	17	18	19\n14	4	15	3	50	689	80	39192	68	1	1	1\n14	4	16	11	12	13	14	15	16	17	18	19	20	21\n14	4	16	1	4	4	226	525	21246	7	1	1	5	1\n14	4	17	12	13	14	15	16	17	18\n14	4	17	2	8	2	4	55	1094	1\n14	4	18	14	15	16	17	18\n14	4	18	1	7	6	2	129\n14	4	19	12	13	15	18	19	24\n14	4	19	2	2	5	1	206	1\n14	4	20	9	14	15	16	19	20	37\n14	4	20	2	2	3	32	2	15741	4\n14	4	21	12	15	16	17	18	19	20	21\n14	4	21	1	10	2	1	2	2	3	1444\n14	4	22	18	19	20	21	22\n14	4	22	1	1	1	1	8\n14	4	23	19	21	23	27	28	29\n14	4	23	3	5	138	1	1	1\n14	4	24	21	24\n14	4	24	3	4\n14	4	25	16	19	20	21	23	25\n14	4	25	1	1	2	3	1	12\n14	4	26	12	20	21	22	23	26\n14	4	26	1	2	1	1	1	14\n14	4	27	25	26	27\n14	4	27	1	1	27\n14	4	28	15	24	26	28	30\n14	4	28	1	1	1	3	1\n14	4	29	28	29	30\n14	4	29	1	7	1\n14	4	30	10	20	30	32\n14	4	30	1	1	2	1\n14	4	31	31\n14	4	31	2\n14	4	32	16	32	35\n14	4	32	1	4	1\n14	4	33	33\n14	4	33	1\n14	4	35	35\n14	4	35	2\n14	4	37	20	37\n14	4	37	43	478\n14	5	0	0\n14	5	0	31\n14	5	6	6	9\n14	5	6	2866	1\n14	5	7	7\n14	5	7	2909\n14	5	8	7	8	10\n14	5	8	4	4736	1\n14	5	9	6	7	8	9	10	11\n14	5	9	12	18	41	8306	21	2\n14	5	10	8	9	10\n14	5	10	9	55	4404\n14	5	11	8	9	10	11	12	13	14	15	16\n14	5	11	8	13	50	78921	158	18	2	1	2\n14	5	12	7	8	9	10	11	12	13	14	15	18	19\n14	5	12	1	4	6	7	792	59144	29	6	5	1	1\n14	5	13	7	8	9	10	11	12	13	14	15\n14	5	13	2	31	5	3	54	308	55329	21	82\n14	5	14	8	10	11	12	13	14	15	16	17	18	20	21\n14	5	14	1	2	24	81	236	51515	5	29	1	1	1	1\n14	5	15	11	12	13	14	15	16	18	20\n14	5	15	3	44	498	96	39044	111	1	1\n14	5	16	8	11	12	13	14	15	16	17	20	21\n14	5	16	13	2	2	9	146	401	20818	23	9	1\n14	5	17	8	12	13	14	15	16	17	21\n14	5	17	1	2	11	7	8	36	1040	1\n14	5	18	12	13	14	15	16	17	18\n14	5	18	1	9	3	17	7	5	94\n14	5	19	8	9	11	12	14	15	18	19\n14	5	19	10	1	2	2	2	5	2	193\n14	5	20	8	12	13	15	16	18	19	20	37\n14	5	20	6	8	4	5	29	1	1	15739	5\n14	5	21	8	11	12	13	14	15	16	17	18	21\n14	5	21	1	1	1	5	6	59	13	9	4	1360\n14	5	22	8	19	20	21	22	28\n14	5	22	3	1	1	1	2	1\n14	5	23	8	9	11	13	15	16	17	18	19	21	23\n14	5	23	4	2	1	1	16	3	18	36	1	11	47\n14	5	24	20	21	24\n14	5	24	1	1	4\n14	5	25	10	11	17	21	24	25\n14	5	25	1	1	1	1	2	7\n14	5	26	16	17	21	26\n14	5	26	1	2	1	12\n14	5	27	16	18	20	21	24	26	27	31\n14	5	27	3	2	1	1	1	1	18	1\n14	5	28	9	21	28	32\n14	5	28	1	1	2	1\n14	5	29	16	22	24	25	29	30\n14	5	29	1	1	1	3	1	1\n14	5	30	26	30\n14	5	30	1	3\n14	5	31	17\n14	5	31	2\n14	5	32	32\n14	5	32	5\n14	5	33	26\n14	5	33	1\n14	5	35	35	38\n14	5	35	2	1\n14	5	37	20	34	35	37\n14	5	37	37	1	1	443\n14	6	0	0\n14	6	0	31\n14	6	6	6	7\n14	6	6	2874	4\n14	6	7	6	7\n14	6	7	1	2933\n14	6	8	7	8\n14	6	8	14	4854\n14	6	9	6	7	8	9	10	11	12	24\n14	6	9	12	22	28	8305	18	2	2	1\n14	6	10	7	8	9	10	11\n14	6	10	3	3	49	4431	3\n14	6	11	7	8	9	10	11	12	13	14	16\n14	6	11	8	1	29	70	79470	178	39	5	3\n14	6	12	7	8	9	10	11	12	13	14	15	17\n14	6	12	7	8	15	14	642	59004	37	13	9	2\n14	6	13	7	9	10	11	12	13	14	15	16	17	20\n14	6	13	51	6	3	43	305	55601	44	93	1	1	1\n14	6	14	7	9	10	11	12	13	14	15	16	17	18	22\n14	6	14	3	1	4	14	130	259	51337	11	42	1	1	1\n14	6	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20\n14	6	15	20	1	2	1	3	44	448	127	38879	115	4	1	2	1\n14	6	16	7	9	10	12	13	14	15	16	17	19	20\n14	6	16	1	1	1	7	4	124	378	20501	24	1	11\n14	6	17	9	13	14	15	16	17\n14	6	17	2	2	1	18	39	1039\n14	6	18	7	9	11	13	14	15	16	17	18	19\n14	6	18	1	1	1	3	2	3	3	3	124	1\n14	6	19	7	9	10	12	13	14	15	18	19\n14	6	19	5	4	2	34	1	108	18	2	23\n14	6	20	7	10	13	14	15	16	17	18	20	37\n14	6	20	1	1	2	4	6	38	1	2	15725	10\n14	6	21	7	9	13	15	16	18	19	20	21	22\n14	6	21	1	1	15	271	76	11	4	6	994	1\n14	6	22	22\n14	6	22	3\n14	6	23	9	15	16	21	23\n14	6	23	1	1	3	1	41\n14	6	24	21	24	27	32\n14	6	24	1	5	1	1\n14	6	25	9	10	17	20	25\n14	6	25	1	2	1	2	4\n14	6	26	15	17	18	19	20	21	22	24	26\n14	6	26	1	1	2	2	5	1	1	1	1\n14	6	27	18	19	21	22	27\n14	6	27	12	1	1	2	2\n14	6	28	19	28\n14	6	28	1	2\n14	6	29	29\n14	6	29	1\n14	6	30	30\n14	6	30	4\n14	6	31	37\n14	6	31	1\n14	6	32	20	32	33\n14	6	32	1	4	1\n14	6	34	30\n14	6	34	1\n14	6	35	35	37\n14	6	35	2	1\n14	6	37	20	37\n14	6	37	48	400\n14	6	38	38\n14	6	38	1\n14	7	0	0\n14	7	0	31\n14	7	6	6	9\n14	7	6	2879	8\n14	7	7	6	7	9\n14	7	7	54	3010	10\n14	7	8	6	7	8	9	10\n14	7	8	56	7	4827	4	1\n14	7	9	6	7	8	9	10	11\n14	7	9	96	12	33	8242	30	5\n14	7	10	6	7	8	9	10	11	12	13\n14	7	10	18	1	8	60	4450	5	4	1\n14	7	11	6	8	9	10	11	12	13	16\n14	7	11	119	2	37	146	79607	215	51	1\n14	7	12	6	8	9	10	11	12	13	14	15\n14	7	12	30	4	10	69	514	58992	49	23	13\n14	7	13	6	8	9	10	11	12	13	14	15	17\n14	7	13	466	2	56	23	36	289	55391	54	93	1\n14	7	14	6	8	9	10	11	12	13	14	15	16	18\n14	7	14	27	31	4	22	28	88	241	51253	15	55	1\n14	7	15	6	9	10	11	12	13	14	15	16	17	20\n14	7	15	164	29	5	1	15	282	97	38965	124	4	2\n14	7	16	6	8	9	10	11	12	13	14	15	16	17	20	21\n14	7	16	6	11	11	8	1	57	11	91	323	20262	26	12	2\n14	7	17	6	9	11	13	14	15	16	17\n14	7	17	27	55	1	2	1	12	36	943\n14	7	18	6	8	9	10	13	14	15	16	17	18	19	21	22\n14	7	18	32	4	27	1	4	2	5	1	1	75	1	1	1\n14	7	19	8	14	15	16	18	19\n14	7	19	1	1	4	1	3	25\n14	7	20	13	15	16	18	19	20	21	37\n14	7	20	1	3	39	3	1	15746	1	6\n14	7	21	6	8	9	10	13	14	15	16	18	21\n14	7	21	4	2	9	3	6	2	59	34	7	872\n14	7	22	12	20	22\n14	7	22	1	1	6\n14	7	23	6	9	15	16	21\n14	7	23	4	14	1	21	1\n14	7	24	10	11	13	16	21	24	26\n14	7	24	1	1	1	1	1	1	1\n14	7	25	13	16	25\n14	7	25	2	1	1\n14	7	26	21\n14	7	26	1\n14	7	27	27\n14	7	27	3\n14	7	28	28\n14	7	28	2\n14	7	29	13\n14	7	29	1\n14	7	30	30\n14	7	30	5\n14	7	32	30	32\n14	7	32	2	3\n14	7	33	33\n14	7	33	1\n14	7	35	35\n14	7	35	2\n14	7	37	20	37\n14	7	37	40	372\n14	7	38	39\n14	7	38	1\n14	8	0	0\n14	8	0	31\n14	8	6	6	9	27\n14	8	6	3978	3	1\n14	8	7	6	7	9	19	23\n14	8	7	76	2948	4	1	1\n14	8	8	6	7	8	9	18	23\n14	8	8	114	8	4794	7	1	1\n14	8	9	6	7	8	9	10	11	12	13	27\n14	8	9	186	12	43	8310	17	3	3	1	1\n14	8	10	6	8	9	10	11	12\n14	8	10	46	7	58	4644	2	2\n14	8	11	6	8	9	10	11	12	13	14	15\n14	8	11	273	22	46	472	78949	383	51	2	1\n14	8	12	6	8	9	10	11	12	13	14	15	18\n14	8	12	140	42	19	203	469	58682	57	15	31	3\n14	8	13	6	8	9	10	11	12	13	14	15	18\n14	8	13	1143	4	127	28	35	274	54237	67	127	1\n14	8	14	6	8	9	10	11	12	13	14	15	16	18\n14	8	14	30	109	11	107	26	91	264	50741	79	58	8\n14	8	15	6	8	9	10	11	12	13	14	15	16	17	18	24\n14	8	15	690	19	240	14	3	20	214	129	37984	168	2	9	1\n14	8	16	6	8	9	10	11	12	13	14	15	16	17	18	20	21\n14	8	16	24	25	75	5	2	3	2	74	244	20081	20	1	19	1\n14	8	17	8	9	10	13	15	16	17	30	37\n14	8	17	3	2	2	4	4	26	932	1	1\n14	8	18	6	8	9	10	12	13	14	16	17	18\n14	8	18	8	23	11	5	2	20	2	1	1	16\n14	8	19	8	10	12	13	14	16	18	19	20	24\n14	8	19	2	4	2	2	3	1	4	1	1	7\n14	8	20	8	10	11	12	14	15	16	17	20	25	37\n14	8	20	1	6	4	1	5	2	39	3	15727	1	12\n14	8	21	6	9	13	18	19	21	24	29\n14	8	21	14	60	4	1	1	797	1	1\n14	8	22	10	14	17	22\n14	8	22	2	2	1	2\n14	8	24	24\n14	8	24	1\n14	8	25	25\n14	8	25	1\n14	8	26	26\n14	8	26	1\n14	8	27	13	27\n14	8	27	2	1\n14	8	28	13	24\n14	8	28	1	1\n14	8	30	28	30	32\n14	8	30	1	4	2\n14	8	32	32\n14	8	32	3\n14	8	33	33\n14	8	33	1\n14	8	35	35\n14	8	35	2\n14	8	37	20	37	39\n14	8	37	19	358	1\n14	8	39	39\n14	8	39	1\n14	9	0	0\n14	9	0	31\n14	9	6	6	9	22\n14	9	6	6553	167	2\n14	9	7	6	7	12\n14	9	7	20	2947	1\n14	9	8	6	7	8	9	10	12	13	14\n14	9	8	24	5	5013	26	3	8	7	8\n14	9	9	6	7	8	9	10	11	12	13\n14	9	9	40	7	38	8869	10	5	2	2\n14	9	10	6	8	9	10	11	12	13\n14	9	10	8	6	45	5441	1	3	5\n14	9	11	6	7	8	9	10	11	12	13	14	15	16	18	20	23\n14	9	11	114	5	15	28	228	78733	268	23	73	2	1	1	1	1\n14	9	12	6	7	8	9	10	11	12	13	14	15	18	21	23	25\n14	9	12	66	1	27	10	94	358	58767	50	51	29	7	1	1	1\n14	9	13	6	8	9	10	11	12	13	14	15	16	18	21\n14	9	13	431	7	38	32	34	277	53833	43	157	1	3	3\n14	9	14	6	8	9	10	11	12	13	14	15	16	21	24\n14	9	14	25	70	3	24	31	49	212	50539	3	82	1	1\n14	9	15	6	8	9	10	11	12	13	14	15	16	17	20	21\n14	9	15	114	13	55	17	2	24	169	110	37754	191	4	1	18\n14	9	16	6	8	9	10	11	12	13	14	15	16	17	20	23	24	36	37\n14	9	16	10	23	26	33	7	11	7	60	265	19897	15	16	1	1	1	1\n14	9	17	14	15	16	17	18	25\n14	9	17	1	2	23	931	1	1\n14	9	18	6	8	9	12	14	18	22\n14	9	18	8	1	3	1	1	29	1\n14	9	19	19	21\n14	9	19	2	1\n14	9	20	15	16	17	20	25	37\n14	9	20	2	18	2	15729	2	13\n14	9	21	6	9	12	13	17	21	23	36\n14	9	21	4	14	1	1	1	774	2	1\n14	9	22	13	22\n14	9	22	1	1\n14	9	23	23\n14	9	23	2\n14	9	24	21	24\n14	9	24	1	10\n14	9	25	25\n14	9	25	2\n14	9	26	25\n14	9	26	1\n14	9	27	24	27	28\n14	9	27	1	1	1\n14	9	28	27\n14	9	28	1\n14	9	29	30\n14	9	29	1\n14	9	30	30	32	35\n14	9	30	3	1	1\n14	9	32	30	32\n14	9	32	1	4\n14	9	33	33\n14	9	33	1\n14	9	35	35	37\n14	9	35	1	1\n14	9	37	20	35	37\n14	9	37	13	1	357\n14	9	39	39\n14	9	39	2\n14	10	0	0\n14	10	0	31\n14	10	6	6	9	11	13	20\n14	10	6	7118	296	1	1	1\n14	10	7	6	7	8	9	10	11	12	14	17	18\n14	10	7	3	2879	6	46	6	1	5	14	3	2\n14	10	8	6	7	8	9	10	11	13\n14	10	8	9	9	5147	10	1	10	27\n14	10	9	6	7	8	9	10	11	12	13	14	17	18	27	28\n14	10	9	11	10	44	9190	2	2	1	12	3	1	6	1	1\n14	10	10	6	8	9	10	11	12	13	14	20	32\n14	10	10	1	5	55	5778	5	19	12	5	1	1\n14	10	11	6	7	8	9	10	11	12	13	14	16	17	18	23\n14	10	11	26	1	12	23	72	78710	281	19	15	6	2	1	3\n14	10	12	6	8	9	10	11	12	13	14	15	16	17	18	29	33\n14	10	12	13	2	9	18	280	58958	29	3	29	2	1	66	1	1\n14	10	13	6	8	9	10	11	12	13	14	15	16	18	20\n14	10	13	124	4	11	10	28	254	53671	28	168	1	10	1\n14	10	14	6	8	9	10	11	12	13	14	15	16	17	23\n14	10	14	4	9	1	8	29	49	218	50494	2	68	1	3\n14	10	15	6	9	11	12	13	14	15	16	17	18	23\n14	10	15	50	23	3	11	89	133	37677	171	1	55	1\n14	10	16	8	9	10	11	12	13	14	15	16	17	18	20	25\n14	10	16	6	2	9	2	1	2	46	200	19891	24	1	28	1\n14	10	17	9	10	12	13	15	16	17\n14	10	17	1	1	1	1	7	19	923\n14	10	18	18	21	24\n14	10	18	39	1	1\n14	10	19	19\n14	10	19	2\n14	10	20	16	20	37\n14	10	20	6	15739	15\n14	10	21	15	21\n14	10	21	1	798\n14	10	22	22	25\n14	10	22	3	1\n14	10	23	21	23	28\n14	10	23	1	5	1\n14	10	24	18	22	24\n14	10	24	2	2	9\n14	10	25	25\n14	10	25	7\n14	10	27	27	30\n14	10	27	1	1\n14	10	28	30\n14	10	28	1\n14	10	30	29	30	32\n14	10	30	1	3	1\n14	10	32	30	32\n14	10	32	1	4\n14	10	33	33\n14	10	33	1\n14	10	35	35\n14	10	35	3\n14	10	36	36\n14	10	36	2\n14	10	37	20	37\n14	10	37	25	347\n14	10	39	39\n14	10	39	2\n14	11	0	0\n14	11	0	31\n14	11	6	6	9	11\n14	11	6	7261	97	1\n14	11	7	7	8	10	11\n14	11	7	2894	3	1	1\n14	11	8	6	7	8	9	13\n14	11	8	1	10	5210	12	2\n14	11	9	6	7	8	9	10	11	15	18	19\n14	11	9	6	6	21	9622	4	2	1	3	2\n14	11	10	7	8	9	10	11	12	13	14	16	18	19\n14	11	10	1	2	47	5836	5	4	1	6	1	1	1\n14	11	11	6	8	9	10	11	12	13	15	16\n14	11	11	3	2	22	44	78750	238	9	2	1\n14	11	12	6	9	10	11	12	13	14	15	16	18\n14	11	12	7	4	7	271	59242	23	9	14	1	2\n14	11	13	6	9	10	11	12	13	14	15	16\n14	11	13	12	4	5	36	255	53622	16	130	1\n14	11	14	8	11	12	13	14	16	18	20	22\n14	11	14	1	18	41	246	50314	65	53	2	1\n14	11	15	6	9	10	11	12	13	14	15	16	17\n14	11	15	8	2	1	1	11	121	145	37656	137	2\n14	11	16	8	11	13	14	15	16	17	20	37\n14	11	16	1	1	3	45	230	19851	18	14	1\n14	11	17	14	15	16	17	37\n14	11	17	2	5	11	937	1\n14	11	18	11	15	18	19\n14	11	18	1	1	179	1\n14	11	19	19\n14	11	19	2\n14	11	20	16	17	18	20	37\n14	11	20	12	1	2	15775	5\n14	11	21	11	12	13	15	20	21	24\n14	11	21	1	4	1	2	2	789	1\n14	11	22	14	22\n14	11	22	1	4\n14	11	23	18	23\n14	11	23	1	11\n14	11	24	18	24\n14	11	24	3	7\n14	11	25	22	25	26	37\n14	11	25	2	5	1	1\n14	11	27	27	30\n14	11	27	1	1\n14	11	28	28\n14	11	28	2\n14	11	29	29	31\n14	11	29	1	1\n14	11	30	28	30\n14	11	30	1	5\n14	11	32	30	32\n14	11	32	1	5\n14	11	33	33\n14	11	33	2\n14	11	35	33	35\n14	11	35	2	1\n14	11	36	36\n14	11	36	2\n14	11	37	20	35	37\n14	11	37	13	1	348\n14	11	39	37	39\n14	11	39	1	1\n14	12	0	0\n14	12	0	31\n14	12	6	6	9	14\n14	12	6	7285	12	1\n14	12	7	7\n14	12	7	2911\n14	12	8	7	8	9	12\n14	12	8	199	5039	1	1\n14	12	9	6	7	8	9	10	11	12	13	22\n14	12	9	977	152	175	8491	7	4	1	2	1\n14	12	10	7	8	9	10	11	13	14	18\n14	12	10	26	63	158	5638	6	2	4	1\n14	12	11	6	8	9	10	11	12	13	15\n14	12	11	3	256	198	112	77765	732	21	1\n14	12	12	6	7	8	9	10	11	12	13	14	15	16\n14	12	12	1	106	245	324	369	4020	54668	39	1	21	1\n14	12	13	6	8	9	10	11	12	13	14	15	16	17\n14	12	13	2	112	204	160	740	911	51552	17	322	7	1\n14	12	14	8	9	10	11	12	13	14	15	16	17	18	19	20\n14	12	14	1	99	238	743	702	1468	47053	6	193	9	12	2	12\n14	12	15	6	9	10	11	12	13	14	15	16	17	20	21\n14	12	15	1	110	112	252	617	4851	1065	30736	289	4	3	1\n14	12	16	9	11	12	13	14	15	16	17	18	20\n14	12	16	1	73	99	134	1461	775	17460	36	1	40\n14	12	17	14	15	16	17	18\n14	12	17	4	2	9	941	2\n14	12	18	10	12	13	14	15	16	17	18\n14	12	18	29	58	16	39	34	1	1	66\n14	12	19	14	17	19\n14	12	19	1	1	4\n14	12	20	11	12	13	14	15	16	17	20	22\n14	12	20	21	14	35	144	140	12052	417	2982	1\n14	12	21	10	12	13	15	16	21\n14	12	21	1	274	287	10	1	216\n14	12	22	13	18	19	22	28\n14	12	22	1	1	1	3	1\n14	12	23	11	13	14	16	20	21	23\n14	12	23	2	1	4	1	1	1	1\n14	12	24	12	15	18	24\n14	12	24	1	2	2	3\n14	12	25	14	16	25\n14	12	25	1	2	2\n14	12	26	26\n14	12	26	1\n14	12	27	27\n14	12	27	1\n14	12	28	28	30\n14	12	28	2	1\n14	12	29	26\n14	12	29	1\n14	12	30	27	28	30\n14	12	30	1	2	4\n14	12	31	30\n14	12	31	1\n14	12	32	30	32\n14	12	32	2	3\n14	12	33	25	27	33\n14	12	33	1	1	2\n14	12	35	35\n14	12	35	2\n14	12	36	13	36\n14	12	36	1	1\n14	12	37	16	17	20	37\n14	12	37	193	54	48	62\n14	12	39	39\n14	12	39	1\n14	13	0	0\n14	13	0	31\n14	13	6	6	22	23\n14	13	6	8267	1	1\n14	13	7	7\n14	13	7	3394\n14	13	8	7	8	10	13\n14	13	8	126	5761	1	3\n14	13	9	6	7	8	9	10	11	12	13	22\n14	13	9	644	77	149	8714	10	1	1	1	1\n14	13	10	7	8	9	10	11	13\n14	13	10	25	47	173	6415	3	3\n14	13	11	8	9	10	11	12	13	15	16\n14	13	11	141	177	135	82191	934	33	14	1\n14	13	12	7	8	9	10	11	12	13	14	15	16\n14	13	12	5	57	117	275	2350	55201	31	1	38	3\n14	13	13	6	8	9	10	11	12	13	14	15	16	17\n14	13	13	1	46	109	97	438	780	56497	36	382	21	3\n14	13	14	9	10	11	12	13	14	15	16	17	20\n14	13	14	37	126	159	326	913	47744	12	414	33	31\n14	13	15	6	9	10	11	12	13	14	15	16	17	18	20\n14	13	15	1	22	26	129	235	2409	545	28397	275	3	1	6\n14	13	16	11	12	13	14	15	16	17	20	21	22\n14	13	16	25	61	91	613	654	28705	36	22	1	1\n14	13	17	13	14	15	16	17\n14	13	17	2	1	2	5	1454\n14	13	18	9	10	11	12	13	14	15	16	17	18	19	24\n14	13	18	3	9	1	23	4	19	10	3	2	8	2	1\n14	13	19	12	15	16	19\n14	13	19	1	2	2	2\n14	13	20	11	14	15	16	17	20	21\n14	13	20	1	3	9	974	22	2076	1\n14	13	21	12	13	15	21\n14	13	21	61	67	3	87\n14	13	22	19	20	24\n14	13	22	3	1	1\n14	13	23	21\n14	13	23	1\n14	13	24	15	24\n14	13	24	1	2\n14	13	25	25	37\n14	13	25	2	1\n14	13	26	26\n14	13	26	2\n14	13	27	25	27\n14	13	27	1	2\n14	13	28	23	25	28\n14	13	28	1	1	3\n14	13	30	27	28	30\n14	13	30	1	4	3\n14	13	32	25	30	32\n14	13	32	1	1	1\n14	13	33	30	33\n14	13	33	1	1\n14	13	35	33	35\n14	13	35	1	1\n14	13	36	36\n14	13	36	1\n14	13	37	16	17	20	35	37\n14	13	37	19	2	9	2	30\n14	13	39	39\n14	13	39	1\n15	1	0	0\n15	1	0	16\n15	1	6	6	9\n15	1	6	2104	194\n15	1	7	7	8	9	10	12\n15	1	7	2253	45	63	6	1\n15	1	8	7	8	9	10	11	12	13\n15	1	8	7	3527	51	21	33	55	16\n15	1	9	6	7	8	9	10	11	12	13	14	15\n15	1	9	1	6	19	5910	49	83	66	47	10	4\n15	1	10	7	8	9	10	11	12	13	14	15\n15	1	10	2	5	30	3146	30	90	27	39	9\n15	1	11	9	10	11	12	13	14	15	16\n15	1	11	14	50	54738	465	129	32	21	4\n15	1	12	9	10	11	12	13	14	15	16	17	21\n15	1	12	6	10	1495	44402	116	98	61	35	1	66\n15	1	13	8	9	10	11	12	13	14	15	16	17	18	19	21\n15	1	13	3	4	3	88	244	40833	248	387	21	2	3	1	64\n15	1	14	11	12	13	14	15	16	18	19	20\n15	1	14	10	41	158	34337	94	110	4	23	1\n15	1	15	11	12	13	14	15	16	17	18	19	20	21	22\n15	1	15	22	75	973	74	30538	201	2	4	9	2	57	1\n15	1	16	11	12	13	14	15	16	17	19	20	21	23	37\n15	1	16	2	10	41	578	333	21513	3	1	2278	85	4	61\n15	1	17	9	13	14	15	16	17	18	20	22	23	37\n15	1	17	1	4	27	3	25	809	3	70	1	1	12\n15	1	18	13	14	15	16	17	18	19	20	21	23	27\n15	1	18	8	4	9	1	1	151	1	1	9	2	4\n15	1	19	14	15	16	17	18	19	21	25\n15	1	19	1	3	1	2	1	83	5	1\n15	1	20	14	15	16	17	18	19	20	21	23	25	27	28	37\n15	1	20	22	6	16	1	1	2	2746	2	1	2	1	2	17\n15	1	21	15	16	17	21	22	23	24	25	27	28\n15	1	21	1	1	1	372	1	3	1	2	2	2\n15	1	22	20	22	25\n15	1	22	1	10	3\n15	1	23	21	23	28\n15	1	23	2	15	1\n15	1	24	24	25	33\n15	1	24	3	1	1\n15	1	25	23	24	25	28	34	35\n15	1	25	1	1	10	1	1	1\n15	1	26	13	25	26\n15	1	26	1	2	5\n15	1	27	21	27\n15	1	27	1	7\n15	1	28	26	28\n15	1	28	1	3\n15	1	29	29\n15	1	29	1\n15	1	31	31\n15	1	31	3\n15	1	32	32\n15	1	32	4\n15	1	34	34\n15	1	34	1\n15	1	37	37\n15	1	37	124\n15	1	40	40\n15	1	40	1\n15	2	0	0\n15	2	0	16\n15	2	6	6	9\n15	2	6	2005	100\n15	2	7	7	8	9	10	12\n15	2	7	2137	54	46	13	18\n15	2	8	7	8	9	10	11	12	13\n15	2	8	3	3363	30	13	55	115	20\n15	2	9	6	7	8	9	10	11	12	13	14	15\n15	2	9	3	6	19	6007	44	62	52	36	29	15\n15	2	10	8	9	10	11	12	13	14	15\n15	2	10	2	53	3040	26	78	25	51	10\n15	2	11	9	10	11	12	13	14	15	16	20	21\n15	2	11	16	50	55450	714	132	88	39	6	5	1\n15	2	12	9	10	11	12	13	14	15	16	20	21\n15	2	12	5	5	1298	43586	128	138	61	89	5	134\n15	2	13	8	9	10	11	12	13	14	15	16	17	20	21	30\n15	2	13	2	3	3	49	246	40989	336	591	19	2	3	109	1\n15	2	14	11	12	13	14	15	16	18	19	20	28\n15	2	14	12	44	186	34864	146	180	1	21	15	1\n15	2	15	11	12	13	14	15	16	17	18	19	20	21\n15	2	15	11	47	819	75	30222	138	2	4	16	15	120\n15	2	16	11	12	13	14	15	16	17	18	19	20	21	23	37\n15	2	16	2	5	7	405	352	15594	7	2	1	5350	110	9	84\n15	2	17	13	14	15	16	17	18	20	22	23	37\n15	2	17	3	22	7	24	628	5	118	1	1	13\n15	2	18	13	14	15	16	17	18	19	20	21	23	26	27\n15	2	18	4	2	14	1	8	117	1	1	15	2	1	1\n15	2	19	15	17	18	19	21	23	25	27\n15	2	19	3	2	1	108	2	2	1	1\n15	2	20	14	15	16	17	19	20	21	22	25	28	37\n15	2	20	19	4	22	1	2	5033	2	1	2	1	12\n15	2	21	15	17	21	22	23	25	27	28\n15	2	21	2	1	650	1	5	1	1	2\n15	2	22	19	21	22	26\n15	2	22	2	1	9	1\n15	2	23	21	23\n15	2	23	3	24\n15	2	24	22	24	25\n15	2	24	2	2	1\n15	2	25	22	23	25\n15	2	25	1	1	19\n15	2	26	23	26	31\n15	2	26	1	4	1\n15	2	27	23	27	30\n15	2	27	1	12	1\n15	2	28	26	28\n15	2	28	2	7\n15	2	29	29\n15	2	29	1\n15	2	31	31\n15	2	31	3\n15	2	32	32\n15	2	32	4\n15	2	33	35\n15	2	33	1\n15	2	34	34\n15	2	34	2\n15	2	35	35\n15	2	35	1\n15	2	37	20	37\n15	2	37	4	210\n15	2	40	40\n15	2	40	1\n15	3	0	0\n15	3	0	16\n15	3	6	6\n15	3	6	2008\n15	3	7	7\n15	3	7	2146\n15	3	8	7	8\n15	3	8	4	3436\n15	3	9	7	8	9	10\n15	3	9	9	11	6231	9\n15	3	10	8	9	10	11\n15	3	10	1	34	3132	1\n15	3	11	8	9	10	11	12	13	15\n15	3	11	1	13	38	56873	20	19	1\n15	3	12	9	10	11	12	13	14	15	17\n15	3	12	5	5	1083	43782	18	10	1	1\n15	3	13	8	9	11	12	13	14	15	17	18\n15	3	13	2	1	38	239	41990	46	31	1	1\n15	3	14	11	12	13	14	15	16\n15	3	14	14	37	175	35785	10	8\n15	3	15	11	12	13	14	15	16	25\n15	3	15	7	36	683	77	30611	51	1\n15	3	16	12	13	14	15	16	17	19	20\n15	3	16	3	3	228	403	15425	5	1	5\n15	3	17	13	14	15	16	17	18	27\n15	3	17	5	9	4	30	600	1	2\n15	3	18	13	14	15	16	17	18\n15	3	18	2	5	10	1	1	111\n15	3	19	14	15	16	17	18	19\n15	3	19	1	6	2	1	2	139\n15	3	20	14	15	16	17	19	20	37\n15	3	20	2	1	25	2	1	10508	10\n15	3	21	12	15	19	21\n15	3	21	1	1	6	1139\n15	3	22	18	19	20	21	22\n15	3	22	1	1	2	4	7\n15	3	23	16	19	20	21	23	24\n15	3	23	1	1	2	2	39	1\n15	3	24	24\n15	3	24	2\n15	3	25	23	25\n15	3	25	3	21\n15	3	26	21	26\n15	3	26	1	7\n15	3	27	26	27\n15	3	27	1	14\n15	3	28	20	22	26	28	30\n15	3	28	1	1	1	7	1\n15	3	29	29\n15	3	29	1\n15	3	30	30\n15	3	30	2\n15	3	31	26	28	31\n15	3	31	1	1	2\n15	3	32	30	32	33\n15	3	32	1	2	1\n15	3	34	34\n15	3	34	2\n15	3	35	35	37\n15	3	35	1	1\n15	3	37	20	37\n15	3	37	6	313\n15	3	40	40\n15	3	40	1\n15	4	0	0\n15	4	0	16\n15	4	6	6\n15	4	6	2008\n15	4	7	7\n15	4	7	2159\n15	4	8	7	8	13\n15	4	8	6	3444	1\n15	4	9	6	7	8	9	10\n15	4	9	1	7	13	6254	9\n15	4	10	7	8	9	10	11\n15	4	10	1	7	44	3131	1\n15	4	11	9	10	11	12	13	15\n15	4	11	12	39	57924	29	11	1\n15	4	12	9	10	11	12	13	14	15\n15	4	12	5	8	688	43405	7	4	1\n15	4	13	9	11	12	13	14	15	18	19	21\n15	4	13	3	26	275	42528	27	32	1	1	2\n15	4	14	11	12	13	14	15	16\n15	4	14	8	45	180	35911	9	10\n15	4	15	12	13	14	15	16	18\n15	4	15	35	584	70	30354	35	1\n15	4	16	10	12	13	14	15	16	17	20\n15	4	16	1	5	2	154	383	14991	5	2\n15	4	17	13	15	16	17\n15	4	17	3	2	21	585\n15	4	18	9	10	12	13	14	15	16	17	18\n15	4	18	1	1	2	1	3	7	3	3	95\n15	4	19	14	15	17	19\n15	4	19	1	4	1	143\n15	4	20	12	14	15	16	19	20	37\n15	4	20	1	1	3	19	1	10496	3\n15	4	21	14	15	17	18	19	20	21\n15	4	21	1	9	2	1	2	2	1129\n15	4	22	17	20	21	22\n15	4	22	1	1	2	4\n15	4	23	15	18	19	23\n15	4	23	2	1	6	33\n15	4	24	24\n15	4	24	3\n15	4	25	19	21	22	25	32\n15	4	25	6	3	1	11	1\n15	4	26	18	25	26\n15	4	26	1	2	7\n15	4	27	20	27	30\n15	4	27	1	14	1\n15	4	28	26	28\n15	4	28	2	6\n15	4	29	37\n15	4	29	1\n15	4	30	22	30	32\n15	4	30	1	1	2\n15	4	31	31\n15	4	31	2\n15	4	32	16	32\n15	4	32	1	1\n15	4	33	33\n15	4	33	1\n15	4	34	34\n15	4	34	2\n15	4	35	37\n15	4	35	1\n15	4	37	20	37\n15	4	37	18	306\n15	4	40	40\n15	4	40	1\n15	5	0	0\n15	5	0	16\n15	5	6	6\n15	5	6	2009\n15	5	7	7	13\n15	5	7	2172	1\n15	5	8	7	8\n15	5	8	6	3458\n15	5	9	6	7	8	9	10	11\n15	5	9	2	5	23	6264	24	1\n15	5	10	7	8	9	10\n15	5	10	1	2	35	3151\n15	5	11	8	9	10	11	12	13	14\n15	5	11	12	17	42	58517	40	15	4\n15	5	12	9	10	11	12	13	14	15\n15	5	12	1	6	575	43190	16	6	3\n15	5	13	7	8	9	10	11	12	13	14	15	18\n15	5	13	1	44	5	1	46	247	42915	20	36	2\n15	5	14	8	11	12	13	14	15	16\n15	5	14	3	19	40	197	35899	3	11\n15	5	15	8	9	11	12	13	14	15	16\n15	5	15	2	2	4	23	478	71	30181	46\n15	5	16	8	9	11	12	13	14	15	16	17	20\n15	5	16	7	1	1	5	4	131	308	14617	4	2\n15	5	17	11	13	14	15	16	17	18	21\n15	5	17	1	5	3	4	22	560	1	1\n15	5	18	11	12	13	15	16	17	18\n15	5	18	1	1	2	3	1	5	87\n15	5	19	8	11	12	13	15	18	19	23\n15	5	19	7	2	1	2	7	1	138	1\n15	5	20	8	9	12	13	16	17	20	37\n15	5	20	4	1	2	2	13	1	10496	1\n15	5	21	8	14	15	16	17	21\n15	5	21	3	1	7	3	3	1119\n15	5	22	8	22\n15	5	22	1	5\n15	5	23	8	13	15	17	18	20	23\n15	5	23	1	1	1	2	1	2	25\n15	5	24	24\n15	5	24	3\n15	5	25	13	17	23	25\n15	5	25	1	2	1	9\n15	5	26	17	20	26\n15	5	26	1	1	7\n15	5	27	21	23	27\n15	5	27	1	1	12\n15	5	28	13	28\n15	5	28	1	5\n15	5	30	30	37\n15	5	30	1	1\n15	5	31	17\n15	5	31	2\n15	5	32	25	32	33\n15	5	32	1	2	1\n15	5	33	33\n15	5	33	1\n15	5	34	34\n15	5	34	2\n15	5	37	20	28	37\n15	5	37	18	1	292\n15	5	40	40\n15	5	40	1\n15	6	0	0\n15	6	0	16\n15	6	6	6	7	9\n15	6	6	2009	1	1\n15	6	7	7\n15	6	7	2185\n15	6	8	7	8	9	18\n15	6	8	3	3562	1	1\n15	6	9	6	7	8	9	10	11\n15	6	9	8	14	20	6259	24	1\n15	6	10	7	8	9	10\n15	6	10	3	1	48	3172\n15	6	11	7	8	9	10	11	12	13	14	18	19\n15	6	11	8	2	29	36	58989	74	22	5	1	1\n15	6	12	7	8	9	10	11	12	13	14	15\n15	6	12	3	4	6	9	438	43056	21	8	4\n15	6	13	7	9	10	11	12	13	14	15\n15	6	13	42	12	1	34	235	43218	34	64\n15	6	14	7	9	10	11	12	13	14	15	16	18	19\n15	6	14	1	2	2	15	88	185	35814	4	22	1	1\n15	6	15	7	9	10	11	12	13	14	15	16	18\n15	6	15	32	3	1	3	33	329	59	30023	68	2\n15	6	16	7	9	10	12	13	14	15	16	17	20\n15	6	16	1	2	1	13	3	88	219	14365	15	6\n15	6	17	7	9	12	13	15	16	17\n15	6	17	1	3	1	5	5	22	543\n15	6	18	7	9	12	15	16	18\n15	6	18	2	2	2	2	3	81\n15	6	19	7	9	12	14	15	16	18	19\n15	6	19	12	11	22	55	17	3	3	15\n15	6	20	9	14	15	16	18	20	37\n15	6	20	2	3	1	9	2	10496	6\n15	6	21	7	13	15	16	17	18	19	20	21	22\n15	6	21	2	8	250	56	1	5	3	2	792	2\n15	6	22	10	22\n15	6	22	2	3\n15	6	23	7	9	13	15	16	17	23	27\n15	6	23	1	1	1	1	2	1	20	1\n15	6	24	24	27\n15	6	24	2	1\n15	6	25	9	10	20	24	25	40\n15	6	25	2	1	4	1	1	1\n15	6	26	16	18	20	21\n15	6	26	2	2	2	1\n15	6	27	18	20	21	27\n15	6	27	6	2	1	3\n15	6	28	20	21	25	26	28\n15	6	28	1	2	1	1	1\n15	6	30	30\n15	6	30	1\n15	6	32	32\n15	6	32	2\n15	6	33	33\n15	6	33	2\n15	6	34	25\n15	6	34	2\n15	6	37	20	35	37\n15	6	37	24	1	269\n15	6	40	40\n15	6	40	1\n15	7	0	0\n15	7	0	16\n15	7	6	6	9\n15	7	6	2016	1\n15	7	7	6	7\n15	7	7	4	2307\n15	7	8	6	7	8	9\n15	7	8	8	2	3578	1\n15	7	9	6	7	8	9	10	11	12	15\n15	7	9	18	9	26	6315	9	5	1	1\n15	7	10	6	8	9	10	11	16	26\n15	7	10	1	6	35	3202	3	1	1\n15	7	11	6	8	9	10	11	12	13	14	15	16	28\n15	7	11	17	1	31	75	59229	101	20	1	1	3	1\n15	7	12	6	8	9	10	11	12	13	14	15	17	19\n15	7	12	6	8	4	10	399	43052	30	8	2	4	1\n15	7	13	6	8	9	10	11	12	13	14	15\n15	7	13	59	3	12	1	41	250	43341	27	58\n15	7	14	6	8	9	10	11	12	13	14	15	16	17	18\n15	7	14	1	6	1	6	14	56	189	35755	12	21	2	3\n15	7	15	6	9	10	12	13	14	15	16	17	20\n15	7	15	18	2	1	12	331	63	30094	67	1	1\n15	7	16	6	9	12	13	14	15	16	17	18	20	21\n15	7	16	1	2	110	9	87	234	14099	4	1	2	3\n15	7	17	6	9	10	13	14	15	16	17\n15	7	17	2	11	1	6	1	2	26	511\n15	7	18	6	9	13	15	16	18	19	21\n15	7	18	2	2	6	5	3	84	1	1\n15	7	19	16	19\n15	7	19	1	19\n15	7	20	14	16	20	22	37\n15	7	20	2	38	10495	1	1\n15	7	21	10	13	14	15	16	18	21\n15	7	21	1	30	4	119	74	5	563\n15	7	22	18	20	22\n15	7	22	1	1	3\n15	7	23	9	15	16	17	21	23\n15	7	23	2	1	14	1	1	1\n15	7	24	24\n15	7	24	3\n15	7	25	20	25\n15	7	25	1	3\n15	7	26	22\n15	7	26	1\n15	7	27	27	28	30\n15	7	27	3	1	1\n15	7	28	28\n15	7	28	1\n15	7	30	30\n15	7	30	1\n15	7	32	32	37\n15	7	32	1	1\n15	7	33	33	37\n15	7	33	1	1\n15	7	35	35\n15	7	35	1\n15	7	37	20	37\n15	7	37	23	252\n15	7	40	39	40\n15	7	40	1	1\n15	8	0	0\n15	8	0	16\n15	8	6	6	9\n15	8	6	2147	6\n15	8	7	6	7	9\n15	8	7	76	2223	19\n15	8	8	6	7	8	9	10	11	21\n15	8	8	115	5	3492	12	2	1	1\n15	8	9	6	7	8	9	10	11	18\n15	8	9	166	9	44	6184	13	2	1\n15	8	10	6	7	8	9	10	11	12\n15	8	10	39	1	5	39	3220	1	1\n15	8	11	6	7	8	9	10	11	12	13	14	15	16\n15	8	11	217	2	9	51	307	58864	192	43	1	2	3\n15	8	12	6	8	9	10	11	12	13	14	15	17\n15	8	12	49	17	12	171	325	42938	40	9	20	1\n15	8	13	6	8	9	10	11	12	13	14	15	17\n15	8	13	1047	6	144	14	38	228	42362	29	93	1\n15	8	14	6	8	9	10	11	12	13	14	15	16	18\n15	8	14	44	69	3	55	24	51	213	35374	77	37	1\n15	8	15	6	8	9	10	12	13	14	15	16	17\n15	8	15	607	14	248	13	13	191	82	29245	115	1\n15	8	16	6	8	9	10	12	13	14	15	16	17	18	20	21\n15	8	16	13	11	78	8	2	1	59	158	13992	11	3	10	1\n15	8	17	10	13	14	15	16	17	19\n15	8	17	1	2	1	2	6	510	1\n15	8	18	6	8	9	10	11	12	13	14	15	16	18\n15	8	18	9	17	23	2	1	1	14	3	4	1	19\n15	8	19	8	10	12	15	19	22\n15	8	19	1	3	1	13	2	1\n15	8	20	10	11	12	13	14	16	17	20	37\n15	8	20	3	5	1	7	9	34	2	10461	1\n15	8	21	6	8	9	10	13	14	16	21	27\n15	8	21	17	1	70	1	3	1	2	472	1\n15	8	22	14	16	17	21	22\n15	8	22	1	1	1	1	1\n15	8	23	23\n15	8	23	1\n15	8	24	16	21\n15	8	24	2	1\n15	8	25	13	25\n15	8	25	1	2\n15	8	26	21\n15	8	26	1\n15	8	27	13	14	23\n15	8	27	1	1	1\n15	8	28	13	29	30\n15	8	28	1	1	1\n15	8	30	30	32\n15	8	30	1	1\n15	8	32	32\n15	8	32	1\n15	8	33	35\n15	8	33	1\n15	8	35	35\n15	8	35	1\n15	8	37	20	37	40\n15	8	37	22	231	2\n15	8	39	39\n15	8	39	1\n15	8	40	40\n15	8	40	1\n15	9	0	0\n15	9	0	16\n15	9	6	6	9	25\n15	9	6	4523	21	2\n15	9	7	6	7	9	10\n15	9	7	53	2184	2	1\n15	9	8	6	7	8	9	13	14\n15	9	8	59	2	3618	4	2	1\n15	9	9	6	7	8	9	10	11	22\n15	9	9	93	28	36	6725	5	1	1\n15	9	10	6	7	8	9	10	11	12	23\n15	9	10	16	1	6	47	3736	1	5	1\n15	9	11	6	7	8	9	10	11	12	13	14	15\n15	9	11	159	4	10	23	373	58387	276	26	1	2\n15	9	12	6	7	8	9	10	11	12	13	14	15	16	18\n15	9	12	99	2	31	14	228	234	42735	52	6	6	1	20\n15	9	13	6	8	9	10	11	12	13	14	15\n15	9	13	863	16	69	40	31	230	41512	24	94\n15	9	14	6	8	9	10	11	12	13	14	15	16\n15	9	14	27	101	9	47	26	28	151	35129	7	45\n15	9	15	6	8	9	10	12	13	14	15	16	21\n15	9	15	260	15	123	21	12	118	71	28878	115	1\n15	9	16	6	8	9	10	11	12	13	14	15	16	17	18	20	24\n15	9	16	26	45	61	44	10	6	4	23	151	13798	12	3	4	6\n15	9	17	12	13	14	16	17\n15	9	17	1	2	1	6	517\n15	9	18	6	8	9	11	14	18\n15	9	18	6	1	10	1	1	5\n15	9	19	18	19	20\n15	9	19	1	1	1\n15	9	20	16	20	25	37\n15	9	20	16	10470	1	6\n15	9	21	6	9	10	11	14	17	21	23	28\n15	9	21	2	27	1	1	1	1	442	1	1\n15	9	22	18	22\n15	9	22	1	1\n15	9	23	12	23\n15	9	23	1	1\n15	9	25	25\n15	9	25	2\n15	9	27	28\n15	9	27	1\n15	9	29	29\n15	9	29	1\n15	9	30	30\n15	9	30	2\n15	9	32	32\n15	9	32	2\n15	9	35	33	35\n15	9	35	1	1\n15	9	37	20	37\n15	9	37	12	220\n15	9	39	39\n15	9	39	1\n15	9	40	37	40\n15	9	40	1	2\n15	10	0	0\n15	10	0	16\n15	10	6	6	8	9	13\n15	10	6	5886	2	297	1\n15	10	7	6	7	8	9	10	12	14	18\n15	10	7	11	2183	3	15	2	3	3	1\n15	10	8	6	7	8	9	10	11	13\n15	10	8	15	2	3806	14	1	25	16\n15	10	9	6	7	8	9	10	11	12	13	18\n15	10	9	18	9	35	7057	3	3	1	8	1\n15	10	10	6	8	9	10	11	12	13	14\n15	10	10	1	4	40	4421	5	11	12	2\n15	10	11	6	7	8	9	10	11	12	13	14	15	23\n15	10	11	59	3	28	28	120	58255	150	7	40	1	1\n15	10	12	6	7	8	9	10	11	12	13	14	15	18	25\n15	10	12	22	2	16	3	54	198	42924	29	21	23	1	1\n15	10	13	6	8	9	10	11	12	13	14	15	16	23	27\n15	10	13	258	4	23	17	29	213	41176	10	130	1	5	1\n15	10	14	6	8	9	10	11	12	13	14	15	16	23\n15	10	14	7	42	4	20	27	53	173	34882	1	43	6\n15	10	15	6	8	9	10	11	12	13	14	15	16	18\n15	10	15	96	2	70	10	4	8	70	77	28712	88	1\n15	10	16	8	9	10	11	12	13	14	15	16	17	18	20	25	36\n15	10	16	17	1	16	4	8	2	21	138	13755	7	1	7	3	1\n15	10	17	13	15	16	17	26	37\n15	10	17	1	2	9	512	1	5\n15	10	18	14	18\n15	10	18	1	29\n15	10	19	19\n15	10	19	1\n15	10	20	16	20	37\n15	10	20	6	10472	9\n15	10	21	12	14	21	22\n15	10	21	1	1	440	1\n15	10	22	22\n15	10	22	2\n15	10	23	23	28\n15	10	23	2	1\n15	10	24	18	24\n15	10	24	1	5\n15	10	25	25	26	27	37\n15	10	25	2	1	1	1\n15	10	28	27	28\n15	10	28	1	1\n15	10	29	29\n15	10	29	1\n15	10	30	30\n15	10	30	2\n15	10	32	32\n15	10	32	2\n15	10	33	33\n15	10	33	1\n15	10	35	33\n15	10	35	1\n15	10	37	20	32	37\n15	10	37	10	1	216\n15	10	39	37\n15	10	39	1\n15	10	40	32	40\n15	10	40	1	1\n15	11	0	0\n15	11	0	16\n15	11	6	6	7	8	9	11	14	16	17\n15	11	6	6175	2	1	188	1	4	1	1\n15	11	7	6	7	8	9	11\n15	11	7	1	2110	67	10	11\n15	11	8	6	7	8	9	10	12\n15	11	8	6	9	3923	18	2	1\n15	11	9	6	7	8	9	10	11	12	13	14	15\n15	11	9	11	9	34	7479	4	10	2	1	1	1\n15	11	10	6	8	9	10	11	12	14	16	17\n15	11	10	3	2	36	4587	8	13	4	7	4\n15	11	11	6	7	8	9	10	11	12	13	14	15	16	17\n15	11	11	16	1	2	20	44	58307	147	5	5	1	1	1\n15	11	12	6	8	9	10	11	12	13	14	15	16	17	18	24\n15	11	12	9	1	7	16	178	43059	16	3	6	1	2	72	2\n15	11	13	6	8	9	10	11	12	13	14	15	18	26\n15	11	13	81	1	3	12	27	214	41046	24	80	6	1\n15	11	14	6	8	9	10	11	12	13	14	15	16	18\n15	11	14	2	7	1	1	17	34	148	34803	1	42	2\n15	11	15	6	9	10	12	13	14	15	16	20\n15	11	15	21	14	3	14	93	106	28677	78	1\n15	11	16	8	10	11	12	14	15	16	17	18	20\n15	11	16	9	2	1	4	27	198	13645	6	2	8\n15	11	17	13	14	15	16	17	19\n15	11	17	1	1	1	16	499	1\n15	11	18	14	18	24\n15	11	18	1	31	3\n15	11	19	14\n15	11	19	1\n15	11	20	9	16	20	37\n15	11	20	1	8	10477	3\n15	11	21	9	10	12	13	14	21\n15	11	21	1	1	2	1	1	434\n15	11	22	22	23\n15	11	22	2	1\n15	11	23	18	23\n15	11	23	1	13\n15	11	24	18	24\n15	11	24	1	4\n15	11	25	25\n15	11	25	6\n15	11	26	26	28\n15	11	26	1	1\n15	11	27	24	27\n15	11	27	1	2\n15	11	28	28\n15	11	28	2\n15	11	29	29\n15	11	29	1\n15	11	30	31	32\n15	11	30	1	1\n15	11	32	32\n15	11	32	4\n15	11	33	33\n15	11	33	2\n15	11	36	36\n15	11	36	1\n15	11	37	20	37\n15	11	37	18	214\n15	11	40	40\n15	11	40	1\n15	12	0	0\n15	12	0	16\n15	12	6	6	8	9	11\n15	12	6	6279	1	44	1\n15	12	7	7\n15	12	7	2131\n15	12	8	6	7	8	9	12\n15	12	8	1	5	4031	8	2\n15	12	9	6	7	8	9	10	11	12	15	27\n15	12	9	1	4	25	7729	5	11	1	1	1\n15	12	10	8	9	10	11	12	13	14	18\n15	12	10	4	50	4604	5	3	2	3	1\n15	12	11	6	8	9	10	11	12	13	14	15	16	19\n15	12	11	4	3	11	32	58107	382	15	2	1	2	1\n15	12	12	6	9	10	11	12	13	15	16	18	19\n15	12	12	2	2	6	142	43296	28	11	1	1	1\n15	12	13	6	9	10	11	12	13	14	15	16	18\n15	12	13	9	3	14	28	215	40828	9	203	1	1\n15	12	14	6	9	11	12	13	14	15	16	17	18	19	20\n15	12	14	1	1	16	33	179	34633	5	84	3	23	1	2\n15	12	15	6	9	12	13	14	15	16	19\n15	12	15	2	3	2	41	102	28664	150	1\n15	12	16	13	14	15	16	17	18	20	25	37\n15	12	16	1	16	135	13594	27	1	23	1	1\n15	12	17	13	14	15	16	17\n15	12	17	2	2	1	5	503\n15	12	18	11	12	18	19\n15	12	18	1	2	111	1\n15	12	19	19\n15	12	19	1\n15	12	20	16	17	18	20	37\n15	12	20	5	1	1	10496	1\n15	12	21	13	21\n15	12	21	1	433\n15	12	22	22	28\n15	12	22	1	1\n15	12	23	16	23\n15	12	23	1	13\n15	12	24	18	24\n15	12	24	4	6\n15	12	25	25\n15	12	25	6\n15	12	26	26\n15	12	26	2\n15	12	27	27\n15	12	27	2\n15	12	28	28\n15	12	28	3\n15	12	29	30\n15	12	29	1\n15	12	31	31\n15	12	31	1\n15	12	32	31	32\n15	12	32	1	4\n15	12	33	33	37\n15	12	33	1	1\n15	12	36	36\n15	12	36	1\n15	12	37	20	32	37\n15	12	37	21	1	195\n15	12	40	40\n15	12	40	1\n15	13	0	0\n15	13	0	16\n15	13	6	6	9	19\n15	13	6	6287	11	1\n15	13	7	7\n15	13	7	2140\n15	13	8	6	7	8	9	10\n15	13	8	1	157	3901	3	2\n15	13	9	6	7	8	9	10	11	13\n15	13	9	874	112	146	6708	7	3	1\n15	13	10	7	8	9	10	11	13\n15	13	10	34	43	132	4448	3	1\n15	13	11	8	9	10	11	12	13	15	16\n15	13	11	238	206	108	57280	457	18	2	2\n15	13	12	6	7	8	9	10	11	12	13	14	15	16\n15	13	12	1	78	213	276	312	3213	39801	21	2	18	1\n15	13	13	6	8	9	10	11	12	13	14	15	16	17\n15	13	13	4	89	162	110	583	700	39237	12	197	2	1\n15	13	14	9	10	11	12	13	14	15	16	17	18	20	22\n15	13	14	90	247	619	521	1187	31953	2	140	4	1	2	1\n15	13	15	6	9	10	11	12	13	14	15	16	17\n15	13	15	1	86	98	222	480	3980	847	23132	172	3\n15	13	16	8	10	11	12	13	14	15	16	17	19	20\n15	13	16	1	1	62	97	108	1145	644	11737	27	1	20\n15	13	17	13	14	15	16	17	18\n15	13	17	1	2	2	7	521	1\n15	13	18	9	10	12	13	14	16	18\n15	13	18	1	17	63	5	18	1	38\n15	13	19	16	18	19	22\n15	13	19	1	2	2	1\n15	13	20	11	12	13	14	15	16	17	20\n15	13	20	16	10	37	130	97	8396	229	1627\n15	13	21	12	13	21\n15	13	21	190	138	105\n15	13	22	19\n15	13	22	1\n15	13	23	11	13	14	23\n15	13	23	2	1	5	5\n15	13	24	12	13	22	24\n15	13	24	2	1	1	2\n15	13	25	16	18	25\n15	13	25	3	1	3\n15	13	26	26	29\n15	13	26	1	1\n15	13	27	27\n15	13	27	3\n15	13	28	27	28\n15	13	28	1	3\n15	13	30	30\n15	13	30	1\n15	13	31	30	31\n15	13	31	1	1\n15	13	32	28	30	32\n15	13	32	1	2	2\n15	13	33	30\n15	13	33	1\n15	13	36	10\n15	13	36	1\n15	13	37	16	17	20	37\n15	13	37	111	29	21	37\n15	13	40	17\n15	13	40	1\n15	14	0	0\n15	14	0	16\n15	14	6	6	25\n15	14	6	7167	1\n15	14	7	7\n15	14	7	2521\n15	14	8	7	8	13\n15	14	8	96	4532	3\n15	14	9	6	7	8	9	10	11	13\n15	14	9	577	45	116	6925	5	2	5\n15	14	10	7	8	9	10	11	12	13\n15	14	10	13	38	144	5147	3	1	5\n15	14	11	8	9	10	11	12	13	15	16\n15	14	11	94	150	99	61017	612	25	5	1\n15	14	12	7	8	9	10	11	12	13	14	15	16\n15	14	12	1	42	95	225	1881	40025	28	3	19	2\n15	14	13	6	8	9	10	11	12	13	14	15	16\n15	14	13	1	36	91	78	381	621	43211	31	276	10\n15	14	14	9	10	11	12	13	14	15	16	17	20\n15	14	14	21	80	108	225	725	32648	12	263	23	9\n15	14	15	9	10	11	12	13	14	15	16	17	18	20\n15	14	15	22	36	82	214	1937	426	21189	181	4	1	2\n15	14	16	11	12	13	14	15	16	17	20\n15	14	16	26	25	71	448	401	19575	13	14\n15	14	17	11	13	15	16	17\n15	14	17	1	2	1	7	804\n15	14	18	10	11	12	13	14	15	18\n15	14	18	2	1	17	2	12	1	8\n15	14	19	14	15	16	19\n15	14	19	1	2	1	1\n15	14	20	13	14	15	16	17	20\n15	14	20	1	1	1	516	13	1138\n15	14	21	12	13	21\n15	14	21	31	36	38\n15	14	22	14	17	18\n15	14	22	1	1	1\n15	14	23	11	13	23\n15	14	23	1	2	2\n15	14	24	12	18\n15	14	24	1	1\n15	14	25	16	25\n15	14	25	1	2\n15	14	26	22\n15	14	26	1\n15	14	27	23	27\n15	14	27	1	3\n15	14	28	24	27	28\n15	14	28	1	1	2\n15	14	29	28\n15	14	29	1\n15	14	30	19	30\n15	14	30	1	4\n15	14	31	30\n15	14	31	1\n15	14	32	32\n15	14	32	2\n15	14	37	16	17	20	35	37\n15	14	37	11	3	3	2	18\n16	1	0	0\n16	1	0	14\n16	1	6	6	9\n16	1	6	1443	133\n16	1	7	7	8	9	10	12\n16	1	7	1684	32	60	6	4\n16	1	8	7	8	9	10	11	12	13\n16	1	8	1	2735	34	15	41	53	13\n16	1	9	7	8	9	10	11	12	13	14	15\n16	1	9	4	17	4811	42	70	39	35	12	3\n16	1	10	8	9	10	11	12	13	14	15\n16	1	10	2	39	2342	27	70	20	32	10\n16	1	11	8	9	10	11	12	13	14	15	16\n16	1	11	1	12	46	40357	331	93	38	21	6\n16	1	12	9	10	11	12	13	14	15	16	21\n16	1	12	4	7	1154	32630	92	91	38	34	34\n16	1	13	8	9	10	11	12	13	14	15	16	21\n16	1	13	5	5	3	66	203	30992	186	300	23	41\n16	1	14	10	11	12	13	14	15	16	19	20\n16	1	14	1	7	29	135	23312	84	84	3	1\n16	1	15	11	12	13	14	15	16	17	18	19	21	23\n16	1	15	17	67	805	62	23387	124	1	1	6	37	1\n16	1	16	11	12	13	14	15	16	17	20	21	23	37\n16	1	16	2	5	12	433	274	14452	2	1561	84	5	43\n16	1	17	13	14	15	16	17	18	19	20	22	23	37\n16	1	17	1	16	1	15	416	1	1	37	1	1	11\n16	1	18	11	13	15	16	17	18	21	23	27\n16	1	18	1	6	3	3	1	83	10	2	2\n16	1	19	15	17	18	19	21	23\n16	1	19	4	1	2	57	2	2\n16	1	20	14	15	16	18	19	20	22	25	32	37\n16	1	20	7	1	4	1	3	1743	1	2	1	6\n16	1	21	15	21	23	25	34\n16	1	21	2	253	2	2	1\n16	1	22	17	20	22	23	25\n16	1	22	1	1	4	1	3\n16	1	23	19	23	26\n16	1	23	1	9	1\n16	1	24	24\n16	1	24	5\n16	1	25	23	25	28\n16	1	25	4	15	1\n16	1	26	26\n16	1	26	2\n16	1	27	27\n16	1	27	1\n16	1	28	26	28\n16	1	28	2	4\n16	1	30	28	30\n16	1	30	1	3\n16	1	31	31\n16	1	31	2\n16	1	33	40\n16	1	33	1\n16	1	34	32\n16	1	34	1\n16	1	37	20	37\n16	1	37	2	84\n16	1	40	40\n16	1	40	1\n16	2	0	0\n16	2	0	14\n16	2	6	6	9\n16	2	6	1372	71\n16	2	7	7	8	9	10	12\n16	2	7	1581	49	43	3	13\n16	2	8	7	8	9	10	11	12	13\n16	2	8	1	2605	23	12	51	89	11\n16	2	9	7	8	9	10	11	12	13	14	15\n16	2	9	4	12	4885	26	41	66	41	16	7\n16	2	10	8	9	10	11	12	13	14	15\n16	2	10	2	31	2255	22	75	20	45	12\n16	2	11	9	10	11	12	13	14	15	16\n16	2	11	13	46	40926	560	119	45	28	5\n16	2	12	9	10	11	12	13	14	15	16	17	18	19	20	21\n16	2	12	2	2	918	32149	97	93	41	62	1	1	1	2	62\n16	2	13	8	9	10	11	12	13	14	15	16	17	18	21\n16	2	13	2	2	3	43	224	31171	237	456	7	2	1	56\n16	2	14	11	12	13	14	15	16	19	20	23\n16	2	14	8	21	109	23822	100	110	9	9	1\n16	2	15	11	12	13	14	15	16	17	18	19	20	21\n16	2	15	5	52	615	40	23214	95	1	2	5	6	93\n16	2	16	12	13	14	15	16	17	20	21	23	37\n16	2	16	3	13	281	292	10392	5	3630	86	5	38\n16	2	17	13	14	15	16	17	20	21	23	37\n16	2	17	1	5	4	9	322	72	1	2	6\n16	2	18	13	14	15	16	18	19	21	23	25\n16	2	18	5	1	8	2	64	1	4	2	1\n16	2	19	14	15	16	17	18	19	21	23	25\n16	2	19	1	2	2	2	3	57	2	1	1\n16	2	20	14	15	16	19	20	25	28	37\n16	2	20	11	2	11	2	3309	1	1	8\n16	2	21	15	17	19	21	22	23	25	26\n16	2	21	2	1	1	450	1	1	4	1\n16	2	22	22	25\n16	2	22	4	2\n16	2	23	17	18	21	23	25	26\n16	2	23	1	1	1	22	1	1\n16	2	24	24	25\n16	2	24	4	1\n16	2	25	21	22	23	25\n16	2	25	1	1	1	19\n16	2	26	26\n16	2	26	5\n16	2	27	21	27\n16	2	27	1	2\n16	2	28	27	28	30\n16	2	28	1	4	1\n16	2	30	30\n16	2	30	3\n16	2	31	31\n16	2	31	2\n16	2	32	32\n16	2	32	2\n16	2	34	35\n16	2	34	1\n16	2	37	37\n16	2	37	144\n16	2	40	40\n16	2	40	2\n16	3	0	0\n16	3	0	14\n16	3	6	6\n16	3	6	1372\n16	3	7	7\n16	3	7	1586\n16	3	8	7	8\n16	3	8	2	2668\n16	3	9	6	7	8	9	10\n16	3	9	2	5	8	5047	8\n16	3	10	7	8	9	10	11\n16	3	10	1	1	38	2302	5\n16	3	11	8	9	10	11	12	13\n16	3	11	4	6	48	41937	10	9\n16	3	12	9	10	11	12	13	14	15	21\n16	3	12	7	2	756	32456	17	11	2	1\n16	3	13	8	9	10	11	12	13	14	15	17\n16	3	13	1	3	1	28	180	31926	39	23	1\n16	3	14	11	12	13	14	15	16	18	19\n16	3	14	8	22	113	24438	10	4	1	1\n16	3	15	11	12	13	14	15	16	17	20\n16	3	15	3	37	529	50	23514	31	3	1\n16	3	16	12	13	14	15	16	17	20\n16	3	16	4	2	165	232	10288	2	2\n16	3	17	11	13	14	15	16	17\n16	3	17	1	2	2	5	19	306\n16	3	18	13	15	16	17	18	22\n16	3	18	1	7	2	2	59	1\n16	3	19	15	16	18	19\n16	3	19	3	1	2	70\n16	3	20	14	15	16	18	19	20	37\n16	3	20	2	3	8	1	2	7006	6\n16	3	21	15	16	19	20	21\n16	3	21	2	3	1	3	748\n16	3	22	21	22\n16	3	22	1	5\n16	3	23	19	20	21	23\n16	3	23	1	1	1	32\n16	3	24	20	22	24\n16	3	24	1	1	2\n16	3	25	22	23	25\n16	3	25	2	3	25\n16	3	26	18	20	23	26\n16	3	26	1	1	1	4\n16	3	27	27\n16	3	27	3\n16	3	28	22	23	26	28\n16	3	28	1	1	1	2\n16	3	30	30\n16	3	30	4\n16	3	31	25	31\n16	3	31	1	1\n16	3	32	32	33\n16	3	32	1	1\n16	3	35	37\n16	3	35	1\n16	3	37	37\n16	3	37	196\n16	3	40	40\n16	3	40	2\n16	4	0	0\n16	4	0	14\n16	4	6	6\n16	4	6	1374\n16	4	7	7	14\n16	4	7	1592	2\n16	4	8	7	8	13\n16	4	8	5	2676	1\n16	4	9	7	8	9	10\n16	4	9	6	10	5071	14\n16	4	10	7	8	9	10	11\n16	4	10	2	2	32	2324	1\n16	4	11	9	10	11	12	13	14	15\n16	4	11	19	37	42641	17	22	1	1\n16	4	12	9	10	11	12	13	14	15\n16	4	12	1	1	643	32048	13	2	1\n16	4	13	9	10	11	12	13	14	15\n16	4	13	1	2	17	181	32342	29	27\n16	4	14	11	12	13	14	15	16	18\n16	4	14	6	14	119	24558	8	1	1\n16	4	15	11	12	13	14	15	16	18	20\n16	4	15	1	24	361	53	23332	28	1	1\n16	4	16	12	13	14	15	16	17	18	20\n16	4	16	3	1	119	221	10006	2	1	3\n16	4	17	12	13	15	16	17	18\n16	4	17	2	2	1	16	292	1\n16	4	18	12	14	15	17	18\n16	4	18	1	3	6	3	51\n16	4	19	14	15	17	18	19	20\n16	4	19	1	9	1	1	62	1\n16	4	20	9	15	16	17	20	37\n16	4	20	2	3	14	1	6993	2\n16	4	21	15	17	18	20	21\n16	4	21	3	1	3	1	743\n16	4	22	10	16	18	19	21	22\n16	4	22	1	1	2	1	1	4\n16	4	23	10	14	15	18	19	21	23	32\n16	4	23	1	1	3	3	1	3	24	1\n16	4	24	10\n16	4	24	2\n16	4	25	19	20	21	22	23	25\n16	4	25	3	4	1	4	2	12\n16	4	26	13	26\n16	4	26	1	4\n16	4	27	14	27\n16	4	27	1	2\n16	4	28	28\n16	4	28	2\n16	4	30	16	30	32\n16	4	30	1	2	1\n16	4	31	31\n16	4	31	1\n16	4	32	32\n16	4	32	1\n16	4	33	33\n16	4	33	1\n16	4	37	20	37\n16	4	37	2	201\n16	4	40	27	40\n16	4	40	1	1\n16	5	0	0\n16	5	0	14\n16	5	6	6	11\n16	5	6	1373	1\n16	5	7	7	8\n16	5	7	1604	1\n16	5	8	7	8\n16	5	8	2	2686\n16	5	9	7	8	9	10	11\n16	5	9	7	22	5083	13	1\n16	5	10	8	9	10	11	13\n16	5	10	2	41	2336	2	1\n16	5	11	8	9	10	11	12	13\n16	5	11	3	16	36	43223	17	14\n16	5	12	9	10	11	12	13	14\n16	5	12	8	5	432	31826	17	2\n16	5	13	8	9	10	11	12	13	14	15\n16	5	13	12	3	1	24	215	32567	15	25\n16	5	14	11	12	13	14	15	16	17\n16	5	14	9	29	133	24586	3	9	1\n16	5	15	8	11	12	13	14	15	16\n16	5	15	1	1	16	373	49	23156	19\n16	5	16	8	12	14	15	16	17\n16	5	16	5	3	112	206	9736	5\n16	5	17	13	14	15	16	17\n16	5	17	1	1	1	16	281\n16	5	18	11	13	14	15	17	18\n16	5	18	1	1	2	6	3	51\n16	5	19	8	15	18	19\n16	5	19	2	4	2	59\n16	5	20	13	15	16	20	21	22	37\n16	5	20	2	1	9	6989	1	1	2\n16	5	21	8	15	16	17	18	20	21\n16	5	21	1	4	1	3	1	1	737\n16	5	22	8	10	20	21	22\n16	5	22	1	1	1	1	4\n16	5	23	8	15	21	23\n16	5	23	2	1	3	20\n16	5	25	15	23	25\n16	5	25	1	1	10\n16	5	26	17	26\n16	5	26	2	2\n16	5	27	27\n16	5	27	3\n16	5	28	28\n16	5	28	2\n16	5	30	30\n16	5	30	2\n16	5	31	17\n16	5	31	1\n16	5	32	32\n16	5	32	3\n16	5	33	35\n16	5	33	1\n16	5	37	20	37\n16	5	37	12	191\n16	5	40	40\n16	5	40	1\n16	6	0	0\n16	6	0	14\n16	6	6	6\n16	6	6	1373\n16	6	7	7\n16	6	7	1613\n16	6	8	6	7	8\n16	6	8	1	11	2726\n16	6	9	6	7	8	9	10	13\n16	6	9	14	18	21	5082	15	1\n16	6	10	7	8	9	10\n16	6	10	3	1	33	2355\n16	6	11	7	8	9	10	11	12	13	14\n16	6	11	13	1	26	40	43570	24	14	6\n16	6	12	7	9	10	11	12	13	14	15	18\n16	6	12	4	6	6	356	31704	14	11	4	1\n16	6	13	6	7	9	11	12	13	14	15\n16	6	13	1	71	7	25	165	32803	20	17\n16	6	14	7	9	10	11	12	13	14	15	16	18\n16	6	14	8	2	2	19	45	130	24546	1	12	2\n16	6	15	7	9	10	11	12	13	14	15	16\n16	6	15	41	7	1	5	18	316	47	22957	16\n16	6	16	7	12	13	14	15	16	17	20\n16	6	16	2	3	1	66	145	9569	3	1\n16	6	17	7	9	12	13	14	15	16	17	21\n16	6	17	4	3	1	1	1	4	18	262	2\n16	6	18	7	9	13	15	16	17	18	19\n16	6	18	9	4	2	6	1	1	30	1\n16	6	19	7	9	10	12	14	15	19\n16	6	19	17	5	3	3	18	7	6\n16	6	20	7	9	10	15	16	20	37\n16	6	20	3	1	4	3	6	6985	1\n16	6	21	7	9	13	15	16	18	20	21\n16	6	21	2	1	3	80	12	4	1	639\n16	6	22	10	22\n16	6	22	4	1\n16	6	23	7	9	16	23\n16	6	23	1	2	1	17\n16	6	25	9	10	18\n16	6	25	4	5	1\n16	6	26	19	20\n16	6	26	1	1\n16	6	27	18	20	27\n16	6	27	1	1	1\n16	6	28	25\n16	6	28	2\n16	6	30	25	32\n16	6	30	1	1\n16	6	32	24	32\n16	6	32	1	2\n16	6	35	37\n16	6	35	1\n16	6	37	20	37\n16	6	37	14	179\n16	6	40	40\n16	6	40	1\n16	7	0	0\n16	7	0	14\n16	7	6	6\n16	7	6	1389\n16	7	7	6	7	9\n16	7	7	3	1816	1\n16	7	8	6	7	8\n16	7	8	3	5	2741\n16	7	9	6	7	8	9	10	11\n16	7	9	10	10	22	5128	10	3\n16	7	10	7	8	9	10	11	13\n16	7	10	4	4	33	2389	3	2\n16	7	11	6	9	10	11	12	13	14	15\n16	7	11	5	27	40	43849	31	17	5	1\n16	7	12	6	8	9	10	11	12	13	14	15\n16	7	12	2	3	8	10	251	31660	17	9	3\n16	7	13	6	8	9	10	11	12	13	14	15	17\n16	7	13	15	2	2	3	31	154	33024	24	29	1\n16	7	14	6	8	9	10	11	12	13	14	15	16	17\n16	7	14	1	1	1	4	16	43	116	24509	7	16	1\n16	7	15	6	10	11	12	13	14	15	16	17\n16	7	15	12	2	3	11	246	37	22876	36	1\n16	7	16	10	12	13	14	15	16	17	20\n16	7	16	2	98	5	59	122	9338	10	1\n16	7	17	9	10	14	15	16	17	32\n16	7	17	2	1	1	3	7	251	1\n16	7	18	15	18\n16	7	18	4	35\n16	7	19	19\n16	7	19	8\n16	7	20	14	15	16	20	37\n16	7	20	4	1	14	6983	1\n16	7	21	9	12	13	14	15	16	18	20	21\n16	7	21	3	3	37	3	186	73	6	1	329\n16	7	22	22\n16	7	22	1\n16	7	23	9	14	15	16	17\n16	7	23	2	1	3	10	1\n16	7	24	24\n16	7	24	1\n16	7	25	25\n16	7	25	3\n16	7	27	27\n16	7	27	1\n16	7	32	25	30	32\n16	7	32	1	1	1\n16	7	37	20	37\n16	7	37	15	166\n16	7	40	40\n16	7	40	1\n16	8	0	0\n16	8	0	14\n16	8	6	6	9\n16	8	6	1435	5\n16	8	7	6	7	9\n16	8	7	29	1791	15\n16	8	8	6	7	8	9	19	23\n16	8	8	35	1	2731	4	1	1\n16	8	9	6	7	8	9	10	11	13\n16	8	9	89	11	20	5075	9	2	1\n16	8	10	6	8	9	10	11	12	13	17	22\n16	8	10	9	4	49	2389	2	4	1	2	1\n16	8	11	6	8	9	10	11	12	13	14\n16	8	11	89	3	30	106	43814	96	16	2\n16	8	12	6	8	9	10	11	12	13	14	15	16	19\n16	8	12	15	5	7	50	221	31664	25	6	4	2	1\n16	8	13	6	8	9	10	11	12	13	14	15	23\n16	8	13	355	3	28	4	32	193	32766	32	50	1\n16	8	14	6	8	9	10	11	12	13	14	15	16	17	18	21\n16	8	14	10	19	7	23	19	47	142	24351	2	25	1	5	1\n16	8	15	6	8	9	10	11	12	13	14	15	16	17	18	21\n16	8	15	190	7	67	3	1	15	215	57	22626	49	2	2	1\n16	8	16	6	8	9	10	12	13	14	15	16	17	20\n16	8	16	3	7	21	2	2	6	51	139	9251	7	5\n16	8	17	10	13	14	16	17\n16	8	17	1	1	2	5	256\n16	8	18	6	8	9	10	12	13	14	16	18\n16	8	18	1	1	9	1	1	4	2	1	21\n16	8	19	8	10	13	17	18\n16	8	19	1	2	3	1	1\n16	8	20	8	10	14	15	16	17	20	37\n16	8	20	1	2	4	3	48	1	6940	1\n16	8	21	6	9	21	24\n16	8	21	3	12	313	1\n16	8	22	14\n16	8	22	1\n16	8	24	17\n16	8	24	1\n16	8	25	13	14	22\n16	8	25	2	1	1\n16	8	27	25\n16	8	27	1\n16	8	30	30\n16	8	30	1\n16	8	32	32\n16	8	32	2\n16	8	37	20	37\n16	8	37	16	151\n16	8	40	40\n16	8	40	1\n16	9	0	0\n16	9	0	14\n16	9	6	6	9\n16	9	6	2253	10\n16	9	7	6	7	9	11\n16	9	7	72	1728	2	1\n16	9	8	6	7	8	9	12	17\n16	9	8	88	4	2696	11	1	2\n16	9	9	6	7	8	9	10	11	24\n16	9	9	141	27	38	5118	2	2	1\n16	9	10	6	7	8	9	10	12\n16	9	10	37	1	4	49	2495	6\n16	9	11	6	8	9	10	11	12	13	17\n16	9	11	215	11	43	338	43257	200	26	1\n16	9	12	6	7	8	9	10	11	12	13	14	15	18\n16	9	12	106	1	25	14	193	152	31441	82	5	2	1\n16	9	13	6	8	9	10	11	12	13	14	15\n16	9	13	1162	5	112	19	25	160	31636	16	47\n16	9	14	6	8	9	10	11	12	13	14	15	16\n16	9	14	38	108	14	55	27	32	112	24097	2	24\n16	9	15	6	8	9	10	12	13	14	15	16	18\n16	9	15	382	12	187	19	16	108	55	21991	53	1\n16	9	16	6	8	9	10	11	12	13	14	15	16	17	20\n16	9	16	21	27	86	28	14	13	8	30	93	9054	4	3\n16	9	17	13	15	16	17	22	28\n16	9	17	3	1	9	256	1	1\n16	9	18	6	9	11	14	15	18\n16	9	18	5	11	1	5	2	5\n16	9	19	19\n16	9	19	2\n16	9	20	10	14	16	20	37\n16	9	20	1	1	13	6943	3\n16	9	21	6	9	10	15	16	18	21	22\n16	9	21	6	70	1	1	1	1	234	1\n16	9	22	18	22\n16	9	22	1	1\n16	9	23	19	28\n16	9	23	1	1\n16	9	24	24\n16	9	24	1\n16	9	25	22\n16	9	25	1\n16	9	30	30\n16	9	30	1\n16	9	32	32\n16	9	32	2\n16	9	37	20	37\n16	9	37	11	141\n16	9	40	37\n16	9	40	1\n16	10	0	0\n16	10	0	14\n16	10	6	6	9\n16	10	6	4407	119\n16	10	7	6	7	8	9\n16	10	7	27	1731	1	2\n16	10	8	6	7	8	9	10	11	13\n16	10	8	34	7	2870	7	1	4	3\n16	10	9	6	7	8	9	10	11	13	22\n16	10	9	54	12	37	5615	6	1	1	1\n16	10	10	6	8	9	10	11	12	13\n16	10	10	8	7	40	3082	1	7	6\n16	10	11	6	7	8	9	10	11	12	13	23\n16	10	11	107	7	16	28	248	42869	194	9	1\n16	10	12	6	7	8	9	10	11	12	13	14	15	18	24	29\n16	10	12	53	1	28	8	138	125	31452	48	1	6	6	2	1\n16	10	13	6	8	9	10	11	12	13	14	15	17	23\n16	10	13	537	16	43	22	26	144	31109	14	60	2	2\n16	10	14	6	8	9	10	11	12	13	14	15	16	18	23\n16	10	14	18	79	13	50	26	31	125	23833	1	29	1	3\n16	10	15	6	8	9	10	12	13	14	15	16	17\n16	10	15	174	21	96	16	5	53	70	21663	40	1\n16	10	16	8	9	10	11	12	13	14	15	16	17	18	20	23\n16	10	16	33	10	29	15	10	3	20	101	8920	7	1	1	4\n16	10	17	14	15	16	17	23\n16	10	17	1	1	9	251	1\n16	10	18	13	14	15	17	18\n16	10	18	1	2	1	1	4\n16	10	19	19\n16	10	19	3\n16	10	20	8	10	16	20	25	37\n16	10	20	1	1	4	6945	1	5\n16	10	21	21\n16	10	21	234\n16	10	22	18	22	28\n16	10	22	1	2	1\n16	10	24	24	26\n16	10	24	1	1\n16	10	28	28	30\n16	10	28	1	1\n16	10	30	30\n16	10	30	1\n16	10	32	32\n16	10	32	2\n16	10	37	20	37\n16	10	37	10	135\n16	11	0	0\n16	11	0	14\n16	11	6	6	7	8	9	10	12	16\n16	11	6	5134	1	2	278	1	1	2\n16	11	7	6	7	8	9	11	13\n16	11	7	7	1560	115	28	40	8\n16	11	8	6	7	8	9	10\n16	11	8	5	10	3073	18	3\n16	11	9	6	7	8	9	10	11	13\n16	11	9	18	11	44	5886	2	13	7\n16	11	10	6	8	9	10	11	12	13	14	17\n16	11	10	4	3	45	3518	5	10	3	2	3\n16	11	11	6	7	8	9	10	11	12	13	14	15\n16	11	11	40	4	5	15	63	42849	73	1	12	5\n16	11	12	6	7	8	9	10	11	12	13	14	15	18	22\n16	11	12	18	1	6	7	25	145	31602	21	10	5	2	1\n16	11	13	6	8	9	10	11	12	13	14	15\n16	11	13	179	4	13	19	22	169	30876	8	68\n16	11	14	6	8	10	11	12	13	14	16\n16	11	14	11	37	13	18	28	104	23712	18\n16	11	15	6	8	9	10	12	13	14	15	16	18\n16	11	15	63	4	35	2	8	59	89	21541	31	1\n16	11	16	8	9	10	11	12	13	14	15	16	17	18	19\n16	11	16	6	2	6	5	4	1	24	86	8863	3	1	1\n16	11	17	13	14	15	16	17	18\n16	11	17	1	1	2	7	250	1\n16	11	18	15	18\n16	11	18	1	12\n16	11	19	19\n16	11	19	3\n16	11	20	8	16	17	20	37\n16	11	20	1	3	1	6950	1\n16	11	21	21	27\n16	11	21	233	1\n16	11	22	20	22	24\n16	11	22	1	1	1\n16	11	23	13	23\n16	11	23	1	10\n16	11	24	24\n16	11	24	3\n16	11	25	25\n16	11	25	1\n16	11	26	26\n16	11	26	1\n16	11	28	28\n16	11	28	2\n16	11	29	28\n16	11	29	1\n16	11	30	30\n16	11	30	2\n16	11	32	32\n16	11	32	2\n16	11	37	20	37\n16	11	37	5	135\n16	12	0	0\n16	12	0	14\n16	12	6	6	7	8	9	11	13	15\n16	12	6	5344	2	19	109	3	1	1\n16	12	7	6	7	10\n16	12	7	1	1583	3\n16	12	8	6	8	9	10	16\n16	12	8	2	3281	11	5	1\n16	12	9	6	7	8	9	10	11	13	14	18\n16	12	9	7	7	13	6293	1	3	1	1	1\n16	12	10	6	8	9	10	11	12	13	14	15	16	17\n16	12	10	1	2	48	3574	8	10	2	3	1	2	1\n16	12	11	6	7	8	9	10	11	12	13	14	15\n16	12	11	9	2	1	11	30	42812	220	7	3	2\n16	12	12	6	9	10	11	12	13	14	15	18	24\n16	12	12	3	9	7	117	31680	18	2	3	55	1\n16	12	13	6	9	10	11	12	13	14	15	18	24\n16	12	13	48	5	8	26	171	30682	4	129	8	1\n16	12	14	8	9	10	11	12	13	14	15	16	17	20\n16	12	14	2	2	1	20	35	133	23620	1	42	1	1\n16	12	15	6	9	12	13	14	15	16	18\n16	12	15	22	4	1	24	82	21473	100	2\n16	12	16	8	9	10	12	13	14	15	16	17	18	20	37\n16	12	16	3	1	1	2	2	12	95	8781	16	1	9	1\n16	12	17	11	13	14	16	17	18	24\n16	12	17	1	3	1	5	244	2	1\n16	12	18	14	18	19	24\n16	12	18	1	12	2	2\n16	12	19	9	13	18	19\n16	12	19	1	1	1	1\n16	12	20	16	20\n16	12	20	3	6953\n16	12	21	21\n16	12	21	233\n16	12	22	22	28\n16	12	22	1	1\n16	12	23	23	24\n16	12	23	9	1\n16	12	24	24\n16	12	24	4\n16	12	25	25\n16	12	25	1\n16	12	26	26\n16	12	26	1\n16	12	27	27\n16	12	27	1\n16	12	28	21	25	28\n16	12	28	1	1	1\n16	12	30	30\n16	12	30	2\n16	12	32	30	32\n16	12	32	1	1\n16	12	37	20	37\n16	12	37	6	130\n16	13	0	0\n16	13	0	14\n16	13	6	6	7	9	11\n16	13	6	5393	2	41	1\n16	13	7	7	9\n16	13	7	1591	3\n16	13	8	6	7	8	9	13\n16	13	8	1	4	3312	3	1\n16	13	9	6	7	8	9	10	11	12	14	18\n16	13	9	7	6	11	6449	3	13	2	2	1\n16	13	10	8	9	10	11	13	14	16	18\n16	13	10	1	37	3584	2	1	3	1	1\n16	13	11	6	9	10	11	12	13	15\n16	13	11	3	21	35	42676	244	8	3\n16	13	12	6	9	10	11	12	13	15	16\n16	13	12	2	3	4	111	31970	20	8	1\n16	13	13	6	9	10	11	12	13	14	15	16\n16	13	13	10	1	3	27	184	30509	10	129	1\n16	13	14	6	9	11	12	13	14	15	16	17	18\n16	13	14	1	2	9	32	146	23469	2	59	1	8\n16	13	15	6	9	11	12	13	14	15	16	18	19	20	21\n16	13	15	3	1	1	2	45	77	21456	114	1	3	1	1\n16	13	16	12	14	15	16	17	20\n16	13	16	3	8	88	8815	14	6\n16	13	17	16	17\n16	13	17	2	260\n16	13	18	12	15	18	19\n16	13	18	1	1	78	2\n16	13	19	19	21\n16	13	19	2	1\n16	13	20	14	20	37\n16	13	20	1	6967	1\n16	13	21	18	21\n16	13	21	1	233\n16	13	22	22\n16	13	22	1\n16	13	23	23\n16	13	23	9\n16	13	24	24	28\n16	13	24	9	1\n16	13	25	24	25\n16	13	25	1	1\n16	13	26	26\n16	13	26	1\n16	13	27	19\n16	13	27	1\n16	13	28	28\n16	13	28	2\n16	13	30	30\n16	13	30	3\n16	13	32	32\n16	13	32	1\n16	13	37	20	37\n16	13	37	9	122\n16	14	0	0\n16	14	0	14\n16	14	6	6	9\n16	14	6	5416	4\n16	14	7	7\n16	14	7	1603\n16	14	8	6	7	8	9	13\n16	14	8	1	143	3178	1	1\n16	14	9	6	7	8	9	10\n16	14	9	717	113	127	5602	2\n16	14	10	7	8	9	10	13\n16	14	10	23	47	114	3444	1\n16	14	11	6	8	9	10	11	12	13	14	15\n16	14	11	1	187	163	95	42081	297	14	1	1\n16	14	12	7	8	9	10	11	12	13	15	16\n16	14	12	60	160	243	254	2483	29211	18	8	1\n16	14	13	6	8	9	10	11	12	13	14	15	16\n16	14	13	1	52	138	96	485	556	29201	14	184	3\n16	14	14	9	10	11	12	13	14	15	16	17	20	21\n16	14	14	76	170	448	421	862	21490	5	88	4	5	1\n16	14	15	6	9	10	11	12	13	14	15	16	19\n16	14	15	1	86	86	160	389	3304	661	16889	110	1\n16	14	16	10	11	12	13	14	15	16	17	20\n16	14	16	1	54	64	86	794	445	7530	15	4\n16	14	17	10	13	15	16	17\n16	14	17	1	4	1	5	264\n16	14	18	10	12	13	14	15	17	18\n16	14	18	13	35	7	7	2	3	23\n16	14	19	14	15	19\n16	14	19	1	1	6\n16	14	20	11	12	13	14	15	16	17	20\n16	14	20	6	8	26	112	76	5679	139	937\n16	14	21	12	13	15	18	21\n16	14	21	89	84	1	1	60\n16	14	22	19\n16	14	22	1\n16	14	23	14	16	23\n16	14	23	4	1	4\n16	14	24	12	13	14	18	24	28\n16	14	24	2	1	1	1	4	1\n16	14	25	25\n16	14	25	1\n16	14	26	26\n16	14	26	1\n16	14	28	28	30\n16	14	28	2	1\n16	14	30	30	32\n16	14	30	2	1\n16	14	32	32\n16	14	32	1\n16	14	37	16	17	20	37\n16	14	37	74	24	9	16\n16	15	0	0\n16	15	0	14\n16	15	6	6\n16	15	6	6137\n16	15	7	7\n16	15	7	1942\n16	15	8	7	8	13\n16	15	8	86	3664	1\n16	15	9	6	7	8	9	10	11	13\n16	15	9	499	45	122	5756	2	2	1\n16	15	10	7	8	9	10	11	13\n16	15	10	10	33	112	4003	1	3\n16	15	11	7	8	9	10	11	12	13	15	16\n16	15	11	1	103	119	81	44960	431	12	9	1\n16	15	12	6	7	8	9	10	11	12	13	15	16\n16	15	12	2	2	35	73	202	1384	29335	18	19	2\n16	15	13	8	9	10	11	12	13	14	15	16	17	18\n16	15	13	25	81	58	274	452	32485	17	207	8	1	1\n16	15	14	9	10	11	12	13	14	15	16	17	20\n16	15	14	14	56	95	134	574	22029	4	168	5	6\n16	15	15	9	10	11	12	13	14	15	16	17	20\n16	15	15	14	17	84	142	1561	332	15350	110	1	2\n16	15	16	9	11	12	13	14	15	16	17	20\n16	15	16	1	19	23	85	358	297	12690	15	3\n16	15	17	12	13	14	15	16	17\n16	15	17	2	1	1	1	6	438\n16	15	18	12	13	14	15	17	18\n16	15	18	14	2	3	1	2	3\n16	15	19	15	17	18	19\n16	15	19	2	1	2	3\n16	15	20	14	15	16	17	20	22\n16	15	20	4	2	368	2	578	1\n16	15	21	12	13	21\n16	15	21	14	15	32\n16	15	23	11	16	23\n16	15	23	1	1	2\n16	15	24	12	15	24\n16	15	24	1	1	2\n16	15	25	25\n16	15	25	1\n16	15	26	28\n16	15	26	1\n16	15	28	23	28\n16	15	28	1	2\n16	15	30	21	30	32\n16	15	30	1	1	1\n16	15	32	32\n16	15	32	2\n16	15	37	16	20	35	37\n16	15	37	4	5	1	6\n17	1	0	0\n17	1	0	7\n17	1	6	6	9\n17	1	6	1022	89\n17	1	7	7	8	9	10\n17	1	7	1315	19	46	3\n17	1	8	7	8	9	10	11	12	13\n17	1	8	5	2065	19	6	21	39	12\n17	1	9	6	7	8	9	10	11	12	13	14	15\n17	1	9	1	4	6	3748	30	54	29	18	6	2\n17	1	10	7	8	9	10	11	12	13	14	15\n17	1	10	1	1	38	1803	15	46	20	31	8\n17	1	11	9	10	11	12	13	14	15	16\n17	1	11	7	32	29886	274	70	24	10	4\n17	1	12	9	10	11	12	13	14	15	16	21\n17	1	12	4	5	827	24074	77	49	28	34	31\n17	1	13	8	9	10	11	12	13	14	15	16	17	21\n17	1	13	3	4	3	48	131	23674	139	269	11	1	28\n17	1	14	11	12	13	14	15	16	19\n17	1	14	5	12	103	15726	38	58	2\n17	1	15	11	12	13	14	15	16	17	18	20	21\n17	1	15	11	42	554	47	18097	102	1	2	3	23\n17	1	16	12	13	14	15	16	17	20	21	23	37\n17	1	16	6	5	288	162	9719	1	1001	63	1	22\n17	1	17	14	15	16	17	18	20	23	37\n17	1	17	10	1	1	246	1	22	5	5\n17	1	18	13	14	15	16	17	18	19	21	23	37\n17	1	18	9	2	3	1	2	63	1	7	4	1\n17	1	19	15	18	19	20	21	25	33\n17	1	19	1	1	20	1	2	1	1\n17	1	20	14	15	16	18	20	23	25	37\n17	1	20	4	2	3	1	1049	1	1	3\n17	1	21	15	20	21	23	25	27\n17	1	21	1	2	157	2	2	1\n17	1	22	22	25\n17	1	22	1	1\n17	1	23	21	23	26\n17	1	23	1	15	1\n17	1	25	23	25	28\n17	1	25	1	6	2\n17	1	26	26\n17	1	26	1\n17	1	27	27\n17	1	27	1\n17	1	31	28	31\n17	1	31	1	1\n17	1	32	32\n17	1	32	2\n17	1	34	34\n17	1	34	1\n17	1	36	36\n17	1	36	1\n17	1	37	37\n17	1	37	53\n17	1	40	40\n17	1	40	1\n17	2	0	0\n17	2	0	7\n17	2	6	6	9\n17	2	6	965	58\n17	2	7	7	8	9	10	12\n17	2	7	1247	31	32	3	12\n17	2	8	7	8	9	10	11	12	13\n17	2	8	4	1962	19	5	42	52	10\n17	2	9	6	7	8	9	10	11	12	13	14	15\n17	2	9	1	2	11	3818	18	30	30	20	13	12\n17	2	10	9	10	11	12	13	14	15\n17	2	10	32	1728	12	50	12	36	12\n17	2	11	9	10	11	12	13	14	15	16\n17	2	11	11	31	30295	392	69	37	22	10\n17	2	12	9	10	11	12	13	14	15	16	20	21\n17	2	12	2	3	665	23698	89	60	38	40	1	57\n17	2	13	8	9	10	11	12	13	14	15	16	17	18	20	21\n17	2	13	1	1	2	40	141	23814	153	336	8	1	1	1	43\n17	2	14	11	12	13	14	15	16	20\n17	2	14	10	11	85	16084	59	71	6\n17	2	15	11	12	13	14	15	16	17	19	20	21	23\n17	2	15	10	25	468	38	17967	56	1	1	6	49	1\n17	2	16	12	13	14	15	16	17	20	21	23	37\n17	2	16	3	4	170	170	6970	4	2523	52	3	34\n17	2	17	14	15	16	17	20	21	23	37\n17	2	17	4	1	7	197	35	1	1	5\n17	2	18	13	14	15	17	18	21	23\n17	2	18	2	2	5	1	44	13	1\n17	2	19	15	19	25\n17	2	19	1	21	1\n17	2	20	14	15	16	19	20	25\n17	2	20	4	2	2	1	2067	2\n17	2	21	15	21	23\n17	2	21	2	306	4\n17	2	22	23\n17	2	22	1\n17	2	23	19	21	23\n17	2	23	1	2	26\n17	2	25	25	31\n17	2	25	10	1\n17	2	26	23	31\n17	2	26	1	1\n17	2	27	27\n17	2	27	2\n17	2	28	28\n17	2	28	3\n17	2	31	31\n17	2	31	1\n17	2	32	32\n17	2	32	2\n17	2	33	33\n17	2	33	1\n17	2	34	34\n17	2	34	1\n17	2	36	36\n17	2	36	1\n17	2	37	37\n17	2	37	84\n17	2	40	40\n17	2	40	1\n17	3	0	0\n17	3	0	7\n17	3	6	6\n17	3	6	966\n17	3	7	7\n17	3	7	1253\n17	3	8	7	8\n17	3	8	3	2002\n17	3	9	6	7	8	9	10\n17	3	9	1	4	12	3946	10\n17	3	10	8	9	10	11\n17	3	10	1	16	1770	3\n17	3	11	9	10	11	12	13	15	18\n17	3	11	9	22	31048	14	8	2	1\n17	3	12	9	10	11	12	13	14	15\n17	3	12	1	6	550	23838	14	2	3\n17	3	13	9	11	12	13	14	15	16\n17	3	13	1	25	142	24351	26	27	1\n17	3	14	11	12	13	14	15	16	17	18\n17	3	14	6	14	81	16488	3	7	1	1\n17	3	15	11	12	13	14	15	16	17	18	37\n17	3	15	2	25	401	37	18134	25	1	1	1\n17	3	16	12	13	14	15	16	17\n17	3	16	2	1	88	184	6888	1\n17	3	17	13	14	15	16	17\n17	3	17	1	2	2	9	190\n17	3	18	13	15	17	18\n17	3	18	2	2	1	40\n17	3	19	14	15	17	19\n17	3	19	1	2	1	20\n17	3	20	14	15	16	19	20\n17	3	20	1	2	4	1	4631\n17	3	21	15	16	19	21	23	32\n17	3	21	2	1	1	517	1	1\n17	3	23	21	23\n17	3	23	2	36\n17	3	25	23	25\n17	3	25	2	11\n17	3	27	26	27\n17	3	27	1	1\n17	3	28	23	28\n17	3	28	1	2\n17	3	31	25	26	31\n17	3	31	1	1	1\n17	3	32	32\n17	3	32	2\n17	3	33	33\n17	3	33	1\n17	3	34	34\n17	3	34	1\n17	3	36	36\n17	3	36	1\n17	3	37	20	37\n17	3	37	2	121\n17	3	40	40\n17	3	40	1\n17	4	0	0\n17	4	0	7\n17	4	6	6\n17	4	6	967\n17	4	7	7\n17	4	7	1260\n17	4	8	7	8\n17	4	8	2	2013\n17	4	9	6	7	8	9	10\n17	4	9	1	4	9	3947	12\n17	4	10	8	9	10	13\n17	4	10	1	29	1777	1\n17	4	11	9	10	11	12	13	15\n17	4	11	11	32	31566	12	11	2\n17	4	12	9	10	11	12	13	14	15\n17	4	12	1	2	445	23561	14	11	1\n17	4	13	8	9	10	11	12	13	14	15	16\n17	4	13	1	4	3	23	150	24633	20	24	1\n17	4	14	11	12	13	14	15	16	20\n17	4	14	9	12	87	16528	4	4	1\n17	4	15	11	12	13	14	15	16	17\n17	4	15	1	25	310	31	17978	17	1\n17	4	16	12	14	15	16	17\n17	4	16	1	70	157	6703	4\n17	4	17	13	16	17	19\n17	4	17	4	9	181	1\n17	4	18	12	13	15	18\n17	4	18	1	1	5	36\n17	4	19	9	15	18	19\n17	4	19	1	1	2	18\n17	4	20	12	16	20	37\n17	4	20	1	6	4622	4\n17	4	21	14	15	20	21\n17	4	21	1	7	2	509\n17	4	23	15	17	18	19	21	23\n17	4	23	1	1	1	4	1	32\n17	4	25	19	23	25\n17	4	25	4	1	7\n17	4	26	26\n17	4	26	2\n17	4	27	21\n17	4	27	1\n17	4	28	23	28\n17	4	28	1	1\n17	4	31	31\n17	4	31	1\n17	4	32	32\n17	4	32	3\n17	4	33	33\n17	4	33	1\n17	4	34	34\n17	4	34	1\n17	4	36	40\n17	4	36	1\n17	4	37	37\n17	4	37	122\n17	4	40	40\n17	4	40	1\n17	5	0	0\n17	5	0	7\n17	5	6	6\n17	5	6	968\n17	5	7	7\n17	5	7	1266\n17	5	8	7	8\n17	5	8	1	2023\n17	5	9	6	7	8	9	10\n17	5	9	1	3	12	3961	16\n17	5	10	8	9	10\n17	5	10	1	25	1800\n17	5	11	8	9	10	11	12	13	14	15	16\n17	5	11	1	11	36	31971	9	13	1	1	1\n17	5	12	9	10	11	12	13	14\n17	5	12	3	4	340	23400	14	2\n17	5	13	8	9	11	12	13	14	15\n17	5	13	9	2	21	126	24857	25	21\n17	5	14	11	12	13	14	15	16	20	22\n17	5	14	7	7	65	16569	6	5	1	1\n17	5	15	8	11	12	13	14	15	16\n17	5	15	1	1	12	250	41	17851	24\n17	5	16	8	12	14	15	16	17\n17	5	16	4	8	55	116	6556	1\n17	5	17	8	14	15	16	17	21\n17	5	17	1	1	2	11	171	1\n17	5	18	13	15	16	18\n17	5	18	2	7	3	27\n17	5	19	8	13	15	18	19\n17	5	19	3	1	1	2	20\n17	5	20	8	13	16	17	18	20	37\n17	5	20	3	2	5	3	1	4608	3\n17	5	21	8	13	15	16	17	18	21\n17	5	21	1	1	3	1	2	1	502\n17	5	23	8	9	11	15	16	17	18	21	23\n17	5	23	1	1	1	1	1	2	8	2	17\n17	5	25	9	25\n17	5	25	1	6\n17	5	26	17	26\n17	5	26	1	1\n17	5	28	28\n17	5	28	1\n17	5	31	17\n17	5	31	1\n17	5	32	32	37\n17	5	32	2	1\n17	5	33	33\n17	5	33	1\n17	5	34	34\n17	5	34	1\n17	5	37	20	23	37\n17	5	37	1	1	124\n17	5	40	40\n17	5	40	2\n17	6	0	0\n17	6	0	7\n17	6	6	6	7	9\n17	6	6	966	2	1\n17	6	7	7\n17	6	7	1270\n17	6	8	7	8	9\n17	6	8	5	2053	2\n17	6	9	6	7	8	9	10	11\n17	6	9	3	13	7	3972	7	2\n17	6	10	7	8	9	10\n17	6	10	1	2	29	1824\n17	6	11	7	9	10	11	12	13\n17	6	11	9	16	40	32246	12	18\n17	6	12	7	9	10	11	12	13	14	15\n17	6	12	3	4	2	241	23299	6	6	1\n17	6	13	7	8	9	10	11	12	13	14	15	18\n17	6	13	41	1	7	1	20	134	24971	13	16	1\n17	6	14	7	11	12	13	14	15	16\n17	6	14	3	6	12	85	16583	4	1\n17	6	15	7	9	11	12	13	14	15	16\n17	6	15	21	1	4	10	203	42	17713	15\n17	6	16	7	9	12	13	14	15	16	20\n17	6	16	1	1	3	1	47	103	6450	1\n17	6	17	7	9	12	13	15	16	17\n17	6	17	1	4	1	1	1	4	169\n17	6	18	7	9	14	15	18	20\n17	6	18	4	1	1	3	29	1\n17	6	19	7	9	10	14	15	19\n17	6	19	8	5	2	2	1	2\n17	6	20	15	16	20	22\n17	6	20	1	3	4605	1\n17	6	21	15	16	18	21\n17	6	21	10	6	1	488\n17	6	22	22\n17	6	22	1\n17	6	23	9	23\n17	6	23	1	17\n17	6	25	9	10	22\n17	6	25	2	3	1\n17	6	26	21\n17	6	26	1\n17	6	28	28\n17	6	28	1\n17	6	32	32\n17	6	32	2\n17	6	33	38\n17	6	33	1\n17	6	34	34\n17	6	34	1\n17	6	37	20	37\n17	6	37	7	121\n17	6	40	40\n17	6	40	2\n17	7	0	0\n17	7	0	7\n17	7	6	6\n17	7	6	969\n17	7	7	6	7\n17	7	7	1	1381\n17	7	8	6	7	8\n17	7	8	3	5	2055\n17	7	9	6	7	8	9	10	11\n17	7	9	15	10	15	3990	14	2\n17	7	10	8	9	10\n17	7	10	3	23	1853\n17	7	11	6	8	9	10	11	12	13	14\n17	7	11	9	2	18	46	32420	3	17	4\n17	7	12	6	8	9	10	11	12	13	14	15\n17	7	12	2	4	6	8	179	23259	7	5	1\n17	7	13	6	8	9	10	11	12	13	14	15\n17	7	13	37	2	5	3	18	127	25070	9	14\n17	7	14	8	9	10	11	12	13	14	15	16	17	21\n17	7	14	1	1	4	4	27	72	16571	1	10	2	1\n17	7	15	6	9	10	11	12	13	14	15	16\n17	7	15	19	3	2	3	11	210	32	17556	17\n17	7	16	6	9	10	12	13	14	15	16	17\n17	7	16	1	2	1	68	2	45	91	6267	2\n17	7	17	6	8	9	12	15	16	17\n17	7	17	4	1	4	2	1	5	152\n17	7	18	6	13	14	18\n17	7	18	11	1	1	18\n17	7	19	19\n17	7	19	2\n17	7	20	15	16	17	20	22	37\n17	7	20	1	13	1	4597	1	1\n17	7	21	6	10	13	14	15	16	18	21\n17	7	21	3	1	28	2	146	66	7	236\n17	7	22	20	22\n17	7	22	1	2\n17	7	23	6	9	14	15	16	17	18	21\n17	7	23	1	2	1	1	6	1	3	2\n17	7	28	28\n17	7	28	1\n17	7	32	32\n17	7	32	2\n17	7	34	34\n17	7	34	1\n17	7	37	20	37\n17	7	37	11	110\n17	7	38	39\n17	7	38	1\n17	7	40	40\n17	7	40	2\n17	8	0	0\n17	8	0	7\n17	8	6	6	9\n17	8	6	1073	2\n17	8	7	6	7	9\n17	8	7	3	1384	9\n17	8	8	6	7	8\n17	8	8	8	1	2074\n17	8	9	6	7	8	9	10	11	14\n17	8	9	19	8	11	4004	8	3	1\n17	8	10	6	9	10	13	16\n17	8	10	5	30	1895	1	1\n17	8	11	6	8	9	10	11	12	13\n17	8	11	10	3	16	58	32505	19	15\n17	8	12	6	8	9	10	11	12	13	14	15\n17	8	12	3	6	3	10	125	23331	10	7	2\n17	8	13	6	8	9	10	11	12	13	14	15	17\n17	8	13	44	6	7	1	24	124	25159	20	21	1\n17	8	14	6	8	9	10	11	12	13	14	15	16	18\n17	8	14	3	4	1	6	11	32	96	16500	2	13	2\n17	8	15	6	9	10	11	12	13	14	15	16	17\n17	8	15	32	4	2	1	9	179	32	17531	20	2\n17	8	16	9	12	13	14	15	16	17	20\n17	8	16	7	4	3	37	88	6242	1	2\n17	8	17	16	17	30	33\n17	8	17	1	155	1	1\n17	8	18	8	11	13	16	18	23\n17	8	18	1	1	1	1	23	1\n17	8	19	14	16\n17	8	19	1	1\n17	8	20	14	15	16	20	27	37\n17	8	20	5	3	58	4538	1	4\n17	8	21	6	9	14	21\n17	8	21	2	1	1	235\n17	8	22	22	24\n17	8	22	2	1\n17	8	28	23\n17	8	28	1\n17	8	32	32\n17	8	32	2\n17	8	34	23\n17	8	34	1\n17	8	37	20	37	40\n17	8	37	4	106	1\n17	8	39	40\n17	8	39	1\n17	8	40	40\n17	8	40	2\n17	9	0	0\n17	9	0	7\n17	9	6	6	9\n17	9	6	1192	10\n17	9	7	6	7	9	13\n17	9	7	49	1335	8	1\n17	9	8	6	7	8	9	11	12	13	14	17	18\n17	9	8	80	4	1995	13	1	3	1	5	1	2\n17	9	9	6	7	8	9	10	11	14	18\n17	9	9	135	8	24	3904	8	2	1	2\n17	9	10	6	7	8	9	10	12	13\n17	9	10	37	1	4	38	1896	3	1\n17	9	11	6	8	9	10	11	12	13	14	18\n17	9	11	176	3	29	210	32154	90	4	3	1\n17	9	12	6	8	9	10	11	12	13	14	15\n17	9	12	41	17	8	122	127	23122	80	1	1\n17	9	13	6	8	9	10	11	12	13	14	15\n17	9	13	908	7	93	5	27	126	24252	24	22\n17	9	14	6	8	9	10	11	12	13	14	16	18\n17	9	14	31	49	7	28	24	14	80	16360	9	2\n17	9	15	6	8	9	10	11	12	13	14	15	16\n17	9	15	300	8	137	4	4	6	112	25	17026	25\n17	9	16	6	8	9	10	11	12	13	14	15	16	17	20\n17	9	16	14	10	95	22	12	5	8	33	49	6085	3	1\n17	9	17	13	16	17	18	22	25\n17	9	17	1	2	153	1	1	1\n17	9	18	6	8	9	10	11	12	18\n17	9	18	8	1	9	2	2	1	2\n17	9	20	14	15	16	20	37\n17	9	20	4	3	43	4491	3\n17	9	21	6	9	10	11	12	13	21	33\n17	9	21	7	48	1	2	1	1	174	1\n17	9	22	18	22\n17	9	22	1	1\n17	9	23	23\n17	9	23	3\n17	9	24	24\n17	9	24	1\n17	9	27	30\n17	9	27	1\n17	9	30	30\n17	9	30	1\n17	9	32	32\n17	9	32	2\n17	9	33	32\n17	9	33	1\n17	9	37	20	37\n17	9	37	7	103\n17	9	40	40\n17	9	40	4\n17	10	0	0\n17	10	0	7\n17	10	6	6	9\n17	10	6	2962	16\n17	10	7	6	7	9\n17	10	7	55	1292	1\n17	10	8	6	7	8	11	13\n17	10	8	53	4	2059	1	1\n17	10	9	6	7	8	9	10	11\n17	10	9	94	14	28	4260	2	1\n17	10	10	6	8	9	10	11	12\n17	10	10	21	3	25	2245	3	1\n17	10	11	6	7	8	9	10	11	12	13\n17	10	11	152	1	14	26	337	31626	188	11\n17	10	12	6	7	8	9	10	11	12	13	14	15	17	18\n17	10	12	78	1	37	9	176	89	22917	59	1	2	1	1\n17	10	13	6	8	9	10	11	12	13	14	15\n17	10	13	743	14	61	26	25	157	23462	14	39\n17	10	14	6	8	9	10	11	12	13	14	16	18\n17	10	14	36	98	16	54	29	30	74	16103	15	1\n17	10	15	6	8	9	10	11	12	13	14	15	16	20\n17	10	15	263	8	202	28	3	3	41	34	16496	22	1\n17	10	16	8	9	10	11	12	13	14	15	16	17	20\n17	10	16	44	17	28	29	9	2	14	57	5961	1	2\n17	10	17	14	15	16	17\n17	10	17	1	1	2	153\n17	10	18	12	14	18\n17	10	18	1	1	9\n17	10	20	11	14	16	17	20\n17	10	20	3	1	10	1	4484\n17	10	21	12	21\n17	10	21	1	173\n17	10	22	19	22\n17	10	22	1	1\n17	10	23	13	23\n17	10	23	1	2\n17	10	24	24\n17	10	24	1\n17	10	25	22\n17	10	25	1\n17	10	30	30\n17	10	30	2\n17	10	32	32\n17	10	32	3\n17	10	33	33\n17	10	33	1\n17	10	37	20	37\n17	10	37	4	102\n17	10	40	39	40\n17	10	40	1	3\n17	11	0	0\n17	11	0	7\n17	11	6	6	9\n17	11	6	4231	226\n17	11	7	6	7	8	9	11\n17	11	7	13	1265	21	8	5\n17	11	8	6	7	8	9\n17	11	8	16	8	2268	13\n17	11	9	6	7	8	9	10	11	13	30\n17	11	9	21	7	14	4585	2	2	1	1\n17	11	10	6	8	9	10	11	12	13	17\n17	11	10	6	4	29	2847	1	7	1	1\n17	11	11	6	7	8	9	10	11	12	13\n17	11	11	57	7	10	12	139	31490	92	2\n17	11	12	6	8	9	10	11	12	13	14	15	18\n17	11	12	34	18	4	74	83	23058	24	5	4	3\n17	11	13	6	7	8	9	10	11	12	13	14	15	16\n17	11	13	353	1	8	19	20	13	134	23061	9	32	1\n17	11	14	6	8	9	10	11	12	13	14	16	18\n17	11	14	18	67	1	31	24	28	91	15896	11	2\n17	11	15	6	8	9	10	12	13	14	15	16\n17	11	15	112	6	66	19	3	43	45	16274	27\n17	11	16	8	9	10	11	12	13	14	15	16	17	20\n17	11	16	30	7	23	6	2	5	11	74	5850	1	1\n17	11	17	12	16	17\n17	11	17	1	7	148\n17	11	18	14	15	18\n17	11	18	3	2	6\n17	11	19	18\n17	11	19	1\n17	11	20	16	20	37\n17	11	20	7	4483	1\n17	11	21	21\n17	11	21	173\n17	11	22	20	22\n17	11	22	1	1\n17	11	23	23\n17	11	23	2\n17	11	24	21\n17	11	24	1\n17	11	30	30\n17	11	30	2\n17	11	32	30	32\n17	11	32	1	2\n17	11	33	33\n17	11	33	1\n17	11	37	20	37\n17	11	37	4	98\n17	11	39	39\n17	11	39	1\n17	11	40	37	40\n17	11	40	1	2\n17	12	0	0\n17	12	0	7\n17	12	6	6	7	8	9	10	11	13\n17	12	6	4580	5	50	207	1	14	4\n17	12	7	6	7	9	10\n17	12	7	3	1276	8	1\n17	12	8	6	7	8	9	10	11\n17	12	8	4	3	2411	23	3	2\n17	12	9	6	7	8	9	10	11	13	14	17	32\n17	12	9	7	20	16	4914	1	7	1	2	1	1\n17	12	10	6	8	9	10	11	12	13	14	15	16\n17	12	10	1	1	42	3070	9	18	1	10	1	2\n17	12	11	6	7	8	9	10	11	12	13	14	15\n17	12	11	23	1	4	10	46	31403	123	6	7	1\n17	12	12	6	8	9	10	11	12	13	14	15\n17	12	12	9	3	6	11	71	23188	27	5	5\n17	12	13	6	9	10	11	12	13	14	15\n17	12	13	109	7	10	9	133	22851	7	102\n17	12	14	6	8	9	10	11	12	13	14	16\n17	12	14	4	22	2	5	12	27	65	15811	21\n17	12	15	6	9	10	12	13	14	15	16	20\n17	12	15	35	24	2	1	20	45	16198	60	1\n17	12	16	8	9	10	11	12	14	15	16	17	20\n17	12	16	8	4	5	3	2	7	61	5806	6	1\n17	12	17	13	15	17	23\n17	12	17	1	1	147	1\n17	12	18	13	18	20\n17	12	18	1	10	1\n17	12	20	16	20	38\n17	12	20	1	4487	1\n17	12	21	21\n17	12	21	174\n17	12	22	22\n17	12	22	1\n17	12	23	23\n17	12	23	2\n17	12	30	30\n17	12	30	4\n17	12	32	32\n17	12	32	2\n17	12	33	33\n17	12	33	1\n17	12	37	20	37\n17	12	37	5	95\n17	12	39	39\n17	12	39	1\n17	12	40	40\n17	12	40	2\n17	13	0	0\n17	13	0	7\n17	13	6	6	7	8	9	12\n17	13	6	4688	14	2	70	1\n17	13	7	6	7	9	10\n17	13	7	3	1299	2	1\n17	13	8	6	7	8	9	10	13\n17	13	8	1	3	2497	10	2	2\n17	13	9	6	7	8	9	10	11	14\n17	13	9	3	4	6	5224	1	7	2\n17	13	10	6	7	8	9	10	11	12	14	16	17\n17	13	10	1	1	2	39	3091	8	7	3	2	1\n17	13	11	6	8	9	10	11	12	13	14	16	18	21\n17	13	11	10	1	10	38	31345	117	3	3	1	1	1\n17	13	12	6	9	10	11	12	13	14	15	16	18\n17	13	12	3	2	1	86	23353	14	1	7	1	24\n17	13	13	6	8	9	10	11	12	13	14	15	18	20\n17	13	13	25	1	2	7	18	140	22696	5	78	3	2\n17	13	14	6	8	9	10	11	12	13	14	16\n17	13	14	1	5	7	1	6	15	81	15748	30\n17	13	15	6	8	9	12	13	14	15	16	19\n17	13	15	14	1	7	1	30	66	16170	77	3\n17	13	16	8	10	12	14	15	16	17	20	37\n17	13	16	3	1	1	5	71	5796	9	3	1\n17	13	17	16	17	35\n17	13	17	6	147	1\n17	13	18	14	18	19\n17	13	18	1	8	1\n17	13	20	15	16	20\n17	13	20	1	1	4493\n17	13	21	12	14	21\n17	13	21	1	1	172\n17	13	22	25\n17	13	22	1\n17	13	23	23	28\n17	13	23	2	1\n17	13	30	28	30\n17	13	30	1	3\n17	13	32	30	32\n17	13	32	2	1\n17	13	33	35\n17	13	33	1\n17	13	37	20	37\n17	13	37	5	90\n17	13	38	25\n17	13	38	1\n17	13	39	37\n17	13	39	1\n17	13	40	40\n17	13	40	2\n17	14	0	0\n17	14	0	7\n17	14	6	6	7	9\n17	14	6	4721	1	27\n17	14	7	7	9\n17	14	7	1309	12\n17	14	8	7	8	9	12\n17	14	8	4	2508	4	2\n17	14	9	6	7	8	9	10	11\n17	14	9	1	4	18	5343	1	6\n17	14	10	7	8	9	10	11	12	13	14\n17	14	10	1	3	24	3111	1	1	1	1\n17	14	11	6	8	9	10	11	12	13	14	15\n17	14	11	1	2	16	29	31239	173	8	1	1\n17	14	12	6	9	10	11	12	13	14	15	19\n17	14	12	2	2	12	90	23506	15	1	7	1\n17	14	13	6	8	9	10	11	12	13	14	15	16	21\n17	14	13	3	1	1	1	22	138	22554	8	96	1	1\n17	14	14	6	11	12	13	14	15	16	17	18	20\n17	14	14	1	7	25	80	15682	1	25	1	12	1\n17	14	15	6	11	12	13	14	15	16	18	19\n17	14	15	1	1	1	31	55	16155	80	2	1\n17	14	16	12	14	15	16	17	20\n17	14	16	1	4	61	5835	9	4\n17	14	17	13	15	16	17\n17	14	17	1	1	3	152\n17	14	18	13	18	19\n17	14	18	1	34	1\n17	14	19	18	19\n17	14	19	1	3\n17	14	20	20	21\n17	14	20	4502	1\n17	14	21	13	16	21\n17	14	21	1	1	171\n17	14	23	23\n17	14	23	2\n17	14	25	22	25\n17	14	25	1	1\n17	14	28	28	30\n17	14	28	1	1\n17	14	30	28	30\n17	14	30	1	4\n17	14	32	32\n17	14	32	1\n17	14	35	35\n17	14	35	2\n17	14	37	20	37\n17	14	37	8	84\n17	14	40	40\n17	14	40	2\n17	15	0	0\n17	15	0	7\n17	15	6	6	9\n17	15	6	4728	2\n17	15	7	7	9\n17	15	7	1318	1\n17	15	8	6	7	8\n17	15	8	1	103	2428\n17	15	9	6	7	8	9	10\n17	15	9	643	102	108	4572	4\n17	15	10	7	8	9	10	11	14\n17	15	10	12	36	101	3003	1	1\n17	15	11	6	8	9	10	11	12	13	15\n17	15	11	3	166	142	55	30784	208	6	2\n17	15	12	6	7	8	9	10	11	12	13	15\n17	15	12	1	62	106	163	235	1936	21321	16	7\n17	15	13	8	9	10	11	12	13	14	15\n17	15	13	42	121	72	344	413	21564	8	128\n17	15	14	9	10	11	12	13	14	15	16	17	18	20\n17	15	14	85	148	365	302	679	14097	2	71	1	1	1\n17	15	15	9	10	11	12	13	14	15	16\n17	15	15	82	72	152	334	2676	489	12439	78\n17	15	16	9	11	12	13	14	15	16	17	20\n17	15	16	4	38	53	44	574	304	4916	5	7\n17	15	17	11	13	14	16	17	18\n17	15	17	1	1	1	3	155	1\n17	15	18	10	12	13	14	17	18\n17	15	18	7	17	2	11	1	11\n17	15	19	16	18	19\n17	15	19	1	1	4\n17	15	20	11	12	13	14	15	16	17	20\n17	15	20	5	7	20	60	49	3761	70	543\n17	15	21	12	13	21\n17	15	21	83	55	35\n17	15	22	22\n17	15	22	1\n17	15	23	13	23\n17	15	23	1	1\n17	15	25	25\n17	15	25	1\n17	15	28	28\n17	15	28	2\n17	15	30	30\n17	15	30	5\n17	15	32	32\n17	15	32	1\n17	15	35	35	38\n17	15	35	1	1\n17	15	37	16	17	20	37\n17	15	37	48	13	8	15\n17	15	40	37	40\n17	15	40	1	1\n17	16	0	0\n17	16	0	7\n17	16	6	6\n17	16	6	5376\n17	16	7	7	10\n17	16	7	1596	1\n17	16	8	7	8\n17	16	8	64	2822\n17	16	9	6	7	8	9	10\n17	16	9	403	35	86	4744	5\n17	16	10	7	8	9	10	11	12	13\n17	16	10	10	26	103	3451	4	1	1\n17	16	11	6	8	9	10	11	12	13	15\n17	16	11	1	72	95	56	33073	309	17	3\n17	16	12	7	8	9	10	11	12	13	15	16\n17	16	12	4	35	70	186	1066	21347	21	8	1\n17	16	13	8	9	10	11	12	13	14	15	16	17	18\n17	16	13	15	68	59	247	354	24168	10	139	2	1	1\n17	16	14	9	10	11	12	13	14	15	16	17	20\n17	16	14	16	39	48	126	402	14500	3	100	5	2\n17	16	15	6	9	10	11	12	13	14	15	16	17\n17	16	15	1	16	18	68	88	1121	241	11310	66	2\n17	16	16	11	12	13	14	15	16	17	20\n17	16	16	17	16	40	206	188	8405	4	2\n17	16	17	15	16	17\n17	16	17	1	3	241\n17	16	18	11	12	14	15	16	17\n17	16	18	1	7	3	1	1	1\n17	16	19	16	17	19\n17	16	19	2	1	1\n17	16	20	14	15	16	17	20\n17	16	20	4	7	216	3	329\n17	16	21	12	13	19	20	21\n17	16	21	11	9	1	1	13\n17	16	22	13\n17	16	22	1\n17	16	23	17\n17	16	23	1\n17	16	25	25\n17	16	25	1\n17	16	28	25	28\n17	16	28	1	1\n17	16	30	30\n17	16	30	5\n17	16	32	28\n17	16	32	1\n17	16	35	17\n17	16	35	1\n17	16	37	16	20	37\n17	16	37	4	2	10\n17	16	38	37\n17	16	38	1\n17	16	40	40\n17	16	40	1\n18	1	0	0\n18	1	0	8\n18	1	6	6	9	11\n18	1	6	763	57	1\n18	1	7	7	8	9	10	12\n18	1	7	1018	22	37	4	1\n18	1	8	7	8	9	10	11	12	13\n18	1	8	3	1546	19	2	22	24	5\n18	1	9	7	8	9	10	11	12	13	14	15\n18	1	9	5	9	2944	24	46	16	21	4	3\n18	1	10	9	10	11	12	13	14	15\n18	1	10	26	1249	22	30	8	25	1\n18	1	11	8	9	10	11	12	13	14	15	16\n18	1	11	1	9	35	21333	166	60	16	7	4\n18	1	12	9	10	11	12	13	14	15	16	21\n18	1	12	4	3	529	16941	50	46	26	16	9\n18	1	13	8	9	10	11	12	13	14	15	16	21\n18	1	13	1	3	1	35	110	17044	97	205	8	9\n18	1	14	11	12	13	14	15	16	17\n18	1	14	6	11	80	10316	38	42	1\n18	1	15	11	12	13	14	15	16	17	18	21	23\n18	1	15	9	32	415	28	13575	61	1	2	3	1\n18	1	16	12	13	14	15	16	17	20	21	23	37\n18	1	16	3	4	169	113	6347	1	636	16	2	10\n18	1	17	14	15	16	17	18	20	37\n18	1	17	4	3	2	153	1	9	2\n18	1	18	13	17	18	21	23\n18	1	18	1	1	19	3	1\n18	1	19	15	16	18	19	21	23\n18	1	19	1	1	1	16	1	2\n18	1	20	15	20	22	25	28	37\n18	1	20	1	579	1	1	1	1\n18	1	21	21	22	23	24	25\n18	1	21	54	1	1	1	1\n18	1	22	22	25\n18	1	22	3	1\n18	1	23	23\n18	1	23	11\n18	1	24	24\n18	1	24	1\n18	1	25	25	28\n18	1	25	2	1\n18	1	26	26\n18	1	26	1\n18	1	28	28\n18	1	28	1\n18	1	31	31\n18	1	31	1\n18	1	37	37\n18	1	37	23\n18	1	40	40\n18	1	40	1\n18	2	0	0\n18	2	0	8\n18	2	6	6	9\n18	2	6	721	42\n18	2	7	7	8	9	10	12\n18	2	7	970	21	27	4	4\n18	2	8	7	8	9	10	11	12	13\n18	2	8	3	1450	17	2	37	62	8\n18	2	9	7	8	9	10	11	12	13	14	15\n18	2	9	2	9	2970	17	26	32	19	18	6\n18	2	10	9	10	11	12	13	14	15	18\n18	2	10	14	1232	10	33	8	15	5	1\n18	2	11	9	10	11	12	13	14	15	16\n18	2	11	6	16	21598	269	53	40	17	4\n18	2	12	9	10	11	12	13	14	15	16	20	21\n18	2	12	5	2	484	16652	60	48	30	20	2	31\n18	2	13	8	9	10	11	12	13	14	15	16	17	20	21\n18	2	13	1	2	1	21	82	17169	127	256	13	1	1	14\n18	2	14	11	12	13	14	15	16	20	21\n18	2	14	4	10	40	10530	57	59	4	1\n18	2	15	11	12	13	14	15	16	18	19	20	21\n18	2	15	3	14	382	22	13486	38	3	3	4	18\n18	2	16	12	13	14	15	16	17	20	21	23	37\n18	2	16	1	3	128	88	4668	1	1570	10	1	11\n18	2	17	13	14	15	16	17	20	23	37\n18	2	17	1	3	1	6	114	27	4	1\n18	2	18	16	18	21\n18	2	18	2	16	5\n18	2	19	19	21\n18	2	19	14	2\n18	2	20	14	16	20	37\n18	2	20	1	2	1220	1\n18	2	21	21	23	25\n18	2	21	91	3	1\n18	2	22	22	25\n18	2	22	4	1\n18	2	23	17	23\n18	2	23	1	17\n18	2	24	22\n18	2	24	2\n18	2	25	25\n18	2	25	5\n18	2	26	25\n18	2	26	1\n18	2	28	23	28\n18	2	28	2	1\n18	2	31	28\n18	2	31	1\n18	2	37	37\n18	2	37	36\n18	2	40	40\n18	2	40	1\n18	3	0	0\n18	3	0	8\n18	3	6	6\n18	3	6	721\n18	3	7	7\n18	3	7	975\n18	3	8	7	8\n18	3	8	1	1480\n18	3	9	7	8	9	10	11	13\n18	3	9	1	10	3063	7	1	1\n18	3	10	8	9	10	11\n18	3	10	1	29	1243	1\n18	3	11	8	9	10	11	12	13\n18	3	11	1	5	23	22138	7	9\n18	3	12	9	10	11	12	13	14	15\n18	3	12	1	2	393	16755	5	2	1\n18	3	13	9	10	11	12	13	14	15	16\n18	3	13	1	1	16	124	17568	19	13	1\n18	3	14	11	12	13	14	15	16	26\n18	3	14	3	8	61	10847	4	8	1\n18	3	15	11	12	13	14	15	16	23\n18	3	15	1	12	286	20	13613	13	1\n18	3	16	13	14	15	16	17\n18	3	16	2	74	109	4626	1\n18	3	17	13	14	15	16	17\n18	3	17	1	1	2	6	107\n18	3	18	15	18\n18	3	18	1	19\n18	3	19	18	19\n18	3	19	2	15\n18	3	20	19	20	37\n18	3	20	1	2826	1\n18	3	21	19	21\n18	3	21	1	171\n18	3	22	22\n18	3	22	6\n18	3	23	19	23\n18	3	23	2	25\n18	3	25	14	23	25\n18	3	25	1	1	6\n18	3	28	25	28\n18	3	28	1	1\n18	3	37	20	37\n18	3	37	2	47\n18	3	40	40\n18	3	40	1\n18	4	0	0\n18	4	0	8\n18	4	6	6\n18	4	6	721\n18	4	7	7\n18	4	7	977\n18	4	8	7	8\n18	4	8	3	1489\n18	4	9	6	7	8	9	10\n18	4	9	1	4	7	3082	5\n18	4	10	9	10	11\n18	4	10	21	1254	1\n18	4	11	9	10	11	12	13\n18	4	11	12	26	22498	5	12\n18	4	12	9	10	11	12	13	14\n18	4	12	2	4	324	16568	6	2\n18	4	13	9	11	12	13	14	15\n18	4	13	1	10	80	17806	21	15\n18	4	14	11	12	13	14	15	16\n18	4	14	5	8	50	10898	1	2\n18	4	15	11	12	13	14	15	16	17\n18	4	15	1	12	233	22	13460	14	1\n18	4	16	12	13	14	15	16\n18	4	16	1	2	50	106	4495\n18	4	17	9	15	16	17\n18	4	17	1	2	4	101\n18	4	18	12	13	15	18\n18	4	18	1	1	3	16\n18	4	19	13	15	19\n18	4	19	1	1	17\n18	4	20	12	16	20\n18	4	20	1	1	2826\n18	4	21	13	15	17	18	19	21\n18	4	21	1	2	1	1	2	164\n18	4	22	17	20	21	22\n18	4	22	1	1	1	3\n18	4	23	15	17	21	23	28\n18	4	23	1	1	1	23	1\n18	4	25	20	21	25\n18	4	25	1	2	4\n18	4	26	26\n18	4	26	1\n18	4	28	28\n18	4	28	1\n18	4	37	37\n18	4	37	48\n18	4	40	40\n18	4	40	1\n18	5	0	0\n18	5	0	8\n18	5	6	6\n18	5	6	722\n18	5	7	7\n18	5	7	984\n18	5	8	7	8\n18	5	8	1	1495\n18	5	9	7	8	9	10\n18	5	9	2	8	3099	10\n18	5	10	8	9	10	11\n18	5	10	2	17	1269	1\n18	5	11	8	9	10	11	12	13	15	16\n18	5	11	2	15	31	22765	9	15	1	1\n18	5	12	9	10	11	12	13	14	15\n18	5	12	2	7	238	16412	11	4	2\n18	5	13	8	10	11	12	13	14	15\n18	5	13	4	1	11	103	17961	20	12\n18	5	14	11	12	13	14	16\n18	5	14	5	8	49	10925	6\n18	5	15	8	12	13	14	15	16\n18	5	15	1	12	191	23	13349	15\n18	5	16	8	11	12	14	15	16\n18	5	16	2	1	3	41	92	4377\n18	5	17	13	14	15	16	17\n18	5	17	1	1	3	4	96\n18	5	18	11	13	15	17	18\n18	5	18	1	4	3	1	8\n18	5	19	8	11	15	18	19\n18	5	19	3	1	1	1	13\n18	5	20	12	16	20	37\n18	5	20	1	4	2822	1\n18	5	21	15	16	21\n18	5	21	8	2	158\n18	5	22	22	24\n18	5	22	2	1\n18	5	23	8	9	13	15	17	18	21	23\n18	5	23	1	1	1	1	1	4	3	11\n18	5	25	8	23	25\n18	5	25	1	1	2\n18	5	26	27\n18	5	26	1\n18	5	28	13	28\n18	5	28	1	1\n18	5	37	37\n18	5	37	48\n18	5	40	40\n18	5	40	1\n18	6	0	0\n18	6	0	8\n18	6	6	6\n18	6	6	722\n18	6	7	7\n18	6	7	987\n18	6	8	7	8	9\n18	6	8	6	1512	1\n18	6	9	6	7	8	9	10	11	13\n18	6	9	1	14	5	3100	12	1	1\n18	6	10	7	9	10	13\n18	6	10	1	22	1294	1\n18	6	11	7	8	9	10	11	12	13	15\n18	6	11	11	1	7	29	22960	6	8	1\n18	6	12	7	9	10	11	12	13	14	15\n18	6	12	2	4	2	168	16348	18	1	5\n18	6	13	7	9	10	11	12	13	14	15\n18	6	13	34	3	1	10	97	18059	17	13\n18	6	14	9	10	11	12	13	14	15	16\n18	6	14	2	1	7	6	40	10950	3	5\n18	6	15	7	9	11	12	13	14	15	16\n18	6	15	10	1	1	4	140	27	13280	9\n18	6	16	12	13	14	15	16\n18	6	16	2	1	33	59	4314\n18	6	17	9	13	15	16	17\n18	6	17	1	1	2	3	91\n18	6	18	9	11	18\n18	6	18	2	1	10\n18	6	19	7	9	10	14	15	19\n18	6	19	4	1	2	2	1	3\n18	6	20	7	9	10	16	20	37\n18	6	20	2	1	1	2	2815	1\n18	6	21	9	16	21	22\n18	6	21	2	1	157	1\n18	6	22	10	17\n18	6	22	1	1\n18	6	23	9	23\n18	6	23	1	11\n18	6	24	24\n18	6	24	1\n18	6	25	9\n18	6	25	2\n18	6	27	21\n18	6	27	1\n18	6	28	28\n18	6	28	1\n18	6	37	20	37\n18	6	37	2	47\n18	6	40	40\n18	6	40	1\n18	7	0	0\n18	7	0	8\n18	7	6	6\n18	7	6	723\n18	7	7	6	7\n18	7	7	1	1070\n18	7	8	6	7	8\n18	7	8	2	2	1514\n18	7	9	6	7	8	9	10	11\n18	7	9	8	3	8	3117	10	4\n18	7	10	7	8	9	10	12\n18	7	10	1	1	21	1319	1\n18	7	11	6	9	10	11	12	13	14	15\n18	7	11	7	10	28	23079	6	15	2	1\n18	7	12	6	9	10	11	12	13	14	15\n18	7	12	11	3	4	137	16300	4	3	1\n18	7	13	6	9	10	11	12	13	14	15\n18	7	13	44	7	1	12	76	18108	13	8\n18	7	14	6	10	11	12	13	14	16\n18	7	14	2	1	9	11	60	10942	5\n18	7	15	6	9	10	11	12	13	14	15	16	18\n18	7	15	29	2	2	1	11	123	28	13164	3	1\n18	7	16	9	12	13	14	15	16	21\n18	7	16	1	15	5	29	64	4219	1\n18	7	17	6	9	15	16	17\n18	7	17	1	12	1	3	75\n18	7	18	6	9	16	18\n18	7	18	3	2	1	4\n18	7	19	12	19\n18	7	19	1	2\n18	7	20	20	37\n18	7	20	2816	1\n18	7	21	9	13	15	16	18	20	21\n18	7	21	3	7	40	12	3	1	92\n18	7	22	22\n18	7	22	1\n18	7	23	9	15	16	23\n18	7	23	7	2	1	1\n18	7	24	24\n18	7	24	1\n18	7	28	28\n18	7	28	1\n18	7	37	20	37\n18	7	37	1	47\n18	7	40	40\n18	7	40	1\n18	8	0	0\n18	8	0	8\n18	8	6	6	27\n18	8	6	830	1\n18	8	7	7	9\n18	8	7	1067	9\n18	8	8	6	7	8\n18	8	8	1	5	1517\n18	8	9	6	7	8	9	10	11\n18	8	9	5	7	9	3158	5	1\n18	8	10	6	9	10	13\n18	8	10	2	23	1339	1\n18	8	11	6	9	10	11	12	13	14	15\n18	8	11	4	14	34	23165	9	10	5	1\n18	8	12	6	8	9	10	11	12	13	14	15	18\n18	8	12	1	6	5	7	89	16304	4	2	2	1\n18	8	13	6	8	9	10	11	12	13	14	15\n18	8	13	13	1	1	1	13	110	18162	12	9\n18	8	14	8	10	11	12	13	14	15	16	18\n18	8	14	1	6	9	20	63	10913	1	3	1\n18	8	15	6	9	12	13	14	15	16	18\n18	8	15	5	2	6	161	26	13071	7	3\n18	8	16	9	12	14	15	16\n18	8	16	1	2	26	36	4179\n18	8	17	17\n18	8	17	75\n18	8	18	13	18\n18	8	18	1	7\n18	8	19	15	18\n18	8	19	1	1\n18	8	20	14	15	16	17	19	20\n18	8	20	1	6	25	2	1	2783\n18	8	21	21\n18	8	21	93\n18	8	22	17\n18	8	22	1\n18	8	23	23\n18	8	23	1\n18	8	24	24\n18	8	24	1\n18	8	28	28\n18	8	28	1\n18	8	37	37\n18	8	37	48\n18	8	40	40\n18	8	40	1\n18	9	0	0\n18	9	0	8\n18	9	6	6	9\n18	9	6	849	12\n18	9	7	6	7	9\n18	9	7	20	1056	3\n18	9	8	6	7	8	9\n18	9	8	17	5	1509	3\n18	9	9	6	7	8	9	11	13\n18	9	9	62	8	15	3126	1	1\n18	9	10	6	7	8	9	10	12\n18	9	10	7	1	1	20	1362	1\n18	9	11	6	8	9	10	11	12	13	14\n18	9	11	48	2	19	72	23104	24	7	1\n18	9	12	6	8	9	10	11	12	13	15\n18	9	12	13	7	4	40	86	16288	10	3\n18	9	13	6	8	9	10	11	12	13	14	15\n18	9	13	281	5	39	2	15	88	17943	14	15\n18	9	14	6	8	9	10	11	12	13	14	16	18\n18	9	14	18	19	4	7	10	19	41	10859	7	1\n18	9	15	6	8	9	10	12	13	14	15	16	17	18\n18	9	15	81	3	32	4	5	97	26	12862	15	1	1\n18	9	16	6	8	9	10	11	12	13	14	15	16	17\n18	9	16	3	4	32	4	3	4	3	24	39	4094	4\n18	9	17	16	17\n18	9	17	1	77\n18	9	18	9	10	18\n18	9	18	5	1	7\n18	9	19	27\n18	9	19	1\n18	9	20	15	16	20	37\n18	9	20	4	38	2740	1\n18	9	21	6	9	21	35\n18	9	21	2	16	74	1\n18	9	23	11\n18	9	23	1\n18	9	24	24\n18	9	24	1\n18	9	27	27\n18	9	27	1\n18	9	28	28\n18	9	28	1\n18	9	37	37\n18	9	37	48\n18	9	40	40\n18	9	40	1\n18	10	0	0\n18	10	0	8\n18	10	6	6	9\n18	10	6	1393	8\n18	10	7	6	7	9	12	17\n18	10	7	57	1006	5	1	1\n18	10	8	6	7	8	9	10	11\n18	10	8	63	1	1491	6	1	3\n18	10	9	6	7	8	9	10	11\n18	10	9	114	20	23	3152	4	2\n18	10	10	6	8	9	10	12\n18	10	10	17	5	25	1442	3\n18	10	11	6	7	8	9	10	11	12	13	14	16\n18	10	11	143	2	8	18	236	22701	105	5	1	1\n18	10	12	6	8	9	10	11	12	13	14	15\n18	10	12	70	19	10	135	53	16072	67	1	2\n18	10	13	6	8	9	10	11	12	13	14	15\n18	10	13	871	3	68	6	16	76	17031	9	22\n18	10	14	6	8	9	10	11	12	13	14	16	18\n18	10	14	32	83	24	32	13	20	44	10667	6	3\n18	10	15	6	8	9	10	11	12	13	14	15	16\n18	10	15	308	11	207	18	2	4	64	31	12267	11\n18	10	16	8	9	10	11	12	14	15	16	17	20\n18	10	16	32	16	14	15	1	10	36	4028	2	1\n18	10	17	16	17	21\n18	10	17	4	77	1\n18	10	18	12	14	15	18\n18	10	18	2	1	2	4\n18	10	20	10	15	16	17	20	37\n18	10	20	1	2	17	1	2718	1\n18	10	21	21\n18	10	21	74\n18	10	24	15\n18	10	24	1\n18	10	27	27\n18	10	27	2\n18	10	28	28\n18	10	28	1\n18	10	35	35\n18	10	35	1\n18	10	37	20	37\n18	10	37	3	46\n18	10	40	40\n18	10	40	1\n18	11	0	0\n18	11	0	8\n18	11	6	6	7	9\n18	11	6	3000	1	67\n18	11	7	6	7	8	9	11	13\n18	11	7	27	993	4	3	1	1\n18	11	8	6	7	8	9	10\n18	11	8	26	1	1641	6	1\n18	11	9	6	7	8	9	10\n18	11	9	60	2	25	3450	2\n18	11	10	6	8	9	10	12\n18	11	10	11	6	28	1839	5\n18	11	11	6	7	8	9	10	11	12	13\n18	11	11	109	4	15	16	222	22334	88	17\n18	11	12	6	8	9	10	11	12	13	15	16\n18	11	12	49	28	5	105	46	16022	27	1	1\n18	11	13	6	8	9	10	11	12	13	14	15	19\n18	11	13	494	7	31	20	17	100	16519	6	16	1\n18	11	14	6	8	9	10	11	12	13	14	16\n18	11	14	18	110	14	46	24	20	54	10421	13\n18	11	15	6	8	9	10	11	12	13	14	15	16\n18	11	15	171	19	127	21	2	4	39	29	11910	10\n18	11	16	8	9	10	11	12	13	14	15	16\n18	11	16	30	15	29	13	9	1	7	44	3919\n18	11	17	16	17\n18	11	17	1	80\n18	11	18	13	14	15	18\n18	11	18	1	3	2	1\n18	11	20	9	16	20\n18	11	20	1	5	2716\n18	11	21	19	21\n18	11	21	1	74\n18	11	27	23	27\n18	11	27	1	1\n18	11	28	28\n18	11	28	1\n18	11	35	35\n18	11	35	1\n18	11	37	20	37\n18	11	37	2	45\n18	11	40	40\n18	11	40	1\n18	12	0	0\n18	12	0	8\n18	12	6	6	7	8	9	11	28\n18	12	6	3693	5	17	246	3	1\n18	12	7	6	7	9	10\n18	12	7	3	991	6	1\n18	12	8	6	7	8	9	10\n18	12	8	8	2	1857	17	1\n18	12	9	6	7	8	9	11\n18	12	9	23	12	14	3712	2\n18	12	10	6	8	9	10	11	12\n18	12	10	4	3	22	2245	2	9\n18	12	11	6	7	8	9	10	11	12	13\n18	12	11	45	4	12	11	84	22198	80	3\n18	12	12	6	7	8	9	10	11	12	13	14	15	16	18	24\n18	12	12	25	1	7	3	27	52	16104	22	1	1	2	2	1\n18	12	13	6	8	9	10	11	12	13	14	15\n18	12	13	252	6	11	9	13	86	16253	4	25\n18	12	14	6	8	9	10	11	12	13	14	16\n18	12	14	11	46	6	14	23	16	48	10292	10\n18	12	15	6	8	9	10	12	13	14	15	16\n18	12	15	77	5	46	8	2	19	26	11768	22\n18	12	16	8	9	10	11	12	14	15	16	17	20\n18	12	16	11	3	8	10	4	6	40	3859	5	3\n18	12	17	16	17	18\n18	12	17	2	77	1\n18	12	18	18\n18	12	18	1\n18	12	19	17\n18	12	19	2\n18	12	20	10	16	20\n18	12	20	1	1	2716\n18	12	21	21\n18	12	21	74\n18	12	23	27\n18	12	23	1\n18	12	27	27\n18	12	27	1\n18	12	28	28\n18	12	28	1\n18	12	35	35\n18	12	35	1\n18	12	37	20	37\n18	12	37	3	42\n18	12	40	39\n18	12	40	1\n18	13	0	0\n18	13	0	8\n18	13	6	6	7	8	9	10	11\n18	13	6	3935	70	8	126	1	1\n18	13	7	6	7	10\n18	13	7	7	1007	1\n18	13	8	6	7	8	9	10	12\n18	13	8	3	3	1951	19	1	1\n18	13	9	6	7	8	9	10	11\n18	13	9	7	16	18	4034	6	2\n18	13	10	6	8	9	10	11	12	13	14	15\n18	13	10	2	2	20	2343	8	10	3	7	3\n18	13	11	6	8	9	10	11	12	13	14\n18	13	11	13	4	9	41	22155	73	1	7\n18	13	12	6	8	9	10	11	12	13	14	15\n18	13	12	11	5	2	4	65	16200	7	5	2\n18	13	13	6	8	9	10	11	12	13	14	15\n18	13	13	68	3	5	2	12	103	16082	6	64\n18	13	14	6	8	10	11	12	13	14	16\n18	13	14	5	9	3	11	14	62	10207	18\n18	13	15	6	8	9	10	11	12	13	14	15	16	18	22\n18	13	15	27	1	15	1	1	2	23	33	11684	45	1	1\n18	13	16	8	10	14	15	16	17	20\n18	13	16	4	4	5	37	3844	1	1\n18	13	17	13	15	17	18\n18	13	17	1	1	81	1\n18	13	18	18	22\n18	13	18	3	1\n18	13	20	20\n18	13	20	2722\n18	13	21	21\n18	13	21	74\n18	13	24	18\n18	13	24	1\n18	13	27	27	29\n18	13	27	1	1\n18	13	28	25	28\n18	13	28	1	1\n18	13	35	38\n18	13	35	1\n18	13	37	20	37\n18	13	37	3	39\n18	13	39	39\n18	13	39	1\n18	14	0	0\n18	14	0	8\n18	14	6	6	7	9	18\n18	14	6	4032	3	42	1\n18	14	7	6	7	9\n18	14	7	2	1082	12\n18	14	8	6	7	8	9	10	14\n18	14	8	1	1	1988	10	4	1\n18	14	9	6	7	8	9	10	11	15\n18	14	9	3	4	12	4203	4	3	1\n18	14	10	9	10	11	12	13	14	16\n18	14	10	33	2366	2	2	2	1	1\n18	14	11	6	9	10	11	12	13	14	15\n18	14	11	8	11	25	22117	80	6	6	2\n18	14	12	6	8	9	10	11	12	13	14	15	16	17	18\n18	14	12	3	2	3	3	58	16301	13	1	4	1	1	13\n18	14	13	6	10	11	12	13	14	15\n18	14	13	18	3	8	107	15985	7	51\n18	14	14	6	8	11	12	13	14	15	16\n18	14	14	1	3	11	13	51	10171	1	19\n18	14	15	6	9	12	13	14	15	16	17	19	21	24\n18	14	15	8	2	2	17	44	11671	43	1	1	1	1\n18	14	16	8	11	12	14	15	16	17	18\n18	14	16	1	1	2	5	38	3854	5	1\n18	14	17	11	16	17\n18	14	17	1	1	80\n18	14	18	15	16	18	24\n18	14	18	1	1	3	1\n18	14	20	20\n18	14	20	2726\n18	14	21	12	21\n18	14	21	1	73\n18	14	22	22\n18	14	22	2\n18	14	25	30\n18	14	25	1\n18	14	27	27\n18	14	27	1\n18	14	28	28\n18	14	28	1\n18	14	29	30\n18	14	29	1\n18	14	37	20	37\n18	14	37	3	36\n18	14	38	38\n18	14	38	1\n18	14	39	37\n18	14	39	1\n18	15	0	0\n18	15	0	8\n18	15	6	6	9\n18	15	6	4057	19\n18	15	7	7	9\n18	15	7	1083	7\n18	15	8	7	8	9	11\n18	15	8	3	2000	2	1\n18	15	9	6	7	8	9	10	11	13\n18	15	9	3	2	10	4297	1	2	1\n18	15	10	8	9	10	11	12	14\n18	15	10	1	22	2378	2	1	1\n18	15	11	6	9	10	11	12	13	16\n18	15	11	1	13	29	22035	117	5	1\n18	15	12	9	10	11	12	13	15\n18	15	12	1	5	53	16429	14	6\n18	15	13	6	10	11	12	13	14	15	18\n18	15	13	4	6	19	97	15880	6	60	2\n18	15	14	11	12	13	14	15	16	18\n18	15	14	1	10	61	10132	1	26	5\n18	15	15	9	12	13	14	15	16	18	21\n18	15	15	3	4	28	40	11650	41	2	1\n18	15	16	13	14	15	16	17	20\n18	15	16	2	5	39	3871	1	2\n18	15	17	17\n18	15	17	87\n18	15	18	18\n18	15	18	18\n18	15	19	19\n18	15	19	1\n18	15	20	16	20\n18	15	20	1	2728\n18	15	21	21\n18	15	21	74\n18	15	22	21	22\n18	15	22	1	1\n18	15	24	24\n18	15	24	2\n18	15	27	23\n18	15	27	1\n18	15	28	28\n18	15	28	1\n18	15	30	28	30\n18	15	30	1	1\n18	15	37	20	37\n18	15	37	3	34\n18	15	38	39\n18	15	38	1\n18	16	0	0\n18	16	0	8\n18	16	6	6	9	13\n18	16	6	4063	1	1\n18	16	7	7\n18	16	7	1088\n18	16	8	7	8\n18	16	8	75	1936\n18	16	9	6	7	8	9\n18	16	9	571	90	93	3610\n18	16	10	7	8	9	10	11\n18	16	10	5	32	92	2287	3\n18	16	11	8	9	10	11	12	13	14\n18	16	11	95	109	59	21724	117	8	1\n18	16	12	7	8	9	10	11	12	13	15\n18	16	12	45	79	164	160	1502	14698	8	2\n18	16	13	6	8	9	10	11	12	13	14	15	16\n18	16	13	2	45	90	77	308	308	15088	8	64	1\n18	16	14	9	10	11	12	13	14	15	16	17	20\n18	16	14	68	117	265	217	488	8994	1	31	1	2\n18	16	15	9	10	11	12	13	14	15	16\n18	16	15	56	53	120	199	1904	341	9035	48\n18	16	16	10	11	12	13	14	15	16	17	18	20\n18	16	16	3	27	34	51	400	187	3232	2	1	3\n18	16	17	17\n18	16	17	88\n18	16	18	10	12	14	16	18	25\n18	16	18	2	11	6	1	6	1\n18	16	19	18\n18	16	19	1\n18	16	20	11	12	13	14	15	16	17	20\n18	16	20	7	3	11	43	27	2337	39	266\n18	16	21	12	13	15	18	21\n18	16	21	36	23	1	1	15\n18	16	22	22\n18	16	22	1\n18	16	23	21\n18	16	23	1\n18	16	24	13\n18	16	24	2\n18	16	28	28\n18	16	28	2\n18	16	30	32\n18	16	30	1\n18	16	37	16	17	20	35	37\n18	16	37	25	4	1	1	3\n18	16	39	40\n18	16	39	1\n18	17	0	0\n18	17	0	8\n18	17	6	6\n18	17	6	4636\n18	17	7	7\n18	17	7	1303\n18	17	8	7	8	12	13\n18	17	8	48	2230	1	1\n18	17	9	6	7	8	9	10	13\n18	17	9	351	45	78	3709	5	2\n18	17	10	7	8	9	10	11	13\n18	17	10	8	22	76	2650	1	1\n18	17	11	8	9	10	11	12	13	15	16\n18	17	11	54	70	53	23593	169	14	1	2\n18	17	12	7	8	9	10	11	12	13	15	16\n18	17	12	3	19	49	138	815	14570	17	10	2\n18	17	13	8	9	10	11	12	13	14	15	16\n18	17	13	15	43	36	173	267	16921	9	119	1\n18	17	14	9	10	11	12	13	14	15	16	17\n18	17	14	17	35	40	73	299	9265	3	58	3\n18	17	15	9	10	11	12	13	14	15	16	17\n18	17	15	13	13	50	71	799	140	8178	52	1\n18	17	16	11	12	13	14	15	16	17\n18	17	16	8	11	29	152	108	5366	1\n18	17	17	16	17\n18	17	17	4	130\n18	17	18	12	13	14	15	17	18\n18	17	18	4	1	1	1	1	1\n18	17	20	11	14	15	16	17	20\n18	17	20	1	2	5	120	1	143\n18	17	21	11	12	13	16	21\n18	17	21	1	5	4	1	5\n18	17	22	18\n18	17	22	1\n18	17	25	25\n18	17	25	1\n18	17	28	25	28\n18	17	28	1	1\n18	17	32	30\n18	17	32	1\n18	17	35	35\n18	17	35	1\n18	17	37	16	37\n18	17	37	1	2\n18	17	40	39\n18	17	40	1\n19	1	0	0\n19	1	0	14\n19	1	6	6	9\n19	1	6	543	37\n19	1	7	7	8	9	10	12\n19	1	7	753	11	25	1	1\n19	1	8	7	8	9	10	11	12	13\n19	1	8	3	1285	12	1	16	18	4\n19	1	9	7	8	9	10	11	12	13	14	15\n19	1	9	2	8	2355	23	45	20	15	4	2\n19	1	10	9	10	11	12	13	14	15\n19	1	10	16	955	13	16	9	21	3\n19	1	11	8	9	10	11	12	13	14	15	16\n19	1	11	1	10	18	14966	146	38	21	4	4\n19	1	12	9	10	11	12	13	14	15	16	21\n19	1	12	1	1	405	11619	29	37	16	7	5\n19	1	13	8	9	10	11	12	13	14	15	16	17	18	21\n19	1	13	1	1	2	36	66	12141	60	161	7	1	1	7\n19	1	14	11	12	13	14	15	16	18	19\n19	1	14	1	12	43	6689	28	23	1	1\n19	1	15	11	12	13	14	15	16	18	19	21\n19	1	15	3	21	319	13	9700	51	4	1	3\n19	1	16	12	13	14	15	16	20	21	37\n19	1	16	2	4	119	54	4060	392	5	7\n19	1	17	14	15	16	17	20	21\n19	1	17	2	1	3	91	10	3\n19	1	18	18	20	21	23\n19	1	18	14	1	1	3\n19	1	19	19\n19	1	19	5\n19	1	20	20	21	25\n19	1	20	343	1	1\n19	1	21	21	23	25\n19	1	21	23	1	1\n19	1	22	20\n19	1	22	1\n19	1	23	23\n19	1	23	14\n19	1	25	25\n19	1	25	1\n19	1	26	25\n19	1	26	1\n19	1	27	27\n19	1	27	1\n19	1	28	28\n19	1	28	1\n19	1	30	30	32\n19	1	30	1	1\n19	1	37	37\n19	1	37	17\n19	2	0	0\n19	2	0	14\n19	2	6	6	9\n19	2	6	510	33\n19	2	7	7	8	9	12\n19	2	7	711	18	22	7\n19	2	8	7	8	9	10	11	12	13\n19	2	8	2	1228	9	5	18	36	8\n19	2	9	6	7	8	9	10	11	12	13	14	15\n19	2	9	3	2	3	2346	13	33	25	19	5	8\n19	2	10	8	9	10	11	12	13	14	15\n19	2	10	1	15	901	12	30	6	26	10\n19	2	11	9	10	11	12	13	14	15	16	20\n19	2	11	7	21	15156	213	50	22	10	5	1\n19	2	12	9	10	11	12	13	14	15	16	20	21	28\n19	2	12	1	3	324	11487	32	34	14	5	1	19	1\n19	2	13	11	12	13	14	15	16	21\n19	2	13	21	60	12243	80	180	5	13\n19	2	14	11	12	13	14	15	16	17	19	20\n19	2	14	3	4	29	6861	36	29	1	2	1\n19	2	15	11	12	13	14	15	16	17	19	20	21\n19	2	15	3	18	280	20	9619	25	1	1	1	1\n19	2	16	13	14	15	16	17	18	20	21	23	37\n19	2	16	1	71	51	2966	1	1	1050	4	1	9\n19	2	17	14	15	16	17	18	20	23	37\n19	2	17	1	2	4	65	1	12	4	3\n19	2	18	18	20	21	23\n19	2	18	13	1	2	4\n19	2	19	19	21	25\n19	2	19	5	1	1\n19	2	20	15	16	20	37\n19	2	20	1	1	744	1\n19	2	21	21	23	25\n19	2	21	44	3	1\n19	2	23	23\n19	2	23	18\n19	2	25	25\n19	2	25	4\n19	2	27	26\n19	2	27	1\n19	2	28	28\n19	2	28	1\n19	2	30	30\n19	2	30	1\n19	2	32	32\n19	2	32	1\n19	2	37	37\n19	2	37	24\n19	3	0	0\n19	3	0	14\n19	3	6	6\n19	3	6	513\n19	3	7	7\n19	3	7	715\n19	3	8	7	8\n19	3	8	1	1249\n19	3	9	6	7	8	9	10	11\n19	3	9	1	3	7	2415	5	2\n19	3	10	9	10\n19	3	10	24	919\n19	3	11	9	10	11	12	13\n19	3	11	3	11	15542	5	9\n19	3	12	9	10	11	12	13	14\n19	3	12	4	1	270	11598	6	1\n19	3	13	9	10	11	12	13	14	15	17\n19	3	13	1	1	17	65	12544	17	22	1\n19	3	14	11	12	13	14	15	16\n19	3	14	1	11	35	7069	2	2\n19	3	15	12	13	14	15	16\n19	3	15	13	230	9	9671	8\n19	3	16	11	12	13	14	15	16	17\n19	3	16	1	1	1	47	58	2931	1\n19	3	17	16	17\n19	3	17	2	66\n19	3	18	18\n19	3	18	15\n19	3	19	19\n19	3	19	8\n19	3	20	16	18	20\n19	3	20	2	1	1808\n19	3	21	17	21	23\n19	3	21	1	82	1\n19	3	23	21	23\n19	3	23	2	28\n19	3	25	23	25\n19	3	25	2	4\n19	3	26	26\n19	3	26	1\n19	3	28	22	30\n19	3	28	1	1\n19	3	30	30\n19	3	30	1\n19	3	32	32\n19	3	32	1\n19	3	37	37\n19	3	37	37\n19	4	0	0\n19	4	0	14\n19	4	6	6\n19	4	6	514\n19	4	7	7\n19	4	7	719\n19	4	8	7	8\n19	4	8	1	1255\n19	4	9	6	7	8	9	10	11\n19	4	9	1	3	5	2426	11	1\n19	4	10	9	10	11\n19	4	10	17	918	2\n19	4	11	9	10	11	12	13\n19	4	11	4	21	15792	5	11\n19	4	12	9	10	11	12	13	14\n19	4	12	2	1	215	11472	2	1\n19	4	13	8	11	12	13	14	15\n19	4	13	1	11	57	12729	13	14\n19	4	14	11	12	13	14	16\n19	4	14	3	6	33	7098	3\n19	4	15	11	12	13	14	15	16\n19	4	15	2	3	176	14	9551	7\n19	4	16	13	14	15	16\n19	4	16	2	30	58	2855\n19	4	17	13	16	17	19\n19	4	17	2	4	62	1\n19	4	18	14	18	24\n19	4	18	4	11	1\n19	4	19	15	19\n19	4	19	1	7\n19	4	20	18	19	20\n19	4	20	1	1	1806\n19	4	21	15	21\n19	4	21	1	83\n19	4	22	22\n19	4	22	1\n19	4	23	18	19	23\n19	4	23	2	1	28\n19	4	25	21	25\n19	4	25	1	3\n19	4	26	14\n19	4	26	1\n19	4	30	16	30\n19	4	30	1	1\n19	4	32	33\n19	4	32	1\n19	4	37	37\n19	4	37	37\n19	5	0	0\n19	5	0	14\n19	5	6	6\n19	5	6	515\n19	5	7	7\n19	5	7	723\n19	5	8	8\n19	5	8	1261\n19	5	9	6	7	8	9	10\n19	5	9	1	3	12	2422	11\n19	5	10	8	9	10	11\n19	5	10	1	14	934	2\n19	5	11	9	10	11	12	13\n19	5	11	6	18	15991	4	7\n19	5	12	9	10	11	12	13	14\n19	5	12	3	6	169	11359	4	2\n19	5	13	8	11	12	13	14	15\n19	5	13	3	10	58	12865	7	12\n19	5	14	11	12	13	14	16\n19	5	14	3	13	31	7110	4\n19	5	15	11	12	13	14	15	16	17\n19	5	15	1	2	119	15	9484	3	1\n19	5	16	13	14	15	16	17\n19	5	16	1	19	58	2791	1\n19	5	17	13	15	16	17\n19	5	17	1	3	3	55\n19	5	18	13	15	17	18	20\n19	5	18	1	4	1	7	1\n19	5	19	15	19\n19	5	19	1	9\n19	5	20	15	16	19	20\n19	5	20	1	2	1	1802\n19	5	21	15	17	18	21\n19	5	21	6	1	1	76\n19	5	22	11\n19	5	22	1\n19	5	23	13	15	17	18	21	23\n19	5	23	1	1	2	11	6	7\n19	5	24	32\n19	5	24	1\n19	5	25	25\n19	5	25	3\n19	5	30	30\n19	5	30	1\n19	5	33	35\n19	5	33	1\n19	5	37	37\n19	5	37	37\n19	6	0	0\n19	6	0	14\n19	6	6	6	9\n19	6	6	515	1\n19	6	7	7\n19	6	7	726\n19	6	8	7	8	9	13\n19	6	8	3	1272	1	1\n19	6	9	7	8	9	10\n19	6	9	6	5	2424	10\n19	6	10	8	9	10	11	14\n19	6	10	1	15	951	1	1\n19	6	11	7	8	9	10	11	12	13\n19	6	11	6	1	5	16	16132	6	11\n19	6	12	7	10	11	12	13	14	15\n19	6	12	2	1	124	11302	3	2	2\n19	6	13	6	7	9	11	12	13	14	15\n19	6	13	2	13	5	4	58	12921	12	15\n19	6	14	7	11	12	13	14	15	16	25\n19	6	14	3	2	12	23	7109	1	2	1\n19	6	15	7	9	11	12	13	14	15	16\n19	6	15	3	1	1	3	84	14	9460	4\n19	6	16	12	14	15	16	17\n19	6	16	1	20	35	2746	1\n19	6	17	13	15	16	17	21\n19	6	17	1	3	4	52	1\n19	6	18	7	18\n19	6	18	2	17\n19	6	19	7	9	10	12	14\n19	6	19	4	1	1	1	3\n19	6	20	16	20\n19	6	20	1	1802\n19	6	21	7	15	21\n19	6	21	1	5	76\n19	6	23	23\n19	6	23	7\n19	6	25	9	10\n19	6	25	1	2\n19	6	30	30\n19	6	30	1\n19	6	32	32\n19	6	32	1\n19	6	35	37\n19	6	35	1\n19	6	37	37\n19	6	37	37\n19	7	0	0\n19	7	0	14\n19	7	6	6\n19	7	6	517\n19	7	7	6	7	10\n19	7	7	3	765	1\n19	7	8	6	7	8	9	13\n19	7	8	3	2	1272	1	1\n19	7	9	6	7	8	9	10	11	13\n19	7	9	7	4	4	2424	11	3	1\n19	7	10	6	8	9	10	12\n19	7	10	2	1	20	957	1\n19	7	11	6	9	10	11	12	13	14	15\n19	7	11	12	13	25	16191	4	17	1	1\n19	7	12	6	9	10	11	12	13	14	15\n19	7	12	2	1	6	88	11273	7	4	2\n19	7	13	6	9	11	12	13	14	15	16\n19	7	13	61	7	10	49	12887	14	15	1\n19	7	14	6	9	10	11	12	13	14	15	16	27\n19	7	14	1	1	1	7	3	24	7119	1	3	1\n19	7	15	6	9	10	11	12	13	14	15	16\n19	7	15	32	3	1	1	4	70	17	9386	7\n19	7	16	12	13	14	15	16	21	29\n19	7	16	1	2	10	29	2713	1	1\n19	7	17	6	9	13	15	16	17	23	24\n19	7	17	5	5	1	2	2	36	1	1\n19	7	18	6	9	15	18\n19	7	18	10	5	1	1\n19	7	20	11	13	16	20\n19	7	20	1	1	1	1799\n19	7	21	6	9	13	15	16	21\n19	7	21	4	3	1	10	2	57\n19	7	23	9	16\n19	7	23	5	2\n19	7	25	27\n19	7	25	1\n19	7	30	30\n19	7	30	1\n19	7	32	32\n19	7	32	1\n19	7	37	20	37\n19	7	37	1	37\n19	8	0	0\n19	8	0	14\n19	8	6	6\n19	8	6	659\n19	8	7	6	7\n19	8	7	1	770\n19	8	8	6	7	8\n19	8	8	3	4	1270\n19	8	9	6	7	8	9	10	11	13\n19	8	9	7	5	9	2460	3	3	1\n19	8	10	6	7	9	10	11	12\n19	8	10	1	1	18	980	1	1\n19	8	11	6	9	10	11	12	13	14\n19	8	11	10	11	29	16237	5	8	1\n19	8	12	6	8	9	10	11	12	13	14	15\n19	8	12	3	3	4	6	68	11240	7	1	3\n19	8	13	6	9	10	11	12	13	14	15\n19	8	13	31	10	2	11	51	12893	4	10\n19	8	14	6	9	10	11	12	13	14	15	18\n19	8	14	1	1	8	3	9	43	7098	1	1\n19	8	15	6	9	11	12	13	14	15	16	17	18\n19	8	15	13	3	1	8	105	17	9288	9	1	2\n19	8	16	8	9	12	14	15	16	17\n19	8	16	1	2	2	18	18	2689	1\n19	8	17	16	17\n19	8	17	3	33\n19	8	18	18\n19	8	18	1\n19	8	20	14	15	16	20	37\n19	8	20	1	1	11	1786	1\n19	8	21	9	21	27\n19	8	21	2	55	1\n19	8	23	23\n19	8	23	1\n19	8	24	24\n19	8	24	1\n19	8	27	27	28\n19	8	27	1	1\n19	8	29	27\n19	8	29	1\n19	8	30	32\n19	8	30	1\n19	8	32	32\n19	8	32	1\n19	8	37	20	37\n19	8	37	1	36\n19	9	0	0\n19	9	0	14\n19	9	6	6	9\n19	9	6	723	6\n19	9	7	6	7\n19	9	7	4	776\n19	9	8	6	7	8	9	13\n19	9	8	2	3	1275	2	1\n19	9	9	6	7	8	9	10	11\n19	9	9	6	6	10	2484	4	1\n19	9	10	8	9	10	11	13\n19	9	10	2	16	1007	1	2\n19	9	11	6	8	9	10	11	12	13	14	16\n19	9	11	13	3	14	27	16257	3	5	1	1\n19	9	12	6	7	8	9	10	11	12	13	14	18\n19	9	12	2	1	6	3	8	53	11231	3	5	4\n19	9	13	6	8	9	10	11	12	13	14	15\n19	9	13	32	1	7	1	6	66	12930	7	7\n19	9	14	6	8	9	10	11	12	13	14	16\n19	9	14	3	1	3	1	4	18	33	7076	1\n19	9	15	6	9	10	11	12	13	14	15	16	18	21\n19	9	15	18	7	1	1	4	98	12	9174	4	1	1\n19	9	16	6	8	9	10	11	12	13	14	15	16\n19	9	16	1	1	4	1	2	2	4	6	29	2662\n19	9	17	16	17\n19	9	17	3	32\n19	9	18	16	18\n19	9	18	1	3\n19	9	20	14	15	16	20	37\n19	9	20	7	5	29	1745	1\n19	9	21	9	13	15	21	37\n19	9	21	3	1	1	49	1\n19	9	23	23\n19	9	23	1\n19	9	24	24\n19	9	24	1\n19	9	27	27\n19	9	27	3\n19	9	28	30\n19	9	28	1\n19	9	32	32	33\n19	9	32	1	1\n19	9	37	37\n19	9	37	37\n19	10	0	0\n19	10	0	14\n19	10	6	6	9\n19	10	6	790	14\n19	10	7	6	7	9	14\n19	10	7	32	745	6	3\n19	10	8	6	7	8	9	11\n19	10	8	47	1	1243	6	2\n19	10	9	6	7	8	9	10	11	32\n19	10	9	93	2	14	2435	3	1	1\n19	10	10	6	8	9	10	12	13\n19	10	10	18	2	29	998	2	1\n19	10	11	6	8	9	10	11	12	13\n19	10	11	93	2	22	111	16044	52	1\n19	10	12	6	8	9	10	11	12	13	18\n19	10	12	35	11	4	74	45	11150	4	1\n19	10	13	6	8	9	10	11	12	13	14	15	18\n19	10	13	585	3	57	5	9	55	12357	2	3	1\n19	10	14	6	8	9	10	11	12	13	14	16\n19	10	14	27	34	8	19	8	17	26	6970	5\n19	10	15	6	9	10	12	13	14	15	16	18\n19	10	15	208	180	5	2	58	16	8744	2	1\n19	10	16	8	9	10	11	12	13	14	15	16	17\n19	10	16	9	6	8	9	1	1	16	16	2634	1\n19	10	17	17\n19	10	17	32\n19	10	18	13	18\n19	10	18	1	7\n19	10	20	14	15	16	20\n19	10	20	2	3	33	1707\n19	10	21	12	13	21\n19	10	21	1	1	48\n19	10	23	23\n19	10	23	1\n19	10	24	21\n19	10	24	1\n19	10	27	25	27\n19	10	27	1	2\n19	10	30	30\n19	10	30	1\n19	10	32	32\n19	10	32	1\n19	10	33	33\n19	10	33	1\n19	10	37	20	37\n19	10	37	1	38\n19	11	0	0\n19	11	0	14\n19	11	6	6	9\n19	11	6	1916	12\n19	11	7	6	7	8	9\n19	11	7	29	713	2	4\n19	11	8	6	7	8	9\n19	11	8	58	2	1256	2\n19	11	9	6	7	8	9	11	12	13\n19	11	9	78	5	24	2657	1	1	1\n19	11	10	6	7	8	9	10	12	18\n19	11	10	22	1	2	15	1179	2	2\n19	11	11	6	7	8	9	10	11	12	13	14\n19	11	11	110	1	3	10	244	15669	79	1	1\n19	11	12	6	8	9	10	11	12	13\n19	11	12	43	27	5	131	44	10999	31\n19	11	13	6	8	9	10	11	12	13	14	15\n19	11	13	677	8	58	9	14	49	11629	4	2\n19	11	14	6	8	9	10	11	12	13	14	16	24\n19	11	14	18	108	9	32	17	16	31	6773	4	1\n19	11	15	6	8	9	10	11	12	13	14	15	16\n19	11	15	207	14	161	21	2	6	39	18	8296	2\n19	11	16	8	9	10	11	12	13	14	15	16\n19	11	16	22	15	19	17	9	3	10	34	2545\n19	11	17	17\n19	11	17	33\n19	11	18	12	15	18	20\n19	11	18	3	2	4	1\n19	11	20	10	14	15	16	17	20\n19	11	20	1	1	2	13	1	1690\n19	11	21	18	21\n19	11	21	2	47\n19	11	23	23\n19	11	23	1\n19	11	25	25\n19	11	25	1\n19	11	27	25	28\n19	11	27	1	1\n19	11	30	30\n19	11	30	1\n19	11	32	32\n19	11	32	2\n19	11	33	33\n19	11	33	1\n19	11	37	20	37	39\n19	11	37	2	35	1\n19	12	0	0\n19	12	0	14\n19	12	6	6	7	8	9\n19	12	6	3012	3	2	141\n19	12	7	6	7	9\n19	12	7	21	698	3\n19	12	8	6	7	8	9\n19	12	8	27	1	1431	7\n19	12	9	6	7	8	9	10\n19	12	9	31	7	16	2892	2\n19	12	10	6	8	9	10	12\n19	12	10	10	3	18	1600	5\n19	12	11	6	7	8	9	10	11	12	13\n19	12	11	67	1	7	11	127	15487	58	6\n19	12	12	6	8	9	10	11	12	13	15\n19	12	12	27	24	5	73	38	10983	13	1\n19	12	13	6	8	9	10	11	12	13	14	15\n19	12	13	360	10	20	17	12	59	11242	3	12\n19	12	14	6	8	9	10	11	12	13	14	16	18\n19	12	14	7	75	6	36	23	16	39	6587	16	2\n19	12	15	6	8	9	10	11	12	13	14	15	16\n19	12	15	121	9	75	20	4	1	21	14	8061	10\n19	12	16	8	9	10	11	12	13	14	15	16	17\n19	12	16	19	12	24	17	2	1	8	25	2455	1\n19	12	17	13	17\n19	12	17	1	33\n19	12	18	12	18\n19	12	18	2	6\n19	12	20	9	10	16	20	21	23\n19	12	20	1	1	2	1686	1	2\n19	12	21	21\n19	12	21	47\n19	12	23	23\n19	12	23	1\n19	12	24	28\n19	12	24	1\n19	12	25	22	25\n19	12	25	1	1\n19	12	28	22\n19	12	28	1\n19	12	30	32\n19	12	30	1\n19	12	32	32\n19	12	32	2\n19	12	33	37\n19	12	33	1\n19	12	37	20	37\n19	12	37	2	33\n19	12	39	38\n19	12	39	1\n19	13	0	0\n19	13	0	14\n19	13	6	6	7	8	9	11\n19	13	6	3422	114	3	141	3\n19	13	7	6	7\n19	13	7	23	687\n19	13	8	6	7	8	9	10\n19	13	8	8	3	1560	23	2\n19	13	9	6	7	8	9	10	11\n19	13	9	11	28	6	3141	3	2\n19	13	10	6	8	9	10	11	12	21\n19	13	10	3	2	22	1849	8	15	1\n19	13	11	6	7	8	9	10	11	12	13\n19	13	11	24	2	9	7	41	15453	42	3\n19	13	12	6	8	9	10	11	12	13	14	15	18\n19	13	12	7	9	1	23	44	11026	11	1	2	2\n19	13	13	6	8	9	10	11	12	13	14	15\n19	13	13	163	3	14	6	7	59	11038	6	27\n19	13	14	6	8	9	10	11	12	13	14	16\n19	13	14	6	34	2	14	12	11	29	6503	1\n19	13	15	6	8	9	10	12	13	14	15	16\n19	13	15	42	6	28	3	1	17	15	7967	20\n19	13	16	8	9	10	11	12	14	15	16	17	20\n19	13	16	6	2	6	6	3	2	26	2429	2	1\n19	13	17	17\n19	13	17	34\n19	13	18	12	13	18\n19	13	18	1	1	6\n19	13	20	20\n19	13	20	1688\n19	13	21	21\n19	13	21	48\n19	13	22	14	21\n19	13	22	1	1\n19	13	23	23	26\n19	13	23	2	1\n19	13	25	25\n19	13	25	1\n19	13	28	28\n19	13	28	1\n19	13	32	32	33\n19	13	32	2	1\n19	13	37	20	37\n19	13	37	2	32\n19	13	38	38\n19	13	38	1\n19	14	0	0\n19	14	0	14\n19	14	6	6	7	8	9\n19	14	6	3589	30	2	88\n19	14	7	6	7	9\n19	14	7	1	829	4\n19	14	8	6	7	8	9	10	13\n19	14	8	2	6	1612	14	3	1\n19	14	9	6	7	8	9	11	13	14\n19	14	9	9	12	10	3346	2	1	1\n19	14	10	8	9	10	11	12	13	14	20\n19	14	10	2	20	1902	9	7	1	5	1\n19	14	11	6	8	9	10	11	12	13	14\n19	14	11	10	2	8	21	15429	63	1	1\n19	14	12	6	8	10	11	12	13	15\n19	14	12	6	2	8	40	11091	8	3\n19	14	13	6	9	10	11	12	13	14	15\n19	14	13	57	2	6	9	61	10915	1	48\n19	14	14	6	8	10	11	12	13	14	16\n19	14	14	2	5	1	5	8	24	6471	12\n19	14	15	6	9	10	13	14	15	16\n19	14	15	21	5	1	8	26	7928	33\n19	14	16	9	10	11	12	13	14	15	16\n19	14	16	1	1	1	1	1	2	33	2410\n19	14	17	17\n19	14	17	36\n19	14	18	12	15	16	18\n19	14	18	1	1	1	5\n19	14	20	20\n19	14	20	1691\n19	14	21	20	21	22\n19	14	21	1	48	1\n19	14	23	23\n19	14	23	2\n19	14	25	25\n19	14	25	1\n19	14	26	21\n19	14	26	1\n19	14	28	30\n19	14	28	1\n19	14	32	32\n19	14	32	2\n19	14	33	37\n19	14	33	1\n19	14	37	20	37\n19	14	37	3	29\n19	14	38	37\n19	14	38	1\n19	15	0	0\n19	15	0	14\n19	15	6	6	7	9\n19	15	6	3655	4	38\n19	15	7	7	9\n19	15	7	850	27\n19	15	8	7	8	9	10\n19	15	8	2	1621	10	2\n19	15	9	6	7	8	9	10	11	18\n19	15	9	1	3	7	3470	1	5	1\n19	15	10	8	9	10	12	16\n19	15	10	1	13	1925	3	1\n19	15	11	6	9	10	11	12	13	14\n19	15	11	5	11	13	15391	73	1	1\n19	15	12	6	8	9	10	11	12	13	14	15	16	18\n19	15	12	1	2	4	4	38	11167	7	2	1	1	5\n19	15	13	6	9	10	11	12	13	14	15	18\n19	15	13	14	1	1	9	56	10841	3	33	2\n19	15	14	6	11	12	13	14	16\n19	15	14	1	5	8	25	6459	9\n19	15	15	6	9	12	13	14	15	16	18	21\n19	15	15	1	1	3	10	36	7939	21	1	1\n19	15	16	14	15	16	17	20\n19	15	16	3	19	2427	6	1\n19	15	17	16	17\n19	15	17	1	35\n19	15	18	12	18	21\n19	15	18	1	3	1\n19	15	20	16	18	20\n19	15	20	1	1	1694\n19	15	21	21	27\n19	15	21	48	1\n19	15	22	28\n19	15	22	1\n19	15	23	23\n19	15	23	2\n19	15	25	22\n19	15	25	1\n19	15	30	30\n19	15	30	1\n19	15	32	32\n19	15	32	2\n19	15	37	20	35	37\n19	15	37	8	1	22\n19	16	0	0\n19	16	0	14\n19	16	6	6	9\n19	16	6	3660	18\n19	16	7	7	9\n19	16	7	854	5\n19	16	8	7	8	9\n19	16	8	1	1627	3\n19	16	9	6	7	8	9	11\n19	16	9	2	4	6	3562	1\n19	16	10	8	9	10	11	13\n19	16	10	1	21	1921	1	2\n19	16	11	6	9	10	11	12	13	19\n19	16	11	1	8	10	15367	57	4	1\n19	16	12	6	9	10	11	12	13	14	15\n19	16	12	1	1	5	42	11243	11	2	6\n19	16	13	6	9	10	11	12	13	14	15	21\n19	16	13	5	1	2	18	64	10723	6	64	1\n19	16	14	11	12	13	14	16	18\n19	16	14	5	16	35	6433	14	1\n19	16	15	13	14	15	16	18	20\n19	16	15	17	32	7914	27	1	1\n19	16	16	14	15	16\n19	16	16	8	23	2430\n19	16	17	16	17\n19	16	17	1	40\n19	16	18	18	21\n19	16	18	11	2\n19	16	20	20\n19	16	20	1703\n19	16	21	13	21\n19	16	21	1	49\n19	16	22	22\n19	16	22	1\n19	16	23	23\n19	16	23	2\n19	16	27	27\n19	16	27	1\n19	16	28	28\n19	16	28	1\n19	16	30	32\n19	16	30	1\n19	16	32	30	32\n19	16	32	1	1\n19	16	35	35\n19	16	35	1\n19	16	37	20	35	37\n19	16	37	2	1	19\n19	17	0	0\n19	17	0	14\n19	17	6	6	9\n19	17	6	3668	1\n19	17	7	7\n19	17	7	859\n19	17	8	7	8\n19	17	8	68	1566\n19	17	9	6	7	8	9	10\n19	17	9	473	75	79	2990	2\n19	17	10	7	8	9	10	13\n19	17	10	12	15	57	1853	1\n19	17	11	8	9	10	11	12	13	16\n19	17	11	97	81	52	15107	90	6	1\n19	17	12	7	8	9	10	11	12	13	14	15\n19	17	12	24	62	140	132	1012	10001	7	1	1\n19	17	13	6	8	9	10	11	12	13	14	15\n19	17	13	1	29	70	50	203	204	10178	1	57\n19	17	14	6	9	10	11	12	13	14	16\n19	17	14	1	48	114	184	173	322	5615	24\n19	17	15	9	10	11	12	13	14	15	16\n19	17	15	49	50	68	168	1344	227	6077	24\n19	17	16	9	11	12	13	14	15	16	17	20\n19	17	16	1	32	26	41	224	134	2010	3	1\n19	17	17	17\n19	17	17	40\n19	17	18	9	12	14	18\n19	17	18	1	4	1	7\n19	17	19	19\n19	17	19	1\n19	17	20	11	12	13	14	15	16	17	20\n19	17	20	6	2	9	23	15	1472	24	155\n19	17	21	12	13	16	18	21\n19	17	21	21	23	1	1	6\n19	17	22	22\n19	17	22	1\n19	17	23	23\n19	17	23	2\n19	17	27	28\n19	17	27	1\n19	17	28	26\n19	17	28	1\n19	17	30	30\n19	17	30	1\n19	17	32	32	33\n19	17	32	1	1\n19	17	35	35\n19	17	35	2\n19	17	37	16	17	35	37\n19	17	37	13	2	1	3\n19	18	0	0\n19	18	0	14\n19	18	6	6	9\n19	18	6	4142	1\n19	18	7	7\n19	18	7	1038\n19	18	8	7	8\n19	18	8	28	1820\n19	18	9	6	7	8	9	10	12\n19	18	9	318	54	69	2990	6	1\n19	18	10	7	8	9	10	11	13\n19	18	10	6	20	56	2166	1	4\n19	18	11	8	9	10	11	12	13\n19	18	11	39	52	43	16365	106	7\n19	18	12	7	8	9	10	11	12	13	15	16\n19	18	12	2	20	26	109	516	9993	14	8	1\n19	18	13	8	9	10	11	12	13	14	15	16\n19	18	13	13	24	38	120	148	11524	4	58	2\n19	18	14	9	10	11	12	13	14	15	16	17\n19	18	14	11	24	34	49	192	5739	2	38	3\n19	18	15	9	10	11	12	13	14	15	16	20\n19	18	15	10	8	35	39	589	96	5476	30	1\n19	18	16	11	12	13	14	15	16\n19	18	16	6	7	14	100	85	3333\n19	18	17	13	17\n19	18	17	1	68\n19	18	18	12	13	15	18\n19	18	18	5	1	1	1\n19	18	19	18\n19	18	19	1\n19	18	20	15	16	20\n19	18	20	1	67	88\n19	18	21	12	13	19	21\n19	18	21	2	2	1	1\n19	18	22	25\n19	18	22	1\n19	18	23	23\n19	18	23	2\n19	18	26	26\n19	18	26	1\n19	18	28	21\n19	18	28	1\n19	18	30	30\n19	18	30	1\n19	18	32	30\n19	18	32	1\n19	18	33	35\n19	18	33	1\n19	18	35	32	33	35\n19	18	35	1	1	1\n19	18	37	17	20	37\n19	18	37	1	1	1\n20	1	0	0\n20	1	0	7\n20	1	6	6	9\n20	1	6	401	28\n20	1	7	7	8	9\n20	1	7	532	7	22\n20	1	8	8	9	10	11	12	13\n20	1	8	908	11	1	13	19	2\n20	1	9	7	8	9	10	11	12	13	14	15\n20	1	9	1	2	1689	9	28	18	16	5	2\n20	1	10	9	10	11	12	13	14	15\n20	1	10	9	692	3	17	7	13	2\n20	1	11	9	10	11	12	13	14	15\n20	1	11	5	15	10305	92	38	12	2\n20	1	12	9	10	11	12	13	14	15	16	21\n20	1	12	1	1	257	7779	30	21	13	5	3\n20	1	13	8	10	11	12	13	14	15	16	21\n20	1	13	1	2	20	52	8468	52	110	2	5\n20	1	14	11	12	13	14	15	16\n20	1	14	3	3	22	4167	21	17\n20	1	15	12	13	14	15	16	17	18	21	23\n20	1	15	10	210	12	6880	27	1	1	3	1\n20	1	16	13	14	15	16	20	21	23\n20	1	16	4	66	37	2386	248	2	1\n20	1	17	13	15	16	17	18	20	23	37\n20	1	17	2	1	2	33	1	2	1	1\n20	1	18	13	14	15	18\n20	1	18	2	1	1	14\n20	1	19	19\n20	1	19	6\n20	1	20	14	16	19	20	25	37\n20	1	20	2	1	1	216	1	1\n20	1	21	21	23\n20	1	21	11	2\n20	1	23	23\n20	1	23	10\n20	1	24	24\n20	1	24	3\n20	1	25	25	26\n20	1	25	4	1\n20	1	27	27\n20	1	27	1\n20	1	30	30\n20	1	30	1\n20	1	31	31\n20	1	31	1\n20	1	37	37\n20	1	37	11\n20	1	40	40\n20	1	40	1\n20	2	0	0\n20	2	0	7\n20	2	6	6	9\n20	2	6	381	20\n20	2	7	7	8	9	12\n20	2	7	494	19	16	4\n20	2	8	8	9	10	11	12	13\n20	2	8	845	17	1	16	32	7\n20	2	9	8	9	10	11	12	13	14	15\n20	2	9	11	1692	10	19	17	11	2	3\n20	2	10	9	10	11	12	13	14	15\n20	2	10	15	654	5	18	9	16	3\n20	2	11	9	10	11	12	13	14	15	16\n20	2	11	5	18	10408	135	41	10	10	2\n20	2	12	9	11	12	13	14	15	16	21\n20	2	12	2	208	7694	36	34	7	3	6\n20	2	13	10	11	12	13	14	15	16	21\n20	2	13	1	12	48	8527	61	149	2	1\n20	2	14	11	12	13	14	15	16	19	20\n20	2	14	1	7	22	4282	24	13	1	1\n20	2	15	11	12	13	14	15	16	18	19	21\n20	2	15	1	7	182	12	6839	23	1	1	3\n20	2	16	13	14	15	16	20	21	37\n20	2	16	2	31	35	1780	585	2	5\n20	2	17	15	16	17	20	23\n20	2	17	2	1	26	1	4\n20	2	18	18	23\n20	2	18	14	2\n20	2	19	19	21\n20	2	19	6	1\n20	2	20	16	20\n20	2	20	1	465\n20	2	21	21	23\n20	2	21	22	2\n20	2	23	21	23\n20	2	23	3	12\n20	2	24	20	24\n20	2	24	1	2\n20	2	25	19	23	25\n20	2	25	1	1	3\n20	2	26	26\n20	2	26	1\n20	2	27	27\n20	2	27	1\n20	2	30	30\n20	2	30	1\n20	2	31	31\n20	2	31	1\n20	2	37	37\n20	2	37	13\n20	2	40	40\n20	2	40	1\n20	3	0	0\n20	3	0	7\n20	3	6	6\n20	3	6	381\n20	3	7	7\n20	3	7	494\n20	3	8	7	8\n20	3	8	2	873\n20	3	9	7	8	9	10\n20	3	9	1	4	1756	6\n20	3	10	8	9	10\n20	3	10	1	4	679\n20	3	11	9	10	11	12	13\n20	3	11	4	10	10645	2	9\n20	3	12	9	10	11	12	13	14	15\n20	3	12	2	3	152	7798	5	1	1\n20	3	13	9	11	12	13	14	15	16\n20	3	13	1	14	42	8767	3	9	1\n20	3	14	12	13	14	15\n20	3	14	4	25	4417	2\n20	3	15	11	12	13	14	15	16\n20	3	15	1	7	155	22	6883	4\n20	3	16	14	15	16	17\n20	3	16	22	33	1769	1\n20	3	17	17\n20	3	17	26\n20	3	18	17	18\n20	3	18	1	14\n20	3	19	18	19\n20	3	19	1	8\n20	3	20	20\n20	3	20	1053\n20	3	21	21\n20	3	21	38\n20	3	23	21	23\n20	3	23	1	20\n20	3	24	11	24\n20	3	24	1	1\n20	3	25	23	25\n20	3	25	1	2\n20	3	26	26\n20	3	26	1\n20	3	27	27\n20	3	27	1\n20	3	30	31\n20	3	30	1\n20	3	31	31\n20	3	31	1\n20	3	37	20	37\n20	3	37	1	17\n20	3	40	40\n20	3	40	1\n20	4	0	0\n20	4	0	7\n20	4	6	6\n20	4	6	381\n20	4	7	7\n20	4	7	497\n20	4	8	8\n20	4	8	878\n20	4	9	7	8	9	10\n20	4	9	4	5	1754	4\n20	4	10	8	9	10\n20	4	10	2	11	685\n20	4	11	9	10	11	12	13\n20	4	11	6	13	10785	3	6\n20	4	12	9	10	11	12	13	14\n20	4	12	3	2	146	7694	6	2\n20	4	13	8	10	11	12	13	14	15\n20	4	13	1	1	4	44	8885	17	9\n20	4	14	11	12	13	14	15	16\n20	4	14	1	7	20	4434	1	2\n20	4	15	11	12	13	14	15	16\n20	4	15	1	5	124	10	6783	5\n20	4	16	14	15	16\n20	4	16	22	30	1722\n20	4	17	15	16	17\n20	4	17	1	3	24\n20	4	18	15	18\n20	4	18	1	14\n20	4	19	19\n20	4	19	8\n20	4	20	9	20	37\n20	4	20	1	1052	1\n20	4	21	9	15	21\n20	4	21	1	2	36\n20	4	23	18	21	23\n20	4	23	1	3	17\n20	4	24	24\n20	4	24	1\n20	4	25	25\n20	4	25	2\n20	4	26	25\n20	4	26	1\n20	4	27	27\n20	4	27	1\n20	4	31	10	12\n20	4	31	1	1\n20	4	37	20	37\n20	4	37	1	16\n20	4	40	40\n20	4	40	1\n20	5	0	0\n20	5	0	7\n20	5	6	6\n20	5	6	381\n20	5	7	7\n20	5	7	501\n20	5	8	7	8	13\n20	5	8	2	883	1\n20	5	9	7	8	9	10	11\n20	5	9	1	5	1753	16	1\n20	5	10	9	10	11\n20	5	10	18	687	1\n20	5	11	8	9	10	11	12	13\n20	5	11	4	2	18	10905	1	7\n20	5	12	9	10	11	12	13	14	18\n20	5	12	1	1	113	7635	1	2	1\n20	5	13	8	11	12	13	14	15\n20	5	13	4	8	36	8972	10	11\n20	5	14	9	11	12	13	14	15	16\n20	5	14	1	1	8	15	4456	2	2\n20	5	15	8	12	13	14	15	16\n20	5	15	1	4	92	11	6714	5\n20	5	16	11	14	15	16\n20	5	16	1	17	19	1695\n20	5	17	17\n20	5	17	24\n20	5	18	12	15	16	17	18\n20	5	18	1	3	1	1	9\n20	5	19	15	19\n20	5	19	1	7\n20	5	20	16	20\n20	5	20	2	1051\n20	5	21	13	15	18	21\n20	5	21	2	8	2	27\n20	5	23	11	15	17	18	21	23\n20	5	23	1	1	1	4	3	7\n20	5	24	24\n20	5	24	1\n20	5	25	10	25\n20	5	25	1	2\n20	5	27	18\n20	5	27	1\n20	5	37	37\n20	5	37	17\n20	5	40	40\n20	5	40	1\n20	6	0	0\n20	6	0	7\n20	6	6	6\n20	6	6	381\n20	6	7	7\n20	6	7	504\n20	6	8	7	8\n20	6	8	1	896\n20	6	9	6	7	8	9	10	11	13\n20	6	9	1	4	5	1755	8	1	1\n20	6	10	9	10\n20	6	10	13	710\n20	6	11	7	8	9	10	11	12	13\n20	6	11	5	2	2	18	10987	5	12\n20	6	12	9	11	12	13	14\n20	6	12	1	75	7601	5	3\n20	6	13	7	11	12	13	14	15\n20	6	13	9	4	44	9017	7	9\n20	6	14	9	11	12	13	14	15	16\n20	6	14	1	4	5	16	4468	1	1\n20	6	15	7	12	13	14	15	16\n20	6	15	5	3	53	10	6685	3\n20	6	16	12	14	15	16\n20	6	16	1	10	19	1675\n20	6	17	7	9	15	16	17\n20	6	17	1	1	1	2	21\n20	6	18	7	18	19\n20	6	18	2	14	1\n20	6	19	7	10	14	15\n20	6	19	2	2	2	1\n20	6	20	16	20\n20	6	20	1	1050\n20	6	21	15	16	18	20	21\n20	6	21	3	1	1	1	24\n20	6	23	23\n20	6	23	7\n20	6	24	27\n20	6	24	1\n20	6	25	10\n20	6	25	2\n20	6	37	37\n20	6	37	17\n20	6	40	40\n20	6	40	1\n20	7	0	0\n20	7	0	7\n20	7	6	6\n20	7	6	382\n20	7	7	6	7	9	10\n20	7	7	4	526	2	1\n20	7	8	6	8\n20	7	8	3	900\n20	7	9	6	8	9	10	11\n20	7	9	5	4	1753	9	2\n20	7	10	6	9	10	13\n20	7	10	1	11	727	1\n20	7	11	6	9	10	11	12	13	15	16\n20	7	11	13	1	22	11021	2	10	1	1\n20	7	12	10	11	12	13	14\n20	7	12	3	51	7594	6	5\n20	7	13	6	9	10	11	12	13	14	15	17	21\n20	7	13	44	3	1	5	40	8987	10	12	1	1\n20	7	14	6	10	12	13	14	15	16\n20	7	14	1	1	4	14	4476	1	3\n20	7	15	6	9	12	13	14	15	17\n20	7	15	19	3	1	48	11	6636	1\n20	7	16	6	9	12	14	15	16\n20	7	16	1	2	1	5	11	1663\n20	7	17	9	16	17\n20	7	17	4	1	16\n20	7	18	6	9	18	19\n20	7	18	8	4	2	1\n20	7	19	8\n20	7	19	1\n20	7	20	10	20	37\n20	7	20	1	1049	1\n20	7	21	6	15	21\n20	7	21	3	2	19\n20	7	23	9	16\n20	7	23	6	1\n20	7	27	27\n20	7	27	1\n20	7	37	20	37\n20	7	37	1	16\n20	7	40	40\n20	7	40	1\n20	8	0	0\n20	8	0	7\n20	8	6	6\n20	8	6	484\n20	8	7	6	7	9\n20	8	7	1	522	3\n20	8	8	6	7	8	13\n20	8	8	3	3	898	1\n20	8	9	6	7	8	9	10	11	32\n20	8	9	7	4	7	1765	2	3	1\n20	8	10	9	10	11	18\n20	8	10	7	756	1	1\n20	8	11	6	8	9	10	11	12	13\n20	8	11	7	2	6	23	11023	9	9\n20	8	12	6	8	9	10	11	12	13	14	15\n20	8	12	4	1	1	6	42	7575	7	3	3\n20	8	13	6	8	9	11	12	13	14	15	16	17	21	26\n20	8	13	38	1	5	4	22	8967	12	12	2	1	1	1\n20	8	14	6	10	11	12	13	14	15	16	18\n20	8	14	2	4	3	6	14	4470	1	6	1\n20	8	15	6	9	10	12	13	14	15	16\n20	8	15	15	9	1	2	41	10	6583	2\n20	8	16	9	14	15	16\n20	8	16	4	5	19	1641\n20	8	17	17\n20	8	17	18\n20	8	18	9\n20	8	18	2\n20	8	19	15\n20	8	19	1\n20	8	20	16	20\n20	8	20	2	1048\n20	8	21	9	21\n20	8	21	2	18\n20	8	27	27\n20	8	27	1\n20	8	37	37\n20	8	37	17\n20	8	40	40\n20	8	40	1\n20	9	0	0\n20	9	0	7\n20	9	6	6	9\n20	9	6	553	8\n20	9	7	7\n20	9	7	529\n20	9	8	6	7	8	9	18\n20	9	8	1	2	904	1	1\n20	9	9	6	7	8	9	13\n20	9	9	5	5	4	1789	1\n20	9	10	6	9	10	24\n20	9	10	1	19	771	1\n20	9	11	6	9	10	11	12	13	18\n20	9	11	2	8	17	11040	4	4	1\n20	9	12	6	8	9	10	11	12	13	14\n20	9	12	2	2	1	5	34	7568	1	1\n20	9	13	6	9	10	11	12	13	14	15\n20	9	13	13	2	1	5	38	8969	5	6\n20	9	14	6	10	11	12	13	14	16\n20	9	14	1	3	4	9	27	4455	1\n20	9	15	6	9	10	11	12	13	14	15	16\n20	9	15	4	2	1	1	7	81	16	6504	3\n20	9	16	9	10	12	14	15	16\n20	9	16	1	1	1	10	14	1626\n20	9	17	17\n20	9	17	19\n20	9	18	18\n20	9	18	2\n20	9	20	14	15	16	20\n20	9	20	1	3	19	1025\n20	9	21	9	21\n20	9	21	1	18\n20	9	26	26\n20	9	26	1\n20	9	27	27\n20	9	27	1\n20	9	32	32\n20	9	32	1\n20	9	37	20	37\n20	9	37	1	16\n20	9	40	40\n20	9	40	1\n20	10	0	0\n20	10	0	7\n20	10	6	6	9\n20	10	6	574	8\n20	10	7	6	7	9\n20	10	7	15	518	3\n20	10	8	6	8	9	11\n20	10	8	14	893	1	2\n20	10	9	6	7	8	9	11	13	18\n20	10	9	35	7	10	1777	1	1	1\n20	10	10	6	7	9	10	17\n20	10	10	7	2	23	766	1\n20	10	11	6	8	9	10	11	12	13\n20	10	11	45	2	12	37	10972	14	2\n20	10	12	6	8	9	10	11	12	13	14	15\n20	10	12	10	2	2	32	40	7535	2	2	2\n20	10	13	6	9	10	11	12	13	14	15\n20	10	13	208	17	1	12	37	8801	3	4\n20	10	14	6	8	9	10	11	12	13	14	16\n20	10	14	5	9	6	2	9	14	20	4421	2\n20	10	15	6	9	10	11	12	13	14	15	16	18\n20	10	15	68	44	1	1	5	53	15	6337	2	1\n20	10	16	9	10	13	14	15	16\n20	10	16	3	1	2	7	22	1614\n20	10	17	17	29\n20	10	17	18	1\n20	10	18	17	18\n20	10	18	1	3\n20	10	20	14	15	16	20\n20	10	20	1	5	32	988\n20	10	21	13	21\n20	10	21	1	17\n20	10	24	24\n20	10	24	1\n20	10	26	26\n20	10	26	1\n20	10	27	27\n20	10	27	1\n20	10	32	30\n20	10	32	1\n20	10	37	37\n20	10	37	16\n20	10	40	40\n20	10	40	1\n20	11	0	0\n20	11	0	7\n20	11	6	6	9\n20	11	6	978	3\n20	11	7	6	7	8	9	13\n20	11	7	24	490	8	4	1\n20	11	8	6	8	9	10\n20	11	8	35	878	2	1\n20	11	9	6	7	8	9	10	11\n20	11	9	79	6	16	1791	1	3\n20	11	10	6	8	9	10	12\n20	11	10	15	3	15	803	4\n20	11	11	6	7	8	9	10	11	12\n20	11	11	109	1	6	17	127	10710	67\n20	11	12	6	8	9	10	11	12	13	14\n20	11	12	36	8	5	90	25	7439	1	1\n20	11	13	6	8	9	10	11	12	13	14	15\n20	11	13	610	9	77	7	6	53	8116	3	1\n20	11	14	6	8	9	10	11	12	13	14	16\n20	11	14	23	54	18	20	16	13	21	4280	4\n20	11	15	6	8	9	10	11	12	13	14	15	16\n20	11	15	223	5	147	12	1	2	45	14	5920	1\n20	11	16	8	9	10	11	13	14	15	16	17	24\n20	11	16	20	10	14	9	1	13	10	1571	1	1\n20	11	17	13	14	17\n20	11	17	1	1	18\n20	11	18	14	18\n20	11	18	1	4\n20	11	20	10	11	14	15	16	20\n20	11	20	1	1	4	6	22	954\n20	11	21	21\n20	11	21	17\n20	11	24	24\n20	11	24	1\n20	11	26	23\n20	11	26	1\n20	11	27	26\n20	11	27	1\n20	11	29	32\n20	11	29	1\n20	11	30	30\n20	11	30	1\n20	11	37	37\n20	11	37	16\n20	11	40	40\n20	11	40	1\n20	12	0	0\n20	12	0	7\n20	12	6	6	8	9\n20	12	6	2081	1	50\n20	12	7	6	7	9\n20	12	7	24	471	2\n20	12	8	6	8	9	12\n20	12	8	25	980	1	1\n20	12	9	6	7	8	9	10\n20	12	9	52	2	11	2022	2\n20	12	10	6	8	9	10	11	12\n20	12	10	10	2	12	1046	1	5\n20	12	11	6	7	8	9	10	11	12	13\n20	12	11	82	1	13	8	181	10403	81	2\n20	12	12	6	8	9	10	11	12	13	14\n20	12	12	48	22	5	89	20	7369	24	1\n20	12	13	6	8	9	10	11	12	13	14	15\n20	12	13	428	8	32	11	13	38	7649	4	3\n20	12	14	6	8	9	10	11	12	13	14	16\n20	12	14	23	87	9	40	19	13	19	4102	5\n20	12	15	6	8	9	10	11	12	13	14	15	16\n20	12	15	127	12	101	13	2	2	32	7	5637	4\n20	12	16	8	9	10	11	12	13	14	15	16\n20	12	16	36	8	28	15	11	4	4	12	1480\n20	12	17	13	17\n20	12	17	1	18\n20	12	18	13	18\n20	12	18	1	3\n20	12	20	9	10	11	13	15	16	20\n20	12	20	4	1	2	1	1	9	936\n20	12	21	15	21\n20	12	21	1	16\n20	12	23	14\n20	12	23	1\n20	12	24	24	29\n20	12	24	1	1\n20	12	26	24\n20	12	26	1\n20	12	30	30\n20	12	30	1\n20	12	32	32\n20	12	32	1\n20	12	37	37\n20	12	37	16\n20	12	40	40\n20	12	40	1\n20	13	0	0\n20	13	0	7\n20	13	6	6	7	9\n20	13	6	2734	32	134\n20	13	7	6	7	9\n20	13	7	20	452	2\n20	13	8	6	7	8	9	10\n20	13	8	12	1	1146	12	1\n20	13	9	6	7	8	9	10\n20	13	9	19	10	11	2213	1\n20	13	10	6	8	9	10	11	12	18\n20	13	10	3	1	10	1388	1	7	1\n20	13	11	6	7	8	9	10	11	12	13\n20	13	11	37	6	13	10	78	10289	39	3\n20	13	12	6	8	9	10	11	12	13	14\n20	13	12	17	10	1	46	21	7413	11	1\n20	13	13	6	8	9	10	11	12	13	14	15\n20	13	13	222	5	16	5	6	24	7441	4	10\n20	13	14	6	8	9	10	11	12	13	14	16\n20	13	14	16	64	3	26	16	13	19	3958	4\n20	13	15	6	8	9	10	13	14	15	16\n20	13	15	64	6	45	13	17	14	5490	5\n20	13	16	8	9	10	11	12	13	14	15	16\n20	13	16	18	8	15	7	5	3	2	8	1432\n20	13	17	13	17\n20	13	17	1	17\n20	13	18	12	18\n20	13	18	1	2\n20	13	20	16	20\n20	13	20	1	935\n20	13	21	15	21\n20	13	21	1	15\n20	13	24	24\n20	13	24	2\n20	13	29	29\n20	13	29	1\n20	13	30	32\n20	13	30	1\n20	13	32	32\n20	13	32	1\n20	13	37	37\n20	13	37	16\n20	13	40	40\n20	13	40	1\n20	14	0	0\n20	14	0	7\n20	14	6	6	7	9\n20	14	6	2991	50	103\n20	14	7	6	7	10\n20	14	7	4	496	1\n20	14	8	6	7	8	9	10	12\n20	14	8	5	1	1249	16	2	1\n20	14	9	6	7	8	9	10\n20	14	9	19	8	9	2416	2\n20	14	10	6	9	10	11	12	13	14\n20	14	10	1	18	1533	8	11	1	1\n20	14	11	6	7	8	9	10	11	12\n20	14	11	23	1	7	3	30	10255	21\n20	14	12	6	7	8	9	10	11	12	13	15	16	18\n20	14	12	14	1	5	1	10	22	7433	10	2	1	3\n20	14	13	6	8	9	10	11	12	13	14	15	17\n20	14	13	102	3	7	7	14	43	7299	4	15	1\n20	14	14	6	8	9	10	11	12	13	14	16\n20	14	14	6	15	2	3	5	5	17	3918	8\n20	14	15	6	8	9	10	12	13	14	15	16\n20	14	15	26	3	15	6	1	11	11	5429	7\n20	14	16	8	9	10	11	12	14	15	16	20\n20	14	16	6	2	4	5	2	3	15	1403	2\n20	14	17	17\n20	14	17	17\n20	14	18	9	18\n20	14	18	1	2\n20	14	20	10	20\n20	14	20	1	934\n20	14	21	21\n20	14	21	15\n20	14	24	22	24\n20	14	24	1	1\n20	14	29	30\n20	14	29	1\n20	14	32	32\n20	14	32	2\n20	14	37	20	37\n20	14	37	1	15\n20	14	40	40\n20	14	40	1\n20	15	0	0\n20	15	0	7\n20	15	6	6	7	9	15\n20	15	6	3126	6	58	1\n20	15	7	6	7	8	9	10\n20	15	7	3	547	1	5	1\n20	15	8	7	8	9	10	11\n20	15	8	2	1288	5	1	1\n20	15	9	6	7	8	9	11	17\n20	15	9	3	5	11	2563	1	1\n20	15	10	7	8	9	10	11	12	14\n20	15	10	1	1	15	1576	2	1	3\n20	15	11	6	7	8	9	10	11	12	13	14\n20	15	11	12	1	4	4	17	10232	31	4	4\n20	15	12	6	8	9	10	11	12	13	15\n20	15	12	6	1	1	8	22	7468	9	2\n20	15	13	6	8	9	10	11	12	13	14	15	16	21\n20	15	13	32	2	1	4	12	39	7215	4	26	2	1\n20	15	14	8	11	12	13	14	15	16	21\n20	15	14	4	3	7	23	3894	1	4	1\n20	15	15	6	8	9	10	13	14	15	16\n20	15	15	6	1	5	1	11	9	5414	14\n20	15	16	10	14	15	16	17	20\n20	15	16	1	3	11	1401	2	1\n20	15	17	17\n20	15	17	18\n20	15	18	17	18\n20	15	18	1	4\n20	15	20	20\n20	15	20	937\n20	15	21	21\n20	15	21	15\n20	15	22	22\n20	15	22	1\n20	15	24	22\n20	15	24	1\n20	15	30	30\n20	15	30	1\n20	15	32	32\n20	15	32	2\n20	15	37	37\n20	15	37	15\n20	15	40	40\n20	15	40	1\n20	16	0	0\n20	16	0	7\n20	16	6	6	8	9\n20	16	6	3152	1	35\n20	16	7	7	9	14\n20	16	7	552	9	1\n20	16	8	6	7	8	9	10	11	18\n20	16	8	1	2	1299	7	2	1	1\n20	16	9	6	7	8	9	11	14\n20	16	9	1	1	4	2648	1	2\n20	16	10	9	10	11	12\n20	16	10	17	1590	1	1\n20	16	11	6	8	9	10	11	12	13	14\n20	16	11	3	2	7	10	10199	50	1	1\n20	16	12	6	7	8	9	10	11	12	13	14	15	16	17	18\n20	16	12	4	1	1	1	4	24	7495	8	1	2	1	1	3\n20	16	13	6	8	10	11	12	13	14	15	18\n20	16	13	7	1	1	6	43	7174	2	27	1\n20	16	14	6	11	12	13	14	16	19\n20	16	14	2	1	6	22	3882	3	1\n20	16	15	6	9	13	14	15	16	21\n20	16	15	2	1	7	23	5407	14	1\n20	16	16	13	14	15	16	20\n20	16	16	1	2	14	1403	1\n20	16	17	13	17\n20	16	17	1	21\n20	16	18	18	21\n20	16	18	3	1\n20	16	20	20\n20	16	20	938\n20	16	21	21\n20	16	21	17\n20	16	22	19	21\n20	16	22	1	1\n20	16	30	32\n20	16	30	1\n20	16	32	32\n20	16	32	2\n20	16	37	20	37\n20	16	37	2	13\n20	16	40	40\n20	16	40	1\n20	17	0	0\n20	17	0	7\n20	17	6	6	9\n20	17	6	3164	8\n20	17	7	7	9\n20	17	7	555	1\n20	17	8	8	9	12\n20	17	8	1306	1	1\n20	17	9	6	7	8	9	10	11\n20	17	9	3	3	5	2711	2	1\n20	17	10	8	9	10	13\n20	17	10	5	17	1584	1\n20	17	11	6	8	9	10	11	12	13	14\n20	17	11	1	1	3	16	10172	38	1	1\n20	17	12	10	11	12	13	16\n20	17	12	2	29	7556	7	1\n20	17	13	6	10	11	12	13	14	15	17\n20	17	13	1	1	9	45	7124	1	32	1\n20	17	14	6	11	12	13	14	16	18\n20	17	14	1	1	4	27	3872	6	3\n20	17	15	6	12	13	14	15	16	19	24\n20	17	15	1	1	7	13	5415	11	1	1\n20	17	16	13	14	15	16	17	20\n20	17	16	1	1	11	1406	1	1\n20	17	17	12	13	17\n20	17	17	1	1	20\n20	17	18	18\n20	17	18	8\n20	17	19	19\n20	17	19	2\n20	17	20	20\n20	17	20	941\n20	17	21	21\n20	17	21	20\n20	17	32	31	32	33\n20	17	32	1	1	1\n20	17	37	20	37\n20	17	37	1	12\n20	17	40	39\n20	17	40	1\n20	18	0	0\n20	18	0	7\n20	18	6	6	9\n20	18	6	3170	1\n20	18	7	7\n20	18	7	558\n20	18	8	7	8	9\n20	18	8	45	1271	1\n20	18	9	6	7	8	9	10	11\n20	18	9	389	56	58	2236	1	1\n20	18	10	7	8	9	10\n20	18	10	5	18	48	1534\n20	18	11	8	9	10	11	12	13\n20	18	11	74	55	37	9983	62	1\n20	18	12	7	8	9	10	11	12	13	15\n20	18	12	22	62	76	104	670	6697	12	3\n20	18	13	8	9	10	11	12	13	14	15\n20	18	13	31	57	37	155	131	6717	1	40\n20	18	14	9	10	11	12	13	14	16	18	20\n20	18	14	32	66	129	93	211	3347	8	1	1\n20	18	15	9	10	11	12	13	14	15	16\n20	18	15	32	23	75	107	905	132	4168	16\n20	18	16	9	11	12	13	14	15	16	17\n20	18	16	2	8	17	22	120	59	1195	1\n20	18	17	9	17	18\n20	18	17	1	20	1\n20	18	18	12	13	14	15	18\n20	18	18	3	2	2	1	3\n20	18	19	14	19\n20	18	19	2	1\n20	18	20	11	12	13	14	15	16	17	20\n20	18	20	4	1	1	14	9	828	3	83\n20	18	21	12	13	15	18	21\n20	18	21	6	5	2	1	6\n20	18	24	27\n20	18	24	1\n20	18	31	33\n20	18	31	1\n20	18	32	30\n20	18	32	1\n20	18	33	33\n20	18	33	1\n20	18	37	16	20	37\n20	18	37	9	1	2\n20	18	39	37\n20	18	39	1\n20	19	0	0\n20	19	0	7\n20	19	6	6\n20	19	6	3559\n20	19	7	7\n20	19	7	686\n20	19	8	7	8\n20	19	8	32	1482\n20	19	9	6	7	8	9	10\n20	19	9	261	25	58	2194	3\n20	19	10	7	8	9	10	13\n20	19	10	5	6	39	1751	1\n20	19	11	8	9	10	11	12	13	15	16\n20	19	11	24	39	33	10836	83	5	2	3\n20	19	12	8	9	10	11	12	13	15\n20	19	12	15	23	96	380	6596	4	3\n20	19	13	6	8	9	10	11	12	13	14	15\n20	19	13	1	4	19	20	102	103	7573	6	48\n20	19	14	9	10	11	12	13	14	15	16	17	20\n20	19	14	6	22	18	39	120	3387	1	23	1	1\n20	19	15	9	10	11	12	13	14	15	16\n20	19	15	10	5	23	36	359	44	3787	18\n20	19	16	11	12	13	14	15	16	17\n20	19	16	2	4	12	43	54	1940	1\n20	19	17	15	17\n20	19	17	1	23\n20	19	18	12	13	14	15	17\n20	19	18	1	1	2	1	1\n20	19	19	16\n20	19	19	1\n20	19	20	15	16	20\n20	19	20	1	41	43\n20	19	21	12	13	21\n20	19	21	2	2	2\n20	19	27	27\n20	19	27	1\n20	19	30	30\n20	19	30	1\n20	19	33	30	31\n20	19	33	1	1\n20	19	37	16	37\n20	19	37	1	2\n21	1	0	0\n21	1	0	5\n21	1	6	6	9\n21	1	6	279	19\n21	1	7	7	8	9	10\n21	1	7	372	5	15	2\n21	1	8	7	8	9	10	11	12	13\n21	1	8	1	675	9	2	9	7	1\n21	1	9	7	8	9	10	11	12	13	14	15\n21	1	9	1	1	1262	11	16	9	9	3	2\n21	1	10	9	10	11	12	13	14	15\n21	1	10	6	431	10	11	2	12	2\n21	1	11	9	10	11	12	13	14	15\n21	1	11	1	9	6730	48	28	3	5\n21	1	12	10	11	12	13	14	15	16	21\n21	1	12	1	162	4965	15	18	4	3	1\n21	1	13	8	10	11	12	13	14	15	16	21\n21	1	13	2	2	13	28	5802	41	72	7	1\n21	1	14	11	12	13	14	15	16\n21	1	14	2	3	20	2529	4	13\n21	1	15	11	12	13	14	15	16	21\n21	1	15	2	6	140	9	4748	20	5\n21	1	16	13	14	15	16	20	21	37\n21	1	16	1	49	22	1383	136	3	3\n21	1	17	13	15	16	17	20	21\n21	1	17	1	4	1	32	1	1\n21	1	18	18	21	23\n21	1	18	8	1	2\n21	1	19	15	18	19\n21	1	19	1	1	7\n21	1	20	20\n21	1	20	148\n21	1	21	20	21	23\n21	1	21	1	20	2\n21	1	23	13	23\n21	1	23	1	3\n21	1	25	21	25\n21	1	25	1	1\n21	1	28	25\n21	1	28	1\n21	1	37	37\n21	1	37	5\n21	2	0	0\n21	2	0	5\n21	2	6	6	9\n21	2	6	255	24\n21	2	7	7	8	9	12\n21	2	7	350	8	11	5\n21	2	8	7	8	9	10	11	12	13\n21	2	8	1	639	5	2	14	20	2\n21	2	9	7	9	10	11	12	13	14	15\n21	2	9	3	1252	6	17	11	9	12	2\n21	2	10	9	10	11	12	13	14	15\n21	2	10	8	407	8	14	4	13	4\n21	2	11	9	10	11	12	13	14	15	16\n21	2	11	5	7	6768	111	32	10	10	1\n21	2	12	9	10	11	12	13	14	15	16	21\n21	2	12	2	3	135	4890	12	20	11	2	2\n21	2	13	11	12	13	14	15	16	17	20	21\n21	2	13	9	25	5842	45	92	4	1	1	1\n21	2	14	11	12	13	14	15	16	19	20\n21	2	14	2	5	10	2615	14	14	2	2\n21	2	15	11	12	13	14	15	16	21\n21	2	15	2	6	124	13	4702	13	4\n21	2	16	12	13	14	15	16	17	20	21\n21	2	16	1	2	23	21	1004	1	372	3\n21	2	17	14	17	20	21	37\n21	2	17	1	27	2	1	1\n21	2	18	15	18	21	22	23\n21	2	18	1	5	1	1	1\n21	2	19	18	19	25\n21	2	19	2	4	1\n21	2	20	14	20	25\n21	2	20	1	283	2\n21	2	21	21	23	26\n21	2	21	31	1	1\n21	2	23	18	23\n21	2	23	1	6\n21	2	25	25\n21	2	25	2\n21	2	37	37\n21	2	37	8\n21	3	0	0\n21	3	0	5\n21	3	6	6\n21	3	6	255\n21	3	7	7\n21	3	7	354\n21	3	8	7	8\n21	3	8	3	644\n21	3	9	8	9	10	11\n21	3	9	2	1297	7	1\n21	3	10	9	10\n21	3	10	6	419\n21	3	11	9	10	11	12	13\n21	3	11	4	10	6932	4	5\n21	3	12	11	12	13	14\n21	3	12	112	4973	2	1\n21	3	13	10	11	12	13	14	15\n21	3	13	2	11	23	5982	9	10\n21	3	14	11	12	13	14	16\n21	3	14	2	4	15	2729	3\n21	3	15	11	12	13	14	15	16\n21	3	15	1	4	112	11	4725	4\n21	3	16	12	14	15	16\n21	3	16	1	23	18	996\n21	3	17	13	14	17\n21	3	17	2	1	26\n21	3	18	16	18\n21	3	18	1	7\n21	3	19	19\n21	3	19	6\n21	3	20	16	17	20\n21	3	20	1	1	658\n21	3	21	15	21\n21	3	21	1	42\n21	3	22	22\n21	3	22	1\n21	3	23	21	23\n21	3	23	1	7\n21	3	25	25\n21	3	25	5\n21	3	26	26\n21	3	26	1\n21	3	37	20	37\n21	3	37	1	8\n21	4	0	0\n21	4	0	5\n21	4	6	6\n21	4	6	255\n21	4	7	7\n21	4	7	357\n21	4	8	7	8\n21	4	8	1	645\n21	4	9	7	9	10\n21	4	9	2	1299	6\n21	4	10	9	10\n21	4	10	10	428\n21	4	11	9	10	11	12	13	15\n21	4	11	3	8	7043	1	3	1\n21	4	12	11	12	13	14\n21	4	12	79	4923	4	3\n21	4	13	11	12	13	14	15\n21	4	13	5	31	6069	5	8\n21	4	14	11	12	13	14	16\n21	4	14	2	5	10	2756	1\n21	4	15	12	13	14	15	16\n21	4	15	4	85	5	4653	7\n21	4	16	14	15	16\n21	4	16	13	30	962\n21	4	17	15	16	17\n21	4	17	1	1	25\n21	4	18	13	15	18\n21	4	18	1	2	4\n21	4	19	19\n21	4	19	6\n21	4	20	15	20\n21	4	20	1	658\n21	4	21	15	19	21\n21	4	21	1	1	41\n21	4	22	21\n21	4	22	1\n21	4	23	23\n21	4	23	7\n21	4	25	19	25	32\n21	4	25	1	3	1\n21	4	26	23\n21	4	26	1\n21	4	37	37\n21	4	37	8\n21	5	0	0\n21	5	0	5\n21	5	6	6\n21	5	6	255\n21	5	7	7\n21	5	7	360\n21	5	8	8\n21	5	8	645\n21	5	9	7	8	9	10	11\n21	5	9	1	1	1307	2	1\n21	5	10	9	10\n21	5	10	10	432\n21	5	11	9	10	11	12	13\n21	5	11	7	7	7103	3	9\n21	5	12	8	11	12	13	14	15\n21	5	12	1	62	4895	2	3	1\n21	5	13	8	11	12	13	14	15\n21	5	13	3	8	25	6122	7	7\n21	5	14	10	11	12	13	14	16\n21	5	14	1	2	4	11	2763	1\n21	5	15	11	13	14	15	16\n21	5	15	1	65	8	4620	3\n21	5	16	13	14	15	16\n21	5	16	1	11	13	946\n21	5	17	8	15	16	17\n21	5	17	1	1	1	22\n21	5	18	18\n21	5	18	4\n21	5	19	19	20\n21	5	19	7	1\n21	5	20	16	17	20	37\n21	5	20	1	1	655	1\n21	5	21	15	16	17	18	21\n21	5	21	2	1	2	1	36\n21	5	23	15	16	18	21	23\n21	5	23	1	1	3	1	2\n21	5	25	25\n21	5	25	3\n21	5	32	33\n21	5	32	1\n21	5	37	37\n21	5	37	8\n21	6	0	0\n21	6	0	5\n21	6	6	6	7\n21	6	6	254	1\n21	6	7	7\n21	6	7	361\n21	6	8	8\n21	6	8	651\n21	6	9	7	8	9	10\n21	6	9	3	5	1311	5\n21	6	10	9	10	13\n21	6	10	7	434	1\n21	6	11	7	9	10	11	12	13\n21	6	11	1	4	14	7143	6	9\n21	6	12	10	11	12	13	14\n21	6	12	1	51	4871	3	1\n21	6	13	7	9	11	12	13	14	15\n21	6	13	9	1	3	29	6157	8	3\n21	6	14	11	12	13	14	16\n21	6	14	2	3	9	2776	2\n21	6	15	7	11	12	13	14	15\n21	6	15	4	1	1	37	8	4594\n21	6	16	14	15	16\n21	6	16	7	12	935\n21	6	17	15	16	17\n21	6	17	2	1	22\n21	6	18	9	18\n21	6	18	1	7\n21	6	19	7	9	19\n21	6	19	3	1	3\n21	6	20	7	10	16	20\n21	6	20	1	1	1	653\n21	6	21	7	13	15	16	21\n21	6	21	1	1	13	2	20\n21	6	23	16	23\n21	6	23	1	1\n21	6	25	10\n21	6	25	3\n21	6	33	35\n21	6	33	1\n21	6	37	37\n21	6	37	9\n21	7	0	0\n21	7	0	5\n21	7	6	6\n21	7	6	254\n21	7	7	7	10\n21	7	7	383	1\n21	7	8	6	7	8\n21	7	8	1	1	654\n21	7	9	6	7	8	9	10	11\n21	7	9	3	3	2	1311	4	2\n21	7	10	6	7	9	10\n21	7	10	1	1	10	446\n21	7	11	6	9	10	11	12	13\n21	7	11	13	5	5	7168	3	6\n21	7	12	6	9	10	11	12	13\n21	7	12	1	1	1	46	4859	2\n21	7	13	6	9	10	11	12	13	14	15\n21	7	13	19	6	1	4	23	6149	8	7\n21	7	14	6	11	12	13	14	16\n21	7	14	5	1	5	6	2782	1\n21	7	15	6	12	13	14	15	16\n21	7	15	16	1	39	8	4556	4\n21	7	16	9	14	15	16	21\n21	7	16	1	4	9	926	2\n21	7	17	6	9	10	16	17\n21	7	17	1	8	1	1	11\n21	7	18	6	9	18\n21	7	18	5	1	1\n21	7	19	19\n21	7	19	3\n21	7	20	16	20\n21	7	20	1	652\n21	7	21	6	9	14	15	21\n21	7	21	1	1	1	3	14\n21	7	23	9\n21	7	23	1\n21	7	35	37\n21	7	35	1\n21	7	37	37\n21	7	37	9\n21	8	0	0\n21	8	0	5\n21	8	6	6\n21	8	6	320\n21	8	7	7	9\n21	8	7	385	3\n21	8	8	6	7	8	9\n21	8	8	1	1	653	1\n21	8	9	6	7	8	9	10\n21	8	9	7	2	2	1328	6\n21	8	10	6	9	10\n21	8	10	1	4	454\n21	8	11	6	9	10	11	12	13\n21	8	11	7	6	9	7183	10	6\n21	8	12	6	8	9	10	11	12	13	14	15\n21	8	12	2	1	1	5	16	4857	5	2	2\n21	8	13	6	9	11	12	13	14	15\n21	8	13	40	7	3	21	6112	12	7\n21	8	14	6	11	12	13	14	16\n21	8	14	1	2	3	7	2787	3\n21	8	15	6	9	12	13	14	15	16	18\n21	8	15	32	13	1	19	8	4499	2	1\n21	8	16	6	8	9	10	14	15	16	20\n21	8	16	1	1	7	1	5	6	911	1\n21	8	17	17\n21	8	17	11\n21	8	18	9\n21	8	18	1\n21	8	19	13	15\n21	8	19	1	2\n21	8	20	16	20\n21	8	20	1	651\n21	8	21	6	9	21\n21	8	21	2	6	8\n21	8	37	37\n21	8	37	10\n21	9	0	0\n21	9	0	5\n21	9	6	6	9\n21	9	6	412	2\n21	9	7	6	7	10	14\n21	9	7	2	384	1	1\n21	9	8	6	7	8	9	12	14\n21	9	8	3	2	649	1	1	1\n21	9	9	6	7	8	9	10	13\n21	9	9	5	5	4	1357	5	1\n21	9	10	7	9	10\n21	9	10	1	7	467\n21	9	11	6	8	9	10	11	12	13\n21	9	11	3	1	9	17	7157	9	8\n21	9	12	6	9	10	11	12	13	15\n21	9	12	1	1	4	14	4867	4	1\n21	9	13	6	9	10	11	12	13	14	15\n21	9	13	16	1	2	3	21	6093	5	9\n21	9	14	6	10	12	13	14	16\n21	9	14	1	2	13	6	2790	2\n21	9	15	6	9	10	12	13	14	15	16\n21	9	15	10	1	1	1	41	7	4454	1\n21	9	16	9	13	14	15	16\n21	9	16	2	1	7	2	905\n21	9	17	13	17\n21	9	17	1	10\n21	9	18	15\n21	9	18	1\n21	9	20	14	15	16	20	37\n21	9	20	1	1	3	646	1\n21	9	21	9	13	15	21\n21	9	21	1	1	1	5\n21	9	37	37\n21	9	37	10\n21	10	0	0\n21	10	0	5\n21	10	6	6	9\n21	10	6	451	2\n21	10	7	6	7\n21	10	7	3	389\n21	10	8	6	7	8	13\n21	10	8	2	1	650	1\n21	10	9	6	8	9	10\n21	10	9	5	3	1373	1\n21	10	10	6	9	10\n21	10	10	1	9	489\n21	10	11	6	9	10	11	12	13\n21	10	11	5	4	19	7136	8	2\n21	10	12	6	8	9	10	11	12	13	15	18\n21	10	12	4	1	1	7	25	4870	2	1	1\n21	10	13	6	9	10	11	12	13	14\n21	10	13	35	4	1	6	29	6080	1\n21	10	14	6	8	9	10	11	12	13	14\n21	10	14	2	1	1	1	2	9	14	2782\n21	10	15	6	9	11	12	13	14	15	19\n21	10	15	13	5	1	1	59	6	4383	1\n21	10	16	10	13	14	15	16\n21	10	16	1	1	7	9	893\n21	10	17	17\n21	10	17	10\n21	10	20	14	15	16	20\n21	10	20	3	6	27	610\n21	10	21	21\n21	10	21	5\n21	10	37	37\n21	10	37	11\n21	11	0	0\n21	11	0	5\n21	11	6	6	9\n21	11	6	515	6\n21	11	7	6	7	8	11	13\n21	11	7	21	358	9	1	1\n21	11	8	6	7	8	9\n21	11	8	21	1	631	2\n21	11	9	6	7	8	9	13\n21	11	9	57	2	6	1332	2\n21	11	10	6	8	9	10	17\n21	11	10	17	1	10	490	1\n21	11	11	6	8	9	10	11	12	13\n21	11	11	61	4	7	71	7002	24	1\n21	11	12	6	8	10	11	12	13	14	18\n21	11	12	15	4	36	22	4837	1	1	1\n21	11	13	6	8	9	10	11	12	13	14	15	16\n21	11	13	336	1	29	3	9	28	5748	2	1	2\n21	11	14	6	8	9	10	11	12	13	14	16	18\n21	11	14	13	22	9	7	7	11	22	2704	3	1\n21	11	15	6	8	9	10	12	13	14	15	18\n21	11	15	128	1	111	3	6	55	11	4083	1\n21	11	16	8	9	10	11	12	13	14	15	16\n21	11	16	4	1	4	2	1	1	9	9	889\n21	11	17	13	17\n21	11	17	1	9\n21	11	18	18\n21	11	18	1\n21	11	19	19\n21	11	19	1\n21	11	20	14	15	16	20\n21	11	20	6	5	28	571\n21	11	21	21\n21	11	21	5\n21	11	37	37\n21	11	37	11\n21	12	0	0\n21	12	0	5\n21	12	6	6	8	9	11\n21	12	6	1172	2	8	2\n21	12	7	6	7	9\n21	12	7	20	340	1\n21	12	8	6	8	9\n21	12	8	27	655	1\n21	12	9	6	7	8	9	10	11\n21	12	9	55	2	12	1435	1	2\n21	12	10	6	8	9	10	12\n21	12	10	10	1	11	589	3\n21	12	11	6	8	9	10	11	12	13\n21	12	11	75	6	8	117	6764	71	2\n21	12	12	6	8	9	10	11	12	13	14\n21	12	12	35	12	4	87	13	4754	1	1\n21	12	13	6	8	9	10	11	12	13	14	15\n21	12	13	440	7	45	9	6	34	5280	4	7\n21	12	14	6	8	9	10	11	12	13	14	16	26\n21	12	14	18	57	9	19	17	9	14	2584	5	1\n21	12	15	6	8	9	10	11	12	13	14	15	16\n21	12	15	174	6	110	16	3	2	27	10	3749	1\n21	12	16	8	9	10	11	12	13	14	15	16\n21	12	16	16	10	19	15	1	1	5	3	852\n21	12	17	17\n21	12	17	10\n21	12	18	18\n21	12	18	4\n21	12	19	18\n21	12	19	1\n21	12	20	10	14	15	16	20\n21	12	20	1	3	3	30	534\n21	12	21	13	21\n21	12	21	1	4\n21	12	37	16	20	37\n21	12	37	1	1	9\n21	13	0	0\n21	13	0	5\n21	13	6	6	7	9\n21	13	6	1931	8	87\n21	13	7	6	7\n21	13	7	20	322\n21	13	8	6	7	8	9\n21	13	8	18	2	749	5\n21	13	9	6	7	8	9	12\n21	13	9	34	5	7	1595	1\n21	13	10	6	7	9	10	12\n21	13	10	8	1	11	832	6\n21	13	11	6	7	8	9	10	11	12	13\n21	13	11	57	3	8	9	101	6611	30	3\n21	13	12	6	8	9	10	11	12	13	14\n21	13	12	28	19	4	78	16	4712	16	1\n21	13	13	6	8	9	10	11	12	13	14	15\n21	13	13	294	5	17	10	9	17	4966	2	6\n21	13	14	6	8	9	10	11	12	13	14	16	17\n21	13	14	11	85	3	32	11	12	19	2429	4	1\n21	13	15	6	8	9	10	11	12	13	14	15	16\n21	13	15	90	12	65	15	3	3	11	6	3554	3\n21	13	16	8	9	10	11	12	13	14	15	16	17\n21	13	16	25	7	20	17	4	4	2	8	801	1\n21	13	17	17\n21	13	17	10\n21	13	18	12	14	18	21\n21	13	18	1	1	2	1\n21	13	20	14	16	20\n21	13	20	1	10	524\n21	13	21	21\n21	13	21	4\n21	13	26	21\n21	13	26	1\n21	13	37	37\n21	13	37	9\n21	14	0	0\n21	14	0	5\n21	14	6	6	7	9\n21	14	6	2354	18	119\n21	14	7	6	7\n21	14	7	10	331\n21	14	8	6	8	9\n21	14	8	12	889	9\n21	14	9	6	7	8	9	10	11\n21	14	9	22	6	6	1766	2	1\n21	14	10	6	8	9	10	11	12\n21	14	10	2	1	8	1066	2	9\n21	14	11	6	7	8	9	10	11	12	13\n21	14	11	30	1	6	4	49	6548	24	5\n21	14	12	6	7	8	9	10	11	12	13	15\n21	14	12	19	1	8	1	29	17	4703	7	1\n21	14	13	6	8	9	10	11	12	13	14	15	18\n21	14	13	173	4	7	10	8	32	4778	2	4	1\n21	14	14	6	8	9	10	11	12	13	14	16\n21	14	14	8	35	5	13	6	5	11	2357	2\n21	14	15	6	8	9	10	11	13	14	15	16\n21	14	15	41	3	34	4	1	10	12	3460	3\n21	14	16	8	9	10	11	12	13	14	15	16	17\n21	14	16	13	5	10	13	3	1	2	5	765	1\n21	14	17	17\n21	14	17	12\n21	14	18	12	18\n21	14	18	1	1\n21	14	20	10	16	20\n21	14	20	1	1	522\n21	14	21	15	21\n21	14	21	1	5\n21	14	37	20	37\n21	14	37	1	8\n21	15	0	0\n21	15	0	5\n21	15	6	6	7	9\n21	15	6	2563	22	86\n21	15	7	6	7	9	10\n21	15	7	2	353	1	1\n21	15	8	6	8	9	10\n21	15	8	2	947	15	1\n21	15	9	6	7	8	9	10\n21	15	9	19	4	3	1931	1\n21	15	10	8	9	10	11	12	14	15	18\n21	15	10	1	13	1147	5	15	1	1	1\n21	15	11	6	7	8	9	10	11	12	13\n21	15	11	13	1	1	5	14	6542	19	1\n21	15	12	6	8	9	10	11	12	13	15\n21	15	12	7	3	1	14	14	4730	6	2\n21	15	13	6	9	10	11	12	13	14	15	17	18\n21	15	13	70	4	1	6	24	4697	2	6	1	1\n21	15	14	6	7	8	10	11	12	13	14	16\n21	15	14	4	1	12	2	2	3	16	2330	3\n21	15	15	6	8	9	10	13	14	15	16\n21	15	15	14	1	8	1	5	12	3423	7\n21	15	16	8	10	11	12	14	15	16\n21	15	16	6	6	1	2	1	4	751\n21	15	17	17\n21	15	17	13\n21	15	18	18\n21	15	18	2\n21	15	20	10	20\n21	15	20	1	522\n21	15	21	18	21\n21	15	21	1	4\n21	15	37	37\n21	15	37	8\n21	16	0	0\n21	16	0	5\n21	16	6	6	9\n21	16	6	2646	48\n21	16	7	6	7	8	9\n21	16	7	1	377	1	2\n21	16	8	6	7	8	9	10	11\n21	16	8	1	2	960	9	1	1\n21	16	9	6	8	9\n21	16	9	1	3	2060\n21	16	10	9	10	11	12	13	14\n21	16	10	14	1169	1	3	1	1\n21	16	11	6	8	9	10	11	12	14\n21	16	11	9	3	6	8	6521	22	1\n21	16	12	6	8	10	11	12	13	15\n21	16	12	4	1	4	15	4762	5	2\n21	16	13	6	9	11	12	13	14	15	21\n21	16	13	21	2	11	19	4655	3	13	1\n21	16	14	6	8	10	12	13	14	16\n21	16	14	3	1	1	5	14	2317	5\n21	16	15	6	9	12	13	14	15	16	21\n21	16	15	5	3	1	2	6	3417	1	1\n21	16	16	10	14	15	16	18	20	37\n21	16	16	2	1	4	751	1	1	1\n21	16	17	11	17\n21	16	17	2	12\n21	16	18	14	18\n21	16	18	1	4\n21	16	20	20\n21	16	20	522\n21	16	21	21\n21	16	21	4\n21	16	37	20	35	37\n21	16	37	1	1	6\n21	17	0	0\n21	17	0	5\n21	17	6	6	9	17\n21	17	6	2654	36	1\n21	17	7	7	9\n21	17	7	377	2\n21	17	8	7	8	9\n21	17	8	2	964	3\n21	17	9	6	7	8	9	12	13\n21	17	9	2	1	4	2135	1	1\n21	17	10	9	10	12\n21	17	10	6	1178	1\n21	17	11	6	8	9	10	11	12	13	14\n21	17	11	3	1	2	7	6510	26	1	1\n21	17	12	6	9	10	11	12	13	16	18\n21	17	12	2	2	3	15	4786	1	1	2\n21	17	13	6	11	12	13	14	15\n21	17	13	3	6	27	4623	2	16\n21	17	14	11	12	13	14	16	19\n21	17	14	3	2	15	2305	4	1\n21	17	15	6	13	14	15	16	21\n21	17	15	1	5	11	3409	8	2\n21	17	16	12	14	15	16	20\n21	17	16	1	2	6	746	2\n21	17	17	17\n21	17	17	12\n21	17	18	18	21	24\n21	17	18	3	1	1\n21	17	20	20\n21	17	20	524\n21	17	21	21\n21	17	21	6\n21	17	35	32\n21	17	35	1\n21	17	37	20	37\n21	17	37	1	6\n21	18	0	0\n21	18	0	5\n21	18	6	6	9\n21	18	6	2656	9\n21	18	7	7	8\n21	18	7	379	1\n21	18	8	7	8\n21	18	8	1	968\n21	18	9	6	7	8	9	10	11\n21	18	9	2	1	3	2177	1	2\n21	18	10	8	9	10\n21	18	10	1	8	1179\n21	18	11	6	10	11	12	13\n21	18	11	2	8	6496	24	4\n21	18	12	10	11	12	13	15\n21	18	12	1	18	4822	2	1\n21	18	13	6	9	11	12	13	14	15\n21	18	13	2	1	9	26	4576	4	28\n21	18	14	9	11	12	13	14	16	17\n21	18	14	1	1	6	18	2286	8	1\n21	18	15	12	13	14	15	16	18\n21	18	15	1	4	8	3409	8	1\n21	18	16	12	15	16\n21	18	16	1	11	747\n21	18	17	17\n21	18	17	13\n21	18	18	18	21\n21	18	18	3	2\n21	18	19	19\n21	18	19	1\n21	18	20	20\n21	18	20	527\n21	18	21	21\n21	18	21	9\n21	18	24	24\n21	18	24	1\n21	18	32	32\n21	18	32	1\n21	18	37	37\n21	18	37	6\n21	19	0	0\n21	19	0	5\n21	19	6	6\n21	19	6	2662\n21	19	7	7\n21	19	7	381\n21	19	8	7	8\n21	19	8	32	941\n21	19	9	6	7	8	9\n21	19	9	383	37	46	1730\n21	19	10	7	8	9	10\n21	19	10	8	15	27	1139\n21	19	11	8	9	10	11	12	13	15\n21	19	11	51	35	20	6377	38	3	2\n21	19	12	7	8	9	10	11	12	13	15\n21	19	12	18	39	65	73	420	4257	4	4\n21	19	13	8	9	10	11	12	13	14	15\n21	19	13	14	36	28	83	75	4344	3	21\n21	19	14	9	10	11	12	13	14	16	17\n21	19	14	27	44	79	62	141	1930	14	1\n21	19	15	9	10	11	12	13	14	15	16\n21	19	15	21	17	47	58	525	96	2676	9\n21	19	16	11	12	13	14	15	16	17\n21	19	16	4	11	9	66	34	638	1\n21	19	17	13	17\n21	19	17	1	13\n21	19	18	12	15	18\n21	19	18	2	1	1\n21	19	19	17\n21	19	19	1\n21	19	20	11	12	13	14	15	16	17	20\n21	19	20	2	1	3	5	5	462	4	45\n21	19	21	12	13	15	21\n21	19	21	3	2	5	1\n21	19	24	24\n21	19	24	1\n21	19	32	32\n21	19	32	1\n21	19	37	16	17\n21	19	37	4	2\n21	20	0	0\n21	20	0	5\n21	20	6	6\n21	20	6	3045\n21	20	7	7\n21	20	7	476\n21	20	8	7	8\n21	20	8	14	1092\n21	20	9	6	7	8	9\n21	20	9	240	14	33	1654\n21	20	10	7	8	9	10\n21	20	10	2	6	32	1281\n21	20	11	8	9	10	11	12	13	15	16\n21	20	11	23	25	26	6891	40	4	2	1\n21	20	12	7	8	9	10	11	12	13\n21	20	12	3	7	11	69	207	4207	3\n21	20	13	8	9	10	11	12	13	14	15\n21	20	13	4	17	18	60	61	4844	2	26\n21	20	14	9	10	11	12	13	14	16\n21	20	14	4	9	10	20	99	1945	13\n21	20	15	9	10	11	12	13	14	15	16\n21	20	15	3	3	13	21	241	36	2422	9\n21	20	16	11	12	13	14	15	16\n21	20	16	3	2	8	16	22	1076\n21	20	17	14	17\n21	20	17	1	21\n21	20	18	12\n21	20	18	1\n21	20	20	16	20\n21	20	20	21	24\n21	20	21	16\n21	20	21	1\n21	20	24	15\n21	20	24	1\n21	20	32	32\n21	20	32	1\n22	1	0	0\n22	1	0	4\n22	1	6	6	9\n22	1	6	215	14\n22	1	7	7	8	9	10\n22	1	7	301	5	14	2\n22	1	8	7	8	9	10	11	12\n22	1	8	1	494	4	1	6	4\n22	1	9	8	9	10	11	12	13\n22	1	9	1	868	4	14	6	4\n22	1	10	8	9	10	12	13	14	15\n22	1	10	1	5	293	10	2	4	1\n22	1	11	10	11	12	13	14	15\n22	1	11	9	4232	57	23	3	3\n22	1	12	9	11	12	13	14	15\n22	1	12	3	103	3065	7	19	4\n22	1	13	9	11	12	13	14	15	16	21\n22	1	13	1	11	22	4013	19	41	3	1\n22	1	14	11	12	13	14	15	16\n22	1	14	3	2	11	1571	5	6\n22	1	15	11	12	13	14	15	16	19	21\n22	1	15	2	8	102	3	3024	17	1	4\n22	1	16	14	15	16	20	21	37\n22	1	16	26	12	842	84	6	1\n22	1	17	14	17	23\n22	1	17	1	10	1\n22	1	18	15	18	23\n22	1	18	1	8	1\n22	1	19	19\n22	1	19	2\n22	1	20	20\n22	1	20	75\n22	1	21	21	22\n22	1	21	11	2\n22	1	22	22\n22	1	22	1\n22	1	23	23\n22	1	23	1\n22	1	25	25\n22	1	25	1\n22	1	29	15\n22	1	29	1\n22	1	30	30\n22	1	30	1\n22	1	37	37\n22	1	37	4\n22	2	0	0\n22	2	0	4\n22	2	6	6	9\n22	2	6	193	22\n22	2	7	7	8	9	12\n22	2	7	280	7	13	2\n22	2	8	7	8	9	11	12	13\n22	2	8	2	468	3	5	21	2\n22	2	9	9	10	11	12	13	14	15\n22	2	9	874	3	12	9	7	3	1\n22	2	10	9	10	11	12	13	14\n22	2	10	4	278	2	12	5	8\n22	2	11	9	10	11	12	13	14	15\n22	2	11	1	4	4262	78	13	8	5\n22	2	12	10	11	12	13	14	15	16	21\n22	2	12	1	74	3073	5	11	3	4	3\n22	2	13	9	11	12	13	14	15	16	17\n22	2	13	1	3	16	4033	35	68	5	1\n22	2	14	12	13	14	15	16	19\n22	2	14	2	5	1625	4	9	1\n22	2	15	12	13	14	15	16	21\n22	2	15	7	66	3	3003	6	7\n22	2	16	14	15	16	20	21	37\n22	2	16	15	13	653	184	2	1\n22	2	17	17\n22	2	17	10\n22	2	18	15	18	21\n22	2	18	2	4	2\n22	2	19	19\n22	2	19	3\n22	2	20	16	20	25\n22	2	20	1	156	2\n22	2	21	21\n22	2	21	22\n22	2	22	22\n22	2	22	3\n22	2	23	21	23\n22	2	23	1	2\n22	2	25	23\n22	2	25	1\n22	2	30	30\n22	2	30	1\n22	2	37	37\n22	2	37	5\n22	3	0	0\n22	3	0	4\n22	3	6	6\n22	3	6	193\n22	3	7	7\n22	3	7	282\n22	3	8	8\n22	3	8	475\n22	3	9	7	8	9	10\n22	3	9	1	1	913	3\n22	3	10	9	10\n22	3	10	4	282\n22	3	11	10	11	12	13\n22	3	11	9	4343	1	5\n22	3	12	11	12	13\n22	3	12	70	3146	4\n22	3	13	11	12	13	14	15	17\n22	3	13	5	21	4099	6	4	1\n22	3	14	11	12	13	14\n22	3	14	1	3	8	1696\n22	3	15	12	13	14	15	16\n22	3	15	2	70	3	3022	2\n22	3	16	14	15	16\n22	3	16	19	13	646\n22	3	17	13	17\n22	3	17	2	9\n22	3	18	18\n22	3	18	4\n22	3	19	19\n22	3	19	4\n22	3	20	20\n22	3	20	340\n22	3	21	21\n22	3	21	37\n22	3	22	10	22\n22	3	22	1	2\n22	3	23	23\n22	3	23	3\n22	3	25	25\n22	3	25	2\n22	3	30	32\n22	3	30	1\n22	3	37	37\n22	3	37	6\n22	4	0	0\n22	4	0	4\n22	4	6	6\n22	4	6	193\n22	4	7	7\n22	4	7	283\n22	4	8	8	13\n22	4	8	475	1\n22	4	9	7	8	9	10\n22	4	9	1	2	913	1\n22	4	10	7	8	9	10	12\n22	4	10	1	1	6	286	1\n22	4	11	9	10	11	12	13\n22	4	11	2	10	4399	4	4\n22	4	12	9	11	12	13\n22	4	12	2	71	3099	1\n22	4	13	11	12	13	14	15\n22	4	13	1	18	4155	7	7\n22	4	14	11	12	13	14	16\n22	4	14	2	1	7	1712	2\n22	4	15	12	13	14	15\n22	4	15	1	58	3	2977\n22	4	16	14	15	16\n22	4	16	9	8	631\n22	4	17	17\n22	4	17	10\n22	4	18	15	18\n22	4	18	1	3\n22	4	19	19\n22	4	19	4\n22	4	20	9	20\n22	4	20	1	339\n22	4	21	15	21\n22	4	21	1	36\n22	4	22	22\n22	4	22	2\n22	4	23	19	21	23\n22	4	23	1	1	1\n22	4	25	25\n22	4	25	2\n22	4	32	32\n22	4	32	1\n22	4	37	20	37\n22	4	37	1	5\n22	5	0	0\n22	5	0	4\n22	5	6	6\n22	5	6	193\n22	5	7	7\n22	5	7	285\n22	5	8	7	8\n22	5	8	4	474\n22	5	9	8	9	10\n22	5	9	2	920	2\n22	5	10	8	9	10\n22	5	10	2	5	290\n22	5	11	9	10	11	12	13\n22	5	11	2	9	4460	1	1\n22	5	12	9	11	12	13	14\n22	5	12	1	42	3075	4	2\n22	5	13	8	11	12	13	14	15\n22	5	13	1	3	23	4189	6	4\n22	5	14	12	13	14	16	18\n22	5	14	3	6	1720	1	1\n22	5	15	12	13	14	15\n22	5	15	1	40	5	2948\n22	5	16	14	15	16\n22	5	16	4	4	625\n22	5	17	11	16	17\n22	5	17	1	2	7\n22	5	18	15	18\n22	5	18	1	2\n22	5	19	19\n22	5	19	5\n22	5	20	16	20\n22	5	20	1	339\n22	5	21	15	18	21\n22	5	21	3	2	32\n22	5	22	21	22\n22	5	22	1	1\n22	5	23	21\n22	5	23	1\n22	5	25	25\n22	5	25	2\n22	5	32	32\n22	5	32	1\n22	5	37	37\n22	5	37	5\n22	6	0	0\n22	6	0	4\n22	6	6	6\n22	6	6	193\n22	6	7	7\n22	6	7	289\n22	6	8	7	8\n22	6	8	1	478\n22	6	9	7	8	9	10\n22	6	9	2	3	915	8\n22	6	10	9	10	11	12\n22	6	10	5	294	1	1\n22	6	11	7	9	10	11	12	13	14\n22	6	11	1	2	6	4491	2	3	1\n22	6	12	10	11	12	13	14	15\n22	6	12	3	30	3067	1	1	1\n22	6	13	7	9	11	12	13	14	15\n22	6	13	4	1	3	7	4217	1	7\n22	6	14	12	13	14	16\n22	6	14	3	7	1726	1\n22	6	15	7	12	13	14	15	16\n22	6	15	1	1	24	5	2926	3\n22	6	16	7	12	14	15	16\n22	6	16	1	1	11	8	608\n22	6	17	9	16	17\n22	6	17	1	1	5\n22	6	18	18\n22	6	18	5\n22	6	19	7	10	14	19\n22	6	19	2	1	1	1\n22	6	20	16	20\n22	6	20	1	338\n22	6	21	15	18	21\n22	6	21	11	1	22\n22	6	22	22\n22	6	22	1\n22	6	25	10\n22	6	25	2\n22	6	32	32\n22	6	32	1\n22	6	37	20	37\n22	6	37	1	4\n22	7	0	0\n22	7	0	4\n22	7	6	6\n22	7	6	193\n22	7	7	6	7\n22	7	7	1	300\n22	7	8	6	7	8\n22	7	8	1	1	479\n22	7	9	6	7	8	9	10\n22	7	9	2	3	2	912	5\n22	7	10	9	10	11\n22	7	10	6	307	1\n22	7	11	6	8	9	10	11	12	13\n22	7	11	3	2	1	4	4505	2	8\n22	7	12	9	11	12	13	14	15	18\n22	7	12	1	13	3056	7	3	1	1\n22	7	13	6	9	10	11	12	13	14	15\n22	7	13	8	1	1	1	15	4216	4	6\n22	7	14	10	12	13	14	15	16\n22	7	14	1	4	6	1732	1	2\n22	7	15	6	12	13	14	15	16\n22	7	15	8	1	19	7	2917	1\n22	7	16	6	12	13	14	15	16\n22	7	16	1	2	1	1	5	604\n22	7	17	17\n22	7	17	5\n22	7	18	6	9	18	19\n22	7	18	2	2	1	1\n22	7	19	19\n22	7	19	1\n22	7	20	20\n22	7	20	339\n22	7	21	9	13	15	16	21\n22	7	21	1	1	2	2	16\n22	7	22	22\n22	7	22	1\n22	7	32	32\n22	7	32	1\n22	7	37	37\n22	7	37	4\n22	8	0	0\n22	8	0	4\n22	8	6	6\n22	8	6	219\n22	8	7	6	7\n22	8	7	2	302\n22	8	8	6	7	8\n22	8	8	2	1	480\n22	8	9	6	7	8	9	10\n22	8	9	5	1	2	911	5\n22	8	10	6	9	10\n22	8	10	1	7	310\n22	8	11	6	9	10	11	12	13	14\n22	8	11	12	2	10	4486	5	4	1\n22	8	12	6	8	9	10	11	12	13	14	15\n22	8	12	2	1	1	5	11	3055	3	1	1\n22	8	13	6	9	11	12	13	14	15\n22	8	13	42	4	2	17	4176	7	10\n22	8	14	6	8	10	12	13	14	15	16\n22	8	14	1	1	1	3	2	1734	1	4\n22	8	15	6	9	12	13	14	15\n22	8	15	28	10	3	15	7	2869\n22	8	16	6	9	14	15	16\n22	8	16	1	3	2	9	594\n22	8	17	17\n22	8	17	5\n22	8	18	18\n22	8	18	2\n22	8	19	15\n22	8	19	2\n22	8	20	20\n22	8	20	339\n22	8	21	6	9	21\n22	8	21	3	6	7\n22	8	22	17\n22	8	22	1\n22	8	32	32\n22	8	32	1\n22	8	37	37\n22	8	37	4\n22	9	0	0\n22	9	0	4\n22	9	6	6	9\n22	9	6	317	1\n22	9	7	6	7	10\n22	9	7	1	302	1\n22	9	8	6	7	8\n22	9	8	2	1	481\n22	9	9	6	7	8	9	10\n22	9	9	4	3	3	929	5\n22	9	10	6	9	10	11\n22	9	10	2	6	322	1\n22	9	11	6	9	10	11	12	13\n22	9	11	3	1	7	4479	6	3\n22	9	12	6	8	9	10	11	12	14\n22	9	12	4	1	2	4	18	3053	1\n22	9	13	6	9	11	12	13	14	15\n22	9	13	23	4	4	16	4137	5	11\n22	9	14	9	12	14	16\n22	9	14	2	2	1747	1\n22	9	15	6	9	13	14	15\n22	9	15	11	2	14	5	2860\n22	9	16	9	10	14	15	16\n22	9	16	2	1	1	3	591\n22	9	17	17\n22	9	17	6\n22	9	18	12	18\n22	9	18	1	1\n22	9	20	14	15	16	20\n22	9	20	1	1	2	335\n22	9	21	6	9	21\n22	9	21	1	2	4\n22	9	32	29\n22	9	32	1\n22	9	37	37\n22	9	37	4\n22	10	0	0\n22	10	0	4\n22	10	6	6	9\n22	10	6	359	9\n22	10	7	7\n22	10	7	306\n22	10	8	7	8	11	13\n22	10	8	1	482	1	1\n22	10	9	6	7	9	10\n22	10	9	4	1	945	1\n22	10	10	7	9	10\n22	10	10	1	4	335\n22	10	11	6	9	10	11	12	13\n22	10	11	3	2	5	4486	5	1\n22	10	12	9	10	11	12	13	15\n22	10	12	2	4	14	3056	1	1\n22	10	13	6	8	9	11	12	13	14	15\n22	10	13	16	1	1	3	15	4108	3	7\n22	10	14	10	12	13	14\n22	10	14	1	9	4	1746\n22	10	15	6	9	11	12	13	14	15	16\n22	10	15	2	1	1	3	49	5	2813	1\n22	10	16	14	15	16\n22	10	16	2	3	589\n22	10	17	16	17\n22	10	17	1	5\n22	10	18	15\n22	10	18	1\n22	10	20	15	16	20\n22	10	20	2	7	326\n22	10	21	13	21\n22	10	21	1	3\n22	10	29	13\n22	10	29	1\n22	10	37	16	37\n22	10	37	1	3\n22	11	0	0\n22	11	0	4\n22	11	6	6	9\n22	11	6	381	3\n22	11	7	6	7	8	9	10\n22	11	7	7	298	1	2	1\n22	11	8	6	7	8\n22	11	8	8	2	473\n22	11	9	6	7	8	9	13\n22	11	9	16	2	7	938	1\n22	11	10	9	10	12\n22	11	10	9	335	2\n22	11	11	6	8	9	10	11	12	13\n22	11	11	29	1	6	22	4439	7	1\n22	11	12	6	8	9	10	11	12	13	14	15\n22	11	12	3	1	3	6	17	3055	1	1	1\n22	11	13	6	9	10	11	12	13	14	15\n22	11	13	98	15	2	5	21	4018	4	3\n22	11	14	6	8	9	11	12	13	14	16\n22	11	14	8	5	4	1	11	22	1703	2\n22	11	15	6	8	9	13	14	15\n22	11	15	47	2	25	47	6	2700\n22	11	16	8	10	11	13	14	15	16\n22	11	16	2	4	1	1	5	13	573\n22	11	17	17\n22	11	17	5\n22	11	20	14	15	16	20\n22	11	20	1	2	26	297\n22	11	21	21\n22	11	21	3\n22	11	37	37\n22	11	37	3\n22	12	0	0\n22	12	0	4\n22	12	6	6	8	9	11\n22	12	6	588	1	5	3\n22	12	7	6	7	9\n22	12	7	16	281	5\n22	12	8	6	8	9\n22	12	8	17	472	3\n22	12	9	6	7	8	9	13\n22	12	9	48	3	3	950	1\n22	12	10	6	8	9	10	12\n22	12	10	14	2	8	344	2\n22	12	11	6	8	9	10	11	12	13\n22	12	11	65	1	8	79	4280	29	1\n22	12	12	6	8	9	10	11	12	15\n22	12	12	27	7	3	56	12	2990	1\n22	12	13	6	8	9	10	11	12	13	14	15	18\n22	12	13	350	3	32	3	5	17	3676	1	3	1\n22	12	14	6	8	9	10	11	12	13	14	16\n22	12	14	16	33	8	16	4	7	7	1626	3\n22	12	15	6	8	9	10	12	13	14	15\n22	12	15	121	5	97	5	3	35	4	2449\n22	12	16	8	9	10	11	14	15	16	20\n22	12	16	10	4	8	4	3	6	565	1\n22	12	17	17\n22	12	17	5\n22	12	20	14	15	16	20\n22	12	20	2	1	34	260\n22	12	21	21\n22	12	21	3\n22	12	37	37\n22	12	37	3\n22	13	0	0\n22	13	0	4\n22	13	6	6	7	8	9\n22	13	6	1234	1	1	26\n22	13	7	6	7\n22	13	7	11	273\n22	13	8	6	8	9	10\n22	13	8	15	519	2	1\n22	13	9	6	8	9\n22	13	9	43	12	1068\n22	13	10	6	8	9	10	12	16\n22	13	10	3	1	5	500	1	1\n22	13	11	6	7	8	9	10	11	12	13\n22	13	11	68	1	5	7	91	4085	50	1\n22	13	12	6	8	9	10	11	12	13\n22	13	12	23	13	6	56	10	2939	1\n22	13	13	6	8	9	10	11	12	13	14	15	18\n22	13	13	355	4	28	5	5	15	3303	1	3	1\n22	13	14	6	8	9	10	11	12	13	14	16\n22	13	14	17	58	7	26	19	7	6	1485	11\n22	13	15	6	8	9	10	11	12	13	14	15	16\n22	13	15	107	6	79	21	2	5	21	5	2213	1\n22	13	16	8	9	10	11	12	13	14	15	16\n22	13	16	23	11	14	13	6	3	7	8	517\n22	13	17	17\n22	13	17	5\n22	13	18	18\n22	13	18	1\n22	13	20	9	15	16	17	20\n22	13	20	1	2	11	1	246\n22	13	21	21\n22	13	21	3\n22	13	37	37\n22	13	37	3\n22	14	0	0\n22	14	0	4\n22	14	6	6	7	9\n22	14	6	1779	1	96\n22	14	7	6	7	9\n22	14	7	6	268	1\n22	14	8	6	7	8	9\n22	14	8	4	1	624	13\n22	14	9	6	7	8	9	10	11\n22	14	9	23	2	7	1206	1	1\n22	14	10	6	8	9	10	11	12\n22	14	10	4	2	7	698	1	2\n22	14	11	6	7	8	9	10	11	12	13	14	16\n22	14	11	38	1	3	3	69	3996	21	1	1	1\n22	14	12	6	8	9	10	11	12	13\n22	14	12	20	15	1	32	9	2941	5\n22	14	13	6	8	9	10	11	12	13	14	15	18\n22	14	13	213	1	12	10	6	9	3079	1	3	1\n22	14	14	6	8	9	10	11	12	13	14	16\n22	14	14	5	48	3	23	7	6	8	1397	1\n22	14	15	6	8	9	10	11	13	14	15\n22	14	15	56	8	41	11	1	8	3	2098\n22	14	16	8	9	10	11	12	13	14	15	16	22\n22	14	16	14	10	15	12	5	3	2	3	476	1\n22	14	17	13	17\n22	14	17	1	5\n22	14	18	13	18\n22	14	18	1	1\n22	14	20	10	15	16	17	20\n22	14	20	1	1	3	1	240\n22	14	21	21\n22	14	21	3\n22	14	37	37\n22	14	37	3\n22	15	0	0\n22	15	0	4\n22	15	6	6	7	9\n22	15	6	2039	8	101\n22	15	7	6	7\n22	15	7	1	272\n22	15	8	6	7	8	9	10\n22	15	8	7	1	701	10	3\n22	15	9	6	7	8	9\n22	15	9	14	3	4	1372\n22	15	10	6	8	9	10	11	12\n22	15	10	1	1	6	841	2	9\n22	15	11	6	7	8	9	10	11	12	13\n22	15	11	22	1	3	4	35	3959	8	1\n22	15	12	6	8	10	11	12	13	15\n22	15	12	9	9	15	4	2943	2	2\n22	15	13	6	8	9	10	11	12	13	15\n22	15	13	103	2	6	5	5	19	2961	5\n22	15	14	6	8	9	10	11	12	13	14\n22	15	14	8	22	1	18	3	4	7	1341\n22	15	15	6	8	9	10	11	12	13	14	15	16\n22	15	15	15	5	23	6	2	2	8	3	2038	3\n22	15	16	8	9	10	11	12	14	15	16\n22	15	16	7	6	5	3	1	2	3	454\n22	15	17	17\n22	15	17	6\n22	15	18	18\n22	15	18	2\n22	15	20	13	20\n22	15	20	1	239\n22	15	21	21\n22	15	21	3\n22	15	22	22\n22	15	22	1\n22	15	37	37\n22	15	37	3\n22	16	0	0\n22	16	0	4\n22	16	6	6	7	9\n22	16	6	2161	3	55\n22	16	7	6	7\n22	16	7	1	284\n22	16	8	6	7	8	9	12\n22	16	8	4	1	739	9	1\n22	16	9	6	7	8	9\n22	16	9	6	1	3	1519\n22	16	10	6	8	9	10	11	12	13\n22	16	10	1	1	4	911	1	9	1\n22	16	11	6	8	9	10	11	12\n22	16	11	20	2	4	7	3933	12\n22	16	12	6	8	10	11	12	13	14	15	16\n22	16	12	10	2	12	8	2949	2	1	1	1\n22	16	13	6	8	9	11	12	13	14	15\n22	16	13	46	1	4	6	13	2903	1	6\n22	16	14	6	8	10	11	13	14	16	17\n22	16	14	1	5	2	3	7	1326	1	1\n22	16	15	6	8	9	13	14	15	16\n22	16	15	17	1	13	2	4	2009	2\n22	16	16	8	10	11	15	16\n22	16	16	2	2	1	3	449\n22	16	17	17\n22	16	17	6\n22	16	18	17	22\n22	16	18	1	1\n22	16	20	20\n22	16	20	239\n22	16	21	21\n22	16	21	3\n22	16	22	21\n22	16	22	1\n22	16	37	20	37\n22	16	37	1	2\n22	17	0	0\n22	17	0	4\n22	17	6	6	9\n22	17	6	2227	40\n22	17	7	7	8	9	11\n22	17	7	280	3	3	3\n22	17	8	7	8	9	11	13	14\n22	17	8	2	749	2	1	1	1\n22	17	9	7	8	9	10\n22	17	9	2	6	1599	1\n22	17	10	9	10	12	15\n22	17	10	6	922	5	1\n22	17	11	6	7	8	9	10	11	12	14	15\n22	17	11	6	1	2	3	12	3913	12	2	1\n22	17	12	6	7	8	9	10	11	12	13	14	21\n22	17	12	5	1	1	1	2	7	2961	4	1	1\n22	17	13	6	9	11	12	13	14	15	18\n22	17	13	13	1	6	10	2874	1	9	1\n22	17	14	6	9	11	13	14	16\n22	17	14	2	1	1	6	1320	2\n22	17	15	6	12	13	14	15	16	21\n22	17	15	6	1	2	5	2002	2	1\n22	17	16	14	15	16\n22	17	16	1	2	450\n22	17	17	17\n22	17	17	8\n22	17	20	20\n22	17	20	240\n22	17	21	21\n22	17	21	4\n22	17	22	18\n22	17	22	1\n22	17	37	37\n22	17	37	2\n22	18	0	0\n22	18	0	4\n22	18	6	6	9\n22	18	6	2232	27\n22	18	7	6	7	9\n22	18	7	1	284	1\n22	18	8	7	8	9	12\n22	18	8	1	758	1	1\n22	18	9	6	8	9	11\n22	18	9	1	2	1652	1\n22	18	10	9	10	12\n22	18	10	6	930	1\n22	18	11	6	8	9	10	11	12	13\n22	18	11	2	1	1	6	3901	19	1\n22	18	12	6	9	11	12	13	16	18\n22	18	12	2	1	7	2974	2	1	2\n22	18	13	6	11	12	13	14	15	17\n22	18	13	1	5	11	2856	1	12	1\n22	18	14	11	12	13	14	16\n22	18	14	2	3	12	1311	3\n22	18	15	6	11	13	14	15	21\n22	18	15	1	1	4	7	2001	1\n22	18	16	11	12	16\n22	18	16	1	1	452\n22	18	17	10	17	21\n22	18	17	1	6	1\n22	18	18	16	22\n22	18	18	1	1\n22	18	20	20\n22	18	20	240\n22	18	21	16	19	21\n22	18	21	1	1	4\n22	18	37	37\n22	18	37	2\n22	19	0	0\n22	19	0	4\n22	19	6	6	9\n22	19	6	2237	3\n22	19	7	7\n22	19	7	285\n22	19	8	7	8\n22	19	8	2	759\n22	19	9	7	8	9	11	12\n22	19	9	1	4	1682	1	1\n22	19	10	9	10\n22	19	10	10	927\n22	19	11	8	9	10	11	12\n22	19	11	1	2	4	3899	12\n22	19	12	10	11	12	13	14	15\n22	19	12	2	10	2993	3	1	1\n22	19	13	10	11	12	13	15\n22	19	13	1	5	6	2852	11\n22	19	14	12	13	14	16	18\n22	19	14	6	8	1300	4	1\n22	19	15	13	14	15	16	18\n22	19	15	5	4	1998	5	1\n22	19	16	14	15	16	21\n22	19	16	1	3	452	2\n22	19	17	17\n22	19	17	7\n22	19	18	18\n22	19	18	2\n22	19	19	18\n22	19	19	1\n22	19	20	20\n22	19	20	240\n22	19	21	21\n22	19	21	6\n22	19	22	22\n22	19	22	1\n22	19	37	37\n22	19	37	2\n22	20	0	0\n22	20	0	4\n22	20	6	6\n22	20	6	2237\n22	20	7	7\n22	20	7	288\n22	20	8	7	8\n22	20	8	26	738\n22	20	9	6	7	8	9	10\n22	20	9	318	26	35	1317	1\n22	20	10	7	8	9	10	11\n22	20	10	2	7	18	906	1\n22	20	11	8	9	10	11	12	15\n22	20	11	35	30	17	3821	11	1\n22	20	12	7	8	9	10	11	12	13	15\n22	20	12	6	21	42	69	282	2591	6	1\n22	20	13	8	9	10	11	12	13	14	15	17\n22	20	13	10	28	15	61	53	2682	1	17	1\n22	20	14	9	10	11	12	13	14	16\n22	20	14	19	33	54	37	90	1068	5\n22	20	15	9	10	11	12	13	14	15	16\n22	20	15	6	12	28	31	298	49	1584	5\n22	20	16	11	12	13	14	15	16\n22	20	16	7	5	11	37	28	373\n22	20	17	17\n22	20	17	7\n22	20	18	12	14	18\n22	20	18	2	2	1\n22	20	20	14	15	16	20\n22	20	20	1	1	218	20\n22	20	21	12	13	15	17	21\n22	20	21	3	1	1	1	2\n22	20	22	21\n22	20	22	1\n22	20	37	16	20\n22	20	37	1	1\n22	21	0	0\n22	21	0	4\n22	21	6	6\n22	21	6	2555\n22	21	7	7\n22	21	7	348\n22	21	8	7	8\n22	21	8	14	832\n22	21	9	6	7	8	9	10\n22	21	9	197	8	28	1226	1\n22	21	10	8	9	10\n22	21	10	6	17	1030\n22	21	11	6	8	9	10	11	12	13\n22	21	11	1	17	22	19	4163	27	5\n22	21	12	8	9	10	11	12	13	15\n22	21	12	9	11	59	130	2517	4	3\n22	21	13	8	9	10	11	12	13	14	15\n22	21	13	6	8	8	40	30	2965	4	27\n22	21	14	9	10	11	12	13	14	15	16\n22	21	14	3	9	11	18	56	1056	1	4\n22	21	15	9	10	11	12	13	14	15	16\n22	21	15	1	3	7	6	118	14	1477	7\n22	21	16	11	12	13	14	15	16	17\n22	21	16	2	1	2	13	13	570	1\n22	21	17	17\n22	21	17	9\n22	21	18	18\n22	21	18	1\n22	21	20	14	16	20\n22	21	20	1	8	12\n22	21	21	12	15	21\n22	21	21	1	1	1\n23	1	0	0\n23	1	0	4\n23	1	6	6	9\n23	1	6	142	10\n23	1	7	7	8	9	10	12\n23	1	7	216	3	2	1	1\n23	1	8	8	9	11	12	13\n23	1	8	300	3	2	8	1\n23	1	9	7	8	9	10	11	12	13\n23	1	9	2	2	508	4	6	6	6\n23	1	10	9	10	11	12	13	14	15\n23	1	10	3	196	4	5	2	5	2\n23	1	11	9	10	11	12	13	14	15	16\n23	1	11	1	7	2658	34	12	1	5	1\n23	1	12	11	12	13	14	15\n23	1	12	58	1930	4	12	2\n23	1	13	9	11	12	13	14	15\n23	1	13	1	4	14	2597	13	35\n23	1	14	11	12	13	14	15	16\n23	1	14	1	3	3	963	6	3\n23	1	15	13	14	15	16	17	21\n23	1	15	59	4	2052	4	1	2\n23	1	16	14	15	16	20	21	37\n23	1	16	15	6	463	41	1	1\n23	1	17	14	17	23	37\n23	1	17	1	5	1	1\n23	1	18	18	23\n23	1	18	4	1\n23	1	19	19	26\n23	1	19	1	1\n23	1	20	20\n23	1	20	43\n23	1	21	21\n23	1	21	10\n23	1	23	23\n23	1	23	1\n23	1	25	25\n23	1	25	1\n23	1	29	29\n23	1	29	1\n23	1	37	37\n23	1	37	2\n23	2	0	0\n23	2	0	4\n23	2	6	6	9\n23	2	6	127	15\n23	2	7	7	8	9	12\n23	2	7	202	5	10	1\n23	2	8	7	8	11	12	13\n23	2	8	1	285	7	10	2\n23	2	9	7	8	9	10	11	12	13	14\n23	2	9	1	1	497	9	8	5	2	5\n23	2	10	9	10	11	12	14	15\n23	2	10	5	186	2	7	5	3\n23	2	11	10	11	12	13	14	15\n23	2	11	4	2656	56	10	2	5\n23	2	12	11	12	13	14	15\n23	2	12	41	1942	7	8	3\n23	2	13	11	12	13	14	15	16\n23	2	13	4	13	2600	12	52	3\n23	2	14	13	14	15	16\n23	2	14	9	994	8	3\n23	2	15	11	12	13	14	15	16	21\n23	2	15	3	1	61	4	2031	3	5\n23	2	16	13	14	15	16	20\n23	2	16	1	13	9	356	92\n23	2	17	16	17\n23	2	17	1	5\n23	2	18	18\n23	2	18	4\n23	2	19	19\n23	2	19	1\n23	2	20	20\n23	2	20	84\n23	2	21	21\n23	2	21	13\n23	2	23	23\n23	2	23	3\n23	2	25	23\n23	2	25	1\n23	2	26	26\n23	2	26	1\n23	2	29	32\n23	2	29	1\n23	2	37	37\n23	2	37	4\n23	3	0	0\n23	3	0	4\n23	3	6	6\n23	3	6	127\n23	3	7	7\n23	3	7	204\n23	3	8	7	8\n23	3	8	1	290\n23	3	9	7	8	9	11\n23	3	9	2	3	521	1\n23	3	10	9	10	11\n23	3	10	7	191	1\n23	3	11	10	11	12	13\n23	3	11	5	2711	2	3\n23	3	12	11	12	13\n23	3	12	35	1999	1\n23	3	13	11	12	13	14	15\n23	3	13	1	16	2670	2	3\n23	3	14	13	14\n23	3	14	4	1039\n23	3	15	12	13	14	15	16\n23	3	15	1	48	3	2057	2\n23	3	16	14	15	16\n23	3	16	5	11	350\n23	3	17	17\n23	3	17	5\n23	3	18	18\n23	3	18	4\n23	3	19	19\n23	3	19	1\n23	3	20	20\n23	3	20	176\n23	3	21	21\n23	3	21	18\n23	3	23	23\n23	3	23	4\n23	3	26	26\n23	3	26	1\n23	3	32	32\n23	3	32	1\n23	3	37	37\n23	3	37	4\n23	4	0	0\n23	4	0	4\n23	4	6	6\n23	4	6	127\n23	4	7	7\n23	4	7	207\n23	4	8	8\n23	4	8	293\n23	4	9	8	9	10\n23	4	9	3	523	2\n23	4	10	9	10\n23	4	10	4	192\n23	4	11	9	10	11	13	14\n23	4	11	2	4	2741	1	1\n23	4	12	11	12	13\n23	4	12	34	1982	2\n23	4	13	12	13	14	15\n23	4	13	10	2710	4	2\n23	4	14	11	12	13	14\n23	4	14	1	4	5	1039\n23	4	15	12	13	14	15	16\n23	4	15	1	32	1	2036	1\n23	4	16	14	15	16\n23	4	16	2	6	344\n23	4	17	16	17\n23	4	17	2	3\n23	4	18	13	18\n23	4	18	1	3\n23	4	19	19\n23	4	19	1\n23	4	20	18	20\n23	4	20	1	175\n23	4	21	21\n23	4	21	18\n23	4	23	23\n23	4	23	4\n23	4	26	26\n23	4	26	1\n23	4	32	33\n23	4	32	1\n23	4	37	37\n23	4	37	4\n23	5	0	0\n23	5	0	4\n23	5	6	6\n23	5	6	127\n23	5	7	7\n23	5	7	207\n23	5	8	7	8\n23	5	8	1	295\n23	5	9	9	10\n23	5	9	527	2\n23	5	10	9	10\n23	5	10	1	197\n23	5	11	10	11	12	13\n23	5	11	4	2769	1	2\n23	5	12	11	12	13\n23	5	12	23	1973	1\n23	5	13	8	11	12	13	14	15\n23	5	13	1	4	11	2726	3	6\n23	5	14	11	12	13	14\n23	5	14	1	1	5	1040\n23	5	15	12	13	14	15	16\n23	5	15	1	26	1	2014	2\n23	5	16	14	15	16\n23	5	16	4	5	338\n23	5	17	15	17\n23	5	17	1	2\n23	5	18	18\n23	5	18	4\n23	5	19	19\n23	5	19	1\n23	5	20	20\n23	5	20	175\n23	5	21	21\n23	5	21	18\n23	5	23	11	15	23\n23	5	23	1	1	2\n23	5	26	17\n23	5	26	1\n23	5	33	33\n23	5	33	1\n23	5	37	37\n23	5	37	4\n23	6	0	0\n23	6	0	4\n23	6	6	6\n23	6	6	127\n23	6	7	7\n23	6	7	208\n23	6	8	7	8\n23	6	8	1	295\n23	6	9	6	8	9	10\n23	6	9	2	1	520	5\n23	6	10	9	10\n23	6	10	2	201\n23	6	11	7	9	10	11	12	13\n23	6	11	2	3	2	2785	1	5\n23	6	12	9	10	11	12	13	14\n23	6	12	1	1	16	1966	1	2\n23	6	13	7	9	11	12	13	14	15\n23	6	13	2	1	1	10	2739	2	5\n23	6	14	12	13	14	16\n23	6	14	3	4	1040	1\n23	6	15	13	14	15	16\n23	6	15	7	5	2014	1\n23	6	16	14	15	16\n23	6	16	2	4	334\n23	6	17	16	17\n23	6	17	1	2\n23	6	18	7	18\n23	6	18	1	3\n23	6	19	9\n23	6	19	1\n23	6	20	20\n23	6	20	175\n23	6	21	15	18	21\n23	6	21	4	1	13\n23	6	23	23\n23	6	23	2\n23	6	33	37\n23	6	33	1\n23	6	37	37\n23	6	37	4\n23	7	0	0\n23	7	0	4\n23	7	6	6\n23	7	6	129\n23	7	7	7\n23	7	7	214\n23	7	8	7	8\n23	7	8	1	295\n23	7	9	6	8	9	11\n23	7	9	1	3	523	1\n23	7	10	9	10\n23	7	10	1	208\n23	7	11	6	9	10	11	12	13\n23	7	11	1	3	5	2790	2	1\n23	7	12	9	10	11	12	13	15\n23	7	12	1	1	16	1959	2	1\n23	7	13	6	9	11	12	13	14	15\n23	7	13	5	2	1	6	2733	4	5\n23	7	14	10	12	14\n23	7	14	1	2	1048\n23	7	15	6	9	13	14	15\n23	7	15	2	1	12	3	2009\n23	7	16	13	14	15	16\n23	7	16	1	2	8	326\n23	7	17	17\n23	7	17	2\n23	7	18	6	9	18\n23	7	18	1	1	2\n23	7	20	20\n23	7	20	175\n23	7	21	13	15	21\n23	7	21	1	7	5\n23	7	23	9\n23	7	23	2\n23	7	37	37\n23	7	37	5\n23	8	0	0\n23	8	0	4\n23	8	6	6	9\n23	8	6	138	1\n23	8	7	6	7\n23	8	7	3	212\n23	8	8	6	7	8	9\n23	8	8	2	1	294	1\n23	8	9	6	7	8	9	10	11\n23	8	9	7	3	3	518	2	1\n23	8	10	9	10\n23	8	10	3	212\n23	8	11	6	9	10	11	12	13\n23	8	11	5	1	8	2788	2	4\n23	8	12	10	11	12	13	15\n23	8	12	4	7	1955	2	1\n23	8	13	6	9	11	12	13	14	15\n23	8	13	26	3	2	11	2698	4	6\n23	8	14	6	12	13	14\n23	8	14	2	3	6	1046\n23	8	15	6	9	13	14	15\n23	8	15	16	5	6	2	2001\n23	8	16	9	10	14	15	16\n23	8	16	3	1	2	3	317\n23	8	17	17\n23	8	17	2\n23	8	18	6\n23	8	18	2\n23	8	20	16	20\n23	8	20	1	174\n23	8	21	6	9	21\n23	8	21	1	1	3\n23	8	37	20	37\n23	8	37	1	4\n23	9	0	0\n23	9	0	4\n23	9	6	6\n23	9	6	202\n23	9	7	6	7\n23	9	7	3	213\n23	9	8	6	8\n23	9	8	5	292\n23	9	9	6	7	8	9	10\n23	9	9	5	3	1	523	4\n23	9	10	6	8	9	10\n23	9	10	2	1	3	221\n23	9	11	6	8	9	10	11	12	13\n23	9	11	4	1	3	5	2775	7	3\n23	9	12	6	10	11	12	13	14\n23	9	12	2	1	12	1953	2	1\n23	9	13	6	9	11	12	13	15\n23	9	13	26	4	3	7	2670	6\n23	9	14	11	12	13	14	16\n23	9	14	3	1	5	1043	2\n23	9	15	6	9	13	14	15	16\n23	9	15	17	5	5	3	1980	1\n23	9	16	9	13	15	16\n23	9	16	1	1	3	313\n23	9	17	17\n23	9	17	2\n23	9	20	20\n23	9	20	175\n23	9	21	6	9	21\n23	9	21	1	1	1\n23	9	37	37\n23	9	37	4\n23	10	0	0\n23	10	0	4\n23	10	6	6	9\n23	10	6	262	5\n23	10	7	7\n23	10	7	216\n23	10	8	6	8	9\n23	10	8	1	293	1\n23	10	9	6	7	8	9\n23	10	9	1	3	2	534\n23	10	10	7	9	10	12\n23	10	10	1	3	226	1\n23	10	11	6	10	11	12	13	15\n23	10	11	1	5	2779	5	1	2\n23	10	12	6	10	11	12	13	15\n23	10	12	3	4	8	1951	1	1\n23	10	13	6	9	11	12	13	14	15\n23	10	13	5	2	3	12	2657	2	5\n23	10	14	6	9	10	13	14	16\n23	10	14	1	1	1	4	1038	2\n23	10	15	6	9	12	13	14	15	16\n23	10	15	2	2	1	18	2	1963	1\n23	10	16	10	15	16\n23	10	16	1	2	313\n23	10	17	17\n23	10	17	2\n23	10	20	14	16	20\n23	10	20	1	3	171\n23	10	21	21\n23	10	21	1\n23	10	37	37\n23	10	37	4\n23	11	0	0\n23	11	0	4\n23	11	6	6	9\n23	11	6	272	4\n23	11	7	6	7\n23	11	7	1	219\n23	11	8	7	8\n23	11	8	1	294\n23	11	9	6	8	9	11\n23	11	9	6	1	540	1\n23	11	10	6	9	10\n23	11	10	1	2	234\n23	11	11	6	10	11	12	13\n23	11	11	14	7	2762	5	2\n23	11	12	6	8	10	11	12\n23	11	12	5	2	5	12	1946\n23	11	13	6	8	9	10	11	12	13	14	15\n23	11	13	32	1	4	1	2	13	2622	2	4\n23	11	14	6	8	9	10	11	12	13	14	16\n23	11	14	1	2	1	1	1	1	5	1030	1\n23	11	15	6	9	11	12	13	14	15	16\n23	11	15	6	7	1	1	38	3	1916	1\n23	11	16	14	15	16\n23	11	16	4	5	310\n23	11	17	17\n23	11	17	2\n23	11	20	15	16	20\n23	11	20	1	15	155\n23	11	21	21\n23	11	21	1\n23	11	37	16	20	37\n23	11	37	1	1	2\n23	12	0	0\n23	12	0	4\n23	12	6	6	8	9\n23	12	6	334	1	3\n23	12	7	6	7\n23	12	7	12	208\n23	12	8	6	7	8	9\n23	12	8	16	1	282	1\n23	12	9	6	7	8	9	11\n23	12	9	35	3	4	515	1\n23	12	10	6	9	10	12\n23	12	10	2	5	240	1\n23	12	11	6	8	9	10	11	12	15\n23	12	11	33	5	4	32	2689	15	1\n23	12	12	6	8	9	10	11	12	13\n23	12	12	3	2	3	17	7	1933	1\n23	12	13	6	9	10	11	12	13	14	15\n23	12	13	184	19	2	8	8	2438	4	4\n23	12	14	6	8	9	10	11	12	13	14	16\n23	12	14	9	13	4	4	2	10	3	992	2\n23	12	15	6	8	9	10	12	13	14	15	16\n23	12	15	58	1	44	1	2	32	3	1784	1\n23	12	16	8	10	13	14	15	16\n23	12	16	3	1	1	4	3	316\n23	12	17	17\n23	12	17	2\n23	12	20	14	15	16	20\n23	12	20	3	1	19	133\n23	12	21	21\n23	12	21	1\n23	12	37	37\n23	12	37	2\n23	13	0	0\n23	13	0	4\n23	13	6	6	7	8	9\n23	13	6	671	5	1	9\n23	13	7	6	7	9\n23	13	7	11	200	1\n23	13	8	6	8	9\n23	13	8	20	289	2\n23	13	9	6	7	8	9	10\n23	13	9	36	6	6	549	1\n23	13	10	6	8	9	10	11	12\n23	13	10	10	1	5	279	1	1\n23	13	11	6	8	9	10	11	12\n23	13	11	51	3	7	70	2549	27\n23	13	12	6	8	9	10	11	12\n23	13	12	18	9	4	42	12	1884\n23	13	13	6	8	9	10	11	12	13	14	15\n23	13	13	316	4	18	3	1	4	2124	2	3\n23	13	14	6	8	9	10	11	12	13	14	16\n23	13	14	11	48	5	12	5	4	6	911	4\n23	13	15	6	8	9	10	11	12	13	14	15	16\n23	13	15	95	5	64	9	1	1	20	4	1593	1\n23	13	16	8	9	10	11	12	14	16\n23	13	16	13	11	14	11	4	1	284\n23	13	17	17\n23	13	17	2\n23	13	20	14	16	17	20\n23	13	20	2	12	1	118\n23	13	21	12\n23	13	21	1\n23	13	37	37\n23	13	37	2\n23	14	0	0\n23	14	0	4\n23	14	6	6	9\n23	14	6	1196	43\n23	14	7	6	7\n23	14	7	7	204\n23	14	8	6	8	9\n23	14	8	16	359	4\n23	14	9	6	7	8	9\n23	14	9	29	1	3	642\n23	14	10	6	8	9	10	12\n23	14	10	6	1	6	416	1\n23	14	11	6	8	9	10	11	12\n23	14	11	39	7	2	52	2454	26\n23	14	12	6	8	10	11	12	14	18\n23	14	12	24	14	36	6	1844	1	1\n23	14	13	6	8	9	10	11	12	13\n23	14	13	222	5	14	14	2	11	1882\n23	14	14	6	8	9	10	11	12	13	14	16\n23	14	14	8	56	3	15	14	6	3	811	4\n23	14	15	6	8	9	10	12	13	14	15	16\n23	14	15	78	3	68	7	1	10	1	1427	1\n23	14	16	8	9	10	11	12	14	15	16\n23	14	16	14	12	16	14	3	3	2	237\n23	14	17	17\n23	14	17	3\n23	14	20	10	11	16	20\n23	14	20	2	1	1	114\n23	14	37	37\n23	14	37	2\n23	15	0	0\n23	15	0	4\n23	15	6	6	7	9\n23	15	6	1553	2	70\n23	15	7	6	7	9\n23	15	7	6	198	1\n23	15	8	6	8	9	10\n23	15	8	7	444	9	2\n23	15	9	6	8	9\n23	15	9	14	4	776\n23	15	10	6	8	9	10	12	13\n23	15	10	1	3	3	548	2	1\n23	15	11	6	7	8	9	10	11	12	13\n23	15	11	27	1	13	3	32	2398	16	1\n23	15	12	6	8	10	11	12	13\n23	15	12	15	10	26	6	1830	5\n23	15	13	6	8	9	10	11	12	13\n23	15	13	118	2	11	7	4	10	1743\n23	15	14	6	8	9	10	11	12	13	14	16\n23	15	14	9	31	3	15	7	4	2	739	6\n23	15	15	6	8	9	10	12	13	14	15\n23	15	15	35	2	29	5	1	4	1	1352\n23	15	16	8	9	10	11	12	15	16\n23	15	16	7	3	11	6	1	2	213\n23	15	17	17\n23	15	17	3\n23	15	18	18\n23	15	18	1\n23	15	20	10	16	20\n23	15	20	1	1	112\n23	15	37	37\n23	15	37	2\n23	16	0	0\n23	16	0	4\n23	16	6	6	7	9\n23	16	6	1733	2	50\n23	16	7	6	7\n23	16	7	2	199\n23	16	8	8	9	10\n23	16	8	504	10	2\n23	16	9	6	8	9\n23	16	9	10	4	894\n23	16	10	9	10	12\n23	16	10	6	639	2\n23	16	11	6	7	9	10	11	12	13\n23	16	11	14	1	1	21	2378	5	1\n23	16	12	6	8	9	10	11	12	13	15\n23	16	12	11	4	1	21	8	1816	2	1\n23	16	13	6	8	9	10	11	12	13	14	15\n23	16	13	75	3	5	2	3	7	1654	1	6\n23	16	14	6	8	9	10	11	12	13	14\n23	16	14	3	15	1	4	4	4	2	707\n23	16	15	6	9	10	13	14	15\n23	16	15	12	14	2	1	5	1320\n23	16	16	8	9	10	14	15	16	17\n23	16	16	2	1	2	1	1	212	1\n23	16	17	17\n23	16	17	3\n23	16	18	12\n23	16	18	1\n23	16	20	20\n23	16	20	112\n23	16	37	37\n23	16	37	2\n23	17	0	0\n23	17	0	4\n23	17	6	6	9\n23	17	6	1823	37\n23	17	7	6	7	8	9\n23	17	7	3	196	2	1\n23	17	8	6	8	9	10\n23	17	8	2	528	1	1\n23	17	9	6	7	8	9\n23	17	9	6	1	2	974\n23	17	10	6	8	9	10	11	12	15\n23	17	10	1	2	3	684	1	1	1\n23	17	11	6	7	10	11	12\n23	17	11	11	3	4	2370	5\n23	17	12	6	8	9	10	11	12	13\n23	17	12	9	2	1	5	2	1813	3\n23	17	13	6	11	12	13	14	15\n23	17	13	21	2	6	1625	1	5\n23	17	14	6	8	10	12	13	14	16\n23	17	14	1	3	1	2	4	701	2\n23	17	15	6	9	13	14	15	16\n23	17	15	7	6	4	4	1306	1\n23	17	16	10	15	16\n23	17	16	1	1	210\n23	17	17	17\n23	17	17	4\n23	17	20	20\n23	17	20	112\n23	17	37	37\n23	17	37	2\n23	18	0	0\n23	18	0	4\n23	18	6	6	9\n23	18	6	1860	24\n23	18	7	7	8	9\n23	18	7	191	5	4\n23	18	8	7	8	9	10\n23	18	8	1	534	2	2\n23	18	9	8	9\n23	18	9	2	1021\n23	18	10	9	10	12\n23	18	10	4	691	1\n23	18	11	6	9	10	11	12	13	14\n23	18	11	6	6	9	2340	12	1	1\n23	18	12	6	9	10	11	12	13\n23	18	12	2	1	5	6	1812	1\n23	18	13	6	10	11	12	13	15\n23	18	13	4	1	1	10	1615	5\n23	18	14	6	12	13	14\n23	18	14	2	1	5	698\n23	18	15	6	9	13	14	15	16	21\n23	18	15	1	4	1	2	1303	1	1\n23	18	16	14	15	16\n23	18	16	1	1	211\n23	18	17	17\n23	18	17	4\n23	18	20	20\n23	18	20	112\n23	18	37	37\n23	18	37	2\n23	19	0	0\n23	19	0	4\n23	19	6	6	9\n23	19	6	1863	12\n23	19	7	7\n23	19	7	192\n23	19	8	8	9	11\n23	19	8	538	2	1\n23	19	9	6	7	9\n23	19	9	2	1	1063\n23	19	10	9	10\n23	19	10	8	700\n23	19	11	9	10	11	12	13\n23	19	11	2	6	2332	6	1\n23	19	12	11	12	13	18\n23	19	12	4	1825	5	2\n23	19	13	6	11	12	13	14	15\n23	19	13	1	6	6	1598	1	11\n23	19	14	11	12	13	14\n23	19	14	1	2	6	693\n23	19	15	6	12	14	15	16	18\n23	19	15	1	1	1	1303	2	1\n23	19	16	15	16	17\n23	19	16	1	210	1\n23	19	17	17\n23	19	17	4\n23	19	20	20\n23	19	20	112\n23	19	21	21\n23	19	21	1\n23	19	37	37\n23	19	37	2\n23	20	0	0\n23	20	0	4\n23	20	6	6	9\n23	20	6	1865	2\n23	20	7	7\n23	20	7	193\n23	20	8	7	8\n23	20	8	1	537\n23	20	9	8	9	10	11\n23	20	9	1	1084	1	1\n23	20	10	9	10\n23	20	10	4	702\n23	20	11	10	11	12	13\n23	20	11	2	2331	10	1\n23	20	12	10	11	12	13\n23	20	12	3	3	1833	1\n23	20	13	10	11	12	13	15\n23	20	13	1	4	4	1599	2\n23	20	14	11	12	13	14	16\n23	20	14	1	3	5	684	2\n23	20	15	13	14	15	16\n23	20	15	2	5	1305	3\n23	20	16	15	16	17\n23	20	16	3	208	1\n23	20	17	17\n23	20	17	5\n23	20	18	18\n23	20	18	3\n23	20	20	20\n23	20	20	112\n23	20	21	21\n23	20	21	1\n23	20	37	37\n23	20	37	2\n23	21	0	0\n23	21	0	4\n23	21	6	6\n23	21	6	1865\n23	21	7	7\n23	21	7	194\n23	21	8	7	8\n23	21	8	8	530\n23	21	9	6	7	8	9\n23	21	9	222	13	26	829\n23	21	10	7	8	9	10	11\n23	21	10	2	9	17	680	1\n23	21	11	8	9	10	11	12\n23	21	11	19	22	9	2276	14\n23	21	12	7	8	9	10	11	12\n23	21	12	14	12	15	49	161	1599\n23	21	13	8	9	10	11	12	13	15\n23	21	13	5	12	12	26	21	1523	9\n23	21	14	9	10	11	12	13	14	16\n23	21	14	9	16	16	29	66	549	4\n23	21	15	9	10	11	12	13	14	15	16\n23	21	15	11	14	17	21	194	28	1023	2\n23	21	16	11	12	13	14	15	16	17\n23	21	16	2	4	4	17	8	177	1\n23	21	17	17\n23	21	17	6\n23	21	18	12	15	18\n23	21	18	1	1	1\n23	21	20	11	15	16	20\n23	21	20	2	2	96	12\n23	21	21	15\n23	21	21	1\n23	21	37	17	37\n23	21	37	1	1\n23	22	0	0\n23	22	0	4\n23	22	6	6\n23	22	6	2087\n23	22	7	7	10\n23	22	7	230	1\n23	22	8	7	8\n23	22	8	10	591\n23	22	9	6	7	8	9\n23	22	9	159	8	20	728\n23	22	10	7	8	9	10	13\n23	22	10	2	5	18	754	1\n23	22	11	8	9	10	11	12	15\n23	22	11	11	17	10	2449	13	1\n23	22	12	7	8	9	10	11	12	13	15\n23	22	12	1	4	6	39	67	1565	3	4\n23	22	13	8	9	10	11	12	13	14	15\n23	22	13	2	8	6	33	18	1709	1	10\n23	22	14	9	10	11	12	13	14	16\n23	22	14	1	3	4	7	35	541	3\n23	22	15	9	10	11	12	13	14	15	16\n23	22	15	3	3	11	2	72	18	932	3\n23	22	16	14	15	16\n23	22	16	3	5	271\n23	22	17	17\n23	22	17	8\n23	22	18	12\n23	22	18	1\n23	22	20	15	16	20\n23	22	20	1	6	5\n23	22	37	37\n23	22	37	1\n24	1	0	0\n24	1	0	4\n24	1	6	6	9\n24	1	6	118	8\n24	1	7	7	8	9\n24	1	7	160	2	3\n24	1	8	8	9	11	12	13\n24	1	8	234	2	3	2	1\n24	1	9	9	10	11	12	13\n24	1	9	382	2	5	3	4\n24	1	10	9	10	11	12	13	14\n24	1	10	6	128	2	3	1	4\n24	1	11	10	11	12	13	14	15\n24	1	11	3	1736	11	9	3	2\n24	1	12	10	11	12	13	14	15	16\n24	1	12	1	33	1214	10	13	1	1\n24	1	13	11	12	13	14	15	16\n24	1	13	6	6	1729	13	24	1\n24	1	14	13	14	15	16\n24	1	14	6	600	2	3\n24	1	15	12	13	14	15	16	21\n24	1	15	4	43	2	1356	7	3\n24	1	16	11	14	15	16	20	21\n24	1	16	1	10	6	278	32	5\n24	1	17	15	17	20\n24	1	17	1	8	1\n24	1	18	13	18\n24	1	18	1	3\n24	1	19	19\n24	1	19	1\n24	1	20	20\n24	1	20	28\n24	1	21	21\n24	1	21	9\n24	1	23	23\n24	1	23	2\n24	1	25	25\n24	1	25	1\n24	1	28	26\n24	1	28	1\n24	1	37	37\n24	1	37	1\n24	2	0	0\n24	2	0	4\n24	2	6	6	9\n24	2	6	105	13\n24	2	7	7	8	9\n24	2	7	152	1	7\n24	2	8	8	11	12	13\n24	2	8	225	6	4	1\n24	2	9	9	10	11	12	13	14	28\n24	2	9	384	3	3	5	2	3	1\n24	2	10	7	9	10	12	13	14	15\n24	2	10	1	2	118	4	2	5	2\n24	2	11	8	9	10	11	12	13	14	15	16\n24	2	11	1	1	3	1738	31	7	1	3	1\n24	2	12	11	12	13	14	16	21\n24	2	12	25	1200	6	10	1	1\n24	2	13	12	13	14	15	16\n24	2	13	9	1756	19	19	1\n24	2	14	12	13	14	15	16\n24	2	14	1	5	631	2	6\n24	2	15	13	15	16	21\n24	2	15	25	1364	1	2\n24	2	16	14	15	16	20	21\n24	2	16	3	6	216	64	1\n24	2	17	17\n24	2	17	8\n24	2	18	15	18\n24	2	18	1	2\n24	2	19	19\n24	2	19	1\n24	2	20	20\n24	2	20	61\n24	2	21	21	23\n24	2	21	16	1\n24	2	23	23\n24	2	23	2\n24	2	25	25\n24	2	25	1\n24	2	26	26\n24	2	26	1\n24	2	37	37\n24	2	37	1\n24	3	0	0\n24	3	0	4\n24	3	6	6\n24	3	6	105\n24	3	7	7\n24	3	7	153\n24	3	8	7	8\n24	3	8	1	226\n24	3	9	9	10\n24	3	9	404	3\n24	3	10	9	10\n24	3	10	2	122\n24	3	11	10	11	13\n24	3	11	2	1768	2\n24	3	12	11	12	13\n24	3	12	28	1224	2\n24	3	13	11	12	13	14	15\n24	3	13	1	7	1793	1	2\n24	3	14	11	13	14\n24	3	14	1	1	670\n24	3	15	12	13	14	15	16\n24	3	15	1	26	3	1366	1\n24	3	16	15	16\n24	3	16	5	221\n24	3	17	13	16	17\n24	3	17	1	2	5\n24	3	18	18\n24	3	18	2\n24	3	19	19\n24	3	19	1\n24	3	20	20\n24	3	20	125\n24	3	21	21\n24	3	21	20\n24	3	23	23\n24	3	23	3\n24	3	25	25\n24	3	25	1\n24	3	26	23\n24	3	26	1\n24	3	28	30\n24	3	28	1\n24	3	37	37\n24	3	37	1\n24	4	0	0\n24	4	0	4\n24	4	6	6\n24	4	6	105\n24	4	7	7\n24	4	7	154\n24	4	8	8\n24	4	8	226\n24	4	9	8	9	10\n24	4	9	1	404	1\n24	4	10	9	10\n24	4	10	1	126\n24	4	11	9	10	11	13\n24	4	11	1	2	1793	2\n24	4	12	11	12	15\n24	4	12	18	1213	1\n24	4	13	11	12	13	14	15\n24	4	13	2	8	1812	1	2\n24	4	14	13	14\n24	4	14	1	673\n24	4	15	12	13	15\n24	4	15	2	17	1354\n24	4	16	14	16\n24	4	16	3	221\n24	4	17	17\n24	4	17	5\n24	4	18	18\n24	4	18	2\n24	4	19	19\n24	4	19	1\n24	4	20	14	20\n24	4	20	1	124\n24	4	21	21\n24	4	21	20\n24	4	23	23\n24	4	23	4\n24	4	25	25\n24	4	25	1\n24	4	30	30\n24	4	30	1\n24	4	37	37\n24	4	37	1\n24	5	0	0\n24	5	0	4\n24	5	6	6\n24	5	6	105\n24	5	7	7\n24	5	7	154\n24	5	8	8\n24	5	8	227\n24	5	9	9	10\n24	5	9	404	2\n24	5	10	8	10\n24	5	10	1	128\n24	5	11	10	11	12\n24	5	11	3	1809	1\n24	5	12	10	11	12\n24	5	12	1	20	1202\n24	5	13	12	13	14	15\n24	5	13	5	1821	2	4\n24	5	14	11	13	14	17\n24	5	14	1	4	672	1\n24	5	15	12	13	14	15	16\n24	5	15	1	31	2	1321	2\n24	5	16	11	13	14	15	16\n24	5	16	1	1	2	3	214\n24	5	17	17\n24	5	17	5\n24	5	18	15	18\n24	5	18	1	1\n24	5	19	19\n24	5	19	1\n24	5	20	20\n24	5	20	124\n24	5	21	15	21\n24	5	21	1	19\n24	5	23	18	23\n24	5	23	1	3\n24	5	25	25\n24	5	25	1\n24	5	30	32\n24	5	30	1\n24	5	37	37\n24	5	37	1\n24	6	0	0\n24	6	0	4\n24	6	6	6\n24	6	6	105\n24	6	7	7\n24	6	7	154\n24	6	8	7	8\n24	6	8	1	227\n24	6	9	7	8	9	10\n24	6	9	1	2	399	2\n24	6	10	9	10\n24	6	10	1	133\n24	6	11	10	11	12	13\n24	6	11	3	1823	1	4\n24	6	12	11	12	13	14\n24	6	12	12	1194	2	1\n24	6	13	7	9	13	14	15\n24	6	13	4	1	1848	1	3\n24	6	14	12	13	14	15\n24	6	14	1	2	674	1\n24	6	15	13	14	15\n24	6	15	21	1	1308\n24	6	16	14	15	16\n24	6	16	1	5	210\n24	6	17	13	15	16	17\n24	6	17	1	1	1	3\n24	6	18	18\n24	6	18	2\n24	6	19	9\n24	6	19	1\n24	6	20	16	20\n24	6	20	1	123\n24	6	21	15	21\n24	6	21	3	16\n24	6	23	16	23\n24	6	23	1	2\n24	6	25	10\n24	6	25	1\n24	6	32	32\n24	6	32	1\n24	6	37	37\n24	6	37	1\n24	7	0	0\n24	7	0	4\n24	7	6	6\n24	7	6	105\n24	7	7	7\n24	7	7	160\n24	7	8	8	13\n24	7	8	228	1\n24	7	9	6	8	9	10	11\n24	7	9	2	1	394	4	1\n24	7	10	8	9	10\n24	7	10	1	6	132\n24	7	11	6	10	11	13\n24	7	11	1	6	1826	2\n24	7	12	9	11	12	13	15\n24	7	12	1	6	1186	2	1\n24	7	13	6	12	13	14	15\n24	7	13	6	5	1863	2	2\n24	7	14	8	12	13	14	18\n24	7	14	1	1	1	674	1\n24	7	15	6	13	14	15	16\n24	7	15	4	10	1	1305	1\n24	7	16	12	15	16\n24	7	16	1	5	207\n24	7	17	9	17\n24	7	17	1	2\n24	7	18	6	18\n24	7	18	1	1\n24	7	20	20\n24	7	20	123\n24	7	21	15	16	21\n24	7	21	7	1	8\n24	7	23	6	9\n24	7	23	1	1\n24	7	32	32\n24	7	32	1\n24	7	37	37\n24	7	37	1\n24	8	0	0\n24	8	0	4\n24	8	6	6\n24	8	6	120\n24	8	7	7\n24	8	7	160\n24	8	8	6	7	8\n24	8	8	1	2	228\n24	8	9	6	7	9	10\n24	8	9	3	1	397	2\n24	8	10	10\n24	8	10	142\n24	8	11	6	10	11	13	16\n24	8	11	2	2	1826	2	1\n24	8	12	6	11	12	13\n24	8	12	2	4	1186	1\n24	8	13	6	9	11	12	13	14	15\n24	8	13	10	4	1	7	1852	2	3\n24	8	14	8	9	12	13	14	16\n24	8	14	1	1	1	4	669	1\n24	8	15	6	9	13	14	15	16	17\n24	8	15	9	1	9	2	1296	2	1\n24	8	16	10	14	15	16\n24	8	16	1	1	3	204\n24	8	17	17\n24	8	17	2\n24	8	18	18\n24	8	18	2\n24	8	20	20\n24	8	20	123\n24	8	21	21\n24	8	21	8\n24	8	32	32\n24	8	32	1\n24	8	37	37\n24	8	37	1\n24	9	0	0\n24	9	0	4\n24	9	6	6	9\n24	9	6	146	1\n24	9	7	7\n24	9	7	163\n24	9	8	8\n24	9	8	229\n24	9	9	6	8	9\n24	9	9	6	3	394\n24	9	10	6	9	10\n24	9	10	1	1	145\n24	9	11	6	9	10	11	12	13	14\n24	9	11	5	1	7	1815	1	1	1\n24	9	12	6	10	11	12\n24	9	12	1	1	2	1190\n24	9	13	6	9	10	12	13	14	15\n24	9	13	28	4	1	7	1820	1	7\n24	9	14	6	8	9	12	14\n24	9	14	2	1	2	3	666\n24	9	15	6	9	13	14	15	16\n24	9	15	12	6	5	1	1277	1\n24	9	16	9	15	16\n24	9	16	1	4	203\n24	9	17	16	17\n24	9	17	1	2\n24	9	18	6	18\n24	9	18	1	1\n24	9	20	20\n24	9	20	123\n24	9	21	6	9	21\n24	9	21	1	6	1\n24	9	32	32\n24	9	32	1\n24	9	37	37\n24	9	37	1\n24	10	0	0\n24	10	0	4\n24	10	6	6	9\n24	10	6	200	3\n24	10	7	7\n24	10	7	163\n24	10	8	8\n24	10	8	233\n24	10	9	6	7	9	10\n24	10	9	1	1	413	1\n24	10	10	8	9	10\n24	10	10	1	3	150\n24	10	11	6	9	10	11	12	13\n24	10	11	1	1	3	1806	5	1\n24	10	12	6	10	11	12	13	14	15\n24	10	12	1	5	5	1187	1	1	1\n24	10	13	6	10	12	13	14	15\n24	10	13	10	2	5	1802	1	6\n24	10	14	10	11	12	14	16\n24	10	14	1	1	1	665	1\n24	10	15	6	9	13	14	15	16\n24	10	15	1	2	5	2	1276	2\n24	10	16	9	14	15	16\n24	10	16	1	1	4	199\n24	10	17	17\n24	10	17	2\n24	10	18	15\n24	10	18	1\n24	10	20	20\n24	10	20	123\n24	10	21	21\n24	10	21	1\n24	10	32	32\n24	10	32	1\n24	10	37	37\n24	10	37	1\n24	11	0	0\n24	11	0	4\n24	11	6	6	9\n24	11	6	212	2\n24	11	7	6	7	8\n24	11	7	3	160	1\n24	11	8	8\n24	11	8	234\n24	11	9	6	7	8	9	11	13\n24	11	9	4	3	2	412	1	1\n24	11	10	9	10	12\n24	11	10	3	158	1\n24	11	11	6	9	10	11\n24	11	11	2	4	4	1802\n24	11	12	9	10	11	12	13\n24	11	12	1	1	2	1193	1\n24	11	13	6	8	12	13	14	15	16\n24	11	13	6	1	3	1789	3	6	1\n24	11	14	10	11	12	13	14	16\n24	11	14	1	1	4	6	657	1\n24	11	15	6	9	12	13	14	15\n24	11	15	5	4	1	20	1	1257\n24	11	16	12	14	15	16\n24	11	16	1	1	1	199\n24	11	17	17\n24	11	17	2\n24	11	20	16	20\n24	11	20	9	114\n24	11	21	21\n24	11	21	1\n24	11	32	32\n24	11	32	1\n24	11	37	37\n24	11	37	1\n24	12	0	0\n24	12	0	4\n24	12	6	6	8	9\n24	12	6	228	1	3\n24	12	7	6	7	9\n24	12	7	3	155	5\n24	12	8	6	8	9\n24	12	8	4	233	1\n24	12	9	6	7	8	9	11\n24	12	9	14	2	1	408	1\n24	12	10	6	9	10\n24	12	10	2	2	160\n24	12	11	6	9	10	11	12\n24	12	11	9	1	14	1778	4\n24	12	12	8	10	11	12	18\n24	12	12	2	2	7	1191	1\n24	12	13	6	9	11	12	13	14	15\n24	12	13	47	8	2	7	1744	2	7\n24	12	14	6	8	9	12	13	14	15	20\n24	12	14	6	2	1	2	2	647	1	1\n24	12	15	6	9	12	13	14	15	16\n24	12	15	24	16	1	25	4	1192	2\n24	12	16	15	16\n24	12	16	7	203\n24	12	17	17	19\n24	12	17	1	1\n24	12	20	14	15	16	20\n24	12	20	1	3	18	92\n24	12	21	21\n24	12	21	1\n24	12	32	32\n24	12	32	1\n24	12	37	37\n24	12	37	1\n24	13	0	0\n24	13	0	4\n24	13	6	6	7	9\n24	13	6	329	6	2\n24	13	7	6	7	9\n24	13	7	16	139	2\n24	13	8	6	7	8\n24	13	8	9	1	229\n24	13	9	6	7	8	9\n24	13	9	16	3	3	423\n24	13	10	6	9	10\n24	13	10	3	4	169\n24	13	11	6	9	10	11	12\n24	13	11	28	6	30	1706	18\n24	13	12	6	7	8	9	10	11	12\n24	13	12	8	1	5	1	17	7	1166\n24	13	13	6	8	9	10	11	12	13	14	15\n24	13	13	191	1	12	3	3	5	1545	1	10\n24	13	14	6	8	9	10	11	12	13	14	16\n24	13	14	11	16	8	4	3	3	4	602	3\n24	13	15	6	9	10	13	14	15	16\n24	13	15	69	56	1	16	3	1064	1\n24	13	16	8	9	10	11	12	13	14	15	16\n24	13	16	7	4	5	4	2	1	3	11	186\n24	13	17	17\n24	13	17	1\n24	13	18	18\n24	13	18	1\n24	13	19	22\n24	13	19	1\n24	13	20	14	16	20\n24	13	20	1	16	76\n24	13	21	21\n24	13	21	1\n24	13	32	32\n24	13	32	1\n24	13	37	37\n24	13	37	1\n24	14	0	0\n24	14	0	4\n24	14	6	6	7	9\n24	14	6	663	1	16\n24	14	7	6	7\n24	14	7	5	145\n24	14	8	6	8	9\n24	14	8	12	247	2\n24	14	9	6	8	9	10	11\n24	14	9	25	2	489	1	1\n24	14	10	6	9	10	11\n24	14	10	1	4	223	1\n24	14	11	6	8	9	10	11	12	13	14\n24	14	11	53	2	4	60	1579	23	1	1\n24	14	12	6	8	10	11	12	18\n24	14	12	19	5	47	5	1117	1\n24	14	13	6	8	9	10	12	13	15\n24	14	13	239	5	11	3	6	1301	1\n24	14	14	6	8	9	10	11	12	13	14	16\n24	14	14	9	35	5	14	10	3	5	528	1\n24	14	15	6	8	9	10	11	12	13	14	15	16\n24	14	15	63	6	61	10	2	3	13	3	923	1\n24	14	16	8	9	10	11	12	13	15	16	17\n24	14	16	14	9	12	3	2	1	3	161	1\n24	14	17	17\n24	14	17	1\n24	14	18	18\n24	14	18	1\n24	14	20	9	10	14	15	16	17	20\n24	14	20	1	1	1	1	13	2	57\n24	14	21	21\n24	14	21	1\n24	14	22	19\n24	14	22	1\n24	14	32	32\n24	14	32	1\n24	14	37	37\n24	14	37	1\n24	15	0	0\n24	15	0	4\n24	15	6	6	9\n24	15	6	1058	31\n24	15	7	6	7	9\n24	15	7	6	139	1\n24	15	8	6	7	8	9\n24	15	8	8	1	305	2\n24	15	9	6	8	9\n24	15	9	22	4	576\n24	15	10	6	9	10	12	14\n24	15	10	2	2	364	2	1\n24	15	11	6	7	8	9	10	11	12	13\n24	15	11	37	1	3	3	55	1483	17	2\n24	15	12	6	8	9	10	11	12\n24	15	12	6	8	1	38	2	1099\n24	15	13	6	8	9	10	11	12	13	15\n24	15	13	149	4	8	2	2	5	1150	1\n24	15	14	6	8	9	10	11	12	13	14	16\n24	15	14	2	26	4	28	8	3	7	450	5\n24	15	15	6	8	9	10	13	14	15	16\n24	15	15	48	3	26	9	5	2	834	1\n24	15	16	8	9	10	11	12	13	14	15	16\n24	15	16	11	6	12	9	1	2	1	1	133\n24	15	17	17\n24	15	17	4\n24	15	18	18\n24	15	18	2\n24	15	19	19\n24	15	19	1\n24	15	20	10	14	15	16	20\n24	15	20	1	1	1	4	50\n24	15	21	21\n24	15	21	1\n24	15	32	32\n24	15	32	1\n24	15	37	37\n24	15	37	1\n24	16	0	0\n24	16	0	4\n24	16	6	6	9\n24	16	6	1285	53\n24	16	7	6	7\n24	16	7	3	138\n24	16	8	6	8	9\n24	16	8	2	356	6\n24	16	9	6	7	8	9\n24	16	9	15	1	1	643\n24	16	10	6	9	10	12\n24	16	10	2	4	500	3\n24	16	11	6	7	8	9	10	11	12\n24	16	11	19	1	6	2	22	1444	10\n24	16	12	6	7	8	9	10	11	12	13\n24	16	12	8	1	4	4	11	4	1092	3\n24	16	13	6	8	9	10	11	12	13\n24	16	13	83	3	8	6	2	5	1059\n24	16	14	6	8	9	10	11	12	13	14\n24	16	14	8	21	1	7	2	7	3	406\n24	16	15	6	8	9	10	13	15	19\n24	16	15	24	2	26	2	4	778	1\n24	16	16	8	9	10	11	12	14	16\n24	16	16	4	2	9	5	3	2	118\n24	16	17	17\n24	16	17	4\n24	16	18	12\n24	16	18	2\n24	16	19	15\n24	16	19	1\n24	16	20	20\n24	16	20	50\n24	16	21	21\n24	16	21	1\n24	16	32	32\n24	16	32	1\n24	16	37	37\n24	16	37	1\n24	17	0	0\n24	17	0	4\n24	17	6	6	7	9\n24	17	6	1403	2	44\n24	17	7	6	7	8\n24	17	7	1	139	1\n24	17	8	6	8	9	10\n24	17	8	1	390	4	2\n24	17	9	6	8	9\n24	17	9	4	2	743\n24	17	10	9	10	11	12\n24	17	10	1	549	1	6\n24	17	11	6	7	10	11	12\n24	17	11	11	1	14	1426	5\n24	17	12	6	8	10	11	12	15\n24	17	12	5	4	10	1	1099	3\n24	17	13	6	9	10	11	12	13	15\n24	17	13	32	1	3	2	5	1019	7\n24	17	14	6	8	10	11	12	13	14	15	16\n24	17	14	2	6	1	1	1	1	394	1	1\n24	17	15	6	8	9	10	12	15\n24	17	15	8	2	6	1	1	761\n24	17	16	8	9	10	12	15	16	17\n24	17	16	3	1	2	1	1	109	1\n24	17	17	17\n24	17	17	4\n24	17	19	16\n24	17	19	1\n24	17	20	20\n24	17	20	50\n24	17	21	21\n24	17	21	1\n24	17	32	32\n24	17	32	1\n24	17	37	37\n24	17	37	1\n24	18	0	0\n24	18	0	4\n24	18	6	6	9\n24	18	6	1436	31\n24	18	7	7	8	9\n24	18	7	139	1	2\n24	18	8	6	8	9\n24	18	8	1	405	2\n24	18	9	6	7	8	9\n24	18	9	2	2	1	795\n24	18	10	6	9	10	12\n24	18	10	1	1	578	2\n24	18	11	6	8	9	10	11	12	13\n24	18	11	8	2	2	2	1410	5	2\n24	18	12	6	8	10	11	12	14\n24	18	12	1	1	3	5	1107	1\n24	18	13	6	12	13	15\n24	18	13	10	5	1002	3\n24	18	14	10	12	13	14\n24	18	14	2	2	2	388\n24	18	15	6	9	12	13	14	15\n24	18	15	2	2	1	1	1	766\n24	18	16	14	15	16\n24	18	16	1	2	108\n24	18	17	17\n24	18	17	5\n24	18	20	20\n24	18	20	50\n24	18	21	21\n24	18	21	1\n24	18	32	32\n24	18	32	1\n24	18	37	37\n24	18	37	1\n24	19	0	0\n24	19	0	4\n24	19	6	6	9\n24	19	6	1447	14\n24	19	7	7	9\n24	19	7	140	1\n24	19	8	6	8	9\n24	19	8	1	408	1\n24	19	9	6	7	8	9	12\n24	19	9	2	1	1	830	1\n24	19	10	9	10	12\n24	19	10	2	581	2\n24	19	11	6	9	10	11	12\n24	19	11	3	1	2	1406	3\n24	19	12	10	11	12	13	15\n24	19	12	2	7	1109	2	2\n24	19	13	6	11	12	13	14	15\n24	19	13	4	1	2	997	1	2\n24	19	14	11	13	14	16\n24	19	14	1	1	388	1\n24	19	15	6	13	14	15	21\n24	19	15	1	1	1	767	1\n24	19	16	15	16\n24	19	16	1	107\n24	19	17	13	17\n24	19	17	1	4\n24	19	20	20\n24	19	20	50\n24	19	21	21\n24	19	21	1\n24	19	32	32\n24	19	32	1\n24	19	37	37\n24	19	37	1\n24	20	0	0\n24	20	0	4\n24	20	6	6	7	9\n24	20	6	1453	1	4\n24	20	7	7\n24	20	7	141\n24	20	8	8	12\n24	20	8	408	1\n24	20	9	9	12\n24	20	9	848	1\n24	20	10	9	10\n24	20	10	5	580\n24	20	11	10	11	12	14\n24	20	11	1	1405	8	1\n24	20	12	10	11	12	18\n24	20	12	3	4	1109	1\n24	20	13	6	11	12	13	15\n24	20	13	1	3	4	986	8\n24	20	14	11	12	14\n24	20	14	1	2	387\n24	20	15	14	15	16	21\n24	20	15	2	766	3	1\n24	20	16	12	15	16	17\n24	20	16	1	2	103	2\n24	20	17	17\n24	20	17	4\n24	20	20	20\n24	20	20	50\n24	20	21	15	21\n24	20	21	1	1\n24	20	32	32\n24	20	32	1\n24	20	37	37\n24	20	37	1\n24	21	0	0\n24	21	0	4\n24	21	6	6\n24	21	6	1454\n24	21	7	7	9\n24	21	7	141	1\n24	21	8	7	8\n24	21	8	1	407\n24	21	9	9\n24	21	9	857\n24	21	10	9	10\n24	21	10	5	579\n24	21	11	10	11	12\n24	21	11	1	1407	5\n24	21	12	11	12\n24	21	12	3	1123\n24	21	13	12	13	14	15\n24	21	13	7	972	2	5\n24	21	14	13	14\n24	21	14	1	389\n24	21	15	13	14	15	16\n24	21	15	1	3	772	1\n24	21	16	15	16	21\n24	21	16	2	103	1\n24	21	17	17\n24	21	17	6\n24	21	18	18\n24	21	18	1\n24	21	20	20\n24	21	20	50\n24	21	21	21\n24	21	21	2\n24	21	32	32\n24	21	32	1\n24	21	37	37\n24	21	37	1\n24	22	0	0\n24	22	0	4\n24	22	6	6\n24	22	6	1454\n24	22	7	7	10\n24	22	7	141	1\n24	22	8	7	8\n24	22	8	7	400\n24	22	9	6	7	8	9	10\n24	22	9	180	13	18	651	1\n24	22	10	7	8	9	10\n24	22	10	4	6	13	557\n24	22	11	8	9	10	11	12\n24	22	11	8	9	8	1380	5\n24	22	12	7	8	9	10	11	12	14\n24	22	12	2	6	13	35	95	983	1\n24	22	13	8	9	10	11	12	13	15\n24	22	13	6	9	4	18	18	917	2\n24	22	14	9	10	11	12	13	14\n24	22	14	9	16	9	16	41	303\n24	22	15	9	10	11	12	13	14	15	16\n24	22	15	5	8	7	12	103	15	628	1\n24	22	16	11	12	14	15	16	17\n24	22	16	1	1	7	8	86	1\n24	22	17	13	17\n24	22	17	1	5\n24	22	18	12\n24	22	18	1\n24	22	20	14	15	16	17	20\n24	22	20	1	1	42	1	5\n24	22	21	13	16	21\n24	22	21	1	1	1\n24	22	32	30\n24	22	32	1\n24	22	37	37\n24	22	37	1\n24	23	0	0\n24	23	0	4\n24	23	6	6\n24	23	6	1634\n24	23	7	7\n24	23	7	167\n24	23	8	7	8\n24	23	8	8	436\n24	23	9	6	7	8	9	10\n24	23	9	103	9	16	579	2\n24	23	10	7	8	9	10\n24	23	10	4	4	8	614\n24	23	11	8	9	10	11	12	13	15\n24	23	11	6	5	6	1484	7	1	1\n24	23	12	8	9	10	11	12\n24	23	12	1	4	21	38	972\n24	23	13	8	9	10	11	12	13	14	15	16	17\n24	23	13	1	4	5	20	13	1009	1	8	1	1\n24	23	14	9	10	12	13	14\n24	23	14	1	3	7	21	295\n24	23	15	10	11	12	13	14	15	16\n24	23	15	4	3	1	54	8	566	3\n24	23	16	13	14	15	16\n24	23	16	1	3	5	121\n24	23	17	17\n24	23	17	7\n24	23	20	16	20\n24	23	20	3	2\n24	23	21	21\n24	23	21	1\n24	23	30	30\n24	23	30	1\n24	23	37	16\n24	23	37	1\n25	1	0	0\n25	1	0	1\n25	1	6	6	9\n25	1	6	85	3\n25	1	7	7	8	9\n25	1	7	90	1	7\n25	1	8	8	9	12\n25	1	8	152	1	3\n25	1	9	7	8	9	11	12	13\n25	1	9	1	1	220	4	1	5\n25	1	10	9	10	12\n25	1	10	4	75	3\n25	1	11	9	10	11	12	13	14	15\n25	1	11	1	1	1030	7	3	1	1\n25	1	12	11	12	13	14	15\n25	1	12	16	771	3	4	1\n25	1	13	11	12	13	14	15\n25	1	13	1	5	1176	2	22\n25	1	14	13	14	15\n25	1	14	2	350	1\n25	1	15	12	13	15	16	21\n25	1	15	1	27	891	1	3\n25	1	16	14	15	16	20	21	37\n25	1	16	2	3	184	12	3	2\n25	1	17	17\n25	1	17	6\n25	1	18	18\n25	1	18	4\n25	1	20	14	16	20\n25	1	20	1	1	27\n25	1	21	21\n25	1	21	4\n25	1	23	23\n25	1	23	1\n25	1	37	37\n25	1	37	3\n25	2	0	0\n25	2	0	1\n25	2	6	6	9\n25	2	6	79	6\n25	2	7	7	8	9\n25	2	7	87	2	2\n25	2	8	8	9	11	12	13\n25	2	8	143	6	1	3	1\n25	2	9	9	10	11	12	14\n25	2	9	228	3	2	1	2\n25	2	10	9	10	12	14\n25	2	10	1	72	2	1\n25	2	11	10	11	12	13	14	15\n25	2	11	2	1017	20	7	3	2\n25	2	12	11	12	13	14	15	16\n25	2	12	13	767	4	5	1	1\n25	2	13	11	12	13	14	15	21\n25	2	13	5	5	1183	7	15	1\n25	2	14	13	14	15	16\n25	2	14	1	355	2	2\n25	2	15	13	14	15	16	21\n25	2	15	21	1	894	2	1\n25	2	16	14	15	16	20	21	37\n25	2	16	7	3	134	36	4	2\n25	2	17	17	20\n25	2	17	5	1\n25	2	18	18	23\n25	2	18	3	1\n25	2	20	16	20\n25	2	20	1	38\n25	2	21	21\n25	2	21	10\n25	2	23	23\n25	2	23	1\n25	2	37	37\n25	2	37	5\n25	3	0	0\n25	3	0	1\n25	3	6	6\n25	3	6	79\n25	3	7	7\n25	3	7	87\n25	3	8	8\n25	3	8	145\n25	3	9	9	10\n25	3	9	242	1\n25	3	10	8	10\n25	3	10	1	76\n25	3	11	10	11\n25	3	11	3	1035\n25	3	12	9	11	12\n25	3	12	1	16	781\n25	3	13	11	12	13	15\n25	3	13	2	2	1211	2\n25	3	14	12	13	14\n25	3	14	2	2	377\n25	3	15	13	15	16\n25	3	15	22	894	1\n25	3	16	14	15	16\n25	3	16	1	5	134\n25	3	17	15	17\n25	3	17	1	4\n25	3	18	18\n25	3	18	3\n25	3	20	20\n25	3	20	75\n25	3	21	21\n25	3	21	16\n25	3	23	23\n25	3	23	2\n25	3	37	37\n25	3	37	7\n25	4	0	0\n25	4	0	1\n25	4	6	6\n25	4	6	79\n25	4	7	7\n25	4	7	87\n25	4	8	8\n25	4	8	146\n25	4	9	9	10\n25	4	9	240	3\n25	4	10	9	10	11\n25	4	10	1	77	2\n25	4	11	9	10	11	12	13\n25	4	11	1	1	1049	1	1\n25	4	12	11	12\n25	4	12	12	773\n25	4	13	12	13	14	15\n25	4	13	6	1225	1	3\n25	4	14	13	14\n25	4	14	2	376\n25	4	15	13	14	15	17\n25	4	15	15	2	884	1\n25	4	16	13	14	15	16\n25	4	16	1	2	1	131\n25	4	17	16	17\n25	4	17	1	3\n25	4	18	18\n25	4	18	3\n25	4	20	20\n25	4	20	75\n25	4	21	21\n25	4	21	16\n25	4	23	23\n25	4	23	2\n25	4	37	37\n25	4	37	7\n25	5	0	0\n25	5	0	1\n25	5	6	6\n25	5	6	79\n25	5	7	7\n25	5	7	87\n25	5	8	8\n25	5	8	146\n25	5	9	9	10\n25	5	9	240	2\n25	5	10	10\n25	5	10	81\n25	5	11	9	10	11	13\n25	5	11	1	2	1059	1\n25	5	12	10	11	12\n25	5	12	1	8	771\n25	5	13	8	11	12	13	15\n25	5	13	1	1	1	1240	1\n25	5	14	12	13	14\n25	5	14	1	1	379\n25	5	15	13	14	15	16\n25	5	15	13	1	873	1\n25	5	16	14	15	16\n25	5	16	1	3	128\n25	5	17	17\n25	5	17	4\n25	5	18	15	18\n25	5	18	1	2\n25	5	20	20\n25	5	20	75\n25	5	21	21\n25	5	21	16\n25	5	23	18	23\n25	5	23	1	1\n25	5	37	37\n25	5	37	7\n25	6	0	0\n25	6	0	1\n25	6	6	6\n25	6	6	79\n25	6	7	7\n25	6	7	87\n25	6	8	8\n25	6	8	147\n25	6	9	9	10\n25	6	9	240	1\n25	6	10	9	10\n25	6	10	3	83\n25	6	11	10	11	13\n25	6	11	2	1065	1\n25	6	12	11	12	13	14\n25	6	12	7	764	1	1\n25	6	13	9	11	12	13	15\n25	6	13	1	1	5	1245	3\n25	6	14	11	14\n25	6	14	1	380\n25	6	15	12	13	15	16\n25	6	15	1	12	864	1\n25	6	16	14	16\n25	6	16	1	128\n25	6	17	15	16	17\n25	6	17	1	1	2\n25	6	18	18\n25	6	18	3\n25	6	20	20\n25	6	20	75\n25	6	21	15	21\n25	6	21	2	14\n25	6	23	23\n25	6	23	1\n25	6	37	37\n25	6	37	7\n25	7	0	0\n25	7	0	1\n25	7	6	6\n25	7	6	79\n25	7	7	7\n25	7	7	87\n25	7	8	7	8\n25	7	8	1	146\n25	7	9	6	9	11\n25	7	9	1	242	1\n25	7	10	9	10\n25	7	10	1	85\n25	7	11	10	11	13\n25	7	11	3	1069	2\n25	7	12	11	12\n25	7	12	4	766\n25	7	13	6	11	12	13	15\n25	7	13	4	1	1	1252	1\n25	7	14	6	12	13	14\n25	7	14	1	2	2	377\n25	7	15	6	9	13	15\n25	7	15	1	1	5	863\n25	7	16	16\n25	7	16	130\n25	7	17	6	17\n25	7	17	1	1\n25	7	18	6	18\n25	7	18	1	2\n25	7	20	20\n25	7	20	75\n25	7	21	13	15	16	21\n25	7	21	1	6	1	6\n25	7	23	6\n25	7	23	1\n25	7	37	20	37\n25	7	37	1	6\n25	8	0	0\n25	8	0	1\n25	8	6	6\n25	8	6	89\n25	8	7	7\n25	8	7	88\n25	8	8	7	8	11\n25	8	8	1	144	1\n25	8	9	6	9\n25	8	9	2	242\n25	8	10	9	10\n25	8	10	1	87\n25	8	11	6	9	10	11	12	13\n25	8	11	2	2	2	1066	2	1\n25	8	12	11	12	13\n25	8	12	4	764	1\n25	8	13	6	11	12	13	15\n25	8	13	12	1	3	1245	1\n25	8	14	6	12	13	14\n25	8	14	1	1	2	373\n25	8	15	6	13	14	15\n25	8	15	4	5	1	860\n25	8	16	9	15	16	17\n25	8	16	1	1	128	1\n25	8	17	17\n25	8	17	1\n25	8	18	18\n25	8	18	2\n25	8	20	20\n25	8	20	76\n25	8	21	9	21\n25	8	21	1	5\n25	8	37	20	37\n25	8	37	1	5\n25	9	0	0\n25	9	0	1\n25	9	6	6\n25	9	6	110\n25	9	7	7\n25	9	7	89\n25	9	8	6	7	8\n25	9	8	2	1	141\n25	9	9	6	8	9	10\n25	9	9	4	2	240	1\n25	9	10	6	10	11\n25	9	10	3	85	1\n25	9	11	6	9	10	11	12	13\n25	9	11	7	1	2	1060	1	1\n25	9	12	6	10	11	12\n25	9	12	2	3	2	763\n25	9	13	6	9	11	12	13	15\n25	9	13	22	4	2	3	1219	4\n25	9	14	13	14\n25	9	14	2	372\n25	9	15	6	9	13	14	15	16\n25	9	15	14	6	2	4	834	2\n25	9	16	9	15	16\n25	9	16	2	2	124\n25	9	17	17\n25	9	17	2\n25	9	18	9\n25	9	18	2\n25	9	20	20\n25	9	20	77\n25	9	21	9	21\n25	9	21	4	1\n25	9	37	20	37\n25	9	37	1	4\n25	10	0	0\n25	10	0	1\n25	10	6	6	9\n25	10	6	163	1\n25	10	7	7\n25	10	7	90\n25	10	8	8\n25	10	8	143\n25	10	9	6	7	8	9	10\n25	10	9	4	1	1	252	1\n25	10	10	6	9	10\n25	10	10	1	2	88\n25	10	11	6	7	10	11	12\n25	10	11	3	1	3	1057	1\n25	10	12	6	10	11	12	13\n25	10	12	2	1	1	762	1\n25	10	13	6	11	12	13	14	15\n25	10	13	21	2	5	1192	2	2\n25	10	14	6	8	12	14	16\n25	10	14	1	1	1	372	1\n25	10	15	6	9	13	14	15\n25	10	15	6	3	1	2	828\n25	10	16	16\n25	10	16	126\n25	10	17	17\n25	10	17	2\n25	10	20	20\n25	10	20	78\n25	10	21	21\n25	10	21	1\n25	10	37	37\n25	10	37	4\n25	11	0	0\n25	11	0	1\n25	11	6	6	9\n25	11	6	192	9\n25	11	7	7\n25	11	7	92\n25	11	8	8\n25	11	8	145\n25	11	9	6	7	9	11\n25	11	9	1	1	255	1\n25	11	10	9	10\n25	11	10	1	92\n25	11	11	9	10	11	13\n25	11	11	1	2	1055	2\n25	11	12	8	10	11	12	13\n25	11	12	1	1	3	763	1\n25	11	13	6	9	11	12	13	15\n25	11	13	5	1	1	2	1183	2\n25	11	14	13	14	16\n25	11	14	2	372	2\n25	11	15	13	15\n25	11	15	9	821\n25	11	16	15	16\n25	11	16	3	124\n25	11	17	16	17\n25	11	17	1	1\n25	11	20	16	20\n25	11	20	1	77\n25	11	21	21\n25	11	21	1\n25	11	37	37\n25	11	37	4\n25	12	0	0\n25	12	0	1\n25	12	6	6	8	9\n25	12	6	192	1	5\n25	12	7	6	7\n25	12	7	1	92\n25	12	8	6	7	8\n25	12	8	1	1	144\n25	12	9	9\n25	12	9	267\n25	12	10	6	10\n25	12	10	2	93\n25	12	11	6	9	10	11	12	13\n25	12	11	4	2	2	1049	1	2\n25	12	12	6	10	11	12	15\n25	12	12	1	2	7	754	1\n25	12	13	6	8	9	10	11	12	13	15\n25	12	13	9	1	1	1	4	3	1172	6\n25	12	14	12	14	16\n25	12	14	3	368	1\n25	12	15	6	9	13	14	15	16\n25	12	15	2	1	28	3	791	1\n25	12	16	14	15	16\n25	12	16	1	3	124\n25	12	17	17\n25	12	17	1\n25	12	20	16	20\n25	12	20	10	67\n25	12	21	21\n25	12	21	1\n25	12	37	20	37\n25	12	37	1	3\n25	13	0	0\n25	13	0	1\n25	13	6	6	7	9\n25	13	6	204	4	4\n25	13	7	6	7\n25	13	7	4	89\n25	13	8	6	8	9\n25	13	8	9	136	1\n25	13	9	6	7	8	9\n25	13	9	23	1	1	251\n25	13	10	6	9	10	11\n25	13	10	1	2	94	1\n25	13	11	6	8	9	10	11	12\n25	13	11	21	1	2	15	1016	5\n25	13	12	6	10	11	12	15\n25	13	12	3	7	7	743	1\n25	13	13	6	9	10	12	13	15\n25	13	13	102	7	2	4	1083	4\n25	13	14	6	8	9	10	11	12	13	14	20\n25	13	14	4	2	3	4	1	6	4	347	1\n25	13	15	6	8	9	11	13	14	15\n25	13	15	33	1	28	1	22	5	711\n25	13	16	8	10	14	15	16\n25	13	16	1	1	1	4	129\n25	13	17	16\n25	13	17	1\n25	13	20	14	15	16	17	20\n25	13	20	1	3	18	1	45\n25	13	21	13\n25	13	21	1\n25	13	37	37\n25	13	37	3\n25	14	0	0\n25	14	0	1\n25	14	6	6	7	9\n25	14	6	396	3	5\n25	14	7	6	7	9\n25	14	7	6	86	2\n25	14	8	6	7	8	9\n25	14	8	10	1	128	3\n25	14	9	6	8	9\n25	14	9	20	4	274\n25	14	10	6	9	10\n25	14	10	3	3	117\n25	14	11	6	8	9	10	11	12\n25	14	11	42	4	2	20	953	5\n25	14	12	6	8	9	10	11	12	15	16\n25	14	12	9	2	2	27	5	711	1	1\n25	14	13	6	8	9	10	12	13	14	15\n25	14	13	178	1	16	1	4	906	1	3\n25	14	14	6	8	9	10	11	12	13	14\n25	14	14	7	13	2	7	5	5	2	313\n25	14	15	6	8	9	10	11	13	14	15\n25	14	15	48	3	32	4	2	15	2	617\n25	14	16	8	9	10	11	12	14	15	16\n25	14	16	10	5	5	2	1	2	2	121\n25	14	17	17\n25	14	17	1\n25	14	20	15	16	17	20\n25	14	20	2	12	1	31\n25	14	37	37\n25	14	37	3\n25	15	0	0\n25	15	0	1\n25	15	6	6	9\n25	15	6	690	29\n25	15	7	6	7\n25	15	7	7	83\n25	15	8	6	8\n25	15	8	5	160\n25	15	9	6	7	8	9	11\n25	15	9	25	1	2	317	1\n25	15	10	6	8	9	10	11	12\n25	15	10	2	1	1	175	1	1\n25	15	11	6	8	10	11	12\n25	15	11	21	1	45	892	8\n25	15	12	6	8	10	11	12\n25	15	12	19	6	29	2	670\n25	15	13	6	8	9	10	11	12	13\n25	15	13	150	1	10	7	1	4	750\n25	15	14	6	8	9	10	11	12	13	14	16\n25	15	14	9	33	4	14	4	2	3	246	3\n25	15	15	6	8	9	10	11	12	13	15\n25	15	15	34	6	38	5	2	1	8	531\n25	15	16	8	9	10	11	13	14	15	16\n25	15	16	18	6	13	9	2	1	2	83\n25	15	17	13	17\n25	15	17	1	1\n25	15	20	14	15	16	20\n25	15	20	1	3	3	24\n25	15	37	11	16	37\n25	15	37	1	1	1\n25	16	0	0\n25	16	0	1\n25	16	6	6	9\n25	16	6	926	36\n25	16	7	6	7	9\n25	16	7	5	77	2\n25	16	8	6	8	9\n25	16	8	6	217	5\n25	16	9	6	8	9\n25	16	9	9	2	394\n25	16	10	9	10	12\n25	16	10	1	285	2\n25	16	11	6	8	10	11	12\n25	16	11	24	2	31	843	13\n25	16	12	6	8	10	11	12\n25	16	12	6	5	12	1	662\n25	16	13	6	9	10	11	12	13	14	15\n25	16	13	97	4	5	1	1	654	1	1\n25	16	14	6	8	9	10	11	12	13	14\n25	16	14	3	16	1	4	2	1	3	218\n25	16	15	6	8	9	10	11	12	13	14	15\n25	16	15	27	2	18	4	1	1	5	1	477\n25	16	16	8	9	10	11	15	16\n25	16	16	9	5	8	2	1	65\n25	16	17	17\n25	16	17	1\n25	16	20	20\n25	16	20	24\n25	16	37	37\n25	16	37	1\n25	17	0	0\n25	17	0	1\n25	17	6	6	9\n25	17	6	1058	45\n25	17	7	7\n25	17	7	77\n25	17	8	8	9\n25	17	8	245	8\n25	17	9	6	8	9\n25	17	9	12	2	452\n25	17	10	9	10	12\n25	17	10	1	344	4\n25	17	11	6	7	8	9	10	11	12\n25	17	11	8	2	4	1	23	805	7\n25	17	12	6	8	10	11	12\n25	17	12	5	1	8	4	662\n25	17	13	6	8	9	10	11	12	13\n25	17	13	47	1	2	2	2	4	604\n25	17	14	6	8	10	11	12	14\n25	17	14	4	10	1	3	1	201\n25	17	15	6	8	9	10	12	13	14	15\n25	17	15	20	3	8	4	1	1	1	441\n25	17	16	8	10	11	14	16	17\n25	17	16	5	3	1	1	54	1\n25	17	17	17\n25	17	17	1\n25	17	20	20\n25	17	20	24\n25	17	37	37\n25	17	37	1\n25	18	0	0\n25	18	0	1\n25	18	6	6	9\n25	18	6	1129	25\n25	18	7	6	7\n25	18	7	1	78\n25	18	8	6	8	9\n25	18	8	1	268	2\n25	18	9	6	9\n25	18	9	4	513\n25	18	10	6	8	9	10	12\n25	18	10	1	1	1	377	5\n25	18	11	6	9	10	11	12\n25	18	11	6	2	7	797	3\n25	18	12	6	7	8	10	11	12	15\n25	18	12	1	1	1	6	2	667	1\n25	18	13	6	9	11	12	13	15\n25	18	13	20	1	1	2	577	4\n25	18	14	6	8	9	10	12	13	14\n25	18	14	1	3	2	1	1	1	194\n25	18	15	6	9	15\n25	18	15	5	5	431\n25	18	16	16\n25	18	16	54\n25	18	17	17\n25	18	17	2\n25	18	20	20\n25	18	20	24\n25	18	37	37\n25	18	37	1\n25	19	0	0\n25	19	0	1\n25	19	6	6	9\n25	19	6	1145	24\n25	19	7	6	7	8	9	10\n25	19	7	1	74	1	2	1\n25	19	8	6	8	9	10\n25	19	8	2	268	1	2\n25	19	9	6	7	8	9\n25	19	9	2	1	1	547\n25	19	10	8	9	10	12\n25	19	10	1	2	387	1\n25	19	11	6	9	10	11	12	13\n25	19	11	5	3	4	785	2	1\n25	19	12	6	10	11	12	13\n25	19	12	5	1	1	669	2\n25	19	13	6	13	15\n25	19	13	8	568	2\n25	19	14	12	13	14\n25	19	14	1	1	192\n25	19	15	9	14	15\n25	19	15	3	2	431\n25	19	16	16\n25	19	16	54\n25	19	17	17\n25	19	17	2\n25	19	20	20\n25	19	20	24\n25	19	37	37\n25	19	37	1\n25	20	0	0\n25	20	0	1\n25	20	6	6	7	8	9	11\n25	20	6	1156	2	1	8	1\n25	20	7	7	9\n25	20	7	74	1\n25	20	8	7	8	9\n25	20	8	1	269	1\n25	20	9	6	7	8	9	10	11\n25	20	9	1	2	1	576	1	1\n25	20	10	8	9	10	12\n25	20	10	1	3	390	1\n25	20	11	6	10	11	12	13	14\n25	20	11	3	1	777	3	1	1\n25	20	12	6	10	11	12	15\n25	20	12	1	2	1	668	1\n25	20	13	12	13	15\n25	20	13	2	567	3\n25	20	14	13	14\n25	20	14	1	193\n25	20	15	6	13	15\n25	20	15	2	1	430\n25	20	16	16	17	20\n25	20	16	52	1	1\n25	20	17	17\n25	20	17	2\n25	20	20	20\n25	20	20	24\n25	20	37	37\n25	20	37	1\n25	21	0	0\n25	21	0	1\n25	21	6	6	9\n25	21	6	1161	2\n25	21	7	7\n25	21	7	79\n25	21	8	8\n25	21	8	272\n25	21	9	8	9\n25	21	9	1	588\n25	21	10	9	10	11\n25	21	10	3	390	1\n25	21	11	11	12\n25	21	11	776	4\n25	21	12	12	13	18\n25	21	12	672	1	1\n25	21	13	11	12	13	15\n25	21	13	3	6	560	1\n25	21	14	12	13	14\n25	21	14	1	1	192\n25	21	15	15\n25	21	15	434\n25	21	16	16	17\n25	21	16	51	1\n25	21	17	17\n25	21	17	3\n25	21	20	20\n25	21	20	25\n25	21	37	37\n25	21	37	1\n25	22	0	0\n25	22	0	1\n25	22	6	6\n25	22	6	1161\n25	22	7	7\n25	22	7	79\n25	22	8	8\n25	22	8	273\n25	22	9	6	7	9	11\n25	22	9	1	1	590	1\n25	22	10	9	10\n25	22	10	2	388\n25	22	11	10	11	12\n25	22	11	1	776	3\n25	22	12	10	11	12	13\n25	22	12	1	1	680	1\n25	22	13	12	13	15\n25	22	13	5	553	4\n25	22	14	12	13	14\n25	22	14	1	4	187\n25	22	15	13	14	15	16\n25	22	15	1	1	432	1\n25	22	16	16\n25	22	16	51\n25	22	17	17\n25	22	17	4\n25	22	18	18\n25	22	18	1\n25	22	20	20\n25	22	20	25\n25	22	37	37\n25	22	37	1\n25	23	0	0\n25	23	0	1\n25	23	6	6\n25	23	6	1162\n25	23	7	7\n25	23	7	80\n25	23	8	7	8\n25	23	8	3	270\n25	23	9	6	7	8	9\n25	23	9	125	10	20	437\n25	23	10	7	8	9	10\n25	23	10	2	8	5	375\n25	23	11	8	9	10	11	12\n25	23	11	3	4	5	762	4\n25	23	12	7	8	9	10	11	12\n25	23	12	2	6	7	21	52	601\n25	23	13	8	9	10	11	12	13	15\n25	23	13	3	5	2	17	6	521	5\n25	23	14	9	10	11	12	13	14\n25	23	14	5	9	7	10	23	134\n25	23	15	9	11	12	13	14	15\n25	23	15	4	6	6	56	8	356\n25	23	16	13	15	16	17\n25	23	16	1	1	49	1\n25	23	17	17\n25	23	17	4\n25	23	18	12\n25	23	18	1\n25	23	20	16	20\n25	23	20	20	5\n25	23	37	37\n25	23	37	1\n25	24	0	0\n25	24	0	1\n25	24	6	6\n25	24	6	1287\n25	24	7	7\n25	24	7	97\n25	24	8	7	8\n25	24	8	2	308\n25	24	9	6	7	8	9\n25	24	9	113	6	13	335\n25	24	10	7	8	9	10\n25	24	10	2	2	6	402\n25	24	11	9	10	11	12\n25	24	11	4	5	829	6\n25	24	12	9	10	11	12	13\n25	24	12	3	24	31	569	1\n25	24	13	9	11	12	13	15	17\n25	24	13	2	12	5	579	2	1\n25	24	14	9	10	11	12	13	14	16\n25	24	14	1	1	2	1	6	129	2\n25	24	15	12	13	15	16\n25	24	15	1	34	326	1\n25	24	16	12	13	14	15	16\n25	24	16	1	1	1	1	65\n25	24	17	17\n25	24	17	5\n25	24	20	16	20\n25	24	20	4	1\n25	24	37	16\n25	24	37	1\n26	1	0	0\n26	1	0	6\n26	1	6	6	9\n26	1	6	51	2\n26	1	7	7	8	9\n26	1	7	60	3	2\n26	1	8	8	11\n26	1	8	96	2\n26	1	9	7	9	10	11	12	13\n26	1	9	1	179	1	2	1	4\n26	1	10	10	11	12	13\n26	1	10	64	1	2	1\n26	1	11	11	12	13	14\n26	1	11	647	6	3	1\n26	1	12	11	12	13	14	15\n26	1	12	15	474	3	2	3\n26	1	13	11	12	13	14	15	23\n26	1	13	1	2	813	3	11	1\n26	1	14	12	13	14\n26	1	14	1	1	248\n26	1	15	12	13	15	16	21\n26	1	15	1	13	626	3	1\n26	1	16	14	15	16	20	21\n26	1	16	5	1	112	12	2\n26	1	17	14	17\n26	1	17	1	2\n26	1	18	18\n26	1	18	4\n26	1	20	20\n26	1	20	16\n26	1	21	21\n26	1	21	6\n26	1	37	37\n26	1	37	1\n26	2	0	0\n26	2	0	6\n26	2	6	6	9\n26	2	6	49	2\n26	2	7	7	9	12\n26	2	7	57	3	1\n26	2	8	8	9	11	12	13\n26	2	8	90	1	2	5	1\n26	2	9	8	9	12	13\n26	2	9	1	179	1	2\n26	2	10	9	10	12	14\n26	2	10	1	60	1	3\n26	2	11	10	11	12	13	15\n26	2	11	4	644	15	3	2\n26	2	12	11	12	13	14\n26	2	12	9	474	1	3\n26	2	13	11	12	13	14	15\n26	2	13	3	1	815	5	14\n26	2	14	12	14	15\n26	2	14	1	256	3\n26	2	15	13	14	15	16	21\n26	2	15	19	1	618	1	2\n26	2	16	11	14	15	16	20\n26	2	16	1	5	1	88	20\n26	2	17	17	20\n26	2	17	1	1\n26	2	18	18\n26	2	18	4\n26	2	20	20\n26	2	20	28\n26	2	21	21\n26	2	21	9\n26	2	23	23\n26	2	23	1\n26	2	37	37\n26	2	37	1\n26	3	0	0\n26	3	0	6\n26	3	6	6\n26	3	6	49\n26	3	7	7\n26	3	7	57\n26	3	8	8\n26	3	8	91\n26	3	9	9	10\n26	3	9	185	1\n26	3	10	10\n26	3	10	64\n26	3	11	10	11	12	13\n26	3	11	1	655	1	2\n26	3	12	11	12\n26	3	12	8	491\n26	3	13	11	12	13	15\n26	3	13	1	1	836	3\n26	3	14	14\n26	3	14	273\n26	3	15	13	15\n26	3	15	12	626\n26	3	16	14	15	16\n26	3	16	1	3	85\n26	3	17	17\n26	3	17	1\n26	3	18	18\n26	3	18	4\n26	3	20	20\n26	3	20	49\n26	3	21	21\n26	3	21	11\n26	3	23	23\n26	3	23	1\n26	3	37	37\n26	3	37	1\n26	4	0	0\n26	4	0	6\n26	4	6	6\n26	4	6	49\n26	4	7	7\n26	4	7	57\n26	4	8	7	8\n26	4	8	1	90\n26	4	9	9\n26	4	9	185\n26	4	10	9	10\n26	4	10	1	65\n26	4	11	11	12	13\n26	4	11	662	1	1\n26	4	12	9	10	11	12\n26	4	12	1	1	6	485\n26	4	13	12	13\n26	4	13	5	845\n26	4	14	11	12	14\n26	4	14	1	1	272\n26	4	15	13	14	15\n26	4	15	7	4	621\n26	4	16	15	16\n26	4	16	2	83\n26	4	17	17\n26	4	17	1\n26	4	18	18\n26	4	18	4\n26	4	20	16	20\n26	4	20	1	48\n26	4	21	21\n26	4	21	11\n26	4	23	23\n26	4	23	1\n26	4	37	37\n26	4	37	1\n26	5	0	0\n26	5	0	6\n26	5	6	6\n26	5	6	49\n26	5	7	7\n26	5	7	58\n26	5	8	8\n26	5	8	90\n26	5	9	9	10\n26	5	9	186	1\n26	5	10	9	10\n26	5	10	2	64\n26	5	11	10	11	13\n26	5	11	1	666	2\n26	5	12	11	12	13	15\n26	5	12	7	483	1	1\n26	5	13	12	13	14	15	20\n26	5	13	4	845	2	1	1\n26	5	14	14\n26	5	14	276\n26	5	15	13	15\n26	5	15	11	612\n26	5	16	14	15	16\n26	5	16	1	2	81\n26	5	17	17\n26	5	17	1\n26	5	18	18\n26	5	18	4\n26	5	20	20\n26	5	20	48\n26	5	21	21\n26	5	21	11\n26	5	23	23\n26	5	23	1\n26	5	37	37\n26	5	37	1\n26	6	0	0\n26	6	0	6\n26	6	6	6\n26	6	6	49\n26	6	7	7\n26	6	7	58\n26	6	8	7	8\n26	6	8	1	89\n26	6	9	8	9\n26	6	9	1	187\n26	6	10	9	10\n26	6	10	2	64\n26	6	11	10	11	13\n26	6	11	1	671	1\n26	6	12	11	12\n26	6	12	11	476\n26	6	13	7	12	13	14	15\n26	6	13	2	4	849	1	3\n26	6	14	13	14\n26	6	14	1	278\n26	6	15	7	13	14	15	16\n26	6	15	2	8	1	604	1\n26	6	16	14	16\n26	6	16	1	80\n26	6	17	17\n26	6	17	1\n26	6	18	15	18\n26	6	18	1	3\n26	6	20	20\n26	6	20	49\n26	6	21	15	21\n26	6	21	1	10\n26	6	23	11\n26	6	23	1\n26	6	37	37\n26	6	37	1\n26	7	0	0\n26	7	0	6\n26	7	6	6\n26	7	6	49\n26	7	7	7\n26	7	7	63\n26	7	8	8\n26	7	8	90\n26	7	9	6	9	10	13\n26	7	9	1	185	2	1\n26	7	10	10\n26	7	10	65\n26	7	11	6	10	11	13\n26	7	11	1	1	680	1\n26	7	12	11	12	13	15\n26	7	12	5	472	1	2\n26	7	13	6	12	13	15\n26	7	13	2	4	848	5\n26	7	14	13	14\n26	7	14	2	279\n26	7	15	6	12	13	14	15	16\n26	7	15	1	1	6	2	598	1\n26	7	16	14	16\n26	7	16	1	80\n26	7	17	17\n26	7	17	1\n26	7	18	9	15	18\n26	7	18	1	1	1\n26	7	20	20	29\n26	7	20	48	1\n26	7	21	13	15	21\n26	7	21	1	3	6\n26	7	37	37\n26	7	37	1\n26	8	0	0\n26	8	0	6\n26	8	6	6\n26	8	6	54\n26	8	7	7\n26	8	7	63\n26	8	8	8\n26	8	8	90\n26	8	9	6	9	10\n26	8	9	1	184	1\n26	8	10	9	10	13\n26	8	10	1	66	1\n26	8	11	6	10	11	12	13\n26	8	11	2	4	676	1	2\n26	8	12	6	11	12	13	15\n26	8	12	1	3	471	1	1\n26	8	13	6	9	13	14	15\n26	8	13	3	2	852	1	2\n26	8	14	13	14\n26	8	14	1	281\n26	8	15	6	13	15\n26	8	15	4	1	604\n26	8	16	14	15	16\n26	8	16	1	2	78\n26	8	17	17\n26	8	17	1\n26	8	18	18\n26	8	18	1\n26	8	20	20\n26	8	20	48\n26	8	21	21\n26	8	21	6\n26	8	29	30\n26	8	29	1\n26	8	37	37\n26	8	37	1\n26	9	0	0\n26	9	0	6\n26	9	6	6\n26	9	6	65\n26	9	7	6	7\n26	9	7	2	61\n26	9	8	6	8	9\n26	9	8	2	85	3\n26	9	9	6	9	10\n26	9	9	6	180	1\n26	9	10	9	10	11\n26	9	10	1	69	1\n26	9	11	6	10	11\n26	9	11	4	1	674\n26	9	12	10	11	12\n26	9	12	1	2	469\n26	9	13	6	9	10	12	13	14	15\n26	9	13	22	1	2	1	829	2	1\n26	9	14	6	8	9	13	14	16\n26	9	14	1	1	1	1	277	2\n26	9	15	6	9	12	14	15\n26	9	15	9	2	1	1	596\n26	9	16	9	16\n26	9	16	1	77\n26	9	17	17\n26	9	17	1\n26	9	18	9\n26	9	18	1\n26	9	20	16	20\n26	9	20	1	47\n26	9	21	6	9	21\n26	9	21	1	4	1\n26	9	30	32\n26	9	30	1\n26	9	37	20\n26	9	37	1\n26	10	0	0\n26	10	0	6\n26	10	6	6\n26	10	6	112\n26	10	7	7\n26	10	7	61\n26	10	8	6	8	9\n26	10	8	3	82	1\n26	10	9	7	9	10\n26	10	9	1	192	1\n26	10	10	6	9	10\n26	10	10	2	2	70\n26	10	11	6	9	11	12\n26	10	11	5	1	669	2\n26	10	12	10	11	12	13	15	18\n26	10	12	2	4	462	1	1	1\n26	10	13	6	9	12	13	14\n26	10	13	16	2	3	808	1\n26	10	14	8	11	13	14\n26	10	14	1	1	1	277\n26	10	15	6	9	14	15	16\n26	10	15	10	7	1	577	2\n26	10	16	15	16	20\n26	10	16	1	78	1\n26	10	17	16\n26	10	17	1\n26	10	20	20\n26	10	20	48\n26	10	21	21\n26	10	21	1\n26	10	32	32\n26	10	32	1\n26	11	0	0\n26	11	0	6\n26	11	6	6	9\n26	11	6	141	7\n26	11	7	6	7\n26	11	7	1	61\n26	11	8	8\n26	11	8	83\n26	11	9	6	9\n26	11	9	3	202\n26	11	10	6	9	10\n26	11	10	1	1	71\n26	11	11	6	10	11	12\n26	11	11	2	7	662	3\n26	11	12	6	10	11	12	13\n26	11	12	2	1	3	460	1\n26	11	13	6	9	11	12	13	15\n26	11	13	10	4	3	3	789	1\n26	11	14	8	13	14	16\n26	11	14	1	1	276	1\n26	11	15	6	8	9	13	14	15\n26	11	15	3	1	1	1	2	571\n26	11	16	16\n26	11	16	81\n26	11	18	18\n26	11	18	1\n26	11	20	20\n26	11	20	49\n26	11	21	21\n26	11	21	1\n26	11	32	33\n26	11	32	1\n26	12	0	0\n26	12	0	6\n26	12	6	6	9	11\n26	12	6	158	4	1\n26	12	7	7	9\n26	12	7	60	1\n26	12	8	8	9	13\n26	12	8	83	1	1\n26	12	9	6	7	9\n26	12	9	1	1	213\n26	12	10	6	10	12\n26	12	10	1	77	1\n26	12	11	6	10	11\n26	12	11	1	1	666\n26	12	12	11	12	13\n26	12	12	3	462	1\n26	12	13	6	13	14	15\n26	12	13	1	787	1	3\n26	12	14	10	12	13	14	16\n26	12	14	1	1	3	272	1\n26	12	15	6	13	14	15\n26	12	15	2	7	4	559\n26	12	16	14	16	17\n26	12	16	1	80	1\n26	12	18	12\n26	12	18	1\n26	12	20	16	20\n26	12	20	5	44\n26	12	21	21\n26	12	21	1\n26	12	33	38\n26	12	33	1\n26	13	0	0\n26	13	0	6\n26	13	6	6	9\n26	13	6	161	3\n26	13	7	6	7\n26	13	7	2	59\n26	13	8	6	8	9\n26	13	8	4	78	1\n26	13	9	6	9\n26	13	9	11	208\n26	13	10	8	9	10\n26	13	10	1	1	77\n26	13	11	6	9	10	11	12	13\n26	13	11	13	2	7	646	1	1\n26	13	12	6	10	11	12	13\n26	13	12	1	1	5	457	1\n26	13	13	6	9	10	12	13	15\n26	13	13	21	2	1	6	763	6\n26	13	14	6	8	10	11	12	13	14	15\n26	13	14	2	2	1	1	3	1	267	1\n26	13	15	6	9	10	12	13	14	15\n26	13	15	13	6	1	2	15	2	523\n26	13	16	9	14	15	16\n26	13	16	1	3	2	80\n26	13	17	17\n26	13	17	1\n26	13	20	16	20\n26	13	20	8	36\n26	13	21	21\n26	13	21	1\n26	13	38	40\n26	13	38	1\n26	14	0	0\n26	14	0	6\n26	14	6	6	7	9\n26	14	6	225	1	2\n26	14	7	6	7\n26	14	7	6	53\n26	14	8	6	7	8	9	13\n26	14	8	3	1	71	5	1\n26	14	9	6	7	8	9\n26	14	9	16	1	2	205\n26	14	10	6	10	12\n26	14	10	5	82	1\n26	14	11	6	8	9	10	11	12	13\n26	14	11	19	2	3	11	605	11	1\n26	14	12	6	8	9	10	11	12\n26	14	12	4	2	1	9	4	449\n26	14	13	6	8	9	10	11	12	13	14	15\n26	14	13	82	3	9	3	3	3	676	1	1\n26	14	14	6	8	9	10	11	12	13	14	16\n26	14	14	3	13	3	1	1	5	1	244	1\n26	14	15	6	8	9	12	13	15	16\n26	14	15	34	1	39	2	14	441	1\n26	14	16	8	9	10	11	12	15	16\n26	14	16	7	1	2	2	1	1	74\n26	14	17	17\n26	14	17	1\n26	14	20	8	15	16	20\n26	14	20	1	1	9	25\n26	14	21	12\n26	14	21	1\n26	14	40	40\n26	14	40	1\n26	15	0	0\n26	15	0	6\n26	15	6	6	7	9\n26	15	6	385	1	11\n26	15	7	7\n26	15	7	56\n26	15	8	6	8\n26	15	8	6	96\n26	15	9	6	8	9\n26	15	9	15	2	251\n26	15	10	6	8	9	10	12\n26	15	10	3	1	2	101	1\n26	15	11	6	7	8	9	10	11	12\n26	15	11	16	1	2	1	30	549	16\n26	15	12	6	8	10	11	12\n26	15	12	10	7	17	3	436\n26	15	13	6	8	9	10	11	12	13	14	15\n26	15	13	126	2	10	1	1	3	547	1	2\n26	15	14	6	8	9	10	11	12	13	14	16\n26	15	14	8	24	3	12	3	2	5	187	1\n26	15	15	6	8	9	10	11	12	13	15	16\n26	15	15	45	2	33	2	1	1	4	355	1\n26	15	16	8	9	10	11	13	14	15	16\n26	15	16	7	4	4	5	1	2	2	60\n26	15	17	17\n26	15	17	1\n26	15	20	15	16	20\n26	15	20	1	6	18\n26	15	40	40\n26	15	40	1\n26	16	0	0\n26	16	0	6\n26	16	6	6	9\n26	16	6	585	29\n26	16	7	6	7\n26	16	7	9	49\n26	16	8	6	8	9\n26	16	8	4	137	2\n26	16	9	6	8	9\n26	16	9	24	5	286\n26	16	10	8	10	12\n26	16	10	1	165	1\n26	16	11	6	8	10	11	12\n26	16	11	18	3	28	505	8\n26	16	12	6	7	8	10	12\n26	16	12	10	1	2	26	420\n26	16	13	6	8	9	10	11	12	13\n26	16	13	94	1	7	5	1	2	447\n26	16	14	6	8	9	10	11	12	13	14	16\n26	16	14	2	18	2	11	1	6	2	146	2\n26	16	15	6	8	9	10	11	13	15\n26	16	15	33	2	32	1	1	4	287\n26	16	16	8	9	10	11	16\n26	16	16	8	5	8	5	42\n26	16	17	17\n26	16	17	1\n26	16	20	16	17	20\n26	16	20	2	1	15\n26	16	40	40\n26	16	40	1\n26	17	0	0\n26	17	0	6\n26	17	6	6	9\n26	17	6	744	35\n26	17	7	6	7	8\n26	17	7	2	46	2\n26	17	8	6	8	9\n26	17	8	1	175	1\n26	17	9	6	8	9\n26	17	9	9	2	352\n26	17	10	6	9	10	12\n26	17	10	1	2	236	5\n26	17	11	6	8	9	10	11	12\n26	17	11	13	1	1	18	476	4\n26	17	12	6	8	10	11	12\n26	17	12	4	4	9	2	418\n26	17	13	6	8	9	10	12	13\n26	17	13	51	2	4	2	2	392\n26	17	14	6	8	10	11	12	13	14\n26	17	14	4	6	4	1	2	1	128\n26	17	15	6	8	9	10	13	15\n26	17	15	16	3	8	2	3	255\n26	17	16	8	9	10	11	12	13	14	16\n26	17	16	2	2	2	2	1	1	1	35\n26	17	17	17\n26	17	17	2\n26	17	20	14	20\n26	17	20	1	14\n26	17	40	40\n26	17	40	1\n26	18	0	0\n26	18	0	6\n26	18	6	6	9\n26	18	6	823	22\n26	18	7	6	7\n26	18	7	1	45\n26	18	8	6	8	9\n26	18	8	1	194	2\n26	18	9	6	8	9\n26	18	9	14	5	386\n26	18	10	9	10	12\n26	18	10	1	270	2\n26	18	11	6	8	9	10	11	12\n26	18	11	3	3	1	9	462	3\n26	18	12	6	8	10	12	13\n26	18	12	3	3	3	421	2\n26	18	13	6	8	9	12	13	14\n26	18	13	26	1	2	2	365	1\n26	18	14	8	10	13	14\n26	18	14	7	2	2	119\n26	18	15	6	9	13	15\n26	18	15	8	4	3	240\n26	18	16	8	9	10	16\n26	18	16	2	1	3	29\n26	18	17	17\n26	18	17	2\n26	18	20	20\n26	18	20	14\n26	18	40	37\n26	18	40	1\n26	19	0	0\n26	19	0	6\n26	19	6	6	9\n26	19	6	857	22\n26	19	7	7\n26	19	7	45\n26	19	8	8	9\n26	19	8	212	3\n26	19	9	6	7	9\n26	19	9	3	1	415\n26	19	10	6	10	11	12\n26	19	10	1	281	1	4\n26	19	11	6	8	10	11	12\n26	19	11	4	2	5	448	3\n26	19	12	6	10	12\n26	19	12	5	2	421\n26	19	13	6	12	13\n26	19	13	16	1	355\n26	19	14	8	11	13	14\n26	19	14	3	1	2	114\n26	19	15	6	9	13	14	15\n26	19	15	3	2	1	1	233\n26	19	16	8	15	16\n26	19	16	1	1	27\n26	19	17	17\n26	19	17	2\n26	19	20	20\n26	19	20	14\n26	19	37	37\n26	19	37	1\n26	20	0	0\n26	20	0	6\n26	20	6	6	7	9\n26	20	6	877	3	9\n26	20	7	7	8\n26	20	7	45	1\n26	20	8	7	8	9	10\n26	20	8	1	215	1	1\n26	20	9	6	7	9\n26	20	9	3	1	438\n26	20	10	10	12\n26	20	10	286	2\n26	20	11	6	10	11	12\n26	20	11	1	2	446	1\n26	20	12	6	12\n26	20	12	1	428\n26	20	13	6	11	12	13	15\n26	20	13	3	1	1	351	2\n26	20	14	14\n26	20	14	115\n26	20	15	6	15\n26	20	15	1	233\n26	20	16	16\n26	20	16	27\n26	20	17	17\n26	20	17	2\n26	20	20	20\n26	20	20	14\n26	20	37	37\n26	20	37	1\n26	21	0	0\n26	21	0	6\n26	21	6	6	9\n26	21	6	873	13\n26	21	7	7	9\n26	21	7	49	1\n26	21	8	8\n26	21	8	216\n26	21	9	9\n26	21	9	448\n26	21	10	9	10	11\n26	21	10	1	287	1\n26	21	11	8	11	12	13	14\n26	21	11	1	442	2	1	1\n26	21	12	10	11	12	13\n26	21	12	2	3	425	2\n26	21	13	6	11	12	13	15\n26	21	13	2	1	3	344	1\n26	21	14	12	13	14\n26	21	14	1	1	113\n26	21	15	6	14	15\n26	21	15	1	1	233\n26	21	16	16	17\n26	21	16	26	1\n26	21	17	17\n26	21	17	2\n26	21	20	20\n26	21	20	14\n26	21	37	37\n26	21	37	1\n26	22	0	0\n26	22	0	6\n26	22	6	6	9\n26	22	6	870	6\n26	22	7	7	9\n26	22	7	47	2\n26	22	8	8	11\n26	22	8	216	1\n26	22	9	9\n26	22	9	463\n26	22	10	9	10	12\n26	22	10	4	284	1\n26	22	11	8	10	11	12\n26	22	11	1	1	443	2\n26	22	12	10	11	12	13	17\n26	22	12	1	1	427	1	1\n26	22	13	11	12	13\n26	22	13	1	1	346\n26	22	14	13	14	16\n26	22	14	1	113	1\n26	22	15	6	13	15	16\n26	22	15	1	1	231	1\n26	22	16	16\n26	22	16	26\n26	22	17	17\n26	22	17	3\n26	22	20	20\n26	22	20	14\n26	22	37	37\n26	22	37	1\n26	23	0	0\n26	23	0	6\n26	23	6	6	9\n26	23	6	870	1\n26	23	7	7\n26	23	7	47\n26	23	8	7	8\n26	23	8	1	216\n26	23	9	9\n26	23	9	475\n26	23	10	9	10\n26	23	10	2	284\n26	23	11	6	11\n26	23	11	1	445\n26	23	12	10	11	12\n26	23	12	1	2	428\n26	23	13	12	13	15\n26	23	13	3	343	3\n26	23	14	12	14	16	20\n26	23	14	1	110	1	1\n26	23	15	14	15	16\n26	23	15	1	229	1\n26	23	16	16\n26	23	16	28\n26	23	17	17\n26	23	17	4\n26	23	20	20\n26	23	20	14\n26	23	37	37\n26	23	37	1\n26	24	0	0\n26	24	0	6\n26	24	6	6\n26	24	6	871\n26	24	7	7\n26	24	7	48\n26	24	8	7	8\n26	24	8	2	214\n26	24	9	6	7	8	9\n26	24	9	99	8	7	364\n26	24	10	7	8	9	10\n26	24	10	4	6	2	273\n26	24	11	8	9	10	11	12\n26	24	11	2	1	1	442	1\n26	24	12	7	8	9	10	11	12\n26	24	12	2	6	2	21	32	369\n26	24	13	8	9	10	11	12	13	14\n26	24	13	3	3	3	6	4	323	1\n26	24	14	10	11	12	13	14\n26	24	14	7	4	4	8	88\n26	24	15	9	10	11	12	13	14	15\n26	24	15	1	1	1	2	36	8	183\n26	24	16	12	13	14	16\n26	24	16	1	1	1	27\n26	24	17	17\n26	24	17	4\n26	24	20	16	20\n26	24	20	11	4\n26	24	37	37\n26	24	37	1\n26	25	0	0\n26	25	0	6\n26	25	6	6\n26	25	6	970\n26	25	7	7\n26	25	7	64\n26	25	8	7	8\n26	25	8	4	234\n26	25	9	6	7	8	9\n26	25	9	97	2	8	266\n26	25	10	7	8	9	10\n26	25	10	1	2	3	300\n26	25	11	8	9	10	11	12\n26	25	11	2	2	2	476	3\n26	25	12	9	10	11	12\n26	25	12	1	18	16	346\n26	25	13	9	11	12	13	14	15\n26	25	13	2	7	3	352	1	3\n26	25	14	9	10	11	12	13	14	20\n26	25	14	1	2	3	3	1	87	1\n26	25	15	9	11	12	13	14	15\n26	25	15	1	1	1	13	2	165\n26	25	16	14	15	16\n26	25	16	1	1	36\n26	25	17	17\n26	25	17	4\n26	25	20	16	20\n26	25	20	3	1\n26	25	37	37\n26	25	37	1\n27	1	0	0\n27	1	0	7\n27	1	6	6	9\n27	1	6	43	2\n27	1	7	7	8	9\n27	1	7	40	1	3\n27	1	8	8	11\n27	1	8	54	2\n27	1	9	9	11	13\n27	1	9	97	2	3\n27	1	10	10	12	14\n27	1	10	31	1	1\n27	1	11	10	11	12\n27	1	11	1	404	9\n27	1	12	11	12	13	14\n27	1	12	13	310	1	4\n27	1	13	8	10	12	13	14	15\n27	1	13	1	1	3	534	2	4\n27	1	14	13	14	15\n27	1	14	2	169	1\n27	1	15	12	13	15\n27	1	15	1	11	433\n27	1	16	14	16	20	21\n27	1	16	3	69	7	1\n27	1	18	18\n27	1	18	1\n27	1	19	19\n27	1	19	1\n27	1	20	20\n27	1	20	9\n27	1	21	21\n27	1	21	1\n27	1	37	37\n27	1	37	1\n27	2	0	0\n27	2	0	7\n27	2	6	6	9\n27	2	6	41	2\n27	2	7	7	8	9\n27	2	7	37	2	1\n27	2	8	8	12\n27	2	8	54	2\n27	2	9	9	10	11	12	15\n27	2	9	95	1	3	2	1\n27	2	10	10	12	13	14\n27	2	10	30	1	1	1\n27	2	11	11	12	13\n27	2	11	408	9	4\n27	2	12	11	12	13	14\n27	2	12	5	315	3	1\n27	2	13	12	13	14	15\n27	2	13	1	537	3	10\n27	2	14	12	14	15	16\n27	2	14	1	174	3	1\n27	2	15	13	15\n27	2	15	6	432\n27	2	16	14	15	16	20	21\n27	2	16	2	1	52	13	1\n27	2	18	18\n27	2	18	1\n27	2	19	16\n27	2	19	1\n27	2	20	20\n27	2	20	16\n27	2	21	21\n27	2	21	2\n27	2	37	37\n27	2	37	1\n27	3	0	0\n27	3	0	7\n27	3	6	6\n27	3	6	41\n27	3	7	7\n27	3	7	37\n27	3	8	8\n27	3	8	56\n27	3	9	9	10\n27	3	9	97	1\n27	3	10	9	10\n27	3	10	1	30\n27	3	11	11\n27	3	11	416\n27	3	12	11	12	14\n27	3	12	6	324	1\n27	3	13	12	13	15\n27	3	13	3	547	1\n27	3	14	12	14\n27	3	14	2	179\n27	3	15	12	13	15	16\n27	3	15	1	10	435	1\n27	3	16	14	15	16\n27	3	16	2	2	50\n27	3	18	18\n27	3	18	1\n27	3	20	20\n27	3	20	29\n27	3	21	21\n27	3	21	3\n27	3	37	37\n27	3	37	1\n27	4	0	0\n27	4	0	7\n27	4	6	6\n27	4	6	41\n27	4	7	7\n27	4	7	37\n27	4	8	8\n27	4	8	56\n27	4	9	8	9\n27	4	9	1	97\n27	4	10	9	10\n27	4	10	1	30\n27	4	11	11\n27	4	11	422\n27	4	12	11	12	13\n27	4	12	7	322	1\n27	4	13	11	12	13\n27	4	13	1	2	554\n27	4	14	14\n27	4	14	182\n27	4	15	13	14	15\n27	4	15	6	2	430\n27	4	16	16\n27	4	16	51\n27	4	18	15\n27	4	18	1\n27	4	20	20\n27	4	20	29\n27	4	21	21\n27	4	21	3\n27	4	37	37\n27	4	37	1\n27	5	0	0\n27	5	0	7\n27	5	6	6\n27	5	6	41\n27	5	7	7\n27	5	7	37\n27	5	8	8\n27	5	8	57\n27	5	9	8	9	10\n27	5	9	1	96	1\n27	5	10	10\n27	5	10	30\n27	5	11	11	13\n27	5	11	429	1\n27	5	12	11	12	13\n27	5	12	7	316	1\n27	5	13	13	15	16\n27	5	13	558	2	1\n27	5	14	13	14\n27	5	14	1	183\n27	5	15	13	14	15\n27	5	15	2	4	425\n27	5	16	8	14	15	16\n27	5	16	1	1	1	48\n27	5	20	20\n27	5	20	29\n27	5	21	21\n27	5	21	3\n27	5	37	37\n27	5	37	1\n27	6	0	0\n27	6	0	7\n27	6	6	6	7\n27	6	6	40	1\n27	6	7	7\n27	6	7	37\n27	6	8	8\n27	6	8	59\n27	6	9	6	9\n27	6	9	1	95\n27	6	10	9	10\n27	6	10	1	30\n27	6	11	7	11\n27	6	11	1	435\n27	6	12	11	12\n27	6	12	2	314\n27	6	13	12	13\n27	6	13	1	562\n27	6	14	12	14\n27	6	14	1	187\n27	6	15	7	12	13	15\n27	6	15	1	1	3	423\n27	6	16	7	14	15	16	17\n27	6	16	1	1	1	45	1\n27	6	20	20\n27	6	20	29\n27	6	21	15	21\n27	6	21	1	2\n27	6	37	37\n27	6	37	1\n27	7	0	0\n27	7	0	7\n27	7	6	6\n27	7	6	41\n27	7	7	7\n27	7	7	41\n27	7	8	8\n27	7	8	59\n27	7	9	9\n27	7	9	96\n27	7	10	10\n27	7	10	30\n27	7	11	10	11	12	13\n27	7	11	3	432	1	1\n27	7	12	12	14\n27	7	12	316	1\n27	7	13	6	9	12	13	14	15\n27	7	13	1	1	2	559	1	1\n27	7	14	14\n27	7	14	188\n27	7	15	13	15\n27	7	15	4	421\n27	7	16	15	16\n27	7	16	1	44\n27	7	17	9\n27	7	17	1\n27	7	20	11	20\n27	7	20	1	28\n27	7	21	15	21\n27	7	21	1	1\n27	7	37	37\n27	7	37	1\n27	8	0	0\n27	8	0	7\n27	8	6	6\n27	8	6	42\n27	8	7	7	9\n27	8	7	40	1\n27	8	8	8\n27	8	8	59\n27	8	9	9\n27	8	9	98\n27	8	10	10\n27	8	10	33\n27	8	11	10	11\n27	8	11	2	431\n27	8	12	11	12\n27	8	12	2	317\n27	8	13	9	12	13	14	15\n27	8	13	1	1	560	1	1\n27	8	14	14\n27	8	14	190\n27	8	15	6	9	13	14	15\n27	8	15	3	1	3	1	416\n27	8	16	16\n27	8	16	44\n27	8	20	20\n27	8	20	28\n27	8	21	27\n27	8	21	1\n27	8	37	37\n27	8	37	1\n27	9	0	0\n27	9	0	7\n27	9	6	6\n27	9	6	45\n27	9	7	7\n27	9	7	40\n27	9	8	8\n27	9	8	59\n27	9	9	6	9\n27	9	9	2	99\n27	9	10	10\n27	9	10	35\n27	9	11	6	11	12\n27	9	11	1	431	1\n27	9	12	9	12	13\n27	9	12	1	315	2\n27	9	13	6	9	11	12	13	15\n27	9	13	11	1	1	8	541	1\n27	9	14	6	14\n27	9	14	1	191\n27	9	15	6	9	15\n27	9	15	6	4	407\n27	9	16	16\n27	9	16	44\n27	9	20	20\n27	9	20	28\n27	9	27	27\n27	9	27	1\n27	9	37	37\n27	9	37	1\n27	10	0	0\n27	10	0	7\n27	10	6	6\n27	10	6	66\n27	10	7	6	7\n27	10	7	1	39\n27	10	8	8\n27	10	8	59\n27	10	9	6	8	9\n27	10	9	3	1	101\n27	10	10	6	10\n27	10	10	2	33\n27	10	11	6	9	10	11	13\n27	10	11	3	1	5	422	1\n27	10	12	10	11	12	13	15\n27	10	12	5	1	315	2	1\n27	10	13	6	9	11	12	13\n27	10	13	21	4	1	1	516\n27	10	14	14\n27	10	14	191\n27	10	15	6	9	13	14	15	16\n27	10	15	8	9	1	2	387	1\n27	10	16	16\n27	10	16	44\n27	10	20	20\n27	10	20	28\n27	10	27	15\n27	10	27	1\n27	10	37	20\n27	10	37	1\n27	11	0	0\n27	11	0	7\n27	11	6	6	9\n27	11	6	102	2\n27	11	7	7\n27	11	7	39\n27	11	8	8\n27	11	8	60\n27	11	9	6	9\n27	11	9	1	114\n27	11	10	6	9	10\n27	11	10	1	2	40\n27	11	11	6	10	11	12\n27	11	11	2	4	417	1\n27	11	12	9	11	12	13\n27	11	12	1	2	312	1\n27	11	13	6	12	13\n27	11	13	15	2	503\n27	11	14	6	9	14\n27	11	14	1	1	191\n27	11	15	6	9	12	13	15\n27	11	15	4	3	2	2	378\n27	11	16	8	16\n27	11	16	1	44\n27	11	20	20\n27	11	20	29\n27	12	0	0\n27	12	0	7\n27	12	6	6	8	9\n27	12	6	119	1	6\n27	12	7	7\n27	12	7	39\n27	12	8	8\n27	12	8	61\n27	12	9	6	9\n27	12	9	2	121\n27	12	10	10\n27	12	10	44\n27	12	11	6	8	10	11	12\n27	12	11	1	1	3	411	3\n27	12	12	12\n27	12	12	317\n27	12	13	6	11	13	14	15\n27	12	13	4	1	497	2	2\n27	12	14	6	12	13	14\n27	12	14	1	2	1	187\n27	12	15	11	13	15	20\n27	12	15	1	4	372	1\n27	12	16	15	16\n27	12	16	1	43\n27	12	20	20\n27	12	20	29\n27	13	0	0\n27	13	0	7\n27	13	6	6	9\n27	13	6	126	1\n27	13	7	7\n27	13	7	39\n27	13	8	6	8\n27	13	8	2	61\n27	13	9	6	7	9	11\n27	13	9	2	2	122	1\n27	13	10	9	10	11\n27	13	10	2	44	1\n27	13	11	6	8	11	12\n27	13	11	2	1	407	3\n27	13	12	6	8	10	12	13\n27	13	12	1	1	2	316	2\n27	13	13	6	9	11	12	13	15\n27	13	13	12	2	1	1	481	5\n27	13	14	6	9	10	12	14\n27	13	14	1	1	2	1	184\n27	13	15	6	9	10	13	15	16\n27	13	15	3	1	1	11	358	1\n27	13	16	15	16\n27	13	16	2	41\n27	13	20	15	16	20\n27	13	20	1	2	27\n27	14	0	0\n27	14	0	7\n27	14	6	6	9\n27	14	6	147	2\n27	14	7	6	7	9\n27	14	7	5	34	2\n27	14	8	6	8\n27	14	8	5	58\n27	14	9	6	9	10\n27	14	9	7	121	1\n27	14	10	6	10\n27	14	10	1	48\n27	14	11	6	9	10	11	12	13\n27	14	11	10	2	10	384	3	1\n27	14	12	6	10	11	12	15\n27	14	12	3	5	1	311	1\n27	14	13	6	9	10	12	13	15\n27	14	13	37	6	1	2	445	3\n27	14	14	6	8	9	10	14\n27	14	14	2	3	2	3	174\n27	14	15	6	8	9	13	15\n27	14	15	18	3	15	10	320\n27	14	16	15	16\n27	14	16	1	43\n27	14	20	14	15	16	20\n27	14	20	1	1	5	20\n27	15	0	0\n27	15	0	7\n27	15	6	6	9	27\n27	15	6	233	1	1\n27	15	7	6	7\n27	15	7	4	30\n27	15	8	6	7	8\n27	15	8	4	1	59\n27	15	9	6	9\n27	15	9	12	138\n27	15	10	6	8	9	10\n27	15	10	3	1	1	63\n27	15	11	6	9	10	11	12	13	15\n27	15	11	14	1	10	352	6	1	1\n27	15	12	6	8	10	11	12\n27	15	12	5	2	13	1	295\n27	15	13	6	9	10	12	13	15\n27	15	13	92	9	4	2	347	2\n27	15	14	6	8	9	10	11	12	13	14\n27	15	14	2	10	6	2	2	2	1	150\n27	15	15	6	8	9	13	15\n27	15	15	31	1	29	10	255\n27	15	16	8	9	11	13	14	15	16\n27	15	16	1	1	1	1	2	1	41\n27	15	20	16	20\n27	15	20	7	13\n27	16	0	0\n27	16	0	7\n27	16	6	6	9\n27	16	6	392	8\n27	16	7	6	7\n27	16	7	1	30\n27	16	8	6	8	9	13\n27	16	8	5	66	2	1\n27	16	9	6	8	9\n27	16	9	11	2	173\n27	16	10	6	8	10\n27	16	10	2	1	89\n27	16	11	6	8	10	11	12\n27	16	11	9	1	19	319	8\n27	16	12	6	8	9	10	11	12	15\n27	16	12	5	1	2	11	1	284	1\n27	16	13	6	8	9	12	13\n27	16	13	69	2	6	1	282\n27	16	14	6	8	9	10	11	12	13	14\n27	16	14	1	15	2	6	5	3	1	119\n27	16	15	6	8	9	10	12	13	14	15\n27	16	15	25	3	18	2	1	5	1	204\n27	16	16	8	9	10	11	12	16\n27	16	16	7	3	4	4	1	29\n27	16	20	14	16	18	20\n27	16	20	1	3	1	8\n27	16	27	30\n27	16	27	1\n27	17	0	0\n27	17	0	7\n27	17	6	6	9\n27	17	6	499	21\n27	17	7	7\n27	17	7	30\n27	17	8	6	8	9\n27	17	8	1	95	2\n27	17	9	6	9\n27	17	9	8	206\n27	17	10	6	8	10	12	14\n27	17	10	1	2	126	1	1\n27	17	11	6	8	9	10	11	12\n27	17	11	11	2	2	12	297	5\n27	17	12	6	8	10	12\n27	17	12	4	6	12	276\n27	17	13	6	8	9	10	12	13	15\n27	17	13	57	3	3	2	4	218	2\n27	17	14	6	8	9	10	12	14	16\n27	17	14	4	16	1	5	2	92	1\n27	17	15	6	8	9	10	13	15\n27	17	15	20	1	13	3	1	167\n27	17	16	8	9	10	11	16\n27	17	16	6	2	2	2	20\n27	17	18	16\n27	17	18	1\n27	17	20	13	14	16	20\n27	17	20	1	1	1	5\n27	17	30	30\n27	17	30	1\n27	18	0	0\n27	18	0	7\n27	18	6	6	9\n27	18	6	591	14\n27	18	7	6	7\n27	18	7	1	29\n27	18	8	6	8	9\n27	18	8	2	127	2\n27	18	9	6	7	9	10\n27	18	9	3	1	245	1\n27	18	10	10	12\n27	18	10	160	2\n27	18	11	6	7	8	10	11	12\n27	18	11	5	1	2	11	277	3\n27	18	12	6	8	10	11	12\n27	18	12	6	3	6	2	271\n27	18	13	6	10	11	12	13\n27	18	13	35	2	1	1	181\n27	18	14	6	8	9	10	11	12	13	14\n27	18	14	2	5	1	6	1	1	1	77\n27	18	15	6	9	10	14	15\n27	18	15	5	9	2	1	152\n27	18	16	10	11	14	16\n27	18	16	2	2	1	18\n27	18	20	20\n27	18	20	5\n27	18	30	32\n27	18	30	1\n27	19	0	0\n27	19	0	7\n27	19	6	6	9\n27	19	6	629	21\n27	19	7	7\n27	19	7	31\n27	19	8	6	8	9\n27	19	8	1	135	1\n27	19	9	6	9\n27	19	9	11	260\n27	19	10	9	10	12\n27	19	10	1	185	4\n27	19	11	6	8	10	11	12\n27	19	11	5	1	3	270	4\n27	19	12	6	8	10	11	12	13\n27	19	12	3	1	2	1	270	1\n27	19	13	6	9	12	13	15\n27	19	13	12	1	3	165	1\n27	19	14	8	12	14	18\n27	19	14	1	1	76	1\n27	19	15	6	9	14	15\n27	19	15	4	3	1	144\n27	19	16	8	16	21\n27	19	16	2	15	1\n27	19	20	20\n27	19	20	5\n27	19	32	30\n27	19	32	1\n27	20	0	0\n27	20	0	7\n27	20	6	6	9\n27	20	6	656	9\n27	20	7	7	9	10\n27	20	7	29	1	1\n27	20	8	6	8	9	10\n27	20	8	1	137	1	1\n27	20	9	6	7	9\n27	20	9	5	1	281\n27	20	10	10	12\n27	20	10	189	1\n27	20	11	6	8	10	11	13\n27	20	11	3	1	3	263	1\n27	20	12	6	7	10	11	12\n27	20	12	2	1	2	1	276\n27	20	13	6	12	13	15\n27	20	13	3	1	161	1\n27	20	14	6	8	13	14\n27	20	14	1	2	1	73\n27	20	15	6	9	15\n27	20	15	2	3	140\n27	20	16	16	17\n27	20	16	14	1\n27	20	18	13\n27	20	18	1\n27	20	20	20\n27	20	20	5\n27	20	21	16\n27	20	21	1\n27	20	30	30\n27	20	30	1\n27	21	0	0\n27	21	0	7\n27	21	6	6	7	9\n27	21	6	660	2	11\n27	21	7	7\n27	21	7	31\n27	21	8	7	8\n27	21	8	1	139\n27	21	9	6	9\n27	21	9	1	294\n27	21	10	9	10\n27	21	10	1	195\n27	21	11	6	10	11	12\n27	21	11	1	1	260	2\n27	21	12	10	12\n27	21	12	2	276\n27	21	13	6	13\n27	21	13	1	163\n27	21	14	14\n27	21	14	73\n27	21	15	15\n27	21	15	141\n27	21	16	14	16\n27	21	16	1	14\n27	21	17	17\n27	21	17	1\n27	21	20	20\n27	21	20	5\n27	21	30	30\n27	21	30	1\n27	22	0	0\n27	22	0	7\n27	22	6	6	7	9\n27	22	6	658	1	4\n27	22	7	7\n27	22	7	34\n27	22	8	8\n27	22	8	139\n27	22	9	7	8	9\n27	22	9	1	2	303\n27	22	10	10	12	18\n27	22	10	196	1	1\n27	22	11	10	11\n27	22	11	1	259\n27	22	12	10	11	12\n27	22	12	1	1	276\n27	22	13	10	12	13\n27	22	13	1	2	160\n27	22	14	12	14\n27	22	14	2	72\n27	22	15	15\n27	22	15	141\n27	22	16	16\n27	22	16	14\n27	22	17	17\n27	22	17	1\n27	22	20	20\n27	22	20	5\n27	22	30	30\n27	22	30	1\n27	23	0	0\n27	23	0	7\n27	23	6	6	9\n27	23	6	656	2\n27	23	7	7	9\n27	23	7	35	1\n27	23	8	8\n27	23	8	141\n27	23	9	9	11\n27	23	9	306	1\n27	23	10	9	10	12\n27	23	10	1	197	1\n27	23	11	11	12	14\n27	23	11	258	1	1\n27	23	12	12	13\n27	23	12	280	1\n27	23	13	12	13\n27	23	13	1	159\n27	23	14	14\n27	23	14	72\n27	23	15	14	15\n27	23	15	1	140\n27	23	16	16\n27	23	16	14\n27	23	17	17\n27	23	17	1\n27	23	18	18\n27	23	18	1\n27	23	20	20\n27	23	20	5\n27	23	30	30\n27	23	30	1\n27	24	0	0\n27	24	0	7\n27	24	6	6\n27	24	6	656\n27	24	7	7\n27	24	7	35\n27	24	8	8\n27	24	8	141\n27	24	9	9\n27	24	9	310\n27	24	10	10\n27	24	10	197\n27	24	11	11	12\n27	24	11	255	4\n27	24	12	12\n27	24	12	283\n27	24	13	12	13\n27	24	13	1	159\n27	24	14	13	14\n27	24	14	1	73\n27	24	15	15\n27	24	15	140\n27	24	16	16\n27	24	16	14\n27	24	17	17\n27	24	17	1\n27	24	18	18\n27	24	18	1\n27	24	20	20\n27	24	20	5\n27	24	30	28\n27	24	30	1\n27	25	0	0\n27	25	0	7\n27	25	6	6\n27	25	6	656\n27	25	7	7\n27	25	7	35\n27	25	8	7	8\n27	25	8	2	139\n27	25	9	6	7	8	9\n27	25	9	86	1	8	215\n27	25	10	7	9	10\n27	25	10	1	2	194\n27	25	11	8	9	10	11	12\n27	25	11	1	1	3	249	1\n27	25	12	8	9	10	11	12\n27	25	12	2	4	11	27	244\n27	25	13	8	9	10	11	12	13	15\n27	25	13	1	1	4	6	3	144	1\n27	25	14	9	10	11	12	13	14\n27	25	14	3	2	1	4	7	56\n27	25	15	11	13	14	15\n27	25	15	3	18	1	118\n27	25	16	13	14	16\n27	25	16	1	1	12\n27	25	17	17\n27	25	17	1\n27	25	18	14\n27	25	18	1\n27	25	20	16	17	20\n27	25	20	3	1	1\n27	25	28	30\n27	25	28	1\n27	26	0	0\n27	26	0	7\n27	26	6	6\n27	26	6	742\n27	26	7	7\n27	26	7	39\n27	26	8	7	8\n27	26	8	1	150\n27	26	9	6	7	8	9\n27	26	9	48	1	3	174\n27	26	10	8	9	10\n27	26	10	1	2	211\n27	26	11	8	9	10	11	12\n27	26	11	1	2	3	278	2\n27	26	12	9	10	11	12	13\n27	26	12	2	7	12	230	1\n27	26	13	10	11	12	13\n27	26	13	1	2	1	166\n27	26	14	11	12	13	14\n27	26	14	1	4	2	52\n27	26	15	12	13	14	15\n27	26	15	1	10	2	106\n27	26	16	16\n27	26	16	15\n27	26	17	17\n27	26	17	2\n27	26	20	16\n27	26	20	1\n27	26	30	28\n27	26	30	1\n28	1	0	0\n28	1	0	2\n28	1	6	6\n28	1	6	32\n28	1	7	7	9\n28	1	7	35	1\n28	1	8	8	11\n28	1	8	38	1\n28	1	9	9	10	11\n28	1	9	77	1	2\n28	1	10	10	14\n28	1	10	24	2\n28	1	11	10	11	14	15\n28	1	11	2	270	1	1\n28	1	12	11	12\n28	1	12	7	200\n28	1	13	13	15\n28	1	13	398	3\n28	1	14	13	14	15\n28	1	14	2	108	1\n28	1	15	13	15	16	20\n28	1	15	8	300	1	1\n28	1	16	14	16	20\n28	1	16	5	56	6\n28	1	17	13	17\n28	1	17	1	1\n28	1	18	18\n28	1	18	1\n28	1	20	20\n28	1	20	4\n28	1	21	21\n28	1	21	2\n28	1	37	37\n28	1	37	1\n28	2	0	0\n28	2	0	2\n28	2	6	6	9\n28	2	6	31	1\n28	2	7	7	9	12\n28	2	7	32	2	1\n28	2	8	8\n28	2	8	38\n28	2	9	9\n28	2	9	78\n28	2	10	10	11	13\n28	2	10	24	1	2\n28	2	11	10	11	12	13\n28	2	11	1	269	6	4\n28	2	12	10	11	12	14	16\n28	2	12	1	3	194	1	1\n28	2	13	12	13	14	15\n28	2	13	2	399	2	6\n28	2	14	13	14	15\n28	2	14	1	113	2\n28	2	15	13	15	21\n28	2	15	5	299	1\n28	2	16	16	20\n28	2	16	41	16\n28	2	17	17\n28	2	17	1\n28	2	18	18\n28	2	18	1\n28	2	20	20	37\n28	2	20	10	1\n28	2	21	21\n28	2	21	2\n28	2	37	37\n28	2	37	1\n28	3	0	0\n28	3	0	2\n28	3	6	6\n28	3	6	31\n28	3	7	7\n28	3	7	32\n28	3	8	7	8\n28	3	8	1	37\n28	3	9	9\n28	3	9	81\n28	3	10	10\n28	3	10	26\n28	3	11	11\n28	3	11	273\n28	3	12	11	12\n28	3	12	4	199\n28	3	13	12	13\n28	3	13	1	410\n28	3	14	14\n28	3	14	116\n28	3	15	13	15\n28	3	15	4	303\n28	3	16	14	15	16\n28	3	16	1	1	40\n28	3	17	17\n28	3	17	1\n28	3	18	18\n28	3	18	1\n28	3	20	20\n28	3	20	26\n28	3	21	21\n28	3	21	3\n28	3	37	37\n28	3	37	2\n28	4	0	0\n28	4	0	2\n28	4	6	6\n28	4	6	31\n28	4	7	7\n28	4	7	33\n28	4	8	7	8\n28	4	8	1	36\n28	4	9	8	9\n28	4	9	1	80\n28	4	10	10\n28	4	10	26\n28	4	11	11\n28	4	11	277\n28	4	12	11	12\n28	4	12	3	197\n28	4	13	9	13	14\n28	4	13	1	412	1\n28	4	14	14\n28	4	14	117\n28	4	15	12	13	15\n28	4	15	1	6	297\n28	4	16	15	16\n28	4	16	1	39\n28	4	17	17\n28	4	17	1\n28	4	18	18\n28	4	18	1\n28	4	20	20\n28	4	20	26\n28	4	21	21\n28	4	21	3\n28	4	37	37\n28	4	37	2\n28	5	0	0\n28	5	0	2\n28	5	6	6\n28	5	6	31\n28	5	7	7\n28	5	7	34\n28	5	8	8\n28	5	8	37\n28	5	9	8	9\n28	5	9	1	80\n28	5	10	10\n28	5	10	26\n28	5	11	10	11\n28	5	11	1	279\n28	5	12	11	12\n28	5	12	3	195\n28	5	13	13	14	15\n28	5	13	416	1	1\n28	5	14	14\n28	5	14	118\n28	5	15	13	14	15\n28	5	15	4	1	293\n28	5	16	14	15	16\n28	5	16	1	1	37\n28	5	17	17\n28	5	17	1\n28	5	18	15\n28	5	18	1\n28	5	20	20\n28	5	20	26\n28	5	21	21\n28	5	21	3\n28	5	37	37\n28	5	37	2\n28	6	0	0\n28	6	0	2\n28	6	6	6\n28	6	6	31\n28	6	7	7\n28	6	7	34\n28	6	8	8\n28	6	8	38\n28	6	9	9\n28	6	9	80\n28	6	10	9	10\n28	6	10	2	25\n28	6	11	11	13\n28	6	11	280	2\n28	6	12	11	12	15\n28	6	12	6	188	1\n28	6	13	13	14	15\n28	6	13	418	1	1\n28	6	14	14\n28	6	14	121\n28	6	15	12	13	15\n28	6	15	2	2	292\n28	6	16	16\n28	6	16	37\n28	6	17	17\n28	6	17	1\n28	6	20	20\n28	6	20	26\n28	6	21	21\n28	6	21	3\n28	6	37	37\n28	6	37	2\n28	7	0	0\n28	7	0	2\n28	7	6	6\n28	7	6	31\n28	7	7	7\n28	7	7	34\n28	7	8	6	8\n28	7	8	1	37\n28	7	9	9\n28	7	9	82\n28	7	10	9	10\n28	7	10	1	24\n28	7	11	11	12	13\n28	7	11	283	1	2\n28	7	12	11	12\n28	7	12	1	189\n28	7	13	12	13	15\n28	7	13	2	419	1\n28	7	14	14\n28	7	14	122\n28	7	15	6	13	15\n28	7	15	1	6	287\n28	7	16	16\n28	7	16	37\n28	7	17	17\n28	7	17	1\n28	7	20	20\n28	7	20	26\n28	7	21	15\n28	7	21	3\n28	7	37	37\n28	7	37	2\n28	8	0	0\n28	8	0	2\n28	8	6	6\n28	8	6	33\n28	8	7	6	7\n28	8	7	1	33\n28	8	8	6	8\n28	8	8	1	36\n28	8	9	6	9	14\n28	8	9	1	81	1\n28	8	10	10\n28	8	10	24\n28	8	11	6	11	12\n28	8	11	2	281	1\n28	8	12	10	11	12	13\n28	8	12	2	2	187	1\n28	8	13	6	13	15\n28	8	13	2	423	2\n28	8	14	13	14\n28	8	14	1	121\n28	8	15	9	13	15\n28	8	15	1	2	288\n28	8	16	16\n28	8	16	37\n28	8	17	17\n28	8	17	1\n28	8	20	20\n28	8	20	26\n28	8	37	37\n28	8	37	2\n28	9	0	0\n28	9	0	2\n28	9	6	6\n28	9	6	40\n28	9	7	7\n28	9	7	33\n28	9	8	8\n28	9	8	36\n28	9	9	8	9\n28	9	9	1	81\n28	9	10	9	10\n28	9	10	2	24\n28	9	11	6	10	11	13\n28	9	11	1	1	280	1\n28	9	12	11	12\n28	9	12	1	187\n28	9	13	6	13\n28	9	13	5	422\n28	9	14	13	14\n28	9	14	1	121\n28	9	15	6	11	13	15\n28	9	15	4	1	1	284\n28	9	16	16\n28	9	16	37\n28	9	17	17\n28	9	17	1\n28	9	20	20\n28	9	20	26\n28	9	37	37\n28	9	37	2\n28	10	0	0\n28	10	0	2\n28	10	6	6	9\n28	10	6	49	1\n28	10	7	7\n28	10	7	33\n28	10	8	6	8\n28	10	8	1	36\n28	10	9	6	9\n28	10	9	2	81\n28	10	10	6	10\n28	10	10	2	23\n28	10	11	6	11\n28	10	11	6	276\n28	10	12	12\n28	10	12	187\n28	10	13	6	9	11	12	13\n28	10	13	13	1	1	2	408\n28	10	14	6	9	14	16\n28	10	14	3	1	116	1\n28	10	15	6	9	15\n28	10	15	6	2	276\n28	10	16	16\n28	10	16	37\n28	10	17	17\n28	10	17	1\n28	10	20	20\n28	10	20	26\n28	10	37	37\n28	10	37	2\n28	11	0	0\n28	11	0	2\n28	11	6	6\n28	11	6	82\n28	11	7	7\n28	11	7	33\n28	11	8	6	8\n28	11	8	1	35\n28	11	9	6	9\n28	11	9	5	81\n28	11	10	9	10\n28	11	10	1	22\n28	11	11	6	11	12\n28	11	11	3	273	1\n28	11	12	10	12\n28	11	12	1	188\n28	11	13	6	9	12	13	15\n28	11	13	14	2	1	390	1\n28	11	14	14\n28	11	14	116\n28	11	15	6	9	13	14	15\n28	11	15	3	6	1	1	265\n28	11	16	15	16\n28	11	16	1	37\n28	11	17	17\n28	11	17	1\n28	11	20	20\n28	11	20	26\n28	11	37	37\n28	11	37	2\n28	12	0	0\n28	12	0	2\n28	12	6	6	9\n28	12	6	106	2\n28	12	7	7\n28	12	7	33\n28	12	8	8\n28	12	8	35\n28	12	9	7	9\n28	12	9	2	88\n28	12	10	10\n28	12	10	23\n28	12	11	10	11\n28	12	11	1	272\n28	12	12	9	12\n28	12	12	1	189\n28	12	13	6	11	12	13	14	15\n28	12	13	5	1	2	378	2	3\n28	12	14	6	12	13	14	18\n28	12	14	1	1	1	113	1\n28	12	15	13	14	15\n28	12	15	3	1	263\n28	12	16	16\n28	12	16	37\n28	12	17	17\n28	12	17	1\n28	12	20	20\n28	12	20	26\n28	12	37	37\n28	12	37	2\n28	13	0	0\n28	13	0	2\n28	13	6	6	7	9\n28	13	6	107	1	4\n28	13	7	6	7\n28	13	7	1	34\n28	13	8	8\n28	13	8	35\n28	13	9	6	7	9\n28	13	9	1	2	88\n28	13	10	10\n28	13	10	24\n28	13	11	8	10	11	12\n28	13	11	1	1	270	1\n28	13	12	11	12\n28	13	12	1	191\n28	13	13	6	13	16	17\n28	13	13	4	376	1	1\n28	13	14	10	12	14\n28	13	14	1	1	114\n28	13	15	6	13	15	16\n28	13	15	1	8	256	1\n28	13	16	14	16\n28	13	16	1	36\n28	13	17	17\n28	13	17	1\n28	13	18	18\n28	13	18	1\n28	13	20	14	16	20\n28	13	20	1	2	23\n28	13	37	37\n28	13	37	2\n28	14	0	0\n28	14	0	2\n28	14	6	6\n28	14	6	114\n28	14	7	6	7\n28	14	7	4	33\n28	14	8	6	7	8	11\n28	14	8	3	1	31	1\n28	14	9	6	7	9\n28	14	9	8	1	83\n28	14	10	10\n28	14	10	26\n28	14	11	6	8	9	10	11	12	13\n28	14	11	2	2	2	1	262	1	1\n28	14	12	6	8	10	11	12\n28	14	12	1	1	3	2	186\n28	14	13	6	8	9	13\n28	14	13	16	1	5	362\n28	14	14	6	9	10	12	14\n28	14	14	1	2	1	1	111\n28	14	15	6	9	13	14	15\n28	14	15	5	3	4	3	241\n28	14	16	16\n28	14	16	40\n28	14	17	17\n28	14	17	2\n28	14	18	18\n28	14	18	1\n28	14	20	16	20\n28	14	20	1	22\n28	14	37	37\n28	14	37	2\n28	15	0	0\n28	15	0	2\n28	15	6	6	9\n28	15	6	149	5\n28	15	7	6	7	10\n28	15	7	5	29	1\n28	15	8	6	8	9\n28	15	8	3	31	1\n28	15	9	6	9\n28	15	9	10	85\n28	15	10	6	10\n28	15	10	2	29\n28	15	11	6	10	11	12	13\n28	15	11	6	5	247	5	2\n28	15	12	6	8	9	10	12	14\n28	15	12	4	1	1	6	175	1\n28	15	13	6	9	10	11	13	15\n28	15	13	62	11	1	2	289	2\n28	15	14	6	8	10	12	13	14\n28	15	14	3	4	1	4	1	101\n28	15	15	6	9	13	15	16\n28	15	15	31	16	7	186	1\n28	15	16	8	10	11	15	16\n28	15	16	5	1	1	2	32\n28	15	17	17\n28	15	17	2\n28	15	18	18\n28	15	18	1\n28	15	20	15	16	20\n28	15	20	2	5	15\n28	15	37	37\n28	15	37	2\n28	16	0	0\n28	16	0	2\n28	16	6	6	9\n28	16	6	270	5\n28	16	7	6	7\n28	16	7	6	23\n28	16	8	6	8	9\n28	16	8	6	33	2\n28	16	9	6	9\n28	16	9	7	112\n28	16	10	9	10\n28	16	10	1	43\n28	16	11	6	8	9	10	11	12\n28	16	11	14	1	1	14	216	4\n28	16	12	6	8	10	11	12\n28	16	12	7	4	8	3	162\n28	16	13	6	9	10	11	13	15\n28	16	13	60	10	1	1	226	1\n28	16	14	8	9	10	11	12	14\n28	16	14	12	2	5	2	2	79\n28	16	15	6	8	9	10	13	15\n28	16	15	26	2	14	4	3	143\n28	16	16	8	9	10	14	15	16\n28	16	16	5	1	1	1	1	29\n28	16	17	13	17\n28	16	17	1	1\n28	16	18	12\n28	16	18	1\n28	16	20	14	15	16	20\n28	16	20	2	1	5	7\n28	16	37	37\n28	16	37	2\n28	17	0	0\n28	17	0	2\n28	17	6	6	9\n28	17	6	388	8\n28	17	7	6	7	10\n28	17	7	1	21	1\n28	17	8	6	8	9\n28	17	8	1	55	1\n28	17	9	6	9\n28	17	9	9	139\n28	17	10	6	9	10	12\n28	17	10	1	1	72	2\n28	17	11	6	8	9	10	11	12\n28	17	11	10	2	1	15	188	6\n28	17	12	6	7	10	12\n28	17	12	11	1	9	148\n28	17	13	6	9	10	12	13	15\n28	17	13	40	3	1	1	184	1\n28	17	14	6	8	9	10	11	12	13	14	16\n28	17	14	5	10	1	7	3	1	1	52	2\n28	17	15	6	8	9	10	13	14	15\n28	17	15	18	3	9	2	3	1	110\n28	17	16	8	9	10	11	14	15	16\n28	17	16	4	4	1	3	1	2	19\n28	17	17	17\n28	17	17	1\n28	17	20	16	20\n28	17	20	1	6\n28	17	37	37\n28	17	37	2\n28	18	0	0\n28	18	0	2\n28	18	6	6	9\n28	18	6	461	23\n28	18	7	6	7\n28	18	7	1	21\n28	18	8	6	8	9	10\n28	18	8	3	68	2	1\n28	18	9	6	8	9	10\n28	18	9	11	1	154	1\n28	18	10	6	10	11\n28	18	10	2	105	1\n28	18	11	6	8	9	10	11	12\n28	18	11	9	2	1	15	162	5\n28	18	12	6	9	10	12\n28	18	12	4	1	4	149\n28	18	13	6	8	9	13	15\n28	18	13	37	2	2	145	2\n28	18	14	6	8	10	11	14	16\n28	18	14	2	11	3	4	33	1\n28	18	15	6	8	9	10	13	15\n28	18	15	13	1	7	2	2	88\n28	18	16	8	9	10	11	16\n28	18	16	5	2	4	1	10\n28	18	17	17\n28	18	17	1\n28	18	20	20\n28	18	20	6\n28	18	37	37\n28	18	37	2\n28	19	0	0\n28	19	0	2\n28	19	6	6	9\n28	19	6	529	14\n28	19	7	6	7\n28	19	7	1	20\n28	19	8	8	9\n28	19	8	89	1\n28	19	9	6	9\n28	19	9	3	189\n28	19	10	6	10	12\n28	19	10	1	133	1\n28	19	11	6	8	10	11\n28	19	11	2	2	2	162\n28	19	12	7	10	12\n28	19	12	1	3	150\n28	19	13	6	9	13\n28	19	13	17	1	129\n28	19	14	8	10	13	14\n28	19	14	2	1	1	29\n28	19	15	6	8	9	13	15\n28	19	15	3	2	6	1	78\n28	19	16	8	9	10	11	16\n28	19	16	1	1	1	1	7\n28	19	17	17\n28	19	17	1\n28	19	20	8	20\n28	19	20	1	5\n28	19	37	37\n28	19	37	2\n28	20	0	0\n28	20	0	2\n28	20	6	6	9\n28	20	6	544	12\n28	20	7	7	9\n28	20	7	20	1\n28	20	8	8\n28	20	8	97\n28	20	9	6	9\n28	20	9	6	206\n28	20	10	6	9	10\n28	20	10	1	1	138\n28	20	11	6	11	12\n28	20	11	2	160	1\n28	20	12	9	10	11	12\n28	20	12	1	5	1	144\n28	20	13	6	13	14	15\n28	20	13	12	117	1	1\n28	20	14	8	14\n28	20	14	1	28\n28	20	15	6	13	15\n28	20	15	5	1	72\n28	20	16	16\n28	20	16	7\n28	20	17	17\n28	20	17	1\n28	20	20	20\n28	20	20	5\n28	20	37	37\n28	20	37	2\n28	21	0	0\n28	21	0	2\n28	21	6	6	9\n28	21	6	559	11\n28	21	7	7\n28	21	7	20\n28	21	8	8\n28	21	8	98\n28	21	9	7	9\n28	21	9	1	220\n28	21	10	10	12\n28	21	10	142	1\n28	21	11	6	8	10	11	12\n28	21	11	2	1	2	155	1\n28	21	12	10	12\n28	21	12	3	142\n28	21	13	6	13	15\n28	21	13	5	112	1\n28	21	14	13	14\n28	21	14	1	28\n28	21	15	9	15\n28	21	15	1	72\n28	21	16	16\n28	21	16	7\n28	21	17	17\n28	21	17	1\n28	21	20	20\n28	21	20	5\n28	21	37	37\n28	21	37	2\n28	22	0	0\n28	22	0	2\n28	22	6	6	9\n28	22	6	559	7\n28	22	7	7\n28	22	7	21\n28	22	8	8\n28	22	8	99\n28	22	9	6	9\n28	22	9	3	229\n28	22	10	10\n28	22	10	147\n28	22	11	11\n28	22	11	155\n28	22	12	6	12\n28	22	12	1	143\n28	22	13	6	9	13\n28	22	13	2	1	110\n28	22	14	12	14\n28	22	14	1	27\n28	22	15	6	13	15\n28	22	15	1	1	71\n28	22	16	15	16\n28	22	16	1	6\n28	22	17	17\n28	22	17	1\n28	22	20	20\n28	22	20	5\n28	22	37	37\n28	22	37	2\n28	23	0	0\n28	23	0	2\n28	23	6	6	9\n28	23	6	565	1\n28	23	7	7\n28	23	7	21\n28	23	8	8	10\n28	23	8	98	1\n28	23	9	9\n28	23	9	237\n28	23	10	10	12	14\n28	23	10	144	2	1\n28	23	11	11\n28	23	11	155\n28	23	12	8	12\n28	23	12	1	143\n28	23	13	6	13\n28	23	13	1	110\n28	23	14	14\n28	23	14	27\n28	23	15	15\n28	23	15	72\n28	23	16	16\n28	23	16	6\n28	23	17	17\n28	23	17	1\n28	23	20	20\n28	23	20	5\n28	23	37	37\n28	23	37	2\n28	24	0	0\n28	24	0	2\n28	24	6	6	9\n28	24	6	565	1\n28	24	7	7\n28	24	7	21\n28	24	8	8\n28	24	8	99\n28	24	9	6	9\n28	24	9	1	237\n28	24	10	10\n28	24	10	145\n28	24	11	11	12\n28	24	11	153	2\n28	24	12	10	11	12\n28	24	12	1	1	143\n28	24	13	13\n28	24	13	110\n28	24	14	14\n28	24	14	28\n28	24	15	6	15\n28	24	15	1	71\n28	24	16	16\n28	24	16	6\n28	24	17	17\n28	24	17	1\n28	24	20	20\n28	24	20	5\n28	24	37	37\n28	24	37	2\n28	25	0	0\n28	25	0	2\n28	25	6	6	9\n28	25	6	566	1\n28	25	7	7\n28	25	7	21\n28	25	8	8	9\n28	25	8	98	1\n28	25	9	9\n28	25	9	238\n28	25	10	10\n28	25	10	146\n28	25	11	10	11	13\n28	25	11	1	152	1\n28	25	12	11	12\n28	25	12	1	144\n28	25	13	13\n28	25	13	110\n28	25	14	14	18\n28	25	14	27	1\n28	25	15	15\n28	25	15	71\n28	25	16	16\n28	25	16	6\n28	25	17	17\n28	25	17	1\n28	25	20	20\n28	25	20	5\n28	25	37	37\n28	25	37	2\n28	26	0	0\n28	26	0	2\n28	26	6	6\n28	26	6	566\n28	26	7	7\n28	26	7	21\n28	26	8	7	8\n28	26	8	1	97\n28	26	9	6	7	8	9\n28	26	9	79	2	7	152\n28	26	10	8	10\n28	26	10	4	143\n28	26	11	8	9	11\n28	26	11	1	1	151\n28	26	12	7	8	9	10	11	12\n28	26	12	1	2	1	7	7	126\n28	26	13	8	9	10	11	12	13\n28	26	13	1	4	3	2	1	100\n28	26	14	9	10	12	13	14\n28	26	14	1	2	1	2	21\n28	26	15	11	13	14	15\n28	26	15	3	5	2	61\n28	26	16	12	16\n28	26	16	1	5\n28	26	17	17\n28	26	17	1\n28	26	18	18\n28	26	18	1\n28	26	20	16	20\n28	26	20	4	1\n28	26	37	20	37\n28	26	37	1	1\n28	27	0	0\n28	27	0	2\n28	27	6	6\n28	27	6	645\n28	27	7	7\n28	27	7	25\n28	27	8	7	8\n28	27	8	2	110\n28	27	9	6	8	9\n28	27	9	41	2	116\n28	27	10	8	9	10\n28	27	10	3	4	148\n28	27	11	8	11\n28	27	11	2	161\n28	27	12	9	10	11	12	13\n28	27	12	1	6	3	118	1\n28	27	13	10	13\n28	27	13	1	106\n28	27	14	10	13	14\n28	27	14	1	2	20\n28	27	15	13	14	15\n28	27	15	3	1	57\n28	27	16	16\n28	27	16	9\n28	27	17	17\n28	27	17	1\n28	27	18	14\n28	27	18	1\n28	27	20	16	20\n28	27	20	1	1\n28	27	37	20\n28	27	37	1\n29	1	0	0\n29	1	0	1\n29	1	6	6\n29	1	6	17\n29	1	7	7	9\n29	1	7	19	1\n29	1	8	8\n29	1	8	28\n29	1	9	9\n29	1	9	59\n29	1	10	7	9	10	12	13\n29	1	10	1	1	13	1	1\n29	1	11	11	12	13\n29	1	11	207	3	1\n29	1	12	11	12	13	14\n29	1	12	7	125	1	1\n29	1	13	12	13	14	15\n29	1	13	2	268	4	4\n29	1	14	14	16\n29	1	14	66	1\n29	1	15	13	15\n29	1	15	5	221\n29	1	16	12	14	16	20\n29	1	16	1	2	40	1\n29	1	17	17	20\n29	1	17	1	1\n29	1	18	18\n29	1	18	1\n29	1	20	20\n29	1	20	2\n29	1	21	21\n29	1	21	1\n29	1	23	23\n29	1	23	1\n29	2	0	0\n29	2	0	1\n29	2	6	6	9\n29	2	6	15	2\n29	2	7	7	9	12\n29	2	7	15	4	1\n29	2	8	8\n29	2	8	28\n29	2	9	9	11	12	13\n29	2	9	58	1	1	1\n29	2	10	10	15\n29	2	10	12	1\n29	2	11	11	12	13	15\n29	2	11	205	7	1	1\n29	2	12	11	12\n29	2	12	4	128\n29	2	13	12	13	14	15\n29	2	13	1	263	1	11\n29	2	14	13	14\n29	2	14	1	72\n29	2	15	12	13	15\n29	2	15	1	5	219\n29	2	16	14	15	16	20\n29	2	16	2	2	26	11\n29	2	17	17\n29	2	17	1\n29	2	18	18\n29	2	18	1\n29	2	20	20\n29	2	20	4\n29	2	21	21\n29	2	21	1\n29	2	23	23\n29	2	23	1\n29	3	0	0\n29	3	0	1\n29	3	6	6\n29	3	6	15\n29	3	7	7\n29	3	7	15\n29	3	8	8\n29	3	8	28\n29	3	9	9\n29	3	9	64\n29	3	10	10\n29	3	10	12\n29	3	11	10	11	13\n29	3	11	1	208	1\n29	3	12	11	12\n29	3	12	1	138\n29	3	13	11	13\n29	3	13	2	269\n29	3	14	14\n29	3	14	75\n29	3	15	13	15\n29	3	15	6	228\n29	3	16	16\n29	3	16	26\n29	3	17	17\n29	3	17	1\n29	3	18	15\n29	3	18	1\n29	3	20	20\n29	3	20	15\n29	3	21	21\n29	3	21	1\n29	3	23	23\n29	3	23	1\n29	4	0	0\n29	4	0	1\n29	4	6	6\n29	4	6	15\n29	4	7	7\n29	4	7	15\n29	4	8	8\n29	4	8	28\n29	4	9	9\n29	4	9	64\n29	4	10	10\n29	4	10	13\n29	4	11	11\n29	4	11	211\n29	4	12	11	12\n29	4	12	2	136\n29	4	13	12	13	14\n29	4	13	1	274	1\n29	4	14	13	14\n29	4	14	1	74\n29	4	15	13	15\n29	4	15	5	224\n29	4	16	14	16\n29	4	16	1	25\n29	4	17	17\n29	4	17	1\n29	4	20	20\n29	4	20	15\n29	4	21	21\n29	4	21	1\n29	4	23	21\n29	4	23	1\n29	5	0	0\n29	5	0	1\n29	5	6	6\n29	5	6	15\n29	5	7	7\n29	5	7	15\n29	5	8	8\n29	5	8	28\n29	5	9	8	9\n29	5	9	1	63\n29	5	10	9	10\n29	5	10	1	12\n29	5	11	10	11	13\n29	5	11	1	211	1\n29	5	12	11	12	15\n29	5	12	2	134	1\n29	5	13	13	16\n29	5	13	279	1\n29	5	14	14\n29	5	14	76\n29	5	15	13	15	16\n29	5	15	1	222	1\n29	5	16	14	16\n29	5	16	1	24\n29	5	17	17\n29	5	17	1\n29	5	20	20\n29	5	20	15\n29	5	21	15	21\n29	5	21	1	1\n29	6	0	0\n29	6	0	1\n29	6	6	6\n29	6	6	15\n29	6	7	7\n29	6	7	15\n29	6	8	8\n29	6	8	29\n29	6	9	9\n29	6	9	64\n29	6	10	10\n29	6	10	13\n29	6	11	11\n29	6	11	213\n29	6	12	11	12\n29	6	12	1	133\n29	6	13	9	12	13\n29	6	13	1	1	279\n29	6	14	14\n29	6	14	77\n29	6	15	13	15	16\n29	6	15	2	221	1\n29	6	16	7	14	16\n29	6	16	1	1	24\n29	6	17	17\n29	6	17	1\n29	6	20	20\n29	6	20	15\n29	6	21	21\n29	6	21	1\n29	7	0	0\n29	7	0	1\n29	7	6	6\n29	7	6	15\n29	7	7	7\n29	7	7	16\n29	7	8	8\n29	7	8	29\n29	7	9	9	10\n29	7	9	64	1\n29	7	10	10\n29	7	10	13\n29	7	11	10	11\n29	7	11	1	213\n29	7	12	12\n29	7	12	134\n29	7	13	6	13\n29	7	13	1	280\n29	7	14	13	14\n29	7	14	1	77\n29	7	15	6	12	13	15\n29	7	15	2	1	1	217\n29	7	16	16\n29	7	16	25\n29	7	17	17\n29	7	17	1\n29	7	20	20\n29	7	20	15\n29	7	21	15\n29	7	21	1\n29	8	0	0\n29	8	0	1\n29	8	6	6\n29	8	6	18\n29	8	7	7\n29	8	7	16\n29	8	8	8\n29	8	8	29\n29	8	9	9	10\n29	8	9	62	2\n29	8	10	10\n29	8	10	15\n29	8	11	11	12\n29	8	11	211	2\n29	8	12	11	12\n29	8	12	1	134\n29	8	13	6	9	12	13	14	15\n29	8	13	1	2	1	275	1	2\n29	8	14	10	13	14\n29	8	14	1	1	75\n29	8	15	9	13	15	16\n29	8	15	1	2	214	1\n29	8	16	15	16\n29	8	16	1	24\n29	8	17	17\n29	8	17	1\n29	8	20	20\n29	8	20	15\n29	9	0	0\n29	9	0	1\n29	9	6	6\n29	9	6	19\n29	9	7	7\n29	9	7	16\n29	9	8	8\n29	9	8	29\n29	9	9	9\n29	9	9	65\n29	9	10	10\n29	9	10	18\n29	9	11	6	11\n29	9	11	2	210\n29	9	12	11	12\n29	9	12	1	136\n29	9	13	6	9	13\n29	9	13	5	1	272\n29	9	14	13	14\n29	9	14	1	75\n29	9	15	6	15\n29	9	15	2	215\n29	9	16	9	14	16\n29	9	16	3	2	20\n29	9	17	16\n29	9	17	1\n29	9	20	20\n29	9	20	15\n29	10	0	0\n29	10	0	1\n29	10	6	6\n29	10	6	28\n29	10	7	7\n29	10	7	16\n29	10	8	6	8\n29	10	8	2	27\n29	10	9	6	9\n29	10	9	1	68\n29	10	10	6	10\n29	10	10	1	17\n29	10	11	9	11	12\n29	10	11	1	208	2\n29	10	12	6	11	12\n29	10	12	1	1	134\n29	10	13	6	9	13	15\n29	10	13	6	2	264	1\n29	10	14	9	14\n29	10	14	1	76\n29	10	15	6	9	13	15\n29	10	15	5	4	3	203\n29	10	16	16\n29	10	16	21\n29	10	20	20\n29	10	20	15\n29	11	0	0\n29	11	0	1\n29	11	6	6\n29	11	6	44\n29	11	7	7\n29	11	7	16\n29	11	8	7	8\n29	11	8	1	26\n29	11	9	7	8	9	11\n29	11	9	1	1	73	1\n29	11	10	10	12\n29	11	10	16	1\n29	11	11	9	11	12\n29	11	11	1	207	1\n29	11	12	11	12	13\n29	11	12	1	133	2\n29	11	13	6	9	13\n29	11	13	15	1	251\n29	11	14	8	14\n29	11	14	1	75\n29	11	15	6	9	13	15\n29	11	15	5	3	1	195\n29	11	16	15	16\n29	11	16	1	20\n29	11	20	20\n29	11	20	15\n29	12	0	0\n29	12	0	1\n29	12	6	6	9\n29	12	6	62	2\n29	12	7	7	9\n29	12	7	17	1\n29	12	8	6	8\n29	12	8	1	27\n29	12	9	9\n29	12	9	78\n29	12	10	10\n29	12	10	16\n29	12	11	10	11	12\n29	12	11	1	206	2\n29	12	12	6	10	11	12\n29	12	12	1	1	1	132\n29	12	13	6	9	13	15\n29	12	13	6	2	245	1\n29	12	14	14	16\n29	12	14	74	1\n29	12	15	6	9	13	15\n29	12	15	3	1	1	191\n29	12	16	16\n29	12	16	20\n29	12	20	20\n29	12	20	15\n29	13	0	0\n29	13	0	1\n29	13	6	6	7	9\n29	13	6	70	2	1\n29	13	7	7\n29	13	7	17\n29	13	8	8\n29	13	8	27\n29	13	9	6	7	9	10\n29	13	9	1	1	81	1\n29	13	10	10\n29	13	10	18\n29	13	11	11\n29	13	11	207\n29	13	12	12	13\n29	13	12	133	1\n29	13	13	6	9	13	15\n29	13	13	4	1	240	1\n29	13	14	12	14\n29	13	14	1	73\n29	13	15	13	14	15	16\n29	13	15	7	1	183	1\n29	13	16	16\n29	13	16	21\n29	13	20	16	20\n29	13	20	1	14\n29	14	0	0\n29	14	0	1\n29	14	6	6\n29	14	6	75\n29	14	7	7\n29	14	7	20\n29	14	8	8\n29	14	8	27\n29	14	9	7	9\n29	14	9	1	82\n29	14	10	10\n29	14	10	19\n29	14	11	6	9	11\n29	14	11	3	1	203\n29	14	12	10	11	12\n29	14	12	1	1	132\n29	14	13	6	9	12	13	14	15\n29	14	13	4	1	1	237	1	4\n29	14	14	10	14	15\n29	14	14	1	72	1\n29	14	15	13	15\n29	14	15	2	182\n29	14	16	16\n29	14	16	23\n29	14	20	16	20\n29	14	20	1	13\n29	15	0	0\n29	15	0	1\n29	15	6	6	9\n29	15	6	81	1\n29	15	7	6	7	9\n29	15	7	1	18	2\n29	15	8	6	8\n29	15	8	3	24\n29	15	9	6	9\n29	15	9	8	76\n29	15	10	6	10	11\n29	15	10	1	19	1\n29	15	11	6	10	11	12\n29	15	11	6	3	192	3\n29	15	12	6	8	10	11	12\n29	15	12	1	2	8	1	121\n29	15	13	6	8	9	13	14\n29	15	13	22	1	1	214	1\n29	15	14	6	8	9	12	13	14\n29	15	14	1	1	1	1	1	68\n29	15	15	6	9	13	14	15\n29	15	15	9	12	3	1	162\n29	15	16	11	15	16\n29	15	16	1	1	22\n29	15	20	16	20\n29	15	20	2	11\n29	16	0	0\n29	16	0	1\n29	16	6	6	9\n29	16	6	130	3\n29	16	7	6	7\n29	16	7	1	17\n29	16	8	6	8\n29	16	8	2	26\n29	16	9	6	9\n29	16	9	7	86\n29	16	10	6	9	10\n29	16	10	1	2	27\n29	16	11	6	8	10	11	12\n29	16	11	9	1	10	170	5\n29	16	12	6	10	11	12\n29	16	12	5	6	2	112\n29	16	13	6	9	10	13	14	15\n29	16	13	33	5	1	177	1	1\n29	16	14	6	8	10	14\n29	16	14	2	7	1	60\n29	16	15	6	8	9	13	14	15\n29	16	15	20	1	13	5	1	123\n29	16	16	8	10	15	16\n29	16	16	2	1	1	20\n29	16	20	16	20\n29	16	20	3	8\n29	17	0	0\n29	17	0	1\n29	17	6	6	9\n29	17	6	205	5\n29	17	7	6	7\n29	17	7	3	14\n29	17	8	6	8\n29	17	8	4	33\n29	17	9	6	9\n29	17	9	4	105\n29	17	10	10	11\n29	17	10	45	1\n29	17	11	6	9	10	11	12	13\n29	17	11	9	1	10	140	11	1\n29	17	12	6	8	10	12\n29	17	12	2	1	6	108\n29	17	13	6	8	9	10	13\n29	17	13	33	1	2	1	145\n29	17	14	6	8	9	10	13	14	16\n29	17	14	1	7	1	2	1	47	3\n29	17	15	6	8	9	13	14	15\n29	17	15	23	2	10	3	1	86\n29	17	16	8	9	10	14	16\n29	17	16	1	2	2	2	16\n29	17	20	9	16	20\n29	17	20	1	2	5\n29	18	0	0\n29	18	0	1\n29	18	6	6	9\n29	18	6	275	9\n29	18	7	7\n29	18	7	14\n29	18	8	8	9\n29	18	8	44	1\n29	18	9	6	8	9\n29	18	9	9	2	116\n29	18	10	6	8	10	12\n29	18	10	1	1	62	2\n29	18	11	6	7	9	10	11	12\n29	18	11	10	1	1	11	105	13\n29	18	12	6	8	10	11	12\n29	18	12	1	2	3	1	112\n29	18	13	6	9	10	11	13\n29	18	13	29	4	3	1	113\n29	18	14	6	8	9	10	11	14	16\n29	18	14	1	7	2	2	1	36	1\n29	18	15	6	9	10	13	14	15\n29	18	15	7	5	4	1	1	68\n29	18	16	8	9	10	13	14	16\n29	18	16	4	1	4	1	1	10\n29	18	20	10	20\n29	18	20	1	4\n29	19	0	0\n29	19	0	1\n29	19	6	6	9\n29	19	6	326	7\n29	19	7	7	9\n29	19	7	13	2\n29	19	8	6	8	9\n29	19	8	1	58	1\n29	19	9	6	8	9\n29	19	9	10	1	128\n29	19	10	10	12\n29	19	10	89	1\n29	19	11	6	7	10	11	12\n29	19	11	7	2	2	92	5\n29	19	12	8	10	12\n29	19	12	2	8	117\n29	19	13	6	8	9	13\n29	19	13	19	3	2	91\n29	19	14	6	8	10	11	14\n29	19	14	6	6	2	1	23\n29	19	15	6	8	9	15\n29	19	15	5	1	7	55\n29	19	16	11	12	16\n29	19	16	1	1	9\n29	19	20	20\n29	19	20	4\n29	20	0	0\n29	20	0	1\n29	20	6	6	9\n29	20	6	362	12\n29	20	7	7\n29	20	7	15\n29	20	8	6	8	9	10\n29	20	8	2	67	1	1\n29	20	9	6	8	9\n29	20	9	5	1	141\n29	20	10	8	10	12\n29	20	10	1	99	1\n29	20	11	6	10	11	12	14\n29	20	11	2	7	82	2	1\n29	20	12	6	8	10	11	12\n29	20	12	2	1	2	1	118\n29	20	13	6	13\n29	20	13	11	80\n29	20	14	6	10	12	14	16\n29	20	14	1	1	1	19	1\n29	20	15	6	9	13	15\n29	20	15	2	3	1	49\n29	20	16	16\n29	20	16	9\n29	20	20	20\n29	20	20	4\n29	21	0	0\n29	21	0	1\n29	21	6	6	9\n29	21	6	383	4\n29	21	7	6	7	10\n29	21	7	1	13	1\n29	21	8	8	10\n29	21	8	69	1\n29	21	9	6	9\n29	21	9	6	151\n29	21	10	10\n29	21	10	110\n29	21	11	6	10	11\n29	21	11	3	2	78\n29	21	12	10	12	13\n29	21	12	1	120	1\n29	21	13	6	13\n29	21	13	2	79\n29	21	14	6	14\n29	21	14	1	19\n29	21	15	9	15\n29	21	15	1	48\n29	21	16	16\n29	21	16	10\n29	21	20	20\n29	21	20	4\n29	22	0	0\n29	22	0	1\n29	22	6	6	9\n29	22	6	389	7\n29	22	7	7\n29	22	7	13\n29	22	8	8\n29	22	8	69\n29	22	9	9\n29	22	9	156\n29	22	10	6	7	10\n29	22	10	1	1	113\n29	22	11	6	10	11\n29	22	11	1	1	76\n29	22	12	6	10	12\n29	22	12	2	1	117\n29	22	13	6	10	12	13	14\n29	22	13	3	1	1	74	1\n29	22	14	13	14\n29	22	14	1	18\n29	22	15	9	15\n29	22	15	1	47\n29	22	16	14	16\n29	22	16	1	9\n29	22	20	20\n29	22	20	4\n29	23	0	0\n29	23	0	1\n29	23	6	6	9\n29	23	6	394	2\n29	23	7	7\n29	23	7	14\n29	23	8	8\n29	23	8	69\n29	23	9	6	9\n29	23	9	1	163\n29	23	10	9	10	11	13\n29	23	10	3	111	1	1\n29	23	11	10	11\n29	23	11	1	75\n29	23	12	12\n29	23	12	118\n29	23	13	12	13\n29	23	13	2	73\n29	23	14	13	14\n29	23	14	1	19\n29	23	15	15\n29	23	15	47\n29	23	16	16\n29	23	16	9\n29	23	20	20\n29	23	20	4\n29	24	0	0\n29	24	0	1\n29	24	6	6\n29	24	6	395\n29	24	7	7\n29	24	7	14\n29	24	8	8\n29	24	8	69\n29	24	9	7	9\n29	24	9	1	167\n29	24	10	10\n29	24	10	112\n29	24	11	11\n29	24	11	76\n29	24	12	12\n29	24	12	120\n29	24	13	13\n29	24	13	75\n29	24	14	14\n29	24	14	19\n29	24	15	15\n29	24	15	47\n29	24	16	16\n29	24	16	9\n29	24	20	20\n29	24	20	4\n29	25	0	0\n29	25	0	1\n29	25	6	6\n29	25	6	395\n29	25	7	7\n29	25	7	15\n29	25	8	8	9\n29	25	8	68	1\n29	25	9	7	9\n29	25	9	1	166\n29	25	10	10\n29	25	10	112\n29	25	11	11	12\n29	25	11	75	1\n29	25	12	12\n29	25	12	120\n29	25	13	10	13\n29	25	13	1	74\n29	25	14	14	16\n29	25	14	17	2\n29	25	15	15\n29	25	15	47\n29	25	16	16\n29	25	16	9\n29	25	20	20\n29	25	20	4\n29	26	0	0\n29	26	0	1\n29	26	6	6\n29	26	6	395\n29	26	7	7\n29	26	7	16\n29	26	8	8\n29	26	8	68\n29	26	9	9\n29	26	9	167\n29	26	10	10\n29	26	10	113\n29	26	11	11	12\n29	26	11	73	2\n29	26	12	12\n29	26	12	121\n29	26	13	12	13\n29	26	13	1	73\n29	26	14	14\n29	26	14	17\n29	26	15	15\n29	26	15	47\n29	26	16	16\n29	26	16	11\n29	26	20	20\n29	26	20	4\n29	27	0	0\n29	27	0	1\n29	27	6	6\n29	27	6	395\n29	27	7	7\n29	27	7	16\n29	27	8	8\n29	27	8	68\n29	27	9	6	7	8	9\n29	27	9	52	2	3	110\n29	27	10	7	8	10\n29	27	10	1	1	111\n29	27	11	11\n29	27	11	73\n29	27	12	8	10	11	12\n29	27	12	1	6	5	112\n29	27	13	8	10	11	12	13	15\n29	27	13	1	1	1	2	67	1\n29	27	14	10	11	13	14	16\n29	27	14	2	1	1	12	1\n29	27	15	11	13	14	15\n29	27	15	2	7	1	37\n29	27	16	16\n29	27	16	11\n29	27	20	20\n29	27	20	4\n29	28	0	0\n29	28	0	1\n29	28	6	6\n29	28	6	447\n29	28	7	7\n29	28	7	19\n29	28	8	8\n29	28	8	74\n29	28	9	6	7	9\n29	28	9	36	1	73\n29	28	10	8	9	10\n29	28	10	1	1	118\n29	28	11	8	9	11\n29	28	11	1	1	80\n29	28	12	8	10	11	12\n29	28	12	1	6	6	101\n29	28	13	11	13\n29	28	13	1	74\n29	28	14	11	14\n29	28	14	1	12\n29	28	15	13	14	15\n29	28	15	4	1	33\n29	28	16	12	16\n29	28	16	1	11\n29	28	20	16	20\n29	28	20	1	3\n30	1	0	0\n30	1	0	1\n30	1	6	6	9\n30	1	6	14	1\n30	1	7	7	10\n30	1	7	19	1\n30	1	8	8\n30	1	8	15\n30	1	9	9	11\n30	1	9	38	1\n30	1	10	8	10\n30	1	10	1	11\n30	1	11	11	13\n30	1	11	116	1\n30	1	12	11	12	13	14\n30	1	12	3	102	1	2\n30	1	13	13	14\n30	1	13	197	2\n30	1	14	14\n30	1	14	54\n30	1	15	13	14	15	16\n30	1	15	5	1	152	1\n30	1	16	14	16	20\n30	1	16	3	21	1\n30	1	19	19\n30	1	19	1\n30	1	20	20\n30	1	20	2\n30	1	21	21\n30	1	21	1\n30	2	0	0\n30	2	0	1\n30	2	6	6	9\n30	2	6	13	1\n30	2	7	7	8	9\n30	2	7	17	1	1\n30	2	8	8	9	12\n30	2	8	14	1	1\n30	2	9	9	10\n30	2	9	38	1\n30	2	10	10	13	14\n30	2	10	10	1	1\n30	2	11	11	12	13	15\n30	2	11	112	4	3	1\n30	2	12	11	12	13	14\n30	2	12	2	97	1	2\n30	2	13	11	12	13\n30	2	13	1	1	202\n30	2	14	14	15	16\n30	2	14	60	1	1\n30	2	15	13	15	16\n30	2	15	3	148	1\n30	2	16	14	16	20\n30	2	16	1	16	5\n30	2	19	19\n30	2	19	1\n30	2	20	20\n30	2	20	3\n30	2	21	21\n30	2	21	1\n30	3	0	0\n30	3	0	1\n30	3	6	6\n30	3	6	13\n30	3	7	7\n30	3	7	17\n30	3	8	8\n30	3	8	15\n30	3	9	9\n30	3	9	41\n30	3	10	10	11\n30	3	10	10	1\n30	3	11	11\n30	3	11	115\n30	3	12	11	12\n30	3	12	2	101\n30	3	13	12	13	14\n30	3	13	1	208	1\n30	3	14	13	14\n30	3	14	1	63\n30	3	15	13	15\n30	3	15	4	146\n30	3	16	15	16\n30	3	16	1	17\n30	3	19	20\n30	3	19	1\n30	3	20	20\n30	3	20	8\n30	3	21	21\n30	3	21	1\n30	4	0	0\n30	4	0	1\n30	4	6	6\n30	4	6	13\n30	4	7	7\n30	4	7	17\n30	4	8	8\n30	4	8	15\n30	4	9	9\n30	4	9	41\n30	4	10	9	10\n30	4	10	1	9\n30	4	11	11\n30	4	11	118\n30	4	12	11	12\n30	4	12	1	101\n30	4	13	13	15\n30	4	13	212	1\n30	4	14	13	14\n30	4	14	1	63\n30	4	15	13	15\n30	4	15	2	145\n30	4	16	16\n30	4	16	17\n30	4	20	20	22\n30	4	20	8	1\n30	4	21	21\n30	4	21	1\n30	5	0	0\n30	5	0	1\n30	5	6	6\n30	5	6	13\n30	5	7	7\n30	5	7	17\n30	5	8	8\n30	5	8	15\n30	5	9	8	9\n30	5	9	1	41\n30	5	10	10\n30	5	10	9\n30	5	11	11\n30	5	11	119\n30	5	12	11	12\n30	5	12	1	100\n30	5	13	12	13\n30	5	13	1	214\n30	5	14	12	14\n30	5	14	1	62\n30	5	15	13	15\n30	5	15	1	145\n30	5	16	16\n30	5	16	17\n30	5	20	20\n30	5	20	8\n30	5	21	21\n30	5	21	1\n30	5	22	25\n30	5	22	1\n30	6	0	0\n30	6	0	1\n30	6	6	6\n30	6	6	13\n30	6	7	7\n30	6	7	17\n30	6	8	8\n30	6	8	16\n30	6	9	9\n30	6	9	41\n30	6	10	10\n30	6	10	9\n30	6	11	11\n30	6	11	120\n30	6	12	11	12	14\n30	6	12	3	98	1\n30	6	13	13\n30	6	13	215\n30	6	14	14\n30	6	14	62\n30	6	15	12	13	15\n30	6	15	1	1	143\n30	6	16	16\n30	6	16	17\n30	6	20	20\n30	6	20	8\n30	6	21	21\n30	6	21	1\n30	6	25	22\n30	6	25	1\n30	7	0	0\n30	7	0	1\n30	7	6	6\n30	7	6	13\n30	7	7	7\n30	7	7	17\n30	7	8	8\n30	7	8	16\n30	7	9	9	10\n30	7	9	40	1\n30	7	10	10\n30	7	10	9\n30	7	11	11\n30	7	11	123\n30	7	12	11	12\n30	7	12	1	98\n30	7	13	6	13\n30	7	13	1	215\n30	7	14	14\n30	7	14	63\n30	7	15	13	15\n30	7	15	2	141\n30	7	16	16\n30	7	16	17\n30	7	20	20\n30	7	20	8\n30	7	21	21\n30	7	21	1\n30	7	22	18\n30	7	22	1\n30	8	0	0\n30	8	0	1\n30	8	6	6\n30	8	6	14\n30	8	7	7\n30	8	7	17\n30	8	8	8\n30	8	8	16\n30	8	9	8	9\n30	8	9	1	39\n30	8	10	10\n30	8	10	10\n30	8	11	10	11\n30	8	11	1	123\n30	8	12	10	12\n30	8	12	1	97\n30	8	13	6	13\n30	8	13	1	216\n30	8	14	6	14\n30	8	14	1	62\n30	8	15	13	15\n30	8	15	2	139\n30	8	16	16\n30	8	16	17\n30	8	18	18\n30	8	18	1\n30	8	20	20\n30	8	20	8\n30	8	21	21\n30	8	21	1\n30	9	0	0\n30	9	0	1\n30	9	6	6\n30	9	6	16\n30	9	7	7\n30	9	7	17\n30	9	8	8\n30	9	8	17\n30	9	9	9\n30	9	9	39\n30	9	10	10\n30	9	10	12\n30	9	11	6	9	11\n30	9	11	1	1	121\n30	9	12	6	12	21\n30	9	12	1	95	1\n30	9	13	6	9	13	15\n30	9	13	1	1	214	2\n30	9	14	13	14\n30	9	14	1	61\n30	9	15	13	15\n30	9	15	1	138\n30	9	16	16\n30	9	16	17\n30	9	18	13\n30	9	18	1\n30	9	20	20\n30	9	20	8\n30	9	21	9\n30	9	21	1\n30	10	0	0\n30	10	0	1\n30	10	6	6\n30	10	6	19\n30	10	7	7\n30	10	7	17\n30	10	8	6	8\n30	10	8	1	16\n30	10	9	6	7	9\n30	10	9	3	1	38\n30	10	10	6	10\n30	10	10	1	11\n30	10	11	6	9	11\n30	10	11	1	1	119\n30	10	12	6	10	12\n30	10	12	1	1	93\n30	10	13	6	9	12	13\n30	10	13	7	1	1	208\n30	10	14	14\n30	10	14	61\n30	10	15	6	15\n30	10	15	3	137\n30	10	16	16\n30	10	16	17\n30	10	20	20\n30	10	20	8\n30	10	21	21\n30	10	21	1\n30	11	0	0\n30	11	0	1\n30	11	6	6\n30	11	6	36\n30	11	7	6	7	9\n30	11	7	1	16	1\n30	11	8	8\n30	11	8	16\n30	11	9	9\n30	11	9	40\n30	11	10	9	10\n30	11	10	1	11\n30	11	11	6	10	11	12	13\n30	11	11	1	1	115	1	1\n30	11	12	12\n30	11	12	94\n30	11	13	6	9	12	13	15\n30	11	13	12	2	1	192	1\n30	11	14	9	14\n30	11	14	1	60\n30	11	15	6	9	14	15\n30	11	15	4	1	1	131\n30	11	16	16\n30	11	16	17\n30	11	20	20\n30	11	20	8\n30	11	21	21\n30	11	21	1\n30	12	0	0\n30	12	0	1\n30	12	6	6	9\n30	12	6	53	1\n30	12	7	6	7\n30	12	7	1	15\n30	12	8	8\n30	12	8	16\n30	12	9	6	9\n30	12	9	1	45\n30	12	10	9	10\n30	12	10	1	11\n30	12	11	11\n30	12	11	115\n30	12	12	11	12\n30	12	12	1	95\n30	12	13	6	13	15\n30	12	13	4	187	2\n30	12	14	8	14\n30	12	14	1	60\n30	12	15	6	15\n30	12	15	2	130\n30	12	16	16\n30	12	16	17\n30	12	20	20\n30	12	20	8\n30	12	21	37\n30	12	21	1\n30	13	0	0\n30	13	0	1\n30	13	6	6	9\n30	13	6	60	1\n30	13	7	7\n30	13	7	15\n30	13	8	8\n30	13	8	17\n30	13	9	6	9\n30	13	9	1	46\n30	13	10	10\n30	13	10	11\n30	13	11	10	11	12\n30	13	11	1	114	1\n30	13	12	11	12\n30	13	12	2	93\n30	13	13	6	9	11	13	15\n30	13	13	4	1	1	180	1\n30	13	14	14	16\n30	13	14	59	1\n30	13	15	6	13	15\n30	13	15	1	1	130\n30	13	16	16\n30	13	16	17\n30	13	20	20\n30	13	20	8\n30	13	37	37\n30	13	37	1\n30	14	0	0\n30	14	0	1\n30	14	6	6	9\n30	14	6	65	1\n30	14	7	7\n30	14	7	15\n30	14	8	8\n30	14	8	17\n30	14	9	6	9\n30	14	9	1	47\n30	14	10	10\n30	14	10	12\n30	14	11	6	11	12\n30	14	11	1	114	2\n30	14	12	12\n30	14	12	94\n30	14	13	6	11	13	14	15\n30	14	13	2	1	175	1	2\n30	14	14	13	14\n30	14	14	1	58\n30	14	15	6	13	14	15\n30	14	15	1	1	2	127\n30	14	16	16\n30	14	16	18\n30	14	20	20\n30	14	20	8\n30	14	37	37\n30	14	37	1\n30	15	0	0\n30	15	0	1\n30	15	6	6	7	9\n30	15	6	68	1	1\n30	15	7	7\n30	15	7	15\n30	15	8	6	8\n30	15	8	2	15\n30	15	9	6	9\n30	15	9	2	46\n30	15	10	6	10\n30	15	10	1	11\n30	15	11	6	9	11	12	15\n30	15	11	3	2	107	2	1\n30	15	12	6	12\n30	15	12	1	95\n30	15	13	6	7	9	11	12	13	15\n30	15	13	14	1	1	1	1	157	2\n30	15	14	8	12	13	14	16\n30	15	14	1	2	2	55	1\n30	15	15	6	9	13	14	15\n30	15	15	5	3	2	1	118\n30	15	16	15	16\n30	15	16	1	17\n30	15	20	16	20\n30	15	20	2	6\n30	15	37	39\n30	15	37	1\n30	16	0	0\n30	16	0	1\n30	16	6	6	7	9\n30	16	6	94	1	1\n30	16	7	6	7\n30	16	7	1	16\n30	16	8	6	8\n30	16	8	1	15\n30	16	9	6	8	9\n30	16	9	2	1	50\n30	16	10	10\n30	16	10	11\n30	16	11	6	10	11\n30	16	11	6	2	100\n30	16	12	6	8	10	12\n30	16	12	1	1	2	96\n30	16	13	6	9	12	13	15\n30	16	13	16	4	1	136	4\n30	16	14	6	12	14\n30	16	14	1	1	54\n30	16	15	6	8	9	15\n30	16	15	12	1	8	101\n30	16	16	9	10	15	16\n30	16	16	1	1	1	17\n30	16	20	16	20\n30	16	20	1	5\n30	16	39	40\n30	16	39	1\n30	17	0	0\n30	17	0	1\n30	17	6	6	9\n30	17	6	129	5\n30	17	7	7\n30	17	7	17\n30	17	8	6	8\n30	17	8	2	16\n30	17	9	6	9\n30	17	9	7	57\n30	17	10	10\n30	17	10	16\n30	17	11	6	8	10	11	12	13\n30	17	11	8	1	3	85	2	1\n30	17	12	6	8	10	12	15\n30	17	12	3	1	10	83	1\n30	17	13	6	8	9	12	13	15\n30	17	13	30	2	2	1	100	1\n30	17	14	6	8	12	14	16\n30	17	14	1	4	1	47	1\n30	17	15	6	9	10	13	15	16\n30	17	15	12	9	2	2	80	1\n30	17	16	8	11	16\n30	17	16	2	1	15\n30	17	20	16	20\n30	17	20	3	2\n30	17	40	39\n30	17	40	1\n30	18	0	0\n30	18	0	1\n30	18	6	6	9\n30	18	6	191	1\n30	18	7	6	7\n30	18	7	1	16\n30	18	8	8\n30	18	8	26\n30	18	9	6	8	9\n30	18	9	4	1	68\n30	18	10	8	10\n30	18	10	2	29\n30	18	11	6	10	11	12\n30	18	11	4	4	77	1\n30	18	12	6	7	8	10	11	12\n30	18	12	4	1	3	3	3	73\n30	18	13	6	9	10	12	13	15\n30	18	13	22	3	1	1	74	2\n30	18	14	6	8	10	12	14\n30	18	14	2	5	2	1	37\n30	18	15	6	8	9	10	13	15\n30	18	15	11	1	13	1	1	55\n30	18	16	8	9	10	11	15	16\n30	18	16	3	1	1	3	2	10\n30	18	20	20\n30	18	20	2\n30	18	39	39\n30	18	39	1\n30	19	0	0\n30	19	0	1\n30	19	6	6	9\n30	19	6	234	5\n30	19	7	6	7\n30	19	7	2	15\n30	19	8	8	9\n30	19	8	40	1\n30	19	9	6	9\n30	19	9	4	82\n30	19	10	6	10	12\n30	19	10	1	38	2\n30	19	11	6	10	11	12\n30	19	11	3	9	67	4\n30	19	12	6	8	10	11	12\n30	19	12	3	1	5	2	65\n30	19	13	6	9	10	13\n30	19	13	10	3	1	61\n30	19	14	6	8	10	11	13	14\n30	19	14	2	3	1	2	1	28\n30	19	15	6	9	13	15\n30	19	15	10	1	1	47\n30	19	16	9	10	11	13	16\n30	19	16	1	2	1	1	5\n30	19	20	20\n30	19	20	2\n30	19	39	39\n30	19	39	1\n30	20	0	0\n30	20	0	1\n30	20	6	6	9\n30	20	6	264	5\n30	20	7	7	13\n30	20	7	14	1\n30	20	8	8	9\n30	20	8	43	1\n30	20	9	6	9\n30	20	9	1	92\n30	20	10	10\n30	20	10	56\n30	20	11	6	10	11	12\n30	20	11	3	6	60	3\n30	20	12	10	12\n30	20	12	2	69\n30	20	13	6	13\n30	20	13	15	49\n30	20	14	8	9	10	14\n30	20	14	1	1	1	25\n30	20	15	6	9	10	12	15\n30	20	15	5	6	1	1	34\n30	20	16	11	16\n30	20	16	1	4\n30	20	20	20\n30	20	20	2\n30	20	39	39\n30	20	39	1\n30	21	0	0\n30	21	0	1\n30	21	6	6	9\n30	21	6	284	4\n30	21	7	6	7\n30	21	7	2	12\n30	21	8	6	7	8	9\n30	21	8	2	1	40	1\n30	21	9	6	9\n30	21	9	1	104\n30	21	10	8	10	12\n30	21	10	1	64	1\n30	21	11	6	10	11	12\n30	21	11	2	5	53	1\n30	21	12	7	12\n30	21	12	1	72\n30	21	13	6	8	13\n30	21	13	4	1	45\n30	21	14	9	10	14\n30	21	14	1	1	23\n30	21	15	6	9	15\n30	21	15	1	3	30\n30	21	16	8	16\n30	21	16	1	3\n30	21	20	20\n30	21	20	2\n30	21	39	39\n30	21	39	1\n30	22	0	0\n30	22	0	1\n30	22	6	6	9\n30	22	6	292	4\n30	22	7	7\n30	22	7	14\n30	22	8	8\n30	22	8	43\n30	22	9	6	8	9\n30	22	9	1	1	111\n30	22	10	10\n30	22	10	70\n30	22	11	6	10	11	12\n30	22	11	1	1	50	1\n30	22	12	6	10	12\n30	22	12	1	1	72\n30	22	13	6	9	13\n30	22	13	3	1	41\n30	22	14	14\n30	22	14	23\n30	22	15	6	15\n30	22	15	1	29\n30	22	16	10	16\n30	22	16	1	2\n30	22	20	20\n30	22	20	2\n30	22	39	39\n30	22	39	1\n30	23	0	0\n30	23	0	1\n30	23	6	6	9\n30	23	6	294	5\n30	23	7	6	7\n30	23	7	1	13\n30	23	8	8	9\n30	23	8	43	1\n30	23	9	9\n30	23	9	116\n30	23	10	10\n30	23	10	73\n30	23	11	10	11\n30	23	11	1	49\n30	23	12	12\n30	23	12	73\n30	23	13	6	11	13\n30	23	13	2	1	38\n30	23	14	14\n30	23	14	23\n30	23	15	6	9	13	15\n30	23	15	1	1	1	26\n30	23	16	16\n30	23	16	2\n30	23	20	20\n30	23	20	2\n30	23	39	37\n30	23	39	1\n30	24	0	0\n30	24	0	1\n30	24	6	6\n30	24	6	298\n30	24	7	7\n30	24	7	13\n30	24	8	8\n30	24	8	43\n30	24	9	6	9\n30	24	9	1	122\n30	24	10	10\n30	24	10	74\n30	24	11	11	12\n30	24	11	49	1\n30	24	12	11	12\n30	24	12	1	72\n30	24	13	13	15\n30	24	13	38	1\n30	24	14	14\n30	24	14	23\n30	24	15	15\n30	24	15	26\n30	24	16	16\n30	24	16	2\n30	24	20	20\n30	24	20	2\n30	24	37	37\n30	24	37	1\n30	25	0	0\n30	25	0	1\n30	25	6	6\n30	25	6	299\n30	25	7	7\n30	25	7	13\n30	25	8	6	8\n30	25	8	1	42\n30	25	9	9\n30	25	9	122\n30	25	10	10\n30	25	10	74\n30	25	11	11\n30	25	11	50\n30	25	12	12\n30	25	12	73\n30	25	13	6	13	15	18\n30	25	13	1	35	1	1\n30	25	14	14\n30	25	14	23\n30	25	15	15\n30	25	15	27\n30	25	16	16\n30	25	16	2\n30	25	20	20\n30	25	20	2\n30	25	37	35\n30	25	37	1\n30	26	0	0\n30	26	0	1\n30	26	6	6	9\n30	26	6	300	1\n30	26	7	7\n30	26	7	13\n30	26	8	8\n30	26	8	42\n30	26	9	9\n30	26	9	122\n30	26	10	9	10\n30	26	10	1	73\n30	26	11	11\n30	26	11	50\n30	26	12	12\n30	26	12	73\n30	26	13	13\n30	26	13	35\n30	26	14	14\n30	26	14	23\n30	26	15	14	15\n30	26	15	1	27\n30	26	16	16\n30	26	16	2\n30	26	18	18\n30	26	18	1\n30	26	20	20\n30	26	20	2\n30	26	35	35\n30	26	35	1\n30	27	0	0\n30	27	0	1\n30	27	6	6\n30	27	6	300\n30	27	7	7\n30	27	7	13\n30	27	8	8\n30	27	8	42\n30	27	9	9\n30	27	9	124\n30	27	10	10\n30	27	10	73\n30	27	11	11\n30	27	11	50\n30	27	12	10	12\n30	27	12	1	72\n30	27	13	13\n30	27	13	35\n30	27	14	14\n30	27	14	24\n30	27	15	15\n30	27	15	27\n30	27	16	16\n30	27	16	2\n30	27	18	18\n30	27	18	1\n30	27	20	20\n30	27	20	2\n30	27	35	33\n30	27	35	1\n30	28	0	0\n30	28	0	1\n30	28	6	6\n30	28	6	300\n30	28	7	7\n30	28	7	13\n30	28	8	7	8\n30	28	8	1	41\n30	28	9	6	7	9\n30	28	9	34	1	89\n30	28	10	8	10\n30	28	10	2	72\n30	28	11	11	12\n30	28	11	49	1\n30	28	12	10	11	12\n30	28	12	6	1	65\n30	28	13	11	13\n30	28	13	1	34\n30	28	14	10	11	13	14\n30	28	14	1	2	1	20\n30	28	15	13	15\n30	28	15	4	23\n30	28	16	16\n30	28	16	2\n30	28	18	13\n30	28	18	1\n30	28	20	20\n30	28	20	2\n30	28	33	32\n30	28	33	1\n30	29	0	0\n30	29	0	1\n30	29	6	6\n30	29	6	334\n30	29	7	7\n30	29	7	15\n30	29	8	8\n30	29	8	43\n30	29	9	6	8	9\n30	29	9	24	2	63\n30	29	10	7	8	10\n30	29	10	1	2	76\n30	29	11	9	11\n30	29	11	1	52\n30	29	12	8	10	11	12\n30	29	12	1	1	1	63\n30	29	13	13\n30	29	13	40\n30	29	14	11	13	14	16\n30	29	14	1	2	16	1\n30	29	15	13	15\n30	29	15	2	21\n30	29	16	16\n30	29	16	2\n30	29	20	20\n30	29	20	2\n30	29	32	30\n30	29	32	1\n31	1	6	6	9\n31	1	6	13	1\n31	1	7	7	9\n31	1	7	6	1\n31	1	8	8\n31	1	8	12\n31	1	9	9\n31	1	9	21\n31	1	10	10	12	13\n31	1	10	9	1	1\n31	1	11	11	12	13\n31	1	11	63	1	2\n31	1	12	11	12	13	21\n31	1	12	1	585	1	2\n31	1	13	11	13	14	15	21\n31	1	13	1	147	1	2	3\n31	1	14	11	14	15\n31	1	14	1	64	1\n31	1	15	13	15\n31	1	15	4	705\n31	1	16	16	20	37\n31	1	16	93	41	1\n31	1	17	17	20	37\n31	1	17	2	2	1\n31	1	20	20	37\n31	1	20	133	1\n31	1	21	21\n31	1	21	20\n31	1	37	37\n31	1	37	31\n31	2	6	6	9\n31	2	6	6	7\n31	2	7	7	8\n31	2	7	5	1\n31	2	8	8	10	12\n31	2	8	10	1	1\n31	2	9	9	13\n31	2	9	22	1\n31	2	10	10	13\n31	2	10	8	1\n31	2	11	11	12	13\n31	2	11	64	1	1\n31	2	12	12	14	21\n31	2	12	580	1	6\n31	2	13	13	14	15	21\n31	2	13	144	1	3	7\n31	2	14	14\n31	2	14	65\n31	2	15	13	15	16\n31	2	15	2	705	1\n31	2	16	16	20	21	37\n31	2	16	16	68	1	8\n31	2	17	20	37\n31	2	17	1	1\n31	2	20	20\n31	2	20	176\n31	2	21	21\n31	2	21	25\n31	2	37	37\n31	2	37	34\n31	3	6	6\n31	3	6	6\n31	3	7	7\n31	3	7	5\n31	3	8	8\n31	3	8	11\n31	3	9	9\n31	3	9	29\n31	3	10	10\n31	3	10	9\n31	3	11	11\n31	3	11	64\n31	3	12	11	12\n31	3	12	4	578\n31	3	13	13	15\n31	3	13	148	1\n31	3	14	14\n31	3	14	67\n31	3	15	13	14	15\n31	3	15	3	1	704\n31	3	16	15	16\n31	3	16	1	16\n31	3	20	20\n31	3	20	245\n31	3	21	21\n31	3	21	39\n31	3	37	37\n31	3	37	43\n31	4	6	6\n31	4	6	6\n31	4	7	7\n31	4	7	5\n31	4	8	8\n31	4	8	11\n31	4	9	9\n31	4	9	29\n31	4	10	10\n31	4	10	9\n31	4	11	11\n31	4	11	68\n31	4	12	11	12\n31	4	12	1	577\n31	4	13	12	13	15\n31	4	13	2	148	1\n31	4	14	13	14\n31	4	14	1	67\n31	4	15	13	15\n31	4	15	1	705\n31	4	16	16\n31	4	16	16\n31	4	20	20\n31	4	20	245\n31	4	21	21\n31	4	21	39\n31	4	37	37\n31	4	37	43\n31	5	6	6\n31	5	6	6\n31	5	7	7\n31	5	7	5\n31	5	8	8\n31	5	8	11\n31	5	9	9	10\n31	5	9	28	1\n31	5	10	9	10\n31	5	10	1	8\n31	5	11	11\n31	5	11	69\n31	5	12	12\n31	5	12	579\n31	5	13	13\n31	5	13	150\n31	5	14	14\n31	5	14	67\n31	5	15	15\n31	5	15	706\n31	5	16	16\n31	5	16	16\n31	5	20	20\n31	5	20	245\n31	5	21	21\n31	5	21	39\n31	5	37	37\n31	5	37	43\n31	6	6	6\n31	6	6	6\n31	6	7	7\n31	6	7	5\n31	6	8	8\n31	6	8	11\n31	6	9	9\n31	6	9	29\n31	6	10	10\n31	6	10	9\n31	6	11	11\n31	6	11	69\n31	6	12	12\n31	6	12	579\n31	6	13	12	13\n31	6	13	1	149\n31	6	14	14\n31	6	14	67\n31	6	15	13	14	15\n31	6	15	1	1	704\n31	6	16	14	16\n31	6	16	1	15\n31	6	20	20\n31	6	20	245\n31	6	21	21\n31	6	21	39\n31	6	37	37\n31	6	37	43\n31	7	6	6\n31	7	6	6\n31	7	7	7\n31	7	7	5\n31	7	8	8\n31	7	8	11\n31	7	9	9\n31	7	9	29\n31	7	10	10\n31	7	10	9\n31	7	11	10	11\n31	7	11	1	68\n31	7	12	12\n31	7	12	580\n31	7	13	13\n31	7	13	150\n31	7	14	14\n31	7	14	69\n31	7	15	13	15\n31	7	15	3	701\n31	7	16	16\n31	7	16	15\n31	7	20	20\n31	7	20	245\n31	7	21	21\n31	7	21	39\n31	7	37	20	37\n31	7	37	1	42\n31	8	6	6\n31	8	6	6\n31	8	7	7\n31	8	7	5\n31	8	8	8\n31	8	8	11\n31	8	9	9\n31	8	9	29\n31	8	10	9	10\n31	8	10	1	9\n31	8	11	10	11	12\n31	8	11	1	66	1\n31	8	12	12\n31	8	12	580\n31	8	13	6	13\n31	8	13	2	151\n31	8	14	14\n31	8	14	69\n31	8	15	15\n31	8	15	701\n31	8	16	16\n31	8	16	15\n31	8	20	20\n31	8	20	246\n31	8	21	9	21\n31	8	21	2	37\n31	8	37	20	37\n31	8	37	1	41\n31	9	6	6\n31	9	6	8\n31	9	7	7\n31	9	7	5\n31	9	8	8\n31	9	8	11\n31	9	9	9\n31	9	9	32\n31	9	10	9	10\n31	9	10	1	9\n31	9	11	11\n31	9	11	66\n31	9	12	11	12\n31	9	12	1	580\n31	9	13	6	12	13\n31	9	13	2	1	148\n31	9	14	9	14\n31	9	14	1	68\n31	9	15	6	13	14	15\n31	9	15	1	1	1	698\n31	9	16	16\n31	9	16	15\n31	9	20	20\n31	9	20	247\n31	9	21	6	21\n31	9	21	1	36\n31	9	37	37\n31	9	37	41\n31	10	6	6\n31	10	6	12\n31	10	7	7\n31	10	7	5\n31	10	8	8\n31	10	8	11\n31	10	9	8	9\n31	10	9	1	33\n31	10	10	10\n31	10	10	9\n31	10	11	6	11\n31	10	11	1	66\n31	10	12	10	12\n31	10	12	1	580\n31	10	13	6	13	15\n31	10	13	2	146	1\n31	10	14	12	14\n31	10	14	1	68\n31	10	15	6	15\n31	10	15	3	695\n31	10	16	16\n31	10	16	15\n31	10	20	20\n31	10	20	247\n31	10	21	21\n31	10	21	36\n31	10	37	37\n31	10	37	41\n31	11	6	6	9\n31	11	6	17	1\n31	11	7	6	7\n31	11	7	1	4\n31	11	8	6	8\n31	11	8	1	11\n31	11	9	6	9\n31	11	9	2	31\n31	11	10	10\n31	11	10	10\n31	11	11	6	11\n31	11	11	1	65\n31	11	12	10	11	12\n31	11	12	1	1	579\n31	11	13	6	9	13\n31	11	13	5	1	140\n31	11	14	14\n31	11	14	68\n31	11	15	6	9	13	14	15\n31	11	15	5	3	1	1	686\n31	11	16	16\n31	11	16	15\n31	11	20	20\n31	11	20	247\n31	11	21	21\n31	11	21	36\n31	11	37	37\n31	11	37	41\n31	12	6	6\n31	12	6	32\n31	12	7	7\n31	12	7	4\n31	12	8	8\n31	12	8	11\n31	12	9	8	9\n31	12	9	1	35\n31	12	10	6	10\n31	12	10	1	10\n31	12	11	6	11\n31	12	11	3	63\n31	12	12	12\n31	12	12	579\n31	12	13	6	9	11	13	15\n31	12	13	9	2	1	127	2\n31	12	14	14\n31	12	14	69\n31	12	15	6	9	15\n31	12	15	2	3	681\n31	12	16	16\n31	12	16	15\n31	12	20	20\n31	12	20	247\n31	12	21	21\n31	12	21	36\n31	12	37	37\n31	12	37	41\n31	13	6	6	9\n31	13	6	45	2\n31	13	7	7\n31	13	7	4\n31	13	8	7	8\n31	13	8	1	11\n31	13	9	6	9\n31	13	9	1	39\n31	13	10	10\n31	13	10	10\n31	13	11	10	11\n31	13	11	1	63\n31	13	12	12	13\n31	13	12	578	1\n31	13	13	6	12	13	15\n31	13	13	4	1	121	1\n31	13	14	14\n31	13	14	69\n31	13	15	9	14	15\n31	13	15	2	1	680\n31	13	16	16\n31	13	16	15\n31	13	20	20\n31	13	20	247\n31	13	21	21\n31	13	21	36\n31	13	37	37\n31	13	37	41\n31	14	6	6\n31	14	6	50\n31	14	7	7\n31	14	7	5\n31	14	8	8\n31	14	8	11\n31	14	9	6	9\n31	14	9	1	42\n31	14	10	10\n31	14	10	11\n31	14	11	11	12\n31	14	11	62	1\n31	14	12	10	12\n31	14	12	1	578\n31	14	13	6	11	12	13	14\n31	14	13	3	2	1	115	1\n31	14	14	12	14\n31	14	14	1	69\n31	14	15	13	14	15\n31	14	15	2	1	678\n31	14	16	16\n31	14	16	15\n31	14	20	20\n31	14	20	247\n31	14	21	21\n31	14	21	36\n31	14	37	37\n31	14	37	41\n31	15	6	6\n31	15	6	54\n31	15	7	7\n31	15	7	5\n31	15	8	8\n31	15	8	11\n31	15	9	6	9\n31	15	9	1	41\n31	15	10	10\n31	15	10	12\n31	15	11	10	11	12\n31	15	11	1	62	1\n31	15	12	8	12\n31	15	12	1	580\n31	15	13	6	13\n31	15	13	6	111\n31	15	14	12	14	16\n31	15	14	1	69	1\n31	15	15	6	13	14	15\n31	15	15	2	1	1	674\n31	15	16	13	16\n31	15	16	1	14\n31	15	20	16	20\n31	15	20	1	246\n31	15	21	21\n31	15	21	36\n31	15	37	37\n31	15	37	41\n31	16	6	6	9\n31	16	6	62	1\n31	16	7	7\n31	16	7	5\n31	16	8	8\n31	16	8	12\n31	16	9	6	9	13\n31	16	9	2	38	1\n31	16	10	6	9	10\n31	16	10	1	1	11\n31	16	11	6	10	11	12\n31	16	11	6	1	54	1\n31	16	12	6	10	11	12\n31	16	12	2	2	1	577\n31	16	13	6	9	10	13	15\n31	16	13	16	1	1	93	2\n31	16	14	6	12	14\n31	16	14	3	1	66\n31	16	15	6	9	14	15\n31	16	15	9	7	1	657\n31	16	16	16\n31	16	16	16\n31	16	20	16	20\n31	16	20	1	245\n31	16	21	21\n31	16	21	36\n31	16	37	37\n31	16	37	41\n31	17	6	6	9\n31	17	6	100	1\n31	17	7	6	7\n31	17	7	1	4\n31	17	8	6	8\n31	17	8	2	10\n31	17	9	6	9\n31	17	9	2	46\n31	17	10	6	10	11\n31	17	10	1	13	1\n31	17	11	6	9	10	11	12\n31	17	11	5	1	3	45	1\n31	17	12	6	10	12\n31	17	12	2	4	573\n31	17	13	6	8	9	11	12	13	15\n31	17	13	12	1	3	1	1	74	2\n31	17	14	6	8	14\n31	17	14	1	1	65\n31	17	15	6	9	13	15\n31	17	15	10	11	1	637\n31	17	16	10	15	16\n31	17	16	2	1	14\n31	17	20	14	16	20\n31	17	20	1	2	242\n31	17	21	21\n31	17	21	36\n31	17	37	20	37\n31	17	37	1	40\n31	18	6	6	9\n31	18	6	133	3\n31	18	7	6	7\n31	18	7	1	3\n31	18	8	6	8\n31	18	8	2	10\n31	18	9	6	9\n31	18	9	2	60\n31	18	10	6	10	12\n31	18	10	1	20	1\n31	18	11	6	10	11	12\n31	18	11	8	5	29	5\n31	18	12	6	10	12\n31	18	12	4	4	567\n31	18	13	6	10	13\n31	18	13	22	2	51\n31	18	14	6	8	11	14\n31	18	14	1	2	1	62\n31	18	15	6	8	9	13	15\n31	18	15	9	1	5	1	624\n31	18	16	8	10	14	16\n31	18	16	2	2	1	11\n31	18	20	15	16	20\n31	18	20	1	1	241\n31	18	21	21\n31	18	21	36\n31	18	37	37\n31	18	37	40\n31	19	6	6	9\n31	19	6	177	6\n31	19	7	7\n31	19	7	3\n31	19	8	6	8\n31	19	8	1	14\n31	19	9	6	9\n31	19	9	4	64\n31	19	10	10	12\n31	19	10	32	1\n31	19	11	6	10	11	12\n31	19	11	6	4	18	2\n31	19	12	6	10	12\n31	19	12	2	5	566\n31	19	13	6	9	13\n31	19	13	17	2	33\n31	19	14	8	10	14\n31	19	14	3	2	58\n31	19	15	6	8	9	10	13	15\n31	19	15	9	1	4	1	2	608\n31	19	16	8	9	10	11	12	16\n31	19	16	1	3	2	1	1	4\n31	19	20	16	20\n31	19	20	1	240\n31	19	21	21\n31	19	21	36\n31	19	37	37\n31	19	37	40\n31	20	6	6	9\n31	20	6	211	5\n31	20	7	7\n31	20	7	3\n31	20	8	6	8	9\n31	20	8	1	17	1\n31	20	9	6	8	9\n31	20	9	1	2	76\n31	20	10	10\n31	20	10	46\n31	20	11	8	10	11	12\n31	20	11	2	2	14	1\n31	20	12	8	10	12\n31	20	12	2	3	565\n31	20	13	6	13\n31	20	13	9	26\n31	20	14	6	8	11	14\n31	20	14	1	4	1	52\n31	20	15	8	9	15\n31	20	15	1	1	606\n31	20	16	10	11	16\n31	20	16	1	1	3\n31	20	20	10	20\n31	20	20	1	239\n31	20	21	21\n31	20	21	36\n31	20	37	37\n31	20	37	40\n31	21	6	6	7	9\n31	21	6	218	1	4\n31	21	7	6	7\n31	21	7	1	2\n31	21	8	6	8\n31	21	8	1	27\n31	21	9	6	9\n31	21	9	1	82\n31	21	10	10\n31	21	10	53\n31	21	11	7	11	12\n31	21	11	1	14	1\n31	21	12	8	10	12\n31	21	12	1	2	563\n31	21	13	6	11	13\n31	21	13	7	1	18\n31	21	14	8	12	14\n31	21	14	1	1	50\n31	21	15	6	8	9	13	15\n31	21	15	4	1	1	1	599\n31	21	16	8	16\n31	21	16	1	2\n31	21	20	20\n31	21	20	239\n31	21	21	21\n31	21	21	36\n31	21	37	37\n31	21	37	40\n31	22	6	6	9\n31	22	6	224	8\n31	22	7	6	7\n31	22	7	2	2\n31	22	8	6	8	9	10\n31	22	8	1	28	1	1\n31	22	9	6	9\n31	22	9	3	84\n31	22	10	6	10\n31	22	10	1	54\n31	22	11	6	10	11	12\n31	22	11	1	4	9	1\n31	22	12	10	12\n31	22	12	1	564\n31	22	13	6	13\n31	22	13	3	16\n31	22	14	14\n31	22	14	50\n31	22	15	6	15\n31	22	15	3	596\n31	22	16	16\n31	22	16	2\n31	22	20	20\n31	22	20	239\n31	22	21	21\n31	22	21	36\n31	22	37	37\n31	22	37	40\n31	23	6	6	9\n31	23	6	235	3\n31	23	7	7	10\n31	23	7	1	1\n31	23	8	8\n31	23	8	28\n31	23	9	9\n31	23	9	93\n31	23	10	7	10\n31	23	10	1	59\n31	23	11	11	12\n31	23	11	8	1\n31	23	12	12\n31	23	12	565\n31	23	13	6	13\n31	23	13	1	15\n31	23	14	14\n31	23	14	50\n31	23	15	14	15\n31	23	15	1	595\n31	23	16	16\n31	23	16	2\n31	23	20	20\n31	23	20	239\n31	23	21	21\n31	23	21	36\n31	23	37	20	37\n31	23	37	1	39\n31	24	6	6	9\n31	24	6	233	3\n31	24	7	7\n31	24	7	2\n31	24	8	8\n31	24	8	28\n31	24	9	6	9\n31	24	9	2	94\n31	24	10	10	12\n31	24	10	59	1\n31	24	11	11\n31	24	11	8\n31	24	12	12\n31	24	12	566\n31	24	13	13\n31	24	13	15\n31	24	14	14\n31	24	14	51\n31	24	15	14	15\n31	24	15	1	594\n31	24	16	16\n31	24	16	2\n31	24	20	20\n31	24	20	240\n31	24	21	21\n31	24	21	36\n31	24	37	20	37\n31	24	37	1	38\n31	25	6	6\n31	25	6	235\n31	25	7	7\n31	25	7	2\n31	25	8	8\n31	25	8	28\n31	25	9	6	9\n31	25	9	1	96\n31	25	10	10\n31	25	10	59\n31	25	11	11\n31	25	11	8\n31	25	12	10	12\n31	25	12	1	566\n31	25	13	13\n31	25	13	15\n31	25	14	14\n31	25	14	52\n31	25	15	15\n31	25	15	594\n31	25	16	16\n31	25	16	2\n31	25	20	20\n31	25	20	241\n31	25	21	21\n31	25	21	36\n31	25	37	20	37\n31	25	37	1	37\n31	26	6	6	9\n31	26	6	235	1\n31	26	7	7\n31	26	7	2\n31	26	8	8\n31	26	8	28\n31	26	9	9\n31	26	9	96\n31	26	10	10\n31	26	10	60\n31	26	11	11\n31	26	11	8\n31	26	12	12	15\n31	26	12	565	1\n31	26	13	13\n31	26	13	15\n31	26	14	14\n31	26	14	52\n31	26	15	14	15\n31	26	15	1	593\n31	26	16	16\n31	26	16	2\n31	26	20	20\n31	26	20	242\n31	26	21	21\n31	26	21	36\n31	26	37	20	37\n31	26	37	1	36\n31	27	6	6\n31	27	6	235\n31	27	7	7\n31	27	7	2\n31	27	8	8\n31	27	8	28\n31	27	9	8	9\n31	27	9	1	96\n31	27	10	10	17\n31	27	10	59	1\n31	27	11	11\n31	27	11	8\n31	27	12	12\n31	27	12	565\n31	27	13	13\n31	27	13	15\n31	27	14	14\n31	27	14	53\n31	27	15	14	15\n31	27	15	1	593\n31	27	16	16\n31	27	16	2\n31	27	20	20\n31	27	20	243\n31	27	21	21\n31	27	21	36\n31	27	37	20	37\n31	27	37	1	35\n31	28	6	6\n31	28	6	235\n31	28	7	7\n31	28	7	2\n31	28	8	8\n31	28	8	29\n31	28	9	9\n31	28	9	96\n31	28	10	10\n31	28	10	59\n31	28	11	11\n31	28	11	8\n31	28	12	12\n31	28	12	565\n31	28	13	13\n31	28	13	15\n31	28	14	14\n31	28	14	54\n31	28	15	12	14	15\n31	28	15	1	1	591\n31	28	16	16\n31	28	16	2\n31	28	17	17\n31	28	17	1\n31	28	20	20\n31	28	20	244\n31	28	21	21\n31	28	21	36\n31	28	37	20	37\n31	28	37	1	34\n31	29	6	6\n31	29	6	235\n31	29	7	7\n31	29	7	2\n31	29	8	8\n31	29	8	29\n31	29	9	6	8	9\n31	29	9	31	2	63\n31	29	10	7	8	10\n31	29	10	2	1	56\n31	29	11	11\n31	29	11	8\n31	29	12	8	10	11	12\n31	29	12	1	2	2	561\n31	29	13	8	10	11	13\n31	29	13	1	3	3	8\n31	29	14	10	13	14\n31	29	14	3	1	51\n31	29	15	15\n31	29	15	591\n31	29	16	16\n31	29	16	2\n31	29	17	17\n31	29	17	1\n31	29	20	16	17	20\n31	29	20	70	2	173\n31	29	21	12	13	21\n31	29	21	5	4	27\n31	29	37	16	37\n31	29	37	4	30\n31	30	6	6\n31	30	6	266\n31	30	7	7\n31	30	7	4\n31	30	8	7	8\n31	30	8	1	33\n31	30	9	6	8	9\n31	30	9	28	1	34\n31	30	10	7	10\n31	30	10	1	63\n31	30	11	10	11\n31	30	11	2	11\n31	30	12	8	10	11	12\n31	30	12	1	2	3	560\n31	30	13	10	11	13\n31	30	13	1	2	10\n31	30	14	9	12	13	14\n31	30	14	1	1	2	47\n31	30	15	13	14	15\n31	30	15	3	2	586\n31	30	16	16\n31	30	16	76\n31	30	17	10	17\n31	30	17	1	2\n31	30	20	16	20\n31	30	20	40	133\n31	30	21	12	13	21\n31	30	21	2	5	20\n31	30	37	16	17	20	37\n31	30	37	7	1	1	21\n32	1	6	6\n32	1	6	4\n32	1	7	7	9\n32	1	7	5	1\n32	1	8	8\n32	1	8	6\n32	1	9	9\n32	1	9	13\n32	1	10	10\n32	1	10	2\n32	1	11	11\n32	1	11	36\n32	1	12	12	14\n32	1	12	35	1\n32	1	13	13	15\n32	1	13	69	2\n32	1	14	14\n32	1	14	23\n32	1	15	13	15\n32	1	15	1	66\n32	1	16	16\n32	1	16	15\n32	1	20	20\n32	1	20	3\n32	1	37	12\n32	1	37	1\n32	2	6	6\n32	2	6	4\n32	2	7	7\n32	2	7	5\n32	2	8	8\n32	2	8	6\n32	2	9	9	13	14	15\n32	2	9	11	1	1	1\n32	2	10	10\n32	2	10	2\n32	2	11	11\n32	2	11	36\n32	2	12	11	12\n32	2	12	1	35\n32	2	13	13	15\n32	2	13	67	3\n32	2	14	14\n32	2	14	24\n32	2	15	13	15\n32	2	15	1	67\n32	2	16	16	20\n32	2	16	12	3\n32	2	20	20\n32	2	20	3\n32	3	6	6\n32	3	6	4\n32	3	7	7\n32	3	7	5\n32	3	8	8\n32	3	8	6\n32	3	9	9\n32	3	9	11\n32	3	10	10\n32	3	10	2\n32	3	11	11\n32	3	11	37\n32	3	12	11	12\n32	3	12	1	34\n32	3	13	13\n32	3	13	69\n32	3	14	14\n32	3	14	25\n32	3	15	15\n32	3	15	71\n32	3	16	15	16\n32	3	16	1	11\n32	3	20	20\n32	3	20	6\n32	4	6	6\n32	4	6	4\n32	4	7	7\n32	4	7	5\n32	4	8	8\n32	4	8	6\n32	4	9	9\n32	4	9	11\n32	4	10	10\n32	4	10	2\n32	4	11	11\n32	4	11	38\n32	4	12	11	12\n32	4	12	2	32\n32	4	13	13\n32	4	13	69\n32	4	14	14\n32	4	14	25\n32	4	15	15\n32	4	15	72\n32	4	16	15	16\n32	4	16	2	9\n32	4	20	20\n32	4	20	6\n32	5	6	6\n32	5	6	4\n32	5	7	7\n32	5	7	5\n32	5	8	8\n32	5	8	6\n32	5	9	9\n32	5	9	11\n32	5	10	10\n32	5	10	2\n32	5	11	11\n32	5	11	40\n32	5	12	12\n32	5	12	32\n32	5	13	13\n32	5	13	69\n32	5	14	14\n32	5	14	25\n32	5	15	13	15\n32	5	15	2	72\n32	5	16	16\n32	5	16	9\n32	5	20	20\n32	5	20	6\n32	6	6	6\n32	6	6	4\n32	6	7	7\n32	6	7	5\n32	6	8	8\n32	6	8	6\n32	6	9	9\n32	6	9	11\n32	6	10	10\n32	6	10	2\n32	6	11	11\n32	6	11	40\n32	6	12	12\n32	6	12	32\n32	6	13	13\n32	6	13	71\n32	6	14	14\n32	6	14	25\n32	6	15	13	15\n32	6	15	1	71\n32	6	16	16\n32	6	16	9\n32	6	20	20\n32	6	20	6\n32	7	6	6\n32	7	6	4\n32	7	7	7\n32	7	7	5\n32	7	8	8\n32	7	8	6\n32	7	9	8	9	10\n32	7	9	1	9	1\n32	7	10	10\n32	7	10	2\n32	7	11	11\n32	7	11	40\n32	7	12	12\n32	7	12	32\n32	7	13	13\n32	7	13	72\n32	7	14	13	14\n32	7	14	1	24\n32	7	15	15\n32	7	15	71\n32	7	16	16\n32	7	16	9\n32	7	20	20\n32	7	20	6\n32	8	6	6\n32	8	6	4\n32	8	7	7\n32	8	7	5\n32	8	8	8\n32	8	8	7\n32	8	9	9\n32	8	9	9\n32	8	10	10\n32	8	10	3\n32	8	11	6	11\n32	8	11	1	39\n32	8	12	12\n32	8	12	32\n32	8	13	6	12	13\n32	8	13	1	1	71\n32	8	14	14\n32	8	14	24\n32	8	15	13	15\n32	8	15	1	70\n32	8	16	16\n32	8	16	9\n32	8	20	20\n32	8	20	6\n32	9	6	6\n32	9	6	6\n32	9	7	7\n32	9	7	5\n32	9	8	8\n32	9	8	7\n32	9	9	9\n32	9	9	9\n32	9	10	10\n32	9	10	3\n32	9	11	11\n32	9	11	39\n32	9	12	12\n32	9	12	33\n32	9	13	13\n32	9	13	72\n32	9	14	14\n32	9	14	24\n32	9	15	13	15\n32	9	15	3	67\n32	9	16	16\n32	9	16	9\n32	9	20	20\n32	9	20	6\n32	10	6	6\n32	10	6	6\n32	10	7	7\n32	10	7	5\n32	10	8	8\n32	10	8	7\n32	10	9	9\n32	10	9	9\n32	10	10	10\n32	10	10	3\n32	10	11	11\n32	10	11	39\n32	10	12	10	12\n32	10	12	2	31\n32	10	13	6	11	13	15\n32	10	13	3	1	70	1\n32	10	14	14\n32	10	14	24\n32	10	15	6	9	13	15\n32	10	15	1	2	1	63\n32	10	16	16\n32	10	16	9\n32	10	20	20\n32	10	20	6\n32	11	6	6\n32	11	6	10\n32	11	7	6	7\n32	11	7	1	4\n32	11	8	6	8\n32	11	8	1	6\n32	11	9	9\n32	11	9	11\n32	11	10	9	10\n32	11	10	1	4\n32	11	11	9	11\n32	11	11	1	39\n32	11	12	11	12\n32	11	12	2	29\n32	11	13	6	11	13\n32	11	13	4	1	66\n32	11	14	14\n32	11	14	24\n32	11	15	6	9	15\n32	11	15	3	2	59\n32	11	16	16\n32	11	16	9\n32	11	20	20\n32	11	20	6\n32	12	6	6\n32	12	6	19\n32	12	7	6	7\n32	12	7	1	3\n32	12	8	6	8\n32	12	8	1	5\n32	12	9	6	9\n32	12	9	1	14\n32	12	10	10\n32	12	10	4\n32	12	11	11\n32	12	11	42\n32	12	12	6	12\n32	12	12	1	28\n32	12	13	6	9	12	13\n32	12	13	1	2	1	62\n32	12	14	14	16\n32	12	14	22	2\n32	12	15	15\n32	12	15	59\n32	12	16	16\n32	12	16	9\n32	12	20	20\n32	12	20	6\n32	13	6	6\n32	13	6	24\n32	13	7	7\n32	13	7	3\n32	13	8	8\n32	13	8	5\n32	13	9	9\n32	13	9	16\n32	13	10	10\n32	13	10	4\n32	13	11	11\n32	13	11	42\n32	13	12	10	12\n32	13	12	1	28\n32	13	13	6	13\n32	13	13	3	59\n32	13	14	6	11	14\n32	13	14	1	1	20\n32	13	15	6	9	13	15\n32	13	15	1	1	1	56\n32	13	16	16\n32	13	16	11\n32	13	20	20\n32	13	20	6\n32	14	6	6	9\n32	14	6	28	1\n32	14	7	7\n32	14	7	3\n32	14	8	8\n32	14	8	5\n32	14	9	6	9\n32	14	9	1	16\n32	14	10	10\n32	14	10	5\n32	14	11	11\n32	14	11	43\n32	14	12	12\n32	14	12	28\n32	14	13	6	11	13\n32	14	13	1	1	58\n32	14	14	14\n32	14	14	20\n32	14	15	6	9	15\n32	14	15	1	1	54\n32	14	16	16\n32	14	16	11\n32	14	20	20\n32	14	20	6\n32	15	6	6\n32	15	6	31\n32	15	7	7\n32	15	7	3\n32	15	8	8\n32	15	8	5\n32	15	9	9\n32	15	9	18\n32	15	10	10\n32	15	10	5\n32	15	11	9	11\n32	15	11	1	43\n32	15	12	11	12\n32	15	12	1	27\n32	15	13	6	13\n32	15	13	2	56\n32	15	14	14\n32	15	14	20\n32	15	15	6	15\n32	15	15	2	52\n32	15	16	16\n32	15	16	11\n32	15	20	16	20\n32	15	20	1	5\n32	16	6	6\n32	16	6	35\n32	16	7	6	7\n32	16	7	1	2\n32	16	8	8\n32	16	8	5\n32	16	9	9\n32	16	9	19\n32	16	10	10\n32	16	10	5\n32	16	11	10	11\n32	16	11	1	43\n32	16	12	12\n32	16	12	27\n32	16	13	6	9	13\n32	16	13	2	1	53\n32	16	14	6	14\n32	16	14	1	19\n32	16	15	6	8	9	13	15\n32	16	15	2	1	1	2	46\n32	16	16	16\n32	16	16	12\n32	16	20	16	20\n32	16	20	2	3\n32	17	6	6	7	9\n32	17	6	38	1	2\n32	17	7	6	7\n32	17	7	1	1\n32	17	8	8\n32	17	8	6\n32	17	9	6	9\n32	17	9	4	17\n32	17	10	10\n32	17	10	6\n32	17	11	6	8	9	10	11\n32	17	11	2	2	1	3	35\n32	17	12	6	10	12\n32	17	12	2	1	24\n32	17	13	6	13\n32	17	13	9	46\n32	17	14	9	14\n32	17	14	1	18\n32	17	15	6	9	15	16\n32	17	15	9	4	32	1\n32	17	16	9	10	15	16\n32	17	16	2	2	2	8\n32	17	20	14	16	20\n32	17	20	1	1	1\n32	18	6	6	9\n32	18	6	64	1\n32	18	7	7\n32	18	7	2\n32	18	8	6	8\n32	18	8	2	6\n32	18	9	6	9\n32	18	9	2	25\n32	18	10	6	10	12\n32	18	10	2	9	1\n32	18	11	6	8	10	11	12	13\n32	18	11	4	1	3	25	1	1\n32	18	12	6	10	12\n32	18	12	1	2	21\n32	18	13	6	13\n32	18	13	16	30\n32	18	14	9	14\n32	18	14	1	18\n32	18	15	6	8	9	13	15\n32	18	15	7	2	3	1	21\n32	18	16	8	10	11	16\n32	18	16	2	1	1	6\n32	18	20	20\n32	18	20	1\n32	19	6	6	9\n32	19	6	95	3\n32	19	7	7\n32	19	7	2\n32	19	8	6	8	9	10\n32	19	8	1	8	1	1\n32	19	9	6	9\n32	19	9	1	29\n32	19	10	9	10\n32	19	10	1	14\n32	19	11	6	8	10	11\n32	19	11	3	1	4	18\n32	19	12	8	10	12\n32	19	12	1	3	19\n32	19	13	6	8	13\n32	19	13	10	1	21\n32	19	14	8	9	11	14\n32	19	14	4	1	1	12\n32	19	15	6	9	10	15\n32	19	15	4	1	3	13\n32	19	16	8	9	16\n32	19	16	1	1	4\n32	19	20	20\n32	19	20	1\n32	20	6	6	9\n32	20	6	110	4\n32	20	7	7\n32	20	7	2\n32	20	8	6	8\n32	20	8	1	15\n32	20	9	6	8	9\n32	20	9	4	1	32\n32	20	10	10\n32	20	10	25\n32	20	11	6	10	11	12\n32	20	11	1	4	12	2\n32	20	12	6	8	10	12\n32	20	12	1	1	2	15\n32	20	13	6	8	13\n32	20	13	9	1	11\n32	20	14	6	8	10	14\n32	20	14	1	5	1	5\n32	20	15	6	9	13	15\n32	20	15	1	2	1	9\n32	20	16	10	12	16\n32	20	16	1	1	2\n32	20	20	11\n32	20	20	1\n32	21	6	6\n32	21	6	128\n32	21	7	7\n32	21	7	2\n32	21	8	8\n32	21	8	23\n32	21	9	9\n32	21	9	38\n32	21	10	10	12\n32	21	10	32	1\n32	21	11	6	10	11\n32	21	11	4	3	6\n32	21	12	10	12\n32	21	12	1	17\n32	21	13	6	13\n32	21	13	7	5\n32	21	14	8	10	11	14\n32	21	14	2	1	1	1\n32	21	15	6	9	11	15\n32	21	15	6	1	1	1\n32	21	16	8	16\n32	21	16	1	1\n32	22	6	6	9\n32	22	6	142	3\n32	22	7	6	7\n32	22	7	1	1\n32	22	8	8	9\n32	22	8	24	2\n32	22	9	6	9\n32	22	9	1	38\n32	22	10	10\n32	22	10	37\n32	22	11	10	11\n32	22	11	3	5\n32	22	12	10	12\n32	22	12	1	17\n32	22	13	6	13\n32	22	13	3	2\n32	22	14	10\n32	22	14	1\n32	22	15	9\n32	22	15	1\n32	22	16	16\n32	22	16	1\n32	23	6	6	9\n32	23	6	145	2\n32	23	7	7\n32	23	7	1\n32	23	8	8	9\n32	23	8	23	1\n32	23	9	6	9\n32	23	9	1	43\n32	23	10	10	12\n32	23	10	41	1\n32	23	11	11\n32	23	11	5\n32	23	12	12\n32	23	12	17\n32	23	13	13\n32	23	13	2\n32	23	16	16\n32	23	16	1\n32	24	6	6\n32	24	6	146\n32	24	7	7\n32	24	7	1\n32	24	8	8\n32	24	8	23\n32	24	9	6	9\n32	24	9	1	45\n32	24	10	10\n32	24	10	41\n32	24	11	11\n32	24	11	5\n32	24	12	10	12\n32	24	12	1	17\n32	24	13	6\n32	24	13	2\n32	24	16	16\n32	24	16	1\n32	25	6	6	9\n32	25	6	148	1\n32	25	7	7\n32	25	7	1\n32	25	8	8\n32	25	8	23\n32	25	9	6	9\n32	25	9	2	43\n32	25	10	8	10\n32	25	10	1	41\n32	25	11	11\n32	25	11	5\n32	25	12	10	12\n32	25	12	1	16\n32	25	16	16\n32	25	16	1\n32	26	6	6	9\n32	26	6	147	3\n32	26	7	6\n32	26	7	1\n32	26	8	8\n32	26	8	24\n32	26	9	8	9\n32	26	9	1	43\n32	26	10	10\n32	26	10	42\n32	26	11	11\n32	26	11	5\n32	26	12	12	15\n32	26	12	15	1\n32	26	16	16\n32	26	16	1\n32	27	6	6\n32	27	6	148\n32	27	8	8\n32	27	8	25\n32	27	9	9\n32	27	9	46\n32	27	10	10\n32	27	10	42\n32	27	11	11\n32	27	11	5\n32	27	12	12\n32	27	12	15\n32	27	15	15\n32	27	15	1\n32	27	16	16\n32	27	16	1\n32	28	6	6\n32	28	6	148\n32	28	8	8\n32	28	8	25\n32	28	9	9\n32	28	9	46\n32	28	10	10\n32	28	10	42\n32	28	11	11\n32	28	11	5\n32	28	12	12\n32	28	12	15\n32	28	15	18\n32	28	15	1\n32	28	16	16\n32	28	16	1\n32	29	6	6\n32	29	6	148\n32	29	8	8\n32	29	8	25\n32	29	9	9\n32	29	9	46\n32	29	10	10\n32	29	10	42\n32	29	11	11\n32	29	11	5\n32	29	12	12\n32	29	12	15\n32	29	16	16\n32	29	16	1\n32	29	18	18\n32	29	18	1\n32	30	6	6\n32	30	6	148\n32	30	8	8\n32	30	8	25\n32	30	9	6	8	9\n32	30	9	19	2	25\n32	30	10	10\n32	30	10	42\n32	30	11	11\n32	30	11	5\n32	30	12	10	12\n32	30	12	2	13\n32	30	16	16\n32	30	16	1\n32	30	18	15\n32	30	18	1\n32	31	6	6\n32	31	6	167\n32	31	8	8\n32	31	8	27\n32	31	9	6	8	9\n32	31	9	7	2	16\n32	31	10	10\n32	31	10	44\n32	31	11	11\n32	31	11	5\n32	31	12	10	12\n32	31	12	4	9\n32	31	15	10\n32	31	15	1\n32	31	16	16\n32	31	16	1\n33	1	6	6\n33	1	6	3\n33	1	7	7\n33	1	7	4\n33	1	8	8\n33	1	8	7\n33	1	9	9\n33	1	9	14\n33	1	10	10\n33	1	10	2\n33	1	11	11\n33	1	11	32\n33	1	12	12\n33	1	12	26\n33	1	13	13	15\n33	1	13	71	2\n33	1	14	14\n33	1	14	12\n33	1	15	13	15	17\n33	1	15	2	49	1\n33	1	16	16	20\n33	1	16	7	1\n33	1	20	20\n33	1	20	1\n33	2	6	6\n33	2	6	3\n33	2	7	7\n33	2	7	4\n33	2	8	8\n33	2	8	7\n33	2	9	9\n33	2	9	14\n33	2	10	10\n33	2	10	2\n33	2	11	11\n33	2	11	32\n33	2	12	12	14\n33	2	12	25	1\n33	2	13	13\n33	2	13	73\n33	2	14	14	15\n33	2	14	11	1\n33	2	15	13	15\n33	2	15	3	48\n33	2	16	14	16	20\n33	2	16	1	3	3\n33	2	17	17\n33	2	17	1\n33	2	20	20\n33	2	20	2\n33	3	6	6\n33	3	6	3\n33	3	7	7\n33	3	7	4\n33	3	8	8\n33	3	8	7\n33	3	9	9\n33	3	9	14\n33	3	10	10\n33	3	10	2\n33	3	11	10	11\n33	3	11	1	31\n33	3	12	11	12\n33	3	12	1	24\n33	3	13	11	13\n33	3	13	1	75\n33	3	14	14\n33	3	14	13\n33	3	15	15\n33	3	15	49\n33	3	16	16\n33	3	16	3\n33	3	17	18\n33	3	17	1\n33	3	20	20\n33	3	20	5\n33	4	6	6\n33	4	6	3\n33	4	7	7\n33	4	7	4\n33	4	8	8\n33	4	8	7\n33	4	9	9\n33	4	9	14\n33	4	10	10\n33	4	10	3\n33	4	11	11\n33	4	11	33\n33	4	12	11	12\n33	4	12	1	23\n33	4	13	13\n33	4	13	75\n33	4	14	12	14\n33	4	14	1	12\n33	4	15	13	15\n33	4	15	3	46\n33	4	16	16\n33	4	16	3\n33	4	18	18\n33	4	18	1\n33	4	20	20\n33	4	20	5\n33	5	6	6\n33	5	6	3\n33	5	7	7\n33	5	7	4\n33	5	8	8\n33	5	8	7\n33	5	9	9\n33	5	9	14\n33	5	10	10\n33	5	10	3\n33	5	11	11\n33	5	11	34\n33	5	12	11	12\n33	5	12	1	23\n33	5	13	13	15\n33	5	13	77	1\n33	5	14	14\n33	5	14	12\n33	5	15	13	15\n33	5	15	1	45\n33	5	16	16\n33	5	16	3\n33	5	18	20\n33	5	18	1\n33	5	20	20\n33	5	20	5\n33	6	6	6\n33	6	6	3\n33	6	7	7\n33	6	7	4\n33	6	8	8\n33	6	8	7\n33	6	9	9\n33	6	9	14\n33	6	10	10\n33	6	10	3\n33	6	11	11\n33	6	11	35\n33	6	12	11	12\n33	6	12	1	22\n33	6	13	13\n33	6	13	78\n33	6	14	14\n33	6	14	12\n33	6	15	12	15\n33	6	15	1	45\n33	6	16	15	16\n33	6	16	1	2\n33	6	20	20	22\n33	6	20	5	1\n33	7	6	6\n33	7	6	3\n33	7	7	7\n33	7	7	4\n33	7	8	8\n33	7	8	7\n33	7	9	9\n33	7	9	14\n33	7	10	10\n33	7	10	3\n33	7	11	11	14\n33	7	11	35	1\n33	7	12	11	12\n33	7	12	1	22\n33	7	13	13\n33	7	13	78\n33	7	14	14\n33	7	14	12\n33	7	15	13	15\n33	7	15	1	45\n33	7	16	16\n33	7	16	2\n33	7	20	20\n33	7	20	5\n33	7	22	24\n33	7	22	1\n33	8	6	6\n33	8	6	3\n33	8	7	7\n33	8	7	4\n33	8	8	8\n33	8	8	7\n33	8	9	9\n33	8	9	14\n33	8	10	10\n33	8	10	3\n33	8	11	11\n33	8	11	36\n33	8	12	12\n33	8	12	22\n33	8	13	6	13\n33	8	13	1	78\n33	8	14	14\n33	8	14	13\n33	8	15	15\n33	8	15	45\n33	8	16	16\n33	8	16	2\n33	8	20	20\n33	8	20	5\n33	8	24	24\n33	8	24	1\n33	9	6	6\n33	9	6	4\n33	9	7	7\n33	9	7	4\n33	9	8	8\n33	9	8	7\n33	9	9	6	9\n33	9	9	1	13\n33	9	10	10\n33	9	10	3\n33	9	11	11\n33	9	11	36\n33	9	12	11	12\n33	9	12	1	21\n33	9	13	13\n33	9	13	78\n33	9	14	14\n33	9	14	13\n33	9	15	15\n33	9	15	45\n33	9	16	16\n33	9	16	2\n33	9	20	20\n33	9	20	5\n33	9	24	24\n33	9	24	1\n33	10	6	6\n33	10	6	5\n33	10	7	7\n33	10	7	4\n33	10	8	8\n33	10	8	7\n33	10	9	9\n33	10	9	13\n33	10	10	10\n33	10	10	3\n33	10	11	9	11	12\n33	10	11	1	35	1\n33	10	12	12\n33	10	12	21\n33	10	13	6	13\n33	10	13	1	77\n33	10	14	14\n33	10	14	13\n33	10	15	6	15\n33	10	15	1	44\n33	10	16	16\n33	10	16	2\n33	10	20	20\n33	10	20	5\n33	10	24	24\n33	10	24	1\n33	11	6	6\n33	11	6	7\n33	11	7	6	7\n33	11	7	1	3\n33	11	8	8\n33	11	8	7\n33	11	9	9\n33	11	9	14\n33	11	10	10\n33	11	10	3\n33	11	11	11\n33	11	11	35\n33	11	12	12\n33	11	12	22\n33	11	13	6	13	15\n33	11	13	2	74	1\n33	11	14	14\n33	11	14	13\n33	11	15	6	13	15\n33	11	15	1	1	42\n33	11	16	16\n33	11	16	2\n33	11	20	20\n33	11	20	5\n33	11	24	24\n33	11	24	1\n33	12	6	6\n33	12	6	11\n33	12	7	6	7\n33	12	7	1	2\n33	12	8	8\n33	12	8	7\n33	12	9	6	9\n33	12	9	1	13\n33	12	10	10\n33	12	10	3\n33	12	11	6	11\n33	12	11	1	34\n33	12	12	10	12\n33	12	12	1	21\n33	12	13	6	9	13\n33	12	13	3	4	68\n33	12	14	11	14\n33	12	14	1	12\n33	12	15	6	9	15\n33	12	15	3	2	38\n33	12	16	16\n33	12	16	2\n33	12	20	20\n33	12	20	5\n33	12	24	24\n33	12	24	1\n33	13	6	6\n33	13	6	20\n33	13	7	6	7\n33	13	7	1	1\n33	13	8	6	8\n33	13	8	1	6\n33	13	9	6	9\n33	13	9	1	18\n33	13	10	10\n33	13	10	4\n33	13	11	6	11\n33	13	11	1	34\n33	13	12	12\n33	13	12	21\n33	13	13	6	13\n33	13	13	3	65\n33	13	14	14\n33	13	14	12\n33	13	15	15\n33	13	15	38\n33	13	16	16\n33	13	16	2\n33	13	20	20\n33	13	20	5\n33	13	24	24\n33	13	24	1\n33	14	6	6\n33	14	6	27\n33	14	7	7\n33	14	7	1\n33	14	8	8\n33	14	8	6\n33	14	9	6	9\n33	14	9	1	17\n33	14	10	10\n33	14	10	4\n33	14	11	6	11	12\n33	14	11	1	32	1\n33	14	12	12\n33	14	12	21\n33	14	13	13\n33	14	13	65\n33	14	14	14\n33	14	14	12\n33	14	15	15\n33	14	15	38\n33	14	16	16\n33	14	16	2\n33	14	20	20\n33	14	20	5\n33	14	24	24\n33	14	24	1\n33	15	6	6\n33	15	6	29\n33	15	7	7\n33	15	7	1\n33	15	8	8\n33	15	8	6\n33	15	9	9\n33	15	9	17\n33	15	10	10\n33	15	10	4\n33	15	11	10	11\n33	15	11	1	31\n33	15	12	12\n33	15	12	22\n33	15	13	6	13	15\n33	15	13	1	63	1\n33	15	14	14\n33	15	14	12\n33	15	15	13	15\n33	15	15	1	37\n33	15	16	16\n33	15	16	2\n33	15	20	16	20\n33	15	20	1	4\n33	15	24	24\n33	15	24	1\n33	16	6	6\n33	16	6	30\n33	16	7	7\n33	16	7	1\n33	16	8	8\n33	16	8	6\n33	16	9	9\n33	16	9	17\n33	16	10	10\n33	16	10	5\n33	16	11	11\n33	16	11	31\n33	16	12	12\n33	16	12	22\n33	16	13	6	13	15\n33	16	13	2	59	3\n33	16	14	14\n33	16	14	12\n33	16	15	9	13	15\n33	16	15	2	1	35\n33	16	16	16\n33	16	16	3\n33	16	20	20\n33	16	20	4\n33	16	24	21\n33	16	24	1\n33	17	6	6\n33	17	6	32\n33	17	7	7\n33	17	7	1\n33	17	8	6	8\n33	17	8	2	4\n33	17	9	6	9\n33	17	9	1	18\n33	17	10	10\n33	17	10	5\n33	17	11	6	10	11\n33	17	11	1	2	28\n33	17	12	12\n33	17	12	22\n33	17	13	6	9	13	15\n33	17	13	9	1	49	1\n33	17	14	6	9	14\n33	17	14	1	1	10\n33	17	15	6	9	15\n33	17	15	5	3	30\n33	17	16	9	15	16\n33	17	16	1	1	1\n33	17	20	15	16	20\n33	17	20	1	2	1\n33	17	21	21\n33	17	21	1\n33	18	6	6\n33	18	6	51\n33	18	7	7\n33	18	7	1\n33	18	8	6	8\n33	18	8	1	3\n33	18	9	6	8	9\n33	18	9	2	1	21\n33	18	10	10\n33	18	10	7\n33	18	11	6	9	10	11	12\n33	18	11	2	1	2	21	2\n33	18	12	6	10	11	12\n33	18	12	1	3	1	17\n33	18	13	6	9	13\n33	18	13	9	2	38\n33	18	14	14\n33	18	14	10\n33	18	15	6	9	15\n33	18	15	5	4	24\n33	18	16	16\n33	18	16	3\n33	18	20	20\n33	18	20	1\n33	18	21	21\n33	18	21	1\n33	19	6	6\n33	19	6	71\n33	19	7	9\n33	19	7	1\n33	19	8	6	8\n33	19	8	1	3\n33	19	9	6	8	9\n33	19	9	1	1	26\n33	19	10	6	10\n33	19	10	1	11\n33	19	11	6	10	11	12\n33	19	11	2	2	14	4\n33	19	12	6	10	11	12\n33	19	12	2	1	1	15\n33	19	13	6	8	9	10	12	13	15\n33	19	13	6	1	1	1	1	27	1\n33	19	14	11	14\n33	19	14	1	9\n33	19	15	6	8	9	10	13	15\n33	19	15	2	1	2	3	1	15\n33	19	16	8	11	16\n33	19	16	1	1	1\n33	19	20	9\n33	19	20	1\n33	19	21	21\n33	19	21	1\n33	20	6	6\n33	20	6	86\n33	20	8	8	9\n33	20	8	6	1\n33	20	9	6	9\n33	20	9	1	30\n33	20	10	6	10\n33	20	10	1	17\n33	20	11	10	11\n33	20	11	3	14\n33	20	12	8	10	12\n33	20	12	1	1	18\n33	20	13	6	13	15\n33	20	13	8	19	1\n33	20	14	8	10	11	12	14	16\n33	20	14	3	1	1	1	2	1\n33	20	15	6	9	13	15\n33	20	15	3	3	1	9\n33	20	16	16\n33	20	16	1\n33	20	21	13\n33	20	21	1\n33	21	6	6	9\n33	21	6	97	2\n33	21	8	8\n33	21	8	10\n33	21	9	8	9\n33	21	9	1	33\n33	21	10	10\n33	21	10	22\n33	21	11	6	10	11\n33	21	11	1	3	11\n33	21	12	6	8	10	12	19\n33	21	12	1	1	1	15	1\n33	21	13	6	12	13\n33	21	13	13	1	7\n33	21	14	10	16\n33	21	14	1	1\n33	21	15	6	9	15\n33	21	15	2	4	4\n33	21	16	16\n33	21	16	2\n33	22	6	6	9\n33	22	6	112	2\n33	22	8	8\n33	22	8	12\n33	22	9	9\n33	22	9	39\n33	22	10	10\n33	22	10	27\n33	22	11	8	10	11\n33	22	11	1	1	9\n33	22	12	6	10	11	12\n33	22	12	1	1	1	13\n33	22	13	6	9\n33	22	13	6	1\n33	22	15	9	15\n33	22	15	1	3\n33	22	16	8	16\n33	22	16	1	2\n33	22	19	19\n33	22	19	1\n33	23	6	6	9\n33	23	6	118	1\n33	23	8	8	9\n33	23	8	13	1\n33	23	9	6	9\n33	23	9	3	40\n33	23	10	10\n33	23	10	29\n33	23	11	6	8	10	11\n33	23	11	2	1	2	5\n33	23	12	6	12\n33	23	12	1	12\n33	23	15	9	15\n33	23	15	2	1\n33	23	16	8	16\n33	23	16	1	1\n33	23	19	19\n33	23	19	1\n33	24	6	6	9\n33	24	6	123	1\n33	24	8	8	9\n33	24	8	14	1\n33	24	9	6	9\n33	24	9	2	42\n33	24	10	10\n33	24	10	31\n33	24	11	11\n33	24	11	5\n33	24	12	12\n33	24	12	12\n33	24	15	6\n33	24	15	1\n33	24	16	16\n33	24	16	1\n33	24	19	19\n33	24	19	1\n33	25	6	6	9\n33	25	6	124	2\n33	25	8	6	8\n33	25	8	1	13\n33	25	9	9\n33	25	9	44\n33	25	10	10\n33	25	10	31\n33	25	11	11\n33	25	11	5\n33	25	12	12\n33	25	12	12\n33	25	16	16\n33	25	16	1\n33	25	19	16\n33	25	19	1\n33	26	6	6	9\n33	26	6	124	1\n33	26	8	8\n33	26	8	13\n33	26	9	9\n33	26	9	46\n33	26	10	10\n33	26	10	31\n33	26	11	11\n33	26	11	5\n33	26	12	12\n33	26	12	12\n33	26	16	16\n33	26	16	2\n33	27	6	6\n33	27	6	124\n33	27	8	8\n33	27	8	13\n33	27	9	9\n33	27	9	47\n33	27	10	10\n33	27	10	31\n33	27	11	11\n33	27	11	5\n33	27	12	12\n33	27	12	12\n33	27	16	14	16\n33	27	16	1	1\n33	28	6	6\n33	28	6	124\n33	28	8	8\n33	28	8	13\n33	28	9	9\n33	28	9	47\n33	28	10	10\n33	28	10	31\n33	28	11	11\n33	28	11	5\n33	28	12	12\n33	28	12	12\n33	28	14	17\n33	28	14	1\n33	28	16	16\n33	28	16	1\n33	29	6	6\n33	29	6	124\n33	29	8	8\n33	29	8	13\n33	29	9	9\n33	29	9	47\n33	29	10	10\n33	29	10	31\n33	29	11	11\n33	29	11	5\n33	29	12	12\n33	29	12	12\n33	29	16	16\n33	29	16	1\n33	29	17	12\n33	29	17	1\n33	30	6	6\n33	30	6	124\n33	30	8	8\n33	30	8	13\n33	30	9	9\n33	30	9	47\n33	30	10	10\n33	30	10	31\n33	30	11	11\n33	30	11	5\n33	30	12	12\n33	30	12	13\n33	30	16	16\n33	30	16	1\n33	31	6	6\n33	31	6	124\n33	31	8	8\n33	31	8	13\n33	31	9	6	8	9\n33	31	9	19	2	26\n33	31	10	10\n33	31	10	31\n33	31	11	11\n33	31	11	5\n33	31	12	12\n33	31	12	13\n33	31	16	16\n33	31	16	1\n33	32	6	6\n33	32	6	143\n33	32	8	8\n33	32	8	15\n33	32	9	6	8	9\n33	32	9	10	1	15\n33	32	10	10\n33	32	10	31\n33	32	11	11\n33	32	11	5\n33	32	12	10	11	12\n33	32	12	1	1	11\n33	32	16	16\n33	32	16	1\n34	1	6	6\n34	1	6	5\n34	1	7	7\n34	1	7	5\n34	1	8	8\n34	1	8	9\n34	1	9	9\n34	1	9	6\n34	1	10	10\n34	1	10	1\n34	1	11	11\n34	1	11	29\n34	1	12	11	12	15\n34	1	12	2	19	1\n34	1	13	13	15\n34	1	13	58	2\n34	1	14	14\n34	1	14	13\n34	1	15	13	15\n34	1	15	2	47\n34	1	16	16	20	21\n34	1	16	9	1	1\n34	1	17	17\n34	1	17	1\n34	1	20	20\n34	1	20	1\n34	1	21	21\n34	1	21	1\n34	2	6	6\n34	2	6	5\n34	2	7	7\n34	2	7	5\n34	2	8	8	12\n34	2	8	8	1\n34	2	9	9	10\n34	2	9	5	1\n34	2	10	10\n34	2	10	1\n34	2	11	11\n34	2	11	31\n34	2	12	11	12\n34	2	12	3	16\n34	2	13	13	15\n34	2	13	59	1\n34	2	14	14\n34	2	14	13\n34	2	15	13	15\n34	2	15	2	48\n34	2	16	16\n34	2	16	9\n34	2	17	17\n34	2	17	1\n34	2	20	20\n34	2	20	2\n34	2	21	21\n34	2	21	2\n34	3	6	6\n34	3	6	5\n34	3	7	7\n34	3	7	5\n34	3	8	8\n34	3	8	8\n34	3	9	9\n34	3	9	5\n34	3	10	10\n34	3	10	2\n34	3	11	11\n34	3	11	34\n34	3	12	12\n34	3	12	17\n34	3	13	13\n34	3	13	61\n34	3	14	14\n34	3	14	13\n34	3	15	15\n34	3	15	49\n34	3	16	14	15	16\n34	3	16	1	1	7\n34	3	17	17\n34	3	17	1\n34	3	20	20\n34	3	20	2\n34	3	21	21\n34	3	21	2\n34	4	6	6\n34	4	6	5\n34	4	7	7\n34	4	7	5\n34	4	8	8\n34	4	8	8\n34	4	9	9\n34	4	9	5\n34	4	10	10\n34	4	10	2\n34	4	11	11	12\n34	4	11	33	1\n34	4	12	11	12\n34	4	12	1	16\n34	4	13	12	13\n34	4	13	1	60\n34	4	14	14\n34	4	14	14\n34	4	15	15\n34	4	15	50\n34	4	16	16\n34	4	16	7\n34	4	17	17\n34	4	17	1\n34	4	20	20\n34	4	20	2\n34	4	21	21\n34	4	21	2\n34	5	6	6\n34	5	6	5\n34	5	7	7\n34	5	7	5\n34	5	8	8\n34	5	8	8\n34	5	9	9\n34	5	9	5\n34	5	10	10\n34	5	10	2\n34	5	11	11\n34	5	11	34\n34	5	12	11	12\n34	5	12	1	17\n34	5	13	13\n34	5	13	60\n34	5	14	14\n34	5	14	14\n34	5	15	13	15\n34	5	15	1	49\n34	5	16	16\n34	5	16	7\n34	5	17	17\n34	5	17	1\n34	5	20	20\n34	5	20	2\n34	5	21	21\n34	5	21	2\n34	6	6	6\n34	6	6	5\n34	6	7	7\n34	6	7	5\n34	6	8	8\n34	6	8	8\n34	6	9	9\n34	6	9	5\n34	6	10	9	10\n34	6	10	1	1\n34	6	11	11\n34	6	11	35\n34	6	12	11	12\n34	6	12	1	16\n34	6	13	12	13\n34	6	13	2	59\n34	6	14	14\n34	6	14	14\n34	6	15	15\n34	6	15	49\n34	6	16	16\n34	6	16	7\n34	6	17	17\n34	6	17	1\n34	6	20	20\n34	6	20	2\n34	6	21	21\n34	6	21	2\n34	7	6	6\n34	7	6	5\n34	7	7	7\n34	7	7	5\n34	7	8	8\n34	7	8	8\n34	7	9	9\n34	7	9	6\n34	7	10	10\n34	7	10	1\n34	7	11	11	13\n34	7	11	35	1\n34	7	12	12\n34	7	12	18\n34	7	13	13\n34	7	13	59\n34	7	14	14\n34	7	14	14\n34	7	15	15\n34	7	15	49\n34	7	16	16\n34	7	16	7\n34	7	17	9\n34	7	17	1\n34	7	20	20\n34	7	20	2\n34	7	21	15	21\n34	7	21	1	1\n34	8	6	6\n34	8	6	5\n34	8	7	7\n34	8	7	5\n34	8	8	8\n34	8	8	8\n34	8	9	9\n34	8	9	7\n34	8	10	10\n34	8	10	1\n34	8	11	11\n34	8	11	35\n34	8	12	12\n34	8	12	18\n34	8	13	6	13\n34	8	13	1	59\n34	8	14	14\n34	8	14	14\n34	8	15	15\n34	8	15	50\n34	8	16	16\n34	8	16	7\n34	8	20	20\n34	8	20	2\n34	8	21	21\n34	8	21	1\n34	9	6	6\n34	9	6	6\n34	9	7	7\n34	9	7	5\n34	9	8	8\n34	9	8	8\n34	9	9	9\n34	9	9	7\n34	9	10	10\n34	9	10	1\n34	9	11	11\n34	9	11	35\n34	9	12	12\n34	9	12	18\n34	9	13	6	13\n34	9	13	1	58\n34	9	14	14\n34	9	14	14\n34	9	15	6	15\n34	9	15	1	49\n34	9	16	16\n34	9	16	7\n34	9	20	20\n34	9	20	2\n34	9	21	9\n34	9	21	1\n34	10	6	6\n34	10	6	8\n34	10	7	7\n34	10	7	5\n34	10	8	8\n34	10	8	8\n34	10	9	9\n34	10	9	8\n34	10	10	10\n34	10	10	1\n34	10	11	11	12\n34	10	11	34	1\n34	10	12	12\n34	10	12	18\n34	10	13	6	13\n34	10	13	1	57\n34	10	14	14\n34	10	14	14\n34	10	15	15\n34	10	15	49\n34	10	16	16\n34	10	16	7\n34	10	20	20\n34	10	20	2\n34	11	6	6\n34	11	6	9\n34	11	7	7\n34	11	7	5\n34	11	8	6	8\n34	11	8	1	7\n34	11	9	9\n34	11	9	8\n34	11	10	10\n34	11	10	1\n34	11	11	9	11\n34	11	11	1	33\n34	11	12	12\n34	11	12	19\n34	11	13	9	13\n34	11	13	1	56\n34	11	14	14\n34	11	14	14\n34	11	15	6	15\n34	11	15	2	47\n34	11	16	16\n34	11	16	7\n34	11	20	20\n34	11	20	2\n34	12	6	6	9\n34	12	6	11	1\n34	12	7	7\n34	12	7	5\n34	12	8	6	8\n34	12	8	2	5\n34	12	9	9\n34	12	9	10\n34	12	10	10\n34	12	10	1\n34	12	11	11	13\n34	12	11	32	1\n34	12	12	10	12\n34	12	12	1	18\n34	12	13	6	9	11	13\n34	12	13	4	1	1	50\n34	12	14	14\n34	12	14	14\n34	12	15	6	15\n34	12	15	3	44\n34	12	16	16\n34	12	16	7\n34	12	20	20\n34	12	20	2\n34	13	6	6\n34	13	6	20\n34	13	7	6	7\n34	13	7	1	4\n34	13	8	8\n34	13	8	5\n34	13	9	9\n34	13	9	12\n34	13	10	10\n34	13	10	2\n34	13	11	6	11	12\n34	13	11	1	30	2\n34	13	12	12\n34	13	12	18\n34	13	13	6	13\n34	13	13	3	48\n34	13	14	14\n34	13	14	14\n34	13	15	6	9	15\n34	13	15	3	1	40\n34	13	16	16\n34	13	16	7\n34	13	20	20\n34	13	20	2\n34	14	6	6\n34	14	6	28\n34	14	7	7\n34	14	7	4\n34	14	8	8\n34	14	8	5\n34	14	9	6	9\n34	14	9	1	12\n34	14	10	10\n34	14	10	2\n34	14	11	11	12\n34	14	11	29	1\n34	14	12	12\n34	14	12	20\n34	14	13	6	13\n34	14	13	1	47\n34	14	14	12	14\n34	14	14	1	13\n34	14	15	6	15\n34	14	15	2	38\n34	14	16	16\n34	14	16	7\n34	14	20	20\n34	14	20	2\n34	15	6	6\n34	15	6	32\n34	15	7	7\n34	15	7	4\n34	15	8	8\n34	15	8	5\n34	15	9	9\n34	15	9	12\n34	15	10	10\n34	15	10	2\n34	15	11	11	12\n34	15	11	28	1\n34	15	12	9	12\n34	15	12	1	21\n34	15	13	13\n34	15	13	47\n34	15	14	14\n34	15	14	13\n34	15	15	15\n34	15	15	38\n34	15	16	15	16\n34	15	16	2	5\n34	15	20	20\n34	15	20	2\n34	16	6	6\n34	16	6	32\n34	16	7	7\n34	16	7	4\n34	16	8	8\n34	16	8	5\n34	16	9	9\n34	16	9	13\n34	16	10	10\n34	16	10	2\n34	16	11	6	10	11\n34	16	11	1	1	26\n34	16	12	6	12\n34	16	12	1	21\n34	16	13	13\n34	16	13	47\n34	16	14	10	14\n34	16	14	1	12\n34	16	15	15	16\n34	16	15	39	1\n34	16	16	16\n34	16	16	5\n34	16	20	20\n34	16	20	2\n34	17	6	6	9\n34	17	6	33	1\n34	17	7	7	9\n34	17	7	3	1\n34	17	8	6	8\n34	17	8	1	4\n34	17	9	6	9\n34	17	9	1	12\n34	17	10	10\n34	17	10	4\n34	17	11	6	9	11\n34	17	11	2	1	23\n34	17	12	10	12\n34	17	12	1	20\n34	17	13	9	13\n34	17	13	1	46\n34	17	14	14\n34	17	14	12\n34	17	15	8	13	15\n34	17	15	1	2	36\n34	17	16	16\n34	17	16	6\n34	17	20	20\n34	17	20	2\n34	18	6	6\n34	18	6	37\n34	18	7	6	7\n34	18	7	1	2\n34	18	8	8\n34	18	8	5\n34	18	9	9\n34	18	9	16\n34	18	10	6	10\n34	18	10	1	4\n34	18	11	6	10	11\n34	18	11	1	1	21\n34	18	12	6	10	12\n34	18	12	1	1	18\n34	18	13	6	13\n34	18	13	9	39\n34	18	14	14\n34	18	14	12\n34	18	15	6	8	9	13	15\n34	18	15	2	1	1	2	30\n34	18	16	16\n34	18	16	6\n34	18	20	16	20\n34	18	20	1	1\n34	19	6	6	9\n34	19	6	50	2\n34	19	7	6	7\n34	19	7	1	1\n34	19	8	6	8\n34	19	8	3	3\n34	19	9	6	9\n34	19	9	1	16\n34	19	10	9	10\n34	19	10	1	5\n34	19	11	6	10	11\n34	19	11	1	2	18\n34	19	12	6	10	12\n34	19	12	1	1	16\n34	19	13	6	9	10	13\n34	19	13	15	1	1	24\n34	19	14	6	14\n34	19	14	1	11\n34	19	15	6	9	11	13	15\n34	19	15	5	3	1	1	20\n34	19	16	9	15	16\n34	19	16	1	1	5\n34	19	20	15\n34	19	20	1\n34	20	6	6	9\n34	20	6	75	3\n34	20	7	9\n34	20	7	1\n34	20	8	8\n34	20	8	3\n34	20	9	7	9\n34	20	9	1	23\n34	20	10	10\n34	20	10	9\n34	20	11	6	9	10	11	12\n34	20	11	5	1	1	10	2\n34	20	12	10	12\n34	20	12	1	15\n34	20	13	6	9	13\n34	20	13	10	1	14\n34	20	14	6	8	10	11	14	16\n34	20	14	1	2	2	2	3	1\n34	20	15	6	9	10	13	15\n34	20	15	3	3	1	2	13\n34	20	16	8	10	16\n34	20	16	1	1	3\n34	21	6	6	7	9\n34	21	6	91	1	2\n34	21	7	7\n34	21	7	1\n34	21	8	8\n34	21	8	6\n34	21	9	6	8	9\n34	21	9	2	1	29\n34	21	10	8	10\n34	21	10	1	14\n34	21	11	6	10	11\n34	21	11	3	3	6\n34	21	12	8	10	12	15\n34	21	12	1	1	14	1\n34	21	13	6	9	13\n34	21	13	7	1	8\n34	21	14	10	11	14\n34	21	14	1	1	1\n34	21	15	6	8	9	10	13	15\n34	21	15	4	1	1	1	1	5\n34	21	16	11	12	16\n34	21	16	1	1	2\n34	22	6	6	9\n34	22	6	105	2\n34	22	7	6	7\n34	22	7	1	1\n34	22	8	8\n34	22	8	10\n34	22	9	9\n34	22	9	33\n34	22	10	6	10\n34	22	10	1	19\n34	22	11	10	11\n34	22	11	2	6\n34	22	12	12\n34	22	12	15\n34	22	13	6	9	13\n34	22	13	6	1	2\n34	22	14	8\n34	22	14	1\n34	22	15	6	15\n34	22	15	2	4\n34	22	16	16\n34	22	16	2\n34	23	6	6	9\n34	23	6	114	1\n34	23	7	7\n34	23	7	1\n34	23	8	8\n34	23	8	11\n34	23	9	6	9\n34	23	9	2	34\n34	23	10	10\n34	23	10	21\n34	23	11	10	11\n34	23	11	1	5\n34	23	12	9	10	12\n34	23	12	1	1	13\n34	23	13	6\n34	23	13	2\n34	23	15	9	10	15\n34	23	15	1	1	2\n34	23	16	16\n34	23	16	2\n34	24	6	6	9\n34	24	6	117	1\n34	24	7	7\n34	24	7	1\n34	24	8	8\n34	24	8	11\n34	24	9	6	9\n34	24	9	1	36\n34	24	10	10\n34	24	10	24\n34	24	11	10	11\n34	24	11	1	4\n34	24	12	10	12\n34	24	12	4	9\n34	24	15	6	9\n34	24	15	1	1\n34	24	16	16\n34	24	16	2\n34	25	6	6	9\n34	25	6	118	1\n34	25	7	7\n34	25	7	1\n34	25	8	8\n34	25	8	11\n34	25	9	6	9\n34	25	9	1	37\n34	25	10	10\n34	25	10	29\n34	25	11	11\n34	25	11	4\n34	25	12	12\n34	25	12	9\n34	25	16	16\n34	25	16	2\n34	26	6	6	9\n34	26	6	116	3\n34	26	7	7\n34	26	7	1\n34	26	8	8\n34	26	8	11\n34	26	9	9\n34	26	9	38\n34	26	10	10	12\n34	26	10	28	1\n34	26	11	11\n34	26	11	4\n34	26	12	12\n34	26	12	9\n34	26	16	16\n34	26	16	2\n34	27	6	6	9\n34	27	6	114	2\n34	27	7	7\n34	27	7	1\n34	27	8	8\n34	27	8	11\n34	27	9	9\n34	27	9	41\n34	27	10	10\n34	27	10	28\n34	27	11	11\n34	27	11	4\n34	27	12	10	12\n34	27	12	1	9\n34	27	16	16\n34	27	16	2\n34	28	6	6\n34	28	6	114\n34	28	7	6\n34	28	7	1\n34	28	8	8\n34	28	8	11\n34	28	9	6	9\n34	28	9	1	42\n34	28	10	8	10\n34	28	10	1	28\n34	28	11	11\n34	28	11	4\n34	28	12	12\n34	28	12	9\n34	28	16	16\n34	28	16	2\n34	29	6	6	9\n34	29	6	114	2\n34	29	8	8\n34	29	8	12\n34	29	9	9\n34	29	9	42\n34	29	10	10\n34	29	10	28\n34	29	11	11\n34	29	11	4\n34	29	12	12\n34	29	12	9\n34	29	16	16\n34	29	16	2\n34	30	6	6\n34	30	6	114\n34	30	8	8\n34	30	8	12\n34	30	9	9\n34	30	9	44\n34	30	10	10\n34	30	10	28\n34	30	11	11\n34	30	11	4\n34	30	12	12\n34	30	12	9\n34	30	16	16\n34	30	16	2\n34	31	6	6\n34	31	6	114\n34	31	8	8\n34	31	8	12\n34	31	9	9\n34	31	9	44\n34	31	10	10\n34	31	10	28\n34	31	11	11\n34	31	11	4\n34	31	12	12\n34	31	12	9\n34	31	16	16\n34	31	16	2\n34	32	6	6\n34	32	6	114\n34	32	8	8\n34	32	8	12\n34	32	9	6	9\n34	32	9	15	29\n34	32	10	10\n34	32	10	28\n34	32	11	11\n34	32	11	4\n34	32	12	12\n34	32	12	9\n34	32	16	16\n34	32	16	2\n34	33	6	6\n34	33	6	129\n34	33	8	8\n34	33	8	12\n34	33	9	6	9\n34	33	9	16	13\n34	33	10	10\n34	33	10	28\n34	33	11	11\n34	33	11	4\n34	33	12	10	12\n34	33	12	2	7\n34	33	16	16\n34	33	16	2\n35	1	6	6\n35	1	6	4\n35	1	7	7\n35	1	7	4\n35	1	8	8\n35	1	8	2\n35	1	9	9\n35	1	9	10\n35	1	11	11\n35	1	11	14\n35	1	12	12\n35	1	12	9\n35	1	13	12	13\n35	1	13	1	40\n35	1	14	14\n35	1	14	10\n35	1	15	13	15\n35	1	15	3	31\n35	1	16	16	20\n35	1	16	5	1\n35	1	18	18\n35	1	18	1\n35	2	6	6\n35	2	6	4\n35	2	7	7\n35	2	7	4\n35	2	8	8\n35	2	8	2\n35	2	9	9\n35	2	9	10\n35	2	11	11	12\n35	2	11	13	1\n35	2	12	12\n35	2	12	10\n35	2	13	13	14\n35	2	13	42	1\n35	2	14	14\n35	2	14	10\n35	2	15	13	15\n35	2	15	2	29\n35	2	16	16\n35	2	16	5\n35	2	18	18\n35	2	18	1\n35	2	20	20\n35	2	20	1\n35	3	6	6\n35	3	6	4\n35	3	7	7\n35	3	7	4\n35	3	8	8\n35	3	8	2\n35	3	9	9\n35	3	9	10\n35	3	11	11\n35	3	11	13\n35	3	12	12\n35	3	12	11\n35	3	13	11	13\n35	3	13	1	43\n35	3	14	14\n35	3	14	11\n35	3	15	13	15\n35	3	15	1	28\n35	3	16	16\n35	3	16	5\n35	3	18	18\n35	3	18	1\n35	3	20	20\n35	3	20	1\n35	4	6	6\n35	4	6	4\n35	4	7	7\n35	4	7	4\n35	4	8	8\n35	4	8	2\n35	4	9	9\n35	4	9	10\n35	4	11	11\n35	4	11	14\n35	4	12	12\n35	4	12	11\n35	4	13	12	13\n35	4	13	1	43\n35	4	14	14\n35	4	14	11\n35	4	15	13	15\n35	4	15	1	27\n35	4	16	16\n35	4	16	5\n35	4	18	18\n35	4	18	1\n35	4	20	20\n35	4	20	1\n35	5	6	6\n35	5	6	4\n35	5	7	7\n35	5	7	4\n35	5	8	8\n35	5	8	2\n35	5	9	9\n35	5	9	10\n35	5	11	11\n35	5	11	14\n35	5	12	12\n35	5	12	12\n35	5	13	13\n35	5	13	44\n35	5	14	14\n35	5	14	11\n35	5	15	15\n35	5	15	27\n35	5	16	16\n35	5	16	5\n35	5	18	18\n35	5	18	1\n35	5	20	20\n35	5	20	1\n35	6	6	6\n35	6	6	4\n35	6	7	7\n35	6	7	4\n35	6	8	8\n35	6	8	2\n35	6	9	9\n35	6	9	10\n35	6	11	11\n35	6	11	14\n35	6	12	12\n35	6	12	12\n35	6	13	13\n35	6	13	44\n35	6	14	14\n35	6	14	11\n35	6	15	15\n35	6	15	27\n35	6	16	16\n35	6	16	5\n35	6	18	18\n35	6	18	1\n35	6	20	20\n35	6	20	1\n35	7	6	6\n35	7	6	4\n35	7	7	7\n35	7	7	4\n35	7	8	8\n35	7	8	2\n35	7	9	9\n35	7	9	10\n35	7	11	11\n35	7	11	14\n35	7	12	11	12	13\n35	7	12	1	10	1\n35	7	13	6	13\n35	7	13	2	42\n35	7	14	14\n35	7	14	11\n35	7	15	15\n35	7	15	27\n35	7	16	16\n35	7	16	5\n35	7	18	18\n35	7	18	1\n35	7	20	20\n35	7	20	1\n35	8	6	6\n35	8	6	6\n35	8	7	7\n35	8	7	4\n35	8	8	8\n35	8	8	2\n35	8	9	9\n35	8	9	10\n35	8	11	11	13\n35	8	11	14	1\n35	8	12	12\n35	8	12	10\n35	8	13	13\n35	8	13	43\n35	8	14	14\n35	8	14	11\n35	8	15	15\n35	8	15	27\n35	8	16	16\n35	8	16	5\n35	8	18	15\n35	8	18	1\n35	8	20	20\n35	8	20	1\n35	9	6	6\n35	9	6	6\n35	9	7	7\n35	9	7	4\n35	9	8	8\n35	9	8	2\n35	9	9	9\n35	9	9	10\n35	9	11	11\n35	9	11	14\n35	9	12	12\n35	9	12	10\n35	9	13	13\n35	9	13	44\n35	9	14	14\n35	9	14	11\n35	9	15	6	15\n35	9	15	1	27\n35	9	16	16\n35	9	16	5\n35	9	20	20\n35	9	20	1\n35	10	6	6\n35	10	6	7\n35	10	7	7\n35	10	7	4\n35	10	8	8\n35	10	8	2\n35	10	9	9\n35	10	9	10\n35	10	11	11\n35	10	11	14\n35	10	12	12\n35	10	12	10\n35	10	13	9	13	14\n35	10	13	1	42	1\n35	10	14	14\n35	10	14	11\n35	10	15	15\n35	10	15	27\n35	10	16	16\n35	10	16	5\n35	10	20	20\n35	10	20	1\n35	11	6	6\n35	11	6	7\n35	11	7	7\n35	11	7	4\n35	11	8	8\n35	11	8	2\n35	11	9	6	9\n35	11	9	1	10\n35	11	11	6	10	11\n35	11	11	1	1	12\n35	11	12	12\n35	11	12	10\n35	11	13	13\n35	11	13	42\n35	11	14	14\n35	11	14	12\n35	11	15	15\n35	11	15	27\n35	11	16	16\n35	11	16	5\n35	11	20	20\n35	11	20	1\n35	12	6	6	9\n35	12	6	8	1\n35	12	7	7\n35	12	7	4\n35	12	8	8\n35	12	8	2\n35	12	9	9\n35	12	9	10\n35	12	10	10\n35	12	10	1\n35	12	11	11\n35	12	11	12\n35	12	12	12\n35	12	12	10\n35	12	13	6	9	13\n35	12	13	5	2	35\n35	12	14	13	14\n35	12	14	1	11\n35	12	15	9	15\n35	12	15	1	26\n35	12	16	16\n35	12	16	5\n35	12	20	20\n35	12	20	1\n35	13	6	6	9\n35	13	6	11	2\n35	13	7	7\n35	13	7	4\n35	13	8	8\n35	13	8	2\n35	13	9	9\n35	13	9	14\n35	13	10	10\n35	13	10	1\n35	13	11	6	11\n35	13	11	1	11\n35	13	12	10	12\n35	13	12	2	8\n35	13	13	6	13\n35	13	13	4	32\n35	13	14	14\n35	13	14	11\n35	13	15	6	9	15\n35	13	15	1	2	23\n35	13	16	16\n35	13	16	5\n35	13	20	20\n35	13	20	1\n35	14	6	6\n35	14	6	17\n35	14	7	7\n35	14	7	4\n35	14	8	8\n35	14	8	2\n35	14	9	9\n35	14	9	18\n35	14	10	10\n35	14	10	3\n35	14	11	11\n35	14	11	11\n35	14	12	12\n35	14	12	8\n35	14	13	6	13\n35	14	13	2	30\n35	14	14	6	14\n35	14	14	1	10\n35	14	15	6	15\n35	14	15	3	20\n35	14	16	16\n35	14	16	5\n35	14	20	20\n35	14	20	1\n35	15	6	6\n35	15	6	23\n35	15	7	7\n35	15	7	4\n35	15	8	8\n35	15	8	2\n35	15	9	9\n35	15	9	18\n35	15	10	10\n35	15	10	3\n35	15	11	11\n35	15	11	11\n35	15	12	12\n35	15	12	8\n35	15	13	13\n35	15	13	30\n35	15	14	14\n35	15	14	10\n35	15	15	15\n35	15	15	20\n35	15	16	16\n35	15	16	5\n35	15	20	20\n35	15	20	1\n35	16	6	6	9\n35	16	6	22	1\n35	16	7	7\n35	16	7	4\n35	16	8	8\n35	16	8	2\n35	16	9	6	9\n35	16	9	1	17\n35	16	10	10\n35	16	10	3\n35	16	11	11\n35	16	11	11\n35	16	12	12\n35	16	12	8\n35	16	13	13	15\n35	16	13	29	1\n35	16	14	14\n35	16	14	10\n35	16	15	13	15\n35	16	15	1	19\n35	16	16	16\n35	16	16	5\n35	16	20	20\n35	16	20	1\n35	17	6	6\n35	17	6	23\n35	17	7	7\n35	17	7	4\n35	17	8	6	8\n35	17	8	1	1\n35	17	9	9\n35	17	9	18\n35	17	10	10\n35	17	10	3\n35	17	11	11\n35	17	11	11\n35	17	12	12\n35	17	12	8\n35	17	13	13	15\n35	17	13	29	1\n35	17	14	12	14\n35	17	14	1	9\n35	17	15	6	13	15\n35	17	15	1	2	17\n35	17	16	16\n35	17	16	5\n35	17	20	20\n35	17	20	1\n35	18	6	6\n35	18	6	25\n35	18	7	6	7\n35	18	7	1	3\n35	18	8	8\n35	18	8	1\n35	18	9	6	9\n35	18	9	1	17\n35	18	10	6	10\n35	18	10	1	2\n35	18	11	6	11\n35	18	11	1	10\n35	18	12	8	12\n35	18	12	1	8\n35	18	13	6	11	13	15\n35	18	13	4	1	25	1\n35	18	14	14\n35	18	14	9\n35	18	15	6	9	13	15\n35	18	15	2	1	2	13\n35	18	16	15	16\n35	18	16	1	4\n35	18	20	20\n35	18	20	1\n35	19	6	6	9\n35	19	6	33	2\n35	19	7	6	7\n35	19	7	1	2\n35	19	8	8\n35	19	8	2\n35	19	9	6	7	9\n35	19	9	5	2	11\n35	19	10	10\n35	19	10	2\n35	19	11	10	11\n35	19	11	2	9\n35	19	12	6	12\n35	19	12	1	7\n35	19	13	6	9	13\n35	19	13	9	2	16\n35	19	14	8	10	14\n35	19	14	3	1	5\n35	19	15	6	15\n35	19	15	2	13\n35	19	16	8	14	16\n35	19	16	1	1	2\n35	19	20	20\n35	19	20	1\n35	20	6	6	9\n35	20	6	48	3\n35	20	7	6	7\n35	20	7	1	3\n35	20	8	6	8	9\n35	20	8	1	4	1\n35	20	9	8	9	10\n35	20	9	1	13	1\n35	20	10	10\n35	20	10	5\n35	20	11	6	10	11\n35	20	11	1	1	7\n35	20	12	6	12\n35	20	12	1	6\n35	20	13	6	9	13\n35	20	13	6	1	9\n35	20	14	6	14	16\n35	20	14	1	4	1\n35	20	15	6	10	15\n35	20	15	2	3	8\n35	20	16	8	16\n35	20	16	1	1\n35	20	20	15\n35	20	20	1\n35	21	6	6\n35	21	6	61\n35	21	7	7\n35	21	7	3\n35	21	8	8	9\n35	21	8	4	2\n35	21	9	9\n35	21	9	18\n35	21	10	6	10\n35	21	10	1	9\n35	21	11	6	11	12\n35	21	11	1	5	1\n35	21	12	12\n35	21	12	6\n35	21	13	6	13\n35	21	13	7	2\n35	21	14	6	8	10	14\n35	21	14	1	1	1	1\n35	21	15	6	9	13	15\n35	21	15	2	2	1	4\n35	21	16	9	10\n35	21	16	1	1\n35	22	6	6\n35	22	6	73\n35	22	7	7\n35	22	7	3\n35	22	8	8\n35	22	8	5\n35	22	9	6	9\n35	22	9	3	20\n35	22	10	10\n35	22	10	11\n35	22	11	6	11\n35	22	11	3	2\n35	22	12	10	12\n35	22	12	1	6\n35	22	13	6	13\n35	22	13	2	1\n35	22	14	11\n35	22	14	1\n35	22	15	8	9	15\n35	22	15	1	1	2\n35	23	6	6	9\n35	23	6	77	4\n35	23	7	7\n35	23	7	3\n35	23	8	8\n35	23	8	6\n35	23	9	9\n35	23	9	21\n35	23	10	10\n35	23	10	12\n35	23	11	11\n35	23	11	3\n35	23	12	10	12\n35	23	12	1	5\n35	23	13	6\n35	23	13	1\n35	23	15	6	15\n35	23	15	1	1\n35	24	6	6	9\n35	24	6	77	2\n35	24	7	6	7\n35	24	7	1	2\n35	24	8	8\n35	24	8	6\n35	24	9	6	9\n35	24	9	1	24\n35	24	10	10\n35	24	10	13\n35	24	11	11\n35	24	11	3\n35	24	12	6	12\n35	24	12	1	4\n35	24	15	15\n35	24	15	1\n35	25	6	6	9\n35	25	6	79	1\n35	25	7	7\n35	25	7	2\n35	25	8	8\n35	25	8	6\n35	25	9	6	9\n35	25	9	1	25\n35	25	10	10	12\n35	25	10	12	1\n35	25	11	10	11\n35	25	11	1	2\n35	25	12	12\n35	25	12	4\n35	25	15	15\n35	25	15	1\n35	26	6	6	9\n35	26	6	78	2\n35	26	7	7\n35	26	7	2\n35	26	8	8\n35	26	8	6\n35	26	9	6	9\n35	26	9	1	25\n35	26	10	10\n35	26	10	13\n35	26	11	10	11\n35	26	11	1	1\n35	26	12	12\n35	26	12	5\n35	26	15	6\n35	26	15	1\n35	27	6	6	9\n35	27	6	79	1\n35	27	7	7\n35	27	7	2\n35	27	8	8\n35	27	8	6\n35	27	9	9\n35	27	9	27\n35	27	10	10\n35	27	10	14\n35	27	11	11\n35	27	11	1\n35	27	12	12\n35	27	12	5\n35	28	6	6\n35	28	6	79\n35	28	7	7\n35	28	7	2\n35	28	8	8\n35	28	8	6\n35	28	9	9\n35	28	9	28\n35	28	10	10	12\n35	28	10	13	1\n35	28	11	11\n35	28	11	1\n35	28	12	12\n35	28	12	5\n35	29	6	6\n35	29	6	79\n35	29	7	7\n35	29	7	2\n35	29	8	8\n35	29	8	6\n35	29	9	9\n35	29	9	28\n35	29	10	10\n35	29	10	13\n35	29	11	11\n35	29	11	1\n35	29	12	12\n35	29	12	6\n35	30	6	6\n35	30	6	79\n35	30	7	7	9\n35	30	7	1	1\n35	30	8	8\n35	30	8	6\n35	30	9	9\n35	30	9	28\n35	30	10	10\n35	30	10	13\n35	30	11	11\n35	30	11	1\n35	30	12	12\n35	30	12	6\n35	31	6	6\n35	31	6	79\n35	31	7	7\n35	31	7	1\n35	31	8	8\n35	31	8	6\n35	31	9	9\n35	31	9	29\n35	31	10	10\n35	31	10	13\n35	31	11	11\n35	31	11	1\n35	31	12	12\n35	31	12	6\n35	32	6	6\n35	32	6	79\n35	32	7	7\n35	32	7	1\n35	32	8	8\n35	32	8	6\n35	32	9	9\n35	32	9	29\n35	32	10	10\n35	32	10	13\n35	32	11	11\n35	32	11	1\n35	32	12	12\n35	32	12	6\n35	33	6	6\n35	33	6	79\n35	33	7	7\n35	33	7	1\n35	33	8	8\n35	33	8	6\n35	33	9	6	8	9\n35	33	9	11	1	17\n35	33	10	10\n35	33	10	13\n35	33	11	11\n35	33	11	1\n35	33	12	10	12\n35	33	12	1	5\n35	34	6	6\n35	34	6	90\n35	34	7	7\n35	34	7	1\n35	34	8	8\n35	34	8	7\n35	34	9	6	8	9\n35	34	9	4	2	11\n35	34	10	10\n35	34	10	14\n35	34	11	11\n35	34	11	1\n35	34	12	10	12\n35	34	12	1	4\n36	1	6	6\n36	1	6	2\n36	1	7	7\n36	1	7	2\n36	1	8	8\n36	1	8	3\n36	1	9	9\n36	1	9	8\n36	1	11	11\n36	1	11	19\n36	1	12	12\n36	1	12	6\n36	1	13	13\n36	1	13	31\n36	1	14	14\n36	1	14	13\n36	1	15	13	15\n36	1	15	1	21\n36	1	16	15	16	20\n36	1	16	1	3	1\n36	2	6	6\n36	2	6	2\n36	2	7	7\n36	2	7	2\n36	2	8	8\n36	2	8	3\n36	2	9	9\n36	2	9	8\n36	2	11	11	14\n36	2	11	18	1\n36	2	12	12\n36	2	12	6\n36	2	13	13\n36	2	13	32\n36	2	14	14\n36	2	14	13\n36	2	15	15\n36	2	15	22\n36	2	16	16	20\n36	2	16	2	1\n36	2	20	20\n36	2	20	1\n36	3	6	6\n36	3	6	2\n36	3	7	7\n36	3	7	2\n36	3	8	8\n36	3	8	3\n36	3	9	9\n36	3	9	8\n36	3	11	10	11\n36	3	11	1	17\n36	3	12	12\n36	3	12	6\n36	3	13	13\n36	3	13	32\n36	3	14	14\n36	3	14	14\n36	3	15	15\n36	3	15	22\n36	3	16	16\n36	3	16	2\n36	3	20	20\n36	3	20	2\n36	4	6	6\n36	4	6	2\n36	4	7	7\n36	4	7	2\n36	4	8	8\n36	4	8	3\n36	4	9	9\n36	4	9	8\n36	4	10	10\n36	4	10	1\n36	4	11	11\n36	4	11	17\n36	4	12	12\n36	4	12	6\n36	4	13	13\n36	4	13	32\n36	4	14	14\n36	4	14	14\n36	4	15	15\n36	4	15	22\n36	4	16	16\n36	4	16	2\n36	4	20	20\n36	4	20	2\n36	5	6	6\n36	5	6	2\n36	5	7	7\n36	5	7	2\n36	5	8	8\n36	5	8	3\n36	5	9	9\n36	5	9	8\n36	5	10	10\n36	5	10	1\n36	5	11	11\n36	5	11	17\n36	5	12	12\n36	5	12	6\n36	5	13	13\n36	5	13	32\n36	5	14	14\n36	5	14	14\n36	5	15	15\n36	5	15	22\n36	5	16	16\n36	5	16	2\n36	5	20	20\n36	5	20	2\n36	6	6	6\n36	6	6	2\n36	6	7	7\n36	6	7	2\n36	6	8	8\n36	6	8	3\n36	6	9	9\n36	6	9	8\n36	6	10	10\n36	6	10	1\n36	6	11	11\n36	6	11	17\n36	6	12	12\n36	6	12	6\n36	6	13	13\n36	6	13	32\n36	6	14	14\n36	6	14	14\n36	6	15	15\n36	6	15	22\n36	6	16	16\n36	6	16	2\n36	6	20	20\n36	6	20	2\n36	7	6	6\n36	7	6	2\n36	7	7	7\n36	7	7	2\n36	7	8	8\n36	7	8	3\n36	7	9	9\n36	7	9	8\n36	7	10	10\n36	7	10	1\n36	7	11	11\n36	7	11	17\n36	7	12	12	15\n36	7	12	5	1\n36	7	13	13\n36	7	13	32\n36	7	14	14\n36	7	14	14\n36	7	15	15\n36	7	15	22\n36	7	16	16\n36	7	16	2\n36	7	20	20\n36	7	20	2\n36	8	6	6\n36	8	6	2\n36	8	7	7\n36	8	7	2\n36	8	8	8\n36	8	8	3\n36	8	9	9\n36	8	9	8\n36	8	10	10\n36	8	10	1\n36	8	11	11\n36	8	11	17\n36	8	12	12\n36	8	12	5\n36	8	13	13\n36	8	13	32\n36	8	14	14\n36	8	14	14\n36	8	15	15\n36	8	15	23\n36	8	16	16\n36	8	16	2\n36	8	20	20\n36	8	20	2\n36	9	6	6\n36	9	6	2\n36	9	7	7\n36	9	7	2\n36	9	8	8\n36	9	8	3\n36	9	9	9\n36	9	9	8\n36	9	10	10\n36	9	10	1\n36	9	11	11\n36	9	11	17\n36	9	12	12\n36	9	12	5\n36	9	13	13\n36	9	13	32\n36	9	14	14\n36	9	14	14\n36	9	15	15\n36	9	15	23\n36	9	16	16\n36	9	16	2\n36	9	20	20\n36	9	20	2\n36	10	6	6\n36	10	6	2\n36	10	7	7\n36	10	7	2\n36	10	8	8\n36	10	8	3\n36	10	9	9\n36	10	9	8\n36	10	10	10\n36	10	10	1\n36	10	11	11\n36	10	11	17\n36	10	12	12\n36	10	12	5\n36	10	13	6	10	13\n36	10	13	1	1	30\n36	10	14	6	14\n36	10	14	3	11\n36	10	15	15\n36	10	15	23\n36	10	16	16\n36	10	16	2\n36	10	20	20\n36	10	20	2\n36	11	6	6\n36	11	6	6\n36	11	7	7\n36	11	7	2\n36	11	8	8\n36	11	8	3\n36	11	9	9\n36	11	9	8\n36	11	10	10\n36	11	10	2\n36	11	11	11\n36	11	11	17\n36	11	12	12\n36	11	12	5\n36	11	13	13	15\n36	11	13	29	1\n36	11	14	14\n36	11	14	11\n36	11	15	15\n36	11	15	23\n36	11	16	16\n36	11	16	2\n36	11	20	20\n36	11	20	2\n36	12	6	6\n36	12	6	6\n36	12	7	7\n36	12	7	2\n36	12	8	8\n36	12	8	3\n36	12	9	9\n36	12	9	8\n36	12	10	10\n36	12	10	2\n36	12	11	6	11\n36	12	11	2	15\n36	12	12	12\n36	12	12	5\n36	12	13	6	13\n36	12	13	1	28\n36	12	14	14\n36	12	14	11\n36	12	15	9	15\n36	12	15	1	23\n36	12	16	16\n36	12	16	2\n36	12	20	14	20\n36	12	20	1	1\n36	13	6	6\n36	13	6	9\n36	13	7	7\n36	13	7	2\n36	13	8	8\n36	13	8	3\n36	13	9	9\n36	13	9	9\n36	13	10	6	10\n36	13	10	1	1\n36	13	11	6	11\n36	13	11	3	12\n36	13	12	10	12\n36	13	12	1	4\n36	13	13	13\n36	13	13	28\n36	13	14	14\n36	13	14	12\n36	13	15	6	15\n36	13	15	1	22\n36	13	16	16\n36	13	16	2\n36	13	20	20\n36	13	20	1\n36	14	6	6\n36	14	6	14\n36	14	7	7\n36	14	7	2\n36	14	8	8\n36	14	8	3\n36	14	9	9\n36	14	9	9\n36	14	10	10\n36	14	10	2\n36	14	11	11\n36	14	11	12\n36	14	12	12\n36	14	12	4\n36	14	13	6	9	13\n36	14	13	4	1	23\n36	14	14	8	11	14\n36	14	14	1	1	10\n36	14	15	6	12	15\n36	14	15	1	1	20\n36	14	16	16\n36	14	16	2\n36	14	20	20\n36	14	20	1\n36	15	6	6\n36	15	6	19\n36	15	7	7\n36	15	7	2\n36	15	8	8\n36	15	8	4\n36	15	9	9\n36	15	9	10\n36	15	10	10\n36	15	10	2\n36	15	11	11\n36	15	11	13\n36	15	12	12\n36	15	12	5\n36	15	13	6	9	13\n36	15	13	1	1	21\n36	15	14	14\n36	15	14	10\n36	15	15	15\n36	15	15	20\n36	15	16	16\n36	15	16	2\n36	15	20	20\n36	15	20	1\n36	16	6	6	9\n36	16	6	19	1\n36	16	7	7\n36	16	7	2\n36	16	8	8\n36	16	8	4\n36	16	9	9\n36	16	9	11\n36	16	10	10\n36	16	10	2\n36	16	11	11\n36	16	11	13\n36	16	12	12\n36	16	12	5\n36	16	13	13\n36	16	13	21\n36	16	14	14\n36	16	14	10\n36	16	15	15\n36	16	15	20\n36	16	16	16\n36	16	16	2\n36	16	20	20\n36	16	20	1\n36	17	6	6\n36	17	6	19\n36	17	7	7\n36	17	7	2\n36	17	8	8\n36	17	8	4\n36	17	9	9\n36	17	9	12\n36	17	10	10\n36	17	10	2\n36	17	11	10	11\n36	17	11	1	12\n36	17	12	12\n36	17	12	5\n36	17	13	13\n36	17	13	21\n36	17	14	14\n36	17	14	10\n36	17	15	15\n36	17	15	20\n36	17	16	16\n36	17	16	2\n36	17	20	20\n36	17	20	1\n36	18	6	6\n36	18	6	19\n36	18	7	7\n36	18	7	2\n36	18	8	8\n36	18	8	4\n36	18	9	9\n36	18	9	12\n36	18	10	10\n36	18	10	3\n36	18	11	6	11\n36	18	11	2	10\n36	18	12	11	12\n36	18	12	1	4\n36	18	13	6	13\n36	18	13	1	20\n36	18	14	14\n36	18	14	10\n36	18	15	6	9	15\n36	18	15	1	2	17\n36	18	16	16\n36	18	16	2\n36	18	20	20\n36	18	20	1\n36	19	6	6	9\n36	19	6	22	1\n36	19	7	7	9\n36	19	7	1	1\n36	19	8	6	8\n36	19	8	1	3\n36	19	9	6	9\n36	19	9	1	13\n36	19	10	10\n36	19	10	3\n36	19	11	11\n36	19	11	11\n36	19	12	12\n36	19	12	4\n36	19	13	6	9	13\n36	19	13	1	1	18\n36	19	14	14	16\n36	19	14	9	1\n36	19	15	6	9	13	15\n36	19	15	1	3	1	12\n36	19	16	16\n36	19	16	2\n36	19	20	20\n36	19	20	1\n36	20	6	6\n36	20	6	26\n36	20	7	7\n36	20	7	1\n36	20	8	8\n36	20	8	3\n36	20	9	9\n36	20	9	19\n36	20	10	10\n36	20	10	3\n36	20	11	6	10	11	12\n36	20	11	2	2	6	1\n36	20	12	6	9	11	12\n36	20	12	1	1	1	1\n36	20	13	6	9	13\n36	20	13	3	2	14\n36	20	14	6	14\n36	20	14	2	7\n36	20	15	6	15\n36	20	15	2	10\n36	20	16	16\n36	20	16	3\n36	20	20	16\n36	20	20	1\n36	21	6	6	9\n36	21	6	35	1\n36	21	7	6\n36	21	7	1\n36	21	8	8\n36	21	8	3\n36	21	9	6	8	9\n36	21	9	1	2	19\n36	21	10	10\n36	21	10	5\n36	21	11	11	12\n36	21	11	6	1\n36	21	12	12\n36	21	12	2\n36	21	13	6	9	13\n36	21	13	9	1	4\n36	21	14	6	8	11	14\n36	21	14	1	2	1	3\n36	21	15	9	15\n36	21	15	5	5\n36	21	16	11	16\n36	21	16	3	1\n36	22	6	6\n36	22	6	47\n36	22	8	6	8\n36	22	8	1	6\n36	22	9	6	9\n36	22	9	1	25\n36	22	10	10\n36	22	10	5\n36	22	11	8	11\n36	22	11	1	9\n36	22	12	12\n36	22	12	3\n36	22	13	6	13\n36	22	13	1	3\n36	22	14	8	14\n36	22	14	2	1\n36	22	15	10	15\n36	22	15	1	4\n36	22	16	8\n36	22	16	1\n36	23	6	6	9\n36	23	6	48	2\n36	23	8	6	8\n36	23	8	1	9\n36	23	9	8	9\n36	23	9	1	24\n36	23	10	10\n36	23	10	6\n36	23	11	6	10	11\n36	23	11	1	3	5\n36	23	12	12\n36	23	12	3\n36	23	13	13\n36	23	13	3\n36	23	14	14\n36	23	14	1\n36	23	15	6	9	15\n36	23	15	2	1	1\n36	24	6	6\n36	24	6	52\n36	24	8	8	9\n36	24	8	9	1\n36	24	9	6	9\n36	24	9	1	26\n36	24	10	10	12\n36	24	10	8	1\n36	24	11	11\n36	24	11	5\n36	24	12	12\n36	24	12	3\n36	24	13	6	13\n36	24	13	2	1\n36	24	14	14\n36	24	14	1\n36	24	15	6\n36	24	15	1\n36	25	6	6\n36	25	6	56\n36	25	8	8\n36	25	8	9\n36	25	9	6	9\n36	25	9	1	26\n36	25	10	10\n36	25	10	8\n36	25	11	11	12\n36	25	11	4	1\n36	25	12	12\n36	25	12	4\n36	25	13	13\n36	25	13	1\n36	25	14	9\n36	25	14	1\n36	26	6	6\n36	26	6	57\n36	26	8	8\n36	26	8	9\n36	26	9	6	9\n36	26	9	1	26\n36	26	10	10\n36	26	10	8\n36	26	11	11\n36	26	11	4\n36	26	12	12\n36	26	12	5\n36	26	13	6\n36	26	13	1\n36	27	6	6\n36	27	6	59\n36	27	8	8\n36	27	8	9\n36	27	9	9\n36	27	9	26\n36	27	10	10\n36	27	10	8\n36	27	11	11\n36	27	11	4\n36	27	12	12\n36	27	12	5\n36	28	6	6	9\n36	28	6	57	2\n36	28	8	8\n36	28	8	9\n36	28	9	6	9\n36	28	9	1	25\n36	28	10	10\n36	28	10	8\n36	28	11	11\n36	28	11	4\n36	28	12	12\n36	28	12	5\n36	29	6	6\n36	29	6	58\n36	29	8	8\n36	29	8	9\n36	29	9	9\n36	29	9	27\n36	29	10	10\n36	29	10	8\n36	29	11	11\n36	29	11	4\n36	29	12	12\n36	29	12	5\n36	30	6	6\n36	30	6	58\n36	30	8	8\n36	30	8	9\n36	30	9	9\n36	30	9	27\n36	30	10	10\n36	30	10	8\n36	30	11	11\n36	30	11	4\n36	30	12	12\n36	30	12	5\n36	31	6	6\n36	31	6	58\n36	31	8	8\n36	31	8	9\n36	31	9	9\n36	31	9	27\n36	31	10	10\n36	31	10	8\n36	31	11	11\n36	31	11	4\n36	31	12	12\n36	31	12	5\n36	32	6	6\n36	32	6	58\n36	32	8	8\n36	32	8	9\n36	32	9	9\n36	32	9	27\n36	32	10	10\n36	32	10	8\n36	32	11	11\n36	32	11	4\n36	32	12	12\n36	32	12	5\n36	33	6	6\n36	33	6	58\n36	33	8	8\n36	33	8	9\n36	33	9	9\n36	33	9	27\n36	33	10	10\n36	33	10	8\n36	33	11	11\n36	33	11	4\n36	33	12	12\n36	33	12	5\n36	34	6	6\n36	34	6	58\n36	34	8	8\n36	34	8	9\n36	34	9	6	9\n36	34	9	6	21\n36	34	10	10\n36	34	10	8\n36	34	11	11\n36	34	11	4\n36	34	12	12\n36	34	12	5\n36	35	6	6\n36	35	6	64\n36	35	8	8\n36	35	8	9\n36	35	9	6	9\n36	35	9	8	13\n36	35	10	10\n36	35	10	8\n36	35	11	11\n36	35	11	4\n36	35	12	10	12\n36	35	12	1	4\n37	1	6	6	9\n37	1	6	2	1\n37	1	7	7\n37	1	7	1\n37	1	8	8\n37	1	8	2\n37	1	9	9\n37	1	9	7\n37	1	10	10\n37	1	10	2\n37	1	11	11\n37	1	11	11\n37	1	12	12\n37	1	12	8\n37	1	13	13	15\n37	1	13	21	1\n37	1	14	14\n37	1	14	3\n37	1	15	13	15\n37	1	15	1	19\n37	1	16	16\n37	1	16	4\n37	2	6	6\n37	2	6	2\n37	2	7	7\n37	2	7	1\n37	2	8	8\n37	2	8	2\n37	2	9	9\n37	2	9	8\n37	2	10	10\n37	2	10	2\n37	2	11	11\n37	2	11	11\n37	2	12	11	12\n37	2	12	1	7\n37	2	13	13\n37	2	13	22\n37	2	14	14\n37	2	14	3\n37	2	15	13	15\n37	2	15	1	19\n37	2	16	16	20\n37	2	16	2	2\n37	3	6	6\n37	3	6	2\n37	3	7	7\n37	3	7	1\n37	3	8	8\n37	3	8	2\n37	3	9	9	10\n37	3	9	7	1\n37	3	10	10\n37	3	10	2\n37	3	11	11\n37	3	11	12\n37	3	12	10	12\n37	3	12	1	6\n37	3	13	13\n37	3	13	23\n37	3	14	14\n37	3	14	3\n37	3	15	15\n37	3	15	19\n37	3	16	16\n37	3	16	2\n37	3	20	20\n37	3	20	2\n37	4	6	6\n37	4	6	2\n37	4	7	7\n37	4	7	1\n37	4	8	8\n37	4	8	2\n37	4	9	9\n37	4	9	7\n37	4	10	10\n37	4	10	4\n37	4	11	11\n37	4	11	12\n37	4	12	12\n37	4	12	6\n37	4	13	13\n37	4	13	23\n37	4	14	14\n37	4	14	3\n37	4	15	13	15\n37	4	15	2	17\n37	4	16	16\n37	4	16	2\n37	4	20	20\n37	4	20	2\n37	5	6	6\n37	5	6	2\n37	5	7	7\n37	5	7	1\n37	5	8	8\n37	5	8	2\n37	5	9	9\n37	5	9	7\n37	5	10	10\n37	5	10	4\n37	5	11	11\n37	5	11	12\n37	5	12	12\n37	5	12	6\n37	5	13	13\n37	5	13	25\n37	5	14	14\n37	5	14	3\n37	5	15	15\n37	5	15	17\n37	5	16	16\n37	5	16	2\n37	5	20	20\n37	5	20	2\n37	6	6	6\n37	6	6	2\n37	6	7	7\n37	6	7	1\n37	6	8	8\n37	6	8	2\n37	6	9	9\n37	6	9	7\n37	6	10	10\n37	6	10	4\n37	6	11	11\n37	6	11	12\n37	6	12	12\n37	6	12	6\n37	6	13	13	15\n37	6	13	24	1\n37	6	14	14\n37	6	14	3\n37	6	15	15\n37	6	15	17\n37	6	16	15	16\n37	6	16	1	1\n37	6	20	20\n37	6	20	2\n37	7	6	6\n37	7	6	2\n37	7	7	7\n37	7	7	1\n37	7	8	8\n37	7	8	2\n37	7	9	9\n37	7	9	7\n37	7	10	10\n37	7	10	4\n37	7	11	11\n37	7	11	12\n37	7	12	12\n37	7	12	6\n37	7	13	13\n37	7	13	24\n37	7	14	14\n37	7	14	3\n37	7	15	15\n37	7	15	19\n37	7	16	16\n37	7	16	1\n37	7	20	20\n37	7	20	2\n37	8	6	6\n37	8	6	2\n37	8	7	7\n37	8	7	1\n37	8	8	8\n37	8	8	2\n37	8	9	9\n37	8	9	7\n37	8	10	10\n37	8	10	4\n37	8	11	11\n37	8	11	12\n37	8	12	12\n37	8	12	6\n37	8	13	13\n37	8	13	24\n37	8	14	14\n37	8	14	3\n37	8	15	15\n37	8	15	19\n37	8	16	16\n37	8	16	1\n37	8	20	20\n37	8	20	2\n37	9	6	6\n37	9	6	2\n37	9	7	6\n37	9	7	1\n37	9	8	8\n37	9	8	2\n37	9	9	6	9\n37	9	9	1	6\n37	9	10	9	10\n37	9	10	1	3\n37	9	11	11\n37	9	11	12\n37	9	12	12\n37	9	12	6\n37	9	13	9	13	15\n37	9	13	1	22	1\n37	9	14	14\n37	9	14	3\n37	9	15	9	15\n37	9	15	2	17\n37	9	16	16\n37	9	16	1\n37	9	20	20\n37	9	20	2\n37	10	6	6\n37	10	6	4\n37	10	8	8\n37	10	8	2\n37	10	9	6	9\n37	10	9	1	9\n37	10	10	10\n37	10	10	3\n37	10	11	11\n37	10	11	12\n37	10	12	12\n37	10	12	6\n37	10	13	6	13\n37	10	13	2	20\n37	10	14	14\n37	10	14	3\n37	10	15	15\n37	10	15	18\n37	10	16	16\n37	10	16	1\n37	10	20	20\n37	10	20	2\n37	11	6	6\n37	11	6	7\n37	11	8	8\n37	11	8	2\n37	11	9	9\n37	11	9	9\n37	11	10	10\n37	11	10	3\n37	11	11	11\n37	11	11	12\n37	11	12	12\n37	11	12	6\n37	11	13	6	13\n37	11	13	1	19\n37	11	14	14\n37	11	14	3\n37	11	15	6	15\n37	11	15	1	17\n37	11	16	16\n37	11	16	1\n37	11	20	20\n37	11	20	2\n37	12	6	6\n37	12	6	9\n37	12	8	8\n37	12	8	2\n37	12	9	9\n37	12	9	9\n37	12	10	10\n37	12	10	3\n37	12	11	11\n37	12	11	12\n37	12	12	12\n37	12	12	6\n37	12	13	6	13\n37	12	13	1	18\n37	12	14	14\n37	12	14	3\n37	12	15	6	9	15\n37	12	15	1	1	15\n37	12	16	16\n37	12	16	1\n37	12	20	20\n37	12	20	2\n37	13	6	6\n37	13	6	11\n37	13	8	8\n37	13	8	2\n37	13	9	9\n37	13	9	10\n37	13	10	6	10\n37	13	10	1	2\n37	13	11	11\n37	13	11	12\n37	13	12	12\n37	13	12	6\n37	13	13	6	9	13\n37	13	13	2	1	15\n37	13	14	14\n37	13	14	3\n37	13	15	6	9	15\n37	13	15	1	1	13\n37	13	16	16\n37	13	16	1\n37	13	20	20\n37	13	20	2\n37	14	6	6\n37	14	6	15\n37	14	8	8\n37	14	8	2\n37	14	9	9\n37	14	9	12\n37	14	10	10\n37	14	10	2\n37	14	11	11\n37	14	11	12\n37	14	12	12\n37	14	12	6\n37	14	13	13\n37	14	13	15\n37	14	14	14\n37	14	14	3\n37	14	15	6	9	15\n37	14	15	1	1	11\n37	14	16	16\n37	14	16	1\n37	14	20	20\n37	14	20	2\n37	15	6	6	9\n37	15	6	15	1\n37	15	8	8\n37	15	8	2\n37	15	9	6	9\n37	15	9	1	12\n37	15	10	10\n37	15	10	2\n37	15	11	11\n37	15	11	12\n37	15	12	10	12\n37	15	12	1	5\n37	15	13	13\n37	15	13	15\n37	15	14	14\n37	15	14	3\n37	15	15	15\n37	15	15	11\n37	15	16	16\n37	15	16	1\n37	15	20	20\n37	15	20	2\n37	16	6	6	9\n37	16	6	15	1\n37	16	8	8\n37	16	8	2\n37	16	9	6	9\n37	16	9	1	12\n37	16	10	10\n37	16	10	3\n37	16	11	11\n37	16	11	12\n37	16	12	12\n37	16	12	5\n37	16	13	13\n37	16	13	15\n37	16	14	14\n37	16	14	3\n37	16	15	9	15\n37	16	15	1	10\n37	16	16	16\n37	16	16	1\n37	16	20	20\n37	16	20	2\n37	17	6	6\n37	17	6	16\n37	17	8	8\n37	17	8	2\n37	17	9	6	9\n37	17	9	1	13\n37	17	10	10\n37	17	10	3\n37	17	11	11\n37	17	11	12\n37	17	12	12\n37	17	12	5\n37	17	13	13\n37	17	13	15\n37	17	14	14\n37	17	14	3\n37	17	15	15\n37	17	15	10\n37	17	16	16\n37	17	16	1\n37	17	20	20\n37	17	20	2\n37	18	6	6\n37	18	6	17\n37	18	8	8\n37	18	8	2\n37	18	9	6	9\n37	18	9	1	12\n37	18	10	10\n37	18	10	3\n37	18	11	11\n37	18	11	12\n37	18	12	12\n37	18	12	5\n37	18	13	13\n37	18	13	15\n37	18	14	14\n37	18	14	3\n37	18	15	15\n37	18	15	10\n37	18	16	16\n37	18	16	1\n37	18	20	20\n37	18	20	2\n37	19	6	6	9\n37	19	6	17	1\n37	19	8	6	8\n37	19	8	1	1\n37	19	9	6	9\n37	19	9	2	10\n37	19	10	10\n37	19	10	3\n37	19	11	6	11\n37	19	11	1	11\n37	19	12	12\n37	19	12	5\n37	19	13	9	13\n37	19	13	1	14\n37	19	14	14\n37	19	14	3\n37	19	15	15\n37	19	15	10\n37	19	16	16\n37	19	16	1\n37	19	20	16	20\n37	19	20	1	1\n37	20	6	6	9\n37	20	6	20	1\n37	20	8	8\n37	20	8	1\n37	20	9	9\n37	20	9	12\n37	20	10	10\n37	20	10	3\n37	20	11	6	11	12\n37	20	11	1	9	1\n37	20	12	12\n37	20	12	5\n37	20	13	6	9	13\n37	20	13	4	3	7\n37	20	14	6	14\n37	20	14	1	2\n37	20	15	6	15\n37	20	15	2	8\n37	20	16	16\n37	20	16	2\n37	20	20	16\n37	20	20	1\n37	21	6	6	9\n37	21	6	27	1\n37	21	8	8\n37	21	8	1\n37	21	9	9\n37	21	9	16\n37	21	10	10\n37	21	10	3\n37	21	11	6	10	11\n37	21	11	1	1	7\n37	21	12	12\n37	21	12	6\n37	21	13	13\n37	21	13	7\n37	21	14	14\n37	21	14	2\n37	21	15	6	9	15\n37	21	15	2	1	5\n37	21	16	8	16\n37	21	16	1	2\n37	22	6	6	9\n37	22	6	29	1\n37	22	8	8\n37	22	8	2\n37	22	9	8	9\n37	22	9	1	17\n37	22	10	10\n37	22	10	4\n37	22	11	6	11	12\n37	22	11	1	4	2\n37	22	12	10	12\n37	22	12	1	5\n37	22	13	6	13\n37	22	13	2	5\n37	22	14	8	16\n37	22	14	1	1\n37	22	15	6	9	15\n37	22	15	1	1	3\n37	22	16	10\n37	22	16	2\n37	23	6	6	9\n37	23	6	32	1\n37	23	8	8\n37	23	8	4\n37	23	9	6	9\n37	23	9	3	16\n37	23	10	10\n37	23	10	7\n37	23	11	6	10	11\n37	23	11	1	2	1\n37	23	12	12\n37	23	12	7\n37	23	13	6	13\n37	23	13	4	1\n37	23	15	6	9	15\n37	23	15	1	1	1\n37	23	16	10\n37	23	16	1\n37	24	6	6	9\n37	24	6	40	1\n37	24	8	8	9\n37	24	8	3	1\n37	24	9	6	9\n37	24	9	1	17\n37	24	10	9	10\n37	24	10	1	9\n37	24	11	6\n37	24	11	1\n37	24	12	6	12\n37	24	12	1	6\n37	24	13	6\n37	24	13	1\n37	24	15	13\n37	24	15	1\n37	25	6	6	9\n37	25	6	42	2\n37	25	8	8\n37	25	8	3\n37	25	9	9\n37	25	9	20\n37	25	10	10\n37	25	10	9\n37	25	12	12\n37	25	12	6\n37	25	13	13\n37	25	13	1\n37	26	6	6	9\n37	26	6	41	1\n37	26	8	8\n37	26	8	3\n37	26	9	6	9\n37	26	9	2	20\n37	26	10	10\n37	26	10	9\n37	26	12	12\n37	26	12	6\n37	26	13	6\n37	26	13	1\n37	27	6	6	9\n37	27	6	43	1\n37	27	8	8\n37	27	8	3\n37	27	9	9\n37	27	9	21\n37	27	10	10	12\n37	27	10	8	1\n37	27	12	12\n37	27	12	6\n37	28	6	6\n37	28	6	43\n37	28	8	8\n37	28	8	3\n37	28	9	6	9\n37	28	9	1	21\n37	28	10	10\n37	28	10	8\n37	28	12	12\n37	28	12	7\n37	29	6	6\n37	29	6	44\n37	29	8	8\n37	29	8	3\n37	29	9	6	9\n37	29	9	3	18\n37	29	10	10\n37	29	10	8\n37	29	12	12\n37	29	12	7\n37	30	6	6	9\n37	30	6	46	1\n37	30	8	8\n37	30	8	3\n37	30	9	9\n37	30	9	18\n37	30	10	10\n37	30	10	8\n37	30	12	12\n37	30	12	7\n37	31	6	6\n37	31	6	46\n37	31	8	8\n37	31	8	3\n37	31	9	8	9\n37	31	9	1	18\n37	31	10	10\n37	31	10	8\n37	31	12	12\n37	31	12	7\n37	32	6	6	9\n37	32	6	45	1\n37	32	8	8\n37	32	8	4\n37	32	9	9\n37	32	9	18\n37	32	10	10\n37	32	10	8\n37	32	12	12\n37	32	12	7\n37	33	6	6\n37	33	6	45\n37	33	8	8\n37	33	8	4\n37	33	9	9\n37	33	9	19\n37	33	10	8	10\n37	33	10	1	7\n37	33	12	12\n37	33	12	7\n37	34	6	6\n37	34	6	45\n37	34	8	8\n37	34	8	5\n37	34	9	9\n37	34	9	19\n37	34	10	10\n37	34	10	7\n37	34	12	12\n37	34	12	7\n37	35	6	6\n37	35	6	45\n37	35	8	8\n37	35	8	5\n37	35	9	6	9\n37	35	9	6	13\n37	35	10	10\n37	35	10	7\n37	35	12	12\n37	35	12	7\n37	36	6	6\n37	36	6	51\n37	36	8	8\n37	36	8	5\n37	36	9	6	9\n37	36	9	8	5\n37	36	10	10\n37	36	10	7\n37	36	12	12\n37	36	12	7\n38	1	6	6\n38	1	6	1\n38	1	8	8\n38	1	8	2\n38	1	9	9\n38	1	9	4\n38	1	10	10\n38	1	10	2\n38	1	11	11	13\n38	1	11	3	1\n38	1	12	11	12\n38	1	12	1	7\n38	1	13	13\n38	1	13	22\n38	1	14	14\n38	1	14	3\n38	1	15	13	15\n38	1	15	1	10\n38	2	6	6\n38	2	6	1\n38	2	8	8\n38	2	8	2\n38	2	9	9\n38	2	9	4\n38	2	10	10\n38	2	10	2\n38	2	11	11\n38	2	11	4\n38	2	12	12\n38	2	12	7\n38	2	13	13\n38	2	13	24\n38	2	14	14\n38	2	14	3\n38	2	15	13	15\n38	2	15	1	9\n38	3	6	6\n38	3	6	1\n38	3	8	8\n38	3	8	2\n38	3	9	9\n38	3	9	4\n38	3	10	10\n38	3	10	2\n38	3	11	11\n38	3	11	4\n38	3	12	12\n38	3	12	7\n38	3	13	13	14	15\n38	3	13	23	1	1\n38	3	14	14\n38	3	14	3\n38	3	15	15\n38	3	15	9\n38	4	6	6\n38	4	6	1\n38	4	8	8\n38	4	8	2\n38	4	9	9\n38	4	9	4\n38	4	10	10\n38	4	10	2\n38	4	11	11\n38	4	11	4\n38	4	12	12\n38	4	12	7\n38	4	13	13\n38	4	13	23\n38	4	14	14\n38	4	14	4\n38	4	15	15\n38	4	15	10\n38	5	6	6\n38	5	6	1\n38	5	8	8\n38	5	8	2\n38	5	9	9\n38	5	9	4\n38	5	10	10\n38	5	10	2\n38	5	11	11\n38	5	11	4\n38	5	12	12\n38	5	12	7\n38	5	13	13\n38	5	13	23\n38	5	14	13	14\n38	5	14	1	3\n38	5	15	15\n38	5	15	10\n38	6	6	6\n38	6	6	1\n38	6	8	8\n38	6	8	2\n38	6	9	9\n38	6	9	4\n38	6	10	10\n38	6	10	2\n38	6	11	11\n38	6	11	4\n38	6	12	12\n38	6	12	7\n38	6	13	13\n38	6	13	24\n38	6	14	14\n38	6	14	3\n38	6	15	15\n38	6	15	10\n38	7	6	6\n38	7	6	1\n38	7	8	8\n38	7	8	2\n38	7	9	9\n38	7	9	4\n38	7	10	10\n38	7	10	2\n38	7	11	11\n38	7	11	4\n38	7	12	12\n38	7	12	7\n38	7	13	13\n38	7	13	24\n38	7	14	14\n38	7	14	3\n38	7	15	13	15\n38	7	15	1	9\n38	8	6	6\n38	8	6	1\n38	8	8	8\n38	8	8	2\n38	8	9	9\n38	8	9	4\n38	8	10	9	10\n38	8	10	1	1\n38	8	11	11\n38	8	11	4\n38	8	12	12\n38	8	12	7\n38	8	13	11	13\n38	8	13	1	24\n38	8	14	14\n38	8	14	3\n38	8	15	15\n38	8	15	9\n38	9	6	6\n38	9	6	1\n38	9	8	8\n38	9	8	2\n38	9	9	9\n38	9	9	5\n38	9	10	10\n38	9	10	1\n38	9	11	11\n38	9	11	5\n38	9	12	10	12\n38	9	12	1	6\n38	9	13	13\n38	9	13	24\n38	9	14	14\n38	9	14	3\n38	9	15	15\n38	9	15	9\n38	10	6	6\n38	10	6	1\n38	10	8	8\n38	10	8	2\n38	10	9	9\n38	10	9	5\n38	10	10	10\n38	10	10	2\n38	10	11	11\n38	10	11	5\n38	10	12	12\n38	10	12	6\n38	10	13	13\n38	10	13	24\n38	10	14	14\n38	10	14	3\n38	10	15	15\n38	10	15	9\n38	11	6	6\n38	11	6	1\n38	11	8	8\n38	11	8	2\n38	11	9	9\n38	11	9	5\n38	11	10	10\n38	11	10	2\n38	11	11	11\n38	11	11	5\n38	11	12	12\n38	11	12	6\n38	11	13	13\n38	11	13	24\n38	11	14	14\n38	11	14	3\n38	11	15	15\n38	11	15	9\n38	12	6	6\n38	12	6	1\n38	12	8	8\n38	12	8	2\n38	12	9	9\n38	12	9	5\n38	12	10	10\n38	12	10	2\n38	12	11	11\n38	12	11	5\n38	12	12	12\n38	12	12	6\n38	12	13	6	13\n38	12	13	1	23\n38	12	14	14\n38	12	14	3\n38	12	15	15\n38	12	15	9\n38	13	6	6\n38	13	6	2\n38	13	8	8\n38	13	8	2\n38	13	9	9\n38	13	9	5\n38	13	10	10\n38	13	10	2\n38	13	11	6	11\n38	13	11	1	4\n38	13	12	12\n38	13	12	6\n38	13	13	6	9	13\n38	13	13	1	1	21\n38	13	14	14\n38	13	14	3\n38	13	15	6	15\n38	13	15	1	8\n38	14	6	6\n38	14	6	5\n38	14	8	8\n38	14	8	2\n38	14	9	6	9\n38	14	9	1	5\n38	14	10	10\n38	14	10	2\n38	14	11	11	12\n38	14	11	3	1\n38	14	12	12\n38	14	12	6\n38	14	13	6	13\n38	14	13	1	20\n38	14	14	14\n38	14	14	3\n38	14	15	6	9	15\n38	14	15	1	1	6\n38	15	6	6\n38	15	6	8\n38	15	8	8\n38	15	8	2\n38	15	9	9\n38	15	9	6\n38	15	10	10\n38	15	10	2\n38	15	11	11\n38	15	11	3\n38	15	12	12\n38	15	12	7\n38	15	13	6	13\n38	15	13	4	16\n38	15	14	14\n38	15	14	3\n38	15	15	15\n38	15	15	6\n38	16	6	6\n38	16	6	12\n38	16	8	8\n38	16	8	2\n38	16	9	6	9\n38	16	9	2	4\n38	16	10	10\n38	16	10	2\n38	16	11	11\n38	16	11	3\n38	16	12	12\n38	16	12	7\n38	16	13	9	13\n38	16	13	1	15\n38	16	14	14\n38	16	14	3\n38	16	15	15\n38	16	15	6\n38	17	6	6	9\n38	17	6	13	1\n38	17	8	8\n38	17	8	2\n38	17	9	9\n38	17	9	5\n38	17	10	9	10\n38	17	10	1	1\n38	17	11	11\n38	17	11	3\n38	17	12	12\n38	17	12	7\n38	17	13	13\n38	17	13	15\n38	17	14	14\n38	17	14	3\n38	17	15	6	15\n38	17	15	1	5\n38	18	6	6\n38	18	6	14\n38	18	8	8\n38	18	8	2\n38	18	9	9\n38	18	9	7\n38	18	10	10\n38	18	10	1\n38	18	11	11\n38	18	11	3\n38	18	12	12\n38	18	12	7\n38	18	13	13\n38	18	13	15\n38	18	14	14\n38	18	14	3\n38	18	15	15\n38	18	15	5\n38	19	6	6\n38	19	6	14\n38	19	8	8\n38	19	8	2\n38	19	9	6	9\n38	19	9	1	6\n38	19	10	10\n38	19	10	1\n38	19	11	11\n38	19	11	3\n38	19	12	12\n38	19	12	7\n38	19	13	6	12	13\n38	19	13	2	1	12\n38	19	14	12	14\n38	19	14	1	2\n38	19	15	15\n38	19	15	5\n38	20	6	6\n38	20	6	17\n38	20	8	6	8\n38	20	8	1	1\n38	20	9	9\n38	20	9	6\n38	20	10	10\n38	20	10	1\n38	20	11	11\n38	20	11	3\n38	20	12	12\n38	20	12	9\n38	20	13	6	11	13\n38	20	13	3	2	7\n38	20	14	9	14\n38	20	14	1	1\n38	20	15	13	15\n38	20	15	2	3\n38	21	6	6\n38	21	6	21\n38	21	8	6\n38	21	8	1\n38	21	9	9\n38	21	9	7\n38	21	10	10\n38	21	10	1\n38	21	11	9	11\n38	21	11	1	4\n38	21	12	6	12\n38	21	12	2	7\n38	21	13	13\n38	21	13	9\n38	21	14	14\n38	21	14	1\n38	21	15	15\n38	21	15	3\n38	22	6	6	9\n38	22	6	23	1\n38	22	9	9\n38	22	9	8\n38	22	10	10\n38	22	10	1\n38	22	11	6	11\n38	22	11	1	3\n38	22	12	10	12\n38	22	12	2	5\n38	22	13	6	13\n38	22	13	6	3\n38	22	14	11\n38	22	14	1\n38	22	15	6	10	15\n38	22	15	1	1	1\n38	23	6	6	9\n38	23	6	30	1\n38	23	9	6	9\n38	23	9	4	5\n38	23	10	10	12\n38	23	10	3	1\n38	23	11	10	11\n38	23	11	1	3\n38	23	12	12\n38	23	12	5\n38	23	13	6	13\n38	23	13	1	2\n38	23	15	15\n38	23	15	1\n38	24	6	6	9\n38	24	6	34	1\n38	24	9	6	9\n38	24	9	1	5\n38	24	10	10\n38	24	10	4\n38	24	11	11\n38	24	11	3\n38	24	12	10	12\n38	24	12	1	5\n38	24	13	13\n38	24	13	2\n38	24	15	9\n38	24	15	1\n38	25	6	6\n38	25	6	35\n38	25	9	6	9\n38	25	9	1	6\n38	25	10	10\n38	25	10	5\n38	25	11	6	10	11\n38	25	11	1	1	1\n38	25	12	10	12\n38	25	12	1	4\n38	25	13	6\n38	25	13	2\n38	26	6	6\n38	26	6	39\n38	26	9	9\n38	26	9	6\n38	26	10	10\n38	26	10	7\n38	26	11	11\n38	26	11	1\n38	26	12	12\n38	26	12	4\n38	27	6	6\n38	27	6	39\n38	27	9	9\n38	27	9	6\n38	27	10	10\n38	27	10	7\n38	27	11	11\n38	27	11	1\n38	27	12	12\n38	27	12	4\n38	28	6	6	9\n38	28	6	38	1\n38	28	9	9\n38	28	9	6\n38	28	10	10\n38	28	10	7\n38	28	11	11\n38	28	11	1\n38	28	12	12\n38	28	12	4\n38	29	6	6	9\n38	29	6	37	1\n38	29	9	9\n38	29	9	7\n38	29	10	10\n38	29	10	7\n38	29	11	11\n38	29	11	1\n38	29	12	12\n38	29	12	4\n38	30	6	6\n38	30	6	37\n38	30	9	9\n38	30	9	8\n38	30	10	10\n38	30	10	7\n38	30	11	11\n38	30	11	1\n38	30	12	12\n38	30	12	4\n38	31	6	6\n38	31	6	37\n38	31	9	9\n38	31	9	8\n38	31	10	10\n38	31	10	7\n38	31	11	11\n38	31	11	1\n38	31	12	12\n38	31	12	4\n38	32	6	6\n38	32	6	37\n38	32	9	9\n38	32	9	8\n38	32	10	10\n38	32	10	7\n38	32	11	11\n38	32	11	1\n38	32	12	12\n38	32	12	4\n38	33	6	6\n38	33	6	37\n38	33	9	9\n38	33	9	8\n38	33	10	10\n38	33	10	7\n38	33	11	11\n38	33	11	1\n38	33	12	12\n38	33	12	4\n38	34	6	6\n38	34	6	37\n38	34	9	9\n38	34	9	8\n38	34	10	10\n38	34	10	7\n38	34	11	11\n38	34	11	1\n38	34	12	12\n38	34	12	4\n38	35	6	6\n38	35	6	37\n38	35	9	9\n38	35	9	8\n38	35	10	10\n38	35	10	7\n38	35	11	11\n38	35	11	1\n38	35	12	12\n38	35	12	4\n38	36	6	6\n38	36	6	37\n38	36	9	6	9\n38	36	9	3	5\n38	36	10	10\n38	36	10	7\n38	36	11	11\n38	36	11	1\n38	36	12	12\n38	36	12	4\n38	37	6	6\n38	37	6	40\n38	37	9	6	9\n38	37	9	2	3\n38	37	10	10\n38	37	10	7\n38	37	11	11\n38	37	11	1\n38	37	12	12\n38	37	12	4\n39	1	8	8\n39	1	8	3\n39	1	9	9\n39	1	9	2\n39	1	11	11\n39	1	11	10\n39	1	12	12\n39	1	12	4\n39	1	13	13\n39	1	13	15\n39	1	14	14\n39	1	14	3\n39	1	15	15\n39	1	15	7\n39	2	8	8\n39	2	8	3\n39	2	9	9\n39	2	9	2\n39	2	11	11	13\n39	2	11	9	1\n39	2	12	11	12\n39	2	12	1	3\n39	2	13	13\n39	2	13	15\n39	2	14	14\n39	2	14	3\n39	2	15	15\n39	2	15	7\n39	3	8	8\n39	3	8	3\n39	3	9	9\n39	3	9	2\n39	3	11	11\n39	3	11	10\n39	3	12	12\n39	3	12	3\n39	3	13	13\n39	3	13	16\n39	3	14	14\n39	3	14	3\n39	3	15	15\n39	3	15	7\n39	4	8	8\n39	4	8	3\n39	4	9	9\n39	4	9	2\n39	4	11	11\n39	4	11	10\n39	4	12	12\n39	4	12	3\n39	4	13	13\n39	4	13	16\n39	4	14	14\n39	4	14	3\n39	4	15	15\n39	4	15	7\n39	5	8	8\n39	5	8	3\n39	5	9	9\n39	5	9	2\n39	5	11	11\n39	5	11	10\n39	5	12	12\n39	5	12	3\n39	5	13	13\n39	5	13	16\n39	5	14	14\n39	5	14	3\n39	5	15	15\n39	5	15	7\n39	6	8	8\n39	6	8	3\n39	6	9	9\n39	6	9	2\n39	6	11	11\n39	6	11	10\n39	6	12	12\n39	6	12	3\n39	6	13	13\n39	6	13	16\n39	6	14	14\n39	6	14	3\n39	6	15	15\n39	6	15	7\n39	7	8	8\n39	7	8	3\n39	7	9	9\n39	7	9	2\n39	7	11	11\n39	7	11	10\n39	7	12	12\n39	7	12	3\n39	7	13	13\n39	7	13	16\n39	7	14	14\n39	7	14	3\n39	7	15	15\n39	7	15	7\n39	8	8	8\n39	8	8	3\n39	8	9	9\n39	8	9	2\n39	8	11	11\n39	8	11	10\n39	8	12	12\n39	8	12	3\n39	8	13	13\n39	8	13	16\n39	8	14	14\n39	8	14	3\n39	8	15	15\n39	8	15	7\n39	9	8	8\n39	9	8	3\n39	9	9	9\n39	9	9	2\n39	9	11	11\n39	9	11	10\n39	9	12	12\n39	9	12	3\n39	9	13	13\n39	9	13	16\n39	9	14	14\n39	9	14	3\n39	9	15	15\n39	9	15	7\n39	10	8	8\n39	10	8	3\n39	10	9	9\n39	10	9	2\n39	10	11	11\n39	10	11	10\n39	10	12	12\n39	10	12	3\n39	10	13	13\n39	10	13	16\n39	10	14	14\n39	10	14	3\n39	10	15	15\n39	10	15	7\n39	11	8	8\n39	11	8	3\n39	11	9	9\n39	11	9	2\n39	11	11	11\n39	11	11	10\n39	11	12	12\n39	11	12	3\n39	11	13	13\n39	11	13	16\n39	11	14	14\n39	11	14	3\n39	11	15	6	15\n39	11	15	1	6\n39	12	6	6\n39	12	6	1\n39	12	8	8\n39	12	8	3\n39	12	9	9\n39	12	9	2\n39	12	11	11\n39	12	11	10\n39	12	12	12\n39	12	12	3\n39	12	13	13\n39	12	13	16\n39	12	14	14\n39	12	14	3\n39	12	15	15\n39	12	15	6\n39	13	6	6\n39	13	6	1\n39	13	8	8\n39	13	8	3\n39	13	9	9\n39	13	9	2\n39	13	11	11\n39	13	11	10\n39	13	12	12\n39	13	12	3\n39	13	13	13	15\n39	13	13	15	1\n39	13	14	14\n39	13	14	3\n39	13	15	6	15\n39	13	15	1	5\n39	14	6	6\n39	14	6	2\n39	14	8	6	8	9\n39	14	8	1	1	1\n39	14	9	6	9\n39	14	9	1	1\n39	14	11	11\n39	14	11	10\n39	14	12	12\n39	14	12	3\n39	14	13	13\n39	14	13	15\n39	14	14	14\n39	14	14	3\n39	14	15	15\n39	14	15	6\n39	15	6	6\n39	15	6	4\n39	15	8	8\n39	15	8	1\n39	15	9	9\n39	15	9	2\n39	15	11	11\n39	15	11	10\n39	15	12	6	12\n39	15	12	1	2\n39	15	13	13\n39	15	13	15\n39	15	14	14\n39	15	14	3\n39	15	15	9	15\n39	15	15	1	5\n39	16	6	6	9\n39	16	6	3	2\n39	16	8	8\n39	16	8	1\n39	16	9	9\n39	16	9	3\n39	16	11	11\n39	16	11	10\n39	16	12	12\n39	16	12	2\n39	16	13	13\n39	16	13	15\n39	16	14	14\n39	16	14	3\n39	16	15	15\n39	16	15	5\n39	17	6	6\n39	17	6	3\n39	17	8	8\n39	17	8	1\n39	17	9	9\n39	17	9	5\n39	17	11	11\n39	17	11	10\n39	17	12	12\n39	17	12	2\n39	17	13	13\n39	17	13	15\n39	17	14	14\n39	17	14	3\n39	17	15	15\n39	17	15	5\n39	18	6	6\n39	18	6	3\n39	18	8	8\n39	18	8	1\n39	18	9	9\n39	18	9	5\n39	18	11	11\n39	18	11	10\n39	18	12	12\n39	18	12	2\n39	18	13	12	13\n39	18	13	1	14\n39	18	14	14\n39	18	14	3\n39	18	15	15\n39	18	15	5\n39	19	6	6\n39	19	6	3\n39	19	8	8\n39	19	8	1\n39	19	9	9\n39	19	9	5\n39	19	11	11\n39	19	11	10\n39	19	12	12\n39	19	12	3\n39	19	13	6	13	15\n39	19	13	1	12	1\n39	19	14	14\n39	19	14	3\n39	19	15	15\n39	19	15	5\n39	20	6	6\n39	20	6	4\n39	20	8	8\n39	20	8	1\n39	20	9	9\n39	20	9	5\n39	20	11	6	11\n39	20	11	2	8\n39	20	12	12\n39	20	12	3\n39	20	13	13\n39	20	13	12\n39	20	14	14\n39	20	14	3\n39	20	15	6	15\n39	20	15	1	5\n39	21	6	6\n39	21	6	7\n39	21	8	8\n39	21	8	1\n39	21	9	9\n39	21	9	5\n39	21	11	6	11\n39	21	11	1	7\n39	21	12	6	12\n39	21	12	1	2\n39	21	13	6	11	13\n39	21	13	1	1	10\n39	21	14	14\n39	21	14	3\n39	21	15	9	15\n39	21	15	1	4\n39	22	6	6	9\n39	22	6	9	1\n39	22	8	8\n39	22	8	1\n39	22	9	8	9\n39	22	9	1	5\n39	22	11	6	10	11	12\n39	22	11	3	1	3	1\n39	22	12	10	12\n39	22	12	1	1\n39	22	13	6	13\n39	22	13	2	8\n39	22	14	14\n39	22	14	3\n39	22	15	9	13	15\n39	22	15	1	1	2\n39	23	6	6	9\n39	23	6	12	2\n39	23	8	8\n39	23	8	2\n39	23	9	9\n39	23	9	7\n39	23	10	10\n39	23	10	2\n39	23	11	11\n39	23	11	3\n39	23	12	12\n39	23	12	2\n39	23	13	6	9	13\n39	23	13	2	2	5\n39	23	14	8	10	11\n39	23	14	1	1	1\n39	23	15	15\n39	23	15	2\n39	24	6	6\n39	24	6	14\n39	24	8	6	8\n39	24	8	1	2\n39	24	9	9\n39	24	9	11\n39	24	10	10\n39	24	10	3\n39	24	11	11	12\n39	24	11	3	1\n39	24	12	12\n39	24	12	2\n39	24	13	6	9	13\n39	24	13	2	1	2\n39	24	15	15\n39	24	15	2\n39	25	6	6	9\n39	25	6	16	1\n39	25	8	8\n39	25	8	2\n39	25	9	6	9\n39	25	9	2	10\n39	25	10	10\n39	25	10	3\n39	25	11	11	12\n39	25	11	2	1\n39	25	12	12\n39	25	12	3\n39	25	13	6	13\n39	25	13	1	1\n39	25	15	15\n39	25	15	2\n39	26	6	6	9\n39	26	6	17	2\n39	26	8	8\n39	26	8	2\n39	26	9	6	9\n39	26	9	1	10\n39	26	10	10\n39	26	10	3\n39	26	11	11\n39	26	11	2\n39	26	12	12\n39	26	12	4\n39	26	13	13\n39	26	13	1\n39	26	15	6	15\n39	26	15	1	1\n39	27	6	6\n39	27	6	19\n39	27	8	8\n39	27	8	2\n39	27	9	6	9\n39	27	9	1	11\n39	27	10	10\n39	27	10	3\n39	27	11	11	12\n39	27	11	1	1\n39	27	12	10	12\n39	27	12	1	3\n39	27	13	6\n39	27	13	1\n39	27	15	15\n39	27	15	1\n39	28	6	6\n39	28	6	21\n39	28	8	8\n39	28	8	2\n39	28	9	9\n39	28	9	11\n39	28	10	10\n39	28	10	4\n39	28	11	11\n39	28	11	1\n39	28	12	12\n39	28	12	4\n39	28	15	6\n39	28	15	1\n39	29	6	6	9\n39	29	6	20	2\n39	29	8	8\n39	29	8	2\n39	29	9	9\n39	29	9	11\n39	29	10	10\n39	29	10	4\n39	29	11	11\n39	29	11	1\n39	29	12	12\n39	29	12	4\n39	30	6	6	9\n39	30	6	19	1\n39	30	8	8\n39	30	8	2\n39	30	9	9\n39	30	9	13\n39	30	10	10\n39	30	10	4\n39	30	11	11\n39	30	11	1\n39	30	12	12\n39	30	12	4\n39	31	6	6\n39	31	6	19\n39	31	8	8\n39	31	8	2\n39	31	9	9\n39	31	9	14\n39	31	10	10\n39	31	10	4\n39	31	11	11\n39	31	11	1\n39	31	12	12\n39	31	12	4\n39	32	6	6\n39	32	6	19\n39	32	8	8\n39	32	8	2\n39	32	9	9\n39	32	9	14\n39	32	10	10\n39	32	10	4\n39	32	11	11\n39	32	11	1\n39	32	12	12\n39	32	12	4\n39	33	6	6\n39	33	6	19\n39	33	8	8\n39	33	8	2\n39	33	9	9\n39	33	9	14\n39	33	10	10\n39	33	10	4\n39	33	11	11\n39	33	11	1\n39	33	12	12\n39	33	12	4\n39	34	6	6\n39	34	6	19\n39	34	8	8\n39	34	8	2\n39	34	9	9\n39	34	9	14\n39	34	10	10\n39	34	10	4\n39	34	11	11\n39	34	11	1\n39	34	12	12\n39	34	12	4\n39	35	6	6\n39	35	6	19\n39	35	8	8\n39	35	8	2\n39	35	9	9\n39	35	9	14\n39	35	10	10\n39	35	10	4\n39	35	11	11\n39	35	11	1\n39	35	12	12\n39	35	12	4\n39	36	6	6\n39	36	6	19\n39	36	8	8\n39	36	8	2\n39	36	9	9\n39	36	9	14\n39	36	10	10\n39	36	10	4\n39	36	11	11\n39	36	11	1\n39	36	12	12\n39	36	12	4\n39	37	6	6\n39	37	6	19\n39	37	8	8\n39	37	8	2\n39	37	9	6	9\n39	37	9	4	10\n39	37	10	10\n39	37	10	4\n39	37	11	11\n39	37	11	1\n39	37	12	12\n39	37	12	4\n39	38	6	6\n39	38	6	23\n39	38	8	8\n39	38	8	2\n39	38	9	6	9\n39	38	9	3	7\n39	38	10	10\n39	38	10	4\n39	38	11	11\n39	38	11	1\n39	38	12	10	12\n39	38	12	1	3\n40	1	7	7\n40	1	7	1\n40	1	8	8\n40	1	8	2\n40	1	9	9\n40	1	9	1\n40	1	10	10\n40	1	10	1\n40	1	11	11\n40	1	11	8\n40	1	12	12\n40	1	12	2\n40	1	13	11	13\n40	1	13	1	9\n40	1	14	14\n40	1	14	2\n40	1	15	15\n40	1	15	9\n40	1	16	16\n40	1	16	2\n40	2	7	7\n40	2	7	1\n40	2	8	8\n40	2	8	2\n40	2	9	9\n40	2	9	1\n40	2	10	10\n40	2	10	1\n40	2	11	11\n40	2	11	9\n40	2	12	12\n40	2	12	2\n40	2	13	13\n40	2	13	9\n40	2	14	14\n40	2	14	2\n40	2	15	15\n40	2	15	9\n40	2	16	16	20\n40	2	16	1	1\n40	3	7	7\n40	3	7	1\n40	3	8	8\n40	3	8	2\n40	3	9	9\n40	3	9	1\n40	3	10	10\n40	3	10	1\n40	3	11	11\n40	3	11	9\n40	3	12	12\n40	3	12	2\n40	3	13	13\n40	3	13	9\n40	3	14	14\n40	3	14	2\n40	3	15	15\n40	3	15	9\n40	3	16	16\n40	3	16	1\n40	3	20	20\n40	3	20	1\n40	4	7	7\n40	4	7	1\n40	4	8	8\n40	4	8	2\n40	4	9	9\n40	4	9	1\n40	4	10	10\n40	4	10	1\n40	4	11	11\n40	4	11	9\n40	4	12	12\n40	4	12	2\n40	4	13	13\n40	4	13	9\n40	4	14	14\n40	4	14	2\n40	4	15	15\n40	4	15	9\n40	4	16	16\n40	4	16	1\n40	4	20	20\n40	4	20	1\n40	5	7	7\n40	5	7	1\n40	5	8	8\n40	5	8	2\n40	5	9	9\n40	5	9	1\n40	5	10	10\n40	5	10	1\n40	5	11	11\n40	5	11	9\n40	5	12	12\n40	5	12	2\n40	5	13	13\n40	5	13	9\n40	5	14	14\n40	5	14	2\n40	5	15	15\n40	5	15	9\n40	5	16	16\n40	5	16	1\n40	5	20	20\n40	5	20	1\n40	6	7	7\n40	6	7	1\n40	6	8	8\n40	6	8	2\n40	6	9	9\n40	6	9	1\n40	6	10	10\n40	6	10	1\n40	6	11	11\n40	6	11	9\n40	6	12	12\n40	6	12	2\n40	6	13	13\n40	6	13	9\n40	6	14	14\n40	6	14	2\n40	6	15	15\n40	6	15	9\n40	6	16	16\n40	6	16	1\n40	6	20	20\n40	6	20	1\n40	7	7	7\n40	7	7	1\n40	7	8	8\n40	7	8	2\n40	7	9	9\n40	7	9	1\n40	7	10	10\n40	7	10	1\n40	7	11	11\n40	7	11	9\n40	7	12	12\n40	7	12	2\n40	7	13	13\n40	7	13	9\n40	7	14	14\n40	7	14	2\n40	7	15	15\n40	7	15	9\n40	7	16	16\n40	7	16	1\n40	7	20	20\n40	7	20	1\n40	8	7	7\n40	8	7	1\n40	8	8	8\n40	8	8	2\n40	8	9	9\n40	8	9	1\n40	8	10	10\n40	8	10	1\n40	8	11	11\n40	8	11	9\n40	8	12	12\n40	8	12	2\n40	8	13	13\n40	8	13	9\n40	8	14	14\n40	8	14	2\n40	8	15	15\n40	8	15	9\n40	8	16	16\n40	8	16	1\n40	8	20	20\n40	8	20	1\n40	9	7	7\n40	9	7	1\n40	9	8	8\n40	9	8	2\n40	9	9	9\n40	9	9	1\n40	9	10	10\n40	9	10	1\n40	9	11	11\n40	9	11	9\n40	9	12	12\n40	9	12	2\n40	9	13	13\n40	9	13	9\n40	9	14	14\n40	9	14	2\n40	9	15	15\n40	9	15	9\n40	9	16	16\n40	9	16	1\n40	9	20	20\n40	9	20	1\n40	10	7	7\n40	10	7	1\n40	10	8	8\n40	10	8	2\n40	10	9	9\n40	10	9	1\n40	10	10	10\n40	10	10	1\n40	10	11	6	11\n40	10	11	1	8\n40	10	12	12\n40	10	12	2\n40	10	13	13\n40	10	13	9\n40	10	14	14\n40	10	14	2\n40	10	15	15\n40	10	15	9\n40	10	16	16\n40	10	16	1\n40	10	20	20\n40	10	20	1\n40	11	6	6\n40	11	6	1\n40	11	7	7\n40	11	7	1\n40	11	8	8\n40	11	8	2\n40	11	9	9\n40	11	9	1\n40	11	10	10\n40	11	10	1\n40	11	11	11\n40	11	11	8\n40	11	12	12\n40	11	12	2\n40	11	13	9	13\n40	11	13	1	8\n40	11	14	14\n40	11	14	2\n40	11	15	15\n40	11	15	9\n40	11	16	16\n40	11	16	1\n40	11	20	20\n40	11	20	1\n40	12	6	6\n40	12	6	1\n40	12	7	7\n40	12	7	1\n40	12	8	8\n40	12	8	2\n40	12	9	9\n40	12	9	2\n40	12	10	10\n40	12	10	1\n40	12	11	11\n40	12	11	8\n40	12	12	12\n40	12	12	2\n40	12	13	13\n40	12	13	8\n40	12	14	14\n40	12	14	2\n40	12	15	15\n40	12	15	9\n40	12	16	16\n40	12	16	1\n40	12	20	20\n40	12	20	1\n40	13	6	6\n40	13	6	1\n40	13	7	7\n40	13	7	1\n40	13	8	8\n40	13	8	2\n40	13	9	9\n40	13	9	2\n40	13	10	10\n40	13	10	1\n40	13	11	11\n40	13	11	8\n40	13	12	12\n40	13	12	2\n40	13	13	6	13\n40	13	13	1	7\n40	13	14	14\n40	13	14	2\n40	13	15	13	15\n40	13	15	1	8\n40	13	16	16\n40	13	16	1\n40	13	20	20\n40	13	20	1\n40	14	6	6\n40	14	6	2\n40	14	7	7\n40	14	7	1\n40	14	8	8\n40	14	8	2\n40	14	9	9\n40	14	9	2\n40	14	10	10\n40	14	10	1\n40	14	11	11\n40	14	11	8\n40	14	12	12\n40	14	12	2\n40	14	13	6	13\n40	14	13	2	6\n40	14	14	14\n40	14	14	2\n40	14	15	9	15\n40	14	15	1	7\n40	14	16	16\n40	14	16	1\n40	14	20	20\n40	14	20	1\n40	15	6	6\n40	15	6	4\n40	15	7	7\n40	15	7	1\n40	15	8	8\n40	15	8	2\n40	15	9	9\n40	15	9	3\n40	15	10	10\n40	15	10	1\n40	15	11	11\n40	15	11	8\n40	15	12	12\n40	15	12	2\n40	15	13	6	9	13\n40	15	13	1	1	4\n40	15	14	14\n40	15	14	2\n40	15	15	6	15\n40	15	15	1	6\n40	15	16	16\n40	15	16	1\n40	15	20	20\n40	15	20	1\n40	16	6	6	9\n40	16	6	5	1\n40	16	7	7\n40	16	7	1\n40	16	8	8\n40	16	8	2\n40	16	9	9\n40	16	9	4\n40	16	10	10\n40	16	10	1\n40	16	11	11\n40	16	11	8\n40	16	12	12\n40	16	12	2\n40	16	13	6	13\n40	16	13	1	3\n40	16	14	14\n40	16	14	2\n40	16	15	6	15\n40	16	15	1	5\n40	16	16	16\n40	16	16	1\n40	16	20	20\n40	16	20	1\n40	17	6	6\n40	17	6	7\n40	17	7	7\n40	17	7	1\n40	17	8	8\n40	17	8	2\n40	17	9	9\n40	17	9	5\n40	17	10	10\n40	17	10	1\n40	17	11	11\n40	17	11	8\n40	17	12	12\n40	17	12	2\n40	17	13	13\n40	17	13	3\n40	17	14	14\n40	17	14	2\n40	17	15	9	15\n40	17	15	1	4\n40	17	16	16\n40	17	16	1\n40	17	20	20\n40	17	20	1\n40	18	6	6\n40	18	6	7\n40	18	7	7\n40	18	7	1\n40	18	8	8\n40	18	8	2\n40	18	9	9\n40	18	9	6\n40	18	10	10\n40	18	10	1\n40	18	11	6	11\n40	18	11	1	7\n40	18	12	12\n40	18	12	2\n40	18	13	13\n40	18	13	3\n40	18	14	14\n40	18	14	2\n40	18	15	15\n40	18	15	4\n40	18	16	16\n40	18	16	1\n40	18	20	20\n40	18	20	1\n40	19	6	6\n40	19	6	8\n40	19	7	7\n40	19	7	1\n40	19	8	8\n40	19	8	2\n40	19	9	9\n40	19	9	6\n40	19	10	10\n40	19	10	1\n40	19	11	11\n40	19	11	7\n40	19	12	12\n40	19	12	2\n40	19	13	13\n40	19	13	3\n40	19	14	14\n40	19	14	2\n40	19	15	15\n40	19	15	4\n40	19	16	16\n40	19	16	1\n40	19	20	20\n40	19	20	1\n40	20	6	6\n40	20	6	8\n40	20	7	7\n40	20	7	1\n40	20	8	8\n40	20	8	2\n40	20	9	9\n40	20	9	6\n40	20	10	10\n40	20	10	1\n40	20	11	11\n40	20	11	7\n40	20	12	12\n40	20	12	2\n40	20	13	13\n40	20	13	3\n40	20	14	14\n40	20	14	2\n40	20	15	15\n40	20	15	4\n40	20	16	16\n40	20	16	1\n40	20	20	20\n40	20	20	1\n40	21	6	6\n40	21	6	8\n40	21	7	7\n40	21	7	1\n40	21	8	6	8\n40	21	8	1	1\n40	21	9	6	9\n40	21	9	1	5\n40	21	10	10\n40	21	10	1\n40	21	11	6	11\n40	21	11	1	6\n40	21	12	12\n40	21	12	2\n40	21	13	6	13\n40	21	13	1	2\n40	21	14	14\n40	21	14	2\n40	21	15	6	15\n40	21	15	2	2\n40	21	16	16\n40	21	16	1\n40	21	20	20\n40	21	20	1\n40	22	6	6\n40	22	6	14\n40	22	7	7\n40	22	7	1\n40	22	8	8\n40	22	8	1\n40	22	9	6	9\n40	22	9	1	4\n40	22	10	6\n40	22	10	1\n40	22	11	11\n40	22	11	6\n40	22	12	10	12\n40	22	12	1	1\n40	22	13	13\n40	22	13	2\n40	22	14	14\n40	22	14	2\n40	22	15	15\n40	22	15	2\n40	22	16	8\n40	22	16	1\n40	22	20	20\n40	22	20	1\n40	23	6	6\n40	23	6	16\n40	23	7	7\n40	23	7	1\n40	23	8	6	8\n40	23	8	1	1\n40	23	9	9\n40	23	9	4\n40	23	10	10\n40	23	10	1\n40	23	11	6	10	11\n40	23	11	1	3	2\n40	23	12	12\n40	23	12	1\n40	23	13	6	13\n40	23	13	1	1\n40	23	14	14\n40	23	14	2\n40	23	15	6	15\n40	23	15	1	1\n40	23	20	16\n40	23	20	1\n40	24	6	6\n40	24	6	20\n40	24	7	7\n40	24	7	1\n40	24	8	8\n40	24	8	1\n40	24	9	9\n40	24	9	4\n40	24	10	10\n40	24	10	4\n40	24	11	11\n40	24	11	2\n40	24	12	12\n40	24	12	1\n40	24	13	13\n40	24	13	1\n40	24	14	8	10\n40	24	14	1	1\n40	24	15	15\n40	24	15	1\n40	24	16	16\n40	24	16	1\n40	25	6	6	9\n40	25	6	18	2\n40	25	7	6\n40	25	7	1\n40	25	8	8\n40	25	8	2\n40	25	9	9\n40	25	9	4\n40	25	10	10\n40	25	10	5\n40	25	11	6	10\n40	25	11	1	1\n40	25	12	10\n40	25	12	1\n40	25	13	13\n40	25	13	1\n40	25	15	15\n40	25	15	1\n40	25	16	10\n40	25	16	1\n40	26	6	6\n40	26	6	20\n40	26	8	8\n40	26	8	2\n40	26	9	9\n40	26	9	6\n40	26	10	10\n40	26	10	8\n40	26	13	6\n40	26	13	1\n40	26	15	15\n40	26	15	1\n40	27	6	6\n40	27	6	21\n40	27	8	8\n40	27	8	2\n40	27	9	9\n40	27	9	6\n40	27	10	10\n40	27	10	8\n40	27	15	6\n40	27	15	1\n40	28	6	6\n40	28	6	22\n40	28	8	8\n40	28	8	2\n40	28	9	9\n40	28	9	6\n40	28	10	10\n40	28	10	8\n40	29	6	6\n40	29	6	22\n40	29	8	8\n40	29	8	2\n40	29	9	6	9\n40	29	9	1	5\n40	29	10	10\n40	29	10	8\n40	30	6	6\n40	30	6	23\n40	30	8	8\n40	30	8	2\n40	30	9	9\n40	30	9	5\n40	30	10	10\n40	30	10	8\n40	31	6	6\n40	31	6	23\n40	31	8	8\n40	31	8	2\n40	31	9	9\n40	31	9	5\n40	31	10	10\n40	31	10	8\n40	32	6	6\n40	32	6	23\n40	32	8	8\n40	32	8	2\n40	32	9	9\n40	32	9	5\n40	32	10	10\n40	32	10	8\n40	33	6	6	9\n40	33	6	22	1\n40	33	8	8\n40	33	8	2\n40	33	9	9\n40	33	9	5\n40	33	10	10\n40	33	10	8\n40	34	6	6\n40	34	6	22\n40	34	8	8\n40	34	8	2\n40	34	9	9\n40	34	9	6\n40	34	10	10\n40	34	10	8\n40	35	6	6\n40	35	6	22\n40	35	8	8\n40	35	8	2\n40	35	9	9\n40	35	9	6\n40	35	10	10\n40	35	10	8\n40	36	6	6\n40	36	6	22\n40	36	8	8\n40	36	8	2\n40	36	9	9\n40	36	9	6\n40	36	10	10\n40	36	10	8\n40	37	6	6\n40	37	6	22\n40	37	8	8\n40	37	8	2\n40	37	9	9\n40	37	9	6\n40	37	10	10\n40	37	10	8\n40	38	6	6\n40	38	6	22\n40	38	8	8\n40	38	8	2\n40	38	9	6	9\n40	38	9	5	1\n40	38	10	10\n40	38	10	8\n40	39	6	6\n40	39	6	27\n40	39	8	8\n40	39	8	2\n40	39	9	9\n40	39	9	1\n40	39	10	10\n40	39	10	8\n41	1	6	6\n41	1	6	1\n41	1	7	7\n41	1	7	2\n41	1	8	8\n41	1	8	1\n41	1	9	9\n41	1	9	3\n41	1	10	10\n41	1	10	1\n41	1	11	11\n41	1	11	2\n41	1	12	11	12\n41	1	12	1	4\n41	1	13	13\n41	1	13	6\n41	1	14	14\n41	1	14	2\n41	1	15	15\n41	1	15	3\n41	1	16	16\n41	1	16	1\n41	2	6	6\n41	2	6	1\n41	2	7	7\n41	2	7	2\n41	2	8	8\n41	2	8	1\n41	2	9	9\n41	2	9	3\n41	2	10	10\n41	2	10	1\n41	2	11	11\n41	2	11	3\n41	2	12	12\n41	2	12	4\n41	2	13	13\n41	2	13	6\n41	2	14	14\n41	2	14	2\n41	2	15	15\n41	2	15	3\n41	2	16	16\n41	2	16	1\n41	3	6	6\n41	3	6	1\n41	3	7	7\n41	3	7	2\n41	3	8	8\n41	3	8	1\n41	3	9	9\n41	3	9	3\n41	3	10	10\n41	3	10	1\n41	3	11	11\n41	3	11	3\n41	3	12	12\n41	3	12	4\n41	3	13	13\n41	3	13	6\n41	3	14	14\n41	3	14	2\n41	3	15	13	15\n41	3	15	1	2\n41	3	16	16\n41	3	16	1\n41	4	6	6\n41	4	6	1\n41	4	7	7\n41	4	7	2\n41	4	8	8\n41	4	8	1\n41	4	9	9\n41	4	9	3\n41	4	10	10\n41	4	10	1\n41	4	11	11\n41	4	11	3\n41	4	12	12\n41	4	12	4\n41	4	13	13\n41	4	13	7\n41	4	14	14\n41	4	14	2\n41	4	15	15\n41	4	15	2\n41	4	16	16\n41	4	16	1\n41	5	6	6\n41	5	6	1\n41	5	7	7\n41	5	7	2\n41	5	8	8\n41	5	8	1\n41	5	9	9\n41	5	9	3\n41	5	10	10\n41	5	10	1\n41	5	11	11\n41	5	11	3\n41	5	12	12\n41	5	12	4\n41	5	13	13\n41	5	13	7\n41	5	14	14\n41	5	14	2\n41	5	15	15\n41	5	15	2\n41	5	16	16\n41	5	16	1\n41	6	6	6\n41	6	6	1\n41	6	7	7\n41	6	7	2\n41	6	8	8\n41	6	8	1\n41	6	9	9\n41	6	9	3\n41	6	10	10\n41	6	10	1\n41	6	11	11\n41	6	11	3\n41	6	12	12\n41	6	12	4\n41	6	13	13\n41	6	13	7\n41	6	14	14\n41	6	14	2\n41	6	15	15\n41	6	15	2\n41	6	16	16\n41	6	16	1\n41	7	6	6\n41	7	6	1\n41	7	7	7\n41	7	7	2\n41	7	8	8\n41	7	8	1\n41	7	9	9\n41	7	9	3\n41	7	10	10\n41	7	10	1\n41	7	11	11\n41	7	11	3\n41	7	12	12\n41	7	12	4\n41	7	13	13\n41	7	13	7\n41	7	14	14\n41	7	14	2\n41	7	15	15\n41	7	15	2\n41	7	16	16\n41	7	16	1\n41	8	6	6\n41	8	6	1\n41	8	7	7\n41	8	7	2\n41	8	8	8\n41	8	8	1\n41	8	9	9\n41	8	9	3\n41	8	10	10\n41	8	10	1\n41	8	11	11\n41	8	11	3\n41	8	12	12\n41	8	12	4\n41	8	13	13\n41	8	13	7\n41	8	14	14\n41	8	14	2\n41	8	15	15\n41	8	15	2\n41	8	16	16\n41	8	16	1\n41	9	6	6\n41	9	6	1\n41	9	7	7\n41	9	7	2\n41	9	8	8\n41	9	8	1\n41	9	9	9\n41	9	9	3\n41	9	10	10\n41	9	10	1\n41	9	11	11\n41	9	11	3\n41	9	12	12\n41	9	12	4\n41	9	13	13\n41	9	13	7\n41	9	14	14\n41	9	14	2\n41	9	15	15\n41	9	15	2\n41	9	16	16\n41	9	16	1\n41	10	6	6\n41	10	6	1\n41	10	7	7\n41	10	7	2\n41	10	8	8\n41	10	8	1\n41	10	9	9\n41	10	9	3\n41	10	10	10\n41	10	10	1\n41	10	11	11\n41	10	11	3\n41	10	12	12\n41	10	12	4\n41	10	13	13\n41	10	13	7\n41	10	14	14\n41	10	14	2\n41	10	15	15\n41	10	15	2\n41	10	16	16\n41	10	16	1\n41	11	6	6\n41	11	6	1\n41	11	7	7\n41	11	7	2\n41	11	8	8\n41	11	8	1\n41	11	9	9\n41	11	9	3\n41	11	10	10\n41	11	10	1\n41	11	11	11\n41	11	11	3\n41	11	12	12\n41	11	12	4\n41	11	13	13\n41	11	13	7\n41	11	14	14\n41	11	14	2\n41	11	15	15\n41	11	15	2\n41	11	16	16\n41	11	16	1\n41	12	6	6\n41	12	6	1\n41	12	7	7\n41	12	7	2\n41	12	8	8\n41	12	8	1\n41	12	9	9\n41	12	9	3\n41	12	10	10\n41	12	10	1\n41	12	11	10	11\n41	12	11	1	2\n41	12	12	12\n41	12	12	4\n41	12	13	13\n41	12	13	7\n41	12	14	14\n41	12	14	2\n41	12	15	15\n41	12	15	2\n41	12	16	16\n41	12	16	1\n41	13	6	6\n41	13	6	1\n41	13	7	7\n41	13	7	2\n41	13	8	8\n41	13	8	1\n41	13	9	9\n41	13	9	3\n41	13	10	10\n41	13	10	2\n41	13	11	6	11\n41	13	11	1	1\n41	13	12	12\n41	13	12	4\n41	13	13	13\n41	13	13	7\n41	13	14	14\n41	13	14	2\n41	13	15	15\n41	13	15	2\n41	13	16	16\n41	13	16	1\n41	14	6	6\n41	14	6	2\n41	14	7	7\n41	14	7	2\n41	14	8	8\n41	14	8	1\n41	14	9	9\n41	14	9	3\n41	14	10	10\n41	14	10	2\n41	14	11	11\n41	14	11	1\n41	14	12	12\n41	14	12	4\n41	14	13	9	13\n41	14	13	1	6\n41	14	14	6	14\n41	14	14	1	1\n41	14	15	15\n41	14	15	2\n41	14	16	8\n41	14	16	1\n41	15	6	6\n41	15	6	3\n41	15	7	7\n41	15	7	2\n41	15	8	8\n41	15	8	2\n41	15	9	6	9\n41	15	9	1	3\n41	15	10	10\n41	15	10	2\n41	15	11	11\n41	15	11	1\n41	15	12	12\n41	15	12	4\n41	15	13	9	13\n41	15	13	1	5\n41	15	14	14\n41	15	14	1\n41	15	15	15\n41	15	15	2\n41	16	6	6\n41	16	6	4\n41	16	7	7\n41	16	7	2\n41	16	8	6	8\n41	16	8	1	1\n41	16	9	9\n41	16	9	4\n41	16	10	10\n41	16	10	2\n41	16	11	11\n41	16	11	1\n41	16	12	12\n41	16	12	4\n41	16	13	13\n41	16	13	5\n41	16	14	14\n41	16	14	1\n41	16	15	6	15\n41	16	15	1	1\n41	17	6	6\n41	17	6	6\n41	17	7	7\n41	17	7	2\n41	17	8	8\n41	17	8	1\n41	17	9	9\n41	17	9	4\n41	17	10	10\n41	17	10	2\n41	17	11	11\n41	17	11	1\n41	17	12	12\n41	17	12	4\n41	17	13	6	13\n41	17	13	1	4\n41	17	14	14\n41	17	14	1\n41	17	15	15\n41	17	15	1\n41	18	6	6\n41	18	6	7\n41	18	7	7\n41	18	7	2\n41	18	8	8\n41	18	8	1\n41	18	9	9\n41	18	9	4\n41	18	10	10\n41	18	10	2\n41	18	11	11\n41	18	11	1\n41	18	12	12\n41	18	12	4\n41	18	13	13	15\n41	18	13	3	1\n41	18	14	14\n41	18	14	1\n41	18	15	15\n41	18	15	1\n41	19	6	6\n41	19	6	7\n41	19	7	7\n41	19	7	2\n41	19	8	8\n41	19	8	1\n41	19	9	9\n41	19	9	4\n41	19	10	10	11\n41	19	10	1	1\n41	19	11	11\n41	19	11	1\n41	19	12	12\n41	19	12	4\n41	19	13	13\n41	19	13	3\n41	19	14	14\n41	19	14	1\n41	19	15	15\n41	19	15	2\n41	20	6	6\n41	20	6	7\n41	20	7	7\n41	20	7	2\n41	20	8	8\n41	20	8	1\n41	20	9	9\n41	20	9	4\n41	20	10	10\n41	20	10	1\n41	20	11	11\n41	20	11	2\n41	20	12	12\n41	20	12	4\n41	20	13	13\n41	20	13	3\n41	20	14	14\n41	20	14	1\n41	20	15	15\n41	20	15	2\n41	21	6	6	9\n41	21	6	6	1\n41	21	7	7\n41	21	7	2\n41	21	8	8\n41	21	8	1\n41	21	9	9\n41	21	9	4\n41	21	10	10\n41	21	10	1\n41	21	11	11\n41	21	11	2\n41	21	12	10	12\n41	21	12	1	3\n41	21	13	13\n41	21	13	3\n41	21	14	14\n41	21	14	1\n41	21	15	6	15\n41	21	15	1	1\n41	22	6	6\n41	22	6	7\n41	22	7	6	7\n41	22	7	1	1\n41	22	8	8\n41	22	8	1\n41	22	9	6	9\n41	22	9	1	4\n41	22	10	10\n41	22	10	2\n41	22	11	6	11\n41	22	11	1	1\n41	22	12	8	10	12\n41	22	12	1	1	1\n41	22	13	9	13\n41	22	13	1	2\n41	22	14	14\n41	22	14	1\n41	22	15	9\n41	22	15	1\n41	23	6	6\n41	23	6	10\n41	23	7	6\n41	23	7	1\n41	23	8	8\n41	23	8	2\n41	23	9	6	9\n41	23	9	1	5\n41	23	10	10\n41	23	10	3\n41	23	11	11\n41	23	11	1\n41	23	12	10\n41	23	12	1\n41	23	13	6	13\n41	23	13	1	1\n41	23	14	10\n41	23	14	1\n41	24	6	6\n41	24	6	13\n41	24	8	8\n41	24	8	2\n41	24	9	9\n41	24	9	5\n41	24	10	10\n41	24	10	5\n41	24	11	11\n41	24	11	1\n41	24	13	13\n41	24	13	1\n41	25	6	6	9\n41	25	6	12	1\n41	25	8	8\n41	25	8	2\n41	25	9	6	9\n41	25	9	1	4\n41	25	10	10\n41	25	10	5\n41	25	11	11\n41	25	11	1\n41	25	13	13\n41	25	13	1\n41	26	6	6\n41	26	6	13\n41	26	8	8\n41	26	8	2\n41	26	9	9\n41	26	9	5\n41	26	10	10\n41	26	10	5\n41	26	11	11\n41	26	11	1\n41	26	13	13\n41	26	13	1\n41	27	6	6\n41	27	6	13\n41	27	8	8\n41	27	8	2\n41	27	9	9\n41	27	9	5\n41	27	10	10\n41	27	10	5\n41	27	11	10\n41	27	11	1\n41	27	13	6\n41	27	13	1\n41	28	6	6\n41	28	6	14\n41	28	8	8	9\n41	28	8	1	1\n41	28	9	9\n41	28	9	5\n41	28	10	10\n41	28	10	6\n41	29	6	6	9\n41	29	6	13	1\n41	29	8	8\n41	29	8	1\n41	29	9	6	9\n41	29	9	1	5\n41	29	10	10\n41	29	10	6\n41	30	6	6\n41	30	6	14\n41	30	8	8\n41	30	8	1\n41	30	9	9\n41	30	9	6\n41	30	10	10\n41	30	10	6\n41	31	6	6	9\n41	31	6	13	1\n41	31	8	8\n41	31	8	1\n41	31	9	9\n41	31	9	6\n41	31	10	10\n41	31	10	6\n41	32	6	6\n41	32	6	13\n41	32	8	8\n41	32	8	1\n41	32	9	9\n41	32	9	7\n41	32	10	10\n41	32	10	6\n41	33	6	6\n41	33	6	13\n41	33	8	8\n41	33	8	1\n41	33	9	9\n41	33	9	7\n41	33	10	10\n41	33	10	6\n41	34	6	6\n41	34	6	13\n41	34	8	8\n41	34	8	1\n41	34	9	9\n41	34	9	7\n41	34	10	10	11\n41	34	10	5	1\n41	35	6	6\n41	35	6	13\n41	35	8	8\n41	35	8	1\n41	35	9	9\n41	35	9	7\n41	35	10	10\n41	35	10	5\n41	35	11	11\n41	35	11	1\n41	36	6	6\n41	36	6	13\n41	36	8	8\n41	36	8	1\n41	36	9	9\n41	36	9	7\n41	36	10	10\n41	36	10	5\n41	36	11	12\n41	36	11	1\n41	37	6	6\n41	37	6	13\n41	37	8	8\n41	37	8	1\n41	37	9	9\n41	37	9	7\n41	37	10	10\n41	37	10	5\n41	37	12	12\n41	37	12	1\n41	38	6	6\n41	38	6	13\n41	38	8	8\n41	38	8	1\n41	38	9	9\n41	38	9	7\n41	38	10	10\n41	38	10	5\n41	38	12	12\n41	38	12	1\n41	39	6	6\n41	39	6	13\n41	39	8	8\n41	39	8	1\n41	39	9	6	8	9\n41	39	9	3	1	3\n41	39	10	10\n41	39	10	5\n41	39	12	12\n41	39	12	1\n41	40	6	6\n41	40	6	16\n41	40	8	8\n41	40	8	2\n41	40	9	6	9\n41	40	9	1	2\n41	40	10	10\n41	40	10	5\n41	40	12	10\n41	40	12	1\n42	1	6	6\n42	1	6	3\n42	1	9	9\n42	1	9	3\n42	1	10	10\n42	1	10	1\n42	1	12	12\n42	1	12	1\n42	1	13	13\n42	1	13	5\n42	1	15	15\n42	1	15	4\n42	2	6	6\n42	2	6	3\n42	2	9	9\n42	2	9	3\n42	2	10	10\n42	2	10	1\n42	2	12	12\n42	2	12	1\n42	2	13	13\n42	2	13	5\n42	2	15	15\n42	2	15	4\n42	3	6	6\n42	3	6	3\n42	3	9	9\n42	3	9	3\n42	3	10	10\n42	3	10	1\n42	3	12	12\n42	3	12	1\n42	3	13	13\n42	3	13	5\n42	3	15	15\n42	3	15	4\n42	4	6	6\n42	4	6	3\n42	4	9	9\n42	4	9	3\n42	4	10	10\n42	4	10	1\n42	4	12	12\n42	4	12	1\n42	4	13	13\n42	4	13	5\n42	4	15	15\n42	4	15	4\n42	5	6	6\n42	5	6	3\n42	5	9	9\n42	5	9	3\n42	5	10	10\n42	5	10	1\n42	5	12	12\n42	5	12	1\n42	5	13	13\n42	5	13	5\n42	5	15	15\n42	5	15	4\n42	6	6	6\n42	6	6	3\n42	6	9	9\n42	6	9	3\n42	6	10	10\n42	6	10	1\n42	6	12	12\n42	6	12	1\n42	6	13	13\n42	6	13	5\n42	6	15	15\n42	6	15	4\n42	7	6	6\n42	7	6	3\n42	7	9	9\n42	7	9	3\n42	7	10	10\n42	7	10	1\n42	7	12	12\n42	7	12	1\n42	7	13	13\n42	7	13	5\n42	7	15	15\n42	7	15	4\n42	8	6	6\n42	8	6	3\n42	8	9	9\n42	8	9	3\n42	8	10	10\n42	8	10	1\n42	8	12	12\n42	8	12	1\n42	8	13	13\n42	8	13	5\n42	8	15	15\n42	8	15	4\n42	9	6	6\n42	9	6	3\n42	9	9	9\n42	9	9	3\n42	9	10	10\n42	9	10	1\n42	9	12	12\n42	9	12	1\n42	9	13	13\n42	9	13	5\n42	9	15	15\n42	9	15	4\n42	10	6	6\n42	10	6	3\n42	10	9	9\n42	10	9	3\n42	10	10	10\n42	10	10	1\n42	10	12	12\n42	10	12	1\n42	10	13	13\n42	10	13	5\n42	10	15	15\n42	10	15	4\n42	11	6	6\n42	11	6	3\n42	11	9	9\n42	11	9	3\n42	11	10	10\n42	11	10	1\n42	11	12	12\n42	11	12	1\n42	11	13	13\n42	11	13	5\n42	11	15	6	15\n42	11	15	1	3\n42	12	6	6\n42	12	6	4\n42	12	9	9\n42	12	9	3\n42	12	10	10\n42	12	10	1\n42	12	12	12\n42	12	12	1\n42	12	13	13\n42	12	13	5\n42	12	15	15\n42	12	15	3\n42	13	6	6\n42	13	6	4\n42	13	9	9\n42	13	9	3\n42	13	10	10\n42	13	10	1\n42	13	12	10\n42	13	12	1\n42	13	13	13\n42	13	13	5\n42	13	15	15\n42	13	15	3\n42	14	6	6\n42	14	6	4\n42	14	9	9\n42	14	9	3\n42	14	10	10\n42	14	10	2\n42	14	13	13\n42	14	13	5\n42	14	15	15\n42	14	15	3\n42	15	6	6	9\n42	15	6	3	1\n42	15	9	9\n42	15	9	3\n42	15	10	10\n42	15	10	2\n42	15	13	6	13\n42	15	13	1	4\n42	15	15	6	15\n42	15	15	1	2\n42	16	6	6\n42	16	6	5\n42	16	9	9\n42	16	9	4\n42	16	10	10\n42	16	10	2\n42	16	13	6	13\n42	16	13	1	3\n42	16	15	15\n42	16	15	2\n42	17	6	6\n42	17	6	6\n42	17	9	9\n42	17	9	4\n42	17	10	10\n42	17	10	2\n42	17	13	6	13\n42	17	13	1	2\n42	17	15	15\n42	17	15	2\n42	18	6	6\n42	18	6	7\n42	18	9	9\n42	18	9	4\n42	18	10	10\n42	18	10	2\n42	18	13	13\n42	18	13	2\n42	18	15	15\n42	18	15	2\n42	19	6	6\n42	19	6	7\n42	19	9	9\n42	19	9	4\n42	19	10	10\n42	19	10	2\n42	19	13	13\n42	19	13	2\n42	19	15	15\n42	19	15	2\n42	20	6	6\n42	20	6	7\n42	20	9	9\n42	20	9	4\n42	20	10	10\n42	20	10	2\n42	20	13	13\n42	20	13	2\n42	20	15	15\n42	20	15	2\n42	21	6	6	9\n42	21	6	6	1\n42	21	9	9\n42	21	9	4\n42	21	10	10\n42	21	10	2\n42	21	13	13\n42	21	13	2\n42	21	15	15\n42	21	15	2\n42	22	6	6\n42	22	6	6\n42	22	9	9\n42	22	9	5\n42	22	10	10\n42	22	10	2\n42	22	13	13\n42	22	13	2\n42	22	15	15\n42	22	15	2\n42	23	6	6\n42	23	6	6\n42	23	9	9\n42	23	9	5\n42	23	10	10\n42	23	10	2\n42	23	13	6	13\n42	23	13	1	1\n42	23	15	15\n42	23	15	2\n42	24	6	6	9\n42	24	6	5	2\n42	24	9	9\n42	24	9	5\n42	24	10	10\n42	24	10	2\n42	24	13	6\n42	24	13	1\n42	24	15	6	15\n42	24	15	1	1\n42	25	6	6\n42	25	6	7\n42	25	9	9\n42	25	9	7\n42	25	10	10\n42	25	10	2\n42	25	15	9\n42	25	15	1\n42	26	6	6\n42	26	6	7\n42	26	9	9\n42	26	9	8\n42	26	10	10	12\n42	26	10	1	1\n42	27	6	6\n42	27	6	7\n42	27	9	6	9\n42	27	9	1	7\n42	27	10	10\n42	27	10	1\n42	27	12	12\n42	27	12	1\n42	28	6	6\n42	28	6	8\n42	28	9	6	9\n42	28	9	2	5\n42	28	10	10\n42	28	10	1\n42	28	12	12\n42	28	12	1\n42	29	6	6\n42	29	6	10\n42	29	9	9\n42	29	9	5\n42	29	10	10\n42	29	10	1\n42	29	12	12\n42	29	12	1\n42	30	6	6\n42	30	6	10\n42	30	9	9\n42	30	9	5\n42	30	10	10\n42	30	10	1\n42	30	12	12\n42	30	12	1\n42	31	6	6\n42	31	6	10\n42	31	9	9\n42	31	9	5\n42	31	10	10\n42	31	10	1\n42	31	12	12\n42	31	12	1\n42	32	6	6\n42	32	6	10\n42	32	9	6	9\n42	32	9	1	4\n42	32	10	10\n42	32	10	1\n42	32	12	12\n42	32	12	1\n42	33	6	6\n42	33	6	11\n42	33	9	9\n42	33	9	4\n42	33	10	10\n42	33	10	1\n42	33	12	12\n42	33	12	1\n42	34	6	6\n42	34	6	11\n42	34	9	9\n42	34	9	4\n42	34	10	10\n42	34	10	1\n42	34	12	12\n42	34	12	1\n42	35	6	6\n42	35	6	11\n42	35	9	9\n42	35	9	4\n42	35	10	10\n42	35	10	1\n42	35	12	12\n42	35	12	1\n42	36	6	6\n42	36	6	11\n42	36	9	9\n42	36	9	4\n42	36	10	10\n42	36	10	1\n42	36	12	12\n42	36	12	1\n42	37	6	6\n42	37	6	11\n42	37	9	9\n42	37	9	4\n42	37	10	10\n42	37	10	1\n42	37	12	12\n42	37	12	1\n42	38	6	6\n42	38	6	11\n42	38	9	9\n42	38	9	4\n42	38	10	10\n42	38	10	1\n42	38	12	12\n42	38	12	1\n42	39	6	6\n42	39	6	11\n42	39	9	9\n42	39	9	4\n42	39	10	10\n42	39	10	1\n42	39	12	12\n42	39	12	1\n42	40	6	6\n42	40	6	11\n42	40	9	6	9\n42	40	9	2	2\n42	40	10	10\n42	40	10	1\n42	40	12	12\n42	40	12	1\n42	41	6	6\n42	41	6	13\n42	41	9	6\n42	41	9	2\n42	41	10	10\n42	41	10	1\n42	41	12	10\n42	41	12	1\n43	1	6	6\n43	1	6	2\n43	1	8	8\n43	1	8	1\n43	1	9	9\n43	1	9	3\n43	1	11	11\n43	1	11	5\n43	1	13	13\n43	1	13	6\n43	1	14	14\n43	1	14	2\n43	1	15	15\n43	1	15	5\n43	2	6	6	9\n43	2	6	1	1\n43	2	8	8\n43	2	8	1\n43	2	9	9\n43	2	9	3\n43	2	11	11\n43	2	11	5\n43	2	13	13\n43	2	13	6\n43	2	14	14\n43	2	14	2\n43	2	15	15\n43	2	15	5\n43	3	6	6\n43	3	6	1\n43	3	8	8\n43	3	8	1\n43	3	9	9\n43	3	9	4\n43	3	11	11\n43	3	11	5\n43	3	13	13\n43	3	13	6\n43	3	14	14\n43	3	14	2\n43	3	15	15\n43	3	15	5\n43	4	6	6\n43	4	6	1\n43	4	8	8\n43	4	8	1\n43	4	9	9\n43	4	9	4\n43	4	11	11\n43	4	11	5\n43	4	13	13\n43	4	13	6\n43	4	14	14\n43	4	14	2\n43	4	15	15\n43	4	15	5\n43	5	6	6\n43	5	6	1\n43	5	8	8\n43	5	8	1\n43	5	9	9\n43	5	9	4\n43	5	11	11\n43	5	11	5\n43	5	13	13\n43	5	13	6\n43	5	14	14\n43	5	14	2\n43	5	15	15\n43	5	15	5\n43	6	6	6\n43	6	6	1\n43	6	8	8\n43	6	8	1\n43	6	9	9	10\n43	6	9	3	1\n43	6	11	11\n43	6	11	5\n43	6	13	13\n43	6	13	6\n43	6	14	14\n43	6	14	2\n43	6	15	15\n43	6	15	5\n43	7	6	6\n43	7	6	1\n43	7	8	8\n43	7	8	1\n43	7	9	9\n43	7	9	3\n43	7	10	10\n43	7	10	1\n43	7	11	11\n43	7	11	5\n43	7	13	13\n43	7	13	6\n43	7	14	14\n43	7	14	2\n43	7	15	15\n43	7	15	5\n43	8	6	6\n43	8	6	1\n43	8	8	8\n43	8	8	1\n43	8	9	9\n43	8	9	3\n43	8	10	10\n43	8	10	1\n43	8	11	11\n43	8	11	5\n43	8	13	13\n43	8	13	6\n43	8	14	14\n43	8	14	2\n43	8	15	15\n43	8	15	5\n43	9	6	6\n43	9	6	1\n43	9	8	8\n43	9	8	1\n43	9	9	9\n43	9	9	3\n43	9	10	9\n43	9	10	1\n43	9	11	11\n43	9	11	5\n43	9	13	13\n43	9	13	6\n43	9	14	14\n43	9	14	2\n43	9	15	15\n43	9	15	5\n43	10	6	6\n43	10	6	1\n43	10	8	8\n43	10	8	1\n43	10	9	9\n43	10	9	4\n43	10	11	11\n43	10	11	5\n43	10	13	13\n43	10	13	6\n43	10	14	14\n43	10	14	2\n43	10	15	9	15\n43	10	15	1	4\n43	11	6	6\n43	11	6	1\n43	11	8	8\n43	11	8	1\n43	11	9	9\n43	11	9	5\n43	11	11	11\n43	11	11	5\n43	11	13	13\n43	11	13	6\n43	11	14	14\n43	11	14	2\n43	11	15	15\n43	11	15	4\n43	12	6	6\n43	12	6	1\n43	12	8	8\n43	12	8	1\n43	12	9	9\n43	12	9	5\n43	12	11	11\n43	12	11	5\n43	12	13	13\n43	12	13	6\n43	12	14	14\n43	12	14	2\n43	12	15	15\n43	12	15	4\n43	13	6	6\n43	13	6	1\n43	13	8	8\n43	13	8	1\n43	13	9	9\n43	13	9	5\n43	13	11	11	12\n43	13	11	4	1\n43	13	13	13\n43	13	13	6\n43	13	14	14\n43	13	14	2\n43	13	15	15\n43	13	15	4\n43	14	6	6\n43	14	6	1\n43	14	8	8\n43	14	8	1\n43	14	9	7	9\n43	14	9	1	4\n43	14	11	11\n43	14	11	4\n43	14	12	12\n43	14	12	1\n43	14	13	13\n43	14	13	6\n43	14	14	14\n43	14	14	2\n43	14	15	6	15\n43	14	15	1	3\n43	15	6	6\n43	15	6	2\n43	15	7	7\n43	15	7	1\n43	15	8	8\n43	15	8	1\n43	15	9	6	9\n43	15	9	1	3\n43	15	11	11\n43	15	11	4\n43	15	12	12\n43	15	12	1\n43	15	13	9	13\n43	15	13	1	5\n43	15	14	14\n43	15	14	2\n43	15	15	15\n43	15	15	3\n43	16	6	6\n43	16	6	3\n43	16	7	6\n43	16	7	1\n43	16	8	6\n43	16	8	1\n43	16	9	9\n43	16	9	4\n43	16	11	11	12\n43	16	11	3	1\n43	16	12	12\n43	16	12	1\n43	16	13	13\n43	16	13	5\n43	16	14	14\n43	16	14	2\n43	16	15	15\n43	16	15	3\n43	17	6	6\n43	17	6	5\n43	17	9	9\n43	17	9	4\n43	17	11	11\n43	17	11	3\n43	17	12	12\n43	17	12	2\n43	17	13	13\n43	17	13	5\n43	17	14	14\n43	17	14	2\n43	17	15	15\n43	17	15	3\n43	18	6	6	9\n43	18	6	4	1\n43	18	9	9\n43	18	9	4\n43	18	11	11\n43	18	11	3\n43	18	12	12\n43	18	12	2\n43	18	13	13	15\n43	18	13	4	1\n43	18	14	14\n43	18	14	2\n43	18	15	15\n43	18	15	3\n43	19	6	6\n43	19	6	4\n43	19	9	9\n43	19	9	5\n43	19	11	11\n43	19	11	3\n43	19	12	12\n43	19	12	2\n43	19	13	13\n43	19	13	4\n43	19	14	14\n43	19	14	2\n43	19	15	15\n43	19	15	4\n43	20	6	6\n43	20	6	4\n43	20	9	9\n43	20	9	5\n43	20	11	11\n43	20	11	3\n43	20	12	12\n43	20	12	2\n43	20	13	6	13\n43	20	13	1	3\n43	20	14	14\n43	20	14	2\n43	20	15	15\n43	20	15	4\n43	21	6	6\n43	21	6	5\n43	21	9	6	9\n43	21	9	1	4\n43	21	11	6	11\n43	21	11	1	2\n43	21	12	12\n43	21	12	2\n43	21	13	13\n43	21	13	3\n43	21	14	14\n43	21	14	2\n43	21	15	15\n43	21	15	4\n43	22	6	6\n43	22	6	7\n43	22	9	9\n43	22	9	4\n43	22	11	11\n43	22	11	2\n43	22	12	12\n43	22	12	2\n43	22	13	13\n43	22	13	3\n43	22	14	14\n43	22	14	2\n43	22	15	15\n43	22	15	4\n43	23	6	6\n43	23	6	7\n43	23	9	9\n43	23	9	4\n43	23	11	9	11\n43	23	11	1	1\n43	23	12	12\n43	23	12	2\n43	23	13	13\n43	23	13	3\n43	23	14	14\n43	23	14	2\n43	23	15	6	15\n43	23	15	1	3\n43	24	6	6\n43	24	6	8\n43	24	9	9\n43	24	9	5\n43	24	11	11\n43	24	11	1\n43	24	12	12\n43	24	12	2\n43	24	13	9	13\n43	24	13	1	2\n43	24	14	14\n43	24	14	2\n43	24	15	6	15\n43	24	15	1	2\n43	25	6	6\n43	25	6	9\n43	25	9	6	9\n43	25	9	1	5\n43	25	11	6\n43	25	11	1\n43	25	12	12\n43	25	12	2\n43	25	13	6	13\n43	25	13	1	1\n43	25	14	14\n43	25	14	2\n43	25	15	15\n43	25	15	2\n43	26	6	6\n43	26	6	12\n43	26	9	9	10\n43	26	9	4	1\n43	26	12	12\n43	26	12	2\n43	26	13	6\n43	26	13	1\n43	26	14	8	14\n43	26	14	1	1\n43	26	15	9	15\n43	26	15	1	1\n43	27	6	6\n43	27	6	13\n43	27	8	8\n43	27	8	1\n43	27	9	9\n43	27	9	5\n43	27	10	10\n43	27	10	1\n43	27	12	12\n43	27	12	2\n43	27	14	9\n43	27	14	1\n43	27	15	9\n43	27	15	1\n43	28	6	6\n43	28	6	13\n43	28	8	8\n43	28	8	1\n43	28	9	9\n43	28	9	7\n43	28	10	10\n43	28	10	1\n43	28	12	12\n43	28	12	2\n43	29	6	6\n43	29	6	13\n43	29	8	8\n43	29	8	1\n43	29	9	6	9\n43	29	9	2	5\n43	29	10	10\n43	29	10	1\n43	29	12	10	12\n43	29	12	1	1\n43	30	6	6\n43	30	6	15\n43	30	8	8\n43	30	8	1\n43	30	9	9\n43	30	9	5\n43	30	10	10\n43	30	10	2\n43	30	12	12\n43	30	12	1\n43	31	6	6\n43	31	6	15\n43	31	8	8\n43	31	8	1\n43	31	9	9\n43	31	9	5\n43	31	10	10\n43	31	10	2\n43	31	12	12\n43	31	12	1\n43	32	6	6\n43	32	6	15\n43	32	8	8\n43	32	8	1\n43	32	9	9\n43	32	9	5\n43	32	10	10\n43	32	10	2\n43	32	12	12\n43	32	12	1\n43	33	6	6\n43	33	6	15\n43	33	8	8\n43	33	8	1\n43	33	9	9\n43	33	9	5\n43	33	10	10\n43	33	10	2\n43	33	12	12\n43	33	12	1\n43	34	6	6\n43	34	6	15\n43	34	8	8\n43	34	8	1\n43	34	9	9\n43	34	9	5\n43	34	10	10\n43	34	10	2\n43	34	12	10\n43	34	12	1\n43	35	6	6\n43	35	6	15\n43	35	8	8\n43	35	8	1\n43	35	9	9\n43	35	9	5\n43	35	10	10\n43	35	10	3\n43	36	6	6\n43	36	6	15\n43	36	8	8\n43	36	8	1\n43	36	9	9\n43	36	9	5\n43	36	10	10\n43	36	10	3\n43	37	6	6\n43	37	6	15\n43	37	8	8\n43	37	8	1\n43	37	9	9\n43	37	9	5\n43	37	10	10\n43	37	10	3\n43	38	6	6\n43	38	6	15\n43	38	8	8\n43	38	8	1\n43	38	9	9\n43	38	9	5\n43	38	10	10\n43	38	10	3\n43	39	6	6\n43	39	6	15\n43	39	8	8\n43	39	8	1\n43	39	9	9\n43	39	9	5\n43	39	10	10\n43	39	10	3\n43	40	6	6\n43	40	6	15\n43	40	8	8\n43	40	8	1\n43	40	9	9\n43	40	9	5\n43	40	10	10\n43	40	10	3\n43	41	6	6\n43	41	6	15\n43	41	8	8\n43	41	8	1\n43	41	9	6	9\n43	41	9	1	4\n43	41	10	10\n43	41	10	3\n43	42	6	6\n43	42	6	16\n43	42	8	8\n43	42	8	1\n43	42	9	6	9\n43	42	9	1	3\n43	42	10	10\n43	42	10	3\n44	1	6	6\n44	1	6	1\n44	1	9	9\n44	1	9	1\n44	1	13	13\n44	1	13	1\n44	1	15	15\n44	1	15	3\n44	1	16	16\n44	1	16	1\n44	2	6	6\n44	2	6	1\n44	2	9	9\n44	2	9	1\n44	2	13	13\n44	2	13	1\n44	2	15	15\n44	2	15	3\n44	2	16	20\n44	2	16	1\n44	3	6	6\n44	3	6	1\n44	3	9	9\n44	3	9	1\n44	3	13	13\n44	3	13	1\n44	3	15	13	15\n44	3	15	1	2\n44	3	20	20\n44	3	20	1\n44	4	6	6\n44	4	6	1\n44	4	9	9\n44	4	9	1\n44	4	13	13\n44	4	13	2\n44	4	15	15\n44	4	15	2\n44	4	20	20\n44	4	20	1\n44	5	6	6\n44	5	6	1\n44	5	9	9\n44	5	9	1\n44	5	13	13\n44	5	13	2\n44	5	15	15\n44	5	15	2\n44	5	20	20\n44	5	20	1\n44	6	6	6\n44	6	6	1\n44	6	9	9\n44	6	9	1\n44	6	13	13\n44	6	13	2\n44	6	15	15\n44	6	15	2\n44	6	20	20\n44	6	20	1\n44	7	6	6\n44	7	6	1\n44	7	9	9\n44	7	9	1\n44	7	13	13\n44	7	13	2\n44	7	15	15\n44	7	15	2\n44	7	20	20\n44	7	20	1\n44	8	6	6\n44	8	6	1\n44	8	9	9\n44	8	9	1\n44	8	13	13\n44	8	13	2\n44	8	15	15\n44	8	15	2\n44	8	20	20\n44	8	20	1\n44	9	6	6\n44	9	6	1\n44	9	9	9\n44	9	9	1\n44	9	13	13\n44	9	13	2\n44	9	15	15\n44	9	15	2\n44	9	20	20\n44	9	20	1\n44	10	6	6\n44	10	6	1\n44	10	9	9\n44	10	9	1\n44	10	13	13\n44	10	13	2\n44	10	15	15\n44	10	15	2\n44	10	20	20\n44	10	20	1\n44	11	6	6\n44	11	6	1\n44	11	9	9\n44	11	9	1\n44	11	13	13\n44	11	13	2\n44	11	15	6	15\n44	11	15	1	1\n44	11	20	20\n44	11	20	1\n44	12	6	6\n44	12	6	2\n44	12	9	9\n44	12	9	1\n44	12	13	13\n44	12	13	2\n44	12	15	15\n44	12	15	1\n44	12	20	20\n44	12	20	1\n44	13	6	6\n44	13	6	2\n44	13	9	9\n44	13	9	1\n44	13	13	13\n44	13	13	2\n44	13	15	15\n44	13	15	1\n44	13	20	20\n44	13	20	1\n44	14	6	6\n44	14	6	2\n44	14	9	9\n44	14	9	1\n44	14	13	13\n44	14	13	2\n44	14	15	15\n44	14	15	1\n44	14	20	20\n44	14	20	1\n44	15	6	6\n44	15	6	2\n44	15	9	9\n44	15	9	1\n44	15	13	13\n44	15	13	2\n44	15	15	15\n44	15	15	1\n44	15	20	20\n44	15	20	1\n44	16	6	6\n44	16	6	2\n44	16	9	9\n44	16	9	1\n44	16	13	13\n44	16	13	2\n44	16	15	15\n44	16	15	1\n44	16	20	20\n44	16	20	1\n44	17	6	6\n44	17	6	2\n44	17	9	9\n44	17	9	1\n44	17	13	6	13\n44	17	13	1	1\n44	17	15	15\n44	17	15	1\n44	17	20	20\n44	17	20	1\n44	18	6	6\n44	18	6	3\n44	18	9	9\n44	18	9	1\n44	18	13	13\n44	18	13	1\n44	18	15	15\n44	18	15	1\n44	18	20	20\n44	18	20	1\n44	19	6	6\n44	19	6	3\n44	19	9	9\n44	19	9	1\n44	19	13	13\n44	19	13	1\n44	19	15	15\n44	19	15	1\n44	19	20	20\n44	19	20	1\n44	20	6	6\n44	20	6	3\n44	20	9	9\n44	20	9	1\n44	20	13	13\n44	20	13	1\n44	20	15	15\n44	20	15	1\n44	20	20	20\n44	20	20	1\n44	21	6	6\n44	21	6	3\n44	21	9	9\n44	21	9	1\n44	21	13	13\n44	21	13	1\n44	21	15	15\n44	21	15	1\n44	21	20	20\n44	21	20	1\n44	22	6	6\n44	22	6	3\n44	22	9	9\n44	22	9	1\n44	22	13	13\n44	22	13	1\n44	22	15	15\n44	22	15	1\n44	22	20	20\n44	22	20	1\n44	23	6	6\n44	23	6	3\n44	23	9	9\n44	23	9	1\n44	23	13	13\n44	23	13	1\n44	23	15	15\n44	23	15	1\n44	23	20	20\n44	23	20	1\n44	24	6	6\n44	24	6	3\n44	24	9	9\n44	24	9	1\n44	24	13	9\n44	24	13	1\n44	24	15	6\n44	24	15	1\n44	24	20	16\n44	24	20	1\n44	25	6	6\n44	25	6	4\n44	25	9	9\n44	25	9	2\n44	25	16	16\n44	25	16	1\n44	26	6	6\n44	26	6	4\n44	26	9	9\n44	26	9	2\n44	26	16	8\n44	26	16	1\n44	27	6	6\n44	27	6	4\n44	27	8	8\n44	27	8	1\n44	27	9	9\n44	27	9	2\n44	28	6	6\n44	28	6	4\n44	28	8	8\n44	28	8	1\n44	28	9	9\n44	28	9	2\n44	29	6	6\n44	29	6	4\n44	29	8	8\n44	29	8	1\n44	29	9	9\n44	29	9	2\n44	30	6	6\n44	30	6	4\n44	30	8	8\n44	30	8	1\n44	30	9	6	9\n44	30	9	1	1\n44	31	6	6\n44	31	6	5\n44	31	8	8\n44	31	8	1\n44	31	9	9\n44	31	9	1\n44	32	6	6\n44	32	6	5\n44	32	8	8\n44	32	8	1\n44	32	9	9\n44	32	9	1\n44	33	6	6\n44	33	6	5\n44	33	8	8\n44	33	8	1\n44	33	9	9\n44	33	9	1\n44	34	6	6\n44	34	6	5\n44	34	8	8\n44	34	8	1\n44	34	9	9\n44	34	9	1\n44	35	6	6\n44	35	6	5\n44	35	8	8\n44	35	8	1\n44	35	9	9\n44	35	9	1\n44	36	6	6\n44	36	6	5\n44	36	8	8\n44	36	8	1\n44	36	9	9\n44	36	9	1\n44	37	6	6\n44	37	6	5\n44	37	8	8\n44	37	8	1\n44	37	9	9\n44	37	9	1\n44	38	6	6\n44	38	6	5\n44	38	8	8\n44	38	8	1\n44	38	9	9\n44	38	9	1\n44	39	6	6\n44	39	6	5\n44	39	8	8\n44	39	8	1\n44	39	9	9\n44	39	9	1\n44	40	6	6\n44	40	6	5\n44	40	8	8\n44	40	8	1\n44	40	9	9\n44	40	9	1\n44	41	6	6\n44	41	6	5\n44	41	8	8\n44	41	8	1\n44	41	9	9\n44	41	9	1\n44	42	6	6\n44	42	6	5\n44	42	8	8\n44	42	8	1\n44	42	9	9\n44	42	9	1\n44	43	6	6\n44	43	6	5\n44	43	8	8\n44	43	8	1\n44	43	9	9\n44	43	9	1\n45	1	9	9\n45	1	9	1\n45	1	10	7\n45	1	10	1\n45	1	12	14\n45	1	12	1\n45	1	13	13\n45	1	13	6\n45	1	14	14\n45	1	14	1\n45	1	15	15\n45	1	15	3\n45	2	7	7\n45	2	7	1\n45	2	9	9\n45	2	9	1\n45	2	13	13\n45	2	13	6\n45	2	14	14\n45	2	14	2\n45	2	15	15\n45	2	15	3\n45	3	7	7\n45	3	7	1\n45	3	9	9\n45	3	9	1\n45	3	13	13\n45	3	13	6\n45	3	14	14\n45	3	14	2\n45	3	15	15\n45	3	15	3\n45	4	7	7\n45	4	7	1\n45	4	9	9\n45	4	9	1\n45	4	13	13\n45	4	13	6\n45	4	14	14\n45	4	14	2\n45	4	15	15\n45	4	15	3\n45	5	7	7\n45	5	7	1\n45	5	9	9\n45	5	9	1\n45	5	13	13\n45	5	13	6\n45	5	14	14\n45	5	14	2\n45	5	15	15\n45	5	15	3\n45	6	7	7\n45	6	7	1\n45	6	9	9\n45	6	9	1\n45	6	13	13\n45	6	13	6\n45	6	14	14\n45	6	14	2\n45	6	15	15\n45	6	15	3\n45	7	7	7\n45	7	7	1\n45	7	9	9\n45	7	9	1\n45	7	13	13\n45	7	13	6\n45	7	14	14\n45	7	14	2\n45	7	15	15\n45	7	15	3\n45	8	7	7\n45	8	7	1\n45	8	9	9\n45	8	9	1\n45	8	13	13\n45	8	13	6\n45	8	14	14\n45	8	14	2\n45	8	15	15\n45	8	15	3\n45	9	7	7\n45	9	7	1\n45	9	9	9\n45	9	9	1\n45	9	13	13\n45	9	13	6\n45	9	14	14\n45	9	14	2\n45	9	15	15\n45	9	15	3\n45	10	7	7\n45	10	7	1\n45	10	9	9\n45	10	9	1\n45	10	13	13\n45	10	13	6\n45	10	14	14\n45	10	14	2\n45	10	15	15\n45	10	15	3\n45	11	7	7\n45	11	7	1\n45	11	9	9\n45	11	9	1\n45	11	13	13\n45	11	13	6\n45	11	14	14\n45	11	14	2\n45	11	15	15\n45	11	15	3\n45	12	7	7\n45	12	7	1\n45	12	9	9\n45	12	9	1\n45	12	13	13\n45	12	13	6\n45	12	14	6	14\n45	12	14	1	1\n45	12	15	15\n45	12	15	3\n45	13	6	6\n45	13	6	1\n45	13	7	7\n45	13	7	1\n45	13	9	9\n45	13	9	1\n45	13	13	13\n45	13	13	6\n45	13	14	14\n45	13	14	1\n45	13	15	6	15\n45	13	15	1	2\n45	14	6	6\n45	14	6	2\n45	14	7	7\n45	14	7	1\n45	14	9	9\n45	14	9	1\n45	14	13	13\n45	14	13	6\n45	14	14	14\n45	14	14	1\n45	14	15	15\n45	14	15	2\n45	15	6	6\n45	15	6	2\n45	15	7	7\n45	15	7	1\n45	15	9	9\n45	15	9	1\n45	15	13	6	13\n45	15	13	1	5\n45	15	14	14\n45	15	14	1\n45	15	15	15\n45	15	15	2\n45	16	6	6\n45	16	6	3\n45	16	7	7\n45	16	7	1\n45	16	9	9\n45	16	9	1\n45	16	13	13\n45	16	13	5\n45	16	14	14\n45	16	14	1\n45	16	15	15\n45	16	15	2\n45	17	6	6\n45	17	6	3\n45	17	7	7\n45	17	7	1\n45	17	9	9\n45	17	9	1\n45	17	13	13\n45	17	13	5\n45	17	14	13\n45	17	14	1\n45	17	15	15\n45	17	15	2\n45	18	6	6\n45	18	6	3\n45	18	7	7\n45	18	7	1\n45	18	9	9\n45	18	9	1\n45	18	13	6	13\n45	18	13	1	5\n45	18	15	6	15\n45	18	15	1	1\n45	19	6	6\n45	19	6	5\n45	19	7	7\n45	19	7	1\n45	19	9	9\n45	19	9	1\n45	19	13	13\n45	19	13	5\n45	19	15	15\n45	19	15	1\n45	20	6	6\n45	20	6	5\n45	20	7	7\n45	20	7	1\n45	20	9	9\n45	20	9	1\n45	20	13	13\n45	20	13	5\n45	20	15	9\n45	20	15	1\n45	21	6	6\n45	21	6	5\n45	21	7	7\n45	21	7	1\n45	21	9	9\n45	21	9	2\n45	21	13	13\n45	21	13	5\n45	22	6	6\n45	22	6	5\n45	22	7	7\n45	22	7	1\n45	22	9	9\n45	22	9	2\n45	22	13	13\n45	22	13	5\n45	23	6	6\n45	23	6	5\n45	23	7	7\n45	23	7	1\n45	23	9	6	9\n45	23	9	1	1\n45	23	13	6	13\n45	23	13	1	4\n45	24	6	6\n45	24	6	7\n45	24	7	6\n45	24	7	1\n45	24	9	9\n45	24	9	1\n45	24	13	13\n45	24	13	4\n45	25	6	6	9\n45	25	6	7	1\n45	25	9	9\n45	25	9	1\n45	25	13	13\n45	25	13	4\n45	26	6	6\n45	26	6	7\n45	26	9	9\n45	26	9	2\n45	26	13	6	13\n45	26	13	2	2\n45	27	6	6\n45	27	6	9\n45	27	9	9\n45	27	9	2\n45	27	13	6	11\n45	27	13	1	1\n45	28	6	6\n45	28	6	10\n45	28	9	9\n45	28	9	2\n45	28	11	11\n45	28	11	1\n45	29	6	6	9\n45	29	6	9	1\n45	29	9	9\n45	29	9	2\n45	29	11	11\n45	29	11	1\n45	30	6	6\n45	30	6	9\n45	30	9	9\n45	30	9	3\n45	30	11	6\n45	30	11	1\n45	31	6	6\n45	31	6	10\n45	31	9	9\n45	31	9	3\n45	32	6	6	9\n45	32	6	9	1\n45	32	9	9\n45	32	9	3\n45	33	6	6\n45	33	6	9\n45	33	9	9\n45	33	9	4\n45	34	6	6\n45	34	6	9\n45	34	9	9\n45	34	9	4\n45	35	6	6\n45	35	6	9\n45	35	9	9\n45	35	9	4\n45	36	6	6	9\n45	36	6	8	1\n45	36	9	9\n45	36	9	4\n45	37	6	6	9\n45	37	6	7	1\n45	37	9	9\n45	37	9	5\n45	38	6	6\n45	38	6	7\n45	38	9	9\n45	38	9	6\n45	39	6	6\n45	39	6	7\n45	39	9	9\n45	39	9	6\n45	40	6	6\n45	40	6	7\n45	40	9	9\n45	40	9	6\n45	41	6	6\n45	41	6	7\n45	41	9	9\n45	41	9	6\n45	42	6	6\n45	42	6	7\n45	42	9	9\n45	42	9	6\n45	43	6	6\n45	43	6	7\n45	43	9	6	9\n45	43	9	2	4\n45	44	6	6\n45	44	6	9\n45	44	9	6	9\n45	44	9	2	2\n46	1	9	9\n46	1	9	1\n46	1	12	12\n46	1	12	2\n46	1	13	13\n46	1	13	1\n46	1	14	14\n46	1	14	1\n46	2	9	9\n46	2	9	1\n46	2	12	12\n46	2	12	2\n46	2	13	13\n46	2	13	1\n46	2	14	14\n46	2	14	1\n46	3	9	9\n46	3	9	1\n46	3	12	12\n46	3	12	2\n46	3	13	13\n46	3	13	1\n46	3	14	14\n46	3	14	1\n46	4	9	9\n46	4	9	1\n46	4	12	12\n46	4	12	2\n46	4	13	13\n46	4	13	1\n46	4	14	14\n46	4	14	1\n46	5	9	9\n46	5	9	1\n46	5	12	12\n46	5	12	2\n46	5	13	13\n46	5	13	1\n46	5	14	14\n46	5	14	1\n46	6	9	9\n46	6	9	1\n46	6	12	12\n46	6	12	2\n46	6	13	13\n46	6	13	1\n46	6	14	14\n46	6	14	1\n46	7	9	9\n46	7	9	1\n46	7	12	12\n46	7	12	2\n46	7	13	13\n46	7	13	1\n46	7	14	14\n46	7	14	1\n46	8	9	9\n46	8	9	1\n46	8	12	12\n46	8	12	2\n46	8	13	13\n46	8	13	1\n46	8	14	14\n46	8	14	1\n46	9	9	9\n46	9	9	1\n46	9	12	12\n46	9	12	2\n46	9	13	13\n46	9	13	1\n46	9	14	14\n46	9	14	1\n46	10	9	9\n46	10	9	1\n46	10	12	12\n46	10	12	2\n46	10	13	13\n46	10	13	1\n46	10	14	14\n46	10	14	1\n46	11	9	9\n46	11	9	1\n46	11	12	12\n46	11	12	2\n46	11	13	13\n46	11	13	1\n46	11	14	14\n46	11	14	1\n46	12	9	9\n46	12	9	1\n46	12	12	12\n46	12	12	2\n46	12	13	13\n46	12	13	1\n46	12	14	14\n46	12	14	1\n46	13	9	9\n46	13	9	1\n46	13	12	12\n46	13	12	2\n46	13	13	13\n46	13	13	1\n46	13	14	14\n46	13	14	1\n46	14	9	9\n46	14	9	1\n46	14	12	12\n46	14	12	2\n46	14	13	13\n46	14	13	1\n46	14	14	14\n46	14	14	1\n46	15	9	9\n46	15	9	1\n46	15	12	12\n46	15	12	2\n46	15	13	13\n46	15	13	1\n46	15	14	14\n46	15	14	1\n46	16	9	9\n46	16	9	1\n46	16	12	12\n46	16	12	2\n46	16	13	13\n46	16	13	1\n46	16	14	14\n46	16	14	1\n46	17	9	9\n46	17	9	1\n46	17	12	10	12\n46	17	12	1	1\n46	17	13	13\n46	17	13	1\n46	17	14	14\n46	17	14	1\n46	18	9	9\n46	18	9	1\n46	18	10	10\n46	18	10	1\n46	18	12	12\n46	18	12	1\n46	18	13	13\n46	18	13	1\n46	18	14	14\n46	18	14	1\n46	19	9	9\n46	19	9	1\n46	19	10	10\n46	19	10	1\n46	19	12	12\n46	19	12	1\n46	19	13	13\n46	19	13	1\n46	19	14	14\n46	19	14	1\n46	20	9	9\n46	20	9	1\n46	20	10	10\n46	20	10	1\n46	20	12	12\n46	20	12	1\n46	20	13	13\n46	20	13	1\n46	20	14	14\n46	20	14	1\n46	21	9	9\n46	21	9	1\n46	21	10	10\n46	21	10	1\n46	21	12	12\n46	21	12	1\n46	21	13	13\n46	21	13	1\n46	21	14	14\n46	21	14	1\n46	22	9	9\n46	22	9	1\n46	22	10	10\n46	22	10	1\n46	22	12	12\n46	22	12	1\n46	22	13	13\n46	22	13	1\n46	22	14	14\n46	22	14	1\n46	23	9	9\n46	23	9	1\n46	23	10	10\n46	23	10	1\n46	23	12	12\n46	23	12	1\n46	23	13	13\n46	23	13	1\n46	23	14	14\n46	23	14	1\n46	24	9	9\n46	24	9	1\n46	24	10	10\n46	24	10	1\n46	24	12	12\n46	24	12	1\n46	24	13	13\n46	24	13	1\n46	24	14	14\n46	24	14	1\n46	25	9	6\n46	25	9	1\n46	25	10	10\n46	25	10	1\n46	25	12	12\n46	25	12	1\n46	25	13	13\n46	25	13	1\n46	25	14	14\n46	25	14	1\n46	26	6	6\n46	26	6	1\n46	26	10	10\n46	26	10	1\n46	26	12	12\n46	26	12	1\n46	26	13	13\n46	26	13	1\n46	26	14	14\n46	26	14	1\n46	27	6	6\n46	27	6	1\n46	27	10	10\n46	27	10	1\n46	27	12	12\n46	27	12	1\n46	27	13	6\n46	27	13	1\n46	27	14	14\n46	27	14	1\n46	28	6	6\n46	28	6	2\n46	28	10	10\n46	28	10	1\n46	28	12	12\n46	28	12	1\n46	28	14	14\n46	28	14	1\n46	29	6	6\n46	29	6	2\n46	29	10	10\n46	29	10	1\n46	29	12	12\n46	29	12	1\n46	29	14	8\n46	29	14	1\n46	30	6	6\n46	30	6	2\n46	30	8	8\n46	30	8	1\n46	30	10	10\n46	30	10	1\n46	30	12	12\n46	30	12	1\n46	31	6	6\n46	31	6	2\n46	31	8	9\n46	31	8	1\n46	31	10	10\n46	31	10	1\n46	31	12	12\n46	31	12	1\n46	32	6	6\n46	32	6	2\n46	32	9	9\n46	32	9	1\n46	32	10	10\n46	32	10	1\n46	32	12	10\n46	32	12	1\n46	33	6	6\n46	33	6	2\n46	33	9	9\n46	33	9	1\n46	33	10	10\n46	33	10	2\n46	34	6	6\n46	34	6	2\n46	34	9	9\n46	34	9	1\n46	34	10	10\n46	34	10	2\n46	35	6	6\n46	35	6	2\n46	35	9	9\n46	35	9	1\n46	35	10	10\n46	35	10	2\n46	36	6	6\n46	36	6	2\n46	36	9	9\n46	36	9	1\n46	36	10	10\n46	36	10	2\n46	37	6	6\n46	37	6	2\n46	37	9	9\n46	37	9	1\n46	37	10	10\n46	37	10	2\n46	38	6	6\n46	38	6	2\n46	38	9	9\n46	38	9	1\n46	38	10	10\n46	38	10	2\n46	39	6	6\n46	39	6	2\n46	39	9	9\n46	39	9	1\n46	39	10	10\n46	39	10	2\n46	40	6	6\n46	40	6	2\n46	40	9	9\n46	40	9	1\n46	40	10	10\n46	40	10	2\n46	41	6	6\n46	41	6	2\n46	41	9	9\n46	41	9	1\n46	41	10	10\n46	41	10	2\n46	42	6	6\n46	42	6	2\n46	42	9	9\n46	42	9	1\n46	42	10	10\n46	42	10	2\n46	43	6	6\n46	43	6	2\n46	43	9	9\n46	43	9	1\n46	43	10	10\n46	43	10	2\n46	44	6	6\n46	44	6	2\n46	44	9	9\n46	44	9	1\n46	44	10	10\n46	44	10	2\n46	45	6	6\n46	45	6	2\n46	45	9	8\n46	45	9	1\n46	45	10	10\n46	45	10	2\n47	1	13	13\n47	1	13	5\n47	2	13	13\n47	2	13	5\n47	3	13	13\n47	3	13	5\n47	4	13	13\n47	4	13	5\n47	5	13	13\n47	5	13	5\n47	6	13	13\n47	6	13	5\n47	7	13	13\n47	7	13	5\n47	8	13	13\n47	8	13	5\n47	9	13	13\n47	9	13	5\n47	10	13	13\n47	10	13	5\n47	11	13	13\n47	11	13	5\n47	12	13	13\n47	12	13	5\n47	13	13	13\n47	13	13	5\n47	14	13	13\n47	14	13	5\n47	15	13	13\n47	15	13	5\n47	16	13	13\n47	16	13	5\n47	17	13	13\n47	17	13	5\n47	18	13	13\n47	18	13	5\n47	19	13	6	13\n47	19	13	2	3\n47	20	6	6\n47	20	6	2\n47	20	13	11	13\n47	20	13	1	2\n47	21	6	6\n47	21	6	2\n47	21	11	11\n47	21	11	1\n47	21	13	6	13\n47	21	13	1	1\n47	22	6	6\n47	22	6	3\n47	22	11	11\n47	22	11	1\n47	22	13	13\n47	22	13	1\n47	23	6	6\n47	23	6	3\n47	23	11	11\n47	23	11	1\n47	23	13	13\n47	23	13	1\n47	24	6	6\n47	24	6	3\n47	24	11	6\n47	24	11	1\n47	24	13	13\n47	24	13	1\n47	25	6	6\n47	25	6	4\n47	25	13	13\n47	25	13	1\n47	26	6	6\n47	26	6	4\n47	26	13	13\n47	26	13	1\n47	27	6	6\n47	27	6	4\n47	27	13	13\n47	27	13	1\n47	28	6	6\n47	28	6	4\n47	28	13	6\n47	28	13	1\n47	29	6	6\n47	29	6	5\n47	30	6	6\n47	30	6	5\n47	31	6	6\n47	31	6	5\n47	32	6	6\n47	32	6	5\n47	33	6	6\n47	33	6	5\n47	34	6	6\n47	34	6	5\n47	35	6	6\n47	35	6	5\n47	36	6	6\n47	36	6	5\n47	37	6	6\n47	37	6	5\n47	38	6	6\n47	38	6	5\n47	39	6	6\n47	39	6	5\n47	40	6	6	9\n47	40	6	4	1\n47	41	6	6\n47	41	6	4\n47	41	9	9\n47	41	9	1\n47	42	6	6\n47	42	6	4\n47	42	9	9\n47	42	9	1\n47	43	6	6\n47	43	6	4\n47	43	9	9\n47	43	9	1\n47	44	6	6\n47	44	6	4\n47	44	9	9\n47	44	9	1\n47	45	6	6\n47	45	6	4\n47	45	9	9\n47	45	9	1\n47	46	6	6\n47	46	6	4\n47	46	9	6\n47	46	9	1\n48	1	11	11\n48	1	11	1\n48	1	12	12\n48	1	12	1\n48	1	13	13\n48	1	13	1\n48	1	15	15\n48	1	15	2\n48	2	11	11\n48	2	11	1\n48	2	12	12\n48	2	12	1\n48	2	13	13\n48	2	13	1\n48	2	15	15\n48	2	15	2\n48	3	11	11\n48	3	11	1\n48	3	12	12\n48	3	12	1\n48	3	13	13\n48	3	13	1\n48	3	15	15\n48	3	15	2\n48	4	11	11\n48	4	11	1\n48	4	12	12\n48	4	12	1\n48	4	13	13\n48	4	13	1\n48	4	15	13	15\n48	4	15	1	1\n48	5	11	11\n48	5	11	1\n48	5	12	12\n48	5	12	1\n48	5	13	13\n48	5	13	2\n48	5	15	15\n48	5	15	1\n48	6	11	11\n48	6	11	1\n48	6	12	12\n48	6	12	1\n48	6	13	13\n48	6	13	2\n48	6	15	15\n48	6	15	1\n48	7	11	11\n48	7	11	1\n48	7	12	12\n48	7	12	1\n48	7	13	13\n48	7	13	2\n48	7	15	15\n48	7	15	1\n48	8	11	11\n48	8	11	1\n48	8	12	12\n48	8	12	1\n48	8	13	13\n48	8	13	2\n48	8	15	15\n48	8	15	1\n48	9	11	11\n48	9	11	1\n48	9	12	12\n48	9	12	1\n48	9	13	13\n48	9	13	2\n48	9	15	15\n48	9	15	1\n48	10	11	11\n48	10	11	1\n48	10	12	12\n48	10	12	1\n48	10	13	13\n48	10	13	2\n48	10	15	15\n48	10	15	1\n48	11	11	11\n48	11	11	1\n48	11	12	12\n48	11	12	1\n48	11	13	6	13\n48	11	13	1	1\n48	11	15	15\n48	11	15	1\n48	12	6	6\n48	12	6	1\n48	12	11	6\n48	12	11	1\n48	12	12	12\n48	12	12	1\n48	12	13	13\n48	12	13	1\n48	12	15	15\n48	12	15	1\n48	13	6	6\n48	13	6	2\n48	13	12	12\n48	13	12	1\n48	13	13	13\n48	13	13	1\n48	13	15	15\n48	13	15	1\n48	14	6	6\n48	14	6	2\n48	14	12	12\n48	14	12	1\n48	14	13	13\n48	14	13	1\n48	14	15	15\n48	14	15	1\n48	15	6	6\n48	15	6	2\n48	15	12	12\n48	15	12	1\n48	15	13	13\n48	15	13	1\n48	15	15	15\n48	15	15	1\n48	16	6	6\n48	16	6	2\n48	16	12	12\n48	16	12	1\n48	16	13	13\n48	16	13	1\n48	16	15	15\n48	16	15	1\n48	17	6	6\n48	17	6	2\n48	17	12	12\n48	17	12	1\n48	17	13	13\n48	17	13	1\n48	17	15	15\n48	17	15	1\n48	18	6	6\n48	18	6	2\n48	18	12	12\n48	18	12	1\n48	18	13	6\n48	18	13	1\n48	18	15	15\n48	18	15	1\n48	19	6	6\n48	19	6	3\n48	19	12	12\n48	19	12	1\n48	19	15	15\n48	19	15	1\n48	20	6	6\n48	20	6	3\n48	20	12	12\n48	20	12	1\n48	20	15	15\n48	20	15	1\n48	21	6	6\n48	21	6	3\n48	21	12	12\n48	21	12	1\n48	21	15	6\n48	21	15	1\n48	22	6	6\n48	22	6	4\n48	22	12	12\n48	22	12	1\n48	23	6	6\n48	23	6	4\n48	23	12	12\n48	23	12	1\n48	24	6	6\n48	24	6	4\n48	24	12	12\n48	24	12	1\n48	25	6	6\n48	25	6	4\n48	25	12	12\n48	25	12	1\n48	26	6	6\n48	26	6	4\n48	26	12	12\n48	26	12	1\n48	27	6	6\n48	27	6	4\n48	27	12	12\n48	27	12	1\n48	28	6	6\n48	28	6	4\n48	28	12	12\n48	28	12	1\n48	29	6	6\n48	29	6	4\n48	29	12	12\n48	29	12	1\n48	30	6	6\n48	30	6	4\n48	30	12	12\n48	30	12	1\n48	31	6	6\n48	31	6	4\n48	31	12	12\n48	31	12	1\n48	32	6	6\n48	32	6	4\n48	32	12	12\n48	32	12	1\n48	33	6	6\n48	33	6	4\n48	33	12	12\n48	33	12	1\n48	34	6	6\n48	34	6	4\n48	34	12	12\n48	34	12	1\n48	35	6	6\n48	35	6	4\n48	35	12	12\n48	35	12	1\n48	36	6	6\n48	36	6	4\n48	36	12	12\n48	36	12	1\n48	37	6	6\n48	37	6	4\n48	37	12	12\n48	37	12	1\n48	38	6	6\n48	38	6	4\n48	38	12	12\n48	38	12	1\n48	39	6	6\n48	39	6	4\n48	39	12	12\n48	39	12	1\n48	40	6	6\n48	40	6	4\n48	40	12	12\n48	40	12	1\n48	41	6	6\n48	41	6	4\n48	41	12	12\n48	41	12	1\n48	42	6	6\n48	42	6	4\n48	42	12	12\n48	42	12	1\n48	43	6	6\n48	43	6	4\n48	43	12	12\n48	43	12	1\n48	44	6	6\n48	44	6	4\n48	44	12	12\n48	44	12	1\n48	45	6	6\n48	45	6	4\n48	45	12	12\n48	45	12	1\n48	46	6	6\n48	46	6	4\n48	46	12	12\n48	46	12	1\n48	47	6	6\n48	47	6	4\n48	47	12	12\n48	47	12	1\n49	1	13	13\n49	1	13	1\n49	1	14	14\n49	1	14	1\n49	2	13	13\n49	2	13	1\n49	2	14	14\n49	2	14	1\n49	3	13	13\n49	3	13	1\n49	3	14	14\n49	3	14	1\n49	4	13	13\n49	4	13	1\n49	4	14	14\n49	4	14	1\n49	5	13	13\n49	5	13	1\n49	5	14	14\n49	5	14	1\n49	6	13	13\n49	6	13	1\n49	6	14	14\n49	6	14	1\n49	7	13	13\n49	7	13	1\n49	7	14	14\n49	7	14	1\n49	8	13	13\n49	8	13	1\n49	8	14	14\n49	8	14	1\n49	9	13	13\n49	9	13	1\n49	9	14	14\n49	9	14	1\n49	10	13	13\n49	10	13	1\n49	10	14	14\n49	10	14	1\n49	11	13	13\n49	11	13	1\n49	11	14	14\n49	11	14	1\n49	12	13	13\n49	12	13	1\n49	12	14	14\n49	12	14	1\n49	13	13	13\n49	13	13	1\n49	13	14	14\n49	13	14	1\n49	14	13	13\n49	14	13	1\n49	14	14	14\n49	14	14	1\n49	15	13	13\n49	15	13	1\n49	15	14	14\n49	15	14	1\n49	16	13	6\n49	16	13	1\n49	16	14	14\n49	16	14	1\n49	17	6	6\n49	17	6	1\n49	17	14	14\n49	17	14	1\n49	18	6	6\n49	18	6	1\n49	18	14	14\n49	18	14	1\n49	19	6	6\n49	19	6	1\n49	19	14	14\n49	19	14	1\n49	20	6	6\n49	20	6	1\n49	20	14	14\n49	20	14	1\n49	21	6	6\n49	21	6	1\n49	21	14	14\n49	21	14	1\n49	22	6	6\n49	22	6	1\n49	22	14	14\n49	22	14	1\n49	23	6	6\n49	23	6	1\n49	23	14	14\n49	23	14	1\n49	24	6	6\n49	24	6	1\n49	24	14	14\n49	24	14	1\n49	25	6	6\n49	25	6	1\n49	25	14	6\n49	25	14	1\n49	26	6	6\n49	26	6	2\n49	27	6	6\n49	27	6	2\n49	28	6	6\n49	28	6	2\n49	29	6	6\n49	29	6	2\n49	30	6	6\n49	30	6	2\n49	31	6	6\n49	31	6	2\n49	32	6	6\n49	32	6	2\n49	33	6	6\n49	33	6	2\n49	34	6	6\n49	34	6	2\n49	35	6	6\n49	35	6	2\n49	36	6	6\n49	36	6	2\n49	37	6	6\n49	37	6	2\n49	38	6	6\n49	38	6	2\n49	39	6	6\n49	39	6	2\n49	40	6	6\n49	40	6	2\n49	41	6	6\n49	41	6	2\n49	42	6	6\n49	42	6	2\n49	43	6	6\n49	43	6	2\n49	44	6	6\n49	44	6	2\n49	45	6	6\n49	45	6	2\n49	46	6	6\n49	46	6	2\n49	47	6	6\n49	47	6	2\n49	48	6	6\n49	48	6	2\n50	1	13	13\n50	1	13	1\n50	2	13	13\n50	2	13	1\n50	3	13	13\n50	3	13	1\n50	4	13	13\n50	4	13	1\n50	5	13	13\n50	5	13	1\n50	6	13	13\n50	6	13	1\n50	7	13	13\n50	7	13	1\n50	8	13	13\n50	8	13	1\n50	9	13	13\n50	9	13	1\n50	10	13	13\n50	10	13	1\n50	11	13	13\n50	11	13	1\n50	12	13	13\n50	12	13	1\n50	13	13	13\n50	13	13	1\n50	14	13	13\n50	14	13	1\n50	15	13	13\n50	15	13	1\n50	16	13	13\n50	16	13	1\n50	17	13	13\n50	17	13	1\n50	18	13	6\n50	18	13	1\n50	19	6	6\n50	19	6	1\n50	20	6	6\n50	20	6	1\n50	21	6	6\n50	21	6	1\n50	22	6	6\n50	22	6	1\n50	23	6	6\n50	23	6	1\n50	24	6	6\n50	24	6	1\n50	25	6	6\n50	25	6	1\n50	26	6	6\n50	26	6	1\n50	27	6	6\n50	27	6	1\n50	28	6	6\n50	28	6	1\n50	29	6	6\n50	29	6	1\n50	30	6	6\n50	30	6	1\n50	31	6	6\n50	31	6	1\n50	32	6	6\n50	32	6	1\n50	33	6	6\n50	33	6	1\n50	34	6	6\n50	34	6	1\n50	35	6	6\n50	35	6	1\n50	36	6	6\n50	36	6	1\n50	37	6	6\n50	37	6	1\n50	38	6	6\n50	38	6	1\n50	39	6	6\n50	39	6	1\n50	40	6	6\n50	40	6	1\n50	41	6	6\n50	41	6	1\n50	42	6	6\n50	42	6	1\n50	43	6	6\n50	43	6	1\n50	44	6	6\n50	44	6	1\n50	45	6	6\n50	45	6	1\n50	46	6	6\n50	46	6	1\n50	47	6	6\n50	47	6	1\n50	48	6	6\n50	48	6	1\n50	49	6	6\n50	49	6	1\n"
#define READ_LEN_DIST "30	31	32	33	34	35	36	37	38	39	40	41	42	43	44	45	46	47	48	49	50	51	52	53	54	55	56	57	58	59	60	61	62	63	64	65	66	67	68	69	70	71	72	73	74	75	76	77	78	79	80	81	82	83	84	85	86	87	88	89	90	91	92	93	94	95	96	97	98	99	100	101	102	103	104	105	106	107	108	109	110	111	112	113	114	115	116	117	118	119	120	121	122	123	124	125	126	127	128	129	130	131	132	133	134	135	136	137	138	139	140	141	142	143	144	145	146	147	148	149	150	151	152	153	154	155	156	157	158	159	160	161	162	163	164	165	166	167	168	169	170	171	172	173	174	175	176	177	178	179	180	181	182	183	184	185	186	187	188	189	190	191	192	193	194	195	196	197	198	199	200	201	202	203	204	205	206	207	208	209	210	211	212	213	214	215	216	217	218	219	220	221	222	223	224	225	226	227	228	229	230	231	232	233	234	235	236	237	238	239	240	241	242	243	244	245	246	247	248	249	250	251	252	253	254	255	256	257	258	259	260	261	262	263	264	265	266	267	268	269	270	271	272	273	274	275	276	277	278	279	280	281	282	283	284	285	286	287	288	289	290	291	292	293	294	295	296	297	298	299	300	301	302	303	304	305	306	307	308	309	310	311	312	313	314	315	316	317	318	319	320	321	322	323	324	325	326	327	328	329	330	331	332	333	334	335	336	337	338	339	340	341	342	343	344	345	346	347	348	349	350	351	352	353	354	355	356	357	358	359	360	361	362	363	364	365	366	367	368	369	370	371	372	373	374	375	376	377	378	379	380	381	382	383	384	385	386	387	388	389	390	391	392	393	394	395	396	397	398	399	400	401	402	403	404	405	406	407	408	409	410	411	412	413	414	415	416	417	418	419	420	421	422	423	424	425	426	427	428	429	430	431	432	433	434	435	436	437	438	439	440	441	442	443	444	445	446	447	448	449	450	451	452	453	454	455	456	457	458	459	460	461	462	463	464	465	466	467	468	469	470	471	472	473	474	475	476	477	478	479	480	481	482	483	484	485	486	487	488	489	490	491	492	493	494	495	496	497	498	499	500	501	502	503	504	505	506	507	508	509	510	511	512	513	514	515	516	517	518	519	520	521	522	523	524	525	526	527	528	529	530	531	532	533	534	535	536	537	538	539	540	541	542	543	544	545	546	547	548	549	550	551	552	553	554	555	556	557	558	559	560	561	562	563	564	565	566	567	568	569	570	571	572	573	574	575	576	577	578	579	580	581	582	583	584	585	586	587	588	589	590	591	592	593	594	595	596	597	598	599	600	601	602	603	604	605	606	607	608	609	610	611	612	613	614	615	616	617	618	619	620	621	622	623	624	625	626	627	628	631	632	636	637	641	643	646	649	652	660	663	664	672	674	690	699	701	717	729	743	750	753	792	816	837	1026	1436	1953	2032	2043	2044\n301	356	388	447	532	725	997	1713	2888	5425	9587	16385	25875	37604	53211	69216	86832	103910	119680	133922	146714	157163	166344	173146	176666	180274	182592	184987	185711	186293	185138	185043	184661	182124	181045	180121	179069	176761	174350	172942	171871	169697	167853	165613	163594	161023	158780	157919	154281	153108	150722	148782	145914	143627	141882	139088	137067	135637	134825	132546	131945	130159	128551	128266	126896	127427	125725	125747	125807	126222	126305	126663	126277	126282	127600	127075	126489	127588	127948	127452	128066	127257	127531	126836	126422	126404	125314	124562	124221	123294	122464	121905	121555	120287	119311	118758	118592	116826	115512	114891	114276	112860	112611	111335	110587	109635	108936	108199	108008	106620	106439	105366	105597	104836	104854	105077	104849	105312	105824	105738	106859	106661	107297	108063	109699	110497	111188	112670	113051	114198	114642	115469	116374	117090	118180	118908	119081	118915	121178	121117	120766	121888	121650	121865	122458	122683	123021	122619	122829	122895	123713	123113	122590	122551	122109	121457	122317	122044	122735	122691	122635	123056	123305	123870	123564	124825	124772	125204	126206	127108	128186	129284	130026	131424	133511	134399	136434	138249	140908	141577	144527	146057	148282	150853	153793	157123	160351	164240	167649	171951	176725	182451	188201	194583	200645	207588	214161	220674	229095	238878	247757	257377	268638	279738	292204	306301	320592	336791	354103	368849	387335	405564	424152	443799	462239	482368	500064	518260	533123	549239	563015	576688	586188	598115	606060	611256	613745	616175	617107	614623	606647	602646	595054	585297	573175	562213	548610	534821	520099	504179	489356	474311	457103	439789	424155	407639	392633	376257	361226	346249	333215	319030	305297	293083	281284	269677	260860	248781	240256	230850	221967	214845	206963	200337	194392	188125	182458	178332	174106	170077	167793	163709	161626	159998	158092	155607	154421	153364	151322	150790	150637	150183	149639	149067	149627	149563	150141	150227	150524	150536	152494	152124	153488	154566	156029	155763	156710	157547	158547	159090	160772	161337	162961	163948	165241	166271	167046	168582	169443	171044	171865	173524	174587	175563	176102	177302	178894	179829	181607	182659	182015	184578	185984	186617	186643	188444	190387	191728	192479	191913	194099	195396	196155	196678	196556	197571	198235	198128	198117	199805	199526	200782	201420	202916	203460	204339	204638	205401	205492	205345	206561	206219	207554	208447	209082	209469	210075	210046	210360	210213	210261	210628	211335	210945	209594	211130	210348	210692	209976	210987	210769	210714	209658	208487	209325	208975	209453	209358	208146	208113	207617	208497	207858	206694	206137	205179	204690	205099	205001	213573	212863	209778	205542	201685	198732	194447	192694	189829	187896	183075	181268	179407	178607	178013	176723	174812	173799	173486	172025	170304	169692	169218	168854	166833	166214	164939	164213	163416	161725	160701	160046	158000	157182	156815	156064	154700	153609	151745	151049	149980	149128	147660	147195	145953	144948	143777	142638	141536	140901	140224	138628	137906	137292	135533	134639	134123	133659	131977	131137	129952	128867	127246	126397	125173	123889	122658	121400	120591	119501	117266	116000	114705	112956	111566	110445	108399	106154	103885	102319	99745	98378	95268	93970	91764	88854	86617	84680	82044	79774	76905	74765	72803	69930	67618	64648	62991	60392	58009	55807	53190	51433	49053	46016	44167	42230	40167	37824	35844	34258	31990	30627	29253	27588	25573	23820	22680	21134	20221	18800	17785	16475	15363	14457	13340	12375	11701	10464	10126	9249	8542	7917	7305	6785	6216	5835	5260	4811	4499	4046	3691	3426	3013	2935	2579	2258	2130	1961	1765	1603	1482	1390	1256	1171	1011	999	811	744	660	592	552	501	455	420	365	354	276	270	225	210	208	179	156	135	125	116	100	81	58	71	67	60	43	42	39	39	19	23	19	19	18	16	9	10	10	4	1	10	2	6	8	7	8	5	5	6	1	4	2	1	2	1	1	2	1	1	1	1	3	1	1	1	1	1	1	1	1	1	1	2	1	1	1	1	1	1	1	1	1	1	1\n"

#define t_QUAL_DIST_1BASE "1	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n1	13010306	2202021	7457525	15429792	18264482	9921629	191545877	111688000	162567909	72231795	159598023	190036017	141905720	396100091	284914063	305016014	470333795	508496661	248783531	230527272	715592102	404842670	614045782	501523489	377729745	753550762	337098614	1649401335	316409388	1150631053	942395691	289247245	928414970	190626815	271911767	1800952348\n2	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	48788	1237619	3636845	6603856	8340026	4508782	86622632	53063586	87666781	23063561	63742348	75956545	63596834	100446987	81786118	86562180	139360458	118832282	87477934	54665360	177686959	113486820	150986704	124257681	108961378	167140920	93342327	405778610	88212442	286706668	239926292	71148154	217780514	53387466	66181159	411494631\n3	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	7143	713773	1995340	3431461	4913890	2801891	56829328	25523650	59554662	23946196	39194589	41605835	33980125	36754872	33071349	28153119	54755214	33495990	33492262	17873271	48577465	46792120	35660022	38532641	29545256	56543314	25545667	78533653	28599130	70334269	46922561	16797205	54908490	10989576	100401937	14747695\n4	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1813	451810	1054157	1767214	2708572	1406959	28424339	13065176	33659207	12192355	13875089	16214154	14861857	14913303	13290538	13693669	20879161	10071383	6986519	10001301	12302577	16215767	8614663	14233349	9265271	17302314	11400438	20095575	8289110	29786593	11711436	2961940	3741183	907672	359509	3183360\n5	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	750	278620	508395	820899	1235661	670032	14963823	11045742	12339969	8593525	4025287	8419760	4996541	5516733	3533303	5997195	4386650	4914343	4113002	1379648	5707375	7004309	1830140	5288060	2027632	3371975	2953833	312030	783026	676896	2294305	616321	648620	180553	205608	652601\n6	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n6	374	186662	248402	367076	554726	282111	6005506	4198042	5081494	3652987	1760155	1933211	1934050	1257411	2623880	942978	2324927	1816141	677510	792813	791408	624247	325606	86149	167743	161937	220152	85508	88126	36935	95230	10143	5689	36256	10	22686\n7	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n7	205	117384	117019	170850	250053	133177	2667687	1607222	2203097	1306206	819701	1236981	939164	649708	239425	264309	708407	86723	202321	137430	108304	34075	68071	31605	72133	5551	18393	5381	5701	2938	16	3	4834	1	1	604\n8	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n8	154	69884	58215	82934	115413	65446	1181015	646062	877803	801335	648632	297254	48819	201821	89539	99234	100707	20109	13742	8764	13827	2547	23841	10852	829	1625	124	551	9	1161	21	16	658	3	4	12\n9	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n9	93	43054	34438	48181	64425	37324	626773	644264	441337	199422	217578	295938	1920	18715	584	13906	53632	380	6308	17	274	246	52	161	36	55	226	14	3	3	12	1	258	3	15\n10	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n10	68	26755	22510	30937	40174	21556	387644	366466	264841	118330	185803	108992	1252	479	1210	13138	2612	294	230	53	312	115	33	59	18	60	78	25	2	6	23	8	114	4	2	23\n11	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	40\n11	60	16599	15171	20771	26172	12613	256990	227124	169545	71792	117739	60448	1310	561	1179	6834	1601	383	176	119	317	25	17	15	9	20	9	6	2	1	2	1	40	2\n12	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37	38	40\n12	45	10503	11053	14825	17848	8147	188239	159488	118865	48987	82215	38293	1278	618	376	4136	1028	128	276	37	96	23	38	15	12	21	15	15	3	2	13	3	1\n13	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	35	37	40\n13	27	6824	8101	10912	12817	5174	140852	117526	87972	34213	61951	26211	1326	752	185	2480	840	68	367	25	56	37	19	28	12	9	27	12	1	6	4\n14	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	37	40\n14	18	4330	5972	8005	8888	3515	104902	85204	65517	24620	47183	16967	406	379	189	1447	608	38	103	9	26	7	17	19	12	6	13	3	1	7	1\n15	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	37\n15	13	2940	4325	6059	6491	2159	76357	60486	47809	17709	35119	11153	92	300	213	965	603	23	35	7	30	12	13	12	3	7	8	1	1	3\n16	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	37\n16	13	1890	3312	4516	4646	1510	54455	42565	34534	12019	25258	7098	72	182	121	536	436	27	26	14	32	8	3	5	1	3	1	4	1	1\n17	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\n17	11	1323	2386	3505	3368	1046	38529	29893	25008	8603	18422	4416	62	147	43	333	262	12	33	8	16	3	1	7	2	1	2	3\n18	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	30	31	32\n18	4	874	1807	2706	2599	785	27228	20379	17759	5871	13403	2510	89	55	36	181	105	12	20	1	14	3	1	2	1	1	1\n19	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	31	32	37\n19	3	641	1317	2048	1891	530	18718	13566	12688	4052	9810	1584	65	47	13	117	33	1	25	1	6	2	2	2	1	1\n20	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	28	31	32	37\n20	476	1053	1536	1380	440	12480	9416	8726	2861	6693	922	30	35	6	67	23	1	12	3	1	1	1	1\n21	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	37\n21	1	365	714	1091	1015	304	8469	6134	6068	1937	4655	529	28	18	6	45	32	3	7	1	2	1	2\n22	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	30\n22	3	236	504	845	761	225	5580	4026	4275	1286	3171	358	10	6	10	24	27	3	3	3	1\n23	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	39\n23	165	385	555	550	163	3749	2773	2953	875	2263	213	6	7	4	19	19	2	1	1\n24	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	30\n24	125	254	364	373	120	2475	1918	2090	462	1519	136	3	7	3	10	20	2	1\n25	0	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	26\n25	1	90	167	253	236	67	1638	1259	1386	309	967	86	6	5	1	7	10	1	2	1\n26	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	28\n26	55	119	175	174	49	1098	879	872	181	689	48	1	3	2	1	9	1\n27	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24	30	32\n27	42	82	90	137	37	747	607	640	130	498	39	1	4	2	6	3	1	1	1	1\n28	6	7	8	9	10	11	12	13	14	15	16	17	19	20	23\n28	31	56	54	88	41	532	416	449	92	344	20	1	1	2	1\n29	0	6	7	8	9	10	11	12	13	14	15	16	19	20	21\n29	1	19	39	46	63	20	380	328	341	64	204	19	1	1	1\n30	6	7	8	9	10	11	12	13	14	15	16	18	20	21\n30	22	20	30	36	18	280	227	226	36	162	16	2	1	1\n31	6	7	8	9	10	11	12	13	14	15	16	17	20	21	25	37\n31	15	27	23	29	13	147	613	145	122	678	100	1	112	22	1	13\n32	6	7	8	9	10	11	12	13	14	15	16	17	18	21\n32	3	5	7	13	2	84	106	92	13	68	3	1	1	1\n33	6	7	8	9	10	11	12	13	14	15	16\n33	3	4	8	11	3	105	77	77	9	57	2\n34	6	7	8	9	10	11	12	13	14	15	16\n34	6	7	6	13	4	76	47	48	9	37	1\n35	6	7	8	9	10	11	12	13	14	15	21\n35	1	4	3	5	3	43	41	43	1	28	1\n36	6	7	8	9	10	11	12	13	14	15\n36	1	1	7	6	1	37	23	27	8	31\n37	6	7	8	9	10	11	12	13	14	15\n37	2	1	3	5	1	28	24	26	1	19\n38	6	7	8	9	10	11	12	13	14	15	16\n38	1	2	1	4	1	18	19	18	2	13	1\n39	7	8	9	10	11	12	13	15\n39	2	1	2	1	9	9	12	7\n40	6	9	10	11	12	13	14	15\n40	1	1	1	9	12	9	1	3\n41	11	12	13	15	16\n41	4	6	7	7	1\n42	6	7	11	12	13	14	15\n42	1	2	9	5	2	1	5\n43	7	9	11	12	13	15\n43	1	2	2	3	3	3\n44	6	9	11	12	13	15\n44	1	1	2	7	4	5\n45	10	11	12	13	14	15\n45	1	1	2	1	1	3\n46	8	11	12	13	15\n46	1	1	1	1	1\n47	11	12\n47	1	2\n48	12	15\n48	2	2\n49	15\n49	1\n"
#define t_QUAL_DIST_MC "2	1	0	0\n2	1	0	48788\n2	1	6	6	9	11	12	13	15	17	18	19	20	21	23	24	25	26	27	30	40\n2	1	6	1149377	88179	8	1	4	13	2	15	1	2	8	2	2	1	1	1	1	1\n2	1	7	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	26	27	30\n2	1	7	3290693	206617	122778	11793	39	4195	398	2	279	1	7	21	2	5	7	1	3	1	2	1\n2	1	8	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	27	28\n2	1	8	134979	5843591	111962	24314	259493	145729	63775	30	19831	48	3	52	35	2	3	1	3	2	2	1\n2	1	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	34	39	40\n2	1	9	23247	33233	73796	7112578	236109	411427	263936	114944	29167	22415	10306	6251	1414	219	788	35	6	11	4	2	1	2	3	1	2	1	32	96\n2	1	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	32	33	39	40\n2	1	10	10255	18574	180310	3728746	87932	203938	85376	133112	17736	19003	9725	12764	128	135	540	14	28	8	7	2	2	4	2	2	1	66	372\n2	1	11	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	38	40\n2	1	11	63	167688	177731	67667	79135391	713388	2084495	200437	1798695	1427869	200125	504704	47985	78514	10187	1840	2839	866	1927	100	93	20	1	4	1	2\n2	1	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	33	34	35	36	37\n2	1	12	1609	81314	125098	108437	857452	47611083	554895	494559	451008	998034	437251	201914	750554	131178	163151	68615	12706	3427	10498	525	157	32	2	18	41	1	20	5	2\n2	1	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37	39	40\n2	1	13	242	68917	84031	61414	2443373	865176	76741370	1150357	1012425	1670612	535335	1090575	829183	332542	367428	156496	152129	42757	40682	15263	3262	2578	209	276	8	13	22	9	10	4	15	68\n2	1	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n2	1	14	24	8308	65602	168610	408680	1427730	18737656	318680	465546	420209	552785	193159	72715	95721	71808	14034	18336	5466	9919	4130	2301	589	423	121	230	198	4	520	24	24	2	7\n2	1	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n2	1	15	1534	37919	10809	5686	2160112	450326	1480735	489418	52174516	793238	1367600	2018877	1153414	570908	499869	153153	125085	94197	71107	41121	19750	13378	2996	841	1738	424	152	4	3405	6	14	3	13\n2	1	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	16	57	4049	12761	1548837	1192961	1740538	427917	1059430	61862172	1033809	3587022	522297	1220082	755004	343513	103837	120829	314704	30347	40961	23178	3724	3856	405	1009	2443	71	67	141	498	4	7	15\n2	1	17	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	17	1	849	2924	5730	271778	545484	544934	354234	1833067	1400462	50863123	1059802	1888161	1146323	1373197	635421	581210	391545	181302	286698	126782	54608	18243	11606	8050	3713	946	873	3340	264	60	3	287	1814\n2	1	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	18	1	554	3383	689958	194631	1260977	421529	2616704	3863227	1316443	79401288	1264593	2568940	3994834	1660674	485228	172968	187025	79534	121256	79305	25282	17621	7500	7608	2700	1453	1106	289	147	77	94	58\n2	1	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	19	19	97	177	57074	813054	974793	190789	1244254	616583	2362444	1619659	63550140	2069347	2275462	1714621	1995989	681351	544679	251175	381982	154092	139530	33147	36335	45724	23856	2599	4912	1466	438	98	176	56\n2	1	20	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	20	656	525	109789	183688	367555	63057	600374	1349593	1405283	3088573	2565788	65371989	4088991	1115604	880809	711451	3588462	410001	256424	154557	69857	40615	14238	62312	29007	6168	20814	2924	2073	428	254	321\n2	1	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	21	14	183	16153	192249	477402	93524	684635	771119	1347495	4564519	2619316	4709375	106390253	6051393	2538204	1651996	3374755	1651046	1269484	494086	151074	163733	23740	56319	21234	5994	28490	6755	3128	1877	429	484\n2	1	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	22	2	18	2213	97209	211188	66838	167195	405806	747148	1922889	1821724	1288399	6714168	97750184	1098889	1211681	2713247	809946	396751	861443	159577	211229	83799	37277	10005	13959	17458	5718	2285	2212	445	1380\n2	1	23	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	23	49	4613	18219	180308	21891	161971	128697	664097	583726	2250537	1164354	3104837	1424594	66465884	1331163	2996499	1247005	2772857	1138469	787531	385705	217999	249105	74044	41697	38106	9687	8967	2078	2508	737\n2	1	24	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	24	1	1945	5878	58194	18056	113850	164539	523103	222529	737429	890869	1957042	1481338	1845514	38496927	1561848	2373203	1947416	1036453	402628	227481	121219	252904	108167	45452	41737	14697	5221	4056	2649	3015\n2	1	25	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	25	1932	15372	52637	5649	98685	354771	228346	233096	623596	3789298	3819794	3121799	3422231	2014410	142004103	5012554	5743449	3728842	997913	993888	274111	626658	248260	61121	166891	18384	13737	4450	5595	5387\n2	1	26	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	26	237	999	20722	6297	56912	43578	355162	118083	274400	494181	1969397	1111693	1488865	2896967	5574068	87694665	3753066	2621762	2152663	1186461	392409	707288	161267	113870	86170	86688	73602	25857	7817	11674\n2	1	27	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	27	3	6	169	213	4585	5373	27680	45567	142395	132505	445341	288625	1464948	722230	3087170	2399811	6340355	4430748	115976166	5590776	4703551	2089228	1019647	1204968	240787	247384	174797	74552	66793	30408	13541	16382\n2	1	28	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	28	1	31	49	3690	2377	18324	28291	75991	83467	207973	153268	608766	1035835	1364202	1164707	4214524	2982528	6656909	89801619	5729123	5707764	1214949	1853884	797364	124475	246643	45686	58480	26160	21365	29236\n2	1	29	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	29	1	2	16	364	936	4778	5977	25775	32483	186370	89551	190675	492384	952621	477077	1158863	2387634	5667645	6764909	77955129	4218068	2316633	4421325	793027	322478	205775	85932	113199	31333	18961	41457\n2	1	30	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	30	1	1	4	82	261	1254	2613	14474	17932	36900	46837	157999	245638	449278	279697	1133448	1503091	2613486	6946400	5098193	132479295	5264368	7382696	1160098	993195	656850	227214	270984	49144	32631	76856\n2	1	31	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	31	1	9	1	20	222	1237	785	10394	8950	51345	17910	31402	172963	286219	140150	390315	491425	1214738	1356559	2787022	6383897	70716906	4319995	2569522	936310	593106	344266	201303	150359	75717	89279\n2	1	32	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	32	2	31	292	703	1433	4897	8858	62460	79932	60402	43103	314683	272818	726968	800299	1431598	2062313	5555813	8758069	5515680	365621558	5525270	3391069	2673228	763685	657884	190221	198031	1057310\n2	1	33	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	33	1	11	16	102	145	442	1099	3267	16526	34567	24129	10155	95633	95023	334635	213175	394193	989759	997593	1414396	3323858	6165400	64401179	1628975	5138127	1204967	856847	460957	176560	230705\n2	1	34	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	34	4	4	39	207	781	1901	2989	9302	6389	11489	50917	59728	136500	496143	590267	197148	600981	1170665	1103470	3965239	1934706	270552667	2146385	1075947	1341858	308815	192512	749615\n2	1	35	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	35	6	4	61	237	55	277	1031	3148	14469	19705	10926	28642	34253	190483	91836	198975	281164	314413	862549	748276	3002662	6157532	2732738	215038436	1556582	5547295	1726926	424098	939513\n2	1	36	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	36	2	7	8	11	2	30	112	149	1233	3833	8280	6062	8085	13902	23436	105776	102832	74110	125927	304402	473679	958161	1525920	1440671	1999343	58421020	1456494	1988572	794420	1311675\n2	1	37	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	37	2	1	1	62	22	94	113	352	500	706	4827	2673	9287	5708	17472	83142	67667	67061	114780	334311	254479	861737	1115809	1524619	6589886	1750588	199424147	1786410	1697570	2066488\n2	1	38	11	12	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	38	3	1	1	5	7	146	118	572	2957	3165	2884	3614	6071	37624	39946	34150	45396	72018	204037	241328	518341	455538	2081099	2472771	1969193	39777366	1436568	3982547\n2	1	39	6	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	39	2	50	121	1	3	16	9	25	15	529	107	694	572	869	934	4267	3029	7945	12786	20669	27519	24946	39554	86666	255686	181694	250709	508073	967863	2073820	1750556	55023854	4937576\n2	1	40	6	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n2	1	40	1	137	444	2	1	96	47	44	2363	144	241	750	975	1695	1291	3836	6557	13450	20467	36610	39570	103524	98619	1262457	273506	864012	1074311	1620072	2247693	4753515	5890458	393177743\n3	1	0	0\n3	1	0	7143\n3	1	6	6	9	11	12	13	14	15	17	18	20	21	24	25	26	27	28\n3	1	6	677265	36450	13	5	6	1	5	1	12	1	4	4	1	2	2	1\n3	1	7	7	8	9	10	11	12	13	14	15	16	17	18	21	22	24	28\n3	1	7	1904700	41572	41258	5557	34	1831	297	2	58	1	1	19	4	1	4	1\n3	1	8	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	25	30\n3	1	8	54054	3190382	16644	8677	53602	72477	30476	12	5049	41	4	19	10	3	4	5	1	1\n3	1	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	34	39	40\n3	1	9	14001	20787	36284	4548079	72207	85550	70423	47586	7288	6095	2766	2009	518	32	158	24	2	8	1	3	2	3	2	1	5	1	6	49\n3	1	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	30	33	39	40\n3	1	10	4500	9289	94519	2515436	23867	73890	25570	31953	4811	10037	2289	5252	42	27	136	7	15	4	4	5	1	1	1	29	206\n3	1	11	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	28	29\n3	1	11	33	80520	68926	32877	53639548	441343	1779287	349617	264260	113489	21329	19333	9023	5832	2349	139	734	171	500	15	2	1\n3	1	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	32	33	34	35	36\n3	1	12	5788	53732	65392	43625	694982	23251466	103889	289527	233538	380036	253585	68290	54888	11295	9827	287	313	277	2634	213	27	2	18	2	10	1	5	1\n3	1	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	31	33	34	36	37	40\n3	1	13	121	40324	60784	28099	2815358	260292	52368646	1327416	864185	868422	168683	399681	134151	96094	91282	17420	3954	4850	3359	826	239	260	79	89	9	1	3	2	33\n3	1	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37	38	39\n3	1	14	213	14452	26747	1084233	358994	1885401	18715888	257739	417682	441763	240283	145785	143578	172894	15392	3521	2449	15765	1946	766	272	130	63	76	30	45	64	3	17	1	4\n3	1	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	39	40\n3	1	15	1807	11661	17833	3680	649207	283371	1309750	486971	34023365	647933	956027	235964	236941	96258	120302	21150	39524	21516	14303	8684	4478	1085	1241	280	252	339	81	1	578	4	1	2\n3	1	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n3	1	16	98	4134	17103	585486	517518	1076878	491502	942557	35545191	567861	1002287	174153	184597	314631	39419	24330	23579	74469	7205	7068	2469	660	843	851	179	542	10	10	8	188	3	6\n3	1	17	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n3	1	17	5	356	2143	6613	295913	803380	617502	613687	1421710	821777	26241298	771537	1126048	290063	531384	114781	92904	61293	124850	22913	11874	1146	2174	1192	1541	313	154	18	544	27	32	111	842\n3	1	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	18	5	3587	8074	113106	174127	854477	290050	338706	1358401	1021300	29238890	836647	735925	1136050	419680	114285	28694	36550	16039	13899	9310	2426	2980	429	458	310	216	82	19	72	22	23	33\n3	1	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	19	186	314	644	57772	292850	616872	266981	399559	310401	1592846	1192925	25745087	758600	557624	344480	308468	94644	383319	93216	27635	12704	4303	3875	973	756	3372	127	567	75	89	13	58	14\n3	1	20	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	20	722	913	39972	38236	362024	204173	182229	423847	383392	997821	1010397	21518462	1276231	355577	186292	70435	851294	111914	68778	42156	10377	8969	1903	813	2916	426	2034	88	586	59	78	5\n3	1	21	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	21	2	148	458	56441	108048	811878	348888	422998	608560	1209299	1768556	781654	1656091	42307258	1520280	1222076	389401	764098	375958	230167	72441	36279	41620	5083	9144	3184	801	3485	129	603	21	111	54\n3	1	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	22	53	608	3980	7988	235699	198715	56584	149659	299129	996285	488173	428635	2071692	26832477	412391	230573	418950	294866	106715	152397	34385	48155	14007	6207	3966	990	2108	227	169	14	147	46\n3	1	23	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	23	27	179	5949	3645	112716	72375	318087	73767	246209	338314	954363	297435	1574136	584766	25703905	600271	594244	1273024	392192	178157	52998	66737	11279	15002	7526	7010	3858	585	2250	93	1119	44\n3	1	24	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	24	13	5604	3888	75400	39617	242938	59558	170200	99398	341705	126692	626986	334050	978620	13008064	445006	534217	405480	176471	83660	47496	17353	19922	14513	8941	5045	632	712	60	833	197\n3	1	25	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	25	33	2748	27610	34124	52877	199558	626036	245621	130918	574364	1539589	1374527	695535	751176	622554	37214068	1691802	1192186	813152	304736	309981	84296	35599	25899	14139	6043	1102	2634	1105	2992	461\n3	1	26	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	26	1	251	4596	17002	27226	181326	158933	167126	72709	455759	430703	922984	588403	1842006	731104	2492358	34373278	1082577	1477674	878871	463479	149664	169782	49171	18983	5819	2378	23787	489	3474	207\n3	1	27	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	27	3	39	394	978	11309	25195	117561	120316	89039	123075	177280	214867	620854	279701	926574	674873	1655313	1574263	26017203	1197752	864270	468722	157879	129896	76175	65601	18198	3505	44061	518	3656	952\n3	1	28	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	28	9	37	151	6202	13848	29978	75206	16840	100609	109528	283162	272327	433535	385922	296836	1497413	1931269	1503076	27847869	843330	2139351	291376	173376	138726	32997	22538	6343	65106	4506	11041	134\n3	1	29	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	29	7	48	324	6337	47816	15237	98041	74462	56093	94016	230300	268003	219656	297300	667644	1424514	1434166	1091073	21280951	1119892	490982	330995	171766	49393	30681	3467	19059	4268	18685	80\n3	1	30	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	30	11	5	509	393	1733	7873	13113	50125	75268	85163	98298	280578	269101	364108	190330	955991	897747	1007138	2767208	1472691	42673231	1485359	1580869	441935	618375	43576	9054	1067636	58568	24206	3122\n3	1	31	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	31	4	9	44	4	1476	4121	6221	24763	25446	27563	39693	35807	74789	167918	92090	65402	315750	388281	371735	564041	806357	2078825	18706316	728424	547469	244337	79483	33714	45874	12867	53139	3705\n3	1	32	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	32	62	1499	24265	10277	19458	21414	31788	20563	104079	55795	201459	127890	169618	569585	443236	635903	603929	3264269	972804	69756892	664166	455117	44906	24541	14306	17932	59790	218110\n3	1	33	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	33	3	1	205	590	1328	6251	15225	8128	10861	24074	37459	47558	53192	69269	65208	126631	145339	239542	306612	370616	700541	779381	823971	22594691	500916	415521	752083	64219	92459	222990	124266\n3	1	34	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	34	56	115	667	2655	3276	26569	18142	27128	30946	24233	77970	102128	144005	236619	359988	156734	210428	1136188	700588	1221784	778935	63438738	527915	285885	314915	151909	242809	112944\n3	1	35	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	35	5	74	44	174	1099	1508	2165	2229	8361	18873	21035	12184	16891	26076	22152	38910	68935	93135	148980	159905	258410	118935	871792	801786	43029481	294475	385417	170044	236122	113364\n3	1	36	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	36	1	3	6	77	188	144	313	2266	4184	5266	9813	10064	12845	15464	25931	27412	63143	25026	67477	119614	80625	1113674	489004	601839	12813080	331262	144302	784757	49425\n3	1	37	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	37	1	8	14	133	83	828	751	1576	4963	3666	28193	3372	33375	11310	38480	69891	146270	141000	48997	1600190	251047	31171	152883	769069	1030686	554194	48796614	202013	888642	99070\n3	1	38	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	38	6	2	4	18	34	9	417	80	2878	818	1049	1362	2347	10080	8113	3448	12615	17785	121947	36617	28870	175234	269447	231401	214102	171700	9034964	431638	212591\n3	1	39	6	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	39	1	12	48	8	3	8	74	157	129	338	411	1384	2338	6710	4109	6351	11584	18007	42855	25721	40114	105748	116436	155901	113478	567773	461286	449223	1048962	1181656	1449923	94307680	283509\n3	1	40	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	1	40	5	1	94	300	17	9	68	3	39	38	1357	106	428	403	561	280	560	1050	3448	1647	3013	556	2392	15720	8313	332387	260448	150832	155038	57164	116986	453193	450891	12730348\n3	2	0	0\n3	2	0	7143\n3	2	6	6	9	11	12	13	15	16	17	20	23	39	40\n3	2	6	674297	16957	2	2	1	6	1	1	2	1	1	1\n3	2	7	7	8	9	10	11	12	13	15	16	17	18	19	20	21	22\n3	2	7	1923270	42767	15737	3853	20	4857	157	1116	5	1	2	3	4	1	2\n3	2	8	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	26\n3	2	8	37007	3250053	16517	7436	65492	49067	30061	167	8574	84	30	6	127	1	1	1	1\n3	2	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	27	28	31	39	40\n3	2	9	15981	20864	26482	4635839	68039	61114	59966	49247	12037	15856	3940	2009	3242	224	462	135	35	15	1	1	1	1	1	9	77\n3	2	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37	39	40\n3	2	10	4894	8750	87476	2534354	17333	38486	24622	23405	3778	14244	5263	7000	505	636	356	348	138	11	20	1	20	8	7	13	4	1	1	1	42	254\n3	2	11	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	31	32	35	39	40\n3	2	11	9	47102	50320	34106	55170309	465649	2240346	844731	492382	481132	205715	74518	41821	25526	29418	2729	3369	2795	1744	61	279	20	1	18	2	7	4	14\n3	2	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	35	36	37	38	39	40\n3	2	12	1082	57388	50108	56779	628867	23845316	98596	267373	239793	421375	648353	138085	214394	27035	73370	5107	2554	2320	16024	2756	657	84	26	310	2	150	50	3	8	1	2	6\n3	2	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n3	2	13	181	38282	49796	24850	2320471	264514	53552979	1491520	911374	895273	498747	673803	480350	262348	577871	167699	73934	57433	20699	9817	8206	3804	124	248	1149	18	409	35	22	6	13	7	49\n3	2	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n3	2	14	17	3990	23485	433869	338244	1722754	18953437	304780	396867	513759	243909	216035	157772	254595	131964	51088	30485	39715	17675	15878	9143	3979	1044	2869	940	732	70	101	11	85	40	4\n3	2	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	15	522	12164	4260	2855	345144	273913	1272862	459935	34570621	703497	1053833	250014	326966	144948	322657	44967	234582	175839	139183	112953	74510	19475	29256	5390	4585	16727	4504	366	702	46	55	6	106	19\n3	2	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	16	60	1679	11342	140361	483131	1052911	480470	896435	36045698	628530	1093386	240968	337531	475079	118219	57332	45049	450727	103842	79722	52448	10767	8891	20803	7116	10716	1205	891	95	531	21	76	22\n3	2	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	17	275	1095	2366	32053	307852	237308	497448	1322458	789032	26743839	750142	1292301	323826	974446	233216	179182	122036	189947	112335	57782	11576	56265	28819	16270	12144	5800	1999	1394	79	447	2	280	1075\n3	2	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	18	2	339	2404	25911	80211	533705	237509	308625	1269691	1025977	29982977	880580	755720	1424878	733705	262876	72189	95240	50538	84007	67248	46244	44198	17403	15652	7335	15617	1373	190	1047	201	243	49\n3	2	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	19	14	26	56	10756	82189	177145	167867	276287	234140	1430178	1110586	26145680	773801	629430	395799	782410	257357	452703	343760	121971	71134	33102	50168	23403	18795	17150	10310	5816	1534	3780	37	816	265\n3	2	20	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	20	221	188	9015	15297	127588	192373	109710	222265	352372	905270	1016822	22093391	1295235	359742	218484	98515	1235253	315714	157879	209386	62603	65904	23805	11758	26699	15534	13761	2671	2649	1823	1503	250\n3	2	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	21	5	79	4912	14177	142342	238494	184904	398886	697405	1366489	716115	1578105	43136233	1601906	1221679	485203	1105464	711533	460738	202585	153461	195638	52167	58562	31456	17637	13880	3348	15996	542	4058	344\n3	2	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	22	1	6	211	641	26931	23181	21096	50113	142836	546287	412931	385406	1829922	27288585	442129	254242	581660	439481	159778	334909	132980	190225	96395	35049	37003	14744	7942	6045	2164	550	2512	181\n3	2	23	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	23	21	814	645	6648	7713	61890	29275	119678	155941	433035	259429	1587812	575125	26205700	778719	623439	1506299	719188	281246	169768	251373	63056	112788	48728	49577	11065	5918	20241	874	3831	337\n3	2	24	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	24	491	661	7733	4580	36539	31867	86299	37671	135689	90401	526040	315804	820235	13229173	469543	577187	537581	226574	222166	134638	48129	80868	45761	68691	16897	7777	6659	1718	7044	651\n3	2	25	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	25	572	4317	5055	21585	23928	103587	166921	48720	475605	1009377	963006	531444	741652	622767	38065895	1981103	1324380	1243419	472225	733893	218069	98922	73596	81624	13969	9246	21424	6954	10902	1615\n3	2	26	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	26	10	268	1505	1727	16355	12338	29885	29907	138893	164940	515540	408415	1592434	696411	2067125	34823832	1251083	1570335	1125082	694499	288319	391970	110729	104469	26041	17543	48690	4772	26847	1110\n3	2	27	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	27	40	39	408	1276	8154	9212	14789	24184	38978	98259	306740	209796	510136	526136	1437628	1319879	26441430	1179922	1119824	776651	284634	302687	180926	208471	50906	18446	104673	1679	16725	2356\n3	2	28	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	28	5	369	230	1549	4286	1427	12044	21629	61645	95745	224253	241226	208154	1000813	1816820	1469582	28098601	882842	2262903	444060	432346	236857	100094	63762	41344	99723	8104	26809	236\n3	2	29	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	29	1	6	179	2341	1654	4378	5961	8068	23716	66044	134455	83491	130191	429838	1063988	1114042	1031006	21328325	1185063	595263	381467	276541	123440	94621	16328	33136	11789	67480	930\n3	2	30	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	30	1	8	20	45	505	695	2292	2742	6616	16075	55529	80140	97474	67722	428687	616658	652522	2602462	1379454	43414211	1750296	2430230	551158	919296	97778	44617	1263898	90301	77474	9562\n3	2	31	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	31	6	56	108	464	1183	2437	883	2595	4096	10031	46863	18475	26033	139947	213790	221801	369589	613626	1734662	18775774	794084	633890	525133	177095	79886	174589	19454	110021	5812\n3	2	32	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	32	1	43	531	309	472	840	1788	1786	16737	12062	23026	32872	55520	228701	194188	231026	509841	2034684	887083	69382039	640512	950114	84887	56915	21378	22454	85747	234663\n3	2	33	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	33	3	7	31	96	313	250	527	1987	4602	5723	7318	12496	18656	44900	71634	131352	198498	252569	584709	699995	768714	22806790	636415	687511	902358	120968	129571	418449	160924\n3	2	34	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	34	2	2	32	35	489	222	1389	1864	2191	16684	20730	40818	117379	171878	63794	123636	805927	345735	639899	631693	63089488	626356	377900	618398	213032	365461	123529\n3	2	35	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	35	2	19	77	16	77	59	203	632	917	980	1865	4165	5158	8234	27003	30541	62257	93385	137609	64298	572795	706340	43071184	450948	814435	193021	338854	125654\n3	2	36	10	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	36	1	3	3	3	6	17	110	199	275	395	546	1080	2545	4456	7199	13446	7618	21955	64790	36417	901149	387214	460037	12728455	410613	150697	858849	47768\n3	2	37	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	37	1	3	33	17	87	52	164	259	191	1601	699	3392	1956	5700	33511	54799	85263	19624	1321066	68969	21294	84553	413959	499715	422447	48300936	175873	1042507	91285\n3	2	38	11	12	14	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	38	1	1	3	2	34	6	151	33	46	164	110	2074	1478	1374	6023	7519	77984	21626	24097	120120	194461	209108	204862	192803	9329989	1107749	297525\n3	2	39	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	39	21	47	2	1	9	9	15	13	193	37	372	424	358	718	2283	1979	6316	7294	8053	19152	31021	37863	75140	82849	304230	311448	310983	915368	984839	659669	93677264	307065\n3	2	40	6	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n3	2	40	2	94	251	6	3	68	22	17	1140	72	51	20	196	93	218	655	632	544	1698	230	563	5280	5007	276038	183072	139631	140985	53937	123326	294685	317412	12407871\n4	1	0	0\n4	1	0	1813\n4	1	6	6	9	11	13	14	15	18	20	21	23	24	25\n4	1	6	424125	27669	3	1	1	1	4	1	1	1	2	1\n4	1	7	7	8	9	10	11	12	13	15	17	18	20	21	22	23	24	25	29\n4	1	7	1001472	22749	24581	3406	11	1619	267	38	1	5	1	2	1	1	1	1	1\n4	1	8	7	8	9	10	11	12	13	14	15	16	18	19	20	21	22\n4	1	8	2040	1658838	8920	4856	26467	52654	10646	20	2642	106	7	14	1	2	1\n4	1	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24	25	27	28	32	39	40\n4	1	9	191	3825	9011	2547413	35169	42956	39422	19056	4295	3901	1595	1142	492	38	3	13	3	1	2	3	2	2	3	34\n4	1	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	39	40\n4	1	10	1016	1806	34454	1270159	14080	41962	12394	18014	2680	4952	1062	4143	34	16	51	3	3	2	1	7	120\n4	1	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n4	1	11	565	3928	10677	27125405	317989	658458	152395	99824	34734	7908	6700	2723	2234	218	55	294	5	220	1	5	1\n4	1	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35\n4	1	12	2288	4788	7073	203459	11896706	221666	319473	115645	124622	58033	72128	17875	18637	1418	174	184	8	958	8	16	3	1	10	1	1	1\n4	1	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	36	39	40\n4	1	13	14	11917	16218	6296	777086	119821	30741571	435210	497400	382716	401318	116695	38676	100373	8025	2211	1463	440	1222	268	113	88	3	45	3	1	14\n4	1	14	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n4	1	14	1	82	130371	119436	300361	10336843	160617	324174	431055	150544	81981	95669	12109	2334	2038	700	42844	902	85	85	19	33	18	2	1	22	26	2	1\n4	1	15	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n4	1	15	1549	5	88223	115749	573900	145893	11912561	399417	279977	79034	100316	89578	52823	11483	5082	844	13996	3468	315	542	69	13	9	1	44	5	191	1	1\n4	1	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n4	1	16	3443	20827	150116	450279	253928	372045	13853406	270594	489378	87670	99435	62658	34549	5215	1042	53475	1674	2863	1003	79	308	10	14	10	31	3	5	94\n4	1	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n4	1	17	143	274	434	572	318454	179359	270702	265847	12338077	466306	531763	228763	105191	58839	20455	4455	59490	6785	3540	295	86	544	739	19	20	28	152	15	5	40	465\n4	1	18	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n4	1	18	49	88468	70978	82082	44029	519862	381984	12211196	320114	563293	441597	91932	42770	8927	16279	10978	12421	3239	357	2476	77	26	9	125	19	6	2	8\n4	1	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	19	18	11955	893	81005	48573	66859	551373	290011	10952350	465258	512227	224303	26282	27000	9661	16123	3233	1086	125	1234	99	502	81	56	201	7	16	5	1	1\n4	1	20	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n4	1	20	25	3	62382	94977	60737	35535	148427	306025	352270	11135020	611213	270209	111082	86250	314927	79335	7373	12318	2413	747	366	299	680	112	676	5	263\n4	1	21	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	21	3	39	308	168	46523	43490	75618	190412	508563	656730	17596337	596169	207067	400600	232312	180056	93933	26340	7591	13746	851	690	273	98	1199	14	21	8	1	1\n4	1	22	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n4	1	22	27	22	26	148	2827	20680	34641	84801	124357	212919	296423	8152289	310428	230080	193031	223924	68152	80079	4898	20213	5393	2109	1773	551	1537	50	3	2\n4	1	23	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	23	4	12	28	5	1009	233	2883	28649	18147	82146	189613	199204	5820274	158809	116304	142889	98545	58123	15488	31804	11093	4127	2271	3702	690	99	336	25	2	5\n4	1	24	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39\n4	1	24	2	1	11	10	112	59	448	4978	21774	90015	412661	251042	162349	7738850	370938	535440	160612	176007	30630	19850	7690	4852	4147	6446	2178	75	112	12\n4	1	25	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	25	9	1	9	29024	8457	23702	82926	12394	3808	47697	51055	130906	115308	185146	10216603	495756	320887	354823	98666	52731	33108	9635	5835	18114	5348	148	350	94	32	5\n4	1	26	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n4	1	26	54	263	30	1175	9204	6677	31157	124948	179085	116920	493783	280181	13393333	148116	777278	289340	238079	80783	14659	12994	14597	2583	290	214	23	1\n4	1	27	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	27	1	2	9	45	11	864	2352	2280	4574	21944	56434	50178	149481	113419	161890	7189066	378134	149445	241271	55675	12126	11637	9558	2913	251	1032	52	5	14\n4	1	28	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	28	2	3	1	13	10	14	43	176	6286	3088	17481	50745	133470	166639	485151	239266	11634752	292624	575263	380441	165046	40627	25601	3952	9719	2168	660	69	39\n4	1	29	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	29	3	5	1	32	192	439	248	6539	13425	13463	19246	49315	156082	87955	256041	8027721	87362	349527	87266	60763	43150	5329	70	363	416	271	47\n4	1	30	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	30	4	3	4	4	47	6	71	220	130	2672	3478	11133	6886	176844	153170	361146	114629	14795464	550262	934280	81626	55148	20783	16093	15267	190	758	1996\n4	1	31	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	31	119	5	294	4	270	143	163	7387	4769	5092	15109	48711	44947	309923	149990	171286	9953932	256048	269046	121269	25074	9496	6947	262	148	4\n4	1	32	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	32	1	4	2	1	18	240	265	101	1815	1137	4396	11162	12718	5106	101973	79431	497922	204541	18456312	315435	184056	70865	1193	54563	26	8373	83919\n4	1	33	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	33	6	4	2	11	4	61	323	55	979	336	2514	3726	13602	14490	31453	54401	83919	203532	106843	6633506	861516	218545	16772	39382	1462	337	1329\n4	1	34	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	34	17	1	9	23	22	21	161	57	3444	16653	25362	23610	10113	37207	8822	36702	18994	346853	29148061	54407	13851	4446	9384	3527	24846\n4	1	35	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	35	1	7	3	25	83	84	501	931	744	762	2789	7098	27075	16511	69109	31115	98713	11355817	39699	30935	5355	4186	19893\n4	1	36	18	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	36	1	5	2	1	26	16	160	10936	82	23217	9226	67843	28255	26465	53998	2656145	50746	27754	3377	3685\n4	1	37	14	21	22	23	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	37	1	10	2	9	6	50	124	127	1611	11472	5021	61223	6943	10756	22644	34228	3546679	19176	9296	11805\n4	1	38	14	18	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	38	1	15	1	28	2	79	6	18	179	74	235	1805	413	1330	13386	9153	39834	25121	735733	29637	50622\n4	1	39	9	10	17	18	21	25	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	1	39	7	10	59	1	1	3	21	62	124	15	11464	25	4477	4796	3661	12429	11422	265934	44998\n4	1	40	9	10	13	16	17	18	21	23	25	29	30	32	33	34	35	36	37	38	39	40\n4	1	40	37	133	15	2	537	1	2	4	1	6	57	105473	1802	30471	27166	4684	16222	27464	27186	2942097\n4	2	0	0\n4	2	0	1813\n4	2	6	6	9	11	12	13	15	16	17	18	20	22	40\n4	2	6	410206	14085	3	2	3	6	2	1	3	3	1	1\n4	2	7	7	8	9	10	11	12	13	14	15	17	18	19	20	22	23	24	27	28\n4	2	7	972817	20011	9280	2295	28	3252	111	1	557	1	2	2	2	3	1	1	1	2\n4	2	8	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	25\n4	2	8	28415	1596497	7587	3756	27481	31683	9360	119	3712	137	29	7	76	3	2	1	1\n4	2	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	32	39	40\n4	2	9	15152	15163	18086	2496571	31313	25536	29059	18526	5617	7934	2125	1007	1855	183	13	76	20	10	2	1	1	2	8	30\n4	2	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	39	40\n4	2	10	2702	4741	44902	1222920	8902	20265	10231	11457	1957	5908	2390	3884	237	243	158	177	62	3	13	2	9	3	1	3	1	1	19	118\n4	2	11	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31	38	39	40\n4	2	11	21	36386	33038	18931	26609274	377248	820239	262743	127548	62815	53477	8898	6926	9242	1406	385	166	64	563	8	54	2	20	1	1	6\n4	2	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37	38	39	40\n4	2	12	5338	45147	37762	26919	568880	11197622	201902	364604	121262	152884	121966	58448	17986	27243	2177	1219	841	100	3826	58	104	1	10	205	3	1	2	22	6	2	3	1	3\n4	2	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	39	40\n4	2	13	165	13524	23920	12530	1078195	314011	29449149	448396	531930	417815	540951	219957	71693	221710	57069	12892	15630	2715	3722	1879	2685	972	18	138	9	10	38	1	8	5	4	25\n4	2	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n4	2	14	209	8044	14887	345324	483904	572433	9413332	144796	294452	377112	135770	107537	102630	45876	19221	18179	6191	33919	4621	735	528	397	848	1705	55	14	111	34	5	6\n4	2	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n4	2	15	972	5620	10757	2491	177099	151976	690089	207961	11261979	383147	277576	62366	120991	110017	74243	39444	16318	5309	19783	20812	714	4276	1721	394	390	126	3594	164	397	2	42	10\n4	2	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	16	221	2750	7983	92797	208392	539021	353279	503851	13130990	254286	466581	86343	105967	95601	56748	10047	6755	129807	13334	17349	14643	1155	1119	270	566	388	774	150	92	805	1	2	6\n4	2	17	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	17	1	178	1269	3521	88657	174463	715607	456826	378855	353583	11375450	430706	504990	233604	105831	81063	26955	27964	60407	22126	11507	3912	1024	8617	1320	278	175	176	158	61	613	8	60	538\n4	2	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	18	7	3350	6488	15958	84360	307502	172067	79352	592390	584488	11093268	297843	560467	442054	105026	54959	26478	22012	14899	26789	13891	4460	9518	3089	536	187	3891	104	37	254	22	1	5\n4	2	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	19	170	293	381	12260	29277	112805	138513	164471	119860	648378	432216	10113562	470695	529237	249164	27153	42598	18537	20641	11382	8951	1516	10200	3728	2999	433	2700	409	145	13	7	3	20\n4	2	20	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n4	2	20	10	407	19850	47349	333564	140832	148272	143632	292279	729185	604799	9865323	631045	248996	112001	115898	326785	114019	12192	17832	7093	3974	3275	1307	3342	3638	4008	65	37	16	5\n4	2	21	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	21	1	119	257	2754	3624	95348	78161	112497	132012	141931	595439	687801	830642	15874593	641825	195479	394742	245647	236880	119323	53894	22339	27896	5306	3046	1946	3415	2260	762	596	111	9	15\n4	2	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	22	39	381	718	2481	20159	25583	64627	81247	119373	142431	332635	320281	815822	7082876	312378	285413	200045	222583	68209	116575	10697	50391	17700	3872	3000	3354	1466	252	491	126	19	4\n4	2	23	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	23	14	112	396	1245	23144	25256	29991	15631	44622	81269	43154	150063	265023	407296	5171438	169887	118827	156452	148179	73462	16575	82934	15520	12921	4483	11412	1996	83	93	22	1	8\n4	2	24	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	24	10	93	140	6419	7921	7798	12635	50368	42334	67699	161200	498912	346743	221062	6871385	399971	493961	171984	176901	40730	39573	12222	8923	5674	18315	2986	91	135	13	26	1\n4	2	25	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	25	21	1022	7430	6733	52117	29220	196598	80658	32595	33005	441003	333815	261306	143216	492032	8714238	523855	301563	340413	115455	86109	54775	16269	8592	29349	4414	184	154	83	58	119\n4	2	26	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	26	1	7	86	4029	7725	41608	22873	43005	24938	34483	186632	379782	309062	194400	622640	692612	12028180	153042	736267	267760	250362	86119	22763	16715	40343	4390	1312	822	134	10	14\n4	2	27	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	27	17	78	202	4195	1230	1227	29883	22725	46718	21432	18059	175164	99076	207998	222229	387705	212500	6265100	402995	144347	275484	70063	26600	15721	18954	7456	463	1053	48	26	138\n4	2	28	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	28	7	1	4	1777	1050	6767	21715	9174	24496	18294	27634	87431	168445	113368	249022	438502	930736	528880	10261120	284838	660529	401859	241292	43505	48133	7123	9186	3121	347	122	421\n4	2	29	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	29	2	27	59	739	3975	2065	1694	8256	3782	14087	47757	26310	23178	58632	179217	392682	193032	359957	7295886	114634	378837	96919	81687	62462	16321	257	614	316	294	469\n4	2	30	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	30	9	299	230	1265	944	1792	20807	22756	26779	8677	56216	84541	150173	70794	135328	386229	396732	837288	187017	12543492	589864	1113195	95203	116807	28057	10599	11949	283	1050	6947\n4	2	31	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	31	2	6	29	1	17	3144	1002	518	2321	5647	6962	5766	9686	37509	25485	20676	83569	135995	101029	505449	521583	720661	8722932	341008	346100	235605	41126	16666	16398	348	85	102\n4	2	32	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	32	1	1	20	97	231	1370	783	1208	6366	2803	8578	6483	31827	18488	34769	43603	48259	377299	137591	1618559	460314	16577848	352252	330865	81349	99401	58117	203	9470	81222\n4	2	33	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	33	6	55	21	4820	575	208	374	790	5150	3297	4897	6818	9743	13002	24805	24593	61398	113131	122837	434950	422045	5119685	1105244	282105	35506	56768	2433	293	1552\n4	2	34	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	34	3	1	3	248	339	1697	359	8016	5804	7908	7612	6873	20441	29835	54042	88933	47877	74377	98439	177851	339889	461443	1413642	27548927	207561	14362	23144	9899	3371	23619\n4	2	35	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	35	2	45	21	55	717	306	244	241	663	6837	3667	2548	3871	5477	7663	7853	11288	12202	32368	49591	64183	121758	372003	196248	10859533	65607	36366	5335	3892	19662\n4	2	36	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	36	1	1	4	6	5	119	142	80	199	95	1156	591	220	148	563	2093	683	15299	590	15272	28499	100433	41007	28626	89233	2415276	72539	25273	3776	4487\n4	2	37	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	37	9	13	74	915	911	410	20	60	869	997	205	186	337	1410	2115	4994	2418	18155	27586	71417	75300	20513	35548	110245	3375404	39695	7470	10442\n4	2	38	11	12	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	38	3	1	20	10	8	33	20	31	153	182	65	32	190	246	66	726	526	675	2422	798	4676	15259	10102	41827	39881	637254	27112	57203\n4	2	39	8	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	39	1	11	19	5	2	2	2	1	75	7	13	2	33	64	7	51	176	32	40	386	553	2373	255	11111	753	5691	7011	7916	12975	51625	190301	61711\n4	2	40	6	8	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	2	40	4	1	47	198	17	6	27	1	21	784	12	47	23	59	25	25	6	692	22	344	1914	1945	19913	352	119847	3180	32145	27540	9091	17788	100906	105589	2743368\n4	3	0	0\n4	3	0	1813\n4	3	6	6	13	15	16\n4	3	6	425358	1	2	1\n4	3	7	7	8	9	10	11	13	14	26\n4	3	7	1024890	11	1	672	13	4	2	1\n4	3	8	7	8	10	11	12	13	15	17	18\n4	3	8	21579	1706166	877	29	1890	8946	1310	1	2\n4	3	9	6	7	8	9	10	11	12	13	14	15	16	17	19	21	39	40\n4	3	9	14510	14141	14891	2609154	23405	1024	3400	13089	1	4	2	197	1	1	2	28\n4	3	10	7	8	9	10	11	12	13	14	15	16	17	19	21	26	32	39	40\n4	3	10	2914	4431	44358	1288413	2178	5000	5531	73	18	2852	2	2	1	1	2	3	87\n4	3	11	7	8	9	10	11	12	13	14	15	16	17	18	19	22\n4	3	11	8	23560	29267	20669	28122349	99418	599509	102546	62675	15042	306	14	5	2\n4	3	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	22	23\n4	3	12	953	40448	30220	33105	453470	12213915	36632	83740	89861	111742	180	65952	8220	1	25	1\n4	3	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	25	26	29	40\n4	3	13	168	13026	20571	12575	879117	323986	31369386	209828	431836	346190	246921	46156	119	42679	205	5	1	1	1	22\n4	3	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29	30	38\n4	3	14	23	2743	14864	180082	374889	557845	10393433	90991	203916	141745	67485	62045	69067	79	5	4	5	21150	2	1	2	1	1\n4	3	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	30\n4	3	15	261	6396	2729	1802	126994	138180	656306	217280	12004895	269080	188601	35877	39102	49097	36626	2457	705	4	5950	2	2	1\n4	3	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	34\n4	3	16	123	1149	5095	39318	172542	496648	369559	514940	13869515	170616	404956	44105	26377	34116	14450	202	34	17949	18	1	1	1	3	5\n4	3	17	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	39	40\n4	3	17	2	144	692	1601	12857	70743	504493	469229	371740	349779	12363064	255044	422041	102482	56990	26707	1820	114	57702	1103	584	3	13	1	229	1	6	2	37	360\n4	3	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32	34	36	38\n4	3	18	5	389	2337	8872	99348	168834	151701	85285	593478	582160	12321618	181109	228520	154742	61731	19007	3388	9417	6683	1752	2	1	4	1	6	1	15\n4	3	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32	33	34\n4	3	19	18	40	58	3152	25145	41299	103029	111856	107023	676230	422421	10966589	250771	386693	95483	10286	14435	2559	4357	1552	19	5	5	86	3	2\n4	3	20	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n4	3	20	1	97	4352	30017	153240	126391	104068	115867	251351	657296	574844	11069301	472405	150663	57886	65465	32789	19235	3526	4695	116	81	53	158	210	7	1\n4	3	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	38	40\n4	3	21	14	63	217	1533	12829	18868	77798	83878	127766	529609	663699	797809	17468948	205102	135302	326130	31188	56564	14113	2445	312	88	33	56	23	11	1	1\n4	3	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n4	3	22	1	16	140	362	4411	4185	16728	47917	75838	120638	280721	313702	729621	8090535	143928	184725	93364	136087	42189	11442	1508	1750	235	1418	414	60	73\n4	3	23	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n4	3	23	2	19	89	323	2068	3599	7968	6006	22965	54350	36401	142090	260124	394912	5799857	105230	94204	87713	37445	33415	9265	2376	2905	492	93	18	2	4	2	31	9\n4	3	24	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	38	40\n4	3	24	9	19	1255	1310	1477	1784	9789	13770	42810	129419	525413	299151	214327	7726409	140506	393035	119855	101708	14442	7478	3297	3180	1522	3143	386	1	1\n4	3	25	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n4	3	25	290	1828	1700	59142	19818	75273	74977	21663	14852	386046	300451	245272	142165	431909	10089991	190280	82203	125362	31985	3047	7759	8174	2174	9214	762	48	6	78	1\n4	3	26	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n4	3	26	1	2	4	485	1154	6726	2975	8742	19617	21802	129656	286170	286349	164814	654420	601475	13156485	98696	383012	108352	120286	33425	6751	9240	179	582	18	30	2\n4	3	27	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n4	3	27	39	5	204	209	468	3966	6272	17229	4621	11313	137497	97830	140411	205719	392862	207548	7034592	175442	66485	118030	29591	3054	7603	4331	311	151	58	19\n4	3	28	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n4	3	28	175	88	715	1948	423	4708	2063	18186	42483	123171	73342	225815	425397	845432	461504	11433140	197223	264283	246882	75984	21001	4421	1652	7692	90	88	23\n4	3	29	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	29	3	4	60	167	608	341	1947	747	7083	25309	20080	23563	44552	149361	340939	188398	343421	7866846	59619	112971	62614	40382	22154	760	57	104	43	46	4\n4	3	30	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	30	7	10	30	48	189	1227	2084	1692	1143	21184	44723	55487	33085	82282	337838	324445	710889	159556	14531661	151320	343015	64619	5671	14388	16403	9020	179	61	51\n4	3	31	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n4	3	31	6	1	31	159	30	1132	297	542	1256	2373	20774	16114	14660	59404	108244	80473	472198	386596	559106	9675272	133201	154290	25188	7993	4857	3066	193	1\n4	3	32	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	32	4	7	25	137	24	67	1890	873	1373	3828	8297	7290	13699	26427	25802	225500	115144	1197555	357330	17459407	85280	12392	42730	65234	49810	9	9770	69484\n4	3	33	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	33	1	9	93	38	126	113	258	1239	701	3175	4421	7284	12862	19247	21662	61219	90067	109592	380509	441260	6536668	258379	25950	26128	10012	1031	8	1245\n4	3	34	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	34	1	44	19	74	74	268	153	586	496	1461	10446	15372	34549	57587	34821	53652	77156	108287	222344	316675	1158669	27624980	105593	12981	13013	8171	2788	22863\n4	3	35	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	35	1	11	125	12	70	35	134	374	499	888	883	1757	5286	2886	5946	7559	16719	39580	41298	93079	293916	92092	11035783	31869	25626	4581	2521	19337\n4	3	36	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	36	4	2	2	17	11	13	7	5	31	42	37	75	181	522	367	14169	165	22124	17116	5503	24408	27398	69848	2608339	18667	25785	1904	2757\n4	3	37	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	37	2	1	67	15	1	4	96	39	15	111	183	247	307	953	3464	2134	21130	9948	59815	43212	7518	29494	80431	3431305	24844	6026	8823\n4	3	38	11	12	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	38	1	1	24	4	9	2	42	1	120	28	52	427	387	386	2262	496	2687	15513	10460	45136	23924	746715	8103	17742\n4	3	39	6	9	10	11	13	16	17	18	23	24	25	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	39	1	9	29	1	5	2	78	4	4	11	45	47	129	344	1688	205	13362	312	5061	6316	5163	11771	39225	254133	15128\n4	3	40	6	9	10	11	12	13	16	17	18	19	21	22	23	24	25	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n4	3	40	1	44	145	5	4	33	3	619	3	15	1	3	12	3	20	144	155	261	4266	96	106995	2003	30807	26930	6055	17432	72692	67009	2676505\n5	1	0	0\n5	1	0	750\n5	1	6	6	9	11	12	15	18	22	27\n5	1	6	262079	16535	1	1	1	1	1	1\n5	1	7	7	8	9	10	11	12	13	15	16	18	21	25\n5	1	7	483819	10289	11348	2085	9	685	138	16	1	2	2	1\n5	1	8	7	8	9	10	11	12	13	14	15	16	17	18	19	21	24\n5	1	8	1048	777567	4071	2801	10671	20150	3452	6	1054	68	1	4	4	1	1\n5	1	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	39	40\n5	1	9	71	1392	4084	1171592	13833	17823	16205	6255	1523	1543	669	467	142	29	1	3	1	1	2	3	1	2	2	17\n5	1	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	34	39	40\n5	1	10	419	876	13337	610078	6722	18632	5891	9554	1082	1462	293	1568	28	3	16	7	1	7	56\n5	1	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	28\n5	1	11	189	1597	5491	14381701	414199	81430	27878	35299	11205	2230	1174	897	224	61	26	142	3	76	1\n5	1	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	40\n5	1	12	724	1939	2828	498162	9881365	150113	370194	60649	52313	17558	4325	3578	1077	511	18	54	1	327	5	1\n5	1	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	40\n5	1	13	5	3219	4940	2457	80613	115418	11573810	117329	113342	171210	109545	17855	25008	2016	2044	478	277	14	346	1	1	34	2	5\n5	1	14	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	35	36\n5	1	14	1	31	12598	384614	86264	7380052	168634	264162	100482	79082	39343	61253	2912	1160	282	195	12356	35	40	8	2	3	1	10	5\n5	1	15	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	31	35\n5	1	15	593	19	29573	52130	99849	56749	3309146	122847	120848	72840	57562	45674	31688	10303	2103	236	12444	35	166	373	68	3	38\n5	1	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	35	37\n5	1	16	801	6001	64984	184618	304351	114262	6867489	254096	273462	178801	83506	39168	14484	4650	1476	26384	157	644	313	8	29	3	29	44\n5	1	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	35	36	37	39	40\n5	1	17	56	136	186	132	97511	64624	114200	155231	4041231	170315	115009	156439	38517	22907	8174	1732	7540	78	926	975	16	11	338	1	37	3	1	11	204\n5	1	18	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36	38	40\n5	1	18	1	21	607	17677	54844	16220	279479	162695	4372877	201109	193408	105603	81812	12723	2372	7807	354	2146	3531	164	855	388	1	35	1	2	1\n5	1	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\n5	1	19	4	848	1067	29735	17787	32159	101728	80837	2919478	83320	90377	103637	44910	5743	11799	2544	2718	3103	51	380	684	1	377	16\n5	1	20	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n5	1	20	13	2	96	69126	12308	68829	122942	214594	91237	4626843	130247	337827	136645	14462	141182	20752	2644	4857	785	824	830	1	11	1	28	2	107\n5	1	21	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35	36	37	38	40\n5	1	21	2	8	105	236	18869	4545	6945	70384	42192	154961	3687932	91564	117645	12362	110112	17142	31091	14998	1927	712	1444	4	11	1428	17	8	1	5\n5	1	22	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n5	1	22	14	7	15	67	9493	667	6166	19591	80858	299134	41173	3815816	181028	63086	151272	138740	31549	54467	2068	6561	11500	3	1	1	1039	23	4\n5	1	23	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n5	1	23	1	4	18	5	371	220	657	11995	13120	50386	80511	125744	3340363	28442	228942	73432	30221	75474	3325	4050	44027	4	31	1	739	159	746	10	4\n5	1	24	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37	39	40\n5	1	24	2	1	8	2	167	1885	1023	691	3944	11214	6480	78991	23159	1107452	44537	66945	20782	7489	432	1577	315	24	29	1773	386	313	6	21\n5	1	25	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	25	7	5	9588	12973	18484	13815	7965	11042	15457	29138	55542	84215	45309	4751019	166463	106787	171807	26058	22530	156264	36	307	22	2234	71	15	48	94	80\n5	1	26	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	26	3	12	37	2	23	59	1575	16463	13161	164195	42119	64348	170782	5640627	153813	301665	48007	87198	291386	342	109	81	874	117	59	2	1971	5279\n5	1	27	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	27	2	3	8	2	177	917	894	414	1789	25337	6603	3652	45312	39811	1527743	89552	50039	25429	5633	2540	564	46	1312	186	901	10	1263	1\n5	1	28	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	28	1	2	3	1	9	2919	400	650	6154	4458	19311	1336	34697	134192	48533	4175154	258457	494407	91041	4368	2305	3727	2846	407	2523	54	102	3\n5	1	29	13	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	29	1	1	3	3	3	223	235	1184	352	154	6742	20439	37621	58800	1590664	241670	28704	4365	15075	16040	2726	318	1019	140	1141	9\n5	1	30	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	30	1	2	1	14	2	10	306	446	429	101	147	930	9980	8936	60898	35121	3177043	43989	11877	1547	2762	4571	5693	6259	57	822	31\n5	1	31	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	31	3	34	102	1	106	16	304	2129	818	34	17564	12694	4526	49223	23367	33064	2704135	9496	33951	21654	7786	7055	8516	2041	665	14549\n5	1	32	15	16	18	19	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	32	1	3	3	2	1	6	12	254	343	4395	179	4965	747	3086	262925	2881	1155	4416	1819	22217	26	2593	1\n5	1	33	14	16	17	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	33	5	1	1	2	1	20	2	32	14	2014	236	1627	2247	17550	2178	28311	7582	676363	28932	3309	279	11216	639	373	92\n5	1	34	14	19	21	24	25	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	34	1	2	1	1	8	2	2222	6736	2888	8851	1921	3773	633059	5543	2471	1506	3451	632	3828\n5	1	35	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	35	1	8	421	701	360	1894	518	56	732	882	2182	3982	4551	2705	971	3172	2234984	6079	5535	2615	16971	4985\n5	1	36	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	36	3	2	137	433	46	4	21	175	974	289	1628	2816	339	948	3325	549961	37007	1868	15146	1199\n5	1	37	21	23	24	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	37	1	4	14	35	438	768	1930	681	759	1610	734	1038	2147	630300	3401	2712	2048\n5	1	38	11	16	17	18	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	38	1	1	1	7	1	15	2	47	2	3	177	169	100	3003	9	882	6709	4887	3067	2639	141563	2034	15234\n5	1	39	9	10	17	25	26	27	28	29	30	31	33	34	35	36	37	38	39	40\n5	1	39	2	1	20	52	1978	215	133	494	4	502	167	67	1704	158	5315	2214	183428	9154\n5	1	40	9	10	13	16	17	21	23	24	25	26	29	30	31	32	33	34	35	36	37	38	39	40\n5	1	40	14	60	14	2	241	1	2	3	61	2632	7	24	21594	1	64	4827	8237	1402	2453	12420	2568	595974\n5	2	0	0\n5	2	0	750\n5	2	6	6	9	11	12	13	15	16	18	21	22	25	40\n5	2	6	246727	15402	6	2	3	2	2	1	1	1	1	2\n5	2	7	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	26\n5	2	7	465302	9406	6750	1811	16	2990	153	1	239	4	1	1	1	1	1	2	2	2\n5	2	8	7	8	9	10	11	12	13	14	15	16	17	18	19	20	22	24\n5	2	8	943	750863	3433	2715	11508	23173	2837	105	1612	309	14	7	73	2	2	1\n5	2	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	28	30	40\n5	2	9	130	1447	4042	1164852	11378	11030	15259	6605	2099	4986	1419	562	1361	232	4	50	15	9	3	2	2	1	1	23\n5	2	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	28	30	39	40\n5	2	10	360	814	12410	591743	4690	11108	5024	6372	1199	2598	560	3061	191	73	49	94	39	7	4	1	1	4	84\n5	2	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31	40\n5	2	11	141	1586	5318	14181364	507578	131559	75095	57512	13861	56171	2590	4646	4636	1373	309	105	33	222	2	12	1	10	1\n5	2	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	30	35	36	37	40\n5	2	12	693	1678	2576	462369	9561272	153833	447532	104742	64381	106761	14751	18451	25489	2833	877	225	12	1424	3	62	11	3	10	2	1	1\n5	2	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	35	37	39	40\n5	2	13	18	2835	4375	2159	71757	105729	11296137	109539	122695	232428	196475	33835	71679	20410	30534	3363	2277	118	1458	18	55	408	8	5	9	1	3	2	2	11\n5	2	14	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	35	36	37\n5	2	14	30	9683	345181	76807	7047763	167781	269250	199476	93418	93314	147431	19938	5506	1338	2228	13564	210	537	177	147	1974	11	1	100	13	12\n5	2	15	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	35	36	37	38	40\n5	2	15	282	11	27229	47782	89305	50421	3048294	113817	152711	83610	109098	175019	68408	13530	9228	396	15347	92	388	1672	28	229	106	3	64	5	413	1	12\n5	2	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	34	35	36	37	40\n5	2	16	802	5312	52543	162175	268053	99034	6031788	282459	294184	381549	223381	124780	50329	12934	1179	53571	412	3370	4383	131	425	102	1	1	25	7	6	3\n5	2	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37	39	40\n5	2	17	53	131	165	164	88328	54868	96441	133140	3769078	190274	156768	326851	114258	72722	36249	4777	12588	417	1371	3071	71	125	1078	6	8	40	4	1	18	248\n5	2	18	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	34	35	36	37	38	39	40\n5	2	18	1	10	1126	16382	49309	10728	230607	137903	3983665	292863	260022	163637	188898	32549	6943	12135	1828	3769	6362	1149	2547	1101	19	2	46	6	1	5	4	1\n5	2	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n5	2	19	3	1703	961	28893	14473	24736	96767	74955	3002013	85113	155930	166994	76337	12550	22218	5088	3096	7456	267	3597	2717	25	2	1	285	52	1	4	3\n5	2	20	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n5	2	20	20	4	66	58546	9780	53576	96651	173688	79790	4176496	158587	510196	220440	31404	172975	37918	4176	11900	1017	2040	1774	19	34	3	1455	179	211	58	5\n5	2	21	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n5	2	21	4	29	236	482	13739	3463	7105	66444	36569	135247	3487843	109914	141075	27489	129562	31238	35896	65111	3082	1764	11442	29	5	27	975	26	89	1	17\n5	2	22	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n5	2	22	11	5	15	62	7990	585	4994	13562	72942	237573	46580	3717816	194674	65390	197640	136575	68607	132013	3541	15213	21807	31	9	59	854	44	139	15	1\n5	2	23	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	23	5	3	13	18	303	138	314	12262	11727	38802	82090	115595	3000082	33027	232930	130865	38775	182981	6197	8223	129947	19	125	21	853	128	770	15	1	9\n5	2	24	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n5	2	24	4	1	6	2	105	1557	882	696	3549	10072	6194	67797	25911	1049498	54923	89267	23460	10957	2000	4355	622	197	134	1	2140	406	66	108	22\n5	2	25	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	25	1	7517	8717	13602	13111	5517	11548	34041	36117	45095	61440	45444	4484103	190601	107421	298124	40903	42655	333631	33	408	205	4246	127	41	28	319	179\n5	2	26	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\n5	2	26	1	3	10	1	15	34	1348	13597	11819	141409	33976	53050	138902	4488862	321350	367900	85641	144105	534128	751	207	207	2519	606	1149	1559	6524\n5	2	27	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	27	1	3	16	8	109	746	1331	320	2156	42415	4514	4205	49558	39524	1627903	92855	70793	62172	8461	1965	661	74	2114	449	2250	9	3307	6\n5	2	28	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	28	1	6	4	4	2130	440	1008	9241	4219	28278	1038	28567	101800	73622	3569876	277681	777970	170476	5273	2665	9293	4991	1122	9133	88	232	17\n5	2	29	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	29	1	1	2	7	7	223	279	1450	383	123	7494	14998	52646	55692	1459663	378320	41487	4858	12933	28794	7164	709	3891	168	3023	20\n5	2	30	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	30	13	3	4	456	447	592	147	139	837	11000	11971	80880	47626	3855769	46531	13661	1037	4285	4636	6887	18727	68	2726	113\n5	2	31	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	31	44	125	1	126	12	417	2739	1051	33	18638	7004	3348	65999	20900	39795	3154982	10071	33181	37135	10795	6208	20882	1657	2559	15190\n5	2	32	16	17	18	19	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	32	1	4	1	4	5	3	7	230	298	3728	195	5070	1254	2404	238857	2414	1158	6394	1590	43008	52	5092	9\n5	2	33	14	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	33	5	2	20	5	2	46	13	2101	212	1482	1797	13445	1527	46824	6465	588865	50717	8558	817	16637	476	662	303\n5	2	34	19	20	21	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	34	3	1	1	2	7	3	2	2428	4457	2105	10694	1639	3035	675725	7727	3101	3424	3177	2178	4243\n5	2	35	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	35	4	1	378	601	326	1938	534	55	900	937	2375	4176	4102	1766	637	2538	2224998	6474	9808	2560	25182	5035\n5	2	36	14	18	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	36	1	1	9	2	135	412	50	5	24	175	918	261	1434	1979	226	668	3154	458293	79470	1842	31540	1243\n5	2	37	21	23	24	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	37	2	6	22	46	428	1238	2500	550	1099	1719	690	1045	2061	715972	5109	3942	2274\n5	2	38	11	18	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	2	38	2	5	1	9	1	31	1	2	134	152	76	2494	6	561	6464	4743	2764	3224	126197	1927	21768\n5	2	39	9	10	17	25	26	27	28	29	30	31	33	34	35	36	37	38	39	40\n5	2	39	2	3	13	39	1150	391	275	795	1	735	92	80	2125	100	6782	1651	206158	12149\n5	2	40	9	10	13	17	21	23	24	25	26	29	30	31	33	34	35	36	37	38	39	40\n5	2	40	16	58	10	209	1	5	1	35	1192	5	23	23034	48	5103	7870	1297	2984	11070	2899	596921\n5	3	0	0\n5	3	0	750\n5	3	6	6	8	9	11	14	15	18\n5	3	6	246849	2	2	1	1	1	1\n5	3	7	7	8	10	11	13	26\n5	3	7	467850	21	184	9	5	1\n5	3	8	7	8	9	10	11	12	13	15	16\n5	3	8	14561	751334	1	312	31	591	2021	277	1\n5	3	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	40\n5	3	9	16822	10544	8852	1161993	7298	295	1135	3542	2	13	7	114	2	3	1	12\n5	3	10	7	8	9	10	11	12	13	14	15	16	17	18	21	22	39	40\n5	3	10	2283	3456	17654	590375	701	1623	1794	15	13	644	2	1	1	1	3	44\n5	3	11	7	8	9	10	11	12	13	14	15	16	17	18	19	21\n5	3	11	9	16424	15620	10219	14337437	326880	50913	5447	18437	3644	123	15	13	2\n5	3	12	7	8	9	10	11	12	13	14	15	16	17	18	19	22	36\n5	3	12	4650	30158	20552	14453	690277	9525024	54980	264219	34259	35439	116	654	862	7	2\n5	3	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	27	29	36	40\n5	3	13	190	4470	9313	6551	174533	216776	11315326	45305	61953	117879	68564	9385	70	1	124	6	4	1	1	1	5\n5	3	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	32	36\n5	3	14	133	3241	8838	106034	565470	143657	6989905	32095	209785	40100	38289	21205	43127	212	3	4	1	4586	3	1	1	1\n5	3	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	33\n5	3	15	514	2604	6989	1616	82065	140240	163192	204844	2995750	61350	66026	7508	9820	7129	9210	5825	164	36	5558	6	2	1\n5	3	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31\n5	3	16	421	2035	3499	20661	95383	326480	336043	154691	5931737	87151	174553	12247	33324	2708	425	16	1067	8827	1	3	1	1	1\n5	3	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	31	39	40\n5	3	17	95	751	1040	81494	131975	227043	225162	183194	335882	3687961	90858	66913	71936	4996	3535	183	679	8447	8	61	99	16	161\n5	3	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	38\n5	3	18	8	2194	5205	4064	21481	48058	117285	98541	364712	242381	3893096	49871	127937	54567	8971	6168	518	3623	13	567	1549	3\n5	3	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	33\n5	3	19	150	363	344	8852	26682	109783	121885	132070	459112	178462	355274	2820249	46204	24280	51565	5808	2477	4483	901	982	340	1	2	1\n5	3	20	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	32	33	35\n5	3	20	164	6343	35000	27772	183464	204228	269973	367006	299478	114882	4072137	92894	175105	26777	7041	23151	9564	227	623	156	300	2	13	1\n5	3	21	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35	40\n5	3	21	2	96	121	2288	4350	43934	27340	90461	154237	134612	184981	182888	196150	3374050	28509	56415	3417	23366	8002	1530	6219	237	275	249	2	1	231	1\n5	3	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	35\n5	3	22	22	252	552	1340	4485	7861	18197	64706	95587	229990	192252	597469	145999	3587544	91847	52242	31251	109519	26771	2636	932	364	311	355\n5	3	23	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	35	36	38	40\n5	3	23	22	72	256	486	5103	2544	17356	24336	51896	45089	101772	276749	194199	227102	2838336	17287	40106	22119	3139	14569	209	90	621	1	252	72	7	1\n5	3	24	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	35	36\n5	3	24	9	89	38	259	2986	682	1851	7423	10820	16133	38065	32327	79644	42330	1030929	33020	39376	2999	643	57	108	19	2	1338	338\n5	3	25	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38	39	40\n5	3	25	1	11	501	2989	2783	21499	24389	84644	18322	23381	38012	242233	190080	250078	279274	70979	4238668	101446	32629	15767	3509	397	9545	11	58	3	379	40	24	15	23\n5	3	26	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	39	40\n5	3	26	1	2	10	4	58	384	173	798	745	3232	8788	47996	42559	173514	164986	110805	233184	4375636	32003	72885	10238	6992	3863	145	73	4	1	806	755\n5	3	27	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37	38	39\n5	3	27	36	76	113	737	654	6095	2169	6326	4255	6201	54352	89913	51584	30623	144942	366122	1521996	54067	36456	7623	1796	1257	519	323	9	20	1	147\n5	3	28	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n5	3	28	737	459	3897	6625	7113	11887	13493	23091	109394	178330	214554	16890	350374	479418	116130	3295716	41936	53263	37665	35	1141	1123	520	4	302	9	83\n5	3	29	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	29	5	5	20	59	196	44	281	143	2213	486	1838	5377	5618	10011	3128	60044	110858	91739	313769	1372670	35878	18123	3423	9553	2869	186	81	573	117	1	3\n5	3	30	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	30	7	4	2948	305	576	197	3773	4868	2913	2708	20845	13174	6468	57326	212905	87560	1011796	396577	3484324	38241	910	819	1108	1315	91	1404	31	1	17\n5	3	31	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	31	1	26	17	36	377	341	2828	2728	7933	4812	26146	40852	190660	1470	391436	762174	10334	201578	49728	53111	2730772	1441	49405	5488	1549	301	134	1371	992	14652\n5	3	32	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n5	3	32	3	1	1	60	49	100	98	61	443	379	1471	4552	7765	6316	18541	14913	224257	6813	973	929	937	86	2\n5	3	33	12	14	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	33	1	7	11	71	3	62	12	35	331	445	3170	663	1527	5283	16839	1768	47924	2845	566202	431	132	2	768	370	100	28\n5	3	34	16	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	34	4	17	12	73	303	57	4	545	469	141	17627	36859	6510	61827	2118	72186	614717	1397	442	448	4040	107	3348\n5	3	35	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	35	3	12	3	243	135	51	67	151	515	2566	1392	1386	1442	3363	6127	4375	3456	8305	14018	9407	18923	9926	16315	13708	2179293	2706	1042	3513	2768	4718\n5	3	36	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	36	1	24	12	18	4	5	78	330	57	128	237	616	274	989	719	2364	1693	9500	9335	2438	1544	4685	9270	444974	1138	2056	80	908\n5	3	37	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	37	2	2	11	530	8	3	2	16	340	228	332	1152	165	111	2505	3542	14174	5128	26695	32497	53884	27557	5218	12690	88222	656096	2579	2905	2500\n5	3	38	12	16	18	20	22	23	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	38	1	1	11	1	8	25	72	6	10	611	375	305	3094	109	823	4780	4445	2814	6110	121489	1492	7592\n5	3	39	9	10	11	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	39	1	9	1	2	23	11	5	113	27	58	4	155	599	2535	4220	555	5401	3447	4533	5516	1053	3568	36383	37734	6476	2251	176666	2173\n5	3	40	6	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	3	40	2	38	97	8	3	16	40	6	341	6	27	18	49	8	36	36	633	17449	14	160	112	382	18859	25	778	5650	8506	2138	3140	32210	22471	553179\n5	4	0	0\n5	4	0	750\n5	4	6	6	8	9\n5	4	6	263669	2	2\n5	4	7	7	8	10	12	14	17\n5	4	7	500369	6	222	2	1	1\n5	4	8	7	8	9	10	11	12	13	14	15	18	19\n5	4	8	10164	804258	3	213	1	486	2649	2	352	1	1\n5	4	9	6	7	8	9	10	11	12	13	14	17	39	40\n5	4	9	9147	7408	7581	1203880	7158	327	1033	4237	3	99	4	12\n5	4	10	7	8	9	10	11	12	13	14	16	18	19	39	40\n5	4	10	1748	2631	18609	622307	981	1532	2233	28	558	1	1	3	45\n5	4	11	7	8	9	10	11	12	13	14	15	16	17	18	20	24	25	28\n5	4	11	36	9987	14043	10721	15033198	354952	60647	8140	20546	4166	123	9	1	1	1	1\n5	4	12	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22\n5	4	12	437	14655	12748	14573	571031	10048282	60163	291290	37748	45818	121	367	353	1	2\n5	4	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	36	40\n5	4	13	93	3897	7213	6415	111470	223754	11836280	54538	71153	132857	74352	10012	38	4	48	2	2	1	1	10\n5	4	14	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	25	26	36\n5	4	14	1	10	994	7490	36716	468604	148196	7456853	37687	234425	48281	41662	22026	51127	98	1	5	6670	5	1\n5	4	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	31\n5	4	15	140	2624	1132	915	47077	81144	153841	213263	3353463	75752	80297	12097	12382	8637	13969	7102	243	49	8626	19	1	1\n5	4	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31	40\n5	4	16	64	439	1516	13430	80869	243580	331713	171190	6899106	102137	208942	17793	45366	3439	591	9	1464	13094	2	1	1	1	1\n5	4	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31	36	39	40\n5	4	17	59	374	646	4285	22412	128620	121655	152697	318397	4017547	108778	72605	91212	5200	4479	374	757	9001	1	149	1	57	1	19	165\n5	4	18	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	38\n5	4	18	2	12	118	933	766	3467	23762	84374	76886	348761	220656	4341090	52617	157016	55801	13241	5324	627	5414	25	696	2217	4\n5	4	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	32\n5	4	19	6	22	29	1311	5223	23558	44868	58522	200219	137444	203010	2833523	56440	29268	57297	6619	2973	5488	965	608	325	1\n5	4	20	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	33\n5	4	20	1	39	251	1806	4270	79734	51460	118628	183536	240536	120544	4642105	109653	225493	34521	7663	10040	11532	345	284	182	175	5\n5	4	21	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36\n5	4	21	1	8	32	80	389	3219	3774	40728	50137	42080	111185	101760	171174	3723434	25063	56682	3511	19066	9541	1241	4030	132	334	176	1	2	342	2\n5	4	22	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n5	4	22	12	70	35	1108	1405	12398	18339	27318	93371	125805	398760	130865	3782463	92381	61888	39798	125350	14189	2550	777	172	205	1	1	1	486\n5	4	23	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	38	40\n5	4	23	13	54	135	366	693	3637	8740	11043	22090	49473	172695	164628	213225	3233805	14415	57548	27635	4556	9787	204	83	428	4	4	269	95	14	1\n5	4	24	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	35	36	37\n5	4	24	1	3	6	56	345	460	1849	2873	4530	8183	19005	15483	79906	35560	1104538	33250	49736	2865	823	96	59	33	2	1314	307	1\n5	4	25	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38	39	40\n5	4	25	126	655	646	18876	18348	38924	9905	12911	18896	174704	153692	194218	245345	65591	4531916	126842	28783	20660	3423	522	8876	15	101	6	201	27	39	29	25\n5	4	26	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	39	40\n5	4	26	1	3	30	113	118	368	279	777	4195	26640	25370	184105	96495	94748	223441	5809939	32763	97070	13642	6152	8136	199	89	6	1861	1994\n5	4	27	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39\n5	4	27	2	1	4	117	281	1064	1708	3595	2213	3435	48470	38132	30972	20415	134241	174485	1422610	31132	23711	5088	2497	1840	604	3	151	3	17	64\n5	4	28	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n5	4	28	63	16	690	595	1577	5188	2734	7548	19196	73346	72767	11903	179957	419595	131384	4013327	42021	36311	27654	34	1473	828	383	9	327	37	39\n5	4	29	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	29	1	29	4	183	74	575	93	1564	4124	4212	4668	1103	39609	71089	65743	279505	1461003	24335	21162	2805	12826	4179	69	77	291	124	1	1\n5	4	30	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	30	1	6	10	131	78	121	970	1273	1059	1527	12319	5798	2554	35241	112269	41530	574762	240861	2651017	32148	344	1424	1708	1047	26	972	55	2	27\n5	4	31	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	31	2	3	1	71	15	533	664	1629	1804	3103	18425	52545	1227	151173	323932	8485	105207	32341	48748	2256769	2071	22986	4423	1804	495	237	2101	430	11988\n5	4	32	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n5	4	32	4	8	8	16	6	189	376	821	4837	8308	5978	16974	15646	243321	7624	1258	1509	1388	71	3\n5	4	33	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	38	39	40\n5	4	33	4	1	23	43	2	53	12	6	310	163	2962	384	1626	5565	18892	2630	54941	3578	661448	367	265	777	579	194	32\n5	4	34	15	16	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	34	1	1	6	1	22	28	37	1	212	279	176	6971	18648	4616	38278	1986	44381	538890	1701	557	488	3804	53	3185\n5	4	35	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	35	1	17	59	31	65	83	339	70	1595	1256	856	1900	5837	2525	2665	6472	10012	7766	19007	7130	12900	12543	2152487	2803	666	3826	1870	4717\n5	4	36	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	36	1	1	6	6	8	3	26	4	27	42	196	608	189	685	563	2198	1554	9196	13155	2736	1318	4679	11397	527695	1190	2313	130	984\n5	4	37	12	13	15	16	17	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	37	2	1	5	25	5	66	16	14	1270	204	42	242	1450	5236	2078	9375	13200	19860	15956	2507	7466	44135	548209	2361	1957	2055\n5	4	38	11	12	18	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	38	2	1	10	1	34	3	67	6	13	316	280	175	3920	82	1105	4884	4593	2849	3956	137938	1751	8087\n5	4	39	9	10	13	16	17	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	39	5	16	4	1	38	3	1	2	1	1	21	252	3855	1424	219	1935	1345	2168	2045	615	1136	22446	17617	4182	3035	144319	1967\n5	4	40	6	9	10	11	13	15	16	17	18	19	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n5	4	40	1	34	78	1	20	4	2	244	1	5	11	17	48	275	11069	2	18	27	71	15091	11	406	4455	8200	1917	2317	21118	17147	507530\n6	1	0	0\n6	1	0	374\n6	1	6	6	9	11	18\n6	1	6	174212	12448	1	1\n6	1	7	7	8	9	10	12	13	15	24\n6	1	7	235930	4643	6096	1350	283	93	6	1\n6	1	8	7	8	9	10	11	12	13	14	15	16	18	19	21	24\n6	1	8	448	348243	2020	1865	4550	8144	1302	3	444	52	2	1	1	1\n6	1	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	27\n6	1	9	58	612	1757	528102	5459	7619	7377	2289	610	487	42	243	52	12	1	2	1	1	2\n6	1	10	7	8	9	10	11	12	13	14	15	16	17	18	19	21\n6	1	10	177	320	5020	255317	3033	12051	2168	2209	611	330	137	726	10	2\n6	1	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24	25	26	28\n6	1	11	61	721	2321	5808492	148298	22856	8773	9961	2230	850	525	270	71	17	55	1	2	1	1\n6	1	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27\n6	1	12	197	651	939	176432	3734074	48347	158957	32807	12808	12586	8752	4001	6333	793	304	21	38	1	1\n6	1	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	27\n6	1	13	3	948	1520	851	22902	41183	4840643	42975	44124	35156	34574	5687	8536	1125	1014	135	96	21	1\n6	1	14	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29\n6	1	14	10	723	142556	26600	3171320	97421	54978	67151	31691	20224	27077	11542	1404	166	111	4	6	2	1\n6	1	15	8	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26\n6	1	15	253	8466	11282	24882	52432	1434546	20816	68182	36885	33717	20267	31503	15301	822	756	34	11\n6	1	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29\n6	1	16	170	1673	18817	51204	72051	26650	1557360	53578	57659	49053	7301	11686	19131	530	4855	820	478	194	1\n6	1	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	30\n6	1	17	23	60	74	191	30470	48414	41373	27339	1582180	34750	47815	16898	57114	40221	2337	1836	745	2081	124	4	1\n6	1	18	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n6	1	18	1	9	519	5702	17944	7802	41779	31916	973385	88966	15076	27886	21484	3791	18188	1589	959	387	1	26	1\n6	1	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\n6	1	19	3	318	476	21189	27523	10541	36119	30654	2259372	41592	79626	40854	28755	13750	27088	4518	1448	15	29	1	4	5\n6	1	20	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	32	37\n6	1	20	3	2	10	15362	2441	2757	2238	12261	29258	762567	34321	28950	4340	2006	43722	1777	793	34	72	1	61	2\n6	1	21	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	32	37\n6	1	21	1	3	35	99	15650	1932	55164	15224	34838	18655	1945461	98681	38897	50390	29019	17391	3288	47	110	17	16	9\n6	1	22	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34\n6	1	22	6	2	3	3877	58	3869	5239	20955	24166	59689	1455023	38354	55688	119412	23162	4726	226	1261	391	8	25	1\n6	1	23	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34\n6	1	23	1	2	4	3	13	2	286	999	912	3744	28830	18809	502923	38339	17599	49842	11791	177	2052	1070	1	68	43\n6	1	24	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	38\n6	1	24	1	2	3	26	13	90	144	466	2390	5050	20601	12160	653066	4355	58569	34325	216	1017	108	7	123	3	75	1	1	1\n6	1	25	11	12	13	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	40\n6	1	25	2	1	3	2	6	2	21	128	1113	897	2732	12985	3609	700104	9536	9575	252	30365	16683	2366	839	6	143	33	4	1\n6	1	26	12	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	38\n6	1	26	1	2	2	7	5	17	2226	648	6702	7521	7474	2265	559365	8848	5870	8926	1765	8178	2857	15	1531	18	2	2\n6	1	27	12	15	16	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	38\n6	1	27	1	3	3	26	49	151	608	1524	2880	3959	7304	292570	1385	4855	3304	3572	2541	368	490	8	5\n6	1	28	11	12	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	1	28	2	1	3	1	2	1	1	23	42	11	143	25	271	198	3560	2110	74659	834	773	2647	623	117	71	3	2	25	1\n6	1	29	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	1	29	1	1	3	1	3	52	35	74	102	495	1119	1914	4870	984	145521	2150	2522	5057	374	1901	190	25	53	296\n6	1	30	14	17	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	1	30	3	3	21	9	20	40	95	2119	3646	1191	1013	133118	16005	2281	1033	1122	96	40	77	5\n6	1	31	14	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	1	31	1	1	3	85	126	149	1534	818	2985	1802	202862	1481	2859	767	1457	586	253	1933	450\n6	1	32	16	18	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	1	32	1	2	1	10	20	18	516	1290	622	1265	810	1390	66742	3023	2626	5803	72	33	951	313\n6	1	33	16	19	20	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	1	33	1	1	2	2	16	333	145	335	912	704	1395	72351	811	7557	117	631	1208	1605\n6	1	34	24	25	26	27	28	29	31	32	33	34	35	36	37	38\n6	1	34	2	3	474	209	4	607	393	2132	282	31395	780	79	7	568\n6	1	35	17	21	22	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	1	35	1	1	1	2	7	1	36	94	54	151	272	1426	1101	86114	1471	482	3280	736\n6	1	36	23	26	28	29	30	31	32	33	34	35	36	37	38	40\n6	1	36	1	1	27	27	14	25	12	2	143	23	7199	196	1913	560\n6	1	37	20	22	26	27	28	29	31	32	33	34	35	36	37	38	40\n6	1	37	1	1	3	3	1	36	13	7	64	5	64	24	4798	508	161\n6	1	38	31	32	33	34	35	36	37	38	40\n6	1	38	230	482	250	45	594	307	215	33123	1010\n6	1	39	35	37	39\n6	1	39	1	1	8\n6	1	40	22	26	31	33	35	36	37	38	40\n6	1	40	1	1	144	274	1	2	23	541	21699\n6	2	0	0\n6	2	0	374\n6	2	6	6	9	12	13	21	27\n6	2	6	163795	10466	1	5	2	1\n6	2	7	7	8	9	10	11	12	13	15	17	19	22\n6	2	7	226986	4138	3448	1191	12	1234	65	93	1	1	1\n6	2	8	7	8	9	10	11	12	13	14	15	16	17	18	19\n6	2	8	506	336827	1416	1444	4999	9486	888	30	630	179	8	2	30\n6	2	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	26	28	32\n6	2	9	76	606	1744	532086	4146	4646	6924	2264	919	2023	222	231	630	94	2	20	1	1	1	1	1\n6	2	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	30	32\n6	2	10	153	308	4598	248237	2079	6719	1614	1442	818	599	236	1300	87	25	34	11	12	7	3	1	1\n6	2	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n6	2	11	60	662	2201	5733147	182700	35704	31214	14972	3570	22028	1706	1474	3834	596	73	40	5	3	2	1	1\n6	2	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n6	2	12	207	545	864	161291	3548345	46782	178776	43800	12086	53500	14025	18093	42949	2191	1214	75	252	82	5	21	1	1\n6	2	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27\n6	2	13	9	758	1222	768	18849	36247	4721344	41892	76619	34381	64950	12221	24022	14876	7470	508	542	288	111	12\n6	2	14	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	37\n6	2	14	10	675	125112	22155	2985410	91370	52733	109931	36043	35082	92381	53635	4888	686	832	735	78	478	1	118	2\n6	2	15	8	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	30	32	35	37\n6	2	15	126	7348	10205	21548	40975	1247359	17315	85484	44743	45834	88140	88563	40946	4088	2743	258	37	13	18	2	25	1	4\n6	2	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	31\n6	2	16	131	1417	13791	43360	61118	20334	1278118	57408	42074	111336	22892	24597	55488	887	31242	2036	1130	842	1	1\n6	2	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33\n6	2	17	25	58	71	181	27794	39519	34823	23779	1443086	38346	65949	59895	91949	108386	4392	3726	2422	4225	521	6	7	16	1	1\n6	2	18	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	33\n6	2	18	1	8	832	5159	16167	5348	29006	27802	845473	116203	26394	44472	26254	6664	60082	2743	1125	723	6	201	3\n6	2	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	37\n6	2	19	7	680	319	18489	22349	8740	33905	28395	2022753	42238	120653	61126	92373	41634	92655	8150	3822	36	233	1	5	27	1	13\n6	2	20	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	37\n6	2	20	14	1	13	14013	2143	2412	2082	10975	20855	713318	32903	26206	4838	3246	113074	1864	2436	48	216	3	8	71	1	8\n6	2	21	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n6	2	21	2	17	100	181	11565	1174	42597	13913	30969	20581	1692597	191404	53358	124265	59945	44678	8385	91	390	35	5	38	4	6	3\n6	2	22	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34\n6	2	22	3	3	3	3150	45	3054	3046	17611	19988	53149	1272916	43727	81526	217103	38544	11258	451	3385	2070	73	66	2\n6	2	23	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\n6	2	23	2	1	12	4	74	4	203	1455	907	3485	23084	16605	430578	43219	19969	80309	27133	446	4293	3472	5	125	1	49\n6	2	24	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	38\n6	2	24	2	6	2	6	12	70	94	320	3581	3061	21606	10518	669665	7327	84457	50242	359	1964	227	18	288	98	1\n6	2	25	13	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n6	2	25	3	2	5	1	47	136	1503	720	2394	15450	3211	816438	9024	17830	533	48258	30554	4501	1362	4	248	51	1	5\n6	2	26	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	2	26	1	1	1	5	4	21	6	16	2080	600	7144	6542	10008	3936	657166	11768	6314	16855	1379	13670	4157	16	2041	22	2	1	4\n6	2	27	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	2	27	2	2	3	1	5	2	38	56	171	547	1297	2818	4043	8688	337141	1429	7933	3177	7809	5283	439	1155	10	7	2	13\n6	2	28	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	2	28	5	1	1	29	36	9	120	35	255	162	3611	2319	72070	1142	653	4735	1075	153	199	12	13	72	4\n6	2	29	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	29	2	1	2	1	46	28	46	75	493	1094	1871	5824	1143	173188	1414	3966	8342	351	2724	238	34	75	476	2\n6	2	30	16	17	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	2	30	1	3	1	1	14	8	21	44	49	1437	3254	751	1187	126650	22606	3692	1025	1797	121	154	125	34\n6	2	31	14	15	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	31	1	1	2	2	1	1	2	54	124	142	1335	1060	3610	1492	220339	1515	3944	1126	1372	1007	385	2960	747\n6	2	32	14	18	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	32	1	1	2	1	6	13	21	514	1145	628	947	734	1375	65832	3404	3201	7220	62	32	1430	450\n6	2	33	19	21	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	33	1	2	1	1	23	239	102	222	637	696	1764	61252	1126	10767	255	914	2225	2220\n6	2	34	19	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	2	34	1	3	428	260	5	785	4	578	2227	340	35938	943	91	18	649\n6	2	35	24	25	26	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	35	1	1	4	36	65	36	167	306	1719	1444	90132	1704	528	5219	1381\n6	2	36	21	26	28	29	30	31	32	34	35	36	37	38	39	40\n6	2	36	1	2	38	28	9	57	37	187	15	5868	304	2688	1	689\n6	2	37	23	24	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	2	37	1	1	1	2	4	58	3	14	17	108	7	63	36	5671	611	215\n6	2	38	27	31	32	33	34	35	36	37	38	40\n6	2	38	1	349	713	343	43	730	381	248	40307	1220\n6	2	39	19	39\n6	2	39	1	7\n6	2	40	31	33	35	37	38	40\n6	2	40	169	349	1	18	673	25325\n6	3	0	0\n6	3	0	374\n6	3	6	6	8	9	10	11	19\n6	3	6	163861	1	2	1	4	2\n6	3	7	7	8	9	10	11	12	13	15	16	19\n6	3	7	228119	28	1	89	13	2	5	1	1	1\n6	3	8	7	8	9	10	11	12	13	15	16	17	18	19\n6	3	8	440	342866	6	58	24	170	501	123	2	1	1	1\n6	3	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22	26\n6	3	9	140	674	1743	548082	2364	179	331	899	1	17	6	41	7	13	2	1	1\n6	3	10	7	8	9	10	11	12	13	14	15	16	18	19	20	21	23	26	32\n6	3	10	185	354	4450	252608	284	427	549	5	1	123	1	1	1	3	1	1	1\n6	3	11	8	9	10	11	12	13	14	15	16	17	18	19	21	23	27\n6	3	11	68	739	2236	5812361	100604	12698	12	4771	962	60	27	27	3	1	1\n6	3	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23\n6	3	12	161	507	815	153463	3668332	14237	86838	7388	8796	111	747	1078	1	1	1	1\n6	3	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	26	27\n6	3	13	9	711	1192	759	18271	34073	4796888	10386	14097	28498	21066	2936	51	1	187	3	9	2	2\n6	3	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27\n6	3	14	1	3	10	759	120363	22300	3149357	28536	45765	27751	11880	13507	9615	298	7	4	2	1	1	1\n6	3	15	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	31\n6	3	15	117	1	7415	9639	20511	41713	1436415	8104	23161	3875	15171	1411	7684	2151	120	4	1	2	1	1\n6	3	16	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	37\n6	3	16	7	138	1366	13745	41336	58956	17557	1292811	12815	19717	4062	1496	328	17	9	6	2	9	2	1	1	1	1\n6	3	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27\n6	3	17	26	75	6	88	182	25876	38293	33493	23309	1741342	17793	28961	2939	31896	2104	129	51	1	38	5\n6	3	18	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	32\n6	3	18	4	9	43	998	4774	15535	5797	27735	27995	971163	16927	7751	10766	1908	2900	81	97	6	9	2	2\n6	3	19	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n6	3	19	1	3	30	1456	340	19600	22749	8937	41857	27208	2338644	15660	22429	12064	473	200	171	5	6	12	1\n6	3	20	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	32\n6	3	20	15	1	10	13269	1962	2326	4019	10363	26798	1054678	13729	17502	2339	7550	2219	1449	17	23	28	1	3\n6	3	21	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	32	37\n6	3	21	1	3	28	44	225	460	11581	1141	43221	14280	33737	21383	2044233	47231	18731	2847	491	660	177	11	18	16	3	2\n6	3	22	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n6	3	22	21	1	5	7	3086	55	2962	2928	17719	25897	67115	1676661	12156	20987	1576	6399	231	44	42	3\n6	3	23	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	33	37\n6	3	23	2	45	7	16	38	193	3	239	4013	936	3314	31204	18667	585353	9626	15684	5823	995	5	30	10	1	2\n6	3	24	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\n6	3	24	28	2	9	4	7	12	92	152	407	10830	3928	30951	13404	1003249	2128	11892	2178	140	187	22	4	5\n6	3	25	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37	39\n6	3	25	30	1	32	4	3	3	102	182	2885	907	2423	28711	3050	1298207	3716	2972	95	881	35	89	5	1	1	2	1\n6	3	26	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\n6	3	26	7	21	11	1	12	37	7	35	1973	1023	10161	8426	17105	5294	889485	8549	2780	1016	965	29	439	12	128\n6	3	27	11	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n6	3	27	6	20	6	1	5	1	74	105	287	612	1341	4314	4824	12454	450652	1676	6001	2593	576	1009	222	225	2\n6	3	28	13	14	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33\n6	3	28	1	2	2	3	30	33	15	106	39	219	148	3877	2438	75573	1085	451	990	490	58\n6	3	29	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n6	3	29	8	8	1	1	6	3	58	40	50	92	682	1252	2134	8878	1668	244770	260	3475	691	202	708	56	25	37\n6	3	30	13	14	16	17	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37\n6	3	30	2	18	3	3	1	5	27	8	16	45	59	1573	3999	786	1368	162530	943	646	525	8	3	1\n6	3	31	13	14	17	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n6	3	31	1	1	2	1	2	5	5	50	129	119	1303	1454	5513	1382	268553	922	526	772	49	1	1	231	2	123\n6	3	32	14	15	16	18	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	3	32	1	3	1	2	4	2	6	13	32	837	1370	661	1115	939	1033	86610	1369	2097	151	25	8	685\n6	3	33	16	20	22	24	25	26	27	28	29	30	31	32	33	34	35	37	38	40\n6	3	33	2	3	2	1	1	30	259	128	255	690	710	1840	66125	897	1667	105	353	388\n6	3	34	15	18	19	22	23	24	25	26	27	28	29	31	32	33	34	35	36	37	38\n6	3	34	1	1	1	1	1	4	6	512	362	16	993	792	2588	521	44347	1090	148	2	7\n6	3	35	20	22	25	26	28	29	30	31	32	33	34	35	36	37	38	40\n6	3	35	2	2	2	3	19	62	33	165	289	2277	1820	105619	18	6	1378	3\n6	3	36	22	28	29	30	31	32	34	35	36	37	38	40\n6	3	36	1	60	32	9	57	31	269	28	8727	33	365	3\n6	3	37	18	23	24	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n6	3	37	1	2	1	6	2	61	1	15	24	157	17	83	61	7713	271	1	12\n6	3	38	31	32	33	34	35	36	37	38	40\n6	3	38	453	963	602	67	1062	565	387	52617	578\n6	3	39	23	27	35	37	39	40\n6	3	39	1	1	1	2	2	1\n6	3	40	31	32	33	36	37	38	40\n6	3	40	241	1	495	1	29	808	30674\n6	4	0	0\n6	4	0	374\n6	4	6	6	7	8	9	11\n6	4	6	163995	1	1	3	1\n6	4	7	7	8	9	10	12	14\n6	4	7	229362	2	3	58	1	1\n6	4	8	7	8	9	10	12	13	14	15	19\n6	4	8	7384	337818	6	32	106	656	4	70	1\n6	4	9	6	7	8	9	10	11	12	13	14	17	18\n6	4	9	12712	5716	4199	528990	2052	94	232	1021	9	44	1\n6	4	10	7	8	9	10	11	12	13	14	16	18\n6	4	10	1633	2032	7145	246923	235	377	642	9	104	1\n6	4	11	7	8	9	10	11	12	13	14	15	16	17	18\n6	4	11	29	8066	7341	4638	5851165	104222	13273	44	4826	826	46	4\n6	4	12	7	8	9	10	11	12	13	14	15	16	17	18	19	25\n6	4	12	2311	13433	10557	9611	260334	3532776	15680	88484	7486	8821	120	415	349	1\n6	4	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	27\n6	4	13	120	1506	3687	2360	49602	73076	4733131	10565	14526	28668	21072	2884	19	3	43	1	1\n6	4	14	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n6	4	14	1	61	1511	2349	46242	234645	59433	2954256	27125	45504	28941	11842	12404	10123	88\n6	4	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23\n6	4	15	277	1224	2973	1402	21276	56836	109616	113593	1217558	10433	24036	3488	13939	1509	7444	2149	28\n6	4	16	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26\n6	4	16	311	406	910	5218	18164	49728	66556	27141	1242099	12728	19473	3990	1558	303	12	2	2	6	3\n6	4	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	28\n6	4	17	49	459	579	33030	66261	76769	126909	98595	69670	1399055	17749	23230	1572	30557	2123	129	36	18	2\n6	4	18	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	30	31\n6	4	18	3	4	1097	2613	2729	18213	18638	47983	54126	55402	49664	798314	17501	7498	10677	1795	857	58	31	1	1	1\n6	4	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	28\n6	4	19	72	195	207	3166	23445	38872	47116	67015	143153	84332	142818	1904626	10735	20967	10896	498	153	95	1	7\n6	4	20	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	35\n6	4	20	1	1	20	112	5178	54493	18828	107203	94408	26192	57272	31907	67555	662894	13923	12917	2321	2313	961	1474	18	23	30	1\n6	4	21	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	30\n6	4	21	1	1	46	63	1065	3734	12595	66614	107937	32573	105211	50971	144691	40512	1618991	35068	13348	1905	398	299	62	8	16\n6	4	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31\n6	4	22	7	33	127	1818	752	6467	49428	65428	126361	34926	76872	35809	217737	1178234	10368	12479	1421	4086	205	29	47	4	1\n6	4	23	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n6	4	23	7	34	95	196	1316	1306	8839	1758	6974	9855	113375	6574	62519	57560	385758	6622	6750	3828	864	6	26	8\n6	4	24	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\n6	4	24	1	26	6	465	523	1578	4465	41696	4982	68374	40551	4299	151987	102434	52938	586072	2213	5889	1263	146	145	22	7	5\n6	4	25	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37\n6	4	25	6	115	169	1085	627	3084	5582	5279	148401	146255	59775	285636	27790	9222	633488	2476	2389	107	717	26	80	4	1	8	3\n6	4	26	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n6	4	26	1	7	14	20	10	148	155	1843	5436	1950	10192	2692	58492	58054	96074	108673	12860	574371	5564	2492	855	841	23	188	8	64	1\n6	4	27	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\n6	4	27	11	33	17	698	28	1136	698	1619	6422	3743	11282	17148	34123	58061	19891	15279	306127	1381	3188	1831	559	861	137	141\n6	4	28	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33\n6	4	28	4	4	4	7	13	72	85	202	904	721	520	748	8344	2016	69301	662	499	562	451	37\n6	4	29	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n6	4	29	1	6	2	154	34	12	16	351	422	371	688	7897	8665	3224	65015	19767	9558	1658	142361	365	1751	533	142	395	26	19	26\n6	4	30	10	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	40\n6	4	30	6	7	3	2	17	3	14	7	44	4812	5789	397	41818	1989	4465	954	3115	104705	915	402	465	10	1\n6	4	31	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38	40\n6	4	31	1	2	3	9	14	24	191	63	166	8399	18451	11052	6073	6881	31599	192664	1283	524	505	22	1	122	78\n6	4	32	15	16	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	4	32	34	1	41	107	71	120	288	572	2426	6056	7400	1529	10889	4661	1771	57421	1153	1483	157	13	9	360\n6	4	33	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	38	40\n6	4	33	3	7	1	2	4	3	2	6	8	54	635	283	531	1378	5821	5014	57225	531	1109	71	169	236\n6	4	34	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	4	34	9	12	169	234	536	3818	1734	332	4386	2797	1075	3622	805	31141	580	86	3	8\n6	4	35	18	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	4	35	1	4	127	96	28	32	622	278	2442	13484	13565	1470	76789	6	6	863	2\n6	4	36	22	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	4	36	1	1	2	8	5	95	54	215	1413	74	307	118	2123	4943	7	208\n6	4	37	12	14	15	16	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n6	4	37	1	3	8	1	11	12	11	7	2	9	9	5	124	102	250	618	69	1158	26	740	347	4610	204	1	5\n6	4	38	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	4	38	1	2	17	31	26	988	108	4989	2107	3062	937	6324	3202	749	33820	352\n6	4	39	31	39\n6	4	39	1	5\n6	4	40	25	28	30	31	32	33	35	36	37	38	40\n6	4	40	1	2	9	1350	691	2977	2019	896	244	1633	21960\n6	5	0	0\n6	5	0	374\n6	5	6	6	8	9\n6	5	6	176705	1	1\n6	5	7	7	8	9	10	15\n6	5	7	246704	3	1	129	2\n6	5	8	7	8	9	10	11	12	13	15	18	21\n6	5	8	4785	362960	1	30	4	120	714	164	1	1\n6	5	9	6	7	8	9	10	11	12	13	14	15	16	17	18	20\n6	5	9	6562	4401	3584	545488	2851	188	318	994	1	1	1	63	1	2\n6	5	10	7	8	9	10	11	12	13	14	16	19	21	23	24\n6	5	10	1075	1453	7868	261916	471	447	683	9	106	1	2	1	1\n6	5	11	7	8	9	10	11	12	13	14	15	16	17	23\n6	5	11	9	4600	6533	4766	6126475	113519	16677	30	5785	1127	55	1\n6	5	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	27\n6	5	12	135	5662	6031	8245	214931	3815183	19297	98417	8137	12449	175	468	103	1	1\n6	5	13	7	8	9	10	11	12	13	14	15	16	17	18	19	21\n6	5	13	44	1381	2607	2256	32163	77894	4944284	13789	17106	34467	22579	3082	8	18\n6	5	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24	25\n6	5	14	3	466	2297	12964	207149	60681	3198128	34453	52153	34272	13075	14979	10122	41	1	4	1\n6	5	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25\n6	5	15	64	1121	431	558	12171	40666	65672	123274	1461590	13069	27224	5511	17722	1620	10989	2741	5	9	1\n6	5	16	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	25	26\n6	5	16	1	36	45	270	2994	20094	50217	70208	35027	1550772	14388	28127	4048	1838	328	17	1	1	2\n6	5	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	37\n6	5	17	29	212	345	1875	16080	40342	80922	78926	62647	1563457	19826	23766	1582	39374	2983	181	36	1	7	4	1\n6	5	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	28	29\n6	5	18	3	59	444	396	6887	7201	34319	40870	68773	42875	960603	16700	8387	10663	3450	509	74	29	5	1\n6	5	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	28\n6	5	19	8	4	15	449	3989	8542	25606	44904	53986	57563	85011	2251472	15453	23990	13170	250	162	98	3	13\n6	5	20	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n6	5	20	2	6	3	58	8194	1759	29512	18410	7173	15038	15455	69743	736451	12034	16242	2495	1465	798	1467	22	22	25\n6	5	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n6	5	21	7	15	41	585	1344	13940	38776	16121	67991	26846	83694	37034	1917990	39692	17516	3375	499	295	35	6	19	17\n6	5	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n6	5	22	2	1	2	344	290	1744	16484	19371	40155	23210	53631	39630	106620	1446591	12114	11877	1657	3868	291	45	43	4\n6	5	23	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n6	5	23	1	2	7	26	48	92	271	1386	563	1759	4204	28967	5288	48258	49367	481421	7430	5788	4059	947	2	34	11\n6	5	24	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\n6	5	24	43	99	230	1139	5811	2048	16015	11818	2463	55416	72959	42602	572433	2421	3404	1408	152	218	33	7	4\n6	5	25	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37\n6	5	25	1	19	1	19	58	1092	1029	1537	29090	39348	21488	115236	25511	4839	553508	1136	2216	86	842	54	75	6	3	8	4\n6	5	26	10	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n6	5	26	2	1	26	54	640	2265	685	4441	2115	22452	34541	54575	64962	15581	455015	4103	2375	984	1187	19	196	32	78	3\n6	5	27	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\n6	5	27	4	525	408	463	2319	1153	4096	6771	14364	38266	9579	10736	256964	1225	2553	2040	686	959	240	73\n6	5	28	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	36	37\n6	5	28	8	2	48	61	101	667	370	357	395	8025	1896	70559	409	794	401	436	71	1	1\n6	5	29	12	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n6	5	29	1	3	4	11	184	183	199	164	3379	4164	1564	28209	7975	7110	1569	117822	388	1373	754	207	273	51	11	9\n6	5	30	10	13	15	17	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	35\n6	5	30	1	1	9	36	4	1	30	1307	2276	272	19532	3026	4680	1320	5974	108992	1152	450	538	12\n6	5	31	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38	40\n6	5	31	1	3	5	2	6	35	24	164	3944	7431	4781	2689	4726	18001	172108	1211	503	276	23	4	62	44\n6	5	32	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	5	32	7	96	12	37	150	278	1744	3261	4533	1110	6338	2215	1917	62273	743	1217	103	5	6	164\n6	5	33	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	38	40\n6	5	33	1	8	1	4	4	4	5	9	4	43	600	331	566	1506	6609	6184	64386	348	656	49	107	141\n6	5	34	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	5	34	5	8	142	153	404	2338	1072	159	3267	1685	796	2682	396	23283	356	54	4	7\n6	5	35	17	20	21	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	5	35	2	1	2	4	105	33	26	46	635	261	4074	9931	8780	918	64637	8	7	437	2\n6	5	36	26	27	28	29	30	31	32	33	34	35	36	37	38\n6	5	36	5	3	52	33	161	1402	169	154	81	1846	5488	13	106\n6	5	37	16	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	5	37	1	7	13	5	2	1	9	3	9	90	71	118	571	84	755	10	550	157	3223	42	7\n6	5	38	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n6	5	38	25	21	12	727	54	3942	1404	1549	503	3802	1856	458	22823	211\n6	5	39	35	39\n6	5	39	1	5\n6	5	40	25	29	30	31	32	33	35	36	37	38	40\n6	5	40	1	2	3	1078	661	2077	1518	698	162	1126	15308\n7	1	0	0\n7	1	0	205\n7	1	6	6	9	22	24\n7	1	6	108554	8828	1	1\n7	1	7	7	8	9	10	11	12	13	15	19	28\n7	1	7	110873	2150	2886	911	1	144	47	5	1	1\n7	1	8	7	8	9	10	11	12	13	14	15	16\n7	1	8	221	161878	1103	1205	2021	3603	556	1	233	29\n7	1	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19\n7	1	9	32	296	827	238416	2269	3513	3218	880	281	190	20	104	3	4\n7	1	10	7	8	9	10	11	12	13	14	15	16	17	18	19	21\n7	1	10	65	190	2037	120652	1308	6202	994	1196	259	116	44	107	5	2\n7	1	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24\n7	1	11	24	344	1090	2600831	50608	7910	2522	3365	608	226	106	4	15	6	26	2\n7	1	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24\n7	1	12	71	234	331	65386	1430693	25949	54817	15146	2000	6728	330	1468	3585	472	7	4	1\n7	1	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27\n7	1	13	1	362	445	372	7657	23677	2075696	32060	31516	6652	17548	2327	145	1502	3083	9	40	2	2	1\n7	1	14	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27\n7	1	14	5	276	41902	15314	1138529	37895	25590	20620	6119	2459	9336	8039	9	54	51	3	4	1\n7	1	15	8	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27\n7	1	15	126	2661	4903	19595	7794	667952	5727	48541	21547	1926	5691	26598	169	5806	615	46	3	1\n7	1	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	30\n7	1	16	25	546	3380	12865	45384	14611	1017985	48803	33937	772	13819	38990	62	1520	4009	14	97	135	26	1\n7	1	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n7	1	17	16	23	34	35	9641	1883	17527	15915	763592	42756	2170	11724	50309	55	22545	866	12	35	24	2\n7	1	18	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	32\n7	1	18	1	2	124	1755	5312	2044	8564	6888	518969	4254	12472	30776	639	40983	13393	1192	540	1769	29	2\n7	1	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31\n7	1	19	1	6	27	2475	284	740	2898	7431	201261	10249	3894	750	1845	3111	2456	171	1817	1	7	1\n7	1	20	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	1	20	1	1	2	4612	607	49	470	1875	1971	211156	5154	3829	5445	6915	9397	2646	9972	1	176	2	1	26	1\n7	1	21	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\n7	1	21	15	31	9260	1959	1321	2418	1632	2365	607003	1561	31895	23675	8619	8682	4068	228	3651	1	9	14\n7	1	22	11	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32\n7	1	22	3	1	321	125	10	179	211	290	3597	70365	791	2196	1265	1142	4961	90	775	389	12\n7	1	23	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31\n7	1	23	3	1	12	5	111	9	697	3031	111	195450	1039	470	113	127	431	475	52	184\n7	1	24	12	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	1	24	1	1	2	20	123	35	1071	3411	618	1706	111147	5729	4312	1069	542	7249	43	336	10	4	1\n7	1	25	12	13	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	1	25	2	1	1	3	19	209	750	185	586	1706	84100	444	8751	679	10590	32	197	42	2	5\n7	1	26	13	16	17	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	1	26	1	3	5	1	22	59	277	69	854	169	30872	128	219	1074	68	88	16	127	23\n7	1	27	13	14	16	18	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	1	27	2	1	1	7	18	28	140	61	779	148	312	65280	65	201	11	992	7	18\n7	1	28	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	1	28	5	17	74	148	822	465	412	185	26565	1441	419	581	294	10	19	148\n7	1	29	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36	37	40\n7	1	29	1	1	12	16	21	113	96	292	424	889	67765	221	506	968	330	203	1	273	1\n7	1	30	19	22	24	25	26	27	28	29	30	31	32	33	34	37	40\n7	1	30	2	6	7	3	10	63	192	69	4202	172	343	88	38	252	104\n7	1	31	14	19	22	24	25	26	27	28	29	30	31	32	33	34	37	40\n7	1	31	1	1	1	9	18	3	126	210	442	164	16233	116	434	271	325	39\n7	1	32	21	23	25	26	27	28	29	30	31	32	33	34	37	40\n7	1	32	1	1	2	1	12	18	119	48	83	4972	15	23	59	27\n7	1	33	14	17	28	29	30	32	33	34	37	40\n7	1	33	1	1	3	179	68	69	4353	368	566	93\n7	1	34	25	26	29	30	31	32	34	37\n7	1	34	2	1	34	24	10	95	2763	9\n7	1	35	17	20	21	24	29	33	34	35\n7	1	35	1	2	1	1	1	2	1	7\n7	1	36	32	35	37\n7	1	36	1	1	1\n7	1	37	25	27	28	29	30	31	32	33	34	35	37	40\n7	1	37	1	3	1	6	6	2	33	63	60	2	4652	5\n7	1	38	38\n7	1	38	1\n7	1	39	39\n7	1	39	1\n7	1	40	21	32	37	40\n7	1	40	1	2	17	584\n7	2	0	0\n7	2	0	205\n7	2	6	6	9	13\n7	2	6	102432	6153	1\n7	2	7	7	8	9	10	11	12	13	14	15	21\n7	2	7	106875	1822	1398	680	5	573	39	1	62	1\n7	2	8	7	8	9	10	11	12	13	14	15	16	17	18	24	25\n7	2	8	258	156897	697	839	2198	4008	330	20	300	91	2	2	1	1\n7	2	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	23	27	28	30\n7	2	9	49	277	798	244047	1577	1978	2994	926	593	803	82	121	15	43	7	3	1	1	1\n7	2	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24\n7	2	10	65	182	1869	118116	863	3135	715	895	464	218	133	161	29	4	6	5	1\n7	2	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28\n7	2	11	27	324	1100	2575978	66700	13922	9612	5629	1125	7790	126	222	1399	229	31	20	2	2	2	1\n7	2	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27\n7	2	12	72	224	324	58503	1345365	26656	60426	18869	2162	23194	1295	6280	22376	2494	164	26	56	7	6\n7	2	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28\n7	2	13	4	225	394	296	6059	19519	1989186	30440	43972	6448	40846	6833	1273	10996	14227	101	347	58	26	1	2\n7	2	14	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n7	2	14	1	2	280	35746	11148	1080535	29399	26046	41504	6488	4426	32766	27612	68	211	389	2	20	197	1	62\n7	2	15	8	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	32\n7	2	15	70	2158	4367	15277	7503	570764	5444	63408	25578	3675	26764	57595	242	16485	1636	190	24	3	1	28	15\n7	2	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29\n7	2	16	28	416	2645	10625	36478	12170	792625	49408	25124	462	38741	94511	68	3918	17728	252	212	567	108\n7	2	17	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	37\n7	2	17	17	28	30	53	8195	1655	12698	13013	670820	31280	2599	32076	89326	110	53827	1914	16	99	64	3	1	1\n7	2	18	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	32\n7	2	18	2	3	250	1544	4692	1981	7110	5925	416132	4146	16713	34810	621	99283	39402	1302	567	3796	2	58	11\n7	2	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31\n7	2	19	1	36	23	2080	262	519	2317	5965	173611	8838	7504	704	4215	5365	2710	254	3879	1	63	1	2\n7	2	20	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\n7	2	20	2	2	2	3878	490	63	466	1551	1722	213408	8378	2704	10296	11427	8118	3238	18219	1	233	1	2	27\n7	2	21	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\n7	2	21	4	57	99	7378	1705	2044	2327	1693	4564	609535	1523	58717	35230	16441	26226	9903	666	7110	1	5	6\n7	2	22	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\n7	2	22	1	1	2	248	113	11	145	211	245	3143	58743	1543	2667	2106	2047	5271	234	1521	3	592	37\n7	2	23	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\n7	2	23	1	2	2	46	4	14	366	21	605	4615	114	299256	1542	400	245	277	397	855	83	150	1\n7	2	24	11	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	2	24	2	2	1	1	26	177	34	1354	3296	563	2413	132344	6851	9742	1254	582	12210	17	430	12	1	2\n7	2	25	13	15	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	2	25	1	1	15	56	382	495	148	492	1911	79965	692	13214	832	15661	77	142	111	3	11\n7	2	26	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	2	26	1	6	19	4	5	50	67	277	146	1150	255	46174	304	259	1063	88	43	31	122	28\n7	2	27	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	2	27	1	2	1	18	1	39	56	109	108	1203	295	579	94349	153	327	13	1648	6	9\n7	2	28	16	17	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	2	28	1	1	7	60	114	665	366	403	414	23757	2311	646	518	633	1	22	218\n7	2	29	17	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37	40\n7	2	29	1	2	1	8	7	18	151	123	404	683	903	88991	302	491	1444	275	252	246	7\n7	2	30	22	23	24	25	26	27	28	29	30	31	32	33	34	37	40\n7	2	30	1	2	3	4	19	57	185	101	3735	196	401	54	47	448	109\n7	2	31	14	19	21	24	25	26	27	28	29	30	31	32	33	34	37	40\n7	2	31	1	1	2	8	6	14	211	90	510	253	17463	133	333	386	320	53\n7	2	32	23	25	26	27	28	29	30	31	32	33	34	36	37	40\n7	2	32	1	3	2	15	14	150	51	94	6464	3	50	1	143	31\n7	2	33	29	30	31	32	33	34	35	36	37	40\n7	2	33	165	79	3	35	4031	411	1	1	608	94\n7	2	34	20	26	27	28	29	30	31	32	33	34	37\n7	2	34	1	1	1	1	35	24	18	138	2	3513	12\n7	2	35	29	34	35\n7	2	35	1	1	8\n7	2	36	36\n7	2	36	1\n7	2	37	23	26	27	28	29	30	31	32	33	34	36	37	40\n7	2	37	1	4	9	1	10	12	15	59	78	59	1	6093	8\n7	2	38	27\n7	2	38	1\n7	2	39	39\n7	2	39	1\n7	2	40	32	37	40\n7	2	40	2	24	827\n7	3	0	0\n7	3	0	205\n7	3	6	6	8	9	10	11	12	13	15	19	21\n7	3	6	102465	3	1	1	3	1	2	3	1	1\n7	3	7	7	8	9	10	11	12	13	15	16	19	23\n7	3	7	107421	17	1	21	11	1	2	2	1	1	1\n7	3	8	7	8	9	10	11	12	13	15	16	21\n7	3	8	229	159607	5	14	9	48	122	71	4	1\n7	3	9	6	7	8	9	10	11	12	13	14	15	16	17	19\n7	3	9	93	295	845	252670	783	74	117	228	2	6	1	20	1\n7	3	10	7	8	9	10	11	12	13	14	16	18	19	21	32\n7	3	10	63	151	1762	120526	98	147	195	3	14	1	2	1	1\n7	3	11	8	9	10	11	12	13	14	15	16	17	18	19	23\n7	3	11	21	330	981	2610735	31329	3542	12	1256	240	27	2	1	1\n7	3	12	8	9	10	11	12	13	14	15	16	17	18	19	21\n7	3	12	53	227	314	55040	1394731	8004	22306	2993	1328	46	291	64	1\n7	3	13	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22	26\n7	3	13	8	208	361	303	5715	19160	2027175	4763	8256	6111	5717	779	8	86	1	1\n7	3	14	8	10	11	12	13	14	15	16	17	18	19	20	21	24\n7	3	14	4	5	307	34029	10529	1157096	6007	22612	1106	3096	1404	2593	124	1\n7	3	15	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23\n7	3	15	56	1	2086	3942	15007	8443	657098	5339	7151	1447	262	306	4148	161	91\n7	3	16	9	10	11	12	13	14	15	16	17	18	19	20	21	22	26	27\n7	3	16	2	17	402	2437	10018	34139	10762	786764	6912	4117	118	9	1010	58	12	1\n7	3	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	31\n7	3	17	12	24	2	41	49	7469	1552	12271	12213	867430	3387	1605	781	1134	4	16	33	27	1\n7	3	18	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29\n7	3	18	2	3	5	332	1412	4276	2664	6810	6681	494315	3565	1071	1410	55	797	163	38	3	1	1\n7	3	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	31\n7	3	19	3	98	29	2005	430	504	2756	5751	185649	1772	1325	99	2	28	58	1\n7	3	20	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n7	3	20	1	5	3784	489	34	1249	1986	3143	394392	2297	156	396	2631	672	78	5	4\n7	3	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n7	3	21	1	3	2	4	129	288	7591	1733	3244	2396	2187	5277	926121	1710	4123	2684	311	46	69	3	2\n7	3	22	11	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n7	3	22	3	238	122	11	149	210	314	2983	61696	35	299	81	127	86	3	1\n7	3	23	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31\n7	3	23	2	6	2	10	147	4	45	1315	27	577	9345	85	536704	2452	314	186	139	68	18	1\n7	3	24	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n7	3	24	2	1	3	1	1	43	248	46	4159	4617	579	3607	236924	1593	1475	1133	409	2	1	5	1	1	1	1\n7	3	25	12	13	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31\n7	3	25	2	2	1	2	37	61	919	712	167	454	2477	113829	372	210	165	27	2	2\n7	3	26	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	37\n7	3	26	1	2	2	10	40	11	6	140	116	233	242	2400	667	85943	688	237	223	6	2\n7	3	27	12	14	15	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	3	27	1	1	2	20	1	63	134	168	188	2119	406	1105	147229	316	681	5	250	1	5\n7	3	28	12	20	21	22	23	24	25	26	27	28	29	30	31	32\n7	3	28	1	2	8	60	137	653	342	426	528	24992	763	82	77	16\n7	3	29	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	3	29	1	1	2	8	9	17	16	244	174	540	1142	1306	127543	34	287	100	115	27	7\n7	3	30	14	15	16	17	19	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	3	30	2	1	1	1	1	7	1	3	2	23	53	201	124	4774	122	13	40	14	5\n7	3	31	17	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\n7	3	31	1	1	1	5	7	16	7	443	100	528	214	20404	65	1	18	1\n7	3	32	14	26	27	28	29	30	31	32	33	34	35	37\n7	3	32	1	4	32	17	224	32	140	9013	10	63	2	28\n7	3	33	20	29	30	32	33	35	37\n7	3	33	1	215	78	35	4537	2	35\n7	3	34	29	30	31	32	33	34	37\n7	3	34	42	33	24	171	1	4447	23\n7	3	35	20	25	33	35\n7	3	35	1	1	1	6\n7	3	36	30	36\n7	3	36	2	2\n7	3	37	25	26	27	28	29	30	31	32	33	34	35	37	40\n7	3	37	1	2	10	2	18	17	16	86	82	96	1	7819	13\n7	3	39	39\n7	3	39	1\n7	3	40	32	37	40\n7	3	40	5	30	1094\n7	4	0	0\n7	4	0	205\n7	4	6	6	7	8	9	12	14	18\n7	4	6	102546	2	3	2	2	2	1\n7	4	7	7	8	9	10	12	14\n7	4	7	107970	18	8	16	3	1\n7	4	8	7	8	9	10	12	13	14	15	17\n7	4	8	269	160394	33	10	45	186	5	34	1\n7	4	9	6	7	8	9	10	11	12	13	14	15	16	17	18\n7	4	9	106	260	806	252981	713	49	112	302	26	2	1	24	5\n7	4	10	7	8	9	10	11	12	13	14	15	16	17	18\n7	4	10	89	154	1708	120606	69	94	215	13	1	14	7	5\n7	4	11	7	8	9	10	11	12	13	14	15	16	17	18	20	21\n7	4	11	36	47	487	1045	2634110	33149	3871	107	1306	341	26	13	4	1\n7	4	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20\n7	4	12	11	67	252	349	52014	1397733	8299	22982	3041	1352	40	223	66	2\n7	4	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	27\n7	4	13	16	220	1222	348	5102	18622	2031165	5296	8868	6302	5819	823	4	9	58	1	1	1\n7	4	14	7	9	10	11	12	13	14	15	16	17	18	19	20	21	24\n7	4	14	3	34	11	296	32846	9644	1158249	6041	23126	1081	3193	1426	2613	121	1\n7	4	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26\n7	4	15	3	62	44	14	1821	3832	14071	8141	662322	5652	7371	1652	217	346	4514	139	86	1	1\n7	4	16	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	26	37\n7	4	16	70	33	377	2348	9411	32338	10409	776375	6974	4232	115	11	1072	61	4	14	2\n7	4	17	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24	26	28	37\n7	4	17	1	11	111	45	46	141	7137	1539	11696	11447	862928	3451	1773	836	1252	12	28	27	1	1\n7	4	18	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n7	4	18	1	65	19	2	309	1275	4285	2555	6268	6504	490659	3688	1150	1444	67	840	176	39	1	1	1\n7	4	19	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	28	31\n7	4	19	1	1	120	12	2	90	31	2021	399	496	2667	5490	183666	1866	1326	91	1	33	50	1	1\n7	4	20	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n7	4	20	1	199	8	1	9	9	3478	430	42	1244	1902	3183	395462	2335	158	393	2786	661	76	7	1\n7	4	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30\n7	4	21	69	23	4	29	141	323	7213	1597	3237	2459	2101	5336	923846	1805	4083	2826	381	37	70	3	1\n7	4	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n7	4	22	28	86	4	20	2	17	249	114	14	189	180	254	2796	60598	30	385	69	119	99	4\n7	4	23	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31\n7	4	23	9	48	2	14	5	21	139	2	52	1436	8	570	8821	72	532400	2525	333	146	137	66	9	1\n7	4	24	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31\n7	4	24	26	80	25	1	26	1	1	60	271	46	4137	4322	534	3443	235362	1639	1629	1076	433	2	1	3\n7	4	25	10	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	4	25	2	1	2	2	1	38	85	928	701	127	406	2268	113043	390	279	193	31	1	1	1	1	4\n7	4	26	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	37\n7	4	26	4	22	7	12	6	7	7	10	41	70	2	155	80	242	252	2341	645	85344	677	253	196	2	1	1\n7	4	27	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	37\n7	4	27	2	72	7	7	7	7	2	10	64	1	37	114	156	171	1996	421	1069	146333	280	736	5	260	11\n7	4	28	10	12	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	37\n7	4	28	7	3	4	2	6	10	39	1	2	5	57	108	597	300	450	579	24610	852	111	64	12	5\n7	4	29	10	11	15	16	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	4	29	4	1	1	1	2	5	10	17	15	250	167	539	1028	1244	126488	43	319	134	109	30	5\n7	4	30	10	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	4	30	40	15	1	5	25	2	35	8	19	1	78	1	4	14	4	20	146	147	4506	130	9	40	17	13\n7	4	31	10	13	14	15	17	18	19	22	23	24	25	26	27	28	29	30	31	32	34	37\n7	4	31	4	1	2	1	1	8	1	2	1	3	7	5	399	91	508	208	19996	81	9	2\n7	4	32	16	19	20	21	22	25	26	27	28	29	30	31	32	33	34	35	37\n7	4	32	10	3	1	1	1	10	4	25	19	196	17	146	8948	16	71	1	38\n7	4	33	22	29	30	32	33	34	37\n7	4	33	1	194	82	28	4441	1	41\n7	4	34	13	16	18	19	29	30	31	32	34	37\n7	4	34	1	1	1	1	47	23	19	175	4372	26\n7	4	35	15	33	35	37\n7	4	35	1	2	8	1\n7	4	36	24	36\n7	4	36	1	2\n7	4	37	26	27	28	29	30	31	32	33	34	37	40\n7	4	37	3	15	3	16	12	29	60	82	80	7639	15\n7	4	39	32\n7	4	39	1\n7	4	40	32	37	40\n7	4	40	2	45	1060\n7	5	0	0\n7	5	0	205\n7	5	6	6	8	9\n7	5	6	102648	3	1\n7	5	7	7	8	10	15\n7	5	7	108633	6	21	2\n7	5	8	7	8	9	10	12	13	15	18\n7	5	8	3727	157826	2	5	22	160	41	1\n7	5	9	6	7	8	9	10	11	12	13	15	17\n7	5	9	8643	2715	2113	242743	920	45	67	207	1	20\n7	5	10	7	8	9	10	11	12	13	14	16	21\n7	5	10	1016	1277	3235	117654	139	88	194	4	9	1\n7	5	11	7	8	9	10	11	12	13	14	15	16	17	25\n7	5	11	16	3891	3506	2075	2645240	33646	3862	9	1367	270	24	1\n7	5	12	7	8	9	10	11	12	13	14	15	16	17	18	19\n7	5	12	1132	6126	5070	5154	102156	1333318	8492	23388	3011	1343	63	169	23\n7	5	13	7	8	9	10	11	12	13	14	15	16	17	18	19	21	23\n7	5	13	85	789	1658	1187	21117	42584	1990894	5475	8765	6693	5786	755	1	10	1\n7	5	14	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	24	25\n7	5	14	1	23	1315	1566	15547	82090	40892	1060957	4694	23365	1146	3271	1444	2542	36	1	1\n7	5	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	27\n7	5	15	173	641	1428	1026	8925	26261	68228	37242	550864	6588	7397	1049	151	319	4276	152	13	2	1\n7	5	16	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	26\n7	5	16	3	171	189	399	1346	3505	9483	35993	9572	759944	7280	4139	140	31	934	44	2	4\n7	5	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	30\n7	5	17	18	225	301	12935	31259	53926	50758	74927	62046	606317	3084	1280	253	746	2	5	19	1	11	1\n7	5	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27\n7	5	18	3	86	377	307	2371	11457	9049	35694	34123	49762	366937	3721	757	1336	47	133	94	6	1\n7	5	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25\n7	5	19	10	87	80	297	7979	1506	5279	4354	907	3425	6033	164518	933	1033	103	2	12	17\n7	5	20	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n7	5	20	8	4	13	2000	30351	13315	38019	30049	45896	30339	20169	13909	185336	2627	124	418	876	258	22	7	3\n7	5	21	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	32\n7	5	21	2	10	22	467	3965	20136	34563	76773	125518	100049	37731	8846	9473	530107	1797	1549	1582	184	18	24	1	2	1\n7	5	22	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31\n7	5	22	1	3	1	5	33	195	120	63	321	124	174	1160	1195	3676	2455	54141	28	273	58	146	27	7	1\n7	5	23	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n7	5	23	7	12	14	44	92	1002	417	27877	6761	96493	122550	5827	11985	58635	1545	207327	1169	338	46	36	57	9\n7	5	24	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31\n7	5	24	1	2	161	145	723	2540	25364	2616	41174	7620	13804	44286	3387	1875	105346	1036	643	458	400	2	4\n7	5	25	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	32	37\n7	5	25	1	3	12	46	17	373	352	54	2380	5041	11648	21696	3092	628	8053	63831	151	160	202	29	1	2	7\n7	5	26	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	37\n7	5	26	2	7	4	42	48	408	110	913	443	4324	31210	2489	314	9681	868	38411	247	189	144	2	1	1\n7	5	27	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	37\n7	5	27	16	3	274	13	865	89	7237	7393	25633	13306	7158	338	1714	15079	373	70724	143	272	113	3\n7	5	28	13	17	20	21	22	23	24	25	26	27	28	29	30	31	32	33	37\n7	5	28	1	3	2	1024	368	655	827	1060	343	204	22309	432	63	52	4	1	1\n7	5	29	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	5	29	2	76	32	128	1	126	92	399	12312	2964	1439	17526	20026	1716	448	2890	68794	33	234	74	86	21	3\n7	5	30	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	5	30	1	1	6	141	43	151	144	17	911	481	2946	125	7	29	6	3\n7	5	31	14	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\n7	5	31	1	3	4	5	11	915	332	682	338	96	1891	925	738	240	14734	46	1	8\n7	5	32	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	5	32	11	3	15	3	50	23	65	2	10	173	49	40	861	2160	511	188	5207	17	43	20\n7	5	33	24	25	26	28	29	30	31	32	33	35	37\n7	5	33	8	11	194	4	482	68	505	16	3385	1	17\n7	5	34	23	28	29	30	31	32	33	34	37\n7	5	34	1	29	441	61	559	123	578	2777	11\n7	5	35	32	33	35\n7	5	35	1	4	4\n7	5	36	35	36\n7	5	36	1	1\n7	5	37	16	17	18	20	21	23	24	25	26	27	28	29	30	31	32	33	34	37	40\n7	5	37	1	1	1	1	3	2	5	19	64	32	364	394	525	535	184	801	55	4839	8\n7	5	40	29	30	31	32	33	37	40\n7	5	40	18	152	59	30	101	16	699\n7	6	0	0\n7	6	0	205\n7	6	6	6	7	9\n7	6	6	111279	11	1\n7	6	7	7	10\n7	6	7	117442	60\n7	6	8	7	8	9	10	12	13	15	17\n7	6	8	2353	170198	3	7	35	226	94	1\n7	6	9	6	7	8	9	10	11	12	13	14	17	20	21	22	24\n7	6	9	4312	2101	1736	249435	1398	94	116	326	1	49	1	1	1	2\n7	6	10	7	8	9	10	11	12	13	14	16	18\n7	6	10	598	897	3574	125017	230	154	316	14	19	4\n7	6	11	7	8	9	10	11	12	13	14	15	16	17	24	25\n7	6	11	15	2163	3022	2075	2758583	36825	5807	18	1678	333	80	2	1\n7	6	12	7	8	9	10	11	12	13	14	15	16	17	18	19	23	28\n7	6	12	74	2268	2653	3772	79851	1466290	11735	25883	3400	1809	93	153	6	1	1\n7	6	13	7	8	9	10	11	12	13	14	15	16	17	18	21	28\n7	6	13	59	541	1137	1014	11694	45638	2128737	8859	11573	7507	6492	821	2	1\n7	6	14	7	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24\n7	6	14	12	339	1231	3712	72191	39946	1142827	4647	28257	1404	3376	1628	2755	22	1	1\n7	6	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23\n7	6	15	35	571	198	265	4361	18942	51868	44078	685561	7325	10145	1410	207	385	5816	158	4\n7	6	16	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	25	26\n7	6	16	3	17	8	87	682	3226	9487	37861	10816	1023470	8703	4969	217	41	1051	68	1	1\n7	6	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28\n7	6	17	17	100	182	761	8525	21141	20676	48520	56401	748944	3581	1497	286	474	1	2	36	1	6	1\n7	6	18	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	28\n7	6	18	10	80	91	418	3645	7134	25883	36943	56092	481875	4440	820	1268	57	55	75	7	1\n7	6	19	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	31\n7	6	19	12	9	8	7	1200	242	2491	1953	1739	4001	7748	200243	939	914	101	1	28	12	1	2\n7	6	20	7	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n7	6	20	1	1	31	4595	1783	9228	5299	12713	10224	15879	18417	190528	1091	133	416	632	185	5	8	3\n7	6	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	32\n7	6	21	1	6	17	481	3840	8505	28014	43137	42883	27306	4386	4737	557990	1981	920	1583	229	37	6	3	5	1\n7	6	22	7	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n7	6	22	1	4	4	48	32	240	158	72	842	1088	4139	2645	68490	39	305	58	153	70	11\n7	6	23	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n7	6	23	1	12	6	55	26	4972	1910	21996	32538	2435	4749	21732	486	123144	641	387	27	14	58	16\n7	6	24	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31\n7	6	24	2	5	139	752	4087	1092	10595	3708	6205	24375	3278	1305	90591	655	381	252	491	5	3\n7	6	25	7	10	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32\n7	6	25	1	1	6	3	68	45	35	2151	4958	9839	9780	2177	747	6178	67058	106	59	215	27	3	1\n7	6	26	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	37\n7	6	26	1	13	77	31	392	198	2666	7892	1135	101	3525	498	25501	80	176	141	2	1	1\n7	6	27	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31\n7	6	27	1	461	10	2476	2858	9203	4334	5068	127	1072	5910	153	42431	60	110	43\n7	6	28	14	17	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33\n7	6	28	1	1	2	2	329	190	990	905	1035	298	84	24913	395	60	80	9	1\n7	6	29	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	6	29	2	7	98	3	51	18	215	5333	1444	671	7124	8850	1739	225	1740	46572	19	182	39	52	12	2\n7	6	30	19	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	6	30	1	4	90	37	63	106	14	599	205	3401	64	3	10	4	2\n7	6	31	17	20	21	22	23	24	25	26	27	28	29	30	31	32	34\n7	6	31	1	3	6	418	601	471	490	326	715	924	849	206	12085	13	2\n7	6	32	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n7	6	32	1	3	1	30	9	38	1	9	58	36	33	521	1183	364	117	3238	21	26	6\n7	6	33	24	25	26	28	29	30	31	32	33	35	37\n7	6	33	13	10	361	57	585	124	526	25	3283	2	17\n7	6	34	27	28	29	30	31	32	33	34	37\n7	6	34	1	79	370	47	290	54	333	1725	11\n7	6	35	34	35\n7	6	35	1	5\n7	6	36	36\n7	6	36	1\n7	6	37	16	17	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	37	40\n7	6	37	2	2	1	1	1	4	4	62	13	239	358	370	344	67	496	30	1	2922	4\n7	6	40	29	30	31	32	33	37	40\n7	6	40	16	102	31	25	66	10	457\n8	1	0	0\n8	1	0	154\n8	1	6	6	9	15\n8	1	6	64349	5534	1\n8	1	7	7	8	9	10	12	13	15\n8	1	7	55135	1043	1387	562	54	32	2\n8	1	8	7	8	9	10	11	12	13	15	16\n8	1	8	128	78570	553	825	913	1494	263	174	14\n8	1	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	26\n8	1	9	18	126	388	110263	907	1611	1479	392	100	88	6	30	1	3	1\n8	1	10	7	8	9	10	11	12	13	14	15	16	17	18	32\n8	1	10	31	91	871	59371	556	3267	468	606	80	39	16	49	1\n8	1	11	8	9	10	11	12	13	14	15	16	17	18	19	20	23	30\n8	1	11	18	161	521	1156319	18264	3147	1021	1156	294	34	52	3	3	21	1\n8	1	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n8	1	12	15	94	131	25085	573594	5629	30978	4816	1411	728	126	3087	351	14	3\n8	1	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n8	1	13	142	176	144	3723	7534	839918	12123	11150	1384	311	422	322	47	377	30\n8	1	14	11	12	13	14	15	16	17	18	19	20	21	22	23	26	28	30\n8	1	14	119	16006	6972	708930	31764	2908	3985	1476	25070	2290	1533	232	47	1	1	1\n8	1	15	8	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	28	30\n8	1	15	75	962	1984	12588	6659	587325	5378	2815	3862	14707	1373	9341	1052	482	25	2	1	1\n8	1	16	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	27	30\n8	1	16	166	835	2306	4403	12502	222853	5647	18775	281	3690	22947	201	2337	226	70	14	1\n8	1	17	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	28	30\n8	1	17	2	12	121	603	301	920	32382	4708	1425	2160	1014	1740	3119	238	71	2	1\n8	1	18	12	13	14	15	16	17	18	19	20	21	22	23	25	26	27	28	30	32\n8	1	18	27	723	1995	2173	1324	854	170317	236	10966	4437	5	60	1581	369	6746	4	1	3\n8	1	19	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	27	28	32\n8	1	19	1	5	11	980	373	284	126	556	84345	541	1052	93	32	10	125	958	44	3\n8	1	20	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	32\n8	1	20	4	1	1	1412	794	328	53	438	972	85992	2632	238	58	79	3485	322	1076	1252	86	11\n8	1	21	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	32\n8	1	21	1	1	369	5	36	36	95	138	92467	27	111	249	77	742	3740	2563	44	6\n8	1	22	12	13	16	17	18	19	20	21	22	23	24	25	26	27	28	30	37\n8	1	22	1	2	2	24	7	282	695	65	17677	16	64	201	77	704	214	65	13\n8	1	23	12	14	15	18	19	20	21	22	23	24	25	26	27	28	31\n8	1	23	1	1	1	5	8	101	129	7	13444	1	3	20	5	13	3\n8	1	24	17	19	20	21	22	23	24	25	26	27	28	29	30	32	34	37\n8	1	24	1	5	221	42	194	2	7060	535	94	198	116	3	71	83	129	10\n8	1	25	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	37\n8	1	25	1	1	69	128	31	12	43	11370	12	22	1347	1	422	5	24	177	162\n8	1	26	16	17	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n8	1	26	1	2	2	6	10	9	17	57	18	2117	87	33	3	1	7	92	1	56	28\n8	1	27	18	20	21	22	23	24	25	26	27	28	29	30	32	34\n8	1	27	7	178	85	5	6	10	85	78	23359	4	14	1	8	1\n8	1	28	22	23	24	25	26	27	28	29	30	31	34	37\n8	1	28	1	4	1	2	95	91	10636	2	5	2	12	1\n8	1	29	17	21	22	24	25	26	27	28	29	30	31	32	33	34	37\n8	1	29	1	1	2	4	11	3	47	1	580	2	1	100	1	58	17\n8	1	30	20	23	26	27	28	29	30	31	32	34	37\n8	1	30	1	1	9	4	49	1	1543	5	5	3	4\n8	1	31	25	26	27	28	29	30	31	35\n8	1	31	1	3	5	19	2	3	90	1\n8	1	32	21	25	26	27	29	30	31	32	34	40\n8	1	32	1	1	3	4	2	10	4	519	6	1\n8	1	33	31	32	33	34\n8	1	33	1	1	6	1\n8	1	34	27	28	29	30	32	33	34	37\n8	1	34	5	25	1	17	20	1	1084	8\n8	1	35	21	34	35	36	37	38\n8	1	35	1	1	15	2	1	1\n8	1	36	32	35	36	37\n8	1	36	1	1	13	1\n8	1	37	28	30	32	34	37\n8	1	37	10	14	2	23	609\n8	1	38	37	38	40\n8	1	38	1	1	1\n8	1	39	39	40\n8	1	39	3	1\n8	1	40	32	40\n8	1	40	2	10\n8	2	0	0\n8	2	0	154\n8	2	6	6	9\n8	2	6	61115	3252\n8	2	7	7	8	9	10	12	13	15	18\n8	2	7	53167	966	634	344	258	20	30	1\n8	2	8	7	8	9	10	11	12	13	14	15	16\n8	2	8	115	76188	358	472	1012	1809	156	9	164	59\n8	2	9	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	28\n8	2	9	45	143	354	114555	588	951	1399	338	257	315	39	26	9	17	2	1\n8	2	10	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	32\n8	2	10	28	86	752	58533	405	1454	346	432	170	111	33	92	15	1	1	1	1\n8	2	11	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	26\n8	2	11	14	152	475	1148427	25152	4593	6523	2747	593	111	50	324	212	80	7	1\n8	2	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23\n8	2	12	17	89	126	22000	526812	6256	34897	11125	5621	737	180	13833	2809	51	1	4\n8	2	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	28\n8	2	13	70	135	86	2889	6633	816180	19552	19974	1354	455	542	821	1080	2765	1	29	6	2\n8	2	14	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26\n8	2	14	1	104	13149	5198	619032	36981	6764	4610	1533	69660	7521	4795	370	88	1	5\n8	2	15	8	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	30	31	32\n8	2	15	34	674	1595	9707	7766	553542	5192	2196	3793	32663	6079	27407	1425	850	122	20	1	1	2\n8	2	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	27\n8	2	16	2	107	657	1816	3386	8444	153367	3481	11708	246	15374	34126	201	3070	1078	67	21\n8	2	17	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	27	28	32\n8	2	17	1	19	101	547	214	699	25351	2510	3451	4281	2182	2423	4360	769	132	1	3	1\n8	2	18	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	32\n8	2	18	2	2	86	545	1622	2377	1109	771	134654	179	35798	6431	13	76	2	4611	514	12040	5	3\n8	2	19	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	27	28	30	31	32\n8	2	19	2	12	9	844	414	301	141	403	124476	667	900	173	56	70	465	1796	103	1	1	8\n8	2	20	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	32\n8	2	20	3	5	1047	662	358	49	344	808	92464	1587	256	110	90	6978	614	1820	1529	79	19\n8	2	21	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	32\n8	2	21	4	1	670	9	77	49	116	179	123322	26	168	114	166	1299	6190	3860	21	5\n8	2	22	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	37\n8	2	22	1	1	1	5	32	12	401	552	80	18462	15	80	94	202	1207	310	51	8\n8	2	23	13	15	16	17	18	19	20	21	22	23	25	26	27	28	31\n8	2	23	1	1	1	1	10	23	226	248	12	19212	2	38	3	15	9\n8	2	24	19	20	21	22	23	24	25	26	27	28	30	32	34	37\n8	2	24	5	192	29	179	2	5541	766	97	356	165	37	86	106	7\n8	2	25	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	37\n8	2	25	1	2	7	4	96	108	32	12	40	14542	9	11	2045	4	552	12	60	185	147\n8	2	26	13	17	18	19	20	21	22	23	24	25	26	27	28	30	31	32	34	37\n8	2	26	1	11	9	3	26	21	20	52	49	17	3535	134	94	7	7	155	63	10\n8	2	27	17	18	19	20	21	22	23	24	25	26	27	28	29	30	32\n8	2	27	1	18	1	326	232	15	4	12	99	216	36095	5	11	3	27\n8	2	28	14	20	22	23	24	25	26	27	28	29	30	31	32	34	37\n8	2	28	2	1	2	21	5	2	241	144	15874	2	17	1	2	17	3\n8	2	29	15	21	24	25	26	27	28	29	31	32	34	37\n8	2	29	1	1	2	10	4	43	2	384	1	100	45	16\n8	2	30	19	24	25	26	27	28	29	30	31	32	34	37\n8	2	30	2	1	1	15	17	80	2	2158	3	4	6	1\n8	2	31	22	23	24	25	26	27	28	29	30	31	32	33	34\n8	2	31	1	1	1	2	1	4	15	1	6	82	1	1	2\n8	2	32	17	22	27	29	30	31	32	34	35\n8	2	32	1	1	9	7	18	1	833	10	1\n8	2	33	31	33\n8	2	33	1	8\n8	2	34	26	27	28	30	31	32	34	35	37\n8	2	34	1	12	36	28	1	31	1430	1	11\n8	2	35	30	33	34	35	40\n8	2	35	1	2	1	12	1\n8	2	36	32	35	36	37\n8	2	36	1	1	11	2\n8	2	37	28	30	34	35	36	37\n8	2	37	11	19	40	2	4	779\n8	2	38	28	39\n8	2	38	1	1\n8	2	39	39	40\n8	2	39	2	1\n8	2	40	36	37	38	40\n8	2	40	1	1	2	9\n8	3	0	0\n8	3	0	154\n8	3	6	6	8	15\n8	3	6	61157	2	1\n8	3	7	7	8	10	11	12	13	15\n8	3	7	53433	3	8	6	1	1	1\n8	3	8	7	8	10	12	13	15	21\n8	3	8	135	77517	2	15	33	26	1\n8	3	9	6	7	8	9	10	11	12	13	16	23\n8	3	9	43	142	400	118930	278	26	37	69	1	1\n8	3	10	7	8	9	10	11	12	13	14	16	18	21\n8	3	10	26	91	666	59699	50	32	59	1	3	1	1\n8	3	11	8	9	10	11	12	13	14	15	16	19\n8	3	11	14	162	499	1164296	9668	1504	5	341	87	1\n8	3	12	8	9	10	11	12	13	14	15	16	17	18	19\n8	3	12	25	84	129	20288	548918	1869	6355	863	321	11	144	28\n8	3	13	7	8	9	10	11	12	13	14	15	16	17	18	19	21	23	25\n8	3	13	3	55	110	97	2721	6598	827867	1956	4824	834	19	187	2	2	1	1\n8	3	14	10	11	12	13	14	15	16	17	18	19	20	22	23\n8	3	14	4	115	11950	4720	671703	3756	1524	260	909	395	578	3	1\n8	3	15	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27\n8	3	15	21	1	667	1468	8738	7920	612707	3860	99	1561	457	325	4	1	1	1	1	1\n8	3	16	10	11	12	13	14	15	16	17	18	19	20	21	26\n8	3	16	4	122	562	1649	3061	6713	162483	215	526	86	144	10	9\n8	3	17	11	12	13	14	15	16	17	18	19	20	21	22	24	26	30\n8	3	17	1	19	91	459	261	641	36151	343	39	11	48	5	2	12	1\n8	3	18	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	27\n8	3	18	6	1	147	466	1463	3136	1123	713	148555	151	104	8	5	3	12	31\n8	3	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25\n8	3	19	2	56	11	693	779	545	138	338	243701	430	51	276	15	1	12\n8	3	20	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27\n8	3	20	1	946	674	324	34	316	754	163903	119	230	124	72	141	30	216\n8	3	21	10	11	13	15	16	17	18	19	20	21	22	23	24	25	26	27\n8	3	21	1	1	3	1149	64	111	65	169	296	202065	24	144	9	40	33	194\n8	3	22	11	13	14	15	16	17	18	19	20	21	22	23	24	25	27\n8	3	22	1	1	1	3	7	34	27	552	454	67	22401	1	56	7	1\n8	3	23	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n8	3	23	1	16	5	8	49	377	375	18	27184	1	4	96	2	2\n8	3	24	17	18	19	20	21	22	23	24	25	26	28\n8	3	24	1	2	2	177	40	109	1	5576	13	16	1\n8	3	25	13	17	18	19	20	21	22	23	24	25	26	27	32\n8	3	25	3	1	8	8	263	104	42	8	30	28854	2	11	1\n8	3	26	13	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n8	3	26	1	8	16	13	2	65	58	1	138	34	25	6722	227	162	1	3\n8	3	27	13	18	19	20	21	22	23	24	25	26	27	28	29	30	32\n8	3	27	1	36	1	645	418	12	4	12	131	426	58191	3	18	3	2\n8	3	28	19	20	21	22	23	24	25	26	27	28	29	30	34	37\n8	3	28	3	13	11	24	35	2	27	441	199	23344	4	25	22	6\n8	3	29	15	17	24	25	26	27	28	29	30\n8	3	29	1	1	3	3	3	16	5	378	1\n8	3	30	13	22	24	26	27	28	29	30	31	32	34	37\n8	3	30	1	1	1	19	10	129	2	2818	3	2	8	5\n8	3	31	13	17	21	22	23	25	26	27	28	29	30	31	32\n8	3	31	1	1	3	4	21	21	10	4	9	1	1	43	1\n8	3	32	25	26	27	29	30	31	32	34\n8	3	32	2	1	10	8	12	1	1292	13\n8	3	33	20	28	32	33	34\n8	3	33	1	1	1	7	1\n8	3	34	23	25	27	28	30	31	32	34	37\n8	3	34	1	1	12	43	33	1	43	1760	11\n8	3	35	28	31	35\n8	3	35	1	1	15\n8	3	36	18	33	35	36\n8	3	36	1	1	3	11\n8	3	37	28	29	30	32	34	37\n8	3	37	8	1	19	1	41	915\n8	3	38	37	38\n8	3	38	1	1\n8	3	39	22	39\n8	3	39	1	2\n8	3	40	32	40\n8	3	40	1	10\n8	4	0	0\n8	4	0	154\n8	4	6	6	7	8	9	10	11	14\n8	4	6	61175	8	5	7	1	1	3\n8	4	7	7	8	9	10	11	12	14	15	17	18\n8	4	7	53626	45	30	5	1	18	10	2	1	1\n8	4	8	7	8	9	10	11	12	13	14	15	17	18\n8	4	8	178	77742	60	12	5	34	51	24	16	1	5\n8	4	9	6	7	8	9	10	11	12	13	14	15	16	17	18\n8	4	9	41	140	380	118907	254	27	57	76	48	1	1	1	20\n8	4	10	7	8	9	10	11	12	13	14	15	16	17	18	20	22	32\n8	4	10	42	93	705	59722	41	29	67	12	2	1	4	6	1	1	1\n8	4	11	7	8	9	10	11	12	13	14	15	16	18\n8	4	11	11	25	298	456	1175158	10152	1683	93	335	65	21\n8	4	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20\n8	4	12	4	19	114	142	19213	549951	2131	6623	790	332	22	96	33	1\n8	4	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20	22\n8	4	13	5	67	686	106	2556	6399	828796	2367	4916	872	53	258	6	1	1\n8	4	14	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	27\n8	4	14	1	48	9	162	11150	4233	671059	3991	1652	299	897	466	590	1	4	1\n8	4	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	25	27\n8	4	15	1	31	28	1	584	1352	8022	7602	611078	3828	119	1725	451	401	1	7	1	2	2\n8	4	16	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	26\n8	4	16	35	6	128	520	1399	2786	6199	159740	242	545	93	120	17	5	1	5\n8	4	17	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	26	27\n8	4	17	35	25	5	72	69	431	240	565	35829	393	32	9	79	14	1	10	1\n8	4	18	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	25	26	27	28\n8	4	18	2	30	11	2	127	385	1274	2877	1007	604	146363	187	107	16	10	1	5	1	30	1\n8	4	19	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25\n8	4	19	71	11	1	45	17	634	878	521	117	342	242938	442	41	300	25	2	15\n8	4	20	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	35\n8	4	20	124	2	8	1	844	707	313	39	325	713	163698	127	268	131	73	169	31	212	1\n8	4	21	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	32	33	35	36\n8	4	21	25	5	1	7	2	25	1065	14	89	76	101	290	201222	45	113	15	52	34	196	1	3	1	1	2\n8	4	22	9	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	28\n8	4	22	7	30	1	7	10	6	1	35	25	500	420	52	21977	2	69	12	1	2\n8	4	23	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29	30\n8	4	23	4	14	1	10	1	10	3	1	5	26	21	291	297	9	26901	1	2	78	4	1	3\n8	4	24	9	10	12	14	16	17	18	20	21	22	23	24	25	26	27	28	29	35\n8	4	24	6	30	6	5	2	7	4	145	31	125	2	5396	9	23	3	3	2	1\n8	4	25	10	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	35\n8	4	25	4	2	3	1	1	2	16	14	275	105	29	20	24	28775	7	16	1\n8	4	26	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	32	35	36\n8	4	26	2	6	2	4	3	3	3	7	15	16	2	87	50	7	150	28	15	6930	261	219	6	1	2	1\n8	4	27	10	12	13	14	15	17	18	19	20	21	22	24	25	26	27	28	29	33	35\n8	4	27	25	2	5	3	8	5	71	2	658	386	3	6	141	394	57402	1	11	1	1\n8	4	28	10	12	14	15	16	17	18	19	21	22	23	24	25	26	27	28	29	30	32	34	35	36	37\n8	4	28	4	2	1	3	2	5	16	1	1	3	5	1	4	397	237	22981	1	18	2	15	1	1	7\n8	4	29	10	16	22	23	25	26	27	28	29	30	32	35	36\n8	4	29	1	1	6	1	9	1	16	2	372	1	1	1	1\n8	4	30	10	13	16	17	18	19	20	21	22	25	26	27	28	30	32	34	35	37	40\n8	4	30	16	10	7	5	4	7	6	1	24	4	20	1	88	2700	6	6	1	9	1\n8	4	31	10	13	14	17	18	22	24	25	26	28	31	33\n8	4	31	5	1	1	3	2	1	1	1	1	6	26	1\n8	4	32	16	22	23	25	26	27	29	30	31	32	33	34\n8	4	32	5	4	2	6	4	12	5	4	1	1279	2	20\n8	4	33	14	15	28	29	30	33	35\n8	4	33	1	2	1	1	1	1	1\n8	4	34	16	18	19	20	23	27	28	29	30	31	32	33	34	37\n8	4	34	1	2	1	2	1	24	35	1	24	1	31	3	1707	12\n8	4	35	15	16	19	22	24	25	26	33	35	38\n8	4	35	2	1	1	2	1	1	1	1	7	1\n8	4	36	16	20	21	24	28	32	35	36	37\n8	4	36	2	1	1	1	1	1	1	2	1\n8	4	37	21	22	28	30	32	34	35	37\n8	4	37	1	1	15	19	1	36	1	864\n8	4	38	38\n8	4	38	1\n8	4	39	33	39\n8	4	39	1	1\n8	4	40	32	39	40\n8	4	40	2	2	6\n8	5	0	0\n8	5	0	154\n8	5	6	6	7	8\n8	5	6	61212	1	3\n8	5	7	7	8	9	10	11	13\n8	5	7	53979	23	3	11	1	1\n8	5	8	7	8	9	10	11	12	13	15\n8	5	8	172	78149	10	1	8	8	41	18\n8	5	9	6	7	8	9	10	11	12	13\n8	5	9	59	161	447	120128	299	38	20	70\n8	5	10	7	8	9	10	11	12	13	14	16\n8	5	10	38	116	704	59916	39	29	58	2	1\n8	5	11	7	8	9	10	11	12	13	14	15	16	18	19	20\n8	5	11	87	144	185	477	1184190	10469	1771	32	371	160	1	1	1\n8	5	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20\n8	5	12	23	106	91	126	17739	551231	2342	6769	910	397	47	131	40	2\n8	5	13	7	8	9	10	11	12	13	14	15	16	17	18	19	20\n8	5	13	17	647	237	94	2530	5981	829145	2192	4980	881	33	214	3	1\n8	5	14	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	25	26\n8	5	14	1	32	16	4	183	10316	4064	670873	4253	1796	291	935	470	626	3	5	1	1\n8	5	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26\n8	5	15	2	62	26	1	528	1256	7506	7174	609811	3918	124	1761	532	412	6	2	1	1	1\n8	5	16	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	26\n8	5	16	4	256	19	3	138	492	1277	2523	5730	157402	277	599	80	127	11	4\n8	5	17	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	26	28\n8	5	17	1	13	4	1	12	35	67	393	235	557	35630	375	37	11	84	32	3	11	1\n8	5	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	25	27	28\n8	5	18	7	5	1	17	105	390	1199	2823	908	639	144808	187	111	26	5	1	5	17	1\n8	5	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25\n8	5	19	76	19	1	26	32	12	584	933	439	96	321	242124	468	51	358	17	1	11\n8	5	20	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	35\n8	5	20	123	21	2	23	1	30	799	642	293	39	259	688	163594	140	233	136	97	151	39	234	1\n8	5	21	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28\n8	5	21	24	6	3	8	18	3	1094	12	93	53	103	284	200236	28	156	24	43	26	214	1\n8	5	22	8	9	10	11	13	14	15	16	17	18	19	20	21	22	24	25	26	28\n8	5	22	17	9	1	8	5	6	1	2	24	24	481	379	68	21737	68	9	4	3\n8	5	23	8	9	10	11	13	14	15	16	17	18	19	20	21	23	24	26	27	28\n8	5	23	22	21	4	23	52	2	3	1	11	3	24	234	321	26543	2	84	3	1\n8	5	24	15	18	19	20	21	22	24	25	26	27\n8	5	24	1	3	3	140	29	108	5303	5	26	3\n8	5	25	8	9	10	11	13	14	15	17	18	19	20	21	22	24	25	26	27	28	29	32\n8	5	25	2	3	7	3	19	2	2	10	15	22	291	90	31	18	28684	2	18	1	1	1\n8	5	26	10	11	16	17	18	20	21	22	23	24	25	26	27	28	30	32	33\n8	5	26	7	2	3	14	8	75	59	5	143	26	21	7146	237	181	9	1	1\n8	5	27	17	18	19	20	21	22	24	25	26	27	28	29	30\n8	5	27	1	39	1	665	371	2	6	116	379	56817	1	15	1\n8	5	28	11	12	13	17	18	22	25	26	27	28	29	30	34	37\n8	5	28	1	2	22	2	1	3	2	396	225	22659	2	19	22	4\n8	5	29	15	21	24	26	27	28	29	35\n8	5	29	1	1	1	1	23	2	364	1\n8	5	30	16	26	27	28	30	32	34	36	37\n8	5	30	1	10	2	92	2644	1	10	1	15\n8	5	31	10	11	13	16	17	30	31	32\n8	5	31	1	1	7	1	14	1	2	1\n8	5	32	25	26	27	29	30	32	34	35\n8	5	32	6	1	9	3	3	1280	25	1\n8	5	33	33\n8	5	33	11\n8	5	34	27	28	29	30	32	34	37\n8	5	34	19	47	1	26	38	1637	16\n8	5	35	16	35\n8	5	35	1	19\n8	5	36	28	36	37\n8	5	36	1	5	1\n8	5	37	28	30	34	35	37\n8	5	37	11	13	28	1	840\n8	5	38	38\n8	5	38	2\n8	5	39	38	39\n8	5	39	1	2\n8	5	40	32	40\n8	5	40	2	5\n8	6	0	0\n8	6	0	154\n8	6	6	6	7	23\n8	6	6	61261	9	1\n8	6	7	7	8	9	10\n8	6	7	54476	1	1	8\n8	6	8	7	8	9	11	12	13	15	18\n8	6	8	2181	78009	3	1	15	45	13	2\n8	6	9	6	7	8	9	10	11	12	13	23\n8	6	9	5378	1402	1227	112893	483	23	29	71	1\n8	6	10	7	8	9	10	11	12	13	14\n8	6	10	616	919	1418	57800	67	39	93	8\n8	6	11	7	8	9	10	11	12	13	14	15	16	18	19	20	24\n8	6	11	38	2293	1913	981	1187164	10863	1814	10	368	70	1	1	1	1\n8	6	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	22\n8	6	12	625	2990	2675	2718	44061	515399	2869	7181	944	360	40	103	9	2	1\n8	6	13	7	8	9	10	11	12	13	14	15	16	17	18\n8	6	13	86	374	909	667	8251	12614	815068	2578	5099	992	41	218\n8	6	14	7	8	9	10	11	12	13	14	15	16	17	18	19	20	22	24	27	28\n8	6	14	10	15	663	873	12568	49641	28709	591846	3866	1819	324	1060	508	641	7	1	1	1\n8	6	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24\n8	6	15	130	389	711	474	4673	16579	36060	49216	516883	4857	144	1092	226	362	3	8	1\n8	6	16	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	30\n8	6	16	4	100	92	215	731	7403	2078	8037	6929	140130	281	569	75	124	4	1\n8	6	17	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	26	27\n8	6	17	2	51	76	153	1132	716	5719	3028	5182	20748	417	32	26	34	24	4	1\n8	6	18	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	25	27\n8	6	18	1	46	250	100	329	1119	2423	6224	16860	3299	118553	198	126	8	5	3	2	4\n8	6	19	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	27	30	32\n8	6	19	18	1	43	39	490	19898	1064	89207	33146	546	3625	331	95739	412	37	185	8	4	1	1	1\n8	6	20	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27\n8	6	20	2	6	358	3868	1544	9507	8030	23640	5306	35394	923	78290	63	256	50	77	42	6	59\n8	6	21	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	32\n8	6	21	1	4	8	198	65	4773	5955	41570	50990	2492	9006	1362	2624	82248	32	43	22	34	7	59	2	1\n8	6	22	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	25	26\n8	6	22	1	1	1	1	5	643	2367	455	2939	23	236	340	39	15428	60	8	2\n8	6	23	10	11	12	13	14	15	16	17	18	19	20	21	23	24	26	27	29	30\n8	6	23	2	21	4	50	144	1213	5035	5350	134	77	146	299	14488	6	23	1	1	2\n8	6	24	11	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	33\n8	6	24	1	4	1	4	9	6	132	180	118	1	5057	8	21	4	1	1	2	1\n8	6	25	7	9	10	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29\n8	6	25	1	2	3	18	225	1826	1098	4970	109	8893	238	156	1	1023	10471	2	16	1	1\n8	6	26	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30\n8	6	26	2	2	1	18	30	135	247	776	640	1083	1883	260	48	138	13	2717	78	55	5\n8	6	27	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n8	6	27	2	88	17	18331	2638	2976	7074	1709	1	449	61	209	24244	3	17	2\n8	6	28	14	15	18	19	20	21	22	23	24	25	26	27	28	30	34	36	37\n8	6	28	2	1	16	254	2995	5359	472	1	253	2649	146	106	10722	10	12	1	3\n8	6	29	21	22	24	25	26	27	28	29	30	35\n8	6	29	2	1	2	1	1	18	1	357	2	1\n8	6	30	20	21	22	24	25	26	28	30	31	32	34	37\n8	6	30	160	60	132	97	827	8	50	1364	1	2	7	8\n8	6	31	31	33\n8	6	31	1	1\n8	6	32	15	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35\n8	6	32	6	8	13	28	24	4	171	59	177	46	1	145	2	1	629	1	8	1\n8	6	33	30	32	33\n8	6	33	1	1	10\n8	6	34	22	24	25	26	27	28	29	30	32	33	34	37\n8	6	34	4	202	298	87	7	24	82	15	19	1	972	11\n8	6	35	17	25	29	31	35	37\n8	6	35	1	1	1	1	18	1\n8	6	36	36	37\n8	6	36	4	2\n8	6	37	22	24	25	26	28	29	30	32	34	37\n8	6	37	15	11	205	36	6	19	7	1	19	557\n8	6	38	25	38\n8	6	38	1	2\n8	6	39	35	39\n8	6	39	1	1\n8	6	40	32	40\n8	6	40	1	4\n8	7	0	0\n8	7	0	154\n8	7	6	6\n8	7	6	66639\n8	7	7	6	7	8	9	10	11	15	18	20	21	22	23\n8	7	7	1	59530	1	1	50	1	5	2	2	3	1	1\n8	7	8	6	7	8	9	10	12	13	15\n8	7	8	1	1391	84697	3	6	19	99	104\n8	7	9	6	7	8	9	10	11	12	13	19	20	22	23	24	28	30\n8	7	9	2514	951	1021	115724	863	130	83	131	1	1	1	1	3	2	1\n8	7	10	6	7	8	9	10	11	12	13	14	15	16	17	28	32\n8	7	10	2	342	533	1501	61738	183	73	222	1	1	5	1	1	1\n8	7	11	6	7	8	9	10	11	12	13	14	15	16	19	21	23	29\n8	7	11	25	1	1189	1484	984	1239951	11873	2646	11	573	122	1	1	1	1\n8	7	12	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20\n8	7	12	14	37	909	1266	1854	33481	586633	3685	8036	1340	491	44	89	1	1\n8	7	13	6	7	8	9	10	11	12	13	14	15	16	17	18	19\n8	7	13	22	10	270	585	567	5342	12197	865015	4213	6304	1322	48	201	1\n8	7	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	27\n8	7	14	1	180	567	1953	41578	17504	702295	3451	2410	423	1022	472	634	1	4	2	1\n8	7	15	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24\n8	7	15	15	14	317	109	98	1622	6039	21760	33449	557403	7230	226	1037	206	407	4	7	1\n8	7	16	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n8	7	16	1	8	3	33	262	1509	1787	4158	9486	234357	406	730	98	142	6\n8	7	17	6	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	26	28	32\n8	7	17	6	24	51	47	743	422	4288	3232	7725	28909	418	31	22	16	16	3	1	1	1\n8	7	18	6	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24	25	27	33\n8	7	18	2	15	45	27	168	515	1821	4447	18747	4432	160286	323	163	10	6	1	2	2	1\n8	7	19	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24\n8	7	19	1	2	6	3114	193	22346	10708	481	1010	379	64156	485	35	127	2	1\n8	7	20	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27\n8	7	20	2	474	101	2412	1711	3660	2050	7486	923	80040	58	269	24	108	29	14\n8	7	21	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	35\n8	7	21	1	1	9	3	6	589	1480	9774	17893	800	4937	1632	4299	55994	29	14	33	32	1	27	1\n8	7	22	13	14	15	16	17	18	19	20	21	22	24	25	26	28	29\n8	7	22	5	307	1269	266	1234	9	131	386	43	15045	115	4	1	1	1\n8	7	23	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26\n8	7	23	2	7	1	25	35	503	3157	2379	41	20	64	95	1	8308	1	4\n8	7	24	14	17	18	19	20	21	22	24	25	26	27	29\n8	7	24	1	3	8	6	119	392	126	6891	4	20	6	2\n8	7	25	15	16	17	18	19	20	21	22	23	24	25	26	27\n8	7	25	31	258	194	1082	10	3521	146	365	2	647	8401	3	20\n8	7	26	11	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30\n8	7	26	1	1	2	51	63	263	219	463	442	81	14	76	6	1726	23	12	3\n8	7	27	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n8	7	27	1	18	5	5712	836	1088	2447	635	1	202	56	56	13552	1	34	1\n8	7	28	13	19	20	21	22	24	25	26	27	28	30	34	37	39\n8	7	28	1	89	1689	1906	236	110	895	67	57	5808	3	4	1	1\n8	7	29	21	22	24	27	28	29	33	35\n8	7	29	2	1	2	21	1	595	1	1\n8	7	30	20	21	22	23	24	25	26	27	28	30	34	37\n8	7	30	129	27	80	2	55	345	7	3	27	733	3	3\n8	7	31	27	30	31	33\n8	7	31	1	1	1	1\n8	7	32	18	19	20	21	22	24	25	26	27	29	30	31	32	33	34\n8	7	32	14	1	11	10	2	75	39	93	13	79	4	1	307	1	5\n8	7	33	26	28	30	31	32	33\n8	7	33	1	1	4	1	2	5\n8	7	34	22	24	25	26	27	28	29	30	32	33	34	37\n8	7	34	2	170	142	58	7	7	69	3	7	1	546	6\n8	7	35	28	29	35	36\n8	7	35	2	1	17	1\n8	7	36	28	35	36\n8	7	36	1	1	3\n8	7	37	22	24	25	26	28	29	30	34	36	37\n8	7	37	22	33	120	16	4	19	4	7	3	354\n8	7	38	37	38\n8	7	38	1	1\n8	7	39	28\n8	7	39	1\n8	7	40	38	39	40\n8	7	40	1	1	2\n9	1	0	0\n9	1	0	93\n9	1	6	6	9\n9	1	6	39402	3652\n9	1	7	7	8	9	10	12	13\n9	1	7	32532	689	802	373	41	1\n9	1	8	7	8	9	10	11	12	13	15	16\n9	1	8	94	45318	391	492	513	1246	118	1	8\n9	1	9	6	7	8	9	10	11	12	13	14	15	16\n9	1	9	12	70	214	61626	501	855	798	263	47	29	10\n9	1	10	7	8	9	10	11	12	13	14	15	16	18\n9	1	10	29	64	468	34101	337	1761	115	368	47	31	3\n9	1	11	8	9	10	11	12	13	14	15	16	23\n9	1	11	16	99	291	615620	8540	1192	438	431	140	6\n9	1	12	8	9	10	11	12	13	14	15	16	17	20	21	23	24\n9	1	12	12	50	66	13996	594016	2087	1782	578	29908	1	1	1765	1	1\n9	1	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n9	1	13	80	83	46	1378	3264	425311	3918	5152	397	10	83	4	4	1587	20\n9	1	14	11	12	13	14	15	16	17	18	19	20	21	22	23\n9	1	14	78	471	3023	193124	1081	1488	1	55	4	47	4	1	45\n9	1	15	8	11	12	13	14	15	16	17	18	19	20	21	23	27\n9	1	15	1	473	899	7448	892	201264	2573	18	172	8	218	3553	58	1\n9	1	16	10	11	12	13	14	15	16	17	18	19	20	21	23	37\n9	1	16	2	75	384	888	4049	8320	248266	13	183	18	12236	18387	3064	53\n9	1	17	13	14	15	16	17	18	19	20	21	22	23	37\n9	1	17	88	12	71	76	1468	21	5	6	35	7	127	4\n9	1	18	11	13	14	15	16	17	18	19	20	21	22	23	25	37\n9	1	18	1	580	230	393	319	56	15408	8	12	1577	14	94	1	22\n9	1	19	14	15	16	17	18	19	20	21	23	25	28	31\n9	1	19	6	19	14	25	18	422	3	36	31	8	1	1\n9	1	20	13	14	15	16	17	18	19	20	21	22	23	24	25	27	28	31\n9	1	20	1	1	31	70	18	36	35	13596	29	23	47	1	15	1	1	1\n9	1	21	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	32	37\n9	1	21	1	1	195	44	10	9	9	148	52368	18	744	1	18	1	1	1	63\n9	1	22	11	15	18	19	20	21	22	23	24	25	26	28	33\n9	1	22	1	2	9	2	69	17	203	35	2	18	7	14	1\n9	1	23	15	16	18	19	20	21	22	23	25	26	27	28	31	37\n9	1	23	1	2	8	13	36	46	9	6129	27	5	1	25	5	1\n9	1	24	20	21	22	23	24	25\n9	1	24	1	1	1	1	12	1\n9	1	25	17	19	20	21	22	23	24	25	26	28	30	31	34\n9	1	25	1	1	1	7	3	39	1	164	10	29	1	16	1\n9	1	26	15	20	21	22	23	24	25	26	27	28	29	30	31\n9	1	26	1	2	5	26	7	1	27	137	7	7	1	2	23\n9	1	27	22	23	24	25	26	27	28	29	30\n9	1	27	18	1	2	1	1	25	1	2	1\n9	1	28	15	22	23	25	26	27	28	29	30	31\n9	1	28	1	2	23	1	7	1	112	2	5	7\n9	1	29	15	22	26	27	28	29	30	34	35\n9	1	29	1	3	3	7	1	16	3	1	1\n9	1	30	14	23	25	27	28	29	30	31\n9	1	30	1	1	1	2	6	4	39	1\n9	1	31	17	23	25	26	28	29	30	31\n9	1	31	1	2	4	3	36	1	1	178\n9	1	32	30	32	33	37	40\n9	1	32	1	9	2	1	1\n9	1	33	29	33\n9	1	33	1	2\n9	1	34	31	34\n9	1	34	1	2\n9	1	35	23	30	35	37	38\n9	1	35	1	1	8	1	1\n9	1	36	36\n9	1	36	1\n9	1	37	23	37\n9	1	37	25	233\n9	1	39	31	39\n9	1	39	1	2\n9	1	40	31	40\n9	1	40	5	10\n9	2	0	0\n9	2	0	93\n9	2	6	6	9	28\n9	2	6	37766	1647	1\n9	2	7	7	8	9	10	12	15\n9	2	7	31409	568	368	222	156	2\n9	2	8	7	8	9	10	11	12	13	16\n9	2	8	71	43710	176	316	591	1437	70	23\n9	2	9	6	7	8	9	10	11	12	13	14	15	16	18	20\n9	2	9	22	95	204	64731	304	510	773	200	148	142	40	1	1\n9	2	10	7	8	9	10	11	12	13	14	15	16	18	23	30\n9	2	10	15	50	411	33917	212	732	90	303	78	60	2	1	1\n9	2	11	8	9	10	11	12	13	14	15	16	18	19	20	21	23	25\n9	2	11	10	84	281	614525	13324	1967	1977	634	401	2	2	83	34	2	1\n9	2	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n9	2	12	9	36	80	12184	511173	2691	3876	1214	76082	2	6	4	178	3883	2\n9	2	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n9	2	13	35	52	30	935	2727	416046	7781	8779	410	22	98	7	291	3864	39\n9	2	14	11	12	13	14	15	16	17	18	19	20	21	23	27\n9	2	14	74	500	1705	198426	1612	1799	7	55	5	569	77	39	1\n9	2	15	11	12	13	14	15	16	17	18	19	20	21	23\n9	2	15	253	683	5479	959	195179	2109	24	169	9	1440	11246	68\n9	2	16	11	12	13	14	15	16	17	18	19	20	21	22	23	24	30	37\n9	2	16	33	232	569	2954	5382	209118	12	120	35	36542	23989	3	4336	1	1	19\n9	2	17	11	12	13	14	15	16	17	18	19	20	21	22	23	25	28	37\n9	2	17	2	2	79	5	57	33	1238	12	5	19	26	3	135	1	3	2\n9	2	18	11	12	13	14	15	16	17	18	19	20	21	22	23	27	28	37\n9	2	18	3	1	421	169	428	222	38	12131	13	20	2446	21	80	1	1	10\n9	2	19	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27	28	30	31\n9	2	19	2	2	1	7	12	3	18	17	363	2	44	1	41	1	11	1	1	1	1\n9	2	20	11	12	14	15	16	17	18	19	20	21	22	23	25	28\n9	2	20	1	1	4	37	83	10	38	27	26052	27	29	64	5	2\n9	2	21	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31	37\n9	2	21	1	2	305	43	5	12	4	202	77614	5	1149	1	14	2	1	8	1	48\n9	2	22	13	15	18	19	20	21	22	23	24	25	26	27	28	29	30\n9	2	22	1	3	5	3	43	20	200	21	2	11	2	3	12	1	1\n9	2	23	15	16	17	18	19	20	21	22	23	25	26	27	28	31	32	37\n9	2	23	2	1	1	14	15	44	67	7	10254	17	1	7	52	11	1	7\n9	2	24	20	22	24	25	27	30\n9	2	24	1	2	15	1	1	1\n9	2	25	17	19	21	22	23	25	26	27	28	31	33\n9	2	25	1	1	3	7	34	159	3	3	46	28	1\n9	2	26	21	22	23	25	26	27	28	29	30	31	32	39\n9	2	26	5	22	6	16	76	4	8	2	5	28	1	1\n9	2	27	20	21	22	23	27	28	29	30	31	32\n9	2	27	1	1	13	3	20	1	2	2	1	1\n9	2	28	23	24	25	26	27	28	29	30	31	32	33\n9	2	28	37	3	3	5	15	163	3	2	1	1	1\n9	2	29	26	27	29	30	34	35\n9	2	29	1	9	13	2	1	1\n9	2	30	26	27	28	29	30	31	32\n9	2	30	1	1	6	5	38	1	2\n9	2	31	14	25	26	28	31\n9	2	31	1	3	1	38	196\n9	2	32	27	32	33\n9	2	32	1	8	1\n9	2	33	33	35\n9	2	33	4	1\n9	2	34	31	34	35\n9	2	34	2	1	1\n9	2	35	35\n9	2	35	9\n9	2	36	36\n9	2	36	1\n9	2	37	23	37\n9	2	37	43	335\n9	2	38	39\n9	2	38	1\n9	2	39	39\n9	2	39	2\n9	2	40	31	32	40\n9	2	40	4	1	6\n9	3	0	0\n9	3	0	93\n9	3	6	6	18\n9	3	6	37787	1\n9	3	7	7	8	10	11\n9	3	7	31583	1	4	2\n9	3	8	7	8	11	12	13\n9	3	8	67	44494	1	5	19\n9	3	9	6	7	8	9	10	11	12	13	21\n9	3	9	31	93	217	67027	93	8	16	19	1\n9	3	10	7	8	9	10	11	12	13	16\n9	3	10	22	38	395	34644	21	16	12	2\n9	3	11	8	9	10	11	12	13	15	16	17	19	27\n9	3	11	10	89	285	624457	3977	361	122	20	1	2	1\n9	3	12	8	9	10	11	12	13	14	15	16\n9	3	12	26	47	68	10739	519693	495	133	246	296\n9	3	13	8	9	10	11	12	13	14	15	16	17	18	19	21	22	23\n9	3	13	33	36	23	710	2663	422945	527	2016	228	5	129	1	1	1	2\n9	3	14	8	10	11	12	13	14	15	16	17	18	19	26\n9	3	14	1	4	64	534	1461	213143	165	1197	3	34	5	1\n9	3	15	8	9	11	12	13	14	15	16	17	18	19	20	21	22\n9	3	15	2	1	256	565	4539	1093	205105	2114	13	153	11	9	3	2\n9	3	16	8	11	12	13	14	15	16	17	18	19	20	21	23	24	26\n9	3	16	1	46	459	529	2489	4747	281976	6	120	1	10	38	3	1	1\n9	3	17	11	12	13	14	15	16	17	18	19	20	21	23	25	27\n9	3	17	1	3	67	9	42	44	1186	11	1	1	5	4	1	3\n9	3	18	10	11	12	13	14	15	16	17	18	19	20	21	22	23	26	27	28\n9	3	18	3	2	5	336	186	376	301	28	11427	2	3	5	1	2	3	1	1\n9	3	19	10	13	14	15	16	17	18	19	20	21	22	23	26\n9	3	19	2	5	14	20	94	17	20	314	3	1	1	1	1\n9	3	20	13	14	15	16	17	18	19	20	21	22	27\n9	3	20	4	25	57	70	11	43	14	65244	18	1	1\n9	3	21	12	13	14	15	16	17	18	19	20	21	22	23	27	28\n9	3	21	2	3	6	655	217	26	12	103	213	122097	1	8	2	1\n9	3	22	11	14	15	16	17	18	19	20	21	22	23	26\n9	3	22	1	1	4	3	17	68	6	83	8	115	4	3\n9	3	23	11	12	14	15	16	17	18	19	20	21	22	23	24	25	28	37\n9	3	23	2	3	2	4	49	3	8	89	214	25	22	15915	2	3	1	12\n9	3	24	18	19	20	21	24	25	27	29	32\n9	3	24	1	2	1	2	13	1	1	1	1\n9	3	25	11	13	14	17	19	20	21	22	23	25	26	27\n9	3	25	3	1	1	1	3	2	4	21	69	133	3	1\n9	3	26	20	21	22	23	25	26	29\n9	3	26	1	3	7	5	12	63	1\n9	3	27	11	13	14	20	21	22	23	24	26	27	28	30	32\n9	3	27	1	1	2	1	3	24	6	2	13	12	1	1	1\n9	3	28	19	20	21	22	23	25	26	28	30\n9	3	28	3	28	17	48	113	63	8	60	2\n9	3	29	13	14	25	26	27	28	29	30\n9	3	29	4	2	1	1	3	4	10	1\n9	3	30	16	19	20	21	22	25	26	27	28	29	30	31\n9	3	30	1	2	1	1	2	3	4	5	9	11	14	1\n9	3	31	21	22	23	25	26	28	31	32\n9	3	31	1	9	40	66	32	22	103	1\n9	3	32	28	30	32\n9	3	32	1	1	13\n9	3	33	31	32	33\n9	3	33	1	1	5\n9	3	34	35	38\n9	3	34	1	1\n9	3	35	27	35\n9	3	35	1	11\n9	3	36	36\n9	3	36	1\n9	3	37	23	27	28	30	37\n9	3	37	38	1	1	1	380\n9	3	39	26	38	39\n9	3	39	1	1	2\n9	3	40	31	40\n9	3	40	3	3\n9	4	0	0\n9	4	0	93\n9	4	6	6	7	8	9	10	12	14\n9	4	6	37801	9	2	2	1	1	2\n9	4	7	7	8	9	10	12	14\n9	4	7	31737	12	6	6	3	1\n9	4	8	7	8	9	10	12	13	14\n9	4	8	69	44703	12	3	5	28	3\n9	4	9	6	7	8	9	10	11	12	13	14	18	27\n9	4	9	34	89	220	67087	92	9	24	26	12	1	1\n9	4	10	7	8	9	10	11	12	13	14	15	16	20\n9	4	10	19	56	332	34661	22	9	21	1	3	1	1\n9	4	11	7	8	9	10	11	12	13	14	15	16	18\n9	4	11	2	11	107	284	631091	4206	452	17	109	34	1\n9	4	12	7	8	9	10	11	12	13	14	15	16\n9	4	12	2	6	41	87	9612	517004	526	100	257	306\n9	4	13	7	8	9	10	11	12	13	14	15	16	17	18\n9	4	13	1	35	89	27	649	2560	424412	589	2086	221	4	128\n9	4	14	7	9	10	11	12	13	14	15	16	18	19\n9	4	14	1	4	5	73	532	1396	214212	166	1205	37	2\n9	4	15	9	11	12	13	14	15	16	17	18	20	23\n9	4	15	3	203	500	3888	1123	205379	2276	23	157	6	1\n9	4	16	9	10	11	12	13	14	15	16	17	18	19	20	21\n9	4	16	5	1	46	582	436	2082	4349	278946	10	101	3	13	38\n9	4	17	9	10	12	13	14	15	16	17	18	20	21	24	27\n9	4	17	4	1	15	49	12	54	29	1144	4	1	2	1	1\n9	4	18	9	10	11	12	13	14	15	16	17	18	19	20	21\n9	4	18	5	4	1	5	270	100	405	222	46	10959	3	6	1\n9	4	19	9	10	11	12	13	14	15	16	17	18	19	20	23	27	28\n9	4	19	4	1	1	6	1	9	14	26	11	12	465	2	3	2	2\n9	4	20	9	12	13	14	15	16	17	18	19	20	21	22	23\n9	4	20	8	11	1	13	18	82	12	48	34	65562	15	9	1\n9	4	21	9	10	12	14	15	16	17	18	19	20	21	22	23	25	27	29	36\n9	4	21	4	2	5	9	611	107	10	5	20	214	121238	1	3	1	1	1	1\n9	4	22	9	10	12	14	16	17	18	19	20	21	22	24	25	26	27	28\n9	4	22	1	3	3	1	1	7	5	5	58	4	158	1	1	5	1	1\n9	4	23	10	11	12	14	15	16	17	18	19	20	21	22	23	25	26	27	28	30	37\n9	4	23	1	1	2	5	12	7	1	10	48	88	20	18	15985	2	2	1	1	1	5\n9	4	24	9	10	14	17	18	19	21	24	28\n9	4	24	1	4	1	1	2	3	1	4	1\n9	4	25	13	17	18	19	20	21	22	23	25	26\n9	4	25	1	1	1	38	20	7	9	56	148	2\n9	4	26	10	15	16	17	18	21	22	23	25	26	30	31\n9	4	26	3	1	1	1	1	2	20	5	22	75	2	1\n9	4	27	10	15	22	23	25	26	27	28	29	30	31\n9	4	27	3	2	2	3	1	1	16	1	1	1	1\n9	4	28	17	21	23	25	26	27	28	30	31\n9	4	28	1	1	10	2	5	4	76	1	1\n9	4	29	20	25	26	27	28	29	30\n9	4	29	1	1	2	2	1	15	1\n9	4	30	15	19	27	30	32\n9	4	30	1	2	1	11	5\n9	4	31	10	18	22	25	26	28	30	31\n9	4	31	1	1	1	4	6	13	1	81\n9	4	32	23	25	30	31	32	35\n9	4	32	1	1	2	1	11	1\n9	4	33	32	33	37\n9	4	33	1	3	1\n9	4	35	33	35\n9	4	35	1	11\n9	4	36	36\n9	4	36	1\n9	4	37	23	37\n9	4	37	29	363\n9	4	38	38\n9	4	38	2\n9	4	39	37\n9	4	39	2\n9	4	40	31	40\n9	4	40	1	2\n9	5	0	0\n9	5	0	93\n9	5	6	6	7	8	9	11\n9	5	6	37798	12	19	4	2\n9	5	7	7	8	9	10	11	12	13\n9	5	7	31812	93	10	1	11	1	1\n9	5	8	7	8	9	10	11	12	13\n9	5	8	161	44809	26	3	24	1	21\n9	5	9	6	7	8	9	10	11	12	13\n9	5	9	36	109	499	66761	150	110	19	31\n9	5	10	7	8	9	10	11	12	13	14	15	16\n9	5	10	21	117	368	34579	54	10	30	7	1	3\n9	5	11	7	8	9	10	11	12	13	14	15	16	17	18\n9	5	11	92	293	181	299	635592	4383	509	144	117	95	1	2\n9	5	12	7	8	9	10	11	12	13	14	15	16	17	18	19	20	24\n9	5	12	34	116	91	68	8705	515044	506	192	282	335	36	58	1	4	1\n9	5	13	7	8	9	10	11	12	13	14	15	16	17	18	19\n9	5	13	46	1539	464	30	1207	2408	422696	544	2215	226	3	127	2\n9	5	14	7	8	9	10	11	12	13	14	15	16	17	18	19	20	22	23\n9	5	14	4	95	34	5	236	475	1266	214468	189	1418	7	49	19	23	3	1\n9	5	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	26	27\n9	5	15	2	66	20	6	251	557	3479	1081	205358	2393	26	211	3	10	2	1	1\n9	5	16	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22\n9	5	16	3	641	70	1	197	702	416	1932	3911	275374	20	104	15	25	51	2\n9	5	17	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	28\n9	5	17	1	18	34	3	56	20	114	11	22	32	904	18	11	19	8	1\n9	5	18	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	26	30\n9	5	18	1	24	9	1	56	19	316	80	345	229	2	10301	17	17	34	19	1	1	1\n9	5	19	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	25	28\n9	5	19	239	56	1	65	2	39	5	15	2	6	4	180	3	3	1	1	1\n9	5	20	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	26	28\n9	5	20	239	50	1	54	4	107	22	19	16	5	9	14	65391	30	9	1	1\n9	5	21	8	9	11	12	13	15	16	17	18	19	20	21	22	23	25	26	28	29\n9	5	21	35	16	25	2	83	565	121	18	2	4	155	120289	5	3	1	3	1	1\n9	5	22	8	9	11	12	13	14	15	16	17	18	19	20	21	22	26	35\n9	5	22	54	17	21	1	29	10	2	4	7	2	12	5	13	32	8	1\n9	5	23	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	26	37\n9	5	23	91	70	3	78	1	200	4	5	8	17	6	5	75	6	1	15509	2	3	13\n9	5	24	22	24	29\n9	5	24	2	3	1\n9	5	25	8	9	10	11	13	17	18	21	22	23	24	25	26\n9	5	25	10	10	17	16	72	42	3	1	2	1	1	7	1\n9	5	26	10	11	12	14	15	16	17	18	20	21	22	23	25	26	27	28	33\n9	5	26	4	2	2	7	1	1	45	2	2	1	2	1	1	24	1	1	1\n9	5	27	11	15	22	23	24	25	26	27	28\n9	5	27	1	1	1	1	3	1	9	11	2\n9	5	28	8	9	10	11	13	15	17	18	20	21	22	23	24	26	27	28	29	33\n9	5	28	1	5	4	4	43	1	11	1	1	1	1	2	1	6	1	9	2	2\n9	5	29	14	21	22	26	29	33\n9	5	29	1	1	1	7	5	2\n9	5	30	11	22	27	29	30\n9	5	30	1	1	5	2	11\n9	5	31	8	10	13	17	21	31	32\n9	5	31	1	3	17	61	1	2	1\n9	5	32	26	28	31	32	33	37\n9	5	32	1	1	1	12	1	1\n9	5	33	33\n9	5	33	4\n9	5	35	11	13	14	35\n9	5	35	1	1	1	9\n9	5	36	16	36\n9	5	36	1	1\n9	5	37	23	28	35	37	39\n9	5	37	25	1	1	343	1\n9	5	38	35	38\n9	5	38	1	1\n9	5	40	17	40\n9	5	40	1	1\n9	6	0	0\n9	6	0	93\n9	6	6	6	7\n9	6	6	37826	8\n9	6	7	7	8	9	10\n9	6	7	32295	1	1	1\n9	6	8	6	7	8	9	10	12	13	18\n9	6	8	1	127	48835	5	2	11	17	1\n9	6	9	6	7	8	9	10	11	12	13	14	17\n9	6	9	22	145	229	67595	243	13	17	29	1	2\n9	6	10	7	8	9	10	11	12	13	14	18\n9	6	10	23	47	372	34652	49	13	20	1	2\n9	6	11	6	7	8	9	10	11	12	13	14	15	16	18	19	23	24\n9	6	11	1	183	18	140	316	640725	4517	646	22	147	47	3	2	1	1\n9	6	12	7	8	9	10	11	12	13	14	15	16	17	18	19	22	23\n9	6	12	84	7	78	93	7977	513940	582	239	279	352	12	4	2	1	1\n9	6	13	6	7	8	9	10	11	12	13	14	15	16	17	18	21	23\n9	6	13	1	322	25	62	24	592	2346	423361	615	2249	255	5	110	1	8\n9	6	14	7	9	10	11	12	13	14	15	16	17	18	20	21	22	23	27\n9	6	14	45	19	6	85	434	1154	215144	176	1364	7	64	1	7	1	1	1\n9	6	15	7	9	10	11	12	13	14	15	16	17	18	19	20	22\n9	6	15	100	13	4	177	410	3272	1156	205221	2518	8	152	4	13	1\n9	6	16	7	9	10	11	12	13	14	15	16	17	18	20	21	22\n9	6	16	14	3	5	26	694	304	1723	3547	273759	16	110	8	48	1\n9	6	17	7	9	10	11	12	13	14	15	16	17	18	19	21	22	26	28	30	40\n9	6	17	15	5	1	9	1	67	15	19	20	1043	1	1	10	1	1	1	1	1\n9	6	18	7	9	10	11	13	14	15	16	17	18	19	20	21	23	24\n9	6	18	10	5	1	2	232	66	343	192	1	10037	2	3	2	2	1\n9	6	19	7	9	10	11	12	14	15	17	18	19	20	21	22	27\n9	6	19	109	43	4	11	4	3	3	12	10	76	1	1	2	4\n9	6	20	7	9	10	13	15	16	17	18	19	20	21	22	23\n9	6	20	11	8	4	1	12	15	1	32	5	65624	13	3	1\n9	6	21	9	10	11	13	14	15	16	17	18	19	20	21	22	23	28	30\n9	6	21	11	2	1	1	2	587	114	3	1	3	193	119516	4	1	1	1\n9	6	22	7	10	13	16	18	19	20	21	22	26	33\n9	6	22	1	5	1	1	7	1	1	1	62	1	1\n9	6	23	9	10	12	13	15	16	17	20	21	22	23	29	37\n9	6	23	3	1	2	3	2	7	1	91	5	1	15411	1	16\n9	6	24	15	17	22	24	27\n9	6	24	1	1	3	3	1\n9	6	25	9	10	25	27\n9	6	25	3	4	5	1\n9	6	26	14	20	21	22	25	26	27	35\n9	6	26	1	3	3	9	1	44	2	2\n9	6	27	14	23	25	26	27	28	29\n9	6	27	1	1	2	4	8	2	1\n9	6	28	21	27	28	30	32	33\n9	6	28	1	2	12	1	1	1\n9	6	29	26	29	30	33\n9	6	29	3	6	1	1\n9	6	30	28	30\n9	6	30	1	11\n9	6	31	31	32\n9	6	31	2	1\n9	6	32	31	32\n9	6	32	1	12\n9	6	33	29	32	33	37\n9	6	33	1	1	7	1\n9	6	35	33	35\n9	6	35	2	10\n9	6	36	24\n9	6	36	1\n9	6	37	23	32	35	37\n9	6	37	21	1	1	334\n9	6	38	25\n9	6	38	1\n9	6	39	31\n9	6	39	1\n9	6	40	40\n9	6	40	1\n9	7	0	0\n9	7	0	93\n9	7	6	6\n9	7	6	37851\n9	7	7	6	7	8	9	10	11	13	15	18	21	22	24	25	27\n9	7	7	6	33462	3	8	2	1	1	1	2	2	1	1	1	1\n9	7	8	6	7	8	9	10	11	12	13\n9	7	8	2	1518	47603	15	3	4	1	16\n9	7	9	6	7	8	9	10	11	12	13	15	18	19	20	23	25	29\n9	7	9	3370	958	1008	62420	340	205	21	37	1	1	1	1	1	1	1\n9	7	10	6	7	8	9	10	11	12	13	15	17	23	27	30	32\n9	7	10	1	414	597	835	33380	79	23	31	1	2	1	1	2	1\n9	7	11	6	7	8	9	10	11	12	13	14	15	16	19	20	25\n9	7	11	24	4	1767	1379	636	640406	4699	585	9	127	27	1	2	1\n9	7	12	6	7	8	9	10	11	12	13	14	15	16	17	19\n9	7	12	19	532	2511	1604	1738	27076	487440	766	251	319	123	9	1\n9	7	13	6	8	9	10	11	12	13	14	15	16	17	18\n9	7	13	61	324	666	228	4602	5917	414573	668	2259	294	6	92\n9	7	14	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	30\n9	7	14	6	4	372	807	5064	7578	13355	189849	208	1695	3	42	1	2	1	1	1\n9	7	15	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21	22	24	35\n9	7	15	18	1	2	390	199	1264	2768	18290	3389	183384	2701	24	135	11	3	5	1	1\n9	7	16	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22\n9	7	16	2	67	108	163	600	97131	578	2786	3445	173608	13	113	1	9	17	3\n9	7	17	6	8	9	10	11	12	13	14	15	16	17	18	19	21	22	24	27	28	30\n9	7	17	3	3	8	16	18	15	30	14	20	18	934	16	3	4	2	1	2	2	3\n9	7	18	6	9	10	11	12	13	14	15	16	17	18	19	20	21	22	30\n9	7	18	2	11	5	7	49	211	117	320	165	15	9608	15	1	1	6	1\n9	7	19	11	12	13	14	15	16	17	18	19	20	22\n9	7	19	2	6	4	3	6	7	3	9	42	8	6\n9	7	20	10	11	12	13	14	15	16	17	18	19	20	21	22\n9	7	20	1	160	389	441	991	2260	45149	5	22	9	16486	17	8\n9	7	21	6	9	10	11	12	13	14	15	16	17	18	19	20	21	22	27	30	33	37\n9	7	21	2	1	1	80	4952	6151	183	20122	36519	15	3656	15	65	47832	10	1	1	1	1\n9	7	22	12	13	14	15	16	17	18	19	20	21	22	23	24	26	28	29	32	33	35\n9	7	22	2	7	1	5	9	1	5	7	5	13	25	1	1	1	1	1	1	1	2\n9	7	23	9	10	11	12	13	14	15	16	17	18	19	20	21	23	25	37\n9	7	23	3	1	9	3	49	85	126	6934	212	166	2	73	1335	6440	1	9\n9	7	24	21	22	24\n9	7	24	1	2	3\n9	7	25	17	19	21	25	28\n9	7	25	1	2	1	4	1\n9	7	26	14	16	19	21	22	24	25	26	28\n9	7	26	2	2	4	6	12	1	1	24	1\n9	7	27	15	18	22	23	25	26	27	28	37\n9	7	27	1	1	1	1	1	3	9	1	1\n9	7	28	17	21	22	27	28	30\n9	7	28	1	1	1	3	9	2\n9	7	29	25	26	27	29	30\n9	7	29	1	1	1	4	2\n9	7	30	23	30	32\n9	7	30	1	13	1\n9	7	31	28	31\n9	7	31	1	3\n9	7	32	27	31	32	33\n9	7	32	1	1	12	2\n9	7	33	31	32	33	34	35\n9	7	33	1	2	7	1	1\n9	7	35	25	33	35\n9	7	35	1	4	8\n9	7	37	16	17	18	21	23	27	37\n9	7	37	39	2	12	59	9	1	229\n9	7	40	40\n9	7	40	2\n9	8	0	0\n9	8	0	93\n9	8	6	6	11	13	15	18	21	22	24	26\n9	8	6	41351	1	1	1	6	4	1	1	1\n9	8	7	6	7	9	10	13	15	19	23\n9	8	7	4	36814	21	46	1	1	1	1\n9	8	8	7	8	10	12	13	17	19\n9	8	8	1037	52724	7	9	109	1	2\n9	8	9	6	7	8	9	10	11	12	13	21	23	24	26	27	28	30\n9	8	9	1585	560	895	64057	506	48	43	119	1	1	1	1	1	1	1\n9	8	10	7	8	9	10	11	12	13	14	16	19	20	23	24\n9	8	10	230	340	873	35842	111	31	84	1	4	1	1	1	1\n9	8	11	6	7	8	9	10	11	12	13	14	15	16	21	23	24	27\n9	8	11	9	3	920	1222	601	669331	6004	1174	11	239	59	1	1	1	1\n9	8	12	6	7	8	9	10	11	12	13	14	15	16	17	18	20	23\n9	8	12	6	38	821	741	1075	18583	587892	982	139	506	206	2	1	1	1\n9	8	13	6	8	9	10	11	12	13	14	15	16	17	18\n9	8	13	15	143	443	264	2466	5812	440485	1774	3129	471	10	113\n9	8	14	6	8	9	10	11	12	13	14	15	16	17	18	20	21\n9	8	14	2	2	72	415	871	3341	6080	185258	168	2101	3	31	2	2\n9	8	15	6	9	10	11	12	13	14	15	16	17	18	19	20	26\n9	8	15	14	72	58	580	1088	12248	2253	191975	4131	20	153	1	11	1\n9	8	16	8	9	10	11	12	13	14	15	16	17	18	20	21	23\n9	8	16	3	3	27	151	23112	580	2656	4900	235659	7	172	4	15	1\n9	8	17	8	9	10	11	12	13	14	15	16	17	18	19	21	23	24	28	32\n9	8	17	1	1	5	6	10	18	9	18	19	1146	3	2	4	1	1	1	1\n9	8	18	8	9	10	11	12	13	14	15	16	17	18	19\n9	8	18	3	1	3	2	20	267	101	374	286	22	12800	1\n9	8	19	11	12	13	14	15	16	17	18	19	26\n9	8	19	4	6	1	3	18	17	7	13	34	1\n9	8	20	11	12	13	14	15	16	17	18	19	20	21	24\n9	8	20	2	5	6	79	246	8017	3	8	3	8275	18	1\n9	8	21	11	12	13	14	15	16	17	18	19	20	21	22	23\n9	8	21	3	1556	1564	5	4245	13317	28	1349	8	55	27161	1	1\n9	8	22	12	13	15	16	17	18	19	20	21	22	23\n9	8	22	1	2	2	5	3	5	11	10	7	34	2\n9	8	23	10	11	12	13	14	15	16	17	18	19	20	21	23	25	37\n9	8	23	1	5	1	15	13	34	2475	91	86	3	33	454	3241	1	2\n9	8	24	19	21	22	23	24	25\n9	8	24	2	1	1	1	2	1\n9	8	25	20	22	24	25\n9	8	25	1	1	2	8\n9	8	26	16	19	20	21	22	24	26\n9	8	26	1	1	2	6	3	5	11\n9	8	27	19	20	22	23	24	25	26	27	37\n9	8	27	2	1	1	3	3	1	1	7	1\n9	8	28	22	25	27	28	30\n9	8	28	1	4	2	7	2\n9	8	29	23	26	29	30\n9	8	29	1	1	2	2\n9	8	30	23	27	28	30	32\n9	8	30	1	1	3	19	1\n9	8	31	25	27	29	30\n9	8	31	1	1	1	2\n9	8	32	28	30	31	32\n9	8	32	1	3	1	12\n9	8	33	25	26	28	30	31	32	33	35\n9	8	33	1	1	1	2	2	3	4	1\n9	8	34	34\n9	8	34	1\n9	8	35	25	30	35	37\n9	8	35	1	1	9	1\n9	8	37	16	17	18	21	23	35	37	38	40\n9	8	37	40	1	19	34	5	3	136	1	1\n9	8	40	17\n9	8	40	2\n10	1	0	0\n10	1	0	68\n10	1	6	6	9\n10	1	6	24591	2164\n10	1	7	7	8	9	10	12\n10	1	7	21311	452	545	180	22\n10	1	8	7	8	9	10	11	12	13\n10	1	8	44	29178	199	282	353	799	82\n10	1	9	6	7	8	9	10	11	12	13	14	15	20\n10	1	9	9	41	143	38440	289	594	470	139	26	22	1\n10	1	10	7	8	9	10	11	12	13	14	15\n10	1	10	16	26	279	19689	214	1013	70	220	29\n10	1	11	8	9	10	11	12	13	14	15	16	20\n10	1	11	9	39	173	381538	4665	710	284	210	13	3\n10	1	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n10	1	12	6	16	37	6601	356488	1130	956	308	52	5	6	4	5	852\n10	1	13	8	9	10	11	12	13	14	15	16	17	18	19	21\n10	1	13	36	54	35	701	1928	256172	2148	2881	149	10	3	3	721\n10	1	14	11	12	13	14	15	16	17	18	19	20	21\n10	1	14	47	290	1752	114906	541	706	15	39	2	31	1\n10	1	15	11	12	13	14	15	16	17	18	19	20	21	22	23	31\n10	1	15	224	469	3999	518	179756	678	15	31	16	87	3	1	5	1\n10	1	16	10	11	12	13	14	15	16	17	18	19	20	21	22	37\n10	1	16	2	38	136	353	1711	1114	94328	10	6	14	11192	6	2	80\n10	1	17	12	13	14	15	16	17	18	19	20	21	22	23	25	37\n10	1	17	1	76	40	34	23	983	18	7	34	15	5	5	1	10\n10	1	18	13	14	15	16	17	18	19	20	21	22	23	25	30\n10	1	18	11	7	9	32	36	333	9	6	21	6	7	1	1\n10	1	19	13	14	15	16	17	18	19	20	21	22	23	24	25\n10	1	19	1	12	54	2	27	27	949	11	47	8	45	1	26\n10	1	20	14	15	16	17	18	19	20	21	22	23	24	25	37\n10	1	20	14	2	23	5	18	36	12963	14	15	12	1	31	4\n10	1	21	15	16	17	18	19	20	21	22	23	24	25	26	27\n10	1	21	3	1	30	16	1	25	2478	14	18	6	18	1	1\n10	1	22	15	16	18	19	20	21	22	23	24	25	26\n10	1	22	1	1	4	7	29	13	191	8	2	37	1\n10	1	23	18	19	20	21	22	23	25	26	28	31\n10	1	23	1	1	6	15	9	176	10	3	8	1\n10	1	24	19	20	21	22	23	24	32\n10	1	24	1	2	2	5	1	39	3\n10	1	25	11	13	21	22	23	24	25	26	28	30	31\n10	1	25	1	1	2	3	24	1	263	2	7	2	6\n10	1	26	20	21	22	23	24	25	26	27	28	29	31	40\n10	1	26	1	5	13	1	2	11	63	2	4	2	10	1\n10	1	27	22	23	24	25	26	27	28	30\n10	1	27	5	1	2	1	3	16	2	3\n10	1	28	13	23	25	26	27	28	29	30	32	37\n10	1	28	1	8	2	4	1	37	2	2	1	1\n10	1	29	26	27	28	29	30	31\n10	1	29	1	1	3	10	2	1\n10	1	30	12	24	26	27	28	29	30	31	32\n10	1	30	1	1	1	3	4	1	45	1	3\n10	1	31	22	25	28	30	31	34\n10	1	31	1	1	8	1	65	2\n10	1	32	30	31	32	33\n10	1	32	5	1	18	1\n10	1	33	33\n10	1	33	2\n10	1	34	32	34\n10	1	34	1	5\n10	1	35	35	37\n10	1	35	22	1\n10	1	36	32	36	37\n10	1	36	1	6	1\n10	1	37	12	20	37	39\n10	1	37	1	4	108	1\n10	1	38	38	39	40\n10	1	38	2	1	1\n10	1	39	39\n10	1	39	2\n10	1	40	31	32	35	38	40\n10	1	40	6	1	1	1	14\n10	2	0	0\n10	2	0	68\n10	2	6	6	9\n10	2	6	23618	982\n10	2	7	7	8	9	10	12\n10	2	7	20592	348	220	140	112\n10	2	8	7	8	9	10	11	12	13\n10	2	8	66	28130	115	137	432	937	33\n10	2	9	6	7	8	9	10	11	12	13	14	15	18	23	25\n10	2	9	16	50	147	40252	184	355	421	120	84	104	1	1	1\n10	2	10	7	8	9	10	11	12	13	14	15	16	18\n10	2	10	10	30	260	19500	159	435	51	189	51	1	1\n10	2	11	8	9	10	11	12	13	14	15	16	20\n10	2	11	5	68	164	380717	6889	1075	1021	321	19	32\n10	2	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	24	28\n10	2	12	4	18	43	7272	352895	1442	1954	627	50	4	5	5	79	1883	1	1\n10	2	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n10	2	13	16	25	18	490	1980	250973	4177	5204	117	13	8	7	109	1359	1\n10	2	14	11	12	13	14	15	16	17	18	19	20	21	22\n10	2	14	40	341	1171	117440	789	775	12	37	10	216	9	2\n10	2	15	8	11	12	13	14	15	16	17	18	19	20	21	22	23	24\n10	2	15	1	152	436	4172	589	178401	633	14	35	16	480	31	2	1	1\n10	2	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	27	37\n10	2	16	1	19	75	269	1706	1760	65328	13	8	10	26762	14	3	1	1	38\n10	2	17	11	13	14	15	16	17	18	19	20	21	22	23	25	26	28	37\n10	2	17	1	83	39	31	32	788	25	11	65	29	9	14	2	2	1	4\n10	2	18	12	13	14	15	16	17	18	19	20	21	22	23	24	25	30\n10	2	18	1	15	4	3	26	30	332	11	12	43	7	13	2	2	1\n10	2	19	11	12	14	15	16	17	18	19	20	21	22	23	24	25	28\n10	2	19	1	1	17	62	2	20	38	697	9	66	1	78	1	55	2\n10	2	20	14	15	16	17	18	19	20	21	22	23	25	37\n10	2	20	17	1	25	11	17	18	24213	15	13	6	61	3\n10	2	21	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31\n10	2	21	1	2	8	12	5	33	4012	31	43	7	36	1	2	1	1\n10	2	22	17	18	19	20	21	22	23	24	25	26	27	28	29	30\n10	2	22	1	4	6	24	25	161	10	3	33	1	4	3	2	1\n10	2	23	15	18	19	21	22	23	25	26	27	28	31	37\n10	2	23	2	7	4	31	6	229	3	1	4	22	1	1\n10	2	24	20	21	22	23	24	25\n10	2	24	3	2	9	3	37	1\n10	2	25	15	20	21	22	23	24	25	26	27	28	29	30	31\n10	2	25	1	1	4	1	45	4	326	2	3	9	1	1	4\n10	2	26	19	20	21	22	23	24	25	26	27	28	29	30	31\n10	2	26	1	1	4	7	4	2	7	44	1	3	1	1	3\n10	2	27	22	25	26	27	30\n10	2	27	3	1	2	15	3\n10	2	28	23	24	25	26	27	28	29	30	31\n10	2	28	6	4	2	3	5	48	1	3	1\n10	2	29	27	29\n10	2	29	2	13\n10	2	30	15	24	27	28	29	30	31	32	33\n10	2	30	1	1	2	3	2	47	2	2	1\n10	2	31	18	25	27	28	29	30	31	32	40\n10	2	31	1	4	1	13	2	1	68	1	1\n10	2	32	28	30	31	32	33	37\n10	2	32	1	2	1	22	1	1\n10	2	33	20	33\n10	2	33	1	2\n10	2	34	29	31	34\n10	2	34	2	1	4\n10	2	35	35	40\n10	2	35	22	1\n10	2	36	31	36\n10	2	36	1	5\n10	2	37	20	34	37\n10	2	37	23	1	181\n10	2	38	37	38	39\n10	2	38	1	1	1\n10	2	39	26	39\n10	2	39	1	3\n10	2	40	31	34	35	37	38	40\n10	2	40	3	1	1	1	1	9\n10	3	0	0\n10	3	0	68\n10	3	6	6	8\n10	3	6	23633	1\n10	3	7	7	10\n10	3	7	20714	4\n10	3	8	7	8	12	13	15\n10	3	8	41	28629	1	9	1\n10	3	9	6	7	8	9	10	11	12	13	16\n10	3	9	34	55	190	41569	62	11	8	10	1\n10	3	10	7	8	9	10	11	12	13\n10	3	10	11	35	234	19881	10	4	12\n10	3	11	8	9	10	11	12	13	15	16	17	18	19\n10	3	11	6	70	177	387296	1874	159	44	8	1	1	2\n10	3	12	8	9	10	11	12	13	14	15	16	19	21\n10	3	12	12	22	52	6405	357514	313	76	99	23	1	6\n10	3	13	8	9	10	11	12	13	14	15	16	17	18	19	21\n10	3	13	12	16	18	423	1777	255747	299	1032	63	11	3	1	2\n10	3	14	9	10	11	12	13	14	15	16	17	19	20	26\n10	3	14	2	4	36	338	931	125394	79	445	5	1	1	1\n10	3	15	11	12	13	14	15	16	17	18	19	20	22\n10	3	15	108	345	3185	655	182470	583	4	2	4	2	1\n10	3	16	11	12	13	14	15	16	17	18\n10	3	16	13	67	187	1387	1721	63626	6	3\n10	3	17	12	13	14	15	16	17	18	19	20\n10	3	17	1	50	21	29	34	772	5	1	1\n10	3	18	10	12	13	14	15	16	17	18	19	20	21	22	23	27\n10	3	18	2	5	15	48	19	41	22	364	6	4	2	1	1	1\n10	3	19	11	12	13	14	15	16	17	18	19	20	24\n10	3	19	1	4	1	19	42	47	18	26	636	5	2\n10	3	20	13	14	15	16	17	18	19	20	21	22	24	37\n10	3	20	2	18	16	19	10	13	18	51959	1	4	1	2\n10	3	21	12	13	14	15	16	17	18	19	20	21	23	25	26\n10	3	21	12	7	3	9	46	22	13	39	22	7348	4	1	1\n10	3	22	15	16	17	18	19	20	21	22	24	25	26\n10	3	22	1	1	5	13	11	36	22	161	3	1	1\n10	3	23	11	13	15	16	17	18	19	20	21	22	23	25	28\n10	3	23	1	1	2	5	1	19	22	46	51	10	290	6	1\n10	3	24	18	19	20	21	22	23	24	28\n10	3	24	2	1	7	3	10	1	38	1\n10	3	25	19	20	22	23	24	25	26	27\n10	3	25	3	1	15	70	1	440	2	2\n10	3	26	21	22	23	24	25	26\n10	3	26	1	3	2	1	7	43\n10	3	27	19	21	22	23	24	26	27	30\n10	3	27	1	1	5	3	1	1	27	1\n10	3	28	19	20	21	22	23	25	26	27	28	29	30\n10	3	28	1	7	7	10	36	7	5	1	29	2	2\n10	3	29	11	17	22	25	26	27	28	29	30	32\n10	3	29	1	1	1	1	4	1	3	8	3	1\n10	3	30	14	16	19	21	23	25	26	27	28	29	30	31\n10	3	30	1	1	3	1	1	1	5	2	6	5	32	2\n10	3	31	22	23	25	26	28	30	31\n10	3	31	1	11	14	14	8	1	37\n10	3	32	27	28	30	31	32\n10	3	32	1	2	4	2	16\n10	3	33	33\n10	3	33	4\n10	3	34	29	30	34\n10	3	34	1	1	4\n10	3	35	21	22	25	33	35	40\n10	3	35	1	1	1	1	18	1\n10	3	36	36\n10	3	36	5\n10	3	37	20	23	27	30	32	35	36	37	40\n10	3	37	25	2	3	1	1	2	4	191	1\n10	3	38	38	40\n10	3	38	1	1\n10	3	39	38	39\n10	3	39	1	3\n10	3	40	26	36	40\n10	3	40	1	1	9\n10	4	0	0\n10	4	0	68\n10	4	6	6	7	8\n10	4	6	23665	1	1\n10	4	7	7	9	10\n10	4	7	20814	3	4\n10	4	8	7	8	9	12	13\n10	4	8	58	28812	3	4	8\n10	4	9	6	7	8	9	10	11	12	13	14\n10	4	9	16	57	142	41625	45	4	7	16	1\n10	4	10	7	8	9	10	11	12	13	14	18\n10	4	10	13	40	216	19906	7	5	11	1	1\n10	4	11	7	8	9	10	11	12	13	14	15	16	20\n10	4	11	1	8	75	196	391808	1948	216	3	39	10	1\n10	4	12	8	9	10	11	12	13	14	15	16	21\n10	4	12	20	17	44	5498	355812	331	68	118	32	10\n10	4	13	8	9	10	11	12	13	14	15	16	17	18	21\n10	4	13	7	77	13	325	1788	256931	323	1053	89	10	9	4\n10	4	14	10	11	12	13	14	15	16	17	19	20\n10	4	14	3	55	385	819	126045	108	503	1	1	1\n10	4	15	8	9	11	12	13	14	15	16	17	19	20	21\n10	4	15	1	4	86	302	2478	711	181367	597	8	5	1	4\n10	4	16	9	10	11	12	13	14	15	16	17	18	19	20	21	24\n10	4	16	3	1	16	52	162	1107	1559	62021	10	3	1	1	5	2\n10	4	17	9	10	11	12	13	14	15	16	17	18	19	21	22\n10	4	17	1	2	2	17	39	36	27	19	722	5	6	1	1\n10	4	18	9	10	12	13	14	15	16	17	18	19	20	21	22	27\n10	4	18	4	5	26	10	67	86	14	33	212	2	2	1	1	1\n10	4	19	9	12	13	14	15	16	17	18	19	20	21	24\n10	4	19	12	11	11	29	47	10	12	19	592	3	3	2\n10	4	20	9	11	12	14	15	16	17	18	19	20	21	22	32	37\n10	4	20	12	1	35	24	9	40	8	26	26	51923	5	4	1	2\n10	4	21	9	10	12	13	14	15	16	17	18	19	20	21	25	28\n10	4	21	8	1	19	12	40	105	3	33	29	75	23	7096	1	1\n10	4	22	9	10	12	14	15	16	17	18	19	20	21	22	24	25	26	28\n10	4	22	3	6	2	2	2	4	37	11	2	23	42	82	2	2	2	1\n10	4	23	9	10	14	15	17	18	19	20	21	22	23	25	30\n10	4	23	1	7	3	41	8	18	144	1	25	7	161	4	1\n10	4	24	10	14	15	16	18	19	21	22	24	26	27	28\n10	4	24	2	1	1	1	1	1	17	5	15	1	1	1\n10	4	25	14	16	17	18	19	20	21	22	23	25	26	28\n10	4	25	1	1	5	4	148	97	52	48	11	109	2	1\n10	4	26	10	11	14	17	18	21	22	23	24	25	26	28	31\n10	4	26	5	2	1	2	6	3	7	1	1	4	44	1	1\n10	4	27	10	13	14	16	18	20	21	22	23	24	25	26	27	29\n10	4	27	7	1	1	1	3	1	3	4	1	1	3	2	9	1\n10	4	28	13	17	18	23	26	28	37\n10	4	28	2	1	1	5	3	37	1\n10	4	29	25	26	29\n10	4	29	1	1	14\n10	4	30	10	13	15	16	17	18	19	22	25	26	28	30	32\n10	4	30	6	1	1	6	3	1	1	4	3	1	1	15	2\n10	4	31	10	14	17	20	27	28	29	30	31	37\n10	4	31	2	1	1	1	1	4	1	1	28	1\n10	4	32	16	17	19	25	27	32\n10	4	32	1	1	1	1	2	12\n10	4	33	31	33	35\n10	4	33	1	3	1\n10	4	34	31	34\n10	4	34	1	3\n10	4	35	35\n10	4	35	20\n10	4	36	36\n10	4	36	10\n10	4	37	17	20	37\n10	4	37	1	13	179\n10	4	38	37	38\n10	4	38	1	1\n10	4	39	37	38	39\n10	4	39	1	1	1\n10	4	40	31	34	35	40\n10	4	40	3	1	2	6\n10	5	0	0\n10	5	0	68\n10	5	6	6	7	8	9	11\n10	5	6	23584	31	44	16	6\n10	5	7	7	8	9	10	11	12	13\n10	5	7	20794	87	27	3	27	1	5\n10	5	8	7	8	9	10	11	12	13	14\n10	5	8	90	28839	35	9	36	7	14	1\n10	5	9	6	7	8	9	10	11	12	13	14	17\n10	5	9	17	62	344	41417	98	98	12	13	2	1\n10	5	10	7	8	9	10	11	12	13	14	17\n10	5	10	18	60	230	19866	43	11	16	6	5\n10	5	11	7	8	9	10	11	12	13	14	15	16	21\n10	5	11	8	165	89	168	394938	2068	242	73	49	3	1\n10	5	12	7	8	9	10	11	12	13	14	15	16	18	19	21\n10	5	12	4	38	28	40	4904	354725	318	95	230	25	1	1	4\n10	5	13	7	8	9	10	11	12	13	14	15	16	17	18	19	21\n10	5	13	19	662	176	13	471	1562	256614	323	1121	79	2	1	1	4\n10	5	14	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\n10	5	14	39	28	4	164	360	784	126346	120	593	7	6	6	3	4	1\n10	5	15	7	8	9	10	11	12	13	14	15	16	17	18	19	20	23\n10	5	15	1	32	3	2	92	299	2174	703	180554	693	3	4	1	1	1\n10	5	16	8	9	10	11	12	13	14	15	16	17	18	19	20	22\n10	5	16	225	15	3	46	73	129	896	1442	60496	7	14	3	2	1\n10	5	17	8	9	11	12	13	14	15	16	17	18	19	21\n10	5	17	12	11	28	23	63	39	31	31	650	4	3	1\n10	5	18	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	28	30\n10	5	18	13	12	1	20	8	37	16	20	16	22	164	4	9	2	2	2	1\n10	5	19	8	9	11	12	13	14	15	17	18	19	20	21	22\n10	5	19	83	15	24	4	29	19	89	11	20	703	5	2	1\n10	5	20	8	9	11	12	13	14	15	16	17	18	19	20	21	22	35	37\n10	5	20	68	11	8	11	30	20	7	9	11	20	39	51845	2	3	2	5\n10	5	21	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26\n10	5	21	12	7	1	8	20	31	2	10	17	22	15	2	9	7106	5	1	2	1\n10	5	22	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	30	35\n10	5	22	14	8	2	4	1	12	3	6	4	3	4	3	22	14	61	1	1\n10	5	23	8	9	11	13	14	15	16	17	18	20	21	22	23	24	25	26	27\n10	5	23	32	10	17	39	3	17	2	24	6	4	4	2	13	3	1	1	1\n10	5	24	9	10	16	18	20	21	22	24	30\n10	5	24	1	2	1	1	1	2	3	11	1\n10	5	25	8	9	10	11	13	15	16	17	18	20	22	23	25	26	32\n10	5	25	2	1	6	12	14	2	1	12	2	1	3	5	65	1	1\n10	5	26	10	11	13	16	17	20	21	22	24	25	26	35	36\n10	5	26	2	5	1	1	19	4	1	3	8	1	7	2	2\n10	5	27	11	15	18	21	25	27	28\n10	5	27	3	1	2	1	1	3	3\n10	5	28	8	9	11	12	13	15	17	18	22	23	24	25	26	28	30	36	37\n10	5	28	2	1	1	2	11	1	3	2	1	2	3	2	3	9	2	1	1\n10	5	29	11	22	24	25	29	35	36\n10	5	29	1	1	7	2	2	2	1\n10	5	30	10	12	13	14	25	27	28	30	32	35\n10	5	30	1	1	1	1	1	2	1	5	3	1\n10	5	31	8	10	11	13	17	25	31\n10	5	31	1	1	1	1	27	2	1\n10	5	32	24	25	32	36	37\n10	5	32	1	2	10	1	1\n10	5	33	21	35\n10	5	33	1	2\n10	5	34	25\n10	5	34	4\n10	5	35	12	14	15	16	17	19	25	35	36	38\n10	5	35	3	2	1	1	1	2	1	10	1	1\n10	5	36	16	19	25	27	36\n10	5	36	2	1	2	2	3\n10	5	37	20	26	28	33	35	36	37\n10	5	37	12	1	1	1	2	1	167\n10	5	38	38\n10	5	38	2\n10	5	39	39\n10	5	39	1\n10	5	40	35	40\n10	5	40	1	5\n10	6	0	0\n10	6	0	68\n10	6	6	6	7	9\n10	6	6	23568	30	3\n10	6	7	7	8	9\n10	6	7	21022	1	4\n10	6	8	6	7	8	9	10	11	12	13	14\n10	6	8	1	228	30518	12	2	2	3	7	1\n10	6	9	6	7	8	9	10	11	12	13\n10	6	9	20	300	161	41495	129	9	14	13\n10	6	10	7	8	9	10	11	12	13	14	18\n10	6	10	65	29	267	19824	22	3	9	2	1\n10	6	11	6	7	8	9	10	11	12	13	14	15	16	19	20	23\n10	6	11	4	531	19	144	296	397394	2067	306	104	57	32	1	1	1\n10	6	12	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21\n10	6	12	6	292	12	89	104	4387	353500	351	199	142	38	56	3	1	11\n10	6	13	6	7	8	9	10	11	12	13	14	15	16	17	21\n10	6	13	16	1782	8	217	12	267	1438	255194	326	1229	82	4	3\n10	6	14	7	8	9	10	11	12	13	14	15	16	17	18	20	21\n10	6	14	265	3	95	21	102	283	677	126390	106	548	32	13	13	2\n10	6	15	7	9	10	11	12	13	14	15	16	17	18	20	27\n10	6	15	582	90	5	60	196	1873	672	179456	754	7	3	2	1\n10	6	16	7	9	10	11	12	13	14	15	16	17	18	19	20	21	30\n10	6	16	32	32	4	5	40	101	774	1240	59727	10	3	1	2	2	1\n10	6	17	7	9	10	11	12	13	14	15	16	17	18	20	21	22\n10	6	17	58	44	9	21	3	48	16	19	9	570	4	5	22	2\n10	6	18	7	9	10	11	12	14	15	16	17	18	19	22\n10	6	18	58	47	4	3	2	2	4	22	8	109	1	6\n10	6	19	7	9	10	11	12	13	14	16	17	18	19	20	24\n10	6	19	454	257	15	1	5	2	10	3	2	2	16	1	1\n10	6	20	7	9	10	12	14	16	17	18	20	22	30	37\n10	6	20	47	53	48	1	1	13	3	6	51740	2	1	3\n10	6	21	7	9	10	11	12	13	15	17	18	19	20	21	22	23	24	25	27	35\n10	6	21	16	58	26	1	24	13	12	23	1	1	1	6942	22	1	5	1	1	1\n10	6	22	7	9	10	13	15	17	18	20	21	22	24	25	33	39\n10	6	22	2	3	34	2	1	2	3	4	2	27	3	1	1	1\n10	6	23	7	9	10	23	25\n10	6	23	4	11	1	6	1\n10	6	24	16	20	21	22	24	27\n10	6	24	1	1	1	6	22	4\n10	6	25	7	9	10	17	19	20	22	23	25\n10	6	25	1	27	32	4	2	1	1	1	15\n10	6	26	14	17	21	24	26\n10	6	26	1	1	2	2	8\n10	6	27	13	21	24	27\n10	6	27	1	1	1	5\n10	6	28	25	27	28	29	30\n10	6	28	1	1	11	1	2\n10	6	29	28	29\n10	6	29	1	1\n10	6	30	28	30\n10	6	30	2	8\n10	6	31	36\n10	6	31	1\n10	6	32	30	32\n10	6	32	2	12\n10	6	33	33\n10	6	33	1\n10	6	35	33	35	37\n10	6	35	1	21	1\n10	6	36	36\n10	6	36	10\n10	6	37	20	37\n10	6	37	16	158\n10	6	38	25	38\n10	6	38	1	2\n10	6	39	39\n10	6	39	1\n10	6	40	17	40\n10	6	40	2	3\n10	7	0	0\n10	7	0	68\n10	7	6	6\n10	7	6	23615\n10	7	7	6	7	8	9	10	21	27\n10	7	7	25	25730	3	7	1	2	1\n10	7	8	6	7	8	9	10	11	12	13	18	20\n10	7	8	21	48	30658	8	1	3	4	6	1	1\n10	7	9	6	7	8	9	10	11	12	13	15	16	18	19	20	24	27	28	30\n10	7	9	44	50	149	42189	179	244	17	16	16	5	18	15	2	1	1	1	1\n10	7	10	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22	23	26	27	29	30\n10	7	10	1	21	29	238	20171	52	3	16	2	1	4	4	1	7	1	2	6	2	2	1	2\n10	7	11	6	7	8	9	10	11	12	13	14	15	16	20	25	28\n10	7	11	95	18	20	71	221	399147	2277	331	19	51	21	1	1	1\n10	7	12	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21\n10	7	12	36	9	21	14	75	3998	352601	367	197	179	39	16	2	14	11\n10	7	13	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	26\n10	7	13	153	2	19	31	14	273	1370	254980	391	1240	98	2	13	3	7	1\n10	7	14	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	24\n10	7	14	8	6	3	12	63	263	660	126716	82	574	11	66	25	1	4	3	1\n10	7	15	6	8	9	10	11	12	13	14	15	16	17	18	19	21	23	24\n10	7	15	66	4	12	5	67	177	1606	641	178780	831	10	19	45	1	1	1\n10	7	16	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	25	27\n10	7	16	5	2	5	4	8	43	103	734	1167	59081	15	10	16	4	20	10	1	1\n10	7	17	6	9	11	12	13	14	15	16	17	19	21	24	27	28	35\n10	7	17	30	19	3	1	25	10	2	15	606	2	2	1	3	4	1\n10	7	18	6	8	9	11	13	14	16	17	18	19	20	21	22	23	24	25	26\n10	7	18	10	3	8	1	3	3	5	1	50	21	2	14	11	12	1	1	2\n10	7	19	10	15	16	19	21	22	24	27	32\n10	7	19	2	1	1	12	1	1	1	2	1\n10	7	20	12	13	14	15	16	17	18	19	20	21	22	25	27	37\n10	7	20	1	2	2	1	8	6	4	2	51728	1	25	1	1	6\n10	7	21	6	9	10	12	13	15	17	18	20	21	22	24	27	33	35	37\n10	7	21	2	2	1	17	9	2	3	1	3	6934	3	2	2	1	5	1\n10	7	22	18	20	21	22	24	27	29	33	35\n10	7	22	2	2	2	54	1	2	1	1	1\n10	7	23	9	21	22	23	25	37\n10	7	23	2	1	1	1	3	1\n10	7	24	21	22	23	24	25	27	35\n10	7	24	2	3	1	22	1	4	1\n10	7	25	20	22	23	24	25	26	29	32	35\n10	7	25	2	1	1	1	9	1	2	2	1\n10	7	26	24	26	27\n10	7	26	2	1	5\n10	7	27	25	27	35	37\n10	7	27	1	9	1	1\n10	7	28	16	18	21	24	25	27	28	30\n10	7	28	1	1	1	1	1	1	5	3\n10	7	29	28	30\n10	7	29	1	1\n10	7	30	30	31	32\n10	7	30	11	1	2\n10	7	32	21	27	32	33\n10	7	32	1	1	9	1\n10	7	33	33\n10	7	33	3\n10	7	35	33	35	37\n10	7	35	2	19	1\n10	7	36	36	37\n10	7	36	9	2\n10	7	37	20	37\n10	7	37	7	155\n10	7	38	38\n10	7	38	2\n10	7	39	10	40\n10	7	39	1	1\n10	7	40	17	40\n10	7	40	1	2\n10	8	0	0\n10	8	0	68\n10	8	6	6	9	13	15	17	18	20	21	23	24	25\n10	8	6	24093	6	1	1	1	1	2	3	1	1	1\n10	8	7	6	7	8	9	10	15	17	25\n10	8	7	1	25628	2	238	6	1	1	1\n10	8	8	6	7	8	10	11	13	14	22\n10	8	8	4	1177	29713	1	4	13	1	1\n10	8	9	6	7	8	9	10	11	12	13	14	17	23	24	28	30\n10	8	9	2152	1032	520	38634	208	15	18	21	1	1	2	1	1	3\n10	8	10	7	8	9	10	11	12	13	14	16	17	23\n10	8	10	250	325	592	19417	55	18	22	5	1	1	1\n10	8	11	6	7	8	9	10	11	12	13	14	15	16	20\n10	8	11	25	9	1241	960	465	398087	2619	347	22	70	13	1\n10	8	12	6	7	8	9	10	11	12	13	14	15	16	17	21	23\n10	8	12	8	433	1750	1139	1096	17197	334345	466	102	185	47	3	2	1\n10	8	13	6	8	9	10	11	12	13	14	15	16	17\n10	8	13	38	176	400	180	3052	3783	248473	541	1385	89	7\n10	8	14	9	10	11	12	13	14	15	16	17	18	20	21	24	37\n10	8	14	231	679	3464	4504	8228	110733	101	752	7	4	7	2	2	1\n10	8	15	6	9	10	11	12	13	14	15	16	17	18	20\n10	8	15	19	228	151	803	1699	13080	2143	162493	900	4	1	1\n10	8	16	9	10	11	12	13	14	15	16	17	18	19	20\n10	8	16	2	4	68	118	163	1363	1093	57860	6	4	1	1\n10	8	17	9	10	11	12	13	14	15	16	17	18	22	23\n10	8	17	6	10	31	5	12	15	14	13	557	5	6	1\n10	8	18	10	11	12	13	14	15	16	17	18	19	20	23\n10	8	18	2	12	17	10	52	16	6	3	66	2	1	1\n10	8	19	9	10	11	12	13	14	15	16	17	18	19	21	23	27\n10	8	19	1	1	7	7	7	15	28	3	4	20	63	4	1	1\n10	8	20	11	12	13	14	15	16	17	18	19	20	21	22	23	24	37\n10	8	20	102	171	196	449	863	35869	67	6	1	14021	1	4	1	1	1\n10	8	21	9	11	12	13	14	15	16	17	18	19	20	21	22	23	33	35\n10	8	21	1	1	2503	1818	1	15	11	7	5	2	2	2629	7	1	1	1\n10	8	22	11	13	14	15	16	17	18	19	20	21	22	25\n10	8	22	2	3	4	5	9	8	13	3	14	5	47	1\n10	8	23	11	13	15	17	18	19	20	21	23	30\n10	8	23	1	1	2	1	1	3	1	3	8	1\n10	8	24	19	21	22	24	27	35\n10	8	24	1	1	8	23	1	1\n10	8	25	15	18	19	20	23	24	25	27	28\n10	8	25	1	1	1	3	1	1	8	2	1\n10	8	26	21	23	26\n10	8	26	2	1	4\n10	8	27	14	15	18	20	21	23	24	25	26	27	37\n10	8	27	1	1	2	2	1	4	5	1	3	14	1\n10	8	28	23	25	26	27	28\n10	8	28	1	1	1	1	8\n10	8	29	25	26	29\n10	8	29	2	1	1\n10	8	30	27	28	30	32\n10	8	30	1	4	12	1\n10	8	31	27\n10	8	31	1\n10	8	32	25	28	32	33\n10	8	32	1	1	10	2\n10	8	33	32	33	34	35\n10	8	33	1	5	1	1\n10	8	35	21	27	35\n10	8	35	2	1	26\n10	8	36	36\n10	8	36	9\n10	8	37	16	17	20	34	36	37\n10	8	37	53	7	9	1	2	95\n10	8	38	35	38\n10	8	38	1	1\n10	8	40	17	40\n10	8	40	1	2\n10	9	0	0\n10	9	0	68\n10	9	6	6	9	11	12	13	15	18	21	24\n10	9	6	26314	12	1	1	1	6	2	2	1\n10	9	7	6	7	10	18\n10	9	7	1	28513	14	1\n10	9	8	6	7	8	10	11	12	13	17\n10	9	8	2	771	32913	5	1	4	30	1\n10	9	9	6	7	8	9	10	11	12	13	18	21	23	24	28\n10	9	9	1018	712	545	39940	163	10	16	29	1	1	1	1	1\n10	9	10	7	8	9	10	11	12	13	16	17	20	21	23\n10	9	10	136	214	564	21227	31	12	30	1	1	2	1	1\n10	9	11	6	7	8	9	10	11	12	13	15	16	18\n10	9	11	10	3	688	773	435	417649	2699	485	118	40	1\n10	9	12	6	7	8	9	10	11	12	13	14	15	16	17	28	32	35\n10	9	12	2	20	491	441	658	11775	335606	469	18	232	91	1	1	1	1\n10	9	13	6	8	9	10	11	12	13	14	15	16	17\n10	9	13	5	102	266	184	1667	3587	264253	877	1712	206	2\n10	9	14	6	8	9	10	11	12	13	14	15	16	17	18	20\n10	9	14	1	1	62	272	599	1975	3592	108068	42	824	9	1	2\n10	9	15	6	9	10	11	12	13	14	15	16	19	23\n10	9	15	3	25	36	365	614	7955	1182	155276	816	1	1\n10	9	16	10	11	12	13	14	15	16	17	18	20\n10	9	16	2	55	154	214	1274	1276	92645	2	1	3\n10	9	17	9	10	11	12	13	14	15	16	17	20	23	27	30	33\n10	9	17	1	1	18	1	9	15	19	9	607	2	1	1	1	1\n10	9	18	11	12	13	14	15	16	17	18	19\n10	9	18	8	4	2	22	18	15	5	54	1\n10	9	19	11	14	15	16	17	18	19\n10	9	19	8	7	14	10	2	12	24\n10	9	20	11	12	13	14	15	16	17	18	20	37\n10	9	20	3	3	2	43	100	7051	18	6	6837	2\n10	9	21	6	12	13	15	16	17	18	19	20	21	23	24	29	35\n10	9	21	1	662	683	8	2	11	5	2	3	1274	1	1	1	1\n10	9	22	14	15	16	17	18	19	20	21	22	24\n10	9	22	2	3	6	8	8	7	8	4	26	1\n10	9	23	13	15	16	17	18	19	20	21	22	23	24\n10	9	23	1	2	1	3	3	2	2	1	2	7	1\n10	9	24	17	18	19	20	21	22	24	26	27	28\n10	9	24	1	1	2	1	2	5	19	1	1	1\n10	9	25	12	17	18	20	22	23	25	27\n10	9	25	1	1	2	1	2	1	7	1\n10	9	26	17	20	21	22	25	26	27\n10	9	26	1	1	1	1	1	3	1\n10	9	27	19	21	22	23	24	27\n10	9	27	1	2	2	1	6	10\n10	9	28	19	24	25	26	27	28\n10	9	28	1	3	1	1	2	7\n10	9	29	31\n10	9	29	1\n10	9	30	28	29	30\n10	9	30	1	1	14\n10	9	32	23	30	31	32\n10	9	32	1	2	1	8\n10	9	33	31	32	33\n10	9	33	2	2	4\n10	9	34	32	33\n10	9	34	1	1\n10	9	35	17	21	24	27	33	35	37\n10	9	35	2	3	1	1	2	20	1\n10	9	36	27	36\n10	9	36	1	10\n10	9	37	16	17	20	27	37\n10	9	37	31	1	4	1	61\n10	9	38	38\n10	9	38	1\n10	9	40	39	40\n10	9	40	1	1\n11	1	0	0\n11	1	0	60\n11	1	6	6	9\n11	1	6	15241	1358\n11	1	7	7	8	9	10	12\n11	1	7	14335	358	338	118	22\n11	1	8	7	8	9	10	11	12	13	15	16\n11	1	8	32	19601	124	129	244	603	36	1	1\n11	1	9	6	7	8	9	10	11	12	13	14	15\n11	1	9	4	36	86	25066	194	367	267	107	25	20\n11	1	10	7	8	9	10	11	12	13	14	15	18\n11	1	10	8	15	155	11494	167	546	46	162	19	1\n11	1	11	8	9	10	11	12	13	14	15	16\n11	1	11	7	27	123	253926	2218	391	182	108	8\n11	1	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22\n11	1	12	5	19	16	5199	219941	629	643	156	25	5	11	2	5	467	1\n11	1	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21	28\n11	1	13	33	19	19	438	1353	164404	1252	1566	35	11	5	1	1	407	1\n11	1	14	11	12	13	14	15	16	17	18	19	20	21	27\n11	1	14	18	224	1103	69818	329	229	9	37	2	13	9	1\n11	1	15	11	12	13	14	15	16	17	18	19	20	21	22	23\n11	1	15	146	344	2940	318	113481	344	13	64	15	32	31	3	8\n11	1	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	37\n11	1	16	1	23	80	197	1079	645	51772	11	9	1	6578	15	1	1	1	34\n11	1	17	13	14	15	16	17	18	19	20	21	22	23	27	37\n11	1	17	67	60	55	26	966	45	4	28	31	3	21	1	3\n11	1	18	13	14	15	16	17	18	19	20	21	22	23\n11	1	18	9	6	1	7	27	418	12	5	47	3	26\n11	1	19	14	15	16	17	18	19	20	21	22	23	25\n11	1	19	8	55	1	22	38	902	23	48	11	35	36\n11	1	20	14	16	17	18	19	20	21	22	24	25	27	37\n11	1	20	4	9	4	5	49	6670	24	9	1	55	1	3\n11	1	21	13	15	16	17	18	19	20	21	22	23	24	25	26	27	29\n11	1	21	1	2	6	44	7	3	7	1442	31	29	8	17	1	2	1\n11	1	22	11	17	18	19	20	21	22	23	24	25	27\n11	1	22	1	1	1	5	24	35	249	2	7	57	1\n11	1	23	21	22	23	24	25	26	28	30	31\n11	1	23	8	3	156	1	1	3	1	2	1\n11	1	24	20	21	22	23	24	29	32\n11	1	24	1	3	13	2	98	1	1\n11	1	25	23	25	27	31\n11	1	25	15	298	3	1\n11	1	26	23	24	25	26	27	31\n11	1	26	1	3	1	17	1	2\n11	1	27	21	27	28	30\n11	1	27	1	14	1	1\n11	1	28	14	25	26	27	28	30	32\n11	1	28	1	1	1	1	8	2	1\n11	1	29	24	29	32	34\n11	1	29	1	6	1	1\n11	1	30	27	30	32\n11	1	30	1	18	1\n11	1	31	28	30	31	38\n11	1	31	2	1	5	1\n11	1	32	25	30	32\n11	1	32	1	1	4\n11	1	33	33\n11	1	33	2\n11	1	34	27\n11	1	34	1\n11	1	35	35	37\n11	1	35	1	1\n11	1	36	36\n11	1	36	1\n11	1	37	20	37\n11	1	37	3	37\n11	1	40	40\n11	1	40	2\n11	2	0	0\n11	2	0	60\n11	2	6	6	9\n11	2	6	14705	540\n11	2	7	7	8	9	10	12\n11	2	7	13906	245	129	49	82\n11	2	8	7	8	9	10	11	12	13\n11	2	8	40	18944	83	83	280	653	22\n11	2	9	6	7	8	9	10	11	12	13	14	15	18\n11	2	9	13	43	117	26093	136	216	281	87	67	52	1\n11	2	10	7	8	9	10	11	12	13	14	15	18\n11	2	10	5	18	161	11330	96	267	49	131	35	2\n11	2	11	8	9	10	11	12	13	14	15	16	17	18	20\n11	2	11	2	28	109	254689	4190	666	595	218	11	1	1	19\n11	2	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n11	2	12	2	9	16	4069	218007	880	1013	387	36	8	10	10	52	1099\n11	2	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	24	30\n11	2	13	10	13	6	290	1293	161828	2561	3054	49	8	5	2	61	747	1	1	1\n11	2	14	11	12	13	14	15	16	17	18	19	20	21	27\n11	2	14	27	203	771	71451	473	441	26	27	10	120	8	1\n11	2	15	11	12	13	14	15	16	17	18	19	20	21	22	23	24\n11	2	15	76	239	2264	346	112731	369	21	75	10	223	65	1	17	1\n11	2	16	10	11	12	13	14	15	16	17	18	19	20	21	22	23	25	37\n11	2	16	2	7	29	117	759	741	34792	11	2	6	15939	25	3	4	1	25\n11	2	17	8	13	14	15	16	17	18	19	20	21	22	23	27	37\n11	2	17	1	63	48	45	35	750	30	11	35	52	8	30	1	4\n11	2	18	12	13	14	15	16	17	18	19	20	21	22	23	24	25	27\n11	2	18	1	14	1	3	6	34	398	19	10	72	6	70	2	2	3\n11	2	19	11	14	15	16	17	18	19	20	21	23	25\n11	2	19	1	10	45	2	28	39	703	9	40	67	52\n11	2	20	11	14	15	16	17	18	19	20	21	22	23	25	27	37\n11	2	20	1	3	3	4	1	9	25	13247	13	7	5	63	3	6\n11	2	21	16	17	18	19	20	21	22	23	24	25	26	27\n11	2	21	2	39	10	9	15	2338	34	60	9	47	4	1\n11	2	22	16	18	19	20	21	22	23	24	25	26	28	30\n11	2	22	1	1	2	14	35	184	8	9	70	1	1	1\n11	2	23	15	18	19	20	21	22	23	25	26	27	28\n11	2	23	1	2	1	1	17	2	264	2	2	2	2\n11	2	24	21	22	24	32\n11	2	24	2	28	89	1\n11	2	25	22	23	24	25	27	30	31\n11	2	25	1	33	2	428	1	1	1\n11	2	26	19	21	22	23	24	26	29	31	32\n11	2	26	1	1	1	3	1	11	1	2	1\n11	2	27	22	27	28	30	32\n11	2	27	1	23	1	1	1\n11	2	28	19	23	26	27	28	30\n11	2	28	1	2	1	1	6	2\n11	2	29	29\n11	2	29	8\n11	2	30	27	28	30\n11	2	30	3	3	19\n11	2	31	30	31\n11	2	31	1	8\n11	2	32	30	32\n11	2	32	3	5\n11	2	33	33\n11	2	33	2\n11	2	34	32\n11	2	34	1\n11	2	35	35\n11	2	35	1\n11	2	36	36\n11	2	36	1\n11	2	37	20	37\n11	2	37	4	74\n11	2	38	38\n11	2	38	1\n11	2	40	31	40\n11	2	40	1	1\n11	3	0	0\n11	3	0	60\n11	3	6	6	9\n11	3	6	14717	1\n11	3	7	7\n11	3	7	13994\n11	3	8	7	8	13\n11	3	8	28	19308	3\n11	3	9	6	7	8	9	10	11	12	13\n11	3	9	9	38	95	26883	20	5	4	2\n11	3	10	7	8	9	10	11	12	13	14\n11	3	10	5	19	166	11523	11	2	4	1\n11	3	11	8	9	10	11	12	13	15	16	19\n11	3	11	5	42	132	258536	941	76	17	2	1\n11	3	12	8	9	10	11	12	13	14	15	16	18	21\n11	3	12	2	13	17	4404	220476	189	58	66	13	1	6\n11	3	13	8	9	10	11	12	13	14	15	16	17	18	21	23\n11	3	13	4	8	10	293	1262	164404	200	543	21	9	2	4	1\n11	3	14	11	12	13	14	15	16	17	18	19	20	22\n11	3	14	28	275	706	75703	50	210	6	1	3	2	1\n11	3	15	8	11	12	13	14	15	16	17	18	19	24\n11	3	15	1	54	247	2398	386	114371	319	5	1	5	1\n11	3	16	11	12	13	14	15	16	17	18\n11	3	16	5	16	79	878	1004	33761	4	1\n11	3	17	13	14	15	16	17	18	19	20	21\n11	3	17	65	55	42	22	736	3	2	1	1\n11	3	18	11	12	13	14	15	16	17	18	19	23\n11	3	18	1	3	11	5	9	6	18	555	3	1\n11	3	19	11	12	14	15	16	17	18	19	20	22	26\n11	3	19	1	2	11	66	3	22	30	670	3	1	1\n11	3	20	14	15	16	17	18	19	20	21	22	37\n11	3	20	6	3	10	2	5	49	29667	3	3	1\n11	3	21	12	13	14	16	17	18	19	20	21	22	23\n11	3	21	1	7	1	7	32	10	6	15	4419	9	7\n11	3	22	18	19	20	21	22	24\n11	3	22	1	5	18	42	209	1\n11	3	23	15	16	18	19	20	21	22	23	25	27\n11	3	23	1	1	17	3	9	72	5	448	7	1\n11	3	24	20	21	22	24	28\n11	3	24	2	1	19	91	1\n11	3	25	19	21	22	23	25	28\n11	3	25	1	2	1	65	595	1\n11	3	26	13	20	21	23	24	26\n11	3	26	1	1	2	1	1	13\n11	3	27	22	23	24	25	26	27	28\n11	3	27	3	1	2	1	2	29	1\n11	3	28	20	22	23	24	25	26	28	30\n11	3	28	1	1	3	2	1	1	3	1\n11	3	29	29	31\n11	3	29	8	1\n11	3	30	22	28	30	32\n11	3	30	1	4	21	3\n11	3	31	21	23	25	26	29	31\n11	3	31	1	2	2	2	1	4\n11	3	32	27	29	32	33	37\n11	3	32	1	1	4	2	1\n11	3	33	33\n11	3	33	2\n11	3	35	35\n11	3	35	1\n11	3	36	36\n11	3	36	1\n11	3	37	20	37\n11	3	37	10	99\n11	3	38	38\n11	3	38	1\n11	3	40	40\n11	3	40	1\n11	4	0	0\n11	4	0	60\n11	4	6	6\n11	4	6	14726\n11	4	7	7	9\n11	4	7	14064	1\n11	4	8	7	8	12	13\n11	4	8	36	19393	1	4\n11	4	9	6	7	8	9	10	11	12	13\n11	4	9	34	48	113	26887	23	5	1	2\n11	4	10	7	8	9	10	11	12	13\n11	4	10	8	15	133	11538	4	3	1\n11	4	11	8	9	10	11	12	13	14	15	16	18\n11	4	11	8	56	91	262054	1018	89	3	15	3	1\n11	4	12	7	8	9	10	11	12	13	14	15	16	18	19	21\n11	4	12	1	17	16	26	3665	219178	202	41	65	11	1	2	4\n11	4	13	8	9	10	11	12	13	14	15	16	17	18	21\n11	4	13	14	54	7	214	1133	165685	212	588	27	7	2	2\n11	4	14	9	10	11	12	13	14	15	16	17	19\n11	4	14	1	6	32	302	621	76073	50	215	2	2\n11	4	15	8	9	10	11	12	13	14	15	16	17	18	19	21\n11	4	15	1	3	1	45	224	1738	467	113344	336	6	1	5	1\n11	4	16	9	10	11	12	13	14	15	16	17	18	21\n11	4	16	4	1	6	23	72	610	946	32707	4	1	1\n11	4	17	9	10	11	12	13	14	15	16	17	18	19	21\n11	4	17	1	1	3	14	58	58	20	20	653	3	1	2\n11	4	18	9	10	11	12	13	14	15	16	17	18	19	20	21\n11	4	18	2	5	1	51	12	110	150	3	32	251	5	2	3\n11	4	19	9	11	12	13	14	15	16	17	18	19	20	22\n11	4	19	8	2	15	7	10	77	5	27	23	570	3	1\n11	4	20	9	10	12	14	15	16	17	18	19	20	21	22	37\n11	4	20	13	1	51	16	10	6	6	6	35	29581	1	2	1\n11	4	21	9	10	12	13	14	15	16	17	18	19	20	21	22	23\n11	4	21	4	1	21	4	64	217	2	66	45	71	19	4034	1	4\n11	4	22	9	10	14	15	16	17	18	19	20	21	22	24	25\n11	4	22	1	2	1	6	2	72	15	3	13	74	62	1	1\n11	4	23	9	13	14	15	16	17	18	19	20	21	23	28\n11	4	23	1	1	1	42	2	30	33	124	1	27	266	1\n11	4	24	10	12	14	19	20	21	22	23	24	27\n11	4	24	2	1	2	1	1	29	16	1	44	1\n11	4	25	16	17	18	19	20	21	22	23	24	25\n11	4	25	1	4	6	173	138	58	67	13	1	145\n11	4	26	14	17	18	20	23	24	25	26\n11	4	26	1	1	1	1	1	2	1	11\n11	4	27	10	16	17	18	19	20	21	22	23	24	27\n11	4	27	1	2	2	2	1	3	5	3	2	1	9\n11	4	28	10	17	18	19	26	27	28	29\n11	4	28	2	1	1	1	1	1	2	1\n11	4	29	10	18	22	25	26	27	28	29\n11	4	29	1	1	1	1	1	2	1	2\n11	4	30	10	16	18	22	25	28	29	30	32\n11	4	30	2	2	2	1	1	1	1	11	1\n11	4	31	26	27	28	31	32\n11	4	31	1	1	1	1	1\n11	4	32	19	27	29	32	35\n11	4	32	1	1	1	3	1\n11	4	33	29	35\n11	4	33	1	3\n11	4	35	35\n11	4	35	1\n11	4	36	31\n11	4	36	1\n11	4	37	20	37	40\n11	4	37	5	95	1\n11	4	38	35\n11	4	38	1\n11	4	40	35\n11	4	40	1\n11	5	0	0\n11	5	0	60\n11	5	6	6	7	8	9	11	13\n11	5	6	14716	23	15	2	3	1\n11	5	7	7	8	9	10	11	12	13\n11	5	7	14120	24	7	1	3	1	1\n11	5	8	7	8	9	10	11	12	13	15\n11	5	8	28	19502	9	6	7	1	6	2\n11	5	9	6	7	8	9	10	11	12	13\n11	5	9	16	43	158	26877	65	18	3	5\n11	5	10	7	8	9	10	11	12	13	15	17\n11	5	10	11	26	130	11516	12	9	5	1	1\n11	5	11	7	8	9	10	11	12	13	15	16\n11	5	11	5	23	47	124	264653	1039	117	17	6\n11	5	12	7	8	9	10	11	12	13	14	15	16	18	21\n11	5	12	1	13	20	33	2956	218663	211	56	69	12	1	1\n11	5	13	7	8	9	10	11	12	13	14	15	16	17\n11	5	13	4	97	32	12	206	1123	166279	180	530	26	7\n11	5	14	8	9	10	11	12	13	14	15	16	17	19\n11	5	14	4	8	1	30	297	554	76430	65	275	3	2\n11	5	15	8	9	10	11	12	13	14	15	16	17	19	20	25\n11	5	15	2	2	1	27	156	1293	476	113158	391	3	19	1	1\n11	5	16	8	9	10	11	12	13	14	15	16	17	18	20	21\n11	5	16	21	3	1	8	19	42	483	930	31831	3	1	1	1\n11	5	17	9	10	11	12	13	14	15	16	17	18	19	21\n11	5	17	1	1	2	26	62	77	49	29	657	1	4	4\n11	5	18	8	10	12	13	14	15	16	17	18	20	21\n11	5	18	1	1	5	34	4	64	11	26	246	2	1\n11	5	19	8	9	11	12	13	14	15	16	17	18	19	20	21	23\n11	5	19	9	4	2	12	4	10	79	2	11	43	812	5	1	1\n11	5	20	8	11	12	13	14	15	16	17	18	19	20	21	22	26	37\n11	5	20	11	1	22	2	21	10	18	7	11	55	29603	2	1	1	2\n11	5	21	8	11	12	13	14	15	16	17	18	19	20	21	22\n11	5	21	2	1	10	9	13	71	31	58	22	1	10	4008	5\n11	5	22	8	9	14	18	19	20	21	22\n11	5	22	3	1	1	4	1	7	18	119\n11	5	23	8	9	11	13	15	16	17	18	20	21	22	23	25	28\n11	5	23	4	3	2	5	50	14	75	72	2	14	2	41	2	1\n11	5	24	10	16	18	20	21	22	24\n11	5	24	1	1	2	1	2	8	34\n11	5	25	8	12	13	20	21	23	25	26\n11	5	25	1	1	1	2	1	6	136	1\n11	5	26	14	16	17	21	23	26\n11	5	26	1	1	2	1	2	7\n11	5	27	18	19	20	23	27	28	33\n11	5	27	4	2	2	1	4	1	1\n11	5	28	13	21	26	27	30\n11	5	28	2	1	1	1	1\n11	5	29	21	29	33\n11	5	29	2	3	1\n11	5	30	24	26	30	32	37\n11	5	30	1	1	7	1	1\n11	5	31	17	31\n11	5	31	1	1\n11	5	32	30	32\n11	5	32	1	4\n11	5	35	14	35	37\n11	5	35	1	5	1\n11	5	37	20	37\n11	5	37	5	91\n11	5	40	40\n11	5	40	1\n11	6	0	0\n11	6	0	60\n11	6	6	6	7	9	10\n11	6	6	14594	131	6	1\n11	6	7	6	7	8	9	10\n11	6	7	1	14220	2	11	1\n11	6	8	6	7	8	9	10	12	13	14\n11	6	8	3	362	19510	33	2	2	2	2\n11	6	9	6	7	8	9	10	11	12	13	14	21\n11	6	9	11	457	101	26477	81	8	6	3	1	1\n11	6	10	7	8	9	10	11	12	13	14\n11	6	10	97	18	138	11464	27	8	2	9\n11	6	11	6	7	8	9	10	11	12	13	14	15	16\n11	6	11	3	581	11	145	234	265307	1172	181	271	21	5\n11	6	12	6	7	8	9	10	11	12	13	14	15	16	17	18	21\n11	6	12	2	224	8	72	81	2923	217453	203	171	231	13	2	2	2\n11	6	13	6	7	8	9	10	11	12	13	14	15	16	21\n11	6	13	25	2321	3	296	10	153	1035	163889	226	655	19	1\n11	6	14	7	9	10	11	12	13	14	15	16	17	18	24\n11	6	14	251	94	30	125	200	459	76125	194	266	2	6	1\n11	6	15	7	8	9	10	11	12	13	14	15	16	17	20	24\n11	6	15	934	1	112	7	63	113	1100	492	111851	415	3	2	2\n11	6	16	7	9	10	11	12	13	14	15	16	17	19	21\n11	6	16	19	36	4	4	27	32	442	845	31232	5	1	1\n11	6	17	7	8	9	10	11	12	13	14	15	16	17	18	19	21\n11	6	17	80	1	108	15	14	3	78	13	181	16	337	5	1	2\n11	6	18	7	9	10	11	12	13	14	15	17	18	21\n11	6	18	88	91	9	2	4	10	12	29	3	156	3\n11	6	19	7	9	10	12	13	14	15	16	17	18	19	21\n11	6	19	471	342	35	10	1	15	6	3	1	1	10	1\n11	6	20	7	9	10	13	14	15	16	18	20	21	36	37\n11	6	20	57	77	81	3	4	8	3	7	29396	1	1	3\n11	6	21	7	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	27	28\n11	6	21	25	63	24	10	21	2	82	6	4	18	3	1	3764	14	2	15	2	1\n11	6	22	7	9	10	12	13	15	16	17	18	19	21	22	23	24	25	27\n11	6	22	3	3	81	2	1	5	1	7	1	1	13	1	1	8	6	1\n11	6	23	7	9	10	13	17	18	21	23	24\n11	6	23	5	9	3	1	4	1	1	26	1\n11	6	24	10	12	15	18	21	22	23	24	25	27\n11	6	24	2	1	2	1	2	1	1	9	4	12\n11	6	25	7	9	10	17	18	21	24	40\n11	6	25	5	53	74	3	1	1	1	1\n11	6	26	10	21	24	26	36\n11	6	26	1	2	3	4	1\n11	6	27	10	12	27\n11	6	27	2	1	2\n11	6	28	28\n11	6	28	2\n11	6	29	18	24	30\n11	6	29	1	1	1\n11	6	30	12	30\n11	6	30	1	8\n11	6	31	20\n11	6	31	1\n11	6	32	32\n11	6	32	5\n11	6	33	37	38\n11	6	33	1	1\n11	6	35	33	35	37\n11	6	35	1	1	3\n11	6	37	20	37\n11	6	37	8	87\n11	6	40	40\n11	6	40	1\n11	7	0	0\n11	7	0	60\n11	7	6	6	9\n11	7	6	14638	1\n11	7	7	6	7	8	9	10	21	22\n11	7	7	73	20249	3	2	2	1	1\n11	7	8	6	7	8	9	11	13\n11	7	8	91	33	19526	3	1	1\n11	7	9	6	7	8	9	10	11	12	13	14	15	16	19	23	27	28\n11	7	9	125	45	131	27688	99	50	8	5	1	4	3	4	1	1	1\n11	7	10	6	7	8	9	10	11	12	13	14	17	19	20	21	23	26	27\n11	7	10	15	18	22	170	11977	20	2	5	2	1	1	1	1	3	3	1\n11	7	11	6	7	8	9	10	11	12	13	14	15	16	17	23\n11	7	11	354	39	55	68	321	266441	1109	150	48	22	17	1	1\n11	7	12	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22\n11	7	12	201	28	55	24	125	2322	216799	238	103	92	20	21	8	5	1	5	1\n11	7	13	6	7	8	9	10	11	12	13	14	15	16	17	21	23\n11	7	13	899	3	10	70	18	148	989	162833	266	714	32	2	1	1\n11	7	14	6	7	8	9	10	11	12	13	14	15	16	17	18	19	24\n11	7	14	32	1	40	2	48	29	171	406	76685	47	303	17	1	2	1\n11	7	15	6	8	9	10	11	12	13	14	15	16	17	18	19\n11	7	15	329	8	68	9	24	100	980	432	111727	425	6	1	1\n11	7	16	6	8	9	10	11	12	13	14	15	16	17	20	21	37\n11	7	16	33	9	15	12	5	29	29	378	679	30747	28	3	11	1\n11	7	17	6	9	10	12	13	14	15	16	17	18	21	22	28\n11	7	17	88	64	2	1	5	3	3	4	188	3	6	2	2\n11	7	18	6	8	9	10	11	13	16	17	18	21	22	28\n11	7	18	47	11	59	1	1	6	1	2	66	3	2	1\n11	7	19	8	9	14	15	19	23	29\n11	7	19	2	1	1	1	9	1	1\n11	7	20	10	12	13	16	20	26	37\n11	7	20	1	2	6	2	29393	1	3\n11	7	21	6	8	9	10	11	12	13	15	18	20	21	27	28	29	30	31	35	37\n11	7	21	4	2	10	5	1	10	10	5	1	1	3737	3	1	1	1	1	1	1\n11	7	22	15	18	22\n11	7	22	2	2	12\n11	7	23	6	9	18	20	23\n11	7	23	1	22	1	1	5\n11	7	24	15	18	21	22	23	24\n11	7	24	1	2	4	2	1	31\n11	7	25	18	24	25\n11	7	25	1	1	8\n11	7	26	18	21	28\n11	7	26	1	2	1\n11	7	27	13	21	24	27\n11	7	27	1	2	2	12\n11	7	28	15	28\n11	7	28	1	2\n11	7	30	28	30\n11	7	30	1	8\n11	7	32	30	32	37\n11	7	32	1	3	1\n11	7	33	33\n11	7	33	1\n11	7	35	35\n11	7	35	1\n11	7	36	36\n11	7	36	2\n11	7	37	20	30	37\n11	7	37	8	1	85\n11	7	38	38\n11	7	38	1\n11	7	40	40\n11	7	40	2\n11	8	0	0\n11	8	0	60\n11	8	6	6	9	13	15	20	22\n11	8	6	16922	4	1	1	1	1\n11	8	7	6	7	8	9	10	11	12	13	15	17\n11	8	7	12	19775	1	617	3	3	1	1	2	1\n11	8	8	6	7	8	9	10	11	12	13	15	16	17	18	19	20	21	23\n11	8	8	11	30	19784	5	3	14	3	4	4	2	1	1	4	1	4	3\n11	8	9	6	7	8	9	10	11	12	13	14	17	18	23	28	30\n11	8	9	24	48	112	27879	124	26	29	4	8	4	3	2	2	2\n11	8	10	6	7	8	9	10	11	12	13	14	15	16	17	18	19	32\n11	8	10	3	22	15	156	12346	36	9	5	17	4	1	2	2	1	1\n11	8	11	6	7	8	9	10	11	12	13	14	15	16	18	19	20\n11	8	11	52	21	10	31	181	267107	1314	184	51	55	25	4	6	1\n11	8	12	6	7	8	9	10	11	12	13	14	15	16	17	19	20	21	23\n11	8	12	25	9	6	12	37	2063	216537	282	102	103	27	10	2	1	3	1\n11	8	13	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22	23	27\n11	8	13	96	1	8	14	11	161	988	162130	365	852	34	7	1	1	1	1	2	2\n11	8	14	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21	30\n11	8	14	3	4	3	15	13	25	159	393	76783	57	332	6	118	2	5	1\n11	8	15	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	27	28\n11	8	15	49	3	19	1	18	95	845	485	111004	547	7	119	2	1	96	1	3	2	1\n11	8	16	6	8	9	11	12	13	14	15	16	17	18	19	20	23	28\n11	8	16	2	2	3	3	8	24	319	637	30545	2	1	2	4	1	1\n11	8	17	9	11	13	14	16	17	21	32\n11	8	17	1	1	2	2	4	254	1	1\n11	8	18	6	10	11	13	14	18	19	21	24	27\n11	8	18	1	2	1	1	3	43	1	28	3	4\n11	8	19	15	17	18	19	21	22	23\n11	8	19	1	1	2	13	1	3	1\n11	8	20	10	14	15	16	18	20	37\n11	8	20	1	1	1	1	1	29400	3\n11	8	21	9	12	13	17	18	20	21	22	24\n11	8	21	4	7	4	1	2	1	3751	2	1\n11	8	22	15	21	22\n11	8	22	5	5	10\n11	8	23	18	19	22	23\n11	8	23	1	1	2	9\n11	8	24	15	21	22	23	24	27	28	36\n11	8	24	3	3	3	1	20	3	1	1\n11	8	25	25	27\n11	8	25	3	5\n11	8	26	23	26\n11	8	26	1	3\n11	8	27	21	23	27	29\n11	8	27	4	1	11	1\n11	8	28	23	27	28\n11	8	28	1	1	7\n11	8	29	29	30\n11	8	29	1	1\n11	8	30	17	28	30	32\n11	8	30	1	1	8	1\n11	8	31	31\n11	8	31	1\n11	8	32	32	35\n11	8	32	2	1\n11	8	33	33\n11	8	33	1\n11	8	35	35\n11	8	35	2\n11	8	36	37\n11	8	36	2\n11	8	37	20	32	35	37\n11	8	37	5	1	1	84\n11	8	38	38\n11	8	38	1\n11	8	40	40\n11	8	40	2\n11	9	0	0\n11	9	0	60\n11	9	6	6	9	11	12	15	16	17	18	19	20	21	23	24	27\n11	9	6	17078	103	3	2	2	1	2	2	1	1	1	2	1	1\n11	9	7	6	7	9	10	13	18\n11	9	7	2	19900	1	4	1	2\n11	9	8	6	7	8	9	10	12	13	14	18\n11	9	8	1	1008	18916	1	4	5	7	1	1\n11	9	9	6	7	8	9	10	11	12	13	20	23	27	28	30	32\n11	9	9	1480	1259	354	25584	51	6	6	10	1	2	1	4	1	1\n11	9	10	7	8	9	10	11	12	13	14	16\n11	9	10	188	217	427	11847	18	13	7	4	1\n11	9	11	6	7	8	9	10	11	12	13	14	15	16\n11	9	11	13	4	902	571	322	266246	1250	118	6	23	3\n11	9	12	6	7	8	9	10	11	12	13	14	15	16	17	18	21	31\n11	9	12	6	379	1375	831	721	12475	203006	221	18	94	18	3	1	1	1\n11	9	13	6	8	9	10	11	12	13	14	15	16\n11	9	13	15	142	280	135	2166	2717	157364	221	801	39\n11	9	14	6	9	10	11	12	13	14	15	16	17	18	20	21\n11	9	14	2	182	524	2625	2866	5522	65965	43	394	3	3	5	2\n11	9	15	6	9	10	11	12	13	14	15	16	17	19	22	24	37\n11	9	15	11	183	90	597	1209	9203	1433	99490	508	1	1	1	1	1\n11	9	16	9	10	11	12	13	14	15	16	17	18	19	20\n11	9	16	1	11	45	76	89	775	682	29831	3	2	1	2\n11	9	17	10	12	13	14	15	16	17	18	21	26\n11	9	17	12	3	8	9	5	8	240	5	6	1\n11	9	18	9	10	11	12	13	14	15	16	17	18	21\n11	9	18	1	1	39	10	4	84	68	4	3	82	2\n11	9	19	9	11	12	15	16	18	19	21	23\n11	9	19	1	2	4	6	1	1	15	2	1\n11	9	20	10	11	12	13	14	15	16	17	20	22	23	26	37\n11	9	20	1	48	90	76	229	412	21448	51	7057	1	1	1	2\n11	9	21	6	10	11	12	13	14	15	16	17	18	21	23	25\n11	9	21	1	1	7	1439	1025	10	86	3	8	30	1290	1	1\n11	9	22	12	13	15	18	19	22	26\n11	9	22	1	1	4	3	1	12	1\n11	9	23	15	19	20	21	22	23	28\n11	9	23	1	2	3	3	2	14	1\n11	9	24	13	15	18	21	22	24\n11	9	24	2	1	1	1	3	16\n11	9	25	24	25\n11	9	25	1	2\n11	9	26	14	23	26\n11	9	26	1	1	1\n11	9	27	13	15	18	19	21	22	24	27	28\n11	9	27	3	6	1	1	3	1	3	8	2\n11	9	28	17	23	24	26	27	28\n11	9	28	1	1	1	1	3	6\n11	9	29	26	29\n11	9	29	1	1\n11	9	30	26	28	30	32\n11	9	30	1	2	8	1\n11	9	31	21\n11	9	31	1\n11	9	32	30	32\n11	9	32	1	5\n11	9	33	33\n11	9	33	1\n11	9	35	33	35\n11	9	35	1	3\n11	9	36	24\n11	9	36	1\n11	9	37	16	17	20	37\n11	9	37	34	2	6	47\n11	9	38	37\n11	9	38	1\n11	9	40	40\n11	9	40	2\n11	10	0	0\n11	10	0	60\n11	10	6	6	9	11	12	15\n11	10	6	18597	8	1	1	2\n11	10	7	7	10\n11	10	7	22727	11\n11	10	8	7	8	10	12	13\n11	10	8	530	21351	2	2	21\n11	10	9	6	7	8	9	10	11	12	13\n11	10	9	801	909	328	26037	49	3	7	32\n11	10	10	6	7	8	9	10	11	12	13\n11	10	10	1	87	111	443	13049	13	5	15\n11	10	11	6	7	8	9	10	11	12	13	14	15	16\n11	10	11	4	1	483	436	277	280811	1988	194	1	62	20\n11	10	12	6	7	8	9	10	11	12	13	14	15	16	23\n11	10	12	1	15	336	330	452	7693	203488	218	4	116	43	1\n11	10	13	6	8	9	10	11	12	13	14	15	16	17	24\n11	10	13	8	94	169	125	1207	2440	168064	369	1085	98	1	1\n11	10	14	6	9	10	11	12	13	14	15	16	17	18	24\n11	10	14	1	63	203	552	1213	2496	63719	10	496	1	1	1\n11	10	15	9	10	11	12	13	14	15	16	17\n11	10	15	40	34	271	447	5292	764	94594	280	2\n11	10	16	10	11	12	13	14	15	16	17	20\n11	10	16	2	33	93	111	675	752	50624	2	1\n11	10	17	10	12	13	14	15	16	17	24\n11	10	17	4	6	3	11	2	8	282	1\n11	10	18	11	12	13	14	15	16	17	18	21	22\n11	10	18	6	4	2	41	47	3	4	25	1	1\n11	10	19	11	14	15	16	18	19\n11	10	19	4	1	4	3	2	8\n11	10	20	11	13	14	15	16	17	20	21	37\n11	10	20	1	4	20	53	3597	14	3384	1	1\n11	10	21	12	13	14	15	16	17	18	20	21\n11	10	21	352	291	1	23	1	4	7	2	631\n11	10	22	14	15	16	18	19	22	24\n11	10	22	1	6	3	1	1	7	1\n11	10	23	15	17	18	19	20	21	23	24\n11	10	23	2	1	1	3	3	3	9	1\n11	10	24	20	22	23	24\n11	10	24	2	5	1	16\n11	10	25	24	25\n11	10	25	1	2\n11	10	26	17	22	24	25	26	29\n11	10	26	2	1	1	1	1	1\n11	10	27	15	21	23	24	26	27	28\n11	10	27	2	1	1	2	2	4	1\n11	10	28	20	21	23	24	27	28\n11	10	28	2	1	1	1	2	8\n11	10	29	28\n11	10	29	1\n11	10	30	23	28	30	32\n11	10	30	2	2	5	1\n11	10	31	27\n11	10	31	1\n11	10	32	30	32	37\n11	10	32	2	4	1\n11	10	33	32	33\n11	10	33	1	1\n11	10	35	32	33	35\n11	10	35	1	1	1\n11	10	37	16	17	20	34	35	36	37\n11	10	37	11	1	2	1	2	1	33\n11	10	40	39	40\n11	10	40	1	1\n12	1	0	0\n12	1	0	45\n12	1	6	6	9\n12	1	6	9701	802\n12	1	7	7	8	9	10	12\n12	1	7	10501	257	218	64	13\n12	1	8	7	8	9	10	11	12	13\n12	1	8	19	14068	69	75	164	405	25\n12	1	9	6	7	8	9	10	11	12	13	14	15	16	28\n12	1	9	2	26	74	17008	139	276	196	95	21	9	1	1\n12	1	10	8	9	10	11	12	13	14	15\n12	1	10	8	111	7416	102	365	28	102	15\n12	1	11	8	9	10	11	12	13	14	15	16\n12	1	11	3	21	100	186159	1474	273	144	54	11\n12	1	12	8	9	10	11	12	13	14	15	16	17	19	20	21\n12	1	12	1	7	16	3861	154309	471	379	101	29	3	5	2	304\n12	1	13	8	9	10	11	12	13	14	15	16	17	18	21\n12	1	13	22	20	10	350	1013	115372	793	979	31	8	5	262\n12	1	14	11	12	13	14	15	16	17	18	19	20	21\n12	1	14	18	160	810	47562	231	157	11	17	7	13	1\n12	1	15	11	12	13	14	15	16	17	18	19	20	21	22	23\n12	1	15	110	282	2035	229	79180	217	17	57	10	19	42	1	16\n12	1	16	11	12	13	14	15	16	17	18	19	20	21	23	25	37\n12	1	16	11	48	111	697	430	32734	49	11	1	4137	47	3	1	13\n12	1	17	13	14	15	16	17	18	19	20	21	22	23	25	37\n12	1	17	37	10	47	18	926	76	2	26	67	1	63	1	4\n12	1	18	13	14	15	16	17	18	19	20	21	22	23\n12	1	18	8	4	4	7	9	471	3	4	50	1	57\n12	1	19	14	15	16	17	18	19	20	21	22	23	25	27\n12	1	19	1	15	1	13	17	291	4	11	1	14	6	2\n12	1	20	14	15	16	17	18	19	20	21	22	23	24	25	27	37\n12	1	20	3	3	8	4	9	16	4068	7	3	1	1	11	1	1\n12	1	21	14	15	17	18	19	20	21	22	23	24	25	27	28	29	32\n12	1	21	1	1	6	6	1	7	925	5	59	3	10	1	1	1	1\n12	1	22	16	18	20	21	22	23	24	25	28\n12	1	22	1	1	7	7	80	2	2	27	1\n12	1	23	13	19	21	22	23	25	26	28	30\n12	1	23	1	1	5	2	260	2	2	2	1\n12	1	24	21	22	24	26	29	30\n12	1	24	1	4	29	1	1	1\n12	1	25	22	23	25	27	28	29	30\n12	1	25	1	8	81	1	1	1	3\n12	1	26	23	26	27	28\n12	1	26	2	16	1	4\n12	1	27	20	21	23	26	27	30\n12	1	27	1	1	1	2	32	1\n12	1	28	24	26	28	32\n12	1	28	1	1	11	2\n12	1	29	25	29	32\n12	1	29	1	7	4\n12	1	30	26	27	28	30	31	32\n12	1	30	1	1	1	15	1	2\n12	1	31	27	28	31	33	35	38\n12	1	31	1	1	7	2	1	3\n12	1	32	15	29	30	32	35\n12	1	32	1	2	2	9	1\n12	1	33	33	37\n12	1	33	2	1\n12	1	35	38\n12	1	35	2\n12	1	37	37\n12	1	37	13\n12	1	38	38\n12	1	38	3\n12	1	40	40\n12	1	40	1\n12	2	0	0\n12	2	0	45\n12	2	6	6	9\n12	2	6	9397	306\n12	2	7	7	8	9	10	11	12\n12	2	7	10116	217	108	41	1	63\n12	2	8	7	8	9	10	11	12	13	15\n12	2	8	20	13525	49	39	225	557	17	1\n12	2	9	6	7	8	9	10	11	12	13	14	15\n12	2	9	8	22	77	17614	74	136	182	50	48	45\n12	2	10	7	8	9	10	11	12	13	14	15	17	32\n12	2	10	6	20	102	7283	70	166	36	108	27	1	1\n12	2	11	8	9	10	11	12	13	14	15	16	20\n12	2	11	1	27	92	187485	2465	458	395	115	6	7\n12	2	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n12	2	12	3	3	11	3376	152745	558	636	229	22	7	6	9	28	632\n12	2	13	8	9	10	11	12	13	14	15	16	17	18	20	21	28\n12	2	13	11	7	7	185	927	114196	1609	1829	12	7	9	25	441	1\n12	2	14	10	11	12	13	14	15	16	17	18	19	20	21\n12	2	14	1	12	165	568	48487	363	201	17	17	34	64	17\n12	2	15	8	11	12	13	14	15	16	17	18	19	20	21	23\n12	2	15	1	66	218	1858	258	78192	160	24	58	18	92	94	31\n12	2	16	11	12	13	14	15	16	17	18	19	20	21	23	27	37\n12	2	16	4	29	62	629	492	21213	39	10	2	10634	83	6	1	11\n12	2	17	13	14	15	16	17	18	19	20	21	22	23	26	37\n12	2	17	38	6	44	26	699	36	7	37	71	1	75	1	5\n12	2	18	12	13	14	15	16	17	18	19	20	21	23	24	26\n12	2	18	1	8	4	4	5	23	430	5	7	64	116	2	1\n12	2	19	14	15	16	17	18	19	20	21	22	23	25	27\n12	2	19	1	10	1	3	13	270	8	8	1	13	8	1\n12	2	20	14	15	18	19	20	21	22	23	25	27	29	37\n12	2	20	2	2	4	5	8248	4	3	1	16	1	1	1\n12	2	21	13	14	15	17	18	19	20	21	22	23	24	25	26	27	29\n12	2	21	2	2	3	7	3	5	9	1560	9	107	3	10	2	5	3\n12	2	22	18	19	20	21	22	24	25	27\n12	2	22	2	2	4	9	65	2	14	1\n12	2	23	15	18	20	21	22	23	24	25	27	30\n12	2	23	1	7	1	24	2	447	1	1	1	1\n12	2	24	20	24\n12	2	24	1	35\n12	2	25	21	23	25	27	28	29	31\n12	2	25	1	9	124	2	2	1	1\n12	2	26	21	23	24	26	31	32\n12	2	26	2	1	3	15	1	1\n12	2	27	20	22	23	26	27	30	32\n12	2	27	1	1	1	1	34	1	1\n12	2	28	22	23	26	27	28	29\n12	2	28	1	2	2	4	13	1\n12	2	29	16	26	27	29\n12	2	29	1	1	1	9\n12	2	30	27	28	30	31	32\n12	2	30	3	4	13	1	2\n12	2	31	31\n12	2	31	8\n12	2	32	30	32	33\n12	2	32	4	12	2\n12	2	33	30	33\n12	2	33	1	3\n12	2	35	35\n12	2	35	2\n12	2	37	37\n12	2	37	32\n12	2	38	32	38	40\n12	2	38	1	6	1\n12	2	40	40\n12	2	40	1\n12	3	0	0\n12	3	0	45\n12	3	6	6\n12	3	6	9405\n12	3	7	7	9	21\n12	3	7	10162	1	1\n12	3	8	7	8	12	13\n12	3	8	31	13822	1	1\n12	3	9	6	7	8	9	10	11	12\n12	3	9	8	25	83	18072	18	4	6\n12	3	10	7	8	9	10	11	12	13	16\n12	3	10	2	13	116	7404	5	3	4	1\n12	3	11	8	9	10	11	12	13	15	19\n12	3	11	3	28	77	190852	551	41	7	1\n12	3	12	8	9	10	11	12	13	14	15	16	19	21\n12	3	12	2	5	12	2728	154598	119	24	25	3	1	1\n12	3	13	8	9	10	11	12	13	14	15	16	17	18	21\n12	3	13	1	5	2	180	960	116282	121	284	8	5	2	1\n12	3	14	10	11	12	13	14	15	16	17\n12	3	14	1	18	156	480	51371	37	120	2\n12	3	15	11	12	13	14	15	16	17	18	19	20\n12	3	15	21	137	1531	254	79213	194	3	1	2	1\n12	3	16	11	12	13	14	15	16	17\n12	3	16	3	8	35	477	536	20586	2\n12	3	17	11	13	14	15	16	17	18	21\n12	3	17	1	39	9	41	26	709	1	1\n12	3	18	12	13	14	15	16	17	18	19	20	21\n12	3	18	1	5	5	4	6	15	554	2	2	1\n12	3	19	14	15	16	17	18	19	21	22\n12	3	19	2	13	3	8	10	319	1	1\n12	3	20	14	15	16	17	18	19	20	27	37\n12	3	20	1	4	2	7	3	12	19135	1	1\n12	3	21	13	14	15	16	17	18	19	20	21	22	23\n12	3	21	2	1	2	3	12	2	6	21	2954	3	4\n12	3	22	18	20	21	22	24	26\n12	3	22	1	11	8	61	1	1\n12	3	23	13	14	15	18	20	21	23	25	27\n12	3	23	2	1	3	4	3	43	744	7	2\n12	3	24	21	22	23	24\n12	3	24	2	5	2	37\n12	3	25	20	21	22	23	24	25	32\n12	3	25	1	2	1	12	2	154	1\n12	3	26	21	22	23	24	25	26\n12	3	26	3	2	1	1	2	14\n12	3	27	14	16	21	22	23	24	26	27	32\n12	3	27	1	1	3	1	5	1	2	38	2\n12	3	28	16	20	22	23	26	27	28	29	30\n12	3	28	1	1	2	1	1	2	10	1	1\n12	3	29	25	26	27	28	29\n12	3	29	1	2	1	1	10\n12	3	30	28	30\n12	3	30	2	18\n12	3	31	17	23	25	27	31\n12	3	31	1	1	1	1	7\n12	3	32	29	32\n12	3	32	1	17\n12	3	33	33	34	35	37\n12	3	33	2	1	1	1\n12	3	35	33	35\n12	3	35	1	1\n12	3	37	20	23	37\n12	3	37	1	1	47\n12	3	38	38\n12	3	38	6\n12	3	40	40\n12	3	40	2\n12	4	0	0\n12	4	0	45\n12	4	6	6\n12	4	6	9413\n12	4	7	7	9	10\n12	4	7	10218	1	1\n12	4	8	7	8	9	12	13\n12	4	8	19	13899	2	2	2\n12	4	9	6	7	8	9	10	11	12	14	18\n12	4	9	17	45	85	18054	16	2	3	4	1\n12	4	10	7	8	9	10	12	13	14\n12	4	10	3	15	108	7384	1	2	1\n12	4	11	8	9	10	11	12	13	14	15	16	17	18\n12	4	11	3	50	93	192982	605	65	4	5	2	1	2\n12	4	12	8	9	10	11	12	13	14	15	16\n12	4	12	11	9	18	2767	153411	132	30	39	4\n12	4	13	8	9	10	11	12	13	14	15	16	17	18\n12	4	13	1	62	9	146	923	116877	175	315	15	9	9\n12	4	14	9	10	11	12	13	14	15	16	17	18	20\n12	4	14	4	3	15	197	481	51395	43	122	4	2	1\n12	4	15	9	11	12	13	14	15	16	17	18	19	20\n12	4	15	4	21	166	1390	287	78084	207	5	1	3	1\n12	4	16	9	10	11	12	13	14	15	16	17	18	20	21	22\n12	4	16	3	3	2	8	29	469	657	19771	5	2	2	2	1\n12	4	17	8	9	11	12	13	14	15	16	17	18	19	21	22\n12	4	17	1	5	2	8	35	15	46	22	624	2	2	1	1\n12	4	18	9	10	12	13	14	15	16	17	18	19	22	23\n12	4	18	3	4	16	8	58	62	5	14	404	1	2	1\n12	4	19	9	12	13	14	15	17	18	19	20	22	25	27\n12	4	19	5	3	1	4	25	11	8	281	2	1	1	1\n12	4	20	9	12	13	14	15	16	18	19	20	21	25	37\n12	4	20	9	10	2	5	1	7	7	13	19118	2	1	1\n12	4	21	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	28\n12	4	21	8	2	6	3	14	98	6	21	21	12	15	2808	2	3	1	1\n12	4	22	9	10	14	15	16	17	18	19	20	21	22	23	24\n12	4	22	1	5	1	1	1	11	5	1	6	10	32	1	1\n12	4	23	9	10	12	14	15	17	18	19	20	21	22	23\n12	4	23	2	2	1	1	9	2	16	31	1	58	4	644\n12	4	24	9	12	14	18	20	21	22	23	24	26\n12	4	24	1	1	1	1	1	9	7	1	19	1\n12	4	25	10	17	18	19	20	21	22	23	25\n12	4	25	1	1	1	42	31	20	20	2	47\n12	4	26	10	14	20	21	22	26\n12	4	26	5	1	1	1	1	11\n12	4	27	10	14	16	17	18	19	20	21	22	23	24	25	27	28\n12	4	27	5	1	1	3	2	2	1	3	1	1	1	3	20	1\n12	4	28	14	18	19	25	27	28	32\n12	4	28	1	2	1	1	1	5	2\n12	4	29	10	22	27	28	29\n12	4	29	1	1	1	1	8\n12	4	30	10	16	18	22	25	30	32\n12	4	30	2	1	4	3	4	4	1\n12	4	31	10	28	31\n12	4	31	1	1	5\n12	4	32	20	24	27	29	32	33\n12	4	32	1	1	1	2	14	1\n12	4	33	31	33\n12	4	33	2	1\n12	4	34	30\n12	4	34	1\n12	4	35	35	37\n12	4	35	1	1\n12	4	37	20	28	29	37\n12	4	37	9	1	1	38\n12	4	38	31	32	38\n12	4	38	3	2	1\n12	4	40	32	35\n12	4	40	1	1\n12	5	0	0\n12	5	0	45\n12	5	6	6	7	8	9	13\n12	5	6	9422	2	4	1	1\n12	5	7	7	8\n12	5	7	10282	3\n12	5	8	7	8	9	13\n12	5	8	27	13983	2	3\n12	5	9	6	7	8	9	10	11	12	13\n12	5	9	16	36	67	18161	42	4	4	1\n12	5	10	7	8	9	10	11	12	13	16\n12	5	10	3	18	106	7421	3	2	1	1\n12	5	11	8	9	10	11	12	13	14	15	16\n12	5	11	8	40	80	195156	570	70	1	7	5\n12	5	12	8	9	10	11	12	13	14	15	16	17	18	20	21\n12	5	12	19	10	10	2250	152804	180	34	44	4	2	1	1	2\n12	5	13	7	8	9	10	11	12	13	14	15	16	17	21\n12	5	13	2	35	10	4	133	849	117471	134	374	10	4	1\n12	5	14	8	10	11	12	13	14	15	16	17\n12	5	14	6	3	18	238	399	51629	39	133	2\n12	5	15	7	8	9	11	12	13	14	15	16	17	19	20\n12	5	15	1	1	1	14	153	1101	330	77549	225	4	3	3\n12	5	16	7	8	9	11	12	13	14	15	16	17	20\n12	5	16	1	10	2	3	13	19	352	600	19153	9	2\n12	5	17	8	9	11	12	13	14	15	16	17	18	19\n12	5	17	2	3	1	47	41	43	52	65	455	1	1\n12	5	18	8	12	13	14	15	16	17	18	19\n12	5	18	2	4	45	2	139	10	46	240	2\n12	5	19	8	9	11	12	14	15	16	17	18	19	21\n12	5	19	3	2	3	15	9	33	1	4	14	304	1\n12	5	20	8	9	11	12	13	14	15	16	17	18	19	20	21	24	37\n12	5	20	5	1	1	60	1	27	4	30	11	5	21	19019	2	1	2\n12	5	21	8	11	12	13	14	15	16	17	18	20	21	22\n12	5	21	2	1	10	28	58	178	148	76	23	1	2388	1\n12	5	22	8	13	14	18	19	20	21	22	24	26\n12	5	22	2	2	1	3	2	5	5	54	1	1\n12	5	23	8	9	11	13	15	16	17	18	21	23\n12	5	23	7	2	1	1	115	37	154	183	77	76\n12	5	24	15	18	21	22	24\n12	5	24	1	2	3	2	15\n12	5	25	13	19	20	21	23	25\n12	5	25	1	1	1	1	2	51\n12	5	26	15	17	18	21	22	26	31\n12	5	26	1	1	1	4	1	3	1\n12	5	27	16	18	20	21	27	28	32\n12	5	27	2	3	6	5	6	1	1\n12	5	28	17	22	25	28	29	30\n12	5	28	1	1	1	4	1	2\n12	5	29	15	21	25	28	29\n12	5	29	1	2	3	1	4\n12	5	30	27	28	30\n12	5	30	2	1	2\n12	5	31	13	17	31	32\n12	5	31	1	1	7	1\n12	5	32	24	26	28	29	32	34\n12	5	32	1	1	2	1	14	1\n12	5	33	33\n12	5	33	2\n12	5	35	35\n12	5	35	2\n12	5	37	20	37\n12	5	37	2	38\n12	5	38	38\n12	5	38	1\n12	6	0	0\n12	6	0	45\n12	6	6	6	7	9\n12	6	6	9259	165	14\n12	6	7	6	7	8	9	11\n12	6	7	6	10314	6	24	4\n12	6	8	6	7	8	9	10	12	13\n12	6	8	3	191	13947	30	1	3	2\n12	6	9	6	7	8	9	10	11	12	13\n12	6	9	12	273	84	17915	48	5	3	1\n12	6	10	7	8	9	10	11	12	13	14	16	18\n12	6	10	45	13	119	7341	16	18	3	3	1	1\n12	6	11	6	7	8	9	10	11	12	13	14	15	16	18	24	27\n12	6	11	3	218	5	67	131	196281	764	103	5	6	2	1	1	1\n12	6	12	6	7	8	9	10	11	12	13	14	15	16	18	20\n12	6	12	1	56	4	20	29	1813	152558	159	59	63	3	3	1\n12	6	13	6	7	8	9	10	11	12	13	14	15	16	17	21\n12	6	13	12	970	3	103	5	106	771	116840	166	377	9	2	2\n12	6	14	7	9	10	11	12	13	14	15	16	17	18	19	20	21	26\n12	6	14	74	61	24	33	239	384	51549	50	183	3	15	1	2	1	1\n12	6	15	7	9	10	11	12	13	14	15	16	17	20	21\n12	6	15	367	23	1	30	84	795	371	77198	258	8	1	1\n12	6	16	7	9	10	11	12	13	14	15	16	17	18	26\n12	6	16	9	26	3	1	15	22	305	564	18872	3	3	1\n12	6	17	7	9	10	12	13	14	15	16	17	18	21	24\n12	6	17	26	42	9	1	39	3	74	16	543	12	3	2\n12	6	18	7	9	10	12	13	14	15	16	17	18	19	27\n12	6	18	34	27	7	3	10	15	8	4	10	355	2	1\n12	6	19	7	9	10	12	14	15	16	18	19	20\n12	6	19	131	83	22	23	52	7	1	2	12	1\n12	6	20	7	9	10	12	13	14	15	16	17	18	19	20	21	30	37\n12	6	20	13	26	32	1	2	4	6	5	3	8	1	18936	1	1	1\n12	6	21	7	9	10	12	13	14	15	16	17	18	19	20	21	22	24\n12	6	21	9	19	11	2	20	3	75	15	3	9	2	1	2319	2	1\n12	6	22	9	10	12	13	14	15	17	18	20	21	22	28\n12	6	22	2	28	2	3	1	3	5	3	1	3	7	1\n12	6	23	7	12	13	17	18	20	21	23\n12	6	23	1	3	2	2	2	1	1	66\n12	6	24	12	13	17	18	21	22	24\n12	6	24	1	2	1	3	2	1	8\n12	6	25	7	9	10	16	17	18	20	21	22	23	25	32\n12	6	25	1	16	21	1	4	1	1	1	1	1	6	1\n12	6	26	17	21	22	26\n12	6	26	1	1	1	2\n12	6	27	13	18	19	21	24	27\n12	6	27	1	1	1	2	2	1\n12	6	28	12	14	18	20	23	28\n12	6	28	1	1	1	1	1	4\n12	6	29	13	14	17	21	30\n12	6	29	1	2	1	1	1\n12	6	30	30\n12	6	30	4\n12	6	31	21	26	27	29	30	33\n12	6	31	1	2	1	2	1	1\n12	6	32	17	25	28	30	32	33\n12	6	32	1	1	1	1	10	2\n12	6	33	29	33\n12	6	33	1	1\n12	6	34	30\n12	6	34	1\n12	6	35	30	35\n12	6	35	1	1\n12	6	37	20	37\n12	6	37	2	38\n12	6	38	30\n12	6	38	1\n12	7	0	0\n12	7	0	45\n12	7	6	6	9\n12	7	6	9290	6\n12	7	7	6	7	8	9	10\n12	7	7	142	12750	2	2	1\n12	7	8	6	7	8	9	13\n12	7	8	225	38	13786	12	1\n12	7	9	6	7	8	9	10	11	12	13	15	29\n12	7	9	278	48	116	18095	57	16	2	3	1	1\n12	7	10	6	7	8	9	10	11	12	13	14	15\n12	7	10	51	13	28	122	7472	15	6	3	2	1\n12	7	11	6	7	8	9	10	11	12	13	14	15	16	17\n12	7	11	613	37	74	50	834	195646	711	95	215	11	1	2\n12	7	12	6	7	8	9	10	11	12	13	14	15	16	18	19	21\n12	7	12	334	31	69	25	398	1567	151654	177	152	73	8	2	1	1\n12	7	13	6	7	8	9	10	11	12	13	14	15	16\n12	7	13	2035	3	6	202	23	87	738	114690	175	425	5\n12	7	14	6	7	8	9	10	11	12	13	14	15	16	17	19	24	28\n12	7	14	61	3	87	16	140	26	150	294	51539	77	142	1	1	1	1\n12	7	15	6	8	9	10	11	12	13	14	15	16	17	18	21\n12	7	15	931	3	135	18	8	66	654	359	75989	264	1	1	2\n12	7	16	6	8	9	10	11	12	13	14	15	16	17	18	21	22	25	27\n12	7	16	63	20	36	21	1	48	78	281	586	18206	2	18	3	1	5	1\n12	7	17	6	8	9	10	11	12	13	14	15	16	17	18	20	21	25	27\n12	7	17	222	3	181	2	1	7	3	9	12	2	115	18	1	3	10	1\n12	7	18	6	8	9	10	13	15	16	17	18	19\n12	7	18	135	22	161	4	7	3	3	2	81	2\n12	7	19	8	9	10	13	15	19	20\n12	7	19	1	1	1	3	1	11	1\n12	7	20	8	10	12	13	15	16	18	19	20\n12	7	20	2	3	1	4	1	5	1	1	18930\n12	7	21	6	8	9	10	13	14	15	16	18	21	24	27	33	40\n12	7	21	21	3	69	14	3	2	13	4	1	2199	1	7	1	1\n12	7	22	17	18	22	23	35\n12	7	22	1	2	7	1	1\n12	7	23	6	9	21	23	27	40\n12	7	23	7	57	1	1	1	1\n12	7	24	10	21	23	24\n12	7	24	1	3	1	9\n12	7	25	13	16	22	24	25\n12	7	25	1	3	1	1	1\n12	7	26	21	26	37\n12	7	26	1	4	1\n12	7	27	24	27\n12	7	27	1	3\n12	7	28	22	25	27	28	37\n12	7	28	1	1	1	1	2\n12	7	29	29\n12	7	29	3\n12	7	30	30	32\n12	7	30	10	1\n12	7	32	25	26	30	32\n12	7	32	2	2	1	6\n12	7	33	33\n12	7	33	4\n12	7	35	35\n12	7	35	1\n12	7	37	20	37\n12	7	37	3	36\n12	8	0	0\n12	8	0	45\n12	8	6	6	9	15	22	24	28\n12	8	6	14398	5	1	2	1	1\n12	8	7	6	7	8	9	11	13	23\n12	8	7	39	12561	2	318	1	1	1\n12	8	8	6	7	8	9	10	11	12	13	15	16	17	21	23	26\n12	8	8	45	25	14113	14	6	9	1	2	1	1	2	1	1	1\n12	8	9	6	7	8	9	10	11	12	13	14	17	18	24	25	28	30\n12	8	9	47	44	80	18821	92	12	26	6	30	3	4	1	1	1	2\n12	8	10	6	7	8	9	10	11	12	13	14	15	16	17	18	22\n12	8	10	6	9	17	94	8803	15	11	9	5	4	1	8	6	1\n12	8	11	6	7	8	9	10	11	12	13	14	15	16	17	18\n12	8	11	198	46	46	31	195	195924	744	122	32	9	18	1	1\n12	8	12	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21	23	24	28	30	33\n12	8	12	92	26	28	20	88	1369	151285	224	57	72	22	24	62	1	5	3	1	2	1	1\n12	8	13	6	7	8	9	10	11	12	13	14	15	16	17	18	21\n12	8	13	374	1	4	24	31	84	722	114024	202	507	8	6	17	12\n12	8	14	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	25\n12	8	14	17	4	18	35	33	21	115	269	51946	30	181	32	16	2	3	9	1	2\n12	8	15	6	8	9	10	11	12	13	14	15	16	17	18	20	21	24\n12	8	15	198	7	65	10	5	50	530	312	75631	318	6	20	1	39	1\n12	8	16	6	8	9	10	11	12	13	14	15	16	17	18	20	21\n12	8	16	8	5	6	1	6	4	10	185	458	17947	2	3	5	3\n12	8	17	8	9	10	13	14	15	16	17	18	19	20	21	23\n12	8	17	1	1	4	1	1	1	2	104	1	1	1	4	2\n12	8	18	6	8	9	10	12	14	17	18	20	21	24\n12	8	18	1	3	8	3	8	7	1	76	2	11	4\n12	8	19	10	11	13	14	15	16	18	19	21	24\n12	8	19	1	1	1	1	1	1	1	7	1	1\n12	8	20	10	14	15	16	18	20	21	23	37\n12	8	20	2	1	1	1	2	18924	2	1	1\n12	8	21	9	12	13	20	21	22	24	27\n12	8	21	9	6	4	1	2189	1	1	2\n12	8	22	10	18	20	21	22	23\n12	8	22	1	1	1	1	5	1\n12	8	23	21	23\n12	8	23	1	2\n12	8	24	22	24	25	28\n12	8	24	1	10	1	1\n12	8	25	15	22	25\n12	8	25	2	2	15\n12	8	26	26	29	33\n12	8	26	4	1	1\n12	8	27	21	23	27	32	37\n12	8	27	1	1	10	1	1\n12	8	28	28\n12	8	28	2\n12	8	29	29\n12	8	29	4\n12	8	30	30	32\n12	8	30	10	1\n12	8	32	32\n12	8	32	7\n12	8	33	32	33	37\n12	8	33	1	3	1\n12	8	35	35	37\n12	8	35	1	1\n12	8	37	20	37\n12	8	37	4	35\n12	8	40	9\n12	8	40	2\n12	9	0	0\n12	9	0	45\n12	9	6	6	9	11	13	14	15	17	18	20	21	22	24	25\n12	9	6	14911	499	1	1	1	2	1	1	1	2	1	1	1\n12	9	7	6	7	8	9	10	11	12	15	22\n12	9	7	7	12688	4	4	6	3	1	2	1\n12	9	8	6	7	8	9	10	12	13	14	17\n12	9	8	4	20	14215	34	11	17	15	7	1\n12	9	9	6	7	8	9	10	11	12	13	14	19	28\n12	9	9	15	28	88	19267	29	9	3	11	1	1	1\n12	9	10	6	7	8	9	10	11	12	13	14	16	18	23\n12	9	10	1	2	11	93	9086	14	18	23	18	1	2	1\n12	9	11	6	7	8	9	10	11	12	13	14	15	16	18	19	23\n12	9	11	31	14	5	34	84	196418	749	75	17	9	7	1	1	2\n12	9	12	6	7	8	9	10	11	12	13	14	15	16	17	18	21\n12	9	12	12	8	5	4	34	1239	151443	140	14	59	8	4	1	1\n12	9	13	6	9	10	11	12	13	14	15	16	17	18	19	22\n12	9	13	51	12	25	88	765	113589	136	522	9	2	2	1	1\n12	9	14	6	8	11	12	13	14	15	16	17	18	19	20	21	23	24	26\n12	9	14	6	1	19	85	277	51991	60	204	1	115	2	1	14	1	1	1\n12	9	15	6	8	9	10	11	12	13	14	15	16	17	18	19	21	27\n12	9	15	22	1	4	2	10	53	467	334	75414	306	1	36	1	65	2\n12	9	16	6	8	11	12	13	14	15	16	17	18	19	23\n12	9	16	2	2	4	3	1	176	394	17910	1	1	1	5\n12	9	17	12	13	14	15	16	17	18	20	22\n12	9	17	1	1	5	2	4	173	1	1	1\n12	9	18	15	16	18	21	22	27\n12	9	18	1	3	175	26	1	4\n12	9	19	18	19	22	23\n12	9	19	1	5	3	1\n12	9	20	11	15	16	17	18	20	37\n12	9	20	1	1	2	2	1	18935	1\n12	9	21	6	9	12	13	15	18	19	21	23	24\n12	9	21	1	2	6	4	1	7	1	2252	3	2\n12	9	22	18	22	23\n12	9	22	1	10	1\n12	9	23	23	25	27\n12	9	23	11	1	1\n12	9	24	20	21	22	23	24	28\n12	9	24	1	1	2	1	13	2\n12	9	25	21	25	27\n12	9	25	1	6	12\n12	9	26	13	14	19	21\n12	9	26	1	1	1	2\n12	9	27	21	23	27\n12	9	27	1	1	10\n12	9	28	23	24	28	29\n12	9	28	1	1	4	1\n12	9	29	29\n12	9	29	5\n12	9	30	30\n12	9	30	13\n12	9	32	30	32\n12	9	32	1	9\n12	9	33	31	33	35\n12	9	33	1	2	2\n12	9	35	33\n12	9	35	1\n12	9	37	20	35	37\n12	9	37	5	1	33\n12	10	0	0\n12	10	0	45\n12	10	6	6	9	11	12	13	15	18	21	22\n12	10	6	14998	53	2	1	1	3	2	1	2\n12	10	7	6	7	9	10	13\n12	10	7	3	12751	1	4	1\n12	10	8	6	7	8	10	13	20\n12	10	8	1	806	13520	2	2	1\n12	10	9	6	7	8	9	10	11	12	13	16	18	25\n12	10	9	1522	587	244	17561	19	2	7	8	1	1	1\n12	10	10	7	8	9	10	11	12	13	14	16	19	22	25\n12	10	10	107	133	284	8717	7	12	8	3	3	1	1	1\n12	10	11	6	7	8	9	10	11	12	13	14	15	16\n12	10	11	5	4	742	387	232	195321	1017	69	3	20	6\n12	10	12	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21\n12	10	12	3	332	1054	607	546	9721	140697	105	13	50	8	4	2	1	1\n12	10	13	6	8	9	10	11	12	13	14	15	16\n12	10	13	10	100	191	128	1775	1958	109792	106	525	20\n12	10	14	6	9	10	11	12	13	14	15	16	17	18\n12	10	14	3	140	457	1915	2118	4091	43717	16	229	2	13\n12	10	15	6	9	10	11	12	13	14	15	16	19\n12	10	15	7	124	95	373	876	6632	1053	67083	223	1\n12	10	16	8	9	10	11	12	13	14	15	16	17	18	19	20\n12	10	16	3	1	8	19	51	57	466	414	17429	1	2	1	2\n12	10	17	9	10	12	13	14	15	16	17	18	19	21\n12	10	17	3	10	6	4	14	2	1	136	8	1	1\n12	10	18	9	10	11	12	13	14	15	16	17	18	19\n12	10	18	1	27	12	48	10	93	38	2	3	109	2\n12	10	19	11	13	15	17	18	19	20\n12	10	19	2	1	1	1	1	7	1\n12	10	20	11	12	13	14	15	16	17	18	19	20	21\n12	10	20	54	61	74	136	253	14467	30	1	1	3865	2\n12	10	21	10	11	12	13	14	15	16	17	18	19	20	21	23	25\n12	10	21	3	1	873	626	28	51	1	2	27	2	1	748	1	1\n12	10	22	18	19	21	22	28\n12	10	22	3	2	3	11	1\n12	10	23	11	13	15	16	18	19	21	23	25\n12	10	23	1	1	2	6	2	1	2	12	1\n12	10	24	13	15	17	21	22	23	24	26\n12	10	24	1	3	1	1	1	1	9	1\n12	10	25	15	22	24	25	28\n12	10	25	1	1	1	4	1\n12	10	26	26\n12	10	26	1\n12	10	27	14	15	17	18	21	25	26	27\n12	10	27	6	5	1	2	3	4	1	7\n12	10	28	24	25	28\n12	10	28	2	1	4\n12	10	29	28	29\n12	10	29	1	5\n12	10	30	28	30	32\n12	10	30	1	12	1\n12	10	31	28\n12	10	31	1\n12	10	32	25	30	32\n12	10	32	1	1	7\n12	10	33	30	33\n12	10	33	1	2\n12	10	35	35\n12	10	35	3\n12	10	37	16	17	20	33	35	37\n12	10	37	14	4	1	1	1	13\n12	11	0	0\n12	11	0	45\n12	11	6	6	9	13	16\n12	11	6	16545	5	1	1\n12	11	7	7	10\n12	11	7	14582	5\n12	11	8	7	8	12	13\n12	11	8	491	15297	1	7\n12	11	9	6	7	8	9	10	11	12	13\n12	11	9	826	417	222	17846	22	3	2	15\n12	11	10	7	8	9	10	11	13	15\n12	11	10	64	90	336	9746	6	5	1\n12	11	11	6	8	9	10	11	12	13	14	15	16	28\n12	11	11	3	358	313	203	207012	1190	95	1	22	7	1\n12	11	12	7	8	9	10	11	12	13	14	15	16	21\n12	11	12	21	244	250	340	6231	140444	107	2	60	25	1\n12	11	13	6	8	9	10	11	12	13	14	15	16\n12	11	13	2	84	124	145	1024	1891	117445	162	570	36\n12	11	14	6	9	10	11	12	13	14	15	16	19	20\n12	11	14	1	52	230	328	842	1996	41945	7	234	1	2\n12	11	15	6	9	10	11	12	13	14	15	16	18	27\n12	11	15	1	25	46	177	329	4090	567	63057	171	3	1\n12	11	16	10	11	12	13	14	15	16	17\n12	11	16	3	49	79	112	448	472	31246	1\n12	11	17	9	10	12	13	14	15	17	30\n12	11	17	2	4	4	5	12	2	155	1\n12	11	18	9	10	11	12	13	14	15	16	17	18\n12	11	18	5	5	3	31	5	39	23	7	6	49\n12	11	19	12	14	15	16	17	18	19\n12	11	19	1	4	2	3	2	2	5\n12	11	20	11	12	14	15	16	17	18	20	22\n12	11	20	3	1	10	22	2023	3	1	1808	1\n12	11	21	10	12	13	14	15	16	17	18	19	20	21\n12	11	21	4	219	185	9	20	1	4	10	1	2	307\n12	11	22	10	13	17	18	19	20	21	22\n12	11	22	1	1	1	2	5	2	1	3\n12	11	23	16	17	19	20	21	23\n12	11	23	1	1	2	5	1	4\n12	11	24	13	15	20	21	24\n12	11	24	1	1	1	1	8\n12	11	25	15	17	21	22	23	25	27\n12	11	25	1	1	1	1	1	8	1\n12	11	26	24	26	28\n12	11	26	1	1	1\n12	11	27	18	21	25	27\n12	11	27	1	1	1	4\n12	11	28	18	19	25	27	28\n12	11	28	1	1	1	1	5\n12	11	29	23	29\n12	11	29	1	4\n12	11	30	18	23	27	28	29	30\n12	11	30	1	1	1	1	1	9\n12	11	32	27	30	32\n12	11	32	1	2	5\n12	11	33	29	33\n12	11	33	1	2\n12	11	35	33	35\n12	11	35	1	3\n12	11	37	16	17	21	37\n12	11	37	2	1	1	9\n13	1	0	0\n13	1	0	27\n13	1	6	6	9\n13	1	6	6353	471\n13	1	7	7	8	9	10	12\n13	1	7	7688	203	166	28	16\n13	1	8	7	8	9	10	11	12	13	15\n13	1	8	15	10340	51	43	109	334	19	1\n13	1	9	6	7	8	9	10	11	12	13	14	15	25\n13	1	9	1	27	66	12231	107	173	121	68	14	8	1\n13	1	10	7	8	9	10	11	12	13	14	15\n13	1	10	5	8	72	4725	66	188	31	72	7\n13	1	11	8	9	10	11	12	13	14	15	16	19\n13	1	11	3	10	61	139411	969	253	78	58	8	1\n13	1	12	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n13	1	12	4	8	9	4261	112252	366	318	79	23	1	1	5	2	197\n13	1	13	8	9	10	11	12	13	14	15	16	17	18	20	21\n13	1	13	12	13	5	260	729	85295	757	721	33	13	1	1	132\n13	1	14	11	12	13	14	15	16	17	18	19	20	21\n13	1	14	9	147	332	33391	173	112	9	2	34	3	1\n13	1	15	11	12	13	14	15	16	17	18	19	20	21	23\n13	1	15	68	227	1883	199	59260	160	16	26	14	9	70	19\n13	1	16	10	11	12	13	14	15	16	17	18	19	20	21	23	27	37\n13	1	16	1	13	47	85	590	328	22269	36	15	2	2689	119	4	1	12\n13	1	17	13	14	15	16	17	18	19	20	21	23	37\n13	1	17	40	9	69	20	980	88	2	12	46	59	1\n13	1	18	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27\n13	1	18	16	3	15	15	19	543	1	6	55	2	73	1	1	1	1\n13	1	19	12	14	15	16	17	18	19	20	21	23	25	27\n13	1	19	1	1	5	1	2	7	147	4	8	6	2	1\n13	1	20	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	31	37\n13	1	20	5	2	10	1	5	3	2436	2	2	4	3	2	1	1	1	1	1\n13	1	21	15	16	17	18	19	20	21	22	23	25	26	27\n13	1	21	2	7	2	5	1	12	736	1	61	4	2	7\n13	1	22	11	20	21	22	23	24	25	26	27	28	29\n13	1	22	2	10	3	32	5	1	4	1	4	2	4\n13	1	23	15	19	20	21	22	23	25	27	28\n13	1	23	1	1	2	23	2	334	1	1	2\n13	1	24	21	22	23	24	25	26	27	28	29	30	32\n13	1	24	1	4	2	9	1	1	1	1	3	1	1\n13	1	25	20	21	23	25	26	27	28	29	31\n13	1	25	2	1	7	32	2	2	5	3	2\n13	1	26	22	23	24	25	26	27	30	31	40\n13	1	26	4	1	2	3	20	1	2	3	1\n13	1	27	22	24	26	27	29\n13	1	27	3	1	1	13	1\n13	1	28	23	24	27	28	29	32	37	39\n13	1	28	1	1	3	16	3	2	1	1\n13	1	29	28	29	37\n13	1	29	2	9	1\n13	1	30	27	28	30\n13	1	30	1	2	6\n13	1	31	12	25	27	28	29	31\n13	1	31	1	1	1	2	1	21\n13	1	32	30	32\n13	1	32	2	10\n13	1	35	35\n13	1	35	1\n13	1	37	37\n13	1	37	6\n13	1	40	32	40\n13	1	40	1	3\n13	2	0	0\n13	2	0	27\n13	2	6	6	9\n13	2	6	6123	231\n13	2	7	7	8	9	10	12\n13	2	7	7409	168	90	9	59\n13	2	8	7	8	9	10	11	12	13	15\n13	2	8	17	9894	40	31	181	459	9	5\n13	2	9	6	7	8	9	10	11	12	13	14	15	28\n13	2	9	7	22	40	12543	65	95	143	50	32	24	1\n13	2	10	7	8	9	10	11	12	13	14	15\n13	2	10	3	5	71	4616	44	114	21	88	17\n13	2	11	8	9	10	11	12	13	14	15	16	17	20\n13	2	11	1	13	67	141840	1727	347	280	92	1	2	2\n13	2	12	9	10	11	12	13	14	15	16	17	19	20	21\n13	2	12	5	4	2541	111024	387	459	133	20	3	16	18	422\n13	2	13	8	9	10	11	12	13	14	15	16	17	18	19	20	21\n13	2	13	6	4	13	157	776	84823	1082	1222	9	7	6	3	9	271\n13	2	14	11	12	13	14	15	16	17	18	19	20	21	24\n13	2	14	11	130	474	34315	237	140	12	4	74	34	5	1\n13	2	15	11	12	13	14	15	16	17	18	19	20	21	23\n13	2	15	36	182	1382	174	58530	114	14	34	42	62	134	25\n13	2	16	11	12	13	14	15	16	17	18	19	20	21	23	30	37\n13	2	16	1	9	39	405	390	14161	30	10	1	7497	103	4	1	7\n13	2	17	13	14	15	16	17	18	19	20	21	22	23	27	28\n13	2	17	24	1	20	19	797	47	1	18	68	1	80	2	1\n13	2	18	13	14	15	16	17	18	19	20	21	22	23	25	27\n13	2	18	6	1	5	4	18	444	1	7	56	3	140	1	7\n13	2	19	17	18	19	20	21	23	25\n13	2	19	4	4	189	2	5	5	2\n13	2	20	16	18	19	20	21	23	27\n13	2	20	7	3	1	5166	7	3	1\n13	2	21	15	16	18	19	20	21	22	23	24	25	26	27	28	29\n13	2	21	1	3	2	4	10	1276	3	83	1	2	1	5	1	2\n13	2	22	11	18	20	22	23	25	27	28\n13	2	22	1	1	3	37	2	3	1	2\n13	2	23	18	21	22	23	25	26	28	31\n13	2	23	1	33	1	533	3	1	3	1\n13	2	24	21	22	23	24	27\n13	2	24	2	1	1	13	1\n13	2	25	20	21	23	24	25	27	28	29	30	31\n13	2	25	1	1	3	1	29	3	8	1	1	4\n13	2	26	22	23	25	26	27	28	31\n13	2	26	2	1	4	16	1	1	4\n13	2	27	26	27\n13	2	27	1	37\n13	2	28	25	26	27	28	29	30	31\n13	2	28	1	2	3	24	1	1	1\n13	2	29	28	29\n13	2	29	1	23\n13	2	30	30	32\n13	2	30	9	2\n13	2	31	25	28	30	31\n13	2	31	1	1	1	24\n13	2	32	30	32	35\n13	2	32	1	12	1\n13	2	35	32\n13	2	35	1\n13	2	37	32	37	38\n13	2	37	1	20	1\n13	2	39	37\n13	2	39	1\n13	2	40	40\n13	2	40	4\n13	3	0	0\n13	3	0	27\n13	3	6	6\n13	3	6	6130\n13	3	7	7\n13	3	7	7451\n13	3	8	7	8	15\n13	3	8	16	10097	1\n13	3	9	6	7	8	9	10	11	12\n13	3	9	4	25	61	12895	8	2	2\n13	3	10	7	8	9	10	11	13	25\n13	3	10	1	3	65	4727	4	4	1\n13	3	11	8	9	10	11	12	13	15\n13	3	11	4	19	66	144651	152	14	1\n13	3	12	8	9	10	11	12	13	14	15	21\n13	3	12	1	4	8	2245	112281	58	17	8	1\n13	3	13	8	9	10	11	12	13	14	15	16	17	21\n13	3	13	1	8	5	117	753	86499	72	101	2	3	1\n13	3	14	11	12	13	14	15	16\n13	3	14	17	133	396	36220	33	38\n13	3	15	8	11	12	13	14	15	16	17	19\n13	3	15	2	14	128	1208	176	59041	101	4	2\n13	3	16	11	12	13	14	15	16	17	18	20	40\n13	3	16	2	4	30	382	370	13683	4	1	1	1\n13	3	17	11	13	14	15	16	17	18	21\n13	3	17	1	32	2	51	19	779	2	1\n13	3	18	13	14	15	16	17	18\n13	3	18	6	5	9	11	15	510\n13	3	19	11	12	14	15	16	17	18	19	20\n13	3	19	1	2	3	2	5	3	4	311	1\n13	3	20	13	14	15	16	17	18	19	20	21\n13	3	20	1	1	2	5	2	5	3	12807	3\n13	3	21	13	15	16	17	18	19	20	21	23	27\n13	3	21	2	4	5	2	3	13	16	2334	3	1\n13	3	22	16	17	18	19	20	21	22	25	27\n13	3	22	1	1	2	1	6	1	34	1	1\n13	3	23	15	16	18	19	20	21	22	23	28\n13	3	23	1	4	7	14	8	48	2	795	1\n13	3	24	11	22	23	24	32\n13	3	24	1	1	2	11	1\n13	3	25	19	20	21	22	23	24	25\n13	3	25	1	1	2	3	11	1	27\n13	3	26	20	23	25	26\n13	3	26	1	1	1	18\n13	3	27	20	22	25	26	27\n13	3	27	1	6	1	1	52\n13	3	28	20	21	22	23	25	26	27	28	30\n13	3	28	2	1	6	9	3	1	2	18	1\n13	3	29	26	28	29\n13	3	29	1	1	25\n13	3	30	26	28	30\n13	3	30	2	3	9\n13	3	31	23	25	26	28	31\n13	3	31	2	8	2	2	20\n13	3	32	30	31	32	40\n13	3	32	1	1	13	1\n13	3	35	35\n13	3	35	1\n13	3	37	20	37\n13	3	37	1	27\n13	3	38	38\n13	3	38	1\n13	3	40	40\n13	3	40	4\n13	4	0	0\n13	4	0	27\n13	4	6	6	14\n13	4	6	6133	1\n13	4	7	7\n13	4	7	7493\n13	4	8	7	8	14\n13	4	8	17	10151	1\n13	4	9	6	7	8	9	10	12	13	14	18\n13	4	9	8	25	61	12885	8	1	1	1	1\n13	4	10	7	8	9	10	11\n13	4	10	6	6	69	4731	2\n13	4	11	7	8	9	10	11	12	13	14	15\n13	4	11	1	1	24	49	146624	315	36	1	4\n13	4	12	8	9	10	11	12	13	14	15	16	21\n13	4	12	1	7	16	1930	111364	92	22	21	1	1\n13	4	13	8	9	10	11	12	13	14	15	16	17	18\n13	4	13	2	21	7	93	738	87127	80	176	1	1	4\n13	4	14	11	12	13	14	15	16\n13	4	14	11	137	364	36274	25	67\n13	4	15	8	11	12	13	14	15	16	17	20\n13	4	15	1	7	116	942	224	58172	157	4	1\n13	4	16	9	11	12	13	14	15	16	18	20	21\n13	4	16	1	1	2	21	300	386	13158	2	2	1\n13	4	17	9	10	13	14	15	16	17	18\n13	4	17	2	1	40	1	42	32	693	2\n13	4	18	9	10	12	13	14	15	16	17	18	21	23\n13	4	18	1	1	1	8	4	14	6	19	478	1	1\n13	4	19	9	12	13	14	15	16	17	18	19	22\n13	4	19	6	1	2	1	6	2	3	9	313	2\n13	4	20	9	12	14	16	17	18	19	20	21	22	27	37\n13	4	20	2	2	4	9	1	5	6	12811	2	1	1	1\n13	4	21	9	12	13	14	15	17	18	19	20	21	22	23	24	28\n13	4	21	1	1	5	3	17	1	2	2	13	2338	1	6	1	1\n13	4	22	9	10	16	18	19	20	21	22\n13	4	22	1	3	1	3	1	9	4	30\n13	4	23	13	18	19	20	21	23\n13	4	23	1	7	5	2	33	775\n13	4	24	10	18	21	23	24\n13	4	24	1	1	1	1	8\n13	4	25	18	19	20	22	23	25\n13	4	25	1	3	1	5	2	30\n13	4	26	20	22	23	24	25	26\n13	4	26	1	1	2	1	4	16\n13	4	27	9	10	16	17	27	28	30\n13	4	27	1	2	1	1	49	1	1\n13	4	28	10	11	16	18	28	29	30\n13	4	28	1	1	1	1	19	1	1\n13	4	29	26	28	29\n13	4	29	1	1	23\n13	4	30	10	16	17	20	28	30\n13	4	30	1	3	1	1	1	4\n13	4	31	17	28	31\n13	4	31	1	3	17\n13	4	32	22	25	27	30	32	33	37\n13	4	32	1	2	1	1	6	2	1\n13	4	35	35\n13	4	35	1\n13	4	37	20	37\n13	4	37	2	25\n13	4	38	37\n13	4	38	1\n13	4	40	37	40\n13	4	40	1	5\n13	5	0	0\n13	5	0	27\n13	5	6	6	8\n13	5	6	6140	1\n13	5	7	7	8\n13	5	7	7539	3\n13	5	8	7	8	9	11\n13	5	8	30	10191	1	1\n13	5	9	6	7	8	9	10	11	13\n13	5	9	14	45	74	12851	28	7	2\n13	5	10	7	8	9	10	11	13\n13	5	10	2	10	73	4733	1	2\n13	5	11	7	8	9	10	11	12	13	14	15	16	18\n13	5	11	5	20	41	51	148129	353	50	10	4	5	1\n13	5	12	7	8	9	10	11	12	13	14	15	16	17	18	21\n13	5	12	3	18	15	15	1770	110666	133	27	24	1	2	3	1\n13	5	13	7	8	9	10	11	12	13	14	15	16	17\n13	5	13	2	132	24	2	158	681	87339	92	203	1	5\n13	5	14	8	10	11	12	13	14	15	16	18	19	20\n13	5	14	7	8	15	200	309	36244	30	98	1	2	3\n13	5	15	8	9	10	11	12	13	14	15	16	17	18	19\n13	5	15	6	1	1	22	159	920	195	57379	166	11	1	2\n13	5	16	8	9	11	12	13	14	15	16	17	18	19	20	21\n13	5	16	57	6	13	5	20	304	423	12599	2	3	3	2	2\n13	5	17	8	9	11	12	13	14	15	16	17	19	21	22\n13	5	17	3	4	9	35	53	13	45	63	495	3	1	1\n13	5	18	8	11	12	13	14	15	16	17	18	19	20	21\n13	5	18	5	1	2	37	4	141	26	50	245	1	2	2\n13	5	19	7	8	9	11	12	13	14	15	18	19	20\n13	5	19	1	24	7	9	11	3	2	8	1	263	1\n13	5	20	8	9	11	12	13	14	15	16	17	18	19	20	22	37\n13	5	20	26	4	4	40	11	21	5	14	3	4	9	12695	5	2\n13	5	21	8	9	12	13	14	15	16	17	18	19	20	21	26\n13	5	21	3	5	10	22	48	273	158	74	42	1	2	1742	1\n13	5	22	8	9	10	13	14	16	19	20	21	22	28	30\n13	5	22	5	2	1	6	1	2	3	3	1	15	1	1\n13	5	23	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	26	27\n13	5	23	22	4	1	3	11	1	111	30	153	201	3	2	108	2	131	3	1\n13	5	24	18	20	21	24\n13	5	24	1	1	2	6\n13	5	25	8	9	10	11	13	17	18	20	22	25\n13	5	25	2	3	1	4	8	6	1	1	2	8\n13	5	26	14	17	22	24	26	27\n13	5	26	1	4	1	1	9	1\n13	5	27	16	18	19	20	21	24	25	26	27	30	35\n13	5	27	15	7	2	3	12	1	2	2	5	1	1\n13	5	28	9	11	13	17	21	22	25	28	33\n13	5	28	2	1	11	3	1	1	3	3	1\n13	5	29	16	20	21	22	24	25	26	28	29\n13	5	29	4	1	2	4	2	4	2	1	4\n13	5	30	23	27	28	30	32\n13	5	30	1	1	1	3	1\n13	5	31	8	10	11	13	17	28\n13	5	31	2	2	1	3	8	1\n13	5	32	22	25	26	29	32\n13	5	32	1	1	1	1	2\n13	5	33	33\n13	5	33	2\n13	5	35	35\n13	5	35	1\n13	5	37	20	28	32	37\n13	5	37	2	2	1	24\n13	5	40	11	17	40\n13	5	40	1	1	3\n13	6	0	0\n13	6	0	27\n13	6	6	6	7	9\n13	6	6	6092	56	6\n13	6	7	7	8	9	10\n13	6	7	7618	3	5	1\n13	6	8	6	7	8	9	10	13\n13	6	8	1	38	10563	6	2	1\n13	6	9	6	7	8	9	10	11	12\n13	6	9	6	48	56	12898	32	2	1\n13	6	10	7	8	9	10	11	12\n13	6	10	5	8	78	4740	10	2\n13	6	11	6	7	8	9	10	11	12	13	15	16\n13	6	11	1	45	1	20	73	149532	391	81	3	2\n13	6	12	7	8	9	10	11	12	13	14	15	16	17\n13	6	12	6	9	7	12	1361	110586	110	44	25	1	1\n13	6	13	6	7	8	9	10	11	12	13	14	15	16	17	18\n13	6	13	5	97	1	14	3	106	604	87735	124	240	2	8	1\n13	6	14	7	9	10	11	12	13	14	15	16	17	18	20\n13	6	14	10	11	5	17	220	293	36257	39	105	1	4	1\n13	6	15	7	9	11	12	13	14	15	16	17	18\n13	6	15	39	1	9	74	665	297	57392	153	14	2\n13	6	16	7	9	10	12	13	14	15	16	17	18	21\n13	6	16	1	3	2	5	18	234	366	12546	3	3	1\n13	6	17	7	9	10	12	13	14	15	16	17	18\n13	6	17	3	8	1	2	33	2	70	30	666	2\n13	6	18	7	9	13	14	15	16	17	18	19	20\n13	6	18	4	1	4	5	10	11	9	464	1	2\n13	6	19	7	9	10	12	13	14	15	16	17	18	19	21\n13	6	19	14	4	3	43	1	144	30	1	2	3	46	1\n13	6	20	7	9	10	12	14	15	16	17	18	20\n13	6	20	1	3	4	1	4	2	10	1	7	12685\n13	6	21	9	12	13	14	15	16	18	19	20	21	22	24\n13	6	21	1	1	4	1	191	48	18	2	3	1602	2	1\n13	6	22	10	14	15	16	18	19	21	22\n13	6	22	2	1	1	1	1	1	2	23\n13	6	23	15	21	23\n13	6	23	1	1	130\n13	6	24	21	22	23	24\n13	6	24	1	1	1	7\n13	6	25	10	15	22	24	25	27\n13	6	25	1	1	1	1	13	1\n13	6	26	15	17	18	19	20	21	22	26\n13	6	26	1	1	1	2	1	2	3	7\n13	6	27	18	22	26	27\n13	6	27	3	1	1	3\n13	6	28	24	25	28	30\n13	6	28	1	1	6	1\n13	6	29	29\n13	6	29	5\n13	6	30	30\n13	6	30	5\n13	6	32	24	32\n13	6	32	1	3\n13	6	33	33\n13	6	33	3\n13	6	35	35\n13	6	35	2\n13	6	37	20	26	37\n13	6	37	2	1	23\n13	6	40	17	32	40\n13	6	40	1	1	1\n13	7	0	0\n13	7	0	27\n13	7	6	6	9\n13	7	6	6096	9\n13	7	7	6	7	8	9	10	24\n13	7	7	245	7728	1	9	1	1\n13	7	8	6	7	8	9	12	13\n13	7	8	279	15	10334	11	1	1\n13	7	9	6	7	8	9	10	11	12	13	15	17	18	19\n13	7	9	405	31	73	12491	37	15	4	1	5	1	2	1\n13	7	10	6	7	8	9	10	11	12	13	14	16	17	19	20	21\n13	7	10	88	5	25	90	4643	5	15	3	1	1	1	2	1	1\n13	7	11	6	7	8	9	10	11	12	13	14	15\n13	7	11	522	19	37	79	825	148758	698	92	4	3\n13	7	12	6	7	8	9	10	11	12	13	14	15	16	17	21	23\n13	7	12	167	6	39	17	378	1039	110026	148	41	64	2	1	1	1\n13	7	13	6	7	9	10	11	12	13	14	15	16	27\n13	7	13	2328	1	288	40	82	574	85254	141	233	3	1\n13	7	14	6	8	9	10	11	12	13	14	15	16	17	18	21\n13	7	14	96	125	25	126	30	189	295	36072	53	95	2	4	1\n13	7	15	6	8	9	10	11	12	13	14	15	16	17	20	21\n13	7	15	1084	5	202	21	8	57	504	224	56074	188	3	1	1\n13	7	16	6	8	9	10	11	12	13	14	15	16	17	18	21	24	27	29	32\n13	7	16	67	41	53	34	2	50	168	143	545	11776	3	18	6	1	1	1	1\n13	7	17	6	8	9	10	11	12	13	14	15	16	17	18	19	21	22	32	37\n13	7	17	226	1	334	2	1	6	15	1	22	3	59	32	1	1	1	1	1\n13	7	18	6	8	9	10	12	13	14	15	16	17	18	19	21\n13	7	18	173	19	212	2	4	14	3	10	3	1	66	1	1\n13	7	19	8	9	10	13	15	16	17	18	19	24\n13	7	19	4	2	1	5	3	3	2	6	25	1\n13	7	20	8	10	11	12	13	14	15	16	17	18	19	20	21	22	37\n13	7	20	2	3	2	1	6	1	4	11	1	6	1	12652	1	2	1\n13	7	21	6	8	9	10	12	13	15	16	18	21	24\n13	7	21	28	14	100	8	1	12	42	14	5	1366	20\n13	7	22	8	10	12	13	16	17	18	19	20	21	22	25	26	27	28\n13	7	22	2	1	3	5	3	2	2	1	1	2	5	1	1	1	1\n13	7	23	6	9	18	23	24\n13	7	23	15	112	1	2	1\n13	7	24	10	16	18	21	24\n13	7	24	2	3	1	3	2\n13	7	25	10	13	16	17	18	21	22\n13	7	25	1	5	2	1	2	2	1\n13	7	26	10	17	21	25	26	27\n13	7	26	1	2	1	1	3	1\n13	7	27	13	27	28\n13	7	27	1	2	1\n13	7	28	10	18	20	21	28\n13	7	28	1	1	1	1	2\n13	7	29	13	23	25	28\n13	7	29	1	2	1	1\n13	7	30	30\n13	7	30	6\n13	7	32	30	32\n13	7	32	1	3\n13	7	33	33\n13	7	33	3\n13	7	35	35	38\n13	7	35	1	1\n13	7	37	20	37\n13	7	37	2	21\n13	7	40	40\n13	7	40	1\n13	8	0	0\n13	8	0	27\n13	8	6	6	9	11	18	24\n13	8	6	11809	7	1	1	1\n13	8	7	6	7	9	10	21	26\n13	8	7	83	7679	40	1	1	1\n13	8	8	6	7	8	9	13	27\n13	8	8	126	27	10563	4	1	1\n13	8	9	6	7	8	9	10	11	12	13	14	28	30	32\n13	8	9	113	42	88	13725	43	11	4	1	3	2	1	1\n13	8	10	6	7	8	9	10	11	12	13	14	18	22	30\n13	8	10	24	4	22	76	5965	16	5	9	3	1	1	1\n13	8	11	6	7	8	9	10	11	12	13	14	15\n13	8	11	371	68	60	29	587	148122	487	73	135	10\n13	8	12	6	7	8	9	10	11	12	13	14	15	16	17	18	21\n13	8	12	208	28	50	13	216	898	109915	151	91	49	5	2	1	2\n13	8	13	6	7	8	9	10	11	12	13	14	15	16	17	18\n13	8	13	1003	1	7	79	25	59	554	84323	156	318	3	1	1\n13	8	14	6	7	8	9	10	11	12	13	14	15	16	17	18	25\n13	8	14	42	2	71	9	127	18	108	212	35855	74	104	1	4	4\n13	8	15	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23	25\n13	8	15	579	14	200	11	6	60	344	256	55365	203	3	10	1	2	2	1	1\n13	8	16	6	7	8	9	10	12	13	14	15	16\n13	8	16	12	1	21	39	4	1	2	110	317	11600\n13	8	17	8	10	13	14	15	17	28\n13	8	17	1	1	4	2	2	68	1\n13	8	18	6	8	9	10	11	12	13	14	16	18	20\n13	8	18	19	16	8	3	1	1	1	1	1	94	1\n13	8	19	8	10	12	13	14	15	17	18	19	24\n13	8	19	3	2	1	1	2	4	2	5	10	2\n13	8	20	10	11	13	14	16	18	19	20\n13	8	20	1	4	1	1	1	1	2	12647\n13	8	21	6	9	12	13	19	21	24\n13	8	21	4	35	1	3	2	1340	3\n13	8	22	12	16	17	18	22\n13	8	22	2	1	1	2	3\n13	8	23	21	23\n13	8	23	1	4\n13	8	24	17	21	22	23	24\n13	8	24	1	1	1	1	22\n13	8	25	25\n13	8	25	3\n13	8	26	21	22	26\n13	8	26	1	1	2\n13	8	27	23	24	26	27\n13	8	27	1	1	1	3\n13	8	28	28	30\n13	8	28	4	1\n13	8	29	29\n13	8	29	1\n13	8	30	30	32\n13	8	30	4	3\n13	8	32	32\n13	8	32	5\n13	8	33	33	37\n13	8	33	2	1\n13	8	35	35\n13	8	35	1\n13	8	37	20	27	37\n13	8	37	3	1	19\n13	8	38	38\n13	8	38	1\n13	8	40	37\n13	8	40	1\n13	9	0	0\n13	9	0	27\n13	9	6	6	9	13	17	18	22\n13	9	6	13763	623	1	1	2	3\n13	9	7	6	7	8	9	10	11	13	14	21	24\n13	9	7	20	7810	11	1	3	2	2	1	1	1\n13	9	8	6	7	8	9	10	11	12	13	14	15	17	18	19\n13	9	8	15	24	10519	155	28	4	50	28	60	1	8	23	1\n13	9	9	6	7	8	9	10	11	12	13	14	17	18\n13	9	9	20	27	61	14091	17	9	9	8	8	6	8\n13	9	10	6	8	9	10	11	12	13	14	18	25	27\n13	9	10	2	14	73	6804	7	53	25	1	5	1	1\n13	9	11	6	7	8	9	10	11	12	13	14	15	16	17	18	20	23	32\n13	9	11	105	32	23	85	118	148110	500	50	49	5	11	2	38	1	6	1\n13	9	12	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21	25	31	33\n13	9	12	48	13	7	3	58	839	109752	122	25	73	6	18	158	1	13	1	1	1\n13	9	13	6	8	9	10	11	12	13	14	15	16	17	18	20	21	22\n13	9	13	202	5	30	47	75	570	83617	119	398	2	4	40	3	13	1\n13	9	14	6	8	10	11	12	13	14	15	16	18	21	22	23	26\n13	9	14	14	8	3	25	65	179	36156	21	132	6	3	1	1	1\n13	9	15	6	8	9	10	11	12	13	14	15	16	17	18	19	21	23	24\n13	9	15	73	3	42	2	1	30	304	267	55068	187	2	50	1	95	2	12\n13	9	16	6	8	9	10	11	12	14	15	16	17	18	19	20	21	22	23	25\n13	9	16	7	6	8	4	1	3	94	295	11470	4	7	1	2	8	1	6	1\n13	9	17	10	12	13	14	16	17	18	19	20	22	23	25	26	28	32	34\n13	9	17	1	2	1	1	2	51	2	4	1	7	1	1	1	1	2	1\n13	9	18	6	9	11	12	13	16	17	18	19	20	21	22	23	24\n13	9	18	1	1	2	4	2	3	1	45	4	1	29	1	7	19\n13	9	19	12	14	16	17	19	21	22\n13	9	19	1	1	1	1	9	1	1\n13	9	20	20	21	23	37\n13	9	20	12648	2	1	2\n13	9	21	6	9	12	13	14	16	21	22	23	24	25	28	37\n13	9	21	1	5	3	4	2	3	1321	2	2	1	2	1	1\n13	9	22	18	22\n13	9	22	2	4\n13	9	23	19	23	30\n13	9	23	1	5	1\n13	9	24	18	24	26	27\n13	9	24	1	26	1	1\n13	9	25	18	23	25\n13	9	25	1	1	6\n13	9	26	26	28	30\n13	9	26	2	1	1\n13	9	27	23	25	27\n13	9	27	2	1	2\n13	9	28	25	28	30\n13	9	28	1	5	1\n13	9	29	32\n13	9	29	1\n13	9	30	28	30	32\n13	9	30	1	5	1\n13	9	32	30	32\n13	9	32	2	7\n13	9	33	32	33\n13	9	33	1	1\n13	9	35	35\n13	9	35	1\n13	9	37	20	35	37\n13	9	37	1	1	19\n13	9	38	38\n13	9	38	1\n13	10	0	0\n13	10	0	27\n13	10	6	6	9	13	15	18\n13	10	6	13989	277	1	2	2\n13	10	7	6	7	9	10	14\n13	10	7	3	7872	10	19	2\n13	10	8	6	7	8	9	10	11	12	13\n13	10	8	1	30	10590	2	1	2	11	20\n13	10	9	6	7	8	9	10	11	12	13	27	32\n13	10	9	18	21	39	15009	18	3	2	5	1	1\n13	10	10	7	8	9	10	11	12	13	14	15	16	18\n13	10	10	1	11	69	6918	8	43	15	17	1	1	1\n13	10	11	6	7	8	9	10	11	12	13	14	15	16	18	19	23\n13	10	11	22	9	8	25	56	148278	613	46	6	4	1	2	3	2\n13	10	12	6	7	8	9	10	11	12	13	14	15	16	18	20\n13	10	12	9	6	2	4	28	591	110271	79	6	39	5	1	1\n13	10	13	6	8	9	10	11	12	13	14	15	16\n13	10	13	35	2	3	18	54	586	83193	94	350	8\n13	10	14	6	8	11	12	13	14	15	16	18	19	22	23	25\n13	10	14	3	1	10	69	189	36269	27	148	63	2	1	1	1\n13	10	15	6	9	11	12	13	14	15	16	18	19	24\n13	10	15	14	4	1	33	214	259	55146	154	32	3	1\n13	10	16	13	14	15	16	19	21	23\n13	10	16	2	83	291	11436	1	3	1\n13	10	17	11	12	13	14	17	19	23\n13	10	17	1	1	1	9	83	1	2\n13	10	18	11	16	18	21	24\n13	10	18	1	5	375	4	3\n13	10	19	11	14	15	18	19	21\n13	10	19	1	1	3	2	13	1\n13	10	20	18	20	21	37\n13	10	20	2	12654	1	1\n13	10	21	12	13	17	18	20	21	24	31\n13	10	21	4	1	1	8	1	1469	1	1\n13	10	22	18	19	22	24\n13	10	22	5	1	14	1\n13	10	23	19	21	23	24\n13	10	23	1	3	29	1\n13	10	24	15	21	23	24\n13	10	24	1	12	2	44\n13	10	25	18	21	22	25	28\n13	10	25	1	1	1	10	1\n13	10	26	21	22	24	26\n13	10	26	1	1	1	2\n13	10	27	24	27\n13	10	27	1	3\n13	10	28	28\n13	10	28	9\n13	10	30	27	28	30\n13	10	30	1	2	7\n13	10	31	27\n13	10	31	1\n13	10	32	22	27	30	32	33\n13	10	32	1	1	2	7	2\n13	10	33	33\n13	10	33	2\n13	10	34	34\n13	10	34	1\n13	10	35	35\n13	10	35	2\n13	10	37	20	32	37\n13	10	37	1	1	20\n13	10	38	38\n13	10	38	1\n13	11	0	0\n13	11	0	27\n13	11	6	6	9	11	12	15	18\n13	11	6	14065	24	1	1	2	1\n13	11	7	7\n13	11	7	7939\n13	11	8	6	7	8	12	13\n13	11	8	1	622	10024	2	4\n13	11	9	6	7	8	9	10	11	12	13	14	19	22\n13	11	9	1608	232	186	13358	8	2	3	3	1	1	1\n13	11	10	7	8	9	10	11	12	13	14	16	18\n13	11	10	81	96	239	6624	5	3	4	4	1	1\n13	11	11	6	7	8	9	10	11	12	13	14	15	16\n13	11	11	3	2	577	331	194	147242	556	35	3	4	3\n13	11	12	6	7	8	9	10	11	12	13	14	15	16	17	18	21\n13	11	12	2	279	851	473	470	8205	101223	81	13	31	2	1	1	1\n13	11	13	6	8	9	10	11	12	13	14	15	16	24\n13	11	13	8	89	159	149	1484	1700	79788	71	310	7	1\n13	11	14	6	9	10	11	12	13	14	15	16	17	18	22\n13	11	14	2	97	316	1557	1664	3280	29688	9	110	2	20	1\n13	11	15	6	9	10	11	12	13	14	15	16	18\n13	11	15	1	106	90	304	802	5265	764	48417	114	1\n13	11	16	10	11	12	13	14	15	16	19\n13	11	16	1	20	47	41	355	313	10980	1\n13	11	17	10	11	12	14	15	16	17	19	20\n13	11	17	2	2	3	6	2	3	64	1	1\n13	11	18	9	10	11	12	13	14	15	16	17	18	19	22\n13	11	18	5	51	1	108	10	86	67	7	10	145	3	1\n13	11	19	14	15	16	17	18	19	22\n13	11	19	1	4	1	2	3	13	1\n13	11	20	11	12	13	14	15	16	17	18	19	20\n13	11	20	34	45	43	97	153	9982	14	1	1	2287\n13	11	21	10	12	13	14	15	16	18	19	20	21	22	24\n13	11	21	4	604	401	3	62	4	25	2	1	386	2	1\n13	11	22	10	12	13	14	17	18	19	21	22\n13	11	22	1	1	1	1	1	2	1	2	8\n13	11	23	10	11	14	16	18	19	20	21	23\n13	11	23	1	2	4	6	6	1	1	3	13\n13	11	24	10	13	15	18	21	22	23	24\n13	11	24	1	5	15	10	4	1	1	16\n13	11	25	14	15	17	25	28\n13	11	25	1	1	1	7	1\n13	11	26	21	26\n13	11	26	1	1\n13	11	27	14	20	21	26	27\n13	11	27	1	1	1	1	3\n13	11	28	18	22	26	27	28\n13	11	28	1	1	1	2	7\n13	11	30	23	30\n13	11	30	1	8\n13	11	31	30\n13	11	31	1\n13	11	32	27	32\n13	11	32	1	8\n13	11	33	33\n13	11	33	4\n13	11	34	34\n13	11	34	1\n13	11	35	35\n13	11	35	2\n13	11	37	16	17	37\n13	11	37	12	1	8\n13	11	38	35\n13	11	38	1\n13	12	0	0\n13	12	0	27\n13	12	6	6	9\n13	12	6	15687	3\n13	12	7	7	10\n13	12	7	9153	2\n13	12	8	7	8	13\n13	12	8	377	11436	10\n13	12	9	6	7	8	9	10	11	12	13\n13	12	9	1206	119	177	13259	17	3	4	7\n13	12	10	7	8	9	10	11	12	13\n13	12	10	56	78	230	7533	7	2	6\n13	12	11	6	7	8	9	10	11	12	13	14	15	16\n13	12	11	2	1	293	236	140	156115	1953	86	1	24	8\n13	12	12	7	8	9	10	11	12	13	14	15	16	17	21\n13	12	12	15	211	187	396	4802	100928	112	2	95	12	1	1\n13	12	13	6	8	9	10	11	12	13	14	15	16\n13	12	13	3	78	119	119	782	1448	85508	94	774	36\n13	12	14	6	9	10	11	12	13	14	15	16	17\n13	12	14	1	43	150	253	659	1760	27953	8	271	1\n13	12	15	6	8	9	10	11	12	13	14	15	16	20\n13	12	15	1	1	27	35	145	320	3023	357	45307	173	1\n13	12	16	11	12	13	14	15	16	17	18\n13	12	16	44	65	88	309	313	20410	2	1\n13	12	17	10	11	12	13	14	15	16	17	21\n13	12	17	6	1	2	1	11	2	2	70	1\n13	12	18	9	10	11	12	13	14	15	16	17	18	20	22\n13	12	18	6	11	3	51	18	40	27	7	4	48	1	1\n13	12	19	11	12	13	16	18	19	21\n13	12	19	3	1	1	3	3	12	1\n13	12	20	12	14	15	16	17	18	20\n13	12	20	1	15	9	1226	3	2	1035\n13	12	21	10	12	13	14	15	17	18	19	20	21	23\n13	12	21	2	108	97	1	10	1	8	1	2	166	2\n13	12	22	17	18	19	20	21	22	23\n13	12	22	1	3	1	2	5	3	1\n13	12	23	13	15	16	18	20	23\n13	12	23	1	2	3	3	1	5\n13	12	24	15	18	21	22	24	28\n13	12	24	6	1	1	1	8	1\n13	12	25	15	25\n13	12	25	1	6\n13	12	26	22	23	26\n13	12	26	1	1	1\n13	12	27	17	26	27\n13	12	27	1	1	4\n13	12	28	18	21	22	27	28\n13	12	28	1	2	1	2	2\n13	12	30	27	28	30	32\n13	12	30	1	1	6	1\n13	12	32	25	30	32\n13	12	32	1	1	6\n13	12	33	32	33\n13	12	33	2	2\n13	12	34	34\n13	12	34	1\n13	12	35	33	35	37\n13	12	35	1	1	1\n13	12	37	16	20	37\n13	12	37	3	1	4\n14	1	0	0\n14	1	0	18\n14	1	6	6	9\n14	1	6	4058	272\n14	1	7	7	8	9	10	12\n14	1	7	5678	161	97	21	15\n14	1	8	7	8	9	10	11	12	13\n14	1	8	9	7588	42	19	104	223	20\n14	1	9	6	7	8	9	10	11	12	13	14	15\n14	1	9	1	9	30	8507	67	133	76	43	18	4\n14	1	10	7	8	9	10	11	12	13	14	15	16\n14	1	10	3	5	55	3216	53	108	14	56	4	1\n14	1	11	8	9	10	11	12	13	14	15	16\n14	1	11	3	10	50	103753	787	195	63	32	9\n14	1	12	9	10	11	12	13	14	15	16	17	19	21\n14	1	12	4	5	3089	81439	245	236	51	33	1	4	97\n14	1	13	8	9	10	11	12	13	14	15	16	17	18	19	21\n14	1	13	10	3	6	180	601	63457	588	571	18	4	4	2	73\n14	1	14	11	12	13	14	15	16	17	19	20	22\n14	1	14	10	142	287	23892	137	88	5	53	5	1\n14	1	15	8	11	12	13	14	15	16	17	18	19	20	21	23\n14	1	15	1	69	175	1420	157	45100	101	7	9	30	2	105	7\n14	1	16	11	12	13	14	15	16	17	18	20	21	37\n14	1	16	6	28	59	378	235	14403	17	3	1705	129	4\n14	1	17	13	14	15	16	17	18	20	21	22	23\n14	1	17	18	3	29	8	284	21	8	12	1	22\n14	1	18	12	13	14	15	16	17	18	19	20	21	22	23	27\n14	1	18	1	11	5	19	10	4	271	1	4	26	1	19	7\n14	1	19	14	15	16	18	19	21	23	27\n14	1	19	3	6	1	1	172	3	1	2\n14	1	20	14	16	18	19	20	21	22	23	24	25	26	28	30\n14	1	20	3	4	1	1	1425	1	4	1	2	1	2	1	1\n14	1	21	15	18	19	20	21	22	23	27	28\n14	1	21	1	1	2	7	574	1	17	4	1\n14	1	22	19	20	22	24	25	28	29\n14	1	22	2	4	25	1	2	1	3\n14	1	23	19	20	21	23	25	31\n14	1	23	1	3	7	90	1	1\n14	1	24	20	24	26	28	29\n14	1	24	1	4	1	2	1\n14	1	25	23	24	25	27	28	37\n14	1	25	2	1	19	2	1	1\n14	1	26	21	25	26	31	33\n14	1	26	2	1	2	1	1\n14	1	27	20	21	24	27	30\n14	1	27	2	2	1	11	1\n14	1	28	23	26	28\n14	1	28	3	3	13\n14	1	29	27	28	29	33\n14	1	29	1	2	8	1\n14	1	30	26	28	30	31\n14	1	30	1	1	3	1\n14	1	31	25	28	31\n14	1	31	1	2	10\n14	1	32	32\n14	1	32	3\n14	1	34	34\n14	1	34	1\n14	1	37	32	37\n14	1	37	1	6\n14	1	40	26\n14	1	40	1\n14	2	0	0\n14	2	0	18\n14	2	6	6	9\n14	2	6	3891	168\n14	2	7	7	8	9	10	12	28\n14	2	7	5443	135	61	18	41	1\n14	2	8	7	8	9	10	11	12	13\n14	2	8	9	7218	38	20	163	336	14\n14	2	9	6	7	8	9	10	11	12	13	14	15\n14	2	9	4	16	35	8611	57	85	109	30	27	16\n14	2	10	7	8	9	10	11	12	13	14	15	16	17	19\n14	2	10	2	3	43	3112	46	74	20	63	17	2	1	1\n14	2	11	8	9	10	11	12	13	14	15	16	20\n14	2	11	2	13	39	105517	1272	276	213	59	2	4\n14	2	12	9	10	11	12	13	14	15	16	17	19	20	21\n14	2	12	3	5	2587	79889	298	339	91	121	1	12	13	236\n14	2	13	8	9	10	11	12	13	14	15	16	17	18	20	21\n14	2	13	3	1	7	110	593	63040	864	965	11	8	1	7	159\n14	2	14	11	12	13	14	15	16	17	18	19	20	21\n14	2	14	7	99	214	24684	174	73	7	1	122	18	3\n14	2	15	11	12	13	14	15	16	17	18	19	20	21	23\n14	2	15	30	142	1145	181	44284	86	5	12	57	25	214	8\n14	2	16	11	12	13	14	15	16	17	18	19	20	21	23	37\n14	2	16	2	11	30	280	257	8842	7	2	1	5101	138	3	2\n14	2	17	13	14	15	16	17	18	19	20	21	22	23	27\n14	2	17	9	2	8	5	230	6	3	14	13	1	30	1\n14	2	18	12	13	14	15	16	17	18	19	20	21	22	23	26	27\n14	2	18	1	6	2	15	10	3	202	2	5	24	1	29	1	10\n14	2	19	12	14	15	16	17	18	19	21	23	27	28\n14	2	19	1	2	4	3	3	4	236	6	5	3	1\n14	2	20	14	15	16	17	19	20	21	22	25	28	31	32	37\n14	2	20	2	1	9	2	3	3141	1	1	2	1	1	1	1\n14	2	21	16	17	18	19	20	21	23	26	28\n14	2	21	6	1	1	1	7	984	23	5	3\n14	2	22	14	19	20	21	22	23	24	25	27\n14	2	22	1	1	1	1	24	1	1	1	2\n14	2	23	19	21	22	23	25	28\n14	2	23	2	19	1	136	2	2\n14	2	24	19	24	29\n14	2	24	1	7	1\n14	2	25	12	23	25	27	29\n14	2	25	1	4	18	1	1\n14	2	26	23	26	31\n14	2	26	1	7	2\n14	2	27	21	22	26	27\n14	2	27	2	1	1	23\n14	2	28	23	26	27	28\n14	2	28	4	1	3	16\n14	2	29	27	28	29\n14	2	29	1	2	9\n14	2	30	30	32\n14	2	30	4	1\n14	2	31	28	31\n14	2	31	2	11\n14	2	32	32	33\n14	2	32	3	1\n14	2	33	15	33\n14	2	33	1	1\n14	2	34	28\n14	2	34	1\n14	2	37	30	37\n14	2	37	1	10\n14	3	0	0\n14	3	0	18\n14	3	6	6\n14	3	6	3895\n14	3	7	7\n14	3	7	5470\n14	3	8	7	8	23\n14	3	8	13	7382	1\n14	3	9	6	7	8	9	10	12	13\n14	3	9	4	21	52	8848	11	1	1\n14	3	10	7	8	9	10	11\n14	3	10	2	1	54	3200	1\n14	3	11	8	9	10	11	12	13\n14	3	11	2	13	54	108363	93	22\n14	3	12	8	9	10	11	12	13	14	15	21\n14	3	12	2	3	6	1716	80759	53	24	5	1\n14	3	13	8	9	10	11	12	13	14	15	16	17	18\n14	3	13	1	2	5	95	654	64210	47	63	3	1	1\n14	3	14	8	11	12	13	14	15	16	19\n14	3	14	1	9	82	369	26156	16	26	1\n14	3	15	11	12	13	14	15	16	17\n14	3	15	13	109	982	147	44566	74	1\n14	3	16	12	13	14	15	16\n14	3	16	4	9	215	277	8665\n14	3	17	13	15	17	18\n14	3	17	10	7	250	1\n14	3	18	10	13	15	16	17	18	19\n14	3	18	1	6	6	3	1	211	1\n14	3	19	11	12	14	15	16	17	18	19	21\n14	3	19	2	1	1	6	2	1	1	427	1\n14	3	20	13	14	15	16	17	18	19	20	21	22\n14	3	20	1	4	2	4	1	2	2	8318	1	1\n14	3	21	15	16	18	19	20	21	22\n14	3	21	4	4	1	7	7	1776	1\n14	3	22	17	18	19	20	21	22\n14	3	22	1	1	1	1	2	23\n14	3	23	18	19	20	21	22	23\n14	3	23	1	2	4	4	2	231\n14	3	24	19	21	23	24\n14	3	24	1	1	1	5\n14	3	25	21	25	26\n14	3	25	1	21	1\n14	3	26	23	26\n14	3	26	1	14\n14	3	27	21	22	27	29\n14	3	27	2	1	40	1\n14	3	28	20	21	23	25	27	28	30	31\n14	3	28	2	1	5	1	2	16	1	1\n14	3	29	26	29\n14	3	29	1	10\n14	3	30	30\n14	3	30	5\n14	3	31	25	26	31\n14	3	31	2	1	11\n14	3	32	32\n14	3	32	5\n14	3	33	33	35\n14	3	33	1	1\n14	3	37	37\n14	3	37	13\n14	4	0	0\n14	4	0	18\n14	4	6	6\n14	4	6	3899\n14	4	7	7\n14	4	7	5506\n14	4	8	7	8\n14	4	8	12	7429\n14	4	9	6	7	8	9	10	11	12	14\n14	4	9	4	11	34	8855	11	3	1	1\n14	4	10	8	9	10	11	14	15\n14	4	10	1	70	3203	1	1	1\n14	4	11	8	9	10	11	12	13\n14	4	11	1	14	44	110044	74	22\n14	4	12	9	10	11	12	13	14	15	18	21\n14	4	12	9	6	1468	80137	64	10	7	1	1\n14	4	13	8	9	10	11	12	13	14	15	16	17	18\n14	4	13	1	10	3	75	580	64879	57	54	1	1	2\n14	4	14	11	12	13	14	15	16	18\n14	4	14	8	84	274	26185	15	27	1\n14	4	15	8	9	11	12	13	14	15	16	17	23\n14	4	15	1	1	11	79	841	140	43795	82	1	1\n14	4	16	9	10	12	13	14	15	16	17	20\n14	4	16	1	3	1	6	217	257	8294	1	1\n14	4	17	11	12	13	14	15	16	17	18	20\n14	4	17	1	2	6	4	6	11	224	1	1\n14	4	18	10	13	14	15	16	17	18\n14	4	18	1	5	2	9	3	9	190\n14	4	19	9	12	13	14	15	16	18	19	20\n14	4	19	1	3	1	2	6	3	6	419	1\n14	4	20	9	12	15	16	18	19	20	23\n14	4	20	8	1	2	3	1	2	8314	1\n14	4	21	9	14	15	16	17	18	19	20	21\n14	4	21	3	2	4	1	2	4	2	5	1767\n14	4	22	9	10	15	17	18	21	22\n14	4	22	1	1	1	1	1	1	22\n14	4	23	11	15	18	19	21	23	29\n14	4	23	1	3	1	6	11	216	1\n14	4	24	23	24	28\n14	4	24	2	2	1\n14	4	25	19	20	21	22	23	25	28\n14	4	25	5	2	4	1	2	9	1\n14	4	26	21	24	26	28\n14	4	26	2	1	13	1\n14	4	27	21	26	27\n14	4	27	1	1	40\n14	4	28	26	27	28\n14	4	28	2	1	13\n14	4	29	29\n14	4	29	11\n14	4	30	15	30\n14	4	30	1	5\n14	4	31	28	31\n14	4	31	1	11\n14	4	32	32\n14	4	32	5\n14	4	33	33\n14	4	33	1\n14	4	35	35\n14	4	35	1\n14	4	37	37\n14	4	37	13\n14	5	0	0\n14	5	0	18\n14	5	6	6	8\n14	5	6	3902	1\n14	5	7	7	8\n14	5	7	5528	1\n14	5	8	7	8\n14	5	8	11	7456\n14	5	9	6	7	8	9	10	11\n14	5	9	13	26	42	8874	13	5\n14	5	10	7	8	9	10	11\n14	5	10	1	3	47	3220	1\n14	5	11	7	8	9	10	11	12	13	14	15	16\n14	5	11	3	21	23	47	111277	200	36	3	1	1\n14	5	12	7	8	9	10	11	12	13	14	15	16	18\n14	5	12	1	10	4	10	1166	79667	79	10	13	1	1\n14	5	13	8	9	10	11	12	13	14	15	16	17\n14	5	13	74	13	4	87	470	65256	70	121	1	2\n14	5	14	8	9	10	11	12	13	14	15	16	17\n14	5	14	4	3	4	13	117	219	26189	17	54	1\n14	5	15	8	9	11	12	13	14	15	16	18\n14	5	15	3	1	3	69	601	140	43244	97	3\n14	5	16	8	9	11	12	13	14	15	16	18\n14	5	16	33	2	4	5	9	157	213	8001	1\n14	5	17	8	11	12	13	15	16	17	18\n14	5	17	1	3	10	14	6	13	190	2\n14	5	18	9	13	15	16	17	18	19\n14	5	18	1	10	31	6	18	141	1\n14	5	19	8	9	11	12	13	14	15	18	19\n14	5	19	14	2	1	2	2	2	15	1	395\n14	5	20	8	12	13	14	15	16	18	19	20\n14	5	20	7	20	4	3	1	3	4	1	8281\n14	5	21	8	9	11	12	13	14	15	16	17	18	19	21	22\n14	5	21	2	2	1	1	11	11	100	30	10	14	4	1600	1\n14	5	22	8	9	13	14	18	20	21	22\n14	5	22	2	1	1	1	1	4	1	12\n14	5	23	8	9	13	15	16	17	18	20	21	23\n14	5	23	9	1	5	31	10	44	58	3	33	28\n14	5	24	22	24\n14	5	24	1	2\n14	5	25	8	10	25\n14	5	25	1	1	7\n14	5	26	11	17	20	21	23	26	27\n14	5	26	1	1	1	1	1	10	1\n14	5	27	16	18	19	20	21	22	24	25	26	27\n14	5	27	5	1	3	1	6	1	1	2	1	20\n14	5	28	13	17	28\n14	5	28	1	2	14\n14	5	29	16	22	24	25	29\n14	5	29	2	2	4	1	3\n14	5	30	28	30\n14	5	30	1	4\n14	5	31	8	17	28	31\n14	5	31	1	5	1	4\n14	5	32	18	32\n14	5	32	1	4\n14	5	33	31\n14	5	33	1\n14	5	35	35\n14	5	35	1\n14	5	37	20	37\n14	5	37	3	10\n14	6	0	0\n14	6	0	18\n14	6	6	6	7	9\n14	6	6	3910	4	1\n14	6	7	7	9\n14	6	7	5569	1\n14	6	8	7	8	13\n14	6	8	18	7666	1\n14	6	9	6	7	8	9	10	11	25\n14	6	9	10	34	49	8862	17	1	1\n14	6	10	7	8	9	10	11	13\n14	6	10	1	5	63	3228	1	1\n14	6	11	7	8	9	10	11	12	13	14	15	17\n14	6	11	22	4	28	48	112184	220	51	1	3	1\n14	6	12	7	8	9	10	11	12	13	14	15	16	17	18\n14	6	12	9	23	13	18	1069	79282	97	28	16	3	2	1\n14	6	13	7	8	9	10	11	12	13	14	15	16	18\n14	6	13	61	1	13	1	78	519	65353	73	147	1	1\n14	6	14	7	9	10	11	12	13	14	15	16	18\n14	6	14	5	3	8	15	239	233	26006	7	68	2\n14	6	15	7	9	11	12	13	14	15	16	17	18	20\n14	6	15	28	2	5	84	610	208	42754	97	3	1	1\n14	6	16	7	11	12	13	14	15	16	17	18	21\n14	6	16	5	1	11	8	161	234	7800	1	2	1\n14	6	17	7	11	12	13	14	15	16	17	21\n14	6	17	7	1	3	9	4	19	11	218	1\n14	6	18	7	9	13	14	15	16	17	18	19	22\n14	6	18	5	2	5	1	5	1	1	206	1	1\n14	6	19	7	9	10	12	13	14	15	17	19\n14	6	19	22	8	2	81	4	220	26	1	40\n14	6	20	7	9	12	13	14	15	16	18	20\n14	6	20	1	1	1	3	8	2	3	3	8271\n14	6	21	7	9	13	14	15	16	17	18	20	21	24\n14	6	21	3	3	15	1	459	101	2	29	3	1024	1\n14	6	22	7	10	14	15	16	17	21	22\n14	6	22	1	1	1	1	1	1	1	10\n14	6	23	15	16	21	23\n14	6	23	2	4	1	22\n14	6	24	21	24\n14	6	24	2	5\n14	6	25	9	10	20	25\n14	6	25	1	4	1	4\n14	6	26	17	18	19	20	21\n14	6	26	1	3	2	4	1\n14	6	27	18	19	21	22	27	37\n14	6	27	12	3	2	2	1	1\n14	6	28	19	20	21	24	25	26	28\n14	6	28	3	4	1	1	1	1	5\n14	6	29	29	30\n14	6	29	2	1\n14	6	30	22	25	32\n14	6	30	2	1	1\n14	6	31	30	31\n14	6	31	1	4\n14	6	32	20	21	30	32\n14	6	32	1	1	1	1\n14	6	35	35\n14	6	35	1\n14	6	37	20	37\n14	6	37	2	8\n14	7	0	0\n14	7	0	18\n14	7	6	6	9\n14	7	6	3908	12\n14	7	7	6	7	8	9	10\n14	7	7	132	5642	5	13	3\n14	7	8	6	7	8	9	10	12	13\n14	7	8	114	11	7606	11	3	1	2\n14	7	9	6	7	8	9	10	11	15	19	21	30\n14	7	9	213	23	53	8669	26	11	2	2	1	1\n14	7	10	6	8	9	10	11	12	15	32\n14	7	10	18	11	66	3214	7	9	1	1\n14	7	11	6	7	8	9	10	11	12	13	14	15	21\n14	7	11	187	3	15	41	382	112319	331	68	1	7	1\n14	7	12	6	7	8	9	10	11	12	13	14	15\n14	7	12	36	1	17	5	137	783	79299	103	30	29\n14	7	13	6	8	9	10	11	12	13	14	15	16	18	21\n14	7	13	814	3	112	19	72	484	64607	121	155	1	1	1\n14	7	14	6	8	9	10	11	12	13	14	15	16	18\n14	7	14	34	59	10	46	16	131	176	26153	33	52	2\n14	7	15	6	9	10	11	12	13	14	15	16	18	19	20	21\n14	7	15	327	30	4	5	27	426	171	42582	93	7	1	1	1\n14	7	16	6	8	9	10	11	12	13	14	15	16	17	21\n14	7	16	15	18	11	11	2	163	34	94	295	7443	1	3\n14	7	17	6	9	10	13	14	15	16	17	18	21\n14	7	17	57	114	1	3	2	12	3	36	2	1\n14	7	18	6	8	9	10	12	13	14	15	16	18	23\n14	7	18	67	4	50	1	2	5	4	6	4	116	1\n14	7	19	8	10	13	15	19\n14	7	19	3	2	5	4	35\n14	7	20	8	10	13	14	15	16	18	20	28	37\n14	7	20	1	1	2	2	4	16	5	8254	1	1\n14	7	21	6	8	9	10	11	13	15	16	18	19	21\n14	7	21	10	3	28	5	1	20	86	45	1	1	835\n14	7	22	10	13	16	18	22	34\n14	7	22	2	2	1	2	7	1\n14	7	23	6	9\n14	7	23	2	20\n14	7	24	10	11	13	18	24	25\n14	7	24	1	1	2	1	1	1\n14	7	25	8	13	16	25	27\n14	7	25	1	2	1	2	1\n14	7	26	26\n14	7	26	1\n14	7	27	27\n14	7	27	1\n14	7	28	18	25	28\n14	7	28	1	2	2\n14	7	29	13	29\n14	7	29	1	1\n14	7	30	32	37\n14	7	30	2	1\n14	7	31	21	23	25\n14	7	31	1	2	1\n14	7	32	32\n14	7	32	2\n14	7	35	35\n14	7	35	1\n14	7	37	20	37\n14	7	37	1	8\n14	8	0	0\n14	8	0	18\n14	8	6	6	9	25\n14	8	6	5928	5	1\n14	8	7	6	7	8	9	10\n14	8	7	173	5489	1	16	1\n14	8	8	6	7	8	9	11	19\n14	8	8	229	15	7543	10	1	1\n14	8	9	6	7	8	9	10	11	12	14	28	30\n14	8	9	279	43	65	8777	19	3	3	1	1	1\n14	8	10	6	7	8	9	10	11	12	13	14\n14	8	10	57	7	23	66	3686	3	14	1	1\n14	8	11	6	7	8	9	10	11	12	13	14	15	16\n14	8	11	468	48	61	51	869	111059	569	87	3	1	1\n14	8	12	6	7	8	9	10	11	12	13	14	15	16\n14	8	12	232	35	48	17	394	625	78923	110	16	43	4\n14	8	13	6	8	9	10	11	12	13	14	15	16\n14	8	13	2062	13	220	33	61	441	62325	114	187	2\n14	8	14	6	7	8	9	10	11	12	13	14	15	16	18\n14	8	14	62	4	118	10	162	25	188	203	25610	139	49	8\n14	8	15	6	8	9	10	11	12	13	14	15	16	18	20\n14	8	15	1185	34	427	17	1	35	257	179	40956	105	17	3\n14	8	16	6	8	9	10	12	13	14	15	16	18\n14	8	16	32	11	118	6	7	2	85	228	7168	2\n14	8	17	8	9	10	13	14	15	16	17	18\n14	8	17	1	1	1	2	1	2	3	24	2\n14	8	18	6	8	9	10	11	12	13	14	15	18	21\n14	8	18	25	35	26	5	1	1	21	3	1	19	1\n14	8	19	8	10	12	13	15	18	19	24\n14	8	19	5	4	4	3	10	3	4	6\n14	8	20	8	10	11	12	13	14	16	17	20\n14	8	20	3	3	2	2	5	3	3	2	8233\n14	8	21	6	9	10	13	16	17	19	21	33	37\n14	8	21	16	99	1	3	1	1	1	720	1	1\n14	8	22	11	14	16\n14	8	22	2	2	3\n14	8	23	21	23\n14	8	23	1	2\n14	8	24	25\n14	8	24	1\n14	8	25	14	25\n14	8	25	1	5\n14	8	26	26\n14	8	26	1\n14	8	27	13	27\n14	8	27	1	1\n14	8	28	13	28\n14	8	28	1	2\n14	8	29	25\n14	8	29	1\n14	8	30	30\n14	8	30	1\n14	8	32	32\n14	8	32	5\n14	8	34	17\n14	8	34	1\n14	8	35	37\n14	8	35	1\n14	8	37	37\n14	8	37	10\n14	9	0	0\n14	9	0	18\n14	9	6	6	9	18	20	23	29\n14	9	6	10514	230	1	1	1	1\n14	9	7	6	7	8	10	12\n14	9	7	44	5594	1	1	1\n14	9	8	6	7	8	9	10	12	13	14	15	18	22\n14	9	8	61	23	7788	46	10	7	11	12	1	1	1\n14	9	9	6	7	8	9	10	11	12	13	14	15	18	25	30\n14	9	9	50	9	63	9696	6	6	3	5	1	1	1	1	1\n14	9	10	6	7	8	9	10	11	12	13\n14	9	10	14	2	11	33	5098	6	24	13\n14	9	11	6	7	8	9	10	11	12	13	14	15	16	18\n14	9	11	210	50	40	26	339	110687	305	31	86	2	1	6\n14	9	12	6	7	8	9	10	11	12	13	14	15	16	18	21	25\n14	9	12	90	35	36	10	208	566	78954	99	111	61	1	5	5	6\n14	9	13	6	8	9	10	11	12	13	14	15	18	21\n14	9	13	545	3	38	26	48	424	61613	86	229	1	8\n14	9	14	6	8	9	10	11	12	13	14	15	16	18	21	23\n14	9	14	59	41	9	7	11	44	130	25648	12	54	1	2	1\n14	9	15	6	8	9	10	11	12	13	14	15	16	18	21\n14	9	15	194	8	89	3	3	34	215	200	40671	108	1	41\n14	9	16	6	8	9	10	11	12	13	14	15	16	18	20	23\n14	9	16	15	25	31	13	1	1	2	69	202	6974	1	1	4\n14	9	17	13	15	16	17	22	25	31\n14	9	17	2	1	1	21	1	1	1\n14	9	18	6	9	11	15	18	22	23\n14	9	18	6	3	1	1	38	1	1\n14	9	19	15	17	19\n14	9	19	2	2	2\n14	9	20	8	20	23\n14	9	20	1	8234	1\n14	9	21	6	9	18	21	23\n14	9	21	2	8	1	709	2\n14	9	23	23\n14	9	23	2\n14	9	24	24\n14	9	24	6\n14	9	25	25	28	37\n14	9	25	5	1	2\n14	9	26	26\n14	9	26	1\n14	9	27	27\n14	9	27	1\n14	9	28	28\n14	9	28	3\n14	9	30	28	30\n14	9	30	1	1\n14	9	32	32\n14	9	32	5\n14	9	33	33\n14	9	33	1\n14	9	37	35	37\n14	9	37	1	11\n14	10	0	0\n14	10	0	18\n14	10	6	6	9	11	12	15	24	30\n14	10	6	11282	517	1	1	1	1	1\n14	10	7	6	7	8	9	10	11	12	13	14	15	17	18\n14	10	7	8	5538	20	71	19	3	18	1	22	2	4	7\n14	10	8	6	7	8	9	10	11	12	13\n14	10	8	13	14	7917	15	9	13	13	23\n14	10	9	6	7	8	9	10	11	12	13	14	18	22	28\n14	10	9	20	18	52	10081	12	7	7	6	5	8	1	2\n14	10	10	8	9	10	11	12	13	14	15	18	22	32\n14	10	10	8	60	5546	5	71	12	3	1	3	1	1\n14	10	11	6	7	8	9	10	11	12	13	14	15	16	23\n14	10	11	65	10	28	10	87	110715	355	23	16	2	9	9\n14	10	12	6	7	8	9	10	11	12	13	14	15	16	17	18	21	25	28\n14	10	12	32	14	15	3	51	407	78983	52	12	72	10	16	126	2	1	1\n14	10	13	6	8	9	10	11	12	13	14	15	16	18	23\n14	10	13	131	8	19	14	48	447	61148	46	240	2	14	4\n14	10	14	6	8	9	11	12	13	14	15	16	18	23	26\n14	10	14	12	2	1	14	62	158	25879	4	77	1	2	1\n14	10	15	6	8	9	10	11	12	13	14	15	16	18	21	24\n14	10	15	46	3	28	1	3	22	152	201	40575	85	57	1	9\n14	10	16	8	10	11	14	15	16	18	20	25\n14	10	16	3	1	1	49	199	6883	1	1	1\n14	10	17	8	17	18	30\n14	10	17	1	20	1	1\n14	10	18	11	15	16	18	19	24\n14	10	18	1	1	1	44	1	9\n14	10	19	11	19\n14	10	19	1	1\n14	10	20	16	20	23\n14	10	20	2	8233	1\n14	10	21	12	13	15	21\n14	10	21	2	2	4	757\n14	10	22	22	25\n14	10	22	2	1\n14	10	23	21	23\n14	10	23	1	11\n14	10	24	24\n14	10	24	6\n14	10	25	14	25	26\n14	10	25	1	11	1\n14	10	26	23\n14	10	26	1\n14	10	27	27\n14	10	27	1\n14	10	28	25	27	28\n14	10	28	2	1	2\n14	10	29	29\n14	10	29	1\n14	10	30	28	30\n14	10	30	1	1\n14	10	31	31\n14	10	31	1\n14	10	32	32\n14	10	32	5\n14	10	33	33\n14	10	33	1\n14	10	35	35\n14	10	35	1\n14	10	37	37\n14	10	37	13\n14	11	0	0\n14	11	0	18\n14	11	6	6	8	9	11	13	14	18	20\n14	11	6	11457	2	144	2	1	1	1	1\n14	11	7	6	7	8	10	11\n14	11	7	1	5583	2	6	2\n14	11	8	6	7	8	9	10	13\n14	11	8	4	9	8026	6	11	1\n14	11	9	6	7	8	9	10	11	12	13	18	19\n14	11	9	14	9	44	10719	6	6	2	2	1	2\n14	11	10	6	7	8	9	10	11	12	13	14	18\n14	11	10	1	1	8	44	5660	5	8	6	5	2\n14	11	11	6	7	8	9	10	11	12	13	14	15	16	18	19\n14	11	11	12	3	4	7	54	110785	319	21	3	3	6	1	1\n14	11	12	6	7	8	10	11	12	13	14	15	16	17	18	21\n14	11	12	7	7	1	15	424	79439	48	6	26	1	2	1	4\n14	11	13	6	8	9	10	11	12	13	14	15	16	18\n14	11	13	28	3	2	13	43	450	60812	45	177	3	1\n14	11	14	6	11	12	13	14	15	16	18	25\n14	11	14	5	13	34	136	25906	2	65	72	1\n14	11	15	6	8	9	12	13	14	15	16	18	19	21\n14	11	15	7	2	8	36	168	230	40575	69	4	1	1\n14	11	16	14	15	16	19	20	22\n14	11	16	56	247	6763	1	1	1\n14	11	17	13	14	16	17\n14	11	17	1	3	1	35\n14	11	18	12	15	18	22	24\n14	11	18	1	2	257	1	1\n14	11	19	19\n14	11	19	2\n14	11	20	20\n14	11	20	8234\n14	11	21	13	15	18	21\n14	11	21	1	3	1	756\n14	11	22	22	25\n14	11	22	3	1\n14	11	23	23\n14	11	23	28\n14	11	24	18	23	24\n14	11	24	5	2	18\n14	11	25	22	23	24	25\n14	11	25	1	1	1	13\n14	11	26	22	26\n14	11	26	1	1\n14	11	27	27\n14	11	27	2\n14	11	28	23	27	28\n14	11	28	1	1	4\n14	11	29	27\n14	11	29	1\n14	11	30	26	30\n14	11	30	1	2\n14	11	31	31\n14	11	31	1\n14	11	32	22	32\n14	11	32	1	5\n14	11	33	33\n14	11	33	1\n14	11	35	33\n14	11	35	1\n14	11	37	37\n14	11	37	13\n14	12	0	0\n14	12	0	18\n14	12	6	6	9	11\n14	12	6	11519	15	2\n14	12	7	7\n14	12	7	5612\n14	12	8	7	8	10	12	13\n14	12	8	504	7578	5	2	3\n14	12	9	6	7	8	9	10	11	12	13\n14	12	9	1293	140	152	9331	3	7	3	1\n14	12	10	7	8	9	10	11	12	13\n14	12	10	68	87	161	5433	12	2	2\n14	12	11	6	7	8	9	10	11	12	13	14	15	16\n14	12	11	8	2	497	249	133	109314	1027	39	3	5	3\n14	12	12	6	7	8	9	10	11	12	13	14	15	16	17	21\n14	12	12	2	246	655	303	438	6634	71875	74	11	45	4	1	1\n14	12	13	6	7	8	9	10	11	12	13	14	15	16\n14	12	13	2	1	87	152	90	1264	1282	57797	47	468	7\n14	12	14	6	9	10	11	12	13	14	15	16	17	18\n14	12	14	1	93	249	1410	1365	2713	20293	7	119	1	4\n14	12	15	6	7	9	10	11	12	13	14	15	16	20	21\n14	12	15	2	1	78	74	208	633	4048	539	35332	117	1	2\n14	12	16	8	11	12	13	14	15	16	17	18\n14	12	16	1	14	38	33	179	168	6468	3	4\n14	12	17	10	14	17	18\n14	12	17	3	4	28	2\n14	12	18	9	10	12	13	14	15	16	17	18\n14	12	18	3	22	82	14	64	58	2	3	98\n14	12	19	15	18	19\n14	12	19	3	1	3\n14	12	20	11	12	13	14	15	16	17	20\n14	12	20	28	34	32	58	101	6691	8	1284\n14	12	21	10	12	13	15	17	18	21	22\n14	12	21	3	331	216	31	1	1	177	1\n14	12	22	13	16	17	19	20	22\n14	12	22	1	1	1	1	1	3\n14	12	23	10	11	12	13	14	16	20	21	23	25\n14	12	23	1	3	1	5	2	4	2	1	12	1\n14	12	24	10	12	13	14	15	18	24\n14	12	24	1	3	1	2	8	3	2\n14	12	25	14	20	21	22	25\n14	12	25	5	1	1	1	7\n14	12	26	22	25\n14	12	26	1	1\n14	12	27	25	27	28\n14	12	27	1	1	2\n14	12	28	17	27	28\n14	12	28	1	1	2\n14	12	30	28	30\n14	12	30	1	1\n14	12	31	25\n14	12	31	1\n14	12	32	27	30	32\n14	12	32	1	1	3\n14	12	33	33	35\n14	12	33	1	1\n14	12	37	16	25	32	37\n14	12	37	8	1	1	3\n14	13	0	0\n14	13	0	18\n14	13	6	6	9\n14	13	6	12825	2\n14	13	7	7	10\n14	13	7	6573	1\n14	13	8	7	8	12	13\n14	13	8	332	8718	2	5\n14	13	9	6	7	8	9	10	12	13\n14	13	9	884	76	132	9269	13	1	10\n14	13	10	7	8	9	10	11	12	13	14\n14	13	10	37	65	175	6158	9	3	7	1\n14	13	11	7	8	9	10	11	12	13	15	16\n14	13	11	2	261	209	98	117023	1204	78	18	3\n14	13	12	7	8	9	10	11	12	13	14	15	16	25\n14	13	12	16	152	113	316	3847	72063	67	2	79	22	1\n14	13	13	6	8	9	10	11	12	13	14	15	16\n14	13	13	3	63	91	63	733	1118	62254	59	568	27\n14	13	14	6	9	10	11	12	13	14	15	16	20\n14	13	14	1	32	86	201	509	1400	18822	5	150	1\n14	13	15	9	10	11	12	13	14	15	16\n14	13	15	18	16	134	257	2335	249	33126	91\n14	13	16	11	12	13	14	15	16	17	19\n14	13	16	32	46	49	193	201	12899	3	1\n14	13	17	10	12	14	16	17\n14	13	17	1	1	4	1	40\n14	13	18	9	10	12	13	14	15	16	17	18	19\n14	13	18	1	4	31	1	20	19	2	1	33	1\n14	13	19	10	15	16	19\n14	13	19	1	1	1	1\n14	13	20	14	15	16	17	20\n14	13	20	7	3	684	1	594\n14	13	21	10	12	13	14	15	17	21	27\n14	13	21	2	46	50	1	10	1	71	1\n14	13	22	19	20	21	22\n14	13	22	2	1	1	2\n14	13	23	11	13	14	15	16	20	21	23\n14	13	23	1	1	1	1	1	1	2	4\n14	13	24	18	24\n14	13	24	1	1\n14	13	25	16	22	24	25\n14	13	25	1	2	1	8\n14	13	27	25	27\n14	13	27	1	2\n14	13	28	28	30\n14	13	28	4	1\n14	13	30	27	30\n14	13	30	1	1\n14	13	32	30	32\n14	13	32	2	2\n14	13	33	31\n14	13	33	1\n14	13	35	35\n14	13	35	1\n14	13	37	25	35\n14	13	37	2	1\n15	1	0	0\n15	1	0	13\n15	1	6	6	9\n15	1	6	2741	199\n15	1	7	7	8	9	10	12\n15	1	7	4120	109	79	10	7\n15	1	8	7	8	9	10	11	12	13	15\n15	1	8	8	5761	22	11	95	155	6	1\n15	1	9	6	7	8	9	10	11	12	13	14	15\n15	1	9	1	7	24	6187	51	95	76	34	12	4\n15	1	10	7	8	9	10	11	12	13	14	15\n15	1	10	1	1	49	1958	29	64	8	45	4\n15	1	11	8	9	10	11	12	13	14	15	16	20\n15	1	11	2	8	38	75545	549	127	61	21	5	1\n15	1	12	8	9	10	11	12	13	14	15	16	19	21\n15	1	12	1	4	1	2188	57835	160	166	28	52	2	49\n15	1	13	8	9	10	11	12	13	14	15	16	17	19	21	28\n15	1	13	6	6	5	154	457	46258	470	402	10	1	1	38	1\n15	1	14	11	12	13	14	15	16	18	19	20	21\n15	1	14	4	96	210	17204	86	54	2	50	2	1\n15	1	15	8	11	12	13	14	15	16	17	19	20	21	23\n15	1	15	1	57	141	1055	120	33541	79	1	30	3	90	1\n15	1	16	11	12	13	14	15	16	17	18	19	20	21	23\n15	1	16	2	11	33	189	195	9418	5	1	1	1110	183	5\n15	1	17	13	14	15	17	18	19	20	21	22\n15	1	17	7	1	4	63	4	2	6	3	2\n15	1	18	13	14	15	16	17	18	19	20	21	23	27\n15	1	18	11	5	21	7	5	218	1	1	23	1	7\n15	1	19	14	15	16	17	18	19	20	21	23	25	26\n15	1	19	2	8	1	2	2	183	4	4	4	2	1\n15	1	20	14	15	16	17	18	19	20	21	22	24	25	27	28\n15	1	20	3	1	5	4	2	7	926	4	3	1	6	1	2\n15	1	21	17	18	19	20	21	22	23	24	25	26	27	28	29\n15	1	21	1	2	1	1	579	1	8	1	2	3	2	1	1\n15	1	22	19	20	22	25	26\n15	1	22	1	2	15	4	1\n15	1	23	20	21	22	23	27\n15	1	23	2	2	1	29	1\n15	1	24	24	25	27\n15	1	24	4	1	2\n15	1	25	21	22	23	25	28	30	32\n15	1	25	1	1	6	17	3	1	1\n15	1	26	22	23	25	26	28\n15	1	26	1	1	1	8	1\n15	1	27	27\n15	1	27	13\n15	1	28	28	29	30\n15	1	28	10	1	1\n15	1	29	29	32\n15	1	29	1	2\n15	1	30	30\n15	1	30	7\n15	1	31	23	31\n15	1	31	1	7\n15	1	32	32\n15	1	32	1\n15	1	34	32\n15	1	34	1\n15	1	37	37	39\n15	1	37	2	1\n15	2	0	0\n15	2	0	13\n15	2	6	6	9\n15	2	6	2649	93\n15	2	7	7	8	9	10	12	15\n15	2	7	3918	128	47	6	36	1\n15	2	8	7	8	9	10	11	12	13\n15	2	8	9	5474	22	15	98	275	12\n15	2	9	6	7	8	9	10	11	12	13	14	15	17\n15	2	9	1	11	24	6267	42	66	85	24	20	13	1\n15	2	10	7	9	10	11	12	13	14	15	23\n15	2	10	1	35	1890	28	44	15	47	13	1\n15	2	11	8	9	10	11	12	13	14	15	16	20\n15	2	11	1	4	29	76855	910	184	128	50	3	5\n15	2	12	8	10	11	12	13	14	15	16	17	18	19	20	21\n15	2	12	1	5	1816	56727	241	248	84	123	1	1	6	5	133\n15	2	13	8	9	10	11	12	13	14	15	16	17	18	20	21\n15	2	13	9	2	3	74	448	45920	666	676	4	3	2	5	97\n15	2	14	11	12	13	14	15	16	17	18	19	20\n15	2	14	5	73	187	17727	127	56	3	1	90	9\n15	2	15	11	12	13	14	15	16	17	18	19	20	21	23\n15	2	15	26	88	875	113	32859	68	2	6	52	16	209	2\n15	2	16	11	12	13	14	15	16	17	18	20	21	23\n15	2	16	4	5	16	185	156	5724	1	1	3369	167	3\n15	2	17	13	14	15	16	17	18	19	20	22	23\n15	2	17	6	3	5	1	55	3	1	5	1	2\n15	2	18	13	14	15	16	17	18	19	20	21	22	23	27\n15	2	18	5	3	14	4	4	172	1	2	20	1	3	2\n15	2	19	12	15	17	18	19	20	21	23	25	26	32\n15	2	19	2	4	1	1	264	1	1	1	2	1	1\n15	2	20	14	16	17	19	20	21	22	23	25	37\n15	2	20	2	5	1	5	2034	1	4	1	4	1\n15	2	21	15	17	18	19	20	21	22	23	26	27	28\n15	2	21	4	1	1	1	2	954	1	5	1	4	3\n15	2	22	19	20	21	22	25\n15	2	22	1	3	1	16	3\n15	2	23	21	22	23	25	26	28\n15	2	23	4	1	47	1	1	2\n15	2	24	22	24	26	32\n15	2	24	1	3	1	1\n15	2	25	21	22	23	25	28	30\n15	2	25	1	1	2	27	1	1\n15	2	26	21	22	23	25	26\n15	2	26	1	1	1	1	9\n15	2	27	21	22	26	27\n15	2	27	1	1	1	23\n15	2	28	15	23	24	26	28\n15	2	28	1	1	1	3	12\n15	2	29	27	29\n15	2	29	2	1\n15	2	30	28	30\n15	2	30	1	8\n15	2	31	28	31\n15	2	31	1	6\n15	2	32	32\n15	2	32	5\n15	2	37	37\n15	2	37	2\n15	2	39	37\n15	2	39	1\n15	3	0	0\n15	3	0	13\n15	3	6	6\n15	3	6	2650\n15	3	7	7\n15	3	7	3939\n15	3	8	7	8	13\n15	3	8	3	5633	1\n15	3	9	6	7	8	9	10	11	13	14\n15	3	9	2	10	28	6408	18	2	1	1\n15	3	10	8	9	10	11	13\n15	3	10	3	28	1954	3	2\n15	3	11	9	10	11	12	13	15\n15	3	11	2	29	78879	29	30	3\n15	3	12	9	10	11	12	13	14	15\n15	3	12	2	2	1528	57073	63	20	5\n15	3	13	8	9	10	11	12	13	14	15\n15	3	13	1	2	1	39	447	46835	105	55\n15	3	14	11	12	13	14	15	16\n15	3	14	2	78	160	18863	20	19\n15	3	15	11	12	13	14	15	16	19\n15	3	15	2	66	767	129	32966	76	1\n15	3	16	12	13	14	15	16	18\n15	3	16	8	3	150	138	5687	2\n15	3	17	13	14	15	16	17\n15	3	17	4	1	2	4	62\n15	3	18	13	14	15	16	17	18	22\n15	3	18	10	1	19	5	1	151	1\n15	3	19	14	15	16	17	19	20	25\n15	3	19	1	21	1	1	394	1	2\n15	3	20	14	15	16	19	20	37\n15	3	20	1	1	5	5	5443	1\n15	3	21	15	16	17	19	20	21\n15	3	21	6	3	2	6	3	1570\n15	3	22	16	18	19	20	22	26\n15	3	22	2	3	1	3	18	1\n15	3	23	18	19	20	21	22	23	32\n15	3	23	1	5	2	5	1	54	1\n15	3	24	20	22	24	25\n15	3	24	1	1	1	1\n15	3	25	20	22	23	25\n15	3	25	1	1	5	31\n15	3	26	23	26\n15	3	26	2	15\n15	3	27	21	26	27	28\n15	3	27	5	2	23	1\n15	3	28	23	26	28\n15	3	28	1	3	16\n15	3	29	26\n15	3	29	1\n15	3	30	28	29	30\n15	3	30	1	1	7\n15	3	31	25	31\n15	3	31	1	5\n15	3	32	25	32\n15	3	32	1	6\n15	3	37	37\n15	3	37	4\n15	4	0	0\n15	4	0	13\n15	4	6	6\n15	4	6	2652\n15	4	7	7\n15	4	7	3952\n15	4	8	7	8	13\n15	4	8	8	5656	1\n15	4	9	6	7	8	9	10\n15	4	9	2	5	36	6380	19\n15	4	10	7	8	9	10	12\n15	4	10	1	4	33	1965	1\n15	4	11	8	9	10	11	12	13	18\n15	4	11	1	13	25	80346	48	21	1\n15	4	12	10	11	12	13	14	15	16	18\n15	4	12	4	1037	56588	50	14	6	1	1\n15	4	13	8	9	10	11	12	13	14	15	16	18\n15	4	13	2	11	1	51	462	47243	51	51	2	2\n15	4	14	11	12	13	14	15	16	18\n15	4	14	3	57	249	18932	14	16	1\n15	4	15	11	12	13	14	15	16	20\n15	4	15	5	69	651	100	32350	60	1\n15	4	16	11	12	13	14	15	16	18\n15	4	16	1	2	1	132	151	5513	2\n15	4	17	12	14	17	18\n15	4	17	2	4	57	3\n15	4	18	9	13	14	15	16	17	18\n15	4	18	1	3	2	10	1	3	137\n15	4	19	12	14	15	17	19	20	22\n15	4	19	2	1	17	1	389	1	1\n15	4	20	9	16	17	18	19	20\n15	4	20	1	1	2	2	1	5447\n15	4	21	9	14	15	17	18	19	20	21\n15	4	21	1	1	16	2	2	1	1	1556\n15	4	22	17	18	21	22\n15	4	22	3	1	1	17\n15	4	23	15	17	18	19	20	21	23\n15	4	23	1	1	1	6	1	5	47\n15	4	24	24\n15	4	24	1\n15	4	25	19	20	21	22	25\n15	4	25	7	2	1	2	24\n15	4	26	21	22	24	26\n15	4	26	2	2	1	17\n15	4	27	10	27\n15	4	27	1	22\n15	4	28	10	28\n15	4	28	1	17\n15	4	29	29\n15	4	29	1\n15	4	30	10	30\n15	4	30	1	6\n15	4	31	31\n15	4	31	5\n15	4	32	30	32\n15	4	32	1	6\n15	4	37	37\n15	4	37	5\n15	5	0	0\n15	5	0	13\n15	5	6	6\n15	5	6	2654\n15	5	7	7	9\n15	5	7	3965	1\n15	5	8	7	8	11\n15	5	8	9	5688	2\n15	5	9	6	7	8	9	10	11\n15	5	9	3	15	34	6368	14	6\n15	5	10	7	8	9	10	11	13\n15	5	10	4	3	43	1965	1	1\n15	5	11	7	8	9	10	11	12	13	14\n15	5	11	1	10	14	31	81301	48	31	7\n15	5	12	8	10	11	12	13	14	15	18	22\n15	5	12	3	3	896	56259	45	13	10	1	1\n15	5	13	7	8	9	10	11	12	13	14	15	16	18\n15	5	13	2	35	11	1	75	418	47605	33	37	1	1\n15	5	14	9	11	12	13	14	15	16	19\n15	5	14	1	10	78	191	18930	7	19	1\n15	5	15	8	9	11	12	13	14	15	16	18	19\n15	5	15	2	1	3	47	495	124	31892	49	2	1\n15	5	16	8	9	11	12	13	14	15	16	17	18\n15	5	16	16	2	2	2	6	97	159	5308	1	1\n15	5	17	8	9	10	11	12	13	15	16	17	18\n15	5	17	2	2	1	2	2	6	2	3	48	1\n15	5	18	8	11	12	13	14	15	16	18	20\n15	5	18	3	2	1	6	2	15	2	121	1\n15	5	19	8	9	11	12	13	14	15	17	18	19\n15	5	19	10	1	1	3	1	3	9	2	1	373\n15	5	20	8	9	11	12	13	14	18	19	20\n15	5	20	2	1	1	1	3	2	2	1	5440\n15	5	21	11	13	15	16	17	18	21	22	23\n15	5	21	2	6	18	1	5	1	1530	1	1\n15	5	22	8	9	11	13	14	20	22\n15	5	22	2	1	1	2	1	1	14\n15	5	23	8	11	13	15	17	18	21	23\n15	5	23	2	4	3	4	3	3	3	25\n15	5	24	24\n15	5	24	2\n15	5	25	10	11	13	17	22	25	26\n15	5	25	1	1	2	2	1	16	1\n15	5	26	16	17	20	26\n15	5	26	2	3	1	11\n15	5	27	16	19	21	27\n15	5	27	1	1	1	19\n15	5	28	8	9	13	27	28	33\n15	5	28	1	1	2	1	11	1\n15	5	29	24\n15	5	29	1\n15	5	30	21	27	30	32\n15	5	30	1	2	3	1\n15	5	31	17\n15	5	31	5\n15	5	32	32\n15	5	32	6\n15	5	37	37\n15	5	37	5\n15	6	0	0\n15	6	0	13\n15	6	6	6	7\n15	6	6	2656	1\n15	6	7	7\n15	6	7	3996\n15	6	8	7	8\n15	6	8	23	5790\n15	6	9	6	7	8	9	10	12\n15	6	9	16	38	35	6345	12	1\n15	6	10	7	8	9	10\n15	6	10	2	1	35	1978\n15	6	11	7	8	9	10	11	12	13	14	15\n15	6	11	16	9	30	41	82068	117	26	2	1\n15	6	12	7	8	9	10	11	12	13	14	15\n15	6	12	8	15	10	10	704	56044	36	16	16\n15	6	13	7	8	9	10	11	12	13	14	15	18\n15	6	13	87	5	22	3	51	401	47694	58	82	2\n15	6	14	7	9	10	11	12	13	14	15	16	17	18\n15	6	14	7	3	9	11	154	194	18788	9	34	1	2\n15	6	15	7	9	11	12	13	14	15	16	18\n15	6	15	44	3	6	83	392	171	31385	68	1\n15	6	16	11	12	13	14	15	16	17	18\n15	6	16	1	8	2	69	117	5187	1	1\n15	6	17	7	9	13	14	15	16	17\n15	6	17	1	4	9	2	16	5	32\n15	6	18	7	9	13	14	15	16	18\n15	6	18	2	1	4	4	8	6	109\n15	6	19	7	9	12	13	14	15	16	18	19\n15	6	19	26	14	60	2	189	43	1	1	41\n15	6	20	7	9	10	13	15	16	18	20	37\n15	6	20	1	3	1	4	1	5	3	5424	1\n15	6	21	7	13	14	15	16	18	19	20	21\n15	6	21	2	12	2	457	97	25	1	1	938\n15	6	22	10	15	17	20	21	22	23	26\n15	6	22	2	2	3	1	2	5	1	1\n15	6	23	9	15	16	17	23\n15	6	23	2	3	6	1	14\n15	6	24	24\n15	6	24	3\n15	6	25	9	10	20	25\n15	6	25	6	4	2	4\n15	6	26	16	19	20	22	26	28\n15	6	26	1	4	3	1	2	1\n15	6	27	18	19	21	24	27\n15	6	27	11	2	2	1	6\n15	6	28	19	20	21	22	25	27	28\n15	6	28	1	1	2	2	2	1	2\n15	6	30	20	25	30\n15	6	30	1	1	1\n15	6	32	18	20	25	32\n15	6	32	1	1	1	4\n15	6	33	37\n15	6	33	1\n15	6	37	37\n15	6	37	5\n15	7	0	0\n15	7	0	13\n15	7	6	6	9\n15	7	6	2669	3\n15	7	7	6	7	8	9\n15	7	7	25	4223	1	5\n15	7	8	6	7	8	10	13	15\n15	7	8	18	7	5827	1	1	1\n15	7	9	6	7	8	9	10	11	16\n15	7	9	25	20	36	6368	17	11	1\n15	7	10	6	8	9	10	11	12	13	19\n15	7	10	2	3	46	2002	2	3	1	1\n15	7	11	6	7	8	9	10	11	12	13\n15	7	11	20	1	3	8	54	82587	137	31\n15	7	12	6	7	8	9	10	11	12	13	14	15	16	19\n15	7	12	8	1	6	8	22	582	56134	76	23	6	1	1\n15	7	13	6	9	10	11	12	13	14	15	16\n15	7	13	89	15	2	69	384	47653	80	82	1\n15	7	14	6	8	9	10	11	12	13	14	15	16	18	20\n15	7	14	3	4	1	5	8	123	148	18955	13	32	8	1\n15	7	15	6	9	10	11	12	13	14	15	16	18	19	20\n15	7	15	44	6	1	1	32	430	121	31427	73	1	3	1\n15	7	16	6	8	10	11	12	13	14	15	16	17	18	19\n15	7	16	1	4	2	3	192	3	90	175	4937	1	1	1\n15	7	17	6	9	13	17	18	22\n15	7	17	2	10	2	22	1	1\n15	7	18	6	9	13	14	15	16	18	19	21\n15	7	18	5	9	5	3	4	3	122	2	3\n15	7	19	8	16	19\n15	7	19	1	1	47\n15	7	20	12	14	15	16	18	20	22\n15	7	20	1	2	4	15	3	5408	1\n15	7	21	6	9	12	13	14	15	16	18	21\n15	7	21	1	2	2	46	2	190	98	10	593\n15	7	22	20	22\n15	7	22	1	7\n15	7	23	6	9	15	16	23\n15	7	23	3	4	1	6	1\n15	7	24	18	24\n15	7	24	1	3\n15	7	25	22	25\n15	7	25	1	7\n15	7	26	23	26\n15	7	26	1	2\n15	7	27	13	27\n15	7	27	1	6\n15	7	28	23	27	28\n15	7	28	1	1	1\n15	7	30	30\n15	7	30	1\n15	7	32	30	32\n15	7	32	1	3\n15	7	37	20	37	39\n15	7	37	1	5	1\n15	8	0	0\n15	8	0	13\n15	8	6	6	9\n15	8	6	2904	11\n15	8	7	6	7	9\n15	8	7	203	4025	24\n15	8	8	6	7	8	9	10	11	13	18	19\n15	8	8	180	8	5679	12	1	1	1	1	2\n15	8	9	6	7	8	9	10	11	12	14\n15	8	9	343	29	64	6031	11	3	3	1\n15	8	10	6	8	9	10	11	12\n15	8	10	59	16	60	1964	2	5\n15	8	11	6	7	8	9	10	11	12	13	15\n15	8	11	384	25	25	58	805	81442	439	84	1\n15	8	12	6	7	8	9	10	11	12	13	14	15	16	17\n15	8	12	124	7	30	14	359	443	55881	102	8	37	1	2\n15	8	13	6	8	9	10	11	12	13	14	15	17\n15	8	13	1829	6	221	15	45	372	45706	75	127	1\n15	8	14	6	7	8	9	10	11	12	13	14	15	16	18\n15	8	14	67	3	113	19	144	26	161	214	18266	217	44	2\n15	8	15	6	7	8	9	10	11	12	13	14	15	16	18	20	21\n15	8	15	1120	1	28	398	21	3	16	240	136	29882	52	3	2	1\n15	8	16	6	8	9	10	11	12	13	14	15	16	18\n15	8	16	25	14	149	9	1	5	2	65	161	4730	7\n15	8	17	10	13	16	17	18\n15	8	17	1	2	1	16	3\n15	8	18	6	8	9	10	12	13	14	15	16	18	21\n15	8	18	21	23	42	1	2	19	8	3	1	25	2\n15	8	19	8	10	12	13	14	15	16	17	19\n15	8	19	6	9	1	3	1	32	1	1	1\n15	8	20	10	11	13	14	15	16	20\n15	8	20	4	8	6	10	1	10	5373\n15	8	21	6	9	13	18	21	25\n15	8	21	31	140	5	2	417	1\n15	8	22	10	11	14	18	20	21	22\n15	8	22	1	2	2	1	2	1	1\n15	8	23	23	27\n15	8	23	2	1\n15	8	24	12	20	24\n15	8	24	1	1	1\n15	8	25	13	14	17	20\n15	8	25	2	3	1	1\n15	8	26	24	25\n15	8	26	1	1\n15	8	27	13	24	25	27\n15	8	27	2	2	1	2\n15	8	28	23\n15	8	28	1\n15	8	30	30\n15	8	30	2\n15	8	32	32\n15	8	32	3\n15	8	37	37\n15	8	37	5\n15	8	39	39\n15	8	39	1\n15	9	0	0\n15	9	0	13\n15	9	6	6	9	27\n15	9	6	7257	32	1\n15	9	7	6	7	9	10\n15	9	7	64	4032	1	1\n15	9	8	6	7	8	9	10	12	14\n15	9	8	120	7	5868	3	2	3	1\n15	9	9	6	7	8	9	10	11	12	19	22\n15	9	9	132	56	55	6921	8	2	2	2	1\n15	9	10	6	7	8	9	10	11	12	13\n15	9	10	26	2	13	32	3258	2	9	3\n15	9	11	6	7	8	9	10	11	12	13	14\n15	9	11	342	39	56	20	541	80604	335	37	2\n15	9	12	6	7	8	9	10	11	12	13	14	15	16	18	28	32\n15	9	12	172	45	59	13	366	366	55714	117	6	12	2	12	1	1\n15	9	13	6	8	9	10	11	12	13	14	15	18\n15	9	13	1247	14	90	26	36	333	44457	63	121	1\n15	9	14	6	8	9	10	11	12	13	14	15	16\n15	9	14	78	96	10	29	16	35	127	18126	9	49\n15	9	15	6	8	9	10	11	12	13	14	15	16	18\n15	9	15	415	10	175	15	1	21	150	129	29478	66	1\n15	9	16	6	8	9	10	11	12	14	15	16	24\n15	9	16	26	37	97	21	5	5	46	143	4455	5\n15	9	17	13	16	17	23\n15	9	17	1	2	17	1\n15	9	18	6	8	9	11	14	15	16	18	23\n15	9	18	10	1	12	1	1	1	1	16	1\n15	9	19	13	19\n15	9	19	1	2\n15	9	20	20\n15	9	20	5379\n15	9	21	6	9	15	16	18	21	22	35\n15	9	21	4	37	4	1	1	372	1	1\n15	9	22	22\n15	9	22	1\n15	9	23	23\n15	9	23	3\n15	9	24	22	24\n15	9	24	2	2\n15	9	25	25\n15	9	25	3\n15	9	27	14	19	30\n15	9	27	1	1	1\n15	9	30	30\n15	9	30	2\n15	9	32	32\n15	9	32	3\n15	9	37	20	37\n15	9	37	1	4\n15	9	39	39\n15	9	39	1\n15	10	0	0\n15	10	0	13\n15	10	6	6	9	11	24\n15	10	6	9358	532	2	1\n15	10	7	6	7	8	9	10	11	12	13	14	18\n15	10	7	24	4099	4	26	10	2	5	1	7	3\n15	10	8	6	7	8	9	10	11	12	13\n15	10	8	17	11	6111	17	1	17	6	29\n15	10	9	6	7	8	9	10	11	12	13	14\n15	10	9	25	18	69	7306	4	7	1	12	1\n15	10	10	6	8	9	10	11	12	13	14	17	20\n15	10	10	4	6	40	4127	1	61	23	2	2	1\n15	10	11	6	7	8	9	10	11	12	13	14	15	17	23\n15	10	11	101	42	66	22	215	80288	205	30	56	1	1	6\n15	10	12	6	7	8	9	10	11	12	13	14	15	16	18	24	25\n15	10	12	67	35	30	3	118	271	55679	69	64	109	1	6	1	4\n15	10	13	6	7	8	9	10	11	12	13	14	15	16	23\n15	10	13	308	1	6	28	23	41	363	43924	52	141	1	5\n15	10	14	6	8	9	11	12	13	14	16	23	25\n15	10	14	23	16	1	20	42	116	18109	36	11	1\n15	10	15	6	8	9	10	11	12	13	14	15	16\n15	10	15	95	7	67	2	1	8	131	144	29257	56\n15	10	16	8	9	10	12	13	14	15	16	20	22	23	25\n15	10	16	6	3	4	1	1	37	131	4387	2	1	2	1\n15	10	17	10	16	17\n15	10	17	1	2	14\n15	10	18	12	14	16	18\n15	10	18	1	2	2	26\n15	10	19	16	19\n15	10	19	1	4\n15	10	20	14	18	20	23	25\n15	10	20	1	1	5376	1	1\n15	10	21	13	21\n15	10	21	1	371\n15	10	22	20	22	25\n15	10	22	1	3	1\n15	10	23	18	19	23\n15	10	23	1	1	3\n15	10	24	14	18	24	37\n15	10	24	1	2	3	1\n15	10	25	25\n15	10	25	3\n15	10	27	27\n15	10	27	1\n15	10	28	28\n15	10	28	1\n15	10	30	28	30\n15	10	30	1	2\n15	10	32	32	33	37\n15	10	32	2	1	1\n15	10	35	35\n15	10	35	1\n15	10	37	37\n15	10	37	4\n15	10	39	39\n15	10	39	1\n15	11	0	0\n15	11	0	13\n15	11	6	6	7	8	9	10	11	12	14	15\n15	11	6	9724	4	3	281	2	2	1	4	1\n15	11	7	6	7	8	9	10	11	12	13\n15	11	7	3	4014	139	20	9	19	1	1\n15	11	8	6	7	8	9	10	11	13	14\n15	11	8	3	12	6271	20	12	1	1	1\n15	11	9	6	7	8	9	10	11	12	13	14	15	16\n15	11	9	11	12	37	7952	5	12	2	10	2	1	1\n15	11	10	6	8	9	10	11	12	13	14	17	20\n15	11	10	3	11	31	4408	9	28	11	2	1	1\n15	11	11	6	7	8	9	10	11	12	13	14	15	16	18\n15	11	11	28	14	6	4	72	80331	162	12	14	2	2	3\n15	11	12	6	7	8	9	10	11	12	13	14	15	16	17	18	21	23	24\n15	11	12	18	11	12	1	45	274	55836	50	4	18	3	3	88	3	1	5\n15	11	13	6	8	9	10	11	12	13	14	15	16	18	20	24\n15	11	13	72	1	9	12	46	327	43684	36	132	1	15	1	1\n15	11	14	6	8	11	12	13	14	15	16	18\n15	11	14	9	4	7	29	133	18263	3	27	1\n15	11	15	6	9	10	11	12	13	14	15	16	18	20\n15	11	15	34	20	1	1	18	120	147	29253	41	3	1\n15	11	16	9	14	15	16	18\n15	11	16	2	33	162	4288	1\n15	11	17	13	17\n15	11	17	2	15\n15	11	18	10	16	18	21	22	24\n15	11	18	1	1	34	1	1	1\n15	11	19	11	18	19	25\n15	11	19	1	1	2	1\n15	11	20	18	20\n15	11	20	1	5379\n15	11	21	12	21\n15	11	21	3	368\n15	11	22	22\n15	11	22	4\n15	11	23	23	27\n15	11	23	27	1\n15	11	24	18	20	24\n15	11	24	1	1	3\n15	11	25	18	25	35\n15	11	25	2	8	1\n15	11	27	27\n15	11	27	1\n15	11	28	28\n15	11	28	2\n15	11	30	29	30\n15	11	30	1	1\n15	11	32	32\n15	11	32	2\n15	11	33	33\n15	11	33	1\n15	11	35	35\n15	11	35	1\n15	11	37	37\n15	11	37	6\n15	11	39	39\n15	11	39	1\n15	12	0	0\n15	12	0	13\n15	12	6	6	9	11	12\n15	12	6	9827	76	1	1\n15	12	7	7	9	10	13\n15	12	7	4058	1	6	2\n15	12	8	6	7	8	9	10\n15	12	8	1	8	6468	2	5\n15	12	9	6	7	8	9	10	11	12	13	14	19	23	29\n15	12	9	14	11	23	8270	3	7	3	3	2	1	2	1\n15	12	10	6	7	8	9	10	11	12	13	14	16	18\n15	12	10	1	1	5	29	4501	9	4	4	10	1	2\n15	12	11	6	7	8	9	10	11	12	13	14	15	16\n15	12	11	4	3	2	8	42	80115	497	22	5	4	1\n15	12	12	6	7	9	10	11	12	13	14	15	21\n15	12	12	4	6	5	13	227	56052	48	3	48	1\n15	12	13	6	7	9	10	11	12	13	14	15	16	17	18\n15	12	13	13	1	1	16	32	340	43296	32	287	2	1	3\n15	12	14	6	11	12	13	14	15	16	17	18	19\n15	12	14	2	13	40	144	18203	2	56	1	43	2\n15	12	15	6	9	12	13	14	15	16	18	19	20	21\n15	12	15	7	1	9	64	184	29246	50	3	6	1	1\n15	12	16	9	11	14	15	16	17	18\n15	12	16	1	1	19	159	4180	3	1\n15	12	17	13	14	17\n15	12	17	2	1	16\n15	12	18	12	15	16	18	22\n15	12	18	2	1	3	143	1\n15	12	19	19	26\n15	12	19	1	1\n15	12	20	18	20	22	23	24\n15	12	20	1	5379	1	1	1\n15	12	21	12	21\n15	12	21	2	370\n15	12	22	16	22\n15	12	22	1	4\n15	12	23	23\n15	12	23	28\n15	12	24	18	24\n15	12	24	1	9\n15	12	25	25\n15	12	25	9\n15	12	27	27	30\n15	12	27	1	1\n15	12	28	28\n15	12	28	2\n15	12	29	30\n15	12	29	1\n15	12	30	30\n15	12	30	1\n15	12	32	32\n15	12	32	2\n15	12	33	33\n15	12	33	1\n15	12	35	35\n15	12	35	2\n15	12	37	32	37\n15	12	37	1	5\n15	12	39	37\n15	12	39	1\n15	13	0	0\n15	13	0	13\n15	13	6	6	8	9\n15	13	6	9866	1	6\n15	13	7	7	9	10\n15	13	7	4086	1	1\n15	13	8	6	7	8	13\n15	13	8	1	405	6091	1\n15	13	9	6	7	8	9	10	11	12	13\n15	13	9	1148	100	122	7013	4	3	3	1\n15	13	10	7	8	9	10	11	12	13	14	27\n15	13	10	41	58	127	4348	4	4	1	2	1\n15	13	11	6	8	9	10	11	12	13	14	15	16\n15	13	11	5	421	180	81	79070	606	33	3	5	1\n15	13	12	7	8	9	10	11	12	13	15\n15	13	12	170	499	254	322	5143	50474	48	40\n15	13	13	6	8	9	10	11	12	13	14	15	16\n15	13	13	3	74	109	74	1010	996	40963	41	313	2\n15	13	14	6	9	10	11	12	13	14	15	16	18\n15	13	14	2	46	168	1169	1036	2181	13792	1	61	3\n15	13	15	6	9	10	11	12	13	14	15	16\n15	13	15	2	81	50	189	566	3153	415	25219	72\n15	13	16	11	12	13	14	15	16	17	18	19\n15	13	16	10	32	15	140	87	4005	1	3	1\n15	13	17	9	13	17\n15	13	17	1	1	19\n15	13	18	9	10	12	13	14	15	16	18\n15	13	18	1	15	60	18	31	5	4	63\n15	13	19	12	14	15	16	18	19\n15	13	19	1	1	3	1	1	3\n15	13	20	11	12	13	14	15	16	17	20	25\n15	13	20	27	25	25	47	76	4388	5	786	1\n15	13	21	12	13	14	16	21\n15	13	21	174	98	2	1	97\n15	13	22	18	20	22\n15	13	22	3	1	2\n15	13	23	11	13	14	15	16	18	23	24	25	28\n15	13	23	2	4	4	1	1	2	14	1	1	1\n15	13	24	12	13	18	24\n15	13	24	5	2	1	2\n15	13	25	14	16	20	25	28\n15	13	25	2	1	1	4	1\n15	13	26	26\n15	13	26	1\n15	13	27	27\n15	13	27	1\n15	13	28	24	28\n15	13	28	1	1\n15	13	29	30\n15	13	29	1\n15	13	30	28	30\n15	13	30	1	2\n15	13	32	32\n15	13	32	3\n15	13	33	33\n15	13	33	1\n15	13	35	25	35\n15	13	35	1	1\n15	13	37	16	37\n15	13	37	3	3\n15	14	0	0\n15	14	0	13\n15	14	6	6\n15	14	6	11027\n15	14	7	7	10\n15	14	7	4801	1\n15	14	8	7	8	12	13\n15	14	8	241	7020	2	3\n15	14	9	6	7	8	9	10	11	13\n15	14	9	839	48	140	6781	4	2	5\n15	14	10	7	8	9	10	11	12	13	14	30\n15	14	10	37	47	119	4848	3	3	4	1	1\n15	14	11	6	8	9	10	11	12	13	14	15	16\n15	14	11	3	183	138	57	85304	867	58	1	12	4\n15	14	12	7	8	9	10	11	12	13	14	15	16\n15	14	12	11	117	79	291	2899	50455	78	2	41	9\n15	14	13	8	9	10	11	12	13	14	15	16\n15	14	13	52	67	48	553	873	44484	49	401	17\n15	14	14	9	10	11	12	13	14	15	16	17\n15	14	14	34	61	134	355	1149	12645	1	100	1\n15	14	15	9	10	11	12	13	14	15	16	18\n15	14	15	13	24	87	257	1695	205	23429	39	1\n15	14	16	11	12	13	14	15	16	17\n15	14	16	25	49	46	147	100	8171	2\n15	14	17	11	14	15	17\n15	14	17	1	1	1	22\n15	14	18	9	10	12	13	14	15	18\n15	14	18	1	2	17	5	13	5	33\n15	14	19	15	17	19\n15	14	19	1	1	2\n15	14	20	11	12	14	15	16	17	20\n15	14	20	1	1	2	9	423	2	350\n15	14	21	12	13	17	18	21\n15	14	21	31	22	1	1	42\n15	14	22	16	18\n15	14	22	1	1\n15	14	23	13	14	16	23\n15	14	23	5	3	1	5\n15	14	24	18	24\n15	14	24	2	2\n15	14	25	14	20	25\n15	14	25	1	3	3\n15	14	26	32\n15	14	26	1\n15	14	27	28	29\n15	14	27	1	1\n15	14	28	21	22	24\n15	14	28	1	2	1\n15	14	30	26	27	30\n15	14	30	1	1	1\n15	14	32	32\n15	14	32	3\n15	14	33	30\n15	14	33	1\n15	14	35	35\n15	14	35	1\n15	14	37	35	37\n15	14	37	1	2\n16	1	0	0\n16	1	0	13\n16	1	6	6	9\n16	1	6	1746	144\n16	1	7	7	8	9	10	12\n16	1	7	3164	85	55	4	4\n16	1	8	7	8	9	10	11	12	13\n16	1	8	8	4294	15	8	68	114	9\n16	1	9	7	8	9	10	11	12	13	14	15	30\n16	1	9	10	23	4443	38	68	40	19	3	1	1\n16	1	10	8	9	10	11	12	13	14\n16	1	10	1	38	1370	22	40	11	28\n16	1	11	8	9	10	11	12	13	14	15	16\n16	1	11	2	3	19	53888	375	95	45	25	3\n16	1	12	9	10	11	12	13	14	15	16	18	19	20	21\n16	1	12	1	2	1562	40619	150	92	20	88	1	2	2	26\n16	1	13	8	9	10	11	12	13	14	15	16	17	18	21\n16	1	13	7	5	4	107	363	33320	346	355	8	2	1	16\n16	1	14	11	12	13	14	15	16	17	18	19	20\n16	1	14	4	46	160	11725	42	34	1	1	5	1\n16	1	15	8	11	12	13	14	15	16	18	19	21	22\n16	1	15	1	31	84	792	79	24163	44	2	3	58	1\n16	1	16	11	12	13	14	15	16	17	18	19	20	21	23	37\n16	1	16	4	8	22	134	144	5993	1	2	1	628	152	7	2\n16	1	17	13	14	16	17	18	21	22\n16	1	17	4	1	1	56	7	2	1\n16	1	18	13	14	15	16	17	18	20	21	22	27\n16	1	18	13	3	12	4	4	128	1	13	2	2\n16	1	19	14	15	17	18	19	20	21	23	25	28\n16	1	19	1	6	1	1	103	1	2	2	3	1\n16	1	20	18	19	20	21	22	25\n16	1	20	2	1	524	3	2	4\n16	1	21	17	19	21	22	23	25	27\n16	1	21	2	1	419	2	4	7	1\n16	1	22	20	21	22	24	25\n16	1	22	3	2	18	1	3\n16	1	23	22	23\n16	1	23	1	25\n16	1	24	20	22	24\n16	1	24	1	1	12\n16	1	25	21	23	25	28	30\n16	1	25	1	2	27	1	1\n16	1	26	26	28	31	32\n16	1	26	4	2	1	1\n16	1	27	27	28\n16	1	27	2	1\n16	1	28	23	27	28\n16	1	28	1	1	3\n16	1	29	28\n16	1	29	1\n16	1	30	26	28	30\n16	1	30	1	1	1\n16	1	31	31\n16	1	31	1\n16	1	32	32\n16	1	32	4\n16	1	34	34\n16	1	34	1\n16	1	37	37\n16	1	37	1\n16	2	0	0\n16	2	0	13\n16	2	6	6	9\n16	2	6	1677	69\n16	2	7	7	8	9	10	12	25\n16	2	7	3018	96	35	2	30	1\n16	2	8	7	8	9	10	11	12	13\n16	2	8	6	4083	16	8	85	210	5\n16	2	9	7	8	9	10	11	12	13	14	15	30\n16	2	9	9	23	4493	24	46	62	22	16	8	1\n16	2	10	9	10	11	12	13	14	15\n16	2	10	31	1317	17	35	10	32	3\n16	2	11	8	9	10	11	12	13	14	15	16	20\n16	2	11	1	5	32	54749	660	151	106	41	6	3\n16	2	12	10	11	12	13	14	15	16	19	20	21	22\n16	2	12	1	1262	39827	156	142	63	160	3	2	76	1\n16	2	13	9	10	11	12	13	14	15	16	18	20	21\n16	2	13	2	2	65	343	33117	528	470	8	1	4	55\n16	2	14	11	12	13	14	15	16	19	20	21\n16	2	14	1	42	117	12173	64	38	16	5	1\n16	2	15	11	12	13	14	15	16	18	19	20	21\n16	2	15	15	72	648	79	23759	36	1	11	7	140\n16	2	16	11	12	13	14	15	16	20	21	23\n16	2	16	1	6	9	108	109	3587	2216	129	10\n16	2	17	13	14	15	16	17	18	20	22	23\n16	2	17	5	2	2	2	46	3	2	1	4\n16	2	18	13	15	16	17	18	21	22	23	27\n16	2	18	5	8	1	2	106	20	1	1	1\n16	2	19	13	15	16	17	18	19	20	21	23	25\n16	2	19	1	6	1	1	3	96	1	2	1	4\n16	2	20	11	14	15	16	17	18	19	20	21	22	25\n16	2	20	1	1	1	1	1	2	5	1144	2	2	1\n16	2	21	15	16	17	20	21	22	23	25\n16	2	21	1	1	6	1	671	1	7	6\n16	2	22	21	22	24	25	28\n16	2	22	3	17	1	5	2\n16	2	23	20	21	22	23	25\n16	2	23	1	4	1	34	1\n16	2	24	20	22	24\n16	2	24	1	3	9\n16	2	25	23	25	32\n16	2	25	3	40	1\n16	2	26	22	23	25	26\n16	2	26	2	1	1	1\n16	2	27	21	22	27\n16	2	27	1	1	4\n16	2	28	15	26	27	28\n16	2	28	1	2	1	6\n16	2	30	30	32\n16	2	30	2	1\n16	2	31	31\n16	2	31	2\n16	2	32	30	32\n16	2	32	1	4\n16	2	34	16\n16	2	34	1\n16	2	37	37\n16	2	37	3\n16	3	0	0\n16	3	0	13\n16	3	6	6\n16	3	6	1677\n16	3	7	7\n16	3	7	3033\n16	3	8	7	8	13\n16	3	8	6	4196	1\n16	3	9	6	7	8	9	10	13\n16	3	9	1	16	21	4604	8	1\n16	3	10	7	9	10	11	13\n16	3	10	2	24	1358	1	1\n16	3	11	9	10	11	12	13	15\n16	3	11	6	21	56182	19	13	1\n16	3	12	9	10	11	12	13	14	15\n16	3	12	2	1	1116	40120	34	11	3\n16	3	13	8	10	11	12	13	14	15	16	17	21\n16	3	13	3	1	46	326	33778	57	30	1	3	1\n16	3	14	11	12	13	14	15	16\n16	3	14	5	34	130	12989	14	15\n16	3	15	11	12	13	14	15	16	18	19\n16	3	15	11	44	523	82	23820	54	1	1\n16	3	16	12	13	14	15	16	18\n16	3	16	5	4	99	71	3662	1\n16	3	17	13	14	15	16	17	18	19	21\n16	3	17	4	1	1	2	45	1	1	1\n16	3	18	13	15	16	17	18\n16	3	18	2	3	4	3	104\n16	3	19	15	18	19\n16	3	19	7	4	120\n16	3	20	18	19	20	22\n16	3	20	1	4	3381	1\n16	3	21	15	17	18	19	20	21	22	23\n16	3	21	2	4	3	1	1	1091	1	1\n16	3	22	18	19	20	21	22	24\n16	3	22	1	1	3	3	20	2\n16	3	23	16	21	23\n16	3	23	1	5	55\n16	3	24	22	24\n16	3	24	3	7\n16	3	25	23	24	25	27\n16	3	25	7	1	50	1\n16	3	26	23	26\n16	3	26	1	2\n16	3	27	27	30\n16	3	27	5	1\n16	3	28	20	25	28\n16	3	28	1	1	6\n16	3	30	30\n16	3	30	4\n16	3	31	31\n16	3	31	2\n16	3	32	32\n16	3	32	6\n16	3	37	37\n16	3	37	3\n16	4	0	0\n16	4	0	13\n16	4	6	6\n16	4	6	1678\n16	4	7	7\n16	4	7	3057\n16	4	8	7	8	15\n16	4	8	4	4215	1\n16	4	9	6	7	8	9	10\n16	4	9	2	9	27	4587	11\n16	4	10	7	8	9	10	11	14\n16	4	10	1	2	24	1360	1	1\n16	4	11	8	9	10	11	12	13	14	15\n16	4	11	2	4	25	57287	20	20	1	2\n16	4	12	9	10	11	12	13	14	15\n16	4	12	2	8	899	39575	53	9	2\n16	4	13	8	9	10	11	12	13	14	15	16	17	18	20\n16	4	13	1	11	1	27	298	34034	69	40	2	3	4	1\n16	4	14	10	11	12	13	14	15	16	17\n16	4	14	2	6	27	90	13087	12	14	1\n16	4	15	8	9	11	12	13	14	15	16	18\n16	4	15	1	1	1	41	423	72	23360	52	1\n16	4	16	9	11	12	13	14	15	16	17	22\n16	4	16	3	2	9	2	56	58	3606	2	1\n16	4	17	13	14	15	16	17\n16	4	17	3	7	1	1	43\n16	4	18	10	13	14	15	16	17	18	19	22\n16	4	18	1	3	5	19	1	4	81	1	1\n16	4	19	10	12	14	15	17	18	19\n16	4	19	1	1	1	14	1	1	109\n16	4	20	12	14	16	17	18	19	20	37\n16	4	20	4	1	2	1	4	1	3372	1\n16	4	21	12	14	15	16	17	18	19	21\n16	4	21	2	1	21	1	6	3	3	1064\n16	4	22	10	17	18	20	21	22	27\n16	4	22	1	4	2	3	3	11	1\n16	4	23	10	15	17	19	21	22	23	25	30	37\n16	4	23	1	2	1	10	6	1	40	1	1	1\n16	4	24	22	24\n16	4	24	4	6\n16	4	25	19	20	21	22	25\n16	4	25	11	6	6	7	21\n16	4	26	23\n16	4	26	2\n16	4	27	21	27	29\n16	4	27	1	4	1\n16	4	28	23	26	28	33\n16	4	28	1	1	3	1\n16	4	30	10	13	16	30\n16	4	30	1	1	1	2\n16	4	31	31\n16	4	31	2\n16	4	32	17	32	37\n16	4	32	1	4	1\n16	4	37	37\n16	4	37	3\n16	5	0	0\n16	5	0	13\n16	5	6	6	7\n16	5	6	1679	1\n16	5	7	7	8\n16	5	7	3070	1\n16	5	8	7	8	15\n16	5	8	9	4238	1\n16	5	9	6	7	8	9	10	11\n16	5	9	2	12	34	4566	15	3\n16	5	10	8	9	10	13\n16	5	10	1	25	1385	1\n16	5	11	8	9	10	11	12	13	14	16\n16	5	11	3	11	24	58150	20	12	1	2\n16	5	12	8	9	10	11	12	13	14	15\n16	5	12	3	2	1	600	39332	35	3	1\n16	5	13	8	9	10	11	12	13	14	15\n16	5	13	22	1	1	41	324	34187	29	24\n16	5	14	8	11	12	13	14	15	16	20\n16	5	14	1	6	22	168	13088	6	18	1\n16	5	15	8	11	12	13	14	15	16	18\n16	5	15	1	2	43	395	76	22973	40	2\n16	5	16	8	9	11	12	13	14	15	16	18\n16	5	16	3	1	1	6	3	58	81	3525	2\n16	5	17	11	13	14	17	18\n16	5	17	1	6	6	53	1\n16	5	18	8	9	13	15	16	18	21\n16	5	18	1	1	2	7	1	83	1\n16	5	19	8	14	15	17	18	19	20\n16	5	19	4	1	8	1	3	115	3\n16	5	20	8	12	14	16	17	18	20	22\n16	5	20	1	2	1	1	1	1	3374	1\n16	5	21	8	13	15	16	17	18	21\n16	5	21	1	1	8	3	2	4	1061\n16	5	22	21	22	25\n16	5	22	2	22	1\n16	5	23	8	9	11	15	18	23\n16	5	23	1	1	1	1	2	37\n16	5	24	24\n16	5	24	6\n16	5	25	8	17	23	25\n16	5	25	1	1	1	19\n16	5	26	26\n16	5	26	1\n16	5	27	21	26	27\n16	5	27	1	1	3\n16	5	28	20	28\n16	5	28	1	2\n16	5	29	29\n16	5	29	1\n16	5	30	30	32\n16	5	30	2	1\n16	5	31	13	17\n16	5	31	1	1\n16	5	32	32\n16	5	32	4\n16	5	33	35\n16	5	33	1\n16	5	37	20	37\n16	5	37	1	5\n16	6	0	0\n16	6	0	13\n16	6	6	6	7\n16	6	6	1679	2\n16	6	7	7\n16	6	7	3092\n16	6	8	7	8\n16	6	8	16	4300\n16	6	9	6	7	8	9	10	11\n16	6	9	5	39	22	4534	7	1\n16	6	10	7	8	9	10	11	13\n16	6	10	11	3	25	1385	1	1\n16	6	11	7	8	9	10	11	12	13	14	15	16	18\n16	6	11	35	1	19	26	58649	28	26	16	2	2	1\n16	6	12	7	8	9	10	11	12	13	14	15	16	18\n16	6	12	8	1	4	11	512	39163	27	8	12	2	1\n16	6	13	7	9	10	11	12	13	14	15\n16	6	13	150	35	2	40	244	34265	37	38\n16	6	14	7	10	11	12	13	14	15	16	18	21\n16	6	14	4	3	15	52	127	13028	11	19	3	1\n16	6	15	7	9	11	12	13	14	15	16	18\n16	6	15	65	8	4	42	300	77	22578	35	1\n16	6	16	7	9	10	11	12	14	15	16	18\n16	6	16	2	4	1	1	12	60	75	3434	1\n16	6	17	7	9	10	13	14	15	16	17	18	21\n16	6	17	6	10	1	7	2	10	2	16	3	2\n16	6	18	7	9	10	13	14	15	16	18	21\n16	6	18	12	4	1	6	2	7	2	63	1\n16	6	19	7	9	10	12	14	15	17	19\n16	6	19	36	15	5	10	27	12	1	9\n16	6	20	7	9	10	16	18	20	37\n16	6	20	10	4	3	1	1	3360	1\n16	6	21	7	9	13	15	16	18	20	21	22\n16	6	21	6	4	9	119	18	9	2	897	1\n16	6	22	9	10	15	16	20	21	22	25\n16	6	22	1	10	3	1	1	1	4	2\n16	6	23	9	16	23\n16	6	23	1	4	33\n16	6	24	15	20	24	25	27\n16	6	24	1	1	1	1	2\n16	6	25	7	9	10	25\n16	6	25	1	4	13	2\n16	6	26	20	26\n16	6	26	1	1\n16	6	27	18	21\n16	6	27	2	1\n16	6	28	19	28\n16	6	28	1	1\n16	6	29	30\n16	6	29	1\n16	6	30	20	32\n16	6	30	1	1\n16	6	32	20	32	33\n16	6	32	1	3	1\n16	6	35	35\n16	6	35	1\n16	6	37	37\n16	6	37	5\n16	7	0	0\n16	7	0	13\n16	7	6	6\n16	7	6	1684\n16	7	7	6	7	8\n16	7	7	2	3491	2\n16	7	8	6	7	8	9\n16	7	8	2	5	4319	1\n16	7	9	6	7	8	9	10	11	15\n16	7	9	16	20	24	4598	12	1	1\n16	7	10	7	9	10	23\n16	7	10	2	28	1437	1\n16	7	11	6	8	9	10	11	12	13	14	15\n16	7	11	16	8	19	28	59076	53	18	4	1\n16	7	12	6	7	8	9	10	11	12	13	14	15	19\n16	7	12	1	1	13	7	10	421	39028	55	8	6	1\n16	7	13	6	9	10	11	12	13	14	15\n16	7	13	31	8	1	39	276	34339	33	41\n16	7	14	6	10	11	12	13	14	15	16	17\n16	7	14	2	3	9	53	117	13045	8	19	1\n16	7	15	6	9	11	12	13	14	15	16\n16	7	15	14	2	4	25	373	82	22327	41\n16	7	16	6	11	12	13	14	15	16	21\n16	7	16	1	4	296	3	62	82	3071	1\n16	7	17	9	12	13	14	15	17	37\n16	7	17	3	1	2	1	1	8	1\n16	7	18	6	9	13	14	15	16	18	23\n16	7	18	7	3	2	2	4	1	65	1\n16	7	19	14	19\n16	7	19	1	9\n16	7	20	8	15	16	19	20	27\n16	7	20	1	1	7	1	3356	1\n16	7	21	12	13	14	15	16	18	20	21\n16	7	21	2	65	3	321	137	24	1	350\n16	7	22	15	20	22\n16	7	22	1	1	3\n16	7	23	6	9	15	16	17	20	23\n16	7	23	1	2	5	21	1	1	2\n16	7	24	24\n16	7	24	1\n16	7	25	15	22	25\n16	7	25	1	1	3\n16	7	26	21\n16	7	26	1\n16	7	27	27\n16	7	27	2\n16	7	28	28\n16	7	28	1\n16	7	30	30\n16	7	30	1\n16	7	32	32\n16	7	32	4\n16	7	33	33\n16	7	33	1\n16	7	35	33\n16	7	35	1\n16	7	37	16	18	20	37\n16	7	37	1	1	1	3\n16	8	0	0\n16	8	0	13\n16	8	6	6	9\n16	8	6	1765	12\n16	8	7	6	7	9	10	22\n16	8	7	74	3411	31	2	1\n16	8	8	6	7	8	9	11	13	18\n16	8	8	69	4	4286	5	1	1	1\n16	8	9	6	7	8	9	10	11	12	13	14\n16	8	9	121	18	32	4476	12	5	1	1	5\n16	8	10	6	7	8	9	10	11	12	13	16	17	18\n16	8	10	17	4	8	44	1400	4	8	1	1	1	3\n16	8	11	6	7	8	9	10	11	12	13	15	16\n16	8	11	121	5	5	29	254	58944	153	41	1	1\n16	8	12	6	7	8	9	10	11	12	13	14	15	18\n16	8	12	26	2	13	7	99	350	39163	55	7	11	1\n16	8	13	6	9	10	11	12	13	14	15\n16	8	13	525	61	3	43	315	33903	65	59\n16	8	14	6	8	9	10	11	12	13	14	15	16	18\n16	8	14	17	32	10	46	11	86	148	12857	3	24	7\n16	8	15	6	8	9	10	11	12	13	14	15	16	18	21\n16	8	15	290	3	83	7	1	16	246	91	22012	43	7	1\n16	8	16	6	8	9	10	11	12	13	14	15	16\n16	8	16	6	4	41	3	1	3	4	47	112	3077\n16	8	17	11	13	17\n16	8	17	1	2	7\n16	8	18	6	8	9	12	13	15	16	18	21\n16	8	18	6	5	10	3	9	2	1	51	3\n16	8	19	8	10	13	19\n16	8	19	1	2	7	1\n16	8	20	10	13	14	15	16	17	20\n16	8	20	2	2	10	2	23	2	3319\n16	8	21	6	9	13	16	18	21\n16	8	21	12	39	5	1	1	294\n16	8	22	12	14	18	22\n16	8	22	1	1	1	1\n16	8	23	13	23\n16	8	23	1	3\n16	8	24	16\n16	8	24	1\n16	8	25	18	19	25\n16	8	25	1	1	1\n16	8	27	26	27\n16	8	27	1	2\n16	8	28	13\n16	8	28	1\n16	8	30	32\n16	8	30	1\n16	8	32	32\n16	8	32	4\n16	8	33	33\n16	8	33	2\n16	8	37	27	37\n16	8	37	1	3\n16	9	0	0\n16	9	0	13\n16	9	6	6	9	27\n16	9	6	3042	6	1\n16	9	7	6	7	9\n16	9	7	152	3285	7\n16	9	8	6	7	8	9	10	12	14	18\n16	9	8	170	14	4193	5	2	1	2	2\n16	9	9	6	7	8	9	10	11	18	23	32\n16	9	9	257	56	43	4481	7	1	1	1	1\n16	9	10	6	7	8	9	10	11	12\n16	9	10	44	4	15	42	1717	4	4\n16	9	11	6	7	8	9	10	11	12	13	15	16\n16	9	11	388	43	42	35	790	57663	351	47	1	1\n16	9	12	6	7	8	9	10	11	12	13	14	15	18\n16	9	12	161	33	58	17	515	234	38542	166	4	7	12\n16	9	13	6	8	9	10	11	12	13	14	15	18	20	21\n16	9	13	2011	6	176	16	30	271	31795	49	70	1	1	1\n16	9	14	6	8	9	10	11	12	13	14	15	16\n16	9	14	77	130	12	41	23	36	89	12652	1	22\n16	9	15	6	8	9	10	11	12	13	14	15	16	18\n16	9	15	632	12	262	12	3	13	141	95	20995	36	1\n16	9	16	6	8	9	10	11	12	13	14	15	16	18\n16	9	16	29	57	146	29	13	18	7	31	99	2742	1\n16	9	17	14	17\n16	9	17	1	9\n16	9	18	6	8	9	10	14	15	17	18\n16	9	18	16	2	24	1	8	10	1	11\n16	9	19	12	19\n16	9	19	1	1\n16	9	20	12	14	16	17	18	20\n16	9	20	1	3	5	1	1	3308\n16	9	21	6	9	10	11	12	14	15	18	21\n16	9	21	13	80	1	1	1	1	5	3	193\n16	9	22	18	24\n16	9	22	1	1\n16	9	23	11	23\n16	9	23	1	2\n16	9	25	24\n16	9	25	1\n16	9	26	20\n16	9	26	1\n16	9	27	27	28\n16	9	27	2	1\n16	9	32	32\n16	9	32	5\n16	9	33	33\n16	9	33	2\n16	9	37	37\n16	9	37	3\n16	10	0	0\n16	10	0	13\n16	10	6	6	9	18	20\n16	10	6	6833	157	1	1\n16	10	7	6	7	8	9	10	11\n16	10	7	31	3395	1	5	2	1\n16	10	8	6	7	8	9	10	11	12	13\n16	10	8	46	12	4481	5	1	6	1	6\n16	10	9	6	7	8	9	10	11	13	23\n16	10	9	63	13	52	5158	4	1	1	1\n16	10	10	6	7	8	9	10	12	13\n16	10	10	8	3	8	26	3060	19	7\n16	10	11	6	7	8	9	10	11	12	13	14	15	18	23\n16	10	11	207	54	51	11	401	56996	215	34	1	1	1	1\n16	10	12	6	7	8	9	10	11	12	13	15	16	18	24\n16	10	12	118	26	36	5	221	162	38590	69	5	1	5	1\n16	10	13	6	7	8	9	10	11	12	13	14	15	16	18\n16	10	13	650	2	9	37	15	20	275	31125	45	65	1	1\n16	10	14	6	8	9	10	11	12	13	14	15	16	18	23\n16	10	14	43	61	11	19	7	19	78	12589	1	11	3	4\n16	10	15	6	8	9	10	11	12	13	14	15	16	18	19\n16	10	15	219	6	146	8	1	5	87	129	20568	17	1	1\n16	10	16	8	9	10	11	12	14	15	16	23\n16	10	16	23	9	5	1	2	20	97	2647	2\n16	10	17	17	22	24\n16	10	17	9	1	1\n16	10	18	12	13	14	16	18\n16	10	18	1	1	2	1	29\n16	10	19	19\n16	10	19	1\n16	10	20	16	18	20\n16	10	20	1	2	3307\n16	10	21	20	21	28\n16	10	21	1	192	1\n16	10	23	23\n16	10	23	3\n16	10	24	24\n16	10	24	2\n16	10	27	21	27\n16	10	27	1	2\n16	10	28	27\n16	10	28	1\n16	10	32	32\n16	10	32	6\n16	10	33	31	33\n16	10	33	1	1\n16	10	37	37\n16	10	37	3\n16	11	0	0\n16	11	0	13\n16	11	6	6	7	8	9	10	12	14	18	23\n16	11	6	7764	2	2	443	1	2	2	1	1\n16	11	7	6	7	8	9	10	11	13\n16	11	7	8	3132	193	59	6	87	20\n16	11	8	6	7	8	9	10	12	13\n16	11	8	25	25	4631	32	12	1	2\n16	11	9	6	7	8	9	10	11	13	17\n16	11	9	22	10	66	5419	4	36	12	1\n16	11	10	6	7	8	9	10	11	12	13	14	17	23\n16	11	10	2	2	6	24	3645	7	30	9	1	9	1\n16	11	11	6	7	8	9	10	11	12	13	14	15	18\n16	11	11	66	36	24	5	128	56718	126	17	67	7	1\n16	11	12	6	7	8	9	10	11	12	13	14	15	16	18	25\n16	11	12	23	15	15	3	97	173	38687	64	32	10	1	4	3\n16	11	13	6	8	9	10	11	12	13	14	15	16	18	20\n16	11	13	191	5	11	7	23	282	30785	29	69	3	1	2\n16	11	14	6	8	9	10	11	12	13	14	15	16	18\n16	11	14	16	10	2	1	28	33	93	12582	1	19	1\n16	11	15	6	8	9	10	11	12	13	14	15	16	18	20	21	22	26\n16	11	15	57	3	44	2	4	15	84	116	20387	19	1	2	1	1	1\n16	11	16	8	10	14	15	16\n16	11	16	3	3	21	83	2569\n16	11	17	13	17\n16	11	17	1	8\n16	11	18	14	15	17	18	19\n16	11	18	4	1	1	36	1\n16	11	19	19\n16	11	19	2\n16	11	20	8	20	28\n16	11	20	1	3307	1\n16	11	21	21	22\n16	11	21	192	1\n16	11	22	22\n16	11	22	1\n16	11	23	19	21	23\n16	11	23	2	1	8\n16	11	24	20	22	24\n16	11	24	1	1	2\n16	11	27	24	27\n16	11	27	1	2\n16	11	28	28\n16	11	28	1\n16	11	31	31\n16	11	31	1\n16	11	32	32\n16	11	32	6\n16	11	33	33\n16	11	33	1\n16	11	37	37\n16	11	37	3\n16	12	0	0\n16	12	0	13\n16	12	6	6	7	8	9	11	13	15\n16	12	6	7971	6	28	159	8	1	1\n16	12	7	6	7	8	9	10	13\n16	12	7	3	3208	1	1	8	1\n16	12	8	6	7	8	9	10	13\n16	12	8	1	5	4932	11	9	1\n16	12	9	6	7	8	9	10	11	12	13	14	15	18\n16	12	9	11	14	31	5970	1	6	2	1	3	1	2\n16	12	10	8	9	10	11	12	13	18\n16	12	10	6	31	3836	8	16	7	2\n16	12	11	6	7	8	9	10	11	12	13	14	15	16\n16	12	11	25	8	14	7	48	56658	288	11	12	3	2\n16	12	12	6	7	8	10	11	12	13	14	15	16	17	18	21	24\n16	12	12	13	7	7	32	138	38859	56	2	7	3	5	41	2	4\n16	12	13	6	8	9	10	11	12	13	14	15	18	24\n16	12	13	51	1	2	11	36	225	30593	20	137	10	1\n16	12	14	6	8	9	11	12	13	14	15	16	18\n16	12	14	8	1	2	3	13	108	12687	3	28	1\n16	12	15	6	9	10	12	13	14	15	16\n16	12	15	26	7	1	3	46	129	20316	30\n16	12	16	8	9	11	13	14	15	16	18\n16	12	16	2	1	1	1	17	80	2508	1\n16	12	17	13	17\n16	12	17	1	18\n16	12	18	13	14	16	17	18	19	22	24\n16	12	18	1	2	3	2	33	2	1	1\n16	12	19	19	20	23\n16	12	19	3	1	1\n16	12	20	18	20\n16	12	20	2	3310\n16	12	21	12	13	20	21\n16	12	21	1	1	1	191\n16	12	22	19	20	22\n16	12	22	1	1	2\n16	12	23	20	23	26\n16	12	23	1	8	1\n16	12	24	22	24\n16	12	24	1	2\n16	12	25	15	18	25\n16	12	25	1	1	1\n16	12	26	26\n16	12	26	1\n16	12	27	22	27\n16	12	27	1	1\n16	12	28	26	28\n16	12	28	1	1\n16	12	31	23\n16	12	31	1\n16	12	32	32\n16	12	32	6\n16	12	33	35\n16	12	33	1\n16	12	37	20	37\n16	12	37	1	2\n16	13	0	0\n16	13	0	13\n16	13	6	6	7	9	11	13	18\n16	13	6	8050	1	54	2	1	1\n16	13	7	6	7	8	9	10\n16	13	7	1	3236	1	5	5\n16	13	8	6	7	8	9	10	11	12	13\n16	13	8	1	4	5008	1	5	1	2	1\n16	13	9	6	7	8	9	10	11	12	23\n16	13	9	4	8	32	6123	1	20	2	1\n16	13	10	7	8	9	10	11	12	14	18\n16	13	10	1	4	25	3905	2	2	6	1\n16	13	11	6	7	8	9	10	11	12	13	14	15	17\n16	13	11	8	3	3	4	25	56438	356	13	5	2	1\n16	13	12	6	7	9	10	11	12	13	14	15	16	17	18\n16	13	12	3	2	1	18	159	39149	54	1	15	2	2	1\n16	13	13	6	9	10	11	12	13	14	15	18\n16	13	13	12	1	7	24	242	30348	34	160	1\n16	13	14	6	9	11	12	13	14	15	16	17	18	19	21	24\n16	13	14	3	5	5	27	98	12650	2	30	2	47	1	1	1\n16	13	15	6	9	11	12	13	14	15	16	19	21	22	24\n16	13	15	3	5	1	2	63	139	20291	40	2	1	1	1\n16	13	16	10	14	15	16	18	20	21\n16	13	16	1	12	92	2465	2	1	1\n16	13	17	11	12	13	14	17\n16	13	17	1	1	3	1	19\n16	13	18	11	12	18	19	21	22	24\n16	13	18	1	1	84	2	2	2	1\n16	13	19	15	19	21\n16	13	19	2	2	2\n16	13	20	20	22	25\n16	13	20	3309	5	1\n16	13	21	12	13	18	21\n16	13	21	2	1	1	189\n16	13	22	21	22\n16	13	22	2	3\n16	13	23	23\n16	13	23	10\n16	13	24	15	18	24\n16	13	24	1	2	5\n16	13	25	18\n16	13	25	1\n16	13	26	22	26	29\n16	13	26	1	1	1\n16	13	27	27\n16	13	27	1\n16	13	28	28\n16	13	28	1\n16	13	32	26	32\n16	13	32	1	5\n16	13	35	35\n16	13	35	1\n16	13	37	20	37\n16	13	37	1	1\n16	14	0	0\n16	14	0	13\n16	14	6	6	9	11	19\n16	14	6	8074	8	2	1\n16	14	7	7\n16	14	7	3255\n16	14	8	7	8	10	13\n16	14	8	311	4734	1	2\n16	14	9	6	7	8	9	10	11	12\n16	14	9	876	71	89	5182	3	2	1\n16	14	10	7	8	9	10	11	12	13\n16	14	10	46	60	64	3787	6	2	2\n16	14	11	6	8	9	10	11	12	13	15	16\n16	14	11	3	354	154	50	55685	377	27	2	2\n16	14	12	6	7	8	9	10	11	12	13	14	15	16\n16	14	12	1	141	395	188	234	3973	34780	56	2	15	1\n16	14	13	6	8	9	10	11	12	13	14	15	16	17\n16	14	13	4	46	89	64	780	755	28622	19	198	3	2\n16	14	14	6	9	10	11	12	13	14	15	16	18\n16	14	14	2	43	113	950	825	1671	9199	4	36	5\n16	14	15	9	10	11	12	13	14	15	16	17	19\n16	14	15	46	27	146	407	2344	252	17312	29	1	1\n16	14	16	10	11	12	13	14	15	16	19	20\n16	14	16	1	10	18	9	69	83	2345	1	1\n16	14	17	9	10	11	14	15	17	18	21\n16	14	17	1	1	1	2	1	16	1	1\n16	14	18	10	11	12	13	14	15	17	18	24\n16	14	18	12	2	26	11	41	1	1	46	1\n16	14	19	13	15	16	19\n16	14	19	1	4	1	1\n16	14	20	11	12	13	14	15	16	17	20\n16	14	20	17	13	25	41	45	2741	1	428\n16	14	21	12	13	14	16	18	21\n16	14	21	104	59	1	2	4	28\n16	14	22	12	13	15	16	18	19	20	22	25\n16	14	22	1	2	1	1	3	1	1	1	1\n16	14	23	14	16	17	19	23	24\n16	14	23	2	1	1	1	5	1\n16	14	24	12	14	15	18	25\n16	14	24	4	1	1	1	1\n16	14	25	20\n16	14	25	1\n16	14	26	22	24\n16	14	26	1	1\n16	14	27	28\n16	14	27	1\n16	14	28	28\n16	14	28	1\n16	14	29	27\n16	14	29	1\n16	14	32	30	32\n16	14	32	1	4\n16	14	35	35\n16	14	35	1\n16	14	37	37\n16	14	37	1\n16	15	0	0\n16	15	0	13\n16	15	6	6\n16	15	6	8960\n16	15	7	7	10\n16	15	7	3823	1\n16	15	8	7	8	13\n16	15	8	178	5496	4\n16	15	9	6	7	8	9	10	13\n16	15	9	660	45	103	4957	6	4\n16	15	10	7	8	9	10	11	13\n16	15	10	27	34	92	4136	2	2\n16	15	11	6	7	8	9	10	11	12	13	15	16\n16	15	11	1	1	197	156	49	60612	507	38	9	4\n16	15	12	7	8	9	10	11	12	13	15	16\n16	15	12	11	85	60	208	2299	34558	59	24	9\n16	15	13	6	8	9	10	11	12	13	14	15	16\n16	15	13	1	37	50	47	465	685	31270	33	231	12\n16	15	14	9	10	11	12	13	14	15	16	18	20\n16	15	14	18	43	125	249	891	8251	2	48	1	1\n16	15	15	9	10	11	12	13	14	15	16\n16	15	15	15	7	62	135	1179	129	16113	27\n16	15	16	11	12	13	14	15	16\n16	15	16	22	28	28	84	61	4939\n16	15	17	11	13	14	16	17	18\n16	15	17	1	1	3	1	15	1\n16	15	18	9	10	12	13	14	15	16	17	18	20\n16	15	18	1	1	13	4	7	3	2	1	27	1\n16	15	19	11	12	16	19\n16	15	19	1	1	1	3\n16	15	20	14	15	16	19	20\n16	15	20	3	3	249	1	175\n16	15	21	12	13	15	17	21\n16	15	21	7	5	1	1	15\n16	15	22	18	21\n16	15	22	1	1\n16	15	23	14	23\n16	15	23	2	3\n16	15	24	13	24\n16	15	24	1	2\n16	15	25	25\n16	15	25	2\n16	15	27	27\n16	15	27	1\n16	15	28	28\n16	15	28	2\n16	15	30	30\n16	15	30	1\n16	15	32	30	32\n16	15	32	2	2\n16	15	35	32\n16	15	35	1\n16	15	37	37\n16	15	37	1\n17	1	0	0\n17	1	0	11\n17	1	6	6	9\n17	1	6	1247	76\n17	1	7	7	8	9	10	12\n17	1	7	2254	61	62	4	5\n17	1	8	7	8	9	10	11	12	13\n17	1	8	6	3333	18	4	44	88	12\n17	1	9	7	8	9	10	11	12	13	14	15\n17	1	9	11	11	3209	22	55	34	17	6	3\n17	1	10	7	9	10	11	12	13	14	15	32\n17	1	10	1	24	954	15	26	6	15	4	1\n17	1	11	8	9	10	11	12	13	14	15	16\n17	1	11	2	6	21	38109	293	62	26	9	1\n17	1	12	8	9	10	11	12	13	14	15	16	17	21\n17	1	12	1	3	4	1049	28586	105	60	9	60	1	15\n17	1	13	8	9	10	11	12	13	14	15	16	18	21\n17	1	13	3	5	3	92	256	24128	259	244	4	3	11\n17	1	14	11	12	13	14	15	16	17	19\n17	1	14	4	16	118	8417	24	20	2	2\n17	1	15	11	12	13	14	15	16	17	18	19	20	21\n17	1	15	22	62	583	55	17632	24	1	3	1	1	38\n17	1	16	11	12	13	14	15	16	17	18	20	21	23\n17	1	16	2	10	13	72	78	3718	1	1	406	112	3\n17	1	17	13	14	15	17	18	19	20	21	23\n17	1	17	2	1	1	49	3	1	2	2	1\n17	1	18	13	15	16	17	18	19	21	23\n17	1	18	7	8	1	2	103	2	20	4\n17	1	19	15	17	19	21	22	23	25\n17	1	19	1	1	34	2	1	2	2\n17	1	20	16	18	19	20	21\n17	1	20	3	1	1	327	1\n17	1	21	15	21	22	23	25	37\n17	1	21	1	253	1	3	3	1\n17	1	22	18	20	21	22	25\n17	1	22	2	1	1	5	3\n17	1	23	19	21	23\n17	1	23	1	1	31\n17	1	24	24\n17	1	24	8\n17	1	25	22	25	26\n17	1	25	1	14	1\n17	1	26	25	26	31\n17	1	26	1	1	1\n17	1	27	27\n17	1	27	1\n17	1	28	28\n17	1	28	7\n17	1	29	29	30\n17	1	29	1	1\n17	1	30	30\n17	1	30	1\n17	1	31	25	31\n17	1	31	1	1\n17	1	32	32\n17	1	32	3\n17	2	0	0\n17	2	0	11\n17	2	6	6	9	25\n17	2	6	1208	38	1\n17	2	7	7	8	9	10	12\n17	2	7	2126	78	37	2	29\n17	2	8	7	8	9	10	11	12	13\n17	2	8	6	3149	12	4	71	164	5\n17	2	9	6	7	8	9	10	11	12	13	14	15\n17	2	9	2	8	23	3228	28	33	43	20	13	5\n17	2	10	9	10	11	12	13	14	15	18	32\n17	2	10	15	918	13	21	12	25	6	1	1\n17	2	11	8	9	10	11	12	13	14	15	16	20	21	30\n17	2	11	2	4	21	38670	463	114	82	28	4	2	1	1\n17	2	12	9	10	11	12	13	14	15	16	19	21\n17	2	12	2	1	906	28058	124	117	35	90	1	42\n17	2	13	9	10	11	12	13	14	15	16	18	20	21\n17	2	13	1	1	40	297	23972	352	351	3	1	6	29\n17	2	14	11	12	13	14	15	16	17	19	20	21\n17	2	14	1	12	97	8741	35	20	1	2	1	1\n17	2	15	11	12	13	14	15	16	18	19	20	21	23\n17	2	15	13	50	443	60	17339	25	3	2	5	73	1\n17	2	16	13	14	15	16	18	20	21	23	37\n17	2	16	2	70	59	2211	1	1396	90	1	1\n17	2	17	9	13	15	16	17	21	23	37\n17	2	17	1	3	3	1	43	3	2	1\n17	2	18	13	15	17	18	19	21	23\n17	2	18	7	6	1	82	2	13	5\n17	2	19	15	18	19	21	23	25\n17	2	19	2	2	33	2	1	2\n17	2	20	19	20	21	22	25	28	37\n17	2	20	1	729	1	1	3	1	1\n17	2	21	15	17	18	21	23	25\n17	2	21	2	1	1	445	4	3\n17	2	22	15	19	22	25\n17	2	22	1	1	5	1\n17	2	23	21	23	28\n17	2	23	3	40	1\n17	2	24	22	24\n17	2	24	1	7\n17	2	25	23	25	31\n17	2	25	2	21	1\n17	2	26	26	31\n17	2	26	1	1\n17	2	27	21\n17	2	27	1\n17	2	28	26	28	30\n17	2	28	1	5	1\n17	2	29	29\n17	2	29	1\n17	2	30	27	29\n17	2	30	1	1\n17	2	31	25	31\n17	2	31	1	1\n17	2	32	31	32\n17	2	32	1	3\n17	2	37	37\n17	2	37	1\n17	3	0	0\n17	3	0	11\n17	3	6	6\n17	3	6	1210\n17	3	7	7	26\n17	3	7	2139	1\n17	3	8	7	8	13\n17	3	8	3	3246	3\n17	3	9	6	7	8	9	10	13\n17	3	9	1	5	20	3304	7	1\n17	3	10	7	9	10	11	19\n17	3	10	1	16	956	1	1\n17	3	11	8	9	10	11	12	13\n17	3	11	1	4	12	39680	31	19\n17	3	12	11	12	13	14	15	16\n17	3	12	779	28308	43	5	1	1\n17	3	13	8	9	10	11	12	13	14	15	16	17\n17	3	13	1	1	2	39	253	24433	50	18	1	1\n17	3	14	11	12	13	14	15	16\n17	3	14	1	14	85	9341	7	12\n17	3	15	11	12	13	14	15	16\n17	3	15	5	40	400	39	17353	35\n17	3	16	12	13	14	15	16	18\n17	3	16	4	1	61	40	2247	1\n17	3	17	13	15	16	17\n17	3	17	3	3	3	37\n17	3	18	13	14	15	16	18	19\n17	3	18	3	1	3	1	81	2\n17	3	19	15	16	18	19\n17	3	19	5	1	2	34\n17	3	20	15	16	17	18	19	20\n17	3	20	1	1	1	2	1	2133\n17	3	21	15	16	17	19	20	21\n17	3	21	1	1	1	1	1	699\n17	3	22	20	21	22\n17	3	22	2	3	2\n17	3	23	18	20	21	23\n17	3	23	1	1	3	51\n17	3	24	22	24\n17	3	24	1	6\n17	3	25	21	22	23	25	27\n17	3	25	1	1	6	23	1\n17	3	26	26\n17	3	26	2\n17	3	27	27\n17	3	27	1\n17	3	28	25	28	31\n17	3	28	2	4	1\n17	3	29	28	29\n17	3	29	1	1\n17	3	30	30\n17	3	30	2\n17	3	31	25	28	31	33\n17	3	31	1	1	1	1\n17	3	32	32\n17	3	32	4\n17	3	37	37\n17	3	37	4\n17	4	0	0\n17	4	0	11\n17	4	6	6\n17	4	6	1211\n17	4	7	7\n17	4	7	2148\n17	4	8	7	8\n17	4	8	4	3264\n17	4	9	6	7	8	9	10	11\n17	4	9	2	5	16	3293	8	1\n17	4	10	9	10	11	12\n17	4	10	12	963	1	1\n17	4	11	9	10	11	12	13	15\n17	4	11	7	13	40447	20	17	1\n17	4	12	9	10	11	12	13	14	15\n17	4	12	2	2	636	27977	27	3	3\n17	4	13	8	9	11	12	13	14	15	18\n17	4	13	1	3	17	214	24673	57	25	1\n17	4	14	11	12	13	14	15	16\n17	4	14	1	17	70	9396	4	9\n17	4	15	12	13	14	15	16	17	18	19\n17	4	15	29	296	47	17017	40	1	1	1\n17	4	16	12	13	14	15	16\n17	4	16	4	1	42	36	2220\n17	4	17	13	14	15	16	17	18\n17	4	17	1	1	2	3	31	2\n17	4	18	10	13	14	15	16	17	18\n17	4	18	1	1	4	10	6	3	62\n17	4	19	12	15	18	19	30\n17	4	19	1	5	4	28	1\n17	4	20	16	19	20\n17	4	20	1	1	2135\n17	4	21	9	14	15	16	17	18	19	20	21\n17	4	21	3	3	9	1	1	2	1	1	685\n17	4	22	18	21	22\n17	4	22	1	1	2\n17	4	23	18	19	21	23\n17	4	23	4	5	4	44\n17	4	24	22	24\n17	4	24	1	5\n17	4	25	19	20	21	23	25	26\n17	4	25	3	3	4	2	13	1\n17	4	26	21	26	30\n17	4	26	1	1	1\n17	4	27	22	27\n17	4	27	1	1\n17	4	28	22	26	28\n17	4	28	2	1	3\n17	4	29	29\n17	4	29	1\n17	4	30	28	32\n17	4	30	1	1\n17	4	31	31\n17	4	31	2\n17	4	32	19	32\n17	4	32	1	3\n17	4	33	33\n17	4	33	1\n17	4	37	37\n17	4	37	4\n17	5	0	0\n17	5	0	11\n17	5	6	6	9\n17	5	6	1212	1\n17	5	7	7\n17	5	7	2157\n17	5	8	7	8	13\n17	5	8	2	3278	1\n17	5	9	7	8	9	10	11\n17	5	9	8	16	3277	16	3\n17	5	10	8	9	10\n17	5	10	3	13	971\n17	5	11	9	10	11	12	13	18\n17	5	11	5	8	41052	23	14	1\n17	5	12	8	11	12	13	14	15	18\n17	5	12	4	495	27717	40	4	2	1\n17	5	13	8	9	10	11	12	13	14	15	18\n17	5	13	16	2	1	29	195	24754	57	31	1\n17	5	14	11	12	13	14	15	16	18	20\n17	5	14	1	24	58	9449	2	17	1	1\n17	5	15	8	11	12	13	14	15	16	18\n17	5	15	1	1	27	229	66	16760	27	1\n17	5	16	8	11	12	13	14	15	16	17\n17	5	16	5	3	18	3	29	25	2196	1\n17	5	17	8	10	12	13	14	15	17	21\n17	5	17	1	1	2	3	1	2	25	1\n17	5	18	11	13	15	17	18\n17	5	18	1	6	6	2	62\n17	5	19	8	11	15	17	18	19\n17	5	19	2	2	4	2	3	27\n17	5	20	8	12	14	16	20\n17	5	20	3	1	1	1	2133\n17	5	21	11	12	13	14	15	16	18	21\n17	5	21	1	2	3	2	10	5	4	668\n17	5	22	14	22\n17	5	22	2	4\n17	5	23	8	13	15	16	17	18	21	23\n17	5	23	1	1	6	1	5	9	2	21\n17	5	24	22	24\n17	5	24	1	4\n17	5	25	8	10	17	23	25\n17	5	25	2	1	1	2	7\n17	5	26	14	17\n17	5	26	1	2\n17	5	27	29\n17	5	27	1\n17	5	28	13	17	26	28\n17	5	28	1	1	1	1\n17	5	29	29\n17	5	29	1\n17	5	30	30	32\n17	5	30	1	1\n17	5	31	10	13\n17	5	31	1	1\n17	5	32	32\n17	5	32	4\n17	5	33	35\n17	5	33	1\n17	5	37	37\n17	5	37	4\n17	6	0	0\n17	6	0	11\n17	6	6	6\n17	6	6	1212\n17	6	7	7\n17	6	7	2167\n17	6	8	7	8\n17	6	8	9	3323\n17	6	9	6	7	8	9	10\n17	6	9	5	17	13	3256	7\n17	6	10	9	10\n17	6	10	18	981\n17	6	11	7	9	10	11	12	13	14\n17	6	11	30	12	16	41484	23	21	2\n17	6	12	7	8	9	10	11	12	13	14	15\n17	6	12	5	1	2	3	340	27631	19	4	4\n17	6	13	6	7	8	9	10	11	12	13	14	15	18\n17	6	13	1	88	1	10	1	27	224	24705	33	23	1\n17	6	14	7	9	10	11	12	13	14	15	16\n17	6	14	5	1	1	2	14	110	9470	1	8\n17	6	15	7	9	11	12	13	14	15	16	17	18\n17	6	15	35	6	2	26	200	52	16511	13	1	2\n17	6	16	9	12	14	15	16\n17	6	16	3	5	49	35	2155\n17	6	17	7	9	12	13	15	16	17\n17	6	17	2	3	1	1	1	2	29\n17	6	18	7	9	10	11	13	14	15	16	18\n17	6	18	12	3	1	1	2	2	2	3	57\n17	6	19	7	9	10	12	14	15	19\n17	6	19	14	5	1	1	2	1	3\n17	6	20	7	9	10	18	20\n17	6	20	3	1	3	1	2126\n17	6	21	7	9	10	12	13	15	16	18	21\n17	6	21	2	3	4	1	2	11	5	2	641\n17	6	22	13	15	20	21	22\n17	6	22	1	1	1	1	1\n17	6	23	7	9	23\n17	6	23	1	3	19\n17	6	24	24	27	37\n17	6	24	2	1	1\n17	6	25	7	9	10\n17	6	25	1	4	2\n17	6	26	26\n17	6	26	1\n17	6	28	28\n17	6	28	1\n17	6	29	30	40\n17	6	29	1	1\n17	6	30	30\n17	6	30	1\n17	6	32	32\n17	6	32	5\n17	6	35	35\n17	6	35	1\n17	6	37	37\n17	6	37	4\n17	7	0	0\n17	7	0	11\n17	7	6	6	9\n17	7	6	1217	1\n17	7	7	6	7	10\n17	7	7	2	2388	1\n17	7	8	6	7	8\n17	7	8	9	3	3326\n17	7	9	6	7	8	9	10	11	25\n17	7	9	10	26	16	3266	10	1	1\n17	7	10	6	7	9	10	11\n17	7	10	1	4	23	991	1\n17	7	11	6	7	8	9	10	11	12	13	14	15\n17	7	11	23	1	3	7	42	41740	19	18	2	1\n17	7	12	6	7	8	9	10	11	12	13	14	15	18	19\n17	7	12	13	2	13	7	18	321	27525	13	10	2	1	1\n17	7	13	6	8	9	10	11	12	13	14	15\n17	7	13	65	1	8	3	34	219	24682	30	19\n17	7	14	6	8	9	10	11	12	13	14	15	16\n17	7	14	4	1	1	5	6	29	111	9446	3	8\n17	7	15	6	9	10	11	12	13	14	15	16	18\n17	7	15	38	4	2	1	18	258	57	16202	9	1\n17	7	16	6	9	11	12	13	14	15	16	18\n17	7	16	4	1	2	172	6	55	51	1894	1\n17	7	17	6	9	17	19\n17	7	17	7	10	12	1\n17	7	18	6	9	12	13	15	16	18\n17	7	18	9	3	2	1	2	2	44\n17	7	19	19\n17	7	19	3\n17	7	20	14	15	16	20\n17	7	20	1	1	4	2121\n17	7	21	6	9	12	13	14	15	16	17	18	21\n17	7	21	1	1	2	36	2	270	99	1	19	211\n17	7	22	18\n17	7	22	1\n17	7	23	6	9	15	16	17	18	21\n17	7	23	1	2	1	10	2	1	2\n17	7	24	21	24\n17	7	24	1	1\n17	7	26	26\n17	7	26	1\n17	7	27	27\n17	7	27	1\n17	7	28	28\n17	7	28	1\n17	7	30	30	32\n17	7	30	1	1\n17	7	32	30	32\n17	7	32	1	4\n17	7	35	35\n17	7	35	1\n17	7	37	21	37\n17	7	37	1	4\n17	7	40	40\n17	7	40	1\n17	8	0	0\n17	8	0	11\n17	8	6	6	9\n17	8	6	1403	1\n17	8	7	6	7	9\n17	8	7	16	2391	17\n17	8	8	6	7	8	10\n17	8	8	11	4	3343	2\n17	8	9	6	7	8	9	10	11\n17	8	9	20	9	12	3285	6	2\n17	8	10	6	9	10	11	12\n17	8	10	2	19	1048	1	2\n17	8	11	6	7	9	10	11	12	13\n17	8	11	27	1	13	34	41971	28	32\n17	8	12	6	7	8	9	10	11	12	13	14	15	16	18\n17	8	12	4	1	5	5	16	252	27654	38	5	4	1	1\n17	8	13	6	8	9	10	11	12	13	14	15	18\n17	8	13	83	3	12	3	46	212	24687	44	34	1\n17	8	14	6	8	9	10	11	12	13	14	15	16\n17	8	14	5	3	2	6	3	42	83	9427	8	24\n17	8	15	6	8	9	11	12	13	14	15	16	18\n17	8	15	32	1	10	1	13	254	50	16164	24	3\n17	8	16	6	8	9	13	14	15	16\n17	8	16	1	1	11	2	33	72	1906\n17	8	17	17\n17	8	17	15\n17	8	18	8	9	13	15	16	18	21\n17	8	18	1	1	4	5	3	53	1\n17	8	19	12	13	16	19\n17	8	19	2	1	1	1\n17	8	20	14	15	16	20\n17	8	20	9	6	42	2064\n17	8	21	9	12	13	21\n17	8	21	5	3	1	206\n17	8	24	21\n17	8	24	1\n17	8	25	25\n17	8	25	1\n17	8	26	26\n17	8	26	1\n17	8	27	27\n17	8	27	1\n17	8	28	13\n17	8	28	1\n17	8	30	30\n17	8	30	2\n17	8	32	32\n17	8	32	5\n17	8	35	35\n17	8	35	1\n17	8	37	20	37\n17	8	37	1	3\n17	8	40	37\n17	8	40	1\n17	9	0	0\n17	9	0	11\n17	9	6	6	9	25\n17	9	6	1577	26	1\n17	9	7	6	7	9	10\n17	9	7	120	2274	8	4\n17	9	8	6	7	8	9	10	12	14	18\n17	9	8	145	5	3191	14	2	2	8	2\n17	9	9	6	7	8	9	10	11	30\n17	9	9	217	29	24	3105	2	3	1\n17	9	10	6	8	9	10	12	13	19	32\n17	9	10	40	10	34	1015	13	1	1	1\n17	9	11	6	7	8	9	10	11	12	13	14	16	18\n17	9	11	238	16	23	39	566	41129	241	15	6	1	2\n17	9	12	6	7	8	9	10	11	12	13	14	15	16	18	21\n17	9	12	83	8	22	18	377	201	27066	170	5	3	1	1	1\n17	9	13	6	8	9	10	11	12	13	14	15	18	20	21\n17	9	13	1379	2	161	9	23	200	23262	27	36	1	2	1\n17	9	14	6	8	9	10	11	12	13	14	15	16	18	21\n17	9	14	47	69	19	34	15	30	77	9249	1	24	2	1\n17	9	15	6	8	9	10	11	12	13	14	15	16	17	21	30\n17	9	15	510	15	218	7	2	9	149	57	15305	16	1	3	1\n17	9	16	6	8	9	10	11	12	13	14	15	16\n17	9	16	25	26	141	19	11	8	21	34	44	1672\n17	9	17	13	17	32\n17	9	17	1	11	3\n17	9	18	6	9	11	12	17	18	19\n17	9	18	14	36	1	3	1	2	1\n17	9	19	12\n17	9	19	1\n17	9	20	14	15	16	20\n17	9	20	2	1	13	2049\n17	9	21	6	9	10	11	17	21\n17	9	21	11	87	1	2	1	106\n17	9	25	25\n17	9	25	1\n17	9	26	22\n17	9	26	1\n17	9	27	27\n17	9	27	1\n17	9	30	30\n17	9	30	2\n17	9	32	32\n17	9	32	5\n17	9	35	35\n17	9	35	1\n17	9	37	37\n17	9	37	4\n17	10	0	0\n17	10	0	11\n17	10	6	6	8	9\n17	10	6	4375	1	30\n17	10	7	6	7	8	9\n17	10	7	71	2258	1	2\n17	10	8	6	7	8	9\n17	10	8	93	16	3271	2\n17	10	9	6	7	8	9	10	12\n17	10	9	133	20	30	3713	8	2\n17	10	10	6	8	9	10	11	12\n17	10	10	24	22	17	1968	2	3\n17	10	11	6	7	8	9	10	11	12	13	14	15\n17	10	11	215	59	51	18	600	40184	218	37	3	2\n17	10	12	6	7	8	9	10	11	12	13	14	15	18\n17	10	12	148	30	48	10	405	150	26673	102	3	1	3\n17	10	13	6	8	9	10	11	12	13	14	15\n17	10	13	1220	4	89	23	22	212	22054	35	37\n17	10	14	6	8	9	10	11	12	13	14	15	16\n17	10	14	52	109	13	23	17	24	69	9061	1	19\n17	10	15	6	8	9	10	11	12	13	14	15	16\n17	10	15	388	11	275	14	1	1	55	62	14572	11\n17	10	16	8	9	10	11	12	13	14	15	16\n17	10	16	37	15	20	9	4	3	13	43	1583\n17	10	17	17\n17	10	17	14\n17	10	18	12	14	15	18\n17	10	18	2	1	1	6\n17	10	19	19\n17	10	19	2\n17	10	20	14	16	17	20\n17	10	20	1	10	1	2039\n17	10	21	12	15	18	20	21\n17	10	21	1	4	3	1	103\n17	10	22	22\n17	10	22	1\n17	10	25	25\n17	10	25	2\n17	10	27	27\n17	10	27	1\n17	10	30	27	30	32\n17	10	30	1	2	1\n17	10	32	32	37\n17	10	32	8	1\n17	10	35	35\n17	10	35	1\n17	10	37	37\n17	10	37	4\n17	11	0	0\n17	11	0	11\n17	11	6	6	7	9\n17	11	6	6365	3	351\n17	11	7	6	7	8	9	10	11	13\n17	11	7	27	2253	65	12	3	20	3\n17	11	8	6	7	8	9	10\n17	11	8	33	22	3509	14	7\n17	11	9	6	7	8	9	10	11	12	13	14	19\n17	11	9	39	8	42	4080	4	6	1	1	1	2\n17	11	10	6	7	8	9	10	11	12	13	17\n17	11	10	4	1	7	12	3011	3	18	1	4\n17	11	11	6	7	8	9	10	11	12	13\n17	11	11	120	46	53	10	258	39727	150	21\n17	11	12	6	7	8	9	10	11	12	13	14	15	18	21	24\n17	11	12	61	33	26	5	152	114	26675	65	1	1	5	1	1\n17	11	13	6	8	9	10	11	12	13	14	15	18\n17	11	13	409	6	27	23	27	197	21564	28	38	1\n17	11	14	6	8	9	10	11	12	13	14	16\n17	11	14	21	26	7	8	6	17	71	9011	12\n17	11	15	6	8	9	10	11	12	13	14	15	16	18\n17	11	15	132	4	83	8	1	5	56	68	14296	7	1\n17	11	16	8	9	10	11	14	15	16\n17	11	16	10	2	10	1	24	50	1526\n17	11	17	9	16	17\n17	11	17	1	1	13\n17	11	18	14	17	18\n17	11	18	2	1	9\n17	11	19	14	15\n17	11	19	1	1\n17	11	20	16	18	20\n17	11	20	1	1	2038\n17	11	21	21\n17	11	21	103\n17	11	22	19\n17	11	22	1\n17	11	25	25	30\n17	11	25	1	1\n17	11	27	22	27\n17	11	27	1	1\n17	11	30	28	30\n17	11	30	1	1\n17	11	32	25	32\n17	11	32	1	8\n17	11	35	33\n17	11	35	1\n17	11	37	37\n17	11	37	5\n17	12	0	0\n17	12	0	11\n17	12	6	6	7	8	9	10	11	13\n17	12	6	6768	21	83	309	1	27	2\n17	12	7	6	7	8	9	10	12\n17	12	7	9	2323	1	20	11	2\n17	12	8	6	7	8	9	10	12	14\n17	12	8	9	4	3704	18	11	1	1\n17	12	9	6	7	8	9	10	11	12	13	17	32\n17	12	9	13	28	24	4522	2	10	2	1	1	1\n17	12	10	6	8	9	10	11	12	13	14	15\n17	12	10	3	5	18	3393	19	27	10	8	1\n17	12	11	6	7	8	9	10	11	12	13	14	15\n17	12	11	39	26	34	5	109	39500	148	8	30	6\n17	12	12	6	7	8	9	10	11	12	13	14	15	18	24	25\n17	12	12	16	20	13	1	67	134	26727	42	29	11	1	1	1\n17	12	13	6	8	9	10	11	12	13	14	15	16\n17	12	13	118	2	9	14	20	171	21348	23	75	2\n17	12	14	6	8	11	12	13	14	15	16\n17	12	14	5	9	5	20	78	8994	2	23\n17	12	15	6	9	10	11	12	13	14	15	16	18\n17	12	15	47	22	1	2	3	32	101	14170	6	2\n17	12	16	8	10	14	15	16	17\n17	12	16	5	5	4	61	1471	1\n17	12	17	16	17\n17	12	17	1	17\n17	12	18	15	18	19\n17	12	18	1	15	1\n17	12	19	19\n17	12	19	3\n17	12	20	16	18	20\n17	12	20	1	1	2036\n17	12	21	13	21	22\n17	12	21	1	102	1\n17	12	22	22\n17	12	22	1\n17	12	24	24\n17	12	24	1\n17	12	25	22	25\n17	12	25	1	1\n17	12	27	27\n17	12	27	1\n17	12	28	28\n17	12	28	1\n17	12	30	30\n17	12	30	2\n17	12	32	32\n17	12	32	8\n17	12	33	33\n17	12	33	1\n17	12	37	32	37	40\n17	12	37	1	3	1\n17	13	0	0\n17	13	0	11\n17	13	6	6	7	8	9	12\n17	13	6	6893	23	1	109	1\n17	13	7	6	7	9	10\n17	13	7	3	2413	3	3\n17	13	8	6	7	8	9	10	13\n17	13	8	2	4	3857	6	10	1\n17	13	9	6	7	8	9	10	11	12	14	18\n17	13	9	12	11	19	4870	3	1	5	2	1\n17	13	10	6	8	9	10	11	12	13	14	16\n17	13	10	1	6	23	3555	2	16	9	1	1\n17	13	11	6	7	8	9	10	11	12	13	14	15	16	17\n17	13	11	17	6	9	5	40	39440	171	14	12	1	1	1\n17	13	12	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	24\n17	13	12	11	6	7	2	21	113	26829	40	4	6	4	9	45	1	1	2\n17	13	13	6	9	10	11	12	13	14	15	18	20\n17	13	13	32	4	12	21	185	21163	20	77	7	1\n17	13	14	6	8	9	11	12	13	14	15	16	18	19\n17	13	14	3	1	6	4	25	78	9058	3	10	1	1\n17	13	15	6	9	10	12	13	14	15	16	21\n17	13	15	19	6	1	1	48	94	14140	17	1\n17	13	16	8	14	15	16\n17	13	16	1	15	75	1413\n17	13	17	10	14	15	17\n17	13	17	1	1	1	16\n17	13	18	12	16	17	18	21	22	24\n17	13	18	2	1	1	11	1	2	1\n17	13	19	13	19\n17	13	19	1	3\n17	13	20	12	20\n17	13	20	1	2035\n17	13	21	12	21	29\n17	13	21	1	100	1\n17	13	22	22\n17	13	22	3\n17	13	24	18	24\n17	13	24	1	1\n17	13	25	14	20\n17	13	25	1	1\n17	13	27	27\n17	13	27	1\n17	13	28	24\n17	13	28	1\n17	13	30	32\n17	13	30	2\n17	13	32	22	25	30	32\n17	13	32	1	1	2	6\n17	13	33	33\n17	13	33	1\n17	13	37	37\n17	13	37	3\n17	13	40	40\n17	13	40	1\n17	14	0	0\n17	14	0	11\n17	14	6	6	9\n17	14	6	6969	24\n17	14	7	7	9	10\n17	14	7	2442	18	3\n17	14	8	6	7	8	10\n17	14	8	2	7	3886	6\n17	14	9	6	7	8	9	10	11	12	15\n17	14	9	3	8	20	4990	1	9	2	1\n17	14	10	7	8	9	10	12	13	14	18\n17	14	10	1	10	28	3596	5	1	4	1\n17	14	11	6	7	8	9	10	11	12	13	14	15	18\n17	14	11	15	2	1	1	19	39333	198	6	2	3	1\n17	14	12	6	7	9	10	11	12	13	14	15	21\n17	14	12	2	1	1	7	81	27089	45	2	8	1\n17	14	13	6	7	10	11	12	13	14	15	18\n17	14	13	8	1	9	23	189	20997	23	103	1\n17	14	14	6	11	12	13	14	15	16	18	19	24\n17	14	14	1	4	13	91	9053	2	18	22	3	1\n17	14	15	6	9	13	14	15	16	18	19\n17	14	15	5	4	32	103	14138	16	3	2\n17	14	16	14	15	16	17\n17	14	16	13	61	1372	1\n17	14	17	13	14	17\n17	14	17	2	1	24\n17	14	18	16	18	19	21	22\n17	14	18	1	61	2	1	1\n17	14	19	19	21\n17	14	19	3	2\n17	14	20	20\n17	14	20	2037\n17	14	21	12	17	21\n17	14	21	2	1	100\n17	14	22	18	21	22\n17	14	22	1	1	4\n17	14	24	24\n17	14	24	5\n17	14	25	25\n17	14	25	1\n17	14	27	25\n17	14	27	1\n17	14	29	29\n17	14	29	1\n17	14	30	30\n17	14	30	2\n17	14	32	29	30	32\n17	14	32	1	2	5\n17	14	33	31\n17	14	33	1\n17	14	37	37\n17	14	37	3\n17	14	40	40\n17	14	40	1\n17	15	0	0\n17	15	0	11\n17	15	6	6	9	11\n17	15	6	7002	2	1\n17	15	7	7	10\n17	15	7	2461	1\n17	15	8	7	8	9	10\n17	15	8	233	3682	1	1\n17	15	9	6	7	8	9	10	11	12	13\n17	15	9	828	75	82	4076	1	2	1	1\n17	15	10	7	8	9	10	13	14\n17	15	10	49	49	67	3474	1	1\n17	15	11	6	7	8	9	10	11	12	13	14	15\n17	15	11	2	2	274	96	57	38766	234	15	2	2\n17	15	12	7	8	9	10	11	12	13	14	15	16	17\n17	15	12	96	274	129	211	2956	23767	47	6	10	1	1\n17	15	13	6	7	8	9	10	11	12	13	14	15	16\n17	15	13	2	3	31	60	42	563	547	19777	14	133	2\n17	15	14	6	9	10	11	12	13	14	15	16	18\n17	15	14	1	20	89	767	549	1313	6444	2	12	4\n17	15	15	6	9	10	11	12	13	14	15	16\n17	15	15	1	40	30	109	302	1637	191	11988	18\n17	15	16	11	12	13	14	15	16\n17	15	16	4	15	9	50	48	1281\n17	15	17	9	10	12	13	14	17\n17	15	17	1	2	1	1	3	18\n17	15	18	10	12	13	14	17	18\n17	15	18	4	32	11	17	2	24\n17	15	19	10	11	15	16	18	19\n17	15	19	1	1	3	1	3	1\n17	15	20	11	12	13	14	15	16	17	20\n17	15	20	13	9	15	29	43	1711	1	216\n17	15	21	12	13	15	16	17	18	19	21	22\n17	15	21	47	32	1	2	1	1	1	19	1\n17	15	22	18	21	22\n17	15	22	1	2	2\n17	15	24	12	13	24\n17	15	24	1	1	4\n17	15	25	19	25\n17	15	25	1	1\n17	15	29	19	27\n17	15	29	1	1\n17	15	30	30\n17	15	30	4\n17	15	31	27\n17	15	31	1\n17	15	32	25	30	32\n17	15	32	1	1	3\n17	15	37	16	17	37\n17	15	37	1	1	1\n17	15	40	40\n17	15	40	1\n17	16	0	0\n17	16	0	11\n17	16	6	6\n17	16	6	7836\n17	16	7	7\n17	16	7	2919\n17	16	8	7	8	12	13\n17	16	8	128	4254	4	6\n17	16	9	6	7	8	9	10	11	12	13\n17	16	9	602	58	76	3751	2	1	1	1\n17	16	10	7	8	9	10	11	12	13	23\n17	16	10	21	50	68	3768	2	2	1	1\n17	16	11	6	7	8	9	10	11	12	13	15\n17	16	11	1	1	126	76	32	42568	338	30	10\n17	16	12	6	7	8	9	10	11	12	13	15	16\n17	16	12	1	7	52	41	181	1556	23620	27	15	5\n17	16	13	7	8	9	10	11	12	13	14	15	16\n17	16	13	1	29	49	36	317	504	21729	27	165	3\n17	16	14	9	10	11	12	13	14	15	16\n17	16	14	8	25	74	170	682	5766	3	29\n17	16	15	9	10	11	12	13	14	15	16\n17	16	15	6	5	58	89	787	102	11168	15\n17	16	16	10	11	12	13	14	15	16\n17	16	16	1	19	12	19	48	46	2884\n17	16	17	10	12	14	16	17\n17	16	17	1	1	4	1	17\n17	16	18	12	13	14	15	17	18\n17	16	18	10	3	8	1	1	10\n17	16	19	15	19\n17	16	19	1	3\n17	16	20	14	15	16	20\n17	16	20	4	3	114	95\n17	16	21	12	13	21\n17	16	21	9	2	10\n17	16	22	18	20\n17	16	22	2	1\n17	16	24	12	14	18\n17	16	24	2	1	1\n17	16	25	17	25\n17	16	25	1	1\n17	16	27	27\n17	16	27	2\n17	16	30	28	30\n17	16	30	2	3\n17	16	32	30	32\n17	16	32	1	2\n17	16	37	37\n17	16	37	1\n17	16	40	40\n17	16	40	1\n18	1	0	0\n18	1	0	4\n18	1	6	6	9\n18	1	6	838	36\n18	1	7	7	8	9	10	12\n18	1	7	1729	45	25	5	3\n18	1	8	7	8	9	10	11	12	13\n18	1	8	5	2567	6	2	42	75	9\n18	1	9	6	7	8	9	10	11	12	13	14	15\n18	1	9	1	6	8	2461	31	47	22	18	4	1\n18	1	10	9	10	11	12	13	14	15\n18	1	10	20	725	11	16	3	7	3\n18	1	11	8	9	10	11	12	13	14	15	16\n18	1	11	1	4	12	26899	220	61	20	8	3\n18	1	12	9	10	11	12	13	14	15	16	21\n18	1	12	1	4	703	19487	88	58	13	16	9\n18	1	13	8	9	11	12	13	14	15	18	21\n18	1	13	2	8	57	183	17137	198	165	1	8\n18	1	14	11	12	13	14	15	16	20\n18	1	14	6	9	81	5742	17	15	1\n18	1	15	11	12	13	14	15	16	17	18	20	21\n18	1	15	18	47	394	30	12885	15	2	2	1	9\n18	1	16	11	12	13	14	15	16	17	19	20	21	23\n18	1	16	2	5	4	43	31	2157	1	1	232	31	3\n18	1	17	13	14	15	16	17	18	21	23	27\n18	1	17	4	2	5	4	61	2	3	7	1\n18	1	18	13	15	18	21	23\n18	1	18	3	4	39	5	4\n18	1	19	18	19	20	21\n18	1	19	1	32	2	1\n18	1	20	19	20	25\n18	1	20	1	179	1\n18	1	21	21	22	23	24\n18	1	21	101	1	2	1\n18	1	22	20	21	22	25	30\n18	1	22	2	1	5	3	1\n18	1	23	23	30\n18	1	23	19	1\n18	1	24	24\n18	1	24	1\n18	1	25	23	25\n18	1	25	1	13\n18	1	26	15	25\n18	1	26	1	2\n18	1	27	27\n18	1	27	1\n18	1	29	29	30\n18	1	29	1	1\n18	1	30	30\n18	1	30	1\n18	1	31	26\n18	1	31	1\n18	1	32	25\n18	1	32	1\n18	2	0	0\n18	2	0	4\n18	2	6	6	9	28\n18	2	6	812	26	1\n18	2	7	7	8	9	10	12\n18	2	7	1621	71	21	2	25\n18	2	8	7	8	9	10	11	12	13\n18	2	8	3	2401	8	2	64	144	1\n18	2	9	7	8	9	10	11	12	13	14	15	32\n18	2	9	7	11	2440	14	27	32	9	10	10	1\n18	2	10	8	9	10	11	12	13	14	15\n18	2	10	1	16	709	9	16	8	16	4\n18	2	11	9	10	11	12	13	14	15	16	21\n18	2	11	3	12	27308	339	72	36	13	1	1\n18	2	12	9	10	11	12	13	14	15	16	21\n18	2	12	1	2	588	19263	72	71	26	22	22\n18	2	13	11	12	13	14	15	16	17	20	21\n18	2	13	29	185	17019	292	254	2	2	4	15\n18	2	14	11	12	13	14	15	16	18	19	20\n18	2	14	2	7	65	5981	32	13	1	2	1\n18	2	15	11	12	13	14	15	16	19	20	21\n18	2	15	7	42	374	44	12630	10	2	3	21\n18	2	16	11	12	13	14	15	16	17	20	21	23\n18	2	16	3	2	4	39	29	1245	2	870	15	1\n18	2	17	13	14	15	17	18	20	23	37\n18	2	17	1	1	1	52	1	1	6	1\n18	2	18	13	15	16	17	18	21	23\n18	2	18	1	2	1	1	28	7	5\n18	2	19	15	17	18	19	21	23	28\n18	2	19	3	1	2	22	2	3	1\n18	2	20	16	18	20	30\n18	2	20	2	1	413	1\n18	2	21	18	20	21	23\n18	2	21	1	1	163	3\n18	2	22	21	22	25\n18	2	22	1	4	1\n18	2	23	21	23\n18	2	23	1	35\n18	2	24	22	24\n18	2	24	1	1\n18	2	25	23	25	28	32\n18	2	25	1	17	1	1\n18	2	26	31\n18	2	26	1\n18	2	27	21	28\n18	2	27	1	1\n18	2	29	29\n18	2	29	1\n18	2	30	29	31	32\n18	2	30	1	1	2\n18	3	0	0\n18	3	0	4\n18	3	6	6\n18	3	6	812\n18	3	7	7\n18	3	7	1631\n18	3	8	7	8	19\n18	3	8	1	2482	1\n18	3	9	7	8	9	10	11\n18	3	9	3	17	2490	4	1\n18	3	10	8	9	10	11	13\n18	3	10	1	17	720	2	1\n18	3	11	8	9	10	11	12	13	15\n18	3	11	1	3	12	27988	20	12	1\n18	3	12	10	11	12	13	14	15\n18	3	12	1	543	19473	34	3	1\n18	3	13	8	10	11	12	13	14	15\n18	3	13	1	1	28	168	17351	47	30\n18	3	14	11	12	13	14	15	16\n18	3	14	2	10	65	6401	5	7\n18	3	15	11	12	13	14	15	16\n18	3	15	6	23	311	48	12599	17\n18	3	16	12	13	14	15	16\n18	3	16	4	2	37	34	1219\n18	3	17	13	14	15	16	17	18	19\n18	3	17	4	3	1	2	46	1	1\n18	3	18	13	14	15	18	20\n18	3	18	1	1	1	30	1\n18	3	19	17	18	19\n18	3	19	1	2	23\n18	3	20	15	16	20\n18	3	20	1	1	1291\n18	3	21	16	19	20	21	23\n18	3	21	1	3	1	242	2\n18	3	22	22\n18	3	22	5\n18	3	23	20	21	23	25\n18	3	23	1	3	49	1\n18	3	24	22\n18	3	24	1\n18	3	25	21	23	25\n18	3	25	1	1	16\n18	3	28	23	28	30\n18	3	28	1	1	2\n18	3	29	26	29\n18	3	29	1	1\n18	3	30	30\n18	3	30	1\n18	3	31	31\n18	3	31	2\n18	3	32	25	32	33\n18	3	32	1	2	1\n18	3	37	37\n18	3	37	1\n18	4	0	0\n18	4	0	4\n18	4	6	6\n18	4	6	812\n18	4	7	7\n18	4	7	1635\n18	4	8	7	8\n18	4	8	3	2499\n18	4	9	7	8	9	10	11\n18	4	9	7	14	2482	6	1\n18	4	10	7	8	9	10\n18	4	10	2	2	10	724\n18	4	11	9	10	11	12	13\n18	4	11	3	9	28530	16	12\n18	4	12	9	10	11	12	13	15\n18	4	12	2	1	367	19306	20	2\n18	4	13	9	11	12	13	14	15	16\n18	4	13	2	17	178	17508	48	27	1\n18	4	14	11	12	13	14	15	16\n18	4	14	5	16	43	6460	8	8\n18	4	15	12	13	14	15	16	17	18\n18	4	15	22	213	49	12372	15	1	1\n18	4	16	9	11	12	13	14	15	16	20\n18	4	16	1	1	2	1	19	15	1206	2\n18	4	17	9	13	15	16	17	21\n18	4	17	1	5	4	1	35	1\n18	4	18	12	14	15	18\n18	4	18	1	1	4	27\n18	4	19	15	17	18	19	22\n18	4	19	2	1	3	21	1\n18	4	20	19	20\n18	4	20	1	1293\n18	4	21	9	15	17	18	21\n18	4	21	2	11	3	2	228\n18	4	22	17	21	22	24\n18	4	22	1	1	3	1\n18	4	23	17	18	19	21	23\n18	4	23	1	1	1	4	46\n18	4	25	19	21	22	23	25\n18	4	25	4	2	2	1	9\n18	4	26	20\n18	4	26	1\n18	4	28	31\n18	4	28	1\n18	4	29	29\n18	4	29	1\n18	4	30	30\n18	4	30	3\n18	4	31	13	31\n18	4	31	1	1\n18	4	32	32\n18	4	32	2\n18	4	33	33\n18	4	33	1\n18	4	37	37\n18	4	37	1\n18	5	0	0\n18	5	0	4\n18	5	6	6\n18	5	6	812\n18	5	7	7\n18	5	7	1647\n18	5	8	7	8\n18	5	8	4	2511\n18	5	9	7	8	9	10	13\n18	5	9	7	16	2473	6	1\n18	5	10	7	8	9	10	13\n18	5	10	1	1	20	717	1\n18	5	11	8	9	10	11	12	13\n18	5	11	1	3	9	28875	16	17\n18	5	12	11	12	13	14	15	16\n18	5	12	316	19173	41	6	4	1\n18	5	13	8	9	10	11	12	13	14	15	16	18\n18	5	13	6	1	1	20	132	17564	54	23	1	1\n18	5	14	10	11	12	13	14	15	16\n18	5	14	1	3	15	50	6499	2	7\n18	5	15	8	12	13	14	15	16\n18	5	15	2	19	146	41	12220	17\n18	5	16	8	12	13	14	15	16\n18	5	16	2	2	1	30	16	1180\n18	5	17	13	14	15	16	17	19\n18	5	17	1	3	4	1	32	1\n18	5	18	13	15	17	18\n18	5	18	2	2	1	29\n18	5	19	8	15	19	20\n18	5	19	3	4	19	1\n18	5	20	8	12	13	14	16	17	19	20	22\n18	5	20	3	1	1	1	1	1	1	1285	2\n18	5	21	12	13	14	15	16	17	18	21	22	31\n18	5	21	1	2	1	10	5	5	2	208	1	1\n18	5	22	10	18	21	22\n18	5	22	1	1	1	3\n18	5	23	8	13	15	16	17	18	21	23\n18	5	23	1	1	3	1	7	12	5	17\n18	5	24	24\n18	5	24	1\n18	5	25	17	23	25\n18	5	25	1	1	7\n18	5	29	29\n18	5	29	1\n18	5	30	30	32\n18	5	30	2	1\n18	5	31	13	17\n18	5	31	1	1\n18	5	32	32\n18	5	32	2\n18	5	33	33\n18	5	33	1\n18	5	37	37\n18	5	37	1\n18	6	0	0\n18	6	0	4\n18	6	6	6	7\n18	6	6	811	1\n18	6	7	7	10\n18	6	7	1658	1\n18	6	8	6	7	8	9	13\n18	6	8	1	6	2536	2	1\n18	6	9	6	7	8	9	10\n18	6	9	2	16	8	2460	11\n18	6	10	7	8	9	10\n18	6	10	3	2	17	713\n18	6	11	7	9	10	11	12	13	15\n18	6	11	9	3	20	29153	15	13	1\n18	6	12	7	9	10	11	12	13	14	15	18\n18	6	12	5	2	2	268	19051	24	2	4	1\n18	6	13	7	9	10	11	12	13	14	15	17\n18	6	13	81	13	1	8	119	17526	57	23	1\n18	6	14	7	9	11	12	13	14	15	16\n18	6	14	4	3	3	11	25	6578	5	6\n18	6	15	7	9	11	12	13	14	15	16	17\n18	6	15	27	6	3	8	114	32	12082	15	1\n18	6	16	7	10	12	13	14	15	16\n18	6	16	1	1	2	1	15	14	1180\n18	6	17	7	9	13	15	16	17	21\n18	6	17	2	2	3	1	2	37	1\n18	6	18	7	9	14	18\n18	6	18	8	1	1	35\n18	6	19	7	9	10	12	14	15\n18	6	19	8	6	3	1	2	1\n18	6	20	7	10	20\n18	6	20	3	2	1281\n18	6	21	7	9	13	15	16	21	24\n18	6	21	2	2	4	1	2	202	1\n18	6	22	10	13	14	18	22\n18	6	22	1	1	1	1	2\n18	6	23	9	21	23\n18	6	23	1	1	16\n18	6	24	24\n18	6	24	1\n18	6	25	7	9	10\n18	6	25	1	2	4\n18	6	29	30\n18	6	29	1\n18	6	30	32\n18	6	30	2\n18	6	31	37\n18	6	31	1\n18	6	32	32	33\n18	6	32	2	1\n18	6	33	35\n18	6	33	1\n18	6	37	37\n18	6	37	1\n18	7	0	0\n18	7	0	4\n18	7	6	6\n18	7	6	814\n18	7	7	6	7	9\n18	7	7	3	1831	1\n18	7	8	6	7	8	9\n18	7	8	6	4	2535	1\n18	7	9	6	7	8	9	10	11	12	19\n18	7	9	14	13	18	2467	4	1	2	1\n18	7	10	6	8	9	10\n18	7	10	2	1	15	741\n18	7	11	6	8	9	10	11	12	13	14\n18	7	11	20	3	6	51	29320	17	17	1\n18	7	12	6	8	9	10	11	12	13	14	15\n18	7	12	10	1	3	12	191	18973	11	1	5\n18	7	13	6	8	9	11	12	13	14	15\n18	7	13	90	1	22	27	160	17366	31	15\n18	7	14	6	10	11	12	13	14	15	16\n18	7	14	2	3	3	13	101	6555	4	7\n18	7	15	6	9	10	11	12	13	14	15	16	18\n18	7	15	41	4	1	4	12	134	38	11886	11	1\n18	7	16	6	12	13	14	15	16	18	24\n18	7	16	4	40	4	19	23	1111	3	1\n18	7	17	6	9	12	13	14	15	16	17	18\n18	7	17	11	16	1	2	1	1	1	3	3\n18	7	18	6	9	15	18	21\n18	7	18	14	9	1	12	1\n18	7	20	16	20\n18	7	20	1	1280\n18	7	21	6	9	13	14	15	16	18	21\n18	7	21	3	4	12	1	60	22	4	98\n18	7	22	18	22\n18	7	22	1	1\n18	7	23	6	9	14	16	23\n18	7	23	1	10	1	3	1\n18	7	24	24\n18	7	24	2\n18	7	30	30\n18	7	30	1\n18	7	32	32\n18	7	32	4\n18	7	33	35\n18	7	33	1\n18	7	35	35\n18	7	35	1\n18	7	37	37	38\n18	7	37	1	1\n18	8	0	0\n18	8	0	4\n18	8	6	6\n18	8	6	1035\n18	8	7	6	7	9\n18	8	7	4	1823	21\n18	8	8	7	8\n18	8	8	3	2556\n18	8	9	6	7	8	9	10	11	12	14	32\n18	8	9	9	15	11	2512	6	1	1	2	1\n18	8	10	7	8	9	10	12	13\n18	8	10	1	3	26	779	1	2\n18	8	11	6	7	8	9	10	11	12	13	14\n18	8	11	4	2	3	10	18	29473	16	19	1\n18	8	12	6	7	8	9	10	11	12	13	14	15	16	18\n18	8	12	5	3	10	4	8	167	18995	15	2	6	1	2\n18	8	13	6	8	9	10	11	12	13	14	15\n18	8	13	12	1	1	1	26	142	17406	38	20\n18	8	14	6	8	9	10	11	12	13	14	15	16\n18	8	14	1	1	4	7	6	33	70	6519	3	4\n18	8	15	6	9	11	12	13	14	15	16	18	21\n18	8	15	10	2	1	10	216	31	11712	10	2	1\n18	8	16	8	9	13	14	15	16\n18	8	16	1	1	4	17	27	1106\n18	8	17	17\n18	8	17	3\n18	8	18	10	14	15	18	21\n18	8	18	1	1	1	20	1\n18	8	19	19\n18	8	19	1\n18	8	20	14	15	16	20\n18	8	20	1	4	30	1245\n18	8	21	6	9	12	13	18	21	28\n18	8	21	2	1	2	3	1	89	1\n18	8	22	22\n18	8	22	1\n18	8	23	23\n18	8	23	1\n18	8	24	21	24\n18	8	24	1	2\n18	8	30	32\n18	8	30	1\n18	8	32	32\n18	8	32	4\n18	8	35	35	37\n18	8	35	1	1\n18	8	37	37\n18	8	37	1\n18	8	38	38\n18	8	38	1\n18	9	0	0\n18	9	0	4\n18	9	6	6	9\n18	9	6	1060	22\n18	9	7	6	7	9\n18	9	7	35	1808	4\n18	9	8	6	7	8	9	10	12	14	18\n18	9	8	42	4	2523	12	2	1	1	1\n18	9	9	6	7	8	9	10	11\n18	9	9	66	9	15	2488	3	1\n18	9	10	6	8	9	10	12\n18	9	10	14	2	22	777	5\n18	9	11	6	7	8	9	10	11	12	13	18\n18	9	11	87	4	5	17	161	29316	73	10	1\n18	9	12	6	7	8	10	11	12	13	14	15	18\n18	9	12	19	4	13	89	124	18926	16	1	2	6\n18	9	13	6	8	9	10	11	12	13	14	15	16	18\n18	9	13	390	2	40	5	29	161	17070	21	14	2	1\n18	9	14	6	8	9	10	11	12	13	14	16\n18	9	14	16	33	8	6	4	21	69	6445	10\n18	9	15	6	8	9	11	12	13	14	15	16	18	21\n18	9	15	110	1	38	3	11	174	37	11380	13	2	4\n18	9	16	6	8	9	10	11	12	13	14	15	16\n18	9	16	3	5	41	3	1	5	1	31	14	1047\n18	9	17	17\n18	9	17	3\n18	9	18	6	9	11	18	21\n18	9	18	3	9	1	9	3\n18	9	19	21\n18	9	19	1\n18	9	20	14	15	16	20\n18	9	20	3	5	29	1208\n18	9	21	6	8	9	12	18	21\n18	9	21	6	1	27	3	1	54\n18	9	22	22\n18	9	22	1\n18	9	23	11\n18	9	23	1\n18	9	24	24\n18	9	24	2\n18	9	28	28\n18	9	28	1\n18	9	32	32\n18	9	32	6\n18	9	35	35\n18	9	35	1\n18	9	37	37	39\n18	9	37	1	1\n18	9	38	38\n18	9	38	1\n18	10	0	0\n18	10	0	4\n18	10	6	6	9	22\n18	10	6	1845	5	1\n18	10	7	6	7	9	14\n18	10	7	107	1711	7	4\n18	10	8	6	7	8	9	10	11	12\n18	10	8	112	7	2472	3	3	2	1\n18	10	9	6	7	8	9	10	11	18	32\n18	10	9	193	35	20	2474	2	1	2	1\n18	10	10	6	7	8	9	10	11	12\n18	10	10	41	5	9	24	962	1	4\n18	10	11	6	7	8	9	10	11	12	13	14\n18	10	11	260	40	33	20	614	28246	256	9	2\n18	10	12	6	7	8	9	10	11	12	13	14	15	18\n18	10	12	80	16	27	10	384	106	18436	139	3	4	1\n18	10	13	6	8	9	10	11	12	13	14	15\n18	10	13	1284	8	128	12	23	142	15700	23	20\n18	10	14	6	8	9	10	11	12	13	14	16	18\n18	10	14	65	87	27	48	7	15	56	6227	6	1\n18	10	15	6	8	9	10	11	12	13	14	15	16	18\n18	10	15	456	18	338	12	1	4	66	37	10475	7	1\n18	10	16	8	9	10	11	12	13	14	15	16\n18	10	16	34	11	19	11	1	1	12	28	984\n18	10	17	8	17\n18	10	17	1	2\n18	10	18	12	15	18\n18	10	18	3	2	16\n18	10	20	9	11	14	15	16	17	20\n18	10	20	2	2	2	3	11	1	1187\n18	10	21	15	17	18	21\n18	10	21	2	1	2	57\n18	10	22	22\n18	10	22	1\n18	10	24	15	21\n18	10	24	1	1\n18	10	28	25\n18	10	28	1\n18	10	32	32\n18	10	32	6\n18	10	35	35\n18	10	35	1\n18	10	37	37\n18	10	37	1\n18	10	38	38\n18	10	38	1\n18	10	39	39\n18	10	39	1\n18	11	0	0\n18	11	0	4\n18	11	6	6	7	9\n18	11	6	4347	1	95\n18	11	7	6	7	8	9	10	11\n18	11	7	46	1748	12	4	2	2\n18	11	8	6	7	8	9\n18	11	8	68	15	2617	9\n18	11	9	6	7	8	9	10	11\n18	11	9	82	13	32	2917	3	2\n18	11	10	6	7	8	9	10	12\n18	11	10	15	4	4	11	2014	8\n18	11	11	6	7	8	9	10	11	12	13	14\n18	11	11	178	45	46	5	422	27539	136	28	1\n18	11	12	6	7	8	9	10	11	12	13	14	15	18\n18	11	12	80	24	47	5	270	72	18300	60	1	2	1\n18	11	13	6	7	8	9	10	11	12	13	14	15\n18	11	13	685	1	8	35	36	23	163	14974	19	27\n18	11	14	6	8	9	10	11	12	13	14	16	18\n18	11	14	43	82	8	23	13	12	47	6075	6	1\n18	11	15	6	8	9	10	12	13	14	15	16\n18	11	15	210	8	171	11	2	49	55	10024	5\n18	11	16	8	9	10	11	12	13	14	15	16\n18	11	16	21	9	18	6	2	1	11	39	901\n18	11	17	17\n18	11	17	4\n18	11	18	12	14	15	17	18\n18	11	18	8	1	5	1	8\n18	11	20	16	20\n18	11	20	4	1183\n18	11	21	9	13	15	18	21\n18	11	21	1	2	2	2	51\n18	11	22	20	22\n18	11	22	1	1\n18	11	25	25\n18	11	25	1\n18	11	32	32\n18	11	32	7\n18	11	35	35\n18	11	35	1\n18	11	37	37\n18	11	37	1\n18	11	38	38\n18	11	38	1\n18	11	39	39\n18	11	39	1\n18	12	0	0\n18	12	0	4\n18	12	6	6	7	8	9	11	13	17\n18	12	6	5390	13	33	309	7	1	1\n18	12	7	6	7	9	10\n18	12	7	18	1805	21	7\n18	12	8	6	7	8	9	10	12\n18	12	8	21	7	2821	19	8	1\n18	12	9	6	7	8	9	10	11\n18	12	9	22	33	17	3194	2	2\n18	12	10	6	7	8	9	10	11	12	13\n18	12	10	5	1	2	15	2726	8	36	6\n18	12	11	6	7	8	9	10	11	12	13	15\n18	12	11	77	31	27	3	167	27214	119	17	2\n18	12	12	6	7	8	9	10	11	12	13	15	18	24\n18	12	12	36	16	21	3	126	85	18277	61	1	3	2\n18	12	13	6	8	9	10	11	12	13	14	15\n18	12	13	248	6	13	18	13	139	14667	14	43\n18	12	14	6	8	9	10	11	12	13	14	16	18	21\n18	12	14	18	24	2	4	5	11	62	6026	9	1	1\n18	12	15	6	8	9	10	11	12	13	14	15	16\n18	12	15	86	3	55	8	2	5	26	57	9853	4\n18	12	16	8	9	10	12	14	15	16\n18	12	16	10	3	8	1	7	34	853\n18	12	17	17\n18	12	17	5\n18	12	18	12	14	18	21\n18	12	18	2	3	6	1\n18	12	20	16	20\n18	12	20	1	1183\n18	12	21	21\n18	12	21	51\n18	12	22	22\n18	12	22	1\n18	12	25	27\n18	12	25	1\n18	12	32	32\n18	12	32	7\n18	12	35	35\n18	12	35	1\n18	12	37	37\n18	12	37	1\n18	12	38	38\n18	12	38	1\n18	12	39	39\n18	12	39	1\n18	13	0	0\n18	13	0	4\n18	13	6	6	7	8	9	11	14\n18	13	6	5575	153	10	178	4	1\n18	13	7	6	7	9	10\n18	13	7	3	1888	5	10\n18	13	8	6	7	8	9	10	13\n18	13	8	3	5	2929	12	12	3\n18	13	9	6	7	8	9	10	11	12	14	17\n18	13	9	10	37	22	3559	4	2	1	1	1\n18	13	10	6	7	8	9	10	11	12	13	14	15\n18	13	10	3	1	6	21	2963	19	30	14	16	1\n18	13	11	6	7	8	9	10	11	12	13	14\n18	13	11	32	27	26	2	88	27038	90	7	26\n18	13	12	6	7	8	9	10	11	12	13	14	15	18\n18	13	12	10	6	14	4	72	66	18353	40	20	2	4\n18	13	13	6	7	8	9	10	11	12	13	14	15\n18	13	13	99	1	1	6	13	14	155	14483	15	53\n18	13	14	6	8	9	10	11	12	13	14	16	22\n18	13	14	4	3	3	2	2	3	55	6023	11	1\n18	13	15	6	9	11	12	13	14	15	16	18	24	25\n18	13	15	21	16	2	1	24	59	9805	2	1	1	1\n18	13	16	8	14	15	16\n18	13	16	5	3	30	829\n18	13	17	12	17\n18	13	17	1	5\n18	13	18	18\n18	13	18	10\n18	13	20	16	20\n18	13	20	1	1182\n18	13	21	21	24\n18	13	21	52	1\n18	13	22	22\n18	13	22	1\n18	13	24	24\n18	13	24	2\n18	13	27	27\n18	13	27	1\n18	13	32	30	32\n18	13	32	1	6\n18	13	35	35\n18	13	35	1\n18	13	37	37\n18	13	37	1\n18	13	38	39\n18	13	38	1\n18	13	39	37\n18	13	39	1\n18	14	0	0\n18	14	0	4\n18	14	6	6	7	8	9	11\n18	14	6	5685	7	1	66	1\n18	14	7	6	7	9	10\n18	14	7	1	2090	19	8\n18	14	8	6	7	8	9	10	14	17	18\n18	14	8	2	5	2993	8	4	2	1	1\n18	14	9	6	7	8	9	10	11	12	14\n18	14	9	1	4	19	3773	3	3	2	1\n18	14	10	6	8	9	10	11	12	13\n18	14	10	1	3	12	3134	1	9	4\n18	14	11	6	7	8	9	10	11	12	13	14	16\n18	14	11	16	7	1	5	34	26959	105	10	9	1\n18	14	12	6	7	8	9	10	11	12	13	15	16	17	18	19	24\n18	14	12	9	3	2	1	23	70	18446	34	8	1	4	29	1	3\n18	14	13	6	8	9	10	11	12	13	14	15	18	21\n18	14	13	41	1	1	12	8	146	14327	13	74	2	1\n18	14	14	6	8	9	11	12	13	14	15	16\n18	14	14	7	2	4	4	7	65	6067	1	7\n18	14	15	6	9	12	13	14	15	16	18	21\n18	14	15	11	6	2	25	62	9763	17	1	4\n18	14	16	10	14	15	16	17\n18	14	16	1	6	44	790	2\n18	14	17	8	17	22\n18	14	17	1	4	1\n18	14	18	13	18	21	24\n18	14	18	1	11	1	2\n18	14	20	20\n18	14	20	1182\n18	14	21	21\n18	14	21	52\n18	14	22	22	28\n18	14	22	1	1\n18	14	24	24	28\n18	14	24	3	1\n18	14	25	25\n18	14	25	1\n18	14	27	28\n18	14	27	1\n18	14	30	30\n18	14	30	1\n18	14	32	30	32\n18	14	32	3	3\n18	14	35	32\n18	14	35	1\n18	14	37	37\n18	14	37	2\n18	14	39	39\n18	14	39	1\n18	15	0	0\n18	15	0	4\n18	15	6	6	9\n18	15	6	5759	15\n18	15	7	7	9	10\n18	15	7	2095	16	5\n18	15	8	6	7	8	10	11	13\n18	15	8	1	3	3010	6	1	2\n18	15	9	6	7	8	9	10	11	18\n18	15	9	4	8	9	3868	3	2	1\n18	15	10	7	8	9	10	11	12	13	14\n18	15	10	2	10	19	3173	1	2	7	5\n18	15	11	6	7	8	9	10	11	12	13	14	15\n18	15	11	6	4	2	2	16	26877	126	9	3	1\n18	15	12	6	10	11	12	13	14	15	17\n18	15	12	2	10	60	18598	35	3	8	1\n18	15	13	6	8	9	10	11	12	13	14	15	16	18	19	26\n18	15	13	4	1	2	4	14	136	14234	11	55	1	1	2	1\n18	15	14	6	11	12	13	14	15	16	17	18\n18	15	14	2	2	11	62	6046	1	11	1	24\n18	15	15	6	9	12	13	14	15	16	18	21\n18	15	15	4	1	2	33	72	9760	13	1	4\n18	15	16	14	15	16\n18	15	16	5	40	771\n18	15	17	13	14	17\n18	15	17	1	1	9\n18	15	18	12	13	18	21\n18	15	18	1	1	39	3\n18	15	19	18\n18	15	19	1\n18	15	20	20\n18	15	20	1182\n18	15	21	12	21\n18	15	21	1	57\n18	15	22	21	22\n18	15	22	1	1\n18	15	24	21	24\n18	15	24	1	7\n18	15	25	27\n18	15	25	1\n18	15	28	24	28\n18	15	28	1	2\n18	15	30	30\n18	15	30	4\n18	15	32	30	32\n18	15	32	1	3\n18	15	37	37\n18	15	37	2\n18	15	39	39\n18	15	39	1\n18	16	0	0\n18	16	0	4\n18	16	6	6	9\n18	16	6	5776	6\n18	16	7	7	10\n18	16	7	2111	1\n18	16	8	7	8\n18	16	8	198	2834\n18	16	9	6	7	8	9	10	11	12	13\n18	16	9	616	96	51	3156	1	1	1	1\n18	16	10	7	8	9	10	11	12	14\n18	16	10	46	47	40	3081	1	1	1\n18	16	11	6	7	8	9	10	11	12	13	15\n18	16	11	1	1	192	72	25	26495	153	17	1\n18	16	12	6	7	8	9	10	11	12	13	14	15	16\n18	16	12	2	88	228	78	177	2050	16218	27	1	7	1\n18	16	13	6	7	8	9	10	11	12	13	14	15\n18	16	13	1	1	18	51	33	421	435	13315	13	96\n18	16	14	6	9	10	11	12	13	14	16	18\n18	16	14	1	23	63	539	405	894	4210	9	2\n18	16	15	9	10	11	12	13	14	15	16\n18	16	15	29	9	91	201	1220	134	8168	13\n18	16	16	11	12	13	14	15	16\n18	16	16	4	7	7	26	17	735\n18	16	17	10	14	17	18	35\n18	16	17	2	1	6	1	1\n18	16	18	9	10	11	12	13	14	15	18\n18	16	18	1	6	2	16	3	14	2	23\n18	16	19	15	18\n18	16	19	1	1\n18	16	20	11	12	13	14	15	16	20\n18	16	20	10	9	7	12	19	992	133\n18	16	21	12	13	14	15	17	20	21	27\n18	16	21	29	17	1	6	1	1	10	1\n18	16	22	22\n18	16	22	1\n18	16	24	12	18	24\n18	16	24	3	1	4\n18	16	26	19\n18	16	26	1\n18	16	27	27\n18	16	27	1\n18	16	28	24	28\n18	16	28	1	1\n18	16	30	26	30\n18	16	30	1	4\n18	16	32	28	30	32\n18	16	32	1	1	1\n18	16	37	37\n18	16	37	2\n18	16	39	39\n18	16	39	1\n18	17	0	0\n18	17	0	4\n18	17	6	6\n18	17	6	6397\n18	17	7	7\n18	17	7	2541\n18	17	8	7	8	13\n18	17	8	95	3272	3\n18	17	9	6	7	8	9	10	12	13\n18	17	9	444	57	51	2897	3	1	3\n18	17	10	7	8	9	10	11	13	18\n18	17	10	25	29	44	3294	1	4	1\n18	17	11	8	9	10	11	12	13	15\n18	17	11	85	55	30	29224	201	14	5\n18	17	12	7	8	9	10	11	12	13	15	16\n18	17	12	5	51	29	158	1143	16054	25	11	2\n18	17	13	6	7	8	9	10	11	12	13	14	15	16\n18	17	13	1	1	33	31	23	259	339	14704	9	103	5\n18	17	14	9	10	11	12	13	14	16\n18	17	14	11	23	61	122	428	3764	4\n18	17	15	6	9	10	11	12	13	14	15	16\n18	17	15	1	3	3	49	72	576	50	7558	5\n18	17	16	11	12	13	14	15	16\n18	17	16	15	19	14	33	27	1642\n18	17	17	17\n18	17	17	7\n18	17	18	12	14	18\n18	17	18	7	7	14\n18	17	19	17\n18	17	19	1\n18	17	20	14	16	18	20\n18	17	20	2	73	1	58\n18	17	21	12	13	15	21\n18	17	21	4	4	1	1\n18	17	22	22\n18	17	22	1\n18	17	24	12	13	21	24\n18	17	24	1	1	1	2\n18	17	26	26\n18	17	26	1\n18	17	27	15	24\n18	17	27	1	1\n18	17	28	25	27\n18	17	28	1	1\n18	17	30	28	30\n18	17	30	3	2\n18	17	32	32\n18	17	32	1\n18	17	35	32\n18	17	35	1\n18	17	37	37\n18	17	37	2\n18	17	39	37\n18	17	39	1\n19	1	0	0\n19	1	0	3\n19	1	6	6	9\n19	1	6	599	42\n19	1	7	7	8	9	10	12\n19	1	7	1240	51	24	1	1\n19	1	8	7	8	9	10	11	12	13\n19	1	8	3	1927	12	5	42	56	3\n19	1	9	6	7	8	9	10	11	12	13	14	15\n19	1	9	1	1	11	1801	10	37	13	11	3	3\n19	1	10	7	9	10	11	12	13	14	15\n19	1	10	1	16	477	5	18	1	10	2\n19	1	11	9	10	11	12	13	14	15	17\n19	1	11	2	19	18478	161	30	12	15	1\n19	1	12	10	11	12	13	14	15	16	21\n19	1	12	2	484	12976	51	39	8	1	5\n19	1	13	8	9	11	12	13	14	15	16	17	20	21\n19	1	13	3	2	36	129	12248	138	128	1	1	1	1\n19	1	14	11	12	13	14	15	16	17	18	19\n19	1	14	5	6	53	3963	15	7	1	1	1\n19	1	15	11	12	13	14	15	16	18	19	21	23\n19	1	15	9	32	257	29	9465	8	3	1	5	1\n19	1	16	12	13	14	15	16	17	20	21\n19	1	16	1	3	35	18	1378	3	135	11\n19	1	17	13	14	15	16	17	18	20	21	23\n19	1	17	2	1	7	1	47	2	1	2	2\n19	1	18	15	18	21	23\n19	1	18	3	37	2	5\n19	1	19	17	19	21\n19	1	19	1	11	1\n19	1	20	20	21\n19	1	20	116	1\n19	1	21	15	21	23	25\n19	1	21	1	28	3	1\n19	1	22	20\n19	1	22	1\n19	1	23	21	23\n19	1	23	1	24\n19	1	24	26\n19	1	24	1\n19	1	25	25	28\n19	1	25	5	1\n19	1	26	23	31\n19	1	26	1	1\n19	1	28	23	28\n19	1	28	1	1\n19	1	31	31	32\n19	1	31	1	1\n19	1	32	32\n19	1	32	1\n19	1	37	37\n19	1	37	1\n19	2	0	0\n19	2	0	3\n19	2	6	6	9\n19	2	6	571	29\n19	2	7	7	8	9	10	12\n19	2	7	1164	42	20	3	16\n19	2	8	7	8	9	10	11	12\n19	2	8	2	1810	5	6	44	125\n19	2	9	7	8	9	10	11	12	13	14	15\n19	2	9	4	8	1818	13	20	15	11	6	4\n19	2	10	7	9	10	11	12	13	14	15\n19	2	10	1	13	449	12	10	3	22	4\n19	2	11	9	10	11	12	13	14	15	16\n19	2	11	2	7	18754	234	50	32	16	1\n19	2	12	11	12	13	14	15	16	21\n19	2	12	439	12809	69	44	14	3	15\n19	2	13	11	12	13	14	15	17	20	21\n19	2	13	32	126	12090	205	201	1	1	3\n19	2	14	12	13	14	15	16	19	20\n19	2	14	6	55	4139	15	10	1	4\n19	2	15	11	12	13	14	15	16	18	20	21	23\n19	2	15	6	21	241	36	9335	7	2	8	7	2\n19	2	16	12	13	14	15	16	17	20	21	23\n19	2	16	1	3	25	21	813	1	523	8	1\n19	2	17	15	16	17	18	20	21	23\n19	2	17	1	1	42	2	3	3	2\n19	2	18	13	15	18	21	23\n19	2	18	2	2	35	1	3\n19	2	19	17	19	21	25\n19	2	19	1	10	1	1\n19	2	20	18	19	20	22	25\n19	2	20	1	1	250	1	1\n19	2	21	17	21	23	25\n19	2	21	1	52	2	2\n19	2	23	21	23\n19	2	23	2	35\n19	2	25	25\n19	2	25	6\n19	2	26	30\n19	2	26	1\n19	2	28	28\n19	2	28	2\n19	2	31	23	31\n19	2	31	1	1\n19	2	32	32\n19	2	32	2\n19	2	37	37\n19	2	37	1\n19	3	0	0\n19	3	0	3\n19	3	6	6\n19	3	6	571\n19	3	7	7\n19	3	7	1171\n19	3	8	7	8\n19	3	8	2	1858\n19	3	9	6	7	8	9	10\n19	3	9	1	2	14	1863	7\n19	3	10	9	10\n19	3	10	7	471\n19	3	11	8	10	11	12	13\n19	3	11	1	10	19270	12	14\n19	3	12	10	11	12	13	14	15\n19	3	12	1	336	13008	11	4	3\n19	3	13	8	9	10	11	12	13	14	15\n19	3	13	1	1	3	14	125	12325	42	13\n19	3	14	11	12	13	14	15	16\n19	3	14	1	7	43	4453	2	3\n19	3	15	11	12	13	14	15	16\n19	3	15	1	18	201	35	9351	7\n19	3	16	13	14	15	16\n19	3	16	2	30	10	793\n19	3	17	13	15	17\n19	3	17	3	2	41\n19	3	18	11	15	16	17	18\n19	3	18	1	1	1	1	36\n19	3	19	15	19	20\n19	3	19	1	10	1\n19	3	20	15	19	20	24\n19	3	20	3	1	784	1\n19	3	21	19	20	21	23\n19	3	21	2	1	88	1\n19	3	22	22\n19	3	22	1\n19	3	23	23\n19	3	23	46\n19	3	25	23	25\n19	3	25	3	7\n19	3	28	28\n19	3	28	2\n19	3	30	30\n19	3	30	1\n19	3	31	31\n19	3	31	1\n19	3	32	28	32\n19	3	32	1	1\n19	3	37	37\n19	3	37	1\n19	4	0	0\n19	4	0	3\n19	4	6	6\n19	4	6	572\n19	4	7	7\n19	4	7	1175\n19	4	8	7	8\n19	4	8	4	1870\n19	4	9	7	8	9	10	13\n19	4	9	5	6	1852	7	1\n19	4	10	9	10\n19	4	10	12	480\n19	4	11	9	10	11	12	13\n19	4	11	1	10	19583	21	8\n19	4	12	10	11	12	13	15\n19	4	12	1	270	12878	18	3\n19	4	13	9	11	12	13	14	15	18\n19	4	13	1	6	107	12436	28	19	2\n19	4	14	11	12	13	14	15	16\n19	4	14	5	8	30	4510	5	6\n19	4	15	11	12	13	14	15	16\n19	4	15	2	11	140	28	9196	9\n19	4	16	12	13	14	15	16	17	18\n19	4	16	1	1	24	9	767	1	1\n19	4	17	10	13	15	17\n19	4	17	1	1	1	39\n19	4	18	14	15	18\n19	4	18	1	4	31\n19	4	19	19\n19	4	19	13\n19	4	20	9	20\n19	4	20	1	785\n19	4	21	9	15	18	21\n19	4	21	1	1	1	85\n19	4	22	22\n19	4	22	1\n19	4	23	15	19	21	23\n19	