/*
 * This file was automatically generated by EvoSuite
 * Fri Jun 08 20:04:08 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.File;
import java.io.OutputStreamWriter;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockPrintStream;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.LineGroup;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.AGWindowAlgorithm;
import uk.ac.sanger.artemis.plot.CodonUsageAlgorithm;
import uk.ac.sanger.artemis.plot.CodonUsageWeight;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class CodonUsageAlgorithm_ESTest extends CodonUsageAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}");
      assertNotNull(fastaStreamSequence0);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(120, (int)integer0);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      MarkerRange markerRange0 = strand1.makeMarkerRangeFromPositions(1, 2);
      assertNotNull(markerRange0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 2933;
      Range range0 = markerRange0.getRawRange();
      assertNotNull(range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getCount());
      
      floatArray0[1] = (float) 5;
      floatArray0[2] = 0.403F;
      floatArray0[3] = (float) (-5);
      codonUsageAlgorithm0.getValues(1, 2933, floatArray0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertArrayEquals(new float[] {1.0F, 1.0F, 1.0F, (-5.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Range range1 = markerRange0.getRawRange();
      assertNotNull(range1);
      assertNotSame(range1, range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(range1.equals((Object)range0));
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, range1.getStart());
      assertEquals(2, range1.getCount());
      assertEquals(2, range1.getEnd());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      Range range2 = range1.copy();
      assertNotNull(range2);
      assertNotSame(range1, range2);
      assertNotSame(range1, range0);
      assertNotSame(range2, range0);
      assertNotSame(range2, range1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(range1.equals((Object)range0));
      assertFalse(range2.equals((Object)range0));
      assertFalse(range2.equals((Object)range1));
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, range1.getStart());
      assertEquals(2, range1.getCount());
      assertEquals(2, range1.getEnd());
      assertEquals(2, range2.getCount());
      assertEquals(2, range2.getEnd());
      assertEquals(1, range2.getStart());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      Integer integer1 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(integer1.equals((Object)integer0));
      assertEquals(500, (int)integer1);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      int int0 = codonUsageAlgorithm0.getValueCount();
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, int0);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Float float0 = codonUsageAlgorithm0.getMaximumInternal();
      assertNotNull(float0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2.0F, (float)float0, 0.01F);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Float float1 = codonUsageAlgorithm0.getAverage();
      assertNull(float1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      codonUsageAlgorithm0.getValues(1, 5, floatArray0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F, (-5.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      // Undeclared exception!
      try { 
        codonUsageAlgorithm0.getValues((-5), 1756, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}");
      assertNotNull(fastaStreamSequence0);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertTrue(file0.isFile());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(file0.isFile());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertTrue(file0.isFile());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(120, (int)integer0);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertTrue(file0.isFile());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      MarkerRange markerRange0 = strand1.makeMarkerRangeFromPositions(1, 2);
      assertNotNull(markerRange0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 2933;
      floatArray0[1] = (float) 5;
      codonUsageAlgorithm0.getValues(1, 2933, floatArray0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertArrayEquals(new float[] {1.0F, 1.0F, 1.0F, 0.0F}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertTrue(file0.isFile());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Range range0 = markerRange0.getRawRange();
      assertNotNull(range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getCount());
      assertEquals(2, range0.getEnd());
      
      Range range1 = range0.copy();
      assertNotNull(range1);
      assertNotSame(range1, range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertNotSame(range0, range1);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(range1.equals((Object)range0));
      assertEquals(1, range1.getStart());
      assertEquals(2, range1.getCount());
      assertEquals(2, range1.getEnd());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getCount());
      assertEquals(2, range0.getEnd());
      
      char[] charArray0 = bases0.getSubSequenceC(range0, 1756);
      assertNotNull(charArray0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertNotSame(range0, range1);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertArrayEquals(new char[] {'n', 'n'}, charArray0);
      assertEquals(2, charArray0.length);
      assertFalse(range0.equals((Object)range1));
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getCount());
      assertEquals(2, range0.getEnd());
      
      Integer integer1 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(integer1.equals((Object)integer0));
      assertEquals(500, (int)integer1);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertTrue(file0.isFile());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      int int0 = codonUsageAlgorithm0.getValueCount();
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, int0);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertTrue(file0.isFile());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      float[] floatArray1 = new float[6];
      assertFalse(floatArray1.equals((Object)floatArray0));
      
      floatArray1[0] = (float) 1;
      floatArray1[0] = (float) 1;
      floatArray1[2] = (float) 100000;
      floatArray1[3] = 0.0F;
      floatArray1[4] = (float) (-5);
      floatArray1[5] = (float) 100000;
      Integer integer2 = codonUsageAlgorithm0.getDefaultMinWindowSize();
      assertNotNull(integer2);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)int0));
      assertFalse(integer2.equals((Object)integer1));
      assertEquals(24, (int)integer2);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertTrue(file0.isFile());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Integer integer3 = codonUsageAlgorithm0.getDefaultStepSize(1905);
      assertNotNull(integer3);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(integer3.equals((Object)int0));
      assertFalse(integer3.equals((Object)integer2));
      assertFalse(integer3.equals((Object)integer0));
      assertFalse(integer3.equals((Object)integer1));
      assertEquals(238, (int)integer3);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertTrue(file0.isFile());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "p-euo`Wne");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}", "*\"5");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(120, (int)integer0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      int int0 = (-6270);
      boolean boolean1 = file0.setExecutable(true, true);
      assertFalse(boolean1 == boolean0);
      assertTrue(boolean1);
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      
      float float0 = codonUsageWeight0.getCodonValue('d', 'D', 'I');
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1.0F, float0, 0.01F);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromRawPositions(2, 2);
      assertNotNull(markerRange0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      Range range0 = markerRange0.getRawRange();
      assertNotNull(range0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getStart());
      
      Range range1 = range0.copy();
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(range1.equals((Object)range0));
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getStart());
      assertEquals(2, range1.getEnd());
      assertEquals(1, range1.getCount());
      assertEquals(2, range1.getStart());
      
      Integer integer1 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer1);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(integer1.equals((Object)int0));
      assertFalse(integer1.equals((Object)integer0));
      assertEquals(500, (int)integer1);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      int int1 = codonUsageAlgorithm0.getValueCount();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(int1 == int0);
      assertEquals(3, int1);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      int int2 = 3672;
      float[] floatArray0 = new float[6];
      floatArray0[0] = (float) 1;
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) (-6270);
      floatArray0[3] = 0.0F;
      Integer integer2 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer2);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(integer2.equals((Object)int2));
      assertFalse(integer2.equals((Object)int0));
      assertFalse(integer2.equals((Object)int1));
      assertTrue(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)integer0));
      assertEquals(500, (int)integer2);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Integer integer3 = codonUsageAlgorithm0.getDefaultStepSize(451);
      assertNotNull(integer3);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(integer3.equals((Object)integer2));
      assertFalse(integer3.equals((Object)int2));
      assertFalse(integer3.equals((Object)int1));
      assertFalse(integer3.equals((Object)integer0));
      assertFalse(integer3.equals((Object)int0));
      assertFalse(integer3.equals((Object)integer1));
      assertEquals(56, (int)integer3);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      floatArray0[4] = (float) (-5);
      // Undeclared exception!
      try { 
        codonUsageAlgorithm0.getFeatureScore((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.CodonUsageAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(120, (int)integer0);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      MarkerRange markerRange0 = strand1.makeMarkerRangeFromPositions(1, 2);
      assertNotNull(markerRange0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 2933;
      floatArray0[1] = (float) 5;
      floatArray0[2] = 0.403F;
      floatArray0[3] = (float) (-5);
      codonUsageAlgorithm0.getValues(1, 2933, floatArray0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertArrayEquals(new float[] {1.0F, 1.0F, 1.0F, (-5.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Range range0 = markerRange0.getRawRange();
      assertNotNull(range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      Range range1 = range0.copy();
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(range1.equals((Object)range0));
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(2, range1.getEnd());
      assertEquals(1, range1.getStart());
      assertEquals(2, range1.getCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      Integer integer1 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(integer1.equals((Object)integer0));
      assertEquals(500, (int)integer1);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      int int0 = codonUsageAlgorithm0.getValueCount();
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, int0);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      float[] floatArray1 = new float[6];
      assertFalse(floatArray1.equals((Object)floatArray0));
      
      floatArray1[0] = (float) 1;
      floatArray1[0] = (float) 1;
      floatArray1[2] = (float) 100000;
      floatArray1[3] = 0.0F;
      floatArray1[4] = (float) (-5);
      floatArray1[5] = (float) 100000;
      Float float0 = codonUsageAlgorithm0.getMaximumInternal();
      assertNotNull(float0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2.0F, (float)float0, 0.01F);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Integer integer2 = codonUsageAlgorithm0.getDefaultStepSize(1);
      assertNull(integer2);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(120, (int)integer0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      MarkerRange markerRange0 = strand1.makeMarkerRangeFromPositions(1, 2);
      assertNotNull(markerRange0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 2933;
      floatArray0[1] = (float) 5;
      floatArray0[2] = 0.403F;
      floatArray0[3] = (float) (-5);
      codonUsageAlgorithm0.getValues(1, 2933, floatArray0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertArrayEquals(new float[] {1.0F, 1.0F, 1.0F, (-5.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      Range range0 = markerRange0.getRawRange();
      assertNotNull(range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getCount());
      assertEquals(1, range0.getStart());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      Range range1 = range0.copy();
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(range1.equals((Object)range0));
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getCount());
      assertEquals(1, range0.getStart());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, range1.getCount());
      assertEquals(1, range1.getStart());
      assertEquals(2, range1.getEnd());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      Integer integer1 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(integer1.equals((Object)integer0));
      assertEquals(500, (int)integer1);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      int int0 = codonUsageAlgorithm0.getValueCount();
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, int0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      Float float0 = codonUsageAlgorithm0.getMaximumInternal();
      assertNotNull(float0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2.0F, (float)float0, 0.01F);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      Float float1 = codonUsageAlgorithm0.getAverage();
      assertNull(float1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}");
      assertNotNull(fastaStreamSequence0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(120, (int)integer0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      MarkerRange markerRange0 = strand1.makeMarkerRangeFromPositions(1, 2);
      assertNotNull(markerRange0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 2933;
      floatArray0[1] = (float) 5;
      floatArray0[3] = (float) (-5);
      codonUsageAlgorithm0.getValues(1, 2933, floatArray0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertArrayEquals(new float[] {1.0F, 1.0F, 1.0F, (-5.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      Range range0 = markerRange0.getRawRange();
      assertNotNull(range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      Range range1 = range0.copy();
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(range1.equals((Object)range0));
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getCount());
      assertEquals(2, range1.getEnd());
      assertEquals(2, range1.getCount());
      assertEquals(1, range1.getStart());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      char[] charArray0 = bases0.getSubSequenceC(range0, 1756);
      assertNotNull(charArray0);
      assertNotSame(range0, range1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertArrayEquals(new char[] {'n', 'n'}, charArray0);
      assertEquals(2, charArray0.length);
      assertFalse(range0.equals((Object)range1));
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      Integer integer1 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(integer1.equals((Object)integer0));
      assertEquals(500, (int)integer1);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      int int0 = codonUsageAlgorithm0.getValueCount();
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, int0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      float[] floatArray1 = new float[6];
      assertFalse(floatArray1.equals((Object)floatArray0));
      
      floatArray1[0] = (float) 1;
      floatArray1[0] = (float) 1;
      floatArray1[2] = (float) 100000;
      floatArray1[3] = 0.0F;
      floatArray1[4] = (float) (-5);
      floatArray1[5] = (float) 100000;
      Integer integer2 = codonUsageAlgorithm0.getDefaultMinWindowSize();
      assertNotNull(integer2);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(integer2.equals((Object)int0));
      assertFalse(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)integer0));
      assertEquals(24, (int)integer2);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertEquals(0L, file0.length());
      assertTrue(file0.exists());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertFalse(file0.isDirectory());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canWrite());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0L, file0.length());
      assertTrue(file0.exists());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertFalse(file0.isDirectory());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canWrite());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(0L, file0.length());
      assertTrue(file0.exists());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertFalse(file0.isDirectory());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canWrite());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(120, (int)integer0);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(0L, file0.length());
      assertTrue(file0.exists());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertFalse(file0.isDirectory());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canWrite());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      
      int int0 = 100000;
      int int1 = 1756;
      MarkerRange markerRange0 = strand1.makeMarkerRangeFromPositions(1, 2);
      assertNotNull(markerRange0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 1;
      floatArray0[1] = (float) 5;
      floatArray0[2] = 0.403F;
      floatArray0[3] = (float) (-5);
      // Undeclared exception!
      try { 
        codonUsageAlgorithm0.getValues(1, (-5), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 1 > end: -3
         //
         verifyException("uk.ac.sanger.artemis.plot.CodonUsageAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "p-euo`Wne");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}", "*\"5");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      boolean boolean1 = file0.setExecutable(true, true);
      assertFalse(boolean1 == boolean0);
      assertTrue(boolean1);
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromRawPositions(2, 2);
      assertNotNull(markerRange0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      
      Range range0 = markerRange0.getRawRange();
      assertNotNull(range0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      
      Range range1 = range0.copy();
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(range1.equals((Object)range0));
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(2, range1.getStart());
      assertEquals(1, range1.getCount());
      assertEquals(2, range1.getEnd());
      
      float[] floatArray0 = new float[6];
      floatArray0[0] = (float) 1;
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) (-6270);
      floatArray0[3] = 0.0F;
      floatArray0[4] = (float) (-5);
      floatArray0[5] = (float) (-6270);
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      Float float0 = codonUsageAlgorithm0.getMaximumInternal();
      assertNotNull(float0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2.0F, (float)float0, 0.01F);
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertFalse(file0.isDirectory());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertFalse(file0.isDirectory());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertFalse(file0.isDirectory());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(120, (int)integer0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertFalse(file0.isDirectory());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      MarkerRange markerRange0 = strand1.makeMarkerRangeFromPositions(1, 2);
      assertNotNull(markerRange0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 2933;
      floatArray0[1] = (float) 5;
      floatArray0[2] = 0.403F;
      floatArray0[3] = (float) (-5);
      codonUsageAlgorithm0.getValues(1, 2933, floatArray0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertArrayEquals(new float[] {1.0F, 1.0F, 1.0F, (-5.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertFalse(file0.isDirectory());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Range range0 = markerRange0.getRawRange();
      assertNotNull(range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, range0.getEnd());
      assertEquals(2, range0.getCount());
      assertEquals(2, range0.getStart());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      
      Range range1 = range0.copy();
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(range1.equals((Object)range0));
      assertEquals(3, range0.getEnd());
      assertEquals(2, range0.getCount());
      assertEquals(2, range0.getStart());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, range1.getCount());
      assertEquals(2, range1.getStart());
      assertEquals(3, range1.getEnd());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      
      char[] charArray0 = bases0.getSubSequenceC(range0, 1756);
      assertNotNull(charArray0);
      assertNotSame(range0, range1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertArrayEquals(new char[] {'n', 'n'}, charArray0);
      assertEquals(2, charArray0.length);
      assertFalse(range0.equals((Object)range1));
      assertEquals(3, range0.getEnd());
      assertEquals(2, range0.getCount());
      assertEquals(2, range0.getStart());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      
      Integer integer1 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(integer1.equals((Object)integer0));
      assertEquals(500, (int)integer1);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertFalse(file0.isDirectory());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      int int0 = codonUsageAlgorithm0.getValueCount();
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, int0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertFalse(file0.isDirectory());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      float[] floatArray1 = new float[6];
      assertFalse(floatArray1.equals((Object)floatArray0));
      
      floatArray1[0] = (float) 1;
      floatArray1[1] = (float) 1;
      floatArray1[2] = (float) 100000;
      floatArray1[3] = 0.0F;
      floatArray1[4] = (float) (-5);
      floatArray1[5] = (float) 100000;
      // Undeclared exception!
      try { 
        aGWindowAlgorithm0.getValues(3672, 0, floatArray1);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 3672 > end: 0
         //
         verifyException("uk.ac.sanger.artemis.plot.AGWindowAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}", "*\"5");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      
      MockPrintStream mockPrintStream0 = new MockPrintStream("Kz}");
      assertNotNull(mockPrintStream0);
      
      OutputStreamWriter outputStreamWriter0 = new OutputStreamWriter(mockPrintStream0);
      assertNotNull(outputStreamWriter0);
      
      LineGroup.writeEndOfEMBLEntry(outputStreamWriter0);
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.canExecute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.canExecute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.canExecute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(120, (int)integer0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.canExecute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      
      Float float0 = codonUsageAlgorithm0.getMinimumInternal();
      assertNotNull(float0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.canExecute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      
      int int0 = 100000;
      int int1 = 1756;
      MarkerRange markerRange0 = null;
      try {
        markerRange0 = new MarkerRange(strand1, 100000, 1756);
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // position: 1756
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      File file0 = MockFile.createTempFile("Kz}", "Kz}");
      assertNotNull(file0);
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/Kz}0Kz}", file0.toString());
      assertEquals("Kz}0Kz}", file0.getName());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/Kz}0Kz}", file0.toString());
      assertEquals("Kz}0Kz}", file0.getName());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("Kz}0Kz}", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/Kz}0Kz}", file0.toString());
      assertEquals("Kz}0Kz}", file0.getName());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("Kz}0Kz}", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("Codon Usage Scores from Kz}0Kz}", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(120, (int)integer0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/Kz}0Kz}", file0.toString());
      assertEquals("Kz}0Kz}", file0.getName());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertTrue(file0.isFile());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("Kz}0Kz}", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("Codon Usage Scores from Kz}0Kz}", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      int int0 = 100000;
      int int1 = 1756;
      MarkerRange markerRange0 = strand1.makeMarkerRangeFromPositions(1, 2);
      assertNotNull(markerRange0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 1;
      floatArray0[1] = (float) 5;
      floatArray0[2] = 0.403F;
      floatArray0[3] = (float) (-5);
      // Undeclared exception!
      codonUsageAlgorithm0.getValues(1, 100000, floatArray0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "p-euo`Wne");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}", "*\"5");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.isAbsolute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.isAbsolute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.isAbsolute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertNull(codonUsageAlgorithm0.getAverage());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(120, (int)integer0);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.isAbsolute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertNull(codonUsageAlgorithm0.getAverage());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      
      boolean boolean1 = file0.setExecutable(true, true);
      assertFalse(boolean1 == boolean0);
      assertTrue(boolean1);
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.isAbsolute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromRawPositions(2, 2);
      assertNotNull(markerRange0);
      assertSame(strand0, strand1);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      Range range0 = markerRange0.getRawRange();
      assertNotNull(range0);
      assertSame(strand0, strand1);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getStart());
      
      Range range1 = range0.copy();
      assertNotNull(range1);
      assertSame(strand0, strand1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(range1.equals((Object)range0));
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getStart());
      assertEquals(2, range1.getEnd());
      assertEquals(1, range1.getCount());
      assertEquals(2, range1.getStart());
      
      Integer integer1 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(integer1.equals((Object)integer0));
      assertEquals(500, (int)integer1);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.isAbsolute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertNull(codonUsageAlgorithm0.getAverage());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      
      int int0 = codonUsageAlgorithm0.getValueCount();
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, int0);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.isAbsolute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertNull(codonUsageAlgorithm0.getAverage());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      
      float[] floatArray0 = new float[6];
      floatArray0[0] = (float) 1;
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) (-6270);
      floatArray0[3] = 0.0F;
      Integer integer2 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer2);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertTrue(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)int0));
      assertEquals(500, (int)integer2);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.isAbsolute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertNull(codonUsageAlgorithm0.getAverage());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      
      Integer integer3 = codonUsageAlgorithm0.getDefaultStepSize(451);
      assertNotNull(integer3);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(integer3.equals((Object)integer2));
      assertFalse(integer3.equals((Object)integer1));
      assertFalse(integer3.equals((Object)integer0));
      assertFalse(integer3.equals((Object)int0));
      assertEquals(56, (int)integer3);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.isAbsolute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertNull(codonUsageAlgorithm0.getAverage());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      
      floatArray0[4] = (float) (-5);
      floatArray0[5] = (float) (-6270);
      // Undeclared exception!
      try { 
        aGWindowAlgorithm0.getValues(3672, (-6270), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 3672 > end: -6270
         //
         verifyException("uk.ac.sanger.artemis.plot.AGWindowAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}");
      assertNotNull(fastaStreamSequence0);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.exists());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.exists());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.exists());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(120, (int)integer0);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.exists());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      MarkerRange markerRange0 = strand1.makeMarkerRangeFromPositions(1, 2);
      assertNotNull(markerRange0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 2933;
      floatArray0[1] = (float) 5;
      floatArray0[2] = 0.403F;
      floatArray0[3] = (float) (-5);
      codonUsageAlgorithm0.getValues(1, 2933, floatArray0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertArrayEquals(new float[] {1.0F, 1.0F, 1.0F, (-5.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.exists());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      Range range0 = markerRange0.getRawRange();
      assertNotNull(range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      Range range1 = range0.copy();
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(range1.equals((Object)range0));
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(1, range1.getStart());
      assertEquals(2, range1.getEnd());
      assertEquals(2, range1.getCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      char[] charArray0 = bases0.getSubSequenceC(range0, 1756);
      assertNotNull(charArray0);
      assertNotSame(range0, range1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertArrayEquals(new char[] {'n', 'n'}, charArray0);
      assertEquals(2, charArray0.length);
      assertFalse(range0.equals((Object)range1));
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      Integer integer1 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(integer1.equals((Object)integer0));
      assertEquals(500, (int)integer1);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.exists());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      int int0 = codonUsageAlgorithm0.getValueCount();
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, int0);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.isFile());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.exists());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.canExecute());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      float[] floatArray1 = new float[6];
      assertFalse(floatArray1.equals((Object)floatArray0));
      
      floatArray1[0] = (float) 1;
      floatArray1[1] = (float) 1;
      floatArray1[2] = (float) 100000;
      floatArray1[3] = 0.0F;
      floatArray1[4] = (float) (-5);
      floatArray1[5] = (float) 100000;
      // Undeclared exception!
      try { 
        aGWindowAlgorithm0.getValues(3672, 0, floatArray1);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 3672 > end: 0
         //
         verifyException("uk.ac.sanger.artemis.plot.AGWindowAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "p-euo`Wne");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}", "*\"5");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.exists());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.exists());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.exists());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(120, (int)integer0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.exists());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromRawPositions(2, 2);
      assertNotNull(markerRange0);
      assertSame(strand0, strand1);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      
      Range range0 = markerRange0.getRawRange();
      assertNotNull(range0);
      assertSame(strand0, strand1);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      
      Range range1 = range0.copy();
      assertNotNull(range1);
      assertSame(strand0, strand1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(range1.equals((Object)range0));
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(1, range1.getCount());
      assertEquals(2, range1.getEnd());
      assertEquals(2, range1.getStart());
      
      char[] charArray0 = bases0.getSubSequenceC(range0, 1756);
      assertNotNull(charArray0);
      assertSame(strand0, strand1);
      assertNotSame(range0, range1);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertArrayEquals(new char[] {'n'}, charArray0);
      assertEquals(1, charArray0.length);
      assertFalse(range0.equals((Object)range1));
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      
      Integer integer1 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(integer1.equals((Object)integer0));
      assertEquals(500, (int)integer1);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.exists());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      
      int int0 = codonUsageAlgorithm0.getValueCount();
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, int0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.exists());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      
      float[] floatArray0 = new float[6];
      floatArray0[0] = (float) 1;
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) (-6270);
      floatArray0[3] = 0.0F;
      floatArray0[4] = (float) (-5);
      floatArray0[5] = (float) (-6270);
      // Undeclared exception!
      try { 
        aGWindowAlgorithm0.getValues(3672, 0, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 3672 > end: 0
         //
         verifyException("uk.ac.sanger.artemis.plot.AGWindowAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = null;
      try {
        codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, (CodonUsageWeight) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.CodonUsageAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}", "*\"5");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isAbsolute());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isAbsolute());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isAbsolute());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(120, (int)integer0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.isAbsolute());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      
      int int0 = 100000;
      int int1 = 1756;
      MarkerRange markerRange0 = null;
      try {
        markerRange0 = new MarkerRange(strand1, 100000, 1756);
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // position: 1756
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = null;
      try {
        codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, (CodonUsageWeight) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.CodonUsageAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      CodonUsageAlgorithm codonUsageAlgorithm0 = null;
      try {
        codonUsageAlgorithm0 = new CodonUsageAlgorithm((Strand) null, (CodonUsageWeight) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.CodonUsageAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "p-euo`Wne");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}", "*\"5");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(120, (int)integer0);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      boolean boolean1 = file0.setExecutable(true, true);
      assertFalse(boolean1 == boolean0);
      assertTrue(boolean1);
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      
      float float0 = codonUsageWeight0.getCodonValue('d', 'D', 'I');
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1.0F, float0, 0.01F);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromRawPositions(2, 2);
      assertNotNull(markerRange0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      Range range0 = markerRange0.getRawRange();
      assertNotNull(range0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      
      Range range1 = range0.copy();
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(range1.equals((Object)range0));
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(2, range1.getEnd());
      assertEquals(1, range1.getCount());
      assertEquals(2, range1.getStart());
      
      Integer integer1 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer1);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(integer1.equals((Object)integer0));
      assertEquals(500, (int)integer1);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      int int0 = codonUsageAlgorithm0.getValueCount();
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, int0);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      float[] floatArray0 = new float[6];
      floatArray0[0] = (float) 1;
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) (-6270);
      floatArray0[3] = 0.0F;
      Integer integer2 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer2);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertTrue(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)int0));
      assertFalse(integer2.equals((Object)integer0));
      assertEquals(500, (int)integer2);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      Integer integer3 = codonUsageAlgorithm0.getDefaultStepSize(451);
      assertNotNull(integer3);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(integer3.equals((Object)integer2));
      assertFalse(integer3.equals((Object)integer1));
      assertFalse(integer3.equals((Object)int0));
      assertFalse(integer3.equals((Object)integer0));
      assertEquals(56, (int)integer3);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canExecute());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      floatArray0[4] = (float) (-5);
      // Undeclared exception!
      try { 
        codonUsageAlgorithm0.getFeatureScore((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.CodonUsageAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}");
      assertNotNull(fastaStreamSequence0);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      MarkerRange markerRange0 = strand1.makeMarkerRangeFromPositions(1, 2);
      assertNotNull(markerRange0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 2933;
      Range range0 = markerRange0.getRawRange();
      assertNotNull(range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getCount());
      assertEquals(2, range0.getEnd());
      
      floatArray0[1] = (float) 5;
      floatArray0[2] = 0.403F;
      floatArray0[3] = (float) (-5);
      codonUsageAlgorithm0.getValues(1, 2933, floatArray0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertArrayEquals(new float[] {1.0F, 1.0F, 1.0F, (-5.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      Range range1 = markerRange0.getRawRange();
      assertNotNull(range1);
      assertNotSame(range1, range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(range1.equals((Object)range0));
      assertEquals(2, range1.getCount());
      assertEquals(2, range1.getEnd());
      assertEquals(1, range1.getStart());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      Range range2 = range1.copy();
      assertNotNull(range2);
      assertNotSame(range1, range2);
      assertNotSame(range1, range0);
      assertNotSame(range2, range1);
      assertNotSame(range2, range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(range1.equals((Object)range0));
      assertFalse(range2.equals((Object)range1));
      assertFalse(range2.equals((Object)range0));
      assertEquals(2, range1.getCount());
      assertEquals(2, range1.getEnd());
      assertEquals(1, range1.getStart());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, range2.getEnd());
      assertEquals(1, range2.getStart());
      assertEquals(2, range2.getCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      
      int int0 = codonUsageAlgorithm0.getValueCount();
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, int0);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      Float float0 = codonUsageAlgorithm0.getMaximumInternal();
      assertNotNull(float0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2.0F, (float)float0, 0.01F);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      Float float1 = codonUsageAlgorithm0.getAverage();
      assertNull(float1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      codonUsageAlgorithm0.getValues(1, 5, floatArray0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F, (-5.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultStepSize(5);
      assertNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      Integer integer1 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(integer1.equals((Object)int0));
      assertEquals(500, (int)integer1);
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertTrue(strand1.isForwardStrand());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}");
      assertNotNull(fastaStreamSequence0);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(120, (int)integer0);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      MarkerRange markerRange0 = strand1.makeMarkerRangeFromPositions(1, 2);
      assertNotNull(markerRange0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 2933;
      floatArray0[1] = (float) 5;
      floatArray0[3] = (float) (-5);
      codonUsageAlgorithm0.getValues(1, 2933, floatArray0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertArrayEquals(new float[] {1.0F, 1.0F, 1.0F, (-5.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      Range range0 = markerRange0.getRawRange();
      assertNotNull(range0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      char[] charArray0 = bases0.getSubSequenceC(range0, 1756);
      assertNotNull(charArray0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertArrayEquals(new char[] {'n', 'n'}, charArray0);
      assertEquals(2, charArray0.length);
      assertEquals(1, range0.getStart());
      assertEquals(2, range0.getCount());
      assertEquals(2, range0.getEnd());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      Integer integer1 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(integer1.equals((Object)integer0));
      assertEquals(500, (int)integer1);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      int int0 = codonUsageAlgorithm0.getValueCount();
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, int0);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      float[] floatArray1 = new float[6];
      assertFalse(floatArray1.equals((Object)floatArray0));
      
      floatArray1[0] = (float) 1;
      floatArray1[4] = (float) 1;
      floatArray1[2] = (float) 100000;
      floatArray1[3] = 0.0F;
      floatArray1[4] = (float) (-5);
      floatArray1[5] = (float) 100000;
      Integer integer2 = codonUsageAlgorithm0.getDefaultMinWindowSize();
      assertNotNull(integer2);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)int0));
      assertFalse(integer2.equals((Object)integer0));
      assertEquals(24, (int)integer2);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.canRead());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.exists());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isDirectory());
      assertTrue(file0.canWrite());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      
      // Undeclared exception!
      try { 
        codonUsageAlgorithm0.getValues(2, 3, floatArray1);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 2 > end: 1
         //
         verifyException("uk.ac.sanger.artemis.plot.CodonUsageAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}");
      assertNotNull(fastaStreamSequence0);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(120, (int)integer0);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      MarkerRange markerRange0 = strand1.makeMarkerRangeFromPositions(1, 2);
      assertNotNull(markerRange0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 2933;
      codonUsageAlgorithm0.setRevCompDisplay(true);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(0L, file0.length());
      assertTrue(file0.isFile());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canWrite());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertFalse(file0.isHidden());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertTrue(codonUsageAlgorithm0.isRevCompDisplay());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      
      floatArray0[1] = (float) 5;
      floatArray0[2] = 0.403F;
      // Undeclared exception!
      try { 
        codonUsageAlgorithm0.getValues(1, 2933, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}", "*\"5");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(120, (int)integer0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      
      Float float0 = codonUsageAlgorithm0.getMinimumInternal();
      assertNotNull(float0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      
      MarkerRange markerRange0 = null;
      try {
        markerRange0 = new MarkerRange(strand1, 100000, 1756);
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // position: 1756
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "pseudogene");
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}");
      assertNotNull(fastaStreamSequence0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      boolean boolean1 = FileSystemHandling.setPermissions((EvoSuiteFile) null, false, false, false);
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      
      Strand strand1 = bases0.getReverseStrand();
      assertNotNull(strand1);
      assertNotSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand1.equals((Object)strand0));
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      assertNotNull(file0);
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.isFile());
      assertTrue(file0.canExecute());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand0.equals((Object)strand1));
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.isFile());
      assertTrue(file0.canExecute());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand1, codonUsageWeight0);
      assertNotNull(codonUsageAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.isFile());
      assertTrue(file0.canExecute());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      MarkerRange markerRange0 = strand1.makeMarkerRangeFromPositions(1, 2);
      assertNotNull(markerRange0);
      assertNotSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand1.equals((Object)strand0));
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 2933;
      floatArray0[1] = (float) 5;
      floatArray0[2] = 2933.0F;
      floatArray0[3] = (float) (-5);
      codonUsageAlgorithm0.getValues(1, 2933, floatArray0);
      assertNotSame(strand0, strand1);
      assertNotSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertArrayEquals(new float[] {1.0F, 1.0F, 1.0F, (-5.0F)}, floatArray0, 0.01F);
      assertEquals(4, floatArray0.length);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.isFile());
      assertTrue(file0.canExecute());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      Range range0 = markerRange0.getRange();
      assertNotNull(range0);
      assertNotSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand1.equals((Object)strand0));
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getCount());
      assertEquals(1, range0.getStart());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      
      int int0 = markerRange0.getCount();
      assertNotSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand1.equals((Object)strand0));
      assertEquals(2, int0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      
      Range range1 = range0.copy();
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertNotSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(range1.equals((Object)range0));
      assertFalse(strand1.equals((Object)strand0));
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getCount());
      assertEquals(1, range0.getStart());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, range1.getEnd());
      assertEquals(1, range1.getStart());
      assertEquals(2, range1.getCount());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      
      char[] charArray0 = bases0.getSubSequenceC(range0, 1756);
      assertNotNull(charArray0);
      assertNotSame(range0, range1);
      assertNotSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertArrayEquals(new char[] {'n', 'n'}, charArray0);
      assertEquals(2, charArray0.length);
      assertFalse(range0.equals((Object)range1));
      assertFalse(strand1.equals((Object)strand0));
      assertEquals(2, range0.getEnd());
      assertEquals(2, range0.getCount());
      assertEquals(1, range0.getStart());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      
      Integer integer0 = codonUsageAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer0);
      assertNotSame(strand0, strand1);
      assertNotSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(integer0.equals((Object)int0));
      assertFalse(strand1.equals((Object)strand0));
      assertEquals(500, (int)integer0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.isFile());
      assertTrue(file0.canExecute());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      
      int int1 = codonUsageAlgorithm0.getValueCount();
      assertNotSame(strand0, strand1);
      assertNotSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(int1 == int0);
      assertFalse(strand1.equals((Object)strand0));
      assertEquals(3, int1);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertFalse(strand1.isForwardStrand());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertFalse(file0.isDirectory());
      assertTrue(file0.exists());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canRead());
      assertEquals("*\"50*\"5", file0.getName());
      assertTrue(file0.isFile());
      assertTrue(file0.canExecute());
      assertFalse(file0.isHidden());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/*\"50*\"5", file0.toString());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(0L, file0.length());
      assertEquals("*\"50*\"5", codonUsageWeight0.getName());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse Codon Usage Scores from *\"50*\"5", codonUsageAlgorithm0.getAlgorithmName());
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Kz}");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      File file0 = MockFile.createTempFile("*\"5", "*\"5");
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      codonUsageAlgorithm0.getDefaultWindowSize();
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromPositions(1, 2);
      float[] floatArray0 = new float[4];
      floatArray0[1] = (float) 5;
      codonUsageAlgorithm0.getValues(1, 2933, floatArray0);
      Range range0 = markerRange0.getRawRange();
      range0.copy();
      bases0.getSubSequenceC(range0, 1756);
      codonUsageAlgorithm0.getDefaultMaxWindowSize();
      codonUsageAlgorithm0.getValueCount();
      float[] floatArray1 = new float[6];
      floatArray1[0] = (float) 1;
      floatArray1[0] = (float) 1;
      floatArray1[2] = (float) 8847;
      floatArray1[3] = 0.0F;
      floatArray1[4] = (float) (-5);
      codonUsageAlgorithm0.getDefaultMinWindowSize();
      codonUsageAlgorithm0.getDefaultStepSize(1905);
      //  // Unstable assertion: assertEquals("Codon Usage Scores from *\"51*\"5", codonUsageAlgorithm0.getAlgorithmName());
  }
}
