#ifndef ATL_dGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,240,480,600,720,840,1080,1200,1320,1440,1680,1920,2040,2160,2280
 * N : 25,240,480,600,720,840,1080,1200,1320,1440,1680,1920,2040,2160,2280
 * NB : 2,12,12,24,24,24,40,48,48,48,160,160,160,160,240
 */
#define ATL_dGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 132) (nb_) = 2; \
   else if ((n_) < 540) (nb_) = 12; \
   else if ((n_) < 960) (nb_) = 24; \
   else if ((n_) < 1140) (nb_) = 40; \
   else if ((n_) < 1560) (nb_) = 48; \
   else if ((n_) < 2220) (nb_) = 160; \
   else (nb_) = 240; \
}


#endif    /* end ifndef ATL_dGetNB_geqrf */
