/* This file is part of the 'atomes' software

'atomes' is free software: you can redistribute it and/or modify it under the terms
of the GNU Affero General Public License as published by the Free Software Foundation,
either version 3 of the License, or (at your option) any later version.

'atomes' is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU Affero General Public License along with 'atomes'.
If not, see <https://www.gnu.org/licenses/>

Copyright (C) 2022-2024 by CNRS and University of Strasbourg */

/*!
* @file cp2k_pot.c
* @short CP2K potentials, as distributed with CP2K v9.1
* @author Sébastien Le Roux <sebastien.leroux@ipcms.unistra.fr>
*/

/*
* This file: 'cp2k_pot.c'
*
* Contains:
*

  - CP2K potentials, as distributed with CP2K v9.1

  This file contains 3 tables:

  pot_elem -> the list of chemical elements
  pot_keys -> the list of keywords
  cp2k_pot -> finally the complete potential

*/

#include "global.h"

char * pot_elem[421] = {"H",
"He",
"Li",
"Be",
"B",
"C",
"N",
"O",
"F",
"Ne",
"Na",
"Mg",
"Mg",
"Al",
"Si",
"P",
"S",
"Cl",
"Ar",
"K",
"Ca",
"Sc",
"Ti",
"V",
"Cr",
"Mn",
"Fe",
"Co",
"Ni",
"Cu",
"Cu",
"Zn",
"Zn",
"Ga",
"Ga",
"Ge",
"As",
"Se",
"Br",
"Kr",
"Rb",
"Sr",
"Y",
"Zr",
"Mo",
"Ru",
"Rh",
"Pd",
"Ag",
"Ag",
"In",
"In",
"Sb",
"Te",
"I",
"Xe",
"Cs",
"Ba",
"Ba",
"Ce",
"Gd",
"W",
"Au",
"Au",
"Pb",
"Bi",
"Bi",
"H",
"He",
"Li",
"Be",
"B",
"C",
"N",
"O",
"F",
"Ne",
"Na",
"Na",
"Mg",
"Al",
"Si",
"P",
"S",
"Cl",
"Ar",
"K",
"Ca",
"Sc",
"Ti",
"V",
"Cr",
"Mn",
"Fe",
"Co",
"Ni",
"Cu",
"Zn",
"Ga",
"Ge",
"As",
"Se",
"Br",
"Kr",
"Zr",
"Ru",
"Te",
"Cs",
"Cs",
"Au",
"H",
"C",
"N",
"O",
"F",
"P",
"Ar",
"H",
"C",
"N",
"O",
"H",
"He",
"Li",
"Li",
"Be",
"Be",
"B",
"C",
"N",
"O",
"F",
"Ne",
"Na",
"Na",
"Mg",
"Mg",
"Al",
"Si",
"P",
"S",
"Cl",
"Ar",
"K",
"K",
"Ca",
"Ca",
"Sc",
"Sc",
"Ti",
"Ti",
"V",
"V",
"Cr",
"Cr",
"Mn",
"Mn",
"Fe",
"Fe",
"Co",
"Co",
"Ni",
"Ni",
"Cu",
"Cu",
"Cu",
"Zn",
"Zn",
"Zn",
"Ga",
"Ga",
"Ge",
"As",
"Se",
"Br",
"Kr",
"Rb",
"Rb",
"Sr",
"Sr",
"Y",
"Y",
"Zr",
"Zr",
"Nb",
"Nb",
"Mo",
"Mo",
"Tc",
"Tc",
"Ru",
"Ru",
"Rh",
"Rh",
"Pd",
"Pd",
"Ag",
"Ag",
"Ag",
"Cd",
"Cd",
"In",
"In",
"Sn",
"Sb",
"Te",
"I",
"Xe",
"Cs",
"Cs",
"Ba",
"Ba",
"La",
"Ce",
"Pr",
"Nd",
"Pm",
"Sm",
"Eu",
"Gd",
"Tb",
"Dy",
"Ho",
"Er",
"Tm",
"Yb",
"Lu",
"Hf",
"Ta",
"Ta",
"W",
"W",
"Re",
"Re",
"Os",
"Os",
"Ir",
"Ir",
"Pt",
"Pt",
"Au",
"Au",
"Au",
"Hg",
"Hg",
"Tl",
"Tl",
"Pb",
"Bi",
"Po",
"At",
"Rn",
"H",
"He",
"Li",
"Be",
"B",
"C",
"N",
"O",
"F",
"Ne",
"Na",
"Mg",
"Mg",
"Al",
"Si",
"P",
"S",
"Cl",
"Ar",
"K",
"Ca",
"Sc",
"Ti",
"V",
"Cr",
"Mn",
"Fe",
"Co",
"Ni",
"Cu",
"Cu",
"Zn",
"Zn",
"Ga",
"Ga",
"Ge",
"As",
"Se",
"Br",
"Kr",
"Rb",
"Sr",
"Y",
"Zr",
"Nb",
"Mo",
"Tc",
"Ru",
"Ru",
"Rh",
"Rh",
"Pd",
"Pd",
"Ag",
"Ag",
"Cd",
"In",
"In",
"Sn",
"Sb",
"Te",
"I",
"Xe",
"Cs",
"Ba",
"La",
"Ce",
"Ce",
"Pr",
"Nd",
"Pm",
"Sm",
"Eu",
"Gd",
"Tb",
"Dy",
"Ho",
"Er",
"Tm",
"Yb",
"Lu",
"Hf",
"Ta",
"Ta",
"W",
"W",
"Re",
"Re",
"Os",
"Os",
"Ir",
"Ir",
"Pt",
"Pt",
"Au",
"Au",
"Hg",
"Tl",
"Tl",
"Pb",
"Pb",
"Bi",
"Bi",
"Po",
"At",
"Rn",
"U",
"B",
"H",
"B",
"C",
"N",
"O",
"F",
"P",
"S",
"Cl",
"H",
"C",
"N",
"O",
"Al",
"B",
"C",
"Cl",
"F",
"H",
"N",
"O",
"P",
"S",
"Si",
"H",
"He",
"Li",
"Be",
"B",
"C",
"N",
"O",
"F",
"Ne",
"Na",
"Mg",
"Al",
"Si",
"P",
"S",
"Cl",
"Ar",
"K",
"Ca",
"Sc",
"Ti",
"V",
"Cr",
"Mn",
"Fe",
"Co",
"Ni",
"Cu",
"Zn",
"Ga",
"Ge",
"As",
"Se",
"Br",
"Kr",
"I"};

char * pot_keys[421] = {"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP-q2",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP-q19",
"GTH-BLYP",
"GTH-BLYP-q20",
"GTH-BLYP",
"GTH-BLYP-q3",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP-q9",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP-q19",
"GTH-BLYP",
"GTH-BLYP-q3",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP-q8",
"GTH-BLYP-q9",
"GTH-BLYP",
"GTH-BLYP-q2",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP",
"GTH-BLYP-q19",
"GTH-BLYP-q4",
"GTH-BLYP-q15",
"GTH-BLYP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP-q1",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP",
"GTH-BP-q1",
"GTH-BP",
"GTH-BP-q11",
"GTH-HCTH120",
"GTH-HCTH120",
"GTH-HCTH120",
"GTH-HCTH120",
"GTH-HCTH120",
"GTH-HCTH120",
"GTH-HCTH120",
"GTH-HCTH407",
"GTH-HCTH407",
"GTH-HCTH407",
"GTH-HCTH407",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA-q1",
"GTH-LDA",
"GTH-LDA-q2",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA-q1",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA-q2",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA-q1",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA-q2",
"GTH-LDA",
"GTH-LDA-q3",
"GTH-LDA",
"GTH-LDA-q4",
"GTH-LDA",
"GTH-LDA-q5",
"GTH-LDA",
"GTH-LDA-q6",
"GTH-LDA",
"GTH-LDA-q7",
"GTH-LDA",
"GTH-LDA-q8",
"GTH-LDA",
"GTH-LDA-q9",
"GTH-LDA-q10",
"GTH-LDA",
"GTH-LDA-q1",
"GTH-LDA",
"GTH-LDA-q19",
"GTH-LDA",
"GTH-LDA-q2",
"GTH-LDA-q20",
"GTH-LDA",
"GTH-LDA-q3",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA-q1",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA-q2",
"GTH-LDA",
"GTH-LDA-q3",
"GTH-LDA",
"GTH-LDA-q4",
"GTH-LDA",
"GTH-LDA-q5",
"GTH-LDA",
"GTH-LDA-q6",
"GTH-LDA",
"GTH-LDA-q7",
"GTH-LDA",
"GTH-LDA-q8",
"GTH-LDA",
"GTH-LDA-q9",
"GTH-LDA-q10",
"GTH-LDA",
"GTH-LDA-q1",
"GTH-LDA",
"GTH-LDA-q19",
"GTH-LDA",
"GTH-LDA-q2",
"GTH-LDA",
"GTH-LDA-q3",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA-q1",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA-q2",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA-q5",
"GTH-LDA",
"GTH-LDA-q6",
"GTH-LDA",
"GTH-LDA-q7",
"GTH-LDA",
"GTH-LDA-q8",
"GTH-LDA",
"GTH-LDA-q9",
"GTH-LDA-q10",
"GTH-LDA",
"GTH-LDA-q1",
"GTH-LDA",
"GTH-LDA-q19",
"GTH-LDA",
"GTH-LDA-q2",
"GTH-LDA",
"GTH-LDA-q3",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-LDA",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE-q2",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE-q19",
"GTH-PBE",
"GTH-PBE-q20",
"GTH-PBE",
"GTH-PBE-q3",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE-q8",
"GTH-PBE",
"GTH-PBE-q9",
"GTH-PBE-q10",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE-q19",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE-q3",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE-q30",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE-q5",
"GTH-PBE",
"GTH-PBE-q6",
"GTH-PBE",
"GTH-PBE-q7",
"GTH-PBE",
"GTH-PBE-q8",
"GTH-PBE",
"GTH-PBE-q9",
"GTH-PBE-q10",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE-q19",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE-q3",
"GTH-PBE-q14",
"GTH-PBE",
"GTH-PBE-q15",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE",
"GTH-PBE-q14",
"GTH-PBESol",
"GTH-OLYP",
"GTH-OLYP-q3",
"GTH-OLYP-q4",
"GTH-OLYP-q5",
"GTH-OLYP",
"GTH-OLYP-q7",
"GTH-OLYP-q5",
"GTH-OLYP-q6",
"GTH-OLYP-q7",
"GTH-HF",
"GTH-HF",
"GTH-HF",
"GTH-HF",
"GTH-NLCC-PBE",
"GTH-NLCC-PBE",
"GTH-NLCC-PBE",
"GTH-NLCC-PBE",
"GTH-NLCC-PBE",
"GTH-NLCC-PBE",
"GTH-NLCC-PBE",
"GTH-NLCC-PBE",
"GTH-NLCC-PBE",
"GTH-NLCC-PBE",
"GTH-NLCC-PBE",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL",
"ALL"};

char * cp2k_pot[421] = {"\n"
"H GTH-BLYP-q1 GTH-BLYP\n"
"    1\n"
"     0.20000000    2    -4.19596147     0.73049821\n"
"    0\n"
"#","\n"
"He GTH-BLYP-q2 GTH-BLYP\n"
"    2\n"
"     0.20000000    2    -9.14737128     1.71197792\n"
"    0\n"
"#","\n"
"Li GTH-BLYP-q3 GTH-BLYP\n"
"    3\n"
"     0.40000000    4   -14.11679756     9.67724760    -1.79886461     0.08624957\n"
"    0\n"
"#","\n"
"Be GTH-BLYP-q4 GTH-BLYP\n"
"    4\n"
"     0.32500000    4   -24.08977105    17.30275720    -3.34561015     0.16601474\n"
"    0\n"
"#","\n"
"B GTH-BLYP-q3 GTH-BLYP\n"
"    2    1\n"
"     0.42407181    2    -6.10890761     0.98586957\n"
"    2\n"
"     0.37086003    1     6.34339578\n"
"     0.34936716    0\n"
"#","\n"
"C GTH-BLYP-q4 GTH-BLYP\n"
"    2    2\n"
"     0.33806609    2    -9.13626871     1.42925956\n"
"    2\n"
"     0.30232223    1     9.66551228\n"
"     0.28637912    0\n"
"#","\n"
"N GTH-BLYP-q5 GTH-BLYP\n"
"    2    3\n"
"     0.28287094    2   -12.73646720     1.95107926\n"
"    2\n"
"     0.25523449    1    13.67893172\n"
"     0.24313253    0\n"
"#","\n"
"O GTH-BLYP-q6 GTH-BLYP\n"
"    2    4\n"
"     0.24342026    2   -16.99189235     2.56614206\n"
"    2\n"
"     0.22083140    1    18.38885102\n"
"     0.21720070    0\n"
"#","\n"
"F GTH-BLYP-q7 GTH-BLYP\n"
"    2    5\n"
"     0.21384014    2   -21.90241518     3.27597572\n"
"    2\n"
"     0.19459028    1    23.79658295\n"
"     0.18786326    0\n"
"#","\n"
"Ne GTH-BLYP-q8 GTH-BLYP\n"
"    2    6\n"
"     0.19000000    2   -28.61959769     4.15549516\n"
"    2\n"
"     0.17823784    2    27.95784886     0.83365601\n"
"                                       -1.07624528\n"
"     0.15276372    1     0.33116999\n"
"#","\n"
"Na GTH-BLYP-q9 GTH-BLYP\n"
"    3    6\n"
"     0.23396502    2    -2.68948346    -0.50947770\n"
"    2\n"
"     0.14977690    1    32.85715860\n"
"     0.12319901    1   -13.99900802\n"
"#","\n"
"Mg GTH-BLYP-q10 GTH-BLYP\n"
"    4    6\n"
"     0.20098403    2   -19.33029317     2.86005812\n"
"    2\n"
"     0.14107967    1    40.67473040\n"
"     0.10456134    1   -10.73617094\n"
"#","\n"
"Mg GTH-BLYP-q2\n"
"    2\n"
"     0.61697665    1    -3.24611921\n"
"    2\n"
"     0.60092845    2     3.64729616    -0.76401307\n"
"                                        0.98633664\n"
"     0.70217751    1     0.94952736\n"
"#","\n"
"Al GTH-BLYP-q3 GTH-BLYP\n"
"    2    1\n"
"     0.45000000    1    -7.66683204\n"
"    2\n"
"     0.49773601    2     6.46303151    -1.58386957\n"
"                                        2.04476682\n"
"     0.56545785    1     1.81826715\n"
"#","\n"
"Si GTH-BLYP-q4 GTH-BLYP\n"
"    2    2\n"
"     0.44000000    1    -6.25958674\n"
"    2\n"
"     0.44465247    2     8.31460936    -2.33277947\n"
"                                        3.01160535\n"
"     0.50279207    1     2.33241791\n"
"#","\n"
"P GTH-BLYP-q5 GTH-BLYP\n"
"    2    3\n"
"     0.43000000    1    -5.92953335\n"
"    2\n"
"     0.40286945    2    10.41483915    -3.13168757\n"
"                                        4.04299126\n"
"     0.45245811    1     2.95358263\n"
"#","\n"
"S GTH-BLYP-q6 GTH-BLYP\n"
"    2    4\n"
"     0.42000000    1    -5.98880045\n"
"    2\n"
"     0.36973266    2    12.55648450    -3.91290459\n"
"                                        5.05153810\n"
"     0.41287571    1     3.58772114\n"
"#","\n"
"Cl GTH-BLYP-q7 GTH-BLYP\n"
"    2    5\n"
"     0.41000000    1    -6.35705212\n"
"    2\n"
"     0.34311864    2    14.68134781    -4.64034312\n"
"                                        5.99065720\n"
"     0.38113517    1     4.22292428\n"
"#","\n"
"Ar GTH-BLYP-q8 GTH-BLYP\n"
"    2    6\n"
"     0.40000000    1    -7.10000000\n"
"    2\n"
"     0.32154985    2    16.80099893    -5.32871056\n"
"                                        6.87933576\n"
"     0.35544413    1     4.87719604\n"
"#","\n"
"K GTH-BLYP-q9 GTH-BLYP\n"
"    3    6\n"
"     0.40000000    2    -2.88013377    -1.21143500\n"
"    2\n"
"     0.30634684    2    17.51002284    -5.61037883\n"
"                                        7.24296793\n"
"     0.32105825    2     6.90321066    -2.19925814\n"
"                                        2.60219733\n"
"#","\n"
"Ca GTH-BLYP-q10 GTH-BLYP\n"
"    4    6\n"
"     0.39000000    2    -4.03561119    -1.61257448\n"
"    3\n"
"     0.28936507    2    20.42566030    -7.23674813\n"
"                                        9.34260166\n"
"     0.31177925    2     7.53169389    -2.08537690\n"
"                                        2.46745122\n"
"     0.69141876    1     0.05522276\n"
"#","\n"
"Sc GTH-BLYP-q11 GTH-BLYP\n"
"    4    6    1\n"
"     0.37687548    2     9.84009747    -1.16586015\n"
"    3\n"
"     0.35998897    2     3.30610316     2.54796421\n"
"                                       -3.28940766\n"
"     0.22099375    2    -0.43488219     6.46425824\n"
"                                       -7.64861350\n"
"     0.23338021    1   -10.13403863\n"
"#","\n"
"Ti GTH-BLYP-q12 GTH-BLYP\n"
"    4    6    2\n"
"     0.38000000    2     8.71144218    -0.70028677\n"
"    3\n"
"     0.33777078    2     2.57526386     3.69297065\n"
"                                       -4.76760461\n"
"     0.24253135    2    -4.63054123     8.87087502\n"
"                                      -10.49616087\n"
"     0.24331694    1    -9.40665268\n"
"#","\n"
"V GTH-BLYP-q13 GTH-BLYP\n"
"    4    6    3\n"
"     0.37500000    2     7.09567441    -0.32225919\n"
"    3\n"
"     0.32984260    2     1.99203993     4.73916314\n"
"                                       -6.11823331\n"
"     0.24621323    2    -5.54974480     8.76420181\n"
"                                      -10.36994343\n"
"     0.24115328    1    -9.44436162\n"
"#","\n"
"Cr GTH-BLYP-q14 GTH-BLYP\n"
"    3    6    5\n"
"     0.37000000    2     5.81498098    -0.67571792\n"
"    3\n"
"     0.31671447    2     2.60698311     5.06715750\n"
"                                       -6.54167220\n"
"     0.23961307    2    -4.66668172     7.57290229\n"
"                                       -8.96037883\n"
"     0.22092939    1   -11.18989241\n"
"#","\n"
"Mn GTH-BLYP-q15 GTH-BLYP\n"
"    4    6    5\n"
"     0.36500000    2     6.17870291    -0.44450988\n"
"    3\n"
"     0.29784355    2     1.69433567     6.39053422\n"
"                                       -8.25014420\n"
"     0.24582549    2    -6.53742440     7.84591162\n"
"                                       -9.28340782\n"
"     0.22244655    1   -11.66961579\n"
"#","\n"
"Fe GTH-BLYP-q16 GTH-BLYP\n"
"    4    6    6\n"
"     0.36000000    2     7.01102510    -0.22274667\n"
"    3\n"
"     0.27620533    2     0.61149598     7.99235733\n"
"                                      -10.31808895\n"
"     0.24713005    2    -8.71055592     8.68416924\n"
"                                      -10.27524761\n"
"     0.22353398    1   -12.41150401\n"
"#","\n"
"Co GTH-BLYP-q17 GTH-BLYP\n"
"    4    6    7\n"
"     0.35500000    2     3.43297847     0.61491331\n"
"    3\n"
"     0.27555403    2     0.19362864     9.18128009\n"
"                                      -11.85298162\n"
"     0.24312795    2    -8.92204873     9.23263048\n"
"                                      -10.92419570\n"
"     0.22362456    1   -11.75878279\n"
"#","\n"
"Ni GTH-BLYP-q18 GTH-BLYP\n"
"    4    6    8\n"
"     0.35000000    2     4.07602942     0.23312841\n"
"    3\n"
"     0.25714683    2     0.09878517    10.14864210\n"
"                                      -13.10184061\n"
"     0.24975271    2    -8.34861501     7.26677120\n"
"                                       -8.59815964\n"
"     0.21247761    1   -13.67293293\n"
"#","\n"
"Cu GTH-BLYP-q11 GTH-BLYP\n"
"    1    0   10\n"
"     0.53000000    0\n"
"    3\n"
"     0.43078178    3    10.29852604    -6.05837033     1.70054574\n"
"                                       10.58726032    -4.39079021\n"
"                                                       3.48508169\n"
"     0.55080544    2     2.74458701    -0.86295510\n"
"                                        1.02106225\n"
"     0.26558610    1   -12.66158247\n"
"#","\n"
"Cu GTH-BLYP-q19\n"
"    3    6   10\n"
"     0.34500000    2     0.00729001     1.26270041\n"
"    3\n"
"     0.25025136    2     0.78207556    10.69795592\n"
"                                      -13.81100171\n"
"     0.22145058    2   -13.10305990    14.86802590\n"
"                                      -17.59208548\n"
"     0.21548515    1   -12.45211713\n"
"#","\n"
"Zn GTH-BLYP-q12 GTH-BLYP\n"
"    2    0   10\n"
"     0.51000000    0\n"
"    3\n"
"     0.39855016    3    11.95945993    -8.66522085     2.80807710\n"
"                                       15.75408976    -7.25042390\n"
"                                                       5.75484556\n"
"     0.54556247    2     2.51050004    -0.44032483\n"
"                                        0.52099937\n"
"     0.25168465    1   -14.32309848\n"
"#","\n"
"Zn GTH-BLYP-q20\n"
"    4    6   10\n"
"     0.34000000    2     0.69029187     1.23803712\n"
"    3\n"
"     0.24511603    2    -1.58948215    12.87573398\n"
"                                      -16.62250109\n"
"     0.23151219    2   -10.91449266     9.54377070\n"
"                                      -11.29234178\n"
"     0.20860634    1   -14.24182139\n"
"#","\n"
"Ga GTH-BLYP-q13 GTH-BLYP\n"
"    2    1   10\n"
"     0.49000000    0\n"
"    3\n"
"     0.39467346    3    12.48450375    -7.17987436     1.92607131\n"
"                                       12.40193316    -4.97309473\n"
"                                                       3.94727157\n"
"     0.58027448    2     1.59145844     0.32153951\n"
"                                       -0.38045068\n"
"     0.23867979    1   -16.11979876\n"
"#","\n"
"Ga GTH-BLYP-q3\n"
"    2    1\n"
"     0.56000000    0\n"
"    3\n"
"     0.57532960    3     2.06609505     1.21904266    -0.87326380\n"
"                                       -2.99414098     2.25475743\n"
"                                                      -1.78965823\n"
"     0.67710486    2     0.14524752     0.72041368\n"
"                                       -0.85240496\n"
"     0.94154174    1     0.10030959\n"
"#","\n"
"Ge GTH-BLYP-q4 GTH-BLYP\n"
"    2    2\n"
"     0.54000000    0\n"
"    3\n"
"     0.42737427    3     7.55651469    -0.07090242    -1.72596317\n"
"                                       -2.71574467     4.45641774\n"
"                                                      -3.53717192\n"
"     0.57489897    2     0.80056266     0.71307408\n"
"                                       -0.84372063\n"
"     0.78547258    1     0.21870790\n"
"#","\n"
"As GTH-BLYP-q5 GTH-BLYP\n"
"    2    3\n"
"     0.52000000    0\n"
"    3\n"
"     0.45698284    3     5.57976394     0.11777254    -0.99243898\n"
"                                       -1.76624582     2.56246643\n"
"                                                      -2.03389468\n"
"     0.55494716    2     1.00097684     0.68325082\n"
"                                       -0.80843328\n"
"     0.68498074    1     0.34818137\n"
"#","\n"
"Se GTH-BLYP-q6 GTH-BLYP\n"
"    2    4\n"
"     0.51000000    0\n"
"    3\n"
"     0.43367514    3     6.43369922    -0.22063995    -1.17545323\n"
"                                       -1.62702987     3.03500718\n"
"                                                      -2.40896227\n"
"     0.47248310    2     2.23970327     0.40191857\n"
"                                       -0.47555647\n"
"     0.60911821    1     0.49494679\n"
"#","\n"
"Br GTH-BLYP-q7 GTH-BLYP\n"
"    2    5\n"
"     0.50000000    0\n"
"    3\n"
"     0.43612268    3     6.23128313     0.21889262    -1.12467641\n"
"                                       -2.11187548     2.90390201\n"
"                                                      -2.30490077\n"
"     0.45379296    2     2.46574310     0.49636818\n"
"                                       -0.58731075\n"
"     0.53315603    1     0.74724056\n"
"#","\n"
"Kr GTH-BLYP-q8 GTH-BLYP\n"
"    2    6\n"
"     0.50000000    0\n"
"    3\n"
"     0.42362066    3     6.37382917     0.49858632    -1.41991709\n"
"                                       -2.95316749     3.66621015\n"
"                                                      -2.90996409\n"
"     0.43391338    2     2.63230352     0.64517712\n"
"                                       -0.76338386\n"
"     0.51315369    1     0.70954468\n"
"#","\n"
"Rb GTH-BLYP-q9\n"
"    3    6\n"
"     0.49000000    2     5.75447985    -0.48374192\n"
"    3\n"
"     0.25518839    2    30.72215135   -12.19094908\n"
"                                       15.73844759\n"
"     0.33800292    1     4.39362252\n"
"     0.58372659    1     0.18537105\n"
"#","\n"
"Sr GTH-BLYP-q10 GTH-BLYP\n"
"    4    6\n"
"     0.48000000    2     6.75494554    -1.12140847\n"
"    3\n"
"     0.27574829    2    20.90591056    -7.66251431\n"
"                                        9.89226343\n"
"     0.27951874    2    11.83709620   -11.14034857\n"
"                                       13.18143819\n"
"     0.53145306    1     0.32212393\n"
"#","\n"
"Y GTH-BLYP-q11 GTH-BLYP\n"
"    4    6    1\n"
"     0.47500000    2    12.12173196    -2.23590662\n"
"    3\n"
"     0.24768420    2    22.15257967    -7.66355161\n"
"                                        9.89360259\n"
"     0.29467778    2     5.85308697    -5.77308732\n"
"                                        6.83080904\n"
"     0.45213814    2     1.12663777    -1.27929123\n"
"                                        1.45057990\n"
"#","\n"
"Zr GTH-BLYP-q12 GTH-BLYP\n"
"    4    6    2\n"
"     0.47000000    2     7.68287419    -1.83482397\n"
"    3\n"
"     0.26098833    2    22.58608773    -8.39346102\n"
"                                       10.83591158\n"
"     0.28950143    2     8.50003567    -5.29014738\n"
"                                        6.25938680\n"
"     0.57680903    2     0.04082300     0.26426022\n"
"                                       -0.29964293\n"
"#","\n"
"Mo GTH-BLYP-q14 GTH-BLYP\n"
"    3    6    5\n"
"     0.43000000    2    28.10289595    -4.36588317\n"
"    3\n"
"     0.34238035    2    -0.06850864     2.98011244\n"
"                                       -3.84730862\n"
"     0.41442576    2    -0.15765657    -0.95307240\n"
"                                        1.12769047\n"
"     0.42539061    2     1.13742343    -2.64549690\n"
"                                        2.99971152\n"
"#","\n"
"Ru GTH-BLYP-q16 GTH-BLYP\n"
"    3    6    7\n"
"     0.43000000    2    26.85974124    -5.05749455\n"
"    3\n"
"     0.33894617    2    -0.50446833     3.70095133\n"
"                                       -4.77790762\n"
"     0.42823486    2     0.15024145    -1.32523126\n"
"                                        1.56803477\n"
"     0.43752832    2     1.52972881    -2.96335285\n"
"                                        3.36012630\n"
"#","\n"
"Rh GTH-BLYP-q17 GTH-BLYP\n"
"    3    6    8\n"
"     0.42000000    2    27.21859006    -5.26666561\n"
"    3\n"
"     0.33775970    2    -0.37805742     3.85156484\n"
"                                       -4.97234883\n"
"     0.40476998    2    -0.26519119    -0.79135076\n"
"                                        0.93633885\n"
"     0.43219447    2     1.68856873    -3.13689837\n"
"                                        3.55690842\n"
"#","\n"
"Pd GTH-BLYP-q18 GTH-BLYP\n"
"    2    6   10\n"
"     0.41000000    2    26.65379780    -4.86862194\n"
"    3\n"
"     0.33643267    2    -0.66218232     4.36901475\n"
"                                       -5.64037379\n"
"     0.41121734    2    -0.16335747    -0.94666822\n"
"                                        1.12011294\n"
"     0.44038158    2     1.64374463    -3.09751466\n"
"                                        3.51225149\n"
"#","\n"
"Ag GTH-BLYP-q11 GTH-BLYP\n"
"    1    0   10\n"
"     0.57000000    1     0.27329871\n"
"    3\n"
"     0.53113691    3     9.45447859    -4.73986410     0.59512748\n"
"                                        7.08711317    -1.53661256\n"
"                                                       1.21964841\n"
"     0.62572123    2     3.90619533    -1.71774975\n"
"                                        2.03246891\n"
"     0.40832785    2    -2.77610164    -0.36178338\n"
"                                        0.41022380\n"
"#","\n"
"Ag GTH-BLYP-q19\n"
"    3    6   10\n"
"     0.40000000    2    24.37631116    -4.16834876\n"
"    3\n"
"     0.31731325    2     0.69929536     4.25162666\n"
"                                       -5.48882642\n"
"     0.41393281    2    -0.30767006    -0.44941724\n"
"                                        0.53175765\n"
"     0.45569543    2     1.75618266    -3.09368795\n"
"                                        3.50791241\n"
"#","\n"
"In GTH-BLYP-q13 GTH-BLYP\n"
"    2    1   10\n"
"     0.53000000    1     3.57797710\n"
"    3\n"
"     0.47995615    3    11.20107941    -6.26219645     1.21444270\n"
"                                       10.05975207    -3.13567758\n"
"                                                       2.48886692\n"
"     0.56617182    2     4.78019859    -2.24059762\n"
"                                        2.65111085\n"
"     0.37728287    2    -4.24415179    -0.59846912\n"
"                                        0.67860020\n"
"#","\n"
"In GTH-BLYP-q3\n"
"    2    1\n"
"     0.61000000    1     3.20683546\n"
"    3\n"
"     0.72668632    3     0.70288050     1.01907230    -0.54239646\n"
"                                       -2.19782459     1.40046163\n"
"                                                      -1.11158196\n"
"     0.85226033    2     0.01176733     0.48673996\n"
"                                       -0.57591849\n"
"     1.06121328    1     0.15160282\n"
"#","\n"
"Sb GTH-BLYP-q5 GTH-BLYP\n"
"    2    3\n"
"     0.59000000    1     7.71520811\n"
"    3\n"
"     0.56281517    3     1.46135468     1.28119333    -0.94856576\n"
"                                       -3.19685579     2.44918625\n"
"                                                      -1.94398132\n"
"     0.64746318    2     0.46086693     0.43857096\n"
"                                       -0.51892416\n"
"     0.85920174    1     0.31255771\n"
"#","\n"
"Te GTH-BLYP-q6 GTH-BLYP\n"
"    2    4\n"
"     0.57500000    1     8.54112001\n"
"    3\n"
"     0.57657850    3     1.45132840     0.97095302    -0.49085149\n"
"                                       -2.05186498     1.26737311\n"
"                                                      -1.00594622\n"
"     0.60434855    2     0.70106128     0.40189978\n"
"                                       -0.47553423\n"
"     0.79625711    1     0.38178821\n"
"#","\n"
"I GTH-BLYP-q7 GTH-BLYP\n"
"    2    5\n"
"     0.56000000    1    13.73638610\n"
"    3\n"
"     0.58939001    3     0.21393489     0.88456526    -0.02067022\n"
"                                       -1.17558896     0.05337028\n"
"                                                      -0.04236135\n"
"     0.54232717    2     0.28721066     0.46932671\n"
"                                       -0.55531485\n"
"     0.77040507    1     0.30709615\n"
"#","\n"
"Xe GTH-BLYP-q8\n"
"    2    6\n"
"     0.56000000    1     8.59949070\n"
"    3\n"
"     0.49592925    3     2.81672987     1.44752782    -1.40786958\n"
"                                       -4.15865041     3.63510361\n"
"                                                      -2.88527404\n"
"     0.48311258    1     2.11273917\n"
"     0.69721940    1     0.50983839\n"
"#","\n"
"Cs GTH-BLYP-q9\n"
"    3    6\n"
"     0.54000000    2    33.07782844    -2.80842052\n"
"    4\n"
"     0.45607453    2    -3.56881717     2.63732767\n"
"                                       -3.40477539\n"
"     0.36820141    2    -5.01061387     0.77988492\n"
"                                       -0.92277228\n"
"     0.75684499    1     0.20052308\n"
"     0.58463791    1    -1.70870691\n"
"#","\n"
"Ba GTH-BLYP-q10 GTH-BLYP\n"
"    4    6\n"
"     0.54000000    2    24.53545105    -2.47807384\n"
"    4\n"
"     0.48569784    2     0.09387924     1.15171729\n"
"                                       -1.48686063\n"
"     0.39622579    2     0.84537359    -1.74106987\n"
"                                        2.06006165\n"
"     0.66014281    1     0.42755776\n"
"     0.30049122    1   -19.65179380\n"
"#","\n"
"Ba GTH-BLYP-q2\n"
"    2\n"
"     1.20000000    0\n"
"    3\n"
"     1.03638675    3     1.42164527    -0.44534139    -0.07451309\n"
"                                        0.45373771     0.19239197\n"
"                                                      -0.15270639\n"
"     1.25440147    2     0.73041014    -0.29211206\n"
"                                        0.34563165\n"
"     0.87881774    1    -0.85472852\n"
"#","\n"
"Ce GTH-BLYP-q12 GTH-BLYP\n"
"    4    6    1    1\n"
"     0.52864798    2    19.13548995    -0.59690386\n"
"    4\n"
"     0.52094620    2    -0.55473220     1.70057992\n"
"                                       -2.19543924\n"
"     0.45984533    2    -0.92453341     1.99827739\n"
"                                       -2.36439369\n"
"     0.67639660    1     0.10451755\n"
"     0.30436847    1   -17.54504586\n"
"#","\n"
"Gd GTH-BLYP-q18 GTH-BLYP\n"
"    4    6    1    7\n"
"     0.52166157    2    18.16996137    -0.54313383\n"
"    4\n"
"     0.45763555    2    -2.89847533     3.94756205\n"
"                                       -5.09628069\n"
"     0.45903313    3    -3.22259659     2.93618073    -0.30453227\n"
"                                       -3.98113568     0.72065489\n"
"                                                      -0.51217326\n"
"     0.48380572    1    -0.84857548\n"
"     0.27560057    1   -22.19038178\n"
"#","\n"
"W GTH-BLYP-q14 GTH-BLYP\n"
"    4    6    4\n"
"     0.54000000    2     6.68380890    -0.31709158\n"
"    3\n"
"     0.39238521    3    -1.92936041     4.30955402     2.23540296\n"
"                                       -1.92772713    -5.77178561\n"
"                                                       4.58121281\n"
"     0.39242369    2    -5.22265341     6.11414396\n"
"                                       -7.23435270\n"
"     0.37281208    2    -6.46250589     7.70934709\n"
"                                       -8.74157793\n"
"#","\n"
"Au GTH-BLYP-q11 GTH-BLYP\n"
"    1    0   10\n"
"     0.59000000    1    10.81589381\n"
"    3\n"
"     0.52572747    2     6.71867015    -2.66620610\n"
"                                        3.44205728\n"
"     0.60526597    2     4.32132354    -4.09465015\n"
"                                        4.84485539\n"
"     0.43903160    2    -7.45153985     3.06802476\n"
"                                       -3.47881309\n"
"#","\n"
"Au GTH-BLYP-q19\n"
"    3    6   10\n"
"     0.49000000    2     9.10574107    -0.31170627\n"
"    3\n"
"     0.28881911    3    -5.84394846    25.76364500   -14.96878334\n"
"                                      -57.60745060    38.64923240\n"
"                                                     -30.67687719\n"
"     0.35793393    2    -6.87735522     7.88320706\n"
"                                       -9.32753639\n"
"     0.33407191    2    -8.71118504     9.49731666\n"
"                                      -10.76894486\n"
"#","\n"
"Pb GTH-BLYP-q4\n"
"    2    2\n"
"     0.61750000    1     5.33520808\n"
"    3\n"
"     0.62372070    3     0.77431309     2.33644883    -1.62011026\n"
"                                       -5.65145200     4.18310671\n"
"                                                      -3.32023802\n"
"     0.81430558    2     0.08023553     0.61572271\n"
"                                       -0.72853293\n"
"     0.95575855    1     0.39678153\n"
"#","\n"
"Bi GTH-BLYP-q15\n"
"    2    3   10\n"
"     0.51000000    1    13.61415171\n"
"    3\n"
"     0.47534187    2    10.01031001    -4.17527106\n"
"                                        5.39025176\n"
"     0.54300464    2     5.84572146    -3.45677684\n"
"                                        4.09011352\n"
"     0.39904006    2    -5.95513083     0.85300728\n"
"                                       -0.96721934\n"
"#","\n"
"Bi GTH-BLYP-q5 GTH-BLYP\n"
"    2    3\n"
"     0.60500000    1     8.13212850\n"
"    3\n"
"     0.59003694    3     0.58526544     2.28713930    -1.46002100\n"
"                                       -5.32740847     3.76975801\n"
"                                                      -2.99215266\n"
"     0.77185023    2     0.16538598     0.48986468\n"
"                                       -0.57961570\n"
"     0.93145569    1     0.39528270\n"
"#","\n"
"H GTH-BP-q1 GTH-BP\n"
"    1\n"
"     0.20000000    2    -4.18576872     0.72693955\n"
"    0\n"
"#","\n"
"He GTH-BP-q2 GTH-BP\n"
"    2\n"
"     0.20000000    2    -9.13007508     1.70547521\n"
"    0\n"
"#","\n"
"Li GTH-BP-q3 GTH-BP\n"
"    3\n"
"     0.40000000    4   -14.06056862     9.58589939    -1.77248513     0.08455183\n"
"    0\n"
"#","\n"
"Be GTH-BP-q4 GTH-BP\n"
"    4\n"
"     0.32500000    4   -24.05179710    17.25001598    -3.33397632     0.16556913\n"
"    0\n"
"#","\n"
"B GTH-BP-q3 GTH-BP\n"
"    2    1\n"
"     0.41689069    2    -5.92229378     0.92456157\n"
"    2\n"
"     0.37107711    1     6.29599634\n"
"     0.35853552    0\n"
"#","\n"
"C GTH-BP-q4 GTH-BP\n"
"    2    2\n"
"     0.33679692    2    -8.86848685     1.35447596\n"
"    2\n"
"     0.30241022    1     9.62271161\n"
"     0.28961690    0\n"
"#","\n"
"N GTH-BP-q5 GTH-BP\n"
"    2    3\n"
"     0.28309178    2   -12.45088915     1.87519554\n"
"    2\n"
"     0.25528977    1    13.63656889\n"
"     0.24443710    0\n"
"#","\n"
"O GTH-BP-q6 GTH-BP\n"
"    2    4\n"
"     0.24401839    2   -16.70590802     2.49292672\n"
"    2\n"
"     0.22086487    1    18.34759371\n"
"     0.21290362    0\n"
"#","\n"
"F GTH-BP-q7 GTH-BP\n"
"    2    5\n"
"     0.21448854    2   -21.61832219     3.20543202\n"
"    2\n"
"     0.19461036    1    23.75712327\n"
"     0.18640875    0\n"
"#","\n"
"Ne GTH-BP-q8 GTH-BP\n"
"    2    6\n"
"     0.19000000    2   -27.05603079     4.33563519\n"
"    2\n"
"     0.17609718    2    28.15075707     0.83365601\n"
"                                       -1.07624528\n"
"     0.19349680    1    -0.24066336\n"
"#","\n"
"Na GTH-BP-q1\n"
"    1\n"
"     0.75473588    1    -2.13985326\n"
"    2\n"
"     0.72207334    2     2.08932802    -0.33891173\n"
"                                        0.43753317\n"
"     0.87531990    1     0.49722485\n"
"#","\n"
"Na GTH-BP-q9 GTH-BP\n"
"    3    6\n"
"     0.21033221    2     1.69258850     0.50357981\n"
"    2\n"
"     0.13173054    1    40.12933608\n"
"     0.14067337    1   -12.69190352\n"
"#","\n"
"Mg GTH-BP-q10 GTH-BP\n"
"    4    6\n"
"     0.20344528    2   -19.14863290     2.82311627\n"
"    2\n"
"     0.14101308    1    40.61528144\n"
"     0.10485644    1   -10.81236006\n"
"#","\n"
"Al GTH-BP-q3 GTH-BP\n"
"    2    1\n"
"     0.45000000    1    -7.51792352\n"
"    2\n"
"     0.48626591    2     6.97775636    -1.91568248\n"
"                                        2.47313545\n"
"     0.56192765    1     1.85584177\n"
"#","\n"
"Si GTH-BP-q4 GTH-BP\n"
"    2    2\n"
"     0.44000000    1    -6.31784112\n"
"    2\n"
"     0.43603553    2     8.90462481    -2.69406309\n"
"                                        3.47802049\n"
"     0.49841919    1     2.41937486\n"
"#","\n"
"P GTH-BP-q5 GTH-BP\n"
"    2    3\n"
"     0.43000000    1    -5.89229627\n"
"    2\n"
"     0.39681575    2    10.93288778    -3.45803253\n"
"                                        4.46430080\n"
"     0.44912129    1     3.03004831\n"
"#","\n"
"S GTH-BP-q6 GTH-BP\n"
"    2    4\n"
"     0.42000000    1    -6.03304243\n"
"    2\n"
"     0.36545997    2    13.05126503    -4.21706733\n"
"                                        5.44421051\n"
"     0.41024550    1     3.67822896\n"
"#","\n"
"Cl GTH-BP-q7 GTH-BP\n"
"    2    5\n"
"     0.41000000    1    -6.39460178\n"
"    2\n"
"     0.34001772    2    15.11347341    -4.90811514\n"
"                                        6.33634940\n"
"     0.37914105    1     4.30633607\n"
"#","\n"
"Ar GTH-BP-q8 GTH-BP\n"
"    2    6\n"
"     0.40000000    1    -7.10000000\n"
"    2\n"
"     0.31922565    2    17.15805529    -5.55332249\n"
"                                        7.16930851\n"
"     0.35391145    1     4.94347383\n"
"#","\n"
"K GTH-BP-q9 GTH-BP\n"
"    3    6\n"
"     0.40000000    2    -3.20803677    -1.13958016\n"
"    2\n"
"     0.30531669    2    17.82113209    -5.62459155\n"
"                                        7.26131647\n"
"     0.31728644    2     7.27073764    -2.45836276\n"
"                                        2.90877405\n"
"#","\n"
"Ca GTH-BP-q10 GTH-BP\n"
"    4    6\n"
"     0.39000000    2    -5.15066460    -1.27635919\n"
"    3\n"
"     0.29180561    2    20.37501847    -6.39225402\n"
"                                        8.25236446\n"
"     0.30585091    2     8.08679088    -2.35194765\n"
"                                        2.78286199\n"
"     0.69084590    1     0.05057463\n"
"#","\n"
"Sc GTH-BP-q11 GTH-BP\n"
"    4    6    1\n"
"     0.38500000    2     8.15113811    -0.54578786\n"
"    3\n"
"     0.36408582    2     2.63374349     3.01189542\n"
"                                       -3.88834027\n"
"     0.24337293    2    -2.59643301     7.97785436\n"
"                                       -9.43952457\n"
"     0.25316272    1    -8.16168667\n"
"#","\n"
"Ti GTH-BP-q12 GTH-BP\n"
"    4    6    2\n"
"     0.38000000    2     8.75240544    -0.72051287\n"
"    3\n"
"     0.33725619    2     2.57793688     3.67192953\n"
"                                       -4.74044064\n"
"     0.24244686    2    -4.63571761     8.84700754\n"
"                                      -10.46792049\n"
"     0.24327738    1    -9.40815808\n"
"#","\n"
"V GTH-BP-q13 GTH-BP\n"
"    4    6    3\n"
"     0.37500000    2     7.15179161    -0.34356487\n"
"    3\n"
"     0.32978741    2     1.96706044     4.72624160\n"
"                                       -6.10155167\n"
"     0.24617385    2    -5.58236403     8.79691014\n"
"                                      -10.40864444\n"
"     0.24115908    1    -9.44742960\n"
"#","\n"
"Cr GTH-BP-q14 GTH-BP\n"
"    3    6    5\n"
"     0.37000000    2     5.65864275    -0.68098927\n"
"    3\n"
"     0.31450745    2     2.82535174     5.00194988\n"
"                                       -6.45748952\n"
"     0.24079099    2    -4.43722064     7.25268232\n"
"                                       -8.58148945\n"
"     0.22035720    1   -11.18549799\n"
"#","\n"
"Mn GTH-BP-q15 GTH-BP\n"
"    4    6    5\n"
"     0.36500000    2     6.08697327    -0.45767880\n"
"    3\n"
"     0.29664936    2     1.82641604     6.37301365\n"
"                                       -8.22752524\n"
"     0.24691092    2    -6.51555304     7.91051030\n"
"                                       -9.35984202\n"
"     0.22235797    1   -11.61828411\n"
"#","\n"
"Fe GTH-BP-q16 GTH-BP\n"
"    4    6    6\n"
"     0.36000000    2     6.76627078    -0.22960467\n"
"    3\n"
"     0.27801949    2     0.64092335     7.90310889\n"
"                                      -10.20286971\n"
"     0.25211093    2    -7.91342590     7.66613465\n"
"                                       -9.07069285\n"
"     0.22286543    1   -12.38774903\n"
"#","\n"
"Co GTH-BP-q17 GTH-BP\n"
"    4    6    7\n"
"     0.35500000    2     3.11870813     0.60978675\n"
"    3\n"
"     0.27344715    2     0.60869990     9.05959793\n"
"                                      -11.69589063\n"
"     0.24486485    2    -8.73194160     9.19441838\n"
"                                      -10.87898254\n"
"     0.22321373    1   -11.65940289\n"
"#","\n"
"Ni GTH-BP-q18 GTH-BP\n"
"    4    6    8\n"
"     0.35000000    2     1.98092026     0.67873534\n"
"    3\n"
"     0.26151729    2     0.64051423     9.97129765\n"
"                                      -12.87288991\n"
"     0.22299669    2   -11.03584887    12.32415881\n"
"                                      -14.58214136\n"
"     0.21531615    1   -12.60737765\n"
"#","\n"
"Cu GTH-BP-q11 GTH-BP\n"
"    1    0   10\n"
"     0.53000000    0\n"
"    3\n"
"     0.42826021    3     9.92997278    -6.73378071     2.06123370\n"
"                                       12.04587038    -5.32208253\n"
"                                                       4.22427205\n"
"     0.56179993    2     2.52706517    -0.76026621\n"
"                                        0.89955911\n"
"     0.26481830    1   -12.79028986\n"
"#","\n"
"Zn GTH-BP-q12 GTH-BP\n"
"    2    0   10\n"
"     0.51000000    0\n"
"    3\n"
"     0.39853504    3    11.71430184    -8.95271466     3.10389577\n"
"                                       16.60639177    -8.01422441\n"
"                                                       6.36109342\n"
"     0.54277993    2     2.59454952    -0.56410898\n"
"                                        0.66746275\n"
"     0.25119891    1   -14.42369639\n"
"#","\n"
"Ga GTH-BP-q13 GTH-BP\n"
"    2    1   10\n"
"     0.49000000    0\n"
"    3\n"
"     0.39614555    3    12.22933993    -7.15254431     2.02087227\n"
"                                       12.52084398    -5.21786976\n"
"                                                       4.14155572\n"
"     0.57682875    2     1.65710194     0.27257669\n"
"                                       -0.32251709\n"
"     0.23837295    1   -16.19719645\n"
"#","\n"
"Ge GTH-BP-q4 GTH-BP\n"
"    2    2\n"
"     0.54000000    0\n"
"    3\n"
"     0.42652691    3     7.46008807    -0.10148543    -1.79977798\n"
"                                       -2.79632198     4.64700676\n"
"                                                      -3.68844727\n"
"     0.57081829    2     0.83232240     0.67204801\n"
"                                       -0.79517793\n"
"     0.80229340    1     0.20140599\n"
"#","\n"
"As GTH-BP-q5 GTH-BP\n"
"    2    3\n"
"     0.52000000    0\n"
"    3\n"
"     0.45615688    3     5.51837021     0.17312741    -1.14220882\n"
"                                       -2.08130930     2.94917048\n"
"                                                      -2.34083150\n"
"     0.55642685    2     0.96871581     0.69251828\n"
"                                       -0.81939868\n"
"     0.70085191    1     0.31310326\n"
"#","\n"
"Se GTH-BP-q6 GTH-BP\n"
"    2    4\n"
"     0.51000000    0\n"
"    3\n"
"     0.43378134    3     6.42760223    -0.11666018    -1.25092543\n"
"                                       -1.88402272     3.22987558\n"
"                                                      -2.56363426\n"
"     0.47287696    2     2.19350862     0.46354749\n"
"                                       -0.54847679\n"
"     0.61779280    1     0.45787624\n"
"#","\n"
"Br GTH-BP-q7 GTH-BP\n"
"    2    5\n"
"     0.50000000    0\n"
"    3\n"
"     0.43844329    3     6.02809057     0.36950836    -1.26583607\n"
"                                       -2.53591576     3.26837467\n"
"                                                      -2.59419197\n"
"     0.45265302    2     2.45444938     0.55326441\n"
"                                       -0.65463128\n"
"     0.57270080    1     0.53453193\n"
"#","\n"
"Kr GTH-BP-q8 GTH-BP\n"
"    2    6\n"
"     0.50000000    0\n"
"    3\n"
"     0.42201160    3     6.43640090     0.55484448    -1.49019203\n"
"                                       -3.14009866     3.84765927\n"
"                                                      -3.05398486\n"
"     0.43381353    2     2.58759250     0.72129118\n"
"                                       -0.85344324\n"
"     0.54760510    1     0.52878835\n"
"#","\n"
"Zr GTH-BP-q12 GTH-BP\n"
"    4    6    2\n"
"     0.47000000    2     7.71710396    -1.87349588\n"
"    3\n"
"     0.26012850    2    23.33316266    -8.48756302\n"
"                                       10.95739674\n"
"     0.28909449    2     8.57471103    -5.33803887\n"
"                                        6.31605277\n"
"     0.57923104    2     0.03180631     0.27415481\n"
"                                       -0.31086233\n"
"#","\n"
"Ru GTH-BP-q16 GTH-BP\n"
"    3    6    7\n"
"     0.43000000    2    14.95348689    -0.02426473\n"
"    3\n"
"     0.35723814    2    -1.36117090     5.92761103\n"
"                                       -7.65251293\n"
"     0.36153743    2    -4.67111662     4.55280704\n"
"                                       -5.38695393\n"
"     0.47093469    2     0.51873585    -2.29176040\n"
"                                        2.59861204\n"
"#","\n"
"Te GTH-BP-q6 GTH-BP\n"
"    2    4\n"
"     0.57500000    1     8.45045608\n"
"    3\n"
"     0.57841719    3     1.43632249     1.01620377    -0.52198665\n"
"                                       -2.16092478     1.34776374\n"
"                                                      -1.06975431\n"
"     0.60416533    2     0.67900355     0.42745229\n"
"                                       -0.50576837\n"
"     0.80633893    1     0.35636810\n"
"#","\n"
"Cs GTH-BP-q1\n"
"    1\n"
"     1.20000000    0\n"
"    3\n"
"     1.15311277    3     0.93256439     0.00814108    -0.14921814\n"
"                                       -0.25321342     0.38527959\n"
"                                                      -0.30580619\n"
"     1.29745832    2     0.63229903    -0.43114835\n"
"                                        0.51014161\n"
"     1.01147944    1    -0.69777439\n"
"#","\n"
"Cs GTH-BP-q9 GTH-BP\n"
"    3    6\n"
"     0.54000000    2    33.18925821    -2.80669630\n"
"    4\n"
"     0.44888547    2    -3.15382781     3.31288554\n"
"                                       -4.27691685\n"
"     0.36087547    2    -5.24766705     3.25354824\n"
"                                       -3.84965020\n"
"     0.76171895    1     0.18517971\n"
"     0.33862935    1   -16.82118432\n"
"#","\n"
"Au GTH-BP-q11\n"
"    1    0   10\n"
"     0.59000000    1    10.62376865\n"
"    3\n"
"     0.53803750    2     6.00785520    -2.34452337\n"
"                                        3.02676666\n"
"     0.60560054    2     4.37533897    -4.26458410\n"
"                                        5.04592396\n"
"     0.43922932    2    -7.29174553     2.89836819\n"
"                                       -3.28644061\n"
"#","\n"
"H GTH-HCTH120-q1 GTH-HCTH120\n"
"    1\n"
"     0.20000000    2    -4.17956174     0.72571934\n"
"    0\n"
"#","\n"
"C GTH-HCTH120-q4 GTH-HCTH120\n"
"    2    2\n"
"     0.33476327    2    -8.73799634     1.35592059\n"
"    2\n"
"     0.30224259    1     9.60562026\n"
"     0.29150776    0\n"
"#","\n"
"N GTH-HCTH120-q5 GTH-HCTH120\n"
"    2    3\n"
"     0.28289705    2   -12.19488993     1.83989918\n"
"    2\n"
"     0.25526540    1    13.60420273\n"
"     0.24618482    0\n"
"#","\n"
"O GTH-HCTH120-q6 GTH-HCTH120\n"
"    2    4\n"
"     0.24476117    2   -16.35853832     2.42680904\n"
"    2\n"
"     0.22092765    1    18.29885210\n"
"     0.21259318    0\n"
"#","\n"
"F GTH-HCTH120-q7 GTH-HCTH120\n"
"    2    5\n"
"     0.21555878    2   -21.21402136     3.11524496\n"
"    2\n"
"     0.19472662    1    23.68789289\n"
"     0.18667491    0\n"
"#","\n"
"P GTH-HCTH120-q5 GTH-HCTH120\n"
"    2    3\n"
"     0.43000000    1    -5.55967117\n"
"    2\n"
"     0.39982658    2    10.60103244    -3.26897992\n"
"                                        4.22023493\n"
"     0.45131904    1     2.95015425\n"
"#","\n"
"Ar GTH-HCTH120-q8 GTH-HCTH120\n"
"    2    6\n"
"     0.40000000    1    -7.01660399\n"
"    2\n"
"     0.31726372    2    17.43470209    -5.68655497\n"
"                                        7.34131090\n"
"     0.35199759    1     4.99753699\n"
"#","\n"
"H GTH-HCTH407-q1 GTH-HCTH407\n"
"    1\n"
"     0.20000000    2    -4.17855435     0.72595112\n"
"    0\n"
"#","\n"
"C GTH-HCTH407-q4 GTH-HCTH407\n"
"    2    2\n"
"     0.33895449    2    -8.64070432     1.35762517\n"
"    2\n"
"     0.30236220    1     9.59681173\n"
"     0.29159277    0\n"
"#","\n"
"N GTH-HCTH407-q5 GTH-HCTH407\n"
"    2    3\n"
"     0.28580927    2   -12.16723704     1.85814414\n"
"    2\n"
"     0.25533910    1    13.60665370\n"
"     0.24645801    0\n"
"#","\n"
"O GTH-HCTH407-q6 GTH-HCTH407\n"
"    2    4\n"
"     0.24634413    2   -16.39807931     2.45634724\n"
"    2\n"
"     0.22101140    1    18.29754812\n"
"     0.21441275    0\n"
"#","\n"
"H GTH-PADE-q1 GTH-LDA-q1 GTH-PADE GTH-LDA\n"
"    1\n"
"     0.20000000    2    -4.18023680     0.72507482\n"
"    0\n"
"#","\n"
"He GTH-PADE-q2 GTH-LDA-q2 GTH-PADE GTH-LDA\n"
"    2\n"
"     0.20000000    2    -9.11202340     1.69836797\n"
"    0\n"
"#","\n"
"Li GTH-PADE-q1 GTH-LDA-q1\n"
"    1\n"
"     0.78755305    2    -1.89261247     0.28605968\n"
"    2\n"
"     0.66637518    1     1.85881111\n"
"     1.07930561    1    -0.00589504\n"
"#","\n"
"Li GTH-PADE-q3 GTH-LDA-q3 GTH-PADE GTH-LDA\n"
"    3\n"
"     0.40000000    4   -14.03486849     9.55347627    -1.76648817     0.08436998\n"
"    0\n"
"#","\n"
"Be GTH-PADE-q2 GTH-LDA-q2\n"
"    2\n"
"     0.73900865    2    -2.59295078     0.35483893\n"
"    2\n"
"     0.52879656    1     3.06166591\n"
"     0.65815348    1     0.09246196\n"
"#","\n"
"Be GTH-PADE-q4 GTH-LDA-q4 GTH-PADE GTH-LDA\n"
"    4\n"
"     0.32500000    4   -24.01504092    17.20401444    -3.32639018     0.16541943\n"
"    0\n"
"#","\n"
"B GTH-PADE-q3 GTH-LDA-q3 GTH-PADE GTH-LDA\n"
"    2    1\n"
"     0.43392956    2    -5.57864173     0.80425145\n"
"    2\n"
"     0.37384326    1     6.23392822\n"
"     0.36039317    0\n"
"#","\n"
"C GTH-PADE-q4 GTH-LDA-q4 GTH-PADE GTH-LDA\n"
"    2    2\n"
"     0.34883045    2    -8.51377110     1.22843203\n"
"    2\n"
"     0.30455321    1     9.52284179\n"
"     0.23267730    0\n"
"#","\n"
"N GTH-PADE-q5 GTH-LDA-q5 GTH-PADE GTH-LDA\n"
"    2    3\n"
"     0.28917923    2   -12.23481988     1.76640728\n"
"    2\n"
"     0.25660487    1    13.55224272\n"
"     0.27013369    0\n"
"#","\n"
"O GTH-PADE-q6 GTH-LDA-q6 GTH-PADE GTH-LDA\n"
"    2    4\n"
"     0.24762086    2   -16.58031797     2.39570092\n"
"    2\n"
"     0.22178614    1    18.26691718\n"
"     0.25682890    0\n"
"#","\n"
"F GTH-PADE-q7 GTH-LDA-q7 GTH-PADE GTH-LDA\n"
"    2    5\n"
"     0.21852465    2   -21.30736112     3.07286942\n"
"    2\n"
"     0.19556721    1    23.58494211\n"
"     0.17426832    0\n"
"#","\n"
"Ne GTH-PADE-q8 GTH-LDA-q8 GTH-PADE GTH-LDA\n"
"    2    6\n"
"     0.19000000    2   -27.69285182     4.00590585\n"
"    2\n"
"     0.17948804    2    28.50609828     0.41682800\n"
"                                       -1.07624528\n"
"     0.21491271    1    -0.00008991\n"
"#","\n"
"Na GTH-PADE-q1 GTH-LDA-q1\n"
"    1\n"
"     0.88550938    1    -1.23886713\n"
"    2\n"
"     0.66110390    2     1.84727135    -0.22540903\n"
"                                        0.58200362\n"
"     0.85711928    1     0.47113258\n"
"#","\n"
"Na GTH-PADE-q9 GTH-LDA-q9 GTH-PADE GTH-LDA\n"
"    3    6\n"
"     0.24631780    2    -7.54559253     1.12599671\n"
"    2\n"
"     0.14125125    1    36.55698653\n"
"     0.13966840    1   -10.39208332\n"
"#","\n"
"Mg GTH-PADE-q10 GTH-LDA-q10 GTH-PADE GTH-LDA\n"
"    4    6\n"
"     0.21094954    2   -19.41900751     2.87133099\n"
"    2\n"
"     0.14154696    1    40.31662629\n"
"     0.10546902    1   -10.89111329\n"
"#","\n"
"Mg GTH-PADE-q2 GTH-LDA-q2\n"
"    2\n"
"     0.65181169    1    -2.86429746\n"
"    2\n"
"     0.55647814    2     2.97095712    -0.51508390\n"
"                                        1.32994091\n"
"     0.67756881    1     1.04988101\n"
"#","\n"
"Al GTH-PADE-q3 GTH-LDA-q3 GTH-PADE GTH-LDA\n"
"    2    1\n"
"     0.45000000    1    -8.49135116\n"
"    2\n"
"     0.46010427    2     5.08833953    -1.03784325\n"
"                                        2.67969975\n"
"     0.53674439    1     2.19343827\n"
"#","\n"
"Si GTH-PADE-q4 GTH-LDA-q4 GTH-PADE GTH-LDA\n"
"    2    2\n"
"     0.44000000    1    -7.33610297\n"
"    2\n"
"     0.42273813    2     5.90692831    -1.26189397\n"
"                                        3.25819622\n"
"     0.48427842    1     2.72701346\n"
"#","\n"
"P GTH-PADE-q5 GTH-LDA-q5 GTH-PADE GTH-LDA\n"
"    2    3\n"
"     0.43000000    1    -6.65421981\n"
"    2\n"
"     0.38980284    2     6.84213556    -1.49369090\n"
"                                        3.85669332\n"
"     0.44079585    1     3.28260592\n"
"#","\n"
"S GTH-PADE-q6 GTH-LDA-q6 GTH-PADE GTH-LDA\n"
"    2    4\n"
"     0.42000000    1    -6.55449184\n"
"    2\n"
"     0.36175665    2     7.90530250    -1.73188130\n"
"                                        4.47169830\n"
"     0.40528502    1     3.86657900\n"
"#","\n"
"Cl GTH-PADE-q7 GTH-LDA-q7 GTH-PADE GTH-LDA\n"
"    2    5\n"
"     0.41000000    1    -6.86475431\n"
"    2\n"
"     0.33820832    2     9.06223968    -1.96193036\n"
"                                        5.06568240\n"
"     0.37613709    1     4.46587640\n"
"#","\n"
"Ar GTH-PADE-q8 GTH-LDA-q8 GTH-PADE GTH-LDA\n"
"    2    6\n"
"     0.40000000    1    -7.10000000\n"
"    2\n"
"     0.31738081    2    10.24948699    -2.16984522\n"
"                                        5.60251627\n"
"     0.35161921    1     4.97880101\n"
"#","\n"
"K GTH-PADE-q1 GTH-LDA-q1\n"
"    1\n"
"     0.95000000    0\n"
"    3\n"
"     0.95536395    3     0.91461200    -0.11136800    -0.07324712\n"
"                                        0.28755094     0.18912326\n"
"                                                      -0.30022386\n"
"     1.08641063    2     0.31546177    -0.02881726\n"
"                                        0.06819410\n"
"     0.72060608    1    -1.52951361\n"
"#","\n"
"K GTH-PADE-q9 GTH-LDA-q9 GTH-PADE GTH-LDA\n"
"    3    6\n"
"     0.40000000    2    -4.98934751    -0.75604821\n"
"    2\n"
"     0.29482550    2    11.23870466    -2.73733893\n"
"                                        7.06777871\n"
"     0.32235865    2     5.25670239    -0.39677748\n"
"                                        0.93894690\n"
"#","\n"
"Ca GTH-PADE-q10 GTH-LDA-q10 GTH-PADE GTH-LDA\n"
"    4    6\n"
"     0.39000000    2    -4.92814602    -1.23285409\n"
"    3\n"
"     0.28190948    2    12.35233956    -2.96571964\n"
"                                        7.65745518\n"
"     0.31034528    2     5.72242348    -0.39028860\n"
"                                        0.92359141\n"
"     0.90433011    1     0.01680633\n"
"#","\n"
"Ca GTH-PADE-q2 GTH-LDA-q2\n"
"    2\n"
"     0.80000000    0\n"
"    3\n"
"     0.66973721    3     1.64501442    -0.59004546     0.07221571\n"
"                                        1.52349082    -0.18646017\n"
"                                                       0.29599634\n"
"     0.94647402    2     0.58547893    -0.05338365\n"
"                                        0.12632878\n"
"     0.52654998    1    -3.03232095\n"
"#","\n"
"Sc GTH-PADE-q11 GTH-LDA-q11 GTH-PADE GTH-LDA\n"
"    4    6    1\n"
"     0.38500000    2     7.42503638    -0.48985155\n"
"    3\n"
"     0.35970653    2     6.11958455     0.99282105\n"
"                                       -2.56345293\n"
"     0.24323416    2     6.37661838     2.54239924\n"
"                                       -6.01641469\n"
"     0.25294463    1    -8.02089177\n"
"#","\n"
"Sc GTH-PADE-q3 GTH-LDA-q3\n"
"    2    0    1\n"
"     0.75000000    0\n"
"    3\n"
"     0.59707941    3     1.83576833    -0.67169514     0.34607449\n"
"                                        1.73430939    -0.89356049\n"
"                                                       1.41848330\n"
"     0.84799438    2     0.78412669    -0.10426371\n"
"                                        0.24673297\n"
"     0.45465318    1    -3.85924078\n"
"#","\n"
"Ti GTH-PADE-q12 GTH-LDA-q12 GTH-PADE GTH-LDA\n"
"    4    6    2\n"
"     0.38000000    2     7.54878947    -0.58837666\n"
"    3\n"
"     0.33423466    2     6.92573970     1.21689330\n"
"                                       -3.14200499\n"
"     0.24241582    2     5.07908650     2.65559321\n"
"                                       -6.28428053\n"
"     0.24294750    1    -9.12589591\n"
"#","\n"
"Ti GTH-PADE-q4 GTH-LDA-q4\n"
"    2    0    2\n"
"     0.72000000    0\n"
"    3\n"
"     0.52841076    3     1.86661330    -0.55779994     0.89250253\n"
"                                        1.44023325    -2.30443161\n"
"                                                       3.65817177\n"
"     0.79114554    2     0.96791577    -0.11016023\n"
"                                        0.26068669\n"
"     0.40871178    1    -4.82645635\n"
"#","\n"
"V GTH-PADE-q13 GTH-LDA-q13 GTH-PADE GTH-LDA\n"
"    4    6    3\n"
"     0.37500000    2     4.94129058    -0.09644336\n"
"    3\n"
"     0.32665112    2     7.65939048     1.50745391\n"
"                                       -3.89222925\n"
"     0.24640748    2     4.25623049     2.51062024\n"
"                                       -5.94121187\n"
"     0.24079150    1    -8.82851757\n"
"#","\n"
"V GTH-PADE-q5 GTH-LDA-q5\n"
"    2    0    3\n"
"     0.69000000    0\n"
"    3\n"
"     0.51470421    3     2.20866978    -0.73461318     0.75055919\n"
"                                        1.89676307    -1.93793550\n"
"                                                       3.07637723\n"
"     0.74350381    2     1.11575121    -0.12113126\n"
"                                        0.28664887\n"
"     0.37488959    1    -5.84163317\n"
"#","\n"
"Cr GTH-PADE-q14 GTH-LDA-q14 GTH-PADE GTH-LDA\n"
"    3    6    5\n"
"     0.37000000    2     5.11336166    -0.64681932\n"
"    3\n"
"     0.30601140    2     8.61783515     1.60252229\n"
"                                       -4.13769475\n"
"     0.24108964    2     3.16158758     2.12679104\n"
"                                       -5.03290619\n"
"     0.21957702    1   -11.15786828\n"
"#","\n"
"Cr GTH-PADE-q6 GTH-LDA-q6\n"
"    1    0    5\n"
"     0.66000000    0\n"
"    3\n"
"     0.49857767    3     2.40075556    -0.80261251     0.72025801\n"
"                                        2.07233658    -1.85969818\n"
"                                                       2.95217934\n"
"     0.71976824    2     1.14555658    -0.11757619\n"
"                                        0.27823604\n"
"     0.35434060    1    -6.61587832\n"
"#","\n"
"Mn GTH-PADE-q15 GTH-LDA-q15 GTH-PADE GTH-LDA\n"
"    4    6    5\n"
"     0.36500000    2     6.74868332    -0.57656900\n"
"    3\n"
"     0.28075266    2     9.37953150     2.15929667\n"
"                                       -5.57528002\n"
"     0.25453567    2     0.37117568     1.78710271\n"
"                                       -4.22905690\n"
"     0.22142210    1   -12.11538453\n"
"#","\n"
"Mn GTH-PADE-q7 GTH-LDA-q7\n"
"    2    0    5\n"
"     0.64000000    0\n"
"    3\n"
"     0.48124608    3     2.79903057    -0.96286281     0.62594958\n"
"                                        2.48610107    -1.61619487\n"
"                                                       2.56562982\n"
"     0.66930432    2     1.36877564    -0.13385695\n"
"                                        0.31676337\n"
"     0.32776314    1    -7.99541784\n"
"#","\n"
"Fe GTH-PADE-q16 GTH-LDA-q16 GTH-PADE GTH-LDA\n"
"    4    6    6\n"
"     0.36000000    2     5.39250667    -0.03006638\n"
"    3\n"
"     0.26926810    2    10.19372276     2.64717717\n"
"                                       -6.83498206\n"
"     0.24768563    2     0.14561261     2.21217195\n"
"                                       -5.23495429\n"
"     0.22302105    1   -12.02694100\n"
"#","\n"
"Fe GTH-PADE-q8 GTH-LDA-q8\n"
"    2    0    6\n"
"     0.61000000    0\n"
"    3\n"
"     0.45448200    3     3.01664046    -1.00040646     0.79478164\n"
"                                        2.58303836    -2.05211737\n"
"                                                       3.25763534\n"
"     0.63890282    2     1.49964199    -0.13812935\n"
"                                        0.32687369\n"
"     0.30873177    1    -9.14535371\n"
"#","\n"
"Co GTH-PADE-q17 GTH-LDA-q17 GTH-PADE GTH-LDA\n"
"    4    6    7\n"
"     0.35500000    2     3.41839094     0.48207820\n"
"    3\n"
"     0.25914047    2    11.19522589     3.03867482\n"
"                                       -7.84582466\n"
"     0.25142451    2    -0.55146375     1.96043558\n"
"                                       -4.63923731\n"
"     0.22166454    1   -12.07535366\n"
"#","\n"
"Co GTH-PADE-q9 GTH-LDA-q9\n"
"    2    0    7\n"
"     0.58000000    0\n"
"    3\n"
"     0.44045735    3     3.33497825    -1.11276628     0.75413362\n"
"                                        2.87315017    -1.94716465\n"
"                                                       3.09102805\n"
"     0.61004847    2     1.63400481    -0.15047260\n"
"                                        0.35608316\n"
"     0.29166058    1   -10.35880017\n"
"#","\n"
"Ni GTH-PADE-q10 GTH-LDA-q10\n"
"    2    0    8\n"
"     0.56000000    0\n"
"    3\n"
"     0.42539870    3     3.61965071    -1.19635099     0.74622158\n"
"                                        3.08896496    -1.92673583\n"
"                                                       3.05859831\n"
"     0.58408076    2     1.74222007    -0.16325873\n"
"                                        0.38634067\n"
"     0.27811348    1   -11.60842823\n"
"#","\n"
"Ni GTH-PADE-q18 GTH-LDA-q18 GTH-PADE GTH-LDA\n"
"    4    6    8\n"
"     0.35000000    2     3.61031072     0.44963832\n"
"    3\n"
"     0.24510489    2    12.16113071     3.51625420\n"
"                                       -9.07892931\n"
"     0.23474136    2    -0.82062357     2.54774737\n"
"                                       -6.02907069\n"
"     0.21494950    1   -13.39506212\n"
"#","\n"
"Cu GTH-PADE-q1 GTH-LDA-q1\n"
"    1\n"
"     0.58000000    0\n"
"    3\n"
"     0.84328288    3     0.97578662     0.31838619    -0.03250652\n"
"                                       -0.82206962     0.08393147\n"
"                                                      -0.13323707\n"
"     1.08954266    2     0.02457986     0.10522210\n"
"                                       -0.24900093\n"
"     1.29160225    1    -0.06529209\n"
"#","\n"
"Cu GTH-PADE-q11 GTH-LDA-q11 GTH-PADE GTH-LDA\n"
"    1    0   10\n"
"     0.53000000    0\n"
"    3\n"
"     0.42373431    3     3.88805001    -1.26901549     0.55872509\n"
"                                        3.27658391    -1.44262198\n"
"                                                       2.29009139\n"
"     0.57217697    2     1.75127242    -0.15844220\n"
"                                        0.37494269\n"
"     0.26614275    1   -12.67695749\n"
"#","\n"
"Cu GTH-PADE-q19 GTH-LDA-q19\n"
"    3    6   10\n"
"     0.34500000    2     0.38158866     1.38680111\n"
"    3\n"
"     0.25131927    2     0.03400360    11.19862293\n"
"                                      -14.45736004\n"
"     0.22038147    2   -14.27160096    16.04403507\n"
"                                      -18.98355830\n"
"     0.21773897    1   -12.50830997\n"
"#","\n"
"Zn GTH-PADE-q12 GTH-LDA-q12 GTH-PADE GTH-LDA\n"
"    2    0   10\n"
"     0.51000000    0\n"
"    3\n"
"     0.40086620    3     4.27870973    -1.40486350     0.69522313\n"
"                                        3.62734196    -1.79505840\n"
"                                                       2.84956686\n"
"     0.53961806    2     2.02388400    -0.18244417\n"
"                                        0.43174171\n"
"     0.25215059    1   -14.33836841\n"
"#","\n"
"Zn GTH-PADE-q2 GTH-LDA-q2\n"
"    2\n"
"     0.57000000    0\n"
"    3\n"
"     0.64071219    3     2.08855724     0.08453570    -0.22965773\n"
"                                       -0.21827024     0.59297371\n"
"                                                      -0.94131659\n"
"     0.96760483    2     0.16354600     0.09596150\n"
"                                       -0.22708635\n"
"     1.33035200    1     0.01048578\n"
"#","\n"
"Zn GTH-PADE-q20 GTH-LDA-q20\n"
"    4    6   10\n"
"     0.34000000    2    -0.62164886     1.27422289\n"
"    3\n"
"     0.23892824    2     0.30844368    12.35877752\n"
"                                      -15.95511318\n"
"     0.23960139    2    -9.43744220     8.39596370\n"
"                                       -9.93423822\n"
"     0.20656246    1   -14.03217427\n"
"#","\n"
"Ga GTH-PADE-q13 GTH-LDA-q13 GTH-PADE GTH-LDA\n"
"    2    1   10\n"
"     0.49000000    0\n"
"    3\n"
"     0.39530156    3    12.45703651    -7.08541671     1.84712738\n"
"                                       12.15158654    -4.76926238\n"
"                                                       3.78548466\n"
"     0.58085441    2     1.57898606     0.32869270\n"
"                                       -0.38891444\n"
"     0.23908100    1   -16.13575103\n"
"#","\n"
"Ga GTH-PADE-q3 GTH-LDA-q3\n"
"    2    1\n"
"     0.56000000    0\n"
"    3\n"
"     0.61079074    3     2.36932516     0.09644314    -0.13462450\n"
"                                       -0.24901512     0.34759896\n"
"                                                      -0.55179624\n"
"     0.70459583    2     0.74630529     0.21683799\n"
"                                       -0.51313234\n"
"     0.98257967    1     0.07543656\n"
"#","\n"
"Ge GTH-PADE-q4 GTH-LDA-q4 GTH-PADE GTH-LDA\n"
"    2    2\n"
"     0.54000000    0\n"
"    3\n"
"     0.49374254    3     3.82689099    -0.42611775    -0.32795553\n"
"                                        1.10023129     0.84677753\n"
"                                                      -1.34421765\n"
"     0.60106438    2     1.36251781     0.26511216\n"
"                                       -0.62736987\n"
"     0.78836851    1     0.19120485\n"
"#","\n"
"As GTH-PADE-q5 GTH-LDA-q5 GTH-PADE GTH-LDA\n"
"    2    3\n"
"     0.52000000    0\n"
"    3\n"
"     0.45640025    3     4.56076106    -0.65545935    -0.33517391\n"
"                                        1.69238876     0.86541531\n"
"                                                      -1.37380421\n"
"     0.55056168    2     1.81224664     0.27329186\n"
"                                       -0.64672658\n"
"     0.68528272    1     0.31237276\n"
"#","\n"
"Se GTH-PADE-q6 GTH-LDA-q6 GTH-PADE GTH-LDA\n"
"    2    4\n"
"     0.51000000    0\n"
"    3\n"
"     0.43253108    3     5.14513084    -0.79473967    -0.33405137\n"
"                                        2.05200900     0.86251693\n"
"                                                      -1.36920317\n"
"     0.47247252    2     2.85880607     0.24960384\n"
"                                       -0.59067050\n"
"     0.61342013    1     0.43482888\n"
"#","\n"
"Br GTH-PADE-q7 GTH-LDA-q7 GTH-PADE GTH-LDA\n"
"    2    5\n"
"     0.50000000    0\n"
"    3\n"
"     0.42820734    3     5.39883713    -0.70499608    -0.32301656\n"
"                                        1.82029205     0.83402517\n"
"                                                      -1.32397392\n"
"     0.45532308    2     3.10882269     0.26715405\n"
"                                       -0.63220188\n"
"     0.55784727    1     0.55590294\n"
"#","\n"
"Kr GTH-PADE-q8 GTH-LDA-q8 GTH-PADE GTH-LDA\n"
"    2    6\n"
"     0.50000000    0\n"
"    3\n"
"     0.41075893    3     5.91119429    -0.76196004    -0.35573234\n"
"                                        1.96737236     0.91849694\n"
"                                                      -1.45806869\n"
"     0.43025641    2     3.52435692     0.29208431\n"
"                                       -0.69119763\n"
"     0.51712005    1     0.62922850\n"
"#","\n"
"Rb GTH-PADE-q1 GTH-LDA-q1\n"
"    1\n"
"     1.09620685    2     0.84733274    -0.74812032\n"
"    3\n"
"     0.95569909    3     0.88746022    -0.34976454    -0.00164684\n"
"                                        0.90308815     0.00425212\n"
"                                                      -0.00675003\n"
"     1.15668058    2     0.46173448    -0.14203355\n"
"                                        0.33611273\n"
"     0.66432256    1    -1.36293829\n"
"#","\n"
"Rb GTH-PADE-q9 GTH-LDA-q9 GTH-PADE GTH-LDA\n"
"    3    6\n"
"     0.49000000    2     4.50415106    -0.74101810\n"
"    3\n"
"     0.28230077    2     9.53632920    -3.67415744\n"
"                                        9.48663373\n"
"     0.30188614    2     2.20959243    -2.31371511\n"
"                                        5.47524928\n"
"     0.51489528    1     0.44937574\n"
"#","\n"
"Sr GTH-PADE-q10 GTH-LDA-q10 GTH-PADE GTH-LDA\n"
"    4    6\n"
"     0.48000000    2     5.57145509    -1.07996304\n"
"    3\n"
"     0.27544056    2     9.99513531    -3.61608019\n"
"                                        9.33667892\n"
"     0.30224313    2     3.16912572    -1.71111259\n"
"                                        4.04923144\n"
"     0.50204544    1     0.43872821\n"
"#","\n"
"Sr GTH-PADE-q2 GTH-LDA-q2\n"
"    2\n"
"     1.01000000    2     0.68474888    -0.06212465\n"
"    3\n"
"     0.83756431    3     1.20039504    -0.35889978    -0.07706135\n"
"                                        0.92667525     0.19897155\n"
"                                                      -0.31585755\n"
"     1.17417825    2     0.43998339    -0.00771915\n"
"                                        0.01826685\n"
"     0.74317548    1    -1.38699026\n"
"#","\n"
"Y GTH-PADE-q11 GTH-LDA-q11 GTH-PADE GTH-LDA\n"
"    4    6    1\n"
"     0.47500000    2     6.89262113    -1.44841137\n"
"    3\n"
"     0.25929613    2    11.06849407    -4.05874563\n"
"                                       10.47963616\n"
"     0.28851147    2     3.01907548    -1.80967899\n"
"                                        4.28248210\n"
"     0.50364209    2     0.33991901    -0.00795600\n"
"                                        0.01804251\n"
"#","\n"
"Y GTH-PADE-q3 GTH-LDA-q3\n"
"    2    0    1\n"
"     0.90000000    1    -0.34389132\n"
"    3\n"
"     0.78245699    3     1.52065466    -0.57489340    -0.04611453\n"
"                                        1.48436836     0.11906721\n"
"                                                      -0.18901334\n"
"     0.94986375    2     0.78095000    -0.15582064\n"
"                                        0.36873894\n"
"     0.65385060    2    -1.25692979     0.03323415\n"
"                                       -0.07536797\n"
"#","\n"
"Zr GTH-PADE-q12 GTH-LDA-q12 GTH-PADE GTH-LDA\n"
"    4    6    2\n"
"     0.47000000    2     6.34261837    -1.73217100\n"
"    3\n"
"     0.26250960    2    11.10177456    -3.71411720\n"
"                                        9.58980939\n"
"     0.28881376    2     3.44681955    -1.78708731\n"
"                                        4.22902044\n"
"     0.58825239    2     0.33463695     0.08621617\n"
"                                       -0.19551990\n"
"#","\n"
"Zr GTH-PADE-q4 GTH-LDA-q4\n"
"    2    0    2\n"
"     0.75000000    1    -0.78261098\n"
"    3\n"
"     0.64999821    3     1.73987747    -0.92494916     0.29407499\n"
"                                        2.38820846    -0.75929835\n"
"                                                       1.20534876\n"
"     0.87440769    2     1.01829381    -0.22321509\n"
"                                        0.52822332\n"
"     0.63066761    2    -1.17391057    -0.09356197\n"
"                                        0.21217861\n"
"#","\n"
"Nb GTH-PADE-q13 GTH-LDA-q13 GTH-PADE GTH-LDA\n"
"    3    6    4\n"
"     0.46000000    2    13.50539360     0.75243372\n"
"    3\n"
"     0.39370802    2     3.22202457     1.78131738\n"
"                                       -4.59934171\n"
"     0.40362557    2    -0.82203677     0.94968536\n"
"                                       -2.24736575\n"
"     0.51364405    2    -1.48984771    -0.36326930\n"
"                                        0.82381733\n"
"#","\n"
"Nb GTH-PADE-q5 GTH-LDA-q5\n"
"    1    0    4\n"
"     0.72400000    1     4.02105754\n"
"    3\n"
"     0.69970828    2     1.53265135    -0.55316427\n"
"                                        1.42826399\n"
"     0.84667164    2     0.60967518    -0.25218878\n"
"                                        0.59678759\n"
"     0.51607226    2    -2.69682993     0.74741000\n"
"                                       -1.69496657\n"
"#","\n"
"Mo GTH-PADE-q14 GTH-LDA-q14 GTH-PADE GTH-LDA\n"
"    3    6    5\n"
"     0.43000000    2    16.23745228     1.49653613\n"
"    3\n"
"     0.37625527    2     3.36242551     2.04852792\n"
"                                       -5.28927635\n"
"     0.36173435    2    -0.37957075     1.71892268\n"
"                                       -4.06771350\n"
"     0.52582812    2    -1.54321130    -0.47376044\n"
"                                        1.07438769\n"
"#","\n"
"Mo GTH-PADE-q6 GTH-LDA-q6\n"
"    1    0    5\n"
"     0.69900000    1     7.99586821\n"
"    3\n"
"     0.67812595    2     1.28960728    -0.38656751\n"
"                                        0.99811301\n"
"     0.80077140    2     0.30141226    -0.31338933\n"
"                                        0.74161451\n"
"     0.45338393    2    -2.80970771     3.00775463\n"
"                                       -6.82094635\n"
"#","\n"
"Tc GTH-PADE-q15 GTH-LDA-q15 GTH-PADE GTH-LDA\n"
"    3    6    6\n"
"     0.43000001    2    14.91001129     1.04638147\n"
"    3\n"
"     0.36972111    2     3.91740844     2.04044213\n"
"                                       -5.26839892\n"
"     0.35777235    2    -0.27000007     1.57949660\n"
"                                       -3.73777116\n"
"     0.51048733    2    -1.58670910    -0.49930056\n"
"                                        1.13230724\n"
"#","\n"
"Tc GTH-PADE-q7 GTH-LDA-q7\n"
"    1    0    6\n"
"     0.67300000    1    13.31538067\n"
"    3\n"
"     0.67761188    2     0.81921767    -0.13495786\n"
"                                        0.34845968\n"
"     0.78427538    2     0.02867266    -0.27820911\n"
"                                        0.65836292\n"
"     0.51988975    2    -5.98422427    -0.31829379\n"
"                                        0.72182246\n"
"#","\n"
"Ru GTH-PADE-q16 GTH-LDA-q16 GTH-PADE GTH-LDA\n"
"    3    6    7\n"
"     0.43000000    2    13.58257130     0.59622675\n"
"    3\n"
"     0.36408374    2     4.48063220     2.04055059\n"
"                                       -5.26867898\n"
"     0.36405317    2    -0.32037214     1.29296495\n"
"                                       -3.05971353\n"
"     0.49585036    2    -1.59787017    -0.51393501\n"
"                                        1.16549505\n"
"#","\n"
"Ru GTH-PADE-q8 GTH-LDA-q8\n"
"    1    0    7\n"
"     0.64721429    1     8.68772333\n"
"    3\n"
"     0.62565612    2     1.63786602    -0.51484914\n"
"                                        1.32933477\n"
"     0.74642487    2     0.63901157    -0.27483407\n"
"                                        0.65037612\n"
"     0.44035802    2    -4.88336495     1.35098513\n"
"                                       -3.06374629\n"
"#","\n"
"Rh GTH-PADE-q17 GTH-LDA-q17 GTH-PADE GTH-LDA\n"
"    3    6    8\n"
"     0.42000000    2    15.22501231     0.41591145\n"
"    3\n"
"     0.35005185    2     4.71529244     2.24847003\n"
"                                       -5.80552464\n"
"     0.35025339    2    -0.50469386     1.42536937\n"
"                                       -3.37303956\n"
"     0.49694980    2    -1.68559431    -0.61192127\n"
"                                        1.38770701\n"
"#","\n"
"Rh GTH-PADE-q9 GTH-LDA-q9\n"
"    1    0    8\n"
"     0.62142857    1     5.39796233\n"
"    3\n"
"     0.59807881    2     2.24211131    -0.83330981\n"
"                                        2.15159669\n"
"     0.70958567    2     1.15527830    -0.29785195\n"
"                                        0.70484635\n"
"     0.36920687    2    -1.05305819     4.81701344\n"
"                                      -10.92395969\n"
"#","\n"
"Pd GTH-PADE-q10 GTH-LDA-q10\n"
"    0    0   10\n"
"     0.59600000    1     5.20966476\n"
"    3\n"
"     0.58220422    2     2.41107608    -0.89811395\n"
"                                        2.31892024\n"
"     0.68878713    2     1.22725330    -0.32032214\n"
"                                        0.75802053\n"
"     0.44283523    2    -4.37713124    -0.18223540\n"
"                                        0.41327105\n"
"#","\n"
"Pd GTH-PADE-q18 GTH-LDA-q18 GTH-PADE GTH-LDA\n"
"    2    6   10\n"
"     0.41000000    2    15.72025922     0.14076508\n"
"    3\n"
"     0.34215063    2     5.17768606     2.26678707\n"
"                                       -5.85281906\n"
"     0.34311064    2    -0.37256076     1.37706395\n"
"                                       -3.25872809\n"
"     0.49491624    2    -1.60827298    -0.63789470\n"
"                                        1.44660922\n"
"#","\n"
"Ag GTH-PADE-q1 GTH-LDA-q1\n"
"    1\n"
"     0.65000000    1    -2.37606096\n"
"    3\n"
"     1.01270456    3     0.89793134     0.28982424     0.00726736\n"
"                                       -0.74832297    -0.01876424\n"
"                                                       0.02978730\n"
"     1.23584202    2     0.13008068     0.11726324\n"
"                                       -0.27749548\n"
"     1.01615913    1    -0.03884235\n"
"#","\n"
"Ag GTH-PADE-q11 GTH-LDA-q11 GTH-PADE GTH-LDA\n"
"    1    0   10\n"
"     0.57000000    1     1.01705324\n"
"    3\n"
"     0.49890039    3     2.99028401    -1.51526425     0.53817162\n"
"                                        3.91239548    -1.38955314\n"
"                                                       2.20584723\n"
"     0.63000853    2     1.81396786    -0.55123072\n"
"                                        1.30444997\n"
"     0.38765955    2    -3.42007573     0.44975502\n"
"                                       -1.01994852\n"
"#","\n"
"Ag GTH-PADE-q19 GTH-LDA-q19\n"
"    3    6   10\n"
"     0.40000000    2    26.10213544    -5.21734352\n"
"    3\n"
"     0.30814467    2     1.55692822     3.68811443\n"
"                                       -4.76133525\n"
"     0.42100419    2     0.24550848    -0.89060050\n"
"                                        1.05377272\n"
"     0.44722234    2     1.87011922    -3.09368795\n"
"                                        3.50791241\n"
"#","\n"
"Cd GTH-PADE-q12 GTH-LDA-q12 GTH-PADE GTH-LDA\n"
"    2    0   10\n"
"     0.55000000    1     2.38271306\n"
"    3\n"
"     0.49150479    3     3.20793247    -1.60378823     0.38651363\n"
"                                        4.14096341    -0.99797390\n"
"                                                       1.58423446\n"
"     0.59856481    2     1.94014994    -0.64058146\n"
"                                        1.51589242\n"
"     0.37787436    2    -4.19007193     0.33960669\n"
"                                       -0.77015558\n"
"#","\n"
"Cd GTH-PADE-q2 GTH-LDA-q2\n"
"    2\n"
"     0.62500000    1    -1.79683799\n"
"    3\n"
"     0.82846467    3     1.48529241     0.16450606    -0.09953846\n"
"                                       -0.42475283     0.25700719\n"
"                                                      -0.40798627\n"
"     0.97287254    2     0.46920843     0.18936149\n"
"                                       -0.44811107\n"
"     1.24094900    1     0.06541164\n"
"#","\n"
"In GTH-PADE-q13 GTH-LDA-q13 GTH-PADE GTH-LDA\n"
"    2    1   10\n"
"     0.53000000    1     2.39540385\n"
"    3\n"
"     0.47408054    3     3.55441064    -1.84126870     0.38183068\n"
"                                        4.75413535    -0.98588258\n"
"                                                       1.56504008\n"
"     0.55981945    2     2.22366425    -0.86006177\n"
"                                        2.03527762\n"
"     0.36048751    2    -4.56641372     0.34120718\n"
"                                       -0.77378515\n"
"#","\n"
"In GTH-PADE-q3 GTH-LDA-q3\n"
"    2    1\n"
"     0.61000000    1     2.86577676\n"
"    3\n"
"     0.77060197    3     1.25619360     0.15385620    -0.06790534\n"
"                                       -0.39725499     0.17533083\n"
"                                                      -0.27832906\n"
"     0.85813160    2     0.49445864     0.16091263\n"
"                                       -0.38078878\n"
"     1.08869090    1     0.12920778\n"
"#","\n"
"Sn GTH-PADE-q4 GTH-LDA-q4 GTH-PADE GTH-LDA\n"
"    2    2\n"
"     0.60500000    1     4.61091234\n"
"    3\n"
"     0.66354369    3     1.64879146     0.05498623    -0.14066273\n"
"                                       -0.14197384     0.36318961\n"
"                                                      -0.57654563\n"
"     0.74586492    2     0.76935544     0.18807652\n"
"                                       -0.44507028\n"
"     0.94445897    1     0.22511508\n"
"#","\n"
"Sb GTH-PADE-q5 GTH-LDA-q5 GTH-PADE GTH-LDA\n"
"    2    3\n"
"     0.59000000    1     6.68022783\n"
"    3\n"
"     0.59768356    3     1.95147672    -0.01453812    -0.19191821\n"
"                                        0.03753727     0.49553069\n"
"                                                      -0.78663058\n"
"     0.67212205    2     0.97031285     0.19722998\n"
"                                       -0.46673132\n"
"     0.85655729    1     0.30010262\n"
"#","\n"
"Te GTH-PADE-q6 GTH-LDA-q6 GTH-PADE GTH-LDA\n"
"    2    4\n"
"     0.57500000    1     9.38708481\n"
"    3\n"
"     0.55645602    3     2.04689031     0.01136047    -0.21497109\n"
"                                       -0.02933260     0.55505297\n"
"                                                      -0.88111927\n"
"     0.61526187    2     1.03347754     0.20333245\n"
"                                       -0.48117240\n"
"     0.80510072    1     0.31741073\n"
"#","\n"
"I GTH-PADE-q7 GTH-LDA-q7 GTH-PADE GTH-LDA\n"
"    2    5\n"
"     0.56000000    1    14.66182521\n"
"    3\n"
"     0.55283008    3     1.33805374     0.32333643    -0.11404312\n"
"                                       -0.83485108     0.29445806\n"
"                                                      -0.46743768\n"
"     0.56225147    2     0.67449617     0.24415947\n"
"                                       -0.57778676\n"
"     0.79432495    1     0.22434543\n"
"#","\n"
"Xe GTH-PADE-q8 GTH-LDA-q8 GTH-PADE GTH-LDA\n"
"    2    6\n"
"     0.56000000    1    12.73427972\n"
"    3\n"
"     0.50737118    3     2.23645069     0.15629453    -0.27630331\n"
"                                       -0.40355073     0.71341207\n"
"                                                      -1.13250655\n"
"     0.54102371    2     1.13004299     0.31810091\n"
"                                       -0.75276413\n"
"     0.72982111    1     0.28013078\n"
"#","\n"
"Cs GTH-PADE-q1 GTH-LDA-q1\n"
"    1\n"
"     1.20000000    0\n"
"    3\n"
"     1.22473727    3     0.61152657    -0.09288578    -0.07173455\n"
"                                        0.23983005     0.18521782\n"
"                                                      -0.29402418\n"
"     1.28047759    2     0.24489277    -0.09604275\n"
"                                        0.22727863\n"
"     1.10752212    1    -0.54216260\n"
"#","\n"
"Cs GTH-PADE-q9 GTH-LDA-q9 GTH-PADE GTH-LDA\n"
"    3    6\n"
"     0.54000000    2    35.23443810    -3.31807009\n"
"    4\n"
"     0.45682103    2    -0.28237849     1.07705949\n"
"                                       -2.78095565\n"
"     0.36246700    2    -2.69673321     0.96809883\n"
"                                       -2.29093996\n"
"     0.76146205    1     0.18375440\n"
"     0.33350703    1   -17.94825944\n"
"#","\n"
"Ba GTH-PADE-q10 GTH-LDA-q10 GTH-PADE GTH-LDA\n"
"    4    6\n"
"     0.54000000    2    24.47865325    -2.50084994\n"
"    4\n"
"     0.51477613    2     1.04672903     0.37847454\n"
"                                       -0.97721707\n"
"     0.37519011    2    -0.20243912    -0.28749217\n"
"                                        0.68033065\n"
"     0.66540319    1     0.37841850\n"
"     0.30492043    1   -18.79520777\n"
"#","\n"
"Ba GTH-PADE-q2 GTH-LDA-q2\n"
"    2\n"
"     1.20000000    0\n"
"    3\n"
"     1.01618684    3     0.92259259    -0.29570030    -0.08135711\n"
"                                        0.76349489     0.21006316\n"
"                                                      -0.33346493\n"
"     1.24987991    2     0.44716820    -0.06384326\n"
"                                        0.15108073\n"
"     0.93715823    1    -0.71893382\n"
"#","\n"
"La GTH-PADE-q11 GTH-LDA-q11 GTH-PADE GTH-LDA\n"
"    4    6    1\n"
"     0.53500000    2    19.90930823    -1.47483023\n"
"    4\n"
"     0.55177542    2     1.29327192     0.43447877\n"
"                                       -1.12181937\n"
"     0.47630806    3     1.17252682     0.35023609     0.00887640\n"
"                                       -0.82880986    -0.02100539\n"
"                                                       0.02985728\n"
"     0.62667220    1     0.32837704\n"
"     0.29931017    1   -18.26943896\n"
"#","\n"
"Ce GTH-PADE-q12 GTH-LDA-q12 GTH-PADE GTH-LDA\n"
"    4    6    1    1\n"
"     0.53500000    2    18.26801534    -0.63048034\n"
"    4\n"
"     0.52642558    2    -0.68453554     1.78656499\n"
"                                       -2.30644548\n"
"     0.49085089    2    -1.02722427     1.53667473\n"
"                                       -1.81821806\n"
"     0.69222809    1     0.06340682\n"
"     0.30390134    1   -17.54564801\n"
"#","\n"
"Pr GTH-PADE-q13 GTH-LDA-q13 GTH-PADE GTH-LDA\n"
"    4    6    0    3\n"
"     0.53208333    2    18.42473909    -0.65766893\n"
"    4\n"
"     0.52684996    2     1.01262106     0.66537143\n"
"                                       -1.71798165\n"
"     0.45889736    2     1.11706004     0.78265878\n"
"                                       -1.85210872\n"
"     0.74760989    1     0.01757109\n"
"     0.30077296    1   -17.89711891\n"
"#","\n"
"Nd GTH-PADE-q14 GTH-LDA-q14 GTH-PADE GTH-LDA\n"
"    4    6    0    4\n"
"     0.52916670    2    17.81503043    -0.59479767\n"
"    4\n"
"     0.50299986    2     1.52910988     0.83413680\n"
"                                       -2.15373194\n"
"     0.46701290    2     0.72155346     0.69619548\n"
"                                       -1.64749920\n"
"     0.32528958    1    -0.54324017\n"
"     0.29474281    1   -18.52022760\n"
"#","\n"
"Pm GTH-PADE-q15 GTH-LDA-q15 GTH-PADE GTH-LDA\n"
"    4    6    0    5\n"
"     0.52625000    2    18.25172292    -0.49210744\n"
"    4\n"
"     0.48987856    2     1.30897757     0.97124774\n"
"                                       -2.50775088\n"
"     0.47226016    2     0.16051238     0.66146221\n"
"                                       -1.56530527\n"
"     0.47370914    1    -0.42995241\n"
"     0.29152653    1   -19.30505668\n"
"#","\n"
"Sm GTH-PADE-q16 GTH-LDA-q16 GTH-PADE GTH-LDA\n"
"    4    6    0    6\n"
"     0.52333337    2    17.20679172    -0.53280292\n"
"    4\n"
"     0.47967676    2     1.72363519     1.02996853\n"
"                                       -2.65936731\n"
"     0.49059775    2    -0.08240311     0.46948681\n"
"                                       -1.11100858\n"
"     0.47084026    1    -0.41063034\n"
"     0.28404049    1   -19.98429201\n"
"#","\n"
"Eu GTH-PADE-q17 GTH-LDA-q17 GTH-PADE GTH-LDA\n"
"    4    6    0    7\n"
"     0.52041668    2    17.37351625    -0.64846778\n"
"    4\n"
"     0.46904261    2     1.76363790     1.12972280\n"
"                                       -2.91693172\n"
"     0.44590722    2     0.51804594     0.90228057\n"
"                                       -2.13518554\n"
"     0.49003840    1    -0.42611996\n"
"     0.27840129    1   -20.94652763\n"
"#","\n"
"Gd GTH-PADE-q18 GTH-LDA-q18 GTH-PADE GTH-LDA\n"
"    4    6    0    8\n"
"     0.51750004    2    17.51255640    -0.71953420\n"
"    4\n"
"     0.46201372    2     1.55185591     1.18850339\n"
"                                       -3.06870256\n"
"     0.45695327    2    -0.05834713     0.71741382\n"
"                                       -1.69771095\n"
"     0.48236813    1    -0.56260077\n"
"     0.27338980    1   -21.92349011\n"
"#","\n"
"Tb GTH-PADE-q19 GTH-LDA-q19 GTH-PADE GTH-LDA\n"
"    4    6    0    9\n"
"     0.51458335    2    17.60361623    -0.82808004\n"
"    4\n"
"     0.44869439    2     1.71848088     1.33046245\n"
"                                       -3.43523929\n"
"     0.42422013    2     0.56239978     1.17553634\n"
"                                       -2.78182671\n"
"     0.48280866    1    -0.62580219\n"
"     0.26825995    1   -22.91169709\n"
"#","\n"
"Dy GTH-PADE-q20 GTH-LDA-q20 GTH-PADE GTH-LDA\n"
"    4    6    0   10\n"
"     0.51166666    2    16.99433138    -0.95529792\n"
"    4\n"
"     0.44059045    2     1.94031950     1.37870375\n"
"                                       -3.55979777\n"
"     0.43464206    2     0.01431536     0.86469335\n"
"                                       -2.04623793\n"
"     0.46722880    1    -0.66892417\n"
"     0.26167045    1   -23.92235817\n"
"#","\n"
"Ho GTH-PADE-q21 GTH-LDA-q21 GTH-PADE GTH-LDA\n"
"    4    6    0   11\n"
"     0.50875002    2    16.78157003    -1.17351448\n"
"    4\n"
"     0.43221176    2     2.05279689     1.42314101\n"
"                                       -3.67453429\n"
"     0.42013792    2     0.25329464     0.99529117\n"
"                                       -2.35528878\n"
"     0.44713057    1    -0.74286267\n"
"     0.25499226    1   -25.19721081\n"
"#","\n"
"Er GTH-PADE-q22 GTH-LDA-q22 GTH-PADE GTH-LDA\n"
"    4    6    0   12\n"
"     0.50583333    2    17.10529281    -1.43095318\n"
"    4\n"
"     0.41994801    2     2.14450257     1.54307528\n"
"                                       -3.98420323\n"
"     0.41445530    2     0.05408736     0.96959342\n"
"                                       -2.29447680\n"
"     0.41838497    1    -0.99900632\n"
"     0.24912591    1   -26.69680936\n"
"#","\n"
"Tm GTH-PADE-q23 GTH-LDA-q23 GTH-PADE GTH-LDA\n"
"    4    6    0   13\n"
"     0.50291669    2    17.24729254    -1.62769708\n"
"    4\n"
"     0.41337286    2     1.94719583     1.59627195\n"
"                                       -4.12155644\n"
"     0.40992301    2    -0.09449281     0.93984837\n"
"                                       -2.22408718\n"
"     0.39287009    1    -1.35330770\n"
"     0.24391696    1   -28.10415875\n"
"#","\n"
"Yb GTH-PADE-q24 GTH-LDA-q24 GTH-PADE GTH-LDA\n"
"    4    6    0   14\n"
"     0.50000000    2    17.35714421    -1.77391642\n"
"    4\n"
"     0.40230918    2     2.12077095     1.86019003\n"
"                                       -4.80298999\n"
"     0.41435774    2    -0.92321216     0.70931244\n"
"                                       -1.67853959\n"
"     0.44402468    1    -0.88996733\n"
"     0.23829829    1   -29.93285367\n"
"#","\n"
"Lu GTH-PADE-q25 GTH-LDA-q25 GTH-PADE GTH-LDA\n"
"    4    6    1   14\n"
"     0.49700000    2    17.03705292    -1.66161023\n"
"    4\n"
"     0.39120615    2     2.18467779     2.10393860\n"
"                                       -5.43234610\n"
"     0.39389567    2    -0.71981878     1.15101512\n"
"                                       -2.72379890\n"
"     0.43651827    1    -1.17324513\n"
"     0.23262926    1   -31.85226177\n"
"#","\n"
"Hf GTH-PADE-q12 GTH-LDA-q12 GTH-PADE GTH-LDA\n"
"    4    6    2\n"
"     0.56000000    2     5.13480056     0.52919062\n"
"    3\n"
"     0.42281035    3     2.56444209     2.32910852     0.27075363\n"
"                                       -6.01373234    -0.69908286\n"
"                                                       1.10975964\n"
"     0.47268130    2    -1.02527490     0.79129612\n"
"                                       -1.87254839\n"
"     0.42638752    2     1.45936326     2.32948018\n"
"                                       -5.28276448\n"
"#","\n"
"Ta GTH-PADE-q13 GTH-LDA-q13 GTH-PADE GTH-LDA\n"
"    4    6    3\n"
"     0.55000000    2     4.54623627     0.77942234\n"
"    3\n"
"     0.42185350    3     2.70813558     2.24282880     0.23120613\n"
"                                       -5.79095906    -0.59697167\n"
"                                                       0.94766314\n"
"     0.46134516    2    -0.72485277     0.93609767\n"
"                                       -2.21521141\n"
"     0.41099434    2     1.34849472     2.37542018\n"
"                                       -5.38694662\n"
"#","\n"
"Ta GTH-PADE-q5 GTH-LDA-q5\n"
"    2    0    3\n"
"     0.74400000    1     3.62311645\n"
"    3\n"
"     0.58180113    2     2.00533833    -1.17236605\n"
"                                        3.02703613\n"
"     0.77064628    2     0.51856664    -0.50091380\n"
"                                        1.18537841\n"
"     0.53436996    2    -2.20220040     0.73493457\n"
"                                       -1.66667495\n"
"#","\n"
"W GTH-PADE-q14 GTH-LDA-q14 GTH-PADE GTH-LDA\n"
"    4    6    4\n"
"     0.54000000    2     4.80025094     0.90154434\n"
"    3\n"
"     0.41856963    3     2.69220433     2.33255747     0.29723855\n"
"                                       -6.02263750    -0.76746663\n"
"                                                       1.21831550\n"
"     0.44955492    2    -0.70208426     1.03602407\n"
"                                       -2.45168043\n"
"     0.39960167    2     1.17743638     2.44891670\n"
"                                       -5.55362106\n"
"#","\n"
"W GTH-PADE-q6 GTH-LDA-q6\n"
"    2    0    4\n"
"     0.71900000    1     4.05844991\n"
"    3\n"
"     0.58246289    2     2.16116556    -1.06177835\n"
"                                        2.74149991\n"
"     0.74230741    2     0.60097339    -0.54932611\n"
"                                        1.29994284\n"
"     0.53495887    2    -2.51706347     0.34797654\n"
"                                       -0.78913661\n"
"#","\n"
"Re GTH-PADE-q15 GTH-LDA-q15 GTH-PADE GTH-LDA\n"
"    4    6    5\n"
"     0.53000000    2     5.59266028     0.94395680\n"
"    3\n"
"     0.40325199    3     2.76072043     2.47732079     0.21194880\n"
"                                       -6.39641476    -0.54724946\n"
"                                                       0.86873158\n"
"     0.44095069    2    -0.90054631     1.06118049\n"
"                                       -2.51121137\n"
"     0.39039544    2     0.87525142     2.50135628\n"
"                                       -5.67254285\n"
"#","\n"
"Re GTH-PADE-q7 GTH-LDA-q7\n"
"    2    0    5\n"
"     0.69300000    1     8.18081618\n"
"    3\n"
"     0.50981621    2     2.26937936    -1.36659354\n"
"                                        3.52852934\n"
"     0.74583906    2     0.49669329    -0.39123421\n"
"                                        0.92582911\n"
"     0.50095420    2    -3.68962967     0.83544051\n"
"                                       -1.89460099\n"
"#","\n"
"Os GTH-PADE-q16 GTH-LDA-q16 GTH-PADE GTH-LDA\n"
"    4    6    6\n"
"     0.52000000    2     5.61307299     0.92195476\n"
"    3\n"
"     0.41057830    3     2.78575826     2.59185074     0.54822025\n"
"                                       -6.69212983    -1.41549860\n"
"                                                       2.24703437\n"
"     0.42239546    2    -0.59000550     1.27547446\n"
"                                       -3.01832347\n"
"     0.38025200    2     0.88013282     2.52796761\n"
"                                       -5.73289168\n"
"#","\n"
"Os GTH-PADE-q8 GTH-LDA-q8\n"
"    2    0    6\n"
"     0.66700000    1     9.44045936\n"
"    3\n"
"     0.51030708    2     2.40236688    -1.17998407\n"
"                                        3.04670577\n"
"     0.71755329    2     0.49952321    -0.44509384\n"
"                                        1.05328427\n"
"     0.48758605    2    -4.14203471     0.73468110\n"
"                                       -1.66610013\n"
"#","\n"
"Ir GTH-PADE-q17 GTH-LDA-q17 GTH-PADE GTH-LDA\n"
"    4    6    7\n"
"     0.51000000    2     4.90450946     1.31378645\n"
"    3\n"
"     0.40446887    3     3.24327835     2.83328456     0.72142882\n"
"                                       -7.31550927    -1.86272120\n"
"                                                       2.95697824\n"
"     0.41142571    2    -0.38057445     1.48088044\n"
"                                       -3.50440273\n"
"     0.37642813    2     0.75431547     2.59088743\n"
"                                       -5.87558042\n"
"#","\n"
"Ir GTH-PADE-q9 GTH-LDA-q9\n"
"    2    0    7\n"
"     0.64100000    1    10.72001591\n"
"    3\n"
"     0.50996044    2     2.44599887    -1.08871009\n"
"                                        2.81103736\n"
"     0.68497052    2     0.46179182    -0.55134721\n"
"                                        1.30472563\n"
"     0.47174528    2    -4.54548411     0.72115617\n"
"                                       -1.63542847\n"
"#","\n"
"Pt GTH-PADE-q10 GTH-LDA-q10\n"
"    1    0    9\n"
"     0.61600000    1    11.02741707\n"
"    3\n"
"     0.52013211    2     2.44743006    -1.02260695\n"
"                                        2.64035978\n"
"     0.65897566    2     0.40845297    -0.69628711\n"
"                                        1.64771604\n"
"     0.45124318    2    -4.55229454     0.92706936\n"
"                                       -2.10239568\n"
"#","\n"
"Pt GTH-PADE-q18 GTH-LDA-q18 GTH-PADE GTH-LDA\n"
"    3    6    9\n"
"     0.50000000    2     5.44583159     1.15638204\n"
"    3\n"
"     0.40994150    3     2.99436565     2.88489700     1.03520925\n"
"                                       -7.44877202    -2.67289879\n"
"                                                       4.24309529\n"
"     0.39865199    2    -0.22518140     1.59606293\n"
"                                       -3.77697426\n"
"     0.36796397    2     0.63206655     2.53790667\n"
"                                       -5.75543134\n"
"#","\n"
"Au GTH-PADE-q1 GTH-LDA-q1\n"
"    1\n"
"     0.65000000    2    -1.96371223    -1.69812291\n"
"    2\n"
"     0.91930757    3     1.53959915     0.18155717    -0.19323771\n"
"                                       -0.46877861     0.49893761\n"
"                                                      -0.79203890\n"
"     1.14035080    3     0.47122943     0.21024829    -0.06235978\n"
"                                       -0.49753827     0.14757016\n"
"                                                      -0.20975780\n"
"#","\n"
"Au GTH-PADE-q11 GTH-LDA-q11 GTH-PADE GTH-LDA\n"
"    1    0   10\n"
"     0.59000000    1    11.60442790\n"
"    3\n"
"     0.52117975    2     2.53861359    -1.04613664\n"
"                                        2.70111320\n"
"     0.63061306    2     0.39485270    -0.86959213\n"
"                                        2.05783056\n"
"     0.44070643    2    -4.71906966     0.72777081\n"
"                                       -1.65042907\n"
"#","\n"
"Au GTH-PADE-q19 GTH-LDA-q19\n"
"    3    6   10\n"
"     0.49000000    2     9.07322639    -0.34013367\n"
"    3\n"
"     0.28803780    3    -5.90182040    26.42537412   -15.50837777\n"
"                                      -59.33938963    40.04245923\n"
"                                                     -31.78271670\n"
"     0.35586747    2    -7.08858659     8.19796427\n"
"                                       -9.69996213\n"
"     0.33386175    2    -8.82572349     9.56535285\n"
"                                      -10.84609065\n"
"#","\n"
"Hg GTH-PADE-q12 GTH-LDA-q12 GTH-PADE GTH-LDA\n"
"    2    0   10\n"
"     0.57000000    1     2.13457183\n"
"    3\n"
"     0.52180188    2     3.29392021    -1.80519780\n"
"                                        4.66100069\n"
"     0.62164790    2     2.10096040    -0.71415047\n"
"                                        1.68998846\n"
"     0.40189401    2    -1.66988578     1.09060737\n"
"                                       -2.47326503\n"
"#","\n"
"Hg GTH-PADE-q2 GTH-LDA-q2\n"
"    2\n"
"     0.64000000    1    -3.29632880\n"
"    3\n"
"     0.81210780    3     1.76504143     0.18053035    -0.19516558\n"
"                                       -0.46612737     0.50391537\n"
"                                                      -0.79994085\n"
"     1.05371378    2     0.47405588     0.22473320\n"
"                                       -0.53181582\n"
"     1.10000000    1     0.12063831\n"
"#","\n"
"Tl GTH-PADE-q13 GTH-LDA-q13 GTH-PADE GTH-LDA\n"
"    2    1   10\n"
"     0.55000000    1     7.30188582\n"
"    3\n"
"     0.50242266    2     3.32656022    -1.68141322\n"
"                                        4.34139027\n"
"     0.57201594    2     1.27280729    -1.26443781\n"
"                                        2.99220598\n"
"     0.39318504    2    -3.20065227     1.32653373\n"
"                                       -3.00829573\n"
"#","\n"
"Tl GTH-PADE-q3 GTH-LDA-q3\n"
"    2    1\n"
"     0.63000000    1    -1.23584552\n"
"    3\n"
"     0.75400547    3     1.87576571     0.11761462    -0.19062668\n"
"                                       -0.30367964     0.49219597\n"
"                                                      -0.78133689\n"
"     0.90374170    2     0.75966830     0.24793467\n"
"                                       -0.58672051\n"
"     1.06351212    1     0.24761396\n"
"#","\n"
"Pb GTH-PADE-q4 GTH-LDA-q4 GTH-PADE GTH-LDA\n"
"    2    2\n"
"     0.61750000    1     0.75314257\n"
"    3\n"
"     0.70525860    3     1.97992741     0.06388872    -0.19665860\n"
"                                       -0.16495996     0.50777033\n"
"                                                      -0.80606040\n"
"     0.84664106    2     0.86442030     0.22860106\n"
"                                       -0.54096885\n"
"     0.97193857    1     0.37496708\n"
"#","\n"
"Bi GTH-PADE-q5 GTH-LDA-q5 GTH-PADE GTH-LDA\n"
"    2    3\n"
"     0.60500000    1     6.67943714\n"
"    3\n"
"     0.67885795    3     1.37763378     0.19895396    -0.11491910\n"
"                                       -0.51369691     0.29671983\n"
"                                                      -0.47102813\n"
"     0.79867267    2     0.65557809     0.17026993\n"
"                                       -0.40293219\n"
"     0.93468255    1     0.37847579\n"
"#","\n"
"Po GTH-PADE-q6 GTH-LDA-q6 GTH-PADE GTH-LDA\n"
"    2    4\n"
"     0.59250000    1    10.41173070\n"
"    3\n"
"     0.64794961    3     1.14420296     0.28499406    -0.08280174\n"
"                                       -0.73585149     0.21379318\n"
"                                                      -0.33938616\n"
"     0.74894708    2     0.59456184     0.14942108\n"
"                                       -0.35359482\n"
"     0.88046840    1     0.43323228\n"
"#","\n"
"At GTH-PADE-q7 GTH-LDA-q7 GTH-PADE GTH-LDA\n"
"    2    5\n"
"     0.58000000    1    13.52041116\n"
"    3\n"
"     0.62782694    3     0.94555652     0.37409257    -0.04645981\n"
"                                       -0.96590285     0.11995872\n"
"                                                      -0.19042856\n"
"     0.70982320    2     0.52707805     0.13472635\n"
"                                       -0.31882073\n"
"     0.83836499    1     0.46894787\n"
"#","\n"
"Rn GTH-PADE-q8 GTH-LDA-q8 GTH-PADE GTH-LDA\n"
"    2    6\n"
"     0.57000000    1    14.62918461\n"
"    3\n"
"     0.61518195    3     0.98183224     0.40238854    -0.02938821\n"
"                                       -1.03896274     0.07588004\n"
"                                                      -0.12045584\n"
"     0.67669721    2     0.61227859     0.14541822\n"
"                                       -0.34412231\n"
"     0.78833715    1     0.55774596\n"
"#","\n"
"H GTH-PBE-q1 GTH-PBE\n"
"    1\n"
"     0.20000000    2    -4.17890044     0.72446331\n"
"    0\n"
"#","\n"
"He GTH-PBE-q2 GTH-PBE\n"
"    2\n"
"     0.20000000    2    -9.12214383     1.70270770\n"
"    0\n"
"#","\n"
"Li GTH-PBE-q3 GTH-PBE\n"
"    3\n"
"     0.40000000    4   -14.08115455     9.62621962    -1.78361605     0.08515207\n"
"    0\n"
"#","\n"
"Be GTH-PBE-q4 GTH-PBE\n"
"    4\n"
"     0.32500000    4   -24.06746684    17.27902186    -3.33910629     0.16554912\n"
"    0\n"
"#","\n"
"B GTH-PBE-q3 GTH-PBE\n"
"    2    1\n"
"     0.41899145    2    -5.85946171     0.90375643\n"
"    2\n"
"     0.37132046    1     6.29728018\n"
"     0.36456308    0\n"
"#","\n"
"C GTH-PBE-q4 GTH-PBE\n"
"    2    2\n"
"     0.33847124    2    -8.80367398     1.33921085\n"
"    2\n"
"     0.30257575    1     9.62248665\n"
"     0.29150694    0\n"
"#","\n"
"N GTH-PBE-q5 GTH-PBE\n"
"    2    3\n"
"     0.28379051    2   -12.41522559     1.86809592\n"
"    2\n"
"     0.25540500    1    13.63026257\n"
"     0.24549453    0\n"
"#","\n"
"O GTH-PBE-q6 GTH-PBE\n"
"    2    4\n"
"     0.24455430    2   -16.66721480     2.48731132\n"
"    2\n"
"     0.22095592    1    18.33745811\n"
"     0.21133247    0\n"
"#","\n"
"F GTH-PBE-q7 GTH-PBE\n"
"    2    5\n"
"     0.21492959    2   -21.57302836     3.19977615\n"
"    2\n"
"     0.19468402    1    23.74354045\n"
"     0.18615608    0\n"
"#","\n"
"Ne GTH-PBE-q8 GTH-PBE\n"
"    2    6\n"
"     0.19000000    2   -27.12015973     4.36044962\n"
"    2\n"
"     0.17605938    2    28.17737082     0.83365601\n"
"                                       -1.07624528\n"
"     0.19547452    1    -0.23629360\n"
"#","\n"
"Na GTH-PBE-q9 GTH-PBE\n"
"    3    6\n"
"     0.23652322    2     0.29510499    -0.91388488\n"
"    2\n"
"     0.14356046    1    34.60149228\n"
"     0.12993224    1   -14.27746168\n"
"#","\n"
"Mg GTH-PBE-q10 GTH-PBE\n"
"    4    6\n"
"     0.19275787    2   -20.57539077     3.04016732\n"
"    2\n"
"     0.14140682    1    41.04729209\n"
"     0.10293187    1    -9.98562566\n"
"#","\n"
"Mg GTH-PBE-q2\n"
"    2\n"
"     0.57696017    1    -2.69040744\n"
"    2\n"
"     0.59392350    2     3.50321099    -0.71677167\n"
"                                        0.92534825\n"
"     0.70715728    1     0.83115848\n"
"#","\n"
"Al GTH-PBE-q3 GTH-PBE\n"
"    2    1\n"
"     0.45000000    1    -7.55476126\n"
"    2\n"
"     0.48743529    2     6.95993832    -1.88883584\n"
"                                        2.43847659\n"
"     0.56218949    1     1.86529857\n"
"#","\n"
"Si GTH-PBE-q4 GTH-PBE\n"
"    2    2\n"
"     0.44000000    1    -6.26928833\n"
"    2\n"
"     0.43563383    2     8.95174150    -2.70627082\n"
"                                        3.49378060\n"
"     0.49794218    1     2.43127673\n"
"#","\n"
"P GTH-PBE-q5 GTH-PBE\n"
"    2    3\n"
"     0.43000000    1    -5.87594327\n"
"    2\n"
"     0.39637742    2    11.00886207    -3.47035607\n"
"                                        4.48021042\n"
"     0.44829838    1     3.05606416\n"
"#","\n"
"S GTH-PBE-q6 GTH-PBE\n"
"    2    4\n"
"     0.42000000    1    -5.98626038\n"
"    2\n"
"     0.36482035    2    13.14354448    -4.24183045\n"
"                                        5.47617957\n"
"     0.40948048    1     3.70089057\n"
"#","\n"
"Cl GTH-PBE-q7 GTH-PBE\n"
"    2    5\n"
"     0.41000000    1    -6.39208181\n"
"    2\n"
"     0.33953864    2    15.21898983    -4.93452321\n"
"                                        6.37044208\n"
"     0.37847416    1     4.33877527\n"
"#","\n"
"Ar GTH-PBE-q8 GTH-PBE\n"
"    2    6\n"
"     0.40000000    1    -7.10000000\n"
"    2\n"
"     0.31881468    2    17.25203807    -5.58548836\n"
"                                        7.21083447\n"
"     0.35337019    1     4.97421551\n"
"#","\n"
"K GTH-PBE-q9 GTH-PBE\n"
"    3    6\n"
"     0.40000000    2    -3.36355184    -1.08652975\n"
"    2\n"
"     0.30531772    2    17.85062321    -5.62264870\n"
"                                        7.25880826\n"
"     0.31648432    2     7.33378021    -2.46094505\n"
"                                        2.91182945\n"
"#","\n"
"Ca GTH-PBE-q10 GTH-PBE\n"
"    4    6\n"
"     0.39000000    2    -4.16707222    -1.58379781\n"
"    3\n"
"     0.28935572    2    20.53187635    -7.12978578\n"
"                                        9.20451387\n"
"     0.32788206    2     5.80560513    -0.42875336\n"
"                                        0.50730782\n"
"     0.67961713    1     0.05806826\n"
"#","\n"
"Sc GTH-PBE-q11 GTH-PBE\n"
"    4    6    1\n"
"     0.38500000    2     8.21490030    -0.55705910\n"
"    3\n"
"     0.36361108    2     2.64653339     3.02108393\n"
"                                       -3.90020259\n"
"     0.24389778    2    -2.63482265     7.99213715\n"
"                                       -9.45642421\n"
"     0.25320575    1    -8.16594769\n"
"#","\n"
"Ti GTH-PBE-q12 GTH-PBE\n"
"    4    6    2\n"
"     0.38000000    2     8.71144218    -0.70028677\n"
"    3\n"
"     0.33777078    2     2.57526386     3.69297065\n"
"                                       -4.76760461\n"
"     0.24253135    2    -4.63054123     8.87087502\n"
"                                      -10.49616087\n"
"     0.24331694    1    -9.40665268\n"
"#","\n"
"V GTH-PBE-q13 GTH-PBE\n"
"    4    6    3\n"
"     0.37500000    2     7.47470354    -0.37026363\n"
"    3\n"
"     0.32779544    2     1.94087762     4.72568824\n"
"                                       -6.10083728\n"
"     0.24476590    2    -5.97816705     9.35863915\n"
"                                      -11.07329118\n"
"     0.24173879    1    -9.49989110\n"
"#","\n"
"Cr GTH-PBE-q14 GTH-PBE\n"
"    3    6    5\n"
"     0.37000000    2     5.69965764    -0.69548599\n"
"    3\n"
"     0.31393442    2     2.86995474     4.97445648\n"
"                                       -6.42199570\n"
"     0.24086624    2    -4.47620867     7.33141440\n"
"                                       -8.67464650\n"
"     0.22028633    1   -11.19711641\n"
"#","\n"
"Mn GTH-PBE-q15 GTH-PBE\n"
"    4    6    5\n"
"     0.36500000    2     6.09304649    -0.44646948\n"
"    3\n"
"     0.29568592    2     1.88711984     6.35683658\n"
"                                       -8.20664074\n"
"     0.24561261    2    -6.57002452     7.98335983\n"
"                                       -9.44603874\n"
"     0.22252279    1   -11.61205092\n"
"#","\n"
"Fe GTH-PBE-q16 GTH-PBE\n"
"    4    6    6\n"
"     0.36000000    2     6.75678916    -0.22883251\n"
"    3\n"
"     0.27826303    2     0.62950570     7.91313242\n"
"                                      -10.21581002\n"
"     0.25138338    2    -7.93213293     7.69707888\n"
"                                       -9.10730654\n"
"     0.22285578    1   -12.38579937\n"
"#","\n"
"Co GTH-PBE-q17 GTH-PBE\n"
"    4    6    7\n"
"     0.35500000    2     4.82819736     0.36814301\n"
"    3\n"
"     0.27680076    2    -0.58449582     9.28629277\n"
"                                      -11.98855242\n"
"     0.26815783    2    -6.85195349     5.68013280\n"
"                                       -6.72082376\n"
"     0.22258414    1   -12.33315019\n"
"#","\n"
"Ni GTH-PBE-q18 GTH-PBE\n"
"    4    6    8\n"
"     0.35000000    2     2.10216598     0.64848387\n"
"    3\n"
"     0.26129530    2     0.62265847     9.97022667\n"
"                                      -12.87150729\n"
"     0.22425346    2   -11.14270822    12.42956644\n"
"                                      -14.70686134\n"
"     0.21534825    1   -12.62814550\n"
"#","\n"
"Cu GTH-PBE-q11 GTH-PBE\n"
"    1    0   10\n"
"     0.53000000    0\n"
"    3\n"
"     0.43135505    3     9.69380507    -6.47016535     1.93595215\n"
"                                       11.50177396    -4.99860696\n"
"                                                       3.96752127\n"
"     0.56139155    2     2.54547330    -0.78463573\n"
"                                        0.92839352\n"
"     0.26455485    1   -12.82861406\n"
"#","\n"
"Cu GTH-PBE-q19\n"
"    3    6   10\n"
"     0.34500000    2     0.05196970     1.24904337\n"
"    3\n"
"     0.25002849    2     0.75019332    10.73582127\n"
"                                      -13.85988567\n"
"     0.22202454    2   -13.05959885    14.74763830\n"
"                                      -17.44964096\n"
"     0.21556837    1   -12.45672374\n"
"#","\n"
"Zn GTH-PBE-q12 GTH-PBE\n"
"    2    0   10\n"
"     0.51000000    0\n"
"    3\n"
"     0.40031644    3    11.53004133    -8.79189815     3.14508644\n"
"                                       16.46577518    -8.12057827\n"
"                                                       6.44550918\n"
"     0.54318233    2     2.59719512    -0.59426275\n"
"                                        0.70314117\n"
"     0.25095885    1   -14.46695795\n"
"#","\n"
"Zn GTH-PBE-q20\n"
"    4    6   10\n"
"     0.34000000    2     0.55188462     1.24394356\n"
"    3\n"
"     0.24394890    2    -1.34762699    12.79313122\n"
"                                      -16.51586139\n"
"     0.23975357    2    -9.72145777     8.07114357\n"
"                                       -9.54990586\n"
"     0.20855195    1   -14.19380873\n"
"#","\n"
"Ga GTH-PBE-q13 GTH-PBE\n"
"    2    1   10\n"
"     0.49000000    0\n"
"    3\n"
"     0.41677723    3    10.47568975    -4.92176814     0.87070559\n"
"                                        7.77017809    -2.24815216\n"
"                                                       1.78441545\n"
"     0.56962652    2     1.77798534     0.19585976\n"
"                                       -0.23174439\n"
"     0.23812650    1   -16.24868022\n"
"#","\n"
"Ga GTH-PBE-q3\n"
"    2    1\n"
"     0.56000000    0\n"
"    3\n"
"     0.56586645    3     2.21575051     1.03244793    -0.76062946\n"
"                                       -2.57004845     1.96393682\n"
"                                                      -1.55882652\n"
"     0.64671613    2     0.31122394     0.61341605\n"
"                                       -0.72580366\n"
"     0.99942484    1     0.08951951\n"
"#","\n"
"Ge GTH-PBE-q4 GTH-PBE\n"
"    2    2\n"
"     0.54000000    0\n"
"    3\n"
"     0.42186518    3     7.51024121    -0.58810836    -1.44797580\n"
"                                       -1.59588819     3.73865744\n"
"                                                      -2.96746735\n"
"     0.56752887    2     0.91385969     0.54687534\n"
"                                       -0.64707163\n"
"     0.81391394    1     0.19717731\n"
"#","\n"
"As GTH-PBE-q5 GTH-PBE\n"
"    2    3\n"
"     0.52000000    0\n"
"    3\n"
"     0.45554957    3     5.52067327     0.03512220    -1.06108239\n"
"                                       -1.77119320     2.73970295\n"
"                                                      -2.17457180\n"
"     0.55460557    2     1.02179156     0.62920826\n"
"                                       -0.74448925\n"
"     0.70368872    1     0.31479504\n"
"#","\n"
"Se GTH-PBE-q6 GTH-PBE\n"
"    2    4\n"
"     0.51000000    0\n"
"    3\n"
"     0.43246005    3     6.51810990    -0.22271639    -1.19612899\n"
"                                       -1.65797833     3.08839178\n"
"                                                      -2.45133498\n"
"     0.47049162    2     2.28126223     0.36533529\n"
"                                       -0.43227055\n"
"     0.62560034    1     0.43979948\n"
"#","\n"
"Br GTH-PBE-q7 GTH-PBE\n"
"    2    5\n"
"     0.50000000    0\n"
"    3\n"
"     0.43803892    3     6.07855632     0.33049817    -1.23838226\n"
"                                       -2.44090020     3.19748924\n"
"                                                      -2.53792841\n"
"     0.45313561    2     2.45930381     0.52275313\n"
"                                       -0.61852985\n"
"     0.56771383    1     0.55926645\n"
"#","\n"
"Kr GTH-PBE-q8 GTH-PBE\n"
"    2    6\n"
"     0.50000000    0\n"
"    3\n"
"     0.42165717    3     6.46530358     0.53866049    -1.50260118\n"
"                                       -3.13938870     3.87969957\n"
"                                                      -3.07941607\n"
"     0.43374437    2     2.60116535     0.70510978\n"
"                                       -0.83429715\n"
"     0.52469073    1     0.63559472\n"
"#","\n"
"Rb GTH-PBE-q9 GTH-PBE\n"
"    3    6\n"
"     0.49000000    2     5.66908644    -0.81162703\n"
"    3\n"
"     0.28180292    2    21.39073240    -8.07866676\n"
"                                       10.42951394\n"
"     0.28570828    2    12.25634859   -12.19854075\n"
"                                       14.43350807\n"
"     0.54179651    1     0.34566626\n"
"#","\n"
"Sr GTH-PBE-q10 GTH-PBE\n"
"    4    6\n"
"     0.48000000    2     6.81095035    -1.19610979\n"
"    3\n"
"     0.27588581    2    21.28971943    -7.89903416\n"
"                                       10.19760926\n"
"     0.28174086    2    11.70905135   -10.96577673\n"
"                                       12.97488200\n"
"     0.52108911    1     0.36053906\n"
"#","\n"
"Y GTH-PBE-q11 GTH-PBE\n"
"    4    6    1\n"
"     0.47500000    2    12.16776904    -2.32855103\n"
"    3\n"
"     0.24674070    2    23.45027195    -8.32535748\n"
"                                       10.74799029\n"
"     0.29656397    2     5.97863401    -5.85234964\n"
"                                        6.92459348\n"
"     0.45045569    2     1.18749048    -1.31867331\n"
"                                        1.49523499\n"
"#","\n"
"Zr GTH-PBE-q12 GTH-PBE\n"
"    4    6    2\n"
"     0.47000000    2     7.79605677    -1.89321030\n"
"    3\n"
"     0.25982885    2    23.38087417    -8.57193933\n"
"                                       11.06632609\n"
"     0.28896899    2     8.59276581    -5.37735808\n"
"                                        6.36257589\n"
"     0.58124504    2     0.02781064     0.27686186\n"
"                                       -0.31393184\n"
"#","\n"
"Nb GTH-PBE-q13 GTH-PBE\n"
"    3    6    4\n"
"     0.46000000    2    26.27526252    -4.57803146\n"
"    3\n"
"     0.35116942    2    -1.04371870     3.27790404\n"
"                                       -4.23175592\n"
"     0.40546040    2    -0.66246647    -0.90782868\n"
"                                        1.07415738\n"
"     0.42212155    2     1.49409323    -3.43003953\n"
"                                        3.88929925\n"
"#","\n"
"Mo GTH-PBE-q14 GTH-PBE\n"
"    3    6    5\n"
"     0.43000000    2    28.60936832    -4.72180336\n"
"    3\n"
"     0.34521579    2     0.14630305     2.76200500\n"
"                                       -3.56573312\n"
"     0.41688762    2    -0.19078495    -0.72874402\n"
"                                        0.86226156\n"
"     0.42050785    2     1.21681419    -2.68646267\n"
"                                        3.04616234\n"
"#","\n"
"Tc GTH-PBE-q15 GTH-PBE\n"
"    3    6    6\n"
"     0.43000000    2    27.30199947    -4.64715709\n"
"    3\n"
"     0.34617499    2    -0.37921852     3.34056578\n"
"                                       -4.31265188\n"
"     0.42346840    2    -0.24151639    -0.82215042\n"
"                                        0.97278149\n"
"     0.43186468    2     1.21878473    -2.67400954\n"
"                                        3.03204182\n"
"#","\n"
"Ru GTH-PBE-q16 GTH-PBE\n"
"    3    6    7\n"
"     0.43000000    2    26.83239104    -5.05049720\n"
"    3\n"
"     0.34135508    2    -0.55504091     3.71548964\n"
"                                       -4.79667650\n"
"     0.42827085    2     0.10677508    -1.27757181\n"
"                                        1.51164335\n"
"     0.43814779    2     1.50921742    -2.94305440\n"
"                                        3.33711002\n"
"#","\n"
"Ru GTH-PBE-q8\n"
"    1    0    7\n"
"     0.61211332    1     5.04489332\n"
"    3\n"
"     0.64215040    2     4.62556355    -1.80334903\n"
"                                        2.32811359\n"
"     0.67936654    2     3.23395238    -2.42101064\n"
"                                        2.86457842\n"
"     0.38059720    2   -15.53165455    13.58045054\n"
"                                      -15.39878349\n"
"#","\n"
"Rh GTH-PBE-q17 GTH-PBE\n"
"    3    6    8\n"
"     0.42000000    2    26.20679340    -4.93738335\n"
"    3\n"
"     0.34544622    2    -0.45248232     3.89280438\n"
"                                       -5.02558885\n"
"     0.37838014    2    -0.94111242    -0.00569931\n"
"                                        0.00674351\n"
"     0.43374725    2     1.57423622    -3.01217170\n"
"                                        3.41548166\n"
"#","\n"
"Rh GTH-PBE-q9\n"
"    1    0    8\n"
"     0.61900948    1     4.70454397\n"
"    3\n"
"     0.61332681    2     4.99320515    -1.92978191\n"
"                                        2.49133773\n"
"     0.69365000    2     2.53237506    -1.28086042\n"
"                                        1.51553449\n"
"     0.37003772    2   -16.88260377    14.71821684\n"
"                                      -16.68888922\n"
"#","\n"
"Pd GTH-PBE-q10\n"
"    0    0   10\n"
"     0.59600000    1     5.29987401\n"
"    3\n"
"     0.59194990    2     5.30819456    -2.06237933\n"
"                                        2.66252027\n"
"     0.66628526    2     2.73458446    -1.46697005\n"
"                                        1.73574237\n"
"     0.43851839    2    -3.71978832    -0.80738825\n"
"                                        0.91549223\n"
"#","\n"
"Pd GTH-PBE-q18 GTH-PBE\n"
"    2    6   10\n"
"     0.41000000    2    26.78365917    -4.93130594\n"
"    3\n"
"     0.33797077    2    -0.71872875     4.38486657\n"
"                                       -5.66083840\n"
"     0.41519591    2    -0.04624449    -1.07795233\n"
"                                        1.27545040\n"
"     0.44027049    2     1.63916358    -3.09368795\n"
"                                        3.50791241\n"
"#","\n"
"Ag GTH-PBE-q11 GTH-PBE\n"
"    1    0   10\n"
"     0.57000000    1     0.03341912\n"
"    3\n"
"     0.52704461    3     9.58204535    -5.27424043     0.99704725\n"
"                                        8.43071259    -2.57436494\n"
"                                                       2.04333882\n"
"     0.62911218    2     3.87401904    -1.74211583\n"
"                                        2.06129925\n"
"     0.40538186    2    -2.72495276    -0.43354851\n"
"                                        0.49159781\n"
"#","\n"
"Ag GTH-PBE-q19\n"
"    3    6   10\n"
"     0.40000000    2    24.53317558    -4.21395181\n"
"    3\n"
"     0.31760029    2     0.62551338     4.28490995\n"
"                                       -5.53179495\n"
"     0.41962178    2    -0.19050165    -0.61441835\n"
"                                        0.72698960\n"
"     0.45640092    2     1.75125916    -3.09368795\n"
"                                        3.50791241\n"
"#","\n"
"Cd GTH-PBE-q12 GTH-PBE\n"
"    2    0   10\n"
"     0.55000000    1     3.63395858\n"
"    3\n"
"     0.49127900    3    10.11138228    -6.50695409     1.80457679\n"
"                                       11.33558598    -4.65939724\n"
"                                                       3.69828191\n"
"     0.59970999    2     4.00148729    -1.88393578\n"
"                                        2.22910288\n"
"     0.37787256    2    -6.13703223     1.53571055\n"
"                                       -1.74133209\n"
"#","\n"
"In GTH-PBE-q13 GTH-PBE\n"
"    2    1   10\n"
"     0.53000000    1     3.32478546\n"
"    3\n"
"     0.47949521    3    11.11716024    -6.57350729     1.50686327\n"
"                                       10.93727471    -3.89070422\n"
"                                                       3.08815074\n"
"     0.56993285    2     4.70061419    -2.21706406\n"
"                                        2.62326557\n"
"     0.37706890    2    -4.00228785    -0.84012846\n"
"                                        0.95261614\n"
"#","\n"
"In GTH-PBE-q3\n"
"    2    1\n"
"     0.61000000    1     5.08622849\n"
"    3\n"
"     0.68888318    3     0.56228376     0.99900413    -0.48093816\n"
"                                       -2.07195476     1.24177699\n"
"                                                      -0.98562993\n"
"     0.76370974    2     0.10892299     0.42327835\n"
"                                       -0.50082970\n"
"     1.14391192    1     0.11683948\n"
"#","\n"
"Sn GTH-PBE-q4 GTH-PBE\n"
"    2    2\n"
"     0.60500000    1     6.26678230\n"
"    3\n"
"     0.56643732    3     1.57118124     1.47004118    -1.17857669\n"
"                                       -3.81477013     3.04307193\n"
"                                                      -2.41536347\n"
"     0.64184959    2     0.52689769     0.40325781\n"
"                                       -0.47714107\n"
"     0.99087302    1     0.19876639\n"
"#","\n"
"Sb GTH-PBE-q5 GTH-PBE\n"
"    2    3\n"
"     0.59000000    1     7.92852084\n"
"    3\n"
"     0.55613636    3     1.43047790     1.26142599    -0.92323353\n"
"                                       -3.13013340     2.38377872\n"
"                                                      -1.89206570\n"
"     0.62275507    2     0.56147233     0.30484522\n"
"                                       -0.36069773\n"
"     0.88948576    1     0.27086864\n"
"#","\n"
"Te GTH-PBE-q6 GTH-PBE\n"
"    2    4\n"
"     0.57500000    1     8.71364868\n"
"    3\n"
"     0.57492240    3     1.40181273     0.97877992    -0.48630602\n"
"                                       -2.05457624     1.25563675\n"
"                                                      -0.99663078\n"
"     0.58989076    2     0.76478865     0.32398623\n"
"                                       -0.38334568\n"
"     0.81338925    1     0.34485820\n"
"#","\n"
"I GTH-PBE-q7 GTH-PBE\n"
"    2    5\n"
"     0.56000000    1     8.20710157\n"
"    3\n"
"     0.53192813    3     2.30814581     1.00390933    -0.95915606\n"
"                                       -2.85610882     2.47653030\n"
"                                                      -1.96568498\n"
"     0.58918244    2     0.90648219     0.42507060\n"
"                                       -0.50295032\n"
"     0.73972147    1     0.47919458\n"
"#","\n"
"Xe GTH-PBE-q8 GTH-PBE\n"
"    2    6\n"
"     0.56000000    1     8.03636262\n"
"    3\n"
"     0.53049420    3     2.23202148     1.20035836    -0.99849824\n"
"                                       -3.17371348     2.57811136\n"
"                                                      -2.04631245\n"
"     0.58177483    2     0.79698181     0.59123264\n"
"                                       -0.69955590\n"
"     0.68554509    1     0.56018900\n"
"#","\n"
"Cs GTH-PBE-q9 GTH-PBE\n"
"    3    6\n"
"     0.54000000    2    33.31331676    -2.92121670\n"
"    4\n"
"     0.46189568    2    -3.32292700     2.45565338\n"
"                                       -3.17023488\n"
"     0.36635860    2    -4.95076405     0.84038977\n"
"                                       -0.99436259\n"
"     0.76150193    1     0.19840723\n"
"     0.59701503    1    -1.55056693\n"
"#","\n"
"Ba GTH-PBE-q10 GTH-PBE\n"
"    4    6\n"
"     0.54000000    2    24.52678070    -2.46867001\n"
"    4\n"
"     0.49206839    2     0.09515093     1.16931840\n"
"                                       -1.50958357\n"
"     0.39148930    2     0.80018261    -1.61683907\n"
"                                        1.91306979\n"
"     0.67217348    1     0.38853100\n"
"     0.30049773    1   -19.65379452\n"
"#","\n"
"La GTH-PBE-q11 GTH-PBE\n"
"    4    6    1\n"
"     0.53500000    2    20.68980469    -1.70327035\n"
"    4\n"
"     0.56144723    2    -0.02823977     1.07859821\n"
"                                       -1.39246430\n"
"     0.47517309    2     0.26802268     0.67328503\n"
"                                       -0.79664160\n"
"     0.62908399    1     0.38022718\n"
"     0.29911708    1   -18.44354886\n"
"#","\n"
"Ce GTH-PBE-q12 GTH-PBE\n"
"    4    6    1    1\n"
"     0.52480035    2    18.46313266    -0.35928475\n"
"    4\n"
"     0.52899318    2    -0.46945550     1.68519941\n"
"                                       -2.17558308\n"
"     0.47758674    2    -0.85915259     1.49893178\n"
"                                       -1.77356000\n"
"     0.65909303    1     0.10742047\n"
"     0.30186583    1   -17.66735258\n"
"#","\n"
"Ce GTH-PBE-q30\n"
"    6   12   11    1\n"
"     0.20000000    2   148.23700910     3.91725495\n"
"    4\n"
"     0.24060899    2     2.21770923     4.21351645\n"
"                                       -5.43962635\n"
"     0.16613857    3    -4.53697472    11.78843522     0.01475880\n"
"                                      -13.92369350    -0.03492570\n"
"                                                       0.02482188\n"
"     0.17161109    1   -15.00199037\n"
"     0.26526997    1    -4.75946878\n"
"#","\n"
"Pr GTH-PBE-q13 GTH-PBE\n"
"    4    6    0    3\n"
"     0.53188976    2    16.83551414    -0.43235649\n"
"    4\n"
"     0.52415103    2    -0.50975406     1.84037783\n"
"                                       -2.37591756\n"
"     0.48546735    2    -0.98189616     1.60445908\n"
"                                       -1.89842158\n"
"     0.71653344    1     0.05575046\n"
"     0.29937329    1   -17.49550069\n"
"#","\n"
"Nd GTH-PBE-q14 GTH-PBE\n"
"    4    6    0    4\n"
"     0.52991298    2    17.80646346    -0.32095543\n"
"    4\n"
"     0.50114025    2    -1.36443892     2.46474917\n"
"                                       -3.18197749\n"
"     0.50039105    2    -1.55942619     1.53939247\n"
"                                       -1.82143373\n"
"     0.33431765    1    -1.70064367\n"
"     0.29567529    1   -18.64327128\n"
"#","\n"
"Pm GTH-PBE-q15 GTH-PBE\n"
"    4    6    0    5\n"
"     0.52793919    2    17.84482075    -0.36133182\n"
"    4\n"
"     0.48944396    2    -1.72725500     2.81006693\n"
"                                       -3.62778081\n"
"     0.49132954    2    -1.87193192     1.65260118\n"
"                                       -1.95538409\n"
"     0.47893079    1    -0.44781450\n"
"     0.29022183    1   -19.51693564\n"
"#","\n"
"Sm GTH-PBE-q16 GTH-PBE\n"
"    4    6    0    6\n"
"     0.52466086    2    16.51148828    -0.24504217\n"
"    4\n"
"     0.48687809    2    -1.59045606     2.90667135\n"
"                                       -3.75249657\n"
"     0.49648709    2    -1.75047341     1.54491665\n"
"                                       -1.82797004\n"
"     0.49241328    1    -0.41980527\n"
"     0.28444353    1   -19.88144667\n"
"#","\n"
"Eu GTH-PBE-q17 GTH-PBE\n"
"    4    6    0    7\n"
"     0.52072219    2    17.93467530    -0.57606530\n"
"    4\n"
"     0.46955990    2    -2.07710390     3.25447577\n"
"                                       -4.20151015\n"
"     0.46644592    2    -2.34175427     2.29907112\n"
"                                       -2.72029763\n"
"     0.47357383    1    -0.59831876\n"
"     0.27831058    1   -21.30605878\n"
"#","\n"
"Gd GTH-PBE-q18 GTH-PBE\n"
"    4    6    1    7\n"
"     0.52126799    2    18.10313196    -0.51440770\n"
"    4\n"
"     0.45805877    2    -2.87481761     3.91661136\n"
"                                       -5.05632353\n"
"     0.46124964    2    -3.05406750     2.55197375\n"
"                                       -3.01953606\n"
"     0.48332992    1    -0.84348188\n"
"     0.27559144    1   -22.18390606\n"
"#","\n"
"Tb GTH-PBE-q19 GTH-PBE\n"
"    4    6    0    9\n"
"     0.51588228    2    17.15783725    -0.66955170\n"
"    4\n"
"     0.45376626    2    -2.42821095     3.74357813\n"
"                                       -4.83293859\n"
"     0.45360450    2    -2.68351507     2.30311187\n"
"                                       -2.72507871\n"
"     0.47258283    1    -0.72646091\n"
"     0.26876196    1   -22.75147607\n"
"#","\n"
"Dy GTH-PBE-q20 GTH-PBE\n"
"    4    6    0   10\n"
"     0.51029687    2    17.67093508    -0.86787770\n"
"    4\n"
"     0.44212348    2    -2.71573384     4.01788426\n"
"                                       -5.18706627\n"
"     0.45017230    2    -2.77347535     2.20115245\n"
"                                       -2.60443870\n"
"     0.47116514    1    -0.75227561\n"
"     0.26180741    1   -24.24856414\n"
"#","\n"
"Ho GTH-PBE-q21 GTH-PBE\n"
"    4    6    0   11\n"
"     0.51034519    2    17.00694728    -1.14166376\n"
"    4\n"
"     0.43408065    2    -2.64595349     4.10374692\n"
"                                       -5.29791449\n"
"     0.43159817    2    -3.06100899     2.73161511\n"
"                                       -3.23209058\n"
"     0.45020006    1    -0.82014316\n"
"     0.25514026    1   -25.40966658\n"
"#","\n"
"Er GTH-PBE-q22 GTH-PBE\n"
"    4    6    0   12\n"
"     0.50173422    2    17.22416099    -1.23324605\n"
"    4\n"
"     0.42576787    2    -2.61580658     4.19913757\n"
"                                       -5.42106329\n"
"     0.41793960    2    -3.15341814     3.17618553\n"
"                                       -3.75811340\n"
"     0.43046826    1    -0.89805056\n"
"     0.24914231    1   -26.58720599\n"
"#","\n"
"Tm GTH-PBE-q23 GTH-PBE\n"
"    4    6    0   13\n"
"     0.50234443    2    17.68675860    -1.59907075\n"
"    4\n"
"     0.41312714    2    -3.20033933     4.64501695\n"
"                                       -5.99669110\n"
"     0.41759033    2    -3.17289513     2.80513657\n"
"                                       -3.31908235\n"
"     0.39281519    1    -1.44965467\n"
"     0.24385920    1   -28.31696046\n"
"#","\n"
"Yb GTH-PBE-q24 GTH-PBE\n"
"    4    6    0   14\n"
"     0.49808783    2    17.08328394    -1.56295270\n"
"    4\n"
"     0.40553079    2    -3.55061134     5.03314458\n"
"                                       -6.49776171\n"
"     0.42489671    2    -3.13538311     2.14082491\n"
"                                       -2.53305819\n"
"     0.44507157    1    -0.91407703\n"
"     0.23857822    1   -29.66528314\n"
"#","\n"
"Lu GTH-PBE-q25 GTH-PBE\n"
"    4    6    1   14\n"
"     0.49611621    2    18.63208417    -1.51663710\n"
"    4\n"
"     0.39319895    2    -5.65573977     6.47885270\n"
"                                       -8.36416287\n"
"     0.41028936    2    -4.66078088     2.84645630\n"
"                                       -3.36797252\n"
"     0.43890201    1    -1.52277808\n"
"     0.23494399    1   -32.20596727\n"
"#","\n"
"Hf GTH-PBE-q12 GTH-PBE\n"
"    4    6    2\n"
"     0.56000000    2    15.52236567    -2.43356678\n"
"    3\n"
"     0.31182849    3   -10.91013059    27.37264587   -14.96156977\n"
"                                      -59.67292892    38.63060703\n"
"                                                     -30.66209376\n"
"     0.36196660    2    -9.65170049     9.22329739\n"
"                                      -10.91315264\n"
"     0.41579070    2    -2.74891464     0.48133335\n"
"                                       -0.54578072\n"
"#","\n"
"Ta GTH-PBE-q13 GTH-PBE\n"
"    4    6    3\n"
"     0.55000000    2    13.38520167    -2.25392008\n"
"    3\n"
"     0.40088312    3    -4.43670899     4.17648934     1.87560787\n"
"                                       -2.34114813    -4.84279868\n"
"                                                       3.84385229\n"
"     0.35654936    2    -7.62442808     8.17895534\n"
"                                       -9.67747047\n"
"     0.41822925    2    -1.11356085    -0.87533080\n"
"                                        0.99253183\n"
"#","\n"
"Ta GTH-PBE-q5\n"
"    2    0    3\n"
"     0.74400000    1     9.83934257\n"
"    3\n"
"     0.45239666    2     6.12338066    -2.16890335\n"
"                                        2.80004218\n"
"     0.75164390    2     1.64970103    -2.51481038\n"
"                                        2.97556377\n"
"     0.50114181    2   -12.42334477     9.01473381\n"
"                                      -10.22174735\n"
"#","\n"
"W GTH-PBE-q14 GTH-PBE\n"
"    4    6    4\n"
"     0.54000000    2    13.41481123    -2.21345603\n"
"    3\n"
"     0.39702790    3    -4.14121089     3.83542346     2.23317927\n"
"                                       -1.31924404    -5.76604408\n"
"                                                       4.57665561\n"
"     0.35353069    2    -7.45623626     8.11232637\n"
"                                       -9.59863401\n"
"     0.41210703    2    -0.95466075    -1.06744623\n"
"                                        1.21037026\n"
"#","\n"
"W GTH-PBE-q6\n"
"    2    0    4\n"
"     0.71900000    1    10.69989013\n"
"    3\n"
"     0.46755372    2     5.80350289    -2.07063257\n"
"                                        2.67317516\n"
"     0.72666463    2     1.78871915    -2.55415819\n"
"                                        3.02212073\n"
"     0.49929065    2   -10.59832562     6.44789319\n"
"                                       -7.31122365\n"
"#","\n"
"Re GTH-PBE-q15 GTH-PBE\n"
"    4    6    5\n"
"     0.53000000    2    13.46263143    -2.23492240\n"
"    3\n"
"     0.39380077    3    -3.71748055     3.15477903     2.85593500\n"
"                                        0.57237640    -7.37399245\n"
"                                                       5.85292506\n"
"     0.35253332    2    -7.05340425     7.56675835\n"
"                                       -8.95310922\n"
"     0.40186765    2    -0.90002359    -1.14917105\n"
"                                        1.30303749\n"
"#","\n"
"Re GTH-PBE-q7\n"
"    2    0    5\n"
"     0.69300000    1    11.96194160\n"
"    3\n"
"     0.46331539    2     6.08700876    -2.19137969\n"
"                                        2.82905901\n"
"     0.70964824    2     1.81506156    -2.35412193\n"
"                                        2.78543463\n"
"     0.47606454    2   -12.39371002     8.00629664\n"
"                                       -9.07828707\n"
"#","\n"
"Os GTH-PBE-q16 GTH-PBE\n"
"    4    6    6\n"
"     0.52000000    2    13.46303008    -2.24116983\n"
"    3\n"
"     0.39012207    3    -3.27416829     2.36003137     3.61101851\n"
"                                        2.82653464    -9.32360969\n"
"                                                       7.40038577\n"
"     0.34945025    2    -6.89928214     7.52931882\n"
"                                       -8.90881017\n"
"     0.39284207    2    -0.94268282    -1.08157042\n"
"                                        1.22638558\n"
"#","\n"
"Os GTH-PBE-q8\n"
"    2    0    6\n"
"     0.66700000    1    13.07904899\n"
"    3\n"
"     0.49576015    2     4.35033878    -1.49680274\n"
"                                        1.93236403\n"
"     0.70116140    2     1.81669550    -1.99815917\n"
"                                        2.36425382\n"
"     0.47117333    2   -10.99598697     5.97918090\n"
"                                       -6.77975387\n"
"#","\n"
"Ir GTH-PBE-q17 GTH-PBE\n"
"    4    6    7\n"
"     0.51000000    2    13.41080576    -2.34194822\n"
"    3\n"
"     0.38726411    3    -2.51628491     1.05519006     4.67505628\n"
"                                        6.24173509   -12.07094340\n"
"                                                       9.58101430\n"
"     0.34608307    2    -6.52615069     7.35318392\n"
"                                       -8.70040455\n"
"     0.37881290    2    -0.85595250    -1.17535111\n"
"                                        1.33272289\n"
"#","\n"
"Ir GTH-PBE-q9\n"
"    2    0    7\n"
"     0.64100000    1    14.58181397\n"
"    3\n"
"     0.51010474    2     3.71524999    -1.26263745\n"
"                                        1.63005794\n"
"     0.68489160    2     1.91910152    -1.89619458\n"
"                                        2.24360769\n"
"     0.47173508    2    -8.85603130     3.17025312\n"
"                                       -3.59472915\n"
"#","\n"
"Pt GTH-PBE-q10\n"
"    1    0    9\n"
"     0.61600000    1    11.31363525\n"
"    3\n"
"     0.55090426    2     4.73349110    -1.78459401\n"
"                                        2.30390096\n"
"     0.67413781    2     2.53479850    -1.77806555\n"
"                                        2.10383553\n"
"     0.45739243    2    -7.26401101     2.55866480\n"
"                                       -2.90125318\n"
"#","\n"
"Pt GTH-PBE-q18 GTH-PBE\n"
"    3    6    9\n"
"     0.50000000    2     8.81432324    -0.29250943\n"
"    3\n"
"     0.29800221    3    -5.96838498    24.21289966   -13.78967932\n"
"                                      -53.68763413    35.60479890\n"
"                                                     -28.26043301\n"
"     0.36017182    3    -6.66865904     7.17065922     0.76690370\n"
"                                       -7.20766072    -1.81482538\n"
"                                                       1.28980604\n"
"     0.34053206    2    -8.58990455     9.41012200\n"
"                                      -10.67007542\n"
"#","\n"
"Au GTH-PBE-q11 GTH-PBE\n"
"    1    0   10\n"
"     0.59000000    1    10.51717881\n"
"    3\n"
"     0.54384733    2     5.78681103    -2.25067966\n"
"                                        2.90561495\n"
"     0.60917298    2     4.28404873    -4.07128520\n"
"                                        4.81720962\n"
"     0.43730922    2    -7.40328124     3.01019307\n"
"                                       -3.41323811\n"
"#","\n"
"Au GTH-PBE-q19\n"
"    3    6   10\n"
"     0.49000000    1     8.36945885\n"
"    3\n"
"     0.29008402    3    -5.98869002    26.10502137   -15.17621948\n"
"                                      -58.38556050    39.18483021\n"
"                                                     -31.10199477\n"
"     0.36150576    3    -5.87695332     4.73144606     2.92710526\n"
"                                       -0.72513863    -6.92679530\n"
"                                                       4.92291022\n"
"     0.34037313    2    -8.80458432     9.49191532\n"
"                                      -10.76282032\n"
"#","\n"
"Hg GTH-PBE-q12 GTH-PBE\n"
"    2    0   10\n"
"     0.57000000    1     8.46784734\n"
"    3\n"
"     0.52978669    2     7.37124306    -2.96994403\n"
"                                        3.83418126\n"
"     0.63516596    2     3.55116141    -1.72290935\n"
"                                        2.03857383\n"
"     0.40798543    2    -8.61398015     5.00756120\n"
"                                       -5.67804069\n"
"#","\n"
"Tl GTH-PBE-q13 GTH-PBE\n"
"    2    1   10\n"
"     0.55000000    1    12.29058515\n"
"    3\n"
"     0.51280306    2     7.19017017    -2.86301073\n"
"                                        3.69613096\n"
"     0.57711505    2     4.76094580    -3.67332496\n"
"                                        4.34633671\n"
"     0.39323001    2   -11.01268700     6.42159202\n"
"                                       -7.28140093\n"
"#","\n"
"Tl GTH-PBE-q3\n"
"    2    1\n"
"     0.63000000    1     1.45272083\n"
"    3\n"
"     0.78076788    3     0.37973043     1.20912802    -0.45856792\n"
"                                       -2.30683834     1.18401727\n"
"                                                      -0.93978457\n"
"     0.89705009    2    -0.02423596     0.58235582\n"
"                                       -0.68905269\n"
"     1.09379194    1     0.22764152\n"
"#","\n"
"Pb GTH-PBE-q14\n"
"    2    2   10\n"
"     0.53000000    1    12.57214281\n"
"    3\n"
"     0.49554891    2     8.42980665    -3.44005610\n"
"                                        4.44109332\n"
"     0.56934785    2     4.98150638    -2.89639920\n"
"                                        3.42706575\n"
"     0.40422413    2    -6.81491262     1.83782673\n"
"                                       -2.08389964\n"
"#","\n"
"Pb GTH-PBE-q4 GTH-PBE\n"
"    2    2\n"
"     0.61750000    1     4.67238428\n"
"    3\n"
"     0.62235881    3     0.87991768     2.08114784    -1.43125710\n"
"                                       -5.01469016     3.69548994\n"
"                                                      -2.93320421\n"
"     0.81200202    2     0.15345679     0.47889785\n"
"                                       -0.56663958\n"
"     1.02501525    1     0.30170206\n"
"#","\n"
"Bi GTH-PBE-q15\n"
"    2    3   10\n"
"     0.51000000    1    13.39622231\n"
"    3\n"
"     0.48120446    2     9.54548100    -3.94511418\n"
"                                        5.09312050\n"
"     0.54894636    2     5.63359371    -3.17713769\n"
"                                        3.75924002\n"
"     0.39730251    2    -6.03753705     0.92523553\n"
"                                       -1.04911848\n"
"#","\n"
"Bi GTH-PBE-q5 GTH-PBE\n"
"    2    3\n"
"     0.60500000    1     7.94575692\n"
"    3\n"
"     0.58223216    3     0.64373527     2.24761617    -1.44060063\n"
"                                       -5.24479711     3.71961484\n"
"                                                      -2.95235275\n"
"     0.76639400    2     0.21253292     0.37983417\n"
"                                       -0.44942585\n"
"     0.96565479    1     0.34729822\n"
"#","\n"
"Po GTH-PBE-q6 GTH-PBE\n"
"    2    4\n"
"     0.59250000    1     8.13432566\n"
"    3\n"
"     0.80422357    3     0.32633408     0.10539986     0.52809414\n"
"                                        0.72287456    -1.36353322\n"
"                                                       1.08227094\n"
"     0.81703652    2     0.15801481     0.37530247\n"
"                                       -0.44406387\n"
"     0.89014943    1     0.46253238\n"
"#","\n"
"At GTH-PBE-q7 GTH-PBE\n"
"    2    5\n"
"     0.58000000    1    14.21716853\n"
"    3\n"
"     0.66580683    3    -0.37891203     0.66112626     0.27884944\n"
"                                       -0.39996168    -0.71998616\n"
"                                                       0.57147130\n"
"     0.65241195    2     0.26704745     0.32622823\n"
"                                       -0.38599845\n"
"     0.85406059    1     0.45259467\n"
"#","\n"
"Rn GTH-PBE-q8 GTH-PBE\n"
"    2    6\n"
"     0.57000000    1    16.20061781\n"
"    3\n"
"     0.63480802    3    -0.58199405     0.80312797     0.29738605\n"
"                                       -0.55313531    -0.76784748\n"
"                                                       0.60946004\n"
"     0.64710877    2     0.16927880     0.30517348\n"
"                                       -0.36108613\n"
"     0.80634271    1     0.51103874\n"
"#","\n"
"U GTH-PBE-q14\n"
"    4    6    1    3\n"
"     0.48000000    2    48.86182633    -4.59713581\n"
"    4\n"
"     0.51405537    3    -0.65017014    -1.15225083     1.84763553\n"
"                                        4.49272884    -4.77057442\n"
"                                                       3.78652606\n"
"     0.40934387    3     3.58555843    -6.88134873     4.03097788\n"
"                                       14.85308504    -9.53903470\n"
"                                                       6.77944264\n"
"     0.67885536    2     0.53789816     0.48180765\n"
"                                       -0.54631852\n"
"     0.32134043    1   -16.65115610\n"
"#","\n"
"B GTH-PBESol-q3 GTH-PBESol\n"
"    2    1\n"
"     0.42188166    2    -5.99194495     0.94658199\n"
"    2\n"
"     0.37186069    1     6.29208376\n"
"     0.36287582    0\n"
"#","\n"
"H GTH-OLYP-q1 GTH-OLYP\n"
"    1\n"
"     0.20000000    2    -4.16025705     0.71696182\n"
"    0\n"
"#","\n"
"B GTH-OLYP-q3\n"
"    2    1\n"
"     0.40824397    2    -5.84551716     0.92100194\n"
"    2\n"
"     0.37035120    1     6.31003106\n"
"     0.35773831    0\n"
"#","\n"
"C GTH-OLYP-q4\n"
"    2    2\n"
"     0.33266812    2    -8.65195820     1.32052627\n"
"    2\n"
"     0.30204607    1     9.62061855\n"
"     0.29182215    0\n"
"#","\n"
"N GTH-OLYP-q5\n"
"    2    3\n"
"     0.28091145    2   -12.16718730     1.82099926\n"
"    2\n"
"     0.25510834    1    13.61560292\n"
"     0.24679335    0\n"
"#","\n"
"O GTH-OLYP-q6 GTH-OLYP\n"
"    2    4\n"
"     0.24340006    2   -16.34721549     2.41772603\n"
"    2\n"
"     0.22079018    1    18.31443918\n"
"     0.22008988    0\n"
"#","\n"
"F GTH-OLYP-q7\n"
"    2    5\n"
"     0.21382039    2   -21.28598900     3.12167577\n"
"    2\n"
"     0.19453412    1    23.73308173\n"
"     0.16302766    0\n"
"#","\n"
"P GTH-OLYP-q5\n"
"    2    3\n"
"     0.43000000    1    -4.69763642\n"
"    2\n"
"     0.39666347    2    10.63544240    -3.29388139\n"
"                                        4.25238258\n"
"     0.44942590    1     2.88712442\n"
"#","\n"
"S GTH-OLYP-q6\n"
"    2    4\n"
"     0.42000000    1    -5.70095751\n"
"    2\n"
"     0.36360282    2    13.23499116    -4.28266416\n"
"                                        5.52889566\n"
"     0.40854250    1     3.70359686\n"
"#","\n"
"Cl GTH-OLYP-q7\n"
"    2    5\n"
"     0.41000000    1    -6.18936120\n"
"    2\n"
"     0.33820768    2    15.35745265    -4.99108675\n"
"                                        6.44346529\n"
"     0.37732312    1     4.35487695\n"
"#","\n"
"H GTH-HF-q1 GTH-HF\n"
"    1    0    0    0\n"
"    0.196680577426       2   -4.122010670148    0.685113494453\n"
"       0\n"
"#","\n"
"C GTH-HF-q4 GTH-HF\n"
"    2    2    0    0\n"
"    0.315416975333       2   -8.867306339232    1.255277018021\n"
"       1\n"
"    0.301022709314       1    9.800185699152\n"
"#","\n"
"N GTH-HF-q5 GTH-HF\n"
"    2    3    0    0\n"
"    0.293004428534       2  -12.353673551345    1.940376934223\n"
"       1\n"
"    0.255011990622       1   13.748056543074\n"
"#","\n"
"O GTH-HF-q6 GTH-HF\n"
"    2    4    0    0\n"
"    0.246496621432       2  -17.087623980861    2.645053514530\n"
"       1\n"
"    0.220770923508       1   18.522680682057\n"
"#","\n"
"Al GTH-NLCC-PBE-q3 GTH-NLCC-PBE\n"
"   2 1  \n"
"        0.35000000  2     -1.20404111     -2.14848844 \n"
"   NLCC    1\n"
"        0.487749457320947 1 26.6661157296629\n"
"   2                                                 \n"
"        0.46845918  2      2.69261923      0.00000000\n"
"                                           2.15425102\n"
"        0.54697362  1      2.13803860     \n"
"#","\n"
"B GTH-NLCC-PBE-q3 GTH-NLCC-PBE\n"
"    2   1\n"
"        0.43249960  2     -4.26853158      0.59951279\n"
"    NLCC  1 \n"
"        0.333523099251602 1 18.6519880515354\n"
"   1                                      \n"
"        0.37147150  1      6.30164101      \n"
"#","\n"
"C GTH-NLCC-PBE-q4 GTH-NLCC-PBE\n"
"    2  2\n"
"        0.31478662  2     -6.92377020      0.96359690\n"
"    NLCC  1 \n"
"        0.274399357915869 1 58.7058349842360\n"
"   2                                       \n"
"        0.30228391  1      9.57595383     \n"
"        0.36878252  1     -0.00996437    \n"
"#","\n"
"Cl GTH-NLCC-PBE-q7 GTH-NLCC-PBE\n"
"    2  5\n"
"        0.32000000  1     -0.27448290\n"
"    NLCC  1\n"
"        0.42147846  1     31.2490172184\n"
"    2\n"
"        0.32659110  2      4.20335702      0.00000000\n"
"                                           4.55651710\n"
"        0.36756872  1      4.22907835\n"
"#","\n"
"F GTH-NLCC-PBE-q7 GTH-NLCC-PBE\n"
"    2 5\n"
"        0.20610323  2    -19.86716500      2.79308907\n"
"    NLCC  1 \n"
"        0.171542709683482 1 193.635582221771\n"
"    1 \n"
"        0.19518097  1     23.47047311     \n"
"#","\n"
"H GTH-NLCC-PBE-q1 GTH-NLCC-PBE\n"
"    1    \n"
"        0.20000000  2     -4.07311634      0.68070153 \n"
"   0                                                 \n"
"#","\n"
"N GTH-NLCC-PBE-q5 GTH-NLCC-PBE\n"
"   2 3\n"
"        0.24179589  2    -10.04328500    1.39719020 \n"
"   NLCC  1 \n"
"        0.246115465086927 1 70.6868378070653\n"
"   2                                      \n"
"        0.25696561  1     12.96801666     \n"
"        0.15685548  1     -0.73452991    \n"
"#","\n"
"O GTH-NLCC-PBE-q6 GTH-NLCC-PBE\n"
"   2 4\n"
"        0.26099935  2    -14.15180600      1.97829510 \n"
"   NLCC  1 \n"
"        0.252338420313492 1 44.0109866619909\n"
"   2                                       \n"
"        0.22308282  1     18.37181432     \n"
"        0.26844098  1      0.10003633    \n"
"#","\n"
"P GTH-NLCC-PBE-q5 GTH-NLCC-PBE\n"
"   2  3\n"
"        0.34000000  2     -1.62258310     -0.72412131 \n"
"   NLCC  1 \n"
"        0.398676358021430 1 57.5022588665043\n"
"   2                                                 \n"
"        0.38208906  2      3.47753509     -0.01266608\n"
"                                           3.47461367\n"
"        0.43410975  1      3.37859278      \n"
"#","\n"
"S GTH-NLCC-PBE-q6 GTH-NLCC-PBE\n"
"   2  4\n"
"        0.33000000  2      1.49042820     -0.73313881 \n"
"   NLCC  1 \n"
"        0.386218088400348 1 79.6359982164901\n"
"   2                                                 \n"
"        0.37045712  2      6.18604810      0.00000000\n"
"                                           2.57760787\n"
"        0.39772434  1      3.89113272   \n"
"#","\n"
"Si GTH-NLCC-PBE-q4 GTH-NLCC-PBE\n"
"   2  2\n"
"        0.33000000  2     -0.07845999     -0.79378214 \n"
"   NLCC  1\n"
"        0.442792079831528 1 38.1776559763904\n"
"   2                                                 \n"
"        0.42179461  2      2.87392223      0.02558827\n"
"                                           2.59458148\n"
"        0.48800255  1      2.47962806\n"
"#","\n"
"H ALLELECTRON ALL\n"
"    1    0    0\n"
"     0.20000000    0\n"
"#","\n"
"He ALLELECTRON ALL\n"
"    2    0    0 \n"
"     0.20000000    0\n"
"#","\n"
"Li ALLELECTRON ALL\n"
"    3    0    0 \n"
"     0.40000000    0\n"
"#","\n"
"Be ALLELECTRON ALL\n"
"    4    0    0 \n"
"     0.32500000    0\n"
"#","\n"
"B ALLELECTRON ALL\n"
"    4    1    0\n"
"     0.43392956    0\n"
"#","\n"
"C ALLELECTRON ALL\n"
"    4    2    0\n"
"     0.34883045    0\n"
"#","\n"
"N ALLELECTRON ALL\n"
"    4    3    0\n"
"     0.28917923    0\n"
"#","\n"
"O ALLELECTRON ALL\n"
"    4    4    0\n"
"     0.24762086    0\n"
"#","\n"
"F ALLELECTRON ALL\n"
"    4    5    0\n"
"     0.21852465    0\n"
"#","\n"
"Ne ALLELECTRON ALL\n"
"    4    6    0\n"
"     0.19000000    0\n"
"#","\n"
"Na ALLELECTRON ALL\n"
"    5    6    0\n"
"     0.24631780    0\n"
"#","\n"
"Mg ALLELECTRON ALL\n"
"    6    6    0\n"
"     0.21094954    0\n"
"#","\n"
"Al ALLELECTRON ALL\n"
"    6    7    0\n"
"     0.45000000    0\n"
"#","\n"
"Si ALLELECTRON ALL\n"
"    6    8    0\n"
"     0.44000000    0\n"
"#","\n"
"P ALLELECTRON ALL\n"
"    6    9    0\n"
"     0.43000000    0\n"
"#","\n"
"S ALLELECTRON ALL\n"
"    6   10    0\n"
"     0.42000000    0\n"
"#","\n"
"Cl ALLELECTRON ALL\n"
"    6   11    0\n"
"     0.41000000    0\n"
"#","\n"
"Ar ALLELECTRON ALL\n"
"    6   12    0\n"
"     0.40000000    0\n"
"#","\n"
"K ALLELECTRON ALL\n"
"    7   12    0\n"
"     0.40000000    0\n"
"#","\n"
"Ca ALLELECTRON ALL\n"
"    8   12    0\n"
"     0.39000000    0\n"
"#","\n"
"Sc ALLELECTRON ALL\n"
"    8   12    1\n"
"     0.38500000    0\n"
"#","\n"
"Ti ALLELECTRON ALL\n"
"    8   12    2\n"
"     0.3800000    0\n"
"#","\n"
"V  ALLELECTRON ALL\n"
"    8   12    3\n"
"     0.37500000    0\n"
"#","\n"
"Cr ALLELECTRON ALL\n"
"    8   12    4\n"
"     0.37000000    0\n"
"#","\n"
"Mn ALLELECTRON ALL\n"
"    8   12    5\n"
"     0.36500000    0\n"
"#","\n"
"Fe  ALLELECTRON ALL\n"
"    8   12    6\n"
"     0.36000000    0\n"
"#","\n"
"Co  ALLELECTRON ALL\n"
"    8   12    7\n"
"     0.35500000    0\n"
"#","\n"
"Ni  ALLELECTRON ALL\n"
"    8   12    8\n"
"     0.35000000    0\n"
"#","\n"
"Cu ALLELECTRON ALL\n"
"    8   12    9\n"
"     0.53000000    0\n"
"#","\n"
"Zn ALLELECTRON ALL\n"
"    8   12   10\n"
"     0.34000000    0\n"
"#","\n"
"Ga ALLELECTRON ALL\n"
"    8   13   10\n"
"     0.49000000    0\n"
"#","\n"
"Ge ALLELECTRON ALL\n"
"    8   14   10\n"
"     0.54000000    0\n"
"#","\n"
"As ALLELECTRON ALL\n"
"    8   15   10\n"
"     0.52000000    0\n"
"#","\n"
"Se ALLELECTRON ALL\n"
"    8   16   10\n"
"     0.51000000    0\n"
"#","\n"
"Br ALLELECTRON ALL\n"
"    8   17   10\n"
"     0.50000000    0\n"
"#","\n"
"Kr ALLELECTRON ALL\n"
"    8   18   10\n"
"     0.50000000    0\n"
"#","\n"
"I  ALLELECTRON ALL\n"
"   10   23   20\n"
"     0.50000000    0\n"
};
