# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "vmss update-domain-walk",
)
class UpdateDomainWalk(AAZCommand):
    """Manual platform update domain walk to update virtual machines in a service fabric virtual machine scale set.

    :example: Force recovery service fabric platform update domain walk
        az vmss update-domain-walk -g rg --vmss-name vmss --platform-update-domain
    """

    _aaz_info = {
        "version": "2023-07-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.compute/virtualmachinescalesets/{}/forcerecoveryservicefabricplatformupdatedomainwalk", "2023-07-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.vmss_name = AAZStrArg(
            options=["--vmss-name"],
            help="The name of the VM scale set.",
            required=True,
            id_part="name",
        )
        _args_schema.placement_group_id = AAZStrArg(
            options=["--placement-group-id"],
            help="The placement group id for which the manual recovery walk is requested.",
        )
        _args_schema.platform_update_domain = AAZIntArg(
            options=["--platform-update-domain"],
            help="The platform update domain for which a manual recovery walk is requested",
            required=True,
        )
        _args_schema.zone = AAZStrArg(
            options=["--zone"],
            help="The zone in which the manual recovery walk is requested for cross zone virtual machine scale set",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.VirtualMachineScaleSetsForceRecoveryServiceFabricPlatformUpdateDomainWalk(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class VirtualMachineScaleSetsForceRecoveryServiceFabricPlatformUpdateDomainWalk(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/forceRecoveryServiceFabricPlatformUpdateDomainWalk",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "vmScaleSetName", self.ctx.args.vmss_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "placementGroupId", self.ctx.args.placement_group_id,
                ),
                **self.serialize_query_param(
                    "platformUpdateDomain", self.ctx.args.platform_update_domain,
                    required=True,
                ),
                **self.serialize_query_param(
                    "zone", self.ctx.args.zone,
                ),
                **self.serialize_query_param(
                    "api-version", "2023-07-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_platform_update_domain = AAZIntType(
                serialized_name="nextPlatformUpdateDomain",
                flags={"read_only": True},
            )
            _schema_on_200.walk_performed = AAZBoolType(
                serialized_name="walkPerformed",
                flags={"read_only": True},
            )

            return cls._schema_on_200


class _UpdateDomainWalkHelper:
    """Helper class for UpdateDomainWalk"""


__all__ = ["UpdateDomainWalk"]
