# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class ListReferences(AAZCommand):
    """Returns the DNS records specified by the referencing targetResourceIds.

    :example: List DNS records referencing the target resource IDs.
        az network dns list-references --parameters /subscriptions/**921/resourceGroups/MyRg/providers/Microsoft.Network/trafficManagerProfiles/MyTm
    """

    _aaz_info = {
        "version": "2023-07-01-preview",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.network/getdnsresourcereference", "2023-07-01-preview"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.target_resources = AAZListArg(
            options=["--target-resources"],
            arg_group="Properties",
            help="A list of references to azure resources for which referencing dns records need to be queried.",
        )

        target_resources = cls._args_schema.target_resources
        target_resources.Element = AAZObjectArg()

        _element = cls._args_schema.target_resources.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource Id.",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.DnsResourceReferenceGetByTargetResources(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class DnsResourceReferenceGetByTargetResources(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/Microsoft.Network/getDnsResourceReference",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-07-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("targetResources", AAZListType, ".target_resources")

            target_resources = _builder.get(".properties.targetResources")
            if target_resources is not None:
                target_resources.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.targetResources[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200.properties
            properties.dns_resource_references = AAZListType(
                serialized_name="dnsResourceReferences",
            )

            dns_resource_references = cls._schema_on_200.properties.dns_resource_references
            dns_resource_references.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.dns_resource_references.Element
            _element.dns_resources = AAZListType(
                serialized_name="dnsResources",
            )
            _element.target_resource = AAZObjectType(
                serialized_name="targetResource",
            )
            _ListReferencesHelper._build_schema_sub_resource_read(_element.target_resource)

            dns_resources = cls._schema_on_200.properties.dns_resource_references.Element.dns_resources
            dns_resources.Element = AAZObjectType()
            _ListReferencesHelper._build_schema_sub_resource_read(dns_resources.Element)

            return cls._schema_on_200


class _ListReferencesHelper:
    """Helper class for ListReferences"""

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id


__all__ = ["ListReferences"]
