//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _r2root_5.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <src/integral/rys/r2rootlist.h>

using namespace std;
using namespace bagel;

void R2RootList::r2root5(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[5] = {2.635613251680105e-01,1.413408451087209e+00,3.596439491132585e+00,7.085837038047054e+00,1.264084906963732e+01
    };
  constexpr double aw[5] = {2.608788004978083e-01,1.993341659360938e-01,3.797136967832551e-02,1.805886227483284e-03,1.168503075026571e-05
    };
  constexpr double x[2635] = {  4.892306114796960e-02,  2.379950964962451e-03,  8.448885794937013e-05,  2.567362812196001e-06,  6.933351127331913e-08,
  1.664178123710639e-09,  3.425686939377008e-11,  5.346406843597989e-13,  2.509774513752789e-15, -2.413528561238968e-16, -1.278776086656787e-17, -3.984123116620220e-19,
  4.067161416639053e-01,  1.586326163243614e-02,  3.390780937592442e-04,  2.195150671624916e-06, -1.293440315897628e-07, -4.896295431193408e-09, -3.973472285478247e-11,
  2.802005430976117e-12,  1.153059950971823e-13,  9.502848059040343e-16, -7.448261260287429e-17, -2.935246101171009e-18,  9.707411160442166e-01,  2.379301518149794e-02,
  1.085742131980060e-05, -8.972820382200425e-06, -5.488220336145494e-09,  6.105118045802725e-09,  2.254908464112098e-12, -5.042507175743186e-12, -5.178315812377485e-17,
  4.664398457851787e-15,  1.710854693992496e-18, -4.334550032559053e-18,  1.530639583976642e+00,  1.666948951547011e-02, -3.146789755431734e-04,  1.129964252785477e-06,
  1.309385739991398e-07, -3.907000681538879e-09,  1.130493708189840e-11,  2.575613631362745e-12, -7.860064907250594e-14,  1.040762526296059e-16,  6.514416111120561e-17,
 -1.821042954180893e-18,  1.905470869069829e+00,  4.110240250637851e-03, -1.278974098876272e-04,  3.297852258226788e-06, -7.149960836471928e-08,  1.222641726993540e-09,
 -1.172934553107130e-11, -2.012661236494194e-13,  1.530055880109339e-14, -5.183233792364846e-16,  1.291879356443127e-17, -1.980128503072499e-19,  6.002016201528043e-02,
  3.200799181143367e-03,  1.232102786810191e-04,  3.992746334617938e-06,  1.120481025488290e-07,  2.662502000617097e-09,  4.810251866352458e-11,  3.346505245475620e-13,
 -2.089774526545542e-14, -1.249519011954736e-15, -4.181248436377876e-17, -9.692312278270137e-19,  4.757015633080957e-01,  1.863845658696795e-02,  3.496948060832612e-04,
 -6.752453375580270e-07, -2.282573269817476e-07, -4.486671402183549e-09,  8.997877768658636e-11,  6.218395567019381e-12,  6.644638862324913e-14, -4.314474451963278e-15,
 -1.663860155803488e-16,  2.109933861261410e-19,  1.065414829653649e+00,  2.345675364042982e-02, -9.343135275118541e-05, -8.126960103782171e-06,  1.063492895055298e-07,
  4.611523591084550e-09, -1.156726851086845e-10, -2.692038154027462e-12,  1.276639128488152e-13,  1.526278405717149e-15, -1.306791305543421e-16, -6.729804917011176e-19,
  1.592411251565776e+00,  1.423616999764867e-02, -2.910250878446681e-04,  2.634199390983106e-06,  5.995200503346038e-08, -3.036928560739210e-09,  5.145553409996576e-11,
  4.687288299395486e-13, -4.669544165502155e-14,  1.205556364580689e-15, -3.553817352869541e-18, -9.948287774082240e-19,  1.920090969863096e+00,  3.227662891598863e-03,
 -9.443300320779607e-05,  2.333076284416022e-06, -5.009390808296802e-08,  9.147355918063042e-10, -1.270407423224161e-11,  7.235979271040872e-14,  3.843437628133141e-15,
 -1.725306952078083e-16,  4.819484843044418e-18, -1.417209139944998e-19,  7.514705749654790e-02,  4.413072894673694e-03,  1.838442972519394e-04,  6.275404979666631e-06,
  1.769855336034730e-07,  3.798464110060640e-09,  3.851007800055926e-11, -1.470614191590792e-12, -1.078003870820481e-13, -3.928107444094362e-15, -9.335548232007696e-17,
 -1.049784112426834e-18,  5.557038763172533e-01,  2.133576357442636e-02,  3.172653037575073e-04, -4.866642475729739e-06, -2.818173953711165e-07, -1.836885950282897e-10,
  2.622190947305581e-10,  4.749353162831990e-12, -1.824044349313040e-13, -8.114157541673419e-15,  4.328854359039603e-17,  8.932462508887996e-18,  1.157178025148625e+00,
  2.235407294437208e-02, -1.782396659749827e-04, -5.855391183637312e-06,  1.671832113314092e-07,  1.407525355385607e-09, -1.326569991893925e-10,  1.299324831384731e-12,
  9.533111641349553e-14, -2.819978763704254e-15, -5.847284426023496e-17,  3.094407374000369e-18,  1.644917228340841e+00,  1.204654914337317e-02, -2.554403726625206e-04,
  3.176535551117074e-06,  1.191428378131382e-08, -1.775901192819658e-09,  4.961297221019626e-11, -4.200277584686203e-13, -1.277461666636533e-14,  5.779762014909135e-16,
 -1.938770108313421e-17,  1.478388532082186e-19,  1.931650473786629e+00,  2.571847967970020e-03, -7.069269346399415e-05,  1.662241668882067e-06, -3.463260420969758e-08,
  6.433768144422373e-10, -9.684848420089661e-12,  1.230979814896663e-13, -7.908602297522291e-17, -6.935747138542796e-17,  1.170162401989217e-18, -2.947979069028092e-20,
  9.629364779577336e-02,  6.239182080355561e-03,  2.787500981000544e-04,  9.742192682722487e-06,  2.561941099256473e-07,  3.680936892763661e-09, -7.764778473164400e-11,
 -7.942279630141968e-12, -3.187938582287215e-13, -7.454785373886775e-15, -3.110572564301941e-17,  6.430599765045723e-18,  6.456477262917301e-01,  2.356574020369008e-02,
  2.328854654602193e-04, -9.033013320653143e-06, -2.162342808202283e-07,  6.807477781017734e-09,  2.765401890635028e-10, -4.640166894927169e-12, -3.479341047750079e-13,
  1.196907353681566e-15,  3.696909940644559e-16,  1.780761429955980e-18,  1.243363175437990e+00,  2.069366832565552e-02, -2.320402628768197e-04, -3.110976398635721e-06,
  1.677888899677121e-07, -1.098311622978519e-09, -7.051509815274112e-11,  2.536512837848169e-12, -1.650985243569761e-14, -2.617731807704409e-15,  5.611324781793225e-17,
  1.483807128213899e-18,  1.689259313905951e+00,  1.015643898207687e-02, -2.171531924929359e-04,  3.143082896609154e-06, -1.282433717104054e-08, -7.581429243643854e-10,
  3.431027648281230e-11, -6.237595520410701e-13, -3.057609850065736e-15,  6.187979770888792e-17, -4.895754171827441e-18,  3.646010764226184e-19,  1.940921006939598e+00,
  2.077575538036427e-03, -5.368367262839521e-05,  1.199571290726124e-06, -2.382046717334399e-08,  4.499930143634206e-10, -6.592763859172183e-12,  8.838688277422609e-14,
 -1.859970083957740e-15, -2.935406500812681e-17,  1.138197292477664e-18,  1.290099847090765e-20,  1.265551401798905e-01,  9.010959604536312e-03,  4.220891433361396e-04,
  1.422953905956775e-05,  2.861871397171408e-07, -2.239901128918591e-09, -4.798178914849939e-10, -2.172919494489553e-11, -4.787173592894866e-13,  4.263593341383767e-15,
  8.487012066198782e-16,  3.762968460925897e-17,  7.428835337957100e-01,  2.494880735699758e-02,  1.092197833047638e-04, -1.110826638077125e-05, -3.020661409949216e-08,
  1.076660692383732e-08,  1.679158883304939e-11, -1.241427436836424e-11, -7.055897084981470e-14,  1.209651561578426e-14,  6.286549624900194e-17, -1.270821833606585e-17,
  1.322250384765174e+00,  1.873150326340817e-02, -2.542256843552666e-04, -6.719066031740034e-07,  1.340375934576456e-07, -2.067490000280912e-09, -1.748213515185112e-11,
  1.009985877849011e-12, -6.231924014331192e-14,  1.055519898378387e-16,  6.259184429453224e-17, -8.432450929490765e-19,  1.726643378520763e+00,  8.565701278322867e-03,
 -1.810394443853647e-04,  2.855212877316612e-06, -2.121846241744110e-08, -1.539292523452000e-10,  1.570134700749934e-11, -6.967596637091532e-13, -1.175610852260364e-15,
  1.087520224238458e-16,  5.095703373239545e-18,  8.885911627988197e-20,  1.948455226586040e+00,  1.699838200008020e-03, -4.130444728766542e-05,  8.825569528046482e-07,
 -1.624008763493945e-08,  3.141010044948817e-10, -5.041900755314009e-12,  2.165561938629932e-14, -1.994022823853405e-15,  2.342745769713213e-17,  1.365345222936957e-18,
 -3.188198253739902e-21,  1.705327513234360e-01,  1.313992567517124e-02,  6.161822347641481e-04,  1.759128166862913e-05,  6.974763282383645e-08, -2.232147661083111e-08,
 -1.211664052714235e-09, -2.433533398728003e-11,  7.456557623037254e-13,  7.599550091970269e-14,  2.543534607612814e-15,  2.803844516032877e-18,  8.435914909142584e-01,
  2.529707260492587e-02, -2.012513239711568e-05, -9.964675886340043e-06,  1.613686729156136e-07,  7.137387923563706e-09, -2.993870030825725e-10, -8.209959584420917e-12,
  2.939880684320352e-13,  5.930367623260801e-15, -2.562042134947660e-16,  2.154778647048385e-18,  1.393104901928900e+00,  1.669864570778328e-02, -2.508424190045925e-04,
  1.124859887592636e-06,  8.968969553710835e-08, -2.354199944385892e-09, -1.355734004659157e-11, -5.178739221722217e-13, -2.286691086909894e-14,  1.864411605859846e-15,
  3.107922804024145e-17, -1.341657594378466e-19,  1.758218219621788e+00,  7.248530533572527e-03, -1.488673099121398e-04,  2.504915122068303e-06, -2.210996132813831e-08,
 -1.027786822953420e-11, -3.428980655414491e-12, -6.260875046287711e-13,  7.198277469997715e-15,  3.823494173804660e-16,  9.345249351830176e-18,  1.763142386431629e-19,
  1.954655122689992e+00,  1.407783312727033e-03, -3.208652240340748e-05,  6.664871481068334e-07, -1.115161021395293e-08,  1.943127712113202e-10, -5.127838741217631e-12,
 -1.822402072573203e-14, -1.690542246376944e-16,  7.985627959117270e-17,  1.690765174173130e-18,  2.604101594314374e-20,  2.342564134342415e-01,  1.888772182536805e-02,
  8.136905830100300e-04,  1.341139757007162e-05, -6.956812215455980e-07, -5.373198750803834e-08, -1.029926502386774e-09,  5.817978903285364e-11,  4.541143805683021e-12,
  8.567126899903461e-14, -5.106226938042286e-15, -3.926584974865641e-16,  9.437731650135284e-01,  2.470966830231922e-02, -1.209270480749245e-04, -6.688320375342733e-06,
  2.197490931180993e-07, -1.606408634881556e-09, -3.769831970863846e-10,  3.114552446563752e-12,  3.873171746625816e-13,  1.544340562756518e-15,  5.252159098416447e-17,
  3.290232683708164e-18,  1.456001040237040e+00,  1.476657448643053e-02, -2.303600761122205e-04,  2.160005222825347e-06,  3.804464514619121e-08, -2.865600570588136e-09,
 -2.647976827534749e-11,  6.857065365976910e-14,  6.711070740293349e-14,  3.100591907474258e-15,  1.905965806779687e-17, -1.997836049637185e-18,  1.785012257873286e+00,
  6.171742360906752e-03, -1.209668982138300e-04,  2.139739102882027e-06, -2.435931491382025e-08, -2.612320485251134e-10, -1.506419966098392e-11, -8.910945575591438e-14,
  2.925455807573441e-14,  8.463487358809405e-16,  7.725664538194825e-18, -7.365102263466539e-19,  1.959819576118133e+00,  1.180300418545270e-03, -2.505306093705366e-05,
  5.123192887202584e-07, -8.527373329345947e-09,  6.768875980774913e-11, -5.175980889818480e-12,  3.746053763700314e-14,  4.139569434132858e-15,  1.583095873207407e-16,
  1.141976560338663e-18, -1.348611733874735e-19,  3.234646620906394e-01,  2.576538486159651e-02,  8.702915111602898e-04, -6.794652966594969e-06, -1.796554931253695e-06,
 -4.191529055398200e-08,  2.613286960525739e-09,  1.790689950447489e-10, -9.220798527086339e-14, -4.132748824288509e-13, -1.353885904580394e-14,  4.948556670489451e-16,
  1.040246138715088e+00,  2.347560097108537e-02, -1.826002279341524e-04, -3.865322703647007e-06,  1.117048513895166e-07, -8.146459318352730e-09, -1.067252733114899e-10,
  1.638636849622597e-11,  4.056336063878896e-13, -5.990492393499992e-15, -7.696400545758956e-16, -3.898460639252477e-17,  1.511554351675544e+00,  1.303316779923395e-02,
 -2.027756944405521e-04,  2.282030762557284e-06, -2.377882331857139e-08, -3.134424033930795e-09,  2.148493630634250e-11,  3.800172839202478e-12,  1.437521752704411e-13,
 -9.791767012240049e-16, -2.995743823626327e-16, -1.125892882547864e-17,  1.807916344405911e+00,  5.299569005674182e-03, -9.786151053153029e-05,  1.689966340884360e-06,
 -3.273557253531447e-08, -5.192498703869743e-10, -9.349099957449341e-14,  1.273371296352898e-12,  4.863336565253320e-14, -4.701977531341791e-16, -9.607609382624515e-17,
 -3.434804749862618e-18,  1.964175674716324e+00,  1.002209946342209e-03, -1.969927630319086e-05,  3.806550730614745e-07, -8.231451610130616e-09, -2.386093749367469e-11,
 -1.467262084059757e-12,  2.486429799089617e-13,  7.745189028327844e-15, -7.802992576983316e-17, -1.659964379524056e-17, -5.677696707497393e-19,  4.391979726602808e-01,
  3.187908938395542e-02,  6.038705858106936e-04, -3.733908200600386e-05, -1.669717856701167e-06,  6.491886970864381e-08,  5.036304206699442e-09, -8.733558590657017e-11,
 -1.423412609045723e-11, -8.953586388438456e-15,  3.639499832186206e-14,  6.491124349963264e-16,  1.130959656793029e+00,  2.184722526906790e-02, -2.236090759088219e-04,
 -3.343505527626201e-06, -3.395568552399126e-08, -4.220415181683539e-09,  4.425853263042681e-10,  1.734893154607024e-11, -6.389336789584257e-13, -5.114276606015346e-14,
 -4.066062583796188e-16,  1.046262937507151e-16,  1.560601122031333e+00,  1.150966276117034e-02, -1.795335631077690e-04,  1.472213219513773e-06, -7.051094686114142e-08,
 -9.571607520989173e-10,  1.661235972150206e-10,  4.838251669664951e-12, -1.760860902598055e-13, -1.608661059184113e-14, -1.360700567438280e-16,  3.105106857446133e-17,
  1.827663748449086e+00,  4.588172578859578e-03, -8.102794657883477e-05,  1.097772049984103e-06, -3.952852669200246e-08,  3.425154648396268e-11,  4.824008691088439e-11,
  1.620042473839066e-12, -5.673040026199811e-14, -5.089221073700989e-15, -3.558420953898724e-17,  9.635945576295265e-18,  1.967895047957395e+00,  8.606130474654240e-04,
 -1.593607868079953e-05,  2.460055629492848e-07, -8.383000475024649e-09,  4.435948669725333e-11,  7.423389776509541e-12,  2.919596955079754e-13, -1.002988685854828e-14,
 -8.525542092742073e-16, -5.448766538084983e-18,  1.621743890653371e-18,  5.730719940287347e-01,  3.459736540304112e-02,  5.532157820550840e-05, -4.876161172900560e-05,
  4.087906292541533e-07,  1.146352853958687e-07, -1.899363396472753e-09, -2.906217756649353e-10,  6.582004487836869e-12,  7.503581220573142e-13, -2.056304966693423e-14,
 -1.954337654951137e-15,  1.214500646182922e+00,  1.988654098831506e-02, -2.676013677171506e-04, -3.882063271709279e-06,  8.522258309840433e-09,  8.385321305597601e-09,
  4.088629922613535e-10, -2.418226623474058e-11, -1.350888660132454e-12,  4.651488878684911e-14,  4.148776833918111e-15, -5.641036814055545e-17,  1.603852099112868e+00,
  1.012499296030617e-02, -1.684823114793276e-04,  4.355316578311815e-07, -4.425084028386980e-08,  3.527220367584094e-09,  1.473723281723407e-10, -7.756601679012194e-12,
 -4.378393853321014e-13,  1.200022510130108e-14,  1.254723516143780e-15, -9.756109645801402e-18,  1.844788893789880e+00,  3.982405336803429e-03, -7.139435522498030e-05,
  5.433614745954449e-07, -2.532696997868875e-08,  1.376841522587201e-09,  4.453243189299602e-11, -2.382244972640080e-12, -1.398003262202159e-13,  3.604568942903556e-15,
  3.829268639714563e-16, -2.719662424150711e-18,  1.971098180604552e+00,  7.427927561925935e-04, -1.372288443419787e-05,  1.304363391079871e-07, -5.352124379958573e-09,
  2.586097814590314e-10,  7.164184068669524e-12, -3.927553289882194e-13, -2.378592766370531e-14,  6.028252290076215e-16,  6.346873698113855e-17, -4.508549418245883e-19,
  7.089934952983518e-01,  3.295759951925547e-02, -4.289281660873106e-04, -2.845497778288049e-05,  1.785208907435930e-06,  1.166276405755936e-08, -4.770456067702528e-09,
  1.003515030954654e-10,  9.681401289308705e-12, -5.055383834868210e-13, -1.278586635741373e-14,  1.631156032197833e-15,  1.289492886995857e+00,  1.757651648828155e-02,
 -3.068852019259843e-04, -2.160054101015795e-06,  2.041102370071061e-07,  7.590346537288705e-09, -4.654151960164057e-10, -2.199565753551377e-11,  1.506321424834566e-12,
  4.794364996301081e-14, -4.477604106158799e-15, -9.784171244113832e-17,  1.641680549995193e+00,  8.792158284736508e-03, -1.648067622724324e-04,  3.897411875455684e-07,
  3.863488924794351e-08,  3.551336123439506e-09, -1.493585105928537e-10, -8.475657053052104e-12,  4.396777837563210e-13,  1.870152036670734e-14, -1.200175255360108e-15,
 -4.163736298172080e-17,  1.859610838047650e+00,  3.432771604176277e-03, -6.628726074307515e-05,  3.871529706161275e-07,  5.715674411254400e-09,  1.345391006391202e-09,
 -4.924772476973471e-11, -2.782421269631872e-12,  1.322961206608415e-13,  6.161121887508046e-15, -3.490219175569884e-16, -1.356634323522393e-17,  1.973858209603243e+00,
  6.382451404711545e-04, -1.248358459503655e-05,  9.064123399734736e-08,  3.432425056703032e-10,  2.468951056185869e-10, -8.555876811758898e-12, -4.734908942214931e-13,
  2.180219472701010e-14,  1.052632624616028e-15, -5.681447777639512e-17, -2.291258824157772e-18,  8.324643565979499e-01,  2.862974031933204e-02, -6.078266900779317e-04,
 -2.886189154167846e-06,  1.207863704243356e-06, -5.140355100017923e-08, -3.719832867556725e-10,  1.339980250434668e-10, -4.827182571930707e-12, -1.106727327547656e-13,
  1.583188512915451e-14, -3.854651265388574e-16,  1.354812492749855e+00,  1.508025557804215e-02, -3.104844422759239e-04,  1.609831245927490e-06,  2.246570394182458e-07,
 -5.175593998435361e-09, -3.905437900389143e-10,  2.107614822403797e-11,  4.615649727848801e-13, -6.639404413378012e-14,  6.705239533760812e-16,  1.502112004587482e-16,
  1.674261923446211e+00,  7.506785381065708e-03, -1.548493968198519e-04,  1.333638381059693e-06,  6.411545981547321e-08, -1.034900825108913e-09, -1.609591179410513e-10,
  6.400997396519519e-12,  2.358098965188688e-13, -2.113426713975202e-14, -5.017328062984258e-17,  5.178452434914227e-17,  1.872315005460439e+00,  2.924148587851650e-03,
 -6.046087076540744e-05,  6.133187522883909e-07,  1.743704791433795e-08, -1.977618027973668e-10, -5.637383213924728e-11,  1.974565349748377e-12,  8.415530063636294e-14,
 -6.499726503449990e-15, -4.726026262561358e-17,  1.614519514408302e-17,  1.976218857589634e+00,  5.431078029508762e-04, -1.124440517203193e-05,  1.216626746660947e-07,
  2.644372948872761e-09, -2.173407337735260e-11, -9.949548933270564e-12,  3.301025212262023e-13,  1.481148109701983e-14, -1.079062071299177e-15, -1.006236639620299e-17,
  2.688316719309731e-18,  9.374017179716639e-01,  2.388084806797504e-02, -5.593049996173653e-04,  8.679619982804630e-06,  3.013371880447373e-07, -3.306399294531733e-08,
  1.257052289322487e-09, -2.310336071982390e-12, -2.353303510409711e-12,  1.250626909284843e-13, -1.714413271796747e-15, -1.603683080253971e-16,  1.410361097065702e+00,
  1.272461373594535e-02, -2.740989016736613e-04,  4.073041385217533e-06,  7.587592302480072e-08, -7.603790999753362e-09,  1.316470743905208e-10,  1.021434797667648e-11,
 -6.761581038402886e-13,  5.199602466593471e-15,  1.256375746178340e-15, -6.381375173890976e-17,  1.701934068079978e+00,  6.346842714941296e-03, -1.338686977678029e-04,
  2.051864837774587e-06,  2.096268799604941e-08, -2.525556267504733e-09,  2.595718011135948e-11,  4.473580392066678e-12, -2.234648109206899e-13, -9.851859753364855e-16,
  5.082908097933422e-16, -1.736389486890805e-17,  1.883096665297426e+00,  2.473971799012240e-03, -5.173705183512609e-05,  8.087651352989750e-07,  5.130552408785413e-09,
 -7.842586759265076e-10,  5.131813091699292e-12,  1.581548809113800e-12, -7.019488479216955e-14, -6.910781846781173e-16,  1.699778282051236e-16, -4.793288071021246e-18,
  1.978221512227947e+00,  4.596122552559880e-04, -9.577041922611649e-06,  1.511792646200981e-07,  7.004777061536248e-10, -1.299816662050247e-10,  6.045982559377936e-13,
  2.792852684434851e-13, -1.177155470750461e-14, -1.442410710733498e-16,  2.917435886036072e-17, -7.509959055194943e-19,  1.024698071080650e+00,  1.986482103012131e-02,
 -4.430586881401474e-04,  9.721811662170038e-06, -9.220287661896768e-08, -8.688102461916612e-09,  6.788740334474000e-10, -2.510783748607609e-11,  2.965616701150418e-13,
  2.441042323280370e-14, -1.802913866694472e-15,  5.858253658486879e-17,  1.457199217868543e+00,  1.073784373710952e-02, -2.222311633577754e-04,  4.299974730912267e-06,
 -3.248679219232053e-08, -3.062923774873369e-09,  1.832409171131873e-10, -3.547133862027915e-12, -1.475801804656091e-13,  1.327110925732379e-14, -3.753337399331077e-16,
 -5.427942122102125e-18,  1.725338936718628e+00,  5.376619871155676e-03, -1.087084729320823e-04,  2.045728512020327e-06, -1.710147516667301e-08, -1.138545943936131e-09,
  6.478618111712748e-11, -8.490966243775596e-13, -7.639442152608810e-14,  5.015139538770190e-15, -9.492402667206704e-17, -4.480270552117723e-18,  1.892226748281976e+00,
  2.099199369666752e-03, -4.200500775411810e-05,  7.826305414675058e-07, -7.011140115019162e-09, -3.709791412483148e-10,  2.091832119094853e-11, -2.091559082812503e-13,
 -2.846743588043025e-14,  1.660599243102291e-15, -2.451999812774808e-17, -1.803843424405155e-18,  1.979918245533017e+00,  3.902606833666868e-04, -7.773459660462130e-06,
  1.442743220708387e-07, -1.337576078565792e-09, -6.278903354756014e-11,  3.542608733841495e-12, -3.018853812949043e-14, -5.128554344249697e-15,  2.845758919289873e-16,
 -3.674012021020264e-18, -3.322384780767354e-19,  1.097760376159320e+00,  1.675338019948832e-02, -3.387070762272260e-04,  7.528425255325726e-06, -1.524310730291590e-07,
  6.699442185569341e-10,  1.679565748149265e-10, -1.103753353154332e-11,  4.016705923316864e-13, -7.442373941949941e-15, -1.232609138499478e-16,  1.620630325956261e-17,
  1.496904803272326e+00,  9.154263405139423e-03, -1.751028507824526e-04,  3.490314505920041e-06, -5.907921432237395e-08, -5.349411386760463e-11,  6.905475225744342e-11,
 -3.449687115135676e-12,  7.882796669787976e-14,  9.539058194866865e-16, -1.620414447359924e-16,  6.836078701153842e-18,  1.745253333457094e+00,  4.599259926554790e-03,
 -8.630924780932685e-05,  1.663201338601196e-06, -2.708136661775826e-08, -9.414674560607154e-12,  2.769686856625351e-11, -1.282976385300553e-12,  2.290254011268235e-14,
  7.534426358529119e-16, -7.077004855757019e-17,  2.389665721182602e-18,  1.900007714647217e+00,  1.798416666635907e-03, -3.345152472403892e-05,  6.351515173586246e-07,
 -1.021453625044115e-08,  4.088998237402145e-12,  9.467824940533041e-12, -4.252342994610968e-13,  6.546414336739646e-15,  3.122846261972240e-16, -2.489088398861630e-17,
  7.539719041139644e-19,  1.981365273201277e+00,  3.345665247169827e-04, -6.198403024107661e-06,  1.169329492687222e-07, -1.872418691496956e-09,  1.569095231959795e-12,
  1.644940949746542e-12, -7.295104721870689e-14,  1.039379212019219e-15,  5.852911148742522e-17, -4.377854115402410e-18,  1.259920492808851e-19,  1.159870822365267e+00,
  1.436564099877897e-02, -2.620791367764339e-04,  5.333494579918368e-06, -1.173398157800537e-07,  2.188437768455280e-09, -2.541100645327048e-12, -2.504167630620937e-12,
  1.474122985460319e-13, -5.240972499505696e-15,  1.160244541935313e-16, -4.490007178830854e-19,  1.530963244921945e+00,  7.905268002957298e-03, -1.387114928851539e-04,
  2.598892039837324e-06, -4.991385591449986e-08,  7.293282769902589e-10,  6.892463918406526e-12, -1.149982166777756e-12,  5.230599434539661e-14, -1.333601277836502e-15,
  5.749578009275060e-18,  1.279052903913876e-18,  1.762385639978512e+00,  3.981419858866920e-03, -6.886926623448454e-05,  1.253952599639705e-06, -2.305382989270696e-08,
  3.172275848815558e-10,  3.286838270102569e-12, -4.822680623610420e-13,  2.036125496825676e-14, -4.426536665220881e-16, -2.538347139602969e-18,  6.578943519608748e-19,
  1.906710593179445e+00,  1.558581735259984e-03, -2.677746980082111e-05,  4.811746311602029e-07, -8.678588471701398e-09,  1.171421883457703e-10,  1.163815273737036e-12,
 -1.688971361560202e-13,  6.901763204708505e-15, -1.373584811958453e-16, -1.629401514987424e-18,  2.467334228966677e-19,  1.982612549634952e+00,  2.900959878329959e-04,
 -4.968676433810920e-06,  8.875856412709372e-08, -1.587584801602504e-09,  2.129010769496005e-11,  2.031867850959962e-13, -2.970179441471014e-14,  1.196625737989590e-15,
 -2.279444314800525e-17, -3.436452385002353e-19,  4.459740030840586e-20,  1.213504659819292e+00,  1.249631786992114e-02, -2.079545067416116e-04,  3.786711327223100e-06,
 -7.773487546496657e-08,  1.674795167569689e-09, -2.908197751294772e-11,  8.951691645847226e-16,  3.049530267916091e-14, -1.665005596420453e-15,  5.748394808633013e-17,
 -1.367059835251815e-18,  1.560544765024696e+00,  6.907870866019557e-03, -1.118289485353589e-04,  1.917868571995339e-06, -3.548010485261895e-08,  6.565467840377591e-10,
 -8.370613653053581e-12, -1.357954591977700e-13,  1.534448945389441e-14, -6.555609788452565e-16,  1.766883135957267e-17, -2.273001005895697e-19,  1.777296507529161e+00,
  3.484876777594475e-03, -5.582151406183883e-05,  9.366802286417123e-07, -1.669537212809493e-08,  2.932855021816915e-10, -3.403333072420363e-12, -6.864984753734973e-14,
  6.656336979468532e-15, -2.654021942403952e-16,  6.413260752370529e-18, -4.725821908115488e-20,  1.912549956664817e+00,  1.365279332171041e-03, -2.175773178789792e-05,
  3.613589973702701e-07, -6.330240631539226e-09,  1.086524505131012e-10, -1.218839878805152e-12, -2.553087575234849e-14,  2.371436976175253e-15, -9.170442098290757e-17,
  2.091637003560365e-18, -8.951326480280425e-21,  1.983699614239187e+00,  2.542081241540050e-04, -4.041679211870502e-06,  6.681361683174727e-08, -1.161345938882054e-09,
  1.973194619800080e-11, -2.186465470513348e-13, -4.589240401725612e-15,  4.204693025087004e-16, -1.604232100109082e-17,  3.558523271446476e-19, -9.747752406701024e-22,
  1.260423652229369e+00,  1.099560543316142e-02, -1.689904711929593e-04,  2.774415321689603e-06, -5.083253205917128e-08,  1.045248507374144e-09, -2.184856223719584e-11,
  3.591252388111669e-13, -2.202818343767711e-16, -3.127537868696437e-16,  1.626085656279936e-17, -5.442995498018607e-19,  1.586520341372937e+00,  6.096570216806386e-03,
 -9.182430235087495e-05,  1.443788989346104e-06, -2.445583110632327e-08,  4.480467358055456e-10, -7.999447665075809e-12,  9.225857800420645e-14,  1.776037759833063e-15,
 -1.708917110844709e-16,  6.962923221331092e-18, -1.916300872014242e-19,  1.790408196248440e+00,  3.079139307282469e-03, -4.600587128864963e-05,  7.117247240848507e-07,
 -1.170923232204957e-08,  2.054079801066700e-10, -3.460975254567250e-12,  3.491579320004864e-14,  9.418986799505152e-16, -7.627036063139776e-17,  2.912274698092363e-18,
 -7.398956575302567e-20,  1.917688186623220e+00,  1.206995010776746e-03, -1.796293173637764e-05,  2.757477209752609e-07, -4.474256720452477e-09,  7.688702204714133e-11,
 -1.261489174346899e-12,  1.203802343675286e-14,  3.594583576730122e-16, -2.755300450144978e-17,  1.022460007301626e-18, -2.493513252762313e-20,  1.984656448799145e+00,
  2.247938714486264e-04, -3.339372067444504e-06,  5.108183284163671e-08, -8.236564418225947e-10,  1.402198756015609e-11, -2.273619759380427e-13,  2.121985350891265e-15,
  6.546608034938141e-17, -4.917160905689753e-18,  1.801929237996324e-19, -4.310047148393988e-21,  1.301895444021214e+00,  9.764447392407352e-03, -1.399707446586614e-04,
  2.103151466467540e-06, -3.439183504594266e-08,  6.338613172275492e-10, -1.291234739633979e-11,  2.602737563086265e-13, -4.114322128617748e-15,  9.072340818818512e-18,
  2.747288383038113e-18, -1.394146323813014e-19,  1.609538588479145e+00,  5.425243569691722e-03, -7.658212143818506e-05,  1.114688900220354e-06, -1.719062314979091e-08,
  2.893600598407918e-10, -5.244422710922780e-12,  9.059745508778391e-14, -9.926394590651198e-16, -1.779694698830653e-17,  1.629224852684356e-18, -6.399029482310859e-20,
  1.802038631173473e+00,  2.742354918527928e-03, -3.846731220559948e-05,  5.530971081892844e-07, -8.343213590841709e-09,  1.356079359360904e-10, -2.346291688913112e-12,
  3.814139232964156e-14, -3.548726061674206e-16, -1.000116378579684e-17,  7.460715438459115e-19, -2.750004836170958e-20,  1.922248139857394e+00,  1.075417261171046e-03,
 -1.503772215931542e-05,  2.149451878832423e-07, -3.208271675227569e-09,  5.127353516025429e-11, -8.672874796754748e-13,  1.369726689172147e-14, -1.180084771803172e-16,
 -3.908168782148359e-18,  2.728326525971960e-19, -9.783973462377206e-21,  1.985505786076616e+00,  2.003262871654544e-04, -2.797105221226535e-06,  3.987315439079773e-08,
 -5.922875671712760e-10,  9.392843514578248e-12, -1.572336373986849e-13,  2.451084838298112e-15, -2.042449849416003e-17, -7.194184156568883e-19,  4.896461805637880e-20,
 -1.734913278198229e-21,  1.338861480921962e+00,  8.737143447465507e-03, -1.176645908705105e-04,  1.639681721943151e-06, -2.429689787134499e-08,  3.973624413270784e-10,
 -7.321418192685486e-12,  1.461595353003963e-13, -2.832302426207553e-15,  4.356377544678309e-17, -1.808330514170663e-19, -2.078067835381450e-20,  1.630092892771890e+00,
  4.861815216780044e-03, -6.468513748349903e-05,  8.798916376978841e-07, -1.247640200738371e-08,  1.900905673357518e-10, -3.184652061586245e-12,  5.690438222296759e-14,
 -9.542385932215345e-16,  1.037213411641776e-17,  1.408706551311188e-19, -1.350379091023886e-20,  1.812431654232205e+00,  2.459083673486903e-03, -3.255057433027392e-05,
  4.385807785637369e-07, -6.115113809002950e-09,  9.065366230790587e-11, -1.461513919024673e-12,  2.493087284575736e-14, -3.935190767665825e-16,  3.601996570703393e-18,
  8.620343149911707e-20, -6.341363984889109e-21,  1.926324403449605e+00,  9.646314034234175e-04, -1.273586147520186e-05,  1.708073168192286e-07, -2.362424490171857e-09,
  3.456205239167126e-11, -5.467498248572951e-13,  9.112478951257576e-15, -1.396222436364779e-16,  1.170250406842840e-18,  3.465903350583477e-20, -2.345981140282217e-21,
  1.986265157742282e+00,  1.797153093494434e-04, -2.369891743455145e-06,  3.171618214209104e-08, -4.370518919615120e-10,  6.355428639431047e-12, -9.966008736549854e-14,
  1.643097005135583e-15, -2.483434349828379e-17,  1.998867425501103e-19,  6.455613560958841e-21, -4.232427092504846e-22,  1.372043432845357e+00,  7.868470872770716e-03,
 -1.000861815086209e-04,  1.306187206164009e-06, -1.782236528155350e-08,  2.618846641026497e-10, -4.278893122256716e-12,  7.811864416750988e-14, -1.515185119144690e-15,
  2.819699519638306e-17, -4.249376433321127e-19,  2.566375577633371e-21,  1.648567622218249e+00,  4.383439744875335e-03, -5.521082380030473e-05,  7.070151786416307e-07,
 -9.326148047476115e-09,  1.296900883890719e-10, -1.959923022143138e-12,  3.261450811504194e-14, -5.720594900224340e-16,  9.337336642979200e-18, -1.033978617727631e-19,
 -8.468609259793435e-22,  1.821778331064777e+00,  2.218194137041242e-03, -2.782040740325121e-05,  3.535511517333946e-07, -4.603054430234350e-09,  6.266420637009882e-11,
 -9.178916133876617e-13,  1.468663097084540e-14, -2.465070151201538e-16,  3.798466288176726e-18, -3.581438445148622e-20, -6.052196403112471e-22,  1.929991293375700e+00,
  8.703489813534309e-04, -1.089224855756694e-05,  1.379037192478463e-07, -1.784158466591386e-09,  2.404154395131909e-11, -3.467988005530677e-13,  5.439948902253308e-15,
 -8.926555988165604e-17,  1.336034546859976e-18, -1.155216356331421e-20, -2.537977799797765e-22,  1.986948355073677e+00,  1.621685613919648e-04, -2.027441859742520e-06,
  2.562438716007805e-08, -3.305669354905129e-10,  4.433586914444506e-12, -6.350288115389719e-14,  9.868872094945270e-16, -1.602186958289532e-17,  2.365612677132265e-19,
 -1.962795570182611e-21, -4.803869846220255e-23,  1.402008847094553e+00,  7.125995867360555e-03, -8.596629354455429e-05,  1.058007262774204e-06, -1.345917404759989e-08,
  1.807877619911005e-10, -2.639510686886286e-12,  4.288562007021487e-14, -7.689276119347675e-16,  1.440377785757472e-17, -2.574270480284265e-19,  3.813911898652086e-21,
  1.665268400627110e+00,  3.973335098532016e-03, -4.754386824303577e-05,  5.762684499826519e-07, -7.138236951643722e-09,  9.182328427312568e-11, -1.258271471338534e-12,
  1.887598719094600e-14, -3.106872142580116e-16,  5.326947054717998e-18, -8.477597860220547e-20,  9.667686474738983e-22,  1.830231199967520e+00,  2.011437409833370e-03,
 -2.398185885860191e-05,  2.888569180387243e-07, -3.540863985064399e-09,  4.479390646204025e-11, -5.986654422800317e-13,  8.687443016787845e-15, -1.376789318540954e-16,
  2.267539758092702e-18, -3.423104011508777e-20,  3.396336100153201e-22,  1.933308253655842e+00,  7.893789207829581e-04, -9.394151900720433e-06,  1.127981212956317e-07,
 -1.375713804587006e-09,  1.726434348788305e-11, -2.279458706077223e-13,  3.253194153978746e-15, -5.055568185952769e-17,  8.152388016097286e-19, -1.197496478539714e-20,
  1.100359098587805e-22,  1.987566419024639e+00,  1.470953266902180e-04, -1.749002338522452e-06,  2.097033010734455e-08, -2.551658375413648e-10,  3.190441598710219e-12,
 -4.188916482638170e-14,  5.932004663253588e-16, -9.132947994405919e-18,  1.457917946308706e-19, -2.113979474729473e-21,  1.871493980518437e-23,  1.429212946478549e+00,
  6.485643250872424e-03, -7.445310925021025e-05,  8.685083452347930e-07, -1.039220738215437e-08,  1.294843253278540e-10, -1.717643767163901e-12,  2.488940144122671e-14,
 -3.996042403050113e-16,  6.983856424060830e-18, -1.258748147481438e-19,  2.161392219804514e-21,  1.680442266032710e+00,  3.618833166343277e-03, -4.125818229584100e-05,
  4.752691414466694e-07, -5.566078461318493e-09,  6.699950597286796e-11, -8.442894212140381e-13,  1.143010337990250e-14, -1.699183452822431e-16,  2.752424768391169e-18,
 -4.596706331609343e-20,  7.137646168445178e-22,  1.837913917138116e+00,  1.832547948184947e-03, -2.082825722099942e-05,  2.386640863203116e-07, -2.771247310142846e-09,
  3.291379696019438e-11, -4.065342739370762e-13,  5.353785559080709e-15, -7.697726162634801e-17,  1.204106951848711e-18, -1.940357181054573e-20,  2.874544211138214e-22,
  1.936323539629669e+00,  7.192902734030279e-04, -8.162133946277983e-06,  9.327975221656761e-08, -1.078596650387679e-09,  1.272796678963617e-11, -1.556943721210898e-13,
  2.022593532951705e-15, -2.858823203498949e-17,  4.389799711244823e-19, -6.939887967936918e-21,  1.002909702085829e-22,  1.988128318033541e+00,  1.340449991286941e-04,
 -1.519911421362868e-06,  1.734863372069910e-08, -2.002171120726422e-10,  2.355700914510597e-12, -2.868845700857183e-14,  3.703336512110163e-16, -5.192319663083680e-18,
  7.902102537850679e-20, -1.237732475047290e-21,  1.767568419299649e-23,  1.454026528236208e+00,  5.929063441505074e-03, -6.494986597867449e-05,  7.209243295986400e-07,
 -8.164901242930234e-09,  9.538046037529048e-11, -1.167938558666943e-12,  1.531464613521885e-14, -2.195437089983964e-16,  3.460710178562215e-18, -5.862120117600525e-20,
  1.014223580912002e-21,  1.694291576728354e+00,  3.310161838913743e-03, -3.604836969723088e-05,  3.959296731648045e-07, -4.405622920237141e-09,  5.004291248780488e-11,
 -5.876819441035193e-13,  7.277820648386244e-15, -9.739225465734867e-17,  1.430026278750036e-18, -2.268635370079813e-20,  3.679423331834461e-22,  1.844927993033867e+00,
  1.676670806441164e-03, -1.821019379232190e-05,  1.991066412951014e-07, -2.199683463445517e-09,  2.471275990262793e-11, -2.855346653006348e-13,  3.456482441939902e-15,
 -4.493646093102839e-17,  6.390527746967966e-19, -9.826821310915592e-21,  1.545033465745532e-22,  1.939076805613738e+00,  6.581953677559314e-04, -7.138530885319142e-06,
  7.787322007936982e-08, -8.572953470042019e-10,  9.580403077072264e-12, -1.098296648627905e-13,  1.314831429948517e-15, -1.684669798720475e-17,  2.356027125883312e-19,
 -3.562197476828385e-21,  5.506706904650718e-23,  1.988641425494601e+00,  1.226673369776854e-04, -1.329506189722150e-06,  1.448788070030655e-08, -1.592354171791143e-10,
  1.775156530455956e-12, -2.027764329619737e-14,  2.415155420585490e-16, -3.073474951352823e-18,  4.263964875903158e-20, -6.394000514912322e-22,  9.802832790938659e-24,
  1.476755418570749e+00,  5.441983782385209e-03, -5.702421990276711e-05,  6.041566352344722e-07, -6.506530661794138e-09,  7.180264805803954e-11, -8.215378897704043e-13,
  9.904872861330717e-15, -1.282666949204698e-16,  1.811427370946071e-18, -2.787559903499689e-20,  4.557199074369264e-22,  1.706983943470129e+00,  3.039652582789093e-03,
 -3.168943219139491e-05,  3.327437374791217e-07, -3.530940961777437e-09,  3.807373423140017e-11, -4.208816854689369e-13,  4.837266712451304e-15, -5.897398798131720e-17,
  7.792394569023060e-19, -1.125660848617236e-20,  1.741180247762901e-22,  1.851357647248469e+00,  1.539983357693100e-03, -1.601689596861504e-05,  1.675236405868690e-07,
 -1.766875761418516e-09,  1.887765783642760e-11, -2.058985319714875e-13,  2.322327915156510e-15, -2.762381868912238e-17,  3.545950760708846e-19, -4.973471208653349e-21,
  7.487080978142142e-23,  1.941600977851786e+00,  6.046055406530448e-04, -6.280461687902475e-06,  6.555765392093029e-08, -6.893491775541510e-10,  7.332316736918766e-12,
 -7.945822669617013e-14,  8.880825061905110e-16, -1.043563811095480e-17,  1.319845840368595e-19, -1.822183879146062e-21,  2.702283997713719e-23,  1.989111866030040e+00,
  1.126859308069270e-04, -1.169846433416721e-06,  1.219981288741196e-08, -1.281031632482490e-10,  1.359789405626349e-12, -1.469219266366508e-14,  1.635262411718568e-16,
 -1.910716574752580e-18,  2.399659982771370e-20, -3.287727285276356e-22,  4.839737798354340e-24,  1.497654519236765e+00,  5.013122381992838e-03, -5.035480854892795e-05,
  5.105559359121421e-07, -5.247349099346963e-09,  5.500339035413642e-11, -5.931964418863817e-13,  6.662167134121139e-15, -7.912153774966756e-17,  1.009729767385411e-18,
 -1.398602152802837e-20,  2.091046625004426e-22,  1.718659527598526e+00,  2.801202929195574e-03, -2.801200955444140e-05,  2.818341681508580e-07, -2.860509305292318e-09,
  2.940779163794741e-11, -3.081842468076736e-13,  3.324990281170539e-15, -3.748250153926124e-17,  4.500792516838176e-19, -5.859369778373533e-21,  8.292660491683934e-23,
  1.857273399419329e+00,  1.419435787103305e-03, -1.416458642894754e-05,  1.420260121746792e-07, -1.433941926214183e-09,  1.462707340158701e-11, -1.515704386547724e-13,
  1.609805530609347e-15, -1.777269510080811e-17,  2.080200479721825e-19, -2.633737464015693e-21,  3.630329615196675e-23,  1.943923644193100e+00,  5.573316229114934e-04,
 -5.555422084367027e-06,  5.560545158014645e-08, -5.599366999609651e-10,  5.689918962754020e-12, -5.864112516027616e-14,  6.181187705229294e-16, -6.755009711855060e-18,
  7.805403458648633e-20, -9.739445315905301e-22,  1.323238612078465e-23,  1.989544772781582e+00,  1.038798559624772e-04, -1.034907206188684e-06,  1.035001183381127e-08,
 -1.040952443365405e-10,  1.055929213024764e-12, -1.085554309710509e-14,  1.140294930385479e-16, -1.240315366174418e-18,  1.424586601856109e-20, -1.765221747310068e-22,
  2.381385106116123e-24,  1.516938223353906e+00,  4.633442194525813e-03, -4.469792448204554e-05,  4.346840365857751e-07, -4.275887495645858e-09,  4.274918733502921e-11,
 -4.373152407826418e-13,  4.619477821867464e-15, -5.098479503330783e-17,  5.960574494970963e-19, -7.475427218182156e-21,  1.011269686800021e-22,  1.729436523948471e+00,
  2.589899071076402e-03, -2.488642004929543e-05,  2.403987862546978e-07, -2.339418927400229e-09,  2.300654310893803e-11, -2.297266304000116e-13,  2.345773571647146e-15,
 -2.475662268004913e-17,  2.740829207819279e-19, -3.239615171631968e-21,  4.143409003176658e-23,  1.862734780310719e+00,  1.312567332776532e-03, -1.258887980187815e-05,
  1.212398764178221e-07, -1.174431517623384e-09,  1.147227395856221e-11, -1.134610909030454e-13,  1.143294064380164e-15, -1.185433931864661e-17,  1.283498931713768e-19,
 -1.478713331626980e-21,  1.842748702122874e-23,  1.946068105740427e+00,  5.154131845371964e-04, -4.938387853951112e-06,  4.748585924145278e-08, -4.589264133088046e-10,
  4.468146814288921e-12, -4.398533852903623e-14,  4.403946214315963e-16, -4.527264237713360e-18,  4.848112722467765e-20, -5.512870062038061e-22,  6.775496209464511e-24,
  1.989944482324895e+00,  9.607060310027037e-05, -9.200463639315556e-07,  8.840291468484717e-09, -8.534470216576066e-11,  8.296548512840351e-13, -8.149936260196828e-15,
  8.136164357422237e-17, -8.331153391459091e-19,  8.876157037840904e-21, -1.003103186238895e-22,  1.224608420490968e-24,  1.534788300639769e+00,  4.295622070545112e-03,
 -3.986572130504763e-05,  3.725803433496879e-07, -3.516257978334105e-09,  3.363936394831533e-11, -3.279516543782757e-13,  3.281198592228264e-15, -3.399857126939468e-17,
  3.688457852481428e-19, -4.238805526010421e-21,  5.208098688564797e-23,  1.739415353264189e+00,  2.401743658885541e-03, -2.221194749860266e-05,  2.063703966111359e-07,
 -1.929529201117242e-09,  1.820006709084600e-11, -1.738123867990636e-13,  1.689562164442151e-15, -1.684643685429409e-17,  1.741960057933812e-19, -1.894851129912251e-21,
  2.201455053270195e-23,  1.867792412655848e+00,  1.217372890753814e-03, -1.123962627472403e-05,  1.041467466278100e-07, -9.698284960938440e-10,  9.094386331703411e-12,
 -8.613810249756452e-14,  8.278688540304086e-16, -8.130744178750152e-18,  8.246830805666379e-20, -8.766630816164245e-22,  9.935041558973801e-24,  1.948054185479261e+00,
  4.780670135902186e-04, -4.409840507105600e-06,  4.080450053334502e-08, -3.791994167734984e-10,  3.545574370000490e-12, -3.344742639374245e-14,  3.197068236944267e-16,
 -3.117104432467177e-18,  3.131960411406342e-20, -3.291217976050076e-22,  3.681985588094138e-24,  1.990314684665353e+00,  8.911254808713898e-05, -8.216408172000688e-07,
  7.597617385405813e-09, -7.053747107083852e-11,  6.586512978821229e-13, -6.201979408403047e-15,  5.913345892299475e-17, -5.746232701592391e-19,  5.748615914619884e-21,
 -6.008494132386481e-23,  6.680598551520823e-25,  1.551359967336485e+00,  3.993672234454662e-03, -3.571142089098211e-05,  3.213040366263755e-07, -2.915324570356224e-09,
  2.675926873098597e-11, -2.495231680511435e-13,  2.376943619632661e-15, -2.329649012693430e-17,  2.369623433340311e-19, -2.525799480250856e-21,  2.847687729031190e-23,
  1.748681914661046e+00,  2.233455293202141e-03, -1.990941821897017e-05,  1.781983468636162e-07, -1.603702907630845e-09,  1.454066042566901e-11, -1.332034557683144e-13,
  1.237871592759785e-15, -1.173724010143663e-17,  1.144707156213232e-19, -1.160858503651777e-21,  1.240245179604362e-23,  1.872489630288241e+00,  1.132204261843743e-03,
 -1.007731006982316e-05,  8.997965368756117e-08, -8.068774320490726e-10,  7.278355732588215e-12, -6.619778605243767e-14,  6.091821619507406e-16, -5.701433638730098e-18,
  5.468379795765956e-20, -5.433651421822741e-22,  5.672779218094785e-24,  1.949898858380848e+00,  4.446488835548639e-04, -3.954382992082226e-06,  3.526383965097570e-08,
 -3.156443555470523e-10,  2.839944365814282e-12, -2.573904343442407e-14,  2.357419989321258e-16, -2.192543108319822e-18,  2.085946854100267e-20, -2.051947481631604e-22,
  2.117271321087746e-24,  1.990658540194145e+00,  8.288587224980550e-05, -7.368310398776175e-07,  6.566842539226621e-09, -5.872878874130545e-11,  5.277707436118243e-13,
 -4.775566560828457e-15,  4.364428790451069e-17, -4.047560073874499e-19,  3.836490726948251e-21, -3.756408047509450e-23,  3.854647168206842e-25,  1.566786624254902e+00,
  3.722649159449390e-03, -3.211897809073638e-05,  2.786361557628951e-07, -2.435038121854802e-09,  2.149236661474817e-11, -1.922492488097413e-13,  1.750638859376379e-15,
 -1.632112508819343e-17,  1.568637311689661e-19, -1.566535339420782e-21,  1.638823690673975e-23,  1.757310140180566e+00,  2.082318289779009e-03, -1.791592888943847e-05,
  1.547029754776263e-07, -1.342255310740854e-09,  1.172077222966850e-11, -1.032400661624048e-13,  9.202129854234533e-16, -8.336677390738026e-18,  7.723275930215656e-20,
 -7.376690113757239e-22,  7.339102033382530e-24,  1.876863752900010e+00,  1.055695863636340e-03, -9.070475362519270e-06,  7.815328019328068e-08, -6.759155002591526e-10,
  5.875357898762682e-12, -5.142629788356977e-14,  4.544794082867240e-16, -4.071087584809576e-18,  3.717148395084835e-20, -3.487156782288865e-22,  3.397379597480131e-24,
  1.951616748061067e+00,  4.146247379030631e-04, -3.559747325755458e-06,  3.063646733746259e-08, -2.645263983159334e-10,  2.294129809871695e-12, -2.001796230540376e-14,
  1.761760071019800e-16, -1.569549273836830e-18,  1.423066307220112e-20, -1.323350532162049e-22,  1.275845444432594e-24,  1.990978771923766e+00,  7.729122185630251e-05,
 -6.633376611682986e-07,  5.705788600018480e-09, -4.922758242614397e-11,  4.264760389510268e-13, -3.715985502153686e-15,  3.264187412822165e-17, -2.900824136287030e-19,
  2.621660652611325e-21, -2.428123168676586e-23,  2.329554003011719e-25,  1.581183599651477e+00,  3.478440658142302e-03, -2.899569186078007e-05,  2.428792985841730e-07,
 -2.047644497076706e-09,  1.741239996767580e-11, -1.497730192074425e-13,  1.307894831331436e-15, -1.164883495223050e-17,  1.064125383388311e-19, -1.003461539113559e-21,
  9.834831501050513e-24,  1.765364022914734e+00,  1.946068490364591e-03, -1.618102737092582e-05,  1.349758381116752e-07, -1.130676027313725e-09,  9.524436774392539e-12,
 -8.082818708961582e-14,  6.928031047281542e-16, -6.018438631236120e-18,  5.323769294636147e-20, -4.825250497203401e-22,  4.516677777006601e-24,  1.880947100096865e+00,
  9.867080844869257e-04, -8.193852159586569e-06,  6.821570629988172e-08, -5.697910566667368e-10,  4.780257737423739e-12, -4.034118262182353e-14,  3.431888859178267e-16,
 -2.951975026026879e-18,  2.578286304619781e-20, -2.300197735479316e-22,  2.112933255907812e-24,  1.953220522242335e+00,  3.875486839661063e-04, -3.216070332711112e-06,
  2.674658312208104e-08, -2.230759936938534e-10,  1.867657737455324e-12, -1.571787306601277e-14,  1.332255110923207e-16, -1.140488399765330e-18,  9.900269047231591e-21,
 -8.764879581360060e-23,  7.976867389403051e-25,  1.991277738961950e+00,  7.224562674891597e-05, -5.993274620552309e-07,  4.981830736113653e-09, -4.152094030198520e-11,
  3.472920860958333e-13, -2.919010827333149e-15,  2.470010211000457e-17, -2.109857255328974e-19,  1.826385944289638e-21, -1.611244394444567e-23,  1.460092850232038e-25,
  1.594651137113436e+00,  3.257601627143914e-03, -2.626682231634341e-05,  2.127194027097585e-07, -1.732579334955611e-09,  1.421846022245992e-11, -1.178454514972754e-13,
  9.894477494986116e-16, -8.447816506076880e-18,  7.368278406994586e-20, -6.600351229176300e-22,  6.106935501572795e-24,  1.772899242684852e+00,  1.822805391344054e-03,
 -1.466390037654736e-05,  1.183097569962953e-07, -9.581201929498411e-10,  7.797226155152283e-12, -6.386231437983300e-14,  5.275075077380082e-16, -4.406513326137472e-18,
  3.736344759827802e-20, -3.231378288135515e-22,  2.867956465556854e-24,  1.884767805562180e+00,  9.242835776433279e-04, -7.426970568973892e-06,  5.981437123747256e-08,
 -4.831411780284914e-10,  3.917504840920154e-12, -3.192652652807202e-14,  2.619670600088166e-16, -2.169345596253896e-18,  1.818982116336287e-20, -1.551350960222149e-22,
  1.353911329388180e-24,  1.954721210514392e+00,  3.630459923113240e-04, -2.915357073228348e-06,  2.345689445848449e-08, -1.892129719362427e-10,  1.531375270269648e-12,
 -1.244937291632498e-14,  1.018185898992563e-16, -8.396040332010404e-19,  7.002164783153432e-21, -5.931735973038386e-23,  5.134402454420999e-25,  1.991557495570829e+00,
  6.767934550041138e-05, -5.433140095444635e-07,  4.369478190733522e-09, -3.522334169539944e-11,  2.848287330220107e-13, -2.312864512572434e-15,  1.888766921086250e-17,
 -1.554482914218374e-19,  1.293224223325894e-21, -1.092147316956249e-23,  9.417686700562527e-26, -2.004326186219366e+00,  2.598822036603483e-03, -5.239077936735542e-04,
  1.061072189292757e-04, -2.159074781055150e-05,  4.414124896395774e-06, -9.067725071140636e-07,  1.871772774273868e-07, -3.882702365315037e-08,  8.093501102483910e-09,
 -1.692485327916869e-09,  3.410712939967389e-10, -2.004042414062921e+00,  2.414242436604815e-03, -4.698472007365711e-04,  9.190258978051928e-05, -1.807204461457272e-05,
  3.573632737100320e-06, -7.108058323755645e-07,  1.422478106596721e-07, -2.864880653996435e-08,  5.807849836391382e-09, -1.183505704610284e-09,  2.332498023864549e-10,
 -2.003883254224730e+00,  2.311596052743595e-03, -4.408639668077292e-04,  8.456241068230336e-05, -1.631920349731218e-05,  3.169855796934200e-06, -6.199662638309345e-07,
  1.221377908435130e-07, -2.424619839091958e-08,  4.851436442828462e-09, -9.771915106841945e-10,  1.907573269189592e-10, -2.003790162164599e+00,  2.251850934225750e-03,
 -4.243514786182930e-04,  8.046858809497071e-05, -1.536185199826694e-05,  2.953790420875445e-06, -5.723133441599198e-07,  1.117887933624141e-07, -2.202180578666834e-08,
  4.376590370034971e-09, -8.764254127758002e-10,  1.702968119950683e-10, -2.003742973391889e+00,  2.221648231135741e-03, -4.161042465994958e-04,  7.844817905681098e-05,
 -1.489485305228467e-05,  2.849578348111031e-06, -5.495784138119184e-07,  1.069024567782341e-07, -2.098185365566679e-08,  4.156635325593209e-09, -8.301468196334746e-10,
  1.609684951828677e-10, -2.001853548202259e+00,  1.097898908560877e-03, -2.027521424894687e-04,  3.747824348942106e-05, -6.934325175507738e-06,  1.284224153047504e-06,
 -2.380616932189025e-07,  4.417235853457085e-08, -8.203964714665469e-09,  1.525081094005199e-09, -2.834557609962244e-10,  5.102066872411460e-11, -2.001796195708785e+00,
  1.061227042771107e-03, -1.927886643720646e-04,  3.505741591254593e-05, -6.381349455542916e-06,  1.162755503484781e-06, -2.120882286206873e-07,  3.872630149449785e-08,
 -7.078891662809386e-09,  1.295353106306666e-09, -2.370483057442683e-10,  4.205737990254906e-11, -2.001762020833401e+00,  1.039458422826585e-03, -1.869754792606845e-04,
  3.366938862516957e-05, -6.069783221383122e-06,  1.095501369089392e-06, -1.979561162545785e-07,  3.581423077470683e-08, -6.487643395815956e-09,  1.176692227222157e-09,
 -2.134835035236912e-10,  3.757738242715946e-11, -2.001741319285722e+00,  1.026302202166264e-03, -1.834988084572617e-04,  3.284795343314914e-05, -5.887326220360986e-06,
  1.056526385981183e-06, -1.898509817963546e-07,  3.416121865625327e-08, -6.155439787635081e-09,  1.110691753785985e-09, -2.005064140933543e-10,  3.513281815727623e-11,
 -2.001730617184819e+00,  1.019509746050706e-03, -1.817146428028526e-04,  3.242895279498798e-05, -5.794817200613681e-06,  1.036883213699287e-06, -1.857901736974664e-07,
  3.333787239004123e-08, -5.990928546665173e-09,  1.078193745181203e-09, -1.941523340668948e-10,  3.394202289449834e-11, -2.000864181239474e+00,  5.088894900941755e-04,
 -9.045190878865622e-05,  1.608075672025327e-05, -2.859497540167241e-06,  5.085896019357473e-07, -9.047732023915159e-08,  1.609928046731879e-08, -2.865281388483732e-09,
  5.100462390642248e-10, -9.072687104836830e-11,  1.566070589507122e-11, -2.000851163731750e+00,  5.006262086545707e-04, -8.828007996568064e-05,  1.557067102015119e-05,
 -2.746934790458596e-06,  4.847152866824618e-07, -8.555066022116609e-08,  1.510286089800868e-08, -2.666827030049830e-09,  4.709980775840451e-10, -8.312799671996674e-11,
  1.424383987067986e-11, -2.000843192937256e+00,  4.955756486729614e-04, -8.696373632973660e-05,  1.526411764552498e-05, -2.679859493394266e-06,  4.706094890943972e-07,
 -8.266453094810016e-08,  1.452409665253141e-08, -2.552534567298388e-09,  4.487004711879339e-10, -7.882542480244804e-11,  1.344791382996019e-11, -2.000838284556315e+00,
  4.924689948990177e-04, -8.615822251116949e-05,  1.507750454158961e-05, -2.639240697464635e-06,  4.621119805835228e-07, -8.093494265056243e-08,  1.417905900538577e-08,
 -2.484750757042632e-09,  4.355446727883790e-10, -7.629988091335288e-11,  1.298295144378355e-11, -2.000835722969172e+00,  4.908487404885562e-04, -8.573937721469122e-05,
  1.498076494988104e-05, -2.618247914804510e-06,  4.577335574152066e-07, -8.004644615374802e-08,  1.400234506074437e-08, -2.450138754303813e-09,  4.288470582732224e-10,
 -7.501792925515259e-11,  1.274758964208301e-11, -2.000417877825531e+00,  2.454136469833678e-04, -4.284250875866528e-05,  7.479521514872319e-06, -1.305856553119310e-06,
  2.280026337122006e-07, -3.981135746284331e-08,  6.951792930386374e-09, -1.213973041096269e-09,  2.119983053689403e-10, -3.699119110008400e-11,  6.269417916097537e-12,
 -2.000414770691075e+00,  2.434479466412456e-04, -4.233391762906768e-05,  7.361960967261062e-06, -1.280328382973745e-06,  2.226753563349395e-07, -3.872986343917862e-08,
  6.736633175715633e-09, -1.171824929358034e-09,  2.038424287967446e-10, -3.543034979431526e-11,  5.982927974448410e-12, -2.000412843322880e+00,  2.422296915649743e-04,
 -4.202001640779032e-05,  7.289705481063628e-06, -1.264703867791958e-06,  2.194284766167711e-07, -3.807348080019074e-08,  6.606596762836950e-09, -1.146458901049640e-09,
  1.989546045746968e-10, -3.449885075170827e-11,  5.812622784112344e-12, -2.000411646941712e+00,  2.414738950359335e-04, -4.182577516922502e-05,  7.245110000295264e-06,
 -1.255085646661177e-06,  2.174349523984106e-07, -3.767152392276762e-08,  6.527172185368638e-09, -1.131005973093383e-09,  1.959846928540570e-10, -3.393432187768838e-11,
  5.709660148548727e-12, -2.000411019668908e+00,  2.410777514147292e-04, -4.172411866808019e-05,  7.221806295441532e-06, -1.250067218761029e-06,  2.163963889691307e-07,
 -3.746243553091603e-08,  6.485920185602459e-09, -1.122992119795470e-09,  1.944468363633748e-10, -3.364244207766139e-11,  5.656500098661991e-12, -2.000205545710408e+00,
  1.205579053060177e-04, -2.086282848045024e-05,  3.610407828843885e-06, -6.248056053868348e-07,  1.081282444520174e-07, -1.871280819237209e-08,  3.238503342360191e-09,
 -5.604733705303764e-10,  9.699742612388714e-11, -1.677274482331961e-11,  2.818470635286132e-12, -2.000204786350902e+00,  1.200782868622520e-04, -2.073968173069753e-05,
  3.582162082841338e-06, -6.187196819173336e-07,  1.068681267738976e-07, -1.845899455508255e-08,  3.188404909094619e-09, -5.507369025900475e-10,  9.512827986225502e-11,
 -1.641786219133743e-11,  2.753816248989561e-12, -2.000204312323914e+00,  1.197790176915985e-04, -2.066299913144408e-05,  3.564610120219500e-06, -6.149457485608937e-07,
  1.060883467441894e-07, -1.830225876592745e-08,  3.157532612327684e-09, -5.447495146068413e-10,  9.398126155428628e-11, -1.620053869376915e-11,  2.714300370698746e-12,
 -2.000204016918805e+00,  1.195925692967628e-04, -2.061528620747161e-05,  3.553703200848503e-06, -6.126036462818309e-07,  1.056050453049849e-07, -1.820524170001924e-08,
  3.138448025320458e-09, -5.410530621631407e-10,  9.327404533912339e-11, -1.606671737645036e-11,  2.689997224190761e-12, -2.000203861678559e+00,  1.194946032262257e-04,
 -2.059023513821124e-05,  3.547981007711877e-06, -6.113758244056813e-07,  1.053518729444487e-07, -1.815445910241200e-08,  3.128466012026856e-09, -5.391211418085672e-10,
  9.290470626133793e-11, -1.599688305319973e-11,  2.677323696587393e-12, -2.000101943486456e+00,  5.975455918861625e-05, -1.029616623796533e-05,  1.774113609532877e-06,
 -3.056952506923698e-07,  5.267412598160479e-08, -9.076269166411221e-09,  1.563935250496628e-09, -2.694829139991718e-10,  4.643381641681549e-11, -7.994259837989237e-12,
  1.337789870160411e-12, -2.000101755766901e+00,  5.963608889369410e-05, -1.026586258486417e-05,  1.767189444242732e-06, -3.042090580072030e-07,  5.236758494446119e-08,
 -9.014763211707700e-09,  1.551841877477221e-09, -2.671416920710822e-10,  4.598610353794600e-11, -7.909583783418991e-12,  1.322419067671068e-12, -2.000101638216226e+00,
  5.956191844837494e-05, -1.024690985384595e-05,  1.762863357956573e-06, -3.032814766921655e-07,  5.217646161645823e-08, -8.976455172945074e-09,  1.544317552393331e-09,
 -2.656865351882875e-10,  4.570812331118525e-11, -7.857063887822644e-12,  1.312894685003234e-12, -2.000101564817378e+00,  5.951561257528705e-05, -1.023508492127670e-05,
  1.760165984887751e-06, -3.027034928044597e-07,  5.205744849758708e-08, -8.952616164165068e-09,  1.539638231506950e-09, -2.647821737555464e-10,  4.553547469699152e-11,
 -7.824465866647929e-12,  1.306986691372166e-12, -2.000101526200853e+00,  5.949125211726835e-05, -1.022886643469359e-05,  1.758748030919083e-06, -3.023997742438506e-07,
  5.199493343762559e-08, -8.940098822822511e-09,  1.537182161393832e-09, -2.643076761969509e-10,  4.544492456058568e-11, -7.807375473733470e-12,  1.303890370512411e-12,
 -2.000050766704776e+00,  2.974774057984912e-05, -5.114797321500048e-06,  8.794339287012787e-07, -1.512092462541278e-07,  2.599883120423769e-08, -4.470227686744433e-09,
  7.686095894560511e-10, -1.321545087752655e-10,  2.272207280066933e-11, -3.903521941435810e-12,  6.519000584032698e-13, -2.000050720036428e+00,  2.971829978143129e-05,
 -5.107280757435900e-06,  8.777196999986033e-07, -1.508420061853064e-07,  2.592322887821767e-08, -4.455087408201314e-09,  7.656383805964465e-10, -1.315803970927613e-10,
  2.261249545578112e-11, -3.882837111170404e-12,  6.481519750448769e-13, -2.000050690767001e+00,  2.969983711534583e-05, -5.102569441058226e-06,  8.766457908927382e-07,
 -1.506120612887595e-07,  2.587591556421520e-08, -4.445617270150337e-09,  7.637808768653071e-10, -1.312216677859642e-10,  2.254406251855492e-11, -3.869925774258373e-12,
  6.458135829397067e-13, -2.000050672473304e+00,  2.968829853791606e-05, -5.099625961201335e-06,  8.759750637253259e-07, -1.504684921241622e-07,  2.584638447104120e-08,
 -4.439708309810930e-09,  7.626222516284619e-10, -1.309979818797552e-10,  2.250140501669409e-11, -3.861880135814410e-12,  6.443568683642766e-13, -2.000050662843139e+00,
  2.968222464348225e-05, -5.098076807952936e-06,  8.756221270783421e-07, -1.503929604242071e-07,  2.583085113684058e-08, -4.436600794812807e-09,  7.620130485435490e-10,
 -1.308803907238947e-10,  2.247898435680884e-11, -3.857652176801878e-12,  6.435915059065452e-13, -2.000025332376937e+00,  1.484167772102100e-05, -2.549141865904786e-06,
  4.378295809235353e-07, -7.519972990978665e-08,  1.291598544828065e-08, -2.218395108156869e-09,  3.810222413650138e-10, -6.544274868525588e-11,  1.123989672603132e-11,
 -1.928888187652517e-12,  3.218047366051941e-13, -2.000025320742327e+00,  1.483433946362426e-05, -2.547270080313688e-06,  4.374031041267200e-07, -7.510845212189160e-08,
  1.289721227169573e-08, -2.214639126315883e-09,  3.802858487805276e-10, -6.530059474674984e-11,  1.121279047904225e-11, -1.923776218625184e-12,  3.208792745164449e-13,
 -2.000025313439672e+00,  1.482973373411107e-05, -2.546095586539970e-06,  4.371355707004351e-07, -7.505120741648110e-08,  1.288544176034994e-08, -2.212284791284705e-09,
  3.798243810673186e-10, -6.521153573109596e-11,  1.119581291210748e-11, -1.920575247227485e-12,  3.202999169083913e-13, -2.000025308873217e+00,  1.482685380221830e-05,
 -2.545361300949597e-06,  4.369683376359346e-07, -7.501543000193456e-08,  1.287808649488140e-08, -2.210813832168348e-09,  3.795361087582847e-10, -6.515591089610130e-11,
  1.118521072336542e-11, -1.918576621854323e-12,  3.199382321417461e-13, -2.000025306468658e+00,  1.482533734610539e-05, -2.544974692083171e-06,  4.368802960768609e-07,
 -7.499659641070886e-08,  1.287421497878068e-08, -2.210039652420066e-09,  3.793844028163235e-10, -6.512664061826176e-11,  1.117963229212809e-11, -1.917525128424082e-12,
  3.197479637840083e-13, -2.000012653479891e+00,  7.412814573145721e-06, -1.272514747266452e-06,  2.184452134816768e-07, -3.749922250462322e-08,  6.437274295990378e-09,
 -1.105049641397777e-09,  1.896974850707901e-10, -3.256424934127822e-11,  5.589978306188833e-12, -9.587906502811907e-13,  1.598786810574678e-13, -2.000012650575286e+00,
  7.410982741978045e-06, -1.272047716380522e-06,  2.183388530185014e-07, -3.747646919814440e-08,  6.432596821858995e-09, -1.104114254898899e-09,  1.895141815352049e-10,
 -3.252888105357398e-11,  5.583237401588634e-12, -9.575199841513283e-13,  1.596487439555397e-13, -2.000012648751455e+00,  7.409832548240244e-06, -1.271754508427384e-06,
  2.182720871657649e-07, -3.746218807024629e-08,  6.429661382694165e-09, -1.103527311233578e-09,  1.893991757318325e-10, -3.250669364842774e-11,  5.579009214283273e-12,
 -9.567230704840607e-13,  1.595045536221083e-13, -2.000012647610710e+00,  7.409113152841799e-06, -1.271571134469506e-06,  2.182303347870296e-07, -3.745325801589039e-08,
  6.427825988394311e-09, -1.103160352376354e-09,  1.893272796294886e-10, -3.249282427872995e-11,  5.576366385391054e-12, -9.562249999344859e-13,  1.594144416113944e-13,
 -2.000012647009942e+00,  7.408734290378854e-06, -1.271474566929085e-06,  2.182083483872313e-07, -3.744855575951120e-08,  6.426859579665243e-09, -1.102967143052535e-09,
  1.892894270675105e-10, -3.248552254696855e-11,  5.574975096197744e-12, -9.559628084821928e-13,  1.593670074822976e-13, -2.000006323567198e+00,  3.704404186156871e-06,
 -6.357443245792566e-07,  1.091054946782777e-07, -1.872452282395507e-08,  3.213474814774047e-09, -5.514917845046514e-10,  9.464620179338329e-11, -1.624302940927505e-11,
  2.787535611019487e-12, -4.779899725661874e-13,  7.968498031460637e-14, -2.000006322841551e+00,  3.703946569415302e-06, -6.356276810530833e-07,  1.090789368229495e-07,
 -1.871884274077722e-08,  3.212307417185734e-09, -5.512583873238572e-10,  9.460047482695069e-11, -1.623420851586158e-11,  2.785854820090832e-12, -4.776732169300113e-13,
  7.962767357596164e-14, -2.000006322385822e+00,  3.703659175593802e-06, -6.355544309123830e-07,  1.090622600180384e-07, -1.871527620606754e-08,  3.211574453587504e-09,
 -5.511118558077527e-10,  9.457176836759233e-11, -1.622867129811370e-11,  2.784799790820666e-12, -4.774744028844334e-13,  7.959170675562375e-14, -2.000006322100745e+00,
  3.703479400098631e-06, -6.355086120650838e-07,  1.090518288966131e-07, -1.871304547613879e-08,  3.211116031750908e-09, -5.510202134478231e-10,  9.455381577522743e-11,
 -1.622520854560807e-11,  2.784140044970701e-12, -4.773500827129183e-13,  7.956921724238099e-14, -2.000006321950599e+00,  3.703384715889830e-06, -6.354844807486553e-07,
  1.090463352900981e-07, -1.871187067814944e-08,  3.210874612927729e-09, -5.509719529590811e-10,  9.454436184846845e-11, -1.622338508610173e-11,  2.783792636066976e-12,
 -4.772846197697805e-13,  7.955737526376847e-14, -2.000003160990961e+00,  1.851701688753096e-06, -3.177440244319838e-07,  5.452350450757111e-08, -9.355998301659538e-09,
  1.605448976169733e-09, -2.754881241255596e-10,  4.727257378607101e-11, -8.111764033255133e-12,  1.391909267631008e-12, -2.386446438744019e-13,  3.977909419703819e-14,
 -2.000003160809612e+00,  1.851587327161736e-06, -3.177148778096586e-07,  5.451686907121423e-08, -9.354579309792176e-09,  1.605157372732214e-09, -2.754298309064608e-10,
  4.726115438369254e-11, -8.109561451234994e-12,  1.391489622937697e-12, -2.385655685245488e-13,  3.976478964133429e-14, -2.000003160695708e+00,  1.851515498019434e-06,
 -3.176965717498986e-07,  5.451270170041808e-08, -9.353688143974753e-09,  1.604974243707764e-09, -2.753932235393736e-10,  4.725398338349966e-11, -8.108178348807421e-12,
  1.391226117316848e-12, -2.385159166990046e-13,  3.975580800857392e-14, -2.000003160624452e+00,  1.851470563309180e-06, -3.176851201159874e-07,  5.451009479092923e-08,
 -9.353130684216302e-09,  1.604859691527334e-09, -2.753703251024342e-10,  4.724949791059657e-11, -8.107313233489087e-12,  1.391061300813478e-12, -2.384848612921634e-13,
  3.975019043160037e-14, -2.000003160586922e+00,  1.851446896180430e-06, -3.176790886069764e-07,  5.450872176314853e-08, -9.352837080384082e-09,  1.604799359714753e-09,
 -2.753582652037060e-10,  4.724713557896041e-11, -8.106857614900788e-12,  1.390974500172700e-12, -2.384685061515662e-13,  3.974723200202486e-14,     0.997932467367649,
     0.988912168395471,     0.971785806764868,     0.944407997159842,     0.900816042786884,     0.998968406240984,     0.994467815107192,     0.985923147790628,
     0.972264876470539,     0.950520508774221,     0.999484724889804,      0.99723671517941,     0.992968764393511,      0.98614675410156,     0.975286228336849,
     0.999742490438814,      0.99861904514826,     0.996486137340494,     0.993076853017906,     0.987649366759045,     0.999871276924199,     0.999309692741927,
      0.99824350235995,     0.996539283178972,     0.993826217932075,     0.999935646352318,     0.999654888701917,      0.99912185897802,     0.998269854249469,
     0.996913489118982,      0.99996782514426,      0.99982745490758,     0.999560956361243,     0.999134980103279,     0.998456839167488,     0.999983913063601,
     0.999913730089696,     0.999780484889067,     0.999567503273092,     0.999228443182297,       0.9999919566546,      0.99995686570342,     0.999890244120447,
     0.999783754939019,     0.999614227484126,     0.999995978357991,     0.999978433016302,     0.999945122479052,     0.999891878294767,     0.999807115214477,
     0.999997989186667,     0.999989216549293,     0.999972561344214,     0.999945939353653,     0.999903557975238  };
  constexpr double w[2635] = {  2.864747031832172e-01, -1.203956709530787e-01,  2.716939055345101e-02, -4.182996896152797e-03,  4.888527208840445e-04,
 -4.606179117146709e-05,  3.637336400462102e-06, -2.472838158267440e-07,  1.476295220972618e-08, -7.857791840163207e-10,  3.773818518748210e-11, -1.648865351565666e-12,
  2.870363532092418e-01, -1.025847303882611e-01,  2.009396223868561e-02, -2.750758247468436e-03,  2.917257892812096e-04, -2.536451490493593e-05,  1.873756817364840e-06,
 -1.205280986854536e-07,  6.872590312804998e-09, -3.521505008243405e-10,  1.638982647003751e-11, -6.979267866310482e-13,  2.766771109513279e-01, -6.930388644468372e-02,
  1.022770255184272e-02, -1.111184148999863e-03,  9.732654004503304e-05, -7.213075605770531e-06,  4.660360048992953e-07, -2.678494589681873e-08,  1.389437006176946e-09,
 -6.576799820043184e-11,  2.865027043062281e-12, -1.155026488861050e-13,  2.286560616307157e-01, -3.180308424682290e-02,  3.067515886061007e-03, -2.362423302549404e-04,
  1.552424321552534e-05, -9.019076346997018e-07,  4.733805480231556e-08, -2.277337859770516e-09,  1.014530004914927e-10, -4.217231250843410e-12,  1.645334690682659e-13,
 -6.045803799061963e-15,  1.174437843481057e-01, -7.535924526374471e-03,  3.941588559551649e-04, -1.853111940831849e-05,  8.036941889416836e-07, -3.263727392476779e-08,
  1.253859275155402e-09, -4.590851616253232e-11,  1.610505142505083e-12, -5.435474385936266e-14,  1.769621125456015e-15, -5.569124681041176e-17,  4.524552670798407e-02,
 -1.875420629118761e-02,  4.179450474825084e-03, -6.366433375579206e-04,  7.373235623959319e-05, -6.893868029016803e-06,  5.407664632709739e-07, -3.655130399963129e-08,
  2.171058146398113e-09, -1.150396942677558e-10,  5.502926761603911e-12, -2.395802013051496e-13,  6.506456239244940e-02, -2.149215186350188e-02,  3.949940742306442e-03,
 -5.134912966126295e-04,  5.219115824743330e-05, -4.380050810023665e-06,  3.140817839462493e-07, -1.969999228443917e-08,  1.099402241938197e-09, -5.530343742651309e-11,
  2.533334192274149e-12, -1.064054172616403e-13,  1.053486197349221e-01, -2.233875334010177e-02,  2.917110908896334e-03, -2.867779306585374e-04,  2.309424134421059e-05,
 -1.592923809781352e-06,  9.672377209263842e-08, -5.266745923645228e-09,  2.606021556366052e-10, -1.183479090458421e-11,  4.971123293741700e-13, -1.940949097011691e-14,
  1.371233104451003e-01, -1.543578852581841e-02,  1.281100806497285e-03, -8.694570069831272e-05,  5.114599768366721e-06, -2.692325354887640e-07,  1.293132462915786e-08,
 -5.741030612910627e-10,  2.377738380949250e-11, -9.249321178566639e-13,  3.397016895472917e-14, -1.181550318481005e-15,  9.245263864335085e-02, -5.094340823582101e-03,
  2.317114438356429e-04, -9.610371400757629e-06,  3.716400682276033e-07, -1.356278464702449e-08,  4.710998324692270e-10, -1.568401670892732e-11,  5.021714367583868e-13,
 -1.555105554693098e-14,  4.666574712269711e-16, -1.355217231366778e-17,  7.403512276016238e-03, -3.007206037483029e-03,  6.584536169443049e-04, -9.884872603927379e-05,
  1.131040954388210e-05, -1.046824296617550e-06,  8.141009323650292e-08, -5.462124938157958e-09,  3.223672916412945e-10, -1.698635196636675e-11,  8.085562552464980e-13,
 -3.504932062779312e-14,  1.701967347642469e-02, -5.046497843923733e-03,  8.536513348315920e-04, -1.038419248692490e-04,  9.996583369498499e-06, -8.019619907679090e-07,
  5.537133557538788e-08, -3.363584155051150e-09,  1.826617181011958e-10, -8.976323303906562e-12,  4.030052281497272e-13, -1.663636732490464e-14,  4.734231876931009e-02,
 -8.281585063386651e-03,  9.450727693919699e-04, -8.315765162501491e-05,  6.096719747576742e-06, -3.878184805565239e-07,  2.194405558074870e-08, -1.123074197962822e-09,
  5.261493709137866e-11, -2.276692788087201e-12,  9.162251095997909e-14, -3.444309401136539e-15,  9.080542704448452e-02, -8.290869254810842e-03,  5.937667825180003e-04,
 -3.556400222973073e-05,  1.872695936395320e-06, -8.921280353314334e-08,  3.913096248728906e-09, -1.598679929549685e-10,  6.135030385878204e-12, -2.224845971976475e-13,
  7.659258361749127e-15, -2.510413500762371e-16,  7.517205875749532e-02, -3.618113571568292e-03,  1.447613149726734e-04, -5.342059430574893e-06,  1.854572012303368e-07,
 -6.122749311195990e-09,  1.929899890607982e-10, -5.877484038022475e-12,  1.724400216596340e-13, -4.890588482072810e-15,  1.361073908552233e-16, -3.670981376315474e-18,
  1.275033967428504e-03, -5.020996963224328e-04,  1.071665065222019e-04, -1.576241213910482e-05,  1.773935415416014e-06, -1.619644693419012e-07,  1.245353232154505e-08,
 -8.275819416884072e-10,  4.844441897804351e-11, -2.534695161937557e-12,  1.199132957780632e-13, -5.170138524432536e-15,  5.273793800387731e-03, -1.353796822268736e-03,
  2.063508253855517e-04, -2.310329510329193e-05,  2.078607843375820e-06, -1.576358407743813e-07,  1.038155836696576e-08, -6.058755751197406e-10,  3.179723529985793e-11,
 -1.517468534296067e-12,  6.643265974038146e-14, -2.683430264130548e-15,  2.476390864502687e-02, -3.499758628112108e-03,  3.465172128195364e-04, -2.708412477369264e-05,
  1.794664592735192e-06, -1.045136108477673e-07,  5.471891836216702e-09, -2.613898465075919e-10,  1.151578565412359e-11, -4.717127749989987e-13,  1.807485004201249e-14,
 -6.503453092576908e-16,  6.501384085451678e-02, -4.847096197983430e-03,  3.010565993349443e-04, -1.597263774701209e-05,  7.545222311756483e-07, -3.255074896793261e-08,
  1.303926078430033e-09, -4.897228798188170e-11,  1.737899264138457e-12, -5.864170205557911e-14,  1.887307010568716e-15, -5.808312662563661e-17,  6.267050233930525e-02,
 -2.673907603115932e-03,  9.510488430292139e-05, -3.149228553085224e-06,  9.863723198084064e-08, -2.973957215869479e-09,  8.519692461988969e-11, -2.376097167106112e-12,
  6.506309374991802e-14, -1.676473759294479e-15,  4.283419660034332e-17, -1.097797543231439e-18,  2.369529454143896e-04, -8.880050109022029e-05,  1.824746071747569e-05,
 -2.606227677755486e-06,  2.865980106574559e-07, -2.568410015387369e-08,  1.944975712565225e-09, -1.276233259737896e-10,  7.391496109671838e-12, -3.832429819042057e-13,
  1.798994560595114e-14, -7.704349711387711e-16,  1.970419771847377e-03, -4.202533538531767e-04,  5.657154734790861e-05, -5.732271988067921e-06,  4.754290492777848e-07,
 -3.368142944607828e-08,  2.094138177686201e-09, -1.163693128237625e-10,  5.855893603143450e-12, -2.695385467093974e-13,  1.143724653113184e-14, -4.496862254918198e-16,
  1.477674332761017e-02, -1.661898195511334e-03,  1.425769433584025e-04, -9.856630891765408e-06,  5.879664455810314e-07, -3.118288294798388e-08,  1.502590248614763e-09,
 -6.665210254818016e-11,  2.745271331573556e-12, -1.058504633643058e-13,  3.840484044443801e-15, -1.315250882624879e-16,  4.946449972602858e-02, -3.040459137099916e-03,
  1.647958897753241e-04, -7.781934648918943e-06,  3.311445585029133e-07, -1.295827287075214e-08,  4.746379762810145e-10, -1.641692738058349e-11,  5.378634551846939e-13,
 -1.686657108373131e-14,  5.075343755049165e-16, -1.463361689613520e-17,  5.328991579879059e-02, -2.041298082546370e-03,  6.512740324957103e-05, -1.954771130296237e-06,
  5.523218928720099e-08, -1.538257116807045e-09,  4.064540595365419e-11, -1.004899646190458e-12,  2.665217877978012e-14, -6.427106420968125e-16,  1.419437032334479e-17,
 -3.486283796344541e-19,  4.942157239731901e-05, -1.705335196737328e-05,  3.310119519299104e-06, -4.529442064364966e-07,  4.819859456294682e-08, -4.208946234833816e-09,
  3.121631155354939e-10, -2.013765599473441e-11,  1.149965692755768e-12, -5.892300320801685e-14,  2.738273343975978e-15, -1.162660217872513e-16,  8.910727069162495e-04,
 -1.512417698714129e-04,  1.773157276186093e-05, -1.600573945923423e-06,  1.208747720005491e-07, -7.908914055454141e-09,  4.594022084727041e-10, -2.408549991117917e-11,
  1.152388858641350e-12, -5.077557015347897e-14,  2.074370823193145e-15, -7.891031581707338e-17,  9.837471809526353e-03, -8.716969610020443e-04,  6.512362595455259e-05,
 -3.971518532994400e-06,  2.132441540703852e-07, -1.027574973287904e-08,  4.533688876544748e-10, -1.863758332105923e-11,  7.145530635868639e-13, -2.579520470220171e-14,
  8.830338424418865e-16, -2.861799539018344e-17,  3.945342488962940e-02, -2.021884161385681e-03,  9.629885104714998e-05, -4.065336205820657e-06,  1.567548006178780e-07,
 -5.584966941807197e-09,  1.866753054596444e-10, -5.985997615667700e-12,  1.813336150085890e-13, -5.248309250835729e-15,  1.485843941449754e-16, -3.996376062170235e-18,
  4.603670905256171e-02, -1.601119819740378e-03,  4.610638108525158e-05, -1.272248899253193e-06,  3.236236886262983e-08, -8.221390762541526e-10,  2.160484857195164e-11,
 -4.372381433313898e-13,  1.083078401034427e-14, -2.996188385349763e-16,  4.405683328779814e-18, -1.433341053308719e-19,  1.227155015105343e-05, -3.673512767508743e-06,
  6.559713595866702e-07, -8.429637840300484e-08,  8.560437601088767e-09, -7.208759983664393e-10,  5.194909411701700e-11, -3.274691105603016e-12,  1.834964466738569e-13,
 -9.256052796709359e-15,  4.245408489850652e-16, -1.782669173663522e-17,  4.825392160463506e-04, -6.236318283814023e-05,  6.365307239823331e-06, -5.043686276622754e-07,
  3.434348323255649e-08, -2.058288051690813e-09,  1.105039036310681e-10, -5.421606331930857e-12,  2.446706012703314e-13, -1.023334974362153e-14,  3.999947603078065e-16,
 -1.462091499297815e-17,  7.156071227192606e-03, -4.958407055797937e-04,  3.267705393246157e-05, -1.752484579321871e-06,  8.470484881817614e-08, -3.737232593663376e-09,
  1.493392594911567e-10, -5.688279991137745e-12,  2.040915384413674e-13, -6.794615186029121e-15,  2.206068108982999e-16, -6.759874464461075e-18,  3.264840228667323e-02,
 -1.411141529253314e-03,  5.953422861363895e-05, -2.254510647358292e-06,  7.905521035210381e-08, -2.601059953057794e-09,  7.844735591119850e-11, -2.331706905616504e-12,
  6.748796065678619e-14, -1.732352794576382e-15,  4.675880350099329e-17, -1.241715178697556e-18,  4.028422882949562e-02, -1.285618986007776e-03,  3.348489289708527e-05,
 -8.613963239658842e-07,  2.027675031635104e-08, -4.203925184199011e-10,  1.277308467586841e-11, -2.396362826288122e-13,  2.001219505946842e-15, -2.135915399900602e-16,
  1.173565511277588e-18,  4.161994089045532e-20,  3.919744324372499e-06, -9.162966344171381e-07,  1.466794583930455e-07, -1.720075524337261e-08,  1.635995961435154e-09,
 -1.310367281426618e-10,  9.070959542725903e-12, -5.541312426789912e-13,  3.026979926699472e-14, -1.494846911447445e-15,  6.740182307730600e-17, -2.789462370102913e-18,
  3.065917372510588e-04, -2.870539740349867e-05,  2.607731393708595e-06, -1.792774156325170e-07,  1.085083694183523e-08, -5.979350046516961e-10,  2.930957149070537e-11,
 -1.330565528226046e-12,  5.673861185253103e-14, -2.220736688081285e-15,  8.229162076746172e-17, -2.912295437323036e-18,  5.588709847695484e-03, -3.001426296306507e-04,
  1.782184290484195e-05, -8.436947324817462e-07,  3.593828600735266e-08, -1.503392043531697e-09,  5.415229777286041e-11, -1.820787360608681e-12,  6.548158958372265e-14,
 -1.973581940265316e-15,  5.425294745115328e-17, -1.936781274746581e-18,  2.781090712303231e-02, -1.024964801635987e-03,  3.863258938661339e-05, -1.321938881912570e-06,
  4.162919707078461e-08, -1.304776907189411e-09,  3.605914903620342e-11, -8.988200806789735e-13,  2.811095299009163e-14, -6.962019003674490e-16,  9.876032051808405e-18,
 -5.353006826429380e-19,  3.561911163724051e-02, -1.054113473035068e-03,  2.486509023820279e-05, -5.898123835368677e-07,  1.440005158746154e-08, -1.936767028779090e-10,
  5.925563085343275e-12, -2.785126040230422e-13, -3.254315358246080e-15, -3.514516516489660e-18,  1.224193127313508e-17,  3.963563909988387e-19,  1.732123036258894e-06,
 -2.657854604676447e-07,  3.838994767692620e-08, -3.960491019216794e-09,  3.427158536899146e-10, -2.580943680444746e-11,  1.689180083817429e-12, -9.857002417603204e-14,
  5.224145306940380e-15, -2.505991506918316e-16,  1.099251339682947e-17, -4.492035737229407e-19,  2.230879942895678e-04, -1.420860014605213e-05,  1.199831445476402e-06,
 -7.285376901202162e-08,  3.721853708531362e-09, -1.925690605332639e-10,  8.845368134645853e-12, -3.473945652873990e-13,  1.421592028885702e-14, -5.574340827036571e-16,
  1.712248123340525e-17, -5.860611924127734e-19,  4.620446108081446e-03, -1.901877034659898e-04,  1.034538271576467e-05, -4.524061874830470e-07,  1.572577751416800e-08,
 -6.328751547555678e-10,  2.402226827112914e-11, -5.743083312744350e-13,  1.834639651433812e-14, -9.211048720978141e-16,  1.252422525426381e-17,  2.944534213470370e-20,
  2.424241356086393e-02, -7.697478030088254e-04,  2.603730158605447e-05, -8.246201473552034e-07,  2.258335487560756e-08, -6.610387394234802e-10,  2.006160769760000e-11,
 -3.561559110014575e-13,  6.681508488621247e-15, -5.185827726488213e-16,  6.574254649959241e-18,  4.567644221837789e-19,  3.176086123331342e-02, -8.798450293867903e-04,
  1.905926989861324e-05, -3.854986453205847e-07,  1.127025519730576e-08, -1.528676972749659e-10, -2.525801394776053e-12, -2.668546424474357e-13,  7.737968157102771e-15,
  5.836234638893880e-16,  5.683015708139786e-18, -1.113365943010172e-18,  1.075744946440062e-06, -8.404574955970652e-08,  1.193516604396770e-08, -1.085492493129767e-09,
  7.921977076631060e-11, -5.546094814259078e-12,  3.494651940336104e-13, -1.870825209553398e-14,  9.276320355400953e-16, -4.507285205098457e-17,  1.922860925504311e-18,
 -6.960080671441244e-20,  1.810353162375061e-04, -7.325720290614019e-06,  5.859018206167485e-07, -3.516200419509340e-08,  1.406564607330685e-09, -6.035179240604486e-11,
  3.202585078780088e-12, -1.155321560737500e-13,  2.646811141924046e-15, -1.424234485028783e-16,  7.603226957450486e-18, -4.943459751323895e-20,  3.995836540786938e-03,
 -1.256447264712798e-04,  6.097109367389499e-06, -2.753570106759004e-07,  7.758251977033067e-09, -2.095723179922462e-10,  1.201256363672456e-11, -3.929159269604923e-13,
 -1.908383684653805e-15, -6.142171079393154e-17,  3.038225331232826e-17, -4.877437821208506e-20,  2.152489019719775e-02, -5.957390585790491e-04,  1.794966905782122e-05,
 -5.460425585748839e-07,  1.343146581021935e-08, -2.893869335586695e-10,  1.089899736213010e-11, -3.455607325168706e-13, -1.897807035435858e-15,  1.490467622073796e-16,
  2.013441535634551e-17, -4.176273329212022e-19,  2.852111405997363e-02, -7.430727718195056e-04,  1.539847064962411e-05, -2.347226088181381e-07,  7.224944069197457e-09,
 -2.570864611047277e-10, -3.746488625523466e-12,  2.407193190586889e-13,  1.794272976068485e-14, -3.998911177701619e-16, -4.587348838166584e-17,  1.837738453737864e-19,
  8.702136110074733e-07, -2.528223478173528e-08,  3.955493953512713e-09, -3.823486641408217e-10,  2.226275751456964e-11, -1.175468963912240e-12,  7.669273868505889e-14,
 -4.516804373399618e-15,  1.827296727357300e-16, -6.226648878810898e-18,  3.483023395231209e-19, -1.943760693575215e-20,  1.588819024095096e-04, -4.013211125856589e-06,
  2.699995128448591e-07, -1.910615960642228e-08,  7.425641394518451e-10, -1.555998819306276e-11,  7.550873788623033e-13, -6.294347848142289e-14,  1.757533810667191e-15,
  3.808595707528976e-17, -3.804011801732066e-19, -2.424304613984962e-19,  3.572548557381826e-03, -8.821045397852316e-05,  3.439618009599270e-06, -1.729075739069883e-07,
  5.541918920243431e-09, -5.485439847422360e-11,  1.233576201044110e-12, -3.066139246623700e-13,  1.022607853783457e-14,  3.910837745428964e-16, -1.732392152629433e-17,
 -1.152965380311739e-18,  1.939230340444942e-02, -4.750623979733154e-04,  1.253256312105682e-05, -3.665349678490908e-07,  9.476951024052083e-09, -1.417437024205877e-10,
  1.928624206973997e-12, -2.301317267725226e-13,  9.463243870893397e-15,  2.057738643286653e-16, -1.784583032355676e-17, -4.709981564549999e-19,  2.577959720513584e-02,
 -6.295938363502316e-04,  1.309836699635587e-05, -1.619640317344036e-07,  1.968974176288373e-09, -2.251294626754799e-10,  6.875119465577548e-12,  3.335347767490411e-13,
 -1.485147593414511e-14, -7.995341291045201e-16,  3.953449272162479e-17,  1.775421281530452e-18,  8.101146258857410e-07, -7.244829561222354e-09,  9.593835718701396e-10,
 -1.473123666726466e-10,  9.689765593662683e-12, -3.366757543203917e-13,  9.870728401998404e-15, -8.293448324895548e-16,  6.616630293993865e-17, -2.465221512486993e-18,
  3.620627674026580e-21,  1.609107135519339e-21,  1.459559795149472e-04, -2.588053951937337e-06,  1.035966534838344e-07, -9.203056631560596e-09,  5.063705625809937e-10,
 -1.145804959566911e-11, -1.206569690514572e-13, -1.255465857013263e-15,  1.430170283096394e-15, -6.108759544461719e-17, -1.328406602555358e-18,  1.536679925081573e-19,
  3.263616999811753e-03, -6.756999193670701e-05,  1.859627350752682e-06, -9.355209747590600e-08,  4.269289964713821e-09, -8.454863437002695e-11, -1.921150372459282e-12,
  6.624573135239570e-14,  7.718972517840378e-15, -4.377782914045839e-16, -6.000057354216124e-18,  1.092894940296377e-18,  1.766808372904249e-02, -3.900251816744967e-04,
  8.954109790972052e-06, -2.366067760735995e-07,  6.769874644622870e-09, -1.369154253589379e-10, -1.864544587805772e-13,  5.136395109634819e-14,  4.694602334880693e-15,
 -3.365181662774660e-16, -1.936158425678138e-19,  6.969611893949336e-19,  2.345887837172432e-02, -5.323185258482707e-04,  1.123013349554340e-05, -1.555223523159853e-07,
 -4.708482208986540e-10, -1.546600793332796e-11,  7.813992459702274e-12, -2.418091209839452e-13, -1.104870166683884e-14,  7.727143179114503e-16,  9.009442375589771e-18,
 -1.979445474819399e-18,  7.884101073388052e-07, -4.458499817025733e-09, -7.207640645594599e-11, -3.786916885522923e-11,  4.350654398974695e-12, -2.157701485143389e-13,
  4.177746460875479e-15,  7.086956933125111e-17,  6.693070679186485e-19, -7.993204834298584e-19,  5.344625706110790e-20, -9.871174470122158e-22,  1.367323413751443e-04,
 -2.081509147716394e-06,  3.383153175607081e-08, -3.037823007943546e-09,  2.631653339621112e-10, -1.169941805970064e-11,  1.505181325059446e-13,  1.058532818931651e-14,
 -4.011946691345523e-16, -1.892021655455758e-17,  1.863985342878321e-18, -3.306716943435152e-20,  3.017436062341947e-03, -5.616249820124147e-05,  1.085460568425623e-06,
 -4.032992046253084e-08,  2.350501138709823e-09, -9.470056751414525e-11,  1.146536231707403e-12,  8.937018461890062e-14, -3.928069535497359e-15, -8.820858190793848e-17,
  1.232644057522970e-17, -2.761037805855272e-19,  1.623559379107123e-02, -3.281145181643378e-04,  6.675360628263266e-06, -1.497781783399831e-07,  4.147212963365035e-09,
 -1.172376109145985e-10,  1.784326033499590e-12,  4.844769056628064e-14, -2.919259742266510e-15, -3.626279165596354e-17,  7.898633576082679e-18, -2.285558540329660e-19,
  2.149732221690120e-02, -4.500411208303281e-04,  9.334154318697660e-06, -1.580373810501750e-07,  4.467529691641072e-10,  7.552000565584334e-11, -2.886253330585162e-14,
 -2.116065391729453e-13,  8.555377906359722e-15,  1.170197668959438e-16, -2.157556466683858e-17,  5.268329361413860e-19,  7.678310204940553e-07, -5.959299871896699e-09,
 -2.321469832720290e-10,  3.167507303891348e-12,  1.143481407905930e-12, -1.037954421973318e-13,  4.441600967204697e-15, -6.668989048945558e-17, -3.433193834818287e-18,
  2.033916502794181e-19,  1.120198049042721e-21, -6.159038838419297e-22,  1.287964176297565e-04, -1.901219600497899e-06,  1.575942286109527e-08, -4.318891463425944e-10,
  8.070867453763288e-11, -6.192139188620637e-12,  2.444796230770329e-13, -2.785984230208068e-15, -2.441175760301200e-16,  1.378682644205816e-17, -9.332254991416680e-20,
 -2.363672115702877e-20,  2.807817276251097e-03, -4.890640236953485e-05,  7.711745819945235e-07, -1.579343843449040e-08,  8.585847382225988e-10, -5.160977920394221e-11,
  1.920646182599650e-12, -2.147141539445796e-14, -1.869575412875988e-15,  1.081135060760030e-16, -1.152327904901004e-18, -1.480279550912627e-19,  1.501993684874774e-02,
 -2.809345092351825e-04,  5.207119703854654e-06, -9.958095441434511e-08,  2.287139253915577e-09, -6.824706549892903e-11,  1.947801842538836e-12, -2.612606902437302e-14,
 -1.115522578483405e-15,  7.467009580160845e-17, -1.053528083202871e-18, -8.495760542440620e-20,  1.983480647246734e-02, -3.827253362473689e-04,  7.526161250256705e-06,
 -1.402999104377530e-07,  1.629260131041732e-09,  3.392633987647167e-11, -2.363491036467847e-12,  1.703939020784232e-14,  3.870395907105527e-15, -2.089765848961897e-16,
  2.532230494855718e-18,  2.527302440025409e-19,  7.407941070367776e-07, -7.477318126929983e-09, -1.361978294870291e-10,  9.871814742737948e-12, -5.495091811023440e-14,
 -2.581799059243908e-14,  2.006096060109189e-15, -8.114582721950509e-17,  1.453141699406468e-18,  4.207656783717700e-20, -3.993173865287389e-21,  1.167297531299163e-22,
  1.214318433229216e-04, -1.781440296135259e-06,  1.517172504152894e-08,  1.504464236086862e-10,  6.402639890112011e-12, -1.743248175069377e-12,  1.194314826340923e-13,
 -4.495400844900687e-15,  6.790272265456488e-17,  2.936689192200152e-18, -2.333843958769552e-19,  6.551335954051512e-21,  2.623575271636267e-03, -4.332509405166249e-05,
  6.373674303314430e-07, -8.093925272223497e-09,  2.171424531789504e-10, -1.640851939072944e-11,  9.605026166622409e-13, -3.458632806061784e-14,  5.074818676037005e-16,
  2.218873262718826e-17, -1.737868314334749e-18,  4.927219109326825e-20,  1.397270511546020e-02, -2.435239997692627e-04,  4.194105624509876e-06, -7.165959610854329e-08,
  1.318683986622282e-09, -3.222666262036956e-11,  1.039385366956909e-12, -3.049199372108993e-14,  4.599757138697070e-16,  1.346285635272793e-17, -1.164238486500598e-18,
  3.409966115521200e-20,  1.841433118643634e-02, -3.287741908105642e-04,  6.012253746683687e-06, -1.115508275633220e-07,  1.825692186227069e-09, -8.998730945084035e-12,
 -1.072324331257918e-12,  5.110562179018176e-14, -7.083059914854104e-16, -4.445868124499426e-17,  3.243109684320939e-18, -9.188644040458734e-20,  7.094003171275621e-07,
 -8.133664773301337e-09, -3.343964968629877e-11,  6.808765756673081e-12, -2.440092593664150e-13,  8.607994567982543e-16,  4.498120461812381e-16, -3.157982627482458e-17,
  1.247663522675915e-18, -2.745331168789608e-20, -1.280151464986002e-22,  3.999621608752397e-23,  1.145602688594355e-04, -1.652933281002302e-06,  1.684103135384413e-08,
  9.205674828775693e-11, -8.501181740598734e-12, -9.488702633271745e-14,  3.019156463205635e-14, -1.895375655784487e-15,  6.990423190319039e-17, -1.362213687055414e-18,
 -1.572511480605844e-20,  2.408876205914481e-21,  2.459916577210173e-03, -3.857388377952389e-05,  5.535060288446826e-07, -6.283203755141087e-09,  5.224938460497275e-11,
 -2.782393177736509e-12,  2.673869447264285e-13, -1.499146288639100e-14,  5.321629114485766e-16, -1.001316116634112e-17, -1.271438073105200e-19,  1.794693051850585e-20,
  1.306071996311900e-02, -2.130936200311970e-04,  3.443190985424146e-06, -5.461878225516442e-08,  8.639987598793603e-10, -1.566755749028463e-11,  4.165075520226133e-13,
 -1.428654139681873e-14,  4.308942417964644e-16, -7.797228452639906e-18, -7.587244875813038e-20,  1.202844484994536e-20,  1.718762688058070e-02, -2.855545898436794e-04,
  4.839633574028913e-06, -8.474907583929568e-08,  1.487403655396175e-09, -2.089638726677971e-11, -6.438207337159836e-14,  2.047587911059424e-14, -8.569374040515029e-16,
  1.626700108651196e-17,  2.674764613232669e-19, -3.323106806703795e-20,  6.767594410449559e-07, -8.136815694402238e-09,  2.665748553289791e-11,  3.397899356972897e-12,
 -1.709449930338849e-13,  4.669798199999214e-15, -1.739876180133869e-17, -6.249071376994583e-18,  4.109728793281183e-19, -1.593003725453874e-20,  3.962636941284216e-22,
 -3.449745861007316e-24,  1.082217664933913e-04, -1.516060243616234e-06,  1.715485606737921e-08, -3.386176078750660e-11, -6.340735701181912e-12,  1.997983081374158e-13,
  1.055878943101529e-15, -4.256287966559426e-16,  2.505697985355660e-17, -9.087344451064964e-19,  2.055258427584995e-20, -9.278361023276552e-23,  2.314016242080146e-03,
 -3.443576458883596e-05,  4.821004219343663e-07, -5.656194697026548e-09,  3.527237725585725e-11,  1.824983790334243e-13,  3.127016532403564e-14, -3.667232487747661e-15,
  1.970983372725854e-16, -6.902418833385602e-18,  1.508458339935986e-19, -5.093540410688444e-22,  1.225958963248309e-02, -1.879556451800557e-04,  2.861816720906240e-06,
 -4.286982885484639e-08,  6.251467814829006e-10, -9.174661897143306e-12,  1.674598007541321e-13, -4.874411698157529e-15,  1.740269458465378e-16, -5.333658174001302e-18,
  1.104091070754549e-19, -3.746206986401187e-22,  1.611693126802531e-02, -2.505324446418450e-04,  3.951786004087777e-06, -6.423159928517869e-08,  1.086837909022797e-09,
 -1.809861585590461e-11,  2.158374641537768e-13,  2.543350694460476e-15, -2.970076900130699e-16,  1.161671560935619e-17, -2.582341762456785e-19,  6.076532500182759e-22,
  6.448402132054936e-07, -7.800210250742681e-09,  5.391916023368743e-11,  1.348717124399599e-12, -9.009840445367610e-14,  3.208404084124641e-15, -7.497063783404667e-17,
  3.769219291161351e-19,  7.101725393610095e-20, -4.507826322710045e-21,  1.711370149264429e-22, -4.517395581235663e-24,  1.024273885102609e-04, -1.381873479176308e-06,
  1.626824628045215e-08, -1.047250161092331e-10, -2.697188914387886e-12,  1.478082436072542e-13, -3.513416345581173e-15, -5.012619778990771e-18,  4.978721087003786e-18,
 -2.806439877686781e-19,  9.982370727029144e-21, -2.435168365044543e-22,  2.183571003797827e-03, -3.084045241739951e-05,  4.177946173962194e-07, -5.046499924306878e-09,
  4.096304499215392e-11,  2.230966208243113e-13, -1.276502198122354e-14, -2.816155590665041e-16,  4.252646460759702e-17, -2.209978723551824e-18,  7.605933162511055e-20,
 -1.797741815122581e-21,  1.155052123538144e-02, -1.669615414552960e-04,  2.401941021159735e-06, -3.415412734361572e-08,  4.733936872547621e-10, -6.312823243268750e-12,
  8.572605387688452e-14, -1.603562782193694e-15,  5.110100090760279e-17, -1.867056042150756e-18,  5.739969491140325e-20, -1.285768690317702e-21,  1.517353191441680e-02,
 -2.217312779256984e-04,  3.274338946146514e-06, -4.944735177376551e-08,  7.782763883393133e-10, -1.281895286300813e-11,  2.036015336640084e-13, -2.085704096078940e-15,
 -4.073071336233450e-17,  3.516792088877339e-18, -1.312662658140592e-19,  3.151069316271342e-21,  6.145756507084712e-07, -7.324352554580123e-09,  6.327272968942181e-11,
  3.294084362313161e-13, -4.223333258869722e-14,  1.681312811134266e-15, -4.953787149046461e-17,  1.044524471890881e-18, -7.015595866974365e-21, -6.707271798114458e-22,
  4.244766797242910e-23, -1.577980994196252e-24,  9.715145129952156e-05, -1.257292306690134e-06,  1.483576453905290e-08, -1.286323169892635e-10, -5.336736209642211e-13,
  7.275719898606371e-14, -2.500441509969448e-15,  5.154870476656968e-17, -9.470337474462976e-20, -4.907551766259536e-20,  2.708273730444176e-21, -9.431961211753140e-23,
  2.066526408637745e-03, -2.772895935629251e-05,  3.612600376204229e-07, -4.372719061102273e-09,  4.227059946149821e-11, -8.010476562213108e-14, -1.017316049886849e-14,
  2.582660882620331e-16,  1.652142944620192e-18, -4.206755435843277e-19,  2.143768471395301e-20, -7.231780938309315e-22,  1.091868038027983e-02, -1.492655821676182e-04,
  2.033697761339993e-06, -2.749069471882437e-08,  3.648155999534030e-10, -4.658173705871323e-12,  5.619845891814816e-14, -6.979622910892442e-16,  1.362181473490374e-17,
 -4.770124011997311e-19,  1.768047948570744e-20, -5.401573534196090e-22,  1.433551344088436e-02, -1.977162130483618e-04,  2.748026775221219e-06, -3.880177968978508e-08,
  5.656544641950117e-10, -8.693742999215746e-12,  1.401685070761718e-13, -2.139323961990467e-15,  1.960889593730868e-17,  4.682352558382649e-19, -3.526109277153592e-20,
  1.268048285457311e-21,  5.863023194517692e-07, -6.811663857119034e-09,  6.409728615147587e-11, -1.326181786503159e-13, -1.831942369182761e-14,  8.046188196646624e-16,
 -2.536203138514080e-17,  6.559368498403671e-19, -1.285352436717146e-20,  1.074575787165497e-22,  5.281287528586329e-24, -3.478884390582626e-25,  9.234979531691773e-05,
 -1.144833936226531e-06,  1.327969457753018e-08, -1.283208744188895e-10,  4.317511997702860e-13,  2.867144583920989e-14, -1.254423278366419e-15,  3.476371546120350e-17,
 -6.568835355163603e-19,  3.022059823399103e-21,  4.111596618210606e-22, -2.282125609964256e-23,  1.961074382825118e-03, -2.503746774441741e-05,  3.127562286243545e-07,
 -3.720037527052699e-09,  3.880149507932507e-11, -2.408804846241415e-13, -3.594151090929510e-15,  1.849974794791724e-16, -3.814284091054743e-18,  1.561096504032979e-21,
  3.573375009313890e-21, -1.820981583541518e-22,  1.035219924033181e-02, -1.342229578616652e-04,  1.735978325923537e-06, -2.233159177560223e-08,  2.837585894437376e-10,
 -3.506632203986506e-12,  4.092659197985877e-14, -4.375804334776019e-16,  4.820358021959854e-18, -1.008474604909334e-19,  3.953513463126227e-21, -1.485272495588062e-22,
  1.358586925018010e-02, -1.774527487192439e-04,  2.331510149420424e-06, -3.097849571619577e-08,  4.209725797941025e-10, -5.969498075568143e-12,  9.016269333849926e-14,
 -1.428175755255714e-15,  2.112528113195284e-17, -1.839705189955744e-19, -4.284348286839150e-21,  3.059721142848957e-22,  5.600654827345179e-07, -6.309198174634781e-09,
  6.118629149018696e-11, -3.245983794461467e-13, -7.047900400552318e-15,  3.743024091947662e-16, -1.201224749232674e-17,  3.258819021501466e-19, -7.624818687586016e-21,
  1.412525763382332e-22, -1.377356553619095e-24, -3.395148015328157e-26,  8.797339396663119e-05, -1.044603915616507e-06,  1.179572252452808e-08, -1.181708898694707e-10,
  7.714001777113682e-13,  8.046206234121368e-15, -5.450414990137944e-16,  1.722378210546048e-17, -4.165095416163584e-19,  7.413805288582724e-21, -5.066674013715809e-23,
 -2.917496003410347e-24,  1.865660276836907e-03, -2.270381453725976e-05,  2.716707899648249e-07, -3.140920410603623e-09,  3.347237837938736e-11, -2.780438888780514e-13,
  1.208210380978438e-17,  7.986863774196340e-17, -2.513221676829548e-18,  4.676111486153999e-20, -2.068571389344294e-22, -2.602954313707383e-23,  9.841488210056235e-03,
 -1.213348682045393e-04,  1.493087842281052e-06, -1.830303374573396e-08,  2.225348726690226e-10, -2.656510944436195e-12,  3.044722134390490e-14, -3.205848585984171e-16,
  2.915546154327583e-18, -2.621197136148303e-20,  6.278426225676864e-22, -2.898529205165511e-23,  1.291115862882497e-02, -1.601815027709292e-04,  1.996588519246194e-06,
 -2.509278965388298e-08,  3.203487624554147e-10, -4.215861946383466e-12,  5.852226671895089e-14, -8.721500282817802e-16,  1.359669746495381e-17, -1.964414091570465e-19,
  1.719832141098942e-21,  3.203489044518010e-23,  5.357809333492397e-07, -5.836724837474458e-09,  5.681821817210373e-11, -3.904779378124570e-13, -1.829772150111436e-15,
  1.722101885988798e-16, -5.623801834626427e-18,  1.512527544220035e-19, -3.666621801799323e-21,  7.901653064645228e-23, -1.397764390477983e-24,  1.514920415587324e-26,
  8.397503627636068e-05, -9.556921901745564e-07,  1.045512384862290e-08, -1.051119680435107e-10,  8.337759435655913e-13, -5.251769354404807e-16, -2.129431868075134e-16,
  7.631403757249444e-18, -2.014202439468408e-19,  4.407798711739853e-21, -7.499416075742418e-23,  6.427038015640589e-25,  1.778965341588772e-03, -2.067252725722685e-05,
  2.370113611045875e-07, -2.649217737259723e-09,  2.805483999832392e-11, -2.585458369693908e-13,  1.355646588246182e-15,  2.342003605788110e-17, -1.127560987068433e-18,
  2.855661139220752e-20, -4.981088248930706e-22,  3.521679944409005e-24,  9.378727549227148e-03, -1.102119759649579e-04,  1.293182192805206e-06, -1.513068650923333e-08,
  1.760361603165346e-10, -2.023697716405150e-12,  2.265896129296868e-14, -2.393019633855432e-16,  2.223096525561640e-18, -1.566742225106147e-20,  8.151442253363907e-23,
 -2.979843268922501e-24,  1.230058612561474e-02, -1.453320638707582e-04,  1.723672524191030e-06, -2.057293133186133e-08,  2.483270606306718e-10, -3.061224630029811e-12,
  3.923337761804698e-14, -5.356449070608677e-16,  7.889775868034664e-18, -1.210819810445719e-19,  1.718545157577928e-21, -1.568921386862488e-23,  5.133130393140789e-07,
 -5.401199330398014e-09,  5.205015506007372e-11, -3.983025711287260e-13,  5.490949142687559e-16,  7.707743619334329e-17, -2.672834285043695e-18,  6.999580319119427e-20,
 -1.662248563052337e-21,  3.676132446089265e-23, -7.382279835103134e-25,  1.254252240644510e-26,  8.031187821604830e-05, -8.768720757122773e-07,  9.272747308457278e-09,
 -9.207202525925754e-11,  7.862616451613591e-13, -3.672538006157375e-15, -6.941014840552435e-17,  3.209166554687586e-18, -8.884471098547450e-20,  2.070572065816489e-21,
 -4.183947680410055e-23,  6.858609888182248e-25,  1.699876344229664e-03, -1.889634856060313e-05,  2.077495554720865e-07, -2.239779377318005e-09,  2.324488269517488e-11,
 -2.213968349488964e-13,  1.635576639612531e-15,  3.261698924810972e-19, -4.095053936021996e-19,  1.279681415189345e-20, -2.834738191876897e-22,  4.717096346841728e-24,
  8.957484399371236e-03, -1.005478043387541e-04,  1.127267606288783e-06, -1.261049231062045e-08,  1.404970216312002e-10, -1.552752170650408e-12,  1.687323972185774e-14,
 -1.767016527455135e-16,  1.702354394734113e-18, -1.340393269270431e-20,  5.434585924451733e-23,  3.795734264915463e-25,  1.174536270075171e-02, -1.324669834947317e-04,
  1.498769258272402e-06, -1.704296724113240e-08,  1.954357034922413e-10, -2.274659214343444e-12,  2.720101490419754e-14, -3.410702066855434e-16,  4.592774372811668e-18,
 -6.684502896685555e-20,  1.008869165496897e-21, -1.411423460207248e-23,  4.925111138374446e-07, -5.003669828149725e-09,  4.736440929727256e-11, -3.800979612119045e-13,
  1.581376306703548e-15,  3.148084722347421e-17, -1.293668384998442e-18,  3.323676575532737e-20, -7.557977614146826e-22,  1.626820621465839e-23, -3.325197628501735e-25,
  6.271395457883555e-27,  7.694605038039614e-05, -8.069017306389698e-07,  8.240718339598327e-09, -8.014440492663483e-11,  7.020251145247995e-13, -4.522685052657050e-15,
 -1.014027218505181e-17,  1.288835496285791e-18, -3.806562479409534e-20,  9.007537798661189e-22, -1.906096751765223e-23,  3.600250958170860e-25,  1.627453219362405e-03,
 -1.733586166141490e-05,  1.829644532895568e-07, -1.901170733221644e-09,  1.920412303592788e-11, -1.831573975580677e-13,  1.517066993265129e-15, -7.228214723352300e-18,
 -1.088302604573096e-19,  4.953673071315889e-21, -1.250464436688462e-22,  2.514310714960293e-24,  8.572422075842981e-03, -9.209897708388221e-05,  9.884715268568295e-07,
 -1.059055461483889e-08,  1.131207752475387e-10, -1.201440504632871e-12,  1.261888841024381e-14, -1.294948936796071e-16,  1.262840963263377e-18, -1.092578973548899e-20,
  6.714107688298896e-23,  8.818726031415303e-26,  1.123825057025916e-02, -1.212449753778110e-04,  1.311620891212549e-06, -1.424744550309482e-08,  1.557745332573376e-10,
 -1.721799966290747e-12,  1.939591472818707e-14, -2.259134445603017e-16,  2.780825748274346e-18, -3.697160584132652e-20,  5.308332824888718e-22, -7.864743617883690e-24,
  4.732260358616524e-07, -4.642530837832603e-09,  4.297111847167293e-11, -3.511725782522294e-13,  1.963770332905664e-15,  9.328659031177067e-18, -6.291554022119660e-19,
  1.631678340326157e-20, -3.546266075418633e-22,  7.254907855354089e-24, -1.437280971473445e-25,  2.738644850247115e-27,  7.384446444616404e-05, -7.446388728689184e-07,
  7.343380394342611e-09, -6.963872470367297e-11,  6.114596739614717e-13, -4.445261508039878e-15,  1.287724778323798e-17,  4.690448577163549e-19, -1.619543038250975e-20,
  3.857490476761331e-22, -8.147048228380560e-24,  1.590646774108454e-25,  1.560899738076342e-03, -1.595844461946770e-05,  1.618793234418560e-07, -1.621305775595325e-09,
  1.588723285202074e-11, -1.494349590341164e-13,  1.286947450623481e-15, -8.637305364781093e-18,  1.519393094809924e-21,  1.672382209540855e-21, -4.939432433567428e-23,
  1.085167396830627e-24,  8.219077988062359e-03, -8.467050772440744e-05,  8.715016369145325e-07, -8.957552769040376e-09,  9.184892936927482e-11, -9.378758907637563e-13,
  9.503356090183864e-15, -9.485876401908281e-17,  9.176792351742087e-19, -8.280517038749379e-21,  6.271673809996871e-23, -2.410036658368421e-25,  1.077323035887198e-02,
 -1.113959777664516e-04,  1.154545968071273e-06, -1.200723291308841e-08,  1.255284152875927e-10, -1.323247960987921e-12,  1.414176964450757e-14, -1.547180477192644e-16,
  1.761125366204278e-18, -2.132610859014032e-20,  2.798276224697851e-22, -3.953111612036674e-24,  4.553175281981329e-07, -4.315074491769202e-09,  3.894944378009257e-11,
 -3.189450781695059e-13,  2.030621814973420e-15, -1.364150631249422e-18, -2.986198817968099e-19,  8.237729655429784e-21, -1.732320772003607e-22,  3.350827516898523e-24,
 -6.286946984318278e-26,  1.157556848436382e-27,  7.097833655009237e-05, -6.890748007702188e-07,  6.563546330638991e-09, -6.054626346238167e-11,  5.264533536068200e-13,
 -4.026289004390261e-15,  2.046305008377872e-17,  1.216847666001157e-19, -6.798473254146248e-21,  1.669274197578272e-22, -3.459958648272035e-24,  6.671227109275807e-26,
  1.499538624003853e-03, -1.473712802566546e-05,  1.438554143618813e-07, -1.389422997229543e-09,  1.318803307958697e-11, -1.214008344209261e-13,  1.052582290529224e-15,
 -7.928234018658323e-18,  3.545370429570685e-20,  4.171696418442149e-22, -1.809187278273870e-23,  4.297693032107298e-25,  7.893692696058567e-03, -7.810482356482035e-05,
  7.722473138797494e-07, -7.626484382153933e-09,  7.517311932984891e-11, -7.386082555619438e-13,  7.216936157040212e-15, -6.980162797712895e-17,  6.618263286250880e-19,
 -6.019868146017343e-21,  4.979110635147029e-23, -3.156800920801237e-25,  1.034525232724061e-02, -1.027037118772615e-04,  1.021692525029929e-06, -1.019342380659600e-08,
  1.021367383861261e-10, -1.030102290639093e-12,  1.049687744482900e-14, -1.087827640824320e-16,  1.159357981871457e-18, -1.292948316609603e-20,  1.541654072912416e-22,
 -1.993151688299048e-24,  4.386569557692557e-07, -4.018240231499897e-09,  3.531507078174940e-11, -2.869943654595571e-13,  1.947532735039734e-15, -6.293269406777999e-18,
 -1.303957479507211e-19,  4.223515005297412e-21, -8.783932517878854e-23,  1.617361768003963e-24, -2.855560948248481e-26,  4.970815096685963e-28,  6.832264688519874e-05,
 -6.393353978792459e-07,  5.884962014984472e-09, -5.273975332253129e-11,  4.510081299620881e-13, -3.514150027156667e-15,  2.156629586013335e-17, -2.157373852468548e-20,
 -2.704609699922632e-21,  7.331182359788949e-23, -1.499333195324911e-24,  2.800325784520869e-26,  1.442791034088606e-03, -1.364956584629798e-05,  1.283725107519635e-07,
 -1.196539069316987e-09,  1.099536076900270e-11, -9.866486432128559e-14,  8.479201807822623e-16, -6.662301394885799e-18,  4.108489239627612e-20, -2.517097290424927e-23,
 -5.944631862410745e-24,  1.627849462819304e-25,  7.593077205509923e-03, -7.227353389108078e-05,  6.874874062721726e-07, -6.533104799576331e-09,  6.198627517339935e-11,
 -5.866491396348577e-13,  5.528994094678261e-15, -5.173303360926532e-17,  4.776768989224926e-19, -4.298017580608448e-21,  3.661697696222572e-23, -2.737621245192209e-25,
  9.950047122202529e-03, -9.499315650596004e-05,  9.085383782054010e-07, -8.711329740683322e-09,  8.382720729034923e-11, -8.109273938089508e-13,  7.907972884029183e-15,
 -7.809139822394447e-17,  7.868397396255916e-19, -8.189424726252110e-21,  8.963148471590448e-23, -1.052051042797030e-24,  4.231279584715894e-07, -3.748976157776935e-09,
  3.205349465702245e-11, -2.569756882647079e-13,  1.798512416712117e-15, -8.274434919648215e-18, -4.409146074811478e-20,  2.160315324151841e-21, -4.583432189253361e-23,
  8.141207066814710e-25, -1.358484952614094e-26,  2.220994998243488e-28,  6.585562283760998e-05, -5.946696961429004e-07,  5.293152588636021e-09, -4.605811853673154e-11,
  3.858105805629096e-13, -3.011510024253020e-15,  2.007693913066912e-17, -7.542361939578608e-20, -9.021365985659066e-22,  3.225608924547164e-23, -6.680526901766520e-25,
  1.206993353922967e-26,  1.390159827078217e-03, -1.267717198860560e-05,  1.150078924415450e-07, -1.035354764073723e-09,  9.211213473939840e-12, -8.040692767403392e-14,
  6.793873519102346e-16, -5.396392523193246e-18,  3.726540476612027e-20, -1.575786443193268e-22, -1.421376458130119e-24,  5.895571004706197e-26,  7.314509035733206e-03,
 -6.707121059445819e-05,  6.146757224570384e-07, -5.628441609788152e-09,  5.147127556810352e-11, -4.697417257003345e-13,  4.273092165236054e-15, -3.866274641370307e-17,
  3.465870064606205e-19, -3.054669348105294e-21,  2.604233444226579e-23, -2.066888920582652e-25,  9.583979693846429e-03, -8.812136141521478e-05,  8.115461091717062e-07,
 -7.490226314170268e-09,  6.934309352273568e-11, -6.447792675440097e-13,  6.034055831072804e-15, -5.701815607219508e-17,  5.469004415134582e-19, -5.370068265672902e-21,
  5.468953586807155e-23, -5.878674540549867e-25,  4.086260532903160e-07, -3.504406697767489e-09,  2.913684592565633e-11, -2.295629966316851e-13,  1.626587449953325e-15,
 -8.748746810678119e-18, -3.806879929442568e-22,  1.074127434888774e-21, -2.434752606977299e-23,  4.242782601266016e-25, -6.757089050870657e-27,  1.040842768928649e-28,
  6.355827640332554e-05, -5.544347358095407e-07,  4.775588113789044e-09, -4.034157513005271e-11,  3.302148815705968e-13, -2.557356534148717e-15,  1.770397814183898e-17,
 -8.998299620922366e-20, -1.164817696736431e-22,  1.376929872143567e-23, -3.043774479399971e-25,  5.387564495009412e-27,  1.341215961362151e-03, -1.180441713589565e-05,
  1.034175782385615e-07, -9.000035552344322e-10,  7.754561963270603e-12, -6.578559350472880e-14,  5.440769474648184e-16, -4.301493519256805e-18,  3.105672823470748e-20,
 -1.770483726386113e-22,  1.634300909734664e-25,  1.932864601363351e-26,  7.055650110438039e-03, -6.241064937099840e-05,  5.517827314755359e-07, -4.874834520479855e-09,
  4.302036671750068e-11, -3.790197801672331e-13,  3.330610243984553e-15, -2.914707302931811e-17,  2.533470393349602e-19, -2.176444032229020e-21,  1.830066003202215e-23,
 -1.474919020784067e-25,  9.243935125615443e-03, -8.197059358537270e-05,  7.279188616967205e-07, -6.476542474226166e-09,  5.777587807457895e-11, -5.173071267094782e-13,
  4.656238789204110e-15, -4.223373579155920e-17,  3.874908464965373e-19, -3.617580112023619e-21,  3.468367668032503e-23, -3.460665500022001e-25,  3.950577763742616e-07,
 -3.281901778823671e-09,  2.653249106809073e-11, -2.049290875594601e-13,  1.453556009176645e-15, -8.472569545926323e-18,  2.075746496807138e-20,  4.950038314951925e-22,
 -1.301046326279930e-23,  2.269601532817491e-25, -3.490998274200365e-27,  5.107282296586258e-29,  6.141400277150600e-05, -5.180803495171598e-07,  4.321574419564589e-09,
 -3.544508717530034e-11,  2.831121184010105e-13, -2.162732291063290e-15,  1.519239620914596e-17, -8.773074488270937e-20,  2.074823037691422e-22,  5.306574977901814e-24,
 -1.396809477281181e-25,  2.483197831589156e-27,  1.295587425285615e-03, -1.101826301982647e-05,  9.332074602364635e-08, -7.857857869336424e-10,  6.560228447273796e-12,
 -5.406655718579956e-14,  4.366072311909342e-16, -3.407083473107851e-18,  2.495374846864896e-20, -1.589599913474060e-22,  6.345579642924861e-25,  4.496159481156286e-27,
  6.814481343439913e-03, -5.821922724330964e-05,  4.971778674520493e-07, -4.243070580415165e-09,  3.617765677303282e-11, -3.080300921505512e-13,  2.617150802282213e-15,
 -2.216414338172591e-17,  1.867384502429551e-19, -1.560041008468596e-21,  1.284374105854250e-23, -1.029364695720897e-25,  8.927228432460169e-03, -7.644315044973706e-05,
  6.554240404664012e-07, -5.629204139078930e-09,  4.845821016558177e-11, -4.184582110018451e-13,  3.629462160257438e-15, -3.167697824821016e-17,  2.789797385419647e-19,
 -2.489903750002451e-21,  2.266721659874082e-23, -2.125087138038844e-25,  3.823396559382010e-07, -3.079095761428366e-09,  2.420739020980714e-11, -1.829967807601997e-13,
  1.289994786771827e-15, -7.848430434317435e-18,  2.984776824857945e-20,  1.862938703131712e-22, -6.893639171604416e-24,  1.235678491455062e-25, -1.859029608829163e-27,
  2.607759505798943e-29,  5.940823727561371e-05, -4.851352745768363e-07,  3.922046660880531e-09, -3.124233934121999e-11,  2.433091758396276e-13, -1.826699353661935e-15,
  1.285101053247048e-17, -7.892856990485588e-20,  3.199333109818473e-22,  1.443227080961858e-24, -6.295350012765015e-26,  1.170340098823521e-27,  1.252950200671929e-03,
 -1.030770902417184e-05,  8.448717395128347e-08, -6.889343230790500e-10,  5.576400332794278e-12, -4.464763628097921e-14,  3.515644113389196e-16, -2.694965876957139e-18,
  1.971697127670647e-20, -1.315909791083933e-22,  6.962147369183826e-25, -7.620162375668370e-28,  6.589250108618776e-03, -5.443607840258229e-05,  4.495412818492040e-07,
 -3.710299607766972e-09,  3.059818464223389e-11, -2.520389347862222e-13,  2.072429361341306e-15, -1.699617954703481e-17,  1.388266189254253e-19, -1.126754601034187e-21,
  9.049981176548369e-24, -7.138492884421838e-26,  8.631532602148306e-03, -7.145738602616896e-05,  5.922639449138236e-07, -4.916377689721502e-09,  4.089315700046132e-11,
 -3.410627835750158e-13,  2.855163990316752e-15, -2.402550231382262e-17,  2.036509066163155e-19, -1.744404286116140e-21,  1.517045622656633e-23, -1.348703677754296e-25,
  3.703971633375513e-07, -2.893881276236206e-09,  2.213021832486527e-11, -1.635723184977996e-13,  1.140499066478341e-15, -7.090768887946078e-18,  3.255374013059394e-20,
  2.449753932096917e-23, -3.547071124297362e-24,  6.790567398316179e-26, -1.013101826081156e-27,  1.375645612640915e-29,  5.752816440880855e-05, -4.551950248358808e-07,
  3.569342928807518e-09, -2.762563683078111e-11,  2.096865479321823e-13, -1.543605352389939e-15,  1.078920224603133e-17, -6.825823907155142e-20,  3.369547925222137e-22,
 -2.594831560483550e-25, -2.661533962393941e-26,  5.560689213475908e-28,  1.213020855816340e-03, -9.663428707486571e-06,  7.672724694222757e-08, -6.064215271241292e-10,
  4.762061471476079e-12, -3.704848986665848e-14,  2.842641336910034e-16, -2.134550845205264e-18,  1.546689421604586e-20, -1.050361364814502e-22,  6.203426735699558e-25,
 -2.331090814025589e-27,  6.378427738544010e-03, -5.100988613252044e-05,  4.077970991628186e-07, -3.258505663919869e-09,  2.601868563229413e-11, -2.075444759221307e-13,
  1.653097331427062e-15, -1.313858395072599e-17,  1.040875018917885e-19, -8.205542520504748e-22,  6.418593236593132e-24, -4.956868385412146e-26,  8.354820685087215e-03,
 -6.694463296793710e-05,  5.369795198838379e-07, -4.313150267475180e-09,  3.470622481873776e-11, -2.799291229294778e-13,  2.265017348106356e-15, -1.840697873447893e-17,
  1.504893093582633e-19, -1.240762174023527e-21,  1.035264999172386e-23, -8.785398472765078e-26,  1.998029997818709e+00,  1.488414188045987e-03, -6.632091422073609e-04,
  2.032795485781077e-04, -5.445240292058950e-05,  1.361608558499202e-05, -3.268241629115482e-06,  7.640198364775631e-07, -1.754462381782981e-07,  3.979142116300006e-08,
 -8.928549170865606e-09,  1.902428032421261e-09,  2.000726519872604e+00, -2.714375999024091e-04, -1.405529946356748e-04,  6.414135064163591e-05, -1.956229397478332e-05,
  5.186627848358192e-06, -1.281819705738645e-06,  3.040157477649564e-07, -7.024837749458923e-08,  1.595385888006500e-08, -3.574198798003658e-09,  7.593449670442823e-10,
  2.002261655187036e+00, -1.266390831115207e-03,  1.464335993071725e-04, -1.010846943534596e-05, -1.450419731101551e-06,  9.253570027991981e-07, -3.027911022334905e-07,
  8.270157430961338e-08, -2.077762385968936e-08,  4.981456755175925e-09, -1.158007104567574e-09,  2.521975141628988e-10,  2.003167063595962e+00, -1.850844524244841e-03,
  3.121356545795949e-04, -5.227258221742982e-05,  8.673091791644892e-06, -1.421051633410042e-06,  2.287768061868591e-07, -3.590096173552126e-08,  5.415919711553690e-09,
 -7.645192987776691e-10,  9.484375099293577e-11, -8.622109673384972e-12,  2.003628128667262e+00, -2.147795334082043e-03,  3.955074468385037e-04, -7.328963782618711e-05,
  1.367485539525546e-05, -2.570809395021039e-06,  4.872613929579909e-07, -9.316955634279688e-08,  1.798330883090422e-08, -3.505655848660117e-09,  6.895238806905538e-10,
 -1.319190640646268e-10,  2.000564651339451e+00, -2.745256606765537e-04, -2.002411536848521e-05,  1.642515894375075e-05, -5.327830577837105e-06,  1.398359804880267e-06,
 -3.332470027040398e-07,  7.514432907137633e-08, -1.634914155045179e-08,  3.469255328608659e-09, -7.216956597050031e-10,  1.424584316567128e-10,  2.001094450090660e+00,
 -6.138672505110528e-04,  7.287894128259311e-05, -6.316229332959528e-06, -9.553626368772523e-08,  2.409754785354496e-07, -8.409472114019528e-08,  2.256260487057461e-08,
 -5.418400280809946e-09,  1.223823217323027e-09, -2.654666462151615e-10,  5.388211241538346e-11,  2.001412150134772e+00, -8.166951662437923e-04,  1.276032783930527e-04,
 -1.951854111300372e-05,  2.898624198148521e-06, -4.119956150678697e-07,  5.451896589566260e-08, -6.290807325473850e-09,  4.990257484337343e-10,  2.430101814467790e-11,
 -2.489120111726783e-11,  7.725689537097787e-12,  2.001605323708522e+00, -9.397792348333711e-04,  1.605176856827566e-04, -2.738933577957024e-05,  4.668187132731697e-06,
 -7.946238083413038e-07,  1.350672619266846e-07, -2.292084930118131e-08,  3.882449057689934e-09, -6.562233538096002e-10,  1.105655391962444e-10, -1.808474343922097e-11,
  2.001705403034152e+00, -1.003474329342615e-03,  1.774631492274863e-04, -3.142090088631885e-05,  5.570068294987936e-06, -9.886834765752238e-07,  1.757246882382699e-07,
 -3.127600493980828e-08,  5.574640308972939e-09, -9.950869338868033e-10,  1.777294272308817e-10, -3.083324829059566e-11,  2.000569790167517e+00, -3.220985665955205e-04,
  4.145873697587212e-05, -4.597777785116477e-06,  3.307348545933364e-07,  2.665075024716792e-08, -1.974730570475567e-08,  6.148186160520518e-09, -1.556688724998776e-09,
  3.582695528916860e-10, -7.791195520112319e-11,  1.572485855271535e-11,  2.000688455395605e+00, -3.974904683401727e-04,  6.135294421579349e-05, -9.288733851808438e-06,
  1.369955020064951e-06, -1.946141473673865e-07,  2.608542468262925e-08, -3.156019560430056e-09,  3.031869252880301e-10, -8.997611070726477e-12, -6.189594220326221e-12,
  2.308505322691656e-12,  2.000761330070172e+00, -4.437170242562747e-04,  7.346258786401026e-05, -1.212333872430461e-05,  1.993365213200423e-06, -3.263881370225594e-07,
  5.318500028461829e-08, -8.618073770386440e-09,  1.387293316419049e-09, -2.215686707087726e-10,  3.503414791225739e-11, -5.353047646698277e-12,  2.000806286808364e+00,
 -4.722066507142422e-04,  8.089225194197710e-05, -1.385462821012428e-05,  2.372417949713173e-06, -4.061540961331954e-07,  6.951657695572098e-08, -1.189537237437435e-08,
  2.034948210251366e-09, -3.480149070672812e-10,  5.945191172989172e-11, -9.873352855893672e-12,  2.000829773277563e+00, -4.870818833224845e-04,  8.476130728411467e-05,
 -1.475384337685211e-05,  2.568780392988650e-06, -4.473686401617823e-07,  7.793334944452776e-08, -1.358009795759391e-08,  2.367044525317747e-09, -4.126912849317532e-10,
  7.191087737142822e-11, -1.217458010787816e-11,  2.000347390892260e+00, -2.008304785267321e-04,  3.131916405420361e-05, -4.818649896901719e-06,  7.286467844068986e-07,
 -1.076734368627876e-07,  1.540842458873335e-08, -2.101903624276531e-09,  2.648934827970527e-10, -2.853472432953647e-11,  1.916354828016553e-12,  1.623900562337530e-13,
  2.000375532844992e+00, -2.186419830447137e-04,  3.593695044435071e-05, -5.888221662897651e-06,  9.613741175250243e-07, -1.563373126550851e-07,  2.530745667737570e-08,
 -4.075189738426488e-09,  6.522051271687312e-10, -1.036276818335187e-10,  1.631503262003062e-11, -2.485189696015408e-12,  2.000393014271316e+00, -2.296976584812406e-04,
  3.879283128596806e-05, -6.547284598808431e-06,  1.104254920381054e-06, -1.861049814996885e-07,  3.134063344942960e-08, -5.273482236924935e-09,  8.865511035595233e-10,
 -1.488992605488660e-10,  2.496452527805930e-11, -4.070311749427332e-12,  2.000403875134169e+00, -2.365630073467601e-04,  4.056226286300689e-05, -6.954694014151912e-06,
  1.192377797809445e-06, -2.044227437238664e-07,  3.504479174625931e-08, -6.007532470078518e-09,  1.029784315108092e-09, -1.765075423404868e-10,  3.022760887335861e-11,
 -5.032839134190906e-12,  2.000409572502193e+00, -2.401633988138458e-04,  4.148897557819789e-05, -7.167784228949583e-06,  1.238407968631567e-06, -2.139781550305035e-07,
  3.697450006798644e-08, -6.389437575964014e-09,  1.104206689498723e-09, -1.908337771650830e-10,  3.295514835720240e-11, -5.531057733877523e-12,  2.000188292557528e+00,
 -1.096618352528127e-04,  1.806657994483090e-05, -2.969371473570845e-06,  4.867569398698332e-07, -7.955939712033069e-08,  1.296142339020457e-08, -2.103864760257387e-09,
  3.400737197070893e-10, -5.470826920862884e-11,  8.747691545470974e-12, -1.357125490506872e-12,  2.000195148382240e+00, -1.139929820246338e-04,  1.917978487073501e-05,
 -3.224966833106937e-06,  5.418851737613905e-07, -9.098569110670307e-08,  1.526527534621680e-08, -2.559070281076557e-09,  4.286315362883422e-10, -7.172628811639791e-11,
  1.198204175862006e-11, -1.946929644361280e-12,  2.000199431097287e+00, -1.166975298826714e-04,  1.987365532379079e-05, -3.383990254258389e-06,  5.761213416326797e-07,
 -9.806872143732896e-08,  1.669078878409490e-08, -2.840213790038302e-09,  4.832264511089306e-10, -8.219854531538681e-11,  1.396872647310135e-11, -2.308598495723158e-12,
  2.000202101172221e+00, -1.183832839337295e-04,  2.030565654343090e-05, -3.482884440657993e-06,  5.973878856359923e-07, -1.024634594941374e-07,  1.757425060642104e-08,
 -3.014253274892190e-09,  5.169843949901379e-10, -8.866653253703045e-11,  1.519437495423239e-11, -2.531487142123939e-12,  2.000203504698614e+00, -1.192692762778390e-04,
  2.053255504498235e-05, -3.534791457756396e-06,  6.085426493601482e-07, -1.047670468101446e-07,  1.803702363190405e-08, -3.105357196893644e-09,  5.346437505965649e-10,
 -9.204779009348617e-11,  1.583468030427300e-11, -2.647856825213525e-12,  2.000097675078315e+00, -5.706090097235227e-05,  9.607327451634963e-06, -1.616759326548051e-06,
  2.719296561738062e-07, -4.571145501787072e-08,  7.679603980687832e-09, -1.289392195887864e-09,  2.163463499969121e-10, -3.627511047990977e-11,  6.073434639084858e-12,
 -9.891964283184800e-13,  2.000099367214870e+00, -5.812892933026492e-05,  9.880660361718646e-06, -1.679246339047490e-06,  2.853487529920443e-07, -4.848070782250042e-08,
  8.235529675632405e-09, -1.398755676237069e-09,  2.375295895991923e-10, -4.032808482764504e-11,  6.840368605375577e-12, -1.128480886560433e-12,  2.000100427204651e+00,
 -5.879783598809513e-05,  1.005169363204227e-05, -1.718310702338191e-06,  2.937301287122013e-07, -5.020875335468185e-08,  8.582114660824254e-09, -1.466874286413118e-09,
  2.507117452432072e-10, -4.284790065173273e-11,  7.316751056000296e-12, -1.214923592337611e-12,  2.000101089207690e+00, -5.921554278596043e-05,  1.015843674605508e-05,
 -1.742677084066613e-06,  2.989550033880612e-07, -5.128538161042795e-08,  8.797924045158527e-09, -1.509265556111163e-09,  2.589104884647317e-10, -4.441421916667329e-11,
  7.612701323310044e-12, -1.268596946019941e-12,  2.000101437544330e+00, -5.943531867293688e-05,  1.021458076768252e-05, -1.755488837157895e-06,  3.017012961859440e-07,
 -5.185108664874523e-08,  8.911280931643597e-09, -1.531524644745588e-09,  2.632140865790139e-10, -4.523611755076263e-11,  7.767944014126245e-12, -1.296742820789317e-12,
  2.000049705140404e+00, -2.907806908570409e-05,  4.943844437224344e-06, -8.404513886173834e-07,  1.428590722922401e-07, -2.428003410163798e-08,  4.126062243662920e-09,
 -7.010774526116964e-10,  1.191073004740407e-10, -2.023214993523489e-11,  3.433561578432500e-12, -5.667536870934878e-13,  2.000050125485765e+00, -2.934325908018009e-05,
  5.011567873955736e-06, -8.559004274626056e-07,  1.461695919909091e-07, -2.496173646240961e-08,  4.262617066302093e-09, -7.278827024057717e-10,  1.242880965267814e-10,
 -2.122123629624590e-11,  3.620319122818867e-12, -6.006023152493578e-13,  2.000050389163260e+00, -2.950959354704159e-05,  5.054026616019857e-06, -8.655816617374246e-07,
  1.482431961342279e-07, -2.538853661146365e-08,  4.348071922145774e-09, -7.446494736034498e-10,  1.275272083295445e-10, -2.183934317703654e-11,  3.736975458678564e-12,
 -6.217364523252106e-13,  2.000050553982271e+00, -2.961355931647254e-05,  5.080557504807239e-06, -8.716293694069043e-07,  1.495381695675705e-07, -2.565499802414253e-08,
  4.401408013322493e-09, -7.551113244571444e-10,  1.295477121556259e-10, -2.222479669911324e-11,  3.809701850432404e-12, -6.349084397375543e-13,  2.000050640751776e+00,
 -2.966829050108822e-05,  5.094521952952484e-06, -8.748120245894323e-07,  1.502195446122357e-07, -2.579517805458749e-08,  4.429462312491834e-09, -7.606132304726528e-10,
  1.306101186837619e-10, -2.242743872350080e-11,  3.847929387568261e-12, -6.418310032767340e-13,  2.000025067673596e+00, -1.467472453891492e-05,  2.506559450574782e-06,
 -4.281280167796643e-07,  7.312346143540485e-08, -1.248898516128680e-08,  2.132969937537065e-09, -3.642749826361118e-10,  6.221005047722077e-11, -1.062351805856116e-11,
  1.812652769868906e-12, -3.007629459088495e-13,  2.000025172426219e+00, -1.474079660400301e-05,  2.523414776032895e-06, -4.319689175181802e-07,  7.394562762632296e-08,
 -1.265810291007427e-08,  2.166810054860752e-09, -3.709104993378683e-10,  6.349114506975939e-11, -1.086783221400363e-11,  1.858734007284835e-12, -3.091064346834914e-13,
  2.000025238181596e+00, -1.478226940982761e-05,  2.533992304458320e-06, -4.343787158582186e-07,  7.446133983192678e-08, -1.276415933495386e-08,  2.188026838940128e-09,
 -3.750698189448427e-10,  6.429398426669207e-11, -1.102090424066697e-11,  1.887599009107948e-12, -3.143316189268533e-13,  2.000025279301606e+00, -1.480820357685518e-05,
  2.540605804290985e-06, -4.358852032705869e-07,  7.478369129242326e-08, -1.283044147625660e-08,  2.201284788486751e-09, -3.776685200265969e-10,  6.479551761570686e-11,
 -1.111651445768691e-11,  1.905625763929873e-12, -3.175944076756032e-13,  2.000025300954864e+00, -1.482185992786050e-05,  2.544088034245773e-06, -4.366783526504004e-07,
  7.495339149809003e-08, -1.286533239756852e-08,  2.208263181383994e-09, -3.790362441742420e-10,  6.505945756476447e-11, -1.116682659268469e-11,  1.915111024898905e-12,
 -3.193110754889023e-13,  2.000012587389749e+00, -7.371134166134131e-06,  1.261888538879495e-06, -2.160253045186927e-07,  3.698155684992183e-08, -6.330859447881208e-09,
  1.083769823033891e-09, -1.855275082934686e-10,  3.175968126140015e-11, -5.436639205029331e-12,  9.298870320926415e-13, -1.546485002291887e-13,  2.000012613536338e+00,
 -7.387624108822480e-06,  1.266092971263740e-06, -2.169828740748979e-07,  3.718641963548361e-08, -6.372976546727039e-09,  1.092192820559572e-09, -1.871782341473335e-10,
  3.207820858159405e-11, -5.497351880481750e-12,  9.413321707913117e-13, -1.567197158170531e-13,  2.000012629954744e+00, -7.397978503204077e-06,  1.268732726696371e-06,
 -2.175840158754235e-07,  3.731501335381890e-08, -6.399410682480902e-09,  1.097478773295020e-09, -1.882140473896683e-10,  3.227805808709788e-11, -5.535439659212255e-12,
  9.485113934657402e-13, -1.580187927172553e-13,  2.000012640224183e+00, -7.404454906699653e-06,  1.270383707465177e-06, -2.179599606669210e-07,  3.739542808229274e-08,
 -6.415939797560475e-09,  1.100783810648550e-09, -1.888616418814991e-10,  3.240299574052744e-11, -5.559248842159112e-12,  9.529988988248777e-13, -1.588307497929979e-13,
  2.000012645632621e+00, -7.407865698316151e-06,  1.271253158572125e-06, -2.181579350080601e-07,  3.743777307345769e-08, -6.424643371602045e-09,  1.102524037864797e-09,
 -1.892026103971836e-10,  3.246877455167772e-11, -5.571783679714763e-12,  9.553613389895344e-13, -1.592581863566786e-13,  2.000006307055357e+00, -3.693991308146059e-06,
  6.330901919183776e-07, -1.085012010309339e-07,  1.859528110151065e-08, -3.186912872182729e-09,  5.461813550982362e-10, -9.360580402449411e-11,  1.604233624527722e-11,
 -2.749294836087020e-12,  4.707833736496221e-13, -7.838119783854070e-14,  2.000006313586817e+00, -3.698110291194288e-06,  6.341401278005576e-07, -1.087402623519512e-07,
  1.864641221385737e-08, -3.197421925493020e-09,  5.482824936046426e-10, -9.401747073396373e-11,  1.612175082056243e-11, -2.764427508288200e-12,  4.736353144554745e-13,
 -7.889718059960967e-14,  2.000006317688868e+00, -3.700697166663180e-06,  6.347994894424257e-07, -1.088903847018471e-07,  1.867851896187555e-08, -3.204020493008462e-09,
  5.496017090109111e-10, -9.427592382273029e-11,  1.617160609736601e-11, -2.773927024160704e-12,  4.754255137878117e-13, -7.922105204580134e-14,  2.000006320254909e+00,
 -3.702315376571858e-06,  6.352119358966132e-07, -1.089842864459531e-07,  1.869860105478944e-08, -3.208147608613618e-09,  5.504267907659568e-10, -9.443756324343448e-11,
  1.620278501058787e-11, -2.779867696456604e-12,  4.765450028640654e-13, -7.942357602292319e-14,  2.000006321606410e+00, -3.703167663051290e-06,  6.354291606170256e-07,
 -1.090337409865100e-07,  1.870917731893168e-08, -3.210321114080321e-09,  5.508613028534855e-10, -9.452268546194787e-11,  1.621920403649522e-11, -2.782996028021709e-12,
  4.771345083407663e-13, -7.953021987051662e-14,  2.000003156864336e+00, -1.849099371449485e-06,  3.170807933847586e-07, -5.437251644106547e-08,  9.323709676804993e-09,
 -1.598813703382938e-09,  2.741617052981259e-10, -4.701273587947894e-11,  8.061646727695532e-12, -1.382360796233096e-12,  2.368454011976060e-13, -3.945361763697634e-14,
  2.000003158496553e+00, -1.850128679793620e-06,  3.173431309943517e-07, -5.443224044301498e-08,  9.336481898164532e-09, -1.601438443451525e-09,  2.746864146925166e-10,
 -4.711552598719665e-11,  8.081473279154926e-12, -1.386138291898008e-12,  2.375572216779256e-13, -3.958238636534078e-14,  2.000003159521747e+00, -1.850775183442078e-06,
  3.175078993225056e-07, -5.446975066620496e-08,  9.344503381833890e-09, -1.603086841389670e-09,  2.750159349223467e-10, -4.718007684752285e-11,  8.093923738121883e-12,
 -1.388510373468164e-12,  2.380041970961064e-13, -3.966324229162715e-14,  2.000003160163093e+00, -1.851179624630789e-06,  3.176109736272099e-07, -5.449321555666710e-08,
  9.349521209707743e-09, -1.604117975790563e-09,  2.752220583918599e-10, -4.722045435815724e-11,  8.101711542005206e-12, -1.389994091597616e-12,  2.382837716201185e-13,
 -3.971381526264058e-14,  2.000003160500892e+00, -1.851392644859504e-06,  3.176652625653282e-07, -5.450557431625011e-08,  9.352164029275822e-09, -1.604661054056317e-09,
  2.753306184275488e-10, -4.724171994918939e-11,  8.105813094794423e-12, -1.390775503611409e-12,  2.384310102186209e-13, -3.974044937540323e-14,   0.00204639784015061,
   0.00156334924253362,  0.000297702132583106,  1.41505037258925e-05,  9.14754695637325e-08,   0.00102108340635466,   0.00078016424390154,  0.000148602415231521,
  7.06649056423632e-06,  4.57142720804553e-08,  0.000510029330668796,  0.000389702956805954,   7.4233480611183e-05,  3.53037172208382e-06,  2.28422126210565e-08,
  0.000254888469162556,  0.000194756543035426,   3.7099197098835e-05,  1.76439297557367e-06,  1.14164082545875e-08,   0.00012741291342033,  9.73545225171944e-05,
  1.85451409461051e-05,  8.81989552633122e-07,  5.70691764052092e-09,  6.36986543592304e-05,  4.86713222806421e-05,  9.27144736948027e-06,  4.40941988420234e-07,
  2.85312372259985e-09,  3.18473800510903e-05,  2.43341761899647e-05,  4.63544183753784e-06,  2.20457667600995e-07,  1.42647643384177e-09,  1.59232036737676e-05,
  1.21667168322819e-05,  2.31765032407309e-06,  1.10225486074861e-07,  7.13216655358985e-10,  7.96148030260647e-06,  6.08326559736546e-06,  1.15880749681387e-06,
  5.51119041049794e-08,  3.56602911821654e-10,  3.98070977443438e-06,  3.04160959360372e-06,  5.79399330036612e-07,  2.75557420697527e-08,  1.78300098770403e-10,
  1.99034729383704e-06,  1.52079899548411e-06,  2.89698560167889e-07,  1.37778185080207e-08,  8.91497097035653e-11  };
  int offset = -5;
  const int ibox0 = static_cast<int>(log(64.0) / log(2.0));
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 5;
    if (std::isnan(t)) {
      fill_n(rr+offset, 5, 0.5);
      fill_n(ww+offset, 5, 0.0);
    } else if (t >= 131072.0) {
      for (int r = 0; r != 5; ++r) {
        ww[offset+r] = aw[5-r-1] / t;
        rr[offset+r] = 1.0 - ax[5-r-1] / t;
      }
    } else {
      assert(t >= 0);
      int it;
      double bigT = 0.0;
      if (t >= 64.0 && t < 131072.0) {
        bigT = t;
        it = static_cast<int>(log(bigT) / log(2.0) + 32 - ibox0);
        t = (t - 1.5 * pow(2.0, it + ibox0 - 32))* 2/pow(2.0, it + ibox0 - 32);
      } else {
        it = static_cast<int>(t*   0.500000000000000);
        t = (t - it *2.000000000000000-   1.000000000000000) *   1.000000000000000;
      }
      const double t2 = t * 2.0;
      for (int j=1; j <=5; ++j) {
        const int boxof = it*60+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
        if (64.0 <= bigT && bigT < 131072.0) {
          const int iref = 2580 + (it - 32) * 5 + 5 - j;
          double rr_infty = x[iref];
          double ww_infty = w[iref];
          double Tref = pow(2.0, it + ibox0 + 1 - 32);
          ww[offset+j-1] = ww[offset+j-1] * ww_infty * Tref / bigT;
          rr[offset+j-1] = 1.0 + rr[offset+j-1] * (1.0 - rr_infty) * Tref /bigT;
        }
      }
    }
  }
}
