/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.dff;

import com.kreative.ksfl.KSFLUtilities;
import java.util.Arrays;

public class DFFResource {
    public long type;
    public int id;
    public short datatype;
    public String name;
    public boolean readonly;
    public boolean system;
    public boolean preload;
    public boolean purgeable;
    public boolean fromfile;
    public boolean fromrsrc;
    public boolean invisible;
    public boolean disabled;
    public boolean protect;
    public boolean fixed;
    public boolean multilingual;
    public boolean compressed;
    public boolean appuse1;
    public boolean appuse2;
    public boolean appuse3;
    public boolean appuse4;
    public byte[] data;
    public static final short DATA_TYPE_BINARY = 0;
    public static final short DATA_TYPE_PLAINTEXT = 1;
    public static final short DATA_TYPE_MACTEXT = 2;
    public static final short DATA_TYPE_DFFTEXT = 3;
    public static final short DATA_TYPE_IMAGE = 4;
    public static final short DATA_TYPE_DFFIMAGE = 5;
    public static final short DATA_TYPE_SOUND = 6;
    public static final short DATA_TYPE_PSTRINGLIST = 7;
    public static final short DATA_TYPE_WSTRINGLIST = 8;
    public static final short DATA_TYPE_LSTRINGLIST = 9;
    public static final short DATA_TYPE_CSTRINGLIST = 10;

    public static boolean isMyType(long type) {
        return true;
    }

    public DFFResource(long type, int id, byte[] data) {
        this.type = type;
        this.id = id;
        this.datatype = 0;
        this.name = "";
        this.data = data;
        this.readonly = false;
        this.system = false;
        this.preload = false;
        this.purgeable = false;
        this.fromfile = false;
        this.fromrsrc = false;
        this.invisible = false;
        this.disabled = false;
        this.protect = false;
        this.fixed = false;
        this.multilingual = false;
        this.compressed = false;
        this.appuse1 = false;
        this.appuse2 = false;
        this.appuse3 = false;
        this.appuse4 = false;
    }

    public DFFResource(long type, int id, String name, byte[] data) {
        this.type = type;
        this.id = id;
        this.datatype = 0;
        this.name = name;
        this.data = data;
        this.readonly = false;
        this.system = false;
        this.preload = false;
        this.purgeable = false;
        this.fromfile = false;
        this.fromrsrc = false;
        this.invisible = false;
        this.disabled = false;
        this.protect = false;
        this.fixed = false;
        this.multilingual = false;
        this.compressed = false;
        this.appuse1 = false;
        this.appuse2 = false;
        this.appuse3 = false;
        this.appuse4 = false;
    }

    public DFFResource(long type, int id, short attr, byte[] data) {
        this.type = type;
        this.id = id;
        this.datatype = 0;
        this.name = "";
        this.data = data;
        this.setAttributes(attr);
    }

    public DFFResource(long type, int id, short attr, String name, byte[] data) {
        this.type = type;
        this.id = id;
        this.datatype = 0;
        this.name = name;
        this.data = data;
        this.setAttributes(attr);
    }

    public DFFResource(long type, int id, short dtype, short attr, byte[] data) {
        this.type = type;
        this.id = id;
        this.datatype = dtype;
        this.name = "";
        this.data = data;
        this.setAttributes(attr);
    }

    public DFFResource(long type, int id, short dtype, short attr, String name, byte[] data) {
        this.type = type;
        this.id = id;
        this.datatype = dtype;
        this.name = name;
        this.data = data;
        this.setAttributes(attr);
    }

    public short getAttributes() {
        short a = 0;
        if (this.readonly) {
            a = (short)(a | 1);
        }
        if (this.system) {
            a = (short)(a | 2);
        }
        if (this.preload) {
            a = (short)(a | 4);
        }
        if (this.purgeable) {
            a = (short)(a | 8);
        }
        if (this.fromfile) {
            a = (short)(a | 0x10);
        }
        if (this.fromrsrc) {
            a = (short)(a | 0x20);
        }
        if (this.invisible) {
            a = (short)(a | 0x40);
        }
        if (this.disabled) {
            a = (short)(a | 0x80);
        }
        if (this.protect) {
            a = (short)(a | 0x100);
        }
        if (this.fixed) {
            a = (short)(a | 0x200);
        }
        if (this.multilingual) {
            a = (short)(a | 0x400);
        }
        if (this.compressed) {
            a = (short)(a | 0x800);
        }
        if (this.appuse1) {
            a = (short)(a | 0x1000);
        }
        if (this.appuse2) {
            a = (short)(a | 0x2000);
        }
        if (this.appuse3) {
            a = (short)(a | 0x4000);
        }
        if (this.appuse4) {
            a = (short)(a | 0x8000);
        }
        return a;
    }

    public String getAttributeString() {
        StringBuffer a = new StringBuffer();
        if (this.readonly) {
            a.append("R");
        } else {
            a.append("-");
        }
        if (this.system) {
            a.append("S");
        } else {
            a.append("-");
        }
        if (this.preload) {
            a.append("L");
        } else {
            a.append("-");
        }
        if (this.purgeable) {
            a.append("U");
        } else {
            a.append("-");
        }
        if (this.fromfile) {
            a.append("A");
        } else {
            a.append("-");
        }
        if (this.fromrsrc) {
            a.append("B");
        } else {
            a.append("-");
        }
        if (this.invisible) {
            a.append("I");
        } else {
            a.append("-");
        }
        if (this.disabled) {
            a.append("D");
        } else {
            a.append("-");
        }
        if (this.protect) {
            a.append("P");
        } else {
            a.append("-");
        }
        if (this.fixed) {
            a.append("F");
        } else {
            a.append("-");
        }
        if (this.multilingual) {
            a.append("M");
        } else {
            a.append("-");
        }
        if (this.compressed) {
            a.append("C");
        } else {
            a.append("-");
        }
        if (this.appuse1) {
            a.append("W");
        } else {
            a.append("-");
        }
        if (this.appuse2) {
            a.append("X");
        } else {
            a.append("-");
        }
        if (this.appuse3) {
            a.append("Y");
        } else {
            a.append("-");
        }
        if (this.appuse4) {
            a.append("Z");
        } else {
            a.append("-");
        }
        return a.toString();
    }

    public void setAttributes(short a) {
        this.readonly = (a & 1) != 0;
        this.system = (a & 2) != 0;
        this.preload = (a & 4) != 0;
        this.purgeable = (a & 8) != 0;
        this.fromfile = (a & 0x10) != 0;
        this.fromrsrc = (a & 0x20) != 0;
        this.invisible = (a & 0x40) != 0;
        this.disabled = (a & 0x80) != 0;
        this.protect = (a & 0x100) != 0;
        this.fixed = (a & 0x200) != 0;
        this.multilingual = (a & 0x400) != 0;
        this.compressed = (a & 0x800) != 0;
        this.appuse1 = (a & 0x1000) != 0;
        this.appuse2 = (a & 0x2000) != 0;
        this.appuse3 = (a & 0x4000) != 0;
        this.appuse4 = (a & 0x8000) != 0;
    }

    public void setAttributeString(String a) {
        this.readonly = a.contains("R") || a.contains("r");
        this.system = a.contains("S") || a.contains("s");
        this.preload = a.contains("L") || a.contains("l");
        this.purgeable = a.contains("U") || a.contains("u") || a.contains("G") || a.contains("g");
        this.fromfile = a.contains("A") || a.contains("a");
        this.fromrsrc = a.contains("B") || a.contains("b");
        this.invisible = a.contains("I") || a.contains("i") || a.contains("H") || a.contains("h");
        this.disabled = a.contains("D") || a.contains("d");
        this.protect = a.contains("P") || a.contains("p");
        this.fixed = a.contains("F") || a.contains("f");
        this.multilingual = a.contains("M") || a.contains("m");
        this.compressed = a.contains("C") || a.contains("c");
        this.appuse1 = a.contains("W") || a.contains("w") || a.contains("1");
        this.appuse2 = a.contains("X") || a.contains("x") || a.contains("2");
        this.appuse3 = a.contains("Y") || a.contains("y") || a.contains("3");
        this.appuse4 = a.contains("Z") || a.contains("z") || a.contains("4");
    }

    public DFFResource shallowCopy() {
        return new DFFResource(this.type, this.id, this.datatype, this.getAttributes(), this.name, this.data);
    }

    public DFFResource deepCopy() {
        return new DFFResource(this.type, this.id, this.datatype, this.getAttributes(), this.name, KSFLUtilities.copy(this.data));
    }

    public <R extends DFFResource> R shallowRecast(Class<R> dffoSubclass) {
        Class[] fparam = new Class[]{Long.TYPE, Integer.TYPE, Short.TYPE, Short.TYPE, String.class, byte[].class};
        Object[] aparam = new Object[]{this.type, this.id, this.datatype, this.getAttributes(), this.name, this.data};
        try {
            return (R)((DFFResource)dffoSubclass.getConstructor(fparam).newInstance(aparam));
        }
        catch (Exception e) {
            return null;
        }
    }

    public <R extends DFFResource> R deepRecast(Class<R> dffoSubclass) {
        Class[] fparam = new Class[]{Long.TYPE, Integer.TYPE, Short.TYPE, Short.TYPE, String.class, byte[].class};
        Object[] aparam = new Object[]{this.type, this.id, this.datatype, this.getAttributes(), this.name, KSFLUtilities.copy(this.data)};
        try {
            return (R)((DFFResource)dffoSubclass.getConstructor(fparam).newInstance(aparam));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof DFFResource) {
            DFFResource other = (DFFResource)o;
            return this.type == other.type && this.id == other.id && this.datatype == other.datatype && this.name.equals(other.name) && this.getAttributes() == other.getAttributes() && Arrays.equals(this.data, other.data);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.type >> 32) ^ (int)this.type ^ this.id ^ (this.datatype << 16 | this.getAttributes() & 0xFFFF) ^ this.name.hashCode() ^ Arrays.hashCode(this.data);
    }
}

