/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.ksfl;

import com.kreative.cff.Chunk;
import com.kreative.cff.ChunkAlreadyExistsException;
import com.kreative.cff.ChunkFileEditor;
import com.kreative.cff.ChunkFileSpec;
import com.kreative.cff.ChunkSpec;
import com.kreative.cff.FieldSpec;
import com.kreative.cff.FieldType;
import com.kreative.dff.DFFResource;
import com.kreative.dff.DFFResourceAlreadyExistsException;
import com.kreative.dff.DFFResourceFile;
import com.kreative.ksfl.KSFLUtilities;
import com.kreative.pe.PEDirectoryEntry;
import com.kreative.pe.PEImage;
import com.kreative.pe.PEResourceData;
import com.kreative.pe.PEResourceDirectory;
import com.kreative.pe.PEResourceEntry;
import com.kreative.pe.PESection;
import com.kreative.prc.PalmResource;
import com.kreative.prc.PalmResourceAlreadyExistsException;
import com.kreative.prc.PalmResourceFile;
import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.MacResourceAlreadyExistsException;
import com.kreative.rsrc.MacResourceFile;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.text.StringCharacterIterator;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class KSFLCLI {
    private static /* synthetic */ int[] $SWITCH_TABLE$com$kreative$ksfl$KSFLCLI$Operation;

    private KSFLCLI() {
    }

    public static void main(String[] args) {
        if (args.length == 0 || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("--help") || args[0].equalsIgnoreCase("help")) {
            KSFLCLI.printUsage();
        } else if (args[0].equalsIgnoreCase("-v") || args[0].equalsIgnoreCase("-version") || args[0].equalsIgnoreCase("--version") || args[0].equalsIgnoreCase("version")) {
            KSFLCLI.printVersion();
        } else if (args[0].equalsIgnoreCase("fcc")) {
            boolean dec = false;
            int i = 1;
            while (i < args.length) {
                if (args[i].equalsIgnoreCase("-d")) {
                    dec = true;
                } else if (args[i].equalsIgnoreCase("-h")) {
                    dec = false;
                } else if (dec) {
                    System.out.println(KSFLUtilities.fcc(args[i]));
                } else {
                    String h = "00000000" + Integer.toHexString(KSFLUtilities.fcc(args[i])).toUpperCase();
                    System.out.println(h.substring(h.length() - 8));
                }
                ++i;
            }
        } else if (args[0].equalsIgnoreCase("fccs")) {
            boolean dec = false;
            int i = 1;
            while (i < args.length) {
                if (args[i].equalsIgnoreCase("-d")) {
                    dec = true;
                } else if (args[i].equalsIgnoreCase("-h")) {
                    dec = false;
                } else if (dec) {
                    System.out.println(KSFLUtilities.fccs(Integer.parseInt(args[i])));
                } else {
                    int t = 0;
                    StringCharacterIterator it = new StringCharacterIterator(args[i]);
                    char ch = it.first();
                    while (ch != '\uffff') {
                        if (ch >= '0' && ch <= '9') {
                            t = t << 4 | ch - 48;
                        } else if (ch >= 'A' && ch <= 'F') {
                            t = t << 4 | ch - 65 + 10;
                        } else if (ch >= 'a' && ch <= 'f') {
                            t = t << 4 | ch - 97 + 10;
                        }
                        ch = it.next();
                    }
                    System.out.println(KSFLUtilities.fccs(t));
                }
                ++i;
            }
        } else if (args[0].equalsIgnoreCase("ecc")) {
            boolean dec = false;
            int i = 1;
            while (i < args.length) {
                if (args[i].equalsIgnoreCase("-d")) {
                    dec = true;
                } else if (args[i].equalsIgnoreCase("-h")) {
                    dec = false;
                } else if (dec) {
                    System.out.println(KSFLUtilities.ecc(args[i]));
                } else {
                    String h = "0000000000000000" + Long.toHexString(KSFLUtilities.ecc(args[i])).toUpperCase();
                    System.out.println(h.substring(h.length() - 16));
                }
                ++i;
            }
        } else if (args[0].equalsIgnoreCase("eccs")) {
            boolean dec = false;
            int i = 1;
            while (i < args.length) {
                if (args[i].equalsIgnoreCase("-d")) {
                    dec = true;
                } else if (args[i].equalsIgnoreCase("-h")) {
                    dec = false;
                } else if (dec) {
                    System.out.println(KSFLUtilities.eccs(Long.parseLong(args[i])));
                } else {
                    long t = 0L;
                    StringCharacterIterator it = new StringCharacterIterator(args[i]);
                    char ch = it.first();
                    while (ch != '\uffff') {
                        if (ch >= '0' && ch <= '9') {
                            t = t << 4 | (long)(ch - 48);
                        } else if (ch >= 'A' && ch <= 'F') {
                            t = t << 4 | (long)(ch - 65 + 10);
                        } else if (ch >= 'a' && ch <= 'f') {
                            t = t << 4 | (long)(ch - 97 + 10);
                        }
                        ch = it.next();
                    }
                    System.out.println(KSFLUtilities.eccs(t));
                }
                ++i;
            }
        } else if (args[0].equalsIgnoreCase("tcc")) {
            boolean dec = false;
            int i = 1;
            while (i < args.length) {
                if (args[i].equalsIgnoreCase("-d")) {
                    dec = true;
                } else if (args[i].equalsIgnoreCase("-h")) {
                    dec = false;
                } else if (dec) {
                    System.out.println(KSFLUtilities.tcc(args[i]));
                } else {
                    String h = "0000" + Integer.toHexString(KSFLUtilities.tcc(args[i])).toUpperCase();
                    System.out.println(h.substring(h.length() - 4));
                }
                ++i;
            }
        } else if (args[0].equalsIgnoreCase("tccs")) {
            boolean dec = false;
            int i = 1;
            while (i < args.length) {
                if (args[i].equalsIgnoreCase("-d")) {
                    dec = true;
                } else if (args[i].equalsIgnoreCase("-h")) {
                    dec = false;
                } else if (dec) {
                    System.out.println(KSFLUtilities.tccs(Short.parseShort(args[i])));
                } else {
                    short t = 0;
                    StringCharacterIterator it = new StringCharacterIterator(args[i]);
                    char ch = it.first();
                    while (ch != '\uffff') {
                        if (ch >= '0' && ch <= '9') {
                            t = (short)(t << 4 | ch - 48);
                        } else if (ch >= 'A' && ch <= 'F') {
                            t = (short)(t << 4 | ch - 65 + 10);
                        } else if (ch >= 'a' && ch <= 'f') {
                            t = (short)(t << 4 | ch - 97 + 10);
                        }
                        ch = it.next();
                    }
                    System.out.println(KSFLUtilities.tccs(t));
                }
                ++i;
            }
        } else if (args[0].equalsIgnoreCase("occ")) {
            boolean dec = false;
            int i = 1;
            while (i < args.length) {
                if (args[i].equalsIgnoreCase("-d")) {
                    dec = true;
                } else if (args[i].equalsIgnoreCase("-h")) {
                    dec = false;
                } else if (dec) {
                    System.out.println(KSFLUtilities.occ(args[i]));
                } else {
                    String h = "00" + Integer.toHexString(KSFLUtilities.occ(args[i])).toUpperCase();
                    System.out.println(h.substring(h.length() - 2));
                }
                ++i;
            }
        } else if (args[0].equalsIgnoreCase("occs")) {
            boolean dec = false;
            int i = 1;
            while (i < args.length) {
                if (args[i].equalsIgnoreCase("-d")) {
                    dec = true;
                } else if (args[i].equalsIgnoreCase("-h")) {
                    dec = false;
                } else if (dec) {
                    System.out.println(KSFLUtilities.occs(Byte.parseByte(args[i])));
                } else {
                    byte t = 0;
                    StringCharacterIterator it = new StringCharacterIterator(args[i]);
                    char ch = it.first();
                    while (ch != '\uffff') {
                        if (ch >= '0' && ch <= '9') {
                            t = (byte)(t << 4 | ch - 48);
                        } else if (ch >= 'A' && ch <= 'F') {
                            t = (byte)(t << 4 | ch - 65 + 10);
                        } else if (ch >= 'a' && ch <= 'f') {
                            t = (byte)(t << 4 | ch - 97 + 10);
                        }
                        ch = it.next();
                    }
                    System.out.println(KSFLUtilities.occs(t));
                }
                ++i;
            }
        } else if (args[0].equalsIgnoreCase("explain")) {
            System.out.println();
            int i = 1;
            while (i < args.length) {
                if (args[i].toLowerCase().startsWith("chunk:")) {
                    ChunkFileSpec cfs = new ChunkFileSpec(args[i].substring(6));
                    System.out.println("==== " + cfs.stringRepresentation() + " ====");
                    KSFLCLI.explainChunk(cfs);
                    System.out.println();
                } else {
                    Format fmt = Format.forString(args[i]);
                    if (fmt == null) {
                        System.err.println("Unknown format: " + args[i]);
                        System.err.println("Should be one of:");
                        Format.print(System.err);
                    } else {
                        System.out.println("==== " + fmt.name() + " ====");
                        KSFLCLI.explain(fmt);
                        System.out.println();
                    }
                }
                ++i;
            }
        } else if (args.length < 2) {
            KSFLCLI.printUsage();
        } else if (args[0].toLowerCase().startsWith("chunk:")) {
            ChunkFileSpec cfs = new ChunkFileSpec(args[0].substring(6));
            File f = new File(args[1]);
            Vector<Operation> ops = new Vector<Operation>();
            Vector<List<String>> oargs = new Vector<List<String>>();
            int i = 2;
            while (i < args.length) {
                Operation op;
                if ((op = Operation.forString(args[i++])) == null) {
                    System.err.println("Unknown operation: " + args[i - 1]);
                    System.err.println("Should be one of:");
                    Operation.print(System.err);
                    while (i < args.length && !args[i].equals(":")) {
                        ++i;
                    }
                    if (i >= args.length || !args[i].equals(":")) continue;
                    ++i;
                    continue;
                }
                Vector<String> oarg = new Vector<String>();
                while (i < args.length && !args[i].equals(":")) {
                    oarg.add(args[i++]);
                }
                if (i < args.length && args[i].equals(":")) {
                    ++i;
                }
                ops.add(op);
                oargs.add(oarg);
            }
            KSFLCLI.doChunkOperations(cfs, f, ops, oargs);
        } else {
            Format fmt = Format.forString(args[0]);
            if (fmt == null) {
                System.err.println("Unknown format: " + args[0]);
                System.err.println("Should be one of:");
                Format.print(System.err);
            } else {
                File f = new File(args[1]);
                Vector<Operation> ops = new Vector<Operation>();
                Vector<List<String>> oargs = new Vector<List<String>>();
                int i = 2;
                while (i < args.length) {
                    Operation op;
                    if ((op = Operation.forString(args[i++])) == null) {
                        System.err.println("Unknown operation: " + args[i - 1]);
                        System.err.println("Should be one of:");
                        Operation.print(System.err);
                        while (i < args.length && !args[i].equals(":")) {
                            ++i;
                        }
                        if (i >= args.length || !args[i].equals(":")) continue;
                        ++i;
                        continue;
                    }
                    Vector<String> oarg = new Vector<String>();
                    while (i < args.length && !args[i].equals(":")) {
                        oarg.add(args[i++]);
                    }
                    if (i < args.length && args[i].equals(":")) {
                        ++i;
                    }
                    ops.add(op);
                    oargs.add(oarg);
                }
                KSFLCLI.doOperations(fmt, f, ops, oargs);
            }
        }
    }

    private static void printVersion() {
        System.out.println("KSFL - Kreative Structured Format Library - version 1.0");
    }

    private static void printUsage() {
        KSFLCLI.printVersion();
        System.out.println("Usage:");
        System.out.println("  ksfl <format> <file> <operation> [options] [: <operation> [options] [...]]");
        System.out.println("  ksfl explain [<format> [<format> [...]]]");
        System.out.println("  ksfl fcc|fccs|ecc|eccs|tcc|tccs|occ|occs [-dh] [<type> [<type> [...]]]");
        System.out.println("  ksfl version|help");
        System.out.println("Format:");
        Format.print(System.out);
        System.out.println("Operation:");
        Operation.print(System.out);
    }

    private static void doOperations(Format fmt, File f, List<Operation> ops, List<List<String>> oargs) {
        switch (fmt) {
            case IFF: {
                KSFLCLI.doChunkOperations(ChunkFileSpec.CFSPEC_IFF, f, ops, oargs);
                break;
            }
            case RIFF: {
                KSFLCLI.doChunkOperations(ChunkFileSpec.CFSPEC_RIFF, f, ops, oargs);
                break;
            }
            case MIDI: {
                KSFLCLI.doChunkOperations(ChunkFileSpec.CFSPEC_MIDI, f, ops, oargs);
                break;
            }
            case PNG: {
                KSFLCLI.doChunkOperations(ChunkFileSpec.CFSPEC_PNG, f, ops, oargs);
                break;
            }
            case ICNS: {
                KSFLCLI.doChunkOperations(ChunkFileSpec.CFSPEC_ICNS, f, ops, oargs);
                break;
            }
            case HYPERCARD: {
                KSFLCLI.doChunkOperations(ChunkFileSpec.CFSPEC_HYPERCARD, f, ops, oargs);
                break;
            }
            case DFFAUTO: {
                KSFLCLI.doDFFOperations(3, false, f, ops, oargs);
                break;
            }
            case DFF1BE: {
                KSFLCLI.doDFFOperations(1, false, f, ops, oargs);
                break;
            }
            case DFF1LE: {
                KSFLCLI.doDFFOperations(1, true, f, ops, oargs);
                break;
            }
            case DFF2BE: {
                KSFLCLI.doDFFOperations(2, false, f, ops, oargs);
                break;
            }
            case DFF2LE: {
                KSFLCLI.doDFFOperations(2, true, f, ops, oargs);
                break;
            }
            case DFF3BE: {
                KSFLCLI.doDFFOperations(3, false, f, ops, oargs);
                break;
            }
            case DFF3LE: {
                KSFLCLI.doDFFOperations(3, true, f, ops, oargs);
                break;
            }
            case WINPE: {
                KSFLCLI.doWinPEOperations(f, ops, oargs);
                break;
            }
            case PRC: {
                KSFLCLI.doPRCOperations(f, ops, oargs);
                break;
            }
            case RSRC: {
                KSFLCLI.doRsrcOperations(f, ops, oargs);
                break;
            }
            default: {
                System.err.println("Internal Error: Unimplemented Format " + fmt.name());
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void doChunkOperations(ChunkFileSpec spec, File f, List<Operation> ops, List<List<String>> oargs) {
        cf = null;
        modified = false;
        i = 0;
        while (i < ops.size() && i < oargs.size()) {
            op = ops.get(i);
            oarg = oargs.get(i);
            if (op == Operation.CREATE) {
                try {
                    cf = new ChunkFileEditor(spec, f, 2);
                    modified = true;
                }
                catch (IOException e) {
                    System.err.println("Error: Invalid file (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                    return;
                }
            }
            if (cf == null) {
                try {
                    cf = new ChunkFileEditor(spec, f, 0);
                    modified = false;
                }
                catch (IOException e) {
                    System.err.println("Error: Invalid file (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                    return;
                }
            }
            switch (KSFLCLI.$SWITCH_TABLE$com$kreative$ksfl$KSFLCLI$Operation()[op.ordinal()]) {
                case 2: {
                    if (oarg.isEmpty()) {
                        idx = 0;
                        while (idx < cf.getChunkCount()) {
                            ch = cf.get(idx);
                            h = ch.getHeader();
                            if (h.containsKey((Object)FieldType.CHARACTER_TYPE)) {
                                System.out.print(String.valueOf(KSFLCLI.xccs((Number)h.get((Object)FieldType.CHARACTER_TYPE))) + "\t");
                            }
                            if (h.containsKey((Object)FieldType.INTEGER_TYPE)) {
                                System.out.print(h.get((Object)FieldType.INTEGER_TYPE) + "\t");
                            }
                            if (h.containsKey((Object)FieldType.ID_NUMBER)) {
                                System.out.print(h.get((Object)FieldType.ID_NUMBER) + "\t");
                            }
                            System.out.println();
                            ++idx;
                        }
                        break;
                    }
                    idx = 0;
                    while (idx < cf.getChunkCount()) {
                        ch = cf.get(idx);
                        h = ch.getHeader();
                        if (!h.containsKey((Object)FieldType.CHARACTER_TYPE)) ** GOTO lbl48
                        s = KSFLCLI.xccs((Number)h.get((Object)FieldType.CHARACTER_TYPE));
                        if (!oarg.contains(s)) ** GOTO lbl53
                        System.out.print(String.valueOf(s) + "\t");
lbl48:
                        // 2 sources

                        if (h.containsKey((Object)FieldType.INTEGER_TYPE)) {
                            System.out.print(h.get((Object)FieldType.INTEGER_TYPE) + "\t");
                        }
                        if (h.containsKey((Object)FieldType.ID_NUMBER)) {
                            System.out.print(h.get((Object)FieldType.ID_NUMBER) + "\t");
                        }
                        System.out.println();
lbl53:
                        // 2 sources

                        ++idx;
                    }
                    break;
                }
                case 3: {
                    j = 0;
                    while (j + KSFLCLI.ntf(spec.chunkHeaderSpec()) <= oarg.size()) {
                        t = KSFLCLI.parseChunkType(spec.chunkHeaderSpec(), oarg, j, oarg.size());
                        j = t[0].intValue();
                        if (j < oarg.size()) {
                            try {
                                start /* !! */  = Long.parseLong(oarg.get(j));
                                ++j;
                                start /* !! */  = cf.getNextAvailableID(t[1], t[2], start /* !! */ );
                                if (t[1] != null) {
                                    System.out.print(String.valueOf(KSFLCLI.xccs(t[1])) + "\t");
                                }
                                if (t[2] != null) {
                                    System.out.print(String.valueOf(t[2].longValue()) + "\t");
                                }
                                System.out.println(start /* !! */ );
                            }
                            catch (NumberFormatException nfe) {
                                start = cf.getNextAvailableID(t[1], t[2]);
                                if (t[1] != null) {
                                    System.out.print(String.valueOf(KSFLCLI.xccs(t[1])) + "\t");
                                }
                                if (t[2] != null) {
                                    System.out.print(String.valueOf(t[2].longValue()) + "\t");
                                }
                                System.out.println(start);
                            }
                            continue;
                        }
                        start /* !! */  = cf.getNextAvailableID(t[1], t[2]);
                        if (t[1] != null) {
                            System.out.print(String.valueOf(KSFLCLI.xccs(t[1])) + "\t");
                        }
                        if (t[2] != null) {
                            System.out.print(String.valueOf(t[2].longValue()) + "\t");
                        }
                        System.out.println(start /* !! */ );
                    }
                    break;
                }
                case 4: {
                    if (oarg.isEmpty()) break;
                    stuff = null;
                    try {
                        raf = new RandomAccessFile(new File(oarg.get(oarg.size() - 1)), "r");
                        stuff = new byte[(int)raf.length()];
                        raf.readFully(stuff);
                        raf.close();
                    }
                    catch (IOException e) {
                        System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                        stuff = null;
                    }
                    if (stuff == null) break;
                    ch = new Chunk(spec.chunkHeaderSpec().createHeader(), stuff);
                    j = 0;
                    if (spec.chunkHeaderSpec().containsType(FieldType.CHARACTER_TYPE)) {
                        if (j < oarg.size() - 1) {
                            switch (KSFLCLI.$SWITCH_TABLE$com$kreative$cff$FieldSize()[spec.chunkHeaderSpec().getField(FieldType.CHARACTER_TYPE).size().ordinal()]) {
                                case 4: {
                                    ch.getHeader().put(FieldType.CHARACTER_TYPE, KSFLUtilities.ecc(oarg.get(j++)));
                                    break;
                                }
                                case 3: {
                                    ch.getHeader().put(FieldType.CHARACTER_TYPE, KSFLUtilities.fcc(oarg.get(j++)));
                                    break;
                                }
                                case 2: {
                                    ch.getHeader().put(FieldType.CHARACTER_TYPE, KSFLUtilities.tcc(oarg.get(j++)));
                                    break;
                                }
                                case 1: {
                                    ch.getHeader().put(FieldType.CHARACTER_TYPE, KSFLUtilities.occ(oarg.get(j++)));
                                }
                            }
                        } else {
                            switch (KSFLCLI.$SWITCH_TABLE$com$kreative$cff$FieldSize()[spec.chunkHeaderSpec().getField(FieldType.CHARACTER_TYPE).size().ordinal()]) {
                                case 4: {
                                    ch.getHeader().put(FieldType.CHARACTER_TYPE, 4927347427821906286L);
                                    break;
                                }
                                case 3: {
                                    ch.getHeader().put(FieldType.CHARACTER_TYPE, 0x44415441);
                                    break;
                                }
                                case 2: {
                                    ch.getHeader().put(FieldType.CHARACTER_TYPE, (short)16191);
                                    break;
                                }
                                case 1: {
                                    ch.getHeader().put(FieldType.CHARACTER_TYPE, (byte)63);
                                }
                            }
                        }
                    }
                    if (spec.chunkHeaderSpec().containsType(FieldType.INTEGER_TYPE)) {
                        if (j < oarg.size() - 1) {
                            try {
                                switch (KSFLCLI.$SWITCH_TABLE$com$kreative$cff$FieldSize()[spec.chunkHeaderSpec().getField(FieldType.INTEGER_TYPE).size().ordinal()]) {
                                    case 4: {
                                        ch.getHeader().put(FieldType.INTEGER_TYPE, Long.parseLong(oarg.get(j)));
                                        ++j;
                                        break;
                                    }
                                    case 3: {
                                        ch.getHeader().put(FieldType.INTEGER_TYPE, Integer.parseInt(oarg.get(j)));
                                        ++j;
                                        break;
                                    }
                                    case 2: {
                                        ch.getHeader().put(FieldType.INTEGER_TYPE, Short.parseShort(oarg.get(j)));
                                        ++j;
                                        break;
                                    }
                                    case 1: {
                                        ch.getHeader().put(FieldType.INTEGER_TYPE, Byte.parseByte(oarg.get(j)));
                                        ++j;
                                    }
                                }
                            }
                            catch (NumberFormatException nfe) {
                                switch (KSFLCLI.$SWITCH_TABLE$com$kreative$cff$FieldSize()[spec.chunkHeaderSpec().getField(FieldType.INTEGER_TYPE).size().ordinal()]) {
                                    case 4: {
                                        ch.getHeader().put(FieldType.INTEGER_TYPE, 0L);
                                        break;
                                    }
                                    case 3: {
                                        ch.getHeader().put(FieldType.INTEGER_TYPE, 0);
                                        break;
                                    }
                                    case 2: {
                                        ch.getHeader().put(FieldType.INTEGER_TYPE, (short)0);
                                        break;
                                    }
                                    case 1: {
                                        ch.getHeader().put(FieldType.INTEGER_TYPE, (byte)0);
                                    }
                                }
                            }
                        } else {
                            switch (KSFLCLI.$SWITCH_TABLE$com$kreative$cff$FieldSize()[spec.chunkHeaderSpec().getField(FieldType.INTEGER_TYPE).size().ordinal()]) {
                                case 4: {
                                    ch.getHeader().put(FieldType.INTEGER_TYPE, 0L);
                                    break;
                                }
                                case 3: {
                                    ch.getHeader().put(FieldType.INTEGER_TYPE, 0);
                                    break;
                                }
                                case 2: {
                                    ch.getHeader().put(FieldType.INTEGER_TYPE, (short)0);
                                    break;
                                }
                                case 1: {
                                    ch.getHeader().put(FieldType.INTEGER_TYPE, (byte)0);
                                }
                            }
                        }
                    }
                    if (spec.chunkHeaderSpec().containsType(FieldType.ID_NUMBER)) {
                        if (j < oarg.size() - 1) {
                            try {
                                switch (KSFLCLI.$SWITCH_TABLE$com$kreative$cff$FieldSize()[spec.chunkHeaderSpec().getField(FieldType.ID_NUMBER).size().ordinal()]) {
                                    case 4: {
                                        ch.getHeader().put(FieldType.ID_NUMBER, Long.parseLong(oarg.get(j)));
                                        ++j;
                                        break;
                                    }
                                    case 3: {
                                        ch.getHeader().put(FieldType.ID_NUMBER, Integer.parseInt(oarg.get(j)));
                                        ++j;
                                        break;
                                    }
                                    case 2: {
                                        ch.getHeader().put(FieldType.ID_NUMBER, Short.parseShort(oarg.get(j)));
                                        ++j;
                                        break;
                                    }
                                    case 1: {
                                        ch.getHeader().put(FieldType.ID_NUMBER, Byte.parseByte(oarg.get(j)));
                                        ++j;
                                    }
                                }
                            }
                            catch (NumberFormatException nfe) {
                                id = cf.getNextAvailableID((Number)ch.getHeader().get((Object)FieldType.CHARACTER_TYPE), (Number)ch.getHeader().get((Object)FieldType.INTEGER_TYPE));
                                ch.getHeader().put(FieldType.ID_NUMBER, id);
                            }
                        } else {
                            id = cf.getNextAvailableID((Number)ch.getHeader().get((Object)FieldType.CHARACTER_TYPE), (Number)ch.getHeader().get((Object)FieldType.INTEGER_TYPE));
                            ch.getHeader().put(FieldType.ID_NUMBER, id);
                        }
                    }
                    try {
                        if (j < oarg.size() - 1) {
                            if (oarg.get(j).equalsIgnoreCase("before")) {
                                if (++j + KSFLCLI.nidf(spec.chunkHeaderSpec()) <= oarg.size() - 1) {
                                    n = KSFLCLI.parseChunkID(spec.chunkHeaderSpec(), oarg, j, oarg.size() - 1);
                                    j = n[0].intValue();
                                    if (!cf.insert(n[1], n[2], n[3], ch)) break;
                                    modified = true;
                                    break;
                                }
                                if (!cf.insert(0, ch)) break;
                                modified = true;
                                break;
                            }
                            if (oarg.get(j).equalsIgnoreCase("after")) {
                                if (++j + KSFLCLI.nidf(spec.chunkHeaderSpec()) <= oarg.size() - 1) {
                                    n = KSFLCLI.parseChunkID(spec.chunkHeaderSpec(), oarg, j, oarg.size() - 1);
                                    j = n[0].intValue();
                                    index = cf.getChunkIndex(n[1], n[2], n[3]);
                                    if (index >= 0) {
                                        ++index;
                                    }
                                    if (!cf.insert(index, ch)) break;
                                    modified = true;
                                    break;
                                }
                                if (!cf.add(ch)) break;
                                modified = true;
                                break;
                            }
                            if (!cf.add(ch)) break;
                            modified = true;
                            break;
                        }
                        if (!cf.add(ch)) break;
                        modified = true;
                    }
                    catch (ChunkAlreadyExistsException e) {
                        System.err.println("Error: Chunk already exists.");
                    }
                    break;
                }
                case 5: {
                    j = 0;
                    while (j + KSFLCLI.nidf(spec.chunkHeaderSpec()) <= oarg.size()) {
                        n = KSFLCLI.parseChunkID(spec.chunkHeaderSpec(), oarg, j, oarg.size());
                        System.out.println(cf.contains(n[1], n[2], n[3]));
                        j = n[0].intValue();
                    }
                    break;
                }
                case 6: {
                    if (oarg.size() > 0 && oarg.size() < KSFLCLI.ntf(spec.chunkHeaderSpec()) + 1) {
                        f1 = new File(oarg.get(oarg.size() - 1));
                        f1.mkdir();
                        j = 0;
                        while (j < cf.getChunkCount()) {
                            ch = cf.get(j);
                            n = new StringBuffer();
                            if (ch.getHeader().containsKey((Object)FieldType.CHARACTER_TYPE)) {
                                n.append(String.valueOf(KSFLCLI.xccs((Number)ch.getHeader().get((Object)FieldType.CHARACTER_TYPE))) + " ");
                            }
                            if (ch.getHeader().containsKey((Object)FieldType.INTEGER_TYPE)) {
                                n.append(String.valueOf(Long.toString(((Number)ch.getHeader().get((Object)FieldType.INTEGER_TYPE)).longValue())) + " ");
                            }
                            if (ch.getHeader().containsKey((Object)FieldType.ID_NUMBER)) {
                                n.append(String.valueOf(Long.toString(((Number)ch.getHeader().get((Object)FieldType.ID_NUMBER)).longValue())) + " ");
                            } else {
                                n.insert(0, String.valueOf(Integer.toString(j)) + " ");
                            }
                            n.deleteCharAt(n.length() - 1);
                            f2 = new File(f1, n.toString());
                            try {
                                fos = new FileOutputStream(f2);
                                fos.write(ch.getData());
                                fos.close();
                            }
                            catch (IOException e) {
                                System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            }
                            ++j;
                        }
                        break;
                    }
                    if (oarg.size() == KSFLCLI.ntf(spec.chunkHeaderSpec()) + 1) {
                        f1 = new File(oarg.get(oarg.size() - 1));
                        f1.mkdir();
                        t = KSFLCLI.parseChunkType(spec.chunkHeaderSpec(), oarg, 0, oarg.size() - 1);
                        e = cf.getChunkIDs(t[1], t[2]);
                        f2 = e.length;
                        n = 0;
                        while (n < f2) {
                            id = e[n];
                            n = new StringBuffer();
                            if (t[1] != null) {
                                n.append(String.valueOf(KSFLCLI.xccs(t[1])) + " ");
                            }
                            if (t[2] != null) {
                                n.append(String.valueOf(Long.toString(t[2].longValue())) + " ");
                            }
                            n.append(Long.toString(id.longValue()));
                            f2 = new File(f1, n.toString());
                            ch = cf.get(t[1], t[2], id);
                            try {
                                fos = new FileOutputStream(f2);
                                fos.write(ch.getData());
                                fos.close();
                            }
                            catch (IOException e) {
                                System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            }
                            ++n;
                        }
                        break;
                    }
                    j = 0;
                    while (j + KSFLCLI.nidf(spec.chunkHeaderSpec()) + 1 <= oarg.size()) {
                        n = KSFLCLI.parseChunkID(spec.chunkHeaderSpec(), oarg, j, oarg.size());
                        j = n[0].intValue();
                        f1 = new File(oarg.get(j++));
                        ch = cf.get(n[1], n[2], n[3]);
                        if (ch == null) {
                            System.err.println("Error: Chunk does not exist.");
                            continue;
                        }
                        try {
                            fos = new FileOutputStream(f1);
                            fos.write(ch.getData());
                            fos.close();
                        }
                        catch (IOException e) {
                            System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                        }
                    }
                    break;
                }
                case 7: {
                    j = 0;
                    while (j + KSFLCLI.nidf(spec.chunkHeaderSpec()) <= oarg.size()) {
                        n = KSFLCLI.parseChunkID(spec.chunkHeaderSpec(), oarg, j, oarg.size());
                        h = cf.getAttributes(n[1], n[2], n[3]);
                        if (h == null) {
                            System.err.println("Error: Chunk does not exist.");
                        } else {
                            if (h.containsKey((Object)FieldType.CHARACTER_TYPE)) {
                                System.out.println("Type: " + KSFLCLI.xccs((Number)h.get((Object)FieldType.CHARACTER_TYPE)));
                            }
                            if (h.containsKey((Object)FieldType.INTEGER_TYPE)) {
                                System.out.println("Type: " + ((Number)h.get((Object)FieldType.INTEGER_TYPE)).longValue());
                            }
                            if (h.containsKey((Object)FieldType.ID_NUMBER)) {
                                System.out.println("ID:   " + ((Number)h.get((Object)FieldType.ID_NUMBER)).longValue());
                            }
                            if (h.containsKey((Object)FieldType.CHECKSUM)) {
                                System.out.println("Chk:  " + ((Number)h.get((Object)FieldType.CHECKSUM)).longValue());
                            }
                            if (h.containsKey((Object)FieldType.SIZE_WITHOUT_HEADER)) {
                                System.out.println("Len:  " + ((Number)h.get((Object)FieldType.SIZE_WITHOUT_HEADER)).longValue() + " (excluding header)");
                            }
                            if (h.containsKey((Object)FieldType.SIZE_WITH_HEADER)) {
                                System.out.println("Len:  " + ((Number)h.get((Object)FieldType.SIZE_WITH_HEADER)).longValue() + " (including header)");
                            }
                        }
                        j = n[0].intValue();
                    }
                    break;
                }
                case 8: {
                    j = 0;
                    while (j + KSFLCLI.nidf(spec.chunkHeaderSpec()) <= oarg.size()) {
                        n = KSFLCLI.parseChunkID(spec.chunkHeaderSpec(), oarg, j, oarg.size());
                        data = cf.getData(n[1], n[2], n[3]);
                        if (data == null) {
                            System.err.println("Error: Chunk does not exist.");
                        } else {
                            try {
                                System.out.write(data);
                            }
                            catch (IOException ch) {
                                // empty catch block
                            }
                        }
                        j = n[0].intValue();
                    }
                    break;
                }
                case 9: {
                    j = 0;
                    while (j + KSFLCLI.nidf(spec.chunkHeaderSpec()) <= oarg.size()) {
                        n = KSFLCLI.parseChunkID(spec.chunkHeaderSpec(), oarg, j, oarg.size());
                        data = cf.getData(n[1], n[2], n[3]);
                        if (data == null) {
                            System.err.println("Error: Chunk does not exist.");
                        } else {
                            KSFLUtilities.printHexDump(System.out, data);
                        }
                        j = n[0].intValue();
                    }
                    break;
                }
                case 10: {
                    j = 0;
                    while (j + KSFLCLI.nidf(spec.chunkHeaderSpec()) <= oarg.size()) {
                        n = KSFLCLI.parseChunkID(spec.chunkHeaderSpec(), oarg, j, oarg.size());
                        if (cf.remove(n[1], n[2], n[3])) {
                            modified = true;
                        }
                        j = n[0].intValue();
                    }
                    break;
                }
                case 11: {
                    if (oarg.size() < KSFLCLI.nidf(spec.chunkHeaderSpec())) break;
                    n = KSFLCLI.parseChunkID(spec.chunkHeaderSpec(), oarg, 0, oarg.size());
                    ch = cf.get(n[1], n[2], n[3]);
                    if (ch == null) {
                        System.err.println("Error: Chunk does not exist.");
                        break;
                    }
                    h = ch.getHeader().clone();
                    localModified = false;
                    j = n[0].intValue();
                    while (j + 2 <= oarg.size()) {
                        siop = oarg.get(j).trim().toLowerCase();
                        if (siop.equals("t") || siop.equals("type") || siop.equals("ct") || siop.equals("ctype")) {
                            if (spec.chunkHeaderSpec().containsType(FieldType.CHARACTER_TYPE)) {
                                switch (KSFLCLI.$SWITCH_TABLE$com$kreative$cff$FieldSize()[spec.chunkHeaderSpec().getField(FieldType.CHARACTER_TYPE).size().ordinal()]) {
                                    case 4: {
                                        h.put(FieldType.CHARACTER_TYPE, KSFLUtilities.ecc(oarg.get(j + 1)));
                                        localModified = true;
                                        break;
                                    }
                                    case 3: {
                                        h.put(FieldType.CHARACTER_TYPE, KSFLUtilities.fcc(oarg.get(j + 1)));
                                        localModified = true;
                                        break;
                                    }
                                    case 2: {
                                        h.put(FieldType.CHARACTER_TYPE, KSFLUtilities.tcc(oarg.get(j + 1)));
                                        localModified = true;
                                        break;
                                    }
                                    case 1: {
                                        h.put(FieldType.CHARACTER_TYPE, KSFLUtilities.occ(oarg.get(j + 1)));
                                        localModified = true;
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                        } else if (siop.equals("m") || siop.equals("magic") || siop.equals("it") || siop.equals("itype")) {
                            if (spec.chunkHeaderSpec().containsType(FieldType.INTEGER_TYPE)) {
                                try {
                                    switch (KSFLCLI.$SWITCH_TABLE$com$kreative$cff$FieldSize()[spec.chunkHeaderSpec().getField(FieldType.INTEGER_TYPE).size().ordinal()]) {
                                        case 4: {
                                            h.put(FieldType.INTEGER_TYPE, Long.parseLong(oarg.get(j + 1)));
                                            localModified = true;
                                            break;
                                        }
                                        case 3: {
                                            h.put(FieldType.INTEGER_TYPE, Integer.parseInt(oarg.get(j + 1)));
                                            localModified = true;
                                            break;
                                        }
                                        case 2: {
                                            h.put(FieldType.INTEGER_TYPE, Short.parseShort(oarg.get(j + 1)));
                                            localModified = true;
                                            break;
                                        }
                                        case 1: {
                                            h.put(FieldType.INTEGER_TYPE, Byte.parseByte(oarg.get(j + 1)));
                                            localModified = true;
                                        }
                                    }
                                }
                                catch (NumberFormatException nfe) {
                                    System.err.println("Error: Invalid type number " + oarg.get(j + 1) + " skipped.");
                                }
                            }
                        } else if (siop.equals("i") || siop.equals("id")) {
                            if (spec.chunkHeaderSpec().containsType(FieldType.ID_NUMBER)) {
                                try {
                                    switch (KSFLCLI.$SWITCH_TABLE$com$kreative$cff$FieldSize()[spec.chunkHeaderSpec().getField(FieldType.ID_NUMBER).size().ordinal()]) {
                                        case 4: {
                                            h.put(FieldType.ID_NUMBER, Long.parseLong(oarg.get(j + 1)));
                                            localModified = true;
                                            break;
                                        }
                                        case 3: {
                                            h.put(FieldType.ID_NUMBER, Integer.parseInt(oarg.get(j + 1)));
                                            localModified = true;
                                            break;
                                        }
                                        case 2: {
                                            h.put(FieldType.ID_NUMBER, Short.parseShort(oarg.get(j + 1)));
                                            localModified = true;
                                            break;
                                        }
                                        case 1: {
                                            h.put(FieldType.ID_NUMBER, Byte.parseByte(oarg.get(j + 1)));
                                            localModified = true;
                                        }
                                    }
                                }
                                catch (NumberFormatException nfe) {
                                    System.err.println("Error: Invalid ID number " + oarg.get(j + 1) + " skipped.");
                                }
                            }
                        } else if (siop.equals("c") || siop.equals("checksum")) {
                            if (spec.chunkHeaderSpec().containsType(FieldType.CHECKSUM)) {
                                try {
                                    switch (KSFLCLI.$SWITCH_TABLE$com$kreative$cff$FieldSize()[spec.chunkHeaderSpec().getField(FieldType.CHECKSUM).size().ordinal()]) {
                                        case 4: {
                                            h.put(FieldType.CHECKSUM, Long.parseLong(oarg.get(j + 1)));
                                            localModified = true;
                                            break;
                                        }
                                        case 3: {
                                            h.put(FieldType.CHECKSUM, Integer.parseInt(oarg.get(j + 1)));
                                            localModified = true;
                                            break;
                                        }
                                        case 2: {
                                            h.put(FieldType.CHECKSUM, Short.parseShort(oarg.get(j + 1)));
                                            localModified = true;
                                            break;
                                        }
                                        case 1: {
                                            h.put(FieldType.CHECKSUM, Byte.parseByte(oarg.get(j + 1)));
                                            localModified = true;
                                        }
                                    }
                                }
                                catch (NumberFormatException nfe) {
                                    System.err.println("Error: Invalid checksum " + oarg.get(j + 1) + " skipped.");
                                }
                            }
                        } else {
                            System.err.println("Unknown attribute type: " + oarg.get(j));
                            System.err.println("Should be one of: [c]t[ype] it[ype] m[agic] i[d] c[hecksum]");
                        }
                        j += 2;
                    }
                    if (!localModified) break;
                    try {
                        if (!cf.setAttributes(n[1], n[2], n[3], h)) break;
                        modified = true;
                    }
                    catch (ChunkAlreadyExistsException e) {
                        System.err.println("Error: Chunk already exists.");
                    }
                    break;
                }
                case 12: {
                    j = 0;
                    while (j + KSFLCLI.nidf(spec.chunkHeaderSpec()) + 1 <= oarg.size()) {
                        n = KSFLCLI.parseChunkID(spec.chunkHeaderSpec(), oarg, j, oarg.size());
                        j = n[0].intValue();
                        sizestr = oarg.get(j++);
                        try {
                            size = Integer.parseInt(sizestr);
                            if (cf.contains(n[1], n[2], n[3])) {
                                if (!cf.setData(n[1], n[2], n[3], KSFLUtilities.resize(cf.getData(n[1], n[2], n[3]), size))) continue;
                                modified = true;
                                continue;
                            }
                            ch = new Chunk(spec.chunkHeaderSpec().createHeader(), new byte[size]);
                            if (ch.getHeader().containsKey((Object)FieldType.CHARACTER_TYPE)) {
                                ch.getHeader().put(FieldType.CHARACTER_TYPE, n[1]);
                            }
                            if (ch.getHeader().containsKey((Object)FieldType.INTEGER_TYPE)) {
                                ch.getHeader().put(FieldType.INTEGER_TYPE, n[2]);
                            }
                            if (ch.getHeader().containsKey((Object)FieldType.ID_NUMBER)) {
                                ch.getHeader().put(FieldType.ID_NUMBER, n[3]);
                            }
                            try {
                                if (!cf.add(ch)) continue;
                                modified = true;
                            }
                            catch (ChunkAlreadyExistsException var14_92) {}
                        }
                        catch (NumberFormatException nfe) {
                            System.err.println("Error: Invalid length " + sizestr + " skipped.");
                        }
                    }
                    break;
                }
                case 13: {
                    j = 0;
                    while (j + KSFLCLI.nidf(spec.chunkHeaderSpec()) + 1 <= oarg.size()) {
                        n = KSFLCLI.parseChunkID(spec.chunkHeaderSpec(), oarg, j, oarg.size());
                        j = n[0].intValue();
                        f1 = new File(oarg.get(j++));
                        if (!cf.contains(n[1], n[2], n[3])) continue;
                        stuff = null;
                        try {
                            raf = new RandomAccessFile(f1, "r");
                            stuff = new byte[(int)raf.length()];
                            raf.readFully(stuff);
                            raf.close();
                        }
                        catch (IOException e) {
                            System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            stuff = null;
                        }
                        if (stuff == null || !cf.setData(n[1], n[2], n[3], stuff)) continue;
                        modified = true;
                    }
                    break;
                }
                case 14: {
                    j = 0;
                    while (j + KSFLCLI.nidf(spec.chunkHeaderSpec()) + 1 <= oarg.size()) {
                        n = KSFLCLI.parseChunkID(spec.chunkHeaderSpec(), oarg, j, oarg.size());
                        j = n[0].intValue();
                        f1 = new File(oarg.get(j++));
                        stuff = null;
                        try {
                            raf = new RandomAccessFile(f1, "r");
                            stuff = new byte[(int)raf.length()];
                            raf.readFully(stuff);
                            raf.close();
                        }
                        catch (IOException e) {
                            System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            stuff = null;
                        }
                        if (stuff == null) continue;
                        if (cf.contains(n[1], n[2], n[3])) {
                            if (!cf.setData(n[1], n[2], n[3], stuff)) continue;
                            modified = true;
                            continue;
                        }
                        ch = new Chunk(spec.chunkHeaderSpec().createHeader(), stuff);
                        if (ch.getHeader().containsKey((Object)FieldType.CHARACTER_TYPE)) {
                            ch.getHeader().put(FieldType.CHARACTER_TYPE, n[1]);
                        }
                        if (ch.getHeader().containsKey((Object)FieldType.INTEGER_TYPE)) {
                            ch.getHeader().put(FieldType.INTEGER_TYPE, n[2]);
                        }
                        if (ch.getHeader().containsKey((Object)FieldType.ID_NUMBER)) {
                            ch.getHeader().put(FieldType.ID_NUMBER, n[3]);
                        }
                        try {
                            if (!cf.add(ch)) continue;
                            modified = true;
                        }
                        catch (ChunkAlreadyExistsException var14_93) {
                            // empty catch block
                        }
                    }
                    break;
                }
                default: {
                    System.err.println("Internal Error: Unimplemented Operation " + op.name());
                }
            }
            ++i;
        }
        if (cf != null && modified) {
            try {
                cf.close();
            }
            catch (IOException e) {
                System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
            }
        }
    }

    private static String xccs(Number n) {
        if (n instanceof Long) {
            return KSFLUtilities.eccs(n.longValue());
        }
        if (n instanceof Integer) {
            return KSFLUtilities.fccs(n.intValue());
        }
        if (n instanceof Short) {
            return KSFLUtilities.tccs(n.shortValue());
        }
        if (n instanceof Byte) {
            return KSFLUtilities.occs(n.byteValue());
        }
        return "";
    }

    private static int ntf(ChunkSpec hs) {
        int n = 0;
        if (hs.containsType(FieldType.CHARACTER_TYPE)) {
            ++n;
        }
        if (hs.containsType(FieldType.INTEGER_TYPE)) {
            ++n;
        }
        return n;
    }

    private static Number[] parseChunkType(ChunkSpec hs, List<String> oarg, int j, int s) {
        Number ctype = null;
        if (j < s && hs.containsType(FieldType.CHARACTER_TYPE)) {
            switch (hs.getField(FieldType.CHARACTER_TYPE).size()) {
                case LONG: {
                    ctype = KSFLUtilities.ecc(oarg.get(j++));
                    break;
                }
                case MEDIUM: {
                    ctype = KSFLUtilities.fcc(oarg.get(j++));
                    break;
                }
                case SHORT: {
                    ctype = KSFLUtilities.tcc(oarg.get(j++));
                    break;
                }
                case BYTE: {
                    ctype = KSFLUtilities.occ(oarg.get(j++));
                }
            }
        }
        Number itype = null;
        if (j < s && hs.containsType(FieldType.INTEGER_TYPE)) {
            try {
                switch (hs.getField(FieldType.INTEGER_TYPE).size()) {
                    case LONG: {
                        itype = Long.parseLong(oarg.get(j));
                        ++j;
                        break;
                    }
                    case MEDIUM: {
                        itype = Integer.parseInt(oarg.get(j));
                        ++j;
                        break;
                    }
                    case SHORT: {
                        itype = Short.parseShort(oarg.get(j));
                        ++j;
                        break;
                    }
                    case BYTE: {
                        itype = Byte.parseByte(oarg.get(j));
                        ++j;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Number[]{j, ctype, itype};
    }

    private static int nidf(ChunkSpec hs) {
        int n = 0;
        if (hs.containsType(FieldType.CHARACTER_TYPE)) {
            ++n;
        }
        if (hs.containsType(FieldType.INTEGER_TYPE)) {
            ++n;
        }
        return ++n;
    }

    private static Number[] parseChunkID(ChunkSpec hs, List<String> oarg, int j, int s) {
        Number ctype = null;
        if (j < s && hs.containsType(FieldType.CHARACTER_TYPE)) {
            switch (hs.getField(FieldType.CHARACTER_TYPE).size()) {
                case LONG: {
                    ctype = KSFLUtilities.ecc(oarg.get(j++));
                    break;
                }
                case MEDIUM: {
                    ctype = KSFLUtilities.fcc(oarg.get(j++));
                    break;
                }
                case SHORT: {
                    ctype = KSFLUtilities.tcc(oarg.get(j++));
                    break;
                }
                case BYTE: {
                    ctype = KSFLUtilities.occ(oarg.get(j++));
                }
            }
        }
        Number itype = null;
        if (j < s && hs.containsType(FieldType.INTEGER_TYPE)) {
            try {
                switch (hs.getField(FieldType.INTEGER_TYPE).size()) {
                    case LONG: {
                        itype = Long.parseLong(oarg.get(j));
                        ++j;
                        break;
                    }
                    case MEDIUM: {
                        itype = Integer.parseInt(oarg.get(j));
                        ++j;
                        break;
                    }
                    case SHORT: {
                        itype = Short.parseShort(oarg.get(j));
                        ++j;
                        break;
                    }
                    case BYTE: {
                        itype = Byte.parseByte(oarg.get(j));
                        ++j;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Number id = null;
        if (j < s) {
            try {
                if (hs.containsType(FieldType.ID_NUMBER)) {
                    switch (hs.getField(FieldType.ID_NUMBER).size()) {
                        case LONG: {
                            id = Long.parseLong(oarg.get(j));
                            ++j;
                            break;
                        }
                        case MEDIUM: {
                            id = Integer.parseInt(oarg.get(j));
                            ++j;
                            break;
                        }
                        case SHORT: {
                            id = Short.parseShort(oarg.get(j));
                            ++j;
                            break;
                        }
                        case BYTE: {
                            id = Byte.parseByte(oarg.get(j));
                            ++j;
                        }
                    }
                } else {
                    id = Integer.parseInt(oarg.get(j));
                    ++j;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Number[]{j, ctype, itype, id};
    }

    /*
     * Unable to fully structure code
     */
    private static void doDFFOperations(int version, boolean le, File f, List<Operation> ops, List<List<String>> oargs) {
        dp = null;
        i = 0;
        while (i < ops.size() && i < oargs.size()) {
            op = ops.get(i);
            oarg = oargs.get(i);
            if (op == Operation.CREATE) {
                try {
                    dp = new DFFResourceFile(f, "rwd", 2, version, le);
                }
                catch (IOException e) {
                    System.err.println("Error: Invalid file (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                    return;
                }
            }
            if (dp == null) {
                try {
                    try {
                        dp = new DFFResourceFile(f, "rwd", 0, version, le);
                    }
                    catch (SecurityException e) {
                        dp = new DFFResourceFile(f, "r", 0, version, le);
                        System.err.println("Warning: Opened read-only");
                    }
                }
                catch (IOException e) {
                    System.err.println("Error: Invalid file (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                    return;
                }
            }
            switch (KSFLCLI.$SWITCH_TABLE$com$kreative$ksfl$KSFLCLI$Operation()[op.ordinal()]) {
                case 2: {
                    if (oarg.isEmpty()) {
                        var13_76 = dp.getTypes();
                        var12_53 = var13_76.length;
                        var11_46 = 0;
                        while (var11_46 < var12_53) {
                            type = var13_76[var11_46];
                            System.out.println(String.valueOf(KSFLUtilities.eccs(type)) + "\t" + dp.getResourceCount(type));
                            ++var11_46;
                        }
                        break;
                    }
                    for (String typestr : oarg) {
                        type = KSFLUtilities.ecc(typestr);
                        var16_120 = dp.getIDs(type);
                        var15_110 = var16_120.length;
                        var14_93 = 0;
                        while (var14_93 < var15_110) {
                            id = var16_120[var14_93];
                            System.out.print(String.valueOf(KSFLUtilities.eccs(type)) + "\t" + id);
                            try {
                                System.out.print("\t" + dp.getNameFromID(type, id));
                            }
                            catch (UnsupportedOperationException var17_126) {
                                // empty catch block
                            }
                            System.out.println();
                            ++var14_93;
                        }
                    }
                    break;
                }
                case 3: {
                    j = 0;
                    while (j < oarg.size()) {
                        type = KSFLUtilities.ecc(oarg.get(j++));
                        if (j < oarg.size()) {
                            try {
                                id = Integer.parseInt(oarg.get(j));
                                System.out.println(String.valueOf(KSFLUtilities.eccs(type)) + "\t" + dp.getNextAvailableID(type, id));
                                ++j;
                            }
                            catch (NumberFormatException nfe) {
                                System.out.println(String.valueOf(KSFLUtilities.eccs(type)) + "\t" + dp.getNextAvailableID(type));
                            }
                            continue;
                        }
                        System.out.println(String.valueOf(KSFLUtilities.eccs(type)) + "\t" + dp.getNextAvailableID(type));
                    }
                    break;
                }
                case 4: {
                    if (oarg.isEmpty()) break;
                    stuff = null;
                    try {
                        raf = new RandomAccessFile(new File(oarg.get(oarg.size() - 1)), "r");
                        stuff = new byte[(int)raf.length()];
                        raf.readFully(stuff);
                        raf.close();
                    }
                    catch (IOException e) {
                        System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                        stuff = null;
                    }
                    if (stuff == null) break;
                    try {
                        type = oarg.size() > 1 ? KSFLUtilities.ecc(oarg.get(0)) : 4927347427821906286L;
                        id = oarg.size() > 2 ? Integer.parseInt(oarg.get(1)) : dp.getNextAvailableID(type);
                        r = new DFFResource(type, id, stuff);
                        if (oarg.size() > 3) {
                            r.name = oarg.get(2);
                        }
                        if (oarg.size() > 4) {
                            r.setAttributeString(oarg.get(3));
                        }
                        if (oarg.size() > 5) {
                            r.datatype = (short)Integer.parseInt(oarg.get(4));
                        }
                        try {
                            dp.add(r);
                        }
                        catch (DFFResourceAlreadyExistsException e) {
                            System.err.println("Error: " + KSFLUtilities.eccs(type) + " " + id + " already exists.");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Error: Invalid number skipped.");
                    }
                    break;
                }
                case 5: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.ecc(oarg.get(j));
                        try {
                            id = Integer.parseInt(oarg.get(j + 1));
                            System.out.println(dp.contains(type, id));
                        }
                        catch (NumberFormatException nfe) {
                            System.out.println(dp.contains(type, oarg.get(j + 1)));
                        }
                        j += 2;
                    }
                    break;
                }
                case 6: {
                    if (oarg.size() == 1) {
                        f1 = new File(oarg.get(0));
                        f1.mkdir();
                        e = dp.getTypes();
                        r = e.length;
                        nfe = 0;
                        while (nfe < r) {
                            type = e[nfe];
                            f2 = new File(f1, KSFLUtilities.eccs(type));
                            f2.mkdir();
                            var19_134 = dp.getIDs(type);
                            var18_130 = var19_134.length;
                            var17_127 = 0;
                            while (var17_127 < var18_130) {
                                id = var19_134[var17_127];
                                r = dp.get(type, id);
                                n = Integer.toString(r.id);
                                if (r.name != null && r.name.length() > 0) {
                                    n = String.valueOf(n) + " " + r.name;
                                }
                                try {
                                    fos = new FileOutputStream(new File(f2, n));
                                    fos.write(r.data);
                                    fos.close();
                                }
                                catch (IOException e) {
                                    System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                                }
                                try {
                                    dos = new DataOutputStream(new FileOutputStream(new File(f2, String.valueOf(n) + ".dffmeta")));
                                    dos.writeLong(r.type);
                                    dos.writeInt(r.id);
                                    dos.writeShort(r.datatype);
                                    dos.writeShort(r.getAttributes());
                                    dos.writeUTF(r.name);
                                    dos.close();
                                }
                                catch (IOException e) {
                                    System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                                }
                                ++var17_127;
                            }
                            ++nfe;
                        }
                        break;
                    }
                    if (oarg.size() == 2) {
                        f1 = new File(oarg.get(1));
                        f1.mkdir();
                        type = KSFLUtilities.ecc(oarg.get(0));
                        f2 = dp.getIDs(type);
                        e = f2.length;
                        r = 0;
                        while (r < e) {
                            id = f2[r];
                            r = dp.get(type, id);
                            n = Integer.toString(r.id);
                            if (r.name != null && r.name.length() > 0) {
                                n = String.valueOf(n) + " " + r.name;
                            }
                            try {
                                fos = new FileOutputStream(new File(f1, n));
                                fos.write(r.data);
                                fos.close();
                            }
                            catch (IOException e) {
                                System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            }
                            try {
                                dos = new DataOutputStream(new FileOutputStream(new File(f1, String.valueOf(n) + ".dffmeta")));
                                dos.writeLong(r.type);
                                dos.writeInt(r.id);
                                dos.writeShort(r.datatype);
                                dos.writeShort(r.getAttributes());
                                dos.writeUTF(r.name);
                                dos.close();
                            }
                            catch (IOException e) {
                                System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            }
                            ++r;
                        }
                        break;
                    }
                    j = 0;
                    while (j + 3 <= oarg.size()) {
                        type = KSFLUtilities.ecc(oarg.get(j));
                        try {
                            id = Integer.parseInt(oarg.get(j + 1));
                            data = dp.getData(type, id);
                            if (data == null) {
                                System.err.println("Error: " + KSFLUtilities.eccs(type) + " " + id + " does not exist.");
                            } else {
                                try {
                                    fos = new FileOutputStream(new File(oarg.get(j + 2)));
                                    fos.write(data);
                                    fos.close();
                                }
                                catch (IOException e) {
                                    System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                                }
                            }
                        }
                        catch (NumberFormatException nfe) {
                            data = dp.getData(type, oarg.get(j + 1));
                            if (data == null) {
                                System.err.println("Error: " + KSFLUtilities.eccs(type) + " " + oarg.get(j + 1) + " does not exist.");
                            }
                            try {
                                fos = new FileOutputStream(new File(oarg.get(j + 2)));
                                fos.write(data);
                                fos.close();
                            }
                            catch (IOException e) {
                                System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            }
                        }
                        j += 3;
                    }
                    break;
                }
                case 7: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.ecc(oarg.get(j));
                        try {
                            id = Integer.parseInt(oarg.get(j + 1));
                            r = dp.getAttributes(type, id);
                            if (r == null) {
                                System.err.println("Error: " + KSFLUtilities.eccs(type) + " " + id + " does not exist.");
                            } else {
                                l = dp.getLength(type, id);
                                ts = KSFLUtilities.eccs(r.type);
                                th = "0000000000000000" + Long.toHexString(r.type).toUpperCase();
                                System.out.println("Type: " + ts + " (0x" + th.substring(th.length() - 16) + ")");
                                System.out.println("ID:   " + r.id);
                                System.out.println("Attr: " + r.getAttributeString().toLowerCase());
                                System.out.println("DT:   " + r.datatype);
                                System.out.println("Name: " + r.name);
                                System.out.println("Len:  " + l);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            r = dp.getAttributes(type, oarg.get(j + 1));
                            if (r == null) {
                                System.err.println("Error: " + KSFLUtilities.eccs(type) + " " + oarg.get(j + 1) + " does not exist.");
                            }
                            l = dp.getLength(type, oarg.get(j + 1));
                            ts = KSFLUtilities.eccs(r.type);
                            th = "0000000000000000" + Long.toHexString(r.type).toUpperCase();
                            System.out.println("Type: " + ts + " (0x" + th.substring(th.length() - 16) + ")");
                            System.out.println("ID:   " + r.id);
                            System.out.println("Attr: " + r.getAttributeString().toLowerCase());
                            System.out.println("DT:   " + r.datatype);
                            System.out.println("Name: " + r.name);
                            System.out.println("Len:  " + l);
                        }
                        j += 2;
                    }
                    break;
                }
                case 8: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.ecc(oarg.get(j));
                        try {
                            id = Integer.parseInt(oarg.get(j + 1));
                            data = dp.getData(type, id);
                            if (data == null) {
                                System.err.println("Error: " + KSFLUtilities.eccs(type) + " " + id + " does not exist.");
                            } else {
                                try {
                                    System.out.write(data);
                                }
                                catch (IOException l) {}
                            }
                        }
                        catch (NumberFormatException nfe) {
                            data = dp.getData(type, oarg.get(j + 1));
                            if (data == null) {
                                System.err.println("Error: " + KSFLUtilities.eccs(type) + " " + oarg.get(j + 1) + " does not exist.");
                            }
                            try {
                                System.out.write(data);
                            }
                            catch (IOException l) {
                                // empty catch block
                            }
                        }
                        j += 2;
                    }
                    break;
                }
                case 9: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.ecc(oarg.get(j));
                        try {
                            id = Integer.parseInt(oarg.get(j + 1));
                            data = dp.getData(type, id);
                            if (data == null) {
                                System.err.println("Error: " + KSFLUtilities.eccs(type) + " " + id + " does not exist.");
                            } else {
                                KSFLUtilities.printHexDump(System.out, data);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            data = dp.getData(type, oarg.get(j + 1));
                            if (data == null) {
                                System.err.println("Error: " + KSFLUtilities.eccs(type) + " " + oarg.get(j + 1) + " does not exist.");
                            }
                            KSFLUtilities.printHexDump(System.out, data);
                        }
                        j += 2;
                    }
                    break;
                }
                case 10: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.ecc(oarg.get(j));
                        try {
                            id = Integer.parseInt(oarg.get(j + 1));
                            dp.remove(type, id);
                        }
                        catch (NumberFormatException nfe) {
                            dp.remove(type, oarg.get(j + 1));
                        }
                        j += 2;
                    }
                    break;
                }
                case 11: {
                    if (oarg.size() < 2) break;
                    type = KSFLUtilities.ecc(oarg.get(0));
                    r = null;
                    try {
                        id = Integer.parseInt(oarg.get(1));
                        r = dp.get(type, id);
                    }
                    catch (NumberFormatException nfe) {
                        name = oarg.get(1);
                        r = dp.get(type, name);
                    }
                    if (r == null) {
                        System.err.println("Error: Cannot find " + KSFLUtilities.eccs(type) + " " + oarg.get(1));
                        break;
                    }
                    id = r.id;
                    changed = false;
                    j = 2;
                    while (j + 2 <= oarg.size()) {
                        siop = oarg.get(j).trim().toLowerCase();
                        if (siop.equals("t") || siop.equals("type")) {
                            r.type = KSFLUtilities.ecc(oarg.get(j + 1));
                            changed = true;
                        } else if (siop.equals("i") || siop.equals("id")) {
                            try {
                                r.id = Integer.parseInt(oarg.get(j + 1));
                                changed = true;
                            }
                            catch (NumberFormatException nfe) {
                                System.err.println("Error: Invalid ID number " + oarg.get(j + 1) + " skipped.");
                            }
                        } else if (siop.equals("n") || siop.equals("name")) {
                            r.name = oarg.get(j + 1);
                            changed = true;
                        } else if (siop.equals("a") || siop.equals("attr") || siop.equals("attrib") || siop.equals("attributes")) {
                            r.setAttributeString(oarg.get(j + 1));
                            changed = true;
                        } else if (siop.equals("d") || siop.equals("dt") || siop.equals("datatype")) {
                            try {
                                r.datatype = (short)Integer.parseInt(oarg.get(j + 1));
                                changed = true;
                            }
                            catch (NumberFormatException nfe) {
                                System.err.println("Error: Invalid datatype " + oarg.get(j + 1) + " skipped.");
                            }
                        } else {
                            System.err.println("Unknown attribute type: " + oarg.get(j));
                            System.err.println("Should be one of: t[ype] i[d] n[ame] a[ttr[ib[utes]]] d[atatype]");
                        }
                        j += 2;
                    }
                    if (!changed) break;
                    try {
                        dp.setAttributes(type, id, r);
                    }
                    catch (DFFResourceAlreadyExistsException e) {
                        System.err.println("Error: " + KSFLUtilities.eccs(r.type) + " " + r.id + " already exists.");
                    }
                    break;
                }
                case 12: {
                    j = 0;
                    while (j + 3 <= oarg.size()) {
                        try {
                            len = Integer.parseInt(oarg.get(j + 2));
                            type = KSFLUtilities.ecc(oarg.get(j));
                            try {
                                id = Integer.parseInt(oarg.get(j + 1));
                                if (!dp.contains(type, id)) ** GOTO lbl401
                                dp.setLength(type, id, (long)len);
                                ** GOTO lbl423
lbl401:
                                // 1 sources

                                r = new DFFResource(type, id, new byte[len]);
                                try {
                                    dp.add(r);
                                }
                                catch (DFFResourceAlreadyExistsException siop) {
                                }
                            }
                            catch (NumberFormatException nfe) {
                                name = oarg.get(j + 1);
                                if (!dp.contains(type, name)) ** GOTO lbl414
                                dp.setLength(type, name, (long)len);
                                ** GOTO lbl423
lbl414:
                                // 1 sources

                                r = new DFFResource(type, dp.getNextAvailableID(type), name, new byte[len]);
                                try {
                                    dp.add(r);
                                }
                                catch (DFFResourceAlreadyExistsException var16_124) {}
                            }
                        }
                        catch (NumberFormatException nfe) {
                            System.err.println("Error: Invalid length " + oarg.get(j + 2) + " skipped.");
                        }
lbl423:
                        // 7 sources

                        j += 3;
                    }
                    break;
                }
                case 13: {
                    j = 0;
                    while (j + 3 <= oarg.size()) {
                        type = KSFLUtilities.ecc(oarg.get(j));
                        try {
                            id = Integer.parseInt(oarg.get(j + 1));
                            if (dp.contains(type, id)) {
                                stuff = null;
                                try {
                                    raf = new RandomAccessFile(new File(oarg.get(j + 2)), "r");
                                    stuff = new byte[(int)raf.length()];
                                    raf.readFully(stuff);
                                    raf.close();
                                }
                                catch (IOException e) {
                                    System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                                    stuff = null;
                                }
                                if (stuff != null) {
                                    dp.setData(type, id, stuff);
                                }
                            }
                        }
                        catch (NumberFormatException nfe) {
                            name = oarg.get(j + 1);
                            if (!dp.contains(type, name)) ** GOTO lbl464
                            stuff = null;
                            try {
                                raf = new RandomAccessFile(new File(oarg.get(j + 2)), "r");
                                stuff = new byte[(int)raf.length()];
                                raf.readFully(stuff);
                                raf.close();
                            }
                            catch (IOException e) {
                                System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                                stuff = null;
                            }
                            if (stuff == null) ** GOTO lbl464
                            dp.setData(type, name, stuff);
                        }
lbl464:
                        // 5 sources

                        j += 3;
                    }
                    break;
                }
                case 14: {
                    j = 0;
                    while (j + 3 <= oarg.size()) {
                        stuff = null;
                        try {
                            raf = new RandomAccessFile(new File(oarg.get(j + 2)), "r");
                            stuff = new byte[(int)raf.length()];
                            raf.readFully(stuff);
                            raf.close();
                        }
                        catch (IOException e) {
                            System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            stuff = null;
                        }
                        if (stuff != null) {
                            type = KSFLUtilities.ecc(oarg.get(j));
                            try {
                                id = Integer.parseInt(oarg.get(j + 1));
                                if (dp.contains(type, id)) {
                                    dp.setData(type, id, stuff);
                                } else {
                                    r = new DFFResource(type, id, stuff);
                                    try {
                                        dp.add(r);
                                    }
                                    catch (DFFResourceAlreadyExistsException e) {}
                                }
                            }
                            catch (NumberFormatException nfe) {
                                name = oarg.get(j + 1);
                                if (dp.contains(type, name)) {
                                    dp.setData(type, name, stuff);
                                }
                                r = new DFFResource(type, dp.getNextAvailableID(type), name, stuff);
                                try {
                                    dp.add(r);
                                }
                                catch (DFFResourceAlreadyExistsException var16_125) {
                                    // empty catch block
                                }
                            }
                        }
                        j += 3;
                    }
                    break;
                }
                default: {
                    System.err.println("Internal Error: Unimplemented Operation " + op.name());
                }
            }
            ++i;
        }
        if (dp != null) {
            dp.close();
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void doWinPEOperations(File f, List<Operation> ops, List<List<String>> oargs) {
        img = null;
        rd = null;
        modified = false;
        i = 0;
        while (i < ops.size() && i < oargs.size()) {
            block153: {
                block152: {
                    op = ops.get(i);
                    oarg = oargs.get(i);
                    if (op != Operation.CREATE) break block152;
                    img = new PEImage();
                    img.msdosStub = PEImage.MSDOS_STUB_DEFAULT;
                    img.peSignature = 17744;
                    img.machine = (short)332;
                    img.numSections = 1;
                    img.creationDate = (int)(System.currentTimeMillis() / 1000L);
                    img.symbolTablePtr = 0;
                    img.numSymbols = 0;
                    img.optHeaderSize = (short)224;
                    img.characteristics = (short)8451;
                    img.magic = (short)267;
                    img.linkerVersion = 0;
                    img.codeSize = 0;
                    img.dataSize = 0;
                    img.bssSize = 0;
                    img.entryPointOfst = 512;
                    img.codeOfst = 0;
                    img.dataOfst = 0;
                    img.base = 0x400000L;
                    img.sectionAlign = 512;
                    img.fileAlign = 512;
                    img.osVersion = 262144;
                    img.imageVersion = 0;
                    img.subsystemVersion = 262144;
                    img.win32versionValue = 0;
                    img.sizeOfImage = 1024;
                    img.sizeOfHeaders = 512;
                    img.checksum = 0;
                    img.subsystem = (short)2;
                    img.dllCharacteristics = (short)1024;
                    img.stackReserveSize = 0x100000L;
                    img.stackCommitSize = 4096L;
                    img.heapReserveSize = 0x100000L;
                    img.heapCommitSize = 4096L;
                    img.loaderFlags = 0;
                    img.numberOfRvaAndSizes = 16;
                    j = 0;
                    while (j < 16) {
                        img.dirEntries.add(new PEDirectoryEntry());
                        ++j;
                    }
                    img.dirEntries.get((int)2).virtualAddress = 512;
                    img.dirEntries.get((int)2).size = 0;
                    img.sections.add(new PESection());
                    v0 = new byte[8];
                    v0[0] = 46;
                    v0[1] = 114;
                    v0[2] = 115;
                    v0[3] = 114;
                    v0[4] = 99;
                    img.sections.get((int)0).name = v0;
                    img.sections.get((int)0).virtualSize = 0;
                    img.sections.get((int)0).virtualAddress = 512;
                    img.sections.get((int)0).rawDataSize = 0;
                    img.sections.get((int)0).rawDataOfst = 512;
                    img.sections.get((int)0).relocOfst = 0;
                    img.sections.get((int)0).lineNumOfst = 0;
                    img.sections.get((int)0).relocCnt = 0;
                    img.sections.get((int)0).lineNumCnt = 0;
                    img.sections.get((int)0).characteristics = 0x40000000;
                    img.sections.get((int)0).data = new byte[0];
                    rd = new PEResourceDirectory();
                    modified = true;
                    break block153;
                }
                if (img == null) {
                    try {
                        raf = new RandomAccessFile(f, "r");
                        img = new PEImage();
                        img.decompile(raf);
                        raf.close();
                        rl = img.ofstToSNO(img.dirEntries.get((int)2).virtualAddress, img.headerSize());
                        rs = img.sections.get(rl[0]);
                        rd = new PEResourceDirectory();
                        rd.decompile(rs.data, rl[1]);
                        modified = false;
                    }
                    catch (IOException e) {
                        System.err.println("Error: Invalid file (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                        return;
                    }
                }
                switch (KSFLCLI.$SWITCH_TABLE$com$kreative$ksfl$KSFLCLI$Operation()[op.ordinal()]) {
                    case 2: {
                        listrd = rd;
                        for (String name : oarg) {
                            found = false;
                            try {
                                id = Integer.parseInt(name);
                                for (Object e : listrd.entries) {
                                    if (e.name != null || e.id != id) continue;
                                    listrd = e instanceof PEResourceDirectory != false ? (PEResourceDirectory)e : null;
                                    found = true;
                                    break;
                                }
                            }
                            catch (NumberFormatException id) {
                                // empty catch block
                            }
                            if (!found) {
                                e = listrd.entries.iterator();
                                while (e.hasNext()) {
                                    e = e.next();
                                    if (e.name == null || !e.name.equals(name)) continue;
                                    listrd = e instanceof PEResourceDirectory != false ? (PEResourceDirectory)e : null;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                listrd = null;
                            }
                            if (listrd == null) break;
                        }
                        if (listrd == null) break;
                        for (PEResourceEntry e : listrd.entries) {
                            if (e instanceof PEResourceDirectory) {
                                System.out.print("d\t");
                            }
                            if (e instanceof PEResourceData) {
                                System.out.print("-\t");
                            }
                            System.out.print("\t" + (e.name == null ? "" : e.name));
                            System.out.println("\t" + e.id);
                        }
                        break;
                    }
                    case 3: {
                        nextrd = rd;
                        for (String name : oarg) {
                            found = false;
                            try {
                                id = Integer.parseInt(name);
                                for (Object e : nextrd.entries) {
                                    if (e.name != null || e.id != id) continue;
                                    nextrd = e instanceof PEResourceDirectory != false ? (PEResourceDirectory)e : null;
                                    found = true;
                                    break;
                                }
                            }
                            catch (NumberFormatException id) {
                                // empty catch block
                            }
                            if (!found) {
                                e = nextrd.entries.iterator();
                                while (e.hasNext()) {
                                    e = e.next();
                                    if (e.name == null || !e.name.equals(name)) continue;
                                    nextrd = e instanceof PEResourceDirectory != false ? (PEResourceDirectory)e : null;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                nextrd = null;
                            }
                            if (nextrd == null) break;
                        }
                        if (nextrd == null) break;
                        ids = new HashSet<Integer>();
                        for (PEResourceEntry e : nextrd.entries) {
                            ids.add(e.id);
                        }
                        id = 1;
                        while (ids.contains(id)) {
                            ++id;
                        }
                        System.out.println(id);
                        break;
                    }
                    case 4: {
                        if (oarg.size() < 2) break;
                        stuff = null;
                        try {
                            raf = new RandomAccessFile(new File(oarg.get(oarg.size() - 1)), "r");
                            stuff = new byte[(int)raf.length()];
                            raf.readFully(stuff);
                            raf.close();
                        }
                        catch (IOException e) {
                            System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            stuff = null;
                        }
                        if (stuff == null) break;
                        ne = new PEResourceData();
                        ne.data = stuff;
                        try {
                            ne.id = Integer.parseInt(oarg.get(oarg.size() - 2));
                            ne.name = null;
                        }
                        catch (NumberFormatException nfe) {
                            ne.id = -2147483648;
                            ne.name = oarg.get(oarg.size() - 2);
                        }
                        addrd = rd;
                        j = 0;
                        while (j < oarg.size() - 2) {
                            name = oarg.get(j);
                            found = false;
                            try {
                                id = Integer.parseInt(name);
                                for (Object e : addrd.entries) {
                                    if (e.name != null || e.id != id) continue;
                                    addrd = e instanceof PEResourceDirectory != false ? (PEResourceDirectory)e : null;
                                    found = true;
                                    break;
                                }
                            }
                            catch (NumberFormatException id) {
                                // empty catch block
                            }
                            if (!found) {
                                e = addrd.entries.iterator();
                                while (e.hasNext()) {
                                    e = e.next();
                                    if (e.name == null || !e.name.equals(name)) continue;
                                    addrd = e instanceof PEResourceDirectory != false ? (PEResourceDirectory)e : null;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                addrd = null;
                            }
                            if (addrd == null) break;
                            ++j;
                        }
                        if (addrd == null) break;
                        exists = false;
                        for (PEResourceEntry e : addrd.entries) {
                            if (e.name != null && ne.name != null && e.name.equals(ne.name)) {
                                exists = true;
                                continue;
                            }
                            if (e.name != null || ne.name != null || e.id != ne.id) continue;
                            exists = true;
                        }
                        if (exists) {
                            System.err.println("Error: Resource already exists.");
                            break;
                        }
                        addrd.entries.add(ne);
                        modified = true;
                        break;
                    }
                    case 5: {
                        verifyre = rd;
                        for (String name : oarg) {
                            if (!(verifyre instanceof PEResourceDirectory)) ** GOTO lbl258
                            found = false;
                            try {
                                id = Integer.parseInt(name);
                                for (Object e : verifyre.entries) {
                                    if (e.name != null || e.id != id) continue;
                                    verifyre = e;
                                    found = true;
                                    break;
                                }
                            }
                            catch (NumberFormatException id) {
                                // empty catch block
                            }
                            if (!found) {
                                e = verifyre.entries.iterator();
                                while (e.hasNext()) {
                                    e = e.next();
                                    if (e.name == null || !e.name.equals(name)) continue;
                                    verifyre = e;
                                    found = true;
                                    break;
                                }
                            }
                            if (found) continue;
                            verifyre = null;
                            continue;
lbl258:
                            // 1 sources

                            verifyre = null;
                        }
                        System.out.println(verifyre != null);
                        break;
                    }
                    case 6: {
                        extre = rd;
                        j = 0;
                        while (j < oarg.size() - 1) {
                            name = oarg.get(j);
                            if (!(extre instanceof PEResourceDirectory)) ** GOTO lbl290
                            found = false;
                            try {
                                id = Integer.parseInt(name);
                                for (Object e : extre.entries) {
                                    if (e.name != null || e.id != id) continue;
                                    extre = e;
                                    found = true;
                                    break;
                                }
                            }
                            catch (NumberFormatException id) {
                                // empty catch block
                            }
                            if (!found) {
                                e = extre.entries.iterator();
                                while (e.hasNext()) {
                                    e = e.next();
                                    if (e.name == null || !e.name.equals(name)) continue;
                                    extre = e;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                extre = null;
                            }
                            ** GOTO lbl291
lbl290:
                            // 1 sources

                            extre = null;
lbl291:
                            // 2 sources

                            ++j;
                        }
                        if (extre == null || oarg.isEmpty()) break;
                        KSFLCLI.winPEExtract((PEResourceEntry)extre, new File(oarg.get(oarg.size() - 1)));
                        break;
                    }
                    case 7: {
                        infore = rd;
                        for (String name : oarg) {
                            if (!(infore instanceof PEResourceDirectory)) ** GOTO lbl322
                            found = false;
                            try {
                                id = Integer.parseInt(name);
                                for (Object e : infore.entries) {
                                    if (e.name != null || e.id != id) continue;
                                    infore = e;
                                    found = true;
                                    break;
                                }
                            }
                            catch (NumberFormatException id) {
                                // empty catch block
                            }
                            if (!found) {
                                e = infore.entries.iterator();
                                while (e.hasNext()) {
                                    e = e.next();
                                    if (e.name == null || !e.name.equals(name)) continue;
                                    infore = e;
                                    found = true;
                                    break;
                                }
                            }
                            if (found) continue;
                            infore = null;
                            continue;
lbl322:
                            // 1 sources

                            infore = null;
                        }
                        if (infore == null) break;
                        System.out.println("ID:   " + infore.id);
                        System.out.println("Name: " + (infore.name == null ? "" : infore.name));
                        if (infore instanceof PEResourceData) {
                            System.out.println("CP:   " + ((PEResourceData)infore).codePage);
                            System.out.println("Len:  " + ((PEResourceData)infore).data.length);
                        }
                        if (!(infore instanceof PEResourceDirectory)) break;
                        System.out.println("Char: " + Integer.toHexString(((PEResourceDirectory)infore).characteristics).toUpperCase());
                        System.out.println("Time: " + Integer.toHexString(((PEResourceDirectory)infore).timeStamp).toUpperCase());
                        System.out.println("Vers: " + Integer.toHexString(((PEResourceDirectory)infore).resourceVersion).toUpperCase());
                        System.out.println("Cnt:  " + ((PEResourceDirectory)infore).entries.size());
                        break;
                    }
                    case 8: {
                        catre = rd;
                        for (String name : oarg) {
                            if (!(catre instanceof PEResourceDirectory)) ** GOTO lbl362
                            found = false;
                            try {
                                id = Integer.parseInt(name);
                                for (Object e : catre.entries) {
                                    if (e.name != null || e.id != id) continue;
                                    catre = e;
                                    found = true;
                                    break;
                                }
                            }
                            catch (NumberFormatException id) {
                                // empty catch block
                            }
                            if (!found) {
                                e = catre.entries.iterator();
                                while (e.hasNext()) {
                                    e = e.next();
                                    if (e.name == null || !e.name.equals(name)) continue;
                                    catre = e;
                                    found = true;
                                    break;
                                }
                            }
                            if (found) continue;
                            catre = null;
                            continue;
lbl362:
                            // 1 sources

                            catre = null;
                        }
                        if (!(catre instanceof PEResourceData)) break;
                        try {
                            System.out.write(((PEResourceData)catre).data);
                        }
                        catch (IOException name) {}
                        break;
                    }
                    case 9: {
                        hexcatre = rd;
                        for (String name : oarg) {
                            if (!(hexcatre instanceof PEResourceDirectory)) ** GOTO lbl396
                            found = false;
                            try {
                                id = Integer.parseInt(name);
                                for (Object e : hexcatre.entries) {
                                    if (e.name != null || e.id != id) continue;
                                    hexcatre = e;
                                    found = true;
                                    break;
                                }
                            }
                            catch (NumberFormatException id) {
                                // empty catch block
                            }
                            if (!found) {
                                e = hexcatre.entries.iterator();
                                while (e.hasNext()) {
                                    e = e.next();
                                    if (e.name == null || !e.name.equals(name)) continue;
                                    hexcatre = e;
                                    found = true;
                                    break;
                                }
                            }
                            if (found) continue;
                            hexcatre = null;
                            continue;
lbl396:
                            // 1 sources

                            hexcatre = null;
                        }
                        if (!(hexcatre instanceof PEResourceData)) break;
                        KSFLUtilities.printHexDump(System.out, ((PEResourceData)hexcatre).data);
                        break;
                    }
                    case 10: {
                        delrd = null;
                        delre = rd;
                        for (String name : oarg) {
                            if (!(delre instanceof PEResourceDirectory)) ** GOTO lbl429
                            delrd = delre;
                            found = false;
                            try {
                                id = Integer.parseInt(name);
                                for (Object e : delre.entries) {
                                    if (e.name != null || e.id != id) continue;
                                    delre = e;
                                    found = true;
                                    break;
                                }
                            }
                            catch (NumberFormatException id) {
                                // empty catch block
                            }
                            if (!found) {
                                e = delre.entries.iterator();
                                while (e.hasNext()) {
                                    e = e.next();
                                    if (e.name == null || !e.name.equals(name)) continue;
                                    delre = e;
                                    found = true;
                                    break;
                                }
                            }
                            if (found) continue;
                            delre = null;
                            continue;
lbl429:
                            // 1 sources

                            delrd = null;
                            delre = null;
                        }
                        if (delrd == null || delre == null) break;
                        delrd.entries.remove(delre);
                        modified = true;
                        break;
                    }
                    case 11: {
                        if (oarg.isEmpty()) break;
                        setinford = null;
                        setinfore = rd;
                        j = 0;
                        while (j < oarg.size() - 1) {
                            name = oarg.get(j);
                            if (!(setinfore instanceof PEResourceDirectory)) ** GOTO lbl468
                            setinford = setinfore;
                            found = false;
                            try {
                                id = Integer.parseInt(name);
                                for (Object e : setinfore.entries) {
                                    if (e.name != null || e.id != id) continue;
                                    setinfore = e;
                                    found = true;
                                    break;
                                }
                            }
                            catch (NumberFormatException id) {
                                // empty catch block
                            }
                            if (!found) {
                                e = setinfore.entries.iterator();
                                while (e.hasNext()) {
                                    e = e.next();
                                    if (e.name == null || !e.name.equals(name)) continue;
                                    setinfore = e;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                setinfore = null;
                            }
                            ** GOTO lbl470
lbl468:
                            // 1 sources

                            setinford = null;
                            setinfore = null;
lbl470:
                            // 2 sources

                            ++j;
                        }
                        if (setinford == null || setinfore == null) break;
                        try {
                            id = Integer.parseInt(oarg.get(oarg.size() - 1));
                            exists = false;
                            for (PEResourceEntry e : setinford.entries) {
                                if (e.name != null || e.id != id) continue;
                                exists = true;
                            }
                            if (exists) {
                                System.err.println("Error: Resource already exists.");
                                break;
                            }
                            setinfore.id = id;
                            setinfore.name = null;
                            modified = true;
                            break;
                        }
                        catch (NumberFormatException nfe) {
                            name = oarg.get(oarg.size() - 1);
                            exists = false;
                            e = setinford.entries.iterator();
                            ** while (e.hasNext())
                        }
lbl-1000:
                        // 1 sources

                        {
                            e = e.next();
                            if (e.name == null || !e.name.equals(name)) continue;
                            exists = true;
                            continue;
                        }
lbl496:
                        // 1 sources

                        if (exists) {
                            System.err.println("Error: Resource already exists.");
                            break;
                        }
                        setinfore.id = -2147483648;
                        setinfore.name = name;
                        modified = true;
                        break;
                    }
                    case 12: {
                        if (oarg.size() < 2) break;
                        try {
                            len = Integer.parseInt(oarg.get(oarg.size() - 1));
                            ne = new PEResourceData();
                            try {
                                ne.id = Integer.parseInt(oarg.get(oarg.size() - 2));
                                ne.name = null;
                            }
                            catch (NumberFormatException nfe) {
                                ne.id = -2147483648;
                                ne.name = oarg.get(oarg.size() - 2);
                            }
                            addrd = rd;
                            j = 0;
                            while (j < oarg.size() - 2) {
                                name = oarg.get(j);
                                found = false;
                                try {
                                    id = Integer.parseInt(name);
                                    for (Object e : addrd.entries) {
                                        if (e.name != null || e.id != id) continue;
                                        addrd = e instanceof PEResourceDirectory != false ? (PEResourceDirectory)e : null;
                                        found = true;
                                        break;
                                    }
                                }
                                catch (NumberFormatException id) {
                                    // empty catch block
                                }
                                if (!found) {
                                    e = addrd.entries.iterator();
                                    while (e.hasNext()) {
                                        e = e.next();
                                        if (e.name == null || !e.name.equals(name)) continue;
                                        addrd = e instanceof PEResourceDirectory != false ? (PEResourceDirectory)e : null;
                                        found = true;
                                        break;
                                    }
                                }
                                if (!found) {
                                    addrd = null;
                                }
                                if (addrd == null) break;
                                ++j;
                            }
                            if (addrd == null) break;
                            exists = false;
                            for (PEResourceEntry e : addrd.entries) {
                                if (e.name != null && ne.name != null && e.name.equals(ne.name)) {
                                    if (e instanceof PEResourceData) {
                                        ((PEResourceData)e).data = KSFLUtilities.resize(((PEResourceData)e).data, len);
                                        modified = true;
                                    }
                                    exists = true;
                                    continue;
                                }
                                if (e.name != null || ne.name != null || e.id != ne.id) continue;
                                if (e instanceof PEResourceData) {
                                    ((PEResourceData)e).data = KSFLUtilities.resize(((PEResourceData)e).data, len);
                                    modified = true;
                                }
                                exists = true;
                            }
                            if (exists) break;
                            ne.data = new byte[len];
                            addrd.entries.add(ne);
                            modified = true;
                        }
                        catch (NumberFormatException nfe) {
                            System.err.println("Error: Invalid length " + oarg.get(oarg.size() - 1) + " skipped.");
                        }
                        break;
                    }
                    case 13: {
                        if (oarg.size() < 2) break;
                        stuff = null;
                        try {
                            raf = new RandomAccessFile(new File(oarg.get(oarg.size() - 1)), "r");
                            stuff = new byte[(int)raf.length()];
                            raf.readFully(stuff);
                            raf.close();
                        }
                        catch (IOException e) {
                            System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                        }
                        if (stuff == null) break;
                        ne = new PEResourceData();
                        ne.data = stuff;
                        try {
                            ne.id = Integer.parseInt(oarg.get(oarg.size() - 2));
                            ne.name = null;
                        }
                        catch (NumberFormatException nfe) {
                            ne.id = -2147483648;
                            ne.name = oarg.get(oarg.size() - 2);
                        }
                        addrd = rd;
                        j = 0;
                        while (j < oarg.size() - 2) {
                            name = oarg.get(j);
                            found = false;
                            try {
                                id = Integer.parseInt(name);
                                for (Object e : addrd.entries) {
                                    if (e.name != null || e.id != id) continue;
                                    addrd = e instanceof PEResourceDirectory != false ? (PEResourceDirectory)e : null;
                                    found = true;
                                    break;
                                }
                            }
                            catch (NumberFormatException id) {
                                // empty catch block
                            }
                            if (!found) {
                                e = addrd.entries.iterator();
                                while (e.hasNext()) {
                                    e = e.next();
                                    if (e.name == null || !e.name.equals(name)) continue;
                                    addrd = e instanceof PEResourceDirectory != false ? (PEResourceDirectory)e : null;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                addrd = null;
                            }
                            if (addrd == null) break;
                            ++j;
                        }
                        if (addrd == null) break;
                        for (PEResourceEntry e : addrd.entries) {
                            if (e.name != null && ne.name != null && e.name.equals(ne.name)) {
                                if (!(e instanceof PEResourceData)) continue;
                                ((PEResourceData)e).data = stuff;
                                modified = true;
                                continue;
                            }
                            if (e.name != null || ne.name != null || e.id != ne.id || !(e instanceof PEResourceData)) continue;
                            ((PEResourceData)e).data = stuff;
                            modified = true;
                        }
                        break;
                    }
                    case 14: {
                        if (oarg.size() < 2) break;
                        stuff = null;
                        try {
                            raf = new RandomAccessFile(new File(oarg.get(oarg.size() - 1)), "r");
                            stuff = new byte[(int)raf.length()];
                            raf.readFully(stuff);
                            raf.close();
                        }
                        catch (IOException e) {
                            System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                        }
                        if (stuff == null) break;
                        ne = new PEResourceData();
                        ne.data = stuff;
                        try {
                            ne.id = Integer.parseInt(oarg.get(oarg.size() - 2));
                            ne.name = null;
                        }
                        catch (NumberFormatException nfe) {
                            ne.id = -2147483648;
                            ne.name = oarg.get(oarg.size() - 2);
                        }
                        addrd = rd;
                        j = 0;
                        while (j < oarg.size() - 2) {
                            name = oarg.get(j);
                            found = false;
                            try {
                                id = Integer.parseInt(name);
                                for (Object e : addrd.entries) {
                                    if (e.name != null || e.id != id) continue;
                                    addrd = e instanceof PEResourceDirectory != false ? (PEResourceDirectory)e : null;
                                    found = true;
                                    break;
                                }
                            }
                            catch (NumberFormatException id) {
                                // empty catch block
                            }
                            if (!found) {
                                for (PEResourceEntry e : addrd.entries) {
                                    if (e.name == null || !e.name.equals(name)) continue;
                                    addrd = e instanceof PEResourceDirectory != false ? (PEResourceDirectory)e : null;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                addrd = null;
                            }
                            if (addrd == null) break;
                            ++j;
                        }
                        if (addrd == null) break;
                        exists = false;
                        for (PEResourceEntry e : addrd.entries) {
                            if (e.name != null && ne.name != null && e.name.equals(ne.name)) {
                                if (e instanceof PEResourceData) {
                                    ((PEResourceData)e).data = stuff;
                                    modified = true;
                                }
                                exists = true;
                                continue;
                            }
                            if (e.name != null || ne.name != null || e.id != ne.id) continue;
                            if (e instanceof PEResourceData) {
                                ((PEResourceData)e).data = stuff;
                                modified = true;
                            }
                            exists = true;
                        }
                        if (exists) break;
                        addrd.entries.add(ne);
                        modified = true;
                        break;
                    }
                    default: {
                        System.err.println("Internal Error: Unimplemented Operation " + op.name());
                    }
                }
            }
            ++i;
        }
        if (img != null && modified) {
            try {
                raf = new RandomAccessFile(f, "rwd");
                raf.setLength(0L);
                rl = img.ofstToSNO(img.dirEntries.get((int)2).virtualAddress, img.headerSize());
                rs = img.sections.get(rl[0]);
                rs.data = new byte[rd.calculateTotalLength()];
                rd.recompile(rs.data, rl[1]);
                img.recalculate();
                img.recompile(raf);
                raf.close();
            }
            catch (IOException e) {
                System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
            }
        }
    }

    private static void winPEExtract(PEResourceEntry re, File f) {
        if (re instanceof PEResourceData) {
            try {
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(((PEResourceData)re).data);
                fos.close();
            }
            catch (IOException e) {
                System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
            }
        } else if (re instanceof PEResourceDirectory) {
            f.mkdir();
            for (PEResourceEntry subre : ((PEResourceDirectory)re).entries) {
                KSFLCLI.winPEExtract(subre, new File(f, subre.name != null ? subre.name : Integer.toString(subre.id)));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void doPRCOperations(File f, List<Operation> ops, List<List<String>> oargs) {
        rp = null;
        i = 0;
        while (i < ops.size() && i < oargs.size()) {
            op = ops.get(i);
            oarg = oargs.get(i);
            if (op == Operation.CREATE) {
                try {
                    rp = new PalmResourceFile(f, "rwd", 2);
                }
                catch (IOException e) {
                    System.err.println("Error: Invalid file (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                    return;
                }
            }
            if (rp == null) {
                try {
                    try {
                        rp = new PalmResourceFile(f, "rwd", 0);
                    }
                    catch (SecurityException e) {
                        rp = new PalmResourceFile(f, "r", 0);
                        System.err.println("Warning: Opened read-only");
                    }
                }
                catch (IOException e) {
                    System.err.println("Error: Invalid file (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                    return;
                }
            }
            switch (KSFLCLI.$SWITCH_TABLE$com$kreative$ksfl$KSFLCLI$Operation()[op.ordinal()]) {
                case 2: {
                    if (oarg.isEmpty()) {
                        var10_75 = rp.getTypes();
                        var9_48 = var10_75.length;
                        var8_26 = 0;
                        while (var8_26 < var9_48) {
                            type = var10_75[var8_26];
                            System.out.println(String.valueOf(KSFLUtilities.fccs(type)) + "\t" + rp.getResourceCount(type));
                            ++var8_26;
                        }
                    } else {
                        for (String typestr : oarg) {
                            type = KSFLUtilities.fcc(typestr);
                            var13_111 = rp.getIDs(type);
                            var12_104 = var13_111.length;
                            var11_90 = 0;
                            while (var11_90 < var12_104) {
                                id = var13_111[var11_90];
                                System.out.println(String.valueOf(KSFLUtilities.fccs(type)) + "\t" + id);
                                ++var11_90;
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    j = 0;
                    while (j < oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j++));
                        if (j < oarg.size()) {
                            try {
                                id = (short)Integer.parseInt(oarg.get(j));
                                System.out.println(String.valueOf(KSFLUtilities.fccs(type)) + "\t" + rp.getNextAvailableID(type, id));
                                ++j;
                            }
                            catch (NumberFormatException nfe) {
                                System.out.println(String.valueOf(KSFLUtilities.fccs(type)) + "\t" + rp.getNextAvailableID(type));
                            }
                            continue;
                        }
                        System.out.println(String.valueOf(KSFLUtilities.fccs(type)) + "\t" + rp.getNextAvailableID(type));
                    }
                    break;
                }
                case 4: {
                    if (oarg.isEmpty()) break;
                    stuff = null;
                    try {
                        raf = new RandomAccessFile(new File(oarg.get(oarg.size() - 1)), "r");
                        stuff = new byte[(int)raf.length()];
                        raf.readFully(stuff);
                        raf.close();
                    }
                    catch (IOException e) {
                        System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                        stuff = null;
                    }
                    if (stuff == null) break;
                    try {
                        type = oarg.size() > 1 ? KSFLUtilities.fcc(oarg.get(0)) : 0x44415441;
                        id = oarg.size() > 2 ? (short)Integer.parseInt(oarg.get(1)) : rp.getNextAvailableID(type);
                        r = new PalmResource(type, id, stuff);
                        try {
                            rp.add(r);
                        }
                        catch (PalmResourceAlreadyExistsException e) {
                            System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + id + " already exists.");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Error: Invalid number skipped.");
                    }
                    break;
                }
                case 5: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j));
                        try {
                            id = (short)Integer.parseInt(oarg.get(j + 1));
                            System.out.println(rp.contains(type, id));
                        }
                        catch (NumberFormatException nfe) {
                            System.err.println("Error: Invalid ID number " + oarg.get(j + 1) + " skipped.");
                        }
                        j += 2;
                    }
                    break;
                }
                case 6: {
                    if (oarg.size() == 1) {
                        f1 = new File(oarg.get(0));
                        f1.mkdir();
                        e = rp.getTypes();
                        r = e.length;
                        nfe = 0;
                        while (nfe < r) {
                            type = e[nfe];
                            f2 = new File(f1, KSFLUtilities.fccs(type));
                            f2.mkdir();
                            var16_119 = rp.getIDs(type);
                            var15_116 = var16_119.length;
                            var14_114 = 0;
                            while (var14_114 < var15_116) {
                                id = var16_119[var14_114];
                                r = rp.get(type, id);
                                n = Integer.toString(r.id);
                                try {
                                    fos = new FileOutputStream(new File(f2, n));
                                    fos.write(r.data);
                                    fos.close();
                                }
                                catch (IOException e) {
                                    System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                                }
                                ++var14_114;
                            }
                            ++nfe;
                        }
                        try {
                            fos = new FileOutputStream(new File(f1, "header.bin"));
                            fos.write(rp.getPRCHeader());
                            fos.close();
                        }
                        catch (IOException e) {
                            System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                        }
                        break;
                    }
                    if (oarg.size() == 2) {
                        f1 = new File(oarg.get(1));
                        f1.mkdir();
                        type = KSFLUtilities.fcc(oarg.get(0));
                        f2 = rp.getIDs(type);
                        e = f2.length;
                        r = 0;
                        while (r < e) {
                            id = f2[r];
                            r = rp.get(type, id);
                            n = Integer.toString(r.id);
                            try {
                                fos = new FileOutputStream(new File(f1, n));
                                fos.write(r.data);
                                fos.close();
                            }
                            catch (IOException e) {
                                System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            }
                            ++r;
                        }
                        break;
                    }
                    j = 0;
                    while (j + 3 <= oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j));
                        try {
                            id = (short)Integer.parseInt(oarg.get(j + 1));
                            data = rp.getData(type, id);
                            if (data == null) {
                                System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + id + " does not exist.");
                            } else {
                                try {
                                    fos = new FileOutputStream(new File(oarg.get(j + 2)));
                                    fos.write(data);
                                    fos.close();
                                }
                                catch (IOException e) {
                                    System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                                }
                            }
                        }
                        catch (NumberFormatException nfe) {
                            System.err.println("Error: Invalid ID number " + oarg.get(j + 1) + " skipped.");
                        }
                        j += 3;
                    }
                    break;
                }
                case 7: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j));
                        try {
                            id = (short)Integer.parseInt(oarg.get(j + 1));
                            r = rp.get(type, id);
                            if (r == null) {
                                System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + id + " does not exist.");
                            } else {
                                ts = KSFLUtilities.fccs(r.type);
                                th = "00000000" + Integer.toHexString(r.type).toUpperCase();
                                System.out.println("Type: " + ts + " (0x" + th.substring(th.length() - 8) + ")");
                                System.out.println("ID:   " + r.id);
                                System.out.println("Len:  " + r.data.length);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            System.err.println("Error: Invalid ID number " + oarg.get(j + 1) + " skipped.");
                        }
                        j += 2;
                    }
                    break;
                }
                case 8: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j));
                        try {
                            id = (short)Integer.parseInt(oarg.get(j + 1));
                            data = rp.getData(type, id);
                            if (data == null) {
                                System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + oarg.get(j + 1) + " does not exist.");
                            } else {
                                try {
                                    System.out.write(data);
                                }
                                catch (IOException ts) {}
                            }
                        }
                        catch (NumberFormatException nfe) {
                            System.err.println("Error: Invalid ID number " + oarg.get(j + 1) + " skipped.");
                        }
                        j += 2;
                    }
                    break;
                }
                case 9: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j));
                        try {
                            id = (short)Integer.parseInt(oarg.get(j + 1));
                            data = rp.getData(type, id);
                            if (data == null) {
                                System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + oarg.get(j + 1) + " does not exist.");
                            } else {
                                KSFLUtilities.printHexDump(System.out, data);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            System.err.println("Error: Invalid ID number " + oarg.get(j + 1) + " skipped.");
                        }
                        j += 2;
                    }
                    break;
                }
                case 10: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j));
                        try {
                            id = (short)Integer.parseInt(oarg.get(j + 1));
                            rp.remove(type, id);
                        }
                        catch (NumberFormatException nfe) {
                            System.err.println("Error: Invalid ID number " + oarg.get(j + 1) + " skipped.");
                        }
                        j += 2;
                    }
                    break;
                }
                case 11: {
                    if (oarg.size() < 2) break;
                    type = KSFLUtilities.fcc(oarg.get(0));
                    r = null;
                    try {
                        id = (short)Integer.parseInt(oarg.get(1));
                        r = rp.get(type, id);
                        if (r == null) {
                            System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + oarg.get(1) + " doesn't exist.");
                            break;
                        }
                        changed = false;
                        j = 2;
                        while (j + 2 <= oarg.size()) {
                            siop = oarg.get(j).trim().toLowerCase();
                            if (siop.equals("t") || siop.equals("type")) {
                                r.type = KSFLUtilities.fcc(oarg.get(j + 1));
                                changed = true;
                            } else if (siop.equals("i") || siop.equals("id")) {
                                try {
                                    r.id = (short)Integer.parseInt(oarg.get(j + 1));
                                    changed = true;
                                }
                                catch (NumberFormatException nfe) {
                                    System.err.println("Warning: Invalid ID number " + oarg.get(j + 1) + " skipped.");
                                }
                            } else {
                                System.err.println("Unknown attribute type: " + oarg.get(j));
                                System.err.println("Should be one of: t[ype] i[d]");
                            }
                            j += 2;
                        }
                        if (!changed) break;
                        try {
                            rp.setAttributes(type, id, r);
                        }
                        catch (PalmResourceAlreadyExistsException e) {
                            System.err.println("Error: " + KSFLUtilities.fccs(r.type) + " " + r.id + " already exists.");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Error: Invalid ID number " + oarg.get(1) + " skipped.");
                    }
                    break;
                }
                case 12: {
                    j = 0;
                    while (j + 3 <= oarg.size()) {
                        try {
                            len = Integer.parseInt(oarg.get(j + 2));
                            type = KSFLUtilities.fcc(oarg.get(j));
                            try {
                                id = (short)Integer.parseInt(oarg.get(j + 1));
                                if (!rp.contains(type, id)) ** GOTO lbl313
                                rp.setData(type, id, KSFLUtilities.resize(rp.getData(type, id), len));
                                ** GOTO lbl325
lbl313:
                                // 1 sources

                                r = new PalmResource(type, id, new byte[len]);
                                try {
                                    rp.add(r);
                                }
                                catch (PalmResourceAlreadyExistsException var12_109) {
                                }
                            }
                            catch (NumberFormatException nfe) {
                                System.err.println("Error: Invalid ID number " + oarg.get(j + 1) + " skipped.");
                            }
                        }
                        catch (NumberFormatException nfe) {
                            System.err.println("Error: Invalid length " + oarg.get(j + 2) + " skipped.");
                        }
lbl325:
                        // 5 sources

                        j += 3;
                    }
                    break;
                }
                case 13: {
                    j = 0;
                    while (j + 3 <= oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j));
                        try {
                            id = (short)Integer.parseInt(oarg.get(j + 1));
                            if (rp.contains(type, id)) {
                                stuff = null;
                                try {
                                    raf = new RandomAccessFile(new File(oarg.get(j + 2)), "r");
                                    stuff = new byte[(int)raf.length()];
                                    raf.readFully(stuff);
                                    raf.close();
                                }
                                catch (IOException e) {
                                    System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                                    stuff = null;
                                }
                                if (stuff != null) {
                                    rp.setData(type, id, stuff);
                                }
                            }
                        }
                        catch (NumberFormatException nfe) {
                            System.err.println("Error: Invalid ID number " + oarg.get(j + 1) + " skipped.");
                        }
                        j += 3;
                    }
                    break;
                }
                case 14: {
                    j = 0;
                    while (j + 3 <= oarg.size()) {
                        stuff = null;
                        try {
                            raf = new RandomAccessFile(new File(oarg.get(j + 2)), "r");
                            stuff = new byte[(int)raf.length()];
                            raf.readFully(stuff);
                            raf.close();
                        }
                        catch (IOException e) {
                            System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            stuff = null;
                        }
                        if (stuff != null) {
                            type = KSFLUtilities.fcc(oarg.get(j));
                            try {
                                id = (short)Integer.parseInt(oarg.get(j + 1));
                                if (rp.contains(type, id)) {
                                    rp.setData(type, id, stuff);
                                } else {
                                    r = new PalmResource(type, id, stuff);
                                    try {
                                        rp.add(r);
                                    }
                                    catch (PalmResourceAlreadyExistsException var12_110) {}
                                }
                            }
                            catch (NumberFormatException nfe) {
                                System.err.println("Error: Invalid ID number " + oarg.get(j + 1) + " skipped.");
                            }
                        }
                        j += 3;
                    }
                    break;
                }
                default: {
                    System.err.println("Internal Error: Unimplemented Operation " + op.name());
                }
            }
            ++i;
        }
        if (rp != null) {
            rp.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void doRsrcOperations(File f, List<Operation> ops, List<List<String>> oargs) {
        rp = null;
        i = 0;
        while (i < ops.size() && i < oargs.size()) {
            op = ops.get(i);
            oarg = oargs.get(i);
            if (op == Operation.CREATE) {
                try {
                    rp = new MacResourceFile(f, "rwd", 2);
                }
                catch (IOException e) {
                    System.err.println("Error: Invalid file (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                    return;
                }
            }
            if (rp == null) {
                try {
                    try {
                        rp = new MacResourceFile(f, "rwd", 0);
                    }
                    catch (SecurityException e) {
                        rp = new MacResourceFile(f, "r", 0);
                        System.err.println("Warning: Opened read-only");
                    }
                }
                catch (IOException e) {
                    System.err.println("Error: Invalid file (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                    return;
                }
            }
            switch (KSFLCLI.$SWITCH_TABLE$com$kreative$ksfl$KSFLCLI$Operation()[op.ordinal()]) {
                case 2: {
                    if (oarg.isEmpty()) {
                        var10_74 = rp.getTypes();
                        var9_46 = var10_74.length;
                        var8_26 = 0;
                        while (var8_26 < var9_46) {
                            type = var10_74[var8_26];
                            System.out.println(String.valueOf(KSFLUtilities.fccs(type)) + "\t" + rp.getResourceCount(type));
                            ++var8_26;
                        }
                    } else {
                        for (String typestr : oarg) {
                            type = KSFLUtilities.fcc(typestr);
                            var13_119 = rp.getIDs(type);
                            var12_108 = var13_119.length;
                            var11_91 = 0;
                            while (var11_91 < var12_108) {
                                id = var13_119[var11_91];
                                System.out.println(String.valueOf(KSFLUtilities.fccs(type)) + "\t" + id + "\t" + rp.getNameFromID(type, id));
                                ++var11_91;
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    j = 0;
                    while (j < oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j++));
                        if (j < oarg.size()) {
                            try {
                                id = (short)Integer.parseInt(oarg.get(j));
                                System.out.println(String.valueOf(KSFLUtilities.fccs(type)) + "\t" + rp.getNextAvailableID(type, id));
                                ++j;
                            }
                            catch (NumberFormatException nfe) {
                                System.out.println(String.valueOf(KSFLUtilities.fccs(type)) + "\t" + rp.getNextAvailableID(type));
                            }
                            continue;
                        }
                        System.out.println(String.valueOf(KSFLUtilities.fccs(type)) + "\t" + rp.getNextAvailableID(type));
                    }
                    break;
                }
                case 4: {
                    if (oarg.isEmpty()) break;
                    stuff = null;
                    try {
                        raf = new RandomAccessFile(new File(oarg.get(oarg.size() - 1)), "r");
                        stuff = new byte[(int)raf.length()];
                        raf.readFully(stuff);
                        raf.close();
                    }
                    catch (IOException e) {
                        System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                        stuff = null;
                    }
                    if (stuff == null) break;
                    try {
                        type = oarg.size() > 1 ? KSFLUtilities.fcc(oarg.get(0)) : 0x44415441;
                        id = oarg.size() > 2 ? (short)Integer.parseInt(oarg.get(1)) : rp.getNextAvailableID(type);
                        r = new MacResource(type, id, stuff);
                        if (oarg.size() > 3) {
                            r.name = oarg.get(2);
                        }
                        if (oarg.size() > 4) {
                            r.setAttributeString(oarg.get(3));
                        }
                        try {
                            rp.add(r);
                        }
                        catch (MacResourceAlreadyExistsException e) {
                            System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + id + " already exists.");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Error: Invalid number skipped.");
                    }
                    break;
                }
                case 5: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j));
                        try {
                            id = (short)Integer.parseInt(oarg.get(j + 1));
                            System.out.println(rp.contains(type, id));
                        }
                        catch (NumberFormatException nfe) {
                            System.out.println(rp.contains(type, oarg.get(j + 1)));
                        }
                        j += 2;
                    }
                    break;
                }
                case 6: {
                    if (oarg.size() == 1) {
                        f1 = new File(oarg.get(0));
                        f1.mkdir();
                        e = rp.getTypes();
                        r = e.length;
                        nfe = 0;
                        while (nfe < r) {
                            type = e[nfe];
                            f2 = new File(f1, KSFLUtilities.fccs(type));
                            f2.mkdir();
                            var16_130 = rp.getIDs(type);
                            var15_126 = var16_130.length;
                            var14_124 = 0;
                            while (var14_124 < var15_126) {
                                id = var16_130[var14_124];
                                r = rp.get(type, id);
                                n = Integer.toString(r.id);
                                if (r.name != null && r.name.length() > 0) {
                                    n = String.valueOf(n) + " " + r.name;
                                }
                                try {
                                    fos = new FileOutputStream(new File(f2, n));
                                    fos.write(r.data);
                                    fos.close();
                                }
                                catch (IOException e) {
                                    System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                                }
                                try {
                                    dos = new DataOutputStream(new FileOutputStream(new File(f2, String.valueOf(n) + ".rsrcmeta")));
                                    dos.writeInt(r.type);
                                    dos.writeShort(r.id);
                                    dos.writeByte(r.getAttributes());
                                    dos.writeUTF(r.name);
                                    dos.close();
                                }
                                catch (IOException e) {
                                    System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                                }
                                ++var14_124;
                            }
                            ++nfe;
                        }
                        break;
                    }
                    if (oarg.size() == 2) {
                        f1 = new File(oarg.get(1));
                        f1.mkdir();
                        type = KSFLUtilities.fcc(oarg.get(0));
                        f2 = rp.getIDs(type);
                        e = f2.length;
                        r = 0;
                        while (r < e) {
                            id = f2[r];
                            r = rp.get(type, id);
                            n = Integer.toString(r.id);
                            if (r.name != null && r.name.length() > 0) {
                                n = String.valueOf(n) + " " + r.name;
                            }
                            try {
                                fos = new FileOutputStream(new File(f1, n));
                                fos.write(r.data);
                                fos.close();
                            }
                            catch (IOException e) {
                                System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            }
                            try {
                                dos = new DataOutputStream(new FileOutputStream(new File(f1, String.valueOf(n) + ".rsrcmeta")));
                                dos.writeInt(r.type);
                                dos.writeShort(r.id);
                                dos.writeByte(r.getAttributes());
                                dos.writeUTF(r.name);
                                dos.close();
                            }
                            catch (IOException e) {
                                System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            }
                            ++r;
                        }
                        break;
                    }
                    j = 0;
                    while (j + 3 <= oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j));
                        try {
                            id = (short)Integer.parseInt(oarg.get(j + 1));
                            data = rp.getData(type, id);
                            if (data == null) {
                                System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + id + " does not exist.");
                            } else {
                                try {
                                    fos = new FileOutputStream(new File(oarg.get(j + 2)));
                                    fos.write(data);
                                    fos.close();
                                }
                                catch (IOException e) {
                                    System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                                }
                            }
                        }
                        catch (NumberFormatException nfe) {
                            data = rp.getData(type, oarg.get(j + 1));
                            try {
                                fos = new FileOutputStream(new File(oarg.get(j + 2)));
                                fos.write(data);
                                fos.close();
                            }
                            catch (IOException e) {
                                System.err.println("Error: Cannot write (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            }
                        }
                        j += 3;
                    }
                    break;
                }
                case 7: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j));
                        try {
                            id = (short)Integer.parseInt(oarg.get(j + 1));
                            r = rp.get(type, id);
                            if (r == null) {
                                System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + id + " does not exist.");
                            } else {
                                ts = KSFLUtilities.fccs(r.type);
                                th = "00000000" + Integer.toHexString(r.type).toUpperCase();
                                System.out.println("Type: " + ts + " (0x" + th.substring(th.length() - 8) + ")");
                                System.out.println("ID:   " + r.id);
                                System.out.println("Attr: " + r.getAttributeString().toLowerCase());
                                System.out.println("Name: " + r.name);
                                System.out.println("Len:  " + r.data.length);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            r = rp.get(type, oarg.get(j + 1));
                            if (r == null) {
                                System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + oarg.get(j + 1) + " does not exist.");
                            }
                            ts = KSFLUtilities.fccs(r.type);
                            th = "00000000" + Integer.toHexString(r.type).toUpperCase();
                            System.out.println("Type: " + ts + " (0x" + th.substring(th.length() - 8) + ")");
                            System.out.println("ID:   " + r.id);
                            System.out.println("Attr: " + r.getAttributeString().toLowerCase());
                            System.out.println("Name: " + r.name);
                            System.out.println("Len:  " + r.data.length);
                        }
                        j += 2;
                    }
                    break;
                }
                case 8: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j));
                        try {
                            id = (short)Integer.parseInt(oarg.get(j + 1));
                            data = rp.getData(type, id);
                            if (data == null) {
                                System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + id + " does not exist.");
                            } else {
                                try {
                                    System.out.write(data);
                                }
                                catch (IOException ts) {}
                            }
                        }
                        catch (NumberFormatException nfe) {
                            data = rp.getData(type, oarg.get(j + 1));
                            if (data == null) {
                                System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + oarg.get(j + 1) + " does not exist.");
                            }
                            try {
                                System.out.write(data);
                            }
                            catch (IOException ts) {
                                // empty catch block
                            }
                        }
                        j += 2;
                    }
                    break;
                }
                case 9: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j));
                        try {
                            id = (short)Integer.parseInt(oarg.get(j + 1));
                            data = rp.getData(type, id);
                            if (data == null) {
                                System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + id + " does not exist.");
                            } else {
                                KSFLUtilities.printHexDump(System.out, data);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            data = rp.getData(type, oarg.get(j + 1));
                            if (data == null) {
                                System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + oarg.get(j + 1) + " does not exist.");
                            }
                            KSFLUtilities.printHexDump(System.out, data);
                        }
                        j += 2;
                    }
                    break;
                }
                case 10: {
                    j = 0;
                    while (j + 2 <= oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j));
                        try {
                            id = (short)Integer.parseInt(oarg.get(j + 1));
                            rp.remove(type, id);
                        }
                        catch (NumberFormatException nfe) {
                            rp.remove(type, oarg.get(j + 1));
                        }
                        j += 2;
                    }
                    break;
                }
                case 11: {
                    if (oarg.size() < 2) break;
                    type = KSFLUtilities.fcc(oarg.get(0));
                    r = null;
                    try {
                        id = (short)Integer.parseInt(oarg.get(1));
                        r = rp.get(type, id);
                    }
                    catch (NumberFormatException nfe) {
                        name = oarg.get(1);
                        r = rp.get(type, name);
                    }
                    if (r == null) {
                        System.err.println("Error: " + KSFLUtilities.fccs(type) + " " + oarg.get(1) + " doesn't exist.");
                        break;
                    }
                    id = r.id;
                    changed = false;
                    j = 2;
                    while (j + 2 <= oarg.size()) {
                        siop = oarg.get(j).trim().toLowerCase();
                        if (siop.equals("t") || siop.equals("type")) {
                            r.type = KSFLUtilities.fcc(oarg.get(j + 1));
                            changed = true;
                        } else if (siop.equals("i") || siop.equals("id")) {
                            try {
                                r.id = (short)Integer.parseInt(oarg.get(j + 1));
                                changed = true;
                            }
                            catch (NumberFormatException nfe) {
                                System.err.println("Warning: Invalid ID number " + oarg.get(j + 1) + " skipped.");
                            }
                        } else if (siop.equals("n") || siop.equals("name")) {
                            r.name = oarg.get(j + 1);
                            changed = true;
                        } else if (siop.equals("a") || siop.equals("attr") || siop.equals("attrib") || siop.equals("attributes")) {
                            r.setAttributeString(oarg.get(j + 1));
                            changed = true;
                        } else {
                            System.err.println("Unknown attribute type: " + oarg.get(j));
                            System.err.println("Should be one of: t[ype] i[d] n[ame] a[ttr[ib[utes]]]");
                        }
                        j += 2;
                    }
                    if (!changed) break;
                    try {
                        rp.setAttributes(type, id, r);
                    }
                    catch (MacResourceAlreadyExistsException e) {
                        System.err.println("Error: " + KSFLUtilities.fccs(r.type) + " " + r.id + " already exists.");
                    }
                    break;
                }
                case 12: {
                    j = 0;
                    while (j + 3 <= oarg.size()) {
                        try {
                            len = Integer.parseInt(oarg.get(j + 2));
                            type = KSFLUtilities.fcc(oarg.get(j));
                            try {
                                id = (short)Integer.parseInt(oarg.get(j + 1));
                                if (!rp.contains(type, id)) ** GOTO lbl376
                                rp.setData(type, id, KSFLUtilities.resize(rp.getData(type, id), len));
                                ** GOTO lbl398
lbl376:
                                // 1 sources

                                r = new MacResource(type, id, new byte[len]);
                                try {
                                    rp.add(r);
                                }
                                catch (MacResourceAlreadyExistsException siop) {
                                }
                            }
                            catch (NumberFormatException nfe) {
                                name = oarg.get(j + 1);
                                if (!rp.contains(type, name)) ** GOTO lbl389
                                rp.setData(type, name, KSFLUtilities.resize(rp.getData(type, name), len));
                                ** GOTO lbl398
lbl389:
                                // 1 sources

                                r = new MacResource(type, rp.getNextAvailableID(type), name, new byte[len]);
                                try {
                                    rp.add(r);
                                }
                                catch (MacResourceAlreadyExistsException var13_122) {}
                            }
                        }
                        catch (NumberFormatException nfe) {
                            System.err.println("Error: Invalid length " + oarg.get(j + 2) + " skipped.");
                        }
lbl398:
                        // 7 sources

                        j += 3;
                    }
                    break;
                }
                case 13: {
                    j = 0;
                    while (j + 3 <= oarg.size()) {
                        type = KSFLUtilities.fcc(oarg.get(j));
                        try {
                            id = (short)Integer.parseInt(oarg.get(j + 1));
                            if (rp.contains(type, id)) {
                                stuff = null;
                                try {
                                    raf = new RandomAccessFile(new File(oarg.get(j + 2)), "r");
                                    stuff = new byte[(int)raf.length()];
                                    raf.readFully(stuff);
                                    raf.close();
                                }
                                catch (IOException e) {
                                    System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                                    stuff = null;
                                }
                                if (stuff != null) {
                                    rp.setData(type, id, stuff);
                                }
                            }
                        }
                        catch (NumberFormatException nfe) {
                            name = oarg.get(j + 1);
                            if (!rp.contains(type, name)) ** GOTO lbl439
                            stuff = null;
                            try {
                                raf = new RandomAccessFile(new File(oarg.get(j + 2)), "r");
                                stuff = new byte[(int)raf.length()];
                                raf.readFully(stuff);
                                raf.close();
                            }
                            catch (IOException e) {
                                System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                                stuff = null;
                            }
                            if (stuff == null) ** GOTO lbl439
                            rp.setData(type, name, stuff);
                        }
lbl439:
                        // 5 sources

                        j += 3;
                    }
                    break;
                }
                case 14: {
                    j = 0;
                    while (j + 3 <= oarg.size()) {
                        stuff = null;
                        try {
                            raf = new RandomAccessFile(new File(oarg.get(j + 2)), "r");
                            stuff = new byte[(int)raf.length()];
                            raf.readFully(stuff);
                            raf.close();
                        }
                        catch (IOException e) {
                            System.err.println("Error: Cannot read (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")");
                            stuff = null;
                        }
                        if (stuff != null) {
                            type = KSFLUtilities.fcc(oarg.get(j));
                            try {
                                id = (short)Integer.parseInt(oarg.get(j + 1));
                                if (rp.contains(type, id)) {
                                    rp.setData(type, id, stuff);
                                } else {
                                    r = new MacResource(type, id, stuff);
                                    try {
                                        rp.add(r);
                                    }
                                    catch (MacResourceAlreadyExistsException e) {}
                                }
                            }
                            catch (NumberFormatException nfe) {
                                name = oarg.get(j + 1);
                                if (rp.contains(type, name)) {
                                    rp.setData(type, name, stuff);
                                }
                                r = new MacResource(type, rp.getNextAvailableID(type), name, stuff);
                                try {
                                    rp.add(r);
                                }
                                catch (MacResourceAlreadyExistsException var13_123) {
                                    // empty catch block
                                }
                            }
                        }
                        j += 3;
                    }
                    break;
                }
                default: {
                    System.err.println("Internal Error: Unimplemented Operation " + op.name());
                }
            }
            ++i;
        }
        if (rp != null) {
            rp.close();
        }
    }

    private static void explain(Format fmt) {
        switch (fmt) {
            case IFF: {
                KSFLCLI.explainChunk(ChunkFileSpec.CFSPEC_IFF);
                break;
            }
            case RIFF: {
                KSFLCLI.explainChunk(ChunkFileSpec.CFSPEC_RIFF);
                break;
            }
            case MIDI: {
                KSFLCLI.explainChunk(ChunkFileSpec.CFSPEC_MIDI);
                break;
            }
            case PNG: {
                KSFLCLI.explainChunk(ChunkFileSpec.CFSPEC_PNG);
                break;
            }
            case ICNS: {
                KSFLCLI.explainChunk(ChunkFileSpec.CFSPEC_ICNS);
                break;
            }
            case HYPERCARD: {
                KSFLCLI.explainChunk(ChunkFileSpec.CFSPEC_HYPERCARD);
                break;
            }
            case DFFAUTO: {
                KSFLCLI.explainDFF(3, false);
                break;
            }
            case DFF1BE: {
                KSFLCLI.explainDFF(1, false);
                break;
            }
            case DFF1LE: {
                KSFLCLI.explainDFF(1, true);
                break;
            }
            case DFF2BE: {
                KSFLCLI.explainDFF(2, false);
                break;
            }
            case DFF2LE: {
                KSFLCLI.explainDFF(2, true);
                break;
            }
            case DFF3BE: {
                KSFLCLI.explainDFF(3, false);
                break;
            }
            case DFF3LE: {
                KSFLCLI.explainDFF(3, true);
                break;
            }
            case WINPE: {
                KSFLCLI.explainWinPE();
                break;
            }
            case PRC: {
                KSFLCLI.explainPRC();
                break;
            }
            case RSRC: {
                KSFLCLI.explainRSRC();
                break;
            }
            default: {
                System.err.println("Internal Error: Unimplemented Format " + fmt.name());
            }
        }
    }

    private static void explainChunk(ChunkFileSpec cfs) {
        System.out.println("KSFL Chunk Format Specification: " + cfs.stringRepresentation());
        System.out.println();
        if (cfs.fileHeaderSpec() != null) {
            for (FieldSpec fs : cfs.fileHeaderSpec()) {
                switch (fs.size()) {
                    case BYTE: {
                        System.out.print(fs.littleEndian() ? "int8le" : "int8be");
                        break;
                    }
                    case SHORT: {
                        System.out.print(fs.littleEndian() ? "int16le" : "int16be");
                        break;
                    }
                    case MEDIUM: {
                        System.out.print(fs.littleEndian() ? "int32le" : "int32be");
                        break;
                    }
                    case LONG: {
                        System.out.print(fs.littleEndian() ? "int64le" : "int64be");
                        break;
                    }
                    case DATA: {
                        System.out.print("byte[]");
                    }
                }
                switch (fs.type()) {
                    case FILLER: {
                        System.out.println(" filler;");
                        break;
                    }
                    case SIZE_WITHOUT_HEADER: {
                        System.out.println(" size; // excluding header");
                        break;
                    }
                    case SIZE_WITH_HEADER: {
                        System.out.println(" size; // including header");
                        break;
                    }
                    case CHUNK_COUNT: {
                        System.out.println(" count;");
                        break;
                    }
                    case INTEGER_TYPE: {
                        System.out.println(" type;");
                        break;
                    }
                    case CHARACTER_TYPE: {
                        System.out.println(" type; // character constant");
                        break;
                    }
                    case ID_NUMBER: {
                        System.out.println(" id;");
                        break;
                    }
                    case CHECKSUM: {
                        System.out.println(" checksum;");
                        break;
                    }
                    case DATA: {
                        System.out.println(" data;");
                    }
                }
            }
            if (cfs.fileHeaderSpec().evenPadded()) {
                System.out.println("short align");
            }
        }
        System.out.println("chunk[] chunks;");
        if (cfs.chunkHeaderSpec() != null || cfs.chunkHeaderSpec().isEmpty()) {
            for (FieldSpec fs : cfs.chunkHeaderSpec()) {
                switch (fs.size()) {
                    case BYTE: {
                        System.out.print(fs.littleEndian() ? "\tint8le" : "\tint8be");
                        break;
                    }
                    case SHORT: {
                        System.out.print(fs.littleEndian() ? "\tint16le" : "\tint16be");
                        break;
                    }
                    case MEDIUM: {
                        System.out.print(fs.littleEndian() ? "\tint32le" : "\tint32be");
                        break;
                    }
                    case LONG: {
                        System.out.print(fs.littleEndian() ? "\tint64le" : "\tint64be");
                        break;
                    }
                    case DATA: {
                        System.out.print("\tbyte[]");
                    }
                }
                switch (fs.type()) {
                    case FILLER: {
                        System.out.println(" filler;");
                        break;
                    }
                    case SIZE_WITHOUT_HEADER: {
                        System.out.println(" size; // excluding header");
                        break;
                    }
                    case SIZE_WITH_HEADER: {
                        System.out.println(" size; // including header");
                        break;
                    }
                    case CHUNK_COUNT: {
                        System.out.println(" count;");
                        break;
                    }
                    case INTEGER_TYPE: {
                        System.out.println(" type;");
                        break;
                    }
                    case CHARACTER_TYPE: {
                        System.out.println(" type; // character constant");
                        break;
                    }
                    case ID_NUMBER: {
                        System.out.println(" id;");
                        break;
                    }
                    case CHECKSUM: {
                        System.out.println(" checksum;");
                        break;
                    }
                    case DATA: {
                        System.out.println(" data;");
                    }
                }
            }
            if (cfs.chunkHeaderSpec().evenPadded()) {
                System.out.println("\tshort align");
            }
        }
    }

    private static void explainDFF(int version, boolean le) {
        switch (version) {
            case 1: {
                System.out.println("KSFL Chunk Format Specification: " + (le ? ChunkFileSpec.CFSPEC_DFF1LE : ChunkFileSpec.CFSPEC_DFF1BE).stringRepresentation());
                System.out.println("DFF File Format version 1.0");
                System.out.println();
                System.out.println("int32" + (le ? "le" : "be") + " magic; // '%DFF'");
                System.out.println("resource[] resources;");
                System.out.println("\tint64" + (le ? "le" : "be") + " type; // character constant");
                System.out.println("\tint16" + (le ? "le" : "be") + " id;");
                System.out.println("\tint16" + (le ? "le" : "be") + " filler;");
                System.out.println("\tint32" + (le ? "le" : "be") + " size; // excluding header");
                System.out.println("\tbyte[] data;");
                break;
            }
            case 2: {
                System.out.println("DFF File Format version 2.0.1");
                System.out.println();
                System.out.println("int32" + (le ? "le" : "be") + " magic; // '%DF2'");
                System.out.println("int32" + (le ? "le" : "be") + " count;");
                System.out.println("header[] headers;");
                System.out.println("\tint64" + (le ? "le" : "be") + " type; // character constant");
                System.out.println("\tint16" + (le ? "le" : "be") + " id; // least significant 16 bits");
                System.out.println("\tint16" + (le ? "le" : "be") + " dataType; // app use; values listed here are deprecated");
                System.out.println("\t\t0 - binary");
                System.out.println("\t\t1 - plain text");
                System.out.println("\t\t2 - Mac OS text");
                System.out.println("\t\t3 - KTF text");
                System.out.println("\t\t4 - image");
                System.out.println("\t\t5 - KIF image");
                System.out.println("\t\t6 - audio");
                System.out.println("\t\t7 - Pascal string list");
                System.out.println("\t\t8 - word string list");
                System.out.println("\t\t9 - long string list");
                System.out.println("\t\t10 - C string list");
                System.out.println("\tint16" + (le ? "le" : "be") + " attributes;");
                System.out.println("\t\tbit 0 - readonly");
                System.out.println("\t\tbit 1 - system");
                System.out.println("\t\tbit 2 - preload");
                System.out.println("\t\tbit 3 - purgeable");
                System.out.println("\t\tbit 4 - fromfile");
                System.out.println("\t\tbit 5 - fromrsrc");
                System.out.println("\t\tbit 6 - invisible");
                System.out.println("\t\tbit 7 - disabled");
                System.out.println("\t\tbit 8 - protected");
                System.out.println("\t\tbit 9 - fixed");
                System.out.println("\t\tbit 10 - multilingual");
                System.out.println("\t\tbit 11 - compressed");
                System.out.println("\t\tbit 12 - appuse1");
                System.out.println("\t\tbit 13 - appuse2");
                System.out.println("\t\tbit 14 - appuse3");
                System.out.println("\t\tbit 15 - appuse4");
                System.out.println("\tint16" + (le ? "le" : "be") + " id; // most significant 16 bits");
                System.out.println("\tint32" + (le ? "le" : "be") + " size; // excluding header");
                System.out.println("name[] names;");
                System.out.println("\tint8" + (le ? "le" : "be") + " length;");
                System.out.println("\tbyte[] name;");
                System.out.println("data[] datas;");
                System.out.println("\tbyte[] data;");
                break;
            }
            case 3: {
                System.out.println("DFF File Format version 3.0");
                System.out.println();
                System.out.println("int32" + (le ? "le" : "be") + " magic; // '%DF3'");
                System.out.println("int32" + (le ? "le" : "be") + " typeCount;");
                System.out.println("type[] types;");
                System.out.println("\tint64" + (le ? "le" : "be") + " type; // character constant");
                System.out.println("\tint32" + (le ? "le" : "be") + " resourceCount;");
                System.out.println("\tint32" + (le ? "le" : "be") + " resourceTableOffset; // from beginning of file");
                System.out.println("resourceTable[] resourceTables;");
                System.out.println("\tresource[] resources;");
                System.out.println("\t\tint32" + (le ? "le" : "be") + " id;");
                System.out.println("\t\tint16" + (le ? "le" : "be") + " dataType; // app use; values listed here are deprecated");
                System.out.println("\t\t\t0 - binary");
                System.out.println("\t\t\t1 - plain text");
                System.out.println("\t\t\t2 - Mac OS text");
                System.out.println("\t\t\t3 - KTF text");
                System.out.println("\t\t\t4 - image");
                System.out.println("\t\t\t5 - KIF image");
                System.out.println("\t\t\t6 - audio");
                System.out.println("\t\t\t7 - Pascal string list");
                System.out.println("\t\t\t8 - word string list");
                System.out.println("\t\t\t9 - long string list");
                System.out.println("\t\t\t10 - C string list");
                System.out.println("\t\tint16" + (le ? "le" : "be") + " attributes;");
                System.out.println("\t\t\tbit 0 - readonly");
                System.out.println("\t\t\tbit 1 - system");
                System.out.println("\t\t\tbit 2 - preload");
                System.out.println("\t\t\tbit 3 - purgeable");
                System.out.println("\t\t\tbit 4 - fromfile");
                System.out.println("\t\t\tbit 5 - fromrsrc");
                System.out.println("\t\t\tbit 6 - invisible");
                System.out.println("\t\t\tbit 7 - disabled");
                System.out.println("\t\t\tbit 8 - protected");
                System.out.println("\t\t\tbit 9 - fixed");
                System.out.println("\t\t\tbit 10 - multilingual");
                System.out.println("\t\t\tbit 11 - compressed");
                System.out.println("\t\t\tbit 12 - appuse1");
                System.out.println("\t\t\tbit 13 - appuse2");
                System.out.println("\t\t\tbit 14 - appuse3");
                System.out.println("\t\t\tbit 15 - appuse4");
                System.out.println("\t\tint32" + (le ? "le" : "be") + " nameOffset; // from beginning of file");
                System.out.println("\t\tint48" + (le ? "le" : "be") + " dataOffset; // from beginning of file");
                System.out.println("\t\tint48" + (le ? "le" : "be") + " size;");
                System.out.println("name[] names;");
                System.out.println("\tint8" + (le ? "le" : "be") + " length;");
                System.out.println("\tbyte[] name;");
                System.out.println("data[] datas;");
                System.out.println("\tbyte[] data;");
            }
        }
    }

    private static void explainWinPE() {
        System.out.println("Windows Portable Executable");
        System.out.println();
        System.out.println("byte[128] msdosStub;");
        System.out.println("int32le peSignature; // 0x4550");
        System.out.println("int16le machine;");
        System.out.println("int16le sectionCount;");
        System.out.println("int32le creationDate; // epoch: January 1, 1970");
        System.out.println("int32le symbolTablePtr;");
        System.out.println("int32le symbolCount;");
        System.out.println("int16le optionalHeaderSize; // usually 0xE0");
        System.out.println("int16le characteristics;");
        System.out.println("int16le magic; // usually 0x010B");
        System.out.println("int16le linkerVersion;");
        System.out.println("int32le codeSize;");
        System.out.println("int32le dataSize;");
        System.out.println("int32le bssSize;");
        System.out.println("int32le entryPointOffset;");
        System.out.println("int32le codeOffset;");
        System.out.println("int32le dataOffset;");
        System.out.println("int32le loadAddress;");
        System.out.println("int32le sectionAlignment;");
        System.out.println("int32le fileAlignment;");
        System.out.println("int32le osVersion; // usually 0x40000 (Win32)");
        System.out.println("int32le binaryVersion;");
        System.out.println("int32le subsystemVersion; // usually 0x40000 (Win32)");
        System.out.println("int32le win32Version; // usually 0");
        System.out.println("int32le imageSize;");
        System.out.println("int32le headerSize;");
        System.out.println("int32le checksum;");
        System.out.println("int16le subsystem;");
        System.out.println("int16le dllCharacteristics;");
        System.out.println("int32le stackReserveSize;");
        System.out.println("int32le stackCommitSize;");
        System.out.println("int32le heapReserveSize;");
        System.out.println("int32le heapCommitSize;");
        System.out.println("int32le loaderFlags;");
        System.out.println("int32le directoryEntryCount;");
        System.out.println("directoryEntry[] directoryEntries;");
        System.out.println("\tint32le virtualAddress;");
        System.out.println("\tint32le size;");
        System.out.println("sectionHeader[] sectionHeaders;");
        System.out.println("\tbyte[8] name;");
        System.out.println("\tint32le virtualSize;");
        System.out.println("\tint32le virtualAddress;");
        System.out.println("\tint32le dataSize;");
        System.out.println("\tint32le dataOffset;");
        System.out.println("\tint32le relocationsOffset;");
        System.out.println("\tint32le lineNumbersOffset;");
        System.out.println("\tint16le relocationCount;");
        System.out.println("\tint16le lineNumberCount;");
        System.out.println("\tint32le characteristics;");
    }

    private static void explainPRC() {
        System.out.println("Palm Resource Database");
        System.out.println();
        System.out.println("byte[32] name;");
        System.out.println("int16be attributes;");
        System.out.println("\tbit 0 - resource database");
        System.out.println("\tbit 1 - read only");
        System.out.println("\tbit 2 - appinfo dirty");
        System.out.println("\tbit 3 - backup");
        System.out.println("\tbit 4 - OK to install newer");
        System.out.println("\tbit 5 - reset after install");
        System.out.println("\tbit 6 - non-beamable (copy-protected)");
        System.out.println("\tbit 7 - file stream database");
        System.out.println("\tbit 8 - hidden");
        System.out.println("\tbit 9 - launchable data");
        System.out.println("\tbit 10 - reserved");
        System.out.println("\tbit 11 - reserved");
        System.out.println("\tbit 12 - reserved");
        System.out.println("\tbit 13 - reserved");
        System.out.println("\tbit 14 - reserved");
        System.out.println("\tbit 15 - open");
        System.out.println("int16be version; // usually 1");
        System.out.println("int32be creationDate; // epoch: January 1, 1904");
        System.out.println("int32be modificationDate; // epoch: January 1, 1904");
        System.out.println("int32be backupDate; // epoch: January 1, 1904");
        System.out.println("int32be modificationNumber; // usually 0");
        System.out.println("int32be appInfoOffset; // usually 0");
        System.out.println("int32be sortInfoOffset; // usually 0");
        System.out.println("int32be type; // for PRC, 'appl'");
        System.out.println("int32be creator;");
        System.out.println("int32be uniqueIDSeed; // usually 0");
        System.out.println("recordList[] recordLists;");
        System.out.println("\tint32be nextRecordListOffset; // usually 0 (only one record list)");
        System.out.println("\tint16be resourceCount;");
        System.out.println("\tresource[] resources; // if no resources, just a single int32be of 0");
        System.out.println("\t\tint32be type; // character constant");
        System.out.println("\t\tint16be id;");
        System.out.println("\t\tint32be dataOffset;");
        System.out.println("byte[] appInfo; // usually empty");
        System.out.println("byte[] sortInfo; // usually empty");
        System.out.println("recordData[] recordDatas;");
        System.out.println("\tbyte[] data;");
    }

    private static void explainRSRC() {
        System.out.println("Mac OS Resource Fork");
        System.out.println();
        System.out.println("Beginning of File:");
        System.out.println("int32be resourceDataOffset; // from beginning of file");
        System.out.println("int32be resourceMapOffset; // from beginning of file");
        System.out.println("int32be resourceDataSize;");
        System.out.println("int32be resourceMapSize;");
        System.out.println();
        System.out.println("Resource Data:");
        System.out.println("data[] resourceData;");
        System.out.println("\tint32be size;");
        System.out.println("\tbyte[] data;");
        System.out.println();
        System.out.println("Resource Map:");
        System.out.println("int32be resourceDataOffset; // from beginning of file");
        System.out.println("int32be resourceMapOffset; // from beginning of file");
        System.out.println("int32be resourceDataSize;");
        System.out.println("int32be resourceMapSize;");
        System.out.println("int32be nextResourceMap;");
        System.out.println("int16be fileRef;");
        System.out.println("int16be attributes;");
        System.out.println("\tbit 5 - changed");
        System.out.println("\tbit 6 - needs compression");
        System.out.println("\tbit 7 - readonly");
        System.out.println("int16be typeListOffset; // from beginning of map");
        System.out.println("int16be nameListOffset; // from beginning of map");
        System.out.println();
        System.out.println("Type List:");
        System.out.println("int16be typeCount; // number of types minus one");
        System.out.println("type[] types;");
        System.out.println("\tint32be type; // character constant");
        System.out.println("\tint16be resourceCount; // number of resources minus one");
        System.out.println("\tint16be resourceListOffset; // from beginning of type list");
        System.out.println();
        System.out.println("Resource List:");
        System.out.println("resource[] resourceList;");
        System.out.println("\tint16be id;");
        System.out.println("\tint16be nameOffset; // from beginning of name list");
        System.out.println("\tint8be attributes;");
        System.out.println("\t\tbit 0 - compressed");
        System.out.println("\t\tbit 1 - changed");
        System.out.println("\t\tbit 2 - preload");
        System.out.println("\t\tbit 3 - protected (readonly)");
        System.out.println("\t\tbit 4 - locked (fixed)");
        System.out.println("\t\tbit 5 - purgeable");
        System.out.println("\t\tbit 6 - system");
        System.out.println("\t\tbit 7 - reserved");
        System.out.println("\tint24be dataOffset; // from beginning of resource data");
        System.out.println("\tint32be resourcePtr;");
        System.out.println();
        System.out.println("Name List:");
        System.out.println("name[] names;");
        System.out.println("\tint8be length;");
        System.out.println("\tbyte[] name;");
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$kreative$ksfl$KSFLCLI$Operation() {
        if ($SWITCH_TABLE$com$kreative$ksfl$KSFLCLI$Operation != null) {
            return $SWITCH_TABLE$com$kreative$ksfl$KSFLCLI$Operation;
        }
        int[] nArray = new int[Operation.values().length];
        try {
            nArray[Operation.ADD.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Operation.CAT.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Operation.CREATE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Operation.DELETE.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Operation.EXTRACT.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Operation.FRESHEN.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Operation.HEXCAT.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Operation.INFO.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Operation.LIST.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Operation.NEXT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Operation.SETINFO.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Operation.TRUNCATE.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Operation.UPDATE.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Operation.VERIFY.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$kreative$ksfl$KSFLCLI$Operation = nArray;
        return nArray;
    }

    private static enum Format {
        IFF,
        RIFF,
        MIDI,
        PNG,
        ICNS,
        HYPERCARD,
        DFFAUTO,
        DFF1BE,
        DFF1LE,
        DFF2BE,
        DFF2LE,
        DFF3BE,
        DFF3LE,
        WINPE,
        PRC,
        RSRC;


        public static Format forString(String s) {
            if ((s = s.trim().toLowerCase()).equals("iff")) {
                return IFF;
            }
            if (s.equals("riff")) {
                return RIFF;
            }
            if (s.equals("midi")) {
                return MIDI;
            }
            if (s.equals("png")) {
                return PNG;
            }
            if (s.equals("icns")) {
                return ICNS;
            }
            if (s.equals("hc") || s.equals("hypercard")) {
                return HYPERCARD;
            }
            if (s.equals("d") || s.equals("dff") || s.equals("dffauto")) {
                return DFFAUTO;
            }
            if (s.equals("d1") || s.equals("d1b") || s.equals("dff1") || s.equals("dff1be")) {
                return DFF1BE;
            }
            if (s.equals("d1l") || s.equals("dff1le")) {
                return DFF1LE;
            }
            if (s.equals("d2") || s.equals("d2b") || s.equals("dff2") || s.equals("dff2be")) {
                return DFF2BE;
            }
            if (s.equals("d2l") || s.equals("dff2le")) {
                return DFF2LE;
            }
            if (s.equals("d3") || s.equals("d3b") || s.equals("dff3") || s.equals("dff3be")) {
                return DFF3BE;
            }
            if (s.equals("d3l") || s.equals("dff3le")) {
                return DFF3LE;
            }
            if (s.equals("w") || s.equals("win") || s.equals("pe") || s.equals("winpe")) {
                return WINPE;
            }
            if (s.equals("p") || s.equals("prc")) {
                return PRC;
            }
            if (s.equals("r") || s.equals("rsrc")) {
                return RSRC;
            }
            return null;
        }

        public static void print(PrintStream out) {
            out.println("  iff           - Interchange File Format (big-endian)");
            out.println("  riff          - Interchange File Format (little-endian)");
            out.println("  midi          - MIDI file format");
            out.println("  png           - PNG file format");
            out.println("  icns          - Mac OS icon file format");
            out.println("  h[yper]c[ard] - HyperCard stack file format");
            out.println("  chunk:<spec>  - custom chunk format");
            out.println("  dff[auto]     - DFF File Format (automatic)");
            out.println("  dff1[be]      - DFF 1.0 (big-endian)");
            out.println("  dff1le        - DFF 1.0 (little-endian)");
            out.println("  dff2[be]      - DFF 2.0.1 (big-endian)");
            out.println("  dff2le        - DFF 2.0.1 (little-endian)");
            out.println("  dff3[be]      - DFF 3.0 (big-endian)");
            out.println("  dff3le        - DFF 3.0 (little-endian)");
            out.println("  [win][pe]     - Windows Portable Executable");
            out.println("  prc           - Palm OS resource database");
            out.println("  rsrc          - Mac OS resource fork");
        }
    }

    private static enum Operation {
        CREATE,
        LIST,
        NEXT,
        ADD,
        VERIFY,
        EXTRACT,
        INFO,
        CAT,
        HEXCAT,
        DELETE,
        SETINFO,
        TRUNCATE,
        FRESHEN,
        UPDATE;


        public static Operation forString(String s) {
            if ((s = s.trim().toLowerCase()).equals("k") || s.equals("kreate") || s.equals("create")) {
                return CREATE;
            }
            if (s.equals("l") || s.equals("list")) {
                return LIST;
            }
            if (s.equals("n") || s.equals("next")) {
                return NEXT;
            }
            if (s.equals("a") || s.equals("add")) {
                return ADD;
            }
            if (s.equals("v") || s.equals("verify")) {
                return VERIFY;
            }
            if (s.equals("e") || s.equals("x") || s.equals("extract") || s.equals("xtract")) {
                return EXTRACT;
            }
            if (s.equals("i") || s.equals("info")) {
                return INFO;
            }
            if (s.equals("c") || s.equals("cat")) {
                return CAT;
            }
            if (s.equals("h") || s.equals("hex") || s.equals("hexcat")) {
                return HEXCAT;
            }
            if (s.equals("d") || s.equals("delete")) {
                return DELETE;
            }
            if (s.equals("s") || s.equals("set") || s.equals("setinfo")) {
                return SETINFO;
            }
            if (s.equals("t") || s.equals("trunc") || s.equals("truncate")) {
                return TRUNCATE;
            }
            if (s.equals("f") || s.equals("freshen")) {
                return FRESHEN;
            }
            if (s.equals("u") || s.equals("update")) {
                return UPDATE;
            }
            return null;
        }

        public static void print(PrintStream out) {
            out.println("  k[reate]");
            out.println("  l[ist] [type]");
            out.println("  n[ext] <type> [id]");
            out.println("  a[dd] <type> [id] [name] [attributes] [datatype] <datafile>");
            out.println("  v[erify] <type> <id|name>");
            out.println("  e[xtract] [type] [id|name] <datafile>");
            out.println("  x[tract] [type] [id|name] <datafile>");
            out.println("  i[nfo] <type> <id|name>");
            out.println("  c[at] <type> <id|name>");
            out.println("  h[ex[cat]] <type> <id|name>");
            out.println("  d[elete] <type> <id|name>");
            out.println("  s[et[info]] <type> <id|name> t[ype]|i[d]|n[ame]|a[ttr]|d[atatype] <value>");
            out.println("  t[runc[ate]] <type> <id|name> <length>");
            out.println("  f[reshen] <type> <id|name> <datafile>");
            out.println("  u[pdate] <type> <id|name> <datafile>");
        }
    }
}

