/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-14 20:09
 */
 
#ifndef PEERLINK_H_
#define PEERLINK_H_

#include <string>
#include <list>
#include "BitStorm.h"
#include "Socket.h"
#include "BitSet.h"
#include "PieceRequest.h"

typedef struct
{
	unsigned int index;
	unsigned int offset;
	unsigned int len;
} TPeerPieceRequest;
typedef std::list<TPeerPieceRequest> TPeerPieceRequestList;

class CPeerLink : 
	public IPeerLink,
	public ITimerCallback,
	public CSocket,
	public IRateMeasureClient
{
public:
	CPeerLink();
	virtual ~CPeerLink();
private:
	TPeerState _state;
	IPeerManager* _manager;
	std::string _ip;
	unsigned int _port;
	std::string _id;
	bool _accepted;
	unsigned int _connectTimeoutTimer;
	
	CPieceRequest _pieceRequest;
	
	std::string _sendBuffer;
	std::string _recvBuffer;
	
	CBitSet _bitSet;
	bool _bitSetRecved;
	
	bool _handShaked;
	
	bool _amChoking;
	bool _amInterested;
	bool _peerChoking;
	bool _peerInterested;
	
	unsigned int _downloadCount;
	unsigned int _uploadCount;
	unsigned int _lastCountSpeedTime;
	unsigned int _lastDownloadCount;
	unsigned int _lastUploadCount;
	unsigned int _uploadSpeed;
	unsigned int _downloadSpeed;
	
	TPeerPieceRequestList _peerRequestList;
	
	bool _canRead;
	bool _canWrite;
	unsigned int _writePriority;
	unsigned int _readPriority;
private:
	void sendData(const void* data, size_t len);
	int processRecvData();
	void sendHandshake();	
	void sendBitfield();
	void sendChoke(bool choke);
	void sendInterested(bool interested);
	void sendHave(unsigned int pieceIndex);
	void sendPieceRequest(unsigned int pieceIndex, unsigned int offset, unsigned int len);
	void sendPieceData(unsigned int pieceIndex, unsigned int offset, std::string& data);
	void sendPieceCancel(unsigned int pieceIndex, unsigned int offset, unsigned int len);
	bool checkHandshake(std::string info);
	
	int processCmd(unsigned cmd, void* data, size_t dataLen);
	
	int processCmdChoke(void* data, size_t dataLen);
	int processCmdUnchoke(void* data, size_t dataLen);
	int processCmdInterested(void* data, size_t dataLen);
	int processCmdNotInterested(void* data, size_t dataLen);
	int processCmdHave(void* data, size_t dataLen);
	int processCmdBitfield(void* data, size_t dataLen);
	int processCmdRequest(void* data, size_t dataLen);
	int processCmdPiece(void* data, size_t dataLen);
	int processCmdCancel(void* data, size_t dataLen);
	
	void getNewPieceTask();
	void doPieceRequest();
	void doPieceSend();
public:	
	int handleRead();
	int handleWrite();
	void handleClose();	
	
	void blockWrite(bool block);
	void blockRead(bool block);
	void setWritePriority(unsigned int Priority);
	unsigned int getWritePriority();	
	void setReadPriority(unsigned int Priority);
	unsigned int getReadPriority();		
	bool canWrite();
	bool canRead();
	int doWrite(unsigned int count);
	int doRead(unsigned int count);	
	
	void onTimer(unsigned int id);
	
	void setPeerManager(IPeerManager* manager);
	TPeerState getState();
		
	void connect(const char* ip, unsigned short port);
	void attach(int handle, const char* ip, unsigned short port, IPeerManager* manager);
	bool isAccepted();
	void closeLink();
	const char* getIP();
	unsigned short getPort();
	void notifyHavePiece(unsigned int pieceIndex);
	void cancelPieceRequest(unsigned int pieceIndex);
	
	bool peerChoked();
	bool peerInterested();
	void chokePeer(bool chocke);
	unsigned int getDownloadCount();
	unsigned int getUploadCount();	
	
	void countSpeed();
	bool checkNeedClose();
	unsigned int getUploadSpeed();
	unsigned int getDownloadSpeed();	
	
	void onConnect();
	void onConnectFailed();	
	void onConnectClosed();
	void onSendComplete();
	void onDownloadComplete();
};

#endif /*PEERLINK_H_*/
