/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-01-29 20:09
 */

#ifndef TORRENTFILE_H_
#define TORRENTFILE_H_

#include <vector>
#include <string>
#include "BitStorm.h"
#include "bdict.h"

class CTorrentFile : public ITorrentFile
{
public:
	CTorrentFile();
	virtual ~CTorrentFile();
private:
	typedef std::vector<TFileInfo> TFileInfoVector;
	typedef std::vector<std::string> TAnnounceVector;
	
	std::string _encoding;
	bool _utf8Valid;
	
	int _pieceLength;
	std::string _pieces;
	
	TAnnounceVector _announces;
	int _creatDate;
	std::string _comment;
	std::string _creator;
	std::string _topDir;
	std::string _name;
	
	std::string _commentUTF8;
	std::string _creatorUTF8;
	std::string _topDirUTF8;
	std::string _nameUTF8;	
	
	TFileInfoVector  _fileInfos;
	int64_t _totalSize;
	
	unsigned char _infoHash[20];
	
	IBTTask* _task;
private:
	bool parseDict(CBDict& dict);
	bool parseInfoDict(CBDict& dict);		
	void updateUTF8();
public:	
 	void setBTTask(IBTTask* task);
	IBTTask* getBTTask();
		
	bool load(const char* filePath);
	void setCharacterEncoding(const char* enc);
	bool IsUTF8Valid();
	unsigned int getAnnounceCount();
	const char* getAnnounce(unsigned int index);
	int getCreationDate();
	const char* getComment();
	const char* getCreator();
	std::string getName();
	std::string getTopDir();
	const char* getCommentUTF8();
	const char* getCreatorUTF8();
	std::string getNameUTF8();
	std::string getTopDirUTF8();	
	unsigned int getPieceLength();
	unsigned int getPieceCount();
	std::string getPieceHash(unsigned int pieceIndex);	
	unsigned int getFileCount();
	TFileInfo getFileInfo(unsigned int index);
	int64_t getTotalSize();
	const unsigned char* getInfoHash();	
};

#endif /*TORRENTFILE_H_*/
