# Copyright 2017 OpenStack Foundation.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Delete unused status related fields

Revision ID: e66f199a5414
Revises: 97d2cad1504e
Create Date: 2017-12-18 15:33:09.217659

"""

# revision identifiers, used by Alembic.
revision = 'e66f199a5414'
down_revision = '97d2cad1504e'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('computehost_reservations', 'status')
    op.drop_column('leases', 'action')
    op.drop_column('leases', 'status_reason')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('leases', sa.Column('status_reason',
                                      mysql.VARCHAR(length=255),
                                      nullable=True))
    op.add_column('leases', sa.Column('action',
                                      mysql.VARCHAR(length=255),
                                      nullable=True))
    op.add_column('computehost_reservations',
                  sa.Column('status',
                            mysql.VARCHAR(length=13),
                            nullable=True))
    # ### end Alembic commands ###
