Subject: Fix for RFC822 folded header line field
From: https://sourceforge.net/tracker/?func=detail&aid=2816230&group_id=63555&atid=504404

$MirOS: ports/mailnews/bmf/patches/patch-lex_c,v 1.1 2009/07/03 09:14:12 tg Exp $
--- a/lex.c.orig	Sun Oct 20 20:28:53 2002
+++ a/lex.c	Fri Jul  3 09:06:51 2009
@@ -682,7 +682,7 @@ again:
 void lex_passthru( lex_t* pthis, bool_t is_spam, double hits )
 {
     char   szbuf[256];
-    bool_t in_headers = true;
+    bool_t ign_header = false;
 
     assert( pthis->bom < pthis->buflen && pthis->eom <= pthis->buflen );
     assert( pthis->bom <= pthis->eom );
@@ -701,7 +701,7 @@ void lex_passthru( lex_t* pthis, bool_t 
     }
 
     /* existing headers */
-    while( in_headers && pthis->pos < pthis->eom )
+    while( pthis->pos < pthis->eom )
     {
         cpchar pbuf = pthis->pbuf + pthis->pos;
         uint len = 0;
@@ -722,9 +722,14 @@ void lex_passthru( lex_t* pthis, bool_t 
         }
  
         /* write header, ignoring existing spam headers */
-        if( strncasecmp( pbuf, "X-Spam-", 7 ) != 0 )
+        if( ign_header && (pbuf[0] == ' ' || pbuf[0] == '\t') )
+            /* continuation line of an ignored header */ ;
+        else if( strncasecmp( pbuf, "X-Spam-", 7 ) == 0 )
+            ign_header = true;
+        else
         {
             write( STDOUT_FILENO, pbuf, len );
+            ign_header = false;
         }
 
         pthis->pos += len;
