
// A collection of Lambert W test values computed using 100 decimal digits precision.
// C++ floating-point type is RealType.

// Written by lambert_w_mp_test_values.cpp Tue Oct 10 14:35:08 2017

// Copyright Paul A. Bristow 2017.
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

// Size of arrays of arguments z and Lambert W
static const unsigned int noof_tests = 100;
// Declare arrays of arguments z and Lambert W(z)
// The values are defined using the macro BOOST_MATH_TEST_VALUE to ensure
// that both built-in and multiprecision types are correctly initialiased with full precision.
// built-in types like double require a floating-point literal like 3.14,
// but multiprecision types require a decimal digit string like "3.14".


template <typename RealType>
static RealType zs[100];

template <typename RealType>
static RealType ws[100];

template <typename RealType>
void init_zs()
{
  zs<RealType>[0] = BOOST_MATH_TEST_VALUE(RealType, -0.35);
  zs<RealType>[1] = BOOST_MATH_TEST_VALUE(RealType, -0.34);
  zs<RealType>[2] = BOOST_MATH_TEST_VALUE(RealType, -0.33);
  zs<RealType>[3] = BOOST_MATH_TEST_VALUE(RealType, -0.32);
  zs<RealType>[4] = BOOST_MATH_TEST_VALUE(RealType, -0.31);
  zs<RealType>[5] = BOOST_MATH_TEST_VALUE(RealType, -0.3);
  zs<RealType>[6] = BOOST_MATH_TEST_VALUE(RealType, -0.29);
  zs<RealType>[7] = BOOST_MATH_TEST_VALUE(RealType, -0.28);
  zs<RealType>[8] = BOOST_MATH_TEST_VALUE(RealType, -0.27);
  zs<RealType>[9] = BOOST_MATH_TEST_VALUE(RealType, -0.26);
  zs<RealType>[10] = BOOST_MATH_TEST_VALUE(RealType, -0.25);
  zs<RealType>[11] = BOOST_MATH_TEST_VALUE(RealType, -0.24);
  zs<RealType>[12] = BOOST_MATH_TEST_VALUE(RealType, -0.23);
  zs<RealType>[13] = BOOST_MATH_TEST_VALUE(RealType, -0.22);
  zs<RealType>[14] = BOOST_MATH_TEST_VALUE(RealType, -0.21);
  zs<RealType>[15] = BOOST_MATH_TEST_VALUE(RealType, -0.2);
  zs<RealType>[16] = BOOST_MATH_TEST_VALUE(RealType, -0.19);
  zs<RealType>[17] = BOOST_MATH_TEST_VALUE(RealType, -0.18);
  zs<RealType>[18] = BOOST_MATH_TEST_VALUE(RealType, -0.17);
  zs<RealType>[19] = BOOST_MATH_TEST_VALUE(RealType, -0.16);
  zs<RealType>[20] = BOOST_MATH_TEST_VALUE(RealType, -0.15);
  zs<RealType>[21] = BOOST_MATH_TEST_VALUE(RealType, -0.14);
  zs<RealType>[22] = BOOST_MATH_TEST_VALUE(RealType, -0.13);
  zs<RealType>[23] = BOOST_MATH_TEST_VALUE(RealType, -0.12);
  zs<RealType>[24] = BOOST_MATH_TEST_VALUE(RealType, -0.11);
  zs<RealType>[25] = BOOST_MATH_TEST_VALUE(RealType, -0.1);
  zs<RealType>[26] = BOOST_MATH_TEST_VALUE(RealType, -0.09);
  zs<RealType>[27] = BOOST_MATH_TEST_VALUE(RealType, -0.08);
  zs<RealType>[28] = BOOST_MATH_TEST_VALUE(RealType, -0.07);
  zs<RealType>[29] = BOOST_MATH_TEST_VALUE(RealType, -0.06);
  zs<RealType>[30] = BOOST_MATH_TEST_VALUE(RealType, -0.05);
  zs<RealType>[31] = BOOST_MATH_TEST_VALUE(RealType, -0.04);
  zs<RealType>[32] = BOOST_MATH_TEST_VALUE(RealType, -0.03);
  zs<RealType>[33] = BOOST_MATH_TEST_VALUE(RealType, -0.02);
  zs<RealType>[34] = BOOST_MATH_TEST_VALUE(RealType, -0.01);
  zs<RealType>[35] = BOOST_MATH_TEST_VALUE(RealType, 0);
  zs<RealType>[36] = BOOST_MATH_TEST_VALUE(RealType, 0.01);
  zs<RealType>[37] = BOOST_MATH_TEST_VALUE(RealType, 0.02);
  zs<RealType>[38] = BOOST_MATH_TEST_VALUE(RealType, 0.03);
  zs<RealType>[39] = BOOST_MATH_TEST_VALUE(RealType, 0.04);
  zs<RealType>[40] = BOOST_MATH_TEST_VALUE(RealType, 0.05);
  zs<RealType>[41] = BOOST_MATH_TEST_VALUE(RealType, 0.06);
  zs<RealType>[42] = BOOST_MATH_TEST_VALUE(RealType, 0.07);
  zs<RealType>[43] = BOOST_MATH_TEST_VALUE(RealType, 0.08);
  zs<RealType>[44] = BOOST_MATH_TEST_VALUE(RealType, 0.09);
  zs<RealType>[45] = BOOST_MATH_TEST_VALUE(RealType, 0.1);
  zs<RealType>[46] = BOOST_MATH_TEST_VALUE(RealType, 0.11);
  zs<RealType>[47] = BOOST_MATH_TEST_VALUE(RealType, 0.12);
  zs<RealType>[48] = BOOST_MATH_TEST_VALUE(RealType, 0.13);
  zs<RealType>[49] = BOOST_MATH_TEST_VALUE(RealType, 0.14);
  zs<RealType>[50] = BOOST_MATH_TEST_VALUE(RealType, 0.15);
  zs<RealType>[51] = BOOST_MATH_TEST_VALUE(RealType, 0.16);
  zs<RealType>[52] = BOOST_MATH_TEST_VALUE(RealType, 0.17);
  zs<RealType>[53] = BOOST_MATH_TEST_VALUE(RealType, 0.18);
  zs<RealType>[54] = BOOST_MATH_TEST_VALUE(RealType, 0.19);
  zs<RealType>[55] = BOOST_MATH_TEST_VALUE(RealType, 0.2);
  zs<RealType>[56] = BOOST_MATH_TEST_VALUE(RealType, 0.21);
  zs<RealType>[57] = BOOST_MATH_TEST_VALUE(RealType, 0.22);
  zs<RealType>[58] = BOOST_MATH_TEST_VALUE(RealType, 0.23);
  zs<RealType>[59] = BOOST_MATH_TEST_VALUE(RealType, 0.24);
  zs<RealType>[60] = BOOST_MATH_TEST_VALUE(RealType, 0.25);
  zs<RealType>[61] = BOOST_MATH_TEST_VALUE(RealType, 0.26);
  zs<RealType>[62] = BOOST_MATH_TEST_VALUE(RealType, 0.27);
  zs<RealType>[63] = BOOST_MATH_TEST_VALUE(RealType, 0.28);
  zs<RealType>[64] = BOOST_MATH_TEST_VALUE(RealType, 0.29);
  zs<RealType>[65] = BOOST_MATH_TEST_VALUE(RealType, 0.3);
  zs<RealType>[66] = BOOST_MATH_TEST_VALUE(RealType, 0.31);
  zs<RealType>[67] = BOOST_MATH_TEST_VALUE(RealType, 0.32);
  zs<RealType>[68] = BOOST_MATH_TEST_VALUE(RealType, 0.33);
  zs<RealType>[69] = BOOST_MATH_TEST_VALUE(RealType, 0.34);
  zs<RealType>[70] = BOOST_MATH_TEST_VALUE(RealType, 0.35);
  zs<RealType>[71] = BOOST_MATH_TEST_VALUE(RealType, 0.36);
  zs<RealType>[72] = BOOST_MATH_TEST_VALUE(RealType, 0.37);
  zs<RealType>[73] = BOOST_MATH_TEST_VALUE(RealType, 0.38);
  zs<RealType>[74] = BOOST_MATH_TEST_VALUE(RealType, 0.39);
  zs<RealType>[75] = BOOST_MATH_TEST_VALUE(RealType, 0.4);
  zs<RealType>[76] = BOOST_MATH_TEST_VALUE(RealType, 0.41);
  zs<RealType>[77] = BOOST_MATH_TEST_VALUE(RealType, 0.42);
  zs<RealType>[78] = BOOST_MATH_TEST_VALUE(RealType, 0.43);
  zs<RealType>[79] = BOOST_MATH_TEST_VALUE(RealType, 0.44);
  zs<RealType>[80] = BOOST_MATH_TEST_VALUE(RealType, 0.45);
  zs<RealType>[81] = BOOST_MATH_TEST_VALUE(RealType, 0.46);
  zs<RealType>[82] = BOOST_MATH_TEST_VALUE(RealType, 0.47);
  zs<RealType>[83] = BOOST_MATH_TEST_VALUE(RealType, 0.48);
  zs<RealType>[84] = BOOST_MATH_TEST_VALUE(RealType, 0.49);
  zs<RealType>[85] = BOOST_MATH_TEST_VALUE(RealType, 0.5);
  zs<RealType>[86] = BOOST_MATH_TEST_VALUE(RealType, 0.51);
  zs<RealType>[87] = BOOST_MATH_TEST_VALUE(RealType, 0.52);
  zs<RealType>[88] = BOOST_MATH_TEST_VALUE(RealType, 0.53);
  zs<RealType>[89] = BOOST_MATH_TEST_VALUE(RealType, 0.54);
  zs<RealType>[90] = BOOST_MATH_TEST_VALUE(RealType, 0.55);
  zs<RealType>[91] = BOOST_MATH_TEST_VALUE(RealType, 0.56);
  zs<RealType>[92] = BOOST_MATH_TEST_VALUE(RealType, 0.57);
  zs<RealType>[93] = BOOST_MATH_TEST_VALUE(RealType, 0.58);
  zs<RealType>[94] = BOOST_MATH_TEST_VALUE(RealType, 0.59);
  zs<RealType>[95] = BOOST_MATH_TEST_VALUE(RealType, 0.6);
  zs<RealType>[96] = BOOST_MATH_TEST_VALUE(RealType, 0.61);
  zs<RealType>[97] = BOOST_MATH_TEST_VALUE(RealType, 0.62);
  zs<RealType>[98] = BOOST_MATH_TEST_VALUE(RealType, 0.63);
  zs<RealType>[99] = BOOST_MATH_TEST_VALUE(RealType, 0.64);
};

template <typename RealType>
void init_ws()
{
  ws<RealType>[0] = BOOST_MATH_TEST_VALUE(RealType, -0.7166388164560746087024558456707254694384568520557269136746931098892793788395047380759438025387884858);
  ws<RealType>[1] = BOOST_MATH_TEST_VALUE(RealType, -0.6536945012690894831597997531138338843162464994103594824433758069038214520742337992347211610550053984);
  ws<RealType>[2] = BOOST_MATH_TEST_VALUE(RealType, -0.6032666497551330505290050177510626805198672833479939253720127109209527349195161224268802996274136747);
  ws<RealType>[3] = BOOST_MATH_TEST_VALUE(RealType, -0.5604894830784555743634840504116545657018790664887527536558909385182231717303278501957297352008893216);
  ws<RealType>[4] = BOOST_MATH_TEST_VALUE(RealType, -0.5229899496273203531021836240814670901286300106249589336522580913925382314180343142582930298688973328);
  ws<RealType>[5] = BOOST_MATH_TEST_VALUE(RealType, -0.4894022271802149690362312519962933689234100060163590345114659679736814083816206187318524147462752111);
  ws<RealType>[6] = BOOST_MATH_TEST_VALUE(RealType, -0.4588564134818020881945707413259267147702798410198651247860751590059996177594865393191440343561489497);
  ws<RealType>[7] = BOOST_MATH_TEST_VALUE(RealType, -0.430758874527112757916530656841372138819645982270515538512158436501726397121990576271580205308878207);
  ws<RealType>[8] = BOOST_MATH_TEST_VALUE(RealType, -0.4046836216050718653643250056478665857931866093242449366197023952738694255086107304901218425119878285);
  ws<RealType>[9] = BOOST_MATH_TEST_VALUE(RealType, -0.3803130203301711158303965355878156301369877394562403253806911002545713191362049178479001390543005669);
  ws<RealType>[10] = BOOST_MATH_TEST_VALUE(RealType, -0.3574029561813889030688111040559047533165905550760120436276204485896714025961457962896168513444411851);
  ws<RealType>[11] = BOOST_MATH_TEST_VALUE(RealType, -0.3357611647889027517286807582305262236620547459507665934563718789670705154001183482511605249232725262);
  ws<RealType>[12] = BOOST_MATH_TEST_VALUE(RealType, -0.3152331201461386435765969738874032981030054464637097661705367708887648429131963353376761780892891198);
  ws<RealType>[13] = BOOST_MATH_TEST_VALUE(RealType, -0.2956924930138396731882414803341009766267402363327831485839773479792571341845506001421908939342687003);
  ws<RealType>[14] = BOOST_MATH_TEST_VALUE(RealType, -0.2770344936961942277405408649408688233196542455843784252217943010706466317584602777484953020015260171);
  ws<RealType>[15] = BOOST_MATH_TEST_VALUE(RealType, -0.2591711018190737450566519502154067057135883397008937032218391275127128217957580326598838960236799743);
  ws<RealType>[16] = BOOST_MATH_TEST_VALUE(RealType, -0.2420275690015187377858338945726638068700099098394765251572836145818480355482127963663852628850474365);
  ws<RealType>[17] = BOOST_MATH_TEST_VALUE(RealType, -0.2255398031589208520522477564458058214947250100630471825833168970061295445194143654537283079293631882);
  ws<RealType>[18] = BOOST_MATH_TEST_VALUE(RealType, -0.2096523776773757526854110454922591821172341338912795099236642246474810661153254626268152915502654464);
  ws<RealType>[19] = BOOST_MATH_TEST_VALUE(RealType, -0.1943169925501295306267806518866699513042867279514786976609290465447683131164947042462416733465191705);
  ws<RealType>[20] = BOOST_MATH_TEST_VALUE(RealType, -0.1794912683479847336169956193772297997551233686606176679348345166799006378410748708389238307302596092);
  ws<RealType>[21] = BOOST_MATH_TEST_VALUE(RealType, -0.1651377892669526609846674769813353453533631060975171667664202096550705187268670901310309631101894252);
  ws<RealType>[22] = BOOST_MATH_TEST_VALUE(RealType, -0.1512233352864070831284495817823327538270829682666487244093315171463780635423561100568377622135186516);
  ws<RealType>[23] = BOOST_MATH_TEST_VALUE(RealType, -0.1377182597958957974485081647284122921614575977782346246206306428239556449434198032928042029722138321);
  ws<RealType>[24] = BOOST_MATH_TEST_VALUE(RealType, -0.1245959804557266577566667196210790531357931527107938915216224185712652948438844608688497767379885997);
  ws<RealType>[25] = BOOST_MATH_TEST_VALUE(RealType, -0.1118325591589629648335694568202658422726453622912658633296897727621943319600088273854870109175450158);
  ws<RealType>[26] = BOOST_MATH_TEST_VALUE(RealType, -0.09940635280454481474353567186786621057820625354936552021878311951478746295439312235429098520600693655);
  ws<RealType>[27] = BOOST_MATH_TEST_VALUE(RealType, -0.0872977208615799240409197586602731399264877335001009828544494658243661146551788411188719365040631665);
  ws<RealType>[28] = BOOST_MATH_TEST_VALUE(RealType, -0.07548877886579220591933915955796681153524932228333916508394604171275936228487984352484617277876166196);
  ws<RealType>[29] = BOOST_MATH_TEST_VALUE(RealType, -0.06396318935617251019529498180168867456392641049371161867095248726275828927462089387234209569688498636);
  ws<RealType>[30] = BOOST_MATH_TEST_VALUE(RealType, -0.05270598355154634795995650617915721289427674396592395159861151190218069285705994080638064249535030165);
  ws<RealType>[31] = BOOST_MATH_TEST_VALUE(RealType, -0.0417034084364844738987273381255397678625601003793974576012640697941798897037109744906565096871084505);
  ws<RealType>[32] = BOOST_MATH_TEST_VALUE(RealType, -0.03094279498284817939791038065611524917275896960162863310717850085820789123932160879579380708946724763);
  ws<RealType>[33] = BOOST_MATH_TEST_VALUE(RealType, -0.02041244405580766725973605390749548004158612495647388221129868845283704895545337928376001388096747673);
  ws<RealType>[34] = BOOST_MATH_TEST_VALUE(RealType, -0.01010152719853875327292018767138623973670903993475235877290726369225412969738704722202330440072213641);
  ws<RealType>[35] = BOOST_MATH_TEST_VALUE(RealType, 0);
  ws<RealType>[36] = BOOST_MATH_TEST_VALUE(RealType, 0.009901473843595011885336326816570107953627746494917415482611387085655068978243229360100010886171970918);
  ws<RealType>[37] = BOOST_MATH_TEST_VALUE(RealType, 0.01961158933740562729168248268298370977812129423409093067066057185151403434315590894008191205649296367);
  ws<RealType>[38] = BOOST_MATH_TEST_VALUE(RealType, 0.02913845916787001265458568152535395243296458501852019787733534716701300947181963767753439648797667795);
  ws<RealType>[39] = BOOST_MATH_TEST_VALUE(RealType, 0.03848966594197856933287598180923987047561124099417969473653441752849562865576161248185402614815991005);
  ws<RealType>[40] = BOOST_MATH_TEST_VALUE(RealType, 0.04767230860012937472638890051416087074706296593389050213640962398757901310991378849253401839554247932);
  ws<RealType>[41] = BOOST_MATH_TEST_VALUE(RealType, 0.05669304377414432493107872588796066666126335321712197451058496819855703149168243802045469883952188552);
  ws<RealType>[42] = BOOST_MATH_TEST_VALUE(RealType, 0.06555812274442272075701853672870305774479404911034476570035450491724937359575494857058381868464932454);
  ws<RealType>[43] = BOOST_MATH_TEST_VALUE(RealType, 0.07427342455278083997072135190143718509109109085324108067398934333182382982634706320903236612485848405);
  ws<RealType>[44] = BOOST_MATH_TEST_VALUE(RealType, 0.08284448574644162210327285639805993759142367414790119841318433362329213386156887296335560991622282284);
  ws<RealType>[45] = BOOST_MATH_TEST_VALUE(RealType, 0.0912765271608622642998957214231795686531192240514720326483083946071722462544175516502066459299560671);
  ws<RealType>[46] = BOOST_MATH_TEST_VALUE(RealType, 0.09957447809219979168181062315832233980460887841902355310769435168948823854831388504977465633939682845);
  ws<RealType>[47] = BOOST_MATH_TEST_VALUE(RealType, 0.1077429981622769541092028233904076346257727607117049788632909974125087436037688769621472372382338589);
  ws<RealType>[48] = BOOST_MATH_TEST_VALUE(RealType, 0.1157864971383620420455904585908175984070719832012079215609230219591260309061070611295890797209058613);
  ws<RealType>[49] = BOOST_MATH_TEST_VALUE(RealType, 0.123709152935653268637225082319130933018353939077412845800247462273779701933149651969922416814563643);
  ws<RealType>[50] = BOOST_MATH_TEST_VALUE(RealType, 0.1315149280010344580474416667366241780127651069693569916108339146599686985542850094826506230355645206);
  ws<RealType>[51] = BOOST_MATH_TEST_VALUE(RealType, 0.1392075842516055911219563262364716100580324132271864711438857091601938661529783118284822918918762012);
  ws<RealType>[52] = BOOST_MATH_TEST_VALUE(RealType, 0.1467906967200019429098356045334600022599041243103780089713630524471411698742480890410424556292186252);
  ws<RealType>[53] = BOOST_MATH_TEST_VALUE(RealType, 0.1542676660400332595939671017213220881360827710416946348345860549372631184130438485651715394816551156);
  ws<RealType>[54] = BOOST_MATH_TEST_VALUE(RealType, 0.1616417298902320361099923668622409534689583622433205732144762283241135493479959458637574220609547663);
  ws<RealType>[55] = BOOST_MATH_TEST_VALUE(RealType, 0.1689159734991095651164749037058183987284469135107297553319388783258832067427865597883933228919370041);
  ws<RealType>[56] = BOOST_MATH_TEST_VALUE(RealType, 0.176093339303957105084240207040480028792877878787501699026158171529756555902997254667356047116441788);
  ws<RealType>[57] = BOOST_MATH_TEST_VALUE(RealType, 0.1831766358446274967063002214815526159126266889851598585852904605011653998837614409160807673866997377);
  ws<RealType>[58] = BOOST_MATH_TEST_VALUE(RealType, 0.1901685459646637418459898415362480836632528245228542609994635862866965513625128722227696305198415266);
  ws<RealType>[59] = BOOST_MATH_TEST_VALUE(RealType, 0.1970716343842153356374997203517126469395880032764377549805749691269132085609349859323881542196582345);
  ws<RealType>[60] = BOOST_MATH_TEST_VALUE(RealType, 0.2038883547022401644431818313271398701493524772101596349734062600818193640670940526181645713107956088);
  ws<RealType>[61] = BOOST_MATH_TEST_VALUE(RealType, 0.2106210558793939073502149913441295543358575322967676769367700683562463350885767192666542957075712751);
  ws<RealType>[62] = BOOST_MATH_TEST_VALUE(RealType, 0.2172719882476450310112829333455034301692311490231843772189917487700633677693451679449281229277444);
  ws<RealType>[63] = BOOST_MATH_TEST_VALUE(RealType, 0.2238433090879237484082608989533539628744637740613473368794338628306680030796510487992807280960350863);
  ws<RealType>[64] = BOOST_MATH_TEST_VALUE(RealType, 0.230337087812934212569787581174413102713202565273940246146535096101718965948694383449116272546328387);
  ws<RealType>[65] = BOOST_MATH_TEST_VALUE(RealType, 0.2367553107885593168713669913131022529850076068942822776500825494062035956449035725319106127888967252);
  ws<RealType>[66] = BOOST_MATH_TEST_VALUE(RealType, 0.2430998858240055404991486201117080426760827615791233989777935602839590601547710113790997280209616842);
  ws<RealType>[67] = BOOST_MATH_TEST_VALUE(RealType, 0.2493726463579186824703694885450067240777490681347030220353778714445393581714407422015446216089384764);
  ws<RealType>[68] = BOOST_MATH_TEST_VALUE(RealType, 0.255575355365104731122377747221405406075211883935782315620283025379607560268766005462481341306785098);
  ws<RealType>[69] = BOOST_MATH_TEST_VALUE(RealType, 0.2617097090061743695408970492873886795528577990555646770473973759567281587373896180370074675102853899);
  ws<RealType>[70] = BOOST_MATH_TEST_VALUE(RealType, 0.2677773400403608426926161268075028522173112518463765933864820650709836250445193581155036917009299903);
  ws<RealType>[71] = BOOST_MATH_TEST_VALUE(RealType, 0.2737798210199097285877692071254930326690991310905656381739509847292712940678493744834592887738653624);
  ws<RealType>[72] = BOOST_MATH_TEST_VALUE(RealType, 0.279718667282780030688985330053563938014151152536888220220066424808617200267097125397004630221318648);
  ws<RealType>[73] = BOOST_MATH_TEST_VALUE(RealType, 0.2855953397589067078034135225526038434573251024673070045734211311120835242005964286865861813715576376);
  ws<RealType>[74] = BOOST_MATH_TEST_VALUE(RealType, 0.2914112476039358811079401653518892721830457004248980213382598417991951999360380881350324421536041991);
  ws<RealType>[75] = BOOST_MATH_TEST_VALUE(RealType, 0.2971677506731385467797269622470213419044581015501274519083671027242648030351552074110959032585686367);
  ws<RealType>[76] = BOOST_MATH_TEST_VALUE(RealType, 0.3028661618471218240709788492447379933660682925225029587250796959940885465093714030223793579774677182);
  ws<RealType>[77] = BOOST_MATH_TEST_VALUE(RealType, 0.3085077492199755507560853270193391876750205224915338763730055720866605941218639559241097041425718389);
  ws<RealType>[78] = BOOST_MATH_TEST_VALUE(RealType, 0.3140937381596049465307653625755662577673424859113972924301418900103932566506643308363685842713510345);
  ws<RealType>[79] = BOOST_MATH_TEST_VALUE(RealType, 0.3196253132491970154264844863020982117371468405067770401175599100299218378827848337045090472924417639);
  ws<RealType>[80] = BOOST_MATH_TEST_VALUE(RealType, 0.3251036201180404567925882149866539513803608104758008850889564944127408970111984388784259876569696298);
  ws<RealType>[81] = BOOST_MATH_TEST_VALUE(RealType, 0.3305297671692582446013104792754623176896333299898173620545327652833709938789531370957735854140619173);
  ws<RealType>[82] = BOOST_MATH_TEST_VALUE(RealType, 0.3359048272114117659741549735010360281170238179628782075568249283432891398635686044147614597227718316);
  ws<RealType>[83] = BOOST_MATH_TEST_VALUE(RealType, 0.3412298390003893228052121236143338755316388573531939840892239102731223392510954828680280968924289841);
  ws<RealType>[84] = BOOST_MATH_TEST_VALUE(RealType, 0.3465058086974944293540338951489158955895910665452626949454054191729967933634547552073491283786892473);
  ws<RealType>[85] = BOOST_MATH_TEST_VALUE(RealType, 0.3517337112491958260249093009299510651714642155171118040466438461099606107203387108968323038321915693);
  ws<RealType>[86] = BOOST_MATH_TEST_VALUE(RealType, 0.356914491693587151869424246256045038549439930737927770357941686970717473161840668532896372614750844);
  ws<RealType>[87] = BOOST_MATH_TEST_VALUE(RealType, 0.3620490663982259224347136211795537282192272992052648623722265772196673697387836128745005565051134501);
  ws<RealType>[88] = BOOST_MATH_TEST_VALUE(RealType, 0.3671383242336754065717073384163048245222026534654156361188807018443753849870522240862625069431927886);
  ws<RealType>[89] = BOOST_MATH_TEST_VALUE(RealType, 0.3721831276867561125667772461128588424710274544378039645877124572815833807252348818205119412993474916);
  ws<RealType>[90] = BOOST_MATH_TEST_VALUE(RealType, 0.3771843139172231305654429202753334704233212269643890432815783280355585518582574589199227373679397234);
  ws<RealType>[91] = BOOST_MATH_TEST_VALUE(RealType, 0.3821426957613190709393551341272838157890329391308789323327108090412283903082231991030667000296469447);
  ws<RealType>[92] = BOOST_MATH_TEST_VALUE(RealType, 0.3870590626854075768406867666899001946809584949146574272916930955076684732166306691825829034241158645);
  ws<RealType>[93] = BOOST_MATH_TEST_VALUE(RealType, 0.3919341816926673886247930427095007681691393368820432019135743979557612444151495005378394686508979365);
  ws<RealType>[94] = BOOST_MATH_TEST_VALUE(RealType, 0.3967687981856199130952904028742195107327166899059243534847812692294320278426834780185947685265825165);
  ws<RealType>[95] = BOOST_MATH_TEST_VALUE(RealType, 0.4015636367870725946626664537946836866230027160063511402379921560604975325206585381386527082762303647);
  ws<RealType>[96] = BOOST_MATH_TEST_VALUE(RealType, 0.4063194021218846501705479426913810870863608030934864938423596576756863248859417057476841165663966806);
  ws<RealType>[97] = BOOST_MATH_TEST_VALUE(RealType, 0.4110367795617996075205416204209832162005305795083946929235957810141140813392726029732502982435129093);
  ws<RealType>[98] = BOOST_MATH_TEST_VALUE(RealType, 0.4157164359354393999190647189307900734531788488207389484153095921329397217223528187979110265697876198);
  ws<RealType>[99] = BOOST_MATH_TEST_VALUE(RealType, 0.4203590202054164452305419772022302902943227646223432518640399730485379665439298245520857153666787776);
};
// End of lambert_w_mp_values.ipp 
