//  Copyright John Maddock 2008.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const std::array<std::array<typename table_type<T>::type, 3>, 380> expint_small_data = {{
      {{ SC_(0.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(577814.7758212256423775256378551874856003) }}, 
      {{ SC_(0.0), SC_(0.216575062950141727924346923828125e-5), SC_(461732.6762508792015318981937822200350918) }}, 
      {{ SC_(0.0), SC_(0.72700195232755504548549652099609375e-5), SC_(137550.2124589000541443257494936989244997) }}, 
      {{ SC_(0.0), SC_(0.14000004739500582218170166015625e-4), SC_(71427.54725445416496694480545527677490243) }}, 
      {{ SC_(0.0), SC_(0.17196454791701398789882659912109375e-4), SC_(58150.52089548332152905218845489376933772) }}, 
      {{ SC_(0.0), SC_(0.60085076256655156612396240234375e-4), SC_(16642.0678648645272946820823309167585461) }}, 
      {{ SC_(0.0), SC_(0.000116783194243907928466796875), SC_(8561.875962532232545332572615047016255041) }}, 
      {{ SC_(0.0), SC_(0.000149052008055150508880615234375), SC_(6708.067688223899497757367667879930968793) }}, 
      {{ SC_(0.0), SC_(0.0003985252114944159984588623046875), SC_(2508.25173755195584857212143870952023231) }}, 
      {{ SC_(0.0), SC_(0.00063875340856611728668212890625), SC_(1564.549694997861843953582226130571046846) }}, 
      {{ SC_(0.0), SC_(0.0010718167759478092193603515625), SC_(931.9958222627537459717559330883276580758) }}, 
      {{ SC_(0.0), SC_(0.00302191521041095256805419921875), SC_(329.9174784073144324156862883962096967334) }}, 
      {{ SC_(0.0), SC_(0.00499413348734378814697265625), SC_(199.2374290724703076159801092696400339127) }}, 
      {{ SC_(0.0), SC_(0.00928423367440700531005859375), SC_(106.7141098014748145666899963724983770114) }}, 
      {{ SC_(0.0), SC_(0.0241700224578380584716796875), SC_(40.38555342987263632091024457927399908981) }}, 
      {{ SC_(0.0), SC_(0.06227754056453704833984375), SC_(15.08765533838058040972104376703012409721) }}, 
      {{ SC_(0.0), SC_(0.12234418094158172607421875), SC_(7.232414021781513135268430322868745728174) }}, 
      {{ SC_(0.0), SC_(0.249557673931121826171875), SC_(3.122105326937778672022451656660829990212) }}, 
      {{ SC_(0.0), SC_(0.4912221431732177734375), SC_(1.245624088523070804276757644439503799036) }}, 
      {{ SC_(1.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(12.68979643564902057445113029537557060384) }}, 
      {{ SC_(1.0), SC_(0.216575062950141727924346923828125e-5), SC_(12.46553004636203965518423078801621406614) }}, 
      {{ SC_(1.0), SC_(0.72700195232755504548549652099609375e-5), SC_(11.2545431860697943553517367149605754442) }}, 
      {{ SC_(1.0), SC_(0.14000004739500582218170166015625e-4), SC_(10.5992512248675236793183882919991723644) }}, 
      {{ SC_(1.0), SC_(0.17196454791701398789882659912109375e-4), SC_(10.39360884363072197965302323976810805946) }}, 
      {{ SC_(1.0), SC_(0.60085076256655156612396240234375e-4), SC_(9.142593481727702781399755039472990143275) }}, 
      {{ SC_(1.0), SC_(0.000116783194243907928466796875), SC_(8.478092497703841888257351897157795499674) }}, 
      {{ SC_(1.0), SC_(0.000149052008055150508880615234375), SC_(8.23414864712424722136034054262711272215) }}, 
      {{ SC_(1.0), SC_(0.0003985252114944159984588623046875), SC_(7.250922616359625879162196113845954202435) }}, 
      {{ SC_(1.0), SC_(0.00063875340856611728668212890625), SC_(6.779415066673595920390207059288727481393) }}, 
      {{ SC_(1.0), SC_(0.0010718167759478092193603515625), SC_(6.262256013645805034976972133526713777336) }}, 
      {{ SC_(1.0), SC_(0.00302191521041095256805419921875), SC_(5.227668441815221372703241290567350771159) }}, 
      {{ SC_(1.0), SC_(0.00499413348734378814697265625), SC_(4.727263598094615939046673594869014017738) }}, 
      {{ SC_(1.0), SC_(0.00928423367440700531005859375), SC_(4.111484685210341022101979530301768631054) }}, 
      {{ SC_(1.0), SC_(0.0241700224578380584716796875), SC_(3.169451246062171542238811993535958670845) }}, 
      {{ SC_(1.0), SC_(0.06227754056453704833984375), SC_(2.260259939322263892205804391830568328218) }}, 
      {{ SC_(1.0), SC_(0.12234418094158172607421875), SC_(1.642402990148853649294192107450058496557) }}, 
      {{ SC_(1.0), SC_(0.249557673931121826171875), SC_(1.045662095585737033852768372992425480117) }}, 
      {{ SC_(1.0), SC_(0.4912221431732177734375), SC_(0.570563675993986183667187214912446161025) }}, 
      {{ SC_(2.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.9999763076811966831897766561746894854348) }}, 
      {{ SC_(2.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.9999708370221707573655426375521705456129) }}, 
      {{ SC_(2.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.999910909258214977122354162319349018702) }}, 
      {{ SC_(2.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.9998376105258768057557573329394689665198) }}, 
      {{ SC_(2.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.9998040704684643561925140532604520761726) }}, 
      {{ SC_(2.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.9993905833022821790211571622936164235556) }}, 
      {{ SC_(2.0), SC_(0.000116783194243907928466796875), SC_(0.9988931249016707081053405184509945116324) }}, 
      {{ SC_(2.0), SC_(0.000149052008055150508880615234375), SC_(0.9986236427091650503801677112391142850053) }}, 
      {{ SC_(2.0), SC_(0.0003985252114944159984588623046875), SC_(0.9967118787199152511223256805042743254983) }}, 
      {{ SC_(2.0), SC_(0.00063875340856611728668212890625), SC_(0.9950310760690411830694553942700458450716) }}, 
      {{ SC_(2.0), SC_(0.0010718167759478092193603515625), SC_(0.9922167663637865286439901988209755749909) }}, 
      {{ SC_(2.0), SC_(0.00302191521041095256805419921875), SC_(0.9811850754001837523201422600369909453641) }}, 
      {{ SC_(2.0), SC_(0.00499413348734378814697265625), SC_(0.9714097310243611715783408142596006996882) }}, 
      {{ SC_(2.0), SC_(0.00928423367440700531005859375), SC_(0.9525867471869806036208170870856088617673) }}, 
      {{ SC_(2.0), SC_(0.0241700224578380584716796875), SC_(0.899514025575894945250135338740921424329) }}, 
      {{ SC_(2.0), SC_(0.06227754056453704833984375), SC_(0.7988586373022102057246901625949836282736) }}, 
      {{ SC_(2.0), SC_(0.12234418094158172607421875), SC_(0.6839053211195040219693434236179451026624) }}, 
      {{ SC_(2.0), SC_(0.249557673931121826171875), SC_(0.5181923428662377685394762787685048866534) }}, 
      {{ SC_(2.0), SC_(0.4912221431732177734375), SC_(0.331604622613933458758263418893725943234) }}, 
      {{ SC_(3.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.4999982693658376543091737671690095008434) }}, 
      {{ SC_(3.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.4999978342821229854793933090060882477432) }}, 
      {{ SC_(3.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.499992730317535704456607299984943350278) }}, 
      {{ SC_(3.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.4999860011809870076130562371694389700641) }}, 
      {{ SC_(3.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.4999828053037840548845718384848723742553) }}, 
      {{ SC_(3.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.4999399341347037428568024707226853352885) }}, 
      {{ SC_(3.0), SC_(0.000116783194243907928466796875), SC_(0.4998832848474067892057518818832512203809) }}, 
      {{ SC_(3.0), SC_(0.000149052008055150508880615234375), SC_(0.4998510561202031850646246064500000857424) }}, 
      {{ SC_(3.0), SC_(0.0003985252114944159984588623046875), SC_(0.4996021696884318821443832438164013431266) }}, 
      {{ SC_(3.0), SC_(0.00063875340856611728668212890625), SC_(0.4993629355297475610790650823685848821969) }}, 
      {{ SC_(3.0), SC_(0.0010718167759478092193603515625), SC_(0.4989326414194633805099515586523952746467) }}, 
      {{ SC_(3.0), SC_(0.00302191521041095256805419921875), SC_(0.4970087940379552304612639268845472514031) }}, 
      {{ SC_(3.0), SC_(0.00499413348734378814697265625), SC_(0.4950834832977331977677179906437250733682) }}, 
      {{ SC_(3.0), SC_(0.00928423367440700531005859375), SC_(0.4909573468985959698257136388230010783411) }}, 
      {{ SC_(3.0), SC_(0.0241700224578380584716796875), SC_(0.4771892295864653755887373794289668954978) }}, 
      {{ SC_(3.0), SC_(0.06227754056453704833984375), SC_(0.4449355580849156787345354284758576392931) }}, 
      {{ SC_(3.0), SC_(0.12234418094158172607421875), SC_(0.400585966685657543850238947546362051285) }}, 
      {{ SC_(3.0), SC_(0.249557673931121826171875), SC_(0.3249132337119700131594392776225790919829) }}, 
      {{ SC_(3.0), SC_(0.4912221431732177734375), SC_(0.2244933004729631534551199436414075158278) }}, 
      {{ SC_(4.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.3333324680071245262715865645284048381042) }}, 
      {{ SC_(4.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.3333322504603637963103582665303151431887) }}, 
      {{ SC_(4.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.3333296983499974493372224529199642401407) }}, 
      {{ SC_(4.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.3333263334289579635589330888999452889502) }}, 
      {{ SC_(4.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.3333247352537861483970485437943510891261) }}, 
      {{ SC_(4.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.3333032925999163851950867018863045026453) }}, 
      {{ SC_(4.0), SC_(0.000116783194243907928466796875), SC_(0.3332749485526314189805479992822408219843) }}, 
      {{ SC_(4.0), SC_(0.000149052008055150508880615234375), SC_(0.3332588184320001054426253340418943955967) }}, 
      {{ SC_(4.0), SC_(0.0003985252114944159984588623046875), SC_(0.3331341500429304879323886027889306418722) }}, 
      {{ SC_(4.0), SC_(0.00063875340856611728668212890625), SC_(0.333014160257927408406635357113451451623) }}, 
      {{ SC_(4.0), SC_(0.0010718167759478092193603515625), SC_(0.3327979976797836072508267743048393663433) }}, 
      {{ SC_(4.0), SC_(0.00302191521041095256805419921875), SC_(0.3318269092483597307661485853343450609366) }}, 
      {{ SC_(4.0), SC_(0.00499413348734378814697265625), SC_(0.3308486011533795870796983158583450430641) }}, 
      {{ SC_(4.0), SC_(0.00928423367440700531005859375), SC_(0.3287335230068152237322561573905418455842) }}, 
      {{ SC_(4.0), SC_(0.0241700224578380584716796875), SC_(0.321528686325499046761296643527534796266) }}, 
      {{ SC_(4.0), SC_(0.06227754056453704833984375), SC_(0.3039708583641707588487204824261130758999) }}, 
      {{ SC_(4.0), SC_(0.12234418094158172607421875), SC_(0.2786114692448072420299674008584420739148) }}, 
      {{ SC_(4.0), SC_(0.249557673931121826171875), SC_(0.2326869174413194941490162582911016352083) }}, 
      {{ SC_(4.0), SC_(0.4912221431732177734375), SC_(0.1672006847220435577039399872043804888457) }}, 
      {{ SC_(5.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.2499994231156112054464478225868175766528) }}, 
      {{ SC_(5.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.2499992780842961167818165530973580904202) }}, 
      {{ SC_(5.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.2499975766733721400779896480513000531392) }}, 
      {{ SC_(5.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.2499953333807530756689397632193171572859) }}, 
      {{ SC_(5.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.2499942679223314330462557114927736244578) }}, 
      {{ SC_(5.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.2499799725437657315484048809036607807089) }}, 
      {{ SC_(5.0), SC_(0.000116783194243907928466796875), SC_(0.2499610756778986060072655969409855563922) }}, 
      {{ SC_(5.0), SC_(0.000149052008055150508880615234375), SC_(0.2499503215508885359803723774515238310774) }}, 
      {{ SC_(5.0), SC_(0.0003985252114944159984588623046875), SC_(0.2498671979578819359594098594467548202963) }}, 
      {{ SC_(5.0), SC_(0.00063875340856611728668212890625), SC_(0.2497871841552494748465221110450611975769) }}, 
      {{ SC_(5.0), SC_(0.0010718167759478092193603515625), SC_(0.2496430147343942808033948163209649673697) }}, 
      {{ SC_(5.0), SC_(0.00302191521041095256805419921875), SC_(0.2489949733488023051271180731389395708097) }}, 
      {{ SC_(5.0), SC_(0.00499413348734378814697265625), SC_(0.2483415035962114594950005069148420510374) }}, 
      {{ SC_(5.0), SC_(0.00928423367440700531005859375), SC_(0.2469266732272532034223040397507562406243) }}, 
      {{ SC_(5.0), SC_(0.0241700224578380584716796875), SC_(0.2420870944507284922750390337420489762581) }}, 
      {{ SC_(5.0), SC_(0.06227754056453704833984375), SC_(0.2301728774743846881561522041544016024552) }}, 
      {{ SC_(5.0), SC_(0.12234418094158172607421875), SC_(0.2126893194298959031515617592899204600847) }}, 
      {{ SC_(5.0), SC_(0.249557673931121826171875), SC_(0.1802691343219245000486413064752883220342) }}, 
      {{ SC_(5.0), SC_(0.4912221431732177734375), SC_(0.1324363639158242626230482022654728761494) }}, 
      {{ SC_(6.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.1999995673366460049641967287178764376758) }}, 
      {{ SC_(6.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.1999994585631243697640119955956215158009) }}, 
      {{ SC_(6.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.1999981825039280130703307389527539339626) }}, 
      {{ SC_(6.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.1999965000314815849734869604432305581943) }}, 
      {{ SC_(6.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.1999957009355879937792673172585206209907) }}, 
      {{ SC_(6.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.1999849793326204915379339620663404213245) }}, 
      {{ SC_(6.0), SC_(0.000116783194243907928466796875), SC_(0.1999708064743587132406006868918039255621) }}, 
      {{ SC_(6.0), SC_(0.000149052008055150508880615234375), SC_(0.1999627407004604659688373925079291930869) }}, 
      {{ SC_(6.0), SC_(0.0003985252114944159984588623046875), SC_(0.1999003951622435866430026938266496921632) }}, 
      {{ SC_(6.0), SC_(0.00063875340856611728668212890625), SC_(0.1998403796271336271407932741008590942797) }}, 
      {{ SC_(6.0), SC_(0.0010718167759478092193603515625), SC_(0.1997322371686603290924085933634566379327) }}, 
      {{ SC_(6.0), SC_(0.00302191521041095256805419921875), SC_(0.1992460408964423756244108293541117608605) }}, 
      {{ SC_(6.0), SC_(0.00499413348734378814697265625), SC_(0.1987556131687399264370086252838978909125) }}, 
      {{ SC_(6.0), SC_(0.00928423367440700531005859375), SC_(0.1976932413637066757394817471625577237966) }}, 
      {{ SC_(6.0), SC_(0.0241700224578380584716796875), SC_(0.1940536965725227157665771390371888397218) }}, 
      {{ SC_(6.0), SC_(0.06227754056453704833984375), SC_(0.1850574933291966669077136179077438196585) }}, 
      {{ SC_(6.0), SC_(0.12234418094158172607421875), SC_(0.1717644938289194367486550307278864140087) }}, 
      {{ SC_(6.0), SC_(0.249557673931121826171875), SC_(0.1468315594631200476064231753398882300411) }}, 
      {{ SC_(6.0), SC_(0.4912221431732177734375), SC_(0.1093644919671378757189796182413879395249) }}, 
      {{ SC_(7.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.1666663205359585109609719894142995101411) }}, 
      {{ SC_(7.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.1666662335171270752925038942979400736368) }}, 
      {{ SC_(7.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.1666652126693686381933638173331056666197) }}, 
      {{ SC_(7.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.1666638666902186306946789400080985267427) }}, 
      {{ SC_(7.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.1666632274126728010473201062136102289408) }}, 
      {{ SC_(7.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.1666546501026803333847125533143404716918) }}, 
      {{ SC_(7.0), SC_(0.000116783194243907928466796875), SC_(0.1666433117325187114084653460018162624208) }}, 
      {{ SC_(7.0), SC_(0.000149052008055150508880615234375), SC_(0.1666368590419343175560338930696031821132) }}, 
      {{ SC_(7.0), SC_(0.0003985252114944159984588623046875), SC_(0.1665869814736449607941247474352503569426) }}, 
      {{ SC_(7.0), SC_(0.00063875340856611728668212890625), SC_(0.1665389669712179092138275188989262765907) }}, 
      {{ SC_(7.0), SC_(0.0010718167759478092193603515625), SC_(0.1664524468419995331119660147079095521575) }}, 
      {{ SC_(7.0), SC_(0.00302191521041095256805419921875), SC_(0.1660634235896485619408270262884485590605) }}, 
      {{ SC_(7.0), SC_(0.00499413348734378814697265625), SC_(0.165670950733263871259068886800095095511) }}, 
      {{ SC_(7.0), SC_(0.00928423367440700531005859375), SC_(0.164820550250757923368498039856098512936) }}, 
      {{ SC_(7.0), SC_(0.0241700224578380584716796875), SC_(0.1619049085280093472329962889514823049632) }}, 
      {{ SC_(7.0), SC_(0.06227754056453704833984375), SC_(0.1546828569686949921899052006303974689854) }}, 
      {{ SC_(7.0), SC_(0.12234418094158172607421875), SC_(0.1439715639021542874422150208138231842592) }}, 
      {{ SC_(7.0), SC_(0.249557673931121826171875), SC_(0.123750400119876872751820629596297627684) }}, 
      {{ SC_(7.0), SC_(0.4912221431732177734375), SC_(0.09302597903689019164880472777711928047359) }}, 
      {{ SC_(8.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.1428568544148735808781192733002851507633) }}, 
      {{ SC_(8.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.142856781899173654062296115818394507506) }}, 
      {{ SC_(8.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.1428559311925076135945476231147924843289) }}, 
      {{ SC_(8.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.1428548095426195059835087605604923576577) }}, 
      {{ SC_(8.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.1428542768109158340969845102903107982851) }}, 
      {{ SC_(8.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.1428471290387793486692888373190714557271) }}, 
      {{ SC_(8.0), SC_(0.000116783194243907928466796875), SC_(0.1428376803552006239388352098411426354666) }}, 
      {{ SC_(8.0), SC_(0.000149052008055150508880615234375), SC_(0.1428323030773124738526110222386890754382) }}, 
      {{ SC_(8.0), SC_(0.0003985252114944159984588623046875), SC_(0.1427907378681579449293000200528290972611) }}, 
      {{ SC_(8.0), SC_(0.00063875340856611728668212890625), SC_(0.1427507247454502126120753111970087575651) }}, 
      {{ SC_(8.0), SC_(0.0010718167759478092193603515625), SC_(0.142678621555652762762107538246220658783) }}, 
      {{ SC_(8.0), SC_(0.00302191521041095256805419921875), SC_(0.1423544023705502882269519246265712881969) }}, 
      {{ SC_(8.0), SC_(0.00499413348734378814697265625), SC_(0.1420272762314528148018794339362192255462) }}, 
      {{ SC_(8.0), SC_(0.00928423367440700531005859375), SC_(0.1413183570357638227021465856426698329799) }}, 
      {{ SC_(8.0), SC_(0.0241700224578380584716796875), SC_(0.1388866411567263210278922912995766892226) }}, 
      {{ SC_(8.0), SC_(0.06227754056453704833984375), SC_(0.1328555427800348797374414593959426400424) }}, 
      {{ SC_(8.0), SC_(0.12234418094158172607421875), SC_(0.1238899552372546545472667765733820900346) }}, 
      {{ SC_(8.0), SC_(0.249557673931121826171875), SC_(0.1068946401652277975340878746040295741526) }}, 
      {{ SC_(8.0), SC_(0.4912221431732177734375), SC_(0.08088310193702867823051770661734151864227) }}, 
      {{ SC_(9.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.1249997527637620604326672847311155586928) }}, 
      {{ SC_(9.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.1249996906074438010127791229133040833274) }}, 
      {{ SC_(9.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.1249989614301868083880516617124344007489) }}, 
      {{ SC_(9.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.1249980000156561814140650490054225773677) }}, 
      {{ SC_(9.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.1249975433882441874555485054009696622375) }}, 
      {{ SC_(9.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.124991416718521755887449021341929686573) }}, 
      {{ SC_(9.0), SC_(0.000116783194243907928466796875), SC_(0.1249833178230097004724362786885679901135) }}, 
      {{ SC_(9.0), SC_(0.000149052008055150508880615234375), SC_(0.1249787087072568381330521173731915148857) }}, 
      {{ SC_(9.0), SC_(0.0003985252114944159984588623046875), SC_(0.1249430810600151579827996508965212932306) }}, 
      {{ SC_(9.0), SC_(0.00063875340856611728668212890625), SC_(0.1249087835048696242301614558094775193733) }}, 
      {{ SC_(9.0), SC_(0.0010718167759478092193603515625), SC_(0.1248469790092924622540583350470436501338) }}, 
      {{ SC_(9.0), SC_(0.00302191521041095256805419921875), SC_(0.1245690579057122458359550268350507283437) }}, 
      {{ SC_(9.0), SC_(0.00499413348734378814697265625), SC_(0.1242886266608453818334250421558130175011) }}, 
      {{ SC_(9.0), SC_(0.00928423367440700531005859375), SC_(0.1236808373880019783729475638951049481542) }}, 
      {{ SC_(9.0), SC_(0.0241700224578380584716796875), SC_(0.121595355017048584868687526759894684985) }}, 
      {{ SC_(9.0), SC_(0.06227754056453704833984375), SC_(0.1164185188631304166733756994725551588974) }}, 
      {{ SC_(9.0), SC_(0.12234418094158172607421875), SC_(0.1087108193281098872435930111186001103594) }}, 
      {{ SC_(9.0), SC_(0.249557673931121826171875), SC_(0.09405862067540226968400526059351356846386) }}, 
      {{ SC_(9.0), SC_(0.4912221431732177734375), SC_(0.07151832045906046342156767136731221443337) }}, 
      {{ SC_(10.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.1111108947793984569014216518069218833733) }}, 
      {{ SC_(10.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.1111108403926174571367154282307620812091) }}, 
      {{ SC_(10.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.1111102023624459184130925638160020991326) }}, 
      {{ SC_(10.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.1111093611245186067953571073222145478079) }}, 
      {{ SC_(10.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.111108961575384725564527240456460394385) }}, 
      {{ SC_(10.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.1111036007344456029637817806930808383435) }}, 
      {{ SC_(10.0), SC_(0.000116783194243907928466796875), SC_(0.1110965141859517001982144185566089271586) }}, 
      {{ SC_(10.0), SC_(0.000149052008055150508880615234375), SC_(0.1110924811969051737763119458245183802011) }}, 
      {{ SC_(10.0), SC_(0.0003985252114944159984588623046875), SC_(0.1110613068023694898577937931449967614007) }}, 
      {{ SC_(10.0), SC_(0.00063875340856611728668212890625), SC_(0.1110312960710822056745981665129038028815) }}, 
      {{ SC_(10.0), SC_(0.0010718167759478092193603515625), SC_(0.1109772160364403990792163363469815693873) }}, 
      {{ SC_(10.0), SC_(0.00302191521041095256805419921875), SC_(0.1107340232276287398901233051893227450036) }}, 
      {{ SC_(10.0), SC_(0.00499413348734378814697265625), SC_(0.1104886224967337646396427643969969266167) }}, 
      {{ SC_(10.0), SC_(0.00928423367440700531005859375), SC_(0.1099567166619847325201763231676300471) }}, 
      {{ SC_(10.0), SC_(0.0241700224578380584716796875), SC_(0.108131196767856621531116300961376597551) }}, 
      {{ SC_(10.0), SC_(0.06227754056453704833984375), SC_(0.1035968675920876240807996818255192946751) }}, 
      {{ SC_(10.0), SC_(0.12234418094158172607421875), SC_(0.09683818150834270733282783916064409551927) }}, 
      {{ SC_(10.0), SC_(0.249557673931121826171875), SC_(0.08396358806329261792071661328014740666971) }}, 
      {{ SC_(10.0), SC_(0.4912221431732177734375), SC_(0.06408297241116001197035783749606063229405) }}, 
      {{ SC_(11.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.09999980770514133597675414931859600344223) }}, 
      {{ SC_(11.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.09999975936133432100414877159704021199218) }}, 
      {{ SC_(11.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.09999919222335628422644365761786665251362) }}, 
      {{ SC_(11.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.09999844445616777622963693922673145404521) }}, 
      {{ SC_(11.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.09999808930128317957647384863686405871679) }}, 
      {{ SC_(11.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.09999332410604928682840606296109188602285) }}, 
      {{ SC_(11.0), SC_(0.000116783194243907928466796875), SC_(0.09998702494188518753354731835115754020628) }}, 
      {{ SC_(11.0), SC_(0.000149052008055150508880615234375), SC_(0.09998344005422412925756796544646105486278) }}, 
      {{ SC_(11.0), SC_(0.0003985252114944159984588623046875), SC_(0.09995572934583473546996768666538729313667) }}, 
      {{ SC_(11.0), SC_(0.00063875340856611728668212890625), SC_(0.09992905289321405162448653681779504313782) }}, 
      {{ SC_(11.0), SC_(0.0010718167759478092193603515625), SC_(0.09988098101725963143130671945579744367585) }}, 
      {{ SC_(11.0), SC_(0.00302191521041095256805419921875), SC_(0.09966480173503889225544076583378042307555) }}, 
      {{ SC_(11.0), SC_(0.00499413348734378814697265625), SC_(0.09944665215335253553056778674874271396217) }}, 
      {{ SC_(11.0), SC_(0.00928423367440700531005859375), SC_(0.09897378679016587091134493183299636500794) }}, 
      {{ SC_(11.0), SC_(0.0241700224578380584716796875), SC_(0.09735061999179684490879044971256167485506) }}, 
      {{ SC_(11.0), SC_(0.06227754056453704833984375), SC_(0.0933170309235925332247990297132760214755) }}, 
      {{ SC_(11.0), SC_(0.12234418094158172607421875), SC_(0.08729961817247598282239360210982686247619) }}, 
      {{ SC_(11.0), SC_(0.249557673931121826171875), SC_(0.075819158542657046280238835356443181261) }}, 
      {{ SC_(11.0), SC_(0.4912221431732177734375), SC_(0.05803991593037685685793414702984855120059) }}, 
      {{ SC_(12.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.09090891784371603149518600552833329425637) }}, 
      {{ SC_(12.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.09090887433428854072583604475717968565254) }}, 
      {{ SC_(12.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.09090836391007486152351513252442904504059) }}, 
      {{ SC_(12.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.09090769091950579812763781260751349192882) }}, 
      {{ SC_(12.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.09090737128004041397458968915744009736645) }}, 
      {{ SC_(12.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.0909030826020283016372965283444900077506) }}, 
      {{ SC_(12.0), SC_(0.000116783194243907928466796875), SC_(0.09089741334731747416007985901915857398215) }}, 
      {{ SC_(12.0), SC_(0.000149052008055150508880615234375), SC_(0.09089418694246647058810371865449823032756) }}, 
      {{ SC_(12.0), SC_(0.0003985252114944159984588623046875), SC_(0.09086924721008654434828770391744254174568) }}, 
      {{ SC_(12.0), SC_(0.00063875340856611728668212890625), SC_(0.09084523822980119176820213507998464872103) }}, 
      {{ SC_(12.0), SC_(0.0010718167759478092193603515625), SC_(0.09080197302758543016549463364527940417656) }}, 
      {{ SC_(12.0), SC_(0.00302191521041095256805419921875), SC_(0.09060740614538043524020592986918340348091) }}, 
      {{ SC_(12.0), SC_(0.00499413348734378814697265625), SC_(0.09041106060067122658993654509695340700083) }}, 
      {{ SC_(12.0), SC_(0.00928423367440700531005859375), SC_(0.08998543963536530003661856436147827766534) }}, 
      {{ SC_(12.0), SC_(0.0241700224578380584716796875), SC_(0.0885242515182503873911397533406318575276) }}, 
      {{ SC_(12.0), SC_(0.06227754056453704833984375), SC_(0.08489186474373130460534785667471398267764) }}, 
      {{ SC_(12.0), SC_(0.12234418094158172607421875), SC_(0.07946937904031325855940951342656922816909) }}, 
      {{ SC_(12.0), SC_(0.249557673931121826171875), SC_(0.06911128093756693069367210021832517578288) }}, 
      {{ SC_(12.0), SC_(0.4912221431732177734375), SC_(0.05303342204177960664912054128073610056634) }}, 
      {{ SC_(13.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.08333317600117284099184869037740301631409) }}, 
      {{ SC_(13.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.08333313644714699316946699817142059689431) }}, 
      {{ SC_(13.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.08333267242511023308839596483396819928955) }}, 
      {{ SC_(13.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.0833320606154296981919490981670984230882) }}, 
      {{ SC_(13.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.08333177003404716917724179238390486798274) }}, 
      {{ SC_(13.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.08332787123418043987690162279088360260336) }}, 
      {{ SC_(13.0), SC_(0.000116783194243907928466796875), SC_(0.08332271736119738881998583983706767483859) }}, 
      {{ SC_(13.0), SC_(0.000149052008055150508880615234375), SC_(0.0833197842615466004561257854670130749122) }}, 
      {{ SC_(13.0), SC_(0.0003985252114944159984588623046875), SC_(0.08329711170859723975931766695759929096705) }}, 
      {{ SC_(13.0), SC_(0.00063875340856611728668212890625), SC_(0.0832752852371160122743231407129948894204) }}, 
      {{ SC_(13.0), SC_(0.0010718167759478092193603515625), SC_(0.08323595286137600240196813776876034382459) }}, 
      {{ SC_(13.0), SC_(0.00302191521041095256805419921875), SC_(0.08305906985672365713435017923620490888333) }}, 
      {{ SC_(13.0), SC_(0.00499413348734378814697265625), SC_(0.08288056596314455823901650776153873189154) }}, 
      {{ SC_(13.0), SC_(0.00928423367440700531005859375), SC_(0.08249360715869584668822453500316491394612) }}, 
      {{ SC_(13.0), SC_(0.0241700224578380584716796875), SC_(0.0811650083520817527503370935560498531099) }}, 
      {{ SC_(13.0), SC_(0.06227754056453704833984375), SC_(0.07786126756746446866379791447935208944906) }}, 
      {{ SC_(13.0), SC_(0.12234418094158172607421875), SC_(0.07292676280305391786313843424668789859853) }}, 
      {{ SC_(13.0), SC_(0.249557673931121826171875), SC_(0.06349150772044809925640555488872857831394) }}, 
      {{ SC_(13.0), SC_(0.4912221431732177734375), SC_(0.04881891192644300261465981982025741827539) }}, 
      {{ SC_(14.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.07692293270192867056543562699538441285583) }}, 
      {{ SC_(14.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.0769228964440710012344728838406850583334) }}, 
      {{ SC_(14.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.07692247109051906115891896156059973330125) }}, 
      {{ SC_(14.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.07692191026492434923638654737971706484434) }}, 
      {{ SC_(14.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.07692164389861925975434793108993496260236) }}, 
      {{ SC_(14.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.07691806999748599814943152086996911260154) }}, 
      {{ SC_(14.0), SC_(0.000116783194243907928466796875), SC_(0.07691334561012010395780541439321710471635) }}, 
      {{ SC_(14.0), SC_(0.000149052008055150508880615234375), SC_(0.07691065693219143191504630888978825884147) }}, 
      {{ SC_(14.0), SC_(0.0003985252114944159984588623046875), SC_(0.07688987370692839019328246159046199168894) }}, 
      {{ SC_(14.0), SC_(0.00063875340856611728668212890625), SC_(0.07686986601374376232543069428262715095707) }}, 
      {{ SC_(14.0), SC_(0.0010718167759478092193603515625), SC_(0.07683381105568102550154808856089764095341) }}, 
      {{ SC_(14.0), SC_(0.00302191521041095256805419921875), SC_(0.07667166528560983649912401473257889126991) }}, 
      {{ SC_(14.0), SC_(0.00499413348734378814697265625), SC_(0.07650803075793694104802016836786104375801) }}, 
      {{ SC_(14.0), SC_(0.00928423367440700531005859375), SC_(0.07615329552520869775634144814095036449211) }}, 
      {{ SC_(14.0), SC_(0.0241700224578380584716796875), SC_(0.07493522871519846308938791611988935762331) }}, 
      {{ SC_(14.0), SC_(0.06227754056453704833984375), SC_(0.07190561993157011549765803135931994222671) }}, 
      {{ SC_(14.0), SC_(0.12234418094158172607421875), SC_(0.06737858497395458474863130657857757639511) }}, 
      {{ SC_(14.0), SC_(0.249557673931121826171875), SC_(0.05871542693672782953195581711588401645767) }}, 
      {{ SC_(14.0), SC_(0.4912221431732177734375), SC_(0.04522286183143052947956742362768640870137) }}, 
      {{ SC_(15.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.07142843830135678430557686186483907103332) }}, 
      {{ SC_(15.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.07142840483256459556893886139866769560301) }}, 
      {{ SC_(15.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.07142801219850261754791111032097799780857) }}, 
      {{ SC_(15.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.07142749451329655914708777285149771592756) }}, 
      {{ SC_(15.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.07142724863667819098544040349933483459537) }}, 
      {{ SC_(15.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.07142394965005100519504785729035742912749) }}, 
      {{ SC_(15.0), SC_(0.000116783194243907928466796875), SC_(0.07141958867417625278045171566133804924267) }}, 
      {{ SC_(15.0), SC_(0.000149052008055150508880615234375), SC_(0.07141710681512763831624656689212439533833) }}, 
      {{ SC_(15.0), SC_(0.0003985252114944159984588623046875), SC_(0.07139792225971062733216224219889843492458) }}, 
      {{ SC_(15.0), SC_(0.00063875340856611728668212890625), SC_(0.07137945354728793815621837897126096496695) }}, 
      {{ SC_(15.0), SC_(0.0010718167759478092193603515625), SC_(0.07134617183191733372828052493089770600179) }}, 
      {{ SC_(15.0), SC_(0.00302191521041095256805419921875), SC_(0.07119649649342545512786733526338407058593) }}, 
      {{ SC_(15.0), SC_(0.00499413348734378814697265625), SC_(0.07104544465318913130029520977272205803238) }}, 
      {{ SC_(15.0), SC_(0.00928423367440700531005859375), SC_(0.07071797905446335190765005167612134211414) }}, 
      {{ SC_(15.0), SC_(0.0241700224578380584716796875), SC_(0.06959346765795077653558839105295821251784) }}, 
      {{ SC_(15.0), SC_(0.06227754056453704833984375), SC_(0.0667959972998317143729966269635932436109) }}, 
      {{ SC_(15.0), SC_(0.12234418094158172607421875), SC_(0.06261431370954492875982416200591991469247) }}, 
      {{ SC_(15.0), SC_(0.249557673931121826171875), SC_(0.05460660412773958169800526198387768453117) }}, 
      {{ SC_(15.0), SC_(0.4912221431732177734375), SC_(0.0421188330888019402635824495314924339382) }}, 
      {{ SC_(16.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.06666654304853809699945783166277385282533) }}, 
      {{ SC_(16.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.06666651197037353362502658679389514469466) }}, 
      {{ SC_(16.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.0666661473815906706976833386950951600242) }}, 
      {{ SC_(16.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.0666656666738665594423295905799989143287) }}, 
      {{ SC_(16.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.06666543835984096023360798850623321457013) }}, 
      {{ SC_(16.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.06666237501435694077352966293019493851952) }}, 
      {{ SC_(16.0), SC_(0.000116783194243907928466796875), SC_(0.06665832553446339453823619449641153525662) }}, 
      {{ SC_(16.0), SC_(0.000149052008055150508880615234375), SC_(0.06665602094909754909286909682461902922413) }}, 
      {{ SC_(16.0), SC_(0.0003985252114944159984588623046875), SC_(0.06663820668780405347821578869651693922563) }}, 
      {{ SC_(16.0), SC_(0.00063875340856611728668212890625), SC_(0.06662105711211390111652234096260015918844) }}, 
      {{ SC_(16.0), SC_(0.0010718167759478092193603515625), SC_(0.06659015249270820342229697822760925298911) }}, 
      {{ SC_(16.0), SC_(0.00302191521041095256805419921875), SC_(0.0664511664269206027424005742189069408551) }}, 
      {{ SC_(16.0), SC_(0.00499413348734378814697265625), SC_(0.06631090040192273720685590565904807744936) }}, 
      {{ SC_(16.0), SC_(0.00928423367440700531005859375), SC_(0.06600681130071304531237155750190562009028) }}, 
      {{ SC_(16.0), SC_(0.0241700224578380584716796875), SC_(0.06496251051306859685686412141792258653208) }}, 
      {{ SC_(16.0), SC_(0.06227754056453704833984375), SC_(0.06236414512855743773641213229896183548994) }}, 
      {{ SC_(16.0), SC_(0.12234418094158172607421875), SC_(0.05847888485328378106294664079191164865064) }}, 
      {{ SC_(16.0), SC_(0.249557673931121826171875), SC_(0.05103452307007735926554556327773818214919) }}, 
      {{ SC_(16.0), SC_(0.4912221431732177734375), SC_(0.0394125620596434965123587499491500472372) }}, 
      {{ SC_(17.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.06249988462307945307908017581791268977313) }}, 
      {{ SC_(17.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.06249985561679221676774980550769608140614) }}, 
      {{ SC_(17.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.06249951533391939041337864186116416893234) }}, 
      {{ SC_(17.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.06249906667335066952129732040559092146342) }}, 
      {{ SC_(17.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.06249885358024184723716755518368815597862) }}, 
      {{ SC_(17.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.06249599445718307493973764409020902900864) }}, 
      {{ SC_(17.0), SC_(0.000116783194243907928466796875), SC_(0.06249221494077931309495003783005590817055) }}, 
      {{ SC_(17.0), SC_(0.000149052008055150508880615234375), SC_(0.06249006399286700569832074698786566925701) }}, 
      {{ SC_(17.0), SC_(0.0003985252114944159984588623046875), SC_(0.06247343732398223434411132037030316052086) }}, 
      {{ SC_(17.0), SC_(0.00063875340856611728668212890625), SC_(0.06245743100772817456409663607219418267563) }}, 
      {{ SC_(17.0), SC_(0.0010718167759478092193603515625), SC_(0.06242858656074609674340793412520265769202) }}, 
      {{ SC_(17.0), SC_(0.00302191521041095256805419921875), SC_(0.0622988647743072145354092596903005273557) }}, 
      {{ SC_(17.0), SC_(0.00499413348734378814697265625), SC_(0.0621679469359271011639958295023269764062) }}, 
      {{ SC_(17.0), SC_(0.00928423367440700531005859375), SC_(0.06188411931831255179325908903786178409114) }}, 
      {{ SC_(17.0), SC_(0.0241700224578380584716796875), SC_(0.0609093492521388775469551843749806027059) }}, 
      {{ SC_(17.0), SC_(0.06227754056453704833984375), SC_(0.0584836363613583832127398530378980108328) }}, 
      {{ SC_(17.0), SC_(0.12234418094158172607421875), SC_(0.05485557615346988551034803028047672930453) }}, 
      {{ SC_(17.0), SC_(0.249557673931121826171875), SC_(0.04790058039318774966694255640723585925481) }}, 
      {{ SC_(17.0), SC_(0.4912221431732177734375), SC_(0.03703236319685020300958697194277916844504) }}, 
      {{ SC_(18.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.05882342124590124743503668917708420145518) }}, 
      {{ SC_(18.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.05882339405250671111581257451611106191635) }}, 
      {{ SC_(18.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.05882307503730626938175588111928585498593) }}, 
      {{ SC_(18.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.05882265441800179218625554918997835286824) }}, 
      {{ SC_(18.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.05882245464319743258599789131069371575228) }}, 
      {{ SC_(18.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.05881977421483662888664297358478870305647) }}, 
      {{ SC_(18.0), SC_(0.000116783194243907928466796875), SC_(0.0588162309167159831370507751429249096136) }}, 
      {{ SC_(18.0), SC_(0.000149052008055150508880615234375), SC_(0.05881421440177187580343423242512009971648) }}, 
      {{ SC_(18.0), SC_(0.0003985252114944159984588623046875), SC_(0.05879862687937101718003654785828567378979) }}, 
      {{ SC_(18.0), SC_(0.00063875340856611728668212890625), SC_(0.05878362092082452731016712169968859340322) }}, 
      {{ SC_(18.0), SC_(0.0010718167759478092193603515625), SC_(0.05875657914165397869174629461513706700597) }}, 
      {{ SC_(18.0), SC_(0.00302191521041095256805419921875), SC_(0.05863496378190809879409693964081298572753) }}, 
      {{ SC_(18.0), SC_(0.00499413348734378814697265625), SC_(0.05851222596691027379082269719377427641588) }}, 
      {{ SC_(18.0), SC_(0.00928423367440700531005859375), SC_(0.05824612853698429641923284472585223102581) }}, 
      {{ SC_(18.0), SC_(0.0241700224578380584716796875), SC_(0.05733220900193670301704905656625237704967) }}, 
      {{ SC_(18.0), SC_(0.06227754056453704833984375), SC_(0.05505763825434673012796407470855753202628) }}, 
      {{ SC_(18.0), SC_(0.12234418094158172607421875), SC_(0.0516548534818056121546604299679736700432) }}, 
      {{ SC_(18.0), SC_(0.249557673931121826171875), SC_(0.04512890504327541405581236239109694591622) }}, 
      {{ SC_(18.0), SC_(0.4912221431732177734375), SC_(0.03492276573742135444124721201053141343969) }}, 
      {{ SC_(19.0), SC_(0.1730655412757187150418758392333984375e-5), SC_(0.05555545375238958055070296836154042278148) }}, 
      {{ SC_(19.0), SC_(0.216575062950141727924346923828125e-5), SC_(0.05555542815860627978655071793595712560455) }}, 
      {{ SC_(19.0), SC_(0.72700195232755504548549652099609375e-5), SC_(0.05555512790899996177912196960367217844985) }}, 
      {{ SC_(19.0), SC_(0.14000004739500582218170166015625e-4), SC_(0.05555473203198997035603620704636908809792) }}, 
      {{ SC_(19.0), SC_(0.17196454791701398789882659912109375e-4), SC_(0.0555545440086324706169620903193223815888) }}, 
      {{ SC_(19.0), SC_(0.60085076256655156612396240234375e-4), SC_(0.05555202125212201603991344567350516412012) }}, 
      {{ SC_(19.0), SC_(0.000116783194243907928466796875), SC_(0.05554868638207377961222457350655311699087) }}, 
      {{ SC_(19.0), SC_(0.000149052008055150508880615234375), SC_(0.0555467884846047083384104067993782562285) }}, 
      {{ SC_(19.0), SC_(0.0003985252114944159984588623046875), SC_(0.05553211785855094070193498404565764766408) }}, 
      {{ SC_(19.0), SC_(0.00063875340856611728668212890625), SC_(0.05551799457292957769783835164124369758407) }}, 
      {{ SC_(19.0), SC_(0.0010718167759478092193603515625), SC_(0.05549254339595949030608724637993842293557) }}, 
      {{ SC_(19.0), SC_(0.00302191521041095256805419921875), SC_(0.05537808090503200278730106215360027103479) }}, 
      {{ SC_(19.0), SC_(0.00499413348734378814697265625), SC_(0.05526256103311035590358747232544709551335) }}, 
      {{ SC_(19.0), SC_(0.00928423367440700531005859375), SC_(0.05501210894918067939819530617078899142577) }}, 
      {{ SC_(19.0), SC_(0.0241700224578380584716796875), SC_(0.05415188958850589857220572747127058337905) }}, 
      {{ SC_(19.0), SC_(0.06227754056453704833984375), SC_(0.05201073405888765875221070931942632402262) }}, 
      {{ SC_(19.0), SC_(0.12234418094158172607421875), SC_(0.04880689438802118463144973826036250259302) }}, 
      {{ SC_(19.0), SC_(0.249557673931121826171875), SC_(0.04266017103271657719951582163012671039402) }}, 
      {{ SC_(19.0), SC_(0.4912221431732177734375), SC_(0.03304018325118980221254092304969558212594) }}
   }};

