// Copyright Justinas Vygintas Daugmaudis, 2010.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0. (See accompanying
// file LICENSE-1.0 or http://www.boost.org/LICENSE-1.0)

#include <boost/random/faure.hpp>

#include <boost/utility.hpp>

#define BOOST_TEST_MAIN
#include <boost/test/unit_test.hpp>

#include "test_qrng_functions.hpp"

//
// DESCRIPTION:
// ~~~~~~~~~~~~
//
// This file tests the faure quasi-random number generator.
// These tests compare our results with values produced by the original
// version of ACM TOMS Algorithm 647, which  is available in the
// TOMS subdirectory in http://www.netlib.org
//
// For independently generated datasets look at http://people.sc.fsu.edu/~jburkardt/datasets/faure/


// Spatial dimension: 2
// N: 100
// Base: 2
// Vectors skipped: 15
static const double faure_02_100[100][2] =
{
  { 0.9375000000, 0.0625000000 },
  { 0.0312500000, 0.5312500000 },
  { 0.5312500000, 0.0312500000 },
  { 0.2812500000, 0.2812500000 },
  { 0.7812500000, 0.7812500000 },
  { 0.1562500000, 0.1562500000 },
  { 0.6562500000, 0.6562500000 },
  { 0.4062500000, 0.9062500000 },
  { 0.9062500000, 0.4062500000 },
  { 0.0937500000, 0.4687500000 },
  { 0.5937500000, 0.9687500000 },
  { 0.3437500000, 0.7187500000 },
  { 0.8437500000, 0.2187500000 },
  { 0.2187500000, 0.8437500000 },
  { 0.7187500000, 0.3437500000 },
  { 0.4687500000, 0.0937500000 },
  { 0.9687500000, 0.5937500000 },
  { 0.0156250000, 0.7968750000 },
  { 0.5156250000, 0.2968750000 },
  { 0.2656250000, 0.0468750000 },
  { 0.7656250000, 0.5468750000 },
  { 0.1406250000, 0.4218750000 },
  { 0.6406250000, 0.9218750000 },
  { 0.3906250000, 0.6718750000 },
  { 0.8906250000, 0.1718750000 },
  { 0.0781250000, 0.2343750000 },
  { 0.5781250000, 0.7343750000 },
  { 0.3281250000, 0.9843750000 },
  { 0.8281250000, 0.4843750000 },
  { 0.2031250000, 0.6093750000 },
  { 0.7031250000, 0.1093750000 },
  { 0.4531250000, 0.3593750000 },
  { 0.9531250000, 0.8593750000 },
  { 0.0468750000, 0.2656250000 },
  { 0.5468750000, 0.7656250000 },
  { 0.2968750000, 0.5156250000 },
  { 0.7968750000, 0.0156250000 },
  { 0.1718750000, 0.8906250000 },
  { 0.6718750000, 0.3906250000 },
  { 0.4218750000, 0.1406250000 },
  { 0.9218750000, 0.6406250000 },
  { 0.1093750000, 0.7031250000 },
  { 0.6093750000, 0.2031250000 },
  { 0.3593750000, 0.4531250000 },
  { 0.8593750000, 0.9531250000 },
  { 0.2343750000, 0.0781250000 },
  { 0.7343750000, 0.5781250000 },
  { 0.4843750000, 0.8281250000 },
  { 0.9843750000, 0.3281250000 },
  { 0.0078125000, 0.6640625000 },
  { 0.5078125000, 0.1640625000 },
  { 0.2578125000, 0.4140625000 },
  { 0.7578125000, 0.9140625000 },
  { 0.1328125000, 0.0390625000 },
  { 0.6328125000, 0.5390625000 },
  { 0.3828125000, 0.7890625000 },
  { 0.8828125000, 0.2890625000 },
  { 0.0703125000, 0.3515625000 },
  { 0.5703125000, 0.8515625000 },
  { 0.3203125000, 0.6015625000 },
  { 0.8203125000, 0.1015625000 },
  { 0.1953125000, 0.9765625000 },
  { 0.6953125000, 0.4765625000 },
  { 0.4453125000, 0.2265625000 },
  { 0.9453125000, 0.7265625000 },
  { 0.0390625000, 0.1328125000 },
  { 0.5390625000, 0.6328125000 },
  { 0.2890625000, 0.8828125000 },
  { 0.7890625000, 0.3828125000 },
  { 0.1640625000, 0.5078125000 },
  { 0.6640625000, 0.0078125000 },
  { 0.4140625000, 0.2578125000 },
  { 0.9140625000, 0.7578125000 },
  { 0.1015625000, 0.8203125000 },
  { 0.6015625000, 0.3203125000 },
  { 0.3515625000, 0.0703125000 },
  { 0.8515625000, 0.5703125000 },
  { 0.2265625000, 0.4453125000 },
  { 0.7265625000, 0.9453125000 },
  { 0.4765625000, 0.6953125000 },
  { 0.9765625000, 0.1953125000 },
  { 0.0234375000, 0.3984375000 },
  { 0.5234375000, 0.8984375000 },
  { 0.2734375000, 0.6484375000 },
  { 0.7734375000, 0.1484375000 },
  { 0.1484375000, 0.7734375000 },
  { 0.6484375000, 0.2734375000 },
  { 0.3984375000, 0.0234375000 },
  { 0.8984375000, 0.5234375000 },
  { 0.0859375000, 0.5859375000 },
  { 0.5859375000, 0.0859375000 },
  { 0.3359375000, 0.3359375000 },
  { 0.8359375000, 0.8359375000 },
  { 0.2109375000, 0.2109375000 },
  { 0.7109375000, 0.7109375000 },
  { 0.4609375000, 0.9609375000 },
  { 0.9609375000, 0.4609375000 },
  { 0.0546875000, 0.9296875000 },
  { 0.5546875000, 0.4296875000 },
  { 0.3046875000, 0.1796875000 }
};

// Spatial dimension: 7
// N: 100
// Base: 7
// Vectors skipped: 2400
static const double faure_07_100[100][7] =
{
  { 0.9995835069, 0.4602249063, 0.9412744690, 0.3202832153, 0.9850062474, 0.8334027489, 0.1103706789 },
  { 0.0000594990, 0.2437079788, 0.3765692866, 0.6493722854, 0.6685309692, 0.3582435890, 0.2228833224 },
  { 0.1429166419, 0.3865651217, 0.5194264295, 0.7922294282, 0.8113881121, 0.5011007318, 0.3657404653 },
  { 0.2857737847, 0.5294222645, 0.6622835723, 0.9350865711, 0.9542452550, 0.6439578747, 0.5085976081 },
  { 0.4286309276, 0.6722794074, 0.8051407152, 0.0779437139, 0.0971023978, 0.7868150176, 0.6514547510 },
  { 0.5714880704, 0.8151365502, 0.9479978580, 0.2208008568, 0.2399595407, 0.9296721604, 0.7943118939 },
  { 0.7143452133, 0.9579936931, 0.0908550009, 0.3636579996, 0.3828166835, 0.0725293033, 0.9371690367 },
  { 0.8572023562, 0.1008508360, 0.2337121437, 0.5065151425, 0.5256738264, 0.2153864461, 0.0800261796 },
  { 0.0204676623, 0.4069732849, 0.6826917356, 0.0983518772, 0.2603677039, 0.0929374665, 0.1004343428 },
  { 0.1633248051, 0.5498304278, 0.8255488784, 0.2412090201, 0.4032248468, 0.2357946094, 0.2432914857 },
  { 0.3061819480, 0.6926875707, 0.9684060213, 0.3840661629, 0.5460819896, 0.3786517522, 0.3861486285 },
  { 0.4490390909, 0.8355447135, 0.1112631642, 0.5269233058, 0.6889391325, 0.5215088951, 0.5290057714 },
  { 0.5918962337, 0.9784018564, 0.2541203070, 0.6697804486, 0.8317962754, 0.6643660380, 0.6718629143 },
  { 0.7347533766, 0.1212589992, 0.3969774499, 0.8126375915, 0.9746534182, 0.8072231808, 0.8147200571 },
  { 0.8776105194, 0.2641161421, 0.5398345927, 0.9554947343, 0.1175105611, 0.9500803237, 0.9575772000 },
  { 0.0408758255, 0.5702385911, 0.9888141846, 0.5473314690, 0.8522044386, 0.8276313441, 0.9779853632 },
  { 0.1837329684, 0.7130957339, 0.1316713274, 0.6901886119, 0.9950615815, 0.9704884869, 0.1208425061 },
  { 0.3265901113, 0.8559528768, 0.2745284703, 0.8330457547, 0.1379187243, 0.1133456298, 0.2636996490 },
  { 0.4694472541, 0.9988100196, 0.4173856131, 0.9759028976, 0.2807758672, 0.2562027727, 0.4065567918 },
  { 0.6123043970, 0.1416671625, 0.5602427560, 0.1187600405, 0.4236330101, 0.3990599155, 0.5494139347 },
  { 0.7551615398, 0.2845243053, 0.7030998989, 0.2616171833, 0.5664901529, 0.5419170584, 0.6922710775 },
  { 0.8980186827, 0.4273814482, 0.8459570417, 0.4044743262, 0.7093472958, 0.6847742012, 0.8351282204 },
  { 0.0612839888, 0.5906467543, 0.1520794907, 0.9963110609, 0.3011840305, 0.5623252216, 0.8555363836 },
  { 0.2041411317, 0.7335038972, 0.2949366335, 0.1391682037, 0.4440411733, 0.7051823645, 0.9983935265 },
  { 0.3469982745, 0.8763610400, 0.4377937764, 0.2820253466, 0.5868983162, 0.8480395073, 0.1412506694 },
  { 0.4898554174, 0.0192181829, 0.5806509193, 0.4248824894, 0.7297554590, 0.9908966502, 0.2841078122 },
  { 0.6327125602, 0.1620753258, 0.7235080621, 0.5677396323, 0.8726126019, 0.1337537931, 0.4269649551 },
  { 0.7755697031, 0.3049324686, 0.8663652050, 0.7105967752, 0.0154697447, 0.2766109359, 0.5698220979 },
  { 0.9184268460, 0.4477896115, 0.0092223478, 0.8534539180, 0.1583268876, 0.4194680788, 0.7126792408 },
  { 0.0816921521, 0.7539120605, 0.4582019397, 0.3024335098, 0.8930207652, 0.1541619563, 0.5902302612 },
  { 0.2245492949, 0.8967692033, 0.6010590825, 0.4452906527, 0.0358779080, 0.2970190992, 0.7330874041 },
  { 0.3674064378, 0.0396263462, 0.7439162254, 0.5881477956, 0.1787350509, 0.4398762420, 0.8759445469 },
  { 0.5102635807, 0.1824834890, 0.8867733682, 0.7310049384, 0.3215921937, 0.5827333849, 0.0188016898 },
  { 0.6531207235, 0.3253406319, 0.0296305111, 0.8738620813, 0.4644493366, 0.7255905278, 0.1616588326 },
  { 0.7959778664, 0.4681977747, 0.1724876540, 0.0167192241, 0.6073064794, 0.8684476706, 0.3045159755 },
  { 0.9388350092, 0.6110549176, 0.3153447968, 0.1595763670, 0.7501636223, 0.0113048135, 0.4473731183 },
  { 0.1021003153, 0.9171773666, 0.7643243886, 0.7514131017, 0.4848574999, 0.8888558339, 0.4677812816 },
  { 0.2449574582, 0.0600345094, 0.9071815315, 0.8942702445, 0.6277146427, 0.0317129767, 0.6106384245 },
  { 0.3878146011, 0.2028916523, 0.0500386744, 0.0371273874, 0.7705717856, 0.1745701196, 0.7534955673 },
  { 0.5306717439, 0.3457487951, 0.1928958172, 0.1799845303, 0.9134289284, 0.3174272625, 0.8963527102 },
  { 0.6735288868, 0.4886059380, 0.3357529601, 0.3228416731, 0.0562860713, 0.4602844053, 0.0392098530 },
  { 0.8163860296, 0.6314630809, 0.4786101029, 0.4656988160, 0.1991432141, 0.6031415482, 0.1820669959 },
  { 0.9592431725, 0.7743202237, 0.6214672458, 0.6085559588, 0.3420003570, 0.7459986910, 0.3249241388 },
  { 0.1225084786, 0.0804426727, 0.0704468376, 0.2003926935, 0.0766942345, 0.6235497114, 0.3453323020 },
  { 0.2653656215, 0.2232998156, 0.2133039805, 0.3432498364, 0.2195513774, 0.7664068543, 0.4881894449 },
  { 0.4082227643, 0.3661569584, 0.3561611233, 0.4861069792, 0.3624085203, 0.9092639971, 0.6310465877 },
  { 0.5510799072, 0.5090141013, 0.4990182662, 0.6289641221, 0.5052656631, 0.0521211400, 0.7739037306 },
  { 0.6939370500, 0.6518712441, 0.6418754091, 0.7718212649, 0.6481228060, 0.1949782829, 0.9167608734 },
  { 0.8367941929, 0.7947283870, 0.7847325519, 0.9146784078, 0.7909799488, 0.3378354257, 0.0596180163 },
  { 0.9796513358, 0.9375855298, 0.9275896948, 0.0575355507, 0.9338370917, 0.4806925686, 0.2024751592 },
  { 0.0029749509, 0.4098887368, 0.8896888201, 0.9175938597, 0.9775688701, 0.9938121021, 0.3074314274 },
  { 0.1458320938, 0.5527458797, 0.0325459630, 0.0604510026, 0.1204260130, 0.1366692450, 0.4502885702 },
  { 0.2886892366, 0.6956030226, 0.1754031058, 0.2033081454, 0.2632831558, 0.2795263878, 0.5931457131 },
  { 0.4315463795, 0.8384601654, 0.3182602487, 0.3461652883, 0.4061402987, 0.4223835307, 0.7360028560 },
  { 0.5744035223, 0.9813173083, 0.4611173916, 0.4890224311, 0.5489974415, 0.5652406735, 0.8788599988 },
  { 0.7172606652, 0.1241744511, 0.6039745344, 0.6318795740, 0.6918545844, 0.7080978164, 0.0217171417 },
  { 0.8601178081, 0.2670315940, 0.7468316773, 0.7747367168, 0.8347117273, 0.8509549592, 0.1645742845 },
  { 0.0233831142, 0.4302969001, 0.1958112691, 0.3665734515, 0.5694056048, 0.5856488368, 0.1849824478 },
  { 0.1662402570, 0.5731540430, 0.3386684120, 0.5094305944, 0.7122627477, 0.7285059797, 0.3278395906 },
  { 0.3090973999, 0.7160111858, 0.4815255548, 0.6522877373, 0.8551198905, 0.8713631225, 0.4706967335 },
  { 0.4519545428, 0.8588683287, 0.6243826977, 0.7951448801, 0.9979770334, 0.0142202654, 0.6135538764 },
  { 0.5948116856, 0.0017254715, 0.7672398405, 0.9380020230, 0.1408341762, 0.1570774082, 0.7564110192 },
  { 0.7376688285, 0.1445826144, 0.9100969834, 0.0808591658, 0.2836913191, 0.2999345511, 0.8992681621 },
  { 0.8805259713, 0.2874397572, 0.0529541263, 0.2237163087, 0.4265484620, 0.4427916939, 0.0421253049 },
  { 0.0437912774, 0.5935622062, 0.5019337181, 0.8155530434, 0.0183851966, 0.3203427143, 0.0625334682 },
  { 0.1866484203, 0.7364193491, 0.6447908610, 0.9584101862, 0.1612423395, 0.4631998572, 0.2053906111 },
  { 0.3295055632, 0.8792764919, 0.7876480038, 0.1012673291, 0.3040994824, 0.6060570001, 0.3482477539 },
  { 0.4723627060, 0.0221336348, 0.9305051467, 0.2441244719, 0.4469566252, 0.7489141429, 0.4911048968 },
  { 0.6152198489, 0.1649907777, 0.0733622895, 0.3869816148, 0.5898137681, 0.8917712858, 0.6339620396 },
  { 0.7580769917, 0.3078479205, 0.2162194324, 0.5298387577, 0.7326709109, 0.0346284286, 0.7768191825 },
  { 0.9009341346, 0.4507050634, 0.3590765752, 0.6726959005, 0.8755280538, 0.1774855715, 0.9196763253 },
  { 0.0641994407, 0.7568275123, 0.8080561671, 0.2645326352, 0.6102219313, 0.0550365919, 0.9400844886 },
  { 0.2070565836, 0.8996846552, 0.9509133099, 0.4073897781, 0.7530790742, 0.1978937348, 0.0829416315 },
  { 0.3499137264, 0.0425417981, 0.0937704528, 0.5502469209, 0.8959362171, 0.3407508776, 0.2257987743 },
  { 0.4927708693, 0.1853989409, 0.2366275956, 0.6931040638, 0.0387933599, 0.4836080205, 0.3686559172 },
  { 0.6356280121, 0.3282560838, 0.3794847385, 0.8359612066, 0.1816505028, 0.6264651633, 0.5115130600 },
  { 0.7784851550, 0.4711132266, 0.5223418814, 0.9788183495, 0.3245076456, 0.7693223062, 0.6543702029 },
  { 0.9213422979, 0.6139703695, 0.6651990242, 0.1216754924, 0.4673647885, 0.9121794490, 0.7972273457 },
  { 0.0846076040, 0.9200928185, 0.1141786161, 0.7135122270, 0.2020586660, 0.7897304694, 0.8176355090 },
  { 0.2274647468, 0.0629499613, 0.2570357589, 0.8563693699, 0.3449158089, 0.9325876123, 0.9604926519 },
  { 0.3703218897, 0.2058071042, 0.3998929018, 0.9992265128, 0.4877729517, 0.0754447552, 0.1033497947 },
  { 0.5131790325, 0.3486642470, 0.5427500446, 0.1420836556, 0.6306300946, 0.2183018980, 0.2462069376 },
  { 0.6560361754, 0.4915213899, 0.6856071875, 0.2849407985, 0.7734872375, 0.3611590409, 0.3890640804 },
  { 0.7988933183, 0.6343785328, 0.8284643303, 0.4277979413, 0.9163443803, 0.5040161837, 0.5319212233 },
  { 0.9417504611, 0.7772356756, 0.9713214732, 0.5706550842, 0.0592015232, 0.6468733266, 0.6747783662 },
  { 0.1050157672, 0.0833581246, 0.4203010650, 0.0196346760, 0.7938954007, 0.5244243470, 0.6951865294 },
  { 0.2478729101, 0.2262152674, 0.5631582079, 0.1624918189, 0.9367525436, 0.6672814899, 0.8380436723 },
  { 0.3907300530, 0.3690724103, 0.7060153507, 0.3053489617, 0.0796096864, 0.8101386327, 0.9809008151 },
  { 0.5335871958, 0.5119295532, 0.8488724936, 0.4482061046, 0.2224668293, 0.9529957756, 0.1237579580 },
  { 0.6764443387, 0.6547866960, 0.9917296365, 0.5910632475, 0.3653239722, 0.0958529184, 0.2666151009 },
  { 0.8193014815, 0.7976438389, 0.1345867793, 0.7339203903, 0.5081811150, 0.2387100613, 0.4094722437 },
  { 0.9621586244, 0.9405009817, 0.2774439222, 0.8767775332, 0.6510382579, 0.3815672041, 0.5523293866 },
  { 0.1254239305, 0.2466234307, 0.5835663712, 0.4686142679, 0.3857321354, 0.2591182245, 0.4298804070 },
  { 0.2682810734, 0.3894805736, 0.7264235140, 0.6114714107, 0.5285892783, 0.4019753674, 0.5727375498 },
  { 0.4111382162, 0.5323377164, 0.8692806569, 0.7543285536, 0.6714464211, 0.5448325103, 0.7155946927 },
  { 0.5539953591, 0.6751948593, 0.0121377997, 0.8971856964, 0.8143035640, 0.6876896531, 0.8584518355 },
  { 0.6968525019, 0.8180520021, 0.1549949426, 0.0400428393, 0.9571607068, 0.8305467960, 0.0013089784 },
  { 0.8397096448, 0.9609091450, 0.2978520854, 0.1828999822, 0.1000178497, 0.9734039388, 0.1441661213 },
  { 0.9825667876, 0.1037662879, 0.4407092283, 0.3257571250, 0.2428749926, 0.1162610817, 0.2870232641 },
  { 0.0058904028, 0.4536205153, 0.5456654965, 0.1654072708, 0.2661986077, 0.4865234724, 0.5552448385 }
};


// Spatial dimension: 16
// N: 100
// Base: 17
// Vectors skipped: 83520
static const double faure_16_100[100][16] =
{
  { 0.9999880270, 0.8056057758, 0.1198740437, 0.6486751835, 0.0390680188, 0.8792878438, 0.8198536895, 0.5009039643, 0.6317812287, 0.8007207768, 0.6547814322, 0.8998455478, 0.1276086254, 0.0370326026, 0.2198129812, 0.3230085847 },
  { 0.0000007043, 0.0739342061, 0.9946008647, 0.7862221336, 0.0647149678, 0.7918135418, 0.2862640393, 0.2779667248, 0.9710738476, 0.9743784057, 0.2536854063, 0.2482376746, 0.8023258680, 0.1164384864, 0.8034393604, 0.9496301388 },
  { 0.0588242337, 0.1327577355, 0.0534243941, 0.8450456630, 0.1235384972, 0.8506370712, 0.3450875687, 0.3367902542, 0.0298973770, 0.0332019351, 0.3125089358, 0.3070612041, 0.8611493974, 0.1752620158, 0.8622628899, 0.0084536682 },
  { 0.1176477631, 0.1915812649, 0.1122479236, 0.9038691925, 0.1823620266, 0.9094606006, 0.4039110981, 0.3956137836, 0.0887209064, 0.0920254645, 0.3713324652, 0.3658847335, 0.9199729269, 0.2340855452, 0.9210864193, 0.0672771976 },
  { 0.1764712925, 0.2504047943, 0.1710714530, 0.9626927219, 0.2411855560, 0.9682841300, 0.4627346275, 0.4544373131, 0.1475444358, 0.1508489939, 0.4301559946, 0.4247082629, 0.9787964563, 0.2929090746, 0.9799099487, 0.1261007270 },
  { 0.2352948219, 0.3092283237, 0.2298949824, 0.0215162513, 0.3000090854, 0.0271076594, 0.5215581569, 0.5132608425, 0.2063679652, 0.2096725234, 0.4889795240, 0.4835317923, 0.0376199857, 0.3517326041, 0.0387334781, 0.1849242565 },
  { 0.2941183514, 0.3680518531, 0.2887185118, 0.0803397807, 0.3588326148, 0.0859311888, 0.5803816863, 0.5720843719, 0.2651914946, 0.2684960528, 0.5478030534, 0.5423553217, 0.0964435151, 0.4105561335, 0.0975570075, 0.2437477859 },
  { 0.3529418808, 0.4268753825, 0.3475420412, 0.1391633101, 0.4176561442, 0.1447547183, 0.6392052157, 0.6309079013, 0.3240150240, 0.3273195822, 0.6066265828, 0.6011788511, 0.1552670445, 0.4693796629, 0.1563805369, 0.3025713153 },
  { 0.4117654102, 0.4856989119, 0.4063655706, 0.1979868395, 0.4764796737, 0.2035782477, 0.6980287451, 0.6897314307, 0.3828385535, 0.3861431116, 0.6654501122, 0.6600023805, 0.2140905739, 0.5282031923, 0.2152040663, 0.3613948447 },
  { 0.4705889396, 0.5445224413, 0.4651891000, 0.2568103689, 0.5353032031, 0.2624017771, 0.7568522746, 0.7485549601, 0.4416620829, 0.4449666410, 0.7242736416, 0.7188259099, 0.2729141033, 0.5870267217, 0.2740275957, 0.4202183741 },
  { 0.5294124690, 0.6033459708, 0.5240126294, 0.3156338983, 0.5941267325, 0.3212253065, 0.8156758040, 0.8073784895, 0.5004856123, 0.5037901704, 0.7830971711, 0.7776494393, 0.3317376327, 0.6458502511, 0.3328511251, 0.4790419035 },
  { 0.5882359984, 0.6621695002, 0.5828361589, 0.3744574278, 0.6529502619, 0.3800488359, 0.8744993334, 0.8662020189, 0.5593091417, 0.5626136998, 0.8419207005, 0.8364729688, 0.3905611621, 0.7046737805, 0.3916746546, 0.5378654329 },
  { 0.6470595278, 0.7209930296, 0.6416596883, 0.4332809572, 0.7117737913, 0.4388723653, 0.9333228628, 0.9250255483, 0.6181326711, 0.6214372292, 0.9007442299, 0.8952964982, 0.4493846916, 0.7634973099, 0.4504981840, 0.5966889623 },
  { 0.7058830572, 0.7798165590, 0.7004832177, 0.4921044866, 0.7705973207, 0.4976958947, 0.9921463922, 0.9838490778, 0.6769562005, 0.6802607587, 0.9595677593, 0.9541200276, 0.5082082210, 0.8223208394, 0.5093217134, 0.6555124918 },
  { 0.7647065866, 0.8386400884, 0.7593067471, 0.5509280160, 0.8294208501, 0.5565194241, 0.0509699216, 0.0426726072, 0.7357797299, 0.7390842881, 0.0183912887, 0.0129435570, 0.5670317504, 0.8811443688, 0.5681452428, 0.7143360212 },
  { 0.8235301161, 0.8974636178, 0.8181302765, 0.6097515454, 0.8882443795, 0.6153429536, 0.1097934510, 0.1014961366, 0.7946032593, 0.7979078175, 0.0772148181, 0.0717670864, 0.6258552798, 0.9399678982, 0.6269687722, 0.7731595506 },
  { 0.8823536455, 0.9562871472, 0.8769538059, 0.6685750748, 0.9470679090, 0.6741664830, 0.1686169804, 0.1603196660, 0.8534267888, 0.8567313469, 0.1360383475, 0.1305906158, 0.6846788092, 0.9987914276, 0.6857923016, 0.8319830800 },
  { 0.9411771749, 0.0151106766, 0.9357773353, 0.7273986042, 0.0058914384, 0.7329900124, 0.2274405099, 0.2191431954, 0.9122503182, 0.9155548763, 0.1948618769, 0.1894141452, 0.7435023386, 0.0576149570, 0.7446158310, 0.8908066094 },
  { 0.0034609119, 0.1362179431, 0.1157081312, 0.9661529295, 0.3034692930, 0.0893913965, 0.6426654233, 0.6931916383, 0.4451222905, 0.5072503780, 0.8453809081, 0.8987567058, 0.5116684286, 0.8257810470, 0.6304289798, 0.8354432876 },
  { 0.0622844413, 0.1950414725, 0.1745316606, 0.0249764589, 0.3622928224, 0.1482149259, 0.7014889528, 0.7520151677, 0.5039458199, 0.5660739074, 0.9042044375, 0.9575802352, 0.5704919580, 0.8846045764, 0.6892525092, 0.8942668170 },
  { 0.1211079707, 0.2538650019, 0.2333551900, 0.0837999883, 0.4211163519, 0.2070384553, 0.7603124822, 0.8108386971, 0.5627693493, 0.6248974369, 0.9630279669, 0.0164037646, 0.6293154874, 0.9434281058, 0.7480760386, 0.9530903464 },
  { 0.1799315001, 0.3126885313, 0.2921787194, 0.1426235177, 0.4799398813, 0.2658619847, 0.8191360116, 0.8696622265, 0.6215928787, 0.6837209663, 0.0218514963, 0.0752272940, 0.6881390168, 0.0022516352, 0.8068995681, 0.0119138758 },
  { 0.2387550296, 0.3715120607, 0.3510022488, 0.2014470471, 0.5387634107, 0.3246855141, 0.8779595410, 0.9284857560, 0.6804164081, 0.7425444957, 0.0806750257, 0.1340508234, 0.7469625462, 0.0610751646, 0.8657230975, 0.0707374052 },
  { 0.2975785590, 0.4303355901, 0.4098257782, 0.2602705765, 0.5975869401, 0.3835090435, 0.9367830704, 0.9873092854, 0.7392399375, 0.8013680251, 0.1394985551, 0.1928743528, 0.8057860756, 0.1198986940, 0.9245466269, 0.1295609347 },
  { 0.3564020884, 0.4891591195, 0.4686493076, 0.3190941060, 0.6564104695, 0.4423325729, 0.9956065998, 0.0461328148, 0.7980634670, 0.8601915545, 0.1983220845, 0.2516978823, 0.8646096051, 0.1787222234, 0.9833701563, 0.1883844641 },
  { 0.4152256178, 0.5479826490, 0.5274728371, 0.3779176354, 0.7152339989, 0.5011561023, 0.0544301292, 0.1049563442, 0.8568869964, 0.9190150839, 0.2571456140, 0.3105214117, 0.9234331345, 0.2375457528, 0.0421936857, 0.2472079935 },
  { 0.4740491472, 0.6068061784, 0.5862963665, 0.4367411648, 0.7740575283, 0.5599796318, 0.1132536586, 0.1637798736, 0.9157105258, 0.9778386133, 0.3159691434, 0.3693449411, 0.9822566639, 0.2963692823, 0.1010172151, 0.3060315229 },
  { 0.5328726766, 0.6656297078, 0.6451198959, 0.4955646942, 0.8328810577, 0.6188031612, 0.1720771881, 0.2226034030, 0.9745340552, 0.0366621427, 0.3747926728, 0.4281684705, 0.0410801933, 0.3551928117, 0.1598407445, 0.3648550523 },
  { 0.5916962060, 0.7244532372, 0.7039434253, 0.5543882236, 0.8917045872, 0.6776266906, 0.2309007175, 0.2814269324, 0.0333575846, 0.0954856721, 0.4336162022, 0.4869919999, 0.0999037227, 0.4140163411, 0.2186642739, 0.4236785817 },
  { 0.6505197354, 0.7832767666, 0.7627669547, 0.6132117530, 0.9505281166, 0.7364502200, 0.2897242469, 0.3402504618, 0.0921811140, 0.1543092016, 0.4924397316, 0.5458155293, 0.1587272521, 0.4728398705, 0.2774878033, 0.4825021111 },
  { 0.7093432648, 0.8421002960, 0.8215904841, 0.6720352824, 0.0093516460, 0.7952737494, 0.3485477763, 0.3990739913, 0.1510046434, 0.2131327310, 0.5512632610, 0.6046390587, 0.2175507815, 0.5316633999, 0.3363113328, 0.5413256405 },
  { 0.7681667943, 0.9009238254, 0.8804140135, 0.7308588118, 0.0681751754, 0.8540972788, 0.4073713057, 0.4578975207, 0.2098281728, 0.2719562604, 0.6100867904, 0.6634625881, 0.2763743109, 0.5904869293, 0.3951348622, 0.6001491700 },
  { 0.8269903237, 0.9597473548, 0.9392375429, 0.7896823412, 0.1269987048, 0.9129208082, 0.4661948351, 0.5167210501, 0.2686517022, 0.3307797898, 0.6689103198, 0.7222861175, 0.3351978403, 0.6493104587, 0.4539583916, 0.6589726994 },
  { 0.8858138531, 0.0185708843, 0.9980610723, 0.8485058707, 0.1858222342, 0.9717443376, 0.5250183645, 0.5755445795, 0.3274752317, 0.3896033192, 0.7277338493, 0.7811096470, 0.3940213698, 0.7081339881, 0.5127819210, 0.7177962288 },
  { 0.9446373825, 0.0773944137, 0.0568846018, 0.9073294001, 0.2446457636, 0.0305678670, 0.5838418939, 0.6343681089, 0.3862987611, 0.4484268486, 0.7865573787, 0.8399331764, 0.4528448992, 0.7669575176, 0.5716054504, 0.7766197582 },
  { 0.0069211195, 0.1985016801, 0.1779918682, 0.1460837253, 0.5422236183, 0.3869692511, 0.9990668074, 0.1084165518, 0.9191707334, 0.0401223503, 0.4370764098, 0.5492757369, 0.2210109891, 0.5939471369, 0.4574185992, 0.7212564364 },
  { 0.0657446489, 0.2573252095, 0.2368153976, 0.2049072547, 0.6010471477, 0.4457927805, 0.0578903368, 0.1672400812, 0.9779942628, 0.0989458798, 0.4958999392, 0.6080992663, 0.2798345185, 0.6527706663, 0.5162421286, 0.7800799658 },
  { 0.1245681783, 0.3161487389, 0.2956389270, 0.2637307842, 0.6598706771, 0.5046163100, 0.1167138663, 0.2260636106, 0.0368177922, 0.1577694092, 0.5547234686, 0.6669227957, 0.3386580480, 0.7115941958, 0.5750656580, 0.8389034952 },
  { 0.1833917078, 0.3749722683, 0.3544624564, 0.3225543136, 0.7186942065, 0.5634398394, 0.1755373957, 0.2848871400, 0.0956413216, 0.2165929386, 0.6135469980, 0.7257463252, 0.3974815774, 0.7704177252, 0.6338891874, 0.8977270246 },
  { 0.2422152372, 0.4337957977, 0.4132859858, 0.3813778430, 0.7775177359, 0.6222633688, 0.2343609251, 0.3437106695, 0.1544648510, 0.2754164680, 0.6723705275, 0.7845698546, 0.4563051068, 0.8292412546, 0.6927127168, 0.9565505540 },
  { 0.3010387666, 0.4926193272, 0.4721095153, 0.4402013724, 0.8363412654, 0.6810868982, 0.2931844545, 0.4025341989, 0.2132883804, 0.3342399974, 0.7311940569, 0.8433933840, 0.5151286362, 0.8880647840, 0.7515362463, 0.0153740834 },
  { 0.3598622960, 0.5514428566, 0.5309330447, 0.4990249018, 0.8951647948, 0.7399104276, 0.3520079839, 0.4613577283, 0.2721119099, 0.3930635268, 0.7900175863, 0.9022169134, 0.5739521656, 0.9468883134, 0.8103597757, 0.0741976129 },
  { 0.4186858254, 0.6102663860, 0.5897565741, 0.5578484312, 0.9539883242, 0.7987339570, 0.4108315133, 0.5201812577, 0.3309354393, 0.4518870562, 0.8488411157, 0.9610404428, 0.6327756950, 0.0057118428, 0.8691833051, 0.1330211423 },
  { 0.4775093548, 0.6690899154, 0.6485801035, 0.6166719606, 0.0128118536, 0.8575574864, 0.4696550427, 0.5790047871, 0.3897589687, 0.5107105856, 0.9076646451, 0.0198639722, 0.6915992244, 0.0645353722, 0.9280068345, 0.1918446717 },
  { 0.5363328842, 0.7279134448, 0.7074036329, 0.6754954900, 0.0716353830, 0.9163810158, 0.5284785721, 0.6378283165, 0.4485824981, 0.5695341151, 0.9664881745, 0.0786875016, 0.7504227538, 0.1233589016, 0.9868303639, 0.2506682011 },
  { 0.5951564136, 0.7867369742, 0.7662271623, 0.7343190195, 0.1304589124, 0.9752045452, 0.5873021015, 0.6966518459, 0.5074060275, 0.6283576445, 0.0253117039, 0.1375110310, 0.8092462833, 0.1821824310, 0.0456538933, 0.3094917305 },
  { 0.6539799431, 0.8455605036, 0.8250506917, 0.7931425489, 0.1892824418, 0.0340280747, 0.6461256310, 0.7554753753, 0.5662295569, 0.6871811739, 0.0841352333, 0.1963345605, 0.8680698127, 0.2410059605, 0.1044774227, 0.3683152599 },
  { 0.7128034725, 0.9043840330, 0.8838742211, 0.8519660783, 0.2481059712, 0.0928516041, 0.7049491604, 0.8142989047, 0.6250530863, 0.7460047033, 0.1429587627, 0.2551580899, 0.9268933421, 0.2998294899, 0.1633009521, 0.4271387893 },
  { 0.7716270019, 0.9632075625, 0.9426977505, 0.9107896077, 0.3069295006, 0.1516751335, 0.7637726898, 0.8731224342, 0.6838766157, 0.8048282327, 0.2017822922, 0.3139816193, 0.9857168715, 0.3586530193, 0.2221244815, 0.4859623187 },
  { 0.8304505313, 0.0220310919, 0.0015212800, 0.9696131371, 0.3657530301, 0.2104986629, 0.8225962192, 0.9319459636, 0.7427001452, 0.8636517621, 0.2606058216, 0.3728051487, 0.0445404009, 0.4174765487, 0.2809480110, 0.5447858482 },
  { 0.8892740607, 0.0808546213, 0.0603448094, 0.0284366665, 0.4245765595, 0.2693221923, 0.8814197486, 0.9907694930, 0.8015236746, 0.9224752915, 0.3194293510, 0.4316286781, 0.1033639303, 0.4763000781, 0.3397715404, 0.6036093776 },
  { 0.9480975901, 0.1396781507, 0.1191683388, 0.0872601959, 0.4834000889, 0.3281457217, 0.9402432780, 0.0495930224, 0.8603472040, 0.9812988209, 0.3782528804, 0.4904522075, 0.1621874597, 0.5351236075, 0.3985950698, 0.6624329070 },
  { 0.0103813271, 0.2607854171, 0.2990991346, 0.3260145212, 0.7809779436, 0.6845471058, 0.2966446621, 0.5236414653, 0.3932191763, 0.5729943227, 0.0287719115, 0.1997947681, 0.9303535497, 0.3621132269, 0.2844082186, 0.6070695852 },
  { 0.0692048565, 0.3196089465, 0.3579226640, 0.3848380506, 0.8398014730, 0.7433706352, 0.3554681915, 0.5824649947, 0.4520427057, 0.6318178521, 0.0875954409, 0.2586182975, 0.9891770791, 0.4209367563, 0.3432317480, 0.6658931146 },
  { 0.1280283860, 0.3784324759, 0.4167461935, 0.4436615800, 0.8986250024, 0.8021941646, 0.4142917209, 0.6412885241, 0.5108662351, 0.6906413815, 0.1464189704, 0.3174418269, 0.0480006085, 0.4797602857, 0.4020552774, 0.7247166440 },
  { 0.1868519154, 0.4372560054, 0.4755697229, 0.5024851094, 0.9574485318, 0.8610176940, 0.4731152503, 0.7001120535, 0.5696897645, 0.7494649109, 0.2052424998, 0.3762653563, 0.1068241379, 0.5385838151, 0.4608788068, 0.7835401734 },
  { 0.2456754448, 0.4960795348, 0.5343932523, 0.5613086388, 0.0162720612, 0.9198412234, 0.5319387798, 0.7589355829, 0.6285132939, 0.8082884403, 0.2640660292, 0.4350888857, 0.1656476673, 0.5974073445, 0.5197023362, 0.8423637028 },
  { 0.3044989742, 0.5549030642, 0.5932167817, 0.6201321682, 0.0750955906, 0.9786647529, 0.5907623092, 0.8177591124, 0.6873368234, 0.8671119697, 0.3228895586, 0.4939124151, 0.2244711967, 0.6562308740, 0.5785258656, 0.9011872322 },
  { 0.3633225036, 0.6137265936, 0.6520403111, 0.6789556977, 0.1339191200, 0.0374882823, 0.6495858386, 0.8765826418, 0.7461603528, 0.9259354991, 0.3817130880, 0.5527359445, 0.2832947262, 0.7150544034, 0.6373493950, 0.9600107616 },
  { 0.4221460330, 0.6725501230, 0.7108638405, 0.7377792271, 0.1927426494, 0.0963118117, 0.7084093680, 0.9354061712, 0.8049838822, 0.9847590286, 0.4405366174, 0.6115594739, 0.3421182556, 0.7738779328, 0.6961729245, 0.0188342911 },
  { 0.4809695624, 0.7313736524, 0.7696873699, 0.7966027565, 0.2515661788, 0.1551353411, 0.7672328974, 0.9942297006, 0.8638074116, 0.0435825580, 0.4993601468, 0.6703830034, 0.4009417850, 0.8327014622, 0.7549964539, 0.0776578205 },
  { 0.5397930918, 0.7901971818, 0.8285108993, 0.8554262859, 0.3103897083, 0.2139588705, 0.8260564268, 0.0530532300, 0.9226309410, 0.1024060874, 0.5581836762, 0.7292065328, 0.4597653144, 0.8915249916, 0.8138199833, 0.1364813499 },
  { 0.5986166213, 0.8490207112, 0.8873344287, 0.9142498153, 0.3692132377, 0.2727823999, 0.8848799562, 0.1118767594, 0.9814544704, 0.1612296168, 0.6170072057, 0.7880300622, 0.5185888438, 0.9503485210, 0.8726435127, 0.1953048793 },
  { 0.6574401507, 0.9078442407, 0.9461579582, 0.9730733447, 0.4280367671, 0.3316059293, 0.9437034856, 0.1707002888, 0.0402779998, 0.2200531462, 0.6758307351, 0.8468535916, 0.5774123732, 0.0091720504, 0.9314670421, 0.2541284087 },
  { 0.7162636801, 0.9666677701, 0.0049814876, 0.0318968741, 0.4868602965, 0.3904294587, 0.0025270150, 0.2295238182, 0.0991015292, 0.2788766756, 0.7346542645, 0.9056771210, 0.6362359026, 0.0679955798, 0.9902905715, 0.3129519381 },
  { 0.7750872095, 0.0254912995, 0.0638050170, 0.0907204035, 0.5456838259, 0.4492529882, 0.0613505445, 0.2883473477, 0.1579250587, 0.3377002050, 0.7934777939, 0.9645006504, 0.6950594320, 0.1268191092, 0.0491141009, 0.3717754675 },
  { 0.8339107389, 0.0843148289, 0.1226285464, 0.1495439329, 0.6045073553, 0.5080765176, 0.1201740739, 0.3471708771, 0.2167485881, 0.3965237344, 0.8523013233, 0.0233241798, 0.7538829615, 0.1856426387, 0.1079376303, 0.4305989969 },
  { 0.8927342683, 0.1431383583, 0.1814520758, 0.2083674624, 0.6633308847, 0.5669000470, 0.1789976033, 0.4059944065, 0.2755721175, 0.4553472638, 0.9111248527, 0.0821477092, 0.8127064909, 0.2444661681, 0.1667611598, 0.4894225264 },
  { 0.9515577977, 0.2019618877, 0.2402756052, 0.2671909918, 0.7221544141, 0.6257235764, 0.2378211327, 0.4648179359, 0.3343956469, 0.5141707933, 0.9699483821, 0.1409712387, 0.8715300203, 0.3032896975, 0.2255846892, 0.5482460558 },
  { 0.0138415347, 0.3230691541, 0.4202064011, 0.5059453170, 0.0197322688, 0.9821249605, 0.6530460462, 0.9388663788, 0.8672676192, 0.1058662950, 0.6204674133, 0.8503137992, 0.6396961102, 0.1302793169, 0.1113978380, 0.4928827340 },
  { 0.0726650642, 0.3818926836, 0.4790299305, 0.5647688464, 0.0785557982, 0.0409484899, 0.7118695756, 0.9976899082, 0.9260911486, 0.1646898244, 0.6792909427, 0.9091373286, 0.6985196397, 0.1891028463, 0.1702213674, 0.5517062634 },
  { 0.1314885936, 0.4407162130, 0.5378534599, 0.6235923759, 0.1373793276, 0.0997720193, 0.7706931050, 0.0565134376, 0.9849146780, 0.2235133538, 0.7381144721, 0.9679608580, 0.7573431691, 0.2479263757, 0.2290448968, 0.6105297928 },
  { 0.1903121230, 0.4995397424, 0.5966769893, 0.6824159053, 0.1962028570, 0.1585955487, 0.8295166344, 0.1153369670, 0.0437382074, 0.2823368832, 0.7969380015, 0.0267843874, 0.8161666985, 0.3067499051, 0.2878684262, 0.6693533222 },
  { 0.2491356524, 0.5583632718, 0.6555005187, 0.7412394347, 0.2550263865, 0.2174190781, 0.8883401638, 0.1741604964, 0.1025617369, 0.3411604126, 0.8557615309, 0.0856079169, 0.8749902279, 0.3655734345, 0.3466919556, 0.7281768516 },
  { 0.3079591818, 0.6171868012, 0.7143240481, 0.8000629641, 0.3138499159, 0.2762426075, 0.9471636932, 0.2329840259, 0.1613852663, 0.3999839420, 0.9145850603, 0.1444314463, 0.9338137573, 0.4243969639, 0.4055154850, 0.7870003810 },
  { 0.3667827112, 0.6760103306, 0.7731475775, 0.8588864935, 0.3726734453, 0.3350661369, 0.0059872227, 0.2918075553, 0.2202087957, 0.4588074715, 0.9734085897, 0.2032549757, 0.9926372867, 0.4832204933, 0.4643390144, 0.8458239104 },
  { 0.4256062406, 0.7348338600, 0.8319711069, 0.9177100229, 0.4314969747, 0.3938896664, 0.0648107521, 0.3506310847, 0.2790323251, 0.5176310009, 0.0322321192, 0.2620785051, 0.0514608161, 0.5420440227, 0.5231625438, 0.9046474398 },
  { 0.4844297700, 0.7936573894, 0.8907946364, 0.9765335523, 0.4903205041, 0.4527131958, 0.1236342815, 0.4094546141, 0.3378558545, 0.5764545303, 0.0910556486, 0.3209020345, 0.1102843455, 0.6008675522, 0.5819860732, 0.9634709693 },
  { 0.5432532995, 0.8524809189, 0.9496181658, 0.0353570817, 0.5491440335, 0.5115367252, 0.1824578109, 0.4682781435, 0.3966793839, 0.6352780597, 0.1498791780, 0.3797255639, 0.1691078749, 0.6596910816, 0.6408096027, 0.0222944987 },
  { 0.6020768289, 0.9113044483, 0.0084416952, 0.0941806111, 0.6079675629, 0.5703602546, 0.2412813403, 0.5271016729, 0.4555029133, 0.6941015891, 0.2087027074, 0.4385490933, 0.2279314044, 0.7185146110, 0.6996331321, 0.0811180281 },
  { 0.6609003583, 0.9701279777, 0.0672652246, 0.1530041406, 0.6667910923, 0.6291837840, 0.3001048697, 0.5859252023, 0.5143264427, 0.7529251185, 0.2675262368, 0.4973726227, 0.2867549338, 0.7773381404, 0.7584566615, 0.1399415575 },
  { 0.7197238877, 0.0289515071, 0.1260887540, 0.2118276700, 0.7256146218, 0.6880073134, 0.3589283991, 0.6447487317, 0.5731499721, 0.8117486479, 0.3263497662, 0.5561961521, 0.3455784632, 0.8361616698, 0.8172801909, 0.1987650869 },
  { 0.7785474171, 0.0877750365, 0.1849122834, 0.2706511994, 0.7844381512, 0.7468308428, 0.4177519285, 0.7035722612, 0.6319735016, 0.8705721773, 0.3851732956, 0.6150196816, 0.4044019926, 0.8949851992, 0.8761037203, 0.2575886163 },
  { 0.8373709465, 0.1465985659, 0.2437358128, 0.3294747288, 0.8432616806, 0.8056543722, 0.4765754580, 0.7623957906, 0.6907970310, 0.9293957068, 0.4439968250, 0.6738432110, 0.4632255220, 0.9538087286, 0.9349272497, 0.3164121457 },
  { 0.8961944759, 0.2054220953, 0.3025593422, 0.3882982582, 0.9020852100, 0.8644779016, 0.5353989874, 0.8212193200, 0.7496205604, 0.9882192362, 0.5028203544, 0.7326667404, 0.5220490514, 0.0126322580, 0.9937507791, 0.3752356751 },
  { 0.9550180053, 0.2642456247, 0.3613828717, 0.4471217876, 0.9609087394, 0.9233014311, 0.5942225168, 0.8800428494, 0.8084440898, 0.0470427656, 0.5616438839, 0.7914902698, 0.5808725808, 0.0714557874, 0.0525743085, 0.4340592046 },
  { 0.0173017424, 0.3853528912, 0.5413136675, 0.6858761129, 0.2584865941, 0.2797028151, 0.0094474303, 0.2952677629, 0.3413160621, 0.6387382673, 0.2121629150, 0.5008328303, 0.3490386708, 0.8984454068, 0.9383874573, 0.3786958828 },
  { 0.0761252718, 0.4441764206, 0.6001371969, 0.7446996423, 0.3173101235, 0.3385263446, 0.0682709597, 0.3540912923, 0.4001395915, 0.6975617967, 0.2709864444, 0.5596563598, 0.4078622002, 0.9572689362, 0.9972109867, 0.4375194122 },
  { 0.1349488012, 0.5029999500, 0.6589607263, 0.8035231717, 0.3761336529, 0.3973498740, 0.1270944891, 0.4129148217, 0.4589631209, 0.7563853261, 0.3298099738, 0.6184798892, 0.4666857296, 0.0160924656, 0.0560345162, 0.4963429416 },
  { 0.1937723306, 0.5618234794, 0.7177842557, 0.8623467011, 0.4349571823, 0.4561734034, 0.1859180185, 0.4717383511, 0.5177866503, 0.8152088555, 0.3886335032, 0.6773034186, 0.5255092590, 0.0749159951, 0.1148580456, 0.5551664710 },
  { 0.2525958600, 0.6206470088, 0.7766077852, 0.9211702305, 0.4937807117, 0.5149969328, 0.2447415479, 0.5305618805, 0.5766101798, 0.8740323850, 0.4474570326, 0.7361269480, 0.5843327884, 0.1337395245, 0.1736815750, 0.6139900004 },
  { 0.3114193894, 0.6794705382, 0.8354313146, 0.9799937599, 0.5526042411, 0.5738204622, 0.3035650773, 0.5893854099, 0.6354337092, 0.9328559144, 0.5062805621, 0.7949504774, 0.6431563179, 0.1925630539, 0.2325051044, 0.6728135298 },
  { 0.3702429188, 0.7382940676, 0.8942548440, 0.0388172893, 0.6114277705, 0.6326439916, 0.3623886067, 0.6482089394, 0.6942572386, 0.9916794438, 0.5651040915, 0.8537740068, 0.7019798473, 0.2513865833, 0.2913286338, 0.7316370592 },
  { 0.4290664482, 0.7971175971, 0.9530783734, 0.0976408188, 0.6702513000, 0.6914675210, 0.4212121362, 0.7070324688, 0.7530807680, 0.0505029732, 0.6239276209, 0.9125975362, 0.7608033767, 0.3102101127, 0.3501521632, 0.7904605886 },
  { 0.4878899777, 0.8559411265, 0.0119019028, 0.1564643482, 0.7290748294, 0.7502910504, 0.4800356656, 0.7658559982, 0.8119042974, 0.1093265026, 0.6827511503, 0.9714210656, 0.8196269061, 0.3690336421, 0.4089756926, 0.8492841180 },
  { 0.5467135071, 0.9147646559, 0.0707254322, 0.2152878776, 0.7878983588, 0.8091145798, 0.5388591950, 0.8246795276, 0.8707278268, 0.1681500320, 0.7415746797, 0.0302445951, 0.8784504355, 0.4278571715, 0.4677992220, 0.9081076475 },
  { 0.6055370365, 0.9735881853, 0.1295489616, 0.2741114070, 0.8467218882, 0.8679381093, 0.5976827244, 0.8835030570, 0.9295513562, 0.2269735614, 0.8003982091, 0.0890681245, 0.9372739649, 0.4866807009, 0.5266227514, 0.9669311769 },
  { 0.6643605659, 0.0324117147, 0.1883724910, 0.3329349364, 0.9055454176, 0.9267616387, 0.6565062538, 0.9423265864, 0.9883748856, 0.2857970908, 0.8592217385, 0.1478916539, 0.9960974943, 0.5455042304, 0.5854462809, 0.0257547063 },
  { 0.7231840953, 0.0912352441, 0.2471960204, 0.3917584658, 0.9643689470, 0.9855851681, 0.7153297832, 0.0011501158, 0.0471984151, 0.3446206202, 0.9180452679, 0.2067151833, 0.0549210237, 0.6043277598, 0.6442698103, 0.0845782357 },
  { 0.7820076247, 0.1500587735, 0.3060195499, 0.4505819952, 0.0231924764, 0.0444086975, 0.7741533126, 0.0599736452, 0.1060219445, 0.4034441497, 0.9768687974, 0.2655387127, 0.1137445531, 0.6631512892, 0.7030933397, 0.1434017651 }
};


QRNG_VALIDATION_TEST_FUNCTIONS(faure)


BOOST_AUTO_TEST_CASE( validate_faure )
{
  test_faure_values(faure_02_100, 15);
  test_faure_values(faure_07_100, 2400);
  test_faure_values(faure_16_100, 83520);
}

BOOST_AUTO_TEST_CASE( validate_faure_seed )
{
  test_faure_seed(faure_02_100, 15);
  test_faure_seed(faure_07_100, 2400);
  test_faure_seed(faure_16_100, 83520);
}

BOOST_AUTO_TEST_CASE( validate_faure_discard )
{
  test_faure_discard(faure_02_100, 15);
  test_faure_discard(faure_07_100, 2400);
  test_faure_discard(faure_16_100, 83520);
}
