/*
** This file is part of the Matrix Brandy Basic VI Interpreter.
** Copyright (C) 2018-2021 Michael McConnell and contributors
**
** Brandy is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2, or (at your option)
** any later version.
**
** Brandy is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with Brandy; see the file COPYING.  If not, write to
** the Free Software Foundation, 59 Temple Place - Suite 330,
** Boston, MA 02111-1307, USA.
**
** This file defines the text mode fonts used by Matrix Brandy.
*/

#ifndef _GRAPHSDL_TEXTFONTS_H
#define _GRAPHSDL_TEXTFONTS_H

/*
** Built-in ISO Latin-1 font for all modes other than Teletext.
** The first character in the table is a blank.
*/
#ifndef BRANDY_MODE7ONLY
static byte sysfont[224][8];
static byte sysfontbase [224][8] = {
/*   */  {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* ! */  {0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0u, 0x18u, 0u},
/* " */  {0x6cu, 0x6cu, 0x6cu, 0u, 0u, 0u, 0u, 0u},
/* # */  {0x36u, 0x36u, 0x7fu, 0x36u, 0x7fu, 0x36u, 0x36u, 0u},
/* $ */  {0x0cu, 0x3fu, 0x68u, 0x3eu, 0x0bu, 0x7eu, 0x18u, 0u},
/* % */  {0x60u, 0x66u, 0x0cu, 0x18u, 0x30u, 0x66u, 0x06u, 0u},
/* & */  {0x38u, 0x6cu, 0x6cu, 0x38u, 0x6du, 0x66u, 0x3bu, 0u},
/* ' */  {0x0cu, 0x18u, 0x30u, 0u, 0u, 0u, 0u, 0u},
/* ( */  {0x0cu, 0x18u, 0x30u, 0x30u, 0x30u, 0x18u, 0x0cu, 0u},
/* ) */  {0x30u, 0x18u, 0x0cu, 0x0cu, 0x0cu, 0x18u, 0x30u, 0u},
/* * */  {0u, 0x18u, 0x7eu, 0x3cu, 0x7eu, 0x18u, 0u, 0u},
/* + */  {0u, 0x18u, 0x18u, 0x7eu, 0x18u, 0x18u, 0u, 0u},
/* , */  {0u, 0u, 0u, 0u, 0u, 0x18u, 0x18u, 0x30u},
/* - */  {0u, 0u, 0u, 0x7eu, 0u, 0u, 0u, 0u},
/* . */  {0u, 0u, 0u, 0u, 0u, 0x18u, 0x18u, 0u},
/* / */  {0u, 0x6u, 0x0cu, 0x18u, 0x30u, 0x60u, 0u, 0u},
/* 0 */  {0x3cu, 0x66u, 0x6eu, 0x7eu, 0x76u, 0x66u, 0x3cu, 0u},
/* 1 */  {0x18u, 0x38u, 0x18u, 0x18u, 0x18u, 0x18u, 0x7eu, 0u},
/* 2 */  {0x3cu, 0x66u, 0x06u, 0x0cu, 0x18u, 0x30u, 0x7eu, 0u},
/* 3 */  {0x3cu, 0x66u, 0x06u, 0x1cu, 0x06u, 0x66u, 0x3cu, 0u},
/* 4 */  {0x0cu, 0x1cu, 0x3cu, 0x6cu, 0x7eu, 0x0cu, 0x0cu, 0u},
/* 5 */  {0x7eu, 0x60u, 0x7cu, 0x6u, 0x6u, 0x66u, 0x3cu, 0u},
/* 6 */  {0x1cu, 0x30u, 0x60u, 0x7cu, 0x66u, 0x66u, 0x3cu, 0u},
/* 7 */  {0x7eu, 0x6u, 0x0cu, 0x18u, 0x30u, 0x30u, 0x30u, 0u},
/* 8 */  {0x3cu, 0x66u, 0x66u, 0x3cu, 0x66u, 0x66u, 0x3cu, 0u},
/* 9 */  {0x3cu, 0x66u, 0x66u, 0x3eu, 0x6u, 0x0cu, 0x38u, 0u},
/* : */  {0u, 0u, 0x18u, 0x18u, 0u, 0x18u, 0x18u, 0u},
/* ; */  {0u, 0u, 0x18u, 0x18u, 0u, 0x18u, 0x18u, 0x30u},
/* < */  {0xcu, 0x18u, 0x30u, 0x60u, 0x30u, 0x18u, 0xcu, 0u},
/* = */  {0u, 0u, 0x7eu, 0u, 0x7eu, 0u, 0u, 0u},
/* > */  {0x30u, 0x18u, 0xcu, 0x6u, 0xcu, 0x18u, 0x30u, 0u},
/* ? */  {0x3cu, 0x66u, 0xcu, 0x18u, 0x18u, 0u, 0x18u, 0u},
/* @ */  {0x3cu, 0x66u, 0x6eu, 0x6au, 0x6eu, 0x60u, 0x3cu, 0u},
/* A */  {0x3cu, 0x66u, 0x66u, 0x7eu, 0x66u, 0x66u, 0x66u, 0u},
/* B */  {0x7cu, 0x66u, 0x66u, 0x7cu, 0x66u, 0x66u, 0x7cu, 0u},
/* C */  {0x3cu, 0x66u, 0x60u, 0x60u, 0x60u, 0x66u, 0x3cu, 0u},
/* D */  {0x78u, 0x6cu, 0x66u, 0x66u, 0x66u, 0x6cu, 0x78u, 0u},
/* E */  {0x7eu, 0x60u, 0x60u, 0x7cu, 0x60u, 0x60u, 0x7eu, 0u},
/* F */  {0x7eu, 0x60u, 0x60u, 0x7cu, 0x60u, 0x60u, 0x60u, 0u},
/* G */  {0x3cu, 0x66u, 0x60u, 0x6eu, 0x66u, 0x66u, 0x3cu, 0u},
/* H */  {0x66u, 0x66u, 0x66u, 0x7eu, 0x66u, 0x66u, 0x66u, 0u},
/* I */  {0x7eu, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x7eu, 0u},
/* J */  {0x3eu, 0x0cu, 0x0cu, 0x0cu, 0x0cu, 0x6cu, 0x38u, 0u},
/* K */  {0x66u, 0x6cu, 0x78u, 0x70u, 0x78u, 0x6cu, 0x66u, 0u},
/* L */  {0x60u, 0x60u, 0x60u, 0x60u, 0x60u, 0x60u, 0x7eu, 0u},
/* M */  {0x63u, 0x77u, 0x7fu, 0x6bu, 0x6bu, 0x63u, 0x63u, 0u},
/* N */  {0x66u, 0x66u, 0x76u, 0x7eu, 0x6eu, 0x66u, 0x66u, 0u},
/* O */  {0x3cu, 0x66u, 0x66u, 0x66u, 0x66u, 0x66u, 0x3cu, 0u},
/* P */  {0x7cu, 0x66u, 0x66u, 0x7cu, 0x60u, 0x60u, 0x60u, 0u},
/* Q */  {0x3cu, 0x66u, 0x66u, 0x66u, 0x6au, 0x6cu, 0x36u, 0u},
/* R */  {0x7cu, 0x66u, 0x66u, 0x7cu, 0x6cu, 0x66u, 0x66u, 0u},
/* S */  {0x3cu, 0x66u, 0x60u, 0x3cu, 0x06u, 0x66u, 0x3cu, 0u},
/* T */  {0x7eu, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0u},
/* U */  {0x66u, 0x66u, 0x66u, 0x66u, 0x66u, 0x66u, 0x3cu, 0u},
/* V */  {0x66u, 0x66u, 0x66u, 0x66u, 0x66u, 0x3cu, 0x18u, 0u},
/* W */  {0x63u, 0x63u, 0x6bu, 0x6bu, 0x7fu, 0x77u, 0x63u, 0u},
/* X */  {0x66u, 0x66u, 0x3cu, 0x18u, 0x3cu, 0x66u, 0x66u, 0u},
/* Y */  {0x66u, 0x66u, 0x66u, 0x3cu, 0x18u, 0x18u, 0x18u, 0u},
/* Z */  {0x7eu, 0x06u, 0x0cu, 0x18u, 0x30u, 0x60u, 0x7eu, 0u},
/* [ */  {0x7cu, 0x60u, 0x60u, 0x60u, 0x60u, 0x60u, 0x7cu, 0u},
/* \ */  {0u, 0x60u, 0x30u, 0x18u, 0x0cu, 0x6u, 0u, 0u},
/* ] */  {0x3eu, 0x6u, 0x6u, 0x6u, 0x6u, 0x6u, 0x3eu, 0u},
/* ^ */  {0x18u, 0x3cu, 0x66u, 0x42u, 0u, 0u, 0u, 0u},
/* _ */  {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0xffu},
/* ` */  {0x30u, 0x18u, 0xcu, 0u, 0u, 0u, 0u, 0u},
/* a */  {0u, 0u, 0x3cu, 0x6u, 0x3eu, 0x66u, 0x3eu, 0u},
/* b */  {0x60u, 0x60u, 0x7cu, 0x66u, 0x66u, 0x66u, 0x7cu, 0u},
/* c */  {0u, 0u, 0x3cu, 0x66u, 0x60u, 0x66u, 0x3cu, 0u},
/* d */  {0x6u, 0x6u, 0x3eu, 0x66u, 0x66u, 0x66u, 0x3eu, 0u},
/* e */  {0u, 0u, 0x3cu, 0x66u, 0x7eu, 0x60u, 0x3cu, 0u},
/* f */  {0x1cu, 0x30u, 0x30u, 0x7cu, 0x30u, 0x30u, 0x30u, 0u},
/* g */  {0u, 0u, 0x3eu, 0x66u, 0x66u, 0x3eu, 0x6u, 0x3cu},
/* h */  {0x60u, 0x60u, 0x7cu, 0x66u, 0x66u, 0x66u, 0x66u, 0u},
/* i */  {0x18u, 0u, 0x38u, 0x18u, 0x18u, 0x18u, 0x3cu, 0u},
/* j */  {0x18u, 0u, 0x38u, 0x18u, 0x18u, 0x18u, 0x18u, 0x70u},
/* k */  {0x60u, 0x60u, 0x66u, 0x6cu, 0x78u, 0x6cu, 0x66u, 0u},
/* l */  {0x38u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x3cu, 0u},
/* m */  {0u, 0u, 0x36u, 0x7fu, 0x6bu, 0x6bu, 0x63u, 0u},
/* n */  {0u, 0u, 0x7cu, 0x66u, 0x66u, 0x66u, 0x66u, 0u},
/* o */  {0u, 0u, 0x3cu, 0x66u, 0x66u, 0x66u, 0x3cu, 0u},
/* p */  {0u, 0u, 0x7cu, 0x66u, 0x66u, 0x7cu, 0x60u, 0x60u},
/* q */  {0u, 0u, 0x3eu, 0x66u, 0x66u, 0x3eu, 0x6u, 0x7u},
/* r */  {0u, 0u, 0x6eu, 0x73u, 0x60u, 0x60u, 0x60u, 0u},
/* s */  {0u, 0u, 0x3eu, 0x60u, 0x3cu, 0x6u, 0x7cu, 0u},
/* t */  {0x30u, 0x30u, 0x7cu, 0x30u, 0x30u, 0x30u, 0x1cu, 0u},
/* u */  {0u, 0u, 0x66u, 0x66u, 0x66u, 0x66u, 0x3eu, 0u},
/* v */  {0u, 0u, 0x66u, 0x66u, 0x66u, 0x3cu, 0x18u, 0u},
/* w */  {0u, 0u, 0x63u, 0x6bu, 0x6bu, 0x7fu, 0x36u, 0u},
/* x */  {0u, 0u, 0x66u, 0x3cu, 0x18u, 0x3cu, 0x66u, 0u},
/* y */  {0u, 0u, 0x66u, 0x66u, 0x66u, 0x3eu, 0x6u, 0x3cu},
/* z */  {0u, 0u, 0x7eu, 0x0cu, 0x18u, 0x30u, 0x7eu, 0u},
/* { */  {0x0cu, 0x18u, 0x18u, 0x70u, 0x18u, 0x18u, 0x0cu, 0u},
/* | */  {0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0u},
/* } */  {0x30u, 0x18u, 0x18u, 0xeu, 0x18u, 0x18u, 0x30u, 0u},
/* ~ */  {0x31u, 0x6bu, 0x46u, 0u, 0u, 0u, 0u, 0u},
/* DEL */  {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
	/* 0x80 */
/* 80*/  {0x3u, 0x3u, 0x6u, 0x6u, 0x76u, 0x1Cu, 0xCu, 0u},
/* 81*/  {0x1Cu, 0x63u, 0x6Bu, 0x6Bu, 0x7Fu, 0x77u, 0x63u, 0u},
/* 82*/  {0x1Cu, 0x36u, 0u, 0x6Bu, 0x6Bu, 0x7Fu, 0x36u, 0u},
/* 83*/  {0xFEu, 0x92u, 0x92u, 0xF2u, 0x82u, 0x82u, 0xFEu, 0u},
/* 84*/  {0x66u, 0x99u, 0x81u, 0x42u, 0x81u, 0x99u, 0x66u, 0u},
/* 85*/  {0x18u, 0x66u, 0x42u, 0x66u, 0x3Cu, 0x18u, 0x18u, 0u},
/* 86*/  {0x18u, 0x66u, 0u, 0x66u, 0x66u, 0x3Eu, 0x6u, 0x3Cu},
/* 87*/  {0x18u, 0x3Cu, 0x3Cu, 0x7Eu, 0x7Eu, 0u, 0x7Eu, 0x3Cu},
/* 88*/  {0x18u, 0x28u, 0x4Fu, 0x81u, 0x4Fu, 0x28u, 0x18u, 0u},
/* 89*/  {0x18u, 0x14u, 0xF2u, 0x81u, 0xF2u, 0x14u, 0x18u, 0u},
/* 8A*/  {0x3Cu, 0x24u, 0x24u, 0xE7u, 0x42u, 0x24u, 0x18u, 0u},
/* 8B*/  {0x18u, 0x24u, 0x42u, 0xE7u, 0x24u, 0x24u, 0x3Cu, 0u},
/* 8C*/  {0u, 0u, 0u, 0u, 0u, 0xDBu, 0xDBu, 0u},
/* 8D*/  {0xF1u, 0x5Bu, 0x55u, 0x51u, 0u, 0u, 0u, 0u},
/* 8E*/  {0xC0u, 0xCCu, 0x18u, 0x30u, 0x60u, 0xDBu, 0x1Bu, 0u},
/* 8F*/  {0u, 0u, 0x3Cu, 0x7Eu, 0x7Eu, 0x3Cu, 0u, 0u},
	/* 90 */
/* 90*/  {0xCu, 0x18u, 0x18u, 0u, 0u, 0u, 0u, 0u},
/* 91*/  {0xCu, 0xCu, 0x18u, 0u, 0u, 0u, 0u, 0u},
/* 92*/  {0u, 0xCu, 0x18u, 0x30u, 0x30u, 0x18u, 0xCu, 0u},
/* 93*/  {0u, 0x30u, 0x18u, 0xCu, 0xCu, 0x18u, 0x30u, 0u},
/* 94*/  {0x1Bu, 0x36u, 0x36u, 0u, 0u, 0u, 0u, 0u},
/* 95*/  {0x36u, 0x36u, 0x6Cu, 0u, 0u, 0u, 0u, 0u},
/* 96*/  {0u, 0u, 0u, 0u, 0u, 0x36u, 0x36u, 0x6Cu},
/* 97*/  {0u, 0u, 0u, 0x3Cu, 0u, 0u, 0u, 0u},
/* 98*/  {0u, 0u, 0u, 0xFFu, 0u, 0u, 0u, 0u},
/* 99*/  {0x18u, 0x18u, 0x18u, 0x3Cu, 0x7Eu, 0x66u, 0x7Eu, 0x3Cu},
/* 9A*/  {0x77u, 0xCCu, 0xCCu, 0xCFu, 0xCCu, 0xCCu, 0x77u, 0u},
/* 9B*/  {0u, 0u, 0x6Eu, 0xDBu, 0xDFu, 0xD8u, 0x6Eu, 0u},
/* 9C*/  {0x18u, 0x18u, 0x7Eu, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u},
/* 9D*/  {0x18u, 0x18u, 0x7Eu, 0x18u, 0x7Eu, 0x18u, 0x18u, 0x18u},
/* 9E*/  {0x3Cu, 0x66u, 0x60u, 0xF6u, 0x66u, 0x66u, 0x66u, 0u},
/* 9F*/  {0x3Eu, 0x66u, 0x66u, 0xF6u, 0x66u, 0x66u, 0x66u, 0u},
	/* a0 */
/*  */  {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/*  */  {0x18u, 0u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0u},
/*  */  {0x8u, 0x3Eu, 0x6Bu, 0x68u, 0x6Bu, 0x3Eu, 0x8u, 0u},
/*  */  {0x1Cu, 0x36u, 0x30u, 0x7Cu, 0x30u, 0x30u, 0x7Eu, 0u},
/*  */  {0u, 0x66u, 0x3Cu, 0x66u, 0x66u, 0x3Cu, 0x66u, 0u},
/*  */  {0x66u, 0x3Cu, 0x18u, 0x18u, 0x7Eu, 0x18u, 0x18u, 0u},
/*  */  {0x18u, 0x18u, 0x18u, 0u, 0x18u, 0x18u, 0x18u, 0u},
/*  */  {0x3Cu, 0x60u, 0x3Cu, 0x66u, 0x3Cu, 0x6u, 0x3Cu, 0u},
/*  */  {0x66u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/*  */  {0x3Cu, 0x42u, 0x99u, 0xA1u, 0xA1u, 0x99u, 0x42u, 0x3Cu},
/*  */  {0x1Cu, 0x6u, 0x1Eu, 0x36u, 0x1Eu, 0u, 0x3Eu, 0u},
/*  */  {0u, 0x33u, 0x66u, 0xCCu, 0xCCu, 0x66u, 0x33u, 0u},
/*  */  {0x7Eu, 0x6u, 0u, 0u, 0u, 0u, 0u, 0u},
/*  */  {0u, 0u, 0u, 0x7Eu, 0u, 0u, 0u, 0u},
/*  */  {0x3Cu, 0x42u, 0xB9u, 0xA5u, 0xB9u, 0xA5u, 0x42u, 0x3Cu},
/*  */  {0x7Eu, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
	/* b0 */
/*  */  {0x3Cu, 0x66u, 0x3Cu, 0u, 0u, 0u, 0u, 0u},
/*  */  {0x18u, 0x18u, 0x7Eu, 0x18u, 0x18u, 0u, 0x7Eu, 0u},
/*  */  {0x38u, 0x4u, 0x18u, 0x20u, 0x3Cu, 0u, 0u, 0u},
/*  */  {0x38u, 0x4u, 0x18u, 0x4u, 0x38u, 0u, 0u, 0u},
/*  */  {0xCu, 0x18u, 0u, 0u, 0u, 0u, 0u, 0u},
/*  */  {0u, 0u, 0x33u, 0x33u, 0x33u, 0x33u, 0x3Eu, 0x60u},
/*  */  {0x3u, 0x3Eu, 0x76u, 0x76u, 0x36u, 0x36u, 0x3Eu, 0u},
/*  */  {0u, 0u, 0u, 0x18u, 0x18u, 0u, 0u, 0u},
/*  */  {0u, 0u, 0u, 0u, 0u, 0u, 0x18u, 0x30u},
/*  */  {0x10u, 0x30u, 0x10u, 0x10u, 0x38u, 0u, 0u, 0u},
/*  */  {0x1Cu, 0x36u, 0x36u, 0x36u, 0x1Cu, 0u, 0x3Eu, 0u},
/*  */  {0u, 0xCCu, 0x66u, 0x33u, 0x33u, 0x66u, 0xCCu, 0u},
/*  */  {0x40u, 0xC0u, 0x40u, 0x48u, 0x48u, 0xAu, 0xFu, 0x2u},
/*  */  {0x40u, 0xC0u, 0x40u, 0x4Fu, 0x41u, 0xFu, 0x8u, 0xFu},
/*  */  {0xE0u, 0x20u, 0xE0u, 0x28u, 0xE8u, 0xAu, 0xFu, 0x2u},
/*  */  {0x18u, 0u, 0x18u, 0x18u, 0x30u, 0x66u, 0x3Cu, 0u},
	/* c0 */
/*  */  {0x30u, 0x18u, 0u, 0x3Cu, 0x66u, 0x7Eu, 0x66u, 0u},
/*  */  {0xCu, 0x18u, 0u, 0x3Cu, 0x66u, 0x7Eu, 0x66u, 0u},
/*  */  {0x18u, 0x66u, 0u, 0x3Cu, 0x66u, 0x7Eu, 0x66u, 0u},
/*  */  {0x36u, 0x6Cu, 0u, 0x3Cu, 0x66u, 0x7Eu, 0x66u, 0u},
/*  */  {0x66u, 0x66u, 0u, 0x3Cu, 0x66u, 0x7Eu, 0x66u, 0u},
/*  */  {0x3Cu, 0x66u, 0x3Cu, 0x3Cu, 0x66u, 0x7Eu, 0x66u, 0u},
/*  */  {0x3Fu, 0x66u, 0x66u, 0x7Fu, 0x66u, 0x66u, 0x67u, 0u},
/*  */  {0x3Cu, 0x66u, 0x60u, 0x60u, 0x66u, 0x3Cu, 0x30u, 0x60u},
/*  */  {0x30u, 0x18u, 0x7Eu, 0x60u, 0x7Cu, 0x60u, 0x7Eu, 0u},
/*  */  {0xCu, 0x18u, 0x7Eu, 0x60u, 0x7Cu, 0x60u, 0x7Eu, 0u},
/*  */  {0x3Cu, 0x66u, 0x7Eu, 0x60u, 0x7Cu, 0x60u, 0x7Eu, 0u},
/*  */  {0x66u, 0u, 0x7Eu, 0x60u, 0x7Cu, 0x60u, 0x7Eu, 0u},
/*  */  {0x30u, 0x18u, 0u, 0x7Eu, 0x18u, 0x18u, 0x7Eu, 0u},
/*  */  {0xCu, 0x18u, 0u, 0x7Eu, 0x18u, 0x18u, 0x7Eu, 0u},
/*  */  {0x3Cu, 0x66u, 0u, 0x7Eu, 0x18u, 0x18u, 0x7Eu, 0u},
/*  */  {0x66u, 0x66u, 0u, 0x7Eu, 0x18u, 0x18u, 0x7Eu, 0u},
	/* d0 */
/*  */  {0x78u, 0x6Cu, 0x66u, 0xF6u, 0x66u, 0x6Cu, 0x78u, 0u},
/*  */  {0x36u, 0x6Cu, 0u, 0x66u, 0x76u, 0x6Eu, 0x66u, 0u},
/*  */  {0x30u, 0x18u, 0x3Cu, 0x66u, 0x66u, 0x66u, 0x3Cu, 0u},
/*  */  {0xCu, 0x18u, 0x3Cu, 0x66u, 0x66u, 0x66u, 0x3Cu, 0u},
/*  */  {0x3Cu, 0x66u, 0x3Cu, 0x66u, 0x66u, 0x66u, 0x3Cu, 0u},
/*  */  {0x36u, 0x6Cu, 0x3Cu, 0x66u, 0x66u, 0x66u, 0x3Cu, 0u},
/*  */  {0x66u, 0u, 0x3Cu, 0x66u, 0x66u, 0x66u, 0x3Cu, 0u},
/*  */  {0u, 0x63u, 0x36u, 0x1Cu, 0x1Cu, 0x36u, 0x63u, 0u},
/*  */  {0x3Du, 0x66u, 0x6Eu, 0x7Eu, 0x76u, 0x66u, 0xBCu, 0u},
/*  */  {0x30u, 0x18u, 0x66u, 0x66u, 0x66u, 0x66u, 0x3Cu, 0u},
/*  */  {0xCu, 0x18u, 0x66u, 0x66u, 0x66u, 0x66u, 0x3Cu, 0u},
/*  */  {0x3Cu, 0x66u, 0u, 0x66u, 0x66u, 0x66u, 0x3Cu, 0u},
/*  */  {0x66u, 0u, 0x66u, 0x66u, 0x66u, 0x66u, 0x3Cu, 0u},
/*  */  {0xCu, 0x18u, 0x66u, 0x66u, 0x3Cu, 0x18u, 0x18u, 0u},
/*  */  {0xF0u, 0x60u, 0x7Cu, 0x66u, 0x7Cu, 0x60u, 0xF0u, 0u},
/*  */  {0x3Cu, 0x66u, 0x66u, 0x6Cu, 0x66u, 0x66u, 0x6Cu, 0xC0u},
	/* e0 */
/*  */  {0x30u, 0x18u, 0x3Cu, 0x6u, 0x3Eu, 0x66u, 0x3Eu, 0u},
/*  */  {0xCu, 0x18u, 0x3Cu, 0x6u, 0x3Eu, 0x66u, 0x3Eu, 0u},
/*  */  {0x18u, 0x66u, 0x3Cu, 0x6u, 0x3Eu, 0x66u, 0x3Eu, 0u},
/*  */  {0x36u, 0x6Cu, 0x3Cu, 0x6u, 0x3Eu, 0x66u, 0x3Eu, 0u},
/*  */  {0x66u, 0u, 0x3Cu, 0x6u, 0x3Eu, 0x66u, 0x3Eu, 0u},
/*  */  {0x3Cu, 0x66u, 0x3Cu, 0x6u, 0x3Eu, 0x66u, 0x3Eu, 0u},
/*  */  {0u, 0u, 0x3Fu, 0xDu, 0x3Fu, 0x6Cu, 0x3Fu, 0u},
/*  */  {0u, 0u, 0x3Cu, 0x66u, 0x60u, 0x66u, 0x3Cu, 0x60u},
/*  */  {0x30u, 0x18u, 0x3Cu, 0x66u, 0x7Eu, 0x60u, 0x3Cu, 0u},
/*  */  {0xCu, 0x18u, 0x3Cu, 0x66u, 0x7Eu, 0x60u, 0x3Cu, 0u},
/*  */  {0x3Cu, 0x66u, 0x3Cu, 0x66u, 0x7Eu, 0x60u, 0x3Cu, 0u},
/*  */  {0x66u, 0u, 0x3Cu, 0x66u, 0x7Eu, 0x60u, 0x3Cu, 0u},
/*  */  {0x30u, 0x18u, 0u, 0x38u, 0x18u, 0x18u, 0x3Cu, 0u},
/*  */  {0xCu, 0x18u, 0u, 0x38u, 0x18u, 0x18u, 0x3Cu, 0u},
/*  */  {0x3Cu, 0x66u, 0u, 0x38u, 0x18u, 0x18u, 0x3Cu, 0u},
/*  */  {0x66u, 0u, 0u, 0x38u, 0x18u, 0x18u, 0x3Cu, 0u},
	/* f0 */
/*  */  {0x18u, 0x3Eu, 0xCu, 0x6u, 0x3Eu, 0x66u, 0x3Eu, 0u},
/*  */  {0x36u, 0x6Cu, 0u, 0x7Cu, 0x66u, 0x66u, 0x66u, 0u},
/*  */  {0x30u, 0x18u, 0u, 0x3Cu, 0x66u, 0x66u, 0x3Cu, 0u},
/*  */  {0xCu, 0x18u, 0u, 0x3Cu, 0x66u, 0x66u, 0x3Cu, 0u},
/*  */  {0x3Cu, 0x66u, 0u, 0x3Cu, 0x66u, 0x66u, 0x3Cu, 0u},
/*  */  {0x36u, 0x6Cu, 0u, 0x3Cu, 0x66u, 0x66u, 0x3Cu, 0u},
/*  */  {0x66u, 0u, 0u, 0x3Cu, 0x66u, 0x66u, 0x3Cu, 0u},
/*  */  {0u, 0x18u, 0u, 0xFFu, 0u, 0x18u, 0u, 0u},
/*  */  {0u, 0x2u, 0x3Cu, 0x6Eu, 0x76u, 0x66u, 0xBCu, 0u},
/*  */  {0x30u, 0x18u, 0u, 0x66u, 0x66u, 0x66u, 0x3Eu, 0u},
/*  */  {0xCu, 0x18u, 0u, 0x66u, 0x66u, 0x66u, 0x3Eu, 0u},
/*  */  {0x3Cu, 0x66u, 0u, 0x66u, 0x66u, 0x66u, 0x3Eu, 0u},
/*  */  {0x66u, 0u, 0u, 0x66u, 0x66u, 0x66u, 0x3Eu, 0u},
/*  */  {0xCu, 0x18u, 0x66u, 0x66u, 0x66u, 0x3Eu, 0x6u, 0x3Cu},
/*  */  {0x60u, 0x60u, 0x7Cu, 0x66u, 0x7Cu, 0x60u, 0x60u, 0u},
/*  */  {0x66u, 0u, 0x66u, 0x66u, 0x66u, 0x3Eu, 0x6u, 0x3Cu}
};
#endif /* BRANDY_MODE7ONLY */

static unsigned short mode7font[224][20];

static unsigned short mode7fontbanks[2][256][20] = {{
/* 00-1B: Hebrew characters that map to &E0 to &FB on the SAA5056. */
/* 00*/ {0u, 0u, 0x380Cu, 0x3C0Cu, 0x1E0Cu, 0x0F0Cu, 0x3F8Cu, 0x31DCu, 0x30F8u, 0x3070u, 0x3038u, 0x301Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 01*/ {0u, 0u, 0x0FF0u, 0x0FF0u, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 02*/ {0u, 0u, 0x007Cu, 0x007Cu, 0x000Cu, 0x000Cu, 0x001Cu, 0x003Cu, 0x007Cu, 0x00ECu, 0x01CCu, 0x038Cu, 0x070Cu, 0x0E0Cu, 0x1C0Cu, 0u, 0u, 0u, 0u, 0u},
/* 03*/ {0u, 0u, 0x3FFCu, 0x3FFCu, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0u, 0u, 0u, 0u, 0u},
/* 04*/ {0u, 0u, 0x3FFCu, 0x3FFCu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x200Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 05*/ {0u, 0u, 0x1F80u, 0x1F80u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* 06*/ {0u, 0u, 0x1FE0u, 0x1FE0u, 0x0180u, 0x0380u, 0x0700u, 0x0E00u, 0x0700u, 0x0380u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* 07*/ {0u, 0u, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 08*/ {0u, 0u, 0x300Cu, 0x301Cu, 0x303Cu, 0x30FCu, 0x31ECu, 0x338Cu, 0x330Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 09*/ {0u, 0u, 0x1F80u, 0x1F80u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 0A*/ {0u, 0u, 0x3FFCu, 0x3FFCu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0u, 0u, 0u},
/* 0B*/ {0u, 0u, 0x3FFCu, 0x3FFCu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 0C*/ {0x3000u, 0x3000u, 0x3FFCu, 0x3FFCu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x001Cu, 0x0038u, 0x0070u, 0x00C0u, 0x0FC0u, 0x0F80u, 0u, 0u, 0u, 0u, 0u},
/* 0D*/ {0u, 0u, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 0E*/ {0u, 0u, 0x31C0u, 0x3BF0u, 0x1F38u, 0x0E1Cu, 0x1C0Cu, 0x380Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x33FCu, 0x33FCu, 0u, 0u, 0u, 0u, 0u},
/* 0F*/ {0u, 0u, 0x1F80u, 0x1F80u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u},
/* 10*/ {0u, 0u, 0x03E0u, 0x03E0u, 0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x1FE0u, 0x1FE0u, 0u, 0u, 0u, 0u, 0u},
/* 11*/ {0u, 0u, 0x3FFCu, 0x3FFCu, 0x060Cu, 0x0E0Cu, 0x1C0Cu, 0x380Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1C38u, 0x0FF0u, 0x07E0u, 0u, 0u, 0u, 0u, 0u},
/* 12*/ {0u, 0u, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C1Cu, 0x0C38u, 0x0C70u, 0x0CE0u, 0x3FC0u, 0x3F80u, 0u, 0u, 0u, 0u, 0u},
/* 13*/ {0u, 0u, 0x3FFCu, 0x3FFCu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0FCCu, 0x0FCCu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0u, 0u, 0u},
/* 14*/ {0u, 0u, 0x3FFCu, 0x3FFCu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0FCCu, 0x0FCCu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 15*/ {0u, 0u, 0x3C1Cu, 0x3C38u, 0x0C70u, 0x0CE0u, 0x0FC0u, 0x0F80u, 0x0C00u, 0x0C00u, 0x0C00u, 0x0C00u, 0x0C00u, 0x0C00u, 0x0C00u, 0x0C00u, 0x0C00u, 0u, 0u, 0u},
/* 16*/ {0u, 0u, 0x300Cu, 0x300Cu, 0x381Cu, 0x1C38u, 0x0E70u, 0x07E0u, 0x03C0u, 0x0180u, 0x01C0u, 0x00E0u, 0x0060u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 17*/ {0u, 0u, 0x3FFCu, 0x3FFCu, 0x000Cu, 0x000Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C1Cu, 0x0C38u, 0x0C70u, 0x0C60u, 0x0C00u, 0x0C00u, 0x0C00u, 0x0C00u, 0u, 0u, 0u},
/* 18*/ {0u, 0u, 0x3FFCu, 0x3FFCu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0u, 0u, 0u, 0u, 0u},
/* 19*/ {0u, 0u, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x338Cu, 0x3F8Cu, 0x3F0Cu, 0x300Cu, 0x301Cu, 0x3038u, 0x3FF0u, 0x3FE0u, 0u, 0u, 0u, 0u, 0u},
/* 1A*/ {0u, 0u, 0x0FFCu, 0x0FFCu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x3C0Cu, 0x3C0cu, 0u, 0u, 0u, 0u, 0u},
/* 1B*/ {0x7F06u, 0x7F86u, 0x61C6u, 0x60C6u, 0x60C6u, 0x60C6u, 0x60C6u, 0x60C6u, 0x6306u, 0x6306u, 0x6306u, 0x6306u, 0x6306u, 0x630Eu, 0x63FCu, 0x63F8u, 0u, 0u, 0u, 0u},
/* 1C*/ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 1D*/ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 1E*/ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 1F*/ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 20 to 7E corresponds to SAA5055 - US-ASCII */
/*   */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* ! */ {0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* " */ {0u, 0x0C60u, 0x0C60u, 0x0C60u, 0x0C60u, 0x0C60u, 0x0C60u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* # */ {0u, 0x0630u, 0x0630u, 0x0630u, 0x0630u, 0x1FFCu, 0x1FFCu, 0x0630u, 0x0630u, 0x1FFCu, 0x1FFCu, 0x0630u, 0x0630u, 0x0630u, 0x0630u, 0u, 0u, 0u, 0u, 0u},
/* $ */ {0u, 0x0FF0u, 0x1FF8u, 0x399Cu, 0x318Cu, 0x3180u, 0x3980u, 0x1FF0u, 0x0FF8u, 0x019Cu, 0x018Cu, 0x318Cu, 0x399Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* % */ {0u, 0x3C00u, 0x3C0Cu, 0x3C1Cu, 0x3C38u, 0x0070u, 0x00E0u, 0x01C0, 0x0380u, 0x0700u, 0x0E00u, 0x1C3Cu, 0x383Cu, 0x303Cu, 0x003Cu, 0u, 0u, 0u, 0u, 0u},
/* & */ {0u, 0x0E00u, 0x1F00u, 0x3B80u, 0x3180u, 0x3380u, 0x3F00u, 0x1E00u, 0x1F00u, 0x3F8Cu, 0x31DCu, 0x30F8u, 0x3878u, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* ' */ {0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* ( */ {0u, 0x0060u, 0x00E0u, 0x01C0u, 0x0380u, 0x0700u, 0x0600u, 0x0600u, 0x0600u, 0x0600u, 0x0700u, 0x0380u, 0x01C0u, 0x00E0u, 0x0060u, 0u, 0u, 0u, 0u, 0u},
/* ) */ {0u, 0x0600u, 0x0700u, 0x0380u, 0x01C0u, 0x00E0u, 0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x00E0u, 0x01C0u, 0x0380u, 0x0700u, 0x0600u, 0u, 0u, 0u, 0u, 0u},
/* * */ {0u, 0x0180u, 0x0180u, 0x318Cu, 0x399Cu, 0x1FF8u, 0x0FF0u, 0x0180u, 0x0180u, 0x0FF0u, 0x1FF8u, 0x399Cu, 0x318Cu, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* + */ {0u, 0u, 0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x1FF8u, 0x1FF8u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* , */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0380u, 0x0300u, 0u, 0u, 0u},
/* - */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* . */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* / */ {0u, 0u, 0x0018u, 0x0038u, 0x0070u, 0x00E0u, 0x01C0u, 0x0380u, 0x0700u, 0x0E00u, 0x1C00u, 0x1800u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 0 */ {0u, 0x03C0u, 0x07E0u, 0x0E70u, 0x1C38u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1C38u, 0x0E70u, 0x07E0u, 0x03C0u, 0u, 0u, 0u, 0u, 0u},
/* 1 */ {0u, 0x0180u, 0x0180u, 0x0F80u, 0x0F80u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* 2 */ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x000Cu, 0x001Cu, 0x03F8u, 0x07F0u, 0x0E00, 0x1C00u, 0x3800u, 0x3000u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u},
/* 3 */ {0u, 0x3FFCu, 0x3FFCu, 0x001Cu, 0x0038u, 0x0070u, 0x00E0u, 0x01F8u, 0x01FCu, 0x000Cu, 0x000Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u},
/* 4 */ {0u, 0x0070u, 0x00F0u, 0x01F0u, 0x03B0u, 0x0730u, 0x0E30u, 0x1C30u, 0x3830u, 0x3FFCu, 0x3FFCu, 0x0030u, 0x0030u, 0x0030u, 0x0030u, 0u, 0u, 0u, 0u, 0u},
/* 5 */ {0u, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3000u, 0x3FF0u, 0x3FF8u, 0x001Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* 6 */ {0u, 0x01F0u, 0x07F0u, 0x0F00u, 0x1C00u, 0x3800u, 0x3000u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* 7 */ {0u, 0x3FFCu, 0x3FFCu, 0x000Cu, 0x001Cu, 0x0038u, 0x0070u, 0x00E0u, 0x01C0u, 0x0380u, 0x0700u, 0x0600u, 0x0600u, 0x0600u, 0x0600u, 0u, 0u, 0u, 0u, 0u},
/* 8 */ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* 9 */ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0x000Cu, 0x001Cu, 0x0038u, 0x00F0u, 0x0FE0u, 0x0F80u, 0u, 0u, 0u, 0u, 0u},
/* : */ {0u, 0u, 0u, 0u, 0u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u, 0u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* ; */ {0u, 0u, 0u, 0u, 0u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0380u, 0x0300u, 0u, 0u, 0u},
/* < */ {0u, 0x0060u, 0x00E0u, 0x01C0u, 0x0380u, 0x0700u, 0x0E00u, 0x1C00u, 0x1C00u, 0x0E00u, 0x0700u, 0x0380u, 0x01C0u, 0x00E0u, 0x0060u, 0u, 0u, 0u, 0u, 0u},
/* = */ {0u, 0u, 0u, 0u, 0u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* > */ {0u, 0x0600u, 0x0700u, 0x0380u, 0x01C0u, 0x00E0u, 0x0070u, 0x0038u, 0x0038u, 0x0070u, 0x00E0u, 0x01C0u, 0x0380u, 0x0700u, 0x0600u, 0u, 0u, 0u, 0u, 0u},
/* ? */ {0u, 0xFE0u, 0x1FF0u, 0x3838u, 0x3018u, 0x0038u, 0x0070u, 0x00E0, 0x01C0u, 0x0180u, 0x0180u, 0u, 0u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* @ */ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x31FCu, 0x31FCu, 0x318Cu, 0x318Cu, 0x31FCu, 0x31FCu, 0x3000u, 0x3800u, 0x1FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* A */ {0u, 0x0180u, 0x03C0u, 0x07E0u, 0x0E70u, 0x1C38u, 0x381Cu, 0x300Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* B */ {0u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x3FF8u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x3FF8u, 0x3FF0u, 0u, 0u, 0u, 0u, 0u},
/* C */ {0u, 0xFF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x300Cu, 0x381Cu, 0x1FF8u, 0xFF0u, 0u, 0u, 0u, 0u, 0u},
/* D */ {0u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x3FF8u, 0x3FF0u, 0u, 0u, 0u, 0u, 0u},
/* E */ {0u, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3FF0u, 0x3FF0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* F */ {0u, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3FF0u, 0x3FF0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0u, 0u, 0u, 0u, 0u},
/* G */ {0u, 0xFF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x303Cu, 0x303Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* H */ {0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* I */ {0u, 0x0FF0u, 0x0FF0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* J */ {0u, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* K */ {0u, 0x1818u, 0x1838u, 0x1870u, 0x18E0u, 0x19C0u, 0x1B80u, 0x1F00u, 0x1F00u, 0x1B80u, 0x19C0u, 0x18E0u, 0x1870u, 0x1838u, 0x1818u, 0u, 0u, 0u, 0u, 0u},
/* L */ {0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* M */ {0u, 0x300Cu, 0x300Cu, 0x381Cu, 0x3C3Cu, 0x3E7Cu, 0x37ECu, 0x33CCu, 0x318Cu, 0x318Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* N */ {0u, 0x300Cu, 0x300Cu, 0x380Cu, 0x3C0Cu, 0x3E0Cu, 0x370Cu, 0x338Cu, 0x31CCu, 0x30ECu, 0x307Cu, 0x303Cu, 0x301Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* O */ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* P */ {0u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x3FF8u, 0x3FF0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0u, 0u, 0u, 0u, 0u},
/* Q */ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x30CCu, 0x30ECu, 0x3078u, 0x3838u, 0x1FFCu, 0x0FCCu, 0u, 0u, 0u, 0u, 0u},
/* R */ {0u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x3FF8u, 0x3FF0u, 0x31C0u, 0x30E0u, 0x3070u, 0x3038u, 0x301Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* S */ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3000u, 0x3800u, 0x1FF0u, 0x0FF8u, 0x001Cu, 0x000Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* T */ {0u, 0x3FFCu, 0x3FFCu, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* U */ {0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* V */ {0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1818u, 0x1C38u, 0x0C30u, 0x0E70u, 0x07E0u, 0x03C0u, 0x03C0u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* W */ {0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x3FFCu, 0x1FF8u, 0x0E70u, 0u, 0u, 0u, 0u, 0u},
/* X */ {0u, 0x300Cu, 0x300Cu, 0x381Cu, 0x1C38u, 0x0E70u, 0x07E0u, 0x03C0u, 0x03C0u, 0x07E0u, 0x0E70u, 0x1C38u, 0x381Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* Y */ {0u, 0x300Cu, 0x300Cu, 0x381Cu, 0x1C38u, 0x0E70u, 0x07E0u, 0x03C0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* Z */ {0u, 0x3FFCu, 0x3FFCu, 0x001Cu, 0x0038u, 0x0070u, 0x00E0u, 0x01C0u, 0x0380u, 0x0700u, 0x0E00u, 0x1C00u, 0x3800u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* [ */ {0u, 0x07E0u, 0x07E0u, 0x0600u, 0x0600u, 0x0600u, 0x0600u, 0x0600u, 0x0600u, 0x0600u, 0x0600u, 0x0600u, 0x0600u, 0x07E0u, 0x07E0u, 0u, 0u, 0u, 0u, 0u},
/* \ */ {0u, 0u, 0x3000u, 0x3800u, 0x1C00u, 0x0E00u, 0x0700u, 0x0380u, 0x1C0u, 0x00E0u, 0x0070u, 0x0038u, 0x001Cu, 0x000Cu, 0u, 0u, 0u, 0u, 0u, 0u},
/* ] */ {0u, 0x07E0u, 0x07E0u, 0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x0060u, 0x07E0u, 0x07E0u, 0u, 0u, 0u, 0u, 0u},
/* ^ */ {0u, 0x0180u, 0x03C0u, 0x07E0u, 0x0E70u, 0x1C38u, 0x1818u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* _ */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0xFFFFu, 0xFFFFu, 0u, 0u},
/* ` */ {0u, 0x0600u, 0x0700u, 0x0380u, 0x01C0u, 0x00E0u, 0x0060u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* a */ {0u, 0u, 0u, 0u, 0u, 0x1FF0u, 0x1FF8u, 0x001Cu, 0x000Cu, 0x1FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x3FFCu, 0x1FFCu, 0u, 0u, 0u, 0u, 0u},
/* b */ {0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x3FF8u, 0x3FF0u, 0u, 0u, 0u, 0u, 0u},
/* c */ {0u, 0u, 0u, 0u, 0u, 0x0FFCu, 0x1FFCu, 0x3800u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3800u, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* d */ {0u, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x0FFCu, 0x1FFCu, 0x380Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* e */ {0u, 0u, 0u, 0u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3800u, 0x1FF8u, 0x0FF8u, 0u, 0u, 0u, 0u, 0u},
/* f */ {0u, 0x30u, 0x00F0u, 0x01C0u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* g */ {0u, 0u, 0u, 0u, 0u, 0x0FFCu, 0x1FFCu, 0x380Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0x000Cu, 0x001Cu, 0x0FF8u, 0x0FF0u, 0u},
/* h */ {0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* i */ {0u, 0x0180u, 0x0180u, 0u, 0u, 0x0F80u, 0x0F80u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* j */ {0u, 0x0180u, 0x0180u, 0u, 0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0380u, 0x0F00u, 0x0C00u, 0u},
/* k */ {0u, 0x1800u, 0x1800u, 0x1800u, 0x1800u, 0x1818u, 0x1838u, 0x18F0u, 0x1BC0u, 0x1F80u, 0x1F80u, 0x19C0u, 0x18F0u, 0x1838u, 0x1818u, 0u, 0u, 0u, 0u, 0u},
/* l */ {0u, 0x0F80u, 0x0F80u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* m */ {0u, 0u, 0u, 0u, 0u, 0x3E30u, 0x3FF8u, 0x33FCu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0u, 0u, 0u, 0u, 0u},
/* n */ {0u, 0u, 0u, 0u, 0u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* o */ {0u, 0u, 0u, 0u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* p */ {0u, 0u, 0u, 0u, 0u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x3FF8u, 0x3FF0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0u},
/* q */ {0u, 0u, 0u, 0u, 0u, 0x0FFCu, 0x1FFCu, 0x380Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0u},
/* r */ {0u, 0u, 0u, 0u, 0u, 0x31FCu, 0x33FCu, 0x3E00u, 0x3C00u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0u, 0u, 0u, 0u, 0u},
/* s */ {0u, 0u, 0u, 0u, 0u, 0x0FFCu, 0x1FFCu, 0x3000u, 0x3000u, 0x1FF0u, 0x0FF8u, 0x000Cu, 0x000Cu, 0x3FF8u, 0x3FF0u, 0u, 0u, 0u, 0u, 0u},
/* t */ {0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x01C0u, 0x00F0u, 0x0030u, 0u, 0u, 0u, 0u, 0u},
/* u */ {0u, 0u, 0u, 0u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* v */ {0u, 0u, 0u, 0u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1818u, 0x1C38u, 0x0E70u, 0x07E0u, 0x03C0u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* w */ {0u, 0u, 0u, 0u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x3FFCu, 0x1FF8u, 0x0E70u, 0u, 0u, 0u, 0u, 0u},
/* x */ {0u, 0u, 0u, 0u, 0u, 0x300Cu, 0x381Cu, 0x1E78u, 0x0FF0u, 0x03C0u, 0x03C0u, 0x0FF0u, 0x1E78u, 0x381Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* y */ {0u, 0u, 0u, 0u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0x000Cu, 0x001Cu, 0x0FF8u, 0x0FF0u, 0u},
/* z */ {0u, 0u, 0u, 0u, 0u, 0x3FFCu, 0x3FFCu, 0x0038u, 0x00F0u, 0x01E0u, 0x0780u, 0x0F00u, 0x1C00u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* { */ {0u, 0x00F0u, 0x01F0u, 0x0180u, 0x0180u, 0x0380u, 0x0300u, 0x0F00u, 0x0F00u, 0x0300u, 0x0380u, 0x0180u, 0x0180u, 0x00F0u, 0x00F0u, 0u, 0u, 0u, 0, 0u},
/* | */ {0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* } */ {0u, 0x0F00u, 0x0F80u, 0x0180u, 0x0180u, 0x01C0u, 0x00C0u, 0x00F0u, 0x00F0u, 0x00C0u, 0x01C0u, 0x0180u, 0x0180u, 0x0F00u, 0x0F00u, 0u, 0u, 0u, 0u, 0u},
/* ~ */ {0u, 0x0E00u, 0x1F0Cu, 0x3BDCu, 0x31F8u, 0x0070u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* Extra character library for picking and packing as appropriate */
/* 7F Triangle                  */ {0u, 0x0180u, 0x03C0u, 0x03C0u,0x0660u,0x0660u,0x0C30u,0x0C30u,0x1818u,0x1818u,0x300Cu,0x300Cu,0x300Cu,0x3FFCu,0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 80 Euro symbol               */ {0u, 0x03F0u, 0x07F8u, 0x0E1Cu, 0x0C0Cu, 0x3F80u, 0x3F80u, 0x0C00u, 0x0C00u, 0x3F80u, 0x3F80u, 0x0C0Cu, 0x0E1Cu, 0x07F8u, 0x03F0u, 0u, 0u, 0u, 0u, 0u},
/* 81 Bock (standard VDU255)    */ {0u, 0x3FFCu, 0x3FFCu, 0x3FFCu, 0x3FFCu, 0x3FFCu, 0x3FFCu, 0x3FFCu, 0x3FFCu, 0x3FFCu, 0x3FFCu, 0x3FFCu, 0x3FFCu, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 82 German open single quote  */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0x0380u, 0x0380u, 0x0180u, 0x0380u, 0x0700u, 0x0E00u, 0u, 0u, 0u},
/* 83 f with hook               */ {0u, 0x0070u, 0x00F0u, 0x01C0u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0380u, 0x0F00u, 0x0E00u, 0u},
/* 84 German open double quote  */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0x0E1Cu, 0x0E1Cu, 0x060Cu, 0x0E1Cu, 0x1C38u, 0x3870u, 0u, 0u, 0u},
/* 85 Ellipsis                  */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0x1998u, 0x1998u, 0u, 0u, 0u, 0u, 0u},
/* 86 Dagger / cross            */ {0u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* 87 Double cross              */ {0u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* 88 Small caret               */ {0x0180u, 0x03C0u, 0x0660u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 89 Per mille                 */ {0u, 0x3830u, 0x6C70u, 0x6CE0u, 0x39C0u, 0x0380u, 0x0700u, 0x0E00u, 0x1C00u, 0x3800u, 0x7000u, 0x671Cu, 0x0DB6u, 0x0DB6u, 0x071Cu, 0u, 0u, 0u, 0u, 0u},
/* 8A S with caron              */ {0x0660u, 0x07E0u, 0x03C0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3800u, 0x1FF0u, 0x0FF8u, 0x001Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* 8B French left chevron       */ {0u, 0u, 0u, 0x0180u, 0x0380u, 0x0700u, 0x0E00u, 0x0C00u, 0x0E00u, 0x0700u, 0x0380u, 0x0180u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 8C OE ligature               */ {0u, 0x0FFCu, 0x1FFCu, 0x3980u, 0x3180u, 0x3180u, 0x3180u, 0x31F8u, 0x31F8u, 0x3180u, 0x3180u, 0x3180u, 0x3980u, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* 8D Up arrow                  */ {0u, 0u, 0x0180u, 0x03C0u, 0x07E0u, 0x0FF0u, 0x1DB8u, 0x399Cu, 0x318Cu, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 8E Z with caron              */ {0x0660u, 0x07E0u, 0x03C0u, 0x3FFCu, 0x3FFCu, 0x0038u, 0x0070u, 0x00E0u, 0x01C0u, 0x0380u, 0x0700u, 0x0E00u, 0x1C00u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 8F Left arrow                */ {0u, 0u, 0x0180u, 0x0380u, 0x0700u, 0x0E00u, 0x1C00u, 0x3FFCu, 0x3FFCu, 0x1C00u, 0x0E00u, 0x0700u, 0x0380u, 0x0180u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 90 Right arrow               */ {0u, 0u, 0x0180u, 0x01C0u, 0x00E0u, 0x0070u, 0x0038u, 0x3FFCu, 0x3FFCu, 0x0038u, 0x0070u, 0x00E0u, 0x01C0u, 0x0180u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 91 Open single quote         */ {0u, 0x0070u, 0x00E0u, 0x01C0u, 0x0180u, 0x01C0u, 0x01C0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 92 Close single quote        */ {0u, 0x0380u, 0x0380u, 0x0180u, 0x0380u, 0x0700u, 0x0E00u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 93 Open double quote         */ {0u, 0x0E1Cu, 0x1C38u, 0x3870u, 0x3060u, 0x3870u, 0x3870u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 94 Close single quote        */ {0u, 0x0E1Cu, 0x0E1Cu, 0x060Cu, 0x0E1Cu, 0x1C38u, 0x3870u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 95 Diamond / bullet          */ {0u, 0u, 0u, 0u, 0u, 0x0180u, 0x03C0u, 0x07E0u, 0x07E0u, 0x03C0u, 0x0180u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 96 Horizontal bar            */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0x1FF8u, 0x1FF8u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 97 Horizontal full-width bar */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0xFFFFu, 0xFFFFu, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 98 Small tilde ~             */ {0x0760u, 0x0DC0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 99 Trademark sign            */ {0u, 0u, 0x7EC6u, 0x7EC6u, 0x18EEu, 0x18FEu, 0x18D6u, 0x18D6u, 0x18C6u, 0x18C6u, 0x18C6u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 9A s with caron              */ {0u, 0x0660u, 0x07E0u, 0x03C0u, 0u, 0x0FFCu, 0x1FFCu, 0x3800u, 0x3800u, 0x1FF0u, 0x0FF8u, 0x001Cu, 0x001Cu, 0x3FF8u, 0x3FF0u, 0u, 0u, 0u, 0u, 0u},
/* 9B French right chevron      */ {0u, 0u, 0u, 0x0180u, 0x01C0u, 0x00E0u, 0x0070u, 0x0030u, 0x0070u, 0x00E0u, 0x01C0u, 0x0180u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* 9C oe ligature               */ {0u, 0u, 0u, 0u, 0u, 0x0E78u, 0x1FFCu, 0x3BCCu, 0x318Cu, 0x31FCu, 0x31FCu, 0x3180u, 0x3BC0u, 0x1FFCu, 0x0E7Cu, 0u, 0u, 0u, 0u, 0u},
/* 9D Double-bar pipe           */ {0u, 0xC60u, 0xC60u, 0xC60u, 0xC60u, 0xC60u, 0xC60u, 0xC60u, 0xC60u, 0xC60u, 0xC60u, 0xC60u, 0xC60u, 0xC60u, 0xC60u, 0u, 0u, 0u, 0u, 0u},
/* 9E z with caron              */ {0u, 0x0660u, 0x07E0u, 0x03C0u, 0u, 0x3FFCu, 0x3FFCu, 0x0038u, 0x0070u, 0x01E0u, 0x0780u, 0x0E00u, 0x1C00u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 9F Y with umlaut             */ {0x0C30u, 0x0C30u, 0x0C30u, 0u, 0x300Cu, 0x381Cu, 0x1C38u, 0x0E70u, 0x07E0u, 0x03C0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* A0 Space                     */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* A1 Inverted exclamation mark */ {0u, 0u, 0u, 0u, 0u, 0x0180u, 0x0180u, 0u, 0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* A2 cent                      */ {0u, 0u, 0u, 0x0180u, 0x0180u, 0x0FFCu, 0x1FFCu, 0x3980u, 0x3180u, 0x3180u, 0x3180u, 0x3180u, 0x3980u, 0x1FFCu, 0x0FFCu, 0x0180u, 0x0180u, 0u, 0u, 0u},
/* A3 Pound sterling            */ {0u, 0x3F0u, 0x7F8u, 0xE1Cu, 0x0C0Cu, 0x0C00u, 0x0C00u, 0x3F80u, 0x3F80u, 0x0C00u, 0x0C00u, 0x0C00u, 0x0C00u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* A4 Currency sign             */ {0u, 0u, 0u, 0u, 0u, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0x0E70u, 0x0E70u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* A5 Yen/Yuan                  */ {0u, 0x300Cu, 0x381Cu, 0x1C38u, 0x0E70u, 0x3FFCu, 0x3FFCu, 0x0180u, 0x0180u, 0x3FFCu, 0x3FFCu, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* A6 Single broken pipe        */ {0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* A7 Section sign              */ {0u, 0xFF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3000u, 0x3800u, 0x1FF0u, 0x1FF8u, 0x381Cu, 0x381Cu, 0x1FF8u, 0xFF8u, 0x1Cu, 0x0Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0xFF0u, 0u}, /* Section sign */
/* A8 Umlaut                    */ {0x1818u, 0x1818u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* A9 Copyright sign            */ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x33CCu, 0x37ECu, 0x366Cu, 0x360Cu, 0x360Cu, 0x360Cu, 0x366Cu, 0x37ECu, 0x33CCu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u},
/* AA a with underline          */ {0u, 0x1FF0u, 0x1FF8u, 0x001Cu, 0x000Cu, 0x1FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x3FFCu, 0x1FFCu,  0u, 0u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* AB double small left chevron */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0x0E1Cu, 0x1C38u, 0x3870u, 0x3870u, 0x1C38u, 0x0E1Cu, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* AC Vertical left corner bracket */ {0u, 0u, 0u, 0u, 0u, 0x3FFCu, 0x3FFCu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* AD Small dash                */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0x07E0u, 0x07E0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* AE Registered trademark sign */ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x37CCu, 0x37ECu, 0x366Cu, 0x366Cu, 0x37CCu, 0x378Cu, 0x37CCu, 0x36ECu, 0x366Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u},
/* AF Macron                    */ {0u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* B0 Degree sign               */ {0x03C0u, 0x07E0u, 0x0E70u, 0x1C38u, 0x0E70u, 0x07E0u, 0x03C0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* B1 Plus or minus sign        */ {0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x3FFCu, 0x3FFCu, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* B2 Superscript 2             */ {0u, 0x0FC0u, 0x0FE0u, 0x0070u, 0x0070u, 0x03E0u, 0x07C0u, 0x0E00u, 0x0C00u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* B3 Superscript 3             */ {0u, 0x0FC0u, 0x0FE0u, 0x0070u, 0x0070u, 0x0FE0u, 0x0FE0u, 0x0070u, 0x0070u, 0x0FE0u, 0x0FC0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* B4 Superscript /             */ {0u, 0x0060u, 0x00E0u, 0x01C0u, 0x0380u, 0x0700u, 0x0600u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* B5 Greek mu (micro symbol)   */ {0u, 0u, 0u, 0u, 0u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x30F8u, 0x3FFCu, 0x3F8Cu, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0u},
/* B6 Pilcrow (Paragraph) sign  */ {0u, 0x0F8Cu, 0x1F8Cu, 0x398Cu, 0x318Cu, 0x318Cu, 0x398Cu, 0x1F8Cu, 0x0F8Cu, 0x018Cu, 0x018Cu, 0x018Cu, 0x018Cu, 0x018Cu, 0x018Cu, 0u, 0u, 0u, 0u, 0u},
/* B7 Centre dot                */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* B8 Small comma               */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0x0180u, 0x0180u, 0x0380u, 0x0700u, 0x0600u, 0u},
/* B9 Superscript 1             */ {0u, 0x0380u, 0x0780u, 0x0F80u, 0x0D80u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* BA o with underline          */ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* BB Double small right chevron */ {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0x3870u, 0x1C38u, 0x0E1Cu, 0x0E1cu, 0x1C38u, 0x3870u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* BC 1/4                       */ {0u, 0x1800u, 0x1800u, 0x1800u, 0x1800u, 0x1800u, 0x1800u, 0x1800u, 0x1800u, 0x1818u, 0x1838u, 0x00F8u, 0x0198u, 0x0318u, 0x0318u, 0x03F8u, 0x03F8u, 0x0018u, 0x0018, 0u},
/* BD 1/2                       */ {0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x31F0u, 0x31F8u, 0x000Cu, 0x000Cu, 0x0018u, 0x0070u, 0x00C0u, 0x0180u, 0x01FCu, 0x01FCu, 0u},
/* BE 3/4                       */ {0u, 0x3E00u, 0x3F00u, 0x0180u, 0x0180u, 0x3F00u, 0x3F00u, 0x0180u, 0x0180u, 0x3F0Cu, 0x3E1Cu, 0x007Cu, 0x00CCu, 0x018Cu, 0x018Cu, 0x01FCu, 0x01FCu, 0x000Cu, 0x000Cu, 0u},
/* BF Rotated ?                 */ {0u, 0u, 0u, 0u, 0u, 0x0180u, 0x0180u, 0u, 0u, 0x0180u, 0x0180u, 0x0380u, 0x0700u, 0x0E00u, 0x1C00u, 0x180Cu, 0x1C1Cu, 0x0FF8u, 0x07F0u, 0u},
/* C0 A with grave accent       */ {0x0600u, 0x0700u, 0x0380u, 0x0180u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* C1 A with acute accent       */ {0x0060u, 0x00E0u, 0x01C0u, 0x0180u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* C2 A with circonflexe accent */ {0x0180u, 0x03C0u, 0x07E0u, 0x0660u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* C3 A with tilde              */ {0x0718u, 0x0FB8u, 0x1DF0u, 0x18E0u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* C4 A with umlaut             */ {0x0C30u, 0x0C30u, 0x0C30u, 0u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* C5 A with ring               */ {0x0180u, 0x03C0u, 0x0660u, 0x0660u, 0x03C0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* C6 AE ligature               */ {0u, 0x0FFCu, 0x1FFCu, 0x3980u, 0x3180u, 0x3180u, 0x3180u, 0x3FF8u, 0x3FF8u, 0x3180u, 0x3180u, 0x3180u, 0x3180u, 0x31FCu, 0x31FCu, 0u, 0u, 0u, 0u, 0u},
/* C7 C with cedilla            */ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0x0180u, 0x0380u, 0x0700u, 0x0600u, 0u},
/* C8 E with grave accent       */ {0x0600u, 0x0700u, 0x0380u, 0x0180u, 0u, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3000u, 0x3FF0u, 0x3FF0u, 0x3000u, 0x3000u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* C9 E with acute accent       */ {0x0060u, 0x00E0u, 0x01C0u, 0x0180u, 0u, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3000u, 0x3FF0u, 0x3FF0u, 0x3000u, 0x3000u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* CA E with circonflexe accent */ {0x0180u, 0x03C0u, 0x07E0u, 0x0660u, 0u, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3000u, 0x3FF0u, 0x3FF0u, 0x3000u, 0x3000u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* CB E with umlaut             */ {0x0C30u, 0x0C30u, 0x0C30u, 0u, 0u, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3000u, 0x3FF0u, 0x3FF0u, 0x3000u, 0x3000u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* CC I with grave accent       */ {0x0600u, 0x0700u, 0x0380u, 0x0180u, 0u, 0x0FF0u, 0x0FF0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* CD I with acute accent       */ {0x0060u, 0x00E0u, 0x01C0u, 0x0180u, 0u, 0x0FF0u, 0x0FF0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* CE I with circonflexe accent */ {0x0180u, 0x03C0u, 0x07E0u, 0x0660u, 0u, 0x0FF0u, 0x0FF0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* CF I with umlaut             */ {0x0C30u, 0x0C30u, 0x0C30u, 0u, 0u, 0x0FF0u, 0x0FF0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* D0 Capital Eth (D with stroke) */ {0u, 0x0FF0u, 0x0FF8u, 0x0C1Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x3F8Cu, 0x3F8Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C1Cu, 0x0FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* D1 N with tilde              */ {0x0718u, 0x0FB8u, 0x1DF0u, 0x18E0u, 0u, 0x300Cu, 0x3C0Cu, 0x3E0Cu, 0x370Cu, 0x338Cu, 0x31CCu, 0x30ECu, 0x307Cu, 0x303Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* D2 O with grave accent       */ {0x0600u, 0x0700u, 0x0380u, 0x0180u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* D3 O with acute accent       */ {0x0060u, 0x00E0u, 0x01C0u, 0x0180u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* D4 O with circonflexe accent */ {0x0180u, 0x03C0u, 0x07E0u, 0x0660u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* D5 O with tilde              */ {0x0718u, 0x0FB8u, 0x1DF0u, 0x18E0u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* D6 O with umlaut             */ {0x0C30u, 0x0C30u, 0x0C30u, 0u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* D7 Multiply symbol (cross)   */ {0u, 0u, 0u, 0x1818u, 0x1C38u, 0x0E70u, 0x07E0u, 0x3C0u, 0x07E0u, 0x0E70u, 0x1C38u, 0x1818u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* D8 O with slash              */ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x303Cu, 0x307Cu, 0x30ECu, 0x31CCu, 0x338Cu, 0x370Cu, 0x3E0Cu, 0x3C0Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* D9 U with grave accent       */ {0x0600u, 0x0700u, 0x0380u, 0x0180u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* DA U with acute accent       */ {0x0060u, 0x00E0u, 0x01C0u, 0x0180u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* DB U with circonflexe accent */ {0x0180u, 0x03C0u, 0x07E0u, 0x0660u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* DC U with umlaut             */ {0x0C30u, 0x0C30u, 0x0C30u, 0u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* DD Y with acute accent       */ {0x0060u, 0x00E0u, 0x01C0u, 0x0180u, 0x300Cu, 0x381Cu, 0x1C38u, 0x0E70u, 0x07E0u, 0x03C0u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* DE Capital Thorn             */ {0u, 0x3000u, 0x3000u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x3FF8u, 0x3FF0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0u, 0u, 0u, 0u, 0u},
/* DF Sharp S ("Beta S")        */ {0u, 0x0FC0u, 0x1FE0u, 0x3870u, 0x3030u, 0x3030u, 0x3030u, 0x31F0u, 0x31F8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x31F8u, 0x31F0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0u},
/* E0 a with grave accent       */ {0x0600u, 0x0700u, 0x0380u, 0x0180u, 0u, 0x0FF0u, 0x0FF8u, 0x001Cu, 0x000Cu, 0x0FFCu, 0x1FFCu, 0x380Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* E1 a with acute accent       */ {0x0060u, 0x00E0u, 0x01C0u, 0x0180u, 0u, 0x0FF0u, 0x0FF8u, 0x001Cu, 0x000Cu, 0x0FFCu, 0x1FFCu, 0x380Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* E2 a with circonflexe accent */ {0x0180u, 0x03C0u, 0x07E0u, 0x0660u, 0u, 0x0FF0u, 0x0FF8u, 0x001Cu, 0x000Cu, 0x0FFCu, 0x1FFCu, 0x380Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* E3 a with tilde              */ {0x0718u, 0x0FB8u, 0x1DF0u, 0x18E0u, 0u, 0x0FF0u, 0x0FF8u, 0x001Cu, 0x000Cu, 0x0FFCu, 0x1FFCu, 0x380Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* E4 a with umlaut             */ {0u, 0x0C30u, 0x0C30u, 0x0C30u, 0u, 0x0FF0u, 0x0FF8u, 0x001Cu, 0x000Cu, 0x0FFCu, 0x1FFCu, 0x380Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* E5 a with ring               */ {0x0180u, 0x03C0u, 0x0660u, 0x03C0u, 0x0180u, 0x0FF0u, 0x0FF8u, 0x001Cu, 0x000Cu, 0x0FFCu, 0x1FFCu, 0x380Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* E6 ae ligature               */ {0u, 0u, 0u, 0u, 0u, 0x1E78u, 0x1FFCu, 0x038Cu, 0x018Cu, 0x1FFCu, 0x3FFCu, 0x3180u, 0x3180u, 0x3FF8u, 0x1FF8u, 0u, 0u, 0u, 0u, 0u},
/* E7 c with cedilla            */ {0u, 0u, 0u, 0u, 0u, 0x0FFCu, 0x1FFCu, 0x3800u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3800u, 0x1FFCu, 0x0FFCu, 0x00C0u, 0x01C0u, 0x0380u, 0x0300u, 0u},
/* E8 e with grave accent       */ {0x0600u, 0x0700u, 0x0380u, 0x0180u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3800u, 0x1FF8u, 0x0FF8u, 0u, 0u, 0u, 0u, 0u},
/* E9 e with acute accent       */ {0x0060u, 0x00E0u, 0x01C0u, 0x0180u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3800u, 0x1FF8u, 0x0FF8u, 0u, 0u, 0u, 0u, 0u},
/* EA e with circonflexe accent */ {0x0180u, 0x03C0u, 0x07E0u, 0x0660u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3800u, 0x1FF8u, 0x0FF8u, 0u, 0u, 0u, 0u, 0u},
/* EB e with umlaut             */ {0u, 0x0C30u, 0x0C30u, 0x0C30u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3800u, 0x1FF8u, 0x0FF8u, 0u, 0u, 0u, 0u, 0u},
/* EC i with grave accent       */ {0x0600u, 0x0700u, 0x0380u, 0x0180u, 0u, 0x0F80u, 0x0F80u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* ED i with acute accent       */ {0x0060u, 0x00E0u, 0x01C0u, 0x0180u, 0u, 0x0F80u, 0x0F80u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* EE i with circonflexe accent */ {0x0180u, 0x03C0u, 0x07E0u, 0x0660u, 0u, 0x0F80u, 0x0F80u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* EF i with umlaut             */ {0u, 0x0C30u, 0x0C30u, 0x0C30u, 0u, 0x0F80u, 0x0F80u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0FF0u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* F0 Lowercase eth (curved d with stroke) */ {0u, 0x1E60u, 0x1FE0u, 0x03C0u, 0x07E0u, 0x0E70u, 0x0C38u, 0x001Cu, 0x000Cu, 0x0FFCu, 0x1FFCu, 0x381Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* F1 n with tilde              */ {0x0718u, 0x0FB8u, 0x1DF0u, 0x18E0u, 0u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* F2 o with grave accent       */ {0x0600u, 0x0700u, 0x0380u, 0x0180u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* F3 o with acute accent       */ {0x0060u, 0x00E0u, 0x01C0u, 0x0180u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* F4 o with circonflexe accent */ {0x0180u, 0x03C0u, 0x07E0u, 0x0660u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* F5 o with tilde              */ {0x0718u, 0x0FB8u, 0x1DF0u, 0x18E0u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* F6 o with umlaut             */ {0u, 0x0C30u, 0x0C30u, 0x0C30u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* F7 Divide symbol             */ {0u, 0u, 0u, 0x0180u, 0x0180u, 0u, 0u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u, 0u, 0u},
/* F8 o with slash              */ {0u, 0u, 0u, 0u, 0u, 0x0FF0u, 0x1FF8u, 0x387Cu, 0x30ECu, 0x31CCu, 0x338Cu, 0x370Cu, 0x3E1Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* F9 u with grave accent       */ {0x0600u, 0x0700u, 0x0380u, 0x0180u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* FA u with acute accent       */ {0x0060u, 0x00E0u, 0x01C0u, 0x0180u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* FB u with circonflexe accent */ {0x0180u, 0x03C0u, 0x07E0u, 0x0660u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* FC u with umlaut             */ {0u, 0x0C30u, 0x0C30u, 0x0C30u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* FD y with acute accent       */ {0x0060u, 0x00E0u, 0x01C0u, 0x0180u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0x000Cu, 0x001Cu, 0x0FF8u, 0x0FF0u, 0u},
/* FE Lowercase Thorn           */ {0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x3FF8u, 0x3FF0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0u},
/* FF y with umlaut             */ {0u, 0x0C30u, 0x0C30u, 0x0C30u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0x000Cu, 0x001Cu, 0x0FF8u, 0x0FF0u, 0u}}, /* End of block 1 */
{ /* Start of Block 2 */
/* Cyrillic characters, on SAA5057 maps &00-&3E to 0xC0 to 0xFE, and &3F to &A6. */
/* 00*/ {0u, 0x3060u, 0x30F0u, 0x31F8u, 0x339Cu, 0x330Cu, 0x330Cu, 0x3F0Cu, 0x3F0Cu, 0x330Cu, 0x330Cu, 0x339Cu, 0x31F8u, 0x30F0u, 0x3060u, 0u, 0u, 0u, 0u, 0u},
/* 01*/ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 02*/ {0u, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 03*/ {0u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3FFcu, 0x3FFCu, 0x000Cu, 0x000Cu, 0u, 0u, 0u},
/* 04*/ {0u, 0x01E0u, 0x03E0u, 0x0760u, 0x0660u, 0x0660u, 0x0660u, 0x0660u, 0x0660u, 0x0660u, 0x0660u, 0x0660u, 0x0660u, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0u, 0u, 0u},
/* 05*/ {0u, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3FF0u, 0x3FF0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 06*/ {0u, 0x0180u, 0x0180u, 0x3FFCu, 0x3FFCu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x3FFCu, 0x3FFCu, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* 07*/ {0u, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0u, 0u, 0u, 0u, 0u},
/* 08*/ {0u, 0x300Cu, 0x300Cu, 0x381Cu, 0x1C38u, 0x0E70u, 0x07E0u, 0x03C0u, 0x03C0u, 0x07E0u, 0x0E70u, 0x1C38u, 0x381Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 09*/ {0u, 0x300Cu, 0x300Cu, 0x301Cu, 0x303Cu, 0x307Cu, 0x30ECu, 0x31CCu, 0x338Cu, 0x370Cu, 0x3E0Cu, 0x3C0Cu, 0x380Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 0A*/ {0u, 0x318Cu, 0x318Cu, 0x301Cu, 0x303Cu, 0x307Cu, 0x30ECu, 0x31CCu, 0x338Cu, 0x370Cu, 0x3E0Cu, 0x3C0Cu, 0x380Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 0B*/ {0u, 0x1818u, 0x1838u, 0x1870u, 0x18E0u, 0x19C0u, 0x1B80u, 0x1F00u, 0x1F00u, 0x1B80u, 0x19C0u, 0x18E0u, 0x1870u, 0x1838u, 0x1818u, 0u, 0u, 0u, 0u, 0u},
/* 0C*/ {0u, 0x03FCu, 0x07FCu, 0x0E0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x3C0Cu, 0x3C0Cu, 0u, 0u, 0u, 0u, 0u},
/* 0D*/ {0u, 0x300Cu, 0x300Cu, 0x381Cu, 0x3C3Cu, 0x3E7Cu, 0x37ECu, 0x33CCu, 0x318Cu, 0x318Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 0E*/ {0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 0F*/ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* 10*/ {0u, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 11*/ {0u, 0x0FFCu, 0x1FFCu, 0x380Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0x038Cu, 0x070Cu, 0x0E0Cu, 0x1C0Cu, 0x380Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 12*/ {0u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x3FF8u, 0x3FF0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0u, 0u, 0u, 0u, 0u},
/* 13*/ {0u, 0xFF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x300Cu, 0x381Cu, 0x1FF8u, 0xFF0u, 0u, 0u, 0u, 0u, 0u},
/* 14*/ {0u, 0x3FFCu, 0x3FFCu, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* 15*/ {0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 16*/ {0u, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x1998u, 0x0FF0u, 0x0FF0u, 0x1998u, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0u, 0u, 0u, 0u, 0u},
/* 17*/ {0u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x3FF8u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x3FF8u, 0x3FF0u, 0u, 0u, 0u, 0u, 0u},
/* 18*/ {0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 19*/ {0u, 0x3C00u, 0x3C00u, 0x0C00u, 0x0C00u, 0x0C00u, 0x0C00u, 0x0FFCu, 0x0FFCu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0FFCu, 0x0FFCu, 0u, 0u, 0u, 0u, 0u},
/* 1A*/ {0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x301Cu, 0x000Cu, 0x001Cu, 0x03F8u, 0x03F8u, 0x001Cu, 0x000Cu, 0x301Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* 1B*/ {0u, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 1C*/ {0u, 0x0F00u, 0x1FC0u, 0x38E0u, 0x2070u, 0x0038u, 0x001Cu, 0x03FCu, 0x03FCu, 0x001Cu, 0x0038u, 0x2070u, 0x38E0u, 0x1FC0u, 0x0F00u, 0u, 0u, 0u, 0u, 0u},
/* 1D*/ {0u, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x3FFCu, 0x3FFCu, 0x000Cu, 0x000Cu, 0u, 0u, 0u},
/* 1E*/ {0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0x000Cu, 0u, 0u, 0u, 0u, 0u},
/* 1F*/ {0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x3F8Cu, 0x3F8Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x3F8Cu, 0x3F8Cu, 0u, 0u, 0u, 0u, 0u},
/* 20*/ {0u, 0u, 0u, 0u, 0u, 0x3060u, 0x30F0u, 0x31F8u, 0x339Cu, 0x3F0Cu, 0x3F0Cu, 0x339Cu, 0x31F8u, 0x30F0u, 0x3060u, 0u, 0u, 0u, 0u, 0u},
/* 21*/ {0u, 0u, 0u, 0u, 0u, 0x1FF0u, 0x1FF8u, 0x001Cu, 0x000Cu, 0x1FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x3FFCu, 0x1FFCu, 0u, 0u, 0u, 0u, 0u},
/* 22*/ {0u, 0x07E0u, 0x1FE0u, 0x3800u, 0x3000u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x3FF8u, 0x3FF0u, 0u, 0u, 0u, 0u, 0u},
/* 23*/ {0u, 0u, 0u, 0u, 0u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3060u, 0x3FFCu, 0x3FFCu, 0x000Cu, 0x000Cu, 0u, 0u, 0u},
/* 24*/ {0u, 0u, 0u, 0u, 0u, 0x01E0u, 0x03E0u, 0x0760u, 0x0660u, 0x0660u, 0x0660u, 0x0660u, 0x0660u, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0u, 0u, 0u},
/* 25*/ {0u, 0u, 0u, 0u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3800u, 0x1FF8u, 0x0FF8u, 0u, 0u, 0u, 0u, 0u},
/* 26*/ {0u, 0u, 0u, 0x0180u, 0x0180u, 0x07E0u, 0x1FF8u, 0x399Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x399Cu, 0x1FF8u, 0x07E0u, 0x0180u, 0x0180u, 0u, 0u, 0u},
/* 27*/ {0u, 0u, 0u, 0u, 0u, 0x3FFCu, 0x3FFCu, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0u, 0u, 0u, 0u, 0u},
/* 28*/ {0u, 0u, 0u, 0u, 0u, 0x300Cu, 0x381Cu, 0x1E78u, 0x0FF0u, 0x03C0u, 0x03C0u, 0x0FF0u, 0x1E78u, 0x381Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 29*/ {0u, 0u, 0u, 0u, 0u, 0x300Cu, 0x303Cu, 0x307Cu, 0x30ECu, 0x31CCu, 0x338Cu, 0x370Cu, 0x3E0Cu, 0x3C0Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 2A*/ {0u, 0u, 0u, 0x0180u, 0x0180u, 0x300Cu, 0x303Cu, 0x307Cu, 0x30ECu, 0x31CCu, 0x338Cu, 0x370Cu, 0x3E0Cu, 0x3C0Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 2B*/ {0u, 0u, 0u, 0u, 0u, 0x300Cu, 0x303Cu, 0x3070u, 0x30E0u, 0x3FC0u, 0x3FC0u, 0x30E0u, 0x3070u, 0x303Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 2C*/ {0u, 0u, 0u, 0u, 0u, 0x03FCu, 0x07FCu, 0x0E0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x0C0Cu, 0x3C0Cu, 0x3C0Cu, 0u, 0u, 0u, 0u, 0u},
/* 2D*/ {0u, 0u, 0u, 0u, 0u, 0x300Cu, 0x381Cu, 0x3C3Cu, 0x3E7Cu, 0x37ECu, 0x33CCu, 0x318Cu, 0x318Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 2E*/ {0u, 0u, 0u, 0u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 2F*/ {0u, 0u, 0u, 0u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* 30*/ {0u, 0u, 0u, 0u, 0u, 0x3FFCu, 0x3FFCu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0u, 0u, 0u, 0u, 0u},
/* 31*/ {0u, 0u, 0u, 0u, 0u, 0x0FFCu, 0x1FFCu, 0x380Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0x038Cu, 0x070Cu, 0x1E0Cu, 0x3C0Cu, 0u, 0u, 0u, 0u, 0u},
/* 32*/ {0u, 0u, 0u, 0u, 0u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x301Cu, 0x3FF8u, 0x3FF0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0u},
/* 33*/ {0u, 0u, 0u, 0u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x300Cu, 0x3000u, 0x3000u, 0x300Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* 34*/ {0u, 0u, 0u, 0u, 0u, 0x3FFCu, 0x3FFCu, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0x0180u, 0u, 0u, 0u, 0u, 0u},
/* 35*/ {0u, 0u, 0u, 0u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0x000Cu, 0x001Cu, 0x0FF8u, 0x0FF0u, 0u},
/* 36*/ {0u, 0u, 0u, 0u, 0u, 0x318Cu, 0x318Cu, 0x318Cu, 0x1998u, 0x0FF0u, 0x0FF0u, 0x1998u, 0x318Cu, 0x318Cu, 0x318Cu, 0u, 0u, 0u, 0u, 0u},
/* 37*/ {0u, 0u, 0u, 0u, 0u, 0x3FF0u, 0x3FF8u, 0x301Cu, 0x301Cu, 0x3FF8u, 0x3FF8u, 0x301Cu, 0x301Cu, 0x3FF8u, 0x3FF0u, 0u, 0u, 0u, 0u, 0u},
/* 38*/ {0u, 0u, 0u, 0u, 0u, 0x3000u, 0x3000u, 0x3000u, 0x3000u, 0x3FF0u, 0x3FF8u, 0x300Cu, 0x300Cu, 0x3FF8u, 0x3FF0u, 0u, 0u, 0u, 0u, 0u},
/* 39*/ {0u, 0u, 0u, 0u, 0u, 0x3C00u, 0x3C00u, 0x0C00u, 0x0C00u, 0x0FF0u, 0x0FF8u, 0x0C0Cu, 0x0C0Cu, 0x0FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* 3A*/ {0u, 0u, 0u, 0u, 0u, 0x0FF0u, 0x1FF8u, 0x381Cu, 0x301Cu, 0x03F8u, 0x03F8u, 0x301Cu, 0x381Cu, 0x1FF8u, 0x0FF0u, 0u, 0u, 0u, 0u, 0u},
/* 3B*/ {0u, 0u, 0u, 0u, 0u, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x3FFCu, 0x3FFCu, 0u, 0u, 0u, 0u, 0u},
/* 3C*/ {0u, 0u, 0u, 0u, 0u, 0x0F00u, 0x1FC0u, 0x38E0u, 0x2070u, 0x03F0u, 0x03F0u, 0x2070u, 0x38E0u, 0x1FC0u, 0x0F00u, 0u, 0u, 0u, 0u, 0u},
/* 3D*/ {0u, 0u, 0u, 0u, 0u, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x318Cu, 0x3FFCu, 0x3FFCu, 0x000Cu, 0x000Cu, 0u, 0u, 0u},
/* 3E*/ {0u, 0u, 0u, 0u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x380Cu, 0x1FFCu, 0x0FFCu, 0x000Cu, 0x000Cu, 0u, 0u, 0u, 0u, 0u},
/* 3F*/ {0u, 0u, 0u, 0u, 0u, 0x300Cu, 0x300Cu, 0x300Cu, 0x300Cu, 0x3F8Cu, 0x3F8Cu, 0x318Cu, 0x318Cu, 0x3F8Cu, 0x3F8Cu, 0u, 0u, 0u, 0u, 0u},

} /* End of block 2 */
};


#endif
