unit EOTButton;

interface

uses
  ButtonBase, Classes, SysUtils, Graphics, LCLIntf, LCLType;

const
  eotBlinkOff   = -1;
  eotCancel     =  0;
  eotGray       =  1;
  eotBlinkOn    =  2;
  eotBackToNego =  3;

type
  // EndOfTurn button
  TEOTButton = class (TButtonBase)
  private
    FTemplate: TBitmap;

  protected
    Buffer, Back: TBitmap;
    procedure Paint; override;
    procedure CheckGlyph;  override;

  public
    constructor Create (aOwner: TComponent); override;
    destructor Destroy; override;
    procedure SetBack (ca: TCanvas; X, Y: integer);
    property Template: TBitmap read FTemplate write FTemplate;

  published
    property Visible;
    property OnClick;

  end;

procedure Register;


implementation

uses
  ScreenTools;

procedure Register;
begin
  RegisterComponents('C-evo', [TEOTButton]);
end;

constructor TEOTButton.Create;
begin
  inherited;
  Buffer := TBitmap.Create;
  Back   := TBitmap.Create;
  Buffer.PixelFormat := pf24bit;
  Back.PixelFormat   := pf24bit;
  Buffer.SetSize (48, 48);
  Back.SetSize   (48, 48);

  Buffer.Canvas.FillRect (0, 0, Buffer.Width, Buffer.Height);
  Back.Canvas.FillRect   (0, 0, Back.Width,   Back.Height);

  ShowHint := true;
  SetBounds (0, 0, 48, 48);
end;

destructor TEOTButton.Destroy;
begin
  FreeAndNil (Buffer);
  FreeAndNil (Back);
  inherited;
end;

procedure TEOTButton.Paint;
begin
  with Canvas do
    if GetGraphic <> nil then
    begin
      UnshareBitmap (Buffer);
      BitBltCanvas (Buffer.Canvas, 0, 0, 48, 48, Back.Canvas, 0, 0);
      ImageOp_CBC (Buffer, Template, 0, 0, 133, 149 + 48 * Byte(Down), 48, 48, clBlack, clWhite);
      if ButtonIndex >= 0 then
        ImageOp_CBC (Buffer, Template, 8, 8, 1 + 32 * Byte(ButtonIndex), 246, 32, 32, clBlack, clWhite);
      BitBltCanvas (Canvas, 0, 0, 48, 48, Buffer.Canvas, 0, 0);
    end
    else
    begin
      Brush.Color := clRed;
      FrameRect (Rect(0, 0, 48, 48))
    end;
end;

procedure TEOTButton.CheckGlyph;
begin
    // Paint used for this button
    Invalidate;
end;

procedure TEOTButton.SetBack (Ca: TCanvas; X, Y: integer);
begin
  BitBltCanvas (Back.Canvas, 0, 0, 48, 48, Ca, X, Y);
end;

end.
