set("${CMAKE_FIND_PACKAGE_NAME}_VERSION" "1.2")

if (${CMAKE_FIND_PACKAGE_NAME}_FIND_VERSION_EXACT AND
    NOT ${CMAKE_FIND_PACKAGE_NAME}_VERSION VERSION_EQUAL ${CMAKE_FIND_PACKAGE_NAME}_FIND_VERSION)
  set("${CMAKE_FIND_PACKAGE_NAME}_FOUND" 0)
  set("${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE"
    "Not an EXACT version match")
elseif (DEFINED ${CMAKE_FIND_PACKAGE_NAME}_FIND_VERSION_RANGE AND
        (${CMAKE_FIND_PACKAGE_NAME}_VERSION VERSION_LESS ${CMAKE_FIND_PACKAGE_NAME}_FIND_VERSION_MIN OR
         (${CMAKE_FIND_PACKAGE_NAME}_FIND_VERSION_RANGE_MAX STREQUAL "EXCLUDE" AND
          ${CMAKE_FIND_PACKAGE_NAME}_VERSION VERSION_GREATER_EQUAL ${CMAKE_FIND_PACKAGE_NAME}_FIND_VERSION_MAX) OR
         (${CMAKE_FIND_PACKAGE_NAME}_FIND_VERSION_RANGE_MAX STREQUAL "INCLUDE" AND
          ${CMAKE_FIND_PACKAGE_NAME}_VERSION VERSION_GREATER ${CMAKE_FIND_PACKAGE_NAME}_FIND_VERSION_MAX)))
  set("${CMAKE_FIND_PACKAGE_NAME}_FOUND" 0)
  set("${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE"
    "Out-of-range version request")
elseif (DEFINED ${CMAKE_FIND_PACKAGE_NAME}_FIND_VERSION AND
        ${CMAKE_FIND_PACKAGE_NAME}_VERSION VERSION_LESS ${CMAKE_FIND_PACKAGE_NAME}_FIND_VERSION)
  set("${CMAKE_FIND_PACKAGE_NAME}_FOUND" 0)
  set("${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE"
    "Insufficient version")
else ()
  set("${CMAKE_FIND_PACKAGE_NAME}_FOUND" 1)
endif ()
