/* SPDX-License-Identifier: GPL-2.0-or-later */

#include <gpio.h>
#include <soc/gpio.h>
#include <soc/ramstage.h>

/*
 * Pad configuration was derived from schematics, revision 0.1
 * - https://wiki.odroid.com/odroid-h4/hardware#odroid-h4_schematics
 */
static const struct pad_config gpio_table[] = {

	/* ------- GPIO Group GPP_A ------- */
	PAD_CFG_NF(GPP_A0, NONE, DEEP, NF1),	/* ESPI_IO0 */
	PAD_CFG_NF(GPP_A1, NONE, DEEP, NF1),	/* ESPI_IO1 */
	PAD_CFG_NF(GPP_A2, NONE, DEEP, NF1),	/* ESPI_IO2 */
	PAD_CFG_NF(GPP_A3, NONE, DEEP, NF1),	/* ESPI_IO3 */
	PAD_CFG_NF(GPP_A4, NONE, DEEP, NF1),	/* ESPI_CS# */
	PAD_CFG_NF(GPP_A5, NONE, DEEP, NF1),	/* ESPI_ALERT# */
	PAD_NC(GPP_A6, NONE),
	PAD_NC(GPP_A7, NONE),
	PAD_CFG_GPO(GPP_A8, 1, PLTRST),		/* LAN_DISABLE# */
	PAD_CFG_NF(GPP_A9, NONE, DEEP, NF1),	/* ESPI_CLK */
	PAD_CFG_NF(GPP_A10, NONE, DEEP, NF1),	/* ESPI_RESET# */
	PAD_NC(GPP_A11, NONE),
	PAD_CFG_NF(GPP_A12, NONE, DEEP, NF1),	/* M.2_SSD_PEDET_R */
	PAD_NC(GPP_A13, NONE),
	PAD_NC(GPP_A14, NONE),
	PAD_NC(GPP_A15, NONE),
	PAD_NC(GPP_A16, NONE),
	PAD_NC(GPP_A17, NONE),
	PAD_CFG_NF(GPP_A18, NONE, DEEP, NF1),	/* DDI1_HPD */
	PAD_CFG_NF(GPP_A19, NONE, DEEP, NF1),	/* TCP0_HPD */
	PAD_NC(GPP_A20, NONE),
	PAD_NC(GPP_A21, NONE),
	PAD_NC(GPP_A22, NONE),
	PAD_NC(GPP_A23, NONE),

	/* ------- GPIO Group GPP_B ------- */
	PAD_CFG_NF(GPP_B0, NONE, DEEP, NF1),	/* CORE_VID0 */
	PAD_CFG_NF(GPP_B1, NONE, DEEP, NF1),	/* CORE_VID1 */
	PAD_CFG_NF(GPP_B2, NONE, PLTRST, NF1),	/* VRALERT# */
	PAD_NC(GPP_B3, NONE),
	PAD_NC(GPP_B4, NONE),
	PAD_NC(GPP_B5, NONE),
	PAD_NC(GPP_B6, NONE),
	PAD_NC(GPP_B7, NONE),
	PAD_CFG_GPI(GPP_B8, NONE, DEEP),	/* EMMC_DET#_L */
	PAD_CFG_NF(GPP_B11, NONE, DEEP, NF1),	/* PMCALERT# */
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),	/* SLP_S0# */
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),	/* PM_PLTRST_N */
	PAD_CFG_NF(GPP_B14, NONE, PLTRST, NF4),	/* PCH_SATA_LED# */
	PAD_NC(GPP_B15, NONE),
	PAD_NC(GPP_B16, NONE),
	PAD_NC(GPP_B17, NONE),
	PAD_NC(GPP_B18, NONE),
	PAD_NC(GPP_B23, NONE),

	/* ------- GPIO Group GPP_C ------- */
	PAD_CFG_NF(GPP_C0, NONE, DEEP, NF1),	/* SMB_CLK */
	PAD_CFG_NF(GPP_C1, NONE, DEEP, NF1),	/* SMB_DATA */
	PAD_CFG_NF(GPP_C2, NONE, DEEP, NF1),	/* SMB_ALERT# */
	PAD_NC(GPP_C3, NONE),
	PAD_NC(GPP_C4, NONE),
	PAD_NC(GPP_C5, NONE),
	PAD_NC(GPP_C6, NONE),
	PAD_NC(GPP_C7, NONE),

	/* ------- GPIO Group GPP_D ------- */
	PAD_NC(GPP_D0, NONE),
	PAD_NC(GPP_D1, NONE),
	PAD_NC(GPP_D2, NONE),
	PAD_NC(GPP_D3, NONE),
	PAD_NC(GPP_D4, NONE),
	PAD_CFG_NF(GPP_D5, NONE, DEEP, NF1),	/* PCIE_CLKREQ0_N */
	PAD_CFG_NF(GPP_D6, NONE, DEEP, NF1),	/* PCIE_CLKREQ1_N */
	PAD_CFG_NF(GPP_D7, NONE, DEEP, NF1),	/* PCIE_CLKREQ2_N */
	PAD_CFG_NF(GPP_D8, NONE, DEEP, NF1),	/* CLKREQ3# but always asserted */
	PAD_NC(GPP_D9, NONE),
	PAD_NC(GPP_D10, NONE),
	PAD_NC(GPP_D11, NONE),
	PAD_NC(GPP_D11, NONE),
	PAD_NC(GPP_D13, NONE),
	PAD_NC(GPP_D14, NONE),
	PAD_NC(GPP_D15, NONE),
	PAD_NC(GPP_D16, NONE),
	PAD_NC(GPP_D17, NONE),
	PAD_NC(GPP_D18, NONE),
	PAD_NC(GPP_D19, NONE),

	/* ------- GPIO Group GPP_E ------- */
	PAD_NC(GPP_E0, NONE),
	PAD_NC(GPP_E1, NONE),
	PAD_NC(GPP_E2, NONE),
	PAD_NC(GPP_E3, NONE),
	PAD_NC(GPP_E4, NONE),
	PAD_NC(GPP_E5, NONE),
	PAD_NC(GPP_E6, NONE),
	PAD_NC(GPP_E7, NONE),
	PAD_NC(GPP_E8, NONE),
	PAD_NC(GPP_E9, NONE),
	PAD_NC(GPP_E10, NONE),
	PAD_NC(GPP_E11, NONE),
	PAD_NC(GPP_E12, NONE),
	PAD_NC(GPP_E13, NONE),
	PAD_CFG_NF(GPP_E14, NONE, DEEP, NF1),	/* DDI0_HPD */
	PAD_NC(GPP_E15, NONE),
	PAD_NC(GPP_E16, NONE),			/* Unknown, goes to M.2 pin 67 (NC) */
	PAD_NC(GPP_E17, NONE),
	PAD_CFG_NF(GPP_E18, NONE, DEEP, NF1),	/* TCP0_DDCCLK */
	PAD_CFG_NF(GPP_E19, NONE, DEEP, NF1),	/* TCP0_DDCDATA */
	PAD_NC(GPP_E20, NONE),
	PAD_NC(GPP_E21, NONE),
	PAD_CFG_NF(GPP_E22, NONE, DEEP, NF1),	/* DDI0_DDCCLK */
	PAD_CFG_NF(GPP_E23, NONE, DEEP, NF1),	/* DDI0_DDCDATA */

	/* ------- GPIO Group GPP_F ------- */
	PAD_NC(GPP_F0, NONE),
	PAD_NC(GPP_F1, NONE),
	PAD_NC(GPP_F2, NONE),
	PAD_NC(GPP_F3, NONE),
	PAD_NC(GPP_F4, NONE),
	PAD_NC(GPP_F5, NONE),
	PAD_NC(GPP_F6, NONE),
	PAD_NC(GPP_F7, NONE),
	PAD_NC(GPP_F10, NONE),
	PAD_NC(GPP_F11, NONE),
	PAD_NC(GPP_F12, NONE),
	PAD_NC(GPP_F13, NONE),
	PAD_NC(GPP_F14, NONE),
	PAD_NC(GPP_F15, NONE),
	PAD_NC(GPP_F16, NONE),
	PAD_NC(GPP_F17, NONE),
	PAD_NC(GPP_F18, NONE),
	PAD_NC(GPP_F22, NONE),
	PAD_NC(GPP_F23, NONE),

	/* ------- GPIO Group GPP_H ------- */
	PAD_NC(GPP_H0, NONE),
	PAD_NC(GPP_H1, NONE),
	PAD_NC(GPP_H2, NONE),
	PAD_NC(GPP_H3, NONE),
	PAD_CFG_NF(GPP_H4, NONE, DEEP, NF1),	/* I2C_0_SDA */
	PAD_CFG_NF(GPP_H5, NONE, DEEP, NF1),	/* I2C_0_SCL */
	PAD_CFG_NF(GPP_H6, NONE, DEEP, NF1),	/* I2C_1_SDA */
	PAD_CFG_NF(GPP_H7, NONE, DEEP, NF1),	/* I2C_1_SCL */
	PAD_NC(GPP_H8, NONE),
	PAD_NC(GPP_H9, NONE),
	PAD_NC(GPP_H10, NONE),
	PAD_NC(GPP_H11, NONE),
	PAD_NC(GPP_H12, NONE),
	PAD_NC(GPP_H13, NONE),
	PAD_CFG_NF(GPP_H15, NONE, DEEP, NF1),	/* DDI1_DDCCLK */
	PAD_CFG_NF(GPP_H17, NONE, DEEP, NF1),	/* DDI1_DDCDATA */
	PAD_NC(GPP_H18, NONE),
	PAD_NC(GPP_H19, NONE),
	PAD_NC(GPP_H20, NONE),
	PAD_NC(GPP_H21, NONE),
	PAD_NC(GPP_H22, NONE),
	PAD_NC(GPP_H23, NONE),

	/* ------- GPIO Group GPP_I ------- */
	PAD_NC(GPP_I5, NONE),
	PAD_CFG_NF(GPP_I7, NONE, DEEP, NF1),	/* EMMC_CMD */
	PAD_CFG_NF(GPP_I8, NONE, DEEP, NF1),	/* EMMC_DATA_0 */
	PAD_CFG_NF(GPP_I9, NONE, DEEP, NF1),	/* EMMC_DATA_1 */
	PAD_CFG_NF(GPP_I10, NONE, DEEP, NF1),	/* EMMC_DATA_2 */
	PAD_CFG_NF(GPP_I11, NONE, DEEP, NF1),	/* EMMC_DATA_3 */
	PAD_CFG_NF(GPP_I12, NONE, DEEP, NF1),	/* EMMC_DATA_4 */
	PAD_CFG_NF(GPP_I13, NONE, DEEP, NF1),	/* EMMC_DATA_5 */
	PAD_CFG_NF(GPP_I14, NONE, DEEP, NF1),	/* EMMC_DATA_6 */
	PAD_CFG_NF(GPP_I15, NONE, DEEP, NF1),	/* EMMC_DATA_7 */
	PAD_CFG_NF(GPP_I16, NONE, DEEP, NF1),	/* EMMC_RCLK */
	PAD_CFG_NF(GPP_I17, NONE, DEEP, NF1),	/* EMMC_CLK */
	PAD_CFG_NF(GPP_I18, NONE, DEEP, NF1),	/* EMMC_RESET# */

	/* ------- GPIO Group GPP_R ------- */
	PAD_CFG_NF(GPP_R0, NONE, DEEP, NF1),	/* HDA_BCLK_R */
	PAD_CFG_NF(GPP_R1, NATIVE, DEEP, NF1),	/* HDA_SYNC_R */
	PAD_CFG_NF(GPP_R2, NONE, DEEP, NF1),	/* HDA_SDO_R */
	PAD_CFG_NF(GPP_R3, NATIVE, DEEP, NF1),	/* HDA_SDI_R */
	PAD_CFG_NF(GPP_R4, NATIVE, DEEP, NF1),	/* HDA_RST_N */
	PAD_NC(GPP_R5, NONE),
	PAD_NC(GPP_R6, NONE),
	PAD_NC(GPP_R7, NONE),

	/* ------- GPIO Group GPP_S ------- */
	PAD_NC(GPP_S0, NONE),
	PAD_NC(GPP_S1, NONE),
	PAD_NC(GPP_S2, NONE),
	PAD_NC(GPP_S3, NONE),
	PAD_NC(GPP_S4, NONE),
	PAD_NC(GPP_S5, NONE),
	PAD_NC(GPP_S6, NONE),
	PAD_NC(GPP_S7, NONE),

	/* ------- GPIO Group GPP_GPD ------- */
	PAD_CFG_NF(GPD0, NONE, PWROK, NF1),	/* BATLOW# */
	PAD_CFG_NF(GPD1, NONE, PWROK, NF1),	/* ACPRESENT */
	PAD_NC(GPD2, NONE),
	PAD_CFG_NF(GPD3, NONE, PWROK, NF1),	/* PM_PWRBTN# */
	PAD_CFG_NF(GPD4, NONE, PWROK, NF1),	/* SLP_S3# */
	PAD_CFG_NF(GPD5, NONE, PWROK, NF1),	/* SLP_S4# */
	PAD_CFG_NF(GPD6, NONE, PWROK, NF1),	/* SLP_A# */
	PAD_NC(GPD7, NONE),
	PAD_CFG_NF(GPD8, NONE, PWROK, NF1),	/* SUSCLK */
	PAD_CFG_NF(GPD9, NONE, PWROK, NF1),	/* SLP_WLAN# */
	PAD_CFG_NF(GPD10, NONE, PWROK, NF1),	/* SLP_S5# */
	PAD_NC(GPD11, NONE),
};

static void mainboard_init(void *chip_info)
{
	gpio_configure_pads(gpio_table, ARRAY_SIZE(gpio_table));
}

struct chip_operations mainboard_ops = {
	.init = mainboard_init,
};
