/** @file

Copyright (c) 2024, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef _FSP_EXT_GLOBALS_
#define _FSP_EXT_GLOBALS_

#define FSP_MAX_SOCKET                      MAX_SOCKET
#define FSP_MAX_IMC                         MAX_IMC
#define FSP_MAX_MC_CH                       MAX_MC_CH
#define FSP_MAX_DIMM                        MAX_DIMM
#define FSP_DIMM_MAX_SERIALNUMBER_LEN       NGN_MAX_SERIALNUMBER_STRLEN
#define FSP_DIMM_MAX_PARTNUMBER_LEN         NGN_MAX_PARTNUMBER_STRLEN
#define FSP_MAX_CH                          ((FSP_MAX_IMC)*(FSP_MAX_MC_CH))
#define FSP_MAX_MEMORY_MAP_ELEMENTS         150

#define MEM_64MB_TO_BYTES(Size64M)          ((UINT64)(Size64M) << 26)
#define MEM_64MB_TO_KBYTES(Size64M)         ((UINT64)(Size64M) << 16)
#define MEM_64MB_TO_MBYTES(Size64M)         ((UINT64)(Size64M) << 6)
#define MEM_64MB_TO_GBYTES(Size64M)         ((Size64M) >> 4)
#define MEM_BYTES_TO_64MB(SizeB)            ((SizeB) >> 26)
#define MEM_KBYTES_TO_64MB(SizeKB)          ((SizeKB) >> 16)
#define MEM_MBYTES_TO_64MB(SizeMB)          ((SizeMB) >> 6)

#define FSP_MAX_PPR_ADDR_ENTRIES_DDR        MAX_PPR_ADDR_ENTRIES_DDR

typedef struct FspExtHeader {
  UINT64 Magic;
  UINT32 DataLength;
  UINT32 CheckSum;
} FSP_EXT_HEADER;

#endif // _FSP_EXT_GLOBALS_
