// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file finalTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#include "finalTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>
#include "final.hpp"

#include "helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalShortStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalShortStruct)
{

    ReturnCode_t return_code_FinalShortStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalShortStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalShortStruct", type_ids_FinalShortStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalShortStruct)
    {
        StructTypeFlag struct_flags_FinalShortStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalShortStruct = "FinalShortStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalShortStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalShortStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalShortStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalShortStruct;
        if (!tmp_ann_custom_FinalShortStruct.empty())
        {
            ann_custom_FinalShortStruct = tmp_ann_custom_FinalShortStruct;
        }

        CompleteTypeDetail detail_FinalShortStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalShortStruct, ann_custom_FinalShortStruct, type_name_FinalShortStruct.to_string());
        CompleteStructHeader header_FinalShortStruct;
        header_FinalShortStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalShortStruct);
        CompleteStructMemberSeq member_seq_FinalShortStruct;
        {
            TypeIdentifierPair type_ids_var_short;
            ReturnCode_t return_code_var_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_var_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_short = 0x00000000;
            bool common_var_short_ec {false};
            CommonStructMember common_var_short {TypeObjectUtils::build_common_struct_member(member_id_var_short, member_flags_var_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_short, common_var_short_ec))};
            if (!common_var_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_short = "var_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_short;
            ann_custom_FinalShortStruct.reset();
            CompleteMemberDetail detail_var_short = TypeObjectUtils::build_complete_member_detail(name_var_short, member_ann_builtin_var_short, ann_custom_FinalShortStruct);
            CompleteStructMember member_var_short = TypeObjectUtils::build_complete_struct_member(common_var_short, detail_var_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalShortStruct, member_var_short);
        }
        CompleteStructType struct_type_FinalShortStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalShortStruct, header_FinalShortStruct, member_seq_FinalShortStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalShortStruct, type_name_FinalShortStruct.to_string(), type_ids_FinalShortStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalShortStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalUShortStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalUShortStruct)
{

    ReturnCode_t return_code_FinalUShortStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalUShortStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalUShortStruct", type_ids_FinalUShortStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalUShortStruct)
    {
        StructTypeFlag struct_flags_FinalUShortStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalUShortStruct = "FinalUShortStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalUShortStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalUShortStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalUShortStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalUShortStruct;
        if (!tmp_ann_custom_FinalUShortStruct.empty())
        {
            ann_custom_FinalUShortStruct = tmp_ann_custom_FinalUShortStruct;
        }

        CompleteTypeDetail detail_FinalUShortStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalUShortStruct, ann_custom_FinalUShortStruct, type_name_FinalUShortStruct.to_string());
        CompleteStructHeader header_FinalUShortStruct;
        header_FinalUShortStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalUShortStruct);
        CompleteStructMemberSeq member_seq_FinalUShortStruct;
        {
            TypeIdentifierPair type_ids_var_ushort;
            ReturnCode_t return_code_var_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_var_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ushort)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ushort Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ushort = 0x00000000;
            bool common_var_ushort_ec {false};
            CommonStructMember common_var_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_ushort, member_flags_var_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ushort, common_var_ushort_ec))};
            if (!common_var_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ushort = "var_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ushort;
            ann_custom_FinalUShortStruct.reset();
            CompleteMemberDetail detail_var_ushort = TypeObjectUtils::build_complete_member_detail(name_var_ushort, member_ann_builtin_var_ushort, ann_custom_FinalUShortStruct);
            CompleteStructMember member_var_ushort = TypeObjectUtils::build_complete_struct_member(common_var_ushort, detail_var_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalUShortStruct, member_var_ushort);
        }
        CompleteStructType struct_type_FinalUShortStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalUShortStruct, header_FinalUShortStruct, member_seq_FinalUShortStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalUShortStruct, type_name_FinalUShortStruct.to_string(), type_ids_FinalUShortStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalUShortStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalLongStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalLongStruct)
{

    ReturnCode_t return_code_FinalLongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalLongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalLongStruct", type_ids_FinalLongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalLongStruct)
    {
        StructTypeFlag struct_flags_FinalLongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalLongStruct = "FinalLongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalLongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalLongStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalLongStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalLongStruct;
        if (!tmp_ann_custom_FinalLongStruct.empty())
        {
            ann_custom_FinalLongStruct = tmp_ann_custom_FinalLongStruct;
        }

        CompleteTypeDetail detail_FinalLongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalLongStruct, ann_custom_FinalLongStruct, type_name_FinalLongStruct.to_string());
        CompleteStructHeader header_FinalLongStruct;
        header_FinalLongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalLongStruct);
        CompleteStructMemberSeq member_seq_FinalLongStruct;
        {
            TypeIdentifierPair type_ids_var_long;
            ReturnCode_t return_code_var_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_var_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_long = 0x00000000;
            bool common_var_long_ec {false};
            CommonStructMember common_var_long {TypeObjectUtils::build_common_struct_member(member_id_var_long, member_flags_var_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_long, common_var_long_ec))};
            if (!common_var_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_long = "var_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_long;
            ann_custom_FinalLongStruct.reset();
            CompleteMemberDetail detail_var_long = TypeObjectUtils::build_complete_member_detail(name_var_long, member_ann_builtin_var_long, ann_custom_FinalLongStruct);
            CompleteStructMember member_var_long = TypeObjectUtils::build_complete_struct_member(common_var_long, detail_var_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalLongStruct, member_var_long);
        }
        CompleteStructType struct_type_FinalLongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalLongStruct, header_FinalLongStruct, member_seq_FinalLongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalLongStruct, type_name_FinalLongStruct.to_string(), type_ids_FinalLongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalLongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalULongStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalULongStruct)
{

    ReturnCode_t return_code_FinalULongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalULongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalULongStruct", type_ids_FinalULongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalULongStruct)
    {
        StructTypeFlag struct_flags_FinalULongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalULongStruct = "FinalULongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalULongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalULongStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalULongStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalULongStruct;
        if (!tmp_ann_custom_FinalULongStruct.empty())
        {
            ann_custom_FinalULongStruct = tmp_ann_custom_FinalULongStruct;
        }

        CompleteTypeDetail detail_FinalULongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalULongStruct, ann_custom_FinalULongStruct, type_name_FinalULongStruct.to_string());
        CompleteStructHeader header_FinalULongStruct;
        header_FinalULongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalULongStruct);
        CompleteStructMemberSeq member_seq_FinalULongStruct;
        {
            TypeIdentifierPair type_ids_var_ulong;
            ReturnCode_t return_code_var_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_var_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ulong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ulong = 0x00000000;
            bool common_var_ulong_ec {false};
            CommonStructMember common_var_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_ulong, member_flags_var_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ulong, common_var_ulong_ec))};
            if (!common_var_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ulong = "var_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ulong;
            ann_custom_FinalULongStruct.reset();
            CompleteMemberDetail detail_var_ulong = TypeObjectUtils::build_complete_member_detail(name_var_ulong, member_ann_builtin_var_ulong, ann_custom_FinalULongStruct);
            CompleteStructMember member_var_ulong = TypeObjectUtils::build_complete_struct_member(common_var_ulong, detail_var_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalULongStruct, member_var_ulong);
        }
        CompleteStructType struct_type_FinalULongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalULongStruct, header_FinalULongStruct, member_seq_FinalULongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalULongStruct, type_name_FinalULongStruct.to_string(), type_ids_FinalULongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalULongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalLongLongStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalLongLongStruct)
{

    ReturnCode_t return_code_FinalLongLongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalLongLongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalLongLongStruct", type_ids_FinalLongLongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalLongLongStruct)
    {
        StructTypeFlag struct_flags_FinalLongLongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalLongLongStruct = "FinalLongLongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalLongLongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalLongLongStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalLongLongStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalLongLongStruct;
        if (!tmp_ann_custom_FinalLongLongStruct.empty())
        {
            ann_custom_FinalLongLongStruct = tmp_ann_custom_FinalLongLongStruct;
        }

        CompleteTypeDetail detail_FinalLongLongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalLongLongStruct, ann_custom_FinalLongLongStruct, type_name_FinalLongLongStruct.to_string());
        CompleteStructHeader header_FinalLongLongStruct;
        header_FinalLongLongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalLongLongStruct);
        CompleteStructMemberSeq member_seq_FinalLongLongStruct;
        {
            TypeIdentifierPair type_ids_var_longlong;
            ReturnCode_t return_code_var_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_var_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_longlong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_longlong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_longlong = 0x00000000;
            bool common_var_longlong_ec {false};
            CommonStructMember common_var_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_longlong, member_flags_var_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_longlong, common_var_longlong_ec))};
            if (!common_var_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_longlong = "var_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_longlong;
            ann_custom_FinalLongLongStruct.reset();
            CompleteMemberDetail detail_var_longlong = TypeObjectUtils::build_complete_member_detail(name_var_longlong, member_ann_builtin_var_longlong, ann_custom_FinalLongLongStruct);
            CompleteStructMember member_var_longlong = TypeObjectUtils::build_complete_struct_member(common_var_longlong, detail_var_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalLongLongStruct, member_var_longlong);
        }
        CompleteStructType struct_type_FinalLongLongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalLongLongStruct, header_FinalLongLongStruct, member_seq_FinalLongLongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalLongLongStruct, type_name_FinalLongLongStruct.to_string(), type_ids_FinalLongLongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalLongLongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalULongLongStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalULongLongStruct)
{

    ReturnCode_t return_code_FinalULongLongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalULongLongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalULongLongStruct", type_ids_FinalULongLongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalULongLongStruct)
    {
        StructTypeFlag struct_flags_FinalULongLongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalULongLongStruct = "FinalULongLongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalULongLongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalULongLongStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalULongLongStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalULongLongStruct;
        if (!tmp_ann_custom_FinalULongLongStruct.empty())
        {
            ann_custom_FinalULongLongStruct = tmp_ann_custom_FinalULongLongStruct;
        }

        CompleteTypeDetail detail_FinalULongLongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalULongLongStruct, ann_custom_FinalULongLongStruct, type_name_FinalULongLongStruct.to_string());
        CompleteStructHeader header_FinalULongLongStruct;
        header_FinalULongLongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalULongLongStruct);
        CompleteStructMemberSeq member_seq_FinalULongLongStruct;
        {
            TypeIdentifierPair type_ids_var_ulonglong;
            ReturnCode_t return_code_var_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_var_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ulonglong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulonglong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ulonglong = 0x00000000;
            bool common_var_ulonglong_ec {false};
            CommonStructMember common_var_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_ulonglong, member_flags_var_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ulonglong, common_var_ulonglong_ec))};
            if (!common_var_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ulonglong = "var_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ulonglong;
            ann_custom_FinalULongLongStruct.reset();
            CompleteMemberDetail detail_var_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_ulonglong, member_ann_builtin_var_ulonglong, ann_custom_FinalULongLongStruct);
            CompleteStructMember member_var_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_ulonglong, detail_var_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalULongLongStruct, member_var_ulonglong);
        }
        CompleteStructType struct_type_FinalULongLongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalULongLongStruct, header_FinalULongLongStruct, member_seq_FinalULongLongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalULongLongStruct, type_name_FinalULongLongStruct.to_string(), type_ids_FinalULongLongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalULongLongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalFloatStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalFloatStruct)
{

    ReturnCode_t return_code_FinalFloatStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalFloatStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalFloatStruct", type_ids_FinalFloatStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalFloatStruct)
    {
        StructTypeFlag struct_flags_FinalFloatStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalFloatStruct = "FinalFloatStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalFloatStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalFloatStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalFloatStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalFloatStruct;
        if (!tmp_ann_custom_FinalFloatStruct.empty())
        {
            ann_custom_FinalFloatStruct = tmp_ann_custom_FinalFloatStruct;
        }

        CompleteTypeDetail detail_FinalFloatStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalFloatStruct, ann_custom_FinalFloatStruct, type_name_FinalFloatStruct.to_string());
        CompleteStructHeader header_FinalFloatStruct;
        header_FinalFloatStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalFloatStruct);
        CompleteStructMemberSeq member_seq_FinalFloatStruct;
        {
            TypeIdentifierPair type_ids_var_float;
            ReturnCode_t return_code_var_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_var_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_float)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_float Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_float = 0x00000000;
            bool common_var_float_ec {false};
            CommonStructMember common_var_float {TypeObjectUtils::build_common_struct_member(member_id_var_float, member_flags_var_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_float, common_var_float_ec))};
            if (!common_var_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_float = "var_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_float;
            ann_custom_FinalFloatStruct.reset();
            CompleteMemberDetail detail_var_float = TypeObjectUtils::build_complete_member_detail(name_var_float, member_ann_builtin_var_float, ann_custom_FinalFloatStruct);
            CompleteStructMember member_var_float = TypeObjectUtils::build_complete_struct_member(common_var_float, detail_var_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalFloatStruct, member_var_float);
        }
        CompleteStructType struct_type_FinalFloatStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalFloatStruct, header_FinalFloatStruct, member_seq_FinalFloatStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalFloatStruct, type_name_FinalFloatStruct.to_string(), type_ids_FinalFloatStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalFloatStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalDoubleStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalDoubleStruct)
{

    ReturnCode_t return_code_FinalDoubleStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalDoubleStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalDoubleStruct", type_ids_FinalDoubleStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalDoubleStruct)
    {
        StructTypeFlag struct_flags_FinalDoubleStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalDoubleStruct = "FinalDoubleStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalDoubleStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalDoubleStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalDoubleStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalDoubleStruct;
        if (!tmp_ann_custom_FinalDoubleStruct.empty())
        {
            ann_custom_FinalDoubleStruct = tmp_ann_custom_FinalDoubleStruct;
        }

        CompleteTypeDetail detail_FinalDoubleStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalDoubleStruct, ann_custom_FinalDoubleStruct, type_name_FinalDoubleStruct.to_string());
        CompleteStructHeader header_FinalDoubleStruct;
        header_FinalDoubleStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalDoubleStruct);
        CompleteStructMemberSeq member_seq_FinalDoubleStruct;
        {
            TypeIdentifierPair type_ids_var_double;
            ReturnCode_t return_code_var_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_var_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_double)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_double Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_double = 0x00000000;
            bool common_var_double_ec {false};
            CommonStructMember common_var_double {TypeObjectUtils::build_common_struct_member(member_id_var_double, member_flags_var_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_double, common_var_double_ec))};
            if (!common_var_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_double = "var_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_double;
            ann_custom_FinalDoubleStruct.reset();
            CompleteMemberDetail detail_var_double = TypeObjectUtils::build_complete_member_detail(name_var_double, member_ann_builtin_var_double, ann_custom_FinalDoubleStruct);
            CompleteStructMember member_var_double = TypeObjectUtils::build_complete_struct_member(common_var_double, detail_var_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalDoubleStruct, member_var_double);
        }
        CompleteStructType struct_type_FinalDoubleStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalDoubleStruct, header_FinalDoubleStruct, member_seq_FinalDoubleStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalDoubleStruct, type_name_FinalDoubleStruct.to_string(), type_ids_FinalDoubleStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalDoubleStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalLongDoubleStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalLongDoubleStruct)
{

    ReturnCode_t return_code_FinalLongDoubleStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalLongDoubleStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalLongDoubleStruct", type_ids_FinalLongDoubleStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalLongDoubleStruct)
    {
        StructTypeFlag struct_flags_FinalLongDoubleStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalLongDoubleStruct = "FinalLongDoubleStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalLongDoubleStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalLongDoubleStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalLongDoubleStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalLongDoubleStruct;
        if (!tmp_ann_custom_FinalLongDoubleStruct.empty())
        {
            ann_custom_FinalLongDoubleStruct = tmp_ann_custom_FinalLongDoubleStruct;
        }

        CompleteTypeDetail detail_FinalLongDoubleStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalLongDoubleStruct, ann_custom_FinalLongDoubleStruct, type_name_FinalLongDoubleStruct.to_string());
        CompleteStructHeader header_FinalLongDoubleStruct;
        header_FinalLongDoubleStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalLongDoubleStruct);
        CompleteStructMemberSeq member_seq_FinalLongDoubleStruct;
        {
            TypeIdentifierPair type_ids_var_longdouble;
            ReturnCode_t return_code_var_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_var_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_longdouble)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_longdouble Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_longdouble = 0x00000000;
            bool common_var_longdouble_ec {false};
            CommonStructMember common_var_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_longdouble, member_flags_var_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_longdouble, common_var_longdouble_ec))};
            if (!common_var_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_longdouble = "var_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_longdouble;
            ann_custom_FinalLongDoubleStruct.reset();
            CompleteMemberDetail detail_var_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_longdouble, member_ann_builtin_var_longdouble, ann_custom_FinalLongDoubleStruct);
            CompleteStructMember member_var_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_longdouble, detail_var_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalLongDoubleStruct, member_var_longdouble);
        }
        CompleteStructType struct_type_FinalLongDoubleStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalLongDoubleStruct, header_FinalLongDoubleStruct, member_seq_FinalLongDoubleStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalLongDoubleStruct, type_name_FinalLongDoubleStruct.to_string(), type_ids_FinalLongDoubleStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalLongDoubleStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalBooleanStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalBooleanStruct)
{

    ReturnCode_t return_code_FinalBooleanStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalBooleanStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalBooleanStruct", type_ids_FinalBooleanStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalBooleanStruct)
    {
        StructTypeFlag struct_flags_FinalBooleanStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalBooleanStruct = "FinalBooleanStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalBooleanStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalBooleanStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalBooleanStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalBooleanStruct;
        if (!tmp_ann_custom_FinalBooleanStruct.empty())
        {
            ann_custom_FinalBooleanStruct = tmp_ann_custom_FinalBooleanStruct;
        }

        CompleteTypeDetail detail_FinalBooleanStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalBooleanStruct, ann_custom_FinalBooleanStruct, type_name_FinalBooleanStruct.to_string());
        CompleteStructHeader header_FinalBooleanStruct;
        header_FinalBooleanStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalBooleanStruct);
        CompleteStructMemberSeq member_seq_FinalBooleanStruct;
        {
            TypeIdentifierPair type_ids_var_boolean;
            ReturnCode_t return_code_var_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_var_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_boolean)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_boolean Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_boolean = 0x00000000;
            bool common_var_boolean_ec {false};
            CommonStructMember common_var_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_boolean, member_flags_var_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_boolean, common_var_boolean_ec))};
            if (!common_var_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_boolean = "var_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_boolean;
            ann_custom_FinalBooleanStruct.reset();
            CompleteMemberDetail detail_var_boolean = TypeObjectUtils::build_complete_member_detail(name_var_boolean, member_ann_builtin_var_boolean, ann_custom_FinalBooleanStruct);
            CompleteStructMember member_var_boolean = TypeObjectUtils::build_complete_struct_member(common_var_boolean, detail_var_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalBooleanStruct, member_var_boolean);
        }
        CompleteStructType struct_type_FinalBooleanStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalBooleanStruct, header_FinalBooleanStruct, member_seq_FinalBooleanStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalBooleanStruct, type_name_FinalBooleanStruct.to_string(), type_ids_FinalBooleanStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalBooleanStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalOctetStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalOctetStruct)
{

    ReturnCode_t return_code_FinalOctetStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalOctetStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalOctetStruct", type_ids_FinalOctetStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalOctetStruct)
    {
        StructTypeFlag struct_flags_FinalOctetStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalOctetStruct = "FinalOctetStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalOctetStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalOctetStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalOctetStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalOctetStruct;
        if (!tmp_ann_custom_FinalOctetStruct.empty())
        {
            ann_custom_FinalOctetStruct = tmp_ann_custom_FinalOctetStruct;
        }

        CompleteTypeDetail detail_FinalOctetStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalOctetStruct, ann_custom_FinalOctetStruct, type_name_FinalOctetStruct.to_string());
        CompleteStructHeader header_FinalOctetStruct;
        header_FinalOctetStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalOctetStruct);
        CompleteStructMemberSeq member_seq_FinalOctetStruct;
        {
            TypeIdentifierPair type_ids_var_octet;
            ReturnCode_t return_code_var_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_var_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_octet)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_octet Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_octet = 0x00000000;
            bool common_var_octet_ec {false};
            CommonStructMember common_var_octet {TypeObjectUtils::build_common_struct_member(member_id_var_octet, member_flags_var_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_octet, common_var_octet_ec))};
            if (!common_var_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_octet = "var_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_octet;
            ann_custom_FinalOctetStruct.reset();
            CompleteMemberDetail detail_var_octet = TypeObjectUtils::build_complete_member_detail(name_var_octet, member_ann_builtin_var_octet, ann_custom_FinalOctetStruct);
            CompleteStructMember member_var_octet = TypeObjectUtils::build_complete_struct_member(common_var_octet, detail_var_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalOctetStruct, member_var_octet);
        }
        CompleteStructType struct_type_FinalOctetStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalOctetStruct, header_FinalOctetStruct, member_seq_FinalOctetStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalOctetStruct, type_name_FinalOctetStruct.to_string(), type_ids_FinalOctetStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalOctetStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalCharStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalCharStruct)
{

    ReturnCode_t return_code_FinalCharStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalCharStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalCharStruct", type_ids_FinalCharStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalCharStruct)
    {
        StructTypeFlag struct_flags_FinalCharStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalCharStruct = "FinalCharStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalCharStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalCharStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalCharStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalCharStruct;
        if (!tmp_ann_custom_FinalCharStruct.empty())
        {
            ann_custom_FinalCharStruct = tmp_ann_custom_FinalCharStruct;
        }

        CompleteTypeDetail detail_FinalCharStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalCharStruct, ann_custom_FinalCharStruct, type_name_FinalCharStruct.to_string());
        CompleteStructHeader header_FinalCharStruct;
        header_FinalCharStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalCharStruct);
        CompleteStructMemberSeq member_seq_FinalCharStruct;
        {
            TypeIdentifierPair type_ids_var_char8;
            ReturnCode_t return_code_var_char8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_char8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_var_char8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_char8)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char8 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_char8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_char8 = 0x00000000;
            bool common_var_char8_ec {false};
            CommonStructMember common_var_char8 {TypeObjectUtils::build_common_struct_member(member_id_var_char8, member_flags_var_char8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_char8, common_var_char8_ec))};
            if (!common_var_char8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_char8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char8 = "var_char8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_char8;
            ann_custom_FinalCharStruct.reset();
            CompleteMemberDetail detail_var_char8 = TypeObjectUtils::build_complete_member_detail(name_var_char8, member_ann_builtin_var_char8, ann_custom_FinalCharStruct);
            CompleteStructMember member_var_char8 = TypeObjectUtils::build_complete_struct_member(common_var_char8, detail_var_char8);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalCharStruct, member_var_char8);
        }
        CompleteStructType struct_type_FinalCharStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalCharStruct, header_FinalCharStruct, member_seq_FinalCharStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalCharStruct, type_name_FinalCharStruct.to_string(), type_ids_FinalCharStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalCharStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalWCharStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalWCharStruct)
{

    ReturnCode_t return_code_FinalWCharStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalWCharStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalWCharStruct", type_ids_FinalWCharStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalWCharStruct)
    {
        StructTypeFlag struct_flags_FinalWCharStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalWCharStruct = "FinalWCharStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalWCharStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalWCharStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalWCharStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalWCharStruct;
        if (!tmp_ann_custom_FinalWCharStruct.empty())
        {
            ann_custom_FinalWCharStruct = tmp_ann_custom_FinalWCharStruct;
        }

        CompleteTypeDetail detail_FinalWCharStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalWCharStruct, ann_custom_FinalWCharStruct, type_name_FinalWCharStruct.to_string());
        CompleteStructHeader header_FinalWCharStruct;
        header_FinalWCharStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalWCharStruct);
        CompleteStructMemberSeq member_seq_FinalWCharStruct;
        {
            TypeIdentifierPair type_ids_var_char16;
            ReturnCode_t return_code_var_char16 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_char16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_var_char16);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_char16)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char16 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_char16 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_char16 = 0x00000000;
            bool common_var_char16_ec {false};
            CommonStructMember common_var_char16 {TypeObjectUtils::build_common_struct_member(member_id_var_char16, member_flags_var_char16, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_char16, common_var_char16_ec))};
            if (!common_var_char16_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_char16 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char16 = "var_char16";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_char16;
            ann_custom_FinalWCharStruct.reset();
            CompleteMemberDetail detail_var_char16 = TypeObjectUtils::build_complete_member_detail(name_var_char16, member_ann_builtin_var_char16, ann_custom_FinalWCharStruct);
            CompleteStructMember member_var_char16 = TypeObjectUtils::build_complete_struct_member(common_var_char16, detail_var_char16);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalWCharStruct, member_var_char16);
        }
        CompleteStructType struct_type_FinalWCharStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalWCharStruct, header_FinalWCharStruct, member_seq_FinalWCharStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalWCharStruct, type_name_FinalWCharStruct.to_string(), type_ids_FinalWCharStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalWCharStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalUnionStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalUnionStruct)
{

    ReturnCode_t return_code_FinalUnionStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalUnionStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalUnionStruct", type_ids_FinalUnionStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalUnionStruct)
    {
        StructTypeFlag struct_flags_FinalUnionStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalUnionStruct = "FinalUnionStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalUnionStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalUnionStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalUnionStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalUnionStruct;
        if (!tmp_ann_custom_FinalUnionStruct.empty())
        {
            ann_custom_FinalUnionStruct = tmp_ann_custom_FinalUnionStruct;
        }

        CompleteTypeDetail detail_FinalUnionStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalUnionStruct, ann_custom_FinalUnionStruct, type_name_FinalUnionStruct.to_string());
        CompleteStructHeader header_FinalUnionStruct;
        header_FinalUnionStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalUnionStruct);
        CompleteStructMemberSeq member_seq_FinalUnionStruct;
        {
            TypeIdentifierPair type_ids_var_union;
            ReturnCode_t return_code_var_union {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerUnionHelper", type_ids_var_union);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union)
            {
            ::register_InnerUnionHelper_type_identifier(type_ids_var_union);
            }
            StructMemberFlag member_flags_var_union = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union = 0x00000000;
            bool common_var_union_ec {false};
            CommonStructMember common_var_union {TypeObjectUtils::build_common_struct_member(member_id_var_union, member_flags_var_union, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union, common_var_union_ec))};
            if (!common_var_union_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union = "var_union";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union;
            ann_custom_FinalUnionStruct.reset();
            CompleteMemberDetail detail_var_union = TypeObjectUtils::build_complete_member_detail(name_var_union, member_ann_builtin_var_union, ann_custom_FinalUnionStruct);
            CompleteStructMember member_var_union = TypeObjectUtils::build_complete_struct_member(common_var_union, detail_var_union);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalUnionStruct, member_var_union);
        }
        CompleteStructType struct_type_FinalUnionStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalUnionStruct, header_FinalUnionStruct, member_seq_FinalUnionStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalUnionStruct, type_name_FinalUnionStruct.to_string(), type_ids_FinalUnionStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalUnionStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalEmptyStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalEmptyStruct)
{

    ReturnCode_t return_code_FinalEmptyStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalEmptyStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalEmptyStruct", type_ids_FinalEmptyStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalEmptyStruct)
    {
        StructTypeFlag struct_flags_FinalEmptyStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        QualifiedTypeName type_name_FinalEmptyStruct = "FinalEmptyStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalEmptyStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalEmptyStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalEmptyStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalEmptyStruct;
        if (!tmp_ann_custom_FinalEmptyStruct.empty())
        {
            ann_custom_FinalEmptyStruct = tmp_ann_custom_FinalEmptyStruct;
        }

        CompleteTypeDetail detail_FinalEmptyStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalEmptyStruct, ann_custom_FinalEmptyStruct, type_name_FinalEmptyStruct.to_string());
        CompleteStructHeader header_FinalEmptyStruct;
        header_FinalEmptyStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FinalEmptyStruct);
        CompleteStructMemberSeq member_seq_FinalEmptyStruct;
        CompleteStructType struct_type_FinalEmptyStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalEmptyStruct, header_FinalEmptyStruct, member_seq_FinalEmptyStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalEmptyStruct, type_name_FinalEmptyStruct.to_string(), type_ids_FinalEmptyStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalEmptyStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalEmptyInheritanceStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalEmptyInheritanceStruct)
{

    ReturnCode_t return_code_FinalEmptyInheritanceStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalEmptyInheritanceStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalEmptyInheritanceStruct", type_ids_FinalEmptyInheritanceStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalEmptyInheritanceStruct)
    {
        StructTypeFlag struct_flags_FinalEmptyInheritanceStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        return_code_FinalEmptyInheritanceStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "FinalEmptyStruct", type_ids_FinalEmptyInheritanceStruct);

        if (return_code_FinalEmptyInheritanceStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_FinalEmptyStruct_type_identifier(type_ids_FinalEmptyInheritanceStruct);
        }
        QualifiedTypeName type_name_FinalEmptyInheritanceStruct = "FinalEmptyInheritanceStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalEmptyInheritanceStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalEmptyInheritanceStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalEmptyInheritanceStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalEmptyInheritanceStruct;
        if (!tmp_ann_custom_FinalEmptyInheritanceStruct.empty())
        {
            ann_custom_FinalEmptyInheritanceStruct = tmp_ann_custom_FinalEmptyInheritanceStruct;
        }

        CompleteTypeDetail detail_FinalEmptyInheritanceStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalEmptyInheritanceStruct, ann_custom_FinalEmptyInheritanceStruct, type_name_FinalEmptyInheritanceStruct.to_string());
        CompleteStructHeader header_FinalEmptyInheritanceStruct;
        if (EK_COMPLETE == type_ids_FinalEmptyInheritanceStruct.type_identifier1()._d())
        {
            header_FinalEmptyInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_FinalEmptyInheritanceStruct.type_identifier1(), detail_FinalEmptyInheritanceStruct);
        }
        else if (EK_COMPLETE == type_ids_FinalEmptyInheritanceStruct.type_identifier2()._d())
        {
            header_FinalEmptyInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_FinalEmptyInheritanceStruct.type_identifier2(), detail_FinalEmptyInheritanceStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalEmptyInheritanceStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_FinalEmptyInheritanceStruct;
        {
            TypeIdentifierPair type_ids_var_str;
            ReturnCode_t return_code_var_str {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_str =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_var_str);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_str)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_var_str))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_str = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_str = 0x00000000;
            bool common_var_str_ec {false};
            CommonStructMember common_var_str {TypeObjectUtils::build_common_struct_member(member_id_var_str, member_flags_var_str, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_str, common_var_str_ec))};
            if (!common_var_str_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_str member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_str = "var_str";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_str;
            ann_custom_FinalEmptyInheritanceStruct.reset();
            CompleteMemberDetail detail_var_str = TypeObjectUtils::build_complete_member_detail(name_var_str, member_ann_builtin_var_str, ann_custom_FinalEmptyInheritanceStruct);
            CompleteStructMember member_var_str = TypeObjectUtils::build_complete_struct_member(common_var_str, detail_var_str);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalEmptyInheritanceStruct, member_var_str);
        }
        CompleteStructType struct_type_FinalEmptyInheritanceStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalEmptyInheritanceStruct, header_FinalEmptyInheritanceStruct, member_seq_FinalEmptyInheritanceStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalEmptyInheritanceStruct, type_name_FinalEmptyInheritanceStruct.to_string(), type_ids_FinalEmptyInheritanceStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalEmptyInheritanceStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalInheritanceStruct_type_identifier(
        TypeIdentifierPair& type_ids_FinalInheritanceStruct)
{

    ReturnCode_t return_code_FinalInheritanceStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalInheritanceStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalInheritanceStruct", type_ids_FinalInheritanceStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalInheritanceStruct)
    {
        StructTypeFlag struct_flags_FinalInheritanceStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        return_code_FinalInheritanceStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "FinalShortStruct", type_ids_FinalInheritanceStruct);

        if (return_code_FinalInheritanceStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_FinalShortStruct_type_identifier(type_ids_FinalInheritanceStruct);
        }
        QualifiedTypeName type_name_FinalInheritanceStruct = "FinalInheritanceStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalInheritanceStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalInheritanceStruct;
        AppliedAnnotationSeq tmp_ann_custom_FinalInheritanceStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FinalInheritanceStruct;
        if (!tmp_ann_custom_FinalInheritanceStruct.empty())
        {
            ann_custom_FinalInheritanceStruct = tmp_ann_custom_FinalInheritanceStruct;
        }

        CompleteTypeDetail detail_FinalInheritanceStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalInheritanceStruct, ann_custom_FinalInheritanceStruct, type_name_FinalInheritanceStruct.to_string());
        CompleteStructHeader header_FinalInheritanceStruct;
        if (EK_COMPLETE == type_ids_FinalInheritanceStruct.type_identifier1()._d())
        {
            header_FinalInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_FinalInheritanceStruct.type_identifier1(), detail_FinalInheritanceStruct);
        }
        else if (EK_COMPLETE == type_ids_FinalInheritanceStruct.type_identifier2()._d())
        {
            header_FinalInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_FinalInheritanceStruct.type_identifier2(), detail_FinalInheritanceStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalInheritanceStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_FinalInheritanceStruct;
        {
            TypeIdentifierPair type_ids_var_str;
            ReturnCode_t return_code_var_str {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_str =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_var_str);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_str)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_var_str))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_str = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_str = 0x00000001;
            bool common_var_str_ec {false};
            CommonStructMember common_var_str {TypeObjectUtils::build_common_struct_member(member_id_var_str, member_flags_var_str, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_str, common_var_str_ec))};
            if (!common_var_str_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_str member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_str = "var_str";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_str;
            ann_custom_FinalInheritanceStruct.reset();
            CompleteMemberDetail detail_var_str = TypeObjectUtils::build_complete_member_detail(name_var_str, member_ann_builtin_var_str, ann_custom_FinalInheritanceStruct);
            CompleteStructMember member_var_str = TypeObjectUtils::build_complete_struct_member(common_var_str, detail_var_str);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalInheritanceStruct, member_var_str);
        }
        CompleteStructType struct_type_FinalInheritanceStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalInheritanceStruct, header_FinalInheritanceStruct, member_seq_FinalInheritanceStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalInheritanceStruct, type_name_FinalInheritanceStruct.to_string(), type_ids_FinalInheritanceStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalInheritanceStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_InheritanceEmptyStruct_type_identifier(
        TypeIdentifierPair& type_ids_InheritanceEmptyStruct)
{

    ReturnCode_t return_code_InheritanceEmptyStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InheritanceEmptyStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InheritanceEmptyStruct", type_ids_InheritanceEmptyStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InheritanceEmptyStruct)
    {
        StructTypeFlag struct_flags_InheritanceEmptyStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        return_code_InheritanceEmptyStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "FinalShortStruct", type_ids_InheritanceEmptyStruct);

        if (return_code_InheritanceEmptyStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_FinalShortStruct_type_identifier(type_ids_InheritanceEmptyStruct);
        }
        QualifiedTypeName type_name_InheritanceEmptyStruct = "InheritanceEmptyStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InheritanceEmptyStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InheritanceEmptyStruct;
        AppliedAnnotationSeq tmp_ann_custom_InheritanceEmptyStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_InheritanceEmptyStruct;
        if (!tmp_ann_custom_InheritanceEmptyStruct.empty())
        {
            ann_custom_InheritanceEmptyStruct = tmp_ann_custom_InheritanceEmptyStruct;
        }

        CompleteTypeDetail detail_InheritanceEmptyStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InheritanceEmptyStruct, ann_custom_InheritanceEmptyStruct, type_name_InheritanceEmptyStruct.to_string());
        CompleteStructHeader header_InheritanceEmptyStruct;
        if (EK_COMPLETE == type_ids_InheritanceEmptyStruct.type_identifier1()._d())
        {
            header_InheritanceEmptyStruct = TypeObjectUtils::build_complete_struct_header(type_ids_InheritanceEmptyStruct.type_identifier1(), detail_InheritanceEmptyStruct);
        }
        else if (EK_COMPLETE == type_ids_InheritanceEmptyStruct.type_identifier2()._d())
        {
            header_InheritanceEmptyStruct = TypeObjectUtils::build_complete_struct_header(type_ids_InheritanceEmptyStruct.type_identifier2(), detail_InheritanceEmptyStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InheritanceEmptyStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_InheritanceEmptyStruct;
        CompleteStructType struct_type_InheritanceEmptyStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_InheritanceEmptyStruct, header_InheritanceEmptyStruct, member_seq_InheritanceEmptyStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_InheritanceEmptyStruct, type_name_InheritanceEmptyStruct.to_string(), type_ids_InheritanceEmptyStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InheritanceEmptyStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FinalExtensibilityInheritance_type_identifier(
        TypeIdentifierPair& type_ids_FinalExtensibilityInheritance)
{

    ReturnCode_t return_code_FinalExtensibilityInheritance {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FinalExtensibilityInheritance =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FinalExtensibilityInheritance", type_ids_FinalExtensibilityInheritance);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FinalExtensibilityInheritance)
    {
        StructTypeFlag struct_flags_FinalExtensibilityInheritance = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::FINAL,
                false, false);
        return_code_FinalExtensibilityInheritance =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "FinalShortStruct", type_ids_FinalExtensibilityInheritance);

        if (return_code_FinalExtensibilityInheritance != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_FinalShortStruct_type_identifier(type_ids_FinalExtensibilityInheritance);
        }
        QualifiedTypeName type_name_FinalExtensibilityInheritance = "FinalExtensibilityInheritance";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FinalExtensibilityInheritance;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FinalExtensibilityInheritance;
        CompleteTypeDetail detail_FinalExtensibilityInheritance = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FinalExtensibilityInheritance, ann_custom_FinalExtensibilityInheritance, type_name_FinalExtensibilityInheritance.to_string());
        CompleteStructHeader header_FinalExtensibilityInheritance;
        if (EK_COMPLETE == type_ids_FinalExtensibilityInheritance.type_identifier1()._d())
        {
            header_FinalExtensibilityInheritance = TypeObjectUtils::build_complete_struct_header(type_ids_FinalExtensibilityInheritance.type_identifier1(), detail_FinalExtensibilityInheritance);
        }
        else if (EK_COMPLETE == type_ids_FinalExtensibilityInheritance.type_identifier2()._d())
        {
            header_FinalExtensibilityInheritance = TypeObjectUtils::build_complete_struct_header(type_ids_FinalExtensibilityInheritance.type_identifier2(), detail_FinalExtensibilityInheritance);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalExtensibilityInheritance Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_FinalExtensibilityInheritance;
        {
            TypeIdentifierPair type_ids_var_long;
            ReturnCode_t return_code_var_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_var_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_long = 0x00000001;
            bool common_var_long_ec {false};
            CommonStructMember common_var_long {TypeObjectUtils::build_common_struct_member(member_id_var_long, member_flags_var_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_long, common_var_long_ec))};
            if (!common_var_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_long = "var_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_long;
            ann_custom_FinalExtensibilityInheritance.reset();
            CompleteMemberDetail detail_var_long = TypeObjectUtils::build_complete_member_detail(name_var_long, member_ann_builtin_var_long, ann_custom_FinalExtensibilityInheritance);
            CompleteStructMember member_var_long = TypeObjectUtils::build_complete_struct_member(common_var_long, detail_var_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_FinalExtensibilityInheritance, member_var_long);
        }
        CompleteStructType struct_type_FinalExtensibilityInheritance = TypeObjectUtils::build_complete_struct_type(struct_flags_FinalExtensibilityInheritance, header_FinalExtensibilityInheritance, member_seq_FinalExtensibilityInheritance);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FinalExtensibilityInheritance, type_name_FinalExtensibilityInheritance.to_string(), type_ids_FinalExtensibilityInheritance))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FinalExtensibilityInheritance already registered in TypeObjectRegistry for a different type.");
        }
    }
}
