---
project: Fortran-lang/fpm
summary: Fortran Package Manager
project_github: https://github.com/fortran-lang/fpm
project_download: https://github.com/fortran-lang/fpm/archive/main.zip
author: fortran-lang/fpm contributors
author_pic: https://fortran-lang.org/assets/img/fortran_logo_512x512.png
author_email: fortran-lang@groups.io
github: https://github.com/fortran-lang
twitter: https://twitter.com/fortranlang
website: https://fortran-lang.org
src_dir: ./src
         ./app
output_dir: ./fpm-doc
page_dir: ./doc
media_dir: ./doc/media
exclude_dir: ./example_packages
             ./test
display: public
         protected
source: true
proc_internals: true
sort: permission-alpha
favicon: doc/media/favicon.ico
print_creation_date: true
extra_mods: iso_fortran_env:https://gcc.gnu.org/onlinedocs/gfortran/ISO_005fFORTRAN_005fENV.html
            tomlf:https://toml-f.github.io/toml-f
            M_CLI2:https://github.com/urbanjost/M_CLI2
creation_date: %Y-%m-%d %H:%M %z
md_extensions: markdown.extensions.toc
               markdown.extensions.smarty
---

[TOC]

# Fortran package manager developer documentation

This is the main documentation of the Fortran package manager (*fpm*).
This document serves as developer documentation of *fpm* itself and contains general advice for developing in the *fpm* code base.


## The package manifest

The central object describing an *fpm* project is the package manifest ``fpm.toml``.
The manifest is written in TOML, you can find the TOML specification at the official [TOML homepage](https://toml.io).

The ``fpm.toml`` file targets project developers and maintainers to relieve them from writing build files for their packages.
With the package manifest a central place to collect information about the project is provided.
It contains the versioning and licensing meta data, as well as the information on external dependencies and the required build-tools or compiler settings.

The manifest format specific to *fpm* projects is documented in the [manifest reference](page/Manifest.html).

@Note For a more practical but less complete guide on creating *fpm* projects see the [packaging guide](page/Packaging.html).

The details of the TOML parsing are implemented with using the [tomlf](https://toml-f.github.io/toml-f) module.
Generally, the interface to all TOML related functions for *fpm* is found in the proxy module [[fpm_toml]].

All the manifest types are bundled in [[fpm_manifest]].
While the specific subtables for the package configuration are found in the ``src/fpm/manifest`` directory, they should be reexported in the [[fpm_manifest]] module if they should be elsewhere in *fpm*.


## Command line interface

*fpm* is mainly used as a command line tool.
To work with an *fpm* project as a user you can completely rely on the command line.

The command line interface is build with the [M_CLI2](https://github.com/urbanjost/M_CLI2) module and can be found in [[fpm_command_line]].


## The package model

Once front-end inputs have been received from the package manifest and command line interface, *fpm* will construct an
internal representation of the package and its dependencies. This internal representation is known as the package *model*.
The model and its associated data types should encapsulate all the information required to correctly build a package and
should be independent of the intended backend build system. Information stored in the model includes: build targets and
their inter-dependencies; compiler and compiler flags; library linking information.

For more information on the contents of the package model and the process for constructing it, please see [[fpm_model]].

## The build backend

Once a complete package model has been constructed, it can be passed to a *backend* for either performing the compilation
and linking of targets, or for generating configuration files for a third-party build system.
Currently, only a native backend is implemented in *fpm*. See [[fpm_backend]] for more information.

## Generating this documentation

This documentation is generated by [FORD](https://github.com/Fortran-FOSS-Programmers/FORD).
For more details on the [project file](https://github.com/fortran-lang/fpm/docs.md) and the comment markup in the source code visit the [FORD documentation](https://github.com/Fortran-FOSS-Programmers/ford/wiki).

To regenerate this documentation run:

```shell
ford docs.md
```
