#############################################################################
##
#A  toric.gd                 toric library                      David Joyner
##
##  this file contains declarations for toric 
##
##


#############################################################################
##
#F  InDualCone(<v>,<L>)
##
##  returns true if v belongs to the dual of the code generated by
##  the vectors in L
##  
DeclareGlobalFunction("InDualCone");

#############################################################################
##
#F  DualSemigroupGenerators(<L>,<F>)
##
##  Input: L is a list of integral n-vectors 
##          generating a cone sigma 
##  Output: the generators of S_sigma,  
##
##  Idea:  let M be the max of the abs values of the 
##  coords of the L[i]'s, for each vector v in 
##  [1..M]^n, test if v in sigma^*. If so, 
##  add to list of possible generators. 
##  Once this for loop is finished, one can check 
##  this list for redundant generators. The  
##  trick below is to simply omit those elements 
##  which are of the form d1+d2, where d1 and d2 
##  are "small" elements in the integral dual cone. 
##  
DeclareGlobalFunction("DualSemigroupGenerators");

#############################################################################
##
#F  EmbeddingAffineToricVariety(<L>)
##
##  Input: L is a list generating a cone 
##        (as in dual_semigp_gens),
##  Output: the toroidal embedding of X=affine_toric_variety(L)
##       (given as a list of multinomials)
##  
DeclareGlobalFunction("EmbeddingAffineToricVariety");

#############################################################################
##
#F  DivisorPolytope(<D>, <Rays>)
##
##  Input: D is the list of coeffs for the Weil divisor D
##  Rays is the list of vectors in the rays for the fan Delta
##   (Delta is determined by a list of generators L
##    but these are not explicitly needed here)
##  Output: the linear expressions in the affine coordinates of the
##   space of the cone which must be >0 for a point to be in the
##   desired polytope
##  
DeclareGlobalFunction("DivisorPolytope");

#############################################################################
##
#F  PolytopeLatticePoints(<A>, <Perps>)
##
##  Input: Perps=[v1,...,vk] is the list of "inward normal" 
##            vectors perpendicular to the walls of the polytope P,
##         A=[a1,...,ak] is the amount wall is shifted from the 
##            origin (ai>=0)
##       Eg, x=0, x=a, y=0, y=b has Perps=[[1,0],[-1,0],[0,1],[0,-1]] 
##           and A=[0,a,0,b]
##  Output: the list of points in P \cap L^\perp
##  
DeclareGlobalFunction("PolytopeLatticePoints");

#############################################################################
##
#F  DivisorPolytopeLatticePoints(<D>, <Cones>, <Rays_ordered> )
##
##  Input: Cones is the fan
##         Rays_ordered is the *ordered* list of rays for Cones
##         D is the list of coeffs for the Weil divisor D
##  Output: the list of points in P_D \cap L^\perp
##            which paramterize the elements in L(D)
##
##  Caution: The rays do not determine the cones in a fan.
##
DeclareGlobalFunction("DivisorPolytopeLatticePoints");

#############################################################################
##
#F  RiemannRochBasis(<D>,  <Cones>, <Rays> )
##
##  Input: Cones is the fan
##         Rays is the *ordered* list of rays for Cones
##         D is the list of coeffs for the Weil divisor D
##
##  Output: computes a basis (a list of monomials)
##           for the RR space of the divisor represented by D
##
##
DeclareGlobalFunction("RiemannRochBasis");

#############################################################################
##
#F  Faces( <Rays> )
##
##  Input: Rays is a list of rays for the fan Delta
##
##  Output: all the normals to the faces (hyperplanes of the cone)
##
##
DeclareGlobalFunction("Faces");

#############################################################################
##
#F  InsideCone(<v>, <Rays> )
##
##  Input: Rays is a list of rays for the fan Delta
##
##  Output: true if v is in the cone represented by Rays
##          (a cone is a list of vectors generating it),
##          false otherwise
##
##  Idea: look at all dim-subsets of Rays and test if 
##        there is a positive solns vector all the normals 
##        to the faces (hyperplanes of the cone)
##
##
DeclareGlobalFunction("InsideCone");

#############################################################################
##
#F  NumberOfConesOfFan( <Delta>, <k> )
##
##  Input: Delta is the fan of cones
##         k is the dimension of the cones counted
##  Output: number of k-diml cones in the fan
##          (each hyperplane of one cone should not form the face
##           of any other cone in the fan)
##
##  Idea:   the fan Delta is represented as a set of max cones.
##          for each max cone, look at the k-diml faces
##          obtained by taking n choose k subsets of the
##          rays describing the cone. 
##          **Certain** of these k-subsets yield the
##          desired cones
##
DeclareGlobalFunction("NumberOfConesOfFan");

#############################################################################
##
#F  ConesOfFan( <Delta>, <k> )
##
##  Input: Delta is the fan of cones
##         k is the dimension of the cones taken
##  Output: the set of k-diml cones in the fan
##          (each hyperplane of one cone should not form the face
##           of any other cone in the fan, ie,
##           only takes those subcones which are *not* interior)
##
##
DeclareGlobalFunction("ConesOfFan");

#############################################################################
##
#F  ToricStar( <cone>, <Cones> )
##
##  Input: Cones is the fan of cones
##         <cone> is a cone of <Cones>
##  Output: the star of the cone in a fan
##          ie, the cones tau which have <cone> as a face
##
##
DeclareGlobalFunction("ToricStar");

#############################################################################
##
#F  BettiNumberToric( <Cones>, <k> )
##
##  Input: Cones is the fan of cones
##         k is an integer
##  Output: the k-th betti number of the toric variety 
##          X(Delta), where Delta is a fan defined by its maximal
##          cones, Cones
##
##
DeclareGlobalFunction("BettiNumberToric");

#############################################################################
##
#F  EulerCharacteristic( <Cones> )
##
##  Input: Cones is the fan of cones
##  Output: Euler char of X(Delta), where 
##          Delta is a fan defined by its maximal cones, Cones
##
##  Note: X(Delta) **must be non-singular**
##
## was DeclareGlobalFunction("EulerCharacteristic");
DeclareAttribute( "EulerCharacteristic", IsList );


#############################################################################
##
#F  CardinalityOfToricVariety( <Cones>, <q> )
##
##  Input: Cones is the fan of cones
##  Output: the number of elements of X(Delta) over GF(q), where 
##          Delta is a fan defined by its maximal cones, Cones,
##          and where q is a prime power
##
##  Note: X(Delta) **must be non-singular***
##
DeclareGlobalFunction("CardinalityOfToricVariety");