#ifndef __GBEMOL_UTILS_H_
#define __GBEMOL_UTILS_H_

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "gbemol-app.h"
#include "gbemol-library.h"
#include "gbemol-playlist.h"
#include "gbemol-locale.h"

/* Widgets */
GtkWidget* gbemol_utils_make_button (char *text, char *stock);
GtkWidget* gbemol_utils_make_button_and_label (char *text, char *stock, GtkWidget** lbl);
GtkWidget* gbemol_utils_label_new_with_markup (gchar* text);
GList* gbemol_utils_get_selected (GtkTreeView* tvw);

/* Memory */
void gbemol_utils_char_list_free (GList *l);
void gbemol_utils_song_list_free (GList *l);
void gbemol_utils_selected_list_free (GList* l);

/* Configuration file */
gboolean gbemol_cfg_create_file (void);
GKeyFile* gbemol_cfg_load_file (void);
gboolean gbemol_cfg_save_file (GKeyFile* file);
void gbemol_cfg_set_string (gchar* group, gchar* key, const gchar* value);
gchar* gbemol_cfg_get_string (gchar* group, gchar* key);
void gbemol_cfg_set_int (gchar* group, gchar* key, gint value);
gint gbemol_cfg_get_int (gchar* group, gchar* key);
gdouble gbemol_cfg_get_double (gchar* group, gchar* key);
void gbemol_cfg_set_double (gchar* group, gchar* key, gdouble d);
void gbemol_cfg_set_bool(gchar* group, gchar* key, gboolean value);
gboolean gbemol_cfg_get_bool(gchar* group, gchar* key);
gboolean gbemol_cfg_get_bool_with_default(gchar* group, gchar* key, gboolean def);

GdkPixbuf* gbemol_utils_get_song_image (GbemolMpdSong* song);
#endif
