/*****************************************************************************\
 *  $Id: genders_test_corner_case_tests.c,v 1.8 2010-02-02 00:04:34 chu11 Exp $
 *****************************************************************************
 *  Copyright (C) 2007-2019 Lawrence Livermore National Security, LLC.
 *  Copyright (C) 2001-2007 The Regents of the University of California.
 *  Produced at Lawrence Livermore National Laboratory (cf, DISCLAIMER).
 *  Written by Jim Garlick <garlick@llnl.gov> and Albert Chu <chu11@llnl.gov>.
 *  UCRL-CODE-2003-004.
 *
 *  This file is part of Genders, a cluster configuration database.
 *  For details, see <http://www.llnl.gov/linux/genders/>.
 *
 *  Genders is free software; you can redistribute it and/or modify it under
 *  the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 2 of the License, or (at your option)
 *  any later version.
 *
 *  Genders is distributed in the hope that it will be useful, but WITHOUT ANY
 *  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 *  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with Genders.  If not, see <http://www.gnu.org/licenses/>.
\*****************************************************************************/

#include "genders.h"
#include "genders_testlib.h"
#include "genders_test_corner_case.h"
#include "genders_test_database.h"

genders_handle_destroy_corner_case_t genders_handle_destroy_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,            0, GENDERS_ERR_MAGIC     },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, -1, GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,              0, GENDERS_ERR_MAGIC     },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};

genders_load_data_corner_case_t genders_load_data_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NULL,               -1, GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_EMPTY,     -1, GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_EXIST,     -1, GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_NOT_EXIST, -1, GENDERS_ERR_NULLHANDLE},

  {4,  GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NULL,                0, GENDERS_ERR_SUCCESS   },
  {5,  GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_EMPTY,      0, GENDERS_ERR_SUCCESS   },
  {6,  GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_EXIST,      0, GENDERS_ERR_SUCCESS   },
  {7,  GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_NOT_EXIST, -1, GENDERS_ERR_OPEN      },

  {8,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NULL,               -1, GENDERS_ERR_MAGIC     },
  {9,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_EMPTY,     -1, GENDERS_ERR_MAGIC     },
  {10, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_EXIST,     -1, GENDERS_ERR_MAGIC     },
  {11, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_NOT_EXIST, -1, GENDERS_ERR_MAGIC     },

  {12, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NULL,               -1, GENDERS_ERR_ISLOADED  },
  {13, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_EMPTY,     -1, GENDERS_ERR_ISLOADED  },
  {14, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_EXIST,     -1, GENDERS_ERR_ISLOADED  },
  {15, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_NOT_EXIST, -1, GENDERS_ERR_ISLOADED  },

  {16, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NULL,               -1, GENDERS_ERR_MAGIC     },
  {17, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_EMPTY,     -1, GENDERS_ERR_MAGIC     },
  {18, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_EXIST,     -1, GENDERS_ERR_MAGIC     },
  {19, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_NOT_EXIST, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_errnum_corner_case_t genders_errnum_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,            GENDERS_ERR_SUCCESS   },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,              GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_ERR_MAGIC     },
  {-1, -1, -1},
};

genders_strerror_corner_case_t genders_strerror_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,            GENDERS_ERR_SUCCESS   },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,              GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_ERR_MAGIC     },
  {-1, -1, -1},
};

genders_errormsg_corner_case_t genders_errormsg_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,            GENDERS_ERR_SUCCESS   },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,              GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_ERR_MAGIC     },
  {-1, -1, -1},
};

genders_perror_corner_case_t genders_perror_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                NULL,       GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                "not-null", GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            NULL,       GENDERS_ERR_SUCCESS   },
  {3, GENDERS_HANDLE_UNLOADED,            "not-null", GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  NULL,       GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  "not-null", GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              NULL,       GENDERS_ERR_SUCCESS   },
  {7, GENDERS_HANDLE_LOADED,              "not-null", GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    NULL,       GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    "not-null", GENDERS_ERR_MAGIC     },
  {-1, -1, NULL, -1},
};

genders_get_flags_corner_case_t genders_get_flags_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_set_flags_corner_case_t genders_set_flags_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,                GENDERS_TEST_FLAG_DEFAULT, -1, GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,                GENDERS_TEST_FLAG_MIN,     -1, GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,                GENDERS_TEST_FLAG_MAX,     -1, GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_UNLOADED,            GENDERS_TEST_FLAG_DEFAULT,  0, GENDERS_ERR_SUCCESS   },
  {4,  GENDERS_HANDLE_UNLOADED,            GENDERS_TEST_FLAG_MIN,      0, GENDERS_ERR_SUCCESS   },
  {5,  GENDERS_HANDLE_UNLOADED,            GENDERS_TEST_FLAG_MAX,     -1, GENDERS_ERR_PARAMETERS},
  {6,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_TEST_FLAG_DEFAULT, -1, GENDERS_ERR_MAGIC     },
  {7,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_TEST_FLAG_MIN,     -1, GENDERS_ERR_MAGIC     },
  {8,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_TEST_FLAG_MAX,     -1, GENDERS_ERR_MAGIC     },
  {9,  GENDERS_HANDLE_LOADED,              GENDERS_TEST_FLAG_DEFAULT,  0, GENDERS_ERR_SUCCESS   },
  {10, GENDERS_HANDLE_LOADED,              GENDERS_TEST_FLAG_MIN,      0, GENDERS_ERR_SUCCESS   },
  {11, GENDERS_HANDLE_LOADED,              GENDERS_TEST_FLAG_MAX,     -1, GENDERS_ERR_PARAMETERS},
  {12, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_TEST_FLAG_DEFAULT, -1, GENDERS_ERR_MAGIC     },
  {13, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_TEST_FLAG_MIN,     -1, GENDERS_ERR_MAGIC     },
  {14, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_TEST_FLAG_MAX,     -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_getnumnodes_corner_case_t genders_getnumnodes_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               -1,                                    GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,           -1,                                    GENDERS_ERR_NOTLOADED },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, -1,                                    GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,             GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   -1,                                    GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};

genders_getnumattrs_corner_case_t genders_getnumattrs_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               -1,                                    GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,           -1,                                    GENDERS_ERR_NOTLOADED },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, -1,                                    GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,             GENDERS_DATABASE_CORNER_CASE_NUMATTRS, GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   -1,                                    GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};

genders_getmaxattrs_corner_case_t genders_getmaxattrs_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               -1,                                    GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,           -1,                                    GENDERS_ERR_NOTLOADED },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, -1,                                    GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,             GENDERS_DATABASE_CORNER_CASE_MAXATTRS, GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   -1,                                    GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};

genders_getmaxnodelen_corner_case_t genders_getmaxnodelen_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               -1,                                      GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,           -1,                                      GENDERS_ERR_NOTLOADED },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, -1,                                      GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,             GENDERS_DATABASE_CORNER_CASE_MAXNODELEN, GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   -1,                                      GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};

genders_getmaxattrlen_corner_case_t genders_getmaxattrlen_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               -1,                                      GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,           -1,                                      GENDERS_ERR_NOTLOADED },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, -1,                                      GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,             GENDERS_DATABASE_CORNER_CASE_MAXATTRLEN, GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   -1,                                      GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};

genders_getmaxvallen_corner_case_t genders_getmaxvallen_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               -1,                                     GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,           -1,                                     GENDERS_ERR_NOTLOADED },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, -1,                                     GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,             GENDERS_DATABASE_CORNER_CASE_MAXVALLEN, GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   -1,                                     GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};

genders_nodelist_create_corner_case_t genders_nodelist_create_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_nodelist_clear_corner_case_t genders_nodelist_clear_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_nodelist_destroy_corner_case_t genders_nodelist_destroy_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_attrlist_create_corner_case_t genders_attrlist_create_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  GENDERS_DATABASE_CORNER_CASE_NUMATTRS, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_attrlist_clear_corner_case_t genders_attrlist_clear_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_attrlist_destroy_corner_case_t genders_attrlist_destroy_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_vallist_create_corner_case_t genders_vallist_create_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  GENDERS_DATABASE_CORNER_CASE_NUMATTRS, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1,                                     GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1,                                     GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_vallist_clear_corner_case_t genders_vallist_clear_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_vallist_destroy_corner_case_t genders_vallist_destroy_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NULLHANDLE},
  {2, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     -1, GENDERS_ERR_NOTLOADED },
  {3, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_NOTLOADED },
  {4, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {5, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {6, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     -1, GENDERS_ERR_PARAMETERS},
  {7, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL,  0, GENDERS_ERR_SUCCESS   },
  {8, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     -1, GENDERS_ERR_MAGIC     },
  {9, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_getnodename_corner_case_t genders_getnodename_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {4,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {5,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {6,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {7,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {8,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {9,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {10, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {11, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {12, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {13, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {14, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {15, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {16, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {17, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {18, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {19, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {20, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {21, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {22, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {23, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {24, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {25, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {26, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {27, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {28, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {29, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_OVERFLOW  },
  {30, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_OVERFLOW  },
  {31, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE,  0, GENDERS_ERR_SUCCESS   },
  {32, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {33, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {34, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {35, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {36, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {37, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {38, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {39, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },

  {-1, -1, -1, -1, -1, -1},
};

genders_getnodes_corner_case_t genders_getnodes_corner_case_tests[] = {
  {0,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {1,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {2,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {3,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {4,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {5,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {6,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {7,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {8,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {9,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {10,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {11,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {12,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {13,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {14,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {15,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {16,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {17,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {18,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {19,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {20,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {21,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {22,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {23,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {24,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {25,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {26,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {27,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {28,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {29,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {30,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {31,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {32,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {33,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {34,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {35,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {36,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {37,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {38,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {39,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {40,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {41,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {42,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {43,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {44,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {45,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {46,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {47,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {48,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {49,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {50,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {51,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {52,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {53,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {54,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {55,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {56,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {57,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {58,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {59,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {60,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {61,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {62,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {63,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {64,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {65,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {66,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {67,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {68,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {69,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {70,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {71,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {72,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {73,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {74,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {75,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {76,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {77,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {78,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {79,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {80,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {81,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {82,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {83,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {84,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {85,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {86,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {87,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {88,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {89,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {90,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {91,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {92,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {93,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {94,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {95,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {96,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {97,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {98,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {99,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {100, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {101, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {102, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {103, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {104, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {105, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {106, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {107, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {108, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {109, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {110, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {111, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {112, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {113, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {114, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {115, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {116, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {117, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {118, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {119, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {120, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {121, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {122, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {123, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {124, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {125, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {126, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {127, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {128, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {129, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {130, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {131, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {132, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {133, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {134, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {135, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {136, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {137, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {138, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {139, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {140, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {141, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {142, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {143, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {144, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {145, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {146, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {147, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {148, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {149, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {150, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {151, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {152, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {153, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {154, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {155, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {156, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {157, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {158, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {159, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {160, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {161, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {162, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {163, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {164, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {165, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {166, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {167, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {168, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {169, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {170, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {171, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {172, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {173, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {174, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {175, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {176, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {177, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {178, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {179, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {180, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {181, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {182, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {183, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {184, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {185, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {186, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {187, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {188, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {189, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {190, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {191, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {192, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {193, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {194, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {195, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {196, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {197, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {198, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {199, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {200, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {201, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {202, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {203, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {204, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {205, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {206, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {207, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {208, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {209, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {210, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {211, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {212, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {213, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {214, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {215, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {216, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {217, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {218, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {219, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {220, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {221, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {222, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {223, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {224, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {225, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {226, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {227, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {228, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_OVERFLOW  },
  {229, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_OVERFLOW  },
  {230, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_OVERFLOW  },
  {231, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {232, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {233, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {234, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {235, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {236, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {237, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {238, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {239, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {240, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {241, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {242, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {243, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {244, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {245, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {246, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {247, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {248, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {249, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {250, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {251, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {252, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {253, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {254, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {255, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {256, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {257, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {258, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {259, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {260, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {261, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {262, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {263, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {264, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_OVERFLOW  },
  {265, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_OVERFLOW  },
  {266, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_OVERFLOW  },
  {267, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {268, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {269, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {270, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {271, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {272, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {273, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_OVERFLOW  },
  {274, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_OVERFLOW  },
  {275, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_OVERFLOW  },
  {276, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {277, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {278, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {279, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {280, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {281, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {282, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {283, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {284, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {285, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {286, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {287, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {288, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {289, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {290, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {291, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {292, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {293, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {294, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {295, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {296, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {297, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {298, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {299, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {300, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {301, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {302, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {303, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {304, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {305, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {306, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {307, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {308, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {309, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {310, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {311, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {312, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {313, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {314, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {315, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {316, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {317, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {318, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {319, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {320, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {321, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {322, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {323, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {324, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {325, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {326, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {327, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {328, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {329, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {330, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {331, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {332, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {333, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {334, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {335, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {336, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {337, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {338, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {339, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {340, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {341, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {342, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {343, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {344, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {345, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {346, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {347, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {348, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {349, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {350, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {351, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {352, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {353, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {354, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {355, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {356, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {357, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {358, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {359, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },

  {-1, -1, -1, -1, -1, -1, -1, -1},
};

genders_getattr_corner_case_t genders_getattr_corner_case_tests[] = {
  {1,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {2,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {3,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {4,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {5,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {6,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {7,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {8,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {9,   GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {10,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {11,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {12,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {13,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {14,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {15,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {16,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {17,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {18,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {19,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {20,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {21,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {22,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {23,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {24,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {25,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {26,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {27,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {28,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {29,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {30,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {31,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {32,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {33,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {34,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {35,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {36,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {37,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {38,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {39,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {40,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {41,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {42,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {43,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {44,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {45,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {46,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {47,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {48,  GENDERS_HANDLE_NULL,               GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},

  {49,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {50,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {51,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {52,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {53,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {54,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {55,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {56,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {57,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {58,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {59,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {60,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {61,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {62,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {63,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {64,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {65,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {66,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {67,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {68,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {69,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {70,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {71,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {72,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {73,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {74,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {75,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {76,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {77,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {78,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {79,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {80,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {81,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {82,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {83,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {84,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {85,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {86,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {87,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {88,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {89,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {90,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {91,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {92,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {93,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {94,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {95,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {96,  GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },

  {97,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {98,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {99,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {100, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {101, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {102, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {103, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {104, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {105, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {106, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {107, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {108, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {109, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {110, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {111, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {112, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {113, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {114, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {115, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {116, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {117, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {118, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {119, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {120, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {121, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {122, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {123, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {124, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {125, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {126, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {127, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {128, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {129, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {130, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {131, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {132, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {133, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {134, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {135, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {136, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {137, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {138, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {139, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {140, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {141, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {142, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {143, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {144, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },

  {145, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {146, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {147, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {148, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTFOUND  },
  {149, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTFOUND  },
  {150, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {151, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {152, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {153, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {154, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {155, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {156, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {157, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {158, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {159, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {160, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTFOUND  },
  {161, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTFOUND  },
  {162, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {163, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {164, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {165, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {166, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {167, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {168, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {169, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {170, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {171, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {172, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTFOUND  },
  {173, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTFOUND  },
  {174, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {175, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTFOUND  },
  {176, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTFOUND  },
  {177, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {178, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTFOUND  },
  {179, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTFOUND  },
  {180, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_DATABASE_CORNER_CASE_MAXATTRS, GENDERS_ERR_SUCCESS   },
  {181, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {182, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {183, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {184, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTFOUND  },
  {185, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTFOUND  },
  {186, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {187, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTFOUND  },
  {188, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTFOUND  },
  {189, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {190, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTFOUND  },
  {191, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTFOUND  },
  {192, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_DATABASE_CORNER_CASE_MAXATTRS, GENDERS_ERR_SUCCESS   },

  {193, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {194, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {195, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {196, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {197, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {198, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {199, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {200, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {201, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {202, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {203, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {204, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {205, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {206, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {207, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {208, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {209, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {210, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {211, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {212, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {213, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {214, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {215, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {216, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {217, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {218, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {219, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {220, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {221, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {222, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {223, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {224, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {225, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {226, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {227, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {228, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {229, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {230, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {231, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {232, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {233, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {234, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {235, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {236, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {237, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {238, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {239, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {240, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NON_NULL, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },

  {-1, -1, -1, -1, -1, -1, -1, -1},
};

genders_getattr_all_corner_case_t genders_getattr_all_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_NULLHANDLE},
  {4,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_NULLHANDLE},
  {5,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {6,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_NULLHANDLE},
  {7,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_NULLHANDLE},
  {8,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_NOTLOADED },
  {9,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_NOTLOADED },
  {10, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_NOTLOADED },
  {11, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_NOTLOADED },
  {12, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_NOTLOADED },
  {13, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_NOTLOADED },
  {14, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_NOTLOADED },
  {15, GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_NOTLOADED },
  {16, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_MAGIC     },
  {17, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_MAGIC     },
  {18, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_MAGIC     },
  {19, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_MAGIC     },
  {20, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_MAGIC     },
  {21, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_MAGIC     },
  {22, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_MAGIC     },
  {23, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_MAGIC     },
  {24, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_PARAMETERS},
  {25, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {26, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_PARAMETERS},
  {27, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_PARAMETERS},
  {28, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_PARAMETERS},
  {29, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {30, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_OVERFLOW  },
  {31, GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_DATABASE_CORNER_CASE_NUMATTRS, GENDERS_ERR_SUCCESS   },
  {32, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_MAGIC     },
  {33, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_MAGIC     },
  {34, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_MAGIC     },
  {35, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_MAGIC     },
  {36, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1,                                    GENDERS_ERR_MAGIC     },
  {37, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1,                                    GENDERS_ERR_MAGIC     },
  {38, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1,                                    GENDERS_ERR_MAGIC     },
  {39, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1,                                    GENDERS_ERR_MAGIC     },

  {-1, -1, -1, -1, -1, -1},
};

genders_testattr_corner_case_t genders_testattr_corner_case_tests[] = {
  {0,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {1,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {2,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {3,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {4,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {5,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {6,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {7,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {8,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {9,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {10,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {11,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {12,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {13,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {14,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {15,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {16,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {17,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {18,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {19,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {20,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {21,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {22,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {23,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {24,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {25,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {26,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {27,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {28,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {29,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {30,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {31,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {32,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {33,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {34,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {35,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {36,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {37,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {38,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {39,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {40,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {41,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {42,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {43,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {44,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {45,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {46,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {47,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {48,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {49,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {50,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {51,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {52,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {53,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {54,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {55,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {56,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {57,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {58,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {59,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {60,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {61,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {62,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {63,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {64,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {65,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {66,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {67,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},
  {68,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NULLHANDLE},
  {69,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NULLHANDLE},
  {70,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NULLHANDLE},
  {71,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NULLHANDLE},

  {72,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {73,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {74,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {75,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {76,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {77,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {78,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {79,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {80,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {81,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {82,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {83,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {84,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {85,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {86,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {87,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {88,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {89,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {90,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {91,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {92,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {93,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {94,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {95,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {96,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {97,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {98,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {99,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {100, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {101, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {102, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {103, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {104, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {105, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {106, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {107, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {108, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {109, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {110, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {111, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {112, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {113, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {114, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {115, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {116, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {117, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {118, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {119, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {120, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {121, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {122, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {123, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {124, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {125, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {126, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {127, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {128, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {129, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {130, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {131, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {132, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {133, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {134, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {135, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {136, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {137, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {138, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {139, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },
  {140, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTLOADED },
  {141, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTLOADED },
  {142, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTLOADED },
  {143, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTLOADED },

  {144, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {145, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {146, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {147, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {148, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {149, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {150, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {151, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {152, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {153, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {154, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {155, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {156, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {157, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {158, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {159, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {160, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {161, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {162, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {163, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {164, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {165, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {166, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {167, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {168, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {169, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {170, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {171, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {172, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {173, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {174, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {175, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {176, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {177, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {178, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {179, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {180, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {181, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {182, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {183, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {184, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {185, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {186, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {187, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {188, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {189, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {190, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {191, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {192, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {193, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {194, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {195, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {196, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {197, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {198, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {199, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {200, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {201, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {202, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {203, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {204, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {205, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {206, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {207, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {208, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {209, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {210, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {211, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {212, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {213, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {214, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {215, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },

  {216, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {217, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {218, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {219, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {220, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {221, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {222, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {223, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {224, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {225, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {226, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {227, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {228, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {229, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {230, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {231, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {232, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTFOUND  },
  {233, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTFOUND  },
  {234, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTFOUND  },
  {235, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTFOUND  },
  {236, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {237, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTFOUND  },
  {238, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTFOUND  },
  {239, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTFOUND  },
  {240, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {241, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {242, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {243, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {244, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {245, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {246, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {247, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {248, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {249, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {250, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {251, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {252, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {253, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {254, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {255, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {256, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_NOTFOUND  },
  {257, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTFOUND  },
  {258, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTFOUND  },
  {259, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTFOUND  },
  {260, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {261, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_NOTFOUND  },
  {262, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_NOTFOUND  },
  {263, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_NOTFOUND  },
  {264, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {265, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {266, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {267, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {268, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {269, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {270, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {271, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {272, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {273, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {274, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {275, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {276, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {277, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_PARAMETERS},
  {278, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_PARAMETERS},
  {279, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_PARAMETERS},
  {280, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,        1, GENDERS_ERR_SUCCESS   },
  {281, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,            1, GENDERS_ERR_SUCCESS   },
  {282, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL,  1, GENDERS_ERR_SUCCESS   },
  {283, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE,  1, GENDERS_ERR_SUCCESS   },
  {284, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_PARAMETERS},
  {285, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_OVERFLOW  },
  {286, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_OVERFLOW  },
  {287, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE,  1, GENDERS_ERR_SUCCESS   },

  {288, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {289, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {290, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {291, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {292, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {293, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {294, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {295, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {296, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {297, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {298, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {299, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {300, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {301, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {302, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {303, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {304, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {305, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {306, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {307, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {308, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {309, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {310, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {311, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {312, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {313, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {314, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {315, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {316, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {317, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {318, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {319, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {320, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {321, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {322, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {323, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {324, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {325, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {326, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {327, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {328, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {329, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {330, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {331, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {332, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {333, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {334, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {335, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {336, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {337, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {338, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {339, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {340, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {341, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {342, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {343, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {344, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {345, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {346, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {347, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {348, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {349, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {350, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {351, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {352, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {353, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {354, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {355, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },
  {356, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       -1, GENDERS_ERR_MAGIC     },
  {357, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           -1, GENDERS_ERR_MAGIC     },
  {358, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, -1, GENDERS_ERR_MAGIC     },
  {359, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, -1, GENDERS_ERR_MAGIC     },

  {-1, -1, -1, -1, -1, -1, -1, -1},
};

genders_testattrval_corner_case_t genders_testattrval_corner_case_tests[] = {
  {0,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {1,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {2,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {3,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {4,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {5,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {6,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {7,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {8,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {9,   GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {10,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {11,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {12,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {13,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {14,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {15,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {16,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {17,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {18,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {19,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {20,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {21,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {22,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {23,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {24,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {25,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {26,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},

  {27,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {28,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {29,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {30,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {31,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {32,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {33,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {34,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {35,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {36,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {37,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {38,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {39,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {40,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {41,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {42,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {43,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {44,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {45,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {46,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {47,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {48,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {49,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {50,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {51,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {52,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {53,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },

  {54,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {55,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {56,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {57,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {58,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {59,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {60,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {61,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {62,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {63,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {64,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {65,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {66,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {67,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {68,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {69,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {70,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {71,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {72,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {73,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {74,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {75,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {76,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {77,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {78,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {79,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {80,  GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },

  {81,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_PARAMETERS},
  {82,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_PARAMETERS},
  {83,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_PARAMETERS},
  {84,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_PARAMETERS},
  {85,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_PARAMETERS},
  {86,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_PARAMETERS},
  {87,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTFOUND  },
  {88,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTFOUND  },
  {89,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTFOUND  },
  {90,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_PARAMETERS},
  {91,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_PARAMETERS},
  {92,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_PARAMETERS},
  {93,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_PARAMETERS},
  {94,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_PARAMETERS},
  {95,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_PARAMETERS},
  {96,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTFOUND  },
  {97,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTFOUND  },
  {98,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTFOUND  },
  {99,  GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_PARAMETERS},
  {100, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_PARAMETERS},
  {101, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_PARAMETERS},
  {102, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_PARAMETERS},
  {103, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_PARAMETERS},
  {104, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_PARAMETERS},
  {105, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,            1, GENDERS_ERR_SUCCESS   },
  {106, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY,  1, GENDERS_ERR_SUCCESS   },
  {107, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,   1, GENDERS_ERR_SUCCESS   },

  {108, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {109, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {110, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {111, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {112, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {113, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {114, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {115, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {116, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {117, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {118, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {119, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {120, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {121, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {122, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {123, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {124, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {125, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {126, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {127, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {128, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {129, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {130, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {131, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {132, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {133, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {134, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },

  {-1, -1, -1, -1, -1, -1, -1},
};

genders_isnode_corner_case_t genders_isnode_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {4,  GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {5,  GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {6,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {7,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {8,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {9,  GENDERS_HANDLE_LOADED,              GENDERS_STRING_NULL,            0, GENDERS_ERR_SUCCESS   },
  {10, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NON_NULL_EMPTY,  0, GENDERS_ERR_SUCCESS   },
  {11, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NON_NULL_FULL,   1, GENDERS_ERR_SUCCESS   },
  {12, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {13, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {14, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_isattr_corner_case_t genders_isattr_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {4,  GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {5,  GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {6,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {7,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {8,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {9,  GENDERS_HANDLE_LOADED,              GENDERS_STRING_NULL,           -1, GENDERS_ERR_PARAMETERS},
  {10, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_PARAMETERS},
  {11, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NON_NULL_FULL,   1, GENDERS_ERR_SUCCESS   },
  {12, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {13, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {14, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_isattrval_corner_case_t genders_isattrval_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {4,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {5,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {6,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {7,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {8,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {9,  GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {10, GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {11, GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {12, GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {13, GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {14, GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {15, GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {16, GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {17, GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {18, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {19, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {20, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {21, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {22, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {23, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {24, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {25, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {26, GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {27, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_PARAMETERS},
  {28, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_PARAMETERS},
  {29, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_PARAMETERS},
  {30, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_PARAMETERS},
  {31, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_PARAMETERS},
  {32, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_PARAMETERS},
  {33, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_PARAMETERS},
  {34, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_PARAMETERS},
  {35, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,   1, GENDERS_ERR_SUCCESS   },
  {36, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {37, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {38, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {39, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {40, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {41, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {42, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {43, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {44, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1, -1},
};

genders_index_attrvals_corner_case_t genders_index_attrvals_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,                GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {4,  GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {5,  GENDERS_HANDLE_UNLOADED,            GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {6,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {7,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {8,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {9,  GENDERS_HANDLE_LOADED,              GENDERS_STRING_NULL,           -1, GENDERS_ERR_PARAMETERS},
  {10, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_PARAMETERS},
  {11, GENDERS_HANDLE_LOADED,              GENDERS_STRING_NON_NULL_FULL,   0, GENDERS_ERR_SUCCESS   },
  {12, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {13, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {14, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_query_corner_case_t genders_query_corner_case_tests[] = {
  {0,   GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {1,   GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {2,   GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {3,   GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {4,   GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {5,   GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {6,   GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {7,   GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {8,   GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {9,   GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {10,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {11,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {12,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {13,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {14,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {15,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {16,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {17,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {18,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {19,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {20,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},
  {21,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NULLHANDLE},
  {22,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NULLHANDLE},
  {23,  GENDERS_HANDLE_NULL,                GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NULLHANDLE},

  {24,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {25,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {26,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {27,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {28,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {29,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {30,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {31,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {32,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {33,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {34,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {35,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {36,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {37,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {38,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {39,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {40,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {41,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {42,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {43,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {44,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },
  {45,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_NOTLOADED },
  {46,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_NOTLOADED },
  {47,  GENDERS_HANDLE_UNLOADED,            GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_NOTLOADED },

  {48,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {49,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {50,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {51,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {52,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {53,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {54,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {55,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {56,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {57,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {58,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {59,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {60,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {61,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {62,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {63,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {64,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {65,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {66,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {67,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {68,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {69,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {70,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {71,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },

  {72,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {73,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {74,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {75,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {76,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_OVERFLOW  },
  {77,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {78,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {79,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {80,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {81,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {82,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {83,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {84,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_PARAMETERS},
  {85,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_PARAMETERS},
  {86,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_PARAMETERS},
  {87,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {88,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_OVERFLOW  },
  {89,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {90,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_OVERFLOW  },
  {91,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_OVERFLOW  },
  {92,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_OVERFLOW  },
  {93,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {94,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },
  {95,  GENDERS_HANDLE_LOADED,              GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  GENDERS_DATABASE_CORNER_CASE_NUMNODES, GENDERS_ERR_SUCCESS   },

  {96,  GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {97,  GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {98,  GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {99,  GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {100, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {101, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {102, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {103, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {104, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {105, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {106, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {107, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NULL,     GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {108, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {109, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {110, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_NEGATIVE,       GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {111, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {112, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {113, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_ZERO,           GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {114, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {115, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {116, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_SMALL, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },
  {117, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NULL,           -1,                                    GENDERS_ERR_MAGIC     },
  {118, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_EMPTY, -1,                                    GENDERS_ERR_MAGIC     },
  {119, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_POINTER_NON_NULL, GENDERS_LENGTH_POSITIVE_LARGE, GENDERS_STRING_NON_NULL_FULL,  -1,                                    GENDERS_ERR_MAGIC     },

  {-1, -1, -1, -1, -1, -1, -1},
};

genders_testquery_corner_case_t genders_testquery_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {4,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {5,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},
  {6,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_NULLHANDLE},
  {7,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NULLHANDLE},
  {8,  GENDERS_HANDLE_NULL,               GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NULLHANDLE},

  {9,  GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {10, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {11, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {12, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {13, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {14, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },
  {15, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_NOTLOADED },
  {16, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_NOTLOADED },
  {17, GENDERS_HANDLE_UNLOADED,           GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTLOADED },

  {18, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {19, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {20, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {21, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {22, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {23, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {24, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {25, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {26, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },

  {27, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_PARAMETERS},
  {28, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_PARAMETERS},
  {29, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTFOUND  },
  {30, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_PARAMETERS},
  {31, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_PARAMETERS},
  {32, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_NOTFOUND  },
  {33, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_PARAMETERS},
  {34, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_PARAMETERS},
  {35, GENDERS_HANDLE_LOADED,             GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,   1, GENDERS_ERR_SUCCESS   },

  {36, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {37, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {38, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NULL,           GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {39, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {40, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {41, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_EMPTY, GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },
  {42, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NULL,           -1, GENDERS_ERR_MAGIC     },
  {43, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_EMPTY, -1, GENDERS_ERR_MAGIC     },
  {44, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_STRING_NON_NULL_FULL,  GENDERS_STRING_NON_NULL_FULL,  -1, GENDERS_ERR_MAGIC     },

  {-1, -1, -1, -1, -1, -1},
};

genders_parse_corner_case_t genders_parse_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NULL,               GENDERS_POINTER_NULL,      -1, GENDERS_ERR_NULLHANDLE},
  {1,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NULL,               GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_NULLHANDLE},
  {2,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_EMPTY,     GENDERS_POINTER_NULL,      -1, GENDERS_ERR_NULLHANDLE},
  {3,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_EMPTY,     GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_NULLHANDLE},
  {4,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NULL,      -1, GENDERS_ERR_NULLHANDLE},
  {5,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_NULLHANDLE},
  {6,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NULL,      -1, GENDERS_ERR_NULLHANDLE},
  {7,  GENDERS_HANDLE_NULL,               GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_NULLHANDLE},
  {8,  GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NULL,               GENDERS_POINTER_NULL,       0, GENDERS_ERR_SUCCESS   },
  {9,  GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NULL,               GENDERS_POINTER_NON_NULL,   0, GENDERS_ERR_SUCCESS   },
  {10, GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_EMPTY,     GENDERS_POINTER_NULL,       0, GENDERS_ERR_SUCCESS   },
  {11, GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_EMPTY,     GENDERS_POINTER_NON_NULL,   0, GENDERS_ERR_SUCCESS   },
  {12, GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NULL,       0, GENDERS_ERR_SUCCESS   },
  {13, GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NON_NULL,   0, GENDERS_ERR_SUCCESS   },
  {14, GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NULL,      -1, GENDERS_ERR_OPEN      },
  {15, GENDERS_HANDLE_UNLOADED,           GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_OPEN      },
  {16, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NULL,               GENDERS_POINTER_NULL,      -1, GENDERS_ERR_MAGIC     },
  {17, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NULL,               GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_MAGIC     },
  {18, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_EMPTY,     GENDERS_POINTER_NULL,      -1, GENDERS_ERR_MAGIC     },
  {19, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_EMPTY,     GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_MAGIC     },
  {20, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NULL,      -1, GENDERS_ERR_MAGIC     },
  {21, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_MAGIC     },
  {22, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NULL,      -1, GENDERS_ERR_MAGIC     },
  {23, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_MAGIC     },
  {24, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NULL,               GENDERS_POINTER_NULL,       0, GENDERS_ERR_SUCCESS   },
  {25, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NULL,               GENDERS_POINTER_NON_NULL,   0, GENDERS_ERR_SUCCESS   },
  {26, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_EMPTY,     GENDERS_POINTER_NULL,       0, GENDERS_ERR_SUCCESS   },
  {27, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_EMPTY,     GENDERS_POINTER_NON_NULL,   0, GENDERS_ERR_SUCCESS   },
  {28, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NULL,       0, GENDERS_ERR_SUCCESS   },
  {29, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NON_NULL,   0, GENDERS_ERR_SUCCESS   },
  {30, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NULL,      -1, GENDERS_ERR_OPEN      },
  {31, GENDERS_HANDLE_LOADED,             GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_OPEN      },
  {32, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NULL,               GENDERS_POINTER_NULL,      -1, GENDERS_ERR_MAGIC     },
  {33, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NULL,               GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_MAGIC     },
  {34, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_EMPTY,     GENDERS_POINTER_NULL,      -1, GENDERS_ERR_MAGIC     },
  {35, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_EMPTY,     GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_MAGIC     },
  {36, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NULL,      -1, GENDERS_ERR_MAGIC     },
  {37, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_EXIST,     GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_MAGIC     },
  {38, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NULL,      -1, GENDERS_ERR_MAGIC     },
  {39, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_FILENAME_NON_NULL_NOT_EXIST, GENDERS_POINTER_NON_NULL,  -1, GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1, -1},
};

genders_set_errnum_corner_case_t genders_set_errnum_corner_case_tests[] = {
  {0,  GENDERS_HANDLE_NULL,                -1,                          GENDERS_ERR_NULLHANDLE     },
  {1,  GENDERS_HANDLE_NULL,                GENDERS_ERR_SUCCESS,         GENDERS_ERR_NULLHANDLE     },
  {2,  GENDERS_HANDLE_NULL,                GENDERS_ERR_ERRNUMRANGE + 1, GENDERS_ERR_NULLHANDLE     },
  {3,  GENDERS_HANDLE_UNLOADED,            -1,                          -1                         },
  {4,  GENDERS_HANDLE_UNLOADED,            GENDERS_ERR_SUCCESS,         GENDERS_ERR_SUCCESS        },
  {5,  GENDERS_HANDLE_UNLOADED,            GENDERS_ERR_ERRNUMRANGE + 1, GENDERS_ERR_ERRNUMRANGE + 1},
  {6,  GENDERS_HANDLE_UNLOADED_DESTROYED,  -1,                          GENDERS_ERR_MAGIC          },
  {7,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_ERR_SUCCESS,         GENDERS_ERR_MAGIC          },
  {8,  GENDERS_HANDLE_UNLOADED_DESTROYED,  GENDERS_ERR_ERRNUMRANGE + 1, GENDERS_ERR_MAGIC          },
  {9,  GENDERS_HANDLE_LOADED,              -1,                          -1                         },
  {10, GENDERS_HANDLE_LOADED,              GENDERS_ERR_SUCCESS,         GENDERS_ERR_SUCCESS        },
  {11, GENDERS_HANDLE_LOADED,              GENDERS_ERR_ERRNUMRANGE + 1, GENDERS_ERR_ERRNUMRANGE + 1},
  {12, GENDERS_HANDLE_LOADED_DESTROYED,    -1,                          GENDERS_ERR_MAGIC          },
  {13, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_ERR_SUCCESS,         GENDERS_ERR_MAGIC          },
  {14, GENDERS_HANDLE_LOADED_DESTROYED,    GENDERS_ERR_ERRNUMRANGE + 1, GENDERS_ERR_MAGIC          },
  {-1, -1, -1, -1},
};

genders_copy_corner_case_t genders_copy_corner_case_tests[] = {
  {0, GENDERS_HANDLE_NULL,               GENDERS_POINTER_NULL,     GENDERS_ERR_NULLHANDLE},
  {1, GENDERS_HANDLE_UNLOADED,           GENDERS_POINTER_NULL,     GENDERS_ERR_NOTLOADED },
  {2, GENDERS_HANDLE_UNLOADED_DESTROYED, GENDERS_POINTER_NULL,     GENDERS_ERR_MAGIC     },
  {3, GENDERS_HANDLE_LOADED,             GENDERS_POINTER_NON_NULL, GENDERS_ERR_SUCCESS   },
  {4, GENDERS_HANDLE_LOADED_DESTROYED,   GENDERS_POINTER_NULL,     GENDERS_ERR_MAGIC     },
  {-1, -1, -1, -1},
};
