# :pizza: Hacktoberfest 2019 :beer:

It's that time of the year again!
[Hacktoberfest](https://hacktoberfest.digitalocean.com) is here, and `gensim` needs **your** help.
We've prepared a list of good issues to work on: [gensim hacktoberfest issues](https://github.com/RaRe-Technologies/gensim/labels/hacktoberfest).

If the learning curve for `gensim` is a bit steep, give the [smart_open](https://github.com/RaRe-Technologies/smart_open) repository a try.
`smart_open` is an important dependency of `gensim`: it performs file I/O over a variety of protocols and formats.
There's also a list of Hacktoberfest-friendly issues to work on: [smart_open hacktoberfest issues](https://github.com/RaRe-Technologies/smart_open/labels/hacktoberfest).

Of course, we welcome contributions on any of the existing issues, not just the ones labeled `hacktoberfest`.
If the issue is simple & quick, you can just submit your PR, with a proper reference to the issue it addresses.
If the issue requires a little more work, but you have a good idea of how to proceed & know when you'll be submitting some initial work, please post a short note about your plans to the issue, or a "work-in-progress" ("[WIP]") pull-request indicating work is underway, to help avoid wasted duplicate work.

Furthermore, we also welcome contributions not connected to an existing issue.
This includes things like fixing typos in documentation, docstrings, etc.
If you make such contributions, please make the motivation behind the contribution clear.
You could start such a contribution with a new pull-request, or if you think it requires other discussion beforehand, as a separate new issue.
Please avoid making innocuous changes without sufficient motivation (e.g. changing code formatting, etc).

## Before Contributing

Check out the following:

- [First-time contributors guide](https://github.com/firstcontributions/first-contributions): if this is your first time contributing on GitHub.
- [Hacktoberfest rules](https://hacktoberfest.digitalocean.com/faq#rules): read this in full
- [Developer page](https://github.com/RaRe-Technologies/gensim/wiki/Developer-page) on our Wiki: for the git flow, code style, etc.

## Questions

If you have a general question about Gensim, please ask on the [mailing list](https://groups.google.com/g/gensim).
If you have a question a about a specific issue or PR, just ask there directly, and we'll get back to you as soon as we can.
Otherwise, ping @mpenkov on [Twitter](https://twitter.com/mpenkov) or [Telegram](https://t.me/mpenkov).

Happy Hacking!!
