/*******************************************************************************
  author       : Bernd Wichern
  filename     : ghmm/tools/cluster.c
  created      : DATE: March 2001 by Achim Gaedke from hmm/src/cluster.c
  $Id: cluster.c 2267 2009-04-24 15:01:58Z grunau $
*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include "../config.h"
#endif

#include <stdio.h>
#include <ghmm/mes.h>
#include <ghmm/rng.h>
#include <ghmm/cluster.h>

int main(int argc, char* argv[]) {
#define CUR_PROC "main"

#ifdef GHMM_OBSOLETE
  int exitcode = -1;
  if (argc == 4 || argc == 5) {
    if (argc == 5) {
      int j;
      GHMM_RNG_SET(RNG,atoi(argv[4]));
      for (j = 0; j < 100; j++)
	printf("%d \n", m_int(GHMM_RNG_UNIFORM(RNG) * 10));
      exit(1);
    }
    else
      GHMM_RNG_SET(RNG,0);
    exitcode = ghmm_cluster_hmm(argv[1], argv[2], argv[3]);
  }
  else {
    GHMM_LOG(LCONVERTED, "Insufficient arguments. \
        Usage: cluster [sequence file][model file][outfile] <seed>\n"); 
  }
  return exitcode;

#else  /* GHMM_OBSOLETE */
  fprintf (stderr, "cluster is obsolete. If you need it rebuild the GHMM with \"GHMM_OBSOLETE\".\n");
  return 0;
#endif /* GHMM_OBSOLETE */
  
# undef CUR_PROC
} /* main */
