/* ----------------------------------------------------------------------
 * p_plug_in_apply_canvas_iter_ALT 
 * ----------------------------------------------------------------------
 */
gint p_plug_in_apply_canvas_iter_ALT(GimpRunMode run_mode, gint32 total_steps, gdouble current_step, gint32 len_struct) 
{
    typedef struct t_plug_in_apply_canvas_Vals 
    {
      gint      direction;
      gint      depth;
     } t_plug_in_apply_canvas_Vals; 

    t_plug_in_apply_canvas_Vals  buf, *buf_from, *buf_to; 

    if(len_struct != sizeof(t_plug_in_apply_canvas_Vals)) 
    {
      fprintf(stderr, "ERROR: p_plug_in_apply_canvas_iter_ALT  stored Data missmatch in size %d != %d\n",   
                       (int)len_struct, sizeof(t_plug_in_apply_canvas_Vals) ); 
      return -1;  /* ERROR */ 
    }


    gimp_get_data("plug-in-apply-canvas-ITER-FROM", g_plugin_data_from); 
    gimp_get_data("plug-in-apply-canvas-ITER-TO",   g_plugin_data_to); 

    buf_from = (t_plug_in_apply_canvas_Vals *)&g_plugin_data_from[0]; 
    buf_to   = (t_plug_in_apply_canvas_Vals *)&g_plugin_data_to[0]; 
    memcpy(&buf, buf_from, sizeof(buf));

    p_delta_gint(&buf.direction, buf_from->direction, buf_to->direction, total_steps, current_step);
    p_delta_gint(&buf.depth, buf_from->depth, buf_to->depth, total_steps, current_step);

    gimp_set_data("plug-in-apply-canvas", &buf, sizeof(buf)); 
    return 0; /* OK */
}
