#!/bin/sh
## This script creates a config.h file containing preprocessor directives.
## The directives are passend on the commandline, seperated by colons.
## The file printed to stdout.
##

## Create the config.h file to be included in all files.
## Returns 0 on success, 1 otherwise.
##
gen_config_h() {
  MACROS="$@"
  echo "/* This file is automatically generated and will be overwritten */"
  echo "/* during the installation process. */"
  OLDIFS=$IFS
  IFS=':'
  for LINE in $MACROS; do
    MACRO=`echo $LINE | cut -d'=' -f1`
    VALUE=`echo $LINE | cut -d'=' -f2-`
    echo "#define $MACRO \"$VALUE\""
  done
  IFS=$OLDIFS
  return 0
}

gen_config_h $@

exit 0
