//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhanaonazure

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ProviderInstancesClient contains the methods for the ProviderInstances group.
// Don't use this type directly, use NewProviderInstancesClient() instead.
type ProviderInstancesClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewProviderInstancesClient creates a new instance of ProviderInstancesClient with the specified values.
// subscriptionID - Subscription ID which uniquely identify Microsoft Azure subscription. The subscription ID forms part of
// the URI for every service call.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewProviderInstancesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ProviderInstancesClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ProviderInstancesClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreate - Creates a provider instance for the specified subscription, resource group, SapMonitor name, and resource
// name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-02-07-preview
// resourceGroupName - Name of the resource group.
// sapMonitorName - Name of the SAP monitor resource.
// providerInstanceName - Name of the provider instance.
// providerInstanceParameter - Request body representing a provider instance
// options - ProviderInstancesClientBeginCreateOptions contains the optional parameters for the ProviderInstancesClient.BeginCreate
// method.
func (client *ProviderInstancesClient) BeginCreate(ctx context.Context, resourceGroupName string, sapMonitorName string, providerInstanceName string, providerInstanceParameter ProviderInstance, options *ProviderInstancesClientBeginCreateOptions) (*runtime.Poller[ProviderInstancesClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, sapMonitorName, providerInstanceName, providerInstanceParameter, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ProviderInstancesClientCreateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ProviderInstancesClientCreateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Create - Creates a provider instance for the specified subscription, resource group, SapMonitor name, and resource name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-02-07-preview
func (client *ProviderInstancesClient) create(ctx context.Context, resourceGroupName string, sapMonitorName string, providerInstanceName string, providerInstanceParameter ProviderInstance, options *ProviderInstancesClientBeginCreateOptions) (*http.Response, error) {
	req, err := client.createCreateRequest(ctx, resourceGroupName, sapMonitorName, providerInstanceName, providerInstanceParameter, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createCreateRequest creates the Create request.
func (client *ProviderInstancesClient) createCreateRequest(ctx context.Context, resourceGroupName string, sapMonitorName string, providerInstanceName string, providerInstanceParameter ProviderInstance, options *ProviderInstancesClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HanaOnAzure/sapMonitors/{sapMonitorName}/providerInstances/{providerInstanceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapMonitorName == "" {
		return nil, errors.New("parameter sapMonitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapMonitorName}", url.PathEscape(sapMonitorName))
	if providerInstanceName == "" {
		return nil, errors.New("parameter providerInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerInstanceName}", url.PathEscape(providerInstanceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-02-07-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, providerInstanceParameter)
}

// BeginDelete - Deletes a provider instance for the specified subscription, resource group, SapMonitor name, and resource
// name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-02-07-preview
// resourceGroupName - Name of the resource group.
// sapMonitorName - Name of the SAP monitor resource.
// providerInstanceName - Name of the provider instance.
// options - ProviderInstancesClientBeginDeleteOptions contains the optional parameters for the ProviderInstancesClient.BeginDelete
// method.
func (client *ProviderInstancesClient) BeginDelete(ctx context.Context, resourceGroupName string, sapMonitorName string, providerInstanceName string, options *ProviderInstancesClientBeginDeleteOptions) (*runtime.Poller[ProviderInstancesClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, sapMonitorName, providerInstanceName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ProviderInstancesClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ProviderInstancesClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes a provider instance for the specified subscription, resource group, SapMonitor name, and resource name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-02-07-preview
func (client *ProviderInstancesClient) deleteOperation(ctx context.Context, resourceGroupName string, sapMonitorName string, providerInstanceName string, options *ProviderInstancesClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, sapMonitorName, providerInstanceName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ProviderInstancesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, sapMonitorName string, providerInstanceName string, options *ProviderInstancesClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HanaOnAzure/sapMonitors/{sapMonitorName}/providerInstances/{providerInstanceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapMonitorName == "" {
		return nil, errors.New("parameter sapMonitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapMonitorName}", url.PathEscape(sapMonitorName))
	if providerInstanceName == "" {
		return nil, errors.New("parameter providerInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerInstanceName}", url.PathEscape(providerInstanceName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-02-07-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets properties of a provider instance for the specified subscription, resource group, SapMonitor name, and resource
// name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-02-07-preview
// resourceGroupName - Name of the resource group.
// sapMonitorName - Name of the SAP monitor resource.
// providerInstanceName - Name of the provider instance.
// options - ProviderInstancesClientGetOptions contains the optional parameters for the ProviderInstancesClient.Get method.
func (client *ProviderInstancesClient) Get(ctx context.Context, resourceGroupName string, sapMonitorName string, providerInstanceName string, options *ProviderInstancesClientGetOptions) (ProviderInstancesClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, sapMonitorName, providerInstanceName, options)
	if err != nil {
		return ProviderInstancesClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ProviderInstancesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ProviderInstancesClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ProviderInstancesClient) getCreateRequest(ctx context.Context, resourceGroupName string, sapMonitorName string, providerInstanceName string, options *ProviderInstancesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HanaOnAzure/sapMonitors/{sapMonitorName}/providerInstances/{providerInstanceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapMonitorName == "" {
		return nil, errors.New("parameter sapMonitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapMonitorName}", url.PathEscape(sapMonitorName))
	if providerInstanceName == "" {
		return nil, errors.New("parameter providerInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerInstanceName}", url.PathEscape(providerInstanceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-02-07-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ProviderInstancesClient) getHandleResponse(resp *http.Response) (ProviderInstancesClientGetResponse, error) {
	result := ProviderInstancesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProviderInstance); err != nil {
		return ProviderInstancesClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Gets a list of provider instances in the specified SAP monitor. The operations returns various properties
// of each provider instances.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-02-07-preview
// resourceGroupName - Name of the resource group.
// sapMonitorName - Name of the SAP monitor resource.
// options - ProviderInstancesClientListOptions contains the optional parameters for the ProviderInstancesClient.List method.
func (client *ProviderInstancesClient) NewListPager(resourceGroupName string, sapMonitorName string, options *ProviderInstancesClientListOptions) *runtime.Pager[ProviderInstancesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ProviderInstancesClientListResponse]{
		More: func(page ProviderInstancesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ProviderInstancesClientListResponse) (ProviderInstancesClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, resourceGroupName, sapMonitorName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ProviderInstancesClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ProviderInstancesClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ProviderInstancesClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *ProviderInstancesClient) listCreateRequest(ctx context.Context, resourceGroupName string, sapMonitorName string, options *ProviderInstancesClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HanaOnAzure/sapMonitors/{sapMonitorName}/providerInstances"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapMonitorName == "" {
		return nil, errors.New("parameter sapMonitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapMonitorName}", url.PathEscape(sapMonitorName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-02-07-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ProviderInstancesClient) listHandleResponse(resp *http.Response) (ProviderInstancesClientListResponse, error) {
	result := ProviderInstancesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProviderInstanceListResult); err != nil {
		return ProviderInstancesClientListResponse{}, err
	}
	return result, nil
}
